/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Mon Jan 25 12:52:11 2021

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_46 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 9359, "epsg", 9359,
        "KSA-GRF17 / UTM zone 39N", 0, 0,
        "GRS 1980", "Greenwich",
        "Kingdom_of_Saudi_Arabia_Geodetic_Reference_Frame_2017", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=GRS80 +towgs84=0,0,0,-0.008393");
    add_proj4text (p, 1,
        ",0.000749,-0.010276,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"KSA-GRF17 / UTM zone 39N\",GEOGCS[\"KSA-GRF17\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Kingdom_of_Saudi_Arabia_Geodetic_Reference_Fram");
    add_srs_wkt (p, 2,
        "e_2017\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1268\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"9333\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",51],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"9359\"]]");
    p = add_epsg_def_ex (filter, first, last, 9360, "epsg", 9360,
        "KSA-GRF17 / UTM zone 40N", 0, 0,
        "GRS 1980", "Greenwich",
        "Kingdom_of_Saudi_Arabia_Geodetic_Reference_Frame_2017", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=GRS80 +towgs84=0,0,0,-0.008393");
    add_proj4text (p, 1,
        ",0.000749,-0.010276,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"KSA-GRF17 / UTM zone 40N\",GEOGCS[\"KSA-GRF17\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Kingdom_of_Saudi_Arabia_Geodetic_Reference_Fram");
    add_srs_wkt (p, 2,
        "e_2017\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1268\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"9333\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",57],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 12,
        "ORTH],AUTHORITY[\"EPSG\",\"9360\"]]");
    p = add_epsg_def_ex (filter, first, last, 9364, "epsg", 9364,
        "TPEN11-IRF", 1, 1,
        "GRS 1980", "Greenwich",
        "TPEN11_Intermediate_Reference_Frame", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"TPEN11-IRF\",DATUM[\"TPEN11_Intermediate_Refere");
    add_srs_wkt (p, 1,
        "nce_Frame\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1266\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 6,
        "T],AUTHORITY[\"EPSG\",\"9364\"]]");
    p = add_epsg_def_ex (filter, first, last, 9367, "epsg", 9367,
        "TPEN11 Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "TPEN11_Intermediate_Reference_Frame", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=53.5 +lon_0=-2.25 +k=1 +x_0=203252.17");
    add_proj4text (p, 1,
        "5 +y_0=407512.765 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TPEN11 Grid\",GEOGCS[\"TPEN11-IRF\",DATUM[\"TPE");
    add_srs_wkt (p, 1,
        "N11_Intermediate_Reference_Frame\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1266\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"93");
    add_srs_wkt (p, 6,
        "64\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",53.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-2.25],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",203252.175],PARAMETER[\"false_northing\",40751");
    add_srs_wkt (p, 10,
        "2.765],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9367\"]]");
    p = add_epsg_def_ex (filter, first, last, 9368, "epsg", 9368,
        "TPEN11 Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "TPEN11_Intermediate_Reference_Frame", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=53.5 +lon_0=-2.25 +k=1 +x_0=203252.17");
    add_proj4text (p, 1,
        "5 +y_0=407512.765 +ellps=GRS80 +units=m +geoidgrids=uk_o");
    add_proj4text (p, 2,
        "s_OSGM15_GB.tif +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"TPEN11 Grid + ODN height\",PROJCS[\"TPEN11 Gr");
    add_srs_wkt (p, 1,
        "id\",GEOGCS[\"TPEN11-IRF\",DATUM[\"TPEN11_Intermediate_R");
    add_srs_wkt (p, 2,
        "eference_Frame\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1266\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"9364\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",53.5],PARAMETER[\"central_meridian\",-2.25],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1],PARAMETER[\"false_easting\",203252.175");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",407512.765],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"9367\"]],V");
    add_srs_wkt (p, 13,
        "ERT_CS[\"ODN height\",VERT_DATUM[\"Ordnance Datum Newlyn");
    add_srs_wkt (p, 14,
        "\",2005,AUTHORITY[\"EPSG\",\"5101\"]],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 15,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related heig");
    add_srs_wkt (p, 16,
        "ht\",UP],AUTHORITY[\"EPSG\",\"5701\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9368\"]]");
    p = add_epsg_def_ex (filter, first, last, 9372, "epsg", 9372,
        "MML07-IRF", 1, 1,
        "GRS 1980", "Greenwich",
        "MML07_Intermediate_Reference_Frame", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"MML07-IRF\",DATUM[\"MML07_Intermediate_Referenc");
    add_srs_wkt (p, 1,
        "e_Frame\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 2,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1271\"]");
    add_srs_wkt (p, 3,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 4,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 5,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"9372\"]]");
    p = add_epsg_def_ex (filter, first, last, 9373, "epsg", 9373,
        "MML07 Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "MML07_Intermediate_Reference_Frame", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=52.45 +lon_0=-0.85 +k=1 +x_0=49350.15");
    add_proj4text (p, 1,
        "7 +y_0=108398.212 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MML07 Grid\",GEOGCS[\"MML07-IRF\",DATUM[\"MML07");
    add_srs_wkt (p, 1,
        "_Intermediate_Reference_Frame\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1271\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"9372\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",52.45],PARAMETER[\"central_meridian\",-0");
    add_srs_wkt (p, 8,
        ".85],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",49350.157],PARAMETER[\"false_northing\",108398.21");
    add_srs_wkt (p, 10,
        "2],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9373\"]]");
    p = add_epsg_def_ex (filter, first, last, 9374, "epsg", 9374,
        "MML07 Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "MML07_Intermediate_Reference_Frame", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=52.45 +lon_0=-0.85 +k=1 +x_0=49350.15");
    add_proj4text (p, 1,
        "7 +y_0=108398.212 +ellps=GRS80 +units=m +geoidgrids=uk_o");
    add_proj4text (p, 2,
        "s_OSGM15_GB.tif +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"MML07 Grid + ODN height\",PROJCS[\"MML07 Grid");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"MML07-IRF\",DATUM[\"MML07_Intermediate_Refer");
    add_srs_wkt (p, 2,
        "ence_Frame\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1271");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"9372\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",52");
    add_srs_wkt (p, 8,
        ".45],PARAMETER[\"central_meridian\",-0.85],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",1],PARAMETER[\"false_easting\",49350.157],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",108398.212],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"9373\"]],VE");
    add_srs_wkt (p, 13,
        "RT_CS[\"ODN height\",VERT_DATUM[\"Ordnance Datum Newlyn\"");
    add_srs_wkt (p, 14,
        ",2005,AUTHORITY[\"EPSG\",\"5101\"]],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height");
    add_srs_wkt (p, 16,
        "\",UP],AUTHORITY[\"EPSG\",\"5701\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 17,
        "\"9374\"]]");
    p = add_epsg_def_ex (filter, first, last, 9377, "epsg", 9377,
        "MAGNA-SIRGAS / Origen-Nacional", 0, 1,
        "GRS 1980", "Greenwich",
        "Marco_Geocentrico_Nacional_de_Referencia", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4 +lon_0=-73 +k=0.9992 +x_0=5000000 +");
    add_proj4text (p, 1,
        "y_0=2000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MAGNA-SIRGAS / Origen-Nacional\",GEOGCS[\"MAGNA");
    add_srs_wkt (p, 1,
        "-SIRGAS\",DATUM[\"Marco_Geocentrico_Nacional_de_Referenc");
    add_srs_wkt (p, 2,
        "ia\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6686\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4686\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",4],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",-73],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9992],PARAMETER[\"false_easting\",5000000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",2000000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AUTHORITY[\"EPSG\",\"9377\"]]");
    p = add_epsg_def_ex (filter, first, last, 9379, "epsg", 9379,
        "IGb14", 1, 1,
        "GRS 1980", "Greenwich",
        "IGb14", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"IGb14\",DYNAMIC[FRAMEEPOCH[2010]],DATUM[\"IGb1");
    add_srs_wkt (p, 1,
        "4\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGTHU");
    add_srs_wkt (p, 2,
        "NIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"de");
    add_srs_wkt (p, 3,
        "gree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geo");
    add_srs_wkt (p, 4,
        "detic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon)\"");
    add_srs_wkt (p, 6,
        ",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]]");
    add_srs_wkt (p, 7,
        ",AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[");
    add_srs_wkt (p, 8,
        "\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"World.\"]");
    add_srs_wkt (p, 9,
        ",BBOX[-90,-180,90,180]],ID[\"EPSG\",9379]]");
    p = add_epsg_def_ex (filter, first, last, 9380, "epsg", 9380,
        "IGb14", 1, 1,
        "GRS 1980", "Greenwich",
        "IGb14", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGb14\",DATUM[\"IGb14\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 1,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"1272\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 5,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"9380\"]]");
    p = add_epsg_def_ex (filter, first, last, 9384, "epsg", 9384,
        "AbInvA96_2020-IRF", 1, 1,
        "GRS 1980", "Greenwich",
        "AbInvA96_2020_Intermediate_Reference_Frame", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"AbInvA96_2020-IRF\",DATUM[\"AbInvA96_2020_Inter");
    add_srs_wkt (p, 1,
        "mediate_Reference_Frame\",SPHEROID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 2,
        "298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1273\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 6,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"9384\"]]");
    p = add_epsg_def_ex (filter, first, last, 9387, "epsg", 9387,
        "AbInvA96_2020 Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "AbInvA96_2020_Intermediate_Reference_Frame", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=57.4 +lon_0=-3.2 +k=1 +x_0=155828.702");
    add_proj4text (p, 1,
        " +y_0=115225.707 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AbInvA96_2020 Grid\",GEOGCS[\"AbInvA96_2020-IRF");
    add_srs_wkt (p, 1,
        "\",DATUM[\"AbInvA96_2020_Intermediate_Reference_Frame\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1273\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9384\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",57.4],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",-3.2],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",155828.702],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",115225.707],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"9387\"]]");
    p = add_epsg_def_ex (filter, first, last, 9388, "epsg", 9388,
        "AbInvA96_2020 Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "AbInvA96_2020_Intermediate_Reference_Frame", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=57.4 +lon_0=-3.2 +k=1 +x_0=155828.702");
    add_proj4text (p, 1,
        " +y_0=115225.707 +ellps=GRS80 +units=m +geoidgrids=uk_os");
    add_proj4text (p, 2,
        "_OSGM15_GB.tif +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"AbInvA96_2020 Grid + ODN height\",PROJCS[\"Ab");
    add_srs_wkt (p, 1,
        "InvA96_2020 Grid\",GEOGCS[\"AbInvA96_2020-IRF\",DATUM[\"");
    add_srs_wkt (p, 2,
        "AbInvA96_2020_Intermediate_Reference_Frame\",SPHEROID[\"");
    add_srs_wkt (p, 3,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 4,
        "19\"]],AUTHORITY[\"EPSG\",\"1273\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"9384\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",57.4],PARAMETER[\"central_m");
    add_srs_wkt (p, 9,
        "eridian\",-3.2],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",155828.702],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",115225.707],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"9387\"]],VERT_CS[\"ODN height\",VERT_");
    add_srs_wkt (p, 14,
        "DATUM[\"Ordnance Datum Newlyn\",2005,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 15,
        "\"5101\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 16,
        "],AXIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"5701\"]],AUTHORITY[\"EPSG\",\"9388\"]]");
    p = add_epsg_def_ex (filter, first, last, 9391, "epsg", 9391,
        "BGS2005 / UTM zone 35N", 0, 0,
        "GRS 1980", "Greenwich",
        "Bulgaria_Geodetic_System_2005", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"BGS2005 / UTM zone 35N\",GEOGCS[\"BGS2005\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Bulgaria_Geodetic_System_2005\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1167\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "7798\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"939");
    add_srs_wkt (p, 12,
        "1\"]]");
    p = add_epsg_def_ex (filter, first, last, 9403, "epsg", 9403,
        "PN68", 1, 1,
        "International 1924", "Greenwich",
        "Pico_de_las_Nieves_1968", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=intl +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"PN68\",DATUM[\"Pico_de_las_Nieves_1968\",SPHERO");
    add_srs_wkt (p, 1,
        "ID[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7022\"]],AUTHORITY[\"EPSG\",\"1286\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 3,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 4,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 5,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"9403\"]]");
    p = add_epsg_def_ex (filter, first, last, 9404, "epsg", 9404,
        "PN68 / UTM zone 27N", 0, 0,
        "International 1924", "Greenwich",
        "Pico_de_las_Nieves_1968", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=27 +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PN68 / UTM zone 27N\",GEOGCS[\"PN68\",DATUM[\"P");
    add_srs_wkt (p, 1,
        "ico_de_las_Nieves_1968\",SPHEROID[\"International 1924\"");
    add_srs_wkt (p, 2,
        ",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1286\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"9403\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",0],PARAMETER[\"central_meridian\",-21],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 9,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 10,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 11,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"9404\"]]");
    p = add_epsg_def_ex (filter, first, last, 9405, "epsg", 9405,
        "PN68 / UTM zone 28N", 0, 0,
        "International 1924", "Greenwich",
        "Pico_de_las_Nieves_1968", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PN68 / UTM zone 28N\",GEOGCS[\"PN68\",DATUM[\"P");
    add_srs_wkt (p, 1,
        "ico_de_las_Nieves_1968\",SPHEROID[\"International 1924\"");
    add_srs_wkt (p, 2,
        ",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"1286\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"9403\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",0],PARAMETER[\"central_meridian\",-15],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 9,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 10,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 11,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"9405\"]]");
    p = add_epsg_def_ex (filter, first, last, 9406, "epsg", 9406,
        "PN84 / UTM zone 27N", 0, 0,
        "International 1924", "Greenwich",
        "Pico_de_las_Nieves_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=27 +ellps=intl +towgs84=-307,-92,127,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PN84 / UTM zone 27N\",GEOGCS[\"PN84\",DATUM[\"P");
    add_srs_wkt (p, 1,
        "ico_de_las_Nieves_1984\",SPHEROID[\"International 1924\"");
    add_srs_wkt (p, 2,
        ",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6728\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4728\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",0],PARAMETER[\"central_meridian\",-21],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 9,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 10,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 11,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"9406\"]]");
    p = add_epsg_def_ex (filter, first, last, 9407, "epsg", 9407,
        "PN84 / UTM zone 28N", 0, 0,
        "International 1924", "Greenwich",
        "Pico_de_las_Nieves_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +ellps=intl +towgs84=-307,-92,127,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PN84 / UTM zone 28N\",GEOGCS[\"PN84\",DATUM[\"P");
    add_srs_wkt (p, 1,
        "ico_de_las_Nieves_1984\",SPHEROID[\"International 1924\"");
    add_srs_wkt (p, 2,
        ",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6728\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4728\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",0],PARAMETER[\"central_meridian\",-15],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 9,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 10,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 11,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"9407\"]]");
    p = add_epsg_def_ex (filter, first, last, 9422, "epsg", 9422,
        "ETRS89", 1, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +vunit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 + EVRF2019 height\",GEOGCS[\"ETRS89\",");
    add_srs_wkt (p, 1,
        "DATUM[\"European_Terrestrial_Reference_System_1989\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4258\"]],VERT_CS[\"EVRF2019 height\",VERT_DATUM[");
    add_srs_wkt (p, 8,
        "\"European Vertical Reference Frame 2019\",2005,AUTHORIT");
    add_srs_wkt (p, 9,
        "Y[\"EPSG\",\"1274\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 10,
        ",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9389\"]],AUTHORITY[\"EPSG\",\"9422\"]]");
    p = add_epsg_def_ex (filter, first, last, 9423, "epsg", 9423,
        "ETRS89", 1, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +vunit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 + EVRF2019 mean-tide height\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "ETRS89\",DATUM[\"European_Terrestrial_Reference_System_1");
    add_srs_wkt (p, 2,
        "989\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4258\"]],VERT_CS[\"EVRF2019 mean-tide ");
    add_srs_wkt (p, 8,
        "height\",VERT_DATUM[\"European Vertical Reference Frame ");
    add_srs_wkt (p, 9,
        "2019 mean tide\",2005,AUTHORITY[\"EPSG\",\"1287\"]],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravit");
    add_srs_wkt (p, 11,
        "y-related height\",UP],AUTHORITY[\"EPSG\",\"9390\"]],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9423\"]]");
    p = add_epsg_def_ex (filter, first, last, 9424, "epsg", 9424,
        "ETRS89", 1, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +geoid");
    add_proj4text (p, 1,
        "grids=uk_os_OSGM15_GB.tif +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 + ODN height\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 1,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 6,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4258\"]],VERT_CS[\"ODN height\",VERT_DATUM[\"Ordnance");
    add_srs_wkt (p, 8,
        " Datum Newlyn\",2005,AUTHORITY[\"EPSG\",\"5101\"]],UNIT[");
    add_srs_wkt (p, 9,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity");
    add_srs_wkt (p, 10,
        "-related height\",UP],AUTHORITY[\"EPSG\",\"5701\"]],AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9424\"]]");
    p = add_epsg_def_ex (filter, first, last, 9425, "epsg", 9425,
        "ETRS89", 1, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +geoid");
    add_proj4text (p, 1,
        "grids=uk_os_OSGM15_GB.tif +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 + ODN (Offshore) height\",GEOGCS[\"ETR");
    add_srs_wkt (p, 1,
        "S89\",DATUM[\"European_Terrestrial_Reference_System_1989");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"4258\"]],VERT_CS[\"ODN (Offshore) height");
    add_srs_wkt (p, 8,
        "\",VERT_DATUM[\"Ordnance Datum Newlyn (Offshore)\",2005,");
    add_srs_wkt (p, 9,
        "AUTHORITY[\"EPSG\",\"1164\"]],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP]");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"7707\"]],AUTHORITY[\"EPSG\",\"9425");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 9426, "epsg", 9426,
        "ETRS89", 1, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +geoid");
    add_proj4text (p, 1,
        "grids=uk_os_OSGM15_GB.tif +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 + ODN Orkney height\",GEOGCS[\"ETRS89\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"European_Terrestrial_Reference_System_1989\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4258\"]],VERT_CS[\"ODN Orkney height\",VERT_D");
    add_srs_wkt (p, 8,
        "ATUM[\"Ordnance Datum Newlyn (Orkney Isles)\",2005,AUTHO");
    add_srs_wkt (p, 9,
        "RITY[\"EPSG\",\"5138\"]],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 10,
        "SG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"5740\"]],AUTHORITY[\"EPSG\",\"9426\"]]");
    p = add_epsg_def_ex (filter, first, last, 9427, "epsg", 9427,
        "ETRS89", 1, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +geoid");
    add_proj4text (p, 1,
        "grids=uk_os_OSGM15_GB.tif +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 + Lerwick height\",GEOGCS[\"ETRS89\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"European_Terrestrial_Reference_System_1989\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4258\"]],VERT_CS[\"Lerwick height\",VERT_DATUM[\"");
    add_srs_wkt (p, 8,
        "Lerwick\",2005,AUTHORITY[\"EPSG\",\"5140\"]],UNIT[\"metr");
    add_srs_wkt (p, 9,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-relat");
    add_srs_wkt (p, 10,
        "ed height\",UP],AUTHORITY[\"EPSG\",\"5742\"]],AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9427\"]]");
    p = add_epsg_def_ex (filter, first, last, 9428, "epsg", 9428,
        "ETRS89", 1, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +geoid");
    add_proj4text (p, 1,
        "grids=uk_os_OSGM15_GB.tif +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 + Stornoway height\",GEOGCS[\"ETRS89\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"European_Terrestrial_Reference_System_1989\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4258\"]],VERT_CS[\"Stornoway height\",VERT_DA");
    add_srs_wkt (p, 8,
        "TUM[\"Stornoway\",2005,AUTHORITY[\"EPSG\",\"5144\"]],UNI");
    add_srs_wkt (p, 9,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 10,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"5746\"]],AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9428\"]]");
    p = add_epsg_def_ex (filter, first, last, 9429, "epsg", 9429,
        "ETRS89", 1, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +geoid");
    add_proj4text (p, 1,
        "grids=uk_os_OSGM15_GB.tif +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 + Douglas height\",GEOGCS[\"ETRS89\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"European_Terrestrial_Reference_System_1989\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4258\"]],VERT_CS[\"Douglas height\",VERT_DATUM[\"");
    add_srs_wkt (p, 8,
        "Douglas\",2005,AUTHORITY[\"EPSG\",\"5148\"]],UNIT[\"metr");
    add_srs_wkt (p, 9,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-relat");
    add_srs_wkt (p, 10,
        "ed height\",UP],AUTHORITY[\"EPSG\",\"5750\"]],AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9429\"]]");
    p = add_epsg_def_ex (filter, first, last, 9430, "epsg", 9430,
        "ETRS89", 1, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +geoid");
    add_proj4text (p, 1,
        "grids=uk_os_OSGM15_GB.tif +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 + St. Marys height\",GEOGCS[\"ETRS89\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"European_Terrestrial_Reference_System_1989\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4258\"]],VERT_CS[\"St. Marys height\",VERT_DA");
    add_srs_wkt (p, 8,
        "TUM[\"St. Marys\",2005,AUTHORITY[\"EPSG\",\"5147\"]],UNI");
    add_srs_wkt (p, 9,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravi");
    add_srs_wkt (p, 10,
        "ty-related height\",UP],AUTHORITY[\"EPSG\",\"5749\"]],AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9430\"]]");
    p = add_epsg_def_ex (filter, first, last, 9449, "epsg", 9449,
        "ETRS89", 1, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +geoid");
    add_proj4text (p, 1,
        "grids=uk_os_OSGM15_Malin.tif +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 + Malin Head height\",GEOGCS[\"ETRS89\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"European_Terrestrial_Reference_System_1989\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4258\"]],VERT_CS[\"Malin Head height\",VERT_D");
    add_srs_wkt (p, 8,
        "ATUM[\"Malin Head\",2005,AUTHORITY[\"EPSG\",\"5130\"]],U");
    add_srs_wkt (p, 9,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gra");
    add_srs_wkt (p, 10,
        "vity-related height\",UP],AUTHORITY[\"EPSG\",\"5731\"]],");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9449\"]]");
    p = add_epsg_def_ex (filter, first, last, 9450, "epsg", 9450,
        "ETRS89", 1, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +geoid");
    add_proj4text (p, 1,
        "grids=uk_os_OSGM15_Belfast.tif +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 + Belfast height\",GEOGCS[\"ETRS89\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"European_Terrestrial_Reference_System_1989\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4258\"]],VERT_CS[\"Belfast height\",VERT_DATUM[\"");
    add_srs_wkt (p, 8,
        "Belfast Lough\",2005,AUTHORITY[\"EPSG\",\"5131\"]],UNIT[");
    add_srs_wkt (p, 9,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity");
    add_srs_wkt (p, 10,
        "-related height\",UP],AUTHORITY[\"EPSG\",\"5732\"]],AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9450\"]]");
    p = add_epsg_def_ex (filter, first, last, 9452, "epsg", 9452,
        "ETRS89", 1, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +vunit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 + BI height\",GEOGCS[\"ETRS89\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Terrestrial_Reference_System_1989\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 6,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4258\"]],VERT_CS[\"BI height\",VERT_DATUM[\"British I");
    add_srs_wkt (p, 8,
        "sles height ensemble\",2005,AUTHORITY[\"EPSG\",\"1288\"]");
    add_srs_wkt (p, 9,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 10,
        "Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"9451\"");
    add_srs_wkt (p, 11,
        "]],AUTHORITY[\"EPSG\",\"9452\"]]");
    p = add_epsg_def_ex (filter, first, last, 9453, "epsg", 9453,
        "GBK19-IRF", 1, 1,
        "GRS 1980", "Greenwich",
        "GBK19_Intermediate_Reference_Frame", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"GBK19-IRF\",DATUM[\"GBK19_Intermediate_Referenc");
    add_srs_wkt (p, 1,
        "e_Frame\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 2,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1289\"]");
    add_srs_wkt (p, 3,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 4,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 5,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"9453\"]]");
    p = add_epsg_def_ex (filter, first, last, 9456, "epsg", 9456,
        "GBK19 Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "GBK19_Intermediate_Reference_Frame", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=55.75 +lon_0=-4.35 +k=1 +x_0=93720.39");
    add_proj4text (p, 1,
        "4 +y_0=113870.493 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GBK19 Grid\",GEOGCS[\"GBK19-IRF\",DATUM[\"GBK19");
    add_srs_wkt (p, 1,
        "_Intermediate_Reference_Frame\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1289\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"9453\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",55.75],PARAMETER[\"central_meridian\",-4");
    add_srs_wkt (p, 8,
        ".35],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",93720.394],PARAMETER[\"false_northing\",113870.49");
    add_srs_wkt (p, 10,
        "3],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9456\"]]");
    p = add_epsg_def_ex (filter, first, last, 9457, "epsg", 9457,
        "GBK19 Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "GBK19_Intermediate_Reference_Frame", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=55.75 +lon_0=-4.35 +k=1 +x_0=93720.39");
    add_proj4text (p, 1,
        "4 +y_0=113870.493 +ellps=GRS80 +units=m +geoidgrids=uk_o");
    add_proj4text (p, 2,
        "s_OSGM15_GB.tif +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"GBK19 Grid + ODN height\",PROJCS[\"GBK19 Grid");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"GBK19-IRF\",DATUM[\"GBK19_Intermediate_Refer");
    add_srs_wkt (p, 2,
        "ence_Frame\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1289");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"9453\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",55");
    add_srs_wkt (p, 8,
        ".75],PARAMETER[\"central_meridian\",-4.35],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",1],PARAMETER[\"false_easting\",93720.394],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",113870.493],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"9456\"]],VE");
    add_srs_wkt (p, 13,
        "RT_CS[\"ODN height\",VERT_DATUM[\"Ordnance Datum Newlyn\"");
    add_srs_wkt (p, 14,
        ",2005,AUTHORITY[\"EPSG\",\"5101\"]],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height");
    add_srs_wkt (p, 16,
        "\",UP],AUTHORITY[\"EPSG\",\"5701\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 17,
        "\"9457\"]]");
    p = add_epsg_def_ex (filter, first, last, 9462, "epsg", 9462,
        "GDA2020", 1, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +geoid");
    add_proj4text (p, 1,
        "grids=au_ga_AGQG_20191107.tif +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"GDA2020 + AVWS height\",GEOGCS[\"GDA2020\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 6,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "7844\"]],VERT_CS[\"AVWS height\",VERT_DATUM[\"Australian");
    add_srs_wkt (p, 8,
        " Vertical Working Surface\",2005,AUTHORITY[\"EPSG\",\"12");
    add_srs_wkt (p, 9,
        "92\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 10,
        "IS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "458\"]],AUTHORITY[\"EPSG\",\"9462\"]]");
    p = add_epsg_def_ex (filter, first, last, 9463, "epsg", 9463,
        "GDA2020", 1, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +geoid");
    add_proj4text (p, 1,
        "grids=au_ga_AUSGeoid2020_20180201.tif +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"GDA2020 + AHD height\",GEOGCS[\"GDA2020\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"78");
    add_srs_wkt (p, 7,
        "44\"]],VERT_CS[\"AHD height\",VERT_DATUM[\"Australian He");
    add_srs_wkt (p, 8,
        "ight Datum\",2005,AUTHORITY[\"EPSG\",\"5111\"]],UNIT[\"m");
    add_srs_wkt (p, 9,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-re");
    add_srs_wkt (p, 10,
        "lated height\",UP],AUTHORITY[\"EPSG\",\"5711\"]],AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9463\"]]");
    p = add_epsg_def_ex (filter, first, last, 9464, "epsg", 9464,
        "GDA94", 1, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +geoid");
    add_proj4text (p, 1,
        "grids=au_ga_AUSGeoid2020_20180201.tif +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"GDA94 + AHD height\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 6,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4283\"");
    add_srs_wkt (p, 7,
        "]],VERT_CS[\"AHD height\",VERT_DATUM[\"Australian Height");
    add_srs_wkt (p, 8,
        " Datum\",2005,AUTHORITY[\"EPSG\",\"5111\"]],UNIT[\"metre");
    add_srs_wkt (p, 9,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-relate");
    add_srs_wkt (p, 10,
        "d height\",UP],AUTHORITY[\"EPSG\",\"5711\"]],AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9464\"]]");
    p = add_epsg_def_ex (filter, first, last, 9469, "epsg", 9469,
        "SRGI2013", 1, 1,
        "WGS 84", "Greenwich",
        "Sistem_Referensi_Geospasial_Indonesia_2013", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"SRGI2013\",DYNAMIC[FRAMEEPOCH[2012]],DATUM[\"S");
    add_srs_wkt (p, 1,
        "istem Referensi Geospasial Indonesia 2013\",ELLIPSOID[\"");
    add_srs_wkt (p, 2,
        "WGS 84\",6378137,298.257223563,LENGTHUNIT[\"metre\",1]]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 4,
        "5199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude (La");
    add_srs_wkt (p, 5,
        "t)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2],AN");
    add_srs_wkt (p, 7,
        "GLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellipsoid");
    add_srs_wkt (p, 8,
        "al height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]],USA");
    add_srs_wkt (p, 9,
        "GE[SCOPE[\"Geodesy.\"],AREA[\"Indonesia - onshore and of");
    add_srs_wkt (p, 10,
        "fshore.\"],BBOX[-13.95,92.01,7.79,141.46]],ID[\"EPSG\",9");
    add_srs_wkt (p, 11,
        "469]]");
    p = add_epsg_def_ex (filter, first, last, 9470, "epsg", 9470,
        "SRGI2013", 1, 1,
        "WGS 84", "Greenwich",
        "Sistem_Referensi_Geospasial_Indonesia_2013", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SRGI2013\",DATUM[\"Sistem_Referensi_Geospasial_");
    add_srs_wkt (p, 1,
        "Indonesia_2013\",SPHEROID[\"WGS 84\",6378137,298.2572235");
    add_srs_wkt (p, 2,
        "63,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"12");
    add_srs_wkt (p, 3,
        "93\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"9470\"]]");
    p = add_epsg_def_ex (filter, first, last, 9473, "epsg", 9473,
        "GDA2020 / Australian Albers", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Albers_Conic_Equal_Area", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=aea +lat_0=0 +lon_0=132 +lat_1=-18 +lat_2=-36 +x_0");
    add_proj4text (p, 1,
        "=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / Australian Albers\",GEOGCS[\"GDA2020\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "19\"]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"7844\"]],PROJECTION[\"Albers_Conic_Equal_Area\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_center\",0],PARAMETER[\"longitud");
    add_srs_wkt (p, 8,
        "e_of_center\",132],PARAMETER[\"standard_parallel_1\",-18");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"standard_parallel_2\",-36],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"9473");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 9474, "epsg", 9474,
        "PZ-90.02", 1, 1,
        "PZ-90", "Greenwich",
        "Parametry_Zemli_1990_02", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378136 +rf=298.257839303 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"PZ-90.02\",DATUM[\"Parametry_Zemli_1990_02\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"PZ-90\",6378136,298.257839303,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7054\"]],AUTHORITY[\"EPSG\",\"1157\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 3,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 4,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 5,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"9474\"]]");
    p = add_epsg_def_ex (filter, first, last, 9475, "epsg", 9475,
        "PZ-90.11", 1, 1,
        "PZ-90", "Greenwich",
        "Parametry_Zemli_1990_11", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378136 +rf=298.257839303 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"PZ-90.11\",DATUM[\"Parametry_Zemli_1990_11\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"PZ-90\",6378136,298.257839303,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 2,
        ",\"7054\"]],AUTHORITY[\"EPSG\",\"1158\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 3,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 4,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 5,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"9475\"]]");
    p = add_epsg_def_ex (filter, first, last, 9476, "epsg", 9476,
        "SRGI2013 / UTM zone 46N", 0, 0,
        "WGS 84", "Greenwich",
        "Sistem_Referensi_Geospasial_Indonesia_2013", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +ellps=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SRGI2013 / UTM zone 46N\",GEOGCS[\"SRGI2013\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Sistem_Referensi_Geospasial_Indonesia_2013\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7030\"]],AUTHORITY[\"EPSG\",\"1293\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"9470\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",93],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9476\"]]");
    p = add_epsg_def_ex (filter, first, last, 9477, "epsg", 9477,
        "SRGI2013 / UTM zone 47N", 0, 0,
        "WGS 84", "Greenwich",
        "Sistem_Referensi_Geospasial_Indonesia_2013", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +ellps=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SRGI2013 / UTM zone 47N\",GEOGCS[\"SRGI2013\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Sistem_Referensi_Geospasial_Indonesia_2013\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7030\"]],AUTHORITY[\"EPSG\",\"1293\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"9470\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",99],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9477\"]]");
    p = add_epsg_def_ex (filter, first, last, 9478, "epsg", 9478,
        "SRGI2013 / UTM zone 48N", 0, 0,
        "WGS 84", "Greenwich",
        "Sistem_Referensi_Geospasial_Indonesia_2013", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +ellps=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SRGI2013 / UTM zone 48N\",GEOGCS[\"SRGI2013\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Sistem_Referensi_Geospasial_Indonesia_2013\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7030\"]],AUTHORITY[\"EPSG\",\"1293\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"9470\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",105],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9478\"]]");
    p = add_epsg_def_ex (filter, first, last, 9479, "epsg", 9479,
        "SRGI2013 / UTM zone 49N", 0, 0,
        "WGS 84", "Greenwich",
        "Sistem_Referensi_Geospasial_Indonesia_2013", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +ellps=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SRGI2013 / UTM zone 49N\",GEOGCS[\"SRGI2013\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Sistem_Referensi_Geospasial_Indonesia_2013\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7030\"]],AUTHORITY[\"EPSG\",\"1293\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"9470\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",111],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9479\"]]");
    p = add_epsg_def_ex (filter, first, last, 9480, "epsg", 9480,
        "SRGI2013 / UTM zone 50N", 0, 0,
        "WGS 84", "Greenwich",
        "Sistem_Referensi_Geospasial_Indonesia_2013", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +ellps=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SRGI2013 / UTM zone 50N\",GEOGCS[\"SRGI2013\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Sistem_Referensi_Geospasial_Indonesia_2013\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7030\"]],AUTHORITY[\"EPSG\",\"1293\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"9470\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",117],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9480\"]]");
    p = add_epsg_def_ex (filter, first, last, 9481, "epsg", 9481,
        "SRGI2013 / UTM zone 51N", 0, 0,
        "WGS 84", "Greenwich",
        "Sistem_Referensi_Geospasial_Indonesia_2013", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +ellps=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SRGI2013 / UTM zone 51N\",GEOGCS[\"SRGI2013\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Sistem_Referensi_Geospasial_Indonesia_2013\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7030\"]],AUTHORITY[\"EPSG\",\"1293\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"9470\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",123],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9481\"]]");
    p = add_epsg_def_ex (filter, first, last, 9482, "epsg", 9482,
        "SRGI2013 / UTM zone 52N", 0, 0,
        "WGS 84", "Greenwich",
        "Sistem_Referensi_Geospasial_Indonesia_2013", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +ellps=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SRGI2013 / UTM zone 52N\",GEOGCS[\"SRGI2013\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Sistem_Referensi_Geospasial_Indonesia_2013\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7030\"]],AUTHORITY[\"EPSG\",\"1293\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"9470\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",129],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9482\"]]");
    p = add_epsg_def_ex (filter, first, last, 9487, "epsg", 9487,
        "SRGI2013 / UTM zone 47S", 0, 0,
        "WGS 84", "Greenwich",
        "Sistem_Referensi_Geospasial_Indonesia_2013", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +south +ellps=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SRGI2013 / UTM zone 47S\",GEOGCS[\"SRGI2013\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Sistem_Referensi_Geospasial_Indonesia_2013\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7030\"]],AUTHORITY[\"EPSG\",\"1293\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"9470\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",99],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9487\"]]");
    p = add_epsg_def_ex (filter, first, last, 9488, "epsg", 9488,
        "SRGI2013 / UTM zone 48S", 0, 0,
        "WGS 84", "Greenwich",
        "Sistem_Referensi_Geospasial_Indonesia_2013", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +south +ellps=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SRGI2013 / UTM zone 48S\",GEOGCS[\"SRGI2013\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Sistem_Referensi_Geospasial_Indonesia_2013\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7030\"]],AUTHORITY[\"EPSG\",\"1293\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"9470\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",105],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9488\"]]");
    p = add_epsg_def_ex (filter, first, last, 9489, "epsg", 9489,
        "SRGI2013 / UTM zone 49S", 0, 0,
        "WGS 84", "Greenwich",
        "Sistem_Referensi_Geospasial_Indonesia_2013", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +south +ellps=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SRGI2013 / UTM zone 49S\",GEOGCS[\"SRGI2013\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Sistem_Referensi_Geospasial_Indonesia_2013\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7030\"]],AUTHORITY[\"EPSG\",\"1293\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"9470\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",111],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9489\"]]");
    p = add_epsg_def_ex (filter, first, last, 9490, "epsg", 9490,
        "SRGI2013 / UTM zone 50S", 0, 0,
        "WGS 84", "Greenwich",
        "Sistem_Referensi_Geospasial_Indonesia_2013", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +ellps=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SRGI2013 / UTM zone 50S\",GEOGCS[\"SRGI2013\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Sistem_Referensi_Geospasial_Indonesia_2013\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7030\"]],AUTHORITY[\"EPSG\",\"1293\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"9470\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",117],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9490\"]]");
    p = add_epsg_def_ex (filter, first, last, 9491, "epsg", 9491,
        "SRGI2013 / UTM zone 51S", 0, 0,
        "WGS 84", "Greenwich",
        "Sistem_Referensi_Geospasial_Indonesia_2013", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +south +ellps=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SRGI2013 / UTM zone 51S\",GEOGCS[\"SRGI2013\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Sistem_Referensi_Geospasial_Indonesia_2013\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7030\"]],AUTHORITY[\"EPSG\",\"1293\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"9470\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",123],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9491\"]]");
    p = add_epsg_def_ex (filter, first, last, 9492, "epsg", 9492,
        "SRGI2013 / UTM zone 52S", 0, 0,
        "WGS 84", "Greenwich",
        "Sistem_Referensi_Geospasial_Indonesia_2013", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +south +ellps=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SRGI2013 / UTM zone 52S\",GEOGCS[\"SRGI2013\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Sistem_Referensi_Geospasial_Indonesia_2013\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7030\"]],AUTHORITY[\"EPSG\",\"1293\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"9470\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",129],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9492\"]]");
    p = add_epsg_def_ex (filter, first, last, 9493, "epsg", 9493,
        "SRGI2013 / UTM zone 53S", 0, 0,
        "WGS 84", "Greenwich",
        "Sistem_Referensi_Geospasial_Indonesia_2013", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +south +ellps=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SRGI2013 / UTM zone 53S\",GEOGCS[\"SRGI2013\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Sistem_Referensi_Geospasial_Indonesia_2013\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7030\"]],AUTHORITY[\"EPSG\",\"1293\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"9470\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",135],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9493\"]]");
    p = add_epsg_def_ex (filter, first, last, 9494, "epsg", 9494,
        "SRGI2013 / UTM zone 54S", 0, 0,
        "WGS 84", "Greenwich",
        "Sistem_Referensi_Geospasial_Indonesia_2013", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +south +ellps=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SRGI2013 / UTM zone 54S\",GEOGCS[\"SRGI2013\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Sistem_Referensi_Geospasial_Indonesia_2013\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7030\"]],AUTHORITY[\"EPSG\",\"1293\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"9470\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",141],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9494\"]]");
    p = add_epsg_def_ex (filter, first, last, 9498, "epsg", 9498,
        "POSGAR 2007 / CABA 2019", 0, 1,
        "WGS 84", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_2007", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-34.6292666666667 +lon_0=-58.46330833");
    add_proj4text (p, 1,
        "33333 +k=1 +x_0=20000 +y_0=70000 +ellps=WGS84 +units=m +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 2007 / CABA 2019\",GEOGCS[\"POSGAR 2007\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Posiciones_Geodesicas_Argentinas_2007\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7030\"]],AUTHORITY[\"EPSG\",\"1062\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"5340\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-34.6292666666667],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",-58.4633083333333],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1],PARAMETER[\"false_easting\",20000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",70000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"9498\"]]");
    p = add_epsg_def_ex (filter, first, last, 9674, "epsg", 9674,
        "NAD83 / USFS R6 Albers", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Albers_Conic_Equal_Area", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=aea +lat_0=34 +lon_0=-120 +lat_1=43 +lat_2=48 +x_0");
    add_proj4text (p, 1,
        "=600000 +y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / USFS R6 Albers\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Albers_Conic_Equal_Area\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_center\",34],PARAMETER[\"longitude_of_center\"");
    add_srs_wkt (p, 8,
        ",-120],PARAMETER[\"standard_parallel_1\",43],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",48],PARAMETER[\"false_easting\",60");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"9674\"]]");
    p = add_epsg_def_ex (filter, first, last, 20004, "epsg", 20004,
        "Pulkovo 1995 / Gauss-Kruger zone 4", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 4\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",4500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20004\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 20005, "epsg", 20005,
        "Pulkovo 1995 / Gauss-Kruger zone 5", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 5\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",5500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20005\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 20006, "epsg", 20006,
        "Pulkovo 1995 / Gauss-Kruger zone 6", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=6500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 6\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",6500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20006\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 20007, "epsg", 20007,
        "Pulkovo 1995 / Gauss-Kruger zone 7", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=7500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 7\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",7500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20007\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 20008, "epsg", 20008,
        "Pulkovo 1995 / Gauss-Kruger zone 8", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=8500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 8\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",4");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",8500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20008\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 20009, "epsg", 20009,
        "Pulkovo 1995 / Gauss-Kruger zone 9", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=9500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 9\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",9500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20009\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 20010, "epsg", 20010,
        "Pulkovo 1995 / Gauss-Kruger zone 10", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=10500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 10\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",10500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20010");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 20011, "epsg", 20011,
        "Pulkovo 1995 / Gauss-Kruger zone 11", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=11500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 11\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",11500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20011");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 20012, "epsg", 20012,
        "Pulkovo 1995 / Gauss-Kruger zone 12", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=12500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 12\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",12500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20012");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 20013, "epsg", 20013,
        "Pulkovo 1995 / Gauss-Kruger zone 13", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 13\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",7");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",13500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20013");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 20014, "epsg", 20014,
        "Pulkovo 1995 / Gauss-Kruger zone 14", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 14\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",14500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20014");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 20015, "epsg", 20015,
        "Pulkovo 1995 / Gauss-Kruger zone 15", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 15\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",15500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20015");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 20016, "epsg", 20016,
        "Pulkovo 1995 / Gauss-Kruger zone 16", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 16\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",16500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20016");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 20017, "epsg", 20017,
        "Pulkovo 1995 / Gauss-Kruger zone 17", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 17\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",17500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"20017");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 20018, "epsg", 20018,
        "Pulkovo 1995 / Gauss-Kruger zone 18", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 18\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "05],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",18500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2001");
    add_srs_wkt (p, 12,
        "8\"]]");
    p = add_epsg_def_ex (filter, first, last, 20019, "epsg", 20019,
        "Pulkovo 1995 / Gauss-Kruger zone 19", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 19\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "11],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",19500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2001");
    add_srs_wkt (p, 12,
        "9\"]]");
    p = add_epsg_def_ex (filter, first, last, 20020, "epsg", 20020,
        "Pulkovo 1995 / Gauss-Kruger zone 20", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 20\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "17],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",20500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2002");
    add_srs_wkt (p, 12,
        "0\"]]");
    p = add_epsg_def_ex (filter, first, last, 20021, "epsg", 20021,
        "Pulkovo 1995 / Gauss-Kruger zone 21", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 21\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "23],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",21500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2002");
    add_srs_wkt (p, 12,
        "1\"]]");
    p = add_epsg_def_ex (filter, first, last, 20022, "epsg", 20022,
        "Pulkovo 1995 / Gauss-Kruger zone 22", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 22\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "29],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",22500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2002");
    add_srs_wkt (p, 12,
        "2\"]]");
    p = add_epsg_def_ex (filter, first, last, 20023, "epsg", 20023,
        "Pulkovo 1995 / Gauss-Kruger zone 23", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 23\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "35],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",23500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2002");
    add_srs_wkt (p, 12,
        "3\"]]");
    p = add_epsg_def_ex (filter, first, last, 20024, "epsg", 20024,
        "Pulkovo 1995 / Gauss-Kruger zone 24", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=24500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 24\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "41],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",24500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2002");
    add_srs_wkt (p, 12,
        "4\"]]");
    p = add_epsg_def_ex (filter, first, last, 20025, "epsg", 20025,
        "Pulkovo 1995 / Gauss-Kruger zone 25", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=25500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 25\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "47],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",25500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2002");
    add_srs_wkt (p, 12,
        "5\"]]");
    p = add_epsg_def_ex (filter, first, last, 20026, "epsg", 20026,
        "Pulkovo 1995 / Gauss-Kruger zone 26", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=26500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 26\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "53],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",26500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2002");
    add_srs_wkt (p, 12,
        "6\"]]");
    p = add_epsg_def_ex (filter, first, last, 20027, "epsg", 20027,
        "Pulkovo 1995 / Gauss-Kruger zone 27", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=27500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 27\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "59],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",27500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2002");
    add_srs_wkt (p, 12,
        "7\"]]");
    p = add_epsg_def_ex (filter, first, last, 20028, "epsg", 20028,
        "Pulkovo 1995 / Gauss-Kruger zone 28", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=28500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 28\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "65],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",28500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2002");
    add_srs_wkt (p, 12,
        "8\"]]");
    p = add_epsg_def_ex (filter, first, last, 20029, "epsg", 20029,
        "Pulkovo 1995 / Gauss-Kruger zone 29", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=29500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 29\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "71],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",29500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2002");
    add_srs_wkt (p, 12,
        "9\"]]");
    p = add_epsg_def_ex (filter, first, last, 20030, "epsg", 20030,
        "Pulkovo 1995 / Gauss-Kruger zone 30", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=30500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0");
    add_proj4text (p, 2,
        ".22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 30\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "77],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",30500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2003");
    add_srs_wkt (p, 12,
        "0\"]]");
    p = add_epsg_def_ex (filter, first, last, 20031, "epsg", 20031,
        "Pulkovo 1995 / Gauss-Kruger zone 31", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=31500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-");
    add_proj4text (p, 2,
        "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 31\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "177],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",31500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2003");
    add_srs_wkt (p, 12,
        "1\"]]");
    p = add_epsg_def_ex (filter, first, last, 20032, "epsg", 20032,
        "Pulkovo 1995 / Gauss-Kruger zone 32", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=32500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-");
    add_proj4text (p, 2,
        "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 32\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "171],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",32500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2003");
    add_srs_wkt (p, 12,
        "2\"]]");
    p = add_epsg_def_ex (filter, first, last, 20064, "epsg", 20064,
        "Pulkovo 1995 / Gauss-Kruger CM 21E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 21E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2463\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 20065, "epsg", 20065,
        "Pulkovo 1995 / Gauss-Kruger CM 27E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 27E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2464\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 20066, "epsg", 20066,
        "Pulkovo 1995 / Gauss-Kruger CM 33E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 33E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2465\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 20067, "epsg", 20067,
        "Pulkovo 1995 / Gauss-Kruger CM 39E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 39E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2466\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 20068, "epsg", 20068,
        "Pulkovo 1995 / Gauss-Kruger CM 45E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 45E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",4");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2467\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 20069, "epsg", 20069,
        "Pulkovo 1995 / Gauss-Kruger CM 51E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 51E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2468\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 20070, "epsg", 20070,
        "Pulkovo 1995 / Gauss-Kruger CM 57E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 57E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2469\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 20071, "epsg", 20071,
        "Pulkovo 1995 / Gauss-Kruger CM 63E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 63E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2470\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 20072, "epsg", 20072,
        "Pulkovo 1995 / Gauss-Kruger CM 69E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 69E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2471\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 20073, "epsg", 20073,
        "Pulkovo 1995 / Gauss-Kruger CM 75E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 75E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",7");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2472\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 20074, "epsg", 20074,
        "Pulkovo 1995 / Gauss-Kruger CM 81E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 81E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2473\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 20075, "epsg", 20075,
        "Pulkovo 1995 / Gauss-Kruger CM 87E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger CM 87E\",GEOGCS[\"P");
    add_srs_wkt (p, 1,
        "ulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "200\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2474\"]");
    add_srs_wkt (p, 12,
        "]");
}

#endif /* full EPSG initialization enabled/disabled */

