(*

  CamlTemplate: A template processor for Objective Caml programs.
  Copyright  2003, 2004, 2005 Benjamin Geer
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St., 5th Floor, Boston MA 02110-1301
  USA
  
  In addition, as a special exception, Benjamin Geer gives permission
  to link the code of this program with the Apache HTTP Server (or
  with modified versions of Apache that use the same license as
  Apache), and distribute linked combinations including the two. You
  must obey the GNU General Public License in all respects for all of
  the code used other than Apache. If you modify this file, you may
  extend this exception to your version of the file, but you are not
  obligated to do so. If you do not wish to do so, delete this
  exception statement from your version.

*)

(* $Id: ctContext.ml,v 1.8 2005-06-08 15:22:09 ben Exp $ *)

open CtTemplateTypes ;;
open CtScope ;;

(* The implementation of the context type in CtTemplateTypes. *)

class context_impl
  ~(template_name : string)
  ~(cur_scope : scope)
  ~(opened_modules : string list)
  ~(buf : Buffer.t)
  ~(get_template_fun : template_name:string -> template) =
object
  val template_name = template_name
  val cur_scope = cur_scope
  val mutable opened_modules = opened_modules
  val buf = buf
  val get_template_fun = get_template_fun

  method get_template_name = template_name
  method get_cur_scope = cur_scope
  method get_opened_modules = opened_modules
  method add_opened_module module_name =
    opened_modules <- List.rev (module_name :: opened_modules)
  method get_buf = buf
  method get_template name =
    get_template_fun name
  method make_macro_context =
    {< cur_scope = cur_scope#make_macro_scope >}
end ;;
