/*
 * GMC_8_1 Register documentation
 *
 * Copyright (C) 2014  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef GMC_8_1_D_H
#define GMC_8_1_D_H

#define mmMC_CONFIG                                                             0x800
#define mmMC_ARB_ATOMIC                                                         0x9be
#define mmMC_ARB_AGE_CNTL                                                       0x9bf
#define mmMC_ARB_RET_CREDITS2                                                   0x9c0
#define mmMC_ARB_FED_CNTL                                                       0x9c1
#define mmMC_ARB_GECC2_STATUS                                                   0x9c2
#define mmMC_ARB_GECC2_MISC                                                     0x9c3
#define mmMC_ARB_GECC2_DEBUG                                                    0x9c4
#define mmMC_ARB_GECC2_DEBUG2                                                   0x9c5
#define mmMC_ARB_PERF_CID                                                       0x9c6
#define mmMC_ARB_SNOOP                                                          0x9c7
#define mmMC_ARB_GRUB                                                           0x9c8
#define mmMC_ARB_GECC2                                                          0x9c9
#define mmMC_ARB_GECC2_CLI                                                      0x9ca
#define mmMC_ARB_ADDR_SWIZ0                                                     0x9cb
#define mmMC_ARB_ADDR_SWIZ1                                                     0x9cc
#define mmMC_ARB_MISC3                                                          0x9cd
#define mmMC_ARB_GRUB_PROMOTE                                                   0x9ce
#define mmMC_ARB_RTT_DATA                                                       0x9cf
#define mmMC_ARB_RTT_CNTL0                                                      0x9d0
#define mmMC_ARB_RTT_CNTL1                                                      0x9d1
#define mmMC_ARB_RTT_CNTL2                                                      0x9d2
#define mmMC_ARB_RTT_DEBUG                                                      0x9d3
#define mmMC_ARB_CAC_CNTL                                                       0x9d4
#define mmMC_ARB_MISC2                                                          0x9d5
#define mmMC_ARB_MISC                                                           0x9d6
#define mmMC_ARB_BANKMAP                                                        0x9d7
#define mmMC_ARB_RAMCFG                                                         0x9d8
#define mmMC_ARB_POP                                                            0x9d9
#define mmMC_ARB_MINCLKS                                                        0x9da
#define mmMC_ARB_SQM_CNTL                                                       0x9db
#define mmMC_ARB_ADDR_HASH                                                      0x9dc
#define mmMC_ARB_DRAM_TIMING                                                    0x9dd
#define mmMC_ARB_DRAM_TIMING2                                                   0x9de
#define mmMC_ARB_WTM_CNTL_RD                                                    0x9df
#define mmMC_ARB_WTM_CNTL_WR                                                    0x9e0
#define mmMC_ARB_WTM_GRPWT_RD                                                   0x9e1
#define mmMC_ARB_WTM_GRPWT_WR                                                   0x9e2
#define mmMC_ARB_TM_CNTL_RD                                                     0x9e3
#define mmMC_ARB_TM_CNTL_WR                                                     0x9e4
#define mmMC_ARB_LAZY0_RD                                                       0x9e5
#define mmMC_ARB_LAZY0_WR                                                       0x9e6
#define mmMC_ARB_LAZY1_RD                                                       0x9e7
#define mmMC_ARB_LAZY1_WR                                                       0x9e8
#define mmMC_ARB_AGE_RD                                                         0x9e9
#define mmMC_ARB_AGE_WR                                                         0x9ea
#define mmMC_ARB_RFSH_CNTL                                                      0x9eb
#define mmMC_ARB_RFSH_RATE                                                      0x9ec
#define mmMC_ARB_PM_CNTL                                                        0x9ed
#define mmMC_ARB_GDEC_RD_CNTL                                                   0x9ee
#define mmMC_ARB_GDEC_WR_CNTL                                                   0x9ef
#define mmMC_ARB_LM_RD                                                          0x9f0
#define mmMC_ARB_LM_WR                                                          0x9f1
#define mmMC_ARB_REMREQ                                                         0x9f2
#define mmMC_ARB_REPLAY                                                         0x9f3
#define mmMC_ARB_RET_CREDITS_RD                                                 0x9f4
#define mmMC_ARB_RET_CREDITS_WR                                                 0x9f5
#define mmMC_ARB_MAX_LAT_CID                                                    0x9f6
#define mmMC_ARB_MAX_LAT_RSLT0                                                  0x9f7
#define mmMC_ARB_MAX_LAT_RSLT1                                                  0x9f8
#define mmMC_ARB_GRUB_REALTIME_RD                                               0x9f9
#define mmMC_ARB_CG                                                             0x9fa
#define mmMC_ARB_GRUB_REALTIME_WR                                               0x9fb
#define mmMC_ARB_DRAM_TIMING_1                                                  0x9fc
#define mmMC_ARB_BUSY_STATUS                                                    0x9fd
#define mmMC_ARB_DRAM_TIMING2_1                                                 0x9ff
#define mmMC_ARB_GRUB2                                                          0xa01
#define mmMC_ARB_BURST_TIME                                                     0xa02
#define mmMC_CITF_XTRA_ENABLE                                                   0x96d
#define mmCC_MC_MAX_CHANNEL                                                     0x96e
#define mmMC_CG_CONFIG                                                          0x96f
#define mmMC_CITF_CNTL                                                          0x970
#define mmMC_CITF_CREDITS_VM                                                    0x971
#define mmMC_CITF_CREDITS_ARB_RD                                                0x972
#define mmMC_CITF_CREDITS_ARB_WR                                                0x973
#define mmMC_CITF_DAGB_CNTL                                                     0x974
#define mmMC_CITF_INT_CREDITS                                                   0x975
#define mmMC_CITF_RET_MODE                                                      0x976
#define mmMC_CITF_DAGB_DLY                                                      0x977
#define mmMC_RD_GRP_EXT                                                         0x978
#define mmMC_WR_GRP_EXT                                                         0x979
#define mmMC_CITF_REMREQ                                                        0x97a
#define mmMC_WR_TC0                                                             0x97b
#define mmMC_WR_TC1                                                             0x97c
#define mmMC_CITF_INT_CREDITS_WR                                                0x97d
#define mmMC_CITF_CREDITS_ARB_RD2                                               0x97e
#define mmMC_CITF_WTM_RD_CNTL                                                   0x97f
#define mmMC_CITF_WTM_WR_CNTL                                                   0x980
#define mmMC_RD_CB                                                              0x981
#define mmMC_RD_DB                                                              0x982
#define mmMC_RD_TC0                                                             0x983
#define mmMC_RD_TC1                                                             0x984
#define mmMC_RD_HUB                                                             0x985
#define mmMC_WR_CB                                                              0x986
#define mmMC_WR_DB                                                              0x987
#define mmMC_WR_HUB                                                             0x988
#define mmMC_CITF_CREDITS_XBAR                                                  0x989
#define mmMC_RD_GRP_LCL                                                         0x98a
#define mmMC_WR_GRP_LCL                                                         0x98b
#define mmMC_CITF_PERF_MON_CNTL2                                                0x98e
#define mmMC_CITF_PERF_MON_RSLT2                                                0x991
#define mmMC_CITF_MISC_RD_CG                                                    0x992
#define mmMC_CITF_MISC_WR_CG                                                    0x993
#define mmMC_CITF_MISC_VM_CG                                                    0x994
#define mmMC_HUB_MISC_POWER                                                     0x82d
#define mmMC_HUB_MISC_HUB_CG                                                    0x82e
#define mmMC_HUB_MISC_VM_CG                                                     0x82f
#define mmMC_HUB_MISC_SIP_CG                                                    0x830
#define mmMC_HUB_MISC_STATUS                                                    0x832
#define mmMC_HUB_MISC_OVERRIDE                                                  0x833
#define mmMC_HUB_MISC_FRAMING                                                   0x834
#define mmMC_HUB_WDP_CNTL                                                       0x835
#define mmMC_HUB_WDP_ERR                                                        0x836
#define mmMC_HUB_WDP_BP                                                         0x837
#define mmMC_HUB_WDP_STATUS                                                     0x838
#define mmMC_HUB_RDREQ_STATUS                                                   0x839
#define mmMC_HUB_WRRET_STATUS                                                   0x83a
#define mmMC_HUB_RDREQ_CNTL                                                     0x83b
#define mmMC_HUB_WRRET_CNTL                                                     0x83c
#define mmMC_HUB_RDREQ_WTM_CNTL                                                 0x83d
#define mmMC_HUB_WDP_WTM_CNTL                                                   0x83e
#define mmMC_HUB_WDP_CREDITS                                                    0x83f
#define mmMC_HUB_WDP_CREDITS2                                                   0x840
#define mmMC_HUB_WDP_GBL0                                                       0x841
#define mmMC_HUB_WDP_GBL1                                                       0x842
#define mmMC_HUB_WDP_CREDITS3                                                   0x843
#define mmMC_HUB_RDREQ_CREDITS                                                  0x844
#define mmMC_HUB_RDREQ_CREDITS2                                                 0x845
#define mmMC_HUB_SHARED_DAGB_DLY                                                0x846
#define mmMC_HUB_MISC_IDLE_STATUS                                               0x847
#define mmMC_HUB_RDREQ_DMIF_LIMIT                                               0x848
#define mmMC_HUB_RDREQ_ACPG_LIMIT                                               0x849
#define mmMC_HUB_WDP_BYPASS_GBL0                                                0x84a
#define mmMC_HUB_WDP_BYPASS_GBL1                                                0x84b
#define mmMC_HUB_RDREQ_BYPASS_GBL0                                              0x84c
#define mmMC_HUB_WDP_SH2                                                        0x84d
#define mmMC_HUB_WDP_SH3                                                        0x84e
#define mmMC_HUB_MISC_ATOMIC_IDLE_STATUS                                        0x84f
#define mmMC_HUB_WDP_VIN0                                                       0x850
#define mmMC_HUB_RDREQ_MCDW                                                     0x851
#define mmMC_HUB_RDREQ_MCDX                                                     0x852
#define mmMC_HUB_RDREQ_MCDY                                                     0x853
#define mmMC_HUB_RDREQ_MCDZ                                                     0x854
#define mmMC_HUB_RDREQ_SIP                                                      0x855
#define mmMC_HUB_RDREQ_GBL0                                                     0x856
#define mmMC_HUB_RDREQ_GBL1                                                     0x857
#define mmMC_HUB_RDREQ_SMU                                                      0x858
#define mmMC_HUB_RDREQ_SDMA0                                                    0x859
#define mmMC_HUB_RDREQ_HDP                                                      0x85a
#define mmMC_HUB_RDREQ_SDMA1                                                    0x85b
#define mmMC_HUB_RDREQ_RLC                                                      0x85c
#define mmMC_HUB_RDREQ_SEM                                                      0x85d
#define mmMC_HUB_RDREQ_VCE0                                                     0x85e
#define mmMC_HUB_RDREQ_UMC                                                      0x85f
#define mmMC_HUB_RDREQ_UVD                                                      0x860
#define mmMC_HUB_RDREQ_TLS                                                      0x861
#define mmMC_HUB_RDREQ_DMIF                                                     0x862
#define mmMC_HUB_RDREQ_MCIF                                                     0x863
#define mmMC_HUB_RDREQ_VMC                                                      0x864
#define mmMC_HUB_RDREQ_VCEU0                                                    0x865
#define mmMC_HUB_WDP_MCDW                                                       0x866
#define mmMC_HUB_WDP_MCDX                                                       0x867
#define mmMC_HUB_WDP_MCDY                                                       0x868
#define mmMC_HUB_WDP_MCDZ                                                       0x869
#define mmMC_HUB_WDP_SIP                                                        0x86a
#define mmMC_HUB_WDP_SDMA1                                                      0x86b
#define mmMC_HUB_WDP_SH0                                                        0x86c
#define mmMC_HUB_WDP_MCIF                                                       0x86d
#define mmMC_HUB_WDP_VCE0                                                       0x86e
#define mmMC_HUB_WDP_XDP                                                        0x86f
#define mmMC_HUB_WDP_IH                                                         0x870
#define mmMC_HUB_WDP_RLC                                                        0x871
#define mmMC_HUB_WDP_SEM                                                        0x872
#define mmMC_HUB_WDP_SMU                                                        0x873
#define mmMC_HUB_WDP_SH1                                                        0x874
#define mmMC_HUB_WDP_UMC                                                        0x875
#define mmMC_HUB_WDP_UVD                                                        0x876
#define mmMC_HUB_WDP_HDP                                                        0x877
#define mmMC_HUB_WDP_SDMA0                                                      0x878
#define mmMC_HUB_WRRET_MCDW                                                     0x879
#define mmMC_HUB_WRRET_MCDX                                                     0x87a
#define mmMC_HUB_WRRET_MCDY                                                     0x87b
#define mmMC_HUB_WRRET_MCDZ                                                     0x87c
#define mmMC_HUB_WDP_VCEU0                                                      0x87d
#define mmMC_HUB_WDP_XDMAM                                                      0x87e
#define mmMC_HUB_WDP_XDMA                                                       0x87f
#define mmMC_HUB_RDREQ_XDMAM                                                    0x880
#define mmMC_HUB_RDREQ_ACPG                                                     0x881
#define mmMC_HUB_RDREQ_ACPO                                                     0x882
#define mmMC_HUB_RDREQ_SAMMSP                                                   0x883
#define mmMC_HUB_RDREQ_VP8                                                      0x884
#define mmMC_HUB_RDREQ_VP8U                                                     0x885
#define mmMC_HUB_WDP_ACPG                                                       0x886
#define mmMC_HUB_WDP_ACPO                                                       0x887
#define mmMC_HUB_WDP_SAMMSP                                                     0x888
#define mmMC_HUB_WDP_VP8                                                        0x889
#define mmMC_HUB_WDP_VP8U                                                       0x88a
#define mmMC_HUB_RDREQ_ISP_SPM                                                  0xde0
#define mmMC_HUB_RDREQ_ISP_MPM                                                  0xde1
#define mmMC_HUB_RDREQ_ISP_CCPU                                                 0xde2
#define mmMC_HUB_WDP_ISP_SPM                                                    0xde3
#define mmMC_HUB_WDP_ISP_MPS                                                    0xde4
#define mmMC_HUB_WDP_ISP_MPM                                                    0xde5
#define mmMC_HUB_WDP_ISP_CCPU                                                   0xde6
#define mmMC_HUB_RDREQ_MCDS                                                     0xde7
#define mmMC_HUB_RDREQ_MCDT                                                     0xde8
#define mmMC_HUB_RDREQ_MCDU                                                     0xde9
#define mmMC_HUB_RDREQ_MCDV                                                     0xdea
#define mmMC_HUB_WDP_MCDS                                                       0xdeb
#define mmMC_HUB_WDP_MCDT                                                       0xdec
#define mmMC_HUB_WDP_MCDU                                                       0xded
#define mmMC_HUB_WDP_MCDV                                                       0xdee
#define mmMC_HUB_WRRET_MCDS                                                     0xdef
#define mmMC_HUB_WRRET_MCDT                                                     0xdf0
#define mmMC_HUB_WRRET_MCDU                                                     0xdf1
#define mmMC_HUB_WRRET_MCDV                                                     0xdf2
#define mmMC_HUB_WDP_CREDITS_MCDW                                               0xdf3
#define mmMC_HUB_WDP_CREDITS_MCDX                                               0xdf4
#define mmMC_HUB_WDP_CREDITS_MCDY                                               0xdf5
#define mmMC_HUB_WDP_CREDITS_MCDZ                                               0xdf6
#define mmMC_HUB_WDP_CREDITS_MCDS                                               0xdf7
#define mmMC_HUB_WDP_CREDITS_MCDT                                               0xdf8
#define mmMC_HUB_WDP_CREDITS_MCDU                                               0xdf9
#define mmMC_HUB_WDP_CREDITS_MCDV                                               0xdfa
#define mmMC_HUB_WDP_BP2                                                        0xdfb
#define mmMC_HUB_RDREQ_VCE1                                                     0xdfc
#define mmMC_HUB_RDREQ_VCEU1                                                    0xdfd
#define mmMC_HUB_WDP_VCE1                                                       0xdfe
#define mmMC_HUB_WDP_VCEU1                                                      0xdff
#define mmMC_RPB_CONF                                                           0x94d
#define mmMC_RPB_IF_CONF                                                        0x94e
#define mmMC_RPB_DBG1                                                           0x94f
#define mmMC_RPB_EFF_CNTL                                                       0x950
#define mmMC_RPB_ARB_CNTL                                                       0x951
#define mmMC_RPB_BIF_CNTL                                                       0x952
#define mmMC_RPB_WR_SWITCH_CNTL                                                 0x953
#define mmMC_RPB_WR_COMBINE_CNTL                                                0x954
#define mmMC_RPB_RD_SWITCH_CNTL                                                 0x955
#define mmMC_RPB_CID_QUEUE_WR                                                   0x956
#define mmMC_RPB_CID_QUEUE_RD                                                   0x957
#define mmMC_RPB_PERF_COUNTER_CNTL                                              0x958
#define mmMC_RPB_PERF_COUNTER_STATUS                                            0x959
#define mmMC_RPB_CID_QUEUE_EX                                                   0x95a
#define mmMC_RPB_CID_QUEUE_EX_DATA                                              0x95b
#define mmMC_RPB_TCI_CNTL                                                       0x95c
#define mmMC_RPB_TCI_CNTL2                                                      0x95d
#define mmMC_SHARED_CHMAP                                                       0x801
#define mmMC_SHARED_CHREMAP                                                     0x802
#define mmMC_RD_GRP_GFX                                                         0x803
#define mmMC_WR_GRP_GFX                                                         0x804
#define mmMC_RD_GRP_SYS                                                         0x805
#define mmMC_WR_GRP_SYS                                                         0x806
#define mmMC_RD_GRP_OTH                                                         0x807
#define mmMC_WR_GRP_OTH                                                         0x808
#define mmMC_VM_FB_LOCATION                                                     0x809
#define mmMC_VM_AGP_TOP                                                         0x80a
#define mmMC_VM_AGP_BOT                                                         0x80b
#define mmMC_VM_AGP_BASE                                                        0x80c
#define mmMC_VM_SYSTEM_APERTURE_LOW_ADDR                                        0x80d
#define mmMC_VM_SYSTEM_APERTURE_HIGH_ADDR                                       0x80e
#define mmMC_VM_SYSTEM_APERTURE_DEFAULT_ADDR                                    0x80f
#define mmMC_VM_DC_WRITE_CNTL                                                   0x810
#define mmMC_VM_DC_WRITE_HIT_REGION_0_LOW_ADDR                                  0x811
#define mmMC_VM_DC_WRITE_HIT_REGION_1_LOW_ADDR                                  0x812
#define mmMC_VM_DC_WRITE_HIT_REGION_2_LOW_ADDR                                  0x813
#define mmMC_VM_DC_WRITE_HIT_REGION_3_LOW_ADDR                                  0x814
#define mmMC_VM_DC_WRITE_HIT_REGION_0_HIGH_ADDR                                 0x815
#define mmMC_VM_DC_WRITE_HIT_REGION_1_HIGH_ADDR                                 0x816
#define mmMC_VM_DC_WRITE_HIT_REGION_2_HIGH_ADDR                                 0x817
#define mmMC_VM_DC_WRITE_HIT_REGION_3_HIGH_ADDR                                 0x818
#define mmMC_VM_MX_L1_TLB_CNTL                                                  0x819
#define mmMC_VM_FB_OFFSET                                                       0x81a
#define mmMC_VM_STEERING                                                        0x81b
#define mmMC_SHARED_CHREMAP2                                                    0x81c
#define mmMC_SHARED_VF_ENABLE                                                   0x81d
#define mmMC_SHARED_VIRT_RESET_REQ                                              0x81e
#define mmMC_SHARED_ACTIVE_FCN_ID                                               0x81f
#define mmMC_CONFIG_MCD                                                         0x828
#define mmMC_CG_CONFIG_MCD                                                      0x829
#define mmMC_MEM_POWER_LS                                                       0x82a
#define mmMC_SHARED_BLACKOUT_CNTL                                               0x82b
#define mmMC_VM_MB_L1_TLB0_DEBUG                                                0x891
#define mmMC_VM_MB_L1_TLB1_DEBUG                                                0x892
#define mmMC_VM_MB_L1_TLB2_DEBUG                                                0x893
#define mmMC_VM_MB_L1_TLB0_STATUS                                               0x895
#define mmMC_VM_MB_L1_TLB1_STATUS                                               0x896
#define mmMC_VM_MB_L1_TLB2_STATUS                                               0x897
#define mmMC_VM_MB_L2ARBITER_L2_CREDITS                                         0x8a1
#define mmMC_VM_MB_L1_TLB3_DEBUG                                                0x8a5
#define mmMC_VM_MB_L1_TLB3_STATUS                                               0x8a6
#define mmMC_VM_MD_L1_TLB0_DEBUG                                                0x998
#define mmMC_VM_MD_L1_TLB1_DEBUG                                                0x999
#define mmMC_VM_MD_L1_TLB2_DEBUG                                                0x99a
#define mmMC_VM_MD_L1_TLB0_STATUS                                               0x99b
#define mmMC_VM_MD_L1_TLB1_STATUS                                               0x99c
#define mmMC_VM_MD_L1_TLB2_STATUS                                               0x99d
#define mmMC_VM_MD_L2ARBITER_L2_CREDITS                                         0x9a4
#define mmMC_VM_MD_L1_TLB3_DEBUG                                                0x9a7
#define mmMC_VM_MD_L1_TLB3_STATUS                                               0x9a8
#define mmMC_XPB_RTR_SRC_APRTR0                                                 0x8cd
#define mmMC_XPB_RTR_SRC_APRTR1                                                 0x8ce
#define mmMC_XPB_RTR_SRC_APRTR2                                                 0x8cf
#define mmMC_XPB_RTR_SRC_APRTR3                                                 0x8d0
#define mmMC_XPB_RTR_SRC_APRTR4                                                 0x8d1
#define mmMC_XPB_RTR_SRC_APRTR5                                                 0x8d2
#define mmMC_XPB_RTR_SRC_APRTR6                                                 0x8d3
#define mmMC_XPB_RTR_SRC_APRTR7                                                 0x8d4
#define mmMC_XPB_RTR_SRC_APRTR8                                                 0x8d5
#define mmMC_XPB_RTR_SRC_APRTR9                                                 0x8d6
#define mmMC_XPB_XDMA_RTR_SRC_APRTR0                                            0x8d7
#define mmMC_XPB_XDMA_RTR_SRC_APRTR1                                            0x8d8
#define mmMC_XPB_XDMA_RTR_SRC_APRTR2                                            0x8d9
#define mmMC_XPB_XDMA_RTR_SRC_APRTR3                                            0x8da
#define mmMC_XPB_RTR_DEST_MAP0                                                  0x8db
#define mmMC_XPB_RTR_DEST_MAP1                                                  0x8dc
#define mmMC_XPB_RTR_DEST_MAP2                                                  0x8dd
#define mmMC_XPB_RTR_DEST_MAP3                                                  0x8de
#define mmMC_XPB_RTR_DEST_MAP4                                                  0x8df
#define mmMC_XPB_RTR_DEST_MAP5                                                  0x8e0
#define mmMC_XPB_RTR_DEST_MAP6                                                  0x8e1
#define mmMC_XPB_RTR_DEST_MAP7                                                  0x8e2
#define mmMC_XPB_RTR_DEST_MAP8                                                  0x8e3
#define mmMC_XPB_RTR_DEST_MAP9                                                  0x8e4
#define mmMC_XPB_XDMA_RTR_DEST_MAP0                                             0x8e5
#define mmMC_XPB_XDMA_RTR_DEST_MAP1                                             0x8e6
#define mmMC_XPB_XDMA_RTR_DEST_MAP2                                             0x8e7
#define mmMC_XPB_XDMA_RTR_DEST_MAP3                                             0x8e8
#define mmMC_XPB_CLG_CFG0                                                       0x8e9
#define mmMC_XPB_CLG_CFG1                                                       0x8ea
#define mmMC_XPB_CLG_CFG2                                                       0x8eb
#define mmMC_XPB_CLG_CFG3                                                       0x8ec
#define mmMC_XPB_CLG_CFG4                                                       0x8ed
#define mmMC_XPB_CLG_CFG5                                                       0x8ee
#define mmMC_XPB_CLG_CFG6                                                       0x8ef
#define mmMC_XPB_CLG_CFG7                                                       0x8f0
#define mmMC_XPB_CLG_CFG8                                                       0x8f1
#define mmMC_XPB_CLG_CFG9                                                       0x8f2
#define mmMC_XPB_CLG_CFG10                                                      0x8f3
#define mmMC_XPB_CLG_CFG11                                                      0x8f4
#define mmMC_XPB_CLG_CFG12                                                      0x8f5
#define mmMC_XPB_CLG_CFG13                                                      0x8f6
#define mmMC_XPB_CLG_CFG14                                                      0x8f7
#define mmMC_XPB_CLG_CFG15                                                      0x8f8
#define mmMC_XPB_CLG_CFG16                                                      0x8f9
#define mmMC_XPB_CLG_CFG17                                                      0x8fa
#define mmMC_XPB_CLG_CFG18                                                      0x8fb
#define mmMC_XPB_CLG_CFG19                                                      0x8fc
#define mmMC_XPB_CLG_EXTRA                                                      0x8fd
#define mmMC_XPB_LB_ADDR                                                        0x8fe
#define mmMC_XPB_UNC_THRESH_HST                                                 0x8ff
#define mmMC_XPB_UNC_THRESH_SID                                                 0x900
#define mmMC_XPB_WCB_STS                                                        0x901
#define mmMC_XPB_WCB_CFG                                                        0x902
#define mmMC_XPB_P2P_BAR_CFG                                                    0x903
#define mmMC_XPB_P2P_BAR0                                                       0x904
#define mmMC_XPB_P2P_BAR1                                                       0x905
#define mmMC_XPB_P2P_BAR2                                                       0x906
#define mmMC_XPB_P2P_BAR3                                                       0x907
#define mmMC_XPB_P2P_BAR4                                                       0x908
#define mmMC_XPB_P2P_BAR5                                                       0x909
#define mmMC_XPB_P2P_BAR6                                                       0x90a
#define mmMC_XPB_P2P_BAR7                                                       0x90b
#define mmMC_XPB_P2P_BAR_SETUP                                                  0x90c
#define mmMC_XPB_P2P_BAR_DEBUG                                                  0x90d
#define mmMC_XPB_P2P_BAR_DELTA_ABOVE                                            0x90e
#define mmMC_XPB_P2P_BAR_DELTA_BELOW                                            0x90f
#define mmMC_XPB_PEER_SYS_BAR0                                                  0x910
#define mmMC_XPB_PEER_SYS_BAR1                                                  0x911
#define mmMC_XPB_PEER_SYS_BAR2                                                  0x912
#define mmMC_XPB_PEER_SYS_BAR3                                                  0x913
#define mmMC_XPB_PEER_SYS_BAR4                                                  0x914
#define mmMC_XPB_PEER_SYS_BAR5                                                  0x915
#define mmMC_XPB_PEER_SYS_BAR6                                                  0x916
#define mmMC_XPB_PEER_SYS_BAR7                                                  0x917
#define mmMC_XPB_PEER_SYS_BAR8                                                  0x918
#define mmMC_XPB_PEER_SYS_BAR9                                                  0x919
#define mmMC_XPB_XDMA_PEER_SYS_BAR0                                             0x91a
#define mmMC_XPB_XDMA_PEER_SYS_BAR1                                             0x91b
#define mmMC_XPB_XDMA_PEER_SYS_BAR2                                             0x91c
#define mmMC_XPB_XDMA_PEER_SYS_BAR3                                             0x91d
#define mmMC_XPB_CLK_GAT                                                        0x91e
#define mmMC_XPB_INTF_CFG                                                       0x91f
#define mmMC_XPB_INTF_STS                                                       0x920
#define mmMC_XPB_PIPE_STS                                                       0x921
#define mmMC_XPB_SUB_CTRL                                                       0x922
#define mmMC_XPB_MAP_INVERT_FLUSH_NUM_LSB                                       0x923
#define mmMC_XPB_PERF_KNOBS                                                     0x924
#define mmMC_XPB_STICKY                                                         0x925
#define mmMC_XPB_STICKY_W1C                                                     0x926
#define mmMC_XPB_MISC_CFG                                                       0x927
#define mmMC_XPB_CLG_CFG20                                                      0x928
#define mmMC_XPB_CLG_CFG21                                                      0x929
#define mmMC_XPB_CLG_CFG22                                                      0x92a
#define mmMC_XPB_CLG_CFG23                                                      0x92b
#define mmMC_XPB_CLG_CFG24                                                      0x92c
#define mmMC_XPB_CLG_CFG25                                                      0x92d
#define mmMC_XPB_CLG_CFG26                                                      0x92e
#define mmMC_XPB_CLG_CFG27                                                      0x92f
#define mmMC_XPB_CLG_CFG28                                                      0x930
#define mmMC_XPB_CLG_CFG29                                                      0x931
#define mmMC_XPB_CLG_CFG30                                                      0x932
#define mmMC_XPB_CLG_CFG31                                                      0x933
#define mmMC_XPB_INTF_CFG2                                                      0x934
#define mmMC_XPB_CLG_EXTRA_RD                                                   0x935
#define mmMC_XPB_CLG_CFG32                                                      0x936
#define mmMC_XPB_CLG_CFG33                                                      0x937
#define mmMC_XPB_CLG_CFG34                                                      0x938
#define mmMC_XPB_CLG_CFG35                                                      0x939
#define mmMC_XPB_CLG_CFG36                                                      0x93a
#define mmMC_XBAR_ADDR_DEC                                                      0xc80
#define mmMC_XBAR_REMOTE                                                        0xc81
#define mmMC_XBAR_WRREQ_CREDIT                                                  0xc82
#define mmMC_XBAR_RDREQ_CREDIT                                                  0xc83
#define mmMC_XBAR_RDREQ_PRI_CREDIT                                              0xc84
#define mmMC_XBAR_WRRET_CREDIT1                                                 0xc85
#define mmMC_XBAR_WRRET_CREDIT2                                                 0xc86
#define mmMC_XBAR_RDRET_CREDIT1                                                 0xc87
#define mmMC_XBAR_RDRET_CREDIT2                                                 0xc88
#define mmMC_XBAR_RDRET_PRI_CREDIT1                                             0xc89
#define mmMC_XBAR_RDRET_PRI_CREDIT2                                             0xc8a
#define mmMC_XBAR_CHTRIREMAP                                                    0xc8b
#define mmMC_XBAR_TWOCHAN                                                       0xc8c
#define mmMC_XBAR_ARB                                                           0xc8d
#define mmMC_XBAR_ARB_MAX_BURST                                                 0xc8e
#define mmMC_XBAR_FIFO_MON_CNTL0                                                0xc8f
#define mmMC_XBAR_FIFO_MON_CNTL1                                                0xc90
#define mmMC_XBAR_FIFO_MON_CNTL2                                                0xc91
#define mmMC_XBAR_FIFO_MON_RSLT0                                                0xc92
#define mmMC_XBAR_FIFO_MON_RSLT1                                                0xc93
#define mmMC_XBAR_FIFO_MON_RSLT2                                                0xc94
#define mmMC_XBAR_FIFO_MON_RSLT3                                                0xc95
#define mmMC_XBAR_FIFO_MON_MAX_THSH                                             0xc96
#define mmMC_XBAR_SPARE0                                                        0xc97
#define mmMC_XBAR_SPARE1                                                        0xc98
#define mmMC_CITF_PERFCOUNTER_LO                                                0x7a0
#define mmMC_HUB_PERFCOUNTER_LO                                                 0x7a1
#define mmMC_RPB_PERFCOUNTER_LO                                                 0x7a2
#define mmMC_MCBVM_PERFCOUNTER_LO                                               0x7a3
#define mmMC_MCDVM_PERFCOUNTER_LO                                               0x7a4
#define mmMC_VM_L2_PERFCOUNTER_LO                                               0x7a5
#define mmMC_ARB_PERFCOUNTER_LO                                                 0x7a6
#define mmATC_PERFCOUNTER_LO                                                    0x7a7
#define mmMC_CITF_PERFCOUNTER_HI                                                0x7a8
#define mmMC_HUB_PERFCOUNTER_HI                                                 0x7a9
#define mmMC_MCBVM_PERFCOUNTER_HI                                               0x7aa
#define mmMC_MCDVM_PERFCOUNTER_HI                                               0x7ab
#define mmMC_RPB_PERFCOUNTER_HI                                                 0x7ac
#define mmMC_VM_L2_PERFCOUNTER_HI                                               0x7ad
#define mmMC_ARB_PERFCOUNTER_HI                                                 0x7ae
#define mmATC_PERFCOUNTER_HI                                                    0x7af
#define mmMC_CITF_PERFCOUNTER0_CFG                                              0x7b0
#define mmMC_CITF_PERFCOUNTER1_CFG                                              0x7b1
#define mmMC_CITF_PERFCOUNTER2_CFG                                              0x7b2
#define mmMC_CITF_PERFCOUNTER3_CFG                                              0x7b3
#define mmMC_HUB_PERFCOUNTER0_CFG                                               0x7b4
#define mmMC_HUB_PERFCOUNTER1_CFG                                               0x7b5
#define mmMC_HUB_PERFCOUNTER2_CFG                                               0x7b6
#define mmMC_HUB_PERFCOUNTER3_CFG                                               0x7b7
#define mmMC_RPB_PERFCOUNTER0_CFG                                               0x7b8
#define mmMC_RPB_PERFCOUNTER1_CFG                                               0x7b9
#define mmMC_RPB_PERFCOUNTER2_CFG                                               0x7ba
#define mmMC_RPB_PERFCOUNTER3_CFG                                               0x7bb
#define mmMC_ARB_PERFCOUNTER0_CFG                                               0x7bc
#define mmMC_ARB_PERFCOUNTER1_CFG                                               0x7bd
#define mmMC_ARB_PERFCOUNTER2_CFG                                               0x7be
#define mmMC_ARB_PERFCOUNTER3_CFG                                               0x7bf
#define mmMC_MCBVM_PERFCOUNTER0_CFG                                             0x7c0
#define mmMC_MCBVM_PERFCOUNTER1_CFG                                             0x7c1
#define mmMC_MCBVM_PERFCOUNTER2_CFG                                             0x7c2
#define mmMC_MCBVM_PERFCOUNTER3_CFG                                             0x7c3
#define mmMC_MCDVM_PERFCOUNTER0_CFG                                             0x7c4
#define mmMC_MCDVM_PERFCOUNTER1_CFG                                             0x7c5
#define mmMC_MCDVM_PERFCOUNTER2_CFG                                             0x7c6
#define mmMC_MCDVM_PERFCOUNTER3_CFG                                             0x7c7
#define mmATC_PERFCOUNTER0_CFG                                                  0x7c8
#define mmATC_PERFCOUNTER1_CFG                                                  0x7c9
#define mmATC_PERFCOUNTER2_CFG                                                  0x7ca
#define mmATC_PERFCOUNTER3_CFG                                                  0x7cb
#define mmMC_VM_L2_PERFCOUNTER0_CFG                                             0x7cc
#define mmMC_VM_L2_PERFCOUNTER1_CFG                                             0x7cd
#define mmMC_CITF_PERFCOUNTER_RSLT_CNTL                                         0x7ce
#define mmMC_HUB_PERFCOUNTER_RSLT_CNTL                                          0x7cf
#define mmMC_RPB_PERFCOUNTER_RSLT_CNTL                                          0x7d0
#define mmMC_MCBVM_PERFCOUNTER_RSLT_CNTL                                        0x7d1
#define mmMC_MCDVM_PERFCOUNTER_RSLT_CNTL                                        0x7d2
#define mmMC_VM_L2_PERFCOUNTER_RSLT_CNTL                                        0x7d3
#define mmMC_ARB_PERFCOUNTER_RSLT_CNTL                                          0x7d4
#define mmATC_PERFCOUNTER_RSLT_CNTL                                             0x7d5
#define mmCHUB_ATC_PERFCOUNTER_LO                                               0x7d6
#define mmCHUB_ATC_PERFCOUNTER_HI                                               0x7d7
#define mmCHUB_ATC_PERFCOUNTER0_CFG                                             0x7d8
#define mmCHUB_ATC_PERFCOUNTER1_CFG                                             0x7d9
#define mmCHUB_ATC_PERFCOUNTER_RSLT_CNTL                                        0x7da
#define mmATC_VM_APERTURE0_LOW_ADDR                                             0xcc0
#define mmATC_VM_APERTURE1_LOW_ADDR                                             0xcc1
#define mmATC_VM_APERTURE0_HIGH_ADDR                                            0xcc2
#define mmATC_VM_APERTURE1_HIGH_ADDR                                            0xcc3
#define mmATC_VM_APERTURE0_CNTL                                                 0xcc4
#define mmATC_VM_APERTURE1_CNTL                                                 0xcc5
#define mmATC_VM_APERTURE0_CNTL2                                                0xcc6
#define mmATC_VM_APERTURE1_CNTL2                                                0xcc7
#define mmATC_ATS_CNTL                                                          0xcc9
#define mmATC_ATS_DEBUG                                                         0xcca
#define mmATC_ATS_FAULT_DEBUG                                                   0xccb
#define mmATC_ATS_STATUS                                                        0xccc
#define mmATC_ATS_FAULT_CNTL                                                    0xccd
#define mmATC_ATS_FAULT_STATUS_INFO                                             0xcce
#define mmATC_ATS_FAULT_STATUS_ADDR                                             0xccf
#define mmATC_ATS_DEFAULT_PAGE_LOW                                              0xcd0
#define mmATC_ATS_DEFAULT_PAGE_CNTL                                             0xcd1
#define mmATC_ATS_FAULT_STATUS_INFO2                                            0xcd2
#define mmATC_MISC_CG                                                           0xcd4
#define mmATC_L2_CNTL                                                           0xcd5
#define mmATC_L2_CNTL2                                                          0xcd6
#define mmATC_L2_DEBUG                                                          0xcd7
#define mmATC_L2_DEBUG2                                                         0xcd8
#define mmATC_L2_CACHE_DATA0                                                    0xcd9
#define mmATC_L2_CACHE_DATA1                                                    0xcda
#define mmATC_L2_CACHE_DATA2                                                    0xcdb
#define mmATC_L1_CNTL                                                           0xcdc
#define mmATC_L1_ADDRESS_OFFSET                                                 0xcdd
#define mmATC_L1RD_DEBUG_TLB                                                    0xcde
#define mmATC_L1WR_DEBUG_TLB                                                    0xcdf
#define mmATC_L1RD_STATUS                                                       0xce0
#define mmATC_L1WR_STATUS                                                       0xce1
#define mmATC_L1RD_DEBUG2_TLB                                                   0xce2
#define mmATC_L1WR_DEBUG2_TLB                                                   0xce3
#define mmATC_VMID_PASID_MAPPING_UPDATE_STATUS                                  0xce6
#define mmATC_VMID0_PASID_MAPPING                                               0xce7
#define mmATC_VMID1_PASID_MAPPING                                               0xce8
#define mmATC_VMID2_PASID_MAPPING                                               0xce9
#define mmATC_VMID3_PASID_MAPPING                                               0xcea
#define mmATC_VMID4_PASID_MAPPING                                               0xceb
#define mmATC_VMID5_PASID_MAPPING                                               0xcec
#define mmATC_VMID6_PASID_MAPPING                                               0xced
#define mmATC_VMID7_PASID_MAPPING                                               0xcee
#define mmATC_VMID8_PASID_MAPPING                                               0xcef
#define mmATC_VMID9_PASID_MAPPING                                               0xcf0
#define mmATC_VMID10_PASID_MAPPING                                              0xcf1
#define mmATC_VMID11_PASID_MAPPING                                              0xcf2
#define mmATC_VMID12_PASID_MAPPING                                              0xcf3
#define mmATC_VMID13_PASID_MAPPING                                              0xcf4
#define mmATC_VMID14_PASID_MAPPING                                              0xcf5
#define mmATC_VMID15_PASID_MAPPING                                              0xcf6
#define mmATC_ATS_VMID_STATUS                                                   0xd07
#define mmATC_ATS_SMU_STATUS                                                    0xd08
#define mmATC_L2_CNTL3                                                          0xd09
#define mmATC_L2_STATUS                                                         0xd0a
#define mmATC_L2_STATUS2                                                        0xd0b
#define mmGMCON_RENG_RAM_INDEX                                                  0xd40
#define mmGMCON_RENG_RAM_DATA                                                   0xd41
#define mmGMCON_RENG_EXECUTE                                                    0xd42
#define mmGMCON_MISC                                                            0xd43
#define mmGMCON_MISC2                                                           0xd44
#define mmGMCON_STCTRL_REGISTER_SAVE_RANGE0                                     0xd45
#define mmGMCON_STCTRL_REGISTER_SAVE_RANGE1                                     0xd46
#define mmGMCON_STCTRL_REGISTER_SAVE_RANGE2                                     0xd47
#define mmGMCON_STCTRL_REGISTER_SAVE_EXCL_SET0                                  0xd48
#define mmGMCON_STCTRL_REGISTER_SAVE_EXCL_SET1                                  0xd49
#define mmGMCON_PERF_MON_CNTL0                                                  0xd4a
#define mmGMCON_PERF_MON_CNTL1                                                  0xd4b
#define mmGMCON_PERF_MON_RSLT0                                                  0xd4c
#define mmGMCON_PERF_MON_RSLT1                                                  0xd4d
#define mmGMCON_PGFSM_CONFIG                                                    0xd4e
#define mmGMCON_PGFSM_WRITE                                                     0xd4f
#define mmGMCON_PGFSM_READ                                                      0xd50
#define mmGMCON_MISC3                                                           0xd51
#define mmGMCON_MASK                                                            0xd52
#define mmGMCON_LPT_TARGET                                                      0xd53
#define mmGMCON_DEBUG                                                           0xd5f
#define mmVM_L2_CNTL                                                            0x500
#define mmVM_L2_CNTL2                                                           0x501
#define mmVM_L2_CNTL3                                                           0x502
#define mmVM_L2_STATUS                                                          0x503
#define mmVM_CONTEXT0_CNTL                                                      0x504
#define mmVM_CONTEXT1_CNTL                                                      0x505
#define mmVM_DUMMY_PAGE_FAULT_CNTL                                              0x506
#define mmVM_DUMMY_PAGE_FAULT_ADDR                                              0x507
#define mmVM_CONTEXT0_CNTL2                                                     0x50c
#define mmVM_CONTEXT1_CNTL2                                                     0x50d
#define mmVM_CONTEXT8_PAGE_TABLE_BASE_ADDR                                      0x50e
#define mmVM_CONTEXT9_PAGE_TABLE_BASE_ADDR                                      0x50f
#define mmVM_CONTEXT10_PAGE_TABLE_BASE_ADDR                                     0x510
#define mmVM_CONTEXT11_PAGE_TABLE_BASE_ADDR                                     0x511
#define mmVM_CONTEXT12_PAGE_TABLE_BASE_ADDR                                     0x512
#define mmVM_CONTEXT13_PAGE_TABLE_BASE_ADDR                                     0x513
#define mmVM_CONTEXT14_PAGE_TABLE_BASE_ADDR                                     0x514
#define mmVM_CONTEXT15_PAGE_TABLE_BASE_ADDR                                     0x515
#define mmVM_INVALIDATE_REQUEST                                                 0x51e
#define mmVM_INVALIDATE_RESPONSE                                                0x51f
#define mmVM_PRT_APERTURE0_LOW_ADDR                                             0x52c
#define mmVM_PRT_APERTURE1_LOW_ADDR                                             0x52d
#define mmVM_PRT_APERTURE2_LOW_ADDR                                             0x52e
#define mmVM_PRT_APERTURE3_LOW_ADDR                                             0x52f
#define mmVM_PRT_APERTURE0_HIGH_ADDR                                            0x530
#define mmVM_PRT_APERTURE1_HIGH_ADDR                                            0x531
#define mmVM_PRT_APERTURE2_HIGH_ADDR                                            0x532
#define mmVM_PRT_APERTURE3_HIGH_ADDR                                            0x533
#define mmVM_PRT_CNTL                                                           0x534
#define mmVM_CONTEXTS_DISABLE                                                   0x535
#define mmVM_CONTEXT0_PROTECTION_FAULT_STATUS                                   0x536
#define mmVM_CONTEXT1_PROTECTION_FAULT_STATUS                                   0x537
#define mmVM_CONTEXT0_PROTECTION_FAULT_MCCLIENT                                 0x538
#define mmVM_CONTEXT1_PROTECTION_FAULT_MCCLIENT                                 0x539
#define mmVM_CONTEXT0_PROTECTION_FAULT_ADDR                                     0x53e
#define mmVM_CONTEXT1_PROTECTION_FAULT_ADDR                                     0x53f
#define mmVM_CONTEXT0_PROTECTION_FAULT_DEFAULT_ADDR                             0x546
#define mmVM_CONTEXT1_PROTECTION_FAULT_DEFAULT_ADDR                             0x547
#define mmVM_FAULT_CLIENT_ID                                                    0x54e
#define mmVM_CONTEXT0_PAGE_TABLE_BASE_ADDR                                      0x54f
#define mmVM_CONTEXT1_PAGE_TABLE_BASE_ADDR                                      0x550
#define mmVM_CONTEXT2_PAGE_TABLE_BASE_ADDR                                      0x551
#define mmVM_CONTEXT3_PAGE_TABLE_BASE_ADDR                                      0x552
#define mmVM_CONTEXT4_PAGE_TABLE_BASE_ADDR                                      0x553
#define mmVM_CONTEXT5_PAGE_TABLE_BASE_ADDR                                      0x554
#define mmVM_CONTEXT6_PAGE_TABLE_BASE_ADDR                                      0x555
#define mmVM_CONTEXT7_PAGE_TABLE_BASE_ADDR                                      0x556
#define mmVM_CONTEXT0_PAGE_TABLE_START_ADDR                                     0x557
#define mmVM_CONTEXT1_PAGE_TABLE_START_ADDR                                     0x558
#define mmVM_CONTEXT0_PAGE_TABLE_END_ADDR                                       0x55f
#define mmVM_CONTEXT1_PAGE_TABLE_END_ADDR                                       0x560
#define mmVM_DEBUG                                                              0x56f
#define mmVM_L2_CG                                                              0x570
#define mmVM_L2_BANK_SELECT_MASKA                                               0x572
#define mmVM_L2_BANK_SELECT_MASKB                                               0x573
#define mmVM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR                             0x575
#define mmVM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR                            0x576
#define mmVM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET                                0x577
#define mmVM_L2_CNTL4                                                           0x578
#define mmVM_L2_BANK_SELECT_RESERVED_CID                                        0x579
#define mmVM_L2_BANK_SELECT_RESERVED_CID2                                       0x57a
#define mmMC_VM_FB_SIZE_OFFSET_VF0                                              0xf980
#define mmMC_VM_FB_SIZE_OFFSET_VF1                                              0xf981
#define mmMC_VM_FB_SIZE_OFFSET_VF2                                              0xf982
#define mmMC_VM_FB_SIZE_OFFSET_VF3                                              0xf983
#define mmMC_VM_FB_SIZE_OFFSET_VF4                                              0xf984
#define mmMC_VM_FB_SIZE_OFFSET_VF5                                              0xf985
#define mmMC_VM_FB_SIZE_OFFSET_VF6                                              0xf986
#define mmMC_VM_FB_SIZE_OFFSET_VF7                                              0xf987
#define mmMC_VM_FB_SIZE_OFFSET_VF8                                              0xf988
#define mmMC_VM_FB_SIZE_OFFSET_VF9                                              0xf989
#define mmMC_VM_FB_SIZE_OFFSET_VF10                                             0xf98a
#define mmMC_VM_FB_SIZE_OFFSET_VF11                                             0xf98b
#define mmMC_VM_FB_SIZE_OFFSET_VF12                                             0xf98c
#define mmMC_VM_FB_SIZE_OFFSET_VF13                                             0xf98d
#define mmMC_VM_FB_SIZE_OFFSET_VF14                                             0xf98e
#define mmMC_VM_FB_SIZE_OFFSET_VF15                                             0xf98f
#define mmMC_VM_NB_MMIOBASE                                                     0xf990
#define mmMC_VM_NB_MMIOLIMIT                                                    0xf991
#define mmMC_VM_NB_PCI_CTRL                                                     0xf992
#define mmMC_VM_NB_PCI_ARB                                                      0xf993
#define mmMC_VM_NB_TOP_OF_DRAM_SLOT1                                            0xf994
#define mmMC_VM_NB_LOWER_TOP_OF_DRAM2                                           0xf995
#define mmMC_VM_NB_UPPER_TOP_OF_DRAM2                                           0xf996
#define mmMC_VM_NB_TOP_OF_DRAM3                                                 0xf997
#define mmMC_VM_MARC_BASE_LO_0                                                  0xf998
#define mmMC_VM_MARC_BASE_LO_1                                                  0xf99e
#define mmMC_VM_MARC_BASE_LO_2                                                  0xf9a4
#define mmMC_VM_MARC_BASE_LO_3                                                  0xf9aa
#define mmMC_VM_MARC_BASE_HI_0                                                  0xf999
#define mmMC_VM_MARC_BASE_HI_1                                                  0xf99f
#define mmMC_VM_MARC_BASE_HI_2                                                  0xf9a5
#define mmMC_VM_MARC_BASE_HI_3                                                  0xf9ab
#define mmMC_VM_MARC_RELOC_LO_0                                                 0xf99a
#define mmMC_VM_MARC_RELOC_LO_1                                                 0xf9a0
#define mmMC_VM_MARC_RELOC_LO_2                                                 0xf9a6
#define mmMC_VM_MARC_RELOC_LO_3                                                 0xf9ac
#define mmMC_VM_MARC_RELOC_HI_0                                                 0xf99b
#define mmMC_VM_MARC_RELOC_HI_1                                                 0xf9a1
#define mmMC_VM_MARC_RELOC_HI_2                                                 0xf9a7
#define mmMC_VM_MARC_RELOC_HI_3                                                 0xf9ad
#define mmMC_VM_MARC_LEN_LO_0                                                   0xf99c
#define mmMC_VM_MARC_LEN_LO_1                                                   0xf9a2
#define mmMC_VM_MARC_LEN_LO_2                                                   0xf9a8
#define mmMC_VM_MARC_LEN_LO_3                                                   0xf9ae
#define mmMC_VM_MARC_LEN_HI_0                                                   0xf99d
#define mmMC_VM_MARC_LEN_HI_1                                                   0xf9a3
#define mmMC_VM_MARC_LEN_HI_2                                                   0xf9a9
#define mmMC_VM_MARC_LEN_HI_3                                                   0xf9af
#define mmMC_VM_MARC_CNTL                                                       0xf9b0
#define mmMC_VM_MB_L1_TLS0_CNTL0                                                0xf9b1
#define mmMC_VM_MB_L1_TLS0_CNTL1                                                0xf9b4
#define mmMC_VM_MB_L1_TLS0_CNTL2                                                0xf9b7
#define mmMC_VM_MB_L1_TLS0_CNTL3                                                0xf9ba
#define mmMC_VM_MB_L1_TLS0_CNTL4                                                0xf9bd
#define mmMC_VM_MB_L1_TLS0_CNTL5                                                0xf9c0
#define mmMC_VM_MB_L1_TLS0_CNTL6                                                0xf9c3
#define mmMC_VM_MB_L1_TLS0_CNTL7                                                0xf9c6
#define mmMC_VM_MB_L1_TLS0_CNTL8                                                0xf9c9
#define mmMC_VM_MB_L1_TLS0_START_ADDR0                                          0xf9b2
#define mmMC_VM_MB_L1_TLS0_START_ADDR1                                          0xf9b5
#define mmMC_VM_MB_L1_TLS0_START_ADDR2                                          0xf9b8
#define mmMC_VM_MB_L1_TLS0_START_ADDR3                                          0xf9bb
#define mmMC_VM_MB_L1_TLS0_START_ADDR4                                          0xf9be
#define mmMC_VM_MB_L1_TLS0_START_ADDR5                                          0xf9c1
#define mmMC_VM_MB_L1_TLS0_START_ADDR6                                          0xf9c4
#define mmMC_VM_MB_L1_TLS0_START_ADDR7                                          0xf9c7
#define mmMC_VM_MB_L1_TLS0_START_ADDR8                                          0xf9ca
#define mmMC_VM_MB_L1_TLS0_END_ADDR0                                            0xf9b3
#define mmMC_VM_MB_L1_TLS0_END_ADDR1                                            0xf9b6
#define mmMC_VM_MB_L1_TLS0_END_ADDR2                                            0xf9b9
#define mmMC_VM_MB_L1_TLS0_END_ADDR3                                            0xf9bc
#define mmMC_VM_MB_L1_TLS0_END_ADDR4                                            0xf9bf
#define mmMC_VM_MB_L1_TLS0_END_ADDR5                                            0xf9c2
#define mmMC_VM_MB_L1_TLS0_END_ADDR6                                            0xf9c5
#define mmMC_VM_MB_L1_TLS0_END_ADDR7                                            0xf9c8
#define mmMC_VM_MB_L1_TLS0_END_ADDR8                                            0xf9cb
#define mmMC_VM_MB_L1_TLS0_PROTECTION_FAULT_STATUS                              0xf9cc
#define mmMC_VM_MB_L1_TLS0_PROTECTION_FAULT_ADDR                                0xf9cd
#define mmMC_SEQ_CNTL                                                           0xa25
#define mmMC_SEQ_CNTL_2                                                         0xad4
#define mmMC_SEQ_DRAM                                                           0xa26
#define mmMC_SEQ_DRAM_2                                                         0xa27
#define mmMC_SEQ_RAS_TIMING                                                     0xa28
#define mmMC_SEQ_CAS_TIMING                                                     0xa29
#define mmMC_SEQ_MISC_TIMING                                                    0xa2a
#define mmMC_SEQ_MISC_TIMING2                                                   0xa2b
#define mmMC_SEQ_PMG_TIMING                                                     0xa2c
#define mmMC_SEQ_RD_CTL_D0                                                      0xa2d
#define mmMC_SEQ_RD_CTL_D1                                                      0xa2e
#define mmMC_SEQ_WR_CTL_D0                                                      0xa2f
#define mmMC_SEQ_WR_CTL_D1                                                      0xa30
#define mmMC_SEQ_WR_CTL_2                                                       0xad5
#define mmMC_SEQ_CMD                                                            0xa31
#define mmMC_PMG_CMD_EMRS                                                       0xa83
#define mmMC_PMG_CMD_MRS                                                        0xaab
#define mmMC_PMG_CMD_MRS1                                                       0xad1
#define mmMC_PMG_CMD_MRS2                                                       0xad7
#define mmMC_PMG_CFG                                                            0xa84
#define mmMC_PMG_AUTO_CMD                                                       0xa34
#define mmMC_PMG_AUTO_CFG                                                       0xa35
#define mmMC_IMP_CNTL                                                           0xa36
#define mmMC_IMP_DEBUG                                                          0xa37
#define mmMC_IMP_STATUS                                                         0xa38
#define mmMC_IMP_DQ_STATUS                                                      0xabc
#define mmMC_SEQ_WCDR_CTRL                                                      0xa39
#define mmMC_SEQ_TRAIN_WAKEUP_CNTL                                              0xa3a
#define mmMC_SEQ_TRAIN_EDC_THRESHOLD                                            0xa3b
#define mmMC_SEQ_TRAIN_EDC_THRESHOLD2                                           0xafe
#define mmMC_SEQ_TRAIN_EDC_THRESHOLD3                                           0xaff
#define mmMC_SEQ_TRAIN_WAKEUP_EDGE                                              0xa3c
#define mmMC_SEQ_TRAIN_WAKEUP_MASK                                              0xa3d
#define mmMC_SEQ_TRAIN_CAPTURE                                                  0xa3e
#define mmMC_SEQ_TRAIN_WAKEUP_CLEAR                                             0xa3f
#define mmMC_SEQ_TRAIN_TIMING                                                   0xa40
#define mmMC_TRAIN_EDCCDR_R_D0                                                  0xa41
#define mmMC_TRAIN_EDCCDR_R_D1                                                  0xa42
#define mmMC_TRAIN_PRBSERR_0_D0                                                 0xa43
#define mmMC_TRAIN_PRBSERR_1_D0                                                 0xa44
#define mmMC_TRAIN_PRBSERR_2_D0                                                 0xafb
#define mmMC_TRAIN_EDC_STATUS_D0                                                0xa45
#define mmMC_TRAIN_PRBSERR_0_D1                                                 0xa46
#define mmMC_TRAIN_PRBSERR_1_D1                                                 0xa47
#define mmMC_TRAIN_PRBSERR_2_D1                                                 0xafc
#define mmMC_TRAIN_EDC_STATUS_D1                                                0xa48
#define mmMC_IO_TXCNTL_DPHY0_D0                                                 0xa49
#define mmMC_IO_TXCNTL_DPHY1_D0                                                 0xa4a
#define mmMC_IO_TXCNTL_APHY_D0                                                  0xa4b
#define mmMC_IO_RXCNTL_DPHY0_D0                                                 0xa4c
#define mmMC_IO_RXCNTL1_DPHY0_D0                                                0xadf
#define mmMC_IO_RXCNTL_DPHY1_D0                                                 0xa4d
#define mmMC_IO_RXCNTL1_DPHY1_D0                                                0xae0
#define mmMC_IO_DPHY_STR_CNTL_D0                                                0xa4e
#define mmMC_IO_APHY_STR_CNTL_D0                                                0xa97
#define mmMC_IO_TXCNTL_DPHY0_D1                                                 0xa4f
#define mmMC_IO_TXCNTL_DPHY1_D1                                                 0xa50
#define mmMC_IO_TXCNTL_APHY_D1                                                  0xa51
#define mmMC_IO_RXCNTL_DPHY0_D1                                                 0xa52
#define mmMC_IO_RXCNTL1_DPHY0_D1                                                0xae1
#define mmMC_IO_RXCNTL_DPHY1_D1                                                 0xa53
#define mmMC_IO_RXCNTL1_DPHY1_D1                                                0xae2
#define mmMC_IO_DPHY_STR_CNTL_D1                                                0xa54
#define mmMC_IO_APHY_STR_CNTL_D1                                                0xa98
#define mmMC_IO_CDRCNTL_D0                                                      0xa55
#define mmMC_IO_CDRCNTL1_D0                                                     0xadd
#define mmMC_IO_CDRCNTL2_D0                                                     0xae4
#define mmMC_IO_CDRCNTL_D1                                                      0xa56
#define mmMC_IO_CDRCNTL1_D1                                                     0xade
#define mmMC_IO_CDRCNTL2_D1                                                     0xae5
#define mmMC_SEQ_FIFO_CTL                                                       0xa57
#define mmMC_SEQ_TXFRAMING_BYTE0_D0                                             0xa58
#define mmMC_SEQ_TXFRAMING_BYTE1_D0                                             0xa59
#define mmMC_SEQ_TXFRAMING_BYTE2_D0                                             0xa5a
#define mmMC_SEQ_TXFRAMING_BYTE3_D0                                             0xa5b
#define mmMC_SEQ_TXFRAMING_DBI_D0                                               0xa5c
#define mmMC_SEQ_TXFRAMING_EDC_D0                                               0xa5d
#define mmMC_SEQ_TXFRAMING_FCK_D0                                               0xa5e
#define mmMC_SEQ_TXFRAMING_BYTE0_D1                                             0xa60
#define mmMC_SEQ_TXFRAMING_BYTE1_D1                                             0xa61
#define mmMC_SEQ_TXFRAMING_BYTE2_D1                                             0xa62
#define mmMC_SEQ_TXFRAMING_BYTE3_D1                                             0xa63
#define mmMC_SEQ_TXFRAMING_DBI_D1                                               0xa64
#define mmMC_SEQ_TXFRAMING_EDC_D1                                               0xa65
#define mmMC_SEQ_TXFRAMING_FCK_D1                                               0xa66
#define mmMC_SEQ_RXFRAMING_BYTE0_D0                                             0xa67
#define mmMC_SEQ_RXFRAMING_BYTE1_D0                                             0xa68
#define mmMC_SEQ_RXFRAMING_BYTE2_D0                                             0xa69
#define mmMC_SEQ_RXFRAMING_BYTE3_D0                                             0xa6a
#define mmMC_SEQ_RXFRAMING_DBI_D0                                               0xa6b
#define mmMC_SEQ_RXFRAMING_EDC_D0                                               0xa6c
#define mmMC_SEQ_RXFRAMING_BYTE0_D1                                             0xa6d
#define mmMC_SEQ_RXFRAMING_BYTE1_D1                                             0xa6e
#define mmMC_SEQ_RXFRAMING_BYTE2_D1                                             0xa6f
#define mmMC_SEQ_RXFRAMING_BYTE3_D1                                             0xa70
#define mmMC_SEQ_RXFRAMING_DBI_D1                                               0xa71
#define mmMC_SEQ_RXFRAMING_EDC_D1                                               0xa72
#define mmMC_IO_PAD_CNTL                                                        0xa73
#define mmMC_IO_PAD_CNTL_D0                                                     0xa74
#define mmMC_IO_PAD_CNTL_D1                                                     0xa75
#define mmMC_NPL_STATUS                                                         0xa76
#define mmMC_BIST_CMD_CNTL                                                      0xa8e
#define mmMC_BIST_CNTL                                                          0xa05
#define mmMC_BIST_AUTO_CNTL                                                     0xa06
#define mmMC_BIST_DIR_CNTL                                                      0xa07
#define mmMC_BIST_SADDR                                                         0xa08
#define mmMC_BIST_EADDR                                                         0xa09
#define mmMC_BIST_CMP_CNTL                                                      0xa8d
#define mmMC_BIST_CMP_CNTL_2                                                    0xab6
#define mmMC_BIST_DATA_WORD0                                                    0xa0a
#define mmMC_BIST_DATA_WORD1                                                    0xa0b
#define mmMC_BIST_DATA_WORD2                                                    0xa0c
#define mmMC_BIST_DATA_WORD3                                                    0xa0d
#define mmMC_BIST_DATA_WORD4                                                    0xa0e
#define mmMC_BIST_DATA_WORD5                                                    0xa0f
#define mmMC_BIST_DATA_WORD6                                                    0xa10
#define mmMC_BIST_DATA_WORD7                                                    0xa11
#define mmMC_BIST_DATA_MASK                                                     0xa12
#define mmMC_BIST_MISMATCH_ADDR                                                 0xa13
#define mmMC_BIST_RDATA_WORD0                                                   0xa14
#define mmMC_BIST_RDATA_WORD1                                                   0xa15
#define mmMC_BIST_RDATA_WORD2                                                   0xa16
#define mmMC_BIST_RDATA_WORD3                                                   0xa17
#define mmMC_BIST_RDATA_WORD4                                                   0xa18
#define mmMC_BIST_RDATA_WORD5                                                   0xa19
#define mmMC_BIST_RDATA_WORD6                                                   0xa1a
#define mmMC_BIST_RDATA_WORD7                                                   0xa1b
#define mmMC_BIST_RDATA_MASK                                                    0xa1c
#define mmMC_BIST_RDATA_EDC                                                     0xa1d
#define mmMC_SEQ_PERF_CNTL                                                      0xa77
#define mmMC_SEQ_PERF_CNTL_1                                                    0xafd
#define mmMC_SEQ_PERF_SEQ_CTL                                                   0xa78
#define mmMC_SEQ_PERF_SEQ_CNT_A_I0                                              0xa79
#define mmMC_SEQ_PERF_SEQ_CNT_A_I1                                              0xa7a
#define mmMC_SEQ_PERF_SEQ_CNT_B_I0                                              0xa7b
#define mmMC_SEQ_PERF_SEQ_CNT_B_I1                                              0xa7c
#define mmMC_SEQ_PERF_SEQ_CNT_C_I0                                              0xad9
#define mmMC_SEQ_PERF_SEQ_CNT_C_I1                                              0xada
#define mmMC_SEQ_PERF_SEQ_CNT_D_I0                                              0xadb
#define mmMC_SEQ_PERF_SEQ_CNT_D_I1                                              0xadc
#define mmMC_SEQ_STATUS_M                                                       0xa7d
#define mmMC_SEQ_STATUS_S                                                       0xa20
#define mmMC_CG_DATAPORT                                                        0xa21
#define mmMC_SEQ_VENDOR_ID_I0                                                   0xa7e
#define mmMC_SEQ_VENDOR_ID_I1                                                   0xa7f
#define mmMC_SEQ_MISC0                                                          0xa80
#define mmMC_SEQ_MISC1                                                          0xa81
#define mmMC_SEQ_RESERVE_0_S                                                    0xa1e
#define mmMC_SEQ_RESERVE_1_S                                                    0xa1f
#define mmMC_SEQ_RESERVE_M                                                      0xa82
#define mmMC_SEQ_IO_RESERVE_D0                                                  0xab7
#define mmMC_SEQ_IO_RESERVE_D1                                                  0xab8
#define mmMC_SEQ_SUP_CNTL                                                       0xa32
#define mmMC_SEQ_SUP_PGM                                                        0xa33
#define mmMC_SEQ_SUP_GP0_STAT                                                   0xa8f
#define mmMC_SEQ_SUP_GP1_STAT                                                   0xa90
#define mmMC_SEQ_SUP_GP2_STAT                                                   0xa85
#define mmMC_SEQ_SUP_GP3_STAT                                                   0xa86
#define mmMC_SEQ_SUP_IR_STAT                                                    0xa87
#define mmMC_SEQ_SUP_DEC_STAT                                                   0xa88
#define mmMC_SEQ_SUP_PGM_STAT                                                   0xa89
#define mmMC_SEQ_SUP_R_PGM                                                      0xa8a
#define mmMC_SEQ_MISC3                                                          0xa8b
#define mmMC_SEQ_MISC4                                                          0xa8c
#define mmMC_SEQ_MISC5                                                          0xa95
#define mmMC_SEQ_MISC6                                                          0xa96
#define mmMC_SEQ_MISC7                                                          0xa99
#define mmMC_SEQ_MISC8                                                          0xa5f
#define mmMC_SEQ_MISC9                                                          0xae7
#define mmMC_SEQ_CG                                                             0xa9a
#define mmMC_SEQ_BYTE_REMAP_D0                                                  0xa93
#define mmMC_SEQ_BYTE_REMAP_D1                                                  0xa94
#define mmMC_SEQ_BIT_REMAP_B0_D0                                                0xaa3
#define mmMC_SEQ_BIT_REMAP_B1_D0                                                0xaa4
#define mmMC_SEQ_BIT_REMAP_B2_D0                                                0xaa5
#define mmMC_SEQ_BIT_REMAP_B3_D0                                                0xaa6
#define mmMC_SEQ_BIT_REMAP_B0_D1                                                0xaa7
#define mmMC_SEQ_BIT_REMAP_B1_D1                                                0xaa8
#define mmMC_SEQ_BIT_REMAP_B2_D1                                                0xaa9
#define mmMC_SEQ_BIT_REMAP_B3_D1                                                0xaaa
#define mmMC_SEQ_RAS_TIMING_LP                                                  0xa9b
#define mmMC_SEQ_CAS_TIMING_LP                                                  0xa9c
#define mmMC_SEQ_MISC_TIMING_LP                                                 0xa9d
#define mmMC_SEQ_MISC_TIMING2_LP                                                0xa9e
#define mmMC_SEQ_RD_CTL_D0_LP                                                   0xac7
#define mmMC_SEQ_RD_CTL_D1_LP                                                   0xac8
#define mmMC_SEQ_WR_CTL_D0_LP                                                   0xa9f
#define mmMC_SEQ_WR_CTL_D1_LP                                                   0xaa0
#define mmMC_SEQ_WR_CTL_2_LP                                                    0xad6
#define mmMC_SEQ_PMG_CMD_EMRS_LP                                                0xaa1
#define mmMC_SEQ_PMG_CMD_MRS_LP                                                 0xaa2
#define mmMC_SEQ_PMG_CMD_MRS1_LP                                                0xad2
#define mmMC_SEQ_PMG_CMD_MRS2_LP                                                0xad8
#define mmMC_SEQ_PMG_TIMING_LP                                                  0xad3
#define mmMC_SEQ_IO_RWORD0                                                      0xaac
#define mmMC_SEQ_IO_RWORD1                                                      0xaad
#define mmMC_SEQ_IO_RWORD2                                                      0xaae
#define mmMC_SEQ_IO_RWORD3                                                      0xaaf
#define mmMC_SEQ_IO_RWORD4                                                      0xab0
#define mmMC_SEQ_IO_RWORD5                                                      0xab1
#define mmMC_SEQ_IO_RWORD6                                                      0xab2
#define mmMC_SEQ_IO_RWORD7                                                      0xab3
#define mmMC_SEQ_IO_RDBI                                                        0xab4
#define mmMC_SEQ_IO_REDC                                                        0xab5
#define mmMC_SEQ_TCG_CNTL                                                       0xabd
#define mmMC_SEQ_TSM_CTRL                                                       0xabe
#define mmMC_SEQ_TSM_GCNT                                                       0xabf
#define mmMC_SEQ_TSM_OCNT                                                       0xac0
#define mmMC_SEQ_TSM_NCNT                                                       0xac1
#define mmMC_SEQ_TSM_BCNT                                                       0xac2
#define mmMC_SEQ_TSM_FLAG                                                       0xac3
#define mmMC_SEQ_TSM_UPDATE                                                     0xac4
#define mmMC_SEQ_TSM_EDC                                                        0xac5
#define mmMC_SEQ_TSM_DBI                                                        0xac6
#define mmMC_SEQ_TSM_WCDR                                                       0xae3
#define mmMC_SEQ_TSM_MISC                                                       0xae6
#define mmMC_SEQ_TIMER_WR                                                       0xac9
#define mmMC_SEQ_TIMER_RD                                                       0xaca
#define mmMC_SEQ_DRAM_ERROR_INSERTION                                           0xacb
#define mmMC_PHY_TIMING_D0                                                      0xacc
#define mmMC_PHY_TIMING_D1                                                      0xacd
#define mmMC_PHY_TIMING_2                                                       0xace
#define mmMC_SEQ_MPLL_OVERRIDE                                                  0xa22
#define mmMCLK_PWRMGT_CNTL                                                      0xae8
#define mmDLL_CNTL                                                              0xae9
#define mmMPLL_SEQ_UCODE_1                                                      0xaea
#define mmMPLL_SEQ_UCODE_2                                                      0xaeb
#define mmMPLL_CNTL_MODE                                                        0xaec
#define mmMPLL_FUNC_CNTL                                                        0xaed
#define mmMPLL_FUNC_CNTL_1                                                      0xaee
#define mmMPLL_FUNC_CNTL_2                                                      0xaef
#define mmMPLL_AD_FUNC_CNTL                                                     0xaf0
#define mmMPLL_DQ_FUNC_CNTL                                                     0xaf1
#define mmMPLL_TIME                                                             0xaf2
#define mmMPLL_SS1                                                              0xaf3
#define mmMPLL_SS2                                                              0xaf4
#define mmMPLL_CONTROL                                                          0xaf5
#define mmMPLL_AD_STATUS                                                        0xaf6
#define mmMPLL_DQ_0_0_STATUS                                                    0xaf7
#define mmMPLL_DQ_0_1_STATUS                                                    0xaf8
#define mmMPLL_DQ_1_0_STATUS                                                    0xaf9
#define mmMPLL_DQ_1_1_STATUS                                                    0xafa
#define mmMC_SEQ_PMG_PG_HWCNTL                                                  0xab9
#define mmMC_SEQ_PMG_PG_SWCNTL_0                                                0xaba
#define mmMC_SEQ_PMG_PG_SWCNTL_1                                                0xabb
#define mmMC_SEQ_TSM_DEBUG_INDEX                                                0xacf
#define mmMC_SEQ_TSM_DEBUG_DATA                                                 0xad0
#define ixMC_TSM_DEBUG_GCNT                                                     0x0
#define ixMC_TSM_DEBUG_FLAG                                                     0x1
#define ixMC_TSM_DEBUG_MISC                                                     0x2
#define ixMC_TSM_DEBUG_BCNT0                                                    0x3
#define ixMC_TSM_DEBUG_BCNT1                                                    0x4
#define ixMC_TSM_DEBUG_BCNT2                                                    0x5
#define ixMC_TSM_DEBUG_BCNT3                                                    0x6
#define ixMC_TSM_DEBUG_BCNT4                                                    0x7
#define ixMC_TSM_DEBUG_BCNT5                                                    0x8
#define ixMC_TSM_DEBUG_BCNT6                                                    0x9
#define ixMC_TSM_DEBUG_BCNT7                                                    0xa
#define ixMC_TSM_DEBUG_BCNT8                                                    0xb
#define ixMC_TSM_DEBUG_BCNT9                                                    0xc
#define ixMC_TSM_DEBUG_BCNT10                                                   0xd
#define ixMC_TSM_DEBUG_ST01                                                     0x10
#define ixMC_TSM_DEBUG_ST23                                                     0x11
#define ixMC_TSM_DEBUG_ST45                                                     0x12
#define ixMC_TSM_DEBUG_BKPT                                                     0x13
#define mmMC_SEQ_IO_DEBUG_INDEX                                                 0xa91
#define mmMC_SEQ_IO_DEBUG_DATA                                                  0xa92
#define ixMC_IO_DEBUG_UP_0                                                      0x0
#define ixMC_IO_DEBUG_UP_1                                                      0x1
#define ixMC_IO_DEBUG_UP_2                                                      0x2
#define ixMC_IO_DEBUG_UP_3                                                      0x3
#define ixMC_IO_DEBUG_UP_4                                                      0x4
#define ixMC_IO_DEBUG_UP_5                                                      0x5
#define ixMC_IO_DEBUG_UP_6                                                      0x6
#define ixMC_IO_DEBUG_UP_7                                                      0x7
#define ixMC_IO_DEBUG_UP_8                                                      0x8
#define ixMC_IO_DEBUG_UP_9                                                      0x9
#define ixMC_IO_DEBUG_UP_10                                                     0xa
#define ixMC_IO_DEBUG_UP_11                                                     0xb
#define ixMC_IO_DEBUG_UP_12                                                     0xc
#define ixMC_IO_DEBUG_UP_13                                                     0xd
#define ixMC_IO_DEBUG_UP_14                                                     0xe
#define ixMC_IO_DEBUG_UP_15                                                     0xf
#define ixMC_IO_DEBUG_UP_16                                                     0x10
#define ixMC_IO_DEBUG_UP_17                                                     0x11
#define ixMC_IO_DEBUG_UP_18                                                     0x12
#define ixMC_IO_DEBUG_UP_19                                                     0x13
#define ixMC_IO_DEBUG_UP_20                                                     0x14
#define ixMC_IO_DEBUG_UP_21                                                     0x15
#define ixMC_IO_DEBUG_UP_22                                                     0x16
#define ixMC_IO_DEBUG_UP_23                                                     0x17
#define ixMC_IO_DEBUG_UP_24                                                     0x18
#define ixMC_IO_DEBUG_UP_25                                                     0x19
#define ixMC_IO_DEBUG_UP_26                                                     0x1a
#define ixMC_IO_DEBUG_UP_27                                                     0x1b
#define ixMC_IO_DEBUG_UP_28                                                     0x1c
#define ixMC_IO_DEBUG_UP_29                                                     0x1d
#define ixMC_IO_DEBUG_UP_30                                                     0x1e
#define ixMC_IO_DEBUG_UP_31                                                     0x1f
#define ixMC_IO_DEBUG_UP_32                                                     0x20
#define ixMC_IO_DEBUG_UP_33                                                     0x21
#define ixMC_IO_DEBUG_UP_34                                                     0x22
#define ixMC_IO_DEBUG_UP_35                                                     0x23
#define ixMC_IO_DEBUG_UP_36                                                     0x24
#define ixMC_IO_DEBUG_UP_37                                                     0x25
#define ixMC_IO_DEBUG_UP_38                                                     0x26
#define ixMC_IO_DEBUG_UP_39                                                     0x27
#define ixMC_IO_DEBUG_UP_40                                                     0x28
#define ixMC_IO_DEBUG_UP_41                                                     0x29
#define ixMC_IO_DEBUG_UP_42                                                     0x2a
#define ixMC_IO_DEBUG_UP_43                                                     0x2b
#define ixMC_IO_DEBUG_UP_44                                                     0x2c
#define ixMC_IO_DEBUG_UP_45                                                     0x2d
#define ixMC_IO_DEBUG_UP_46                                                     0x2e
#define ixMC_IO_DEBUG_UP_47                                                     0x2f
#define ixMC_IO_DEBUG_UP_48                                                     0x30
#define ixMC_IO_DEBUG_UP_49                                                     0x31
#define ixMC_IO_DEBUG_UP_50                                                     0x32
#define ixMC_IO_DEBUG_UP_51                                                     0x33
#define ixMC_IO_DEBUG_UP_52                                                     0x34
#define ixMC_IO_DEBUG_UP_53                                                     0x35
#define ixMC_IO_DEBUG_UP_54                                                     0x36
#define ixMC_IO_DEBUG_UP_55                                                     0x37
#define ixMC_IO_DEBUG_UP_56                                                     0x38
#define ixMC_IO_DEBUG_UP_57                                                     0x39
#define ixMC_IO_DEBUG_UP_58                                                     0x3a
#define ixMC_IO_DEBUG_UP_59                                                     0x3b
#define ixMC_IO_DEBUG_UP_60                                                     0x3c
#define ixMC_IO_DEBUG_UP_61                                                     0x3d
#define ixMC_IO_DEBUG_UP_62                                                     0x3e
#define ixMC_IO_DEBUG_UP_63                                                     0x3f
#define ixMC_IO_DEBUG_UP_64                                                     0x40
#define ixMC_IO_DEBUG_UP_65                                                     0x41
#define ixMC_IO_DEBUG_UP_66                                                     0x42
#define ixMC_IO_DEBUG_UP_67                                                     0x43
#define ixMC_IO_DEBUG_UP_68                                                     0x44
#define ixMC_IO_DEBUG_UP_69                                                     0x45
#define ixMC_IO_DEBUG_UP_70                                                     0x46
#define ixMC_IO_DEBUG_UP_71                                                     0x47
#define ixMC_IO_DEBUG_UP_72                                                     0x48
#define ixMC_IO_DEBUG_UP_73                                                     0x49
#define ixMC_IO_DEBUG_UP_74                                                     0x4a
#define ixMC_IO_DEBUG_UP_75                                                     0x4b
#define ixMC_IO_DEBUG_UP_76                                                     0x4c
#define ixMC_IO_DEBUG_UP_77                                                     0x4d
#define ixMC_IO_DEBUG_UP_78                                                     0x4e
#define ixMC_IO_DEBUG_UP_79                                                     0x4f
#define ixMC_IO_DEBUG_UP_80                                                     0x50
#define ixMC_IO_DEBUG_UP_81                                                     0x51
#define ixMC_IO_DEBUG_UP_82                                                     0x52
#define ixMC_IO_DEBUG_UP_83                                                     0x53
#define ixMC_IO_DEBUG_UP_84                                                     0x54
#define ixMC_IO_DEBUG_UP_85                                                     0x55
#define ixMC_IO_DEBUG_UP_86                                                     0x56
#define ixMC_IO_DEBUG_UP_87                                                     0x57
#define ixMC_IO_DEBUG_UP_88                                                     0x58
#define ixMC_IO_DEBUG_UP_89                                                     0x59
#define ixMC_IO_DEBUG_UP_90                                                     0x5a
#define ixMC_IO_DEBUG_UP_91                                                     0x5b
#define ixMC_IO_DEBUG_UP_92                                                     0x5c
#define ixMC_IO_DEBUG_UP_93                                                     0x5d
#define ixMC_IO_DEBUG_UP_94                                                     0x5e
#define ixMC_IO_DEBUG_UP_95                                                     0x5f
#define ixMC_IO_DEBUG_UP_96                                                     0x60
#define ixMC_IO_DEBUG_UP_97                                                     0x61
#define ixMC_IO_DEBUG_UP_98                                                     0x62
#define ixMC_IO_DEBUG_UP_99                                                     0x63
#define ixMC_IO_DEBUG_UP_100                                                    0x64
#define ixMC_IO_DEBUG_UP_101                                                    0x65
#define ixMC_IO_DEBUG_UP_102                                                    0x66
#define ixMC_IO_DEBUG_UP_103                                                    0x67
#define ixMC_IO_DEBUG_UP_104                                                    0x68
#define ixMC_IO_DEBUG_UP_105                                                    0x69
#define ixMC_IO_DEBUG_UP_106                                                    0x6a
#define ixMC_IO_DEBUG_UP_107                                                    0x6b
#define ixMC_IO_DEBUG_UP_108                                                    0x6c
#define ixMC_IO_DEBUG_UP_109                                                    0x6d
#define ixMC_IO_DEBUG_UP_110                                                    0x6e
#define ixMC_IO_DEBUG_UP_111                                                    0x6f
#define ixMC_IO_DEBUG_UP_112                                                    0x70
#define ixMC_IO_DEBUG_UP_113                                                    0x71
#define ixMC_IO_DEBUG_UP_114                                                    0x72
#define ixMC_IO_DEBUG_UP_115                                                    0x73
#define ixMC_IO_DEBUG_UP_116                                                    0x74
#define ixMC_IO_DEBUG_UP_117                                                    0x75
#define ixMC_IO_DEBUG_UP_118                                                    0x76
#define ixMC_IO_DEBUG_UP_119                                                    0x77
#define ixMC_IO_DEBUG_UP_120                                                    0x78
#define ixMC_IO_DEBUG_UP_121                                                    0x79
#define ixMC_IO_DEBUG_UP_122                                                    0x7a
#define ixMC_IO_DEBUG_UP_123                                                    0x7b
#define ixMC_IO_DEBUG_UP_124                                                    0x7c
#define ixMC_IO_DEBUG_UP_125                                                    0x7d
#define ixMC_IO_DEBUG_UP_126                                                    0x7e
#define ixMC_IO_DEBUG_UP_127                                                    0x7f
#define ixMC_IO_DEBUG_UP_128                                                    0x80
#define ixMC_IO_DEBUG_UP_129                                                    0x81
#define ixMC_IO_DEBUG_UP_130                                                    0x82
#define ixMC_IO_DEBUG_UP_131                                                    0x83
#define ixMC_IO_DEBUG_UP_132                                                    0x84
#define ixMC_IO_DEBUG_UP_133                                                    0x85
#define ixMC_IO_DEBUG_UP_134                                                    0x86
#define ixMC_IO_DEBUG_UP_135                                                    0x87
#define ixMC_IO_DEBUG_UP_136                                                    0x88
#define ixMC_IO_DEBUG_UP_137                                                    0x89
#define ixMC_IO_DEBUG_UP_138                                                    0x8a
#define ixMC_IO_DEBUG_UP_139                                                    0x8b
#define ixMC_IO_DEBUG_UP_140                                                    0x8c
#define ixMC_IO_DEBUG_UP_141                                                    0x8d
#define ixMC_IO_DEBUG_UP_142                                                    0x8e
#define ixMC_IO_DEBUG_UP_143                                                    0x8f
#define ixMC_IO_DEBUG_UP_144                                                    0x90
#define ixMC_IO_DEBUG_UP_145                                                    0x91
#define ixMC_IO_DEBUG_UP_146                                                    0x92
#define ixMC_IO_DEBUG_UP_147                                                    0x93
#define ixMC_IO_DEBUG_UP_148                                                    0x94
#define ixMC_IO_DEBUG_UP_149                                                    0x95
#define ixMC_IO_DEBUG_UP_150                                                    0x96
#define ixMC_IO_DEBUG_UP_151                                                    0x97
#define ixMC_IO_DEBUG_UP_152                                                    0x98
#define ixMC_IO_DEBUG_UP_153                                                    0x99
#define ixMC_IO_DEBUG_UP_154                                                    0x9a
#define ixMC_IO_DEBUG_UP_155                                                    0x9b
#define ixMC_IO_DEBUG_UP_156                                                    0x9c
#define ixMC_IO_DEBUG_UP_157                                                    0x9d
#define ixMC_IO_DEBUG_UP_158                                                    0x9e
#define ixMC_IO_DEBUG_UP_159                                                    0x9f
#define ixMC_IO_DEBUG_DQB0L_MISC_D0                                             0xa0
#define ixMC_IO_DEBUG_DQB0H_MISC_D0                                             0xa1
#define ixMC_IO_DEBUG_DQB1L_MISC_D0                                             0xa2
#define ixMC_IO_DEBUG_DQB1H_MISC_D0                                             0xa3
#define ixMC_IO_DEBUG_DQB2L_MISC_D0                                             0xa4
#define ixMC_IO_DEBUG_DQB2H_MISC_D0                                             0xa5
#define ixMC_IO_DEBUG_DQB3L_MISC_D0                                             0xa6
#define ixMC_IO_DEBUG_DQB3H_MISC_D0                                             0xa7
#define ixMC_IO_DEBUG_DBI_MISC_D0                                               0xa8
#define ixMC_IO_DEBUG_EDC_MISC_D0                                               0xa9
#define ixMC_IO_DEBUG_WCK_MISC_D0                                               0xaa
#define ixMC_IO_DEBUG_CK_MISC_D0                                                0xab
#define ixMC_IO_DEBUG_ADDRL_MISC_D0                                             0xac
#define ixMC_IO_DEBUG_ADDRH_MISC_D0                                             0xad
#define ixMC_IO_DEBUG_ACMD_MISC_D0                                              0xae
#define ixMC_IO_DEBUG_CMD_MISC_D0                                               0xaf
#define ixMC_IO_DEBUG_DQB0L_MISC_D1                                             0xb0
#define ixMC_IO_DEBUG_DQB0H_MISC_D1                                             0xb1
#define ixMC_IO_DEBUG_DQB1L_MISC_D1                                             0xb2
#define ixMC_IO_DEBUG_DQB1H_MISC_D1                                             0xb3
#define ixMC_IO_DEBUG_DQB2L_MISC_D1                                             0xb4
#define ixMC_IO_DEBUG_DQB2H_MISC_D1                                             0xb5
#define ixMC_IO_DEBUG_DQB3L_MISC_D1                                             0xb6
#define ixMC_IO_DEBUG_DQB3H_MISC_D1                                             0xb7
#define ixMC_IO_DEBUG_DBI_MISC_D1                                               0xb8
#define ixMC_IO_DEBUG_EDC_MISC_D1                                               0xb9
#define ixMC_IO_DEBUG_WCK_MISC_D1                                               0xba
#define ixMC_IO_DEBUG_CK_MISC_D1                                                0xbb
#define ixMC_IO_DEBUG_ADDRL_MISC_D1                                             0xbc
#define ixMC_IO_DEBUG_ADDRH_MISC_D1                                             0xbd
#define ixMC_IO_DEBUG_ACMD_MISC_D1                                              0xbe
#define ixMC_IO_DEBUG_CMD_MISC_D1                                               0xbf
#define ixMC_IO_DEBUG_DQB0L_CLKSEL_D0                                           0xc0
#define ixMC_IO_DEBUG_DQB0H_CLKSEL_D0                                           0xc1
#define ixMC_IO_DEBUG_DQB1L_CLKSEL_D0                                           0xc2
#define ixMC_IO_DEBUG_DQB1H_CLKSEL_D0                                           0xc3
#define ixMC_IO_DEBUG_DQB2L_CLKSEL_D0                                           0xc4
#define ixMC_IO_DEBUG_DQB2H_CLKSEL_D0                                           0xc5
#define ixMC_IO_DEBUG_DQB3L_CLKSEL_D0                                           0xc6
#define ixMC_IO_DEBUG_DQB3H_CLKSEL_D0                                           0xc7
#define ixMC_IO_DEBUG_DBI_CLKSEL_D0                                             0xc8
#define ixMC_IO_DEBUG_EDC_CLKSEL_D0                                             0xc9
#define ixMC_IO_DEBUG_WCK_CLKSEL_D0                                             0xca
#define ixMC_IO_DEBUG_CK_CLKSEL_D0                                              0xcb
#define ixMC_IO_DEBUG_ADDRL_CLKSEL_D0                                           0xcc
#define ixMC_IO_DEBUG_ADDRH_CLKSEL_D0                                           0xcd
#define ixMC_IO_DEBUG_ACMD_CLKSEL_D0                                            0xce
#define ixMC_IO_DEBUG_CMD_CLKSEL_D0                                             0xcf
#define ixMC_IO_DEBUG_DQB0L_CLKSEL_D1                                           0xd0
#define ixMC_IO_DEBUG_DQB0H_CLKSEL_D1                                           0xd1
#define ixMC_IO_DEBUG_DQB1L_CLKSEL_D1                                           0xd2
#define ixMC_IO_DEBUG_DQB1H_CLKSEL_D1                                           0xd3
#define ixMC_IO_DEBUG_DQB2L_CLKSEL_D1                                           0xd4
#define ixMC_IO_DEBUG_DQB2H_CLKSEL_D1                                           0xd5
#define ixMC_IO_DEBUG_DQB3L_CLKSEL_D1                                           0xd6
#define ixMC_IO_DEBUG_DQB3H_CLKSEL_D1                                           0xd7
#define ixMC_IO_DEBUG_DBI_CLKSEL_D1                                             0xd8
#define ixMC_IO_DEBUG_EDC_CLKSEL_D1                                             0xd9
#define ixMC_IO_DEBUG_WCK_CLKSEL_D1                                             0xda
#define ixMC_IO_DEBUG_CK_CLKSEL_D1                                              0xdb
#define ixMC_IO_DEBUG_ADDRL_CLKSEL_D1                                           0xdc
#define ixMC_IO_DEBUG_ADDRH_CLKSEL_D1                                           0xdd
#define ixMC_IO_DEBUG_ACMD_CLKSEL_D1                                            0xde
#define ixMC_IO_DEBUG_CMD_CLKSEL_D1                                             0xdf
#define ixMC_IO_DEBUG_DQB0L_OFSCAL_D0                                           0xe0
#define ixMC_IO_DEBUG_DQB0H_OFSCAL_D0                                           0xe1
#define ixMC_IO_DEBUG_DQB1L_OFSCAL_D0                                           0xe2
#define ixMC_IO_DEBUG_DQB1H_OFSCAL_D0                                           0xe3
#define ixMC_IO_DEBUG_DQB2L_OFSCAL_D0                                           0xe4
#define ixMC_IO_DEBUG_DQB2H_OFSCAL_D0                                           0xe5
#define ixMC_IO_DEBUG_DQB3L_OFSCAL_D0                                           0xe6
#define ixMC_IO_DEBUG_DQB3H_OFSCAL_D0                                           0xe7
#define ixMC_IO_DEBUG_DBI_OFSCAL_D0                                             0xe8
#define ixMC_IO_DEBUG_EDC_OFSCAL_D0                                             0xe9
#define ixMC_IO_DEBUG_WCK_OFSCAL_D0                                             0xea
#define ixMC_IO_DEBUG_EDC_RX_EQ_PM_D0                                           0xeb
#define ixMC_IO_DEBUG_EDC_RX_DYN_PM_D0                                          0xec
#define ixMC_IO_DEBUG_EDC_CDR_PHSIZE_D0                                         0xed
#define ixMC_IO_DEBUG_ACMD_OFSCAL_D0                                            0xee
#define ixMC_IO_DEBUG_CMD_OFSCAL_D0                                             0xef
#define ixMC_IO_DEBUG_DQB0L_OFSCAL_D1                                           0xf0
#define ixMC_IO_DEBUG_DQB0H_OFSCAL_D1                                           0xf1
#define ixMC_IO_DEBUG_DQB1L_OFSCAL_D1                                           0xf2
#define ixMC_IO_DEBUG_DQB1H_OFSCAL_D1                                           0xf3
#define ixMC_IO_DEBUG_DQB2L_OFSCAL_D1                                           0xf4
#define ixMC_IO_DEBUG_DQB2H_OFSCAL_D1                                           0xf5
#define ixMC_IO_DEBUG_DQB3L_OFSCAL_D1                                           0xf6
#define ixMC_IO_DEBUG_DQB3H_OFSCAL_D1                                           0xf7
#define ixMC_IO_DEBUG_DBI_OFSCAL_D1                                             0xf8
#define ixMC_IO_DEBUG_EDC_OFSCAL_D1                                             0xf9
#define ixMC_IO_DEBUG_WCK_OFSCAL_D1                                             0xfa
#define ixMC_IO_DEBUG_EDC_RX_EQ_PM_D1                                           0xfb
#define ixMC_IO_DEBUG_EDC_RX_DYN_PM_D1                                          0xfc
#define ixMC_IO_DEBUG_EDC_CDR_PHSIZE_D1                                         0xfd
#define ixMC_IO_DEBUG_ACMD_OFSCAL_D1                                            0xfe
#define ixMC_IO_DEBUG_CMD_OFSCAL_D1                                             0xff
#define ixMC_IO_DEBUG_DQB0L_RXPHASE_D0                                          0x100
#define ixMC_IO_DEBUG_DQB0H_RXPHASE_D0                                          0x101
#define ixMC_IO_DEBUG_DQB1L_RXPHASE_D0                                          0x102
#define ixMC_IO_DEBUG_DQB1H_RXPHASE_D0                                          0x103
#define ixMC_IO_DEBUG_DQB2L_RXPHASE_D0                                          0x104
#define ixMC_IO_DEBUG_DQB2H_RXPHASE_D0                                          0x105
#define ixMC_IO_DEBUG_DQB3L_RXPHASE_D0                                          0x106
#define ixMC_IO_DEBUG_DQB3H_RXPHASE_D0                                          0x107
#define ixMC_IO_DEBUG_DBI_RXPHASE_D0                                            0x108
#define ixMC_IO_DEBUG_EDC_RXPHASE_D0                                            0x109
#define ixMC_IO_DEBUG_WCK_RXPHASE_D0                                            0x10a
#define ixMC_IO_DEBUG_CK_RXPHASE_D0                                             0x10b
#define ixMC_IO_DEBUG_ADDRL_RXPHASE_D0                                          0x10c
#define ixMC_IO_DEBUG_ADDRH_RXPHASE_D0                                          0x10d
#define ixMC_IO_DEBUG_ACMD_RXPHASE_D0                                           0x10e
#define ixMC_IO_DEBUG_CMD_RXPHASE_D0                                            0x10f
#define ixMC_IO_DEBUG_DQB0L_RXPHASE_D1                                          0x110
#define ixMC_IO_DEBUG_DQB0H_RXPHASE_D1                                          0x111
#define ixMC_IO_DEBUG_DQB1L_RXPHASE_D1                                          0x112
#define ixMC_IO_DEBUG_DQB1H_RXPHASE_D1                                          0x113
#define ixMC_IO_DEBUG_DQB2L_RXPHASE_D1                                          0x114
#define ixMC_IO_DEBUG_DQB2H_RXPHASE_D1                                          0x115
#define ixMC_IO_DEBUG_DQB3L_RXPHASE_D1                                          0x116
#define ixMC_IO_DEBUG_DQB3H_RXPHASE_D1                                          0x117
#define ixMC_IO_DEBUG_DBI_RXPHASE_D1                                            0x118
#define ixMC_IO_DEBUG_EDC_RXPHASE_D1                                            0x119
#define ixMC_IO_DEBUG_WCK_RXPHASE_D1                                            0x11a
#define ixMC_IO_DEBUG_CK_RXPHASE_D1                                             0x11b
#define ixMC_IO_DEBUG_ADDRL_RXPHASE_D1                                          0x11c
#define ixMC_IO_DEBUG_ADDRH_RXPHASE_D1                                          0x11d
#define ixMC_IO_DEBUG_ACMD_RXPHASE_D1                                           0x11e
#define ixMC_IO_DEBUG_CMD_RXPHASE_D1                                            0x11f
#define ixMC_IO_DEBUG_DQB0L_TXPHASE_D0                                          0x120
#define ixMC_IO_DEBUG_DQB0H_TXPHASE_D0                                          0x121
#define ixMC_IO_DEBUG_DQB1L_TXPHASE_D0                                          0x122
#define ixMC_IO_DEBUG_DQB1H_TXPHASE_D0                                          0x123
#define ixMC_IO_DEBUG_DQB2L_TXPHASE_D0                                          0x124
#define ixMC_IO_DEBUG_DQB2H_TXPHASE_D0                                          0x125
#define ixMC_IO_DEBUG_DQB3L_TXPHASE_D0                                          0x126
#define ixMC_IO_DEBUG_DQB3H_TXPHASE_D0                                          0x127
#define ixMC_IO_DEBUG_DBI_TXPHASE_D0                                            0x128
#define ixMC_IO_DEBUG_EDC_TXPHASE_D0                                            0x129
#define ixMC_IO_DEBUG_WCK_TXPHASE_D0                                            0x12a
#define ixMC_IO_DEBUG_CK_TXPHASE_D0                                             0x12b
#define ixMC_IO_DEBUG_ADDRL_TXPHASE_D0                                          0x12c
#define ixMC_IO_DEBUG_ADDRH_TXPHASE_D0                                          0x12d
#define ixMC_IO_DEBUG_ACMD_TXPHASE_D0                                           0x12e
#define ixMC_IO_DEBUG_CMD_TXPHASE_D0                                            0x12f
#define ixMC_IO_DEBUG_DQB0L_TXPHASE_D1                                          0x130
#define ixMC_IO_DEBUG_DQB0H_TXPHASE_D1                                          0x131
#define ixMC_IO_DEBUG_DQB1L_TXPHASE_D1                                          0x132
#define ixMC_IO_DEBUG_DQB1H_TXPHASE_D1                                          0x133
#define ixMC_IO_DEBUG_DQB2L_TXPHASE_D1                                          0x134
#define ixMC_IO_DEBUG_DQB2H_TXPHASE_D1                                          0x135
#define ixMC_IO_DEBUG_DQB3L_TXPHASE_D1                                          0x136
#define ixMC_IO_DEBUG_DQB3H_TXPHASE_D1                                          0x137
#define ixMC_IO_DEBUG_DBI_TXPHASE_D1                                            0x138
#define ixMC_IO_DEBUG_EDC_TXPHASE_D1                                            0x139
#define ixMC_IO_DEBUG_WCK_TXPHASE_D1                                            0x13a
#define ixMC_IO_DEBUG_CK_TXPHASE_D1                                             0x13b
#define ixMC_IO_DEBUG_ADDRL_TXPHASE_D1                                          0x13c
#define ixMC_IO_DEBUG_ADDRH_TXPHASE_D1                                          0x13d
#define ixMC_IO_DEBUG_ACMD_TXPHASE_D1                                           0x13e
#define ixMC_IO_DEBUG_CMD_TXPHASE_D1                                            0x13f
#define ixMC_IO_DEBUG_DQB0L_RX_VREF_CAL_D0                                      0x140
#define ixMC_IO_DEBUG_DQB0H_RX_VREF_CAL_D0                                      0x141
#define ixMC_IO_DEBUG_DQB1L_RX_VREF_CAL_D0                                      0x142
#define ixMC_IO_DEBUG_DQB1H_RX_VREF_CAL_D0                                      0x143
#define ixMC_IO_DEBUG_DQB2L_RX_VREF_CAL_D0                                      0x144
#define ixMC_IO_DEBUG_DQB2H_RX_VREF_CAL_D0                                      0x145
#define ixMC_IO_DEBUG_DQB3L_RX_VREF_CAL_D0                                      0x146
#define ixMC_IO_DEBUG_DQB3H_RX_VREF_CAL_D0                                      0x147
#define ixMC_IO_DEBUG_DBI_RX_VREF_CAL_D0                                        0x148
#define ixMC_IO_DEBUG_EDC_RX_VREF_CAL_D0                                        0x149
#define ixMC_IO_DEBUG_WCK_RX_VREF_CAL_D0                                        0x14a
#define ixMC_IO_DEBUG_DQB0_CDR_PHSIZE_D0                                        0x14b
#define ixMC_IO_DEBUG_DQB1_CDR_PHSIZE_D0                                        0x14c
#define ixMC_IO_DEBUG_DQB2_CDR_PHSIZE_D0                                        0x14d
#define ixMC_IO_DEBUG_DQB3_CDR_PHSIZE_D0                                        0x14e
#define ixMC_IO_DEBUG_DBI_CDR_PHSIZE_D0                                         0x14f
#define ixMC_IO_DEBUG_DQB0L_RX_VREF_CAL_D1                                      0x150
#define ixMC_IO_DEBUG_DQB0H_RX_VREF_CAL_D1                                      0x151
#define ixMC_IO_DEBUG_DQB1L_RX_VREF_CAL_D1                                      0x152
#define ixMC_IO_DEBUG_DQB1H_RX_VREF_CAL_D1                                      0x153
#define ixMC_IO_DEBUG_DQB2L_RX_VREF_CAL_D1                                      0x154
#define ixMC_IO_DEBUG_DQB2H_RX_VREF_CAL_D1                                      0x155
#define ixMC_IO_DEBUG_DQB3L_RX_VREF_CAL_D1                                      0x156
#define ixMC_IO_DEBUG_DQB3H_RX_VREF_CAL_D1                                      0x157
#define ixMC_IO_DEBUG_DBI_RX_VREF_CAL_D1                                        0x158
#define ixMC_IO_DEBUG_EDC_RX_VREF_CAL_D1                                        0x159
#define ixMC_IO_DEBUG_WCK_RX_VREF_CAL_D1                                        0x15a
#define ixMC_IO_DEBUG_DQB0_CDR_PHSIZE_D1                                        0x15b
#define ixMC_IO_DEBUG_DQB1_CDR_PHSIZE_D1                                        0x15c
#define ixMC_IO_DEBUG_DQB2_CDR_PHSIZE_D1                                        0x15d
#define ixMC_IO_DEBUG_DQB3_CDR_PHSIZE_D1                                        0x15e
#define ixMC_IO_DEBUG_DBI_CDR_PHSIZE_D1                                         0x15f
#define ixMC_IO_DEBUG_DQB0L_TXSLF_D0                                            0x160
#define ixMC_IO_DEBUG_DQB0H_TXSLF_D0                                            0x161
#define ixMC_IO_DEBUG_DQB1L_TXSLF_D0                                            0x162
#define ixMC_IO_DEBUG_DQB1H_TXSLF_D0                                            0x163
#define ixMC_IO_DEBUG_DQB2L_TXSLF_D0                                            0x164
#define ixMC_IO_DEBUG_DQB2H_TXSLF_D0                                            0x165
#define ixMC_IO_DEBUG_DQB3L_TXSLF_D0                                            0x166
#define ixMC_IO_DEBUG_DQB3H_TXSLF_D0                                            0x167
#define ixMC_IO_DEBUG_DBI_TXSLF_D0                                              0x168
#define ixMC_IO_DEBUG_EDC_TXSLF_D0                                              0x169
#define ixMC_IO_DEBUG_WCK_TXSLF_D0                                              0x16a
#define ixMC_IO_DEBUG_CK_TXSLF_D0                                               0x16b
#define ixMC_IO_DEBUG_ADDRL_TXSLF_D0                                            0x16c
#define ixMC_IO_DEBUG_ADDRH_TXSLF_D0                                            0x16d
#define ixMC_IO_DEBUG_ACMD_TXSLF_D0                                             0x16e
#define ixMC_IO_DEBUG_CMD_TXSLF_D0                                              0x16f
#define ixMC_IO_DEBUG_DQB0L_TXSLF_D1                                            0x170
#define ixMC_IO_DEBUG_DQB0H_TXSLF_D1                                            0x171
#define ixMC_IO_DEBUG_DQB1L_TXSLF_D1                                            0x172
#define ixMC_IO_DEBUG_DQB1H_TXSLF_D1                                            0x173
#define ixMC_IO_DEBUG_DQB2L_TXSLF_D1                                            0x174
#define ixMC_IO_DEBUG_DQB2H_TXSLF_D1                                            0x175
#define ixMC_IO_DEBUG_DQB3L_TXSLF_D1                                            0x176
#define ixMC_IO_DEBUG_DQB3H_TXSLF_D1                                            0x177
#define ixMC_IO_DEBUG_DBI_TXSLF_D1                                              0x178
#define ixMC_IO_DEBUG_EDC_TXSLF_D1                                              0x179
#define ixMC_IO_DEBUG_WCK_TXSLF_D1                                              0x17a
#define ixMC_IO_DEBUG_CK_TXSLF_D1                                               0x17b
#define ixMC_IO_DEBUG_ADDRL_TXSLF_D1                                            0x17c
#define ixMC_IO_DEBUG_ADDRH_TXSLF_D1                                            0x17d
#define ixMC_IO_DEBUG_ACMD_TXSLF_D1                                             0x17e
#define ixMC_IO_DEBUG_CMD_TXSLF_D1                                              0x17f
#define ixMC_IO_DEBUG_DQB0L_TXBST_PD_D0                                         0x180
#define ixMC_IO_DEBUG_DQB0H_TXBST_PD_D0                                         0x181
#define ixMC_IO_DEBUG_DQB1L_TXBST_PD_D0                                         0x182
#define ixMC_IO_DEBUG_DQB1H_TXBST_PD_D0                                         0x183
#define ixMC_IO_DEBUG_DQB2L_TXBST_PD_D0                                         0x184
#define ixMC_IO_DEBUG_DQB2H_TXBST_PD_D0                                         0x185
#define ixMC_IO_DEBUG_DQB3L_TXBST_PD_D0                                         0x186
#define ixMC_IO_DEBUG_DQB3H_TXBST_PD_D0                                         0x187
#define ixMC_IO_DEBUG_DBI_TXBST_PD_D0                                           0x188
#define ixMC_IO_DEBUG_EDC_TXBST_PD_D0                                           0x189
#define ixMC_IO_DEBUG_WCK_TXBST_PD_D0                                           0x18a
#define ixMC_IO_DEBUG_CK_TXBST_PD_D0                                            0x18b
#define ixMC_IO_DEBUG_ADDRL_TXBST_PD_D0                                         0x18c
#define ixMC_IO_DEBUG_ADDRH_TXBST_PD_D0                                         0x18d
#define ixMC_IO_DEBUG_ACMD_TXBST_PD_D0                                          0x18e
#define ixMC_IO_DEBUG_CMD_TXBST_PD_D0                                           0x18f
#define ixMC_IO_DEBUG_DQB0L_TXBST_PD_D1                                         0x190
#define ixMC_IO_DEBUG_DQB0H_TXBST_PD_D1                                         0x191
#define ixMC_IO_DEBUG_DQB1L_TXBST_PD_D1                                         0x192
#define ixMC_IO_DEBUG_DQB1H_TXBST_PD_D1                                         0x193
#define ixMC_IO_DEBUG_DQB2L_TXBST_PD_D1                                         0x194
#define ixMC_IO_DEBUG_DQB2H_TXBST_PD_D1                                         0x195
#define ixMC_IO_DEBUG_DQB3L_TXBST_PD_D1                                         0x196
#define ixMC_IO_DEBUG_DQB3H_TXBST_PD_D1                                         0x197
#define ixMC_IO_DEBUG_DBI_TXBST_PD_D1                                           0x198
#define ixMC_IO_DEBUG_EDC_TXBST_PD_D1                                           0x199
#define ixMC_IO_DEBUG_WCK_TXBST_PD_D1                                           0x19a
#define ixMC_IO_DEBUG_CK_TXBST_PD_D1                                            0x19b
#define ixMC_IO_DEBUG_ADDRL_TXBST_PD_D1                                         0x19c
#define ixMC_IO_DEBUG_ADDRH_TXBST_PD_D1                                         0x19d
#define ixMC_IO_DEBUG_ACMD_TXBST_PD_D1                                          0x19e
#define ixMC_IO_DEBUG_CMD_TXBST_PD_D1                                           0x19f
#define ixMC_IO_DEBUG_DQB0L_TXBST_PU_D0                                         0x1a0
#define ixMC_IO_DEBUG_DQB0H_TXBST_PU_D0                                         0x1a1
#define ixMC_IO_DEBUG_DQB1L_TXBST_PU_D0                                         0x1a2
#define ixMC_IO_DEBUG_DQB1H_TXBST_PU_D0                                         0x1a3
#define ixMC_IO_DEBUG_DQB2L_TXBST_PU_D0                                         0x1a4
#define ixMC_IO_DEBUG_DQB2H_TXBST_PU_D0                                         0x1a5
#define ixMC_IO_DEBUG_DQB3L_TXBST_PU_D0                                         0x1a6
#define ixMC_IO_DEBUG_DQB3H_TXBST_PU_D0                                         0x1a7
#define ixMC_IO_DEBUG_DBI_TXBST_PU_D0                                           0x1a8
#define ixMC_IO_DEBUG_EDC_TXBST_PU_D0                                           0x1a9
#define ixMC_IO_DEBUG_WCK_TXBST_PU_D0                                           0x1aa
#define ixMC_IO_DEBUG_CK_TXBST_PU_D0                                            0x1ab
#define ixMC_IO_DEBUG_ADDRL_TXBST_PU_D0                                         0x1ac
#define ixMC_IO_DEBUG_ADDRH_TXBST_PU_D0                                         0x1ad
#define ixMC_IO_DEBUG_ACMD_TXBST_PU_D0                                          0x1ae
#define ixMC_IO_DEBUG_CMD_TXBST_PU_D0                                           0x1af
#define ixMC_IO_DEBUG_DQB0L_TXBST_PU_D1                                         0x1b0
#define ixMC_IO_DEBUG_DQB0H_TXBST_PU_D1                                         0x1b1
#define ixMC_IO_DEBUG_DQB1L_TXBST_PU_D1                                         0x1b2
#define ixMC_IO_DEBUG_DQB1H_TXBST_PU_D1                                         0x1b3
#define ixMC_IO_DEBUG_DQB2L_TXBST_PU_D1                                         0x1b4
#define ixMC_IO_DEBUG_DQB2H_TXBST_PU_D1                                         0x1b5
#define ixMC_IO_DEBUG_DQB3L_TXBST_PU_D1                                         0x1b6
#define ixMC_IO_DEBUG_DQB3H_TXBST_PU_D1                                         0x1b7
#define ixMC_IO_DEBUG_DBI_TXBST_PU_D1                                           0x1b8
#define ixMC_IO_DEBUG_EDC_TXBST_PU_D1                                           0x1b9
#define ixMC_IO_DEBUG_WCK_TXBST_PU_D1                                           0x1ba
#define ixMC_IO_DEBUG_CK_TXBST_PU_D1                                            0x1bb
#define ixMC_IO_DEBUG_ADDRL_TXBST_PU_D1                                         0x1bc
#define ixMC_IO_DEBUG_ADDRH_TXBST_PU_D1                                         0x1bd
#define ixMC_IO_DEBUG_ACMD_TXBST_PU_D1                                          0x1be
#define ixMC_IO_DEBUG_CMD_TXBST_PU_D1                                           0x1bf
#define ixMC_IO_DEBUG_DQB0L_RX_EQ_D0                                            0x1c0
#define ixMC_IO_DEBUG_DQB0H_RX_EQ_D0                                            0x1c1
#define ixMC_IO_DEBUG_DQB1L_RX_EQ_D0                                            0x1c2
#define ixMC_IO_DEBUG_DQB1H_RX_EQ_D0                                            0x1c3
#define ixMC_IO_DEBUG_DQB2L_RX_EQ_D0                                            0x1c4
#define ixMC_IO_DEBUG_DQB2H_RX_EQ_D0                                            0x1c5
#define ixMC_IO_DEBUG_DQB3L_RX_EQ_D0                                            0x1c6
#define ixMC_IO_DEBUG_DQB3H_RX_EQ_D0                                            0x1c7
#define ixMC_IO_DEBUG_DBI_RX_EQ_D0                                              0x1c8
#define ixMC_IO_DEBUG_EDC_RX_EQ_D0                                              0x1c9
#define ixMC_IO_DEBUG_WCK_RX_EQ_D0                                              0x1ca
#define ixMC_IO_DEBUG_DQ0_RX_EQ_PM_D0                                           0x1cb
#define ixMC_IO_DEBUG_DQ1_RX_EQ_PM_D0                                           0x1cc
#define ixMC_IO_DEBUG_DQ0_RX_DYN_PM_D0                                          0x1cd
#define ixMC_IO_DEBUG_DQ1_RX_DYN_PM_D0                                          0x1ce
#define ixMC_IO_DEBUG_CMD_RX_EQ_D0                                              0x1cf
#define ixMC_IO_DEBUG_DQB0L_RX_EQ_D1                                            0x1d0
#define ixMC_IO_DEBUG_DQB0H_RX_EQ_D1                                            0x1d1
#define ixMC_IO_DEBUG_DQB1L_RX_EQ_D1                                            0x1d2
#define ixMC_IO_DEBUG_DQB1H_RX_EQ_D1                                            0x1d3
#define ixMC_IO_DEBUG_DQB2L_RX_EQ_D1                                            0x1d4
#define ixMC_IO_DEBUG_DQB2H_RX_EQ_D1                                            0x1d5
#define ixMC_IO_DEBUG_DQB3L_RX_EQ_D1                                            0x1d6
#define ixMC_IO_DEBUG_DQB3H_RX_EQ_D1                                            0x1d7
#define ixMC_IO_DEBUG_DBI_RX_EQ_D1                                              0x1d8
#define ixMC_IO_DEBUG_EDC_RX_EQ_D1                                              0x1d9
#define ixMC_IO_DEBUG_WCK_RX_EQ_D1                                              0x1da
#define ixMC_IO_DEBUG_DQ0_RX_EQ_PM_D1                                           0x1db
#define ixMC_IO_DEBUG_DQ1_RX_EQ_PM_D1                                           0x1dc
#define ixMC_IO_DEBUG_DQ0_RX_DYN_PM_D1                                          0x1dd
#define ixMC_IO_DEBUG_DQ1_RX_DYN_PM_D1                                          0x1de
#define ixMC_IO_DEBUG_CMD_RX_EQ_D1                                              0x1df
#define ixMC_IO_DEBUG_WCDR_MISC_D0                                              0x1e0
#define ixMC_IO_DEBUG_WCDR_CLKSEL_D0                                            0x1e1
#define ixMC_IO_DEBUG_WCDR_OFSCAL_D0                                            0x1e2
#define ixMC_IO_DEBUG_WCDR_RXPHASE_D0                                           0x1e3
#define ixMC_IO_DEBUG_WCDR_TXPHASE_D0                                           0x1e4
#define ixMC_IO_DEBUG_WCDR_RX_VREF_CAL_D0                                       0x1e5
#define ixMC_IO_DEBUG_WCDR_TXSLF_D0                                             0x1e6
#define ixMC_IO_DEBUG_WCDR_TXBST_PD_D0                                          0x1e7
#define ixMC_IO_DEBUG_WCDR_TXBST_PU_D0                                          0x1e8
#define ixMC_IO_DEBUG_WCDR_RX_EQ_D0                                             0x1e9
#define ixMC_IO_DEBUG_WCDR_CDR_PHSIZE_D0                                        0x1ea
#define ixMC_IO_DEBUG_WCDR_RX_EQ_PM_D0                                          0x1eb
#define ixMC_IO_DEBUG_WCDR_RX_DYN_PM_D0                                         0x1ec
#define ixMC_IO_DEBUG_WCDR_MISC_D1                                              0x1f0
#define ixMC_IO_DEBUG_WCDR_CLKSEL_D1                                            0x1f1
#define ixMC_IO_DEBUG_WCDR_OFSCAL_D1                                            0x1f2
#define ixMC_IO_DEBUG_WCDR_RXPHASE_D1                                           0x1f3
#define ixMC_IO_DEBUG_WCDR_TXPHASE_D1                                           0x1f4
#define ixMC_IO_DEBUG_WCDR_RX_VREF_CAL_D1                                       0x1f5
#define ixMC_IO_DEBUG_WCDR_TXSLF_D1                                             0x1f6
#define ixMC_IO_DEBUG_WCDR_TXBST_PD_D1                                          0x1f7
#define ixMC_IO_DEBUG_WCDR_TXBST_PU_D1                                          0x1f8
#define ixMC_IO_DEBUG_WCDR_RX_EQ_D1                                             0x1f9
#define ixMC_IO_DEBUG_WCDR_CDR_PHSIZE_D1                                        0x1fa
#define ixMC_IO_DEBUG_WCDR_RX_EQ_PM_D1                                          0x1fb
#define ixMC_IO_DEBUG_WCDR_RX_DYN_PM_D1                                         0x1fc
#define mmMC_SEQ_CNTL_3                                                         0xd80
#define mmMC_SEQ_G5PDX_CTRL                                                     0xd81
#define mmMC_SEQ_G5PDX_CTRL_LP                                                  0xd82
#define mmMC_SEQ_G5PDX_CMD0                                                     0xd83
#define mmMC_SEQ_G5PDX_CMD0_LP                                                  0xd84
#define mmMC_SEQ_G5PDX_CMD1                                                     0xd85
#define mmMC_SEQ_G5PDX_CMD1_LP                                                  0xd86
#define mmMC_SEQ_SREG_READ                                                      0xd87
#define mmMC_SEQ_SREG_STATUS                                                    0xd88
#define mmMC_SEQ_PHYREG_BCAST                                                   0xd89
#define mmMC_SEQ_PMG_DVS_CTL                                                    0xd8a
#define mmMC_SEQ_PMG_DVS_CTL_LP                                                 0xd8b
#define mmMC_SEQ_PMG_DVS_CMD                                                    0xd8c
#define mmMC_SEQ_PMG_DVS_CMD_LP                                                 0xd8d
#define mmMC_SEQ_DLL_STBY                                                       0xd8e
#define mmMC_SEQ_DLL_STBY_LP                                                    0xd8f
#define mmMC_DLB_MISCCTRL0                                                      0xd90
#define mmMC_DLB_MISCCTRL1                                                      0xd91
#define mmMC_DLB_MISCCTRL2                                                      0xd92
#define mmMC_DLB_CONFIG0                                                        0xd93
#define mmMC_DLB_CONFIG1                                                        0xd94
#define mmMC_DLB_SETUP                                                          0xd95
#define mmMC_DLB_SETUPSWEEP                                                     0xd96
#define mmMC_DLB_SETUPFIFO                                                      0xd97
#define mmMC_DLB_WRITE_MASK                                                     0xd98
#define mmMC_DLB_STATUS                                                         0xd99
#define mmMC_DLB_STATUS_MISC0                                                   0xd9a
#define mmMC_DLB_STATUS_MISC1                                                   0xd9b
#define mmMC_DLB_STATUS_MISC2                                                   0xd9c
#define mmMC_DLB_STATUS_MISC3                                                   0xd9d
#define mmMC_DLB_STATUS_MISC4                                                   0xd9e
#define mmMC_DLB_STATUS_MISC5                                                   0xd9f
#define mmMC_DLB_STATUS_MISC6                                                   0xda0
#define mmMC_DLB_STATUS_MISC7                                                   0xda1
#define mmMC_ARB_HARSH_EN_RD                                                    0xdc0
#define mmMC_ARB_HARSH_EN_WR                                                    0xdc1
#define mmMC_ARB_HARSH_TX_HI0_RD                                                0xdc2
#define mmMC_ARB_HARSH_TX_HI0_WR                                                0xdc3
#define mmMC_ARB_HARSH_TX_HI1_RD                                                0xdc4
#define mmMC_ARB_HARSH_TX_HI1_WR                                                0xdc5
#define mmMC_ARB_HARSH_TX_LO0_RD                                                0xdc6
#define mmMC_ARB_HARSH_TX_LO0_WR                                                0xdc7
#define mmMC_ARB_HARSH_TX_LO1_RD                                                0xdc8
#define mmMC_ARB_HARSH_TX_LO1_WR                                                0xdc9
#define mmMC_ARB_HARSH_BWPERIOD0_RD                                             0xdca
#define mmMC_ARB_HARSH_BWPERIOD0_WR                                             0xdcb
#define mmMC_ARB_HARSH_BWPERIOD1_RD                                             0xdcc
#define mmMC_ARB_HARSH_BWPERIOD1_WR                                             0xdcd
#define mmMC_ARB_HARSH_BWCNT0_RD                                                0xdce
#define mmMC_ARB_HARSH_BWCNT0_WR                                                0xdcf
#define mmMC_ARB_HARSH_BWCNT1_RD                                                0xdd0
#define mmMC_ARB_HARSH_BWCNT1_WR                                                0xdd1
#define mmMC_ARB_HARSH_SAT0_RD                                                  0xdd2
#define mmMC_ARB_HARSH_SAT0_WR                                                  0xdd3
#define mmMC_ARB_HARSH_SAT1_RD                                                  0xdd4
#define mmMC_ARB_HARSH_SAT1_WR                                                  0xdd5
#define mmMC_ARB_HARSH_CTL_RD                                                   0xdd6
#define mmMC_ARB_HARSH_CTL_WR                                                   0xdd7
#define mmMC_ARB_GRUB_PRIORITY1_RD                                              0xdd8
#define mmMC_ARB_GRUB_PRIORITY1_WR                                              0xdd9
#define mmMC_ARB_GRUB_PRIORITY2_RD                                              0xdda
#define mmMC_ARB_GRUB_PRIORITY2_WR                                              0xddb
#define mmMCIF_WB_BUFMGR_SW_CONTROL                                             0x5e78
#define mmMCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL                                    0x5e78
#define mmMCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL                                    0x5eb8
#define mmMCIF_WB2_MCIF_WB_BUFMGR_SW_CONTROL                                    0x5ef8
#define mmMCIF_WB_BUFMGR_CUR_LINE_R                                             0x5e79
#define mmMCIF_WB0_MCIF_WB_BUFMGR_CUR_LINE_R                                    0x5e79
#define mmMCIF_WB1_MCIF_WB_BUFMGR_CUR_LINE_R                                    0x5eb9
#define mmMCIF_WB2_MCIF_WB_BUFMGR_CUR_LINE_R                                    0x5ef9
#define mmMCIF_WB_BUFMGR_STATUS                                                 0x5e7a
#define mmMCIF_WB0_MCIF_WB_BUFMGR_STATUS                                        0x5e7a
#define mmMCIF_WB1_MCIF_WB_BUFMGR_STATUS                                        0x5eba
#define mmMCIF_WB2_MCIF_WB_BUFMGR_STATUS                                        0x5efa
#define mmMCIF_WB_BUF_PITCH                                                     0x5e7b
#define mmMCIF_WB0_MCIF_WB_BUF_PITCH                                            0x5e7b
#define mmMCIF_WB1_MCIF_WB_BUF_PITCH                                            0x5ebb
#define mmMCIF_WB2_MCIF_WB_BUF_PITCH                                            0x5efb
#define mmMCIF_WB_BUF_1_STATUS                                                  0x5e7c
#define mmMCIF_WB0_MCIF_WB_BUF_1_STATUS                                         0x5e7c
#define mmMCIF_WB1_MCIF_WB_BUF_1_STATUS                                         0x5ebc
#define mmMCIF_WB2_MCIF_WB_BUF_1_STATUS                                         0x5efc
#define mmMCIF_WB_BUF_1_STATUS2                                                 0x5e7d
#define mmMCIF_WB0_MCIF_WB_BUF_1_STATUS2                                        0x5e7d
#define mmMCIF_WB1_MCIF_WB_BUF_1_STATUS2                                        0x5ebd
#define mmMCIF_WB2_MCIF_WB_BUF_1_STATUS2                                        0x5efd
#define mmMCIF_WB_BUF_2_STATUS                                                  0x5e7e
#define mmMCIF_WB0_MCIF_WB_BUF_2_STATUS                                         0x5e7e
#define mmMCIF_WB1_MCIF_WB_BUF_2_STATUS                                         0x5ebe
#define mmMCIF_WB2_MCIF_WB_BUF_2_STATUS                                         0x5efe
#define mmMCIF_WB_BUF_2_STATUS2                                                 0x5e7f
#define mmMCIF_WB0_MCIF_WB_BUF_2_STATUS2                                        0x5e7f
#define mmMCIF_WB1_MCIF_WB_BUF_2_STATUS2                                        0x5ebf
#define mmMCIF_WB2_MCIF_WB_BUF_2_STATUS2                                        0x5eff
#define mmMCIF_WB_BUF_3_STATUS                                                  0x5e80
#define mmMCIF_WB0_MCIF_WB_BUF_3_STATUS                                         0x5e80
#define mmMCIF_WB1_MCIF_WB_BUF_3_STATUS                                         0x5ec0
#define mmMCIF_WB2_MCIF_WB_BUF_3_STATUS                                         0x5f00
#define mmMCIF_WB_BUF_3_STATUS2                                                 0x5e81
#define mmMCIF_WB0_MCIF_WB_BUF_3_STATUS2                                        0x5e81
#define mmMCIF_WB1_MCIF_WB_BUF_3_STATUS2                                        0x5ec1
#define mmMCIF_WB2_MCIF_WB_BUF_3_STATUS2                                        0x5f01
#define mmMCIF_WB_BUF_4_STATUS                                                  0x5e82
#define mmMCIF_WB0_MCIF_WB_BUF_4_STATUS                                         0x5e82
#define mmMCIF_WB1_MCIF_WB_BUF_4_STATUS                                         0x5ec2
#define mmMCIF_WB2_MCIF_WB_BUF_4_STATUS                                         0x5f02
#define mmMCIF_WB_BUF_4_STATUS2                                                 0x5e83
#define mmMCIF_WB0_MCIF_WB_BUF_4_STATUS2                                        0x5e83
#define mmMCIF_WB1_MCIF_WB_BUF_4_STATUS2                                        0x5ec3
#define mmMCIF_WB2_MCIF_WB_BUF_4_STATUS2                                        0x5f03
#define mmMCIF_WB_ARBITRATION_CONTROL                                           0x5e84
#define mmMCIF_WB0_MCIF_WB_ARBITRATION_CONTROL                                  0x5e84
#define mmMCIF_WB1_MCIF_WB_ARBITRATION_CONTROL                                  0x5ec4
#define mmMCIF_WB2_MCIF_WB_ARBITRATION_CONTROL                                  0x5f04
#define mmMCIF_WB_URGENCY_WATERMARK                                             0x5e85
#define mmMCIF_WB0_MCIF_WB_URGENCY_WATERMARK                                    0x5e85
#define mmMCIF_WB1_MCIF_WB_URGENCY_WATERMARK                                    0x5ec5
#define mmMCIF_WB2_MCIF_WB_URGENCY_WATERMARK                                    0x5f05
#define mmMCIF_WB_TEST_DEBUG_INDEX                                              0x5e86
#define mmMCIF_WB0_MCIF_WB_TEST_DEBUG_INDEX                                     0x5e86
#define mmMCIF_WB1_MCIF_WB_TEST_DEBUG_INDEX                                     0x5ec6
#define mmMCIF_WB2_MCIF_WB_TEST_DEBUG_INDEX                                     0x5f06
#define mmMCIF_WB_TEST_DEBUG_DATA                                               0x5e87
#define mmMCIF_WB0_MCIF_WB_TEST_DEBUG_DATA                                      0x5e87
#define mmMCIF_WB1_MCIF_WB_TEST_DEBUG_DATA                                      0x5ec7
#define mmMCIF_WB2_MCIF_WB_TEST_DEBUG_DATA                                      0x5f07
#define mmMCIF_WB_BUF_1_ADDR_Y                                                  0x5e88
#define mmMCIF_WB0_MCIF_WB_BUF_1_ADDR_Y                                         0x5e88
#define mmMCIF_WB1_MCIF_WB_BUF_1_ADDR_Y                                         0x5ec8
#define mmMCIF_WB2_MCIF_WB_BUF_1_ADDR_Y                                         0x5f08
#define mmMCIF_WB_BUF_1_ADDR_Y_OFFSET                                           0x5e89
#define mmMCIF_WB0_MCIF_WB_BUF_1_ADDR_Y_OFFSET                                  0x5e89
#define mmMCIF_WB1_MCIF_WB_BUF_1_ADDR_Y_OFFSET                                  0x5ec9
#define mmMCIF_WB2_MCIF_WB_BUF_1_ADDR_Y_OFFSET                                  0x5f09
#define mmMCIF_WB_BUF_1_ADDR_C                                                  0x5e8a
#define mmMCIF_WB0_MCIF_WB_BUF_1_ADDR_C                                         0x5e8a
#define mmMCIF_WB1_MCIF_WB_BUF_1_ADDR_C                                         0x5eca
#define mmMCIF_WB2_MCIF_WB_BUF_1_ADDR_C                                         0x5f0a
#define mmMCIF_WB_BUF_1_ADDR_C_OFFSET                                           0x5e8b
#define mmMCIF_WB0_MCIF_WB_BUF_1_ADDR_C_OFFSET                                  0x5e8b
#define mmMCIF_WB1_MCIF_WB_BUF_1_ADDR_C_OFFSET                                  0x5ecb
#define mmMCIF_WB2_MCIF_WB_BUF_1_ADDR_C_OFFSET                                  0x5f0b
#define mmMCIF_WB_BUF_2_ADDR_Y                                                  0x5e8c
#define mmMCIF_WB0_MCIF_WB_BUF_2_ADDR_Y                                         0x5e8c
#define mmMCIF_WB1_MCIF_WB_BUF_2_ADDR_Y                                         0x5ecc
#define mmMCIF_WB2_MCIF_WB_BUF_2_ADDR_Y                                         0x5f0c
#define mmMCIF_WB_BUF_2_ADDR_Y_OFFSET                                           0x5e8d
#define mmMCIF_WB0_MCIF_WB_BUF_2_ADDR_Y_OFFSET                                  0x5e8d
#define mmMCIF_WB1_MCIF_WB_BUF_2_ADDR_Y_OFFSET                                  0x5ecd
#define mmMCIF_WB2_MCIF_WB_BUF_2_ADDR_Y_OFFSET                                  0x5f0d
#define mmMCIF_WB_BUF_2_ADDR_C                                                  0x5e8e
#define mmMCIF_WB0_MCIF_WB_BUF_2_ADDR_C                                         0x5e8e
#define mmMCIF_WB1_MCIF_WB_BUF_2_ADDR_C                                         0x5ece
#define mmMCIF_WB2_MCIF_WB_BUF_2_ADDR_C                                         0x5f0e
#define mmMCIF_WB_BUF_2_ADDR_C_OFFSET                                           0x5e8f
#define mmMCIF_WB0_MCIF_WB_BUF_2_ADDR_C_OFFSET                                  0x5e8f
#define mmMCIF_WB1_MCIF_WB_BUF_2_ADDR_C_OFFSET                                  0x5ecf
#define mmMCIF_WB2_MCIF_WB_BUF_2_ADDR_C_OFFSET                                  0x5f0f
#define mmMCIF_WB_BUF_3_ADDR_Y                                                  0x5e90
#define mmMCIF_WB0_MCIF_WB_BUF_3_ADDR_Y                                         0x5e90
#define mmMCIF_WB1_MCIF_WB_BUF_3_ADDR_Y                                         0x5ed0
#define mmMCIF_WB2_MCIF_WB_BUF_3_ADDR_Y                                         0x5f10
#define mmMCIF_WB_BUF_3_ADDR_Y_OFFSET                                           0x5e91
#define mmMCIF_WB0_MCIF_WB_BUF_3_ADDR_Y_OFFSET                                  0x5e91
#define mmMCIF_WB1_MCIF_WB_BUF_3_ADDR_Y_OFFSET                                  0x5ed1
#define mmMCIF_WB2_MCIF_WB_BUF_3_ADDR_Y_OFFSET                                  0x5f11
#define mmMCIF_WB_BUF_3_ADDR_C                                                  0x5e92
#define mmMCIF_WB0_MCIF_WB_BUF_3_ADDR_C                                         0x5e92
#define mmMCIF_WB1_MCIF_WB_BUF_3_ADDR_C                                         0x5ed2
#define mmMCIF_WB2_MCIF_WB_BUF_3_ADDR_C                                         0x5f12
#define mmMCIF_WB_BUF_3_ADDR_C_OFFSET                                           0x5e93
#define mmMCIF_WB0_MCIF_WB_BUF_3_ADDR_C_OFFSET                                  0x5e93
#define mmMCIF_WB1_MCIF_WB_BUF_3_ADDR_C_OFFSET                                  0x5ed3
#define mmMCIF_WB2_MCIF_WB_BUF_3_ADDR_C_OFFSET                                  0x5f13
#define mmMCIF_WB_BUF_4_ADDR_Y                                                  0x5e94
#define mmMCIF_WB0_MCIF_WB_BUF_4_ADDR_Y                                         0x5e94
#define mmMCIF_WB1_MCIF_WB_BUF_4_ADDR_Y                                         0x5ed4
#define mmMCIF_WB2_MCIF_WB_BUF_4_ADDR_Y                                         0x5f14
#define mmMCIF_WB_BUF_4_ADDR_Y_OFFSET                                           0x5e95
#define mmMCIF_WB0_MCIF_WB_BUF_4_ADDR_Y_OFFSET                                  0x5e95
#define mmMCIF_WB1_MCIF_WB_BUF_4_ADDR_Y_OFFSET                                  0x5ed5
#define mmMCIF_WB2_MCIF_WB_BUF_4_ADDR_Y_OFFSET                                  0x5f15
#define mmMCIF_WB_BUF_4_ADDR_C                                                  0x5e96
#define mmMCIF_WB0_MCIF_WB_BUF_4_ADDR_C                                         0x5e96
#define mmMCIF_WB1_MCIF_WB_BUF_4_ADDR_C                                         0x5ed6
#define mmMCIF_WB2_MCIF_WB_BUF_4_ADDR_C                                         0x5f16
#define mmMCIF_WB_BUF_4_ADDR_C_OFFSET                                           0x5e97
#define mmMCIF_WB0_MCIF_WB_BUF_4_ADDR_C_OFFSET                                  0x5e97
#define mmMCIF_WB1_MCIF_WB_BUF_4_ADDR_C_OFFSET                                  0x5ed7
#define mmMCIF_WB2_MCIF_WB_BUF_4_ADDR_C_OFFSET                                  0x5f17
#define mmMCIF_WB_BUFMGR_VCE_CONTROL                                            0x5e98
#define mmMCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL                                   0x5e98
#define mmMCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL                                   0x5ed8
#define mmMCIF_WB2_MCIF_WB_BUFMGR_VCE_CONTROL                                   0x5f18
#define mmMCIF_WB_HVVMID_CONTROL                                                0x5e99
#define mmMCIF_WB0_MCIF_WB_HVVMID_CONTROL                                       0x5e99
#define mmMCIF_WB1_MCIF_WB_HVVMID_CONTROL                                       0x5ed9
#define mmMCIF_WB2_MCIF_WB_HVVMID_CONTROL                                       0x5f19

#endif /* GMC_8_1_D_H */
