// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use glib::object::IsA;
use glib::translate::*;
use glib::GString;
use pango_sys;
use std::fmt;
use std::mem;
use std::ptr;
use FontFace;

glib_wrapper! {
    pub struct FontFamily(Object<pango_sys::PangoFontFamily, pango_sys::PangoFontFamilyClass, FontFamilyClass>);

    match fn {
        get_type => || pango_sys::pango_font_family_get_type(),
    }
}

pub const NONE_FONT_FAMILY: Option<&FontFamily> = None;

pub trait FontFamilyExt: 'static {
    fn get_name(&self) -> Option<GString>;

    fn is_monospace(&self) -> bool;

    #[cfg(any(feature = "v1_44", feature = "dox"))]
    fn is_variable(&self) -> bool;

    fn list_faces(&self) -> Vec<FontFace>;
}

impl<O: IsA<FontFamily>> FontFamilyExt for O {
    fn get_name(&self) -> Option<GString> {
        unsafe {
            from_glib_none(pango_sys::pango_font_family_get_name(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_monospace(&self) -> bool {
        unsafe {
            from_glib(pango_sys::pango_font_family_is_monospace(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v1_44", feature = "dox"))]
    fn is_variable(&self) -> bool {
        unsafe {
            from_glib(pango_sys::pango_font_family_is_variable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn list_faces(&self) -> Vec<FontFace> {
        unsafe {
            let mut faces = ptr::null_mut();
            let mut n_faces = mem::MaybeUninit::uninit();
            pango_sys::pango_font_family_list_faces(
                self.as_ref().to_glib_none().0,
                &mut faces,
                n_faces.as_mut_ptr(),
            );
            FromGlibContainer::from_glib_container_num(faces, n_faces.assume_init() as usize)
        }
    }
}

impl fmt::Display for FontFamily {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "FontFamily")
    }
}
