/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.awt.Component;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class ColumnFactory {
    private static ColumnFactory columnFactory;
    private int packMargin = 4;

    public static synchronized ColumnFactory getInstance() {
        if (columnFactory == null) {
            columnFactory = new ColumnFactory();
        }
        return columnFactory;
    }

    public static synchronized void setInstance(ColumnFactory factory) {
        columnFactory = factory;
    }

    public TableColumnExt createAndConfigureTableColumn(TableModel model, int modelIndex) {
        TableColumnExt column = this.createTableColumn(modelIndex);
        if (column != null) {
            this.configureTableColumn(model, column);
        }
        return column;
    }

    public TableColumnExt createTableColumn(int modelIndex) {
        return new TableColumnExt(modelIndex);
    }

    public void configureTableColumn(TableModel model, TableColumnExt columnExt) {
        if (columnExt.getModelIndex() < 0 || columnExt.getModelIndex() >= model.getColumnCount()) {
            throw new IllegalStateException("column must have valid modelIndex");
        }
        columnExt.setHeaderValue(model.getColumnName(columnExt.getModelIndex()));
    }

    public void configureColumnWidths(JXTable table, TableColumnExt columnExt) {
        int prefWidth = 75 - table.getColumnMargin();
        int prototypeWidth = this.calcPrototypeWidth(table, columnExt);
        if (prototypeWidth > 0) {
            prefWidth = prototypeWidth;
        }
        int headerWidth = this.calcHeaderWidth(table, columnExt);
        prefWidth = Math.max(prefWidth, headerWidth);
        columnExt.setPreferredWidth(prefWidth += table.getColumnModel().getColumnMargin());
    }

    public int getPreferredScrollableViewportWidth(JXTable table) {
        int w = 0;
        int count = table.getVisibleColumnCount() < 0 ? table.getColumnCount() : Math.min(table.getColumnCount(), table.getVisibleColumnCount());
        for (int i = 0; i < count; ++i) {
            w += table.getColumn(i).getPreferredWidth();
        }
        if (count < table.getVisibleColumnCount()) {
            w += (table.getVisibleColumnCount() - count) * 75;
        }
        return w;
    }

    protected int calcHeaderWidth(JXTable table, TableColumnExt columnExt) {
        int prototypeWidth = -1;
        TableCellRenderer renderer = this.getHeaderRenderer(table, columnExt);
        if (renderer != null) {
            Component comp = renderer.getTableCellRendererComponent(table, columnExt.getHeaderValue(), false, false, -1, -1);
            prototypeWidth = comp.getPreferredSize().width;
        }
        return prototypeWidth;
    }

    protected int calcPrototypeWidth(JXTable table, TableColumnExt columnExt) {
        int prototypeWidth = -1;
        Object prototypeValue = columnExt.getPrototypeValue();
        if (prototypeValue != null) {
            TableCellRenderer cellRenderer = this.getCellRenderer(table, columnExt);
            Component comp = cellRenderer.getTableCellRendererComponent(table, prototypeValue, false, false, 0, -1);
            prototypeWidth = comp.getPreferredSize().width;
        }
        return prototypeWidth;
    }

    protected TableCellRenderer getCellRenderer(JXTable table, TableColumnExt columnExt) {
        int viewIndex = table.convertColumnIndexToView(columnExt.getModelIndex());
        if (viewIndex >= 0) {
            return table.getCellRenderer(0, viewIndex);
        }
        TableCellRenderer renderer = columnExt.getCellRenderer();
        if (renderer == null) {
            renderer = table.getDefaultRenderer(table.getModel().getColumnClass(columnExt.getModelIndex()));
        }
        return renderer;
    }

    protected TableCellRenderer getHeaderRenderer(JXTable table, TableColumnExt columnExt) {
        JTableHeader header;
        TableCellRenderer renderer = columnExt.getHeaderRenderer();
        if (renderer == null && (header = table.getTableHeader()) != null) {
            renderer = header.getDefaultRenderer();
        }
        return renderer;
    }

    public void packColumn(JXTable table, TableColumnExt columnExt, int margin, int max) {
        if (!columnExt.isVisible()) {
            throw new IllegalStateException("column must be visible to pack");
        }
        int column = table.convertColumnIndexToView(columnExt.getModelIndex());
        int width = 0;
        TableCellRenderer headerRenderer = this.getHeaderRenderer(table, columnExt);
        if (headerRenderer != null) {
            Component comp = headerRenderer.getTableCellRendererComponent(table, columnExt.getHeaderValue(), false, false, 0, column);
            width = comp.getPreferredSize().width;
        }
        TableCellRenderer renderer = this.getCellRenderer(table, columnExt);
        for (int r = 0; r < this.getRowCount(table); ++r) {
            Component comp = table.prepareRenderer(renderer, r, column);
            width = Math.max(width, comp.getPreferredSize().width);
        }
        if (margin < 0) {
            margin = this.getDefaultPackMargin();
        }
        if (max != -1 && (width += 2 * margin) > max) {
            width = max;
        }
        columnExt.setPreferredWidth(width);
    }

    protected int getRowCount(JXTable table) {
        return table.getRowCount();
    }

    public int getDefaultPackMargin() {
        return this.packMargin;
    }

    public void setDefaultPackMargin(int margin) {
        this.packMargin = margin;
    }
}

