
(define-module (intr-gtk4-examples calc2 scheme-utils))

(use-modules (ice-9 ftw))
(use-modules (ice-9 match))


;; This procedure is taken from Guile documentation.

(define-public remove-stat
  ;; Remove the `stat' object the `file-system-tree' provides
  ;; for each file in the tree.
  (match-lambda
   ((name stat)              ; flat file
                             name)
   ((name stat children ...) ; directory
                             (list name (map remove-stat children)))))


(define-public (get-load-compiled-path)
  %load-compiled-path)


(define-public (set-load-compiled-path! l-str-path)
  (set! %load-compiled-path l-str-path))


(define-public (get-plain-file-tree str-dir)
  (remove-stat (file-system-tree str-dir)))

