# -*- coding: binary -*-

# Splunk base module
module Msf::Exploit::Remote::HTTP::Splunk::Base
  # Checks if the site is online and running splunk
  #
  # @return [Rex::Proto::Http::Response,nil] Returns the HTTP response if the site is online and running splunk, nil otherwise
  def splunk_and_online?
    res = send_request_cgi({
      'uri' => splunk_url_login
    })

    return res if res&.body =~ /Splunk/

    return nil
  rescue ::Rex::ConnectionRefused, ::Rex::HostUnreachable, ::Rex::ConnectionTimeout => e
    vprint_error("Error connecting to #{splunk_url_login}: #{e}")
    return nil
  end
end
