#include "datapointjs.h"
#include "jsclassregistrar.h"


namespace pappso
{

DataPointJs::DataPointJs(QObject *parent) : QObject(parent), m_dataPoint()
{
}

DataPointJs::DataPointJs(double x, double y, QObject *parent) : QObject(parent), m_dataPoint(x, y)
{
}

DataPointJs::DataPointJs(const DataPoint &data_ppoint, QObject *parent)
  : QObject(parent), m_dataPoint(data_ppoint)
{
}

void
DataPointJs::setX(double x)
{
  if(m_dataPoint.x != x)
    {
      m_dataPoint.x = x;
      emit xChanged();
      emit stringChanged();
      emit validChanged();
    }
}

double
DataPointJs::getX() const
{
  return m_dataPoint.x;
}


void
DataPointJs::setY(double y)
{
  if(m_dataPoint.y != y)
    {
      m_dataPoint.y = y;
      emit yChanged();
      emit stringChanged();
      emit validChanged();
    }
}

double
DataPointJs::getY() const
{
  return m_dataPoint.y;
}

void
DataPointJs::setData(double x, double y)
{
  setX(x);
  setY(y);
}

bool
DataPointJs::isValid() const
{
  return m_dataPoint.isValid();
}

QString
DataPointJs::toString() const
{
  return m_dataPoint.toString();
}

QString
DataPointJs::toString(int decimals) const
{
  return m_dataPoint.toString(decimals);
}

void
DataPointJs::reset()
{
  m_dataPoint.reset();
  emit xChanged();
  emit yChanged();
  emit stringChanged();
  emit validChanged();
}

void
DataPointJs::incrementX(double value)
{
  m_dataPoint.incrementX(value);
  emit xChanged();
  emit stringChanged();
}

void
DataPointJs::incrementY(double value)
{
  m_dataPoint.incrementY(value);
  emit yChanged();
  emit stringChanged();
}

void
DataPointJs::initialize(double x, double y)
{
  m_dataPoint.initialize(x, y);
  emit xChanged();
  emit yChanged();
  emit validChanged();
  emit stringChanged();
}

void
DataPointJs::initialize(const QString &text)
{
  if(m_dataPoint.initialize(text))
    {
      emit xChanged();
      emit yChanged();
      emit validChanged();
      emit stringChanged();
    }
}

const DataPoint &
DataPointJs::dataPoint() const
{
  return m_dataPoint;
}

void
DataPointJs::setDataPoint(const DataPoint &point)
{
  m_dataPoint = point;
  emit xChanged();
  emit yChanged();
  emit validChanged();
  emit stringChanged();
}

void
DataPointJs::registerJsConstructor(QJSEngine *engine)
{
  if(!engine)
    {
      qWarning() << "Cannot register DataPointJs class: engine is null";
      return;
    }

  // Register the meta object as a constructor
  QJSValue jsMetaObject = engine->newQMetaObject(&DataPointJs::staticMetaObject);
  engine->globalObject().setProperty("DataPoint", jsMetaObject);
}

} // namespace pappso
