/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.menubar;

import com.formdev.flatlaf.intellijthemes.FlatDarkFlatIJTheme;
import com.formdev.flatlaf.intellijthemes.FlatHighContrastIJTheme;
import com.formdev.flatlaf.intellijthemes.FlatLightFlatIJTheme;
import com.formdev.flatlaf.intellijthemes.materialthemeuilite.FlatMTGitHubDarkIJTheme;
import com.formdev.flatlaf.intellijthemes.materialthemeuilite.FlatMTGitHubIJTheme;
import com.formdev.flatlaf.themes.FlatMacDarkLaf;
import com.formdev.flatlaf.themes.FlatMacLightLaf;
import com.jsql.util.I18nUtil;
import com.jsql.view.swing.action.ActionNewWindow;
import com.jsql.view.swing.dialog.translate.Language;
import com.jsql.view.swing.menubar.AppMenubar;
import com.jsql.view.swing.menubar.ModelCheckboxMenu;
import com.jsql.view.swing.panel.PanelPreferences;
import com.jsql.view.swing.sql.SqlEngine;
import com.jsql.view.swing.tab.TabHeader;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.RadioItemNonClosing;
import com.jsql.view.swing.util.UiUtil;
import java.awt.CardLayout;
import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class MenuWindows
extends JMenu {
    private static final String I18N_SQL_ENGINE = "MENUBAR_SQL_ENGINE";
    private static final String I18N_PREFERENCES = "MENUBAR_PREFERENCES";
    public static final String ACTION_STARTING_APP = "init";
    public static final String MENU_WINDOWS = "menuWindows";
    public static final String MENU_TRANSLATION = "menuTranslation";
    public static final String ITEM_RUSSIAN = "itemRussian";
    public static final String ITEM_ARABIC = "itemArabic";
    public static final String ITEM_ENGLISH = "itemEnglish";
    private final AppMenubar appMenubar;
    private final JMenu menuView;

    public MenuWindows(AppMenubar appMenubar) {
        super(I18nUtil.valueByKey("MENUBAR_WINDOWS"));
        this.appMenubar = appMenubar;
        this.setName(MENU_WINDOWS);
        I18nViewUtil.addComponentForKey("MENUBAR_WINDOWS", this);
        this.setMnemonic('W');
        JMenuItem itemNewWindows = new JMenuItem(new ActionNewWindow());
        I18nViewUtil.addComponentForKey("NEW_WINDOW_MENU", itemNewWindows);
        this.add(itemNewWindows);
        JMenu menuAppearance = new JMenu(I18nUtil.valueByKey("MENUBAR_APPEARANCE"));
        I18nViewUtil.addComponentForKey("MENUBAR_APPEARANCE", menuAppearance);
        menuAppearance.setMnemonic('A');
        JMenuItem itemNewWindows4k = new JMenuItem(new ActionNewWindow("Open window in 4K resolution...", "-Dsun.java2d.uiScale=2.5"));
        menuAppearance.add(itemNewWindows4k);
        ButtonGroup groupRadio = new ButtonGroup();
        JMenu menuThemes = new JMenu(I18nUtil.valueByKey("MENUBAR_THEMES"));
        I18nViewUtil.addComponentForKey("MENUBAR_THEMES", menuAppearance);
        menuThemes.setMnemonic('T');
        Arrays.asList(new AbstractMap.SimpleEntry<String, String>(FlatLightFlatIJTheme.class.getName(), "IntelliJ"), new AbstractMap.SimpleEntry<String, String>(FlatDarkFlatIJTheme.class.getName(), "IntelliJ Dark"), new AbstractMap.SimpleEntry<String, String>(FlatMacLightLaf.class.getName(), "macOS"), new AbstractMap.SimpleEntry<String, String>(FlatMacDarkLaf.class.getName(), "macOS Dark"), new AbstractMap.SimpleEntry<String, String>(FlatMTGitHubIJTheme.class.getName(), "GitHub"), new AbstractMap.SimpleEntry<String, String>(FlatMTGitHubDarkIJTheme.class.getName(), "GitHub Dark"), new AbstractMap.SimpleEntry<String, String>(FlatHighContrastIJTheme.class.getName(), "High contrast")).forEach(entry -> {
            RadioItemNonClosing item = new RadioItemNonClosing(new AbstractAction((AbstractMap.SimpleEntry)entry){
                final /* synthetic */ AbstractMap.SimpleEntry val$entry;
                {
                    this.val$entry = simpleEntry;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    AppMenubar.applyTheme((String)this.val$entry.getKey());
                }
            });
            item.setText((String)entry.getValue());
            item.setSelected(((String)entry.getKey()).equals(MediatorHelper.model().getMediatorUtils().preferencesUtil().getThemeFlatLafName()));
            groupRadio.add(item);
            menuThemes.add(item);
        });
        this.add(itemNewWindows);
        this.add(menuAppearance);
        this.add(menuThemes);
        this.add(new JSeparator());
        this.add(this.initMenuTranslation());
        this.add(new JSeparator());
        this.menuView = new JMenu(I18nUtil.valueByKey("MENUBAR_VIEW"));
        I18nViewUtil.addComponentForKey("MENUBAR_VIEW", this.menuView);
        this.menuView.setMnemonic('V');
        AtomicInteger accelerator = new AtomicInteger(49);
        AtomicInteger tabPosition = new AtomicInteger();
        MediatorHelper.frame().getTabManagers().getIconsTabs().forEach(entry -> {
            JMenuItem menuItem = new JMenuItem(I18nUtil.valueByKey(entry.getKeyLabel()), entry.getIcon());
            I18nViewUtil.addComponentForKey(entry.getKeyLabel(), menuItem);
            menuItem.setName(entry.getKeyLabel());
            this.menuView.add(menuItem);
            menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.getExtendedKeyCodeForChar(accelerator.getAndIncrement()), 128));
            int position = tabPosition.get();
            menuItem.addActionListener(actionEvent -> {
                CardLayout cardLayout = (CardLayout)MediatorHelper.tabManagersCards().getLayout();
                cardLayout.show(MediatorHelper.tabManagersCards(), menuItem.getName());
                MediatorHelper.frame().getTabManagers().setSelectedIndex(position);
            });
            tabPosition.getAndIncrement();
        });
        this.add(this.menuView);
        JMenu menuPanel = new JMenu(I18nUtil.valueByKey("MENUBAR_PANEL"));
        I18nViewUtil.addComponentForKey("MENUBAR_PANEL", menuPanel);
        menuPanel.setMnemonic('C');
        Arrays.asList(new ModelCheckboxMenu("CONSOLE_CHUNK_LABEL", "chunk_visible", () -> MediatorHelper.panelConsoles().insertChunkTab(), UiUtil.CHUNK.getIcon()), new ModelCheckboxMenu("CONSOLE_BINARY_LABEL", "binary_visible", () -> MediatorHelper.panelConsoles().insertBooleanTab(), UiUtil.BINARY.getIcon()), new ModelCheckboxMenu("CONSOLE_NETWORK_LABEL", "header_visible", () -> MediatorHelper.panelConsoles().insertNetworkTab(), UiUtil.NETWORK.getIcon()), new ModelCheckboxMenu("CONSOLE_JAVA_LABEL", "java_visible", () -> MediatorHelper.panelConsoles().insertJavaTab(), UiUtil.CUP.getIcon(), false)).forEach(model -> {
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(I18nUtil.valueByKey(model.i18n), model.icon, model.isChecked){

                @Override
                protected void processMouseEvent(MouseEvent e) {
                    if (RadioItemNonClosing.shouldClose(e, this)) {
                        super.processMouseEvent(e);
                    }
                }
            };
            I18nViewUtil.addComponentForKey(model.i18n, menuItem);
            menuPanel.add(menuItem);
            menuItem.addActionListener(arg_0 -> MenuWindows.lambda$new$7(menuItem, model, arg_0));
        });
        this.add(menuPanel);
        this.add(new JSeparator());
        this.add(this.getMenuItemSqlEngine());
        this.add(this.getMenuItemPreferences());
    }

    private JMenuItem getMenuItemSqlEngine() {
        JMenuItem itemSqlEngine = new JMenuItem(I18nUtil.valueByKey(I18N_SQL_ENGINE));
        I18nViewUtil.addComponentForKey(I18N_SQL_ENGINE, itemSqlEngine);
        itemSqlEngine.setName("itemSqlEngine");
        itemSqlEngine.setMnemonic('S');
        itemSqlEngine.addActionListener(actionEvent -> {
            String titleTabSqlEngine = "SQL Engine";
            for (int i = 0; i < MediatorHelper.tabResults().getTabCount(); ++i) {
                if (!titleTabSqlEngine.equals(MediatorHelper.tabResults().getTitleAt(i))) continue;
                MediatorHelper.tabResults().setSelectedIndex(i);
                return;
            }
            MediatorHelper.frame().getSplitNS().initSplitOrientation();
            SqlEngine panelSqlEngine = new SqlEngine();
            MediatorHelper.tabResults().addTab(titleTabSqlEngine, panelSqlEngine);
            MediatorHelper.tabResults().setSelectedComponent(panelSqlEngine);
            TabHeader header = new TabHeader(I18nViewUtil.valueByKey(I18N_SQL_ENGINE), UiUtil.COG.getIcon());
            I18nViewUtil.addComponentForKey(I18N_SQL_ENGINE, header.getTabLabel());
            MediatorHelper.tabResults().setTabComponentAt(MediatorHelper.tabResults().indexOfComponent(panelSqlEngine), header);
            MediatorHelper.tabResults().updateUI();
        });
        return itemSqlEngine;
    }

    private JMenuItem getMenuItemPreferences() {
        JMenuItem itemPreferences = new JMenuItem(I18nUtil.valueByKey(I18N_PREFERENCES), 80);
        I18nViewUtil.addComponentForKey(I18N_PREFERENCES, itemPreferences);
        itemPreferences.setName("itemPreferences");
        String titleTabPreferences = "Preferences";
        itemPreferences.addActionListener(actionEvent -> {
            for (int i = 0; i < MediatorHelper.tabResults().getTabCount(); ++i) {
                if (!titleTabPreferences.equals(MediatorHelper.tabResults().getTitleAt(i))) continue;
                MediatorHelper.tabResults().setSelectedIndex(i);
                return;
            }
            MediatorHelper.frame().getSplitNS().initSplitOrientation();
            PanelPreferences panelPreferences = new PanelPreferences();
            MediatorHelper.tabResults().addTab(titleTabPreferences, panelPreferences);
            MediatorHelper.tabResults().setSelectedComponent(panelPreferences);
            TabHeader header = new TabHeader(I18nViewUtil.valueByKey(I18N_PREFERENCES), UiUtil.COG.getIcon());
            I18nViewUtil.addComponentForKey(I18N_PREFERENCES, header.getTabLabel());
            MediatorHelper.tabResults().setTabComponentAt(MediatorHelper.tabResults().indexOfComponent(panelPreferences), header);
            MediatorHelper.tabResults().updateUI();
        });
        return itemPreferences;
    }

    private JMenu initMenuTranslation() {
        JMenu menuTranslation = new JMenu(I18nUtil.valueByKey("MENUBAR_LANGUAGE"));
        I18nViewUtil.addComponentForKey("MENUBAR_LANGUAGE", menuTranslation);
        menuTranslation.setName(MENU_TRANSLATION);
        menuTranslation.setMnemonic('L');
        ButtonGroup groupRadioLanguage = new ButtonGroup();
        AtomicBoolean atomicIsAnySelected = new AtomicBoolean(false);
        AppMenubar.ITEMS_TRANSLATE.forEach(model -> {
            atomicIsAnySelected.set(atomicIsAnySelected.get() || model.getLanguage().isCurrentLanguage());
            model.setMenuItem(new RadioItemNonClosing(model.getLanguage().getMenuItemLabel(), model.getLanguage().getFlag(), model.getLanguage().isCurrentLanguage()));
            model.getMenuItem().addActionListener(actionEvent -> {
                Locale newLocale = model.getLanguage() == Language.EN ? Locale.ROOT : Locale.forLanguageTag(model.getLanguage().getLanguageTag());
                this.appMenubar.switchLocale(newLocale);
                if (!ACTION_STARTING_APP.equals(model.getMenuItem().getActionCommand())) {
                    MediatorHelper.model().getPropertiesUtil().displayI18nStatus(newLocale);
                }
                model.getMenuItem().setActionCommand("");
                MediatorHelper.model().getMediatorUtils().preferencesUtil().withLanguageTag(model.getLanguage().getLanguageTag()).persist();
            });
            menuTranslation.add(model.getMenuItem());
            groupRadioLanguage.add(model.getMenuItem());
        });
        AppMenubar.ITEMS_TRANSLATE.stream().filter(model -> model.getLanguage() == Language.EN).forEach(modelItem -> {
            modelItem.getMenuItem().setSelected(!atomicIsAnySelected.get());
            modelItem.getMenuItem().setName(ITEM_ENGLISH);
        });
        AppMenubar.ITEMS_TRANSLATE.stream().filter(model -> model.getLanguage() == Language.RU).forEach(modelItem -> modelItem.getMenuItem().setName(ITEM_RUSSIAN));
        AppMenubar.ITEMS_TRANSLATE.stream().filter(model -> model.getLanguage() == Language.AR).forEach(modelItem -> {
            modelItem.getMenuItem().setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            modelItem.getMenuItem().setName(ITEM_ARABIC);
        });
        return menuTranslation;
    }

    public void switchLocaleFromPreferences() {
        AppMenubar.ITEMS_TRANSLATE.stream().filter(model -> model.getLanguage().getLanguageTag().equals(MediatorHelper.model().getMediatorUtils().preferencesUtil().getLanguageTag())).forEach(modelItem -> {
            modelItem.getMenuItem().setActionCommand(ACTION_STARTING_APP);
            modelItem.getMenuItem().doClick();
        });
    }

    public JMenu getMenuView() {
        return this.menuView;
    }

    private static /* synthetic */ void lambda$new$7(2 menuItem, ModelCheckboxMenu model, ActionEvent actionEvent) {
        if (menuItem.isSelected()) {
            model.runnableInsertTab.run();
        } else {
            MediatorHelper.tabConsoles().remove(MediatorHelper.tabConsoles().indexOfTab(model.icon));
        }
    }
}

