/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.list;

import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.list.DnDList;
import com.jsql.view.swing.list.ItemList;
import com.jsql.view.swing.list.ItemListScan;
import com.jsql.view.swing.list.ListTransfertHandlerScan;
import com.jsql.view.swing.text.JPopupTextArea;
import com.jsql.view.swing.util.I18nViewUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MenuActionNewValue
implements ActionListener {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final DnDList myList;

    public MenuActionNewValue(DnDList myList) {
        this.myList = myList;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int lastIndex;
        JPanel panel = new JPanel(new BorderLayout());
        final JTextArea textarea = (JTextArea)new JPopupTextArea(new JTextArea()).getProxy();
        JLabel labelAddValue = new JLabel(I18nUtil.valueByKey("LIST_ADD_VALUE_LABEL") + ":");
        panel.add((Component)labelAddValue, "North");
        I18nViewUtil.addComponentForKey("LIST_ADD_VALUE_LABEL", labelAddValue);
        panel.add(new JScrollPane(textarea));
        panel.setPreferredSize(new Dimension(600, 400));
        panel.setMinimumSize(new Dimension(600, 400));
        textarea.addMouseListener(new MouseAdapter(this){

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                textarea.requestFocusInWindow();
            }
        });
        int result = -1;
        try {
            result = JOptionPane.showOptionDialog(this.myList.getTopLevelAncestor(), panel, I18nUtil.valueByKey("LIST_ADD_VALUE_TITLE"), 2, 3, null, new String[]{I18nUtil.valueByKey("LIST_ADD_VALUE_OK"), I18nUtil.valueByKey("LIST_ADD_VALUE_CANCEL")}, I18nUtil.valueByKey("LIST_ADD_VALUE_CANCEL"));
        }
        catch (ClassCastException | IllegalArgumentException | NullPointerException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        if (StringUtils.isEmpty(textarea.getText()) || result != 0) {
            return;
        }
        int firstIndex = lastIndex = Math.max(this.myList.getSelectedIndex(), 0);
        lastIndex = "listManagerScan".equals(this.myList.getName()) ? this.addToScanList(textarea, lastIndex) : this.addToList(textarea, lastIndex);
        this.myList.setSelectionInterval(firstIndex, lastIndex - 1);
        this.myList.scrollRectToVisible(this.myList.getCellBounds(this.myList.getMinSelectionIndex(), this.myList.getMaxSelectionIndex()));
        textarea.setText(null);
    }

    private int addToList(JTextArea textarea, int index) {
        int lastIndex = index;
        for (String newItem : textarea.getText().split("\\n")) {
            if (!StringUtils.isNotEmpty(newItem)) continue;
            ((DefaultListModel)this.myList.getModel()).add(lastIndex++, new ItemList(newItem.replace("\\", "/")));
        }
        return lastIndex;
    }

    private int addToScanList(JTextArea textarea, int index) {
        int lastIndex = index;
        List<ItemListScan> listParsedItems = ListTransfertHandlerScan.parse(textarea.getText().replace("\\", "/"));
        for (ItemListScan item : listParsedItems) {
            ((DefaultListModel)this.myList.getModel()).add(lastIndex++, item);
        }
        return lastIndex;
    }
}

