/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.InjectionFailureException;
import com.jsql.model.injection.method.AbstractMethodInjection;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.subscriber.Seal;
import java.lang.invoke.CallSite;
import java.net.IDN;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ParameterUtil {
    private static final Logger LOGGER;
    private List<AbstractMap.SimpleEntry<String, String>> listQueryString = new CopyOnWriteArrayList<AbstractMap.SimpleEntry<String, String>>();
    private List<AbstractMap.SimpleEntry<String, String>> listRequest = new CopyOnWriteArrayList<AbstractMap.SimpleEntry<String, String>>();
    private List<AbstractMap.SimpleEntry<String, String>> listHeader = new CopyOnWriteArrayList<AbstractMap.SimpleEntry<String, String>>();
    private String rawRequest = "";
    private String rawHeader = "";
    private boolean isMultipartRequest = false;
    private static final String FORMAT_KEY_VALUE = "%s=%s";
    private static final boolean[] TCHAR;
    private final InjectionModel injectionModel;

    public ParameterUtil(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
    }

    public void controlInput(String selectionCommand, String urlQuery, String rawRequest, String rawHeader, AbstractMethodInjection methodInjection, String typeRequest, boolean isScanning) {
        try {
            int port;
            Object urlQueryFixed = urlQuery;
            if (((String)urlQueryFixed).isEmpty()) {
                throw new MalformedURLException("empty URL");
            }
            if (!((String)urlQueryFixed).matches("(?i)^https?://.*")) {
                if (!((String)urlQueryFixed).matches("(?i)^\\w+://.*")) {
                    LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Undefined URL protocol, forcing to [http://]");
                    urlQueryFixed = "http://" + (String)urlQueryFixed;
                } else {
                    throw new MalformedURLException("unknown URL protocol");
                }
            }
            if ((port = URI.create((String)urlQueryFixed).getPort()) > 65535) {
                throw new MalformedURLException("port must be 65535 or lower");
            }
            String authority = URI.create((String)urlQueryFixed).getAuthority();
            if (authority == null) {
                throw new MalformedURLException("undefined domain authority");
            }
            String authorityPunycode = IDN.toASCII(authority);
            if (!authority.equals(authorityPunycode)) {
                LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Punycode domain detected, using [{}] instead of [{}]", (Object)authorityPunycode, (Object)authority);
                urlQueryFixed = ((String)urlQueryFixed).replace(authority, authorityPunycode);
            }
            this.initQueryString((String)urlQueryFixed, selectionCommand);
            this.initRequest(rawRequest, selectionCommand);
            this.initHeader(rawHeader, selectionCommand);
            this.injectionModel.getMediatorUtils().connectionUtil().withMethodInjection(methodInjection);
            this.injectionModel.getMediatorUtils().connectionUtil().withTypeRequest(typeRequest);
            if (isScanning) {
                this.injectionModel.beginInjection();
            } else {
                new Thread(this.injectionModel::beginInjection, "ThreadBeginInjection").start();
            }
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Incorrect Url: {}", (Object)e.getMessage());
            this.injectionModel.sendToViews(new Seal.EndPreparation());
        }
    }

    public void checkParametersFormat() throws InjectionFailureException {
        this.checkOneOrLessStar();
        this.checkStarMatchMethod();
        this.checkMethodNotEmpty();
        this.checkMultipart();
        if (ParameterUtil.isInvalidName(this.injectionModel.getMediatorUtils().connectionUtil().getTypeRequest())) {
            throw new InjectionFailureException(String.format("Illegal method: %s", this.injectionModel.getMediatorUtils().connectionUtil().getTypeRequest()));
        }
    }

    public static boolean isInvalidName(String token) {
        for (int i = 0; i < token.length(); ++i) {
            char c = token.charAt(i);
            if (c <= '\u00ff' && TCHAR[c]) continue;
            return true;
        }
        return token.isEmpty();
    }

    private void checkMultipart() throws InjectionFailureException {
        this.isMultipartRequest = false;
        if (this.getListHeader().stream().filter(entry -> "Content-Type".equals(entry.getKey())).anyMatch(entry -> entry.getValue() != null && ((String)entry.getValue()).contains("multipart/form-data") && ((String)entry.getValue()).contains("boundary="))) {
            LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "Multipart boundary found in header");
            Matcher matcherBoundary = Pattern.compile("boundary=([^;]*)").matcher(this.getHeaderFromEntries());
            if (matcherBoundary.find()) {
                String boundary = matcherBoundary.group(1);
                if (!this.rawRequest.contains(boundary)) {
                    throw new InjectionFailureException(String.format("Incorrect multipart data, boundary not found in body: %s", boundary));
                }
                this.isMultipartRequest = true;
            }
        }
    }

    private void checkOneOrLessStar() throws InjectionFailureException {
        int nbStarInParameter = 0;
        if (this.getQueryStringFromEntries().contains("*")) {
            ++nbStarInParameter;
        }
        if (this.getRequestFromEntries().contains("*")) {
            ++nbStarInParameter;
        }
        if (this.getHeaderFromEntries().contains("*")) {
            ++nbStarInParameter;
        }
        if (nbStarInParameter >= 2 || StringUtils.countMatches((CharSequence)this.getQueryStringFromEntries(), "*") >= 2 || StringUtils.countMatches((CharSequence)this.getRequestFromEntries(), "*") >= 2 || StringUtils.countMatches((CharSequence)this.getHeaderFromEntries(), "*") >= 2) {
            throw new InjectionFailureException("param selected or character insertion [*] can be only used once in URL, Request or Header");
        }
    }

    public void checkStarMatchMethod() throws InjectionFailureException {
        AbstractMethodInjection methodInjection = this.injectionModel.getMediatorUtils().connectionUtil().getMethodInjection();
        boolean isCheckingAllParam = this.injectionModel.getMediatorUtils().preferencesUtil().isCheckingAllParam();
        if (this.getQueryStringFromEntries().contains("*") && methodInjection != this.injectionModel.getMediatorMethod().getQuery() && !isCheckingAllParam) {
            throw new InjectionFailureException("param in URL selected but method Request or Header selected");
        }
        if (this.getRequestFromEntries().contains("*") && methodInjection != this.injectionModel.getMediatorMethod().getRequest() && !isCheckingAllParam) {
            throw new InjectionFailureException("param in Request selected but method URL or Header selected");
        }
        if (this.getHeaderFromEntries().contains("*") && methodInjection != this.injectionModel.getMediatorMethod().getHeader() && !isCheckingAllParam) {
            throw new InjectionFailureException("param in Header selected but method URL or Request selected");
        }
    }

    public void checkMethodNotEmpty() throws InjectionFailureException {
        AbstractMethodInjection methodInjection = this.injectionModel.getMediatorUtils().connectionUtil().getMethodInjection();
        if (methodInjection == this.injectionModel.getMediatorMethod().getQuery() && this.getListQueryString().isEmpty() && !this.injectionModel.getMediatorUtils().connectionUtil().getUrlBase().contains("*")) {
            throw new InjectionFailureException("empty URL param");
        }
        if (methodInjection == this.injectionModel.getMediatorMethod().getRequest() && this.getListRequest().isEmpty()) {
            throw new InjectionFailureException("empty Request param");
        }
        if (methodInjection == this.injectionModel.getMediatorMethod().getHeader() && this.getListHeader().isEmpty()) {
            throw new InjectionFailureException("empty Header param");
        }
    }

    public String initStar(AbstractMap.SimpleEntry<String, String> parameterToInject) {
        String characterInsertionByUser;
        if (parameterToInject == null) {
            characterInsertionByUser = "*";
        } else {
            characterInsertionByUser = parameterToInject.getValue();
            parameterToInject.setValue("*");
        }
        return characterInsertionByUser;
    }

    public void initQueryString(String urlQuery) throws MalformedURLException, URISyntaxException {
        this.initQueryString(urlQuery, "");
    }

    public void initQueryString(String urlQuery, String selectionCommand) throws MalformedURLException, URISyntaxException {
        URL url = new URI(urlQuery).toURL();
        if (StringUtils.isEmpty(urlQuery) || StringUtils.isEmpty(url.getHost())) {
            throw new MalformedURLException("empty URL");
        }
        this.injectionModel.getMediatorUtils().connectionUtil().setUrlByUser(urlQuery);
        this.injectionModel.getMediatorUtils().connectionUtil().setUrlBase(urlQuery);
        this.listQueryString.clear();
        Matcher regexQueryString = Pattern.compile("(.*\\?)(.*)").matcher(urlQuery);
        if (!regexQueryString.find()) {
            return;
        }
        this.injectionModel.getMediatorUtils().connectionUtil().setUrlBase(regexQueryString.group(1));
        if (StringUtils.isNotEmpty(url.getQuery())) {
            this.listQueryString = Pattern.compile("&").splitAsStream(url.getQuery()).map(keyValue -> Arrays.copyOf(keyValue.split("="), 2)).map(keyValue -> {
                String paramToAddStar = selectionCommand.replaceAll("^Query#", "");
                return new AbstractMap.SimpleEntry<String, CallSite>(keyValue[0], (CallSite)((Object)((keyValue[1] == null ? "" : keyValue[1]) + (paramToAddStar.equals(keyValue[0]) ? "*" : ""))));
            }).collect(Collectors.toCollection(CopyOnWriteArrayList::new));
        }
    }

    public void initRequest(String rawRequest) {
        this.initRequest(rawRequest, "");
    }

    public void initRequest(String rawRequest, String selectionCommand) {
        this.rawRequest = rawRequest;
        this.listRequest.clear();
        if (StringUtils.isNotEmpty(rawRequest)) {
            this.listRequest = this.isMultipartRequest ? new CopyOnWriteArrayList<AbstractMap.SimpleEntry<String, String>>(List.of(new AbstractMap.SimpleEntry<String, String>(rawRequest, ""))) : (List)Pattern.compile("&").splitAsStream(rawRequest).map(keyValue -> Arrays.copyOf(keyValue.split("="), 2)).map(keyValue -> {
                String paramToAddStar = selectionCommand.replaceAll("^Request#", "");
                return new AbstractMap.SimpleEntry<String, CallSite>(keyValue[0], (CallSite)((Object)((keyValue[1] == null ? "" : keyValue[1]) + (paramToAddStar.equals(keyValue[0]) ? "*" : ""))));
            }).collect(Collectors.toCollection(CopyOnWriteArrayList::new));
        }
    }

    public void initHeader(String rawHeader) {
        this.initHeader(rawHeader, "");
    }

    public void initHeader(String rawHeader, String selectionCommand) {
        this.rawHeader = rawHeader;
        this.listHeader.clear();
        if (StringUtils.isNotEmpty(rawHeader)) {
            this.listHeader = Pattern.compile("\\\\r\\\\n").splitAsStream(rawHeader).map(keyValue -> Arrays.copyOf(keyValue.split(":"), 2)).map(keyValue -> {
                String paramToAddStar = selectionCommand.replaceAll("^Header#", "");
                return new AbstractMap.SimpleEntry<String, CallSite>(keyValue[0], (CallSite)((Object)((keyValue[1] == null ? "" : keyValue[1]) + (paramToAddStar.equals(keyValue[0]) ? "*" : ""))));
            }).collect(Collectors.toCollection(CopyOnWriteArrayList::new));
        }
    }

    public String getQueryStringFromEntries() {
        return this.listQueryString.stream().filter(Objects::nonNull).map(entry -> {
            if (this.injectionModel.getMediatorStrategy().getStrategy() == this.injectionModel.getMediatorStrategy().getMultibit() && entry.getValue() != null && ((String)entry.getValue()).contains("*")) {
                return String.format(FORMAT_KEY_VALUE, entry.getKey(), "*");
            }
            return String.format(FORMAT_KEY_VALUE, entry.getKey(), entry.getValue());
        }).collect(Collectors.joining("&"));
    }

    public String getRequestFromEntries() {
        return this.listRequest.stream().filter(Objects::nonNull).map(entry -> String.format(FORMAT_KEY_VALUE, entry.getKey(), StringUtils.isEmpty((CharSequence)entry.getValue()) ? "" : entry.getValue())).collect(Collectors.joining("&"));
    }

    public String getHeaderFromEntries() {
        return this.listHeader.stream().filter(Objects::nonNull).map(entry -> String.format("%s:%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("\\r\\n"));
    }

    public boolean isRequestSoap() {
        return this.rawRequest.trim().matches("^(<soapenv:|<\\?xml).*");
    }

    public String getRawRequest() {
        return this.rawRequest;
    }

    public String getRawHeader() {
        return this.rawHeader;
    }

    public List<AbstractMap.SimpleEntry<String, String>> getListRequest() {
        return this.listRequest;
    }

    public List<AbstractMap.SimpleEntry<String, String>> getListHeader() {
        return this.listHeader;
    }

    public List<AbstractMap.SimpleEntry<String, String>> getListQueryString() {
        return this.listQueryString;
    }

    public boolean isMultipartRequest() {
        return this.isMultipartRequest;
    }

    static {
        char[] allowedTokenChars;
        LOGGER = LogManager.getRootLogger();
        TCHAR = new boolean[256];
        for (char c : allowedTokenChars = "!#$%&'*+-.^_`|~0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray()) {
            ParameterUtil.TCHAR[c] = true;
        }
    }
}

