/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	v1 "k8s.io/api/core/v1"
)

// PortRangeApplyConfiguration represents a declarative configuration of the PortRange type for use
// with apply.
type PortRangeApplyConfiguration struct {
	Protocol *v1.Protocol `json:"protocol,omitempty"`
	Start    *int32       `json:"start,omitempty"`
	End      *int32       `json:"end,omitempty"`
}

// PortRangeApplyConfiguration constructs a declarative configuration of the PortRange type for use with
// apply.
func PortRange() *PortRangeApplyConfiguration {
	return &PortRangeApplyConfiguration{}
}

// WithProtocol sets the Protocol field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Protocol field is set to the value of the last call.
func (b *PortRangeApplyConfiguration) WithProtocol(value v1.Protocol) *PortRangeApplyConfiguration {
	b.Protocol = &value
	return b
}

// WithStart sets the Start field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Start field is set to the value of the last call.
func (b *PortRangeApplyConfiguration) WithStart(value int32) *PortRangeApplyConfiguration {
	b.Start = &value
	return b
}

// WithEnd sets the End field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the End field is set to the value of the last call.
func (b *PortRangeApplyConfiguration) WithEnd(value int32) *PortRangeApplyConfiguration {
	b.End = &value
	return b
}
