"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const getPackageVersion_1 = require("./getPackageVersion");
describe("getPackageVersion", () => {
    beforeEach(() => {
        jest.resetModules();
    });
    const packagePath = "../package.json";
    it("should return version without change when already valid", () => {
        const packageJSON = {
            version: "1.2.3",
        };
        jest.mock(packagePath, () => {
            return packageJSON;
        });
        const expected = "1.2.3";
        expect(getPackageVersion_1.getPackageVersion(packagePath)).toEqual(expected);
    });
    it("should return version with prefix", () => {
        const packageJSON = {
            version: "v1.2.3",
        };
        jest.mock(packagePath, () => {
            return packageJSON;
        });
        const expected = "v1.2.3";
        expect(getPackageVersion_1.getPackageVersion(packagePath)).toEqual(expected);
    });
    it("should return invalid version without change", () => {
        const packageJSON = {
            version: "a.b.c",
        };
        jest.mock(packagePath, () => {
            return packageJSON;
        });
        const expected = "a.b.c";
        expect(getPackageVersion_1.getPackageVersion(packagePath)).toEqual(expected);
    });
    it("should return invalid version without build metadata", () => {
        const packageJSON = {
            version: "a.b.c+asd1234",
        };
        jest.mock(packagePath, () => {
            return packageJSON;
        });
        const expected = "a.b.c";
        expect(getPackageVersion_1.getPackageVersion(packagePath)).toEqual(expected);
    });
    it("should return version without build metadata", () => {
        const packageJSON = {
            version: "1.2.3+asd1234",
        };
        jest.mock(packagePath, () => {
            return packageJSON;
        });
        const expected = "1.2.3";
        expect(getPackageVersion_1.getPackageVersion(packagePath)).toEqual(expected);
    });
    it("should return version with prefix but without build metadata", () => {
        const packageJSON = {
            version: "v1.2.3+asd1234",
        };
        jest.mock(packagePath, () => {
            return packageJSON;
        });
        const expected = "v1.2.3";
        expect(getPackageVersion_1.getPackageVersion(packagePath)).toEqual(expected);
    });
});
//# sourceMappingURL=data:application/json;base64,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