import { last } from 'ramda';
import { MediaTypes } from '@swagger-api/apidom-core';
export class JSONSchemaDraft4MediaTypes extends MediaTypes {
  filterByFormat(format = 'generic') {
    const effectiveFormat = format === 'generic' ? 'schema;version' : format;
    return this.filter(mediaType => mediaType.includes(effectiveFormat));
  }
  findBy(version = 'draft-04', format = 'generic') {
    const search = format === 'generic' ? `schema;version=${version}` : `schema+${format};version=${version}`;
    const found = this.find(mediaType => mediaType.includes(search));
    return found || this.unknownMediaType;
  }
  latest(format = 'generic') {
    return last(this.filterByFormat(format));
  }
}
const mediaTypes = new JSONSchemaDraft4MediaTypes('application/schema;version=draft-04', 'application/schema+json;version=draft-04', 'application/schema+yaml;version=draft-04');
export default mediaTypes;