# misc module for Above (MAC Lookup)
# downloaded from https://standards-oui.ieee.org/oui/oui.csv

above_oui = {
    "78F276": "Cyklop Fastjet Technologies (Shanghai) Inc.",
    "286FB9": "Nokia Shanghai Bell Co.",
    "E0A129": "Extreme Networks Headquarters",
    "A8C647": "Extreme Networks Headquarters",
    "A4C7F6": "Extreme Networks Headquarters",
    "F4EAB5": "Extreme Networks Headquarters",
    "B87CF2": "Extreme Networks Headquarters",
    "887E25": "Extreme Networks Headquarters",
    "B42D56": "Extreme Networks Headquarters",
    "A473AB": "Extreme Networks Headquarters",
    "0C9B78": "Extreme Networks Headquarters",
    "001977": "Extreme Networks Headquarters",
    "08EA44": "Extreme Networks Headquarters",
    "001C0E": "Cisco Systems",
    "001906": "Cisco Systems",
    "00192F": "Cisco Systems",
    "9075DE": "Zebra Technologies Inc.",
    "80BA16": "Micas Networks Inc.",
    "B84C87": "IEEE Registration Authority",
    "20F83B": "Nabu Casa",
    "F01B24": "zte corporation",
    "E80AB9": "Cisco Systems",
    "78465F": "Fiberhome Telecommunication Technologies Co.",
    "38E2CA": "Katun Corporation",
    "E4C767": "Intel Corporate",
    "B05B99": "Sagemcom Broadband SAS",
    "9CE330": "Cisco Meraki",
    "04A959": "New H3C Technologies Co.",
    "0CB983": "Honor Device Co.",
    "2CB301": "Honor Device Co.",
    "E4F14C": "Private",
    "10061C": "Espressif Inc.",
    "DC7CF7": "China Mobile Group Device Co.",
    "906C4B": "Advance Security Electronics",
    "50E478": "Sichuan AI-Link Technology Co.",
    "6CFBED": "GN Audio A/S",
    "E4F27C": "Juniper Networks",
    "DCD160": "Tianjin Changdatong Technology Co.",
    "644ED7": "HP Inc.",
    "E00630": "HUAWEI TECHNOLOGIES CO.",
    "000E72": "Arca Technologies S.r.l.",
    "E0C2B7": "Masimo Corporation",
    "04D168": "Sunplus Technology Co.",
    "644C69": "CONPROVE",
    "902D77": "Edgecore Americas Networking Corporation",
    "C88BE8": "Masimo Corporation",
    "D48AFC": "Espressif Inc.",
    "E465B8": "Espressif Inc.",
    "E001C7": "Hui Zhou Gaoshengda Technology Co.",
    "B4DF91": "Cisco Meraki",
    "A881FE": "Luxul Tech Co.",
    "649A08": "Shenzhen SuperElectron Technology Co.",
    "90C710": "zte corporation",
    "98EE8C": "zte corporation",
    "48DA35": "IEEE Registration Authority",
    "48D475": "Lampuga GmbH",
    "601AC7": "Nintendo Co.",
    "50F222": "EM Microelectronic",
    "FC500C": "Sitehop Ltd",
    "CCEB5E": "Xiaomi Communications Co Ltd",
    "60C78D": "Juniper Networks",
    "DC5193": "zte corporation",
    "BCFD0C": "Shenzhen Phaten Tech. LTD",
    "1865C7": "Dongguan YIMO Technology Co.LTD",
    "307A57": "Accuenergy (CANADA) Inc",
    "7478A6": "Fortinet",
    "001982": "SmarDTV Corporation",
    "50FE0C": "AzureWave Technology Inc.",
    "ACD75B": "Sagemcom Broadband SAS",
    "B4C2E0": "Bouffalo Lab (Nanjing) Co.",
    "040986": "Arcadyan Corporation",
    "0C01C8": "DENSO Co.",
    "F42E48": "zte corporation",
    "F8D2AC": "Vantiva USA LLC",
    "CCF3C8": "Vantiva USA LLC",
    "60FDA6": "Apple",
    "80A997": "Apple",
    "348C5E": "Apple",
    "F0EE7A": "Apple",
    "203AEB": "zte corporation",
    "5876B3": "Ubee Interactive Co.",
    "E87072": "Hangzhou BroadLink Technology Co.",
    "40F3B0": "Texas Instruments",
    "149CEF": "Texas Instruments",
    "14987D": "Vantiva USA LLC",
    "58238C": "Vantiva USA LLC",
    "80B234": "Vantiva USA LLC",
    "8417EF": "Vantiva USA LLC",
    "A456CC": "Vantiva USA LLC",
    "70037E": "Vantiva USA LLC",
    "441C12": "Vantiva USA LLC",
    "481BA4": "Cisco Systems",
    "58AD12": "Apple",
    "80C41B": "Texas Instruments",
    "3468B5": "Texas Instruments",
    "D0B2C4": "Vantiva USA LLC",
    "80C6AB": "Vantiva USA LLC",
    "CC03FA": "Vantiva USA LLC",
    "48F7C0": "Vantiva USA LLC",
    "480033": "Vantiva USA LLC",
    "5C7695": "Vantiva USA LLC",
    "383FB3": "Vantiva USA LLC",
    "641236": "Vantiva USA LLC",
    "AC4CA5": "Vantiva USA LLC",
    "00CB7A": "Vantiva USA LLC",
    "B8A75E": "Wuxi Xinjie Electric Co.",
    "8C53E6": "Wistron Neweb Corporation",
    "D87766": "Nurivoice Co.",
    "708185": "New H3C Technologies Co.",
    "0C75D2": "Hangzhou Hikvision Digital Technology Co.",
    "D8DAF1": "HUAWEI TECHNOLOGIES CO.",
    "54443B": "HUAWEI TECHNOLOGIES CO.",
    "5C7075": "HUAWEI TECHNOLOGIES CO.",
    "8C3B4A": "Universal Global Scientific Industrial Co.",
    "50D33B": "cloudnineinfo",
    "84C8A0": "Hui Zhou Gaoshengda Technology Co.",
    "58C41E": "IEEE Registration Authority",
    "08F01E": "eero inc.",
    "18A5FF": "Arcadyan Corporation",
    "8C1AF3": "Shenzhen Gooxi Information Security CO.",
    "F4B6C6": "Indra Heera Technology LLP",
    "A002A5": "Intel Corporate",
    "8CD54A": "TAIYO YUDEN CO.",
    "A88B28": "SHENZHEN DIYANG SMART TECHNOLOGY CO.",
    "709883": "SHENZHEN KAYAN ELECTRONICS.",
    "C4799F": "Haiguang Smart Device Co.",
    "F43A7B": "zte corporation",
    "689E29": "zte corporation",
    "6C03B5": "Cisco Systems",
    "A89162": "Sophos Ltd",
    "E44097": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "DCB4CA": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "943BB1": "Kaon Group Co.",
    "44F034": "Kaon Group Co.",
    "5016F4": "Motorola Mobility LLC",
    "3C08CD": "Juniper Networks",
    "888F10": "Shenzhen Max Infinite Technology Co.",
    "68505D": "Halo Technologies",
    "7C6A8A": "SINOBONDER Technology Co.",
    "90ECE3": "Nokia",
    "887B2C": "zte corporation",
    "60DBEF": "Unify Software and Solutions GmbH & Co. KG",
    "408432": "Microchip Technology Inc.",
    "842859": "Amazon Technologies Inc.",
    "ACC048": "OnePlus Technology (Shenzhen) Co.",
    "905607": "Sichuan AI-Link Technology Co.",
    "483133": "Robert Bosch Elektronika Kft.",
    "B8AB61": "Cisco Meraki",
    "44D5C1": "EM Microelectronic",
    "40B7FC": "Phyplus Microelectronics Limited",
    "682C4F": "leerang corporation",
    "FC59C0": "Arista Networks",
    "641B2F": "Samsung Electronics Co.",
    "68DDB7": "TP-LINK TECHNOLOGIES CO.",
    "14D864": "TP-LINK TECHNOLOGIES CO.",
    "B851A9": "Nokia",
    "D077CE": "Edgecore Networks Corporation",
    "ECAFF9": "Hailo Technologies Ltd.",
    "60152B": "Palo Alto Networks",
    "28EC22": "eero inc.",
    "40D4F6": "Honor Device Co.",
    "7C3180": "SMK corporation",
    "782DAD": "HUAWEI TECHNOLOGIES CO.",
    "D06158": "HUAWEI TECHNOLOGIES CO.",
    "244BF1": "HUAWEI TECHNOLOGIES CO.",
    "44D77E": "Robert Bosch GmbH",
    "0016F6": "Nevion",
    "9C73B1": "Samsung Electronics Co.",
    "388A06": "Samsung Electronics Co.",
    "B0D888": "Panasonic Automotive Systems Co.",
    "843E1D": "Hui Zhou Gaoshengda Technology Co.",
    "40ED00": "TP-Link Corporation Limited",
    "908855": "Cisco Systems",
    "687161": "Cisco Systems",
    "883F37": "UHTEK CO.",
    "4893DC": "UNIWAY INFOCOM PVT LTD",
    "5CE688": "VECOS Europe B.V.",
    "D4BAFA": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "0080B8": "DMG MORI Digital Co.",
    "2873F6": "Amazon Technologies Inc.",
    "C4EBFF": "zte corporation",
    "5C2886": "Inventec(Chongqing) Corporation",
    "201582": "Apple",
    "E0CB1D": "Amazon Technologies Inc.",
    "FC84A7": "Murata Manufacturing Co.",
    "40921A": "Apple",
    "10E2C9": "Apple",
    "4CEC0F": "Cisco Systems",
    "3CCB4D": "Avikus Co.",
    "24A42C": "NETIO products a.s.",
    "702F86": "Marquardt GmbH",
    "A8881F": "SERVERCOM (INDIA) PRIVATE LIMITED",
    "601B52": "Vodafone Italia S.p.A.",
    "C08F20": "Shenzhen Skyworth Digital  Technology  CO.",
    "08FF24": "Shenzhen Skyworth Digital  Technology  CO.",
    "90B67A": "Shenzhen Skyworth Digital  Technology  CO.",
    "249AC8": "Shenzhen Skyworth Digital  Technology  CO.",
    "28C01B": "Shenzhen Skyworth Digital  Technology  CO.",
    "005079": "Private",
    "E028B1": "Shenzhen Skyworth Digital  Technology  CO.",
    "303180": "Shenzhen Skyworth Digital  Technology  CO.",
    "38A851": "Quickset Defense Technologies",
    "0436B8": "I&C Technology",
    "D0431E": "Dell Inc.",
    "204747": "Dell Inc.",
    "F0A0B1": "HUAWEI TECHNOLOGIES CO.",
    "404F42": "HUAWEI TECHNOLOGIES CO.",
    "3086F1": "Fiberhome Telecommunication Technologies Co.",
    "847BEB": "Dell Inc.",
    "989096": "Dell Inc.",
    "801844": "Dell Inc.",
    "9840BB": "Dell Inc.",
    "D481D7": "Dell Inc.",
    "00B0D0": "Dell Inc.",
    "0019B9": "Dell Inc.",
    "001AA0": "Dell Inc.",
    "002564": "Dell Inc.",
    "A4BADB": "Dell Inc.",
    "001C23": "Dell Inc.",
    "1100AA": "Private",
    "9C93E4": "Private",
    "782BCB": "Dell Inc.",
    "14FEB5": "Dell Inc.",
    "180373": "Dell Inc.",
    "74867A": "Dell Inc.",
    "A41F72": "Dell Inc.",
    "00C04F": "Dell Inc.",
    "000BDB": "Dell Inc.",
    "00123F": "Dell Inc.",
    "00CB00": "Private",
    "442063": "Continental Automotive Technologies GmbH",
    "581031": "Hon Hai Precision IND.CO.",
    "54BF64": "Dell Inc.",
    "CCC5E5": "Dell Inc.",
    "4CD98F": "Dell Inc.",
    "DCF401": "Dell Inc.",
    "6C2B59": "Dell Inc.",
    "C8F750": "Dell Inc.",
    "485A0D": "Juniper Networks",
    "D08E79": "Dell Inc.",
    "B44506": "Dell Inc.",
    "04BF1B": "Dell Inc.",
    "F80DA9": "Zyxel Communications Corporation",
    "98E743": "Dell Inc.",
    "185A58": "Dell Inc.",
    "E0D848": "Dell Inc.",
    "AC919B": "Wistron Neweb Corporation",
    "E03C1C": "IEEE Registration Authority",
    "000993": "Visteon Corporation",
    "EC41CA": "Shenzhen TecAnswer Technology co.",
    "148477": "New H3C Technologies Co.",
    "14962D": "New H3C Technologies Co.",
    "C4A64E": "Quectel Wireless Solutions Co.",
    "D858C6": "Katch Asset Tracking Pty Limited",
    "2CC6A0": "Lumacron Technology Ltd.",
    "7066B9": "Huawei Device Co.",
    "C4A1AE": "Huawei Device Co.",
    "486F33": "KYUNGWOO.SYSTEM",
    "086195": "Rockwell Automation",
    "24BBC9": "Shenzhen SuperElectron Technology Co.",
    "0000BC": "Rockwell Automation",
    "FCD749": "Amazon Technologies Inc.",
    "2C9682": "MitraStar Technology Corp.",
    "A87116": "Earda Technologies co Ltd",
    "E8EBDD": "Guangzhou Qingying Acoustics Technology Co.",
    "548C81": "Hangzhou Hikvision Digital Technology Co.",
    "244845": "Hangzhou Hikvision Digital Technology Co.",
    "0050CA": "DZS Inc.",
    "74EE8D": "Apollo Intelligent Connectivity (Beijing) Technology Co.",
    "000351": "Diebold Nixdorf",
    "F09FC2": "Ubiquiti Inc",
    "802AA8": "Ubiquiti Inc",
    "ECC89C": "Hangzhou Hikvision Digital Technology Co.",
    "8CE748": "Hangzhou Hikvision Digital Technology Co.",
    "2428FD": "Hangzhou Hikvision Digital Technology Co.",
    "ACB92F": "Hangzhou Hikvision Digital Technology Co.",
    "D4E853": "Hangzhou Hikvision Digital Technology Co.",
    "240F9B": "Hangzhou Hikvision Digital Technology Co.",
    "C06DED": "Hangzhou Hikvision Digital Technology Co.",
    "2432AE": "Hangzhou Hikvision Digital Technology Co.",
    "E0BAAD": "Hangzhou Hikvision Digital Technology Co.",
    "E0CA3C": "Hangzhou Hikvision Digital Technology Co.",
    "DC07F8": "Hangzhou Hikvision Digital Technology Co.",
    "64DB8B": "Hangzhou Hikvision Digital Technology Co.",
    "94E1AC": "Hangzhou Hikvision Digital Technology Co.",
    "5803FB": "Hangzhou Hikvision Digital Technology Co.",
    "4447CC": "Hangzhou Hikvision Digital Technology Co.",
    "98DF82": "Hangzhou Hikvision Digital Technology Co.",
    "788A20": "Ubiquiti Inc",
    "7483C2": "Ubiquiti Inc",
    "E063DA": "Ubiquiti Inc",
    "245A4C": "Ubiquiti Inc",
    "602232": "Ubiquiti Inc",
    "E43883": "Ubiquiti Inc",
    "C056E3": "Hangzhou Hikvision Digital Technology Co.",
    "BCAD28": "Hangzhou Hikvision Digital Technology Co.",
    "88B6BD": "Flaircomm Microelectronics",
    "BC49B2": "SHENZHEN ALONG COMMUNICATION TECH CO.",
    "9497AE": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "0CBD75": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "AC9073": "HUAWEI TECHNOLOGIES CO.",
    "FC1D3A": "HUAWEI TECHNOLOGIES CO.",
    "E4BEFB": "HUAWEI TECHNOLOGIES CO.",
    "58F8D7": "HUAWEI TECHNOLOGIES CO.",
    "40A677": "Juniper Networks",
    "D818D3": "Juniper Networks",
    "F04B3A": "Juniper Networks",
    "C042D0": "Juniper Networks",
    "001BC0": "Juniper Networks",
    "44ECCE": "Juniper Networks",
    "CCE194": "Juniper Networks",
    "788CB5": "TP-Link Corporation Limited",
    "288A1C": "Juniper Networks",
    "84B59C": "Juniper Networks",
    "5C4527": "Juniper Networks",
    "EC3EF7": "Juniper Networks",
    "204E71": "Juniper Networks",
    "D404FF": "Juniper Networks",
    "002159": "Juniper Networks",
    "00239C": "Juniper Networks",
    "50C58D": "Juniper Networks",
    "28C0DA": "Juniper Networks",
    "84C1C1": "Juniper Networks",
    "7CE2CA": "Juniper Networks",
    "48814E": "E&M SOLUTION CO",
    "7C4D8F": "HP Inc.",
    "9CCBF7": "CLOUD STAR TECHNOLOGY CO.",
    "74D558": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "B8EA98": "Xiaomi Communications Co Ltd",
    "10C4CA": "HUMAX Co.",
    "F46412": "Sony Interactive Entertainment Inc.",
    "3CF9F0": "zte corporation",
    "6877DA": "zte corporation",
    "8858BE": "kuosheng.com",
    "E45D37": "Juniper Networks",
    "94F7AD": "Juniper Networks",
    "784F9B": "Juniper Networks",
    "88D98F": "Juniper Networks",
    "78507C": "Juniper Networks",
    "F07CC7": "Juniper Networks",
    "AC800A": "Sony Corporation",
    "58C935": "Chiun Mai Communication System",
    "E030F9": "Juniper Networks",
    "4C734F": "Juniper Networks",
    "D45A3F": "Juniper Networks",
    "04698F": "Juniper Networks",
    "000585": "Juniper Networks",
    "889009": "Juniper Networks",
    "00CC34": "Juniper Networks",
    "1C3B62": "HMD Global Oy",
    "A4A528": "Sichuan Tianyi Comheart Telecom Co.",
    "E878EE": "New H3C Technologies Co.",
    "ECA7AD": "Barrot Technology Co.",
    "00302B": "Inalp Solutions AG",
    "7473B4": "Apple",
    "A4FC14": "Apple",
    "A81AF1": "Apple",
    "705846": "Trig Avionics Limited",
    "0891A3": "Amazon Technologies Inc.",
    "0CD923": "GOCLOUD Networks(GAOKE Networks)",
    "44DBD2": "YEALINK(XIAMEN) NETWORK TECHNOLOGY CO.",
    "F0748D": "Ruijie Networks Co.",
    "CC08FA": "Apple",
    "909B6F": "Apple",
    "E0DCA0": "Siemens Industrial Automation Products Ltd.",
    "9CDBAF": "HUAWEI TECHNOLOGIES CO.",
    "0C2E57": "HUAWEI TECHNOLOGIES CO.",
    "E8D775": "HUAWEI TECHNOLOGIES CO.",
    "84398F": "Fortinet",
    "B4EDD5": "Quectel Wireless Solutions Co.",
    "5C64F1": "Cisco Systems",
    "B838EF": "ADVA Optical Networking Ltd.",
    "64EC65": "vivo Mobile Communication Co.",
    "F42462": "Selcom Electronics (Shanghai) Co.",
    "F4A17F": "Marquardt Electronics Technology (Shanghai) Co.Ltd",
    "48BCE1": "Samsung Electronics Co.",
    "F83C80": "MITSUMI ELECTRIC CO.",
    "D83ADD": "Raspberry Pi Trading Ltd",
    "70F8AE": "Microsoft Corporation",
    "000F2A": "Cableware Electronics",
    "2CD1C6": "Murata Manufacturing Co.",
    "084218": "Asyril SA",
    "D85B22": "Shenzhen Hohunet Technology Co.",
    "D0D003": "Samsung Electronics Co.",
    "5C76D5": "Nokia",
    "8C7A00": "Nokia",
    "B85CEE": "Baidu Online Network Technology (Beijing) Co.",
    "28B5E8": "Texas Instruments",
    "08C3B3": "TCL King Electrical Appliances(Huizhou)Co.",
    "204569": "ITEL MOBILE LIMITED",
    "D46352": "Vutility Inc.",
    "505A65": "AzureWave Technology Inc.",
    "C4A559": "IEEE Registration Authority",
    "BC64D9": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "2CAB33": "Texas Instruments",
    "DCAC6F": "Everytale Inc",
    "F41532": "PETAiO (NanJing)",
    "301F48": "zte corporation",
    "7CC74A": "Fiberhome Telecommunication Technologies Co.",
    "38FC34": "Huawei Device Co.",
    "3CF692": "Huawei Device Co.",
    "940EE7": "HUAWEI TECHNOLOGIES CO.",
    "A8B271": "HUAWEI TECHNOLOGIES CO.",
    "6405E4": "ALPSALPINE CO",
    "6C0C9A": "Amazon Technologies Inc.",
    "CC00F1": "Sagemcom Broadband SAS",
    "308216": "Apple",
    "C4A052": "Motorola Mobility LLC",
    "84900A": "Arcadyan Corporation",
    "787689": "eero inc.",
    "487706": "NXP Semiconductor (Tianjin) LTD.",
    "0CCC47": "IEEE Registration Authority",
    "5C3E06": "Cisco Systems",
    "C828E5": "Cisco Systems",
    "8CD0B2": "Beijing Xiaomi Mobile Software Co.",
    "B0FC88": "Sagemcom Broadband SAS",
    "34873D": "Quectel Wireless Solutions Co.",
    "C44137": "Quectel Wireless Solutions Co.",
    "D821DA": "SERNET (SUZHOU) TECHNOLOGIES CORPORATION",
    "08F1B3": "Cisco Meraki",
    "BCE8FA": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "10D680": "Tendyron Corporation",
    "F41A9C": "Xiaomi Communications Co Ltd",
    "003E73": "Mist Systems",
    "0CFC18": "HUAWEI TECHNOLOGIES CO.",
    "8076C2": "GD Midea Air-Conditioning Equipment Co.",
    "F04A3D": "Bosch Thermotechnik GmbH",
    "941FA2": "Wuhan YuXin Semiconductor Co.",
    "6CD199": "vivo Mobile Communication Co.",
    "B49DFD": "Shenzhen SDMC Technology CO.",
    "80AB4D": "Nokia Solutions and Networks GmbH & Co. KG",
    "4CBA7D": "Gemtek Technology Co.",
    "001AEB": "Allied Telesis K.K.",
    "DC0682": "Accessia Technology Ltd.",
    "44D267": "Snorble",
    "B0BC7A": "Harman/Becker Automotive Systems GmbH",
    "F0221D": "IEEE Registration Authority",
    "9C5440": "ChengDu TD Tech",
    "5026EF": "Murata Manufacturing Co.",
    "74057C": "Qorvo International Pte. Ltd.",
    "D040BE": "NPO RPS LLC",
    "F44DAD": "Cable Matters Inc.",
    "FC3357": "KAGA FEI Co.",
    "500238": "Nokia Shanghai Bell Co.",
    "ACAD4B": "zte corporation",
    "A8169D": "Hui Zhou Gaoshengda Technology Co.",
    "444988": "Intel Corporate",
    "FC9189": "Sichuan Tianyi Comheart Telecom Co.",
    "F8F0C5": "Suzhou Kuhan Information Technologies Co.",
    "F8DE73": "HUAWEI TECHNOLOGIES CO.",
    "EC1A02": "HUAWEI TECHNOLOGIES CO.",
    "1C1A1B": "Shanghai Sunmi Technology Co.",
    "8038D4": "Fibercentury Network Technology Co.",
    "7C296F": "Apple",
    "40EDCF": "Apple",
    "8C986B": "Apple",
    "1C8682": "Apple",
    "8054E3": "Apple",
    "102E00": "Intel Corporate",
    "203A43": "Intel Corporate",
    "3C3B99": "ITEL MOBILE LIMITED",
    "D009C8": "Cisco Systems",
    "D03957": "Liteon Technology Corporation",
    "48E729": "Espressif Inc.",
    "E8BAE2": "Xplora Technologies AS",
    "5CA06C": "Realme Chongqing Mobile Telecommunications Corp.",
    "A83B76": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "9CDE4D": "ML vision Co.",
    "20318D": "Giax GmbH",
    "3CB07E": "Arounds Intelligent Equipment Co.",
    "C04E8A": "HUAWEI TECHNOLOGIES CO.",
    "68418F": "Telechips",
    "BC9EBB": "Nintendo Co.",
    "902778": "Open Infrastructure",
    "90DAF9": "Siemens Rail Automation SAU",
    "F8009D": "INTRACOM DEFENSE S.A.",
    "201642": "Microsoft Corporation",
    "CC8DB5": "Shenzhen SuperElectron Technology Co.",
    "ACEE64": "Shenzhen SuperElectron Technology Co.",
    "68EE4B": "Sharetronic Data Technology Co.",
    "48C35A": "LENOVO(BEIJING)CO.",
    "B4DB91": "CELESTICA INC.",
    "44643C": "Cisco Systems",
    "24161B": "Cisco Systems",
    "A8400B": "Visteon Corporation",
    "08569B": "WiZ",
    "60706C": "Google",
    "C82ADD": "Google",
    "240935": "Samsung Electronics Co.",
    "8C946A": "New H3C Technologies Co.",
    "FC1165": "Cambium Networks Limited",
    "40E11C": "shenzhen Cloud High Communication Technology Co.",
    "C0BFAC": "Huawei Device Co.",
    "44272E": "Huawei Device Co.",
    "106650": "Robert Bosch JuP1",
    "A80C03": "Florawise",
    "C48372": "IEEE Registration Authority",
    "C0A5E8": "Intel Corporate",
    "906584": "Intel Corporate",
    "28C5D2": "Intel Corporate",
    "081AFD": "Huawei Device Co.",
    "0012F3": "u-blox AG",
    "547068": "VTech Communications Limited",
    "C84052": "PAX Computer Technology(Shenzhen) Ltd.",
    "C461C7": "Microsoft Corporation",
    "ACCB36": "Fiberhome Telecommunication Technologies Co.",
    "FCDF00": "GD Midea Air-Conditioning Equipment Co.",
    "1C8B76": "Calix Inc.",
    "E48C73": "Realme Chongqing Mobile Telecommunications Corp.",
    "2CB6C8": "Raisecom Technology CO.",
    "D834D1": "Shenzhen Orange Digital Technology Co.",
    "842289": "Samsung Electronics Co.",
    "2C9452": "HUAWEI TECHNOLOGIES CO.",
    "6001B1": "HUAWEI TECHNOLOGIES CO.",
    "5CBBEE": "zte corporation",
    "84AAA4": "SONoC Corp.",
    "883C93": "Alcatel-Lucent Enterprise",
    "D0066A": "Cornelis Networks",
    "883CC5": "IEEE Registration Authority",
    "2C9E00": "Sony Interactive Entertainment Inc.",
    "DC6AE7": "Xiaomi Communications Co Ltd",
    "7CA449": "Xiaomi Communications Co Ltd",
    "982044": "New H3C Technologies Co.",
    "D8A0E8": "zte corporation",
    "E8BFDB": "Inodesign Group",
    "287E80": "Hui Zhou Gaoshengda Technology Co.",
    "0C9F71": "Dolphin Electronics (DongGuan) Co.",
    "745889": "Multilaser Industrial S.A.",
    "E8FF98": "Huawei Device Co.",
    "241551": "Huawei Device Co.",
    "58957E": "Huawei Device Co.",
    "B8144D": "Apple",
    "EC28D3": "Apple",
    "AC965B": "Lucid Motors",
    "086518": "Apple",
    "2C57CE": "Apple",
    "C404D8": "Aviva Links Inc.",
    "A044F3": "RafaelMicro",
    "F42B7D": "Chipsguide technology CO.",
    "8C5219": "SHARP Corporation",
    "089115": "Amazon Technologies Inc.",
    "74D423": "Amazon Technologies Inc.",
    "E04735": "Ericsson AB",
    "BCD767": "BAE Systems Apllied Intelligence",
    "EC1D9E": "Quectel Wireless Solutions Co.",
    "80646F": "Espressif Inc.",
    "80398C": "Samsung Electronics Co.",
    "980D6F": "Samsung Electronics Co.",
    "1C90FF": "Tuya Smart Inc.",
    "10823D": "Ruijie Networks Co.",
    "505FB5": "ASKEY COMPUTER CORP",
    "88DE7C": "ASKEY COMPUTER CORP",
    "045747": "GoPro",
    "80563C": "ZF",
    "909877": "Vestel Elektronik San ve Tic. A.S.",
    "3CA7AE": "zte corporation",
    "AC3184": "Huawei Device Co.",
    "503F50": "Huawei Device Co.",
    "2C691D": "IEEE Registration Authority",
    "40A53B": "Nokia",
    "74803F": "Renesas Electronics (Penang) Sdn. Bhd.",
    "5C60BA": "HP Inc.",
    "BCF88B": "zte corporation",
    "68539D": "EM Microelectronic",
    "E051D8": "China Dragon Technology Limited",
    "E8CC8C": "Chengdu Jiarui Hualian Communication Technology Co",
    "E46564": "SHENZHEN KTC TECHNOLOGY CO.",
    "E0EF02": "Chengdu Quanjing Intelligent Technology Co.",
    "4CA3A7": "TECNO MOBILE LIMITED",
    "B067B5": "Apple",
    "5C5284": "Apple",
    "C0956D": "Apple",
    "900A62": "Inventus Power Eletronica do Brasil LTDA",
    "0443FD": "Sichuan Tianyi Comheart Telecom Co.",
    "7CDE78": "New H3C Technologies Co.",
    "A4897E": "Guangzhou Yuhong Technology Co.",
    "ECA138": "Amazon Technologies Inc.",
    "3CE064": "Texas Instruments",
    "E0928F": "Texas Instruments",
    "CC037B": "Texas Instruments",
    "581CF8": "Intel Corporate",
    "AC198E": "Intel Corporate",
    "C85EA9": "Intel Corporate",
    "C8BF4C": "Beijing Xiaomi Mobile Software Co.",
    "3C39C8": "Apple",
    "A8ABB5": "Apple",
    "5864C4": "Apple",
    "AC84C6": "TP-LINK TECHNOLOGIES CO.",
    "1C0ED3": "Sichuan Tianyi Comheart Telecom Co.",
    "CC29BD": "zte corporation",
    "385CFB": "Silicon Laboratories",
    "C43D1A": "Intel Corporate",
    "04E8B9": "Intel Corporate",
    "E02E0B": "Intel Corporate",
    "380A4F": "PRACHI ENTERPRISES",
    "0CBEF1": "Huawei Device Co.",
    "AC936A": "Huawei Device Co.",
    "38A44B": "Huawei Device Co.",
    "801970": "Samsung Electronics Co.",
    "B8FBAF": "Xiamen IPRT Technology CO.",
    "348518": "Espressif Inc.",
    "549A11": "IEEE Registration Authority",
    "E0F728": "Amazon Technologies Inc.",
    "242934": "Google",
    "ECE6A2": "Fiberhome Telecommunication Technologies Co.",
    "3822F4": "Huawei Device Co.",
    "8002F4": "IEEE Registration Authority",
    "149BF3": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "B850D8": "Beijing Xiaomi Mobile Software Co.",
    "C09F51": "SERNET (SUZHOU) TECHNOLOGIES CORPORATION",
    "10071D": "Fiberhome Telecommunication Technologies Co.",
    "10B232": "Qingdao Intelligent&Precise Electronics Co.",
    "AC5AF0": "LG Electronics",
    "ECA62F": "HUAWEI TECHNOLOGIES CO.",
    "A0CDF3": "Murata Manufacturing Co.",
    "B48A0A": "Espressif Inc.",
    "C83A1B": "Toshiba TEC Corporation Inc",
    "C8C13C": "RuggedTek Hangzhou Co.",
    "5C53C3": "Ubee Interactive Co.",
    "8470D7": "eero inc.",
    "9C1FCA": "Hangzhou AlmightyDigit Technology Co.",
    "242CFE": "Zhejiang Tmall Technology Co.",
    "A042D1": "Huawei Device Co.",
    "58879F": "Huawei Device Co.",
    "2CDC78": "Descartes Systems (USA) LLC",
    "F4B3B1": "Silicon Laboratories",
    "581DD8": "Sagemcom Broadband SAS",
    "E8D87E": "Amazon Technologies Inc.",
    "30D587": "Samsung Electronics Co.",
    "08E63B": "zte corporation",
    "88C174": "zte corporation",
    "C89E61": "Lyngsoe Systems LTd",
    "6C1524": "IEEE Registration Authority",
    "C08D51": "Amazon Technologies Inc.",
    "44B4B2": "Amazon Technologies Inc.",
    "ACCCFC": "Amazon Technologies Inc.",
    "14F592": "Shenzhen SDG DONZHI Technology Co.",
    "4C09FA": "FRONTIER SMART TECHNOLOGIES LTD",
    "E8DC6C": "Cisco Systems",
    "68A7B4": "Honor Device Co.",
    "803C20": "HUAWEI TECHNOLOGIES CO.",
    "A4DD58": "HUAWEI TECHNOLOGIES CO.",
    "2C8217": "Apple",
    "78034F": "Nokia",
    "9C57BC": "eero inc.",
    "0015A6": "Digital Electronics Products Ltd.",
    "000AD0": "Niigata Develoment Center",
    "7CEF40": "Nextorage Corporation",
    "C0E01C": "IoT Security Group",
    "A8A237": "Arcadyan Corporation",
    "F8AB82": "Xiaomi Communications Co Ltd",
    "EC30B3": "Xiaomi Communications Co Ltd",
    "902CFB": "CanTops Co",
    "1CAF4A": "Samsung Electronics Co.",
    "C8120B": "Samsung Electronics Co.",
    "28BE43": "vivo Mobile Communication Co.",
    "2CFC8B": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "2874F5": "Nokia Solutions and Networks GmbH & Co. KG",
    "B03F64": "Apple",
    "142D4D": "Apple",
    "EC42CC": "Apple",
    "B8211C": "Apple",
    "A04466": "Intellics",
    "446D7F": "Amazon Technologies Inc.",
    "2406F2": "Sichuan Tianyi Comheart Telecom Co.",
    "AC8FA9": "Nokia Solutions and Networks GmbH & Co. KG",
    "44291E": "AltoBeam (China) Inc.",
    "24EBED": "HUAWEI TECHNOLOGIES CO.",
    "AC51AB": "HUAWEI TECHNOLOGIES CO.",
    "48CDD3": "HUAWEI TECHNOLOGIES CO.",
    "A8C98A": "New H3C Technologies Co.",
    "E0276C": "Guangzhou Shiyuan Electronic Technology Company Limited",
    "DC8E95": "Silicon Laboratories",
    "002604": "WorldCast Systems",
    "F8AD24": "Realme Chongqing Mobile Telecommunications Corp.",
    "CC6618": "Adtran Inc",
    "C0C170": "Shenzhen SuperElectron Technology Co.",
    "504289": "zte corporation",
    "04E31A": "Sagemcom Broadband SAS",
    "18BC57": "ADVA Optical Networking Ltd.",
    "D8E2DF": "Microsoft Corporation",
    "E8EBD3": "Mellanox Technologies",
    "6C999D": "Amazon Technologies Inc.",
    "6818D9": "Hill AFB - CAPRE Group",
    "1C61B4": "TP-Link Corporation Limited",
    "9CA2F4": "TP-Link Corporation Limited",
    "7C6A60": "China Mobile Group Device Co.",
    "B4695F": "TCT mobile ltd",
    "6C0F61": "Hypervolt Ltd",
    "24753A": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "6C9308": "IEEE Registration Authority",
    "388F30": "Samsung Electronics Co.",
    "84C692": "Texas Instruments",
    "6CB2FD": "Texas Instruments",
    "C0060C": "HUAWEI TECHNOLOGIES CO.",
    "B0A4F0": "HUAWEI TECHNOLOGIES CO.",
    "8C1553": "Beijing Memblaze Technology Co Ltd",
    "6CB158": "TP-LINK TECHNOLOGIES CO.",
    "A8537D": "Mist Systems",
    "303422": "eero inc.",
    "302BDC": "Top-Unum Electronics Co.",
    "90F7B2": "New H3C Technologies Co.",
    "1C47F6": "Zhidao Network Technology(Shenzhen) Co.",
    "000CD6": "PARTNER TECH",
    "D4BD4F": "Ruckus Wireless",
    "5CC9C0": "Renesas Electronics (Penang) Sdn. Bhd.",
    "E4DADF": "Taicang T&W Electronics",
    "7C35F8": "Zhejiang Tmall Technology Co.",
    "7426FF": "zte corporation",
    "C42728": "zte corporation",
    "C85895": "Motorola Mobility LLC",
    "E881AB": "Beijing Sankuai Online Technology Co.",
    "E8D322": "Cisco Systems",
    "2C3341": "China Mobile IOT Company Limited",
    "AC567B": "Sunnovo International Limited",
    "34D737": "IBG Industriebeteiligungsgesellschaft mbH &b Co. KG",
    "C07982": "TCL King Electrical Appliances(Huizhou)Co.",
    "7CC95E": "Dongguan Liesheng Electronic Co.",
    "9CC12D": "GD Midea Air-Conditioning Equipment Co.",
    "A0B4BF": "InfiNet LLC",
    "D0EDFF": "ZF CVCS",
    "988FE0": "IEEE Registration Authority",
    "F8A91F": "ZVISION Technologies Co.",
    "4CBAD7": "LG Innotek",
    "08E021": "Honor Device Co.",
    "8CC7C3": "NETLINK ICT",
    "B05C16": "Fiberhome Telecommunication Technologies Co.",
    "80657C": "Apple",
    "DC8084": "Apple",
    "102C8D": "GD Midea Air-Conditioning Equipment Co.",
    "C0FBC1": "ITEL MOBILE LIMITED",
    "9850A3": "SIGNALTEK JSC",
    "DC3643": "IEEE Registration Authority",
    "B0DD74": "Heimgard Technologies AS",
    "B48C9D": "AzureWave Technology Inc.",
    "50B3B4": "Shenzhen Furuilian Electronic Co.",
    "34B883": "Cisco Systems",
    "94E686": "Espressif Inc.",
    "F828C9": "HUAWEI TECHNOLOGIES CO.",
    "FC1193": "HUAWEI TECHNOLOGIES CO.",
    "7CCCFC": "Quectel Wireless Solutions Co.",
    "080076": "PC LAN TECHNOLOGIES",
    "D8B673": "Texas Instruments",
    "B4F267": "Compal Broadband Networks",
    "2CFDB4": "Shenzhen Jingxun Software Telecommunication Technology Co.",
    "38C804": "Hui Zhou Gaoshengda Technology Co.",
    "E007C2": "FUJIAN STAR-NET COMMUNICATION CO.",
    "84B4DB": "Silicon Laboratories",
    "1C70C9": "Jiangsu Aisida Electronic Co.",
    "3CF7D1": "OMRON Corporation",
    "04EEE8": "IEEE Registration Authority",
    "9CB8B4": "AMPAK Technology",
    "DCCCE6": "Samsung Electronics Co.",
    "F065AE": "Samsung Electronics Co.",
    "50874D": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "A05394": "Shenzhen zediel co.",
    "18D793": "IEEE Registration Authority",
    "E85177": "Qingdao Intelligent&Precise Electronics Co.",
    "388A21": "UAB Teltonika Telematics",
    "A05950": "Intel Corporate",
    "5089D1": "Huawei Device Co.",
    "A41752": "Hifocus Electronics India Private Limited",
    "00620B": "Broadcom Limited",
    "40FE95": "New H3C Technologies Co.",
    "E06D18": "PIONEERCORPORATION",
    "A45FB9": "DreamBig Semiconductor",
    "345D9E": "Sagemcom Broadband SAS",
    "18C23C": "Lumi United Technology Co.",
    "0475F9": "Taicang T&W Electronics",
    "BCD074": "Apple",
    "D4354A": "ALAXALA Networks Corporation",
    "40E99B": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
    "90FFD6": "Honor Device Co.",
    "0C1EF7": "Omni-ID",
    "B4D286": "Telechips",
    "58CF79": "Espressif Inc.",
    "786299": "BITSTREAM sp. z o.o.",
    "CC5B31": "Nintendo Co.",
    "B03CDC": "Intel Corporate",
    "C02B31": "Phytium Technology Co.",
    "000F32": "Lootom Telcovideo Network (Wuxi) Co Ltd",
    "8CF8C5": "Intel Corporate",
    "08F80D": "IEEE Registration Authority",
    "BC455B": "Samsung Electronics Co.",
    "78047A": "Edge Networks LLC",
    "CCA3BD": "ITEL MOBILE LIMITED",
    "BCAF87": "smartAC.com",
    "10E8A7": "Wistron Neweb Corporation",
    "A4EF15": "AltoBeam (China) Inc.",
    "C0280B": "Honor Device Co.",
    "9CEA97": "Honor Device Co.",
    "C89BAD": "Honor Device Co.",
    "A06C65": "Texas Instruments",
    "448502": "Shenzhen SuperElectron Technology Co.",
    "D49400": "HUAWEI TECHNOLOGIES CO.",
    "D42C46": "BUFFALO.INC",
    "1091A8": "Espressif Inc.",
    "806A00": "Cisco Systems",
    "F4A454": "IEEE Registration Authority",
    "58FCC6": "TOZO INC",
    "8415D3": "HUAWEI TECHNOLOGIES CO.",
    "1C4586": "Nintendo Co.",
    "185B00": "Nokia",
    "589B4A": "DWnet Technologies(Suzhou) Corporation",
    "F0AE66": "Cosonic Intelligent Technologies Co.",
    "3CA916": "Huawei Device Co.",
    "208097": "Shenzhen OXO Technology limited",
    "7C1689": "Sagemcom Broadband SAS",
    "5C83CD": "New platforms",
    "507C6F": "Intel Corporate",
    "305A99": "Sichuan Tianyi Comheart Telecom Co.",
    "604DE1": "HUAWEI TECHNOLOGIES CO.",
    "704E6B": "HUAWEI TECHNOLOGIES CO.",
    "603D29": "HUAWEI TECHNOLOGIES CO.",
    "54C480": "HUAWEI TECHNOLOGIES CO.",
    "F4573E": "Fiberhome Telecommunication Technologies Co.",
    "A861DF": "China Mobile Group Device Co.",
    "70C6DD": "New H3C Technologies Co.",
    "C41C07": "Samsung Electronics Co.",
    "4011C3": "Samsung Electronics Co.",
    "C47D9F": "Samsung Electronics Co.",
    "384B24": "SIEMENS AG",
    "3C9EC7": "SKY UK LIMITED",
    "282A87": "ITEL MOBILE LIMITED",
    "2426BA": "Shenzhen Toptel Technology Co.",
    "546CEB": "Intel Corporate",
    "009337": "Intel Corporate",
    "C04442": "Apple",
    "D468AA": "Apple",
    "F8C3CC": "Apple",
    "D8B053": "Xiaomi Communications Co Ltd",
    "6CF784": "Xiaomi Communications Co Ltd",
    "10A51D": "Intel Corporate",
    "088E90": "Intel Corporate",
    "58CE2A": "Intel Corporate",
    "042B58": "Shenzhen Hanzsung Technology Co.",
    "B812DA": "LVSWITCHES INC.",
    "A0D7F3": "Samsung Electronics Co.",
    "D866EE": "BOXIN COMMUNICATION CO.",
    "98DD60": "Apple",
    "7890A2": "zte corporation",
    "ACBCD9": "Cisco Systems",
    "7089F5": "Dongguan Lingjie IOT Co.",
    "9431CB": "vivo Mobile Communication Co.",
    "B8208E": "Panasonic Connect Co.",
    "847B57": "Intel Corporate",
    "E8F9D4": "HUAWEI TECHNOLOGIES CO.",
    "B0C787": "HUAWEI TECHNOLOGIES CO.",
    "0C4F9B": "HUAWEI TECHNOLOGIES CO.",
    "482FD7": "HUAWEI TECHNOLOGIES CO.",
    "24D81E": "MirWifi",
    "90380C": "Espressif Inc.",
    "7C214A": "Intel Corporate",
    "508492": "Intel Corporate",
    "9880BB": "IEEE Registration Authority",
    "F06C73": "Nokia",
    "9C756E": "Ajax Systems DMCC",
    "B43D08": "GX International BV",
    "64CBE9": "LG Innotek",
    "40B0A1": "VALCOM CO.",
    "103C59": "zte corporation",
    "607DDD": "Shenzhen Shichuangyi Electronics Co.",
    "AC5E14": "HUAWEI TECHNOLOGIES CO.",
    "20DF73": "HUAWEI TECHNOLOGIES CO.",
    "48128F": "HUAWEI TECHNOLOGIES CO.",
    "BC2228": "D-Link International",
    "947F1D": "Shenzhen Fastrain Technology Co.",
    "A4C69A": "Samsung Electronics Co.",
    "70B9BB": "Shenzhen Hankvision Technology CO.",
    "D48A3B": "HUNAN FN-LINK TECHNOLOGY LIMITED",
    "4006D5": "Cisco Systems",
    "C4CA2B": "Arista Networks",
    "40CA63": "Seongji Industry Company",
    "E4293D": "Shenzhen Sy-Fiber Optical Communication Technology.Co.",
    "9C5636": "Huawei Device Co.",
    "8CB87E": "Intel Corporate",
    "701AB8": "Intel Corporate",
    "5CDF89": "Ruckus Wireless",
    "D0F520": "KYOCERA Corporation",
    "70B64F": "Guangzhou V-SOLUTION Electronic Technology Co.",
    "B89470": "Calix Inc.",
    "EC1C5D": "Siemens AG",
    "D03F27": "Wyze Labs Inc",
    "50297B": "China Mobile Group Device Co.",
    "D0F121": "Xi'an LINKSCI Technology Co.",
    "6CDDEF": "EPCOMM Inc.",
    "B4205B": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "78444A": "Shenzhen Aiwinn information Technology Co.",
    "088EDC": "Apple",
    "A84A28": "Apple",
    "D8BE1F": "Apple",
    "98502E": "Apple",
    "580AD4": "Apple",
    "A477F3": "Apple",
    "CCBCE3": "HUAWEI TECHNOLOGIES CO.",
    "089E84": "HUAWEI TECHNOLOGIES CO.",
    "1082D7": "Realme Chongqing Mobile Telecommunications Corp.",
    "785EE8": "IEEE Registration Authority",
    "9C40CD": "Synclayer Inc.",
    "BC6AD1": "Xiaomi Communications Co Ltd",
    "0845D1": "Cisco Systems",
    "8427B6": "China Mobile IOT Company Limited",
    "10B7A8": "CableFree Networks Limited",
    "089BF1": "eero inc.",
    "3003C8": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "2CB8ED": "SonicWall",
    "500A52": "Huiwan Technologies Co. Ltd",
    "D49390": "CLEVO CO.",
    "B88C29": "GD Midea Air-Conditioning Equipment Co.",
    "5444A3": "Samsung Electronics Co.",
    "409CA6": "Curvalux",
    "807EB4": "Shenzhen SuperElectron Technology Co.",
    "BC062D": "Wacom Co.",
    "3C93F4": "HUAWEI TECHNOLOGIES CO.",
    "6433B5": "IEEE Registration Authority",
    "18E215": "Nokia",
    "8C4B14": "Espressif Inc.",
    "187758": "Audoo Limited (UK)",
    "44D454": "Sagemcom Broadband SAS",
    "6887C6": "Cisco Systems",
    "80248F": "Cisco Systems",
    "504B9E": "Huawei Device Co.",
    "047AAE": "Huawei Device Co.",
    "54A9D4": "Minibar Systems",
    "000062": "BULL HN INFORMATION SYSTEMS",
    "B4E454": "Amazon Technologies Inc.",
    "0C43F9": "Amazon Technologies Inc.",
    "D494FB": "Continental Automotive Systems Inc.",
    "D88083": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "FC4265": "Zhejiang Tmall Technology Co.",
    "C8C9A3": "Espressif Inc.",
    "E43BC9": "HISENSE VISUAL TECHNOLOGY CO.",
    "50E7A0": "Renesas Electronics (Penang) Sdn. Bhd.",
    "90E868": "AzureWave Technology Inc.",
    "4C50F1": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "E89526": "Luxshare Precision Industry CO.",
    "104121": "TELLESCOM INDUSTRIA E COMERCIO EM TELECOMUNICACAO",
    "3C7AF0": "ITEL MOBILE LIMITED",
    "48F3F3": "Baidu Online Network Technology (Beijing) Co.",
    "50411C": "AMPAK Technology",
    "F42679": "Intel Corporate",
    "44A92C": "IEEE Registration Authority",
    "84AC16": "Apple",
    "2CBC87": "Apple",
    "68F0D0": "SkyBell Technologies Inc.",
    "34B472": "Espressif Inc.",
    "F80C58": "Taicang T&W Electronics",
    "3861A5": "Grabango Co",
    "78D3ED": "NORMA",
    "8C1ED9": "Beijing Unigroup Tsingteng Microsystem Co.",
    "D47350": "DBG Commnunications Technology  Co.",
    "70DA17": "Austrian Audio GmbH",
    "FCA89B": "Texas Instruments",
    "98F07B": "Texas Instruments",
    "5078B0": "Huawei Device Co.",
    "E4072B": "Huawei Device Co.",
    "B03795": "LG Electronics",
    "A4FF95": "Nokia",
    "2446E4": "HUAWEI TECHNOLOGIES CO.",
    "F44637": "Intel Corporate",
    "0C718C": "TCT mobile ltd",
    "24085D": "Continental Aftermarket & Services GmbH",
    "38A659": "Sagemcom Broadband SAS",
    "781305": "IEEE Registration Authority",
    "681BEF": "HUAWEI TECHNOLOGIES CO.",
    "FC58DF": "Interphone Service",
    "981082": "Nsolution Co.",
    "A848FA": "Espressif Inc.",
    "505D7A": "zte corporation",
    "E4DC5F": "Cofractal",
    "081C6E": "Xiaomi Communications Co Ltd",
    "CC896C": "GN Hearing A/S",
    "6450D6": "Liquidtool Systems",
    "508140": "HP Inc.",
    "4CAB4F": "Apple",
    "9C583C": "Apple",
    "C41234": "Apple",
    "3CA6F6": "Apple",
    "34FE9E": "Fujitsu Limited",
    "38453B": "Ruckus Wireless",
    "7806C9": "Huawei Device Co.",
    "E8A6CA": "Huawei Device Co.",
    "CCFA66": "Huawei Device Co.",
    "68966A": "OHSUNG",
    "000901": "Shenzhen Shixuntong Information & Technoligy Co",
    "34243E": "zte corporation",
    "98ED7E": "eero inc.",
    "2C4881": "vivo Mobile Communication Co.",
    "E40CFD": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "58D697": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "5437BB": "Taicang T&W Electronics",
    "60F8F2": "Synaptec",
    "F463E7": "Nanjing Maxon O.E. Tech. Co.",
    "88AEDD": "EliteGroup Computer Systems Co.",
    "482218": "Shenzhen Yipingfang Network Technology Co.",
    "AC74B1": "Intel Corporate",
    "F46077": "Texas Instruments",
    "1C3CD4": "HUAWEI TECHNOLOGIES CO.",
    "F4E451": "HUAWEI TECHNOLOGIES CO.",
    "A0E70B": "Intel Corporate",
    "04EEEE": "Laplace System Co.",
    "30A176": "Fiberhome Telecommunication Technologies Co.",
    "6C108B": "WeLink Communications",
    "7C8530": "Nokia",
    "C03C04": "Sagemcom Broadband SAS",
    "A4D73C": "Seiko Epson Corporation",
    "000808": "PPT Vision",
    "F88EA1": "Edgecore Networks Corporation",
    "148919": "2bps",
    "58FD5D": "Hangzhou Xinyun technology Co.",
    "A45590": "Xiaomi Communications Co Ltd",
    "08010F": "Sichuan Tianyi Comheart Telecom Co.",
    "047153": "SERNET (SUZHOU) TECHNOLOGIES CORPORATION",
    "40C48C": "N-iTUS CO.",
    "4C7167": "PoLabs d.o.o.",
    "48E7DA": "AzureWave Technology Inc.",
    "F8BAE6": "Nokia",
    "BCECA0": "COMPAL INFORMATION (KUNSHAN) CO.",
    "24A799": "Huawei Device Co.",
    "7C3E74": "Huawei Device Co.",
    "185207": "Sichuan Tianyi Comheart Telecom Co.",
    "C42360": "Intel Corporate",
    "103D1C": "Intel Corporate",
    "3887D5": "Intel Corporate",
    "1CD107": "Realme Chongqing Mobile Telecommunications Corp.",
    "DC215C": "Intel Corporate",
    "9C1C37": "AltoBeam (China) Inc.",
    "2C0823": "Sercomm France Sarl",
    "B8A377": "Cisco Systems",
    "E44E2D": "Cisco Systems",
    "984265": "Sagemcom Broadband SAS",
    "806559": "EM Microelectronic",
    "D047C1": "Elma Electronic AG",
    "E0C63C": "Sichuan Tianyi Comheart Telecom Co.",
    "C0CC42": "Sichuan Tianyi Comheart Telecom Co.",
    "78D9E9": "MOMENTUM IOT",
    "C87B23": "Bose Corporation",
    "8C19B5": "Arcadyan Corporation",
    "D89AC1": "Nokia",
    "F0B11D": "Nokia",
    "7CD9F4": "UAB Teltonika Telematics",
    "F89753": "Huawei Device Co.",
    "5894AE": "Huawei Device Co.",
    "B03ACE": "Huawei Device Co.",
    "34AB95": "Espressif Inc.",
    "C491CF": "Luxul",
    "84AB26": "Tiinlab Corporation",
    "58356B": "TECNO MOBILE LIMITED",
    "F84CDA": "HUAWEI TECHNOLOGIES CO.",
    "A4D795": "Wingtech Mobile Communications Co.",
    "A4056E": "Tiinlab Corporation",
    "00047D": "Motorola Solutions Inc.",
    "A8934A": "CHONGQING FUGUI ELECTRONICS CO.",
    "FC4EA4": "Apple",
    "F4BEEC": "Apple",
    "54E61B": "Apple",
    "64644A": "Beijing Xiaomi Mobile Software Co.",
    "E89E0C": "MAX8USA DISTRIBUTORS INC.",
    "64808B": "VG Controls",
    "20896F": "Fiberhome Telecommunication Technologies Co.",
    "F4FBB8": "HUAWEI TECHNOLOGIES CO.",
    "0004AD": "Malibu Networks",
    "CC68B6": "TP-Link Corporation Limited",
    "14DD9C": "vivo Mobile Communication Co.",
    "CC3331": "Texas Instruments",
    "A439B6": "SHENZHEN PEIZHE MICROELECTRONICS CO .LTD",
    "BCFF4D": "Espressif Inc.",
    "C45BBE": "Espressif Inc.",
    "002618": "ASUSTek COMPUTER INC.",
    "A070B7": "HUAWEI TECHNOLOGIES CO.",
    "78B554": "Huawei Device Co.",
    "689E6A": "Huawei Device Co.",
    "282B96": "Huawei Device Co.",
    "1CD1E0": "Cisco Systems",
    "E8FD35": "Huawei Device Co.",
    "ECC5D2": "Huawei Device Co.",
    "24456B": "Huawei Device Co.",
    "483871": "Huawei Device Co.",
    "44BDDE": "BHTC GmbH",
    "8C2A8E": "DongGuan Ramaxel Memory Technology",
    "80071B": "VSOLUTION TELECOMMUNICATION TECHNOLOGY CO.",
    "B814DB": "OHSUNG",
    "FC13F0": "Bouffalo Lab (Nanjing) Co.",
    "FC9C98": "Arlo Technology",
    "B4608C": "Fiberhome Telecommunication Technologies Co.",
    "4044FD": "Realme Chongqing Mobile Telecommunications Corp.",
    "646EE0": "Intel Corporate",
    "0456E5": "Intel Corporate",
    "884604": "Xiaomi Communications Co Ltd",
    "F40223": "PAX Computer Technology(Shenzhen) Ltd.",
    "6479F0": "Intel Corporate",
    "081086": "NEC Platforms",
    "78653B": "Shaoxing Ourten Electronics Co.",
    "E0E656": "Nethesis  srl",
    "841EA3": "Sagemcom Broadband SAS",
    "1C6EE6": "NHNETWORKS",
    "08F606": "zte corporation",
    "84D608": "Wingtech Mobile Communications Co.",
    "346893": "Tecnovideo Srl",
    "0020C1": "SAXA",
    "4CF202": "Xiaomi Communications Co Ltd",
    "246968": "TP-LINK TECHNOLOGIES CO.",
    "FCA9DC": "Renesas Electronics (Penang) Sdn. Bhd.",
    "FC584A": "xiamenshi c-chip technology co.",
    "28D3EA": "Huawei Device Co.",
    "A8F266": "Huawei Device Co.",
    "CC9C3E": "Cisco Meraki",
    "4829E4": "AO",
    "84267A": "GUANGDONG TAIDE ZHILIAN TECHNOLOGY CO.",
    "6C4760": "Sunitec Enterprise Co.",
    "3C7AAA": "China Dragon Technology Limited",
    "84FD27": "Silicon Laboratories",
    "9023B4": "New H3C Technologies Co.",
    "882A5E": "New H3C Technologies Co.",
    "183219": "EM Microelectronic",
    "3C9BC6": "Huawei Device Co.",
    "0036BE": "Northwest Towers",
    "A45E5A": "ACTIVIO Inc.",
    "7C5079": "Intel Corporate",
    "8038FB": "Intel Corporate",
    "642656": "Shenzhen Fanweitai Technology Service Co.",
    "540910": "Apple",
    "9CFC28": "Apple",
    "B485E1": "Apple",
    "0C19F8": "Apple",
    "501FC6": "Apple",
    "CC69FA": "Apple",
    "10CEE9": "Apple",
    "749AC0": "Cachengo",
    "34587C": "MIRAE INFORMATION TECHNOLOGY CO.",
    "08B4B1": "Google",
    "A877E5": "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.",
    "10A4DA": "HUAWEI TECHNOLOGIES CO.",
    "382028": "HUAWEI TECHNOLOGIES CO.",
    "E47727": "HUAWEI TECHNOLOGIES CO.",
    "5C56A4": "Wanan Hongsheng Electronic Co.Ltd",
    "105107": "Intel Corporate",
    "AC74C4": "Maytronics Ltd.",
    "F4B301": "Intel Corporate",
    "E8D2FF": "Sagemcom Broadband SAS",
    "0C96CD": "MERCURY CORPORATION",
    "A03B01": "Kyung In Electronics",
    "145E69": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "A0A3F0": "D-Link International",
    "846569": "New H3C Technologies Co.",
    "34F716": "TP-LINK TECHNOLOGIES CO.",
    "AC8247": "Intel Corporate",
    "F0258E": "HUAWEI TECHNOLOGIES CO.",
    "9C746F": "HUAWEI TECHNOLOGIES CO.",
    "E06C4E": "Shenzhen TINNO Mobile Technology Corp.",
    "50558D": "China Mobile IOT Company Limited",
    "281B04": "Zalliant LLC",
    "18CE94": "Samsung Electronics Co.",
    "783716": "Samsung Electronics Co.",
    "64E003": "Hui Zhou Gaoshengda Technology Co.",
    "E8A0CD": "Nintendo Co.",
    "9C823F": "Huawei Device Co.",
    "54F607": "Huawei Device Co.",
    "7C5259": "Sichuan Jiuzhou Electronic Technology Co.",
    "C4E287": "HUAWEI TECHNOLOGIES CO.",
    "484C29": "HUAWEI TECHNOLOGIES CO.",
    "045FB9": "Cisco Systems",
    "102FA3": "Shenzhen Uvision-tech Technology Co.Ltd",
    "C4D438": "HUAWEI TECHNOLOGIES CO.",
    "143FA6": "Sony Home Entertainment&Sound Products Inc",
    "748B29": "Micobiomed",
    "E8F408": "Intel Corporate",
    "44D453": "Sagemcom Broadband SAS",
    "DCCD74": "Japan E.M.Solutions Co.",
    "04495D": "Huawei Device Co.",
    "F0FEE7": "Huawei Device Co.",
    "54211D": "Huawei Device Co.",
    "DCA120": "Nokia",
    "50523B": "Nokia",
    "58B0FE": "Team EPS GmbH",
    "5C6F69": "Broadcom Limited",
    "D012CB": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
    "20FF36": "IFLYTEK CO.",
    "2406AA": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "8CAE49": "IEEE Registration Authority",
    "24649F": "Huawei Device Co.",
    "0C1773": "Huawei Device Co.",
    "E81E92": "Huawei Device Co.",
    "888E68": "Huawei Device Co.",
    "807484": "ALL Winner (Hong Kong) Limited",
    "88238C": "Fiberhome Telecommunication Technologies Co.",
    "78CF2F": "HUAWEI TECHNOLOGIES CO.",
    "A83B5C": "HUAWEI TECHNOLOGIES CO.",
    "A8CC6F": "HMD Global Oy",
    "989AB9": "zte corporation",
    "4C20B8": "Apple",
    "003192": "TP-Link Corporation Limited",
    "843095": "Hon Hai Precision IND.CO.",
    "008A55": "Huawei Device Co.",
    "64A28A": "Huawei Device Co.",
    "AC471B": "Huawei Device Co.",
    "A4CCB9": "Realme Chongqing Mobile Telecommunications Corp.",
    "6CB881": "zte corporation",
    "EC0DE4": "Amazon Technologies Inc.",
    "B04530": "SKY UK LIMITED",
    "6CA0B4": "SKY UK LIMITED",
    "1488E6": "Apple",
    "B456E3": "Apple",
    "241145": "Xiaomi Communications Co Ltd",
    "7895EB": "ITEL MOBILE LIMITED",
    "B0BBE5": "Sagemcom Broadband SAS",
    "8CFDDE": "Sagemcom Broadband SAS",
    "1C9F4E": "COOSEA GROUP (HK) COMPANY LIMITED",
    "A468BC": "Oakley Inc.",
    "B0C53C": "Cisco Systems",
    "ECCE13": "Cisco Systems",
    "0865F0": "JM Zengge Co.",
    "3C6105": "Espressif Inc.",
    "607EA4": "Shanghai Imilab Technology Co.Ltd",
    "48D890": "FN-LINK TECHNOLOGY LIMITED",
    "781F11": "RAB Lighting",
    "14AB02": "HUAWEI TECHNOLOGIES CO.",
    "C418E9": "Samsung Electronics Co.",
    "1CE57F": "Samsung Electronics Co.",
    "085531": "Routerboard.com",
    "8C55BB": "Songwoo Information & Technology Co.",
    "7C8FDE": "DWnet Technologies(Suzhou) Corporation",
    "0838E6": "Motorola (Wuhan) Mobility Technologies Communication Co.",
    "E8C2DD": "Infinix mobility limited",
    "C41C9C": "JiQiDao",
    "847127": "Silicon Laboratories",
    "98F181": "New H3C Technologies Co.",
    "F0F7E7": "HUAWEI TECHNOLOGIES CO.",
    "00042B": "IT Access Co.",
    "40A9CF": "Amazon Technologies Inc.",
    "90808F": "Huawei Device Co.",
    "107100": "Huawei Device Co.",
    "F8B95A": "LG Innotek",
    "D44F67": "HUAWEI TECHNOLOGIES CO.",
    "B4FF98": "HUAWEI TECHNOLOGIES CO.",
    "5895D8": "IEEE Registration Authority",
    "F80DAC": "HP Inc.",
    "E44791": "Iris ID Systems",
    "F013C1": "Hannto Technology Co.",
    "8850F6": "Shenzhen Jingxun Software Telecommunication Technology Co.",
    "849DC2": "Shanghai MXCHIP Information Technology Co.",
    "184516": "Texas Instruments",
    "D02EAB": "Texas Instruments",
    "8454DF": "Huawei Device Co.",
    "40B5C1": "Cisco Systems",
    "E884A5": "Intel Corporate",
    "00C035": "QUINTAR COMPANY",
    "0405DD": "Shenzhen Cultraview Digital Technology Co.",
    "3897A4": "ELECOM CO.",
    "E433AE": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "387A3C": "Fiberhome Telecommunication Technologies Co.",
    "8CCE4E": "Espressif Inc.",
    "1C501E": "Sunplus Technology Co.",
    "409505": "ACOINFO TECHNOLOGY CO.",
    "5CD89E": "Huawei Device Co.",
    "DCE994": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "B82D28": "AMPAK Technology",
    "A4134E": "Luxul",
    "FC66CF": "Apple",
    "AC1D06": "Apple",
    "44A8FC": "Apple",
    "F81093": "Apple",
    "B85F98": "Amazon Technologies Inc.",
    "D8F883": "Intel Corporate",
    "B436D1": "Renesas Electronics (Penang) Sdn. Bhd.",
    "14A9D0": "F5 Networks",
    "000A49": "F5 Networks",
    "0094A1": "F5 Networks",
    "80F1F1": "Tech4home",
    "DC774C": "Cisco Systems",
    "204441": "Remote Solution",
    "FC4482": "Intel Corporate",
    "A085FC": "Microsoft Corporation",
    "101965": "New H3C Technologies Co.",
    "94FF61": "China Mobile Group Device Co.",
    "006151": "HUAWEI TECHNOLOGIES CO.",
    "BC76C5": "HUAWEI TECHNOLOGIES CO.",
    "5C0272": "Silicon Laboratories",
    "000430": "Netgem",
    "0446CF": "Beijing Venustech Cybervision Co.",
    "B88035": "Shenzhen Qihu Intelligent Technology Company Limited",
    "9012A1": "We Corporation Inc.",
    "64B623": "Schrack Seconet Care Communication GmbH",
    "E81B69": "Sercomm Corporation.",
    "6852D6": "UGame Technology Co.",
    "FC1999": "Xiaomi Communications Co Ltd",
    "CC874A": "Nokia",
    "A45129": "XAG",
    "B4C26A": "Garmin International",
    "78F8B8": "Rako Controls Ltd",
    "6CE5F7": "New H3C Technologies Co.",
    "B8DD71": "zte corporation",
    "F4E578": "LLC Proizvodstvennaya Kompania TransService",
    "0854BB": "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.",
    "3CB15B": "Avaya Inc",
    "5865E6": "infomark",
    "08FBEA": "AMPAK Technology",
    "3C9C0F": "Intel Corporate",
    "000EFF": "Megasolution",
    "702C09": "Nintendo Co.",
    "E4D373": "HUAWEI TECHNOLOGIES CO.",
    "C0BC9A": "HUAWEI TECHNOLOGIES CO.",
    "5C443E": "Skullcandy",
    "F88200": "CaptionCall",
    "0050F1": "Maxlinear",
    "1C5D80": "Mitubishi Hitachi Power Systems Industries Co.",
    "60EB5A": "Asterfusion Data Technologies Co.",
    "801605": "Vodafone Italia S.p.A.",
    "00C09F": "Quanta Computer Inc.",
    "C80AA9": "Quanta Computer Inc.",
    "60EB69": "Quanta Computer Inc.",
    "74F7F6": "Shanghai Sunmi Technology Co.",
    "A802DB": "zte corporation",
    "B42330": "Itron Inc",
    "000895": "DIRC Technologie GmbH & Co.KG",
    "A022DE": "vivo Mobile Communication Co.",
    "FC73FB": "HUAWEI TECHNOLOGIES CO.",
    "00269E": "Quanta Computer Inc.",
    "C45444": "Quanta Computer Inc.",
    "001B24": "Quanta Computer Inc.",
    "241AE6": "Huawei Device Co.",
    "60B76E": "Google",
    "00927D": "Ficosa Internationa(Taicang) C0.",
    "441622": "Microsoft Corporation",
    "044562": "ANDRA Sp. z o. o.",
    "94AEF0": "Cisco Systems",
    "DCD9AE": "Nokia Shanghai Bell Co.",
    "C4366C": "LG Innotek",
    "1C08C1": "LG Innotek",
    "A497B1": "CHONGQING FUGUI ELECTRONICS CO.",
    "D440D0": "OCOSMOS Co.",
    "44E6B0": "China Mobile IOT Company Limited",
    "747A90": "Murata Manufacturing Co.",
    "58B623": "Beijing Xiaomi Mobile Software Co.",
    "14007D": "zte corporation",
    "24E9CA": "Huawei Device Co.",
    "BCA993": "Cambium Networks Limited",
    "703AA6": "New H3C Technologies Co.",
    "8CCEFD": "Shenzhen zhouhai technology co.",
    "50FB19": "CHIPSEA TECHNOLOGIES (SHENZHEN) CORP.",
    "9408C7": "Huawei Device Co.",
    "C8CA63": "Huawei Device Co.",
    "9437F7": "Huawei Device Co.",
    "D0C637": "Intel Corporate",
    "903FEA": "HUAWEI TECHNOLOGIES CO.",
    "20AB48": "HUAWEI TECHNOLOGIES CO.",
    "CCD73C": "HUAWEI TECHNOLOGIES CO.",
    "98B8BC": "Samsung Electronics Co.",
    "184E16": "Samsung Electronics Co.",
    "C03D03": "Samsung Electronics Co.",
    "10746F": "MOTOROLA SOLUTIONS MALAYSIA SDN. BHD.",
    "94E70B": "Intel Corporate",
    "046C59": "Intel Corporate",
    "D4ABCD": "Hui Zhou Gaoshengda Technology Co.",
    "34EAE7": "Shanghai High-Flying Electronics  Technology Co.",
    "E00EE4": "DWnet Technologies(Suzhou) Corporation",
    "58FDB1": "LG Electronics",
    "A0CAA5": "INTELLIGENCE TECHNOLOGY OF CEC CO.",
    "D49234": "NEC Corporation",
    "386893": "Intel Corporate",
    "E8854B": "Apple",
    "28EC95": "Apple",
    "E02B96": "Apple",
    "F041C6": "Heat Tech Company",
    "E43A65": "MofiNetwork Inc",
    "F86C03": "Shenzhen Teleone Technology Co.",
    "105DDC": "Huawei Device Co.",
    "DC7385": "Huawei Device Co.",
    "5455D5": "Huawei Device Co.",
    "184593": "Taicang T&W Electronics",
    "CC9ECA": "HMD Global Oy",
    "3C306F": "HUAWEI TECHNOLOGIES CO.",
    "80E1BF": "HUAWEI TECHNOLOGIES CO.",
    "482CD0": "HUAWEI TECHNOLOGIES CO.",
    "D8714D": "Texas Instruments",
    "0CEC80": "Texas Instruments",
    "C49886": "Qorvo International Pte. Ltd.",
    "5C0FFB": "Amino Communications Ltd",
    "3CF652": "zte corporation",
    "E82A44": "Liteon Technology Corporation",
    "48E1E9": "Chengdu Meross Technology Co.",
    "08B055": "ASKEY COMPUTER CORP",
    "08AA55": "Motorola Mobility LLC",
    "709F2D": "zte corporation",
    "A0DE0F": "Huawei Device Co.",
    "F487C5": "Huawei Device Co.",
    "7458F3": "Amazon Technologies Inc.",
    "54219D": "Samsung Electronics Co.",
    "A80577": "Netlist",
    "404028": "ZIV",
    "70039F": "Espressif Inc.",
    "882B94": "MADOKA SYSTEM Co.",
    "7CEF61": "STR Elektronik Josef Schlechtinger GmbH",
    "400589": "T-Mobile",
    "64A965": "Linkflow Co.",
    "68E209": "HUAWEI TECHNOLOGIES CO.",
    "F4308B": "Xiaomi Communications Co Ltd",
    "DC6B12": "worldcns inc.",
    "001354": "Zcomax Technologies",
    "C09BF4": "IEEE Registration Authority",
    "282373": "Digita",
    "D0ABD5": "Intel Corporate",
    "D4C1C8": "zte corporation",
    "88D274": "zte corporation",
    "30B237": "GD Midea Air-Conditioning Equipment Co.",
    "B0B5C3": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "4CCE2D": "Danlaw Inc",
    "BC5A56": "Cisco Systems",
    "BC0F9A": "D-Link International",
    "AC4A56": "Cisco Systems",
    "704A0E": "AMPAK Technology",
    "B0E4D5": "Google",
    "0C35FE": "Fiberhome Telecommunication Technologies Co.",
    "8C83DF": "Nokia",
    "30B9B0": "Intracom Asia Co.",
    "94E7EA": "HUAWEI TECHNOLOGIES CO.",
    "94E4BA": "Huawei Device Co.",
    "347146": "Huawei Device Co.",
    "2CC546": "Huawei Device Co.",
    "0C839A": "Huawei Device Co.",
    "E0E0FC": "Huawei Device Co.",
    "E0D4E8": "Intel Corporate",
    "305075": "GN Audio A/S",
    "90EC77": "silicom",
    "F4B78D": "HUAWEI TECHNOLOGIES CO.",
    "A416E7": "HUAWEI TECHNOLOGIES CO.",
    "B40931": "HUAWEI TECHNOLOGIES CO.",
    "AC4B1E": "Integri-Sys.Com LLC",
    "6869CA": "Hitachi",
    "D4DACD": "SKY UK LIMITED",
    "F4DBE3": "Apple",
    "BC428C": "ALPSALPINE CO",
    "D45EEC": "Beijing Xiaomi Electronics Co.",
    "88C397": "Beijing Xiaomi Mobile Software Co.",
    "04BDBF": "Samsung Electronics Co.",
    "BC7ABF": "Samsung Electronics Co.",
    "60684E": "Samsung Electronics Co.",
    "4C4576": "China Mobile(Hangzhou) Information Technology Co.",
    "74C929": "Zhejiang Dahua Technology Co.",
    "94CC04": "IEEE Registration Authority",
    "8020FD": "Samsung Electronics Co.",
    "B4CE40": "Samsung Electronics Co.",
    "9CC9EB": "NETGEAR",
    "5CB29E": "ASCO Power Technologies",
    "B440A4": "Apple",
    "48B8A3": "Apple",
    "30809B": "New H3C Technologies Co.",
    "64F2FB": "Hangzhou Ezviz Software Co.",
    "6C0D34": "Nokia",
    "F419E2": "Volterra",
    "D807B6": "TP-LINK TECHNOLOGIES CO.",
    "646E97": "TP-LINK TECHNOLOGIES CO.",
    "D84DB9": "Wu Qi Technologies",
    "A04F85": "LG Electronics (Mobile Communications)",
    "6C1632": "HUAWEI TECHNOLOGIES CO.",
    "2C1A01": "HUAWEI TECHNOLOGIES CO.",
    "24169D": "Cisco Systems",
    "00233D": "Laird Technologies",
    "7422BB": "Huawei Device Co.",
    "347839": "zte corporation",
    "30AB6A": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
    "749BE8": "Hitron Technologies. Inc",
    "4C6371": "Xiaomi Communications Co Ltd",
    "00DD25": "Shenzhen hechengdong Technology Co.",
    "8C6078": "Swissbit AG",
    "F80DF0": "zte corporation",
    "5CBAEF": "CHONGQING FUGUI ELECTRONICS CO.",
    "000ADB": "Trilliant",
    "0445A1": "NIRIT- Xinwei  Telecom Technology Co.",
    "9CE91C": "zte corporation",
    "14F6D8": "Intel Corporate",
    "8C97EA": "FREEBOX SAS",
    "8020E1": "BVBA DPTechnics",
    "FC8E6E": "StreamCCTV",
    "788B2A": "Zhen Shi Information Technology (Shanghai) Co.",
    "AC64CF": "FN-LINK TECHNOLOGY LIMITED",
    "5C17CF": "OnePlus Technology (Shenzhen) Co.",
    "102959": "Apple",
    "E47684": "Apple",
    "F05CD5": "Apple",
    "E02AE6": "Fiberhome Telecommunication Technologies Co.",
    "3CDA6D": "Tiandy Technologies CO.",
    "A4FA76": "New H3C Technologies Co.",
    "3CFAD3": "IEEE Registration Authority",
    "48B02D": "NVIDIA Corporation",
    "B41A1D": "Samsung Electronics Co.",
    "F06728": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "9CE176": "Cisco Systems",
    "70EA5A": "Apple",
    "18AFA1": "Shenzhen Yifang Network Technology Co.",
    "54CE69": "Hikari Trading Co.",
    "6CAEF6": "eero inc.",
    "FCF5C4": "Espressif Inc.",
    "E826B6": "Companies House to GlucoRx Technologies Ltd.",
    "00763D": "Veea",
    "C014B8": "Nokia",
    "D028BA": "Realme Chongqing MobileTelecommunications Corp Ltd",
    "A428B7": "Yangtze Memory Technologies Co.",
    "9492D2": "KCF Technologies",
    "E4A8DF": "COMPAL INFORMATION (KUNSHAN) CO.",
    "74D435": "GIGA-BYTE TECHNOLOGY CO.",
    "408D5C": "GIGA-BYTE TECHNOLOGY CO.",
    "6CC63B": "Taicang T&W Electronics",
    "4CE176": "Cisco Systems",
    "1434F6": "LV SOLUTION SDN. BHD.",
    "3093BC": "Sagemcom Broadband SAS",
    "8C53C3": "Beijing Xiaomi Mobile Software Co.",
    "D83BBF": "Intel Corporate",
    "000DBB": "Nippon Dentsu Co.",
    "0CEE99": "Amazon Technologies Inc.",
    "F4FEFB": "Samsung Electronics Co.",
    "588E81": "Silicon Laboratories",
    "902B34": "GIGA-BYTE TECHNOLOGY CO.",
    "94DE80": "GIGA-BYTE TECHNOLOGY CO.",
    "702F35": "HUAWEI TECHNOLOGIES CO.",
    "043F72": "Mellanox Technologies",
    "F86FDE": "Shenzhen Goodix Technology Co.",
    "3C410E": "Cisco Systems",
    "207454": "vivo Mobile Communication Co.",
    "B8C9B5": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "001FF6": "PS Audio International",
    "006967": "IEEE Registration Authority",
    "1C4D66": "Amazon Technologies Inc.",
    "646624": "Sagemcom Broadband SAS",
    "B0F530": "Hitron Technologies. Inc",
    "0045E2": "CyberTAN Technology Inc.",
    "001EB8": "Aloys",
    "984914": "Wistron Neweb Corporation",
    "502CC6": "GREE ELECTRIC APPLIANCES",
    "0CE4A0": "Huawei Device Co.",
    "BC1AE4": "Huawei Device Co.",
    "740AE1": "Huawei Device Co.",
    "B4A898": "Huawei Device Co.",
    "0027E3": "Cisco Systems",
    "089C86": "Nokia Shanghai Bell Co.",
    "F05136": "TCT mobile ltd",
    "7817BE": "HUAWEI TECHNOLOGIES CO.",
    "1C1E38": "PCCW Global",
    "F072EA": "Google",
    "B87BC5": "Apple",
    "4070F5": "Apple",
    "B035B5": "Apple",
    "88ACC0": "Zyxel Communications Corporation",
    "90FD73": "zte corporation",
    "800C67": "Apple",
    "90812A": "Apple",
    "EC9C32": "Sichuan AI-Link Technology Co.",
    "4CADA8": "PANOPTICS CORP.",
    "981BB5": "ASSA ABLOY Korea Co.",
    "F0B107": "Ericsson AB",
    "E8D03C": "Shenzhen Jingxun Software Telecommunication Technology Co.",
    "1C1ADF": "Microsoft Corporation",
    "D4F547": "Google",
    "E04007": "Huawei Device Co.",
    "70CE8C": "Samsung Electronics Co.",
    "783A6C": "TECNO MOBILE LIMITED",
    "34CB1A": "Procter & Gamble Company",
    "90AFD1": "netKTI Co.",
    "7C48B2": "Vida Resources Lte Ltd",
    "C4E0DE": "Zhengzhou XindaJiean Information Technology Co.",
    "901A4F": "EM Microelectronic",
    "D88ADC": "Huawei Device Co.",
    "CC6A10": "The Chamberlain Group",
    "0004C9": "Micro Electron Co.",
    "C84F0E": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "10E953": "Huawei Device Co.",
    "B887C6": "Prudential Technology co.",
    "FC1CA1": "Nokia",
    "6CD2BA": "zte corporation",
    "303ABA": "Guangzhou BaoLun Electronics Co.",
    "C43A35": "FN-LINK TECHNOLOGY LIMITED",
    "04D16E": "IEEE Registration Authority",
    "F03F95": "HUAWEI TECHNOLOGIES CO.",
    "185644": "HUAWEI TECHNOLOGIES CO.",
    "9C69D1": "HUAWEI TECHNOLOGIES CO.",
    "040E3C": "HP Inc.",
    "6C1C71": "Zhejiang Dahua Technology Co.",
    "78C881": "Sony Interactive Entertainment Inc.",
    "7048F7": "Nintendo Co.",
    "18E1CA": "wanze",
    "CCEF03": "Hunan Keyshare Communication Technology Co.",
    "309176": "Skyworth Digital Technology(Shenzhen) Co.",
    "D44F68": "Eidetic Communications Inc",
    "340F66": "Web Sensing LLC",
    "B40216": "Cisco Systems",
    "54A493": "IEEE Registration Authority",
    "8CC84B": "CHONGQING FUGUI ELECTRONICS CO.",
    "0C2FB0": "Samsung Electronics Co.",
    "749EA5": "OHSUNG",
    "002272": "American Micro-Fuel Device Corp.",
    "00D0EF": "IGT",
    "ECBEDD": "Sagemcom Broadband SAS",
    "88571D": "Seongji Industry Company",
    "B04FC3": "Shenzhen NVC Cloud Technology Co.",
    "405582": "Nokia",
    "A4E31B": "Nokia",
    "B8A58D": "Axe Group Holdings Limited",
    "50CEE3": "Gigafirm.co.LTD",
    "F497C2": "Nebulon Inc",
    "5885E9": "Realme Chongqing MobileTelecommunications Corp Ltd",
    "4C1D96": "Intel Corporate",
    "BC2392": "BYD Precision Manufacture Company Ltd.",
    "94E6F7": "Intel Corporate",
    "D89790": "Commonwealth Scientific and Industrial Research Organisation",
    "F4BD9E": "Cisco Systems",
    "A44519": "Xiaomi Communications Co Ltd",
    "8446FE": "HUAWEI TECHNOLOGIES CO.",
    "D82918": "HUAWEI TECHNOLOGIES CO.",
    "086083": "zte corporation",
    "E01954": "zte corporation",
    "7CF31B": "LG Electronics (Mobile Communications)",
    "10327E": "Huawei Device Co.",
    "C419D1": "Telink Semiconductor (Shanghai) Co.",
    "64B21D": "Chengdu Phycom Tech Co.",
    "C42996": "Signify B.V.",
    "B065F1": "WIO Manufacturing HK Limited",
    "901234": "Shenzhen YOUHUA Technology Co.",
    "38C4E8": "NSS Sp. z o.o.",
    "34DD7E": "Umeox Innovations Co.",
    "CCCD64": "SM-Electronic GmbH",
    "24DFA7": "Hangzhou BroadLink Technology Co.",
    "5C925E": "Zioncom Electronics (Shenzhen) Ltd.",
    "084FA9": "Cisco Systems",
    "084FF9": "Cisco Systems",
    "980637": "IEEE Registration Authority",
    "F8084F": "Sagemcom Broadband SAS",
    "30FBB8": "HUAWEI TECHNOLOGIES CO.",
    "1802AE": "vivo Mobile Communication Co.",
    "0C20D3": "vivo Mobile Communication Co.",
    "68DBF5": "Amazon Technologies Inc.",
    "2446C8": "Motorola Mobility LLC",
    "44D791": "HUAWEI TECHNOLOGIES CO.",
    "5098B8": "New H3C Technologies Co.",
    "B84DEE": "Hisense broadband multimedia technology Co.",
    "8CB84A": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
    "98E8FA": "Nintendo Co.",
    "D46BA6": "HUAWEI TECHNOLOGIES CO.",
    "CC0577": "HUAWEI TECHNOLOGIES CO.",
    "A89352": "SHANGHAI ZHONGMI COMMUNICATION TECHNOLOGY CO.",
    "E4CC9D": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "A8D0E3": "Systech Electronics Ltd",
    "308BB2": "Cisco Systems",
    "E0EB62": "Shanghai Hulu Devices Co.",
    "98BA39": "Doro AB",
    "6CE8C6": "Earda Technologies co Ltd",
    "1C4176": "China Mobile Group Device Co.",
    "48216C": "China Mobile IOT Company Limited",
    "8CBE24": "Tashang Semiconductor(Shanghai) Co.",
    "E86F38": "CHONGQING FUGUI ELECTRONICS CO.",
    "94DC4E": "AEV",
    "54DED0": "Sevio Srl",
    "08688D": "New H3C Technologies Co.",
    "08B3AF": "vivo Mobile Communication Co.",
    "30862D": "Arista Network",
    "401920": "Movon Corporation",
    "608B0E": "Apple",
    "1871D5": "Hazens Automotive Electronics(SZ)Co.",
    "ACB1EE": "SHENZHEN FENDA TECHNOLOGY CO.",
    "F8ADCB": "HMD Global Oy",
    "000178": "MARGI Systems",
    "58C876": "China Mobile (Hangzhou) Information Technology Co.",
    "50E085": "Intel Corporate",
    "1442FC": "Texas Instruments",
    "AC5D5C": "FN-LINK TECHNOLOGY LIMITED",
    "A4AE11": "Hon Hai Precision Industry Co.",
    "2C1E4F": "Chengdu Qianli Network Technology Co.",
    "009052": "SELCOM ELETTRONICA S.R.L.",
    "001A83": "Pegasus Technologies Inc.",
    "6C5E3B": "Cisco Systems",
    "D03745": "TP-LINK TECHNOLOGIES CO.",
    "603A7C": "TP-LINK TECHNOLOGIES CO.",
    "D462EA": "HUAWEI TECHNOLOGIES CO.",
    "54BAD6": "HUAWEI TECHNOLOGIES CO.",
    "940B19": "HUAWEI TECHNOLOGIES CO.",
    "70C7F2": "HUAWEI TECHNOLOGIES CO.",
    "DCA632": "Raspberry Pi Trading Ltd",
    "88F56E": "HUAWEI TECHNOLOGIES CO.",
    "C8C2FA": "HUAWEI TECHNOLOGIES CO.",
    "88B362": "Nokia Shanghai Bell Co.",
    "0847D0": "Nokia Shanghai Bell Co.",
    "CC9093": "Hansong Tehnologies",
    "BC97E1": "Broadcom Limited",
    "28D1B7": "Shenzhen YOUHUA Technology Co.",
    "24166D": "HUAWEI TECHNOLOGIES CO.",
    "3894ED": "NETGEAR",
    "700433": "California Things Inc.",
    "CC64A6": "HUAWEI TECHNOLOGIES CO.",
    "30317D": "Hosiden Corporation",
    "F0A968": "Antailiye Technology Co.",
    "50AF4D": "zte corporation",
    "C8EAF8": "zte corporation",
    "148430": "MITAC COMPUTING TECHNOLOGY CORPORATION",
    "B8A44F": "Axis Communications AB",
    "0024EB": "ClearPath Networks",
    "D81399": "Hui Zhou Gaoshengda Technology Co.",
    "54E019": "Ring LLC",
    "5CFAFB": "Acubit",
    "9C7BEF": "Hewlett Packard",
    "848BCD": "IEEE Registration Authority",
    "08EDED": "Zhejiang Dahua Technology Co.",
    "88299C": "Samsung Electronics Co.",
    "7C8956": "Samsung Electronics Co.",
    "383B26": "Jiangsu Qinheng Co.",
    "742EDB": "Perinet GmbH",
    "201742": "LG Electronics",
    "CC8826": "LG Innotek",
    "EC5B73": "Advanced & Wise Technology Corp.",
    "DC7196": "Intel Corporate",
    "D09C7A": "Xiaomi Communications Co Ltd",
    "1C697A": "EliteGroup Computer Systems Co.",
    "4C1744": "Amazon Technologies Inc.",
    "B03055": "China Mobile IOT Company Limited",
    "905C34": "Sirius Electronic Systems Srl",
    "D46A35": "Cisco Systems",
    "D44DA4": "Murata Manufacturing Co.",
    "C82C2B": "IEEE Registration Authority",
    "8020DA": "Sagemcom Broadband SAS",
    "F8E5CF": "CGI IT UK LIMITED",
    "D420B0": "Mist Systems",
    "9C497F": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "C4E39F": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "2479F3": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "80A235": "Edgecore Networks Corporation",
    "C8C64A": "Flextronics Tech.(Ind) Pvt Ltd",
    "00A0B0": "I-O DATA DEVICE",
    "0022AF": "Safety Vision",
    "A091A2": "OnePlus Electronics (Shenzhen) Co.",
    "402343": "CHONGQING FUGUI ELECTRONICS CO.",
    "0021B7": "LEXMARK INTERNATIONAL",
    "68847E": "FUJITSU LIMITED",
    "F89A78": "HUAWEI TECHNOLOGIES CO.",
    "88F872": "HUAWEI TECHNOLOGIES CO.",
    "EC5623": "HUAWEI TECHNOLOGIES CO.",
    "5486BC": "Cisco Systems",
    "30EA26": "Sycada BV",
    "18F18E": "ChipER Technology co. ltd",
    "003085": "Cisco Systems",
    "0080B5": "UNITED NETWORKS INC.",
    "B808CF": "Intel Corporate",
    "605F8D": "eero inc.",
    "C4B36A": "Cisco Systems",
    "70F754": "AMPAK Technology",
    "6C8BD3": "Cisco Systems",
    "68974B": "Shenzhen Costar Electronics Co. Ltd.",
    "34E1D1": "IEEE Registration Authority",
    "108286": "Luxshare Precision Industry Co.",
    "14B457": "Silicon Laboratories",
    "DC962C": "NST Audio Ltd",
    "50EC50": "Beijing Xiaomi Mobile Software Co.",
    "6063F9": "Ciholas",
    "AC8FF8": "Nokia",
    "6003A6": "Inteno Broadband Technology AB",
    "44B295": "Sichuan AI-Link Technology Co.",
    "9424E1": "Alcatel-Lucent Enterprise",
    "6061DF": "Z-meta Research LLC",
    "7057BF": "New H3C Technologies Co.",
    "089798": "COMPAL INFORMATION (KUNSHAN) CO.",
    "18022D": "HUAWEI TECHNOLOGIES CO.",
    "D8BC59": "Shenzhen DAPU Microelectronics Co.",
    "8C79F5": "Samsung Electronics Co.",
    "246F28": "Espressif Inc.",
    "00122A": "VTech Telecommunications Ltd.",
    "000422": "Studio Technologies",
    "80DA13": "eero inc.",
    "48F8DB": "HUAWEI TECHNOLOGIES CO.",
    "C08ACD": "Guangzhou Shiyuan Electronic Technology Company Limited",
    "D81EDD": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "B0518E": "Holl technology CO.Ltd.",
    "681729": "Intel Corporate",
    "2852E0": "Layon international Electronic & Telecom Co.",
    "7C6166": "Amazon Technologies Inc.",
    "989BCB": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
    "F8CA59": "NetComm Wireless",
    "ACF6F7": "LG Electronics (Mobile Communications)",
    "58CB52": "Google",
    "88B291": "Apple",
    "C42AD0": "Apple",
    "CCD281": "Apple",
    "F84D33": "Fiberhome Telecommunication Technologies Co.",
    "107717": "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.",
    "A86D5F": "Raisecom Technology CO.",
    "48E6C0": "SIMCom Wireless Solutions Co.",
    "383C9C": "Fujian Newland Payment Technology Co.",
    "C02E25": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "200DB0": "Shenzhen Four Seas Global Link Network Technology Co.",
    "100C6B": "NETGEAR",
    "58ECED": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "C4F0EC": "Fiberhome Telecommunication Technologies Co.",
    "D88DC8": "Atil Technology Co.",
    "E80FC8": "Universal Electronics",
    "909A77": "Texas Instruments",
    "04EE03": "Texas Instruments",
    "4C2498": "Texas Instruments",
    "7CD95C": "Google",
    "1C2E1B": "Suzhou Tremenet Communication Technology Co.",
    "00EEAB": "Cisco Systems",
    "54A703": "TP-LINK TECHNOLOGIES CO.",
    "907A58": "Zegna-Daidong Limited",
    "E009BF": "SHENZHEN TONG BO WEI TECHNOLOGY Co.",
    "C8AACC": "Private",
    "002167": "HWA JIN T&I Corp.",
    "B00073": "Wistron Neweb Corporation",
    "001BF7": "Lund IP Products AB",
    "846991": "Nokia",
    "00131E": "peiker acustic GmbH",
    "783607": "Cermate Technologies Inc.",
    "1C24EB": "Burlywood",
    "001013": "Kontron America",
    "A8E2C1": "Texas Instruments",
    "58C6F0": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "84A06E": "Sagemcom Broadband SAS",
    "884A18": "Opulinks",
    "00115A": "Ivoclar Vivadent AG",
    "A43EA0": "iComm HK LIMITED",
    "64C2DE": "LG Electronics (Mobile Communications)",
    "8C444F": "HUMAX Co.",
    "006762": "Fiberhome Telecommunication Technologies Co.",
    "2CC407": "machineQ",
    "40DF02": "LINE BIZ Plus",
    "D43B04": "Intel Corporate",
    "900218": "SKY UK LIMITED",
    "144E2A": "Ciena Corporation",
    "0007CB": "FREEBOX SAS",
    "149FB6": "GUANGDONG GENIUS TECHNOLOGY CO.",
    "DC31D1": "vivo Mobile Communication Co.",
    "2C2BF9": "LG Innotek",
    "84139F": "zte corporation",
    "B4ED19": "Pie Digital",
    "7495EC": "ALPSALPINE CO",
    "AC5AEE": "China Mobile Group Device Co.",
    "F051EA": "Fitbit",
    "5033F0": "YICHEN (SHENZHEN) TECHNOLOGY CO.LTD",
    "4CE19E": "TECNO MOBILE LIMITED",
    "441AFA": "New H3C Technologies Co.",
    "04072E": "VTech Electronics Ltd.",
    "FC2BB2": "Actiontec Electronics",
    "E09F2A": "Iton Technology Corp.",
    "9C69B4": "IEEE Registration Authority",
    "44B433": "tide.co.",
    "0006F7": "ALPSALPINE CO",
    "000704": "ALPSALPINE CO",
    "0006F5": "ALPSALPINE CO",
    "34C731": "ALPSALPINE CO",
    "64D4BD": "ALPSALPINE CO",
    "500084": "Siemens Canada",
    "70BC10": "Microsoft Corporation",
    "0498F3": "ALPSALPINE CO",
    "00214F": "ALPSALPINE CO",
    "247D4D": "Texas Instruments",
    "DC21B9": "Sentec Co.Ltd",
    "6CDFFB": "IEEE Registration Authority",
    "203233": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
    "705E55": "Realme Chongqing MobileTelecommunications Corp Ltd",
    "B0D568": "Shenzhen Cultraview Digital Technology Co.",
    "F00EBF": "ZettaHash Inc.",
    "E498BB": "Phyplus Microelectronics Limited",
    "60A11E": "Wuhan Maxsine Electric Co.",
    "C45BF7": "ants",
    "8CDF9D": "NEC Corporation",
    "703509": "Cisco Systems",
    "04EA56": "Intel Corporate",
    "5C415A": "Amazon.com",
    "A8B456": "Cisco Systems",
    "A49426": "Elgama-Elektronika Ltd.",
    "9454DF": "YST CORP.",
    "2CA9F0": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "549B72": "Ericsson AB",
    "A047D7": "Best IT World (India) Pvt Ltd",
    "6899CD": "Cisco Systems",
    "6829DC": "Ficosa Electronics S.L.U.",
    "F80DF1": "Sontex SA",
    "1040F3": "Apple",
    "4428A3": "Jiangsu fulian  Communication Technology Co.",
    "10C595": "Lenovo",
    "44E66E": "Apple",
    "C0E862": "Apple",
    "F40616": "Apple",
    "586B14": "Apple",
    "BCB863": "Apple",
    "7CBC84": "IEEE Registration Authority",
    "780ED1": "TRUMPF Werkzeugmaschinen GmbH+Co.KG",
    "F82F08": "Molex CMS",
    "64F81C": "Huawei Technologies Co.",
    "70BBE9": "Xiaomi Communications Co Ltd",
    "00D02D": "Resideo",
    "08351B": "Shenzhen Jialihua Electronic Technology Co.",
    "AC1585": "silergy corp",
    "AC5093": "Magna Electronics Europe GmbH & Co. OHG",
    "2C1CF6": "Alien Green LLC",
    "3C8D20": "Google",
    "601D91": "Motorola Mobility LLC",
    "D4C94B": "Motorola Mobility LLC",
    "0CFE5D": "IEEE Registration Authority",
    "806940": "LEXAR CO.",
    "B07E11": "Texas Instruments",
    "50A0A4": "Nokia",
    "1098C3": "Murata Manufacturing Co.",
    "10C753": "Qingdao Intelligent&Precise Electronics Co.",
    "F4951B": "Hefei Radio Communication Technology Co.",
    "6C3845": "Fiberhome Telecommunication Technologies Co.",
    "D0B60A": "Xingluo Technology Company  Limited",
    "049226": "ASUSTek COMPUTER INC.",
    "E8ADA6": "Sagemcom Broadband SAS",
    "0C1C19": "LONGCONN ELECTRONICS(SHENZHEN) CO.",
    "E013B5": "vivo Mobile Communication Co.",
    "E0795E": "Wuxi Xiaohu Technology Co.",
    "2C6104": "SHENZHEN FENGLIAN TECHNOLOGY CO.",
    "BC9325": "Ningbo Joyson Preh Car Connect Co.",
    "A4FC77": "Mega Well Limited",
    "8C85E6": "Cleondris GmbH",
    "84326F": "GUANGZHOU AVA ELECTRONICS TECHNOLOGY CO.",
    "C89C13": "Inspiremobile",
    "00B1E3": "Cisco Systems",
    "A41194": "Lenovo",
    "90E710": "New H3C Technologies Co.",
    "302952": "Hillstone Networks Inc",
    "00B4F5": "DongGuan Siyoto Electronics Co.",
    "983B8F": "Intel Corporate",
    "54278D": "NXP (China) Management Ltd.",
    "0C4101": "Ruichi Auto Technology (Guangzhou) Co.",
    "00B771": "Cisco Systems",
    "B0AE25": "Varikorea",
    "1838AE": "CONSPIN SOLUTION",
    "04CF8C": "XIAOMI Electronics",
    "0C7512": "Shenzhen Kunlun TongTai Technology  Co.",
    "402619": "Apple",
    "6CE85C": "Apple",
    "E4B2FB": "Apple",
    "2CCA0C": "WITHUS PLANET",
    "807D14": "HUAWEI TECHNOLOGIES CO.",
    "20283E": "HUAWEI TECHNOLOGIES CO.",
    "049162": "Microchip Technology Inc.",
    "F83880": "Apple",
    "4C569D": "Apple",
    "38539C": "Apple",
    "440049": "Amazon Technologies Inc.",
    "2C79D7": "Sagemcom Broadband SAS",
    "6CC374": "Texas Instruments",
    "684749": "Texas Instruments",
    "F8D9B8": "Open Mesh",
    "7C696B": "Atmosic Technologies",
    "5CD20B": "Yytek Co.",
    "50579C": "Seiko Epson Corporation",
    "D003DF": "Samsung Electronics Co.",
    "10A24E": "GOLD3LINK ELECTRONICS CO.",
    "C423A2": "PT. Emsonic Indonesia",
    "B4CB57": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "B0BE76": "TP-LINK TECHNOLOGIES CO.",
    "4C1B86": "Arcadyan Corporation",
    "00500C": "e-Tek Labs",
    "485F99": "Cloud Network Technology (Samoa) Limited",
    "88F7BF": "vivo Mobile Communication Co.",
    "D87D7F": "Sagemcom Broadband SAS",
    "8834FE": "Bosch Automotive Products (Suzhou) Co. Ltd",
    "58B568": "SECURITAS DIRECT ESPAÑA",
    "ECC40D": "Nintendo Co.",
    "8489EC": "IEEE Registration Authority",
    "00073A": "INVENTEL",
    "00266C": "INVENTEC CORPORATION",
    "008CFA": "INVENTEC CORPORATION",
    "846A66": "Sumitomo Kizai  Co.",
    "5CFB7C": "Shenzhen Jingxun Software Telecommunication Technology Co.",
    "FC039F": "Samsung Electronics Co.",
    "88108F": "HUAWEI TECHNOLOGIES CO.",
    "F4631F": "HUAWEI TECHNOLOGIES CO.",
    "A49B4F": "HUAWEI TECHNOLOGIES CO.",
    "00051A": "3COM EUROPE LTD",
    "08004E": "3COM EUROPE LTD",
    "00301E": "3COM EUROPE LTD",
    "005004": "3COM",
    "000103": "3COM",
    "02C08C": "3COM",
    "7C240C": "Telechips",
    "00203D": "Honeywell Environmental & Combustion Controls",
    "004084": "Honeywell",
    "A0950C": "China Mobile IOT Company Limited",
    "2C15E1": "Phicomm (Shanghai) Co.",
    "18D717": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "80B624": "IVS",
    "DCF505": "AzureWave Technology Inc.",
    "CCF0FD": "China Mobile (Hangzhou) Information Technology Co.",
    "006087": "KANSAI ELECTRIC CO.",
    "98AE71": "VVDN Technologies Pvt Ltd",
    "1C1BB5": "Intel Corporate",
    "D4741B": "Beijing HuaDa ZhiBao Electronic System Co.",
    "0057C1": "LG Electronics (Mobile Communications)",
    "DCF719": "Cisco Systems",
    "A4D990": "Samsung Electronics Co.",
    "30D16B": "Liteon Technology Corporation",
    "0080EB": "COMPCONTROL B.V.",
    "AC6E1A": "SHENZHEN GONGJIN ELECTRONICS CO.",
    "30D32D": "devolo AG",
    "BCF2AF": "devolo AG",
    "E0AF4F": "Deutsche Telekom AG",
    "68A8E1": "Wacom Co.",
    "144802": "THE YEOLRIM Co.",
    "0002EB": "Pico Communications",
    "342EB6": "HUAWEI TECHNOLOGIES CO.",
    "AC9232": "HUAWEI TECHNOLOGIES CO.",
    "001555": "DFM GmbH",
    "000FB0": "Compal Electronics INC.",
    "00023F": "Compal Electronics INC.",
    "DC8B28": "Intel Corporate",
    "B869F4": "Routerboard.com",
    "BC30D9": "Arcadyan Corporation",
    "24D76B": "Syntronic AB",
    "40313C": "XIAOMI Electronics",
    "283A4D": "Cloud Network Technology (Samoa) Limited",
    "B87C6F": "NXP (China) Management Ltd.",
    "305DA6": "ADVALY SYSTEM Inc.",
    "0479B7": "Texas Instruments",
    "C0D0FF": "China Mobile IOT Company Limited",
    "88DF9E": "New H3C Technologies Co.",
    "2C7CE4": "Wuhan Tianyu Information Industry Co.",
    "C4FEE2": "AMICCOM Electronics Corporation",
    "E01283": "Shenzhen Fanzhuo Communication Technology Co.",
    "84C9C6": "SHENZHEN GONGJIN ELECTRONICS CO.",
    "444B5D": "GE Healthcare",
    "FC4AE9": "Castlenet Technology Inc.",
    "1C7508": "COMPAL INFORMATION (KUNSHAN) CO.",
    "001B38": "COMPAL INFORMATION (KUNSHAN) CO.",
    "00235A": "COMPAL INFORMATION (KUNSHAN) CO.",
    "FC4596": "COMPAL INFORMATION (KUNSHAN) CO.",
    "A0E534": "Stratec Biomedical AG",
    "D469A5": "Miura Systems Ltd.",
    "88B66B": "easynetworks",
    "24F57E": "HWH CO.",
    "8CA048": "Beijing NeTopChip Technology Co.",
    "24D3F2": "zte corporation",
    "8C8126": "ARCOM",
    "D47C44": "IEEE Registration Authority",
    "7C96D2": "Fihonest communication co.",
    "A0CF5B": "Cisco Systems",
    "002421": "MICRO-STAR INT'L CO.",
    "0060D1": "CASCADE COMMUNICATIONS",
    "805E4F": "FN-LINK TECHNOLOGY LIMITED",
    "780CF0": "Cisco Systems",
    "0C8C24": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
    "8C6D77": "HUAWEI TECHNOLOGIES CO.",
    "E8C57A": "Ufispace Co.",
    "302432": "Intel Corporate",
    "D0C5D8": "LATECOERE",
    "7054B4": "Vestel Elektronik San ve Tic. A.S.",
    "20A60C": "Xiaomi Communications Co Ltd",
    "DCE838": "CK Telecom (Shenzhen) Limited",
    "A8D498": "Avira Operations GmbH & Co. KG",
    "60D02C": "Ruckus Wireless",
    "D058FC": "SKY UK LIMITED",
    "505967": "Intent Solutions Inc",
    "000680": "Card Access",
    "488AD2": "MERCURY COMMUNICATION TECHNOLOGIES CO.",
    "FCA6CD": "Fiberhome Telecommunication Technologies Co.",
    "44C874": "China Mobile Group Device Co.",
    "3C576C": "Samsung Electronics Co.",
    "841766": "WEIFANG GOERTEK ELECTRONICS CO.",
    "2C4D79": "WEIFANG GOERTEK ELECTRONICS CO.",
    "14579F": "HUAWEI TECHNOLOGIES CO.",
    "B44326": "HUAWEI TECHNOLOGIES CO.",
    "3856B5": "Peerbridge Health Inc",
    "000C42": "Routerboard.com",
    "0026BD": "JTEC Card &amp; Communication Co.",
    "04AB18": "ELECOM CO.",
    "F85C4D": "Nokia",
    "E4EA83": "SHENZHEN GONGJIN ELECTRONICS CO.",
    "74EC42": "Fiberhome Telecommunication Technologies Co.",
    "1866C7": "Shenzhen Libre Technology Co.",
    "5CB3F6": "Human",
    "2C4835": "IEEE Registration Authority",
    "482AE3": "Wistron InfoComm(Kunshan)Co.",
    "709FA9": "TECNO MOBILE LIMITED",
    "0C01DB": "Infinix mobility limited",
    "08C5E1": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
    "74C14F": "HUAWEI TECHNOLOGIES CO.",
    "B0EB57": "HUAWEI TECHNOLOGIES CO.",
    "78D294": "NETGEAR",
    "A85B6C": "Robert Bosch Gmbh",
    "C8B1EE": "Qorvo",
    "1869DA": "China Mobile Group Device Co.",
    "00FCBA": "Cisco Systems",
    "4CC00A": "vivo Mobile Communication Co.",
    "9CE82B": "vivo Mobile Communication Co.",
    "7079B3": "Cisco Systems",
    "149B2F": "JiangSu ZhongXie Intelligent Technology co.",
    "3835FB": "Sagemcom Broadband SAS",
    "9C7F57": "UNIC Memory Technology Co Ltd",
    "B4E01D": "CONCEPTION ELECTRONIQUE",
    "1C0042": "NARI Technology Co.",
    "A075EA": "BoxLock",
    "F04CD5": "Maxlinear",
    "00CBB4": "SHENZHEN ATEKO PHOTOELECTRICITY CO.",
    "48DD9D": "ITEL MOBILE LIMITED",
    "E0BAB4": "Arrcus",
    "807D3A": "Espressif Inc.",
    "0001AE": "Trex Enterprises",
    "00E009": "Stratus Technologies",
    "A0B045": "Halong Mining",
    "ECAF97": "GIT",
    "D4FC13": "Fiberhome Telecommunication Technologies Co.",
    "701D08": "99IOT Shenzhen co.",
    "3CE1A1": "Universal Global Scientific Industrial Co.",
    "F898EF": "HUAWEI TECHNOLOGIES CO.",
    "58F987": "HUAWEI TECHNOLOGIES CO.",
    "68CAE4": "Cisco Systems",
    "781D4A": "zte corporation",
    "001027": "L-3 COMMUNICATIONS EAST",
    "589B0B": "Shineway Technologies",
    "D8160A": "Nippon Electro-Sensory Devices",
    "10C07C": "Blu-ray Disc Association",
    "E4B021": "Samsung Electronics Co.",
    "9CE895": "New H3C Technologies Co.",
    "00583F": "PC Aquarius",
    "903D68": "G-Printec",
    "1094BB": "Apple",
    "A8F5AC": "HUAWEI TECHNOLOGIES CO.",
    "58BAD4": "HUAWEI TECHNOLOGIES CO.",
    "BC2643": "Elprotronic Inc.",
    "04E229": "Qingdao Haier Technology Co.",
    "7412BB": "Fiberhome Telecommunication Technologies Co.",
    "348B75": "LAVA INTERNATIONAL(H.K) LIMITED",
    "2047DA": "Xiaomi Communications Co Ltd",
    "00BE3B": "HUAWEI TECHNOLOGIES CO.",
    "7CA177": "HUAWEI TECHNOLOGIES CO.",
    "242E02": "HUAWEI TECHNOLOGIES CO.",
    "78B6EC": "Scuf Gaming International LLC",
    "8035C1": "Xiaomi Communications Co Ltd",
    "08DFCB": "Systrome Networks",
    "A4933F": "HUAWEI TECHNOLOGIES CO.",
    "34E894": "TP-LINK TECHNOLOGIES CO.",
    "28AC9E": "Cisco Systems",
    "F86FC1": "Apple",
    "28FF3C": "Apple",
    "F099B6": "Apple",
    "88E9FE": "Apple",
    "38892C": "Apple",
    "749EAF": "Apple",
    "94BF2D": "Apple",
    "58B3FC": "SHENZHEN RF-LINK TECHNOLOGY CO.",
    "2429FE": "KYOCERA Corporation",
    "7C49EB": "XIAOMI Electronics",
    "C43306": "China Mobile Group Device Co.",
    "A8367A": "frogblue TECHNOLOGY GmbH",
    "984562": "Shanghai Baud Data Communication Co.",
    "68D482": "SHENZHEN GONGJIN ELECTRONICS CO.",
    "10E7C6": "Hewlett Packard",
    "A433D7": "MitraStar Technology Corp.",
    "B0ACD2": "zte corporation",
    "200F70": "FOXTECH",
    "202D23": "Collinear Networks Inc.",
    "90834B": "BEIJING YUNYI TIMES TECHNOLOGY CO",
    "18502A": "SOARNEX",
    "788C54": "Ping Communication",
    "B8AF67": "Hewlett Packard",
    "C098DA": "China Mobile IOT Company Limited",
    "C048E6": "Samsung Electronics Co.",
    "882E5A": "storONE",
    "007147": "Amazon Technologies Inc.",
    "00BE75": "Cisco Systems",
    "6CE4DA": "NEC Platforms",
    "E4C483": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "001FBA": "Boyoung Tech",
    "DCA333": "Shenzhen YOUHUA Technology Co.",
    "1831BF": "ASUSTek COMPUTER INC.",
    "F00FEC": "HUAWEI TECHNOLOGIES CO.",
    "AC075F": "HUAWEI TECHNOLOGIES CO.",
    "78257A": "LEO Innovation Lab",
    "C8FAE1": "ARQ Digital LLC",
    "10A4B9": "Baidu Online Network Technology (Beijing) Co.",
    "04C241": "Nokia",
    "80CE62": "Hewlett Packard",
    "801F12": "Microchip Technology Inc.",
    "506CBE": "InnosiliconTechnology Ltd",
    "247E12": "Cisco Systems",
    "501CB0": "Cisco Systems",
    "3C479B": "Theissen Training Systems",
    "606BFF": "Nintendo Co.",
    "8CF710": "AMPAK Technology",
    "04AC44": "Holtek Semiconductor Inc.",
    "F4DCA5": "DAWON DNS",
    "307BAC": "New H3C Technologies Co.",
    "785DC8": "LG Electronics",
    "0C5415": "Intel Corporate",
    "E8C1B8": "Nanjing Bangzhong Electronic Commerce Limited",
    "D8D775": "Sagemcom Broadband SAS",
    "E8330D": "Xaptec GmbH",
    "B4A8B9": "Cisco Systems",
    "50DCE7": "Amazon Technologies Inc.",
    "649829": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "081DC4": "Thermo Fisher Scientific Messtechnik GmbH",
    "785364": "SHIFT GmbH",
    "883D24": "Google",
    "38E60A": "Xiaomi Communications Co Ltd",
    "D460E3": "Sercomm Corporation.",
    "40CBC0": "Apple",
    "C4618B": "Apple",
    "08E689": "Apple",
    "DC56E7": "Apple",
    "005D73": "Cisco Systems",
    "606D3C": "Luxshare Precision Industry Company Limited",
    "002790": "Cisco Systems",
    "DCBFE9": "Motorola Mobility LLC",
    "CC4D38": "Carnegie Technologies",
    "CC6EA4": "Samsung Electronics Co.",
    "5C5F67": "Intel Corporate",
    "803A59": "AT&T",
    "F8B568": "IEEE Registration Authority",
    "2C6B7D": "Texas Instruments",
    "9829A6": "COMPAL INFORMATION (KUNSHAN) CO.",
    "588D64": "Xi'an Clevbee Technology Co.",
    "A816D0": "Samsung Electronics Co.",
    "A46CF1": "Samsung Electronics Co.",
    "08AED6": "Samsung Electronics Co.",
    "34BA38": "PAL MOHAN ELECTRONICS PVT LTD",
    "4064A4": "THE FURUKAWA ELECTRIC CO.",
    "D45DDF": "PEGATRON CORPORATION",
    "F065C2": "Yanfeng Visteon Electronics Technology (Shanghai) Co.",
    "70B7E2": "Jiangsu Miter Technology Co.",
    "80B708": "Blue Danube Systems",
    "88D171": "BEGHELLI S.P.A",
    "A825EB": "Cambridge Industries(Group) Co.",
    "34E380": "Genexis B.V.",
    "5C5819": "Jingsheng Technology Co.",
    "B8CA04": "Holtek Semiconductor Inc.",
    "C4C563": "TECNO MOBILE LIMITED",
    "A09D86": "Alcatel-Lucent Shanghai Bell Co.",
    "6CB2AE": "Cisco Systems",
    "00C0FF": "Seagate Cloud Systems Inc",
    "B0982B": "Sagemcom Broadband SAS",
    "34FA9F": "Ruckus Wireless",
    "A09DC1": "China Dragon Technology Limited",
    "2C4205": "Lytx",
    "F41E5E": "RtBrick Inc.",
    "6C7660": "KYOCERA CORPORATION",
    "002102": "UpdateLogic Inc.",
    "505800": "WyTec International",
    "C8D12A": "Comtrend Corporation",
    "BCF292": "PLANTRONICS",
    "0450DA": "Qiku Internet Network Scientific (Shenzhen) Co.",
    "E820E2": "HUMAX Co.",
    "1890D8": "Sagemcom Broadband SAS",
    "785C28": "Prime Motion Inc.",
    "EC9F0D": "IEEE Registration Authority",
    "08BC20": "Hangzhou Royal Cloud Technology Co.",
    "942A3F": "Diversey Inc",
    "2031EB": "HDSN",
    "0005A7": "HYPERCHIP Inc.",
    "0026A8": "DAEHAP HYPER-TECH",
    "E078A3": "Shanghai Winner Information Technology Co.",
    "88835D": "FN-LINK TECHNOLOGY LIMITED",
    "F81D0F": "Hitron Technologies. Inc",
    "10A4BE": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
    "F8C96C": "Fiberhome Telecommunication Technologies Co.",
    "844823": "WOXTER TECHNOLOGY Co. Ltd",
    "947BBE": "Ubicquia LLC",
    "ECC06A": "PowerChord Group Limited",
    "944996": "WiSilica Inc",
    "68A682": "Shenzhen YOUHUA Technology Co.",
    "547A52": "CTE International srl",
    "24F677": "Apple",
    "B0CA68": "Apple",
    "C83C85": "Apple",
    "5433CB": "Apple",
    "3408BC": "Apple",
    "1C36BB": "Apple",
    "3C2EFF": "Apple",
    "001530": "Dell EMC",
    "0CB2B7": "Texas Instruments",
    "587A62": "Texas Instruments",
    "F06E0B": "Microsoft Corporation",
    "346FED": "Enovation Controls",
    "088466": "Novartis Pharma AG",
    "309FFB": "Ardomus Networks Corporation",
    "00E025": "dit Co.",
    "3820A8": "ColorTokens",
    "705896": "InShow Technology",
    "00B69F": "Latch",
    "FCEEE6": "FORMIKE ELECTRONIC CO.",
    "98C5DB": "Ericsson AB",
    "000589": "National Datacomputer",
    "3CA616": "vivo Mobile Communication Co.",
    "BC0543": "AVM GmbH",
    "3CC079": "Shenzhen One-Nine Intelligent Electronic Science and Technology Co.",
    "9CE063": "Samsung Electronics Co.",
    "D03169": "Samsung Electronics Co.",
    "149F3C": "Samsung Electronics Co.",
    "78870D": "Unifiedgateways India Private Limited",
    "A88200": "Hisense Electric Co.",
    "842C80": "Sichuan Changhong Electric Ltd.",
    "408BF6": "Shenzhen TCL New Technology Co.",
    "00006B": "Silicon Graphics",
    "84E327": "TAILYN TECHNOLOGIES INC",
    "0021B8": "Inphi Corporation",
    "E4A7C5": "HUAWEI TECHNOLOGIES CO.",
    "A0FE61": "Vivint Wireless Inc.",
    "5C2BF5": "Vivint Wireless Inc.",
    "90FD9F": "Silicon Laboratories",
    "A0648F": "ASKEY COMPUTER CORP",
    "C850E9": "Raisecom Technology CO.",
    "74373B": "UNINET Co.",
    "7C6456": "Samsung Electronics Co.",
    "10F163": "TNK CO.",
    "88DA1A": "Redpine Signals",
    "98EF9B": "OHSUNG",
    "14CF8D": "OHSUNG",
    "104400": "HUAWEI TECHNOLOGIES CO.",
    "B0E17E": "HUAWEI TECHNOLOGIES CO.",
    "0C9160": "Hui Zhou Gaoshengda Technology Co.",
    "D8ED1C": "Magna Technology SL",
    "F46E24": "NEC Personal Computers",
    "888279": "Shenzhen RB-LINK Intelligent Technology Co.Ltd",
    "68C63A": "Espressif Inc.",
    "B430C0": "York Instruments Ltd",
    "E81DA8": "Ruckus Wireless",
    "5C8D2D": "Shanghai Wellpay Information Technology Co.",
    "006088": "Analog Devices",
    "084ACF": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "947EB9": "National Narrowband Network Communications Pty Ltd",
    "00C0EE": "KYOCERA Display Corporation",
    "2C279E": "IEEE Registration Authority",
    "8C5F48": "Continental Intelligent Transportation Systems LLC",
    "245FDF": "KYOCERA CORPORATION",
    "9C63ED": "zte corporation",
    "DCF090": "Nubia Technology Co.",
    "CC5A53": "Cisco Systems",
    "706BB9": "Cisco Systems",
    "F03D03": "TECNO MOBILE LIMITED",
    "646E69": "Liteon Technology Corporation",
    "D4389C": "Sony Corporation",
    "001987": "Panasonic Mobile Communications Co.",
    "BCC342": "Panasonic Communications Co.",
    "001BD3": "Panasonic Corporation AVC Networks Company",
    "CC7EE7": "Panasonic Corporation AVC Networks Company",
    "74F661": "Schneider Electric Fire & Security Oy",
    "2CB21A": "Phicomm (Shanghai) Co.",
    "E470B8": "Intel Corporate",
    "00DB70": "Apple",
    "B8634D": "Apple",
    "24C42F": "Philips Lifeline",
    "A4E975": "Apple",
    "3035AD": "Apple",
    "844167": "Apple",
    "9800C6": "Apple",
    "AC1F74": "Apple",
    "A85C2C": "Apple",
    "9C305B": "Hon Hai Precision Ind. Co.",
    "FCE557": "Nokia Corporation",
    "48C58D": "Lear Corporation GmbH",
    "00289F": "Semptian Co.",
    "104E89": "Garmin International",
    "20C6EB": "Panasonic Corporation AVC Networks Company",
    "64B5C6": "Nintendo Co.",
    "2830AC": "Frontiir Co. Ltd.",
    "D4D2E5": "BKAV Corporation",
    "0050B5": "FICHET SECURITE ELECTRONIQUE",
    "001439": "Blonder Tongue Laboratories",
    "D8C497": "Quanta Computer Inc.",
    "741C27": "ITEL MOBILE LIMITED",
    "84802D": "Cisco Systems",
    "00188D": "Nokia Danmark A/S",
    "0015AB": "PRO CO SOUND INC",
    "5876C5": "DIGI I'S LTD",
    "00869C": "Palo Alto Networks",
    "94D9B3": "TP-LINK TECHNOLOGIES CO.",
    "C84029": "Fiberhome Telecommunication Technologies Co.",
    "F86EEE": "HUAWEI TECHNOLOGIES CO.",
    "4C49E3": "Xiaomi Communications Co Ltd",
    "28D436": "Jiangsu dewosi electric co.",
    "00A0AC": "GILAT SATELLITE NETWORKS",
    "002609": "Phyllis Co.",
    "28F537": "IEEE Registration Authority",
    "44EA4B": "Actlas Inc.",
    "C4CB6B": "Airista Flow",
    "188090": "Cisco Systems",
    "78D800": "IEEE Registration Authority",
    "0835B2": "CoreEdge Networks Co.",
    "F83441": "Intel Corporate",
    "7802B1": "Cisco Systems",
    "B40F3B": "Tenda Technology Co.",
    "786256": "HUAWEI TECHNOLOGIES CO.",
    "B05508": "HUAWEI TECHNOLOGIES CO.",
    "A8B2DA": "FUJITSU LIMITED",
    "245880": "VIZEO",
    "54666C": "Shenzhen YOUHUA Technology Co.",
    "A89675": "Motorola Mobility LLC",
    "8C9F3B": "Qingdao Hisense Communications Co.",
    "0014B8": "Hill-Rom",
    "ACED5C": "Intel Corporate",
    "589396": "Ruckus Wireless",
    "001F41": "Ruckus Wireless",
    "842096": "SHENZHEN RF-LINK TECHNOLOGY CO.",
    "B4C170": "Yi chip Microelectronics (Hangzhou) Co.",
    "B875C0": "PayPal",
    "001C71": "Emergent Electronics",
    "001A93": "ERCO Leuchten GmbH",
    "94F665": "Ruckus Wireless",
    "B090D4": "Shenzhen Hoin Internet Technology Co.",
    "389AF6": "Samsung Electronics Co.",
    "E0AA96": "Samsung Electronics Co.",
    "507705": "Samsung Electronics Co.",
    "C4108A": "Ruckus Wireless",
    "F0B052": "Ruckus Wireless",
    "AC6706": "Ruckus Wireless",
    "044FAA": "Ruckus Wireless",
    "08306B": "Palo Alto Networks",
    "3894E0": "Syrotech Networks. Ltd.",
    "34F64B": "Intel Corporate",
    "50184C": "Platina Systems Inc.",
    "F4B7B3": "vivo Mobile Communication Co.",
    "6CF9D2": "CHENGDU POVODO ELECTRONIC TECHNOLOGY CO.",
    "F46BEF": "Sagemcom Broadband SAS",
    "A4F3E7": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "E43A6E": "Shenzhen Zeroone Technology CO.",
    "9061AE": "Intel Corporate",
    "10CDB6": "Essential Products",
    "30B62D": "Mojo Networks",
    "70DF2F": "Cisco Systems",
    "90EC50": "C.O.B.O. SPA",
    "0018AE": "TVT CO.",
    "8891DD": "Racktivity",
    "1C4593": "Texas Instruments",
    "FCA667": "Amazon Technologies Inc.",
    "6C60EB": "ZHI YUAN ELECTRONICS CO.",
    "74DADA": "D-Link International",
    "00EC0A": "Xiaomi Communications Co Ltd",
    "C81FEA": "Avaya Inc",
    "60271C": "VIDEOR E. Hartig GmbH",
    "D8F1F0": "Pepxim International Limited",
    "9C7BD2": "NEOLAB Convergence",
    "2C41A1": "Bose Corporation",
    "D0F88C": "Motorola (Wuhan) Mobility Technologies Communication Co.",
    "2CB115": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "10D07A": "AMPAK Technology",
    "002449": "Shen Zhen Lite Star Electronics Technology Co.",
    "DCC8F5": "Shanghai UMEinfo CO.",
    "88D7F6": "ASUSTek COMPUTER INC.",
    "04714B": "IEEE Registration Authority",
    "C8D7B0": "Samsung Electronics Co.",
    "00E18C": "Intel Corporate",
    "9097F3": "Samsung Electronics Co.",
    "7C1C68": "Samsung Electronics Co.",
    "C087EB": "Samsung Electronics Co.",
    "847933": "profichip GmbH",
    "881544": "Cisco Meraki",
    "447BBB": "Shenzhen YOUHUA Technology Co.",
    "44B412": "SIUS AG",
    "0CB912": "JM-DATA GmbH",
    "C4ABB2": "vivo Mobile Communication Co.",
    "DC0856": "Alcatel-Lucent Enterprise",
    "F43E61": "SHENZHEN GONGJIN ELECTRONICS CO.",
    "B4417A": "SHENZHEN GONGJIN ELECTRONICS CO.",
    "3CA308": "Texas Instruments",
    "D4503F": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "388C50": "LG Electronics",
    "00D318": "SPG Controls",
    "D055B2": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "144FD7": "IEEE Registration Authority",
    "B85510": "Zioncom Electronics (Shenzhen) Ltd.",
    "00118B": "Alcatel-Lucent Enterprise",
    "00E0B1": "Alcatel-Lucent Enterprise",
    "00E0DA": "Alcatel-Lucent Enterprise",
    "F8BE0D": "A2UICT Co.",
    "00143F": "Hotway Technology Corporation",
    "E8C1D7": "Philips",
    "4C8120": "Taicang T&W Electronics",
    "28A6DB": "HUAWEI TECHNOLOGIES CO.",
    "14A0F8": "HUAWEI TECHNOLOGIES CO.",
    "C8F86D": "Alcatel-Lucent Shanghai Bell Co.",
    "6045CB": "ASUSTek COMPUTER INC.",
    "E442A6": "Intel Corporate",
    "3C678C": "HUAWEI TECHNOLOGIES CO.",
    "1CDA27": "vivo Mobile Communication Co.",
    "90F305": "HUMAX Co.",
    "4095BD": "NTmore.Co.",
    "98AAFC": "IEEE Registration Authority",
    "F8FF0B": "Electronic Technology Inc.",
    "7C6BF7": "NTI co.",
    "70F087": "Apple",
    "245BA7": "Apple",
    "D47DFC": "TECNO MOBILE LIMITED",
    "409F38": "AzureWave Technology Inc.",
    "000C46": "Allied Telesyn Inc.",
    "001F72": "QingDao Hiphone Technology Co",
    "002365": "Insta Elektro GmbH",
    "6091F3": "vivo Mobile Communication Co.",
    "28395E": "Samsung Electronics Co.",
    "38295A": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "CC82EB": "KYOCERA CORPORATION",
    "D4CF37": "Symbolic IO",
    "049573": "zte corporation",
    "F0D7AA": "Motorola Mobility LLC",
    "40FA7F": "Preh Car Connect GmbH",
    "000631": "Calix Inc.",
    "BC2F3D": "vivo Mobile Communication Co.",
    "3096FB": "Samsung Electronics Co.",
    "4827EA": "Samsung Electronics Co.",
    "7C787E": "Samsung Electronics Co.",
    "E05163": "Arcadyan Corporation",
    "54E3F6": "Alcatel-Lucent",
    "40B034": "Hewlett Packard",
    "3034D2": "Availink",
    "88E628": "Shenzhen Kezhonglong Optoelectronic Technology Co.",
    "50F14A": "Texas Instruments",
    "04DEF2": "Shenzhen ECOM Technology Co. Ltd",
    "407D0F": "HUAWEI TECHNOLOGIES CO.",
    "68CC6E": "HUAWEI TECHNOLOGIES CO.",
    "3CBD3E": "Beijing Xiaomi Electronics Co.",
    "641A22": "Heliospectra AB",
    "B816DB": "CHANT SINCERE CO.",
    "504061": "Nokia",
    "00108E": "HUGH SYMONS CONCEPT Technologies Ltd.",
    "40B4CD": "Amazon Technologies Inc.",
    "F42B48": "Ubiqam",
    "D47AE2": "Samsung Electronics Co.",
    "A084CB": "SonicSensory",
    "540384": "Hongkong Nano IC Technologies Co.",
    "4C7872": "Cav. Uff. Giacomo Cimberio S.p.A.",
    "0003BC": "COT GmbH",
    "8CF5A3": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
    "8CC8F4": "IEEE Registration Authority",
    "F483E1": "Shanghai Clouder Semiconductor Co.",
    "083E5D": "Sagemcom Broadband SAS",
    "70918F": "Weber-Stephen Products LLC",
    "D8E0E1": "Samsung Electronics Co.",
    "00A0C8": "Adtran Inc",
    "6854FD": "Amazon Technologies Inc.",
    "78C1A7": "zte corporation",
    "D8C771": "HUAWEI TECHNOLOGIES CO.",
    "7C1015": "Brilliant Home Technology",
    "00204F": "DEUTSCHE AEROSPACE AG",
    "74614B": "Chongqing Huijiatong Information Technology Co.",
    "D825B0": "Rockeetech Systems Co.",
    "D4B169": "Le Shi Zhi Xin Electronic Technology (Tianjin) Limited",
    "E44790": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "38454C": "Light Labs",
    "F49651": "NAKAYO Inc",
    "446246": "Comat AG",
    "CCB8A8": "AMPAK Technology",
    "34049E": "IEEE Registration Authority",
    "94FB29": "Zebra Technologies Inc.",
    "B0702D": "Apple",
    "6C19C0": "Apple",
    "E02A82": "Universal Global Scientific Industrial Co.",
    "98D293": "Google",
    "00DBDF": "Intel Corporate",
    "94A04E": "Bostex Technology Co.",
    "B0F963": "Hangzhou H3C Technologies Co.",
    "A84041": "Dragino Technology Co.",
    "80D4A5": "HUAWEI TECHNOLOGIES CO.",
    "04B0E7": "HUAWEI TECHNOLOGIES CO.",
    "446A2E": "HUAWEI TECHNOLOGIES CO.",
    "A06FAA": "LG Innotek",
    "0026AB": "Seiko Epson Corporation",
    "000894": "InnoVISION Multimedia Ltd.",
    "8CE117": "zte corporation",
    "688AF0": "zte corporation",
    "C0210D": "SHENZHEN RF-LINK TECHNOLOGY CO.",
    "4CE2F1": "Udino srl",
    "1077B0": "Fiberhome Telecommunication Technologies Co.",
    "F01DBC": "Microsoft Corporation",
    "504B5B": "CONTROLtronic GmbH",
    "B47447": "CoreOS",
    "AC587B": "JCT Healthcare",
    "1062EB": "D-Link International",
    "FC10C6": "Taicang T&W Electronics",
    "C8662C": "Beijing Haitai Fangyuan High Technology Co",
    "D058A8": "zte corporation",
    "D071C4": "zte corporation",
    "B4B384": "ShenZhen Figigantic Electronic Co.",
    "2C6FC9": "Hon Hai Precision Ind. Co.",
    "8096CA": "Hon Hai Precision Ind. Co.",
    "186571": "Top Victory Electronics (Taiwan) Co.",
    "F83F51": "Samsung Electronics Co.",
    "50D753": "CONELCOM GmbH",
    "0CC47A": "Super Micro Computer",
    "34D270": "Amazon Technologies Inc.",
    "A0CC2B": "Murata Manufacturing Co.",
    "0023D2": "Inhand Electronics",
    "00271C": "MERCURY CORPORATION",
    "E0D9E3": "Eltex Enterprise Ltd.",
    "6CA7FA": "YOUNGBO ENGINEERING INC.",
    "8C7EB3": "Lytro",
    "805EC0": "YEALINK(XIAMEN) NETWORK TECHNOLOGY CO.",
    "00C003": "GLOBALNET COMMUNICATIONS",
    "00234A": "Private",
    "1C40E8": "SHENZHEN PROGRESS&WIN TECHNOLOGY CO.",
    "2C402B": "Smart iBlue Technology Limited",
    "5C6B4F": "Hello Inc.",
    "50795B": "Interexport Telecomunicaciones S.A.",
    "0016D9": "NINGBO BIRD CO.",
    "5001D9": "HUAWEI TECHNOLOGIES CO.",
    "A8E705": "Fiberhome Telecommunication Technologies Co.",
    "60A4D0": "Samsung Electronics Co.",
    "007B18": "SENTRY Co.",
    "144D67": "Zioncom Electronics (Shenzhen) Ltd.",
    "4CE173": "IEEE Registration Authority",
    "0CD86C": "SHENZHEN FAST TECHNOLOGIES CO.",
    "886B0F": "Bluegiga Technologies OY",
    "AC84C9": "Sagemcom Broadband SAS",
    "9C62AB": "Sumavision Technologies Co.",
    "188B15": "ShenZhen ZhongRuiJing Technology co.",
    "049790": "Lartech telecom LLC",
    "28EED3": "Shenzhen Super D Technology Co.",
    "24C44A": "zte corporation",
    "98541B": "Intel Corporate",
    "0060D6": "NovAtel Inc.",
    "DC0B34": "LG Electronics (Mobile Communications)",
    "B0958E": "TP-LINK TECHNOLOGIES CO.",
    "C025E9": "TP-LINK TECHNOLOGIES CO.",
    "404E36": "HTC Corporation",
    "2C3361": "Apple",
    "C8F946": "LOCOSYS Technology Inc.",
    "00137E": "CorEdge Networks",
    "D814D6": "SURE SYSTEM Co Ltd",
    "6CEFC6": "SHENZHEN TWOWING TECHNOLOGIES CO.",
    "101DC0": "Samsung Electronics Co.",
    "008701": "Samsung Electronics Co.",
    "5C9960": "Samsung Electronics Co.",
    "245CBF": "NCSE",
    "487B6B": "HUAWEI TECHNOLOGIES CO.",
    "883FD3": "HUAWEI TECHNOLOGIES CO.",
    "5CA933": "Luma Home",
    "C8028F": "Nova Electronics (Shanghai) Co.",
    "000B14": "ViewSonic Corporation",
    "240D65": "Shenzhen Vsun Communication Technology Co.",
    "002341": "Vanderbilt International (SWE) AB",
    "407C7D": "Nokia",
    "24590B": "White Sky Inc. Limited",
    "143365": "TEM Mobile Limited",
    "78471D": "Samsung Electronics Co.",
    "A07591": "Samsung Electronics Co.",
    "0CDFA4": "Samsung Electronics Co.",
    "68EBAE": "Samsung Electronics Co.",
    "444E1A": "Samsung Electronics Co.",
    "D8EC5E": "Belkin International Inc.",
    "E89F80": "Belkin International Inc.",
    "0050CB": "Bucher Automation AG",
    "B072BF": "Murata Manufacturing Co.",
    "6CDEA9": "Cisco Meraki",
    "A8469D": "Cisco Meraki",
    "58EF68": "Belkin International Inc.",
    "CC03D9": "Cisco Meraki",
    "0C8DDB": "Cisco Meraki",
    "701DC4": "NorthStar Battery Company",
    "5C8613": "Beijing Zhoenet Technology Co.",
    "CC7314": "HONG KONG WHEATEK TECHNOLOGY LIMITED",
    "B8EE65": "Liteon Technology Corporation",
    "985BB0": "KMDATA INC.",
    "0011FF": "Digitro Tecnologia Ltda",
    "14B837": "Shenzhen YOUHUA Technology Co.",
    "5CA39D": "SAMSUNG ELECTRO MECHANICS CO.",
    "90187C": "SAMSUNG ELECTRO MECHANICS CO.",
    "A41731": "Hon Hai Precision Ind. Co.",
    "E006E6": "Hon Hai Precision Ind. Co.",
    "BC8556": "Hon Hai Precision Ind. Co.",
    "342387": "Hon Hai Precision Ind. Co.",
    "64DAA0": "Robert Bosch Smart Home GmbH",
    "E47CF9": "Samsung Electronics Co.",
    "4844F7": "Samsung Electronics Co.",
    "001377": "Samsung Electronics Co.",
    "002454": "Samsung Electronics Co.",
    "E81132": "Samsung Electronics Co.",
    "50B7C3": "Samsung Electronics Co.",
    "1C5A3E": "Samsung Electronics Co.",
    "A02195": "Samsung Electronics Co.",
    "50CCF8": "SAMSUNG ELECTRO MECHANICS CO.",
    "002637": "SAMSUNG ELECTRO MECHANICS CO.",
    "002119": "SAMSUNG ELECTRO MECHANICS CO.",
    "F4D9FB": "Samsung Electronics Co.",
    "3C6200": "Samsung Electronics Co.",
    "F07BCB": "Hon Hai Precision Ind. Co.",
    "C417FE": "Hon Hai Precision Ind. Co.",
    "9439E5": "Hon Hai Precision Ind. Co.",
    "642737": "Hon Hai Precision Ind. Co.",
    "C0F8DA": "Hon Hai Precision Ind. Co.",
    "F0F002": "Hon Hai Precision Ind. Co.",
    "C0CB38": "Hon Hai Precision Ind. Co.",
    "001B94": "T.E.M.A. S.p.A.",
    "00223B": "Communication Networks",
    "10D542": "Samsung Electronics Co.",
    "A0821F": "Samsung Electronics Co.",
    "F06BCA": "Samsung Electronics Co.",
    "AC3613": "Samsung Electronics Co.",
    "BC8CCD": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
    "D022BE": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
    "EC9BF3": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
    "F409D8": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
    "18D276": "HUAWEI TECHNOLOGIES CO.",
    "4C3C16": "Samsung Electronics Co.",
    "0073E0": "Samsung Electronics Co.",
    "343111": "Samsung Electronics Co.",
    "08FD0E": "Samsung Electronics Co.",
    "041BBA": "Samsung Electronics Co.",
    "889B39": "Samsung Electronics Co.",
    "E432CB": "Samsung Electronics Co.",
    "B07870": "Wi-NEXT",
    "0017D5": "Samsung Electronics Co.",
    "001E7D": "Samsung Electronics Co.",
    "001DF6": "Samsung Electronics Co.",
    "94350A": "Samsung Electronics Co.",
    "C06599": "Samsung Electronics Co.",
    "BC79AD": "Samsung Electronics Co.",
    "F0E77E": "Samsung Electronics Co.",
    "F008F1": "Samsung Electronics Co.",
    "58C38B": "Samsung Electronics Co.",
    "F0038C": "AzureWave Technology Inc.",
    "00E3B2": "Samsung Electronics Co.",
    "301966": "Samsung Electronics Co.",
    "001D25": "Samsung Electronics Co.",
    "B0F893": "Shanghai MXCHIP Information Technology Co.",
    "001E81": "CNB Technology Inc.",
    "7CA97D": "Objenious",
    "A8A648": "Qingdao Hisense Communications Co.",
    "84EF18": "Intel Corporate",
    "A81B6A": "Texas Instruments",
    "985DAD": "Texas Instruments",
    "D43639": "Texas Instruments",
    "BC282C": "e-Smart Systems Pvt. Ltd",
    "E4C1F1": "SHENZHEN SPOTMAU INFORMATION TECHNOLIGY CO.",
    "240AC4": "Espressif Inc.",
    "005218": "Wuxi Keboda Electron Co.Ltd",
    "C411E0": "Bull Group Co.",
    "343DC4": "BUFFALO.INC",
    "002611": "Licera AB",
    "48FD8E": "HUAWEI TECHNOLOGIES CO.",
    "7C0623": "Ultra Electronics Sonar System Division",
    "00126C": "Visonic Technologies 1993 Ltd.",
    "A40DBC": "Xiamen Intretech Inc.",
    "0002C9": "Mellanox Technologies",
    "28AC67": "Mach Power",
    "0080C7": "XIRCOM",
    "000138": "XAVi Technologies Corp.",
    "00166D": "Yulong Computer Telecommunication Scientific (Shenzhen) Co.",
    "3C9157": "Yulong Computer Telecommunication Scientific (Shenzhen) Co.",
    "14825B": "Hefei Radio Communication Technology Co.",
    "AC6175": "HUAWEI TECHNOLOGIES CO.",
    "244427": "HUAWEI TECHNOLOGIES CO.",
    "0000D8": "Novell",
    "001F46": "Nortel Networks",
    "003093": "Sonnet Technologies",
    "00034B": "Nortel Networks",
    "080051": "ExperData",
    "002561": "ProCurve Networking by HP",
    "008058": "PRINTER SYSTEMS CORP.",
    "00157D": "POSDATA",
    "4849C7": "Samsung Electronics Co.",
    "849866": "Samsung Electronics Co.",
    "001B25": "Nortel Networks",
    "0019E1": "Nortel Networks",
    "001D42": "Nortel Networks",
    "000E40": "Nortel Networks",
    "001C9C": "Nortel Networks",
    "1880F5": "Alcatel-Lucent Shanghai Bell Co.",
    "00140D": "Nortel Networks",
    "10E878": "Nokia",
    "FCB0C4": "Shanghai DareGlobal Technologies Co.",
    "A89DD2": "Shanghai DareGlobal Technologies Co.",
    "00E00F": "Shanghai Baud Data Communication Co.",
    "28BE03": "TCT mobile ltd",
    "903AE6": "PARROT SA",
    "A098ED": "Shandong Intelligent Optical Communication Development Co.",
    "000EF4": "Kasda Networks Inc",
    "002280": "A2B Electronics AB",
    "404AD4": "Widex A/S",
    "9893CC": "LG ELECTRONICS INC",
    "3CCD93": "LG ELECTRONICS INC",
    "2021A5": "LG Electronics (Mobile Communications)",
    "6CD68A": "LG Electronics (Mobile Communications)",
    "00167A": "Skyworth Overseas Development Ltd.",
    "A42940": "Shenzhen YOUHUA Technology Co.",
    "E4A387": "Control Solutions LLC",
    "002483": "LG Electronics (Mobile Communications)",
    "001FE3": "LG Electronics (Mobile Communications)",
    "2C54CF": "LG Electronics (Mobile Communications)",
    "485929": "LG Electronics (Mobile Communications)",
    "CC79CF": "SHENZHEN RF-LINK TECHNOLOGY CO.",
    "001925": "Intelicis Corporation",
    "9476B7": "Samsung Electronics Co.",
    "F485C6": "FDT Technologies",
    "0019AB": "Raycom CO .",
    "4C334E": "HIGHTECH",
    "000F62": "Alcatel Bell Space N.V.",
    "001CD8": "BlueAnt Wireless",
    "283638": "IEEE Registration Authority",
    "C88ED1": "IEEE Registration Authority",
    "B01F81": "IEEE Registration Authority",
    "B8D812": "IEEE Registration Authority",
    "1C21D1": "IEEE Registration Authority",
    "7C70BC": "IEEE Registration Authority",
    "E81863": "IEEE Registration Authority",
    "286C07": "XIAOMI Electronics",
    "F0421C": "Intel Corporate",
    "2CD141": "IEEE Registration Authority",
    "3C39E7": "IEEE Registration Authority",
    "BC6641": "IEEE Registration Authority",
    "80E4DA": "IEEE Registration Authority",
    "885D90": "IEEE Registration Authority",
    "58A2B5": "LG Electronics (Mobile Communications)",
    "10F96F": "LG Electronics (Mobile Communications)",
    "C4438F": "LG Electronics (Mobile Communications)",
    "A09169": "LG Electronics (Mobile Communications)",
    "BCC00F": "Fiberhome Telecommunication Technologies Co.",
    "9CA5C0": "vivo Mobile Communication Co.",
    "3044A1": "Shanghai Nanchao Information Technology",
    "C8755B": "Quantify Technology Pty. Ltd.",
    "4C6641": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
    "70E284": "Wistron Infocomm (Zhongshan) Corporation",
    "A854B2": "Wistron Neweb Corporation",
    "E09579": "ORTHOsoft inc",
    "A0ADA1": "JMR Electronics",
    "E0ACF1": "Cisco Systems",
    "001428": "Vocollect Inc",
    "006B9E": "Vizio",
    "70F395": "Universal Global Scientific Industrial Co.",
    "5CA86A": "HUAWEI TECHNOLOGIES CO.",
    "00C0AB": "Telco Systems",
    "90A4DE": "Wistron Neweb Corporation",
    "0017CA": "Qisda Corporation",
    "0015B7": "Toshiba",
    "E89D87": "Toshiba",
    "00015B": "ITALTEL S.p.A/RF-UP-I",
    "00A0A8": "RENEX CORPORATION",
    "88124E": "Qualcomm Inc.",
    "001B32": "QLogic Corporation",
    "001D7E": "Cisco-Linksys",
    "E4FB8F": "MOBIWIRE MOBILES (NINGBO) CO.",
    "10BD55": "Q-Lab Corporation",
    "C449BB": "MITSUMI ELECTRIC CO.",
    "FC2D5E": "zte corporation",
    "0019CB": "Zyxel Communications Corporation",
    "2C094D": "Raptor Engineering",
    "AC3743": "HTC Corporation",
    "F85A00": "Sanford LP",
    "B40418": "Smartchip Integrated Inc.",
    "90CF7D": "Qingdao Hisense Communications Co.",
    "3876CA": "Shenzhen Smart Intelligent Technology Co.Ltd",
    "F40A4A": "INDUSNET Communication Technology Co.",
    "0023F8": "Zyxel Communications Corporation",
    "B8BBAF": "Samsung Electronics Co.",
    "60C5AD": "Samsung Electronics Co.",
    "442C05": "AMPAK Technology",
    "8C897A": "AUGTEK",
    "50AB3E": "Qibixx AG",
    "042758": "HUAWEI TECHNOLOGIES CO.",
    "9CE374": "HUAWEI TECHNOLOGIES CO.",
    "002550": "Riverbed Technology",
    "FC55DC": "Baltic Latvian Universal Electronics LLC",
    "6038E0": "Belkin International Inc.",
    "8CD2E9": "YOKOTE SEIKO CO.",
    "24F094": "Apple",
    "086D41": "Apple",
    "ECADB8": "Apple",
    "002552": "VXi Corporation",
    "9801A7": "Apple",
    "6879ED": "SHARP Corporation",
    "608D17": "Sentrus Government Systems Division",
    "7C738B": "Cocoon Alarm Ltd",
    "B4D5BD": "Intel Corporate",
    "98AA3C": "Will i-tech Co.",
    "DC3752": "GE",
    "F4911E": "ZHUHAI EWPE INFORMATION TECHNOLOGY INC",
    "DCD916": "HUAWEI TECHNOLOGIES CO.",
    "002382": "Lih Rong electronic Enterprise Co.",
    "F845AD": "Konka Group Co.",
    "000FE2": "Hangzhou H3C Technologies Co.",
    "6CE983": "Gastron Co.",
    "28E31F": "Xiaomi Communications Co Ltd",
    "F80F84": "Natural Security SAS",
    "44A42D": "TCT mobile ltd",
    "80F62E": "Hangzhou H3C Technologies Co.",
    "70F96D": "Hangzhou H3C Technologies Co.",
    "00C0F0": "Kingston Technology Company",
    "0018D7": "JAVAD GNSS",
    "001F09": "Jastec",
    "AC620D": "Jabil Circuit(Wuxi) Co.",
    "BC6A44": "Commend International GmbH",
    "F0EE58": "PACE Telematics GmbH",
    "4CA003": "VITEC",
    "083FBC": "zte corporation",
    "0000C9": "Emulex Corporation",
    "B8AEED": "Elitegroup Computer Systems Co.",
    "1C7370": "Neotech",
    "00022E": "TEAC Corp. R& D",
    "0060B0": "Hewlett Packard",
    "08000D": "International Computers",
    "30E37A": "Intel Corporate",
    "0040AA": "Valmet Automation",
    "7050AF": "SKY UK LIMITED",
    "F4EF9E": "SGSG SCIENCE & TECHNOLOGY CO. LTD",
    "1C740D": "Zyxel Communications Corporation",
    "603ECA": "Cambridge Medical Robotics Ltd",
    "000DB0": "Olym-tech Co.",
    "30F6B9": "Ecocentric Energy",
    "9C741A": "HUAWEI TECHNOLOGIES CO.",
    "E4A8B6": "HUAWEI TECHNOLOGIES CO.",
    "244C07": "HUAWEI TECHNOLOGIES CO.",
    "746FF7": "Wistron Neweb Corporation",
    "D0B0CD": "Moen",
    "001F1F": "Edimax Technology Co. Ltd.",
    "00020E": "ECI Telecom Ltd.",
    "200A5E": "Xiangshan Giant Eagle Technology Developing Co.",
    "B0E2E5": "Fiberhome Telecommunication Technologies Co.",
    "40476A": "Astro Gaming",
    "001FA7": "Sony Interactive Entertainment Inc.",
    "9046A2": "Tedipay UK Ltd",
    "6479A7": "Phison Electronics Corp.",
    "1C5F2B": "D-Link International",
    "00C164": "Cisco Systems",
    "CCB11A": "Samsung Electronics Co.",
    "703C03": "RadiAnt Co.",
    "AC44F2": "YAMAHA CORPORATION",
    "CCD3E2": "Jiangsu Yinhe  Electronics Co.",
    "E4FAED": "Samsung Electronics Co.",
    "288335": "Samsung Electronics Co.",
    "DCCF96": "Samsung Electronics Co.",
    "DC2DCB": "Beijing Unis HengYue Technology Co.",
    "2C9662": "Invenit BV",
    "1CEA1B": "Nokia",
    "D4612E": "HUAWEI TECHNOLOGIES CO.",
    "54511B": "HUAWEI TECHNOLOGIES CO.",
    "68536C": "SPnS Co.",
    "047E4A": "moobox CO.",
    "0080E5": "NetApp",
    "9C5C8E": "ASUSTek COMPUTER INC.",
    "C88722": "Lumenpulse",
    "84683E": "Intel Corporate",
    "743E2B": "Ruckus Wireless",
    "CCB3AB": "shenzhen Biocare Bio-Medical Equipment Co.",
    "E4B318": "Intel Corporate",
    "E0CDFD": "Beijing E3Control Technology Co",
    "30785C": "Partow Tamas Novin (Parman)",
    "E0C767": "Apple",
    "80ED2C": "Apple",
    "F03404": "TCT mobile ltd",
    "80D160": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "60ACC8": "KunTeng Inc.",
    "70661B": "Sonova AG",
    "B07FB9": "NETGEAR",
    "AC61EA": "Apple",
    "38B54D": "Apple",
    "1C5CF2": "Apple",
    "80501B": "Nokia Corporation",
    "A04E04": "Nokia Corporation",
    "14C126": "Nokia Corporation",
    "600194": "Espressif Inc.",
    "D8F710": "Libre Wireless Technologies Inc.",
    "3C591E": "TCL King Electrical Appliances (Huizhou) Co.",
    "002682": "Gemtek Technology Co.",
    "8CA2FD": "Starry",
    "84BA3B": "CANON INC.",
    "A87E33": "Nokia Danmark A/S",
    "002403": "Nokia Danmark A/S",
    "001B33": "Nokia Danmark A/S",
    "00194F": "Nokia Danmark A/S",
    "00BD3A": "Nokia Corporation",
    "002404": "Nokia Danmark A/S",
    "0019B7": "Nokia Danmark A/S",
    "0017B0": "Nokia Danmark A/S",
    "0015DE": "Nokia Danmark A/S",
    "0002EE": "Nokia Danmark A/S",
    "0009E1": "Gemtek Technology Co.",
    "140C76": "FREEBOX SAS",
    "0016BC": "Nokia Danmark A/S",
    "00174B": "Nokia Danmark A/S",
    "002669": "Nokia Danmark A/S",
    "002109": "Nokia Danmark A/S",
    "002108": "Nokia Danmark A/S",
    "001262": "Nokia Danmark A/S",
    "0014A7": "Nokia Danmark A/S",
    "0015A0": "Nokia Danmark A/S",
    "029D8E": "CARDIAC RECORDERS",
    "00402A": "Canoga Perkins Corporation",
    "A4C7DE": "Cambridge Industries(Group) Co.",
    "0019C7": "Cambridge Industries(Group) Co.",
    "70D931": "Cambridge Industries(Group) Co.",
    "0270B3": "DATA RECALL LTD.",
    "000136": "CyberTAN Technology Inc.",
    "0030DA": "Comtrend Corporation",
    "64680C": "Comtrend Corporation",
    "3872C0": "Comtrend Corporation",
    "A80600": "Samsung Electronics Co.",
    "C43655": "Shenzhen Fenglian Technology Co.",
    "E0B9E5": "Technicolor Delivery Technologies Belgium NV",
    "0060BB": "Cabletron Systems",
    "D8B8F6": "Nantworks",
    "24F5AA": "Samsung Electronics Co.",
    "988389": "Samsung Electronics Co.",
    "84A466": "Samsung Electronics Co.",
    "C4576E": "Samsung Electronics Co.",
    "508569": "Samsung Electronics Co.",
    "78595E": "Samsung Electronics Co.",
    "0C1420": "Samsung Electronics Co.",
    "94B10A": "Samsung Electronics Co.",
    "3CBBFD": "Samsung Electronics Co.",
    "A48431": "Samsung Electronics Co.",
    "F05A09": "Samsung Electronics Co.",
    "503275": "Samsung Electronics Co.",
    "08FC88": "Samsung Electronics Co.",
    "F8D0BD": "Samsung Electronics Co.",
    "A0B4A5": "Samsung Electronics Co.",
    "E4F8EF": "Samsung Electronics Co.",
    "D04D2C": "Roku",
    "B0A737": "Roku",
    "008077": "Brother industries",
    "001BE9": "Broadcom",
    "DC446D": "Allwinner Technology Co.",
    "745AAA": "HUAWEI TECHNOLOGIES CO.",
    "04FE8D": "HUAWEI TECHNOLOGIES CO.",
    "DC64B8": "Shenzhen JingHanDa Electronics Co.Ltd",
    "44EE02": "MTI Ltd.",
    "001333": "BaudTec Corporation",
    "58671A": "Barnes&Noble",
    "002675": "Aztech Electronics Pte Ltd",
    "0024FE": "AVM GmbH",
    "C02506": "AVM GmbH",
    "A8D3F7": "Arcadyan Technology Corporation",
    "489D24": "BlackBerry RTS",
    "000D92": "ARIMA Communications Corp.",
    "002163": "ASKEY COMPUTER CORP",
    "08BD43": "NETGEAR",
    "4C60DE": "NETGEAR",
    "C43DC7": "NETGEAR",
    "405D82": "NETGEAR",
    "DCEF09": "NETGEAR",
    "001963": "Sony Corporation",
    "001FE4": "Sony Corporation",
    "002345": "Sony Corporation",
    "6C0E0D": "Sony Corporation",
    "6C23B9": "Sony Corporation",
    "3017C8": "Sony Corporation",
    "205476": "Sony Corporation",
    "001A80": "Sony Corporation",
    "0012EE": "Sony Corporation",
    "001620": "Sony Corporation",
    "0000F4": "Allied Telesis",
    "001577": "Allied Telesis",
    "703C39": "SEAWING Kft",
    "9097D5": "Espressif Inc.",
    "ACD074": "Espressif Inc.",
    "38E3C5": "Taicang T&W Electronics",
    "8841FC": "AirTies Wireless Networks",
    "B8616F": "Accton Technology Corp",
    "0012CF": "Accton Technology Corp",
    "0030F1": "Accton Technology Corp",
    "98743D": "Shenzhen Jun Kai Hengye Technology Co. Ltd",
    "A0F459": "FN-LINK TECHNOLOGY LIMITED",
    "586356": "FN-LINK TECHNOLOGY LIMITED",
    "40E230": "AzureWave Technology Inc.",
    "80D21D": "AzureWave Technology Inc.",
    "705A0F": "Hewlett Packard",
    "4495FA": "Qingdao Santong Digital Technology Co.Ltd",
    "74C246": "Amazon Technologies Inc.",
    "000FA3": "Alpha Networks Inc.",
    "001D6A": "Alpha Networks Inc.",
    "0025D3": "AzureWave Technology Inc.",
    "1C4BD6": "AzureWave Technology Inc.",
    "08A95A": "AzureWave Technology Inc.",
    "94DBC9": "AzureWave Technology Inc.",
    "240A64": "AzureWave Technology Inc.",
    "D4D184": "ADB Broadband Italia",
    "A04FD4": "ADB Broadband Italia",
    "8CB864": "AcSiP Technology Corp.",
    "5CE2F4": "AcSiP Technology Corp.",
    "0030D3": "Agilent Technologies",
    "00A02F": "ADB Broadband Italia",
    "709E29": "Sony Interactive Entertainment Inc.",
    "A4DB30": "Liteon Technology Corporation",
    "40F02F": "Liteon Technology Corporation",
    "D00ED9": "Taicang T&W Electronics",
    "541473": "Wingtech Group (HongKong）Limited",
    "7CCCB8": "Intel Corporate",
    "F40669": "Intel Corporate",
    "001DE1": "Intel Corporate",
    "001F3B": "Intel Corporate",
    "00215D": "Intel Corporate",
    "00216A": "Intel Corporate",
    "8086F2": "Intel Corporate",
    "E09467": "Intel Corporate",
    "08D40C": "Intel Corporate",
    "6C8814": "Intel Corporate",
    "90E2BA": "Intel Corporate",
    "0026C7": "Intel Corporate",
    "0026C6": "Intel Corporate",
    "303A64": "Intel Corporate",
    "ACFDCE": "Intel Corporate",
    "0CCC26": "Airenetworks",
    "E09D31": "Intel Corporate",
    "88532E": "Intel Corporate",
    "884AEA": "Texas Instruments",
    "74E14A": "IEEE Registration Authority",
    "0CEFAF": "IEEE Registration Authority",
    "F80278": "IEEE Registration Authority",
    "A0BB3E": "IEEE Registration Authority",
    "C46699": "vivo Mobile Communication Co.",
    "C8F230": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "8C0EE3": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "B07994": "Motorola Mobility LLC",
    "A470D6": "Motorola Mobility LLC",
    "74C99A": "Ericsson AB",
    "5CC213": "Fr. Sauter AG",
    "28101B": "MagnaCom",
    "001676": "Intel Corporate",
    "0016EA": "Intel Corporate",
    "001B77": "Intel Corporate",
    "001CC0": "Intel Corporate",
    "104A7D": "Intel Corporate",
    "C0D044": "Sagemcom Broadband SAS",
    "A01B29": "Sagemcom Broadband SAS",
    "C8CD72": "Sagemcom Broadband SAS",
    "0022A4": "2Wire Inc",
    "982CBE": "2Wire Inc",
    "640F28": "2Wire Inc",
    "001556": "Sagemcom Broadband SAS",
    "001495": "2Wire Inc",
    "0050BA": "D-Link Corporation",
    "00179A": "D-Link Corporation",
    "001CF0": "D-Link Corporation",
    "001E58": "D-Link Corporation",
    "0022B0": "D-Link Corporation",
    "002401": "D-Link Corporation",
    "1CAFF7": "D-Link International",
    "14D64D": "D-Link International",
    "B499BA": "Hewlett Packard",
    "0C47C9": "Amazon Technologies Inc.",
    "944452": "Belkin International Inc.",
    "0030C5": "CADENCE DESIGN SYSTEMS",
    "348AAE": "Sagemcom Broadband SAS",
    "7C03D8": "Sagemcom Broadband SAS",
    "C0AC54": "Sagemcom Broadband SAS",
    "2C3996": "Sagemcom Broadband SAS",
    "F08261": "Sagemcom Broadband SAS",
    "F82C18": "2Wire Inc",
    "18017D": "Harbin Arteor technology co.",
    "E0D7BA": "Texas Instruments",
    "D08CB5": "Texas Instruments",
    "00182F": "Texas Instruments",
    "0017EA": "Texas Instruments",
    "0021BA": "Texas Instruments",
    "0014BF": "Cisco-Linksys",
    "BC0DA5": "Texas Instruments",
    "CC8CE3": "Texas Instruments",
    "1CE2CC": "Texas Instruments",
    "985945": "Texas Instruments",
    "D494A1": "Texas Instruments",
    "B0B448": "Texas Instruments",
    "94EB2C": "Google",
    "9094E4": "D-Link International",
    "CCB255": "D-Link International",
    "28107B": "D-Link International",
    "FC7516": "D-Link International",
    "84C9B2": "D-Link International",
    "C8D3A3": "D-Link International",
    "3CBB73": "Shenzhen Xinguodu Technology Co.",
    "287CDB": "Hefei  Toycloud Technology Co.",
    "806AB0": "Shenzhen TINNO Mobile Technology Corp.",
    "047863": "Shanghai MXCHIP Information Technology Co.",
    "3C5AB4": "Google",
    "F4F5E8": "Google",
    "48AD08": "HUAWEI TECHNOLOGIES CO.",
    "4CFB45": "HUAWEI TECHNOLOGIES CO.",
    "009ACD": "HUAWEI TECHNOLOGIES CO.",
    "70B3D5": "IEEE Registration Authority",
    "28ED6A": "Apple",
    "409F87": "Jide Technology (Hong Kong) Limited",
    "0CF9C0": "SKY UK LIMITED",
    "4CFF12": "Fuze Entertainment Co.",
    "0CC731": "Currant",
    "AC9A22": "NXP Semiconductors",
    "38F23E": "Microsoft Mobile Oy",
    "2C4138": "Hewlett Packard",
    "441EA1": "Hewlett Packard",
    "78E7D1": "Hewlett Packard",
    "0012F0": "Intel Corporate",
    "E4F89C": "Intel Corporate",
    "6CA100": "Intel Corporate",
    "A402B9": "Intel Corporate",
    "DC5360": "Intel Corporate",
    "3464A9": "Hewlett Packard",
    "3863BB": "Hewlett Packard",
    "5CB901": "Hewlett Packard",
    "DC4A3E": "Hewlett Packard",
    "9CB654": "Hewlett Packard",
    "000740": "BUFFALO.INC",
    "0024A5": "BUFFALO.INC",
    "CCE1D5": "BUFFALO.INC",
    "001CC4": "Hewlett Packard",
    "001E0B": "Hewlett Packard",
    "002264": "Hewlett Packard",
    "0025B3": "Hewlett Packard",
    "6C3BE5": "Hewlett Packard",
    "A0B3CC": "Hewlett Packard",
    "ECB1D7": "Hewlett Packard",
    "000CF1": "Intel Corporation",
    "784859": "Hewlett Packard",
    "643150": "Hewlett Packard",
    "58DC6D": "Exceptional Innovation",
    "902155": "HTC Corporation",
    "D8B377": "HTC Corporation",
    "B0F1A3": "Fengfan (BeiJing) Technology Co.",
    "A4D18C": "Apple",
    "241EEB": "Apple",
    "CC25EF": "Apple",
    "942CB3": "HUMAX Co.",
    "B05ADA": "Hewlett Packard",
    "001083": "Hewlett Packard",
    "88CF98": "HUAWEI TECHNOLOGIES CO.",
    "140467": "SNK Technologies Co.",
    "7CB15D": "HUAWEI TECHNOLOGIES CO.",
    "00265E": "Hon Hai Precision Ind. Co.",
    "00242C": "Hon Hai Precision Ind. Co.",
    "8030DC": "Texas Instruments",
    "A4D578": "Texas Instruments",
    "246081": "razberi technologies",
    "002719": "TP-LINK TECHNOLOGIES CO.",
    "40169F": "TP-LINK TECHNOLOGIES CO.",
    "F4EC38": "TP-LINK TECHNOLOGIES CO.",
    "808917": "TP-LINK TECHNOLOGIES CO.",
    "A09347": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "E8BBA8": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "B0AA36": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "F80D43": "Hon Hai Precision Ind. Co.",
    "38F889": "HUAWEI TECHNOLOGIES CO.",
    "D07AB5": "HUAWEI TECHNOLOGIES CO.",
    "904E2B": "HUAWEI TECHNOLOGIES CO.",
    "2008ED": "HUAWEI TECHNOLOGIES CO.",
    "84742A": "zte corporation",
    "9CD24B": "zte corporation",
    "C87B5B": "zte corporation",
    "0019C6": "zte corporation",
    "001DD9": "Hon Hai Precision Ind. Co.",
    "0007D8": "Hitron Technologies. Inc",
    "C03E0F": "SKY UK LIMITED",
    "7C4CA5": "SKY UK LIMITED",
    "CC4E24": "Brocade Communications Systems LLC",
    "90F652": "TP-LINK TECHNOLOGIES CO.",
    "14CF92": "TP-LINK TECHNOLOGIES CO.",
    "20DCE6": "TP-LINK TECHNOLOGIES CO.",
    "14CC20": "TP-LINK TECHNOLOGIES CO.",
    "784B87": "Murata Manufacturing Co.",
    "E4CE02": "WyreStorm Technologies Ltd",
    "40F308": "Murata Manufacturing Co.",
    "00197D": "Hon Hai Precision Ind. Co.",
    "0014A4": "Hon Hai Precision Ind. Co.",
    "78DD08": "Hon Hai Precision Ind. Co.",
    "9CD21E": "Hon Hai Precision Ind. Co.",
    "00E052": "Brocade Communications Systems LLC",
    "00010F": "Brocade Communications Systems LLC",
    "080088": "Brocade Communications Systems LLC",
    "B43052": "HUAWEI TECHNOLOGIES CO.",
    "04C06F": "HUAWEI TECHNOLOGIES CO.",
    "202BC1": "HUAWEI TECHNOLOGIES CO.",
    "54A51B": "HUAWEI TECHNOLOGIES CO.",
    "002568": "HUAWEI TECHNOLOGIES CO.",
    "781DBA": "HUAWEI TECHNOLOGIES CO.",
    "00259E": "HUAWEI TECHNOLOGIES CO.",
    "3475C7": "Avaya Inc",
    "001B4F": "Avaya Inc",
    "006B8E": "Shanghai Feixun Communication Co.",
    "D46AA8": "HUAWEI TECHNOLOGIES CO.",
    "0034FE": "HUAWEI TECHNOLOGIES CO.",
    "C85195": "HUAWEI TECHNOLOGIES CO.",
    "40CBA8": "HUAWEI TECHNOLOGIES CO.",
    "D46E5C": "HUAWEI TECHNOLOGIES CO.",
    "80D09B": "HUAWEI TECHNOLOGIES CO.",
    "1C8E5C": "HUAWEI TECHNOLOGIES CO.",
    "B8BC1B": "HUAWEI TECHNOLOGIES CO.",
    "582AF7": "HUAWEI TECHNOLOGIES CO.",
    "D4B110": "HUAWEI TECHNOLOGIES CO.",
    "E468A3": "HUAWEI TECHNOLOGIES CO.",
    "3400A3": "HUAWEI TECHNOLOGIES CO.",
    "FC48EF": "HUAWEI TECHNOLOGIES CO.",
    "707BE8": "HUAWEI TECHNOLOGIES CO.",
    "4C1FCC": "HUAWEI TECHNOLOGIES CO.",
    "4C8BEF": "HUAWEI TECHNOLOGIES CO.",
    "8853D4": "HUAWEI TECHNOLOGIES CO.",
    "B0ADAA": "Avaya Inc",
    "B4475E": "Avaya Inc",
    "BCADAB": "Avaya Inc",
    "FCA841": "Avaya Inc",
    "24D921": "Avaya Inc",
    "848371": "Avaya Inc",
    "5006AB": "Cisco Systems",
    "0003DD": "Comark Interactive Solutions",
    "005053": "Cisco Systems",
    "005050": "Cisco Systems",
    "00E0A3": "Cisco Systems",
    "00E08F": "Cisco Systems",
    "001868": "Cisco SPVTG",
    "887556": "Cisco Systems",
    "FC9947": "Cisco Systems",
    "6C2056": "Cisco Systems",
    "00906D": "Cisco Systems",
    "0090AB": "Cisco Systems",
    "005054": "Cisco Systems",
    "00500B": "Cisco Systems",
    "08CC68": "Cisco Systems",
    "0C2724": "Cisco Systems",
    "6C416A": "Cisco Systems",
    "ECE1A9": "Cisco Systems",
    "ACF2C5": "Cisco Systems",
    "2401C7": "Cisco Systems",
    "6886A7": "Cisco Systems",
    "6CECEB": "Texas Instruments",
    "247189": "Texas Instruments",
    "987BF3": "Texas Instruments",
    "A0F6FD": "Texas Instruments",
    "00902B": "Cisco Systems",
    "78A504": "Texas Instruments",
    "D0B5C2": "Texas Instruments",
    "745E1C": "PIONEER CORPORATION",
    "001011": "Cisco Systems",
    "3C0E23": "Cisco Systems",
    "00E018": "ASUSTek COMPUTER INC.",
    "000C6E": "ASUSTek COMPUTER INC.",
    "000EA6": "ASUSTek COMPUTER INC.",
    "0023BE": "Cisco SPVTG",
    "185933": "Cisco SPVTG",
    "445829": "Cisco SPVTG",
    "602AD0": "Cisco SPVTG",
    "881DFC": "Cisco Systems",
    "1CE85D": "Cisco Systems",
    "A89D21": "Cisco Systems",
    "90E6BA": "ASUSTek COMPUTER INC.",
    "F46D04": "ASUSTek COMPUTER INC.",
    "6CFA89": "Cisco Systems",
    "F44E05": "Cisco Systems",
    "689CE2": "Cisco Systems",
    "A0F849": "Cisco Systems",
    "C067AF": "Cisco Systems",
    "C0255C": "Cisco Systems",
    "001D60": "ASUSTek COMPUTER INC.",
    "0015F2": "ASUSTek COMPUTER INC.",
    "28CFE9": "Apple",
    "00A040": "Apple",
    "AC7E8A": "Cisco Systems",
    "046273": "Cisco Systems",
    "CC08E0": "Apple",
    "F0B479": "Apple",
    "1093E9": "Apple",
    "442A60": "Apple",
    "00000C": "Cisco Systems",
    "D8B190": "Cisco Systems",
    "80E86F": "Cisco Systems",
    "0021E9": "Apple",
    "002608": "Apple",
    "0026B0": "Apple",
    "0026BB": "Apple",
    "C82A14": "Apple",
    "3C0754": "Apple",
    "A4B197": "Apple",
    "003065": "Apple",
    "001451": "Apple",
    "001E52": "Apple",
    "D49A20": "Apple",
    "F81EDF": "Apple",
    "A4D1D2": "Apple",
    "28CFDA": "Apple",
    "045453": "Apple",
    "3CD0F8": "Apple",
    "680927": "Apple",
    "6CC26B": "Apple",
    "949426": "Apple",
    "207D74": "Apple",
    "F4F15A": "Apple",
    "C86F1D": "Apple",
    "3090AB": "Apple",
    "8C2DAA": "Apple",
    "848506": "Apple",
    "98FE94": "Apple",
    "D8004D": "Apple",
    "542696": "Apple",
    "64A3CB": "Apple",
    "30F7C5": "Apple",
    "40B395": "Apple",
    "44FB42": "Apple",
    "E88D28": "Apple",
    "C8B5B7": "Apple",
    "90B21F": "Apple",
    "B8E856": "Apple",
    "D89695": "Apple",
    "44D884": "Apple",
    "64200C": "Apple",
    "C8334B": "Apple",
    "64E682": "Apple",
    "F4F951": "Apple",
    "C06394": "Apple",
    "18AF8F": "Apple",
    "1499E2": "Apple",
    "B418D1": "Apple",
    "9C207B": "Apple",
    "B065BD": "Apple",
    "50D59C": "Thai Habel Industrial Co.",
    "6C4A39": "BITA",
    "847D50": "Holley Metering Limited",
    "A0999B": "Apple",
    "24240E": "Apple",
    "903C92": "Apple",
    "D81D72": "Apple",
    "341298": "Apple",
    "70E72C": "Apple",
    "70ECE4": "Apple",
    "D8BB2C": "Apple",
    "D04F7E": "Apple",
    "9CF387": "Apple",
    "A85B78": "Apple",
    "F0DBF8": "Apple",
    "48746E": "Apple",
    "54AE27": "Apple",
    "C8F650": "Apple",
    "FCE998": "Apple",
    "0CBC9F": "Apple",
    "34363B": "Apple",
    "D0A637": "Apple",
    "789F70": "Apple",
    "2078F0": "Apple",
    "E0ACCB": "Apple",
    "68AE20": "Apple",
    "AC87A3": "Apple",
    "A88E24": "Apple",
    "3052CB": "Liteon Technology Corporation",
    "049645": "WUXI SKY CHIP INTERCONNECTION TECHNOLOGY CO.",
    "1CCDE5": "Shanghai Wind Technologies Co.",
    "88C242": "Poynt Co.",
    "DC82F6": "iPort",
    "50A9DE": "Smartcom - Bulgaria AD",
    "E034E4": "Feit Electric Company",
    "34C9F0": "LM Technologies Ltd",
    "681401": "Hon Hai Precision Ind. Co.",
    "AC1FD7": "Real Vision Technology Co.",
    "68A828": "HUAWEI TECHNOLOGIES CO.",
    "CC20E8": "Apple",
    "E8DED6": "Intrising Networks",
    "DCDC07": "TRP Systems BV",
    "3891D5": "Hangzhou H3C Technologies Co.",
    "8CE2DA": "Circle Media Inc",
    "489A42": "Technomate Ltd",
    "BC9C31": "HUAWEI TECHNOLOGIES CO.",
    "70480F": "Apple",
    "3CB72B": "PLUMgrid Inc",
    "D88B4C": "KingTing Tech.",
    "48BF74": "Baicells Technologies Co.",
    "6C9354": "Yaojin Technology (Shenzhen) Co.",
    "F0B0E7": "Apple",
    "20D160": "Private",
    "382187": "Midea Group Co.",
    "78D6B2": "Toshiba",
    "0469F8": "Apple",
    "AC8995": "AzureWave Technology Inc.",
    "381C23": "Hilan Technology CO.",
    "20C3A4": "RetailNext",
    "649A12": "P2 Mobile Technologies Limited",
    "E4C2D1": "HUAWEI TECHNOLOGIES CO.",
    "3029BE": "Shanghai MRDcom Co.",
    "D4F4BE": "Palo Alto Networks",
    "48B620": "ROLI Ltd.",
    "205531": "Samsung Electronics Co.",
    "307CB2": "ANOV FRANCE",
    "847973": "Shanghai Baud Data Communication Co.",
    "E8B4C8": "Samsung Electronics Co.",
    "D087E2": "Samsung Electronics Co.",
    "F05B7B": "Samsung Electronics Co.",
    "D888CE": "RF Technology Pty Ltd",
    "7CFE90": "Mellanox Technologies",
    "60FD56": "WOORISYSTEMS CO.",
    "906FA9": "NANJING PUTIAN TELECOMMUNICATIONS TECHNOLOGY CO.",
    "845B12": "HUAWEI TECHNOLOGIES CO.",
    "B047BF": "Samsung Electronics Co.",
    "7C0BC6": "Samsung Electronics Co.",
    "9870E8": "INNATECH SDN BHD",
    "44656A": "Mega Video Electronic(HK) Industry Co.",
    "78EB39": "Instituto Nacional de Tecnología Industrial",
    "CC5FBF": "Topwise 3G Communication Co.",
    "E02CB2": "Lenovo Mobile Communication (Wuhan) Company Limited",
    "D47BB0": "ASKEY COMPUTER CORP",
    "F0224E": "Esan electronic co.",
    "C8F9C8": "NewSharp Technology(SuZhou)Co",
    "A8A795": "Hon Hai Precision Ind. Co.",
    "0C756C": "Anaren Microwave",
    "44FDA3": "Everysight LTD.",
    "5440AD": "Samsung Electronics Co.",
    "145A83": "Logi-D inc",
    "54CD10": "Panasonic Mobile Communications Co.",
    "68EDA4": "Shenzhen Seavo Technology Co.",
    "2CC5D3": "Ruckus Wireless",
    "80C5E6": "Microsoft Corporation",
    "606DC7": "Hon Hai Precision Ind. Co.",
    "10DF8B": "Shenzhen CareDear Communication Technology Co.",
    "804E81": "Samsung Electronics Co.",
    "C412F5": "D-Link International",
    "FCE1FB": "Array Networks",
    "E89120": "Motorola Mobility LLC",
    "D4F9A1": "HUAWEI TECHNOLOGIES CO.",
    "48066A": "Tempered Networks",
    "BCF811": "Xiamen DNAKE Technology Co.",
    "FC8F90": "Samsung Electronics Co.",
    "A424DD": "Cambrionix Ltd",
    "900A39": "Wiio",
    "74042B": "Lenovo Mobile Communication (Wuhan) Company Limited",
    "D05C7A": "Sartura d.o.o.",
    "BC5C4C": "ELECOM CO.",
    "4480EB": "Motorola Mobility LLC",
    "F87AEF": "Rosonix Technology",
    "2028BC": "Visionscape Co",
    "5870C6": "Shanghai Xiaoyi Technology Co.",
    "64167F": "Polycom",
    "C09A71": "XIAMEN MEITU MOBILE TECHNOLOGY CO.LTD",
    "340B40": "MIOS ELETTRONICA SRL",
    "241C04": "SHENZHEN JEHE TECHNOLOGY DEVELOPMENT CO.",
    "887033": "Hangzhou Silan Microelectronic Inc",
    "DC56E6": "Shenzhen Bococom Technology Co.",
    "144146": "Honeywell (China) Co.",
    "CC9635": "LVS Co.",
    "402814": "RFI Engineering",
    "E861BE": "Melec Inc.",
    "C48E8F": "Hon Hai Precision Ind. Co.",
    "54369B": "1Verge Internet Technology (Beijing) Co.",
    "50502A": "Egardia",
    "94F19E": "HUIZHOU MAORONG INTELLIGENT TECHNOLOGY CO.",
    "B856BD": "ITT LLC",
    "C4924C": "KEISOKUKI CENTER CO.",
    "749CE3": "KodaCloud Canada",
    "4062B6": "Tele system communication",
    "60128B": "CANON INC.",
    "84C3E8": "Vaillant GmbH",
    "40A5EF": "Shenzhen Four Seas Global Link Network Technology Co.",
    "A89FBA": "Samsung Electronics Co.",
    "9CD35B": "Samsung Electronics Co.",
    "D45556": "Fiber Mountain Inc.",
    "4CA515": "Baikal Electronics JSC",
    "7C3CB6": "Shenzhen Homecare Technology Co.",
    "1C7D22": "FUJIFILM Business Innovation Corp.",
    "B88EC6": "Stateless Networks",
    "BCD165": "Cisco SPVTG",
    "28E476": "Pi-Coral",
    "4886E8": "Microsoft Corporation",
    "74A34A": "ZIMI CORPORATION",
    "20C06D": "SHENZHEN SPACETEK TECHNOLOGY CO.",
    "749637": "Todaair Electronic Co.",
    "2CAD13": "SHENZHEN ZHILU TECHNOLOGY CO.",
    "78ACBF": "Igneous Systems",
    "40D28A": "Nintendo Co.",
    "88E603": "Avotek corporation",
    "DC60A1": "Teledyne DALSA Professional Imaging",
    "6828F6": "Vubiq Networks",
    "10A659": "Mobile Create Co.",
    "58856E": "QSC AG",
    "EC59E7": "Microsoft Corporation",
    "C035C5": "Prosoft Systems LTD",
    "A0A3E2": "Actiontec Electronics",
    "74547D": "Cisco SPVTG",
    "D05BA8": "zte corporation",
    "E4BAD9": "360 Fly Inc.",
    "10C67E": "SHENZHEN JUCHIN TECHNOLOGY CO.",
    "00E6E8": "Netzin Technology Corporation",
    "50F43C": "Leeo Inc",
    "E887A3": "Loxley Public Company Limited",
    "8C9109": "Toyoshima Electric Technoeogy(Suzhou) Co.",
    "54098D": "deister electronic GmbH",
    "D8CB8A": "Micro-Star INTL CO.",
    "08EB29": "Jiangsu Huitong Group Co.",
    "08A5C8": "Sunnovo International Limited",
    "A86405": "nimbus 9",
    "D46132": "Pro Concept Manufacturer Co.",
    "54A050": "ASUSTek COMPUTER INC.",
    "BC6B4D": "Nokia",
    "C8D019": "Shanghai Tigercel Communication Technology Co.",
    "8486F3": "Greenvity Communications",
    "58108C": "Intelbras",
    "2C3796": "CYBO CO.",
    "587FB7": "SONAR INDUSTRIAL CO.",
    "F88479": "Yaojin Technology(Shenzhen)Co.",
    "902181": "Shanghai Huaqin Telecom Technology Co.",
    "849681": "Cathay Communication Co.",
    "2CA30E": "POWER DRAGON DEVELOPMENT LIMITED",
    "2C2997": "Microsoft Corporation",
    "908C09": "Total Phase",
    "4C2C83": "Zhejiang KaNong Network Technology Co.",
    "4C7403": "BQ",
    "8C5D60": "UCI Corporation Co.",
    "DC2F03": "Step forward Group Co.",
    "380E7B": "V.P.S. Thai Co.",
    "409B0D": "Shenzhen Yourf Kwan Industrial Co.",
    "70FC8C": "OneAccess SA",
    "80F8EB": "RayTight",
    "D437D7": "zte corporation",
    "2C1A31": "Electronics Company Limited",
    "2012D5": "Scientech Materials Corporation",
    "6C6EFE": "Core Logic Inc.",
    "3808FD": "Silca Spa",
    "2C010B": "NASCENT Technology",
    "04DEDB": "Rockport Networks Inc",
    "1C4840": "IMS Messsysteme GmbH",
    "54DF00": "Ulterius Technologies",
    "20ED74": "Ability enterprise co.",
    "14488B": "Shenzhen Doov Technology Co.",
    "1C5216": "DONGGUAN HELE ELECTRONICS CO.",
    "94CE31": "CTS Limited",
    "784561": "CyberTAN Technology Inc.",
    "6099D1": "Vuzix / Lenovo",
    "B04515": "mira fitness",
    "6050C1": "Kinetek Sports",
    "90B686": "Murata Manufacturing Co.",
    "ECD9D1": "Shenzhen TG-NET Botone Technology Co.",
    "6C0273": "Shenzhen Jin Yun Video Equipment Co.",
    "2829CC": "Corsa Technology Incorporated",
    "E85D6B": "Luminate Wireless",
    "94AEE3": "Belden Hirschmann Industries (Suzhou) Ltd.",
    "A056B2": "Harman/Becker Automotive Systems GmbH",
    "44666E": "IP-LINE",
    "5CB6CC": "NovaComm Technologies Inc.",
    "705B2E": "M2Communication Inc.",
    "5C1515": "ADVAN",
    "244F1D": "iRule LLC",
    "B40AC6": "DEXON Systems Ltd.",
    "D059E4": "Samsung Electronics Co.",
    "14A364": "Samsung Electronics Co.",
    "50FEF2": "Sify Technologies Ltd",
    "481A84": "Pointer Telocation Ltd",
    "DC663A": "Apacer Technology Inc.",
    "08DF1F": "Bose Corporation",
    "184A6F": "Alcatel-Lucent Shanghai Bell Co.",
    "34C5D0": "Hagleitner Hygiene International GmbH",
    "10C37B": "ASUSTek COMPUTER INC.",
    "581F67": "Open-m technology limited",
    "A012DB": "TABUCHI ELECTRIC CO.",
    "B40B44": "Smartisan Technology Co.",
    "3431C4": "AVM GmbH",
    "4826E8": "Tek-Air Systems",
    "D05AF1": "Shenzhen Pulier Tech CO.",
    "FCE186": "A3M Co.",
    "54EF92": "Shenzhen Elink Technology Co.",
    "70305D": "Ubiquoss Inc",
    "54C80F": "TP-LINK TECHNOLOGIES CO.",
    "E4D332": "TP-LINK TECHNOLOGIES CO.",
    "ECE512": "tado GmbH",
    "30918F": "Technicolor Delivery Technologies Belgium NV",
    "5CF4AB": "Zyxel Communications Corporation",
    "08B2A3": "Cynny Italia S.r.L.",
    "A0DA92": "Nanjing Glarun Atten Technology Co. Ltd.",
    "40B3CD": "Chiyoda Electronics Co.",
    "24336C": "Private",
    "D4CFF9": "Shenzhen SEI Robotics Co.",
    "488244": "Life Fitness / Div. of Brunswick",
    "C83168": "eZEX corporation",
    "0C2026": "noax Technologies AG",
    "28656B": "Keystone Microtech Corporation",
    "CC9F35": "Transbit Sp. z o.o.",
    "F03FF8": "R L Drake",
    "B0C554": "D-Link International",
    "202564": "PEGATRON CORPORATION",
    "C8D590": "FLIGHT DATA SYSTEMS",
    "7CFF62": "Huizhou Super Electron Technology Co.",
    "283B96": "Cool Control LTD",
    "648D9E": "IVT Electronic Co.",
    "C09D26": "Topicon HK Lmd.",
    "442938": "NietZsche enterprise Co.Ltd.",
    "ECF72B": "HD DIGITAL TECH CO.",
    "4CF45B": "Blue Clover Devices",
    "B06971": "DEI Sales",
    "F8F005": "Newport Media Inc.",
    "1CFCBB": "Realfiction ApS",
    "5C254C": "Avire Global Pte Ltd",
    "D42F23": "Akenori PTE Ltd",
    "9C3EAA": "EnvyLogic Co.",
    "14C089": "DUNE HD LTD",
    "F4B6E5": "TerraSem Co.",
    "A881F1": "BMEYE B.V.",
    "D069D0": "Verto Medical Solutions",
    "C4E984": "TP-LINK TECHNOLOGIES CO.",
    "48EE86": "UTStarcom (China) Co.",
    "CC95D7": "Vizio",
    "FC09F6": "GUANGDONG TONZE ELECTRIC CO.",
    "BCF61C": "Geomodeling Wuxi Technology Co. Ltd.",
    "086DF2": "Shenzhen MIMOWAVE Technology Co.",
    "98C0EB": "Global Regency Ltd",
    "D09C30": "Foster Electric Company",
    "949F3F": "Optek Digital Technology company limited",
    "78FEE2": "Shanghai Diveo Technology Co.",
    "444891": "HDMI Licensing",
    "FC923B": "Nokia Corporation",
    "E03F49": "ASUSTek COMPUTER INC.",
    "88A73C": "Ragentek Technology Group",
    "88D962": "Canopus Systems US LLC",
    "687848": "WESTUNITIS CO.",
    "48D0CF": "Universal Electronics",
    "DCC793": "Nokia Corporation",
    "1CEEE8": "Ilshin Elecom",
    "602103": "I4VINE",
    "FC07A0": "LRE Medical GmbH",
    "FC1349": "Global Apps Corp.",
    "848433": "Paradox Engineering SA",
    "44C306": "SIFROM Inc.",
    "60FFDD": "C.E. ELECTRONICS",
    "24050F": "MTN Electronic Co. Ltd",
    "AC2DA3": "TXTR GmbH",
    "889CA6": "BTB Korea INC",
    "90837A": "General Electric Water & Process Technologies",
    "A43A69": "Vers Inc",
    "B0D7C5": "Logipix Ltd",
    "9031CD": "Onyx Healthcare Inc.",
    "E48184": "Nokia",
    "2C5A05": "Nokia Corporation",
    "D481CA": "iDevices",
    "D858D7": "CZ.NIC",
    "4CD9C4": "Magneti Marelli Automotive Electronics (Guangzhou) Co. Ltd",
    "0C54A5": "PEGATRON CORPORATION",
    "8C4DB9": "Unmonday Ltd",
    "80BAE6": "Neets",
    "888914": "All Components Incorporated",
    "F0321A": "Mita-Teknik A/S",
    "9C44A6": "SwiftTest",
    "B024F3": "Progeny Systems",
    "F8A2B4": "RHEWA-WAAGENFABRIK August Freudewald GmbH &amp;Co. KG",
    "78CA5E": "ELNO",
    "A03B1B": "Inspire Tech",
    "7CCD3C": "Guangzhou Juzing Technology Co.",
    "10B26B": "base Co.",
    "4CF02E": "Vifa Denmark A/S",
    "B4827B": "AKG Acoustics GmbH",
    "DC5E36": "Paterson Technology",
    "50E0C7": "TurControlSystme AG",
    "DCAD9E": "GreenPriz",
    "B8DF6B": "SpotCam Co.",
    "9C8888": "Simac Techniek NV",
    "041A04": "WaveIP",
    "34A5E1": "Sensorist ApS",
    "18C8E7": "Shenzhen Hualistone Technology Co.",
    "7C6AB3": "IBC TECHNOLOGIES INC.",
    "84569C": "Coho Data",
    "3CCA87": "Iders Incorporated",
    "181BEB": "Actiontec Electronics",
    "9843DA": "INTERTECH",
    "78D99F": "NuCom HK Ltd.",
    "142BD2": "Armtel Ltd.",
    "9CA10A": "SCLE SFE",
    "88789C": "Game Technologies SA",
    "68764F": "Sony Corporation",
    "38DBBB": "Sunbow Telecom Co.",
    "448A5B": "Micro-Star INT'L CO.",
    "0CCB8D": "ASCO Numatics GmbH",
    "907990": "Benchmark Electronics Romania SRL",
    "7CBD06": "AE REFUsol",
    "94BA56": "Shenzhen Coship Electronics Co.",
    "740EDB": "Optowiz Co.",
    "908C44": "H.K ZONGMU TECHNOLOGY CO.",
    "6C8366": "Nanjing SAC Power Grid Automation Co.",
    "6C4B7F": "Vossloh-Schwabe Deutschland GmbH",
    "688AB5": "EDP Servicos",
    "2493CA": "Voxtronic Austria",
    "DCCEBC": "Shenzhen JSR Technology Co.",
    "F83D4E": "Softlink Automation System Co.",
    "8079AE": "ShanDong Tecsunrise  Co.",
    "6C90B1": "SanLogic Inc",
    "E0FAEC": "Platan sp. z o.o. sp. k.",
    "446755": "Orbit Irrigation",
    "7CE56B": "ESEN Optoelectronics Technology Co.",
    "D44C9C": "Shenzhen YOOBAO Technology Co.Ltd",
    "58468F": "Koncar Electronics and Informatics",
    "985D46": "PeopleNet Communication",
    "F89FB8": "YAZAKI Energy System Corporation",
    "540536": "Vivago Oy",
    "54BEF7": "PEGATRON CORPORATION",
    "A4895B": "ARK INFOSOLUTIONS PVT LTD",
    "D09D0A": "LINKCOM",
    "EC219F": "VidaBox LLC",
    "20CEC4": "Peraso Technologies",
    "CC4703": "Intercon Systems Co.",
    "A8CCC5": "Saab AB (publ)",
    "988E4A": "NOXUS(BEIJING) TECHNOLOGY CO.",
    "F854AF": "ECI Telecom Ltd.",
    "F0F5AE": "Adaptrum Inc.",
    "FC3FAB": "Henan Lanxin Technology Co.",
    "EC2AF0": "Ypsomed AG",
    "50B888": "wi2be Tecnologia S/A",
    "28A241": "exlar corp",
    "F42012": "Cuciniale GmbH",
    "98B039": "Nokia",
    "B830A8": "Road-Track Telematics Development",
    "509871": "Inventum Technologies Private Limited",
    "30786B": "TIANJIN Golden Pentagon Electronics Co.",
    "20DF3F": "Nanjing SAC Power Grid Automation Co.",
    "4CD637": "Qsono Electronics Co.",
    "9436E0": "Sichuan Bihong Broadcast &amp; Television New Technologies Co.",
    "442AFF": "E3 Technology",
    "7C8306": "Glen Dimplex Nordic as",
    "140D4F": "Flextronics International",
    "088E4F": "SF Software Solutions",
    "ACCA8E": "ODA Technologies",
    "DC1792": "Captivate Network",
    "5422F8": "zte corporation",
    "486E73": "Pica8",
    "6405BE": "NEW LIGHT LED",
    "28285D": "Zyxel Communications Corporation",
    "646EEA": "Iskratel d.o.o.",
    "D0737F": "Mini-Circuits",
    "CC7B35": "zte corporation",
    "04D437": "ZNV",
    "CCF407": "EUKREA ELECTROMATIQUE SARL",
    "048C03": "ThinPAD Technology (Shenzhen)CO.",
    "88462A": "Telechips Inc.",
    "C80258": "ITW GSE ApS",
    "E8BB3D": "Sino Prime-Tech Limited",
    "34A68C": "Shine Profit Development Limited",
    "949FB4": "ChengDu JiaFaAnTai Technology Co.",
    "406826": "Thales UK Limited",
    "F82BC8": "Jiangsu Switter Co.",
    "60C397": "2Wire Inc",
    "FC6018": "Zhejiang Kangtai Electric Co.",
    "0CF019": "Malgn Technology Co.",
    "A4FCCE": "Security Expert Ltd.",
    "E07F88": "EVIDENCE Network SIA",
    "1C7CC7": "Coriant GmbH",
    "341B22": "Grandbeing Technology Co.",
    "58E02C": "Micro Technic A/S",
    "78B3CE": "Elo touch solutions",
    "341A4C": "SHENZHEN WEIBU ELECTRONICS CO.",
    "88142B": "Protonic Holland",
    "F8516D": "Denwa Technology Corp.",
    "444A65": "Silverflare Ltd.",
    "744BE9": "EXPLORER HYPERTECH CO.",
    "0488E2": "Beats Electronics LLC",
    "40560C": "In Home Displays Ltd",
    "A47ACF": "VIBICOM COMMUNICATIONS INC.",
    "BC261D": "HONG KONG TECON TECHNOLOGY",
    "204C6D": "Hugo Brennenstuhl Gmbh & Co. KG.",
    "E8CE06": "SkyHawke Technologies",
    "C8F386": "Shenzhen Xiaoniao Technology Co.",
    "2C72C3": "Soundmatters",
    "2C69BA": "RF Controls",
    "D4BF7F": "UPVEL",
    "9C9726": "Technicolor Delivery Technologies Belgium NV",
    "7C0507": "PEGATRON CORPORATION",
    "880905": "MTMCommunications",
    "C8DDC9": "Lenovo Mobile Communication Technology Ltd.",
    "6C8686": "Technonia",
    "D4AC4E": "BODi rS",
    "842F75": "Innokas Group",
    "CC3C3F": "SA.S.S. Datentechnik AG",
    "40C4D6": "ChongQing Camyu Technology Development Co.",
    "A8294C": "Precision Optical Transceivers",
    "30D46A": "Autosales Incorporated",
    "70C6AC": "Bosch Automotive Aftermarket",
    "A0861D": "Chengdu Fuhuaxin Technology co.",
    "508D6F": "CHAHOO Limited",
    "308999": "Guangdong East Power Co.",
    "84F493": "OMS spol. s.r.o.",
    "BCD177": "TP-LINK TECHNOLOGIES CO.",
    "7CD762": "Freestyle Technology Pty Ltd",
    "901D27": "zte corporation",
    "F05DC8": "Duracell Powermat",
    "CC5D57": "Information  System Research Institute",
    "E8DE27": "TP-LINK TECHNOLOGIES CO.",
    "282CB2": "TP-LINK TECHNOLOGIES CO.",
    "64E599": "EFM Networks",
    "F4B381": "WindowMaster A/S",
    "74F102": "Beijing HCHCOM Technology Co.",
    "F0F260": "Mobitec AB",
    "044CEF": "Fujian Sanao Technology Co.",
    "4C804F": "Armstrong Monitoring Corp",
    "64C667": "Barnes&Noble",
    "103DEA": "HFC Technology (Beijing) Ltd. Co.",
    "C89346": "MXCHIP Company Limited",
    "94ACCA": "trivum technologies GmbH",
    "908260": "IEEE 1904.1 Working Group",
    "D4EE07": "HIWIFI Co.",
    "FCAD0F": "QTS NETWORKS",
    "984C04": "Zhangzhou Keneng Electrical Equipment Co Ltd",
    "ACDBDA": "Shenzhen Geniatech Inc",
    "9C3178": "Foshan Huadian Intelligent Communications Teachnologies Co.",
    "983F9F": "China SSJ (Suzhou) Network Technology Inc.",
    "B838CA": "Kyokko Tsushin System CO.",
    "B01408": "LIGHTSPEED INTERNATIONAL CO.",
    "081DFB": "Shanghai Mexon Communication Technology Co.",
    "C44EAC": "Shenzhen Shiningworth Technology Co.",
    "B0C95B": "Beijing Symtech CO.",
    "38B5BD": "E.G.O. Elektro-Ger",
    "5C43D2": "HAZEMEYER",
    "D809C3": "Cercacor Labs",
    "D42751": "Infopia Co.",
    "68A40E": "BSH Hausgeräte GmbH",
    "F4C6D7": "blackned GmbH",
    "A80180": "IMAGO Technologies GmbH",
    "0C5521": "Axiros GmbH",
    "4CCA53": "Skyera",
    "90FF79": "Metro Ethernet Forum",
    "D4CA6E": "u-blox AG",
    "F87B62": "FASTWEL INTERNATIONAL CO.",
    "74FE48": "ADVANTECH CO.",
    "80B95C": "ELFTECH Co.",
    "A01917": "Bertel S.p.a.",
    "E4E409": "LEIFHEIT AG",
    "68B8D9": "Act KDE",
    "90CC24": "Synaptics",
    "7898FD": "Q9 Networks Inc.",
    "D063B4": "SolidRun Ltd.",
    "105CBF": "DuroByte Inc",
    "2CE871": "Alert Metalguard ApS",
    "40270B": "Mobileeco Co.",
    "E4EEFD": "MR&D Manufacturing",
    "20918A": "PROFALUX",
    "8C3330": "EmFirst Co.",
    "087BAA": "SVYAZKOMPLEKTSERVICE",
    "EC4993": "Qihan Technology Co.",
    "B0ACFA": "FUJITSU LIMITED",
    "8CE081": "zte corporation",
    "C88A83": "Dongguan HuaHong Electronics Co.",
    "8CC5E1": "ShenZhen Konka Telecommunication Technology Co.",
    "64A341": "Wonderlan (Beijing) Technology Co.",
    "004D32": "Andon Health Co.",
    "24F2DD": "Radiant Zemax LLC",
    "2C441B": "Spectrum Medical Limited",
    "B877C3": "METER Group",
    "FCA9B0": "MIARTECH (SHANGHAI)",
    "A44E2D": "Adaptive Wireless Solutions",
    "A46E79": "DFT System Co.Ltd",
    "9C541C": "Shenzhen My-power Technology Co.",
    "C44567": "SAMBON PRECISON and ELECTRONICS",
    "E45614": "Suttle Apparatus",
    "3C83B5": "Advance Vision Electronics Co. Ltd.",
    "28A192": "GERP Solution",
    "681CA2": "Rosewill Inc.",
    "604616": "XIAMEN VANN INTELLIGENT CO.",
    "6C40C6": "Nimbus Data",
    "1048B1": "Beijing Duokan Technology Limited",
    "0CCDFB": "EDIC Systems Inc.",
    "9C8D1A": "INTEG process group inc",
    "480362": "DESAY ELECTRONICS(HUIZHOU)CO.",
    "18673F": "Hanover Displays Limited",
    "7C0A50": "J-MEX Inc.",
    "106FEF": "Ad-Sol Nissin Corp",
    "5011EB": "SilverNet Ltd",
    "54DF63": "Intrakey technologies GmbH",
    "DC9FA4": "Nokia Corporation",
    "44C39B": "OOO RUBEZH NPO",
    "40F2E9": "IBM",
    "744D79": "Arrive Systems Inc.",
    "9C0473": "Tecmobile (International) Ltd.",
    "D493A0": "Fidelix Oy",
    "08EBED": "World Elite Technology Co.",
    "48F8B3": "Cisco-Linksys",
    "B4DFFA": "Litemax Electronics Inc.",
    "5C4A26": "Enguity Technology Corp",
    "D8D27C": "JEMA ENERGY",
    "B01203": "Dynamics Hong Kong Limited",
    "9886B1": "Flyaudio corporation (China)",
    "7093F8": "Space Monkey",
    "28B3AB": "Genmark Automation",
    "C4E7BE": "SCSpro Co.",
    "58874C": "LITE-ON CLEAN ENERGY TECHNOLOGY CORP.",
    "2891D0": "Stage Tec Entwicklungsgesellschaft für professionelle Audiotechnik mbH",
    "C0BD42": "ZPA Smart Energy a.s.",
    "20DC93": "Cheetah Hi-Tech",
    "2C625A": "Finest Security Systems Co.",
    "2074CF": "Shenzhen Voxtech Co.",
    "FC52CE": "Control iD",
    "D8C691": "Hichan Technology Corp.",
    "E43FA2": "Wuxi DSP Technologies Inc.",
    "F4B72A": "TIME INTERCONNECT LTD",
    "E0F5CA": "CHENG UEI PRECISION INDUSTRY CO.",
    "A8EF26": "Tritonwave",
    "5C2479": "Baltech AG",
    "D82DE1": "Tricascade Inc.",
    "14358B": "Mediabridge Products",
    "00F403": "Orbis Systems Oy",
    "547398": "Toyo Electronics Corporation",
    "60F2EF": "VisionVera International Co.",
    "C03F2A": "Biscotti",
    "381C4A": "SIMCom Wireless Solutions Co.",
    "543968": "Edgewater Networks Inc",
    "440CFD": "NetMan Co.",
    "8CD3A2": "VisSim AS",
    "EC9327": "MEMMERT GmbH + Co. KG",
    "C4393A": "SMC Networks Inc",
    "749975": "IBM Corporation",
    "881036": "Panodic(ShenZhen) Electronics Limted",
    "68B6FC": "Hitron Technologies. Inc",
    "60CBFB": "AirScape Inc.",
    "7C160D": "Saia-Burgess Controls AG",
    "A497BB": "Hitachi Industrial Equipment Systems Co.",
    "4C5427": "Linepro Sp. z o.o.",
    "A4934C": "Cisco Systems",
    "D0D212": "K2NET Co.",
    "80D18B": "Hangzhou I'converge Technology Co.",
    "4088E0": "Beijing Ereneben Information Technology Limited Shenzhen Branch",
    "E85484": "NEO Information Systems Co.",
    "74AE76": "iNovo Broadband",
    "1C8464": "FORMOSA WIRELESS COMMUNICATION CORP.",
    "64517E": "LONG BEN (DONGGUAN) ELECTRONIC TECHNOLOGY CO.",
    "D43D7E": "Micro-Star Int'l Co",
    "ACD9D6": "tci GmbH",
    "4423AA": "Farmage Co.",
    "7CFE28": "Salutron Inc.",
    "E8102E": "Really Simple Software",
    "0C565C": "HyBroad Vision (Hong Kong) Technology Co Ltd",
    "8C6AE4": "Viogem Limited",
    "A0EF84": "Seine Image Int'l Co.",
    "E0A30F": "Pevco",
    "88DC96": "EnGenius Technologies",
    "20443A": "Schneider Electric Asia Pacific Ltd",
    "ECA29B": "Kemppi Oy",
    "C4BA99": "I+ME Actia Informatik und Mikro-Elektronik GmbH",
    "04CE14": "Wilocity LTD.",
    "E8D483": "ULTIMATE Europe Transportation Equipment GmbH",
    "48282F": "zte corporation",
    "EC1A59": "Belkin International Inc.",
    "B0435D": "NuLEDs",
    "0808EA": "AMSC",
    "B45570": "Borea",
    "100D2F": "Online Security Pty. Ltd.",
    "3C98BF": "Quest Controls",
    "D0AEEC": "Alpha Networks Inc.",
    "F0FDA0": "Acurix Networks Pty Ltd",
    "346E8A": "Ecosense",
    "64F242": "Gerdes Aktiengesellschaft",
    "60F281": "TRANWO TECHNOLOGY CO.",
    "0CC0C0": "MAGNETI MARELLI SISTEMAS ELECTRONICOS MEXICO",
    "08379C": "Topaz Co. LTD.",
    "D80DE3": "FXI TECHNOLOGIES AS",
    "A0C3DE": "Triton Electronic Systems Ltd.",
    "142DF5": "Amphitech",
    "942197": "Stalmart Technology Limited",
    "B0D2F5": "Vello Systems",
    "709A0B": "Italian Institute of Technology",
    "E81324": "GuangZhou Bonsoninfo System CO.",
    "D0699E": "LUMINEX Lighting Control Equipment",
    "5057A8": "Cisco Systems",
    "00DEFB": "Cisco Systems",
    "3CA315": "Bless Information & Communications Co.",
    "F83094": "Alcatel-Lucent Telecom Limited",
    "10A932": "Beijing Cyber Cloud Technology Co.",
    "34FC6F": "ALCEA",
    "C0B357": "Yoshiki Electronics Industry Ltd.",
    "A81758": "Elektronik System i Umeå AB",
    "F473CA": "Conversion Sound Inc.",
    "F8F7FF": "SYN-TECH SYSTEMS INC",
    "E4C806": "Ceiec Electric Technology Inc.",
    "442B03": "Cisco Systems",
    "882012": "LMI Technologies",
    "E477D4": "Minrray Industry Co.",
    "38E08E": "Mitsubishi Electric Corporation",
    "08B4CF": "Abicom International",
    "7C94B2": "Philips Healthcare PCCI",
    "E0F9BE": "Cloudena Corp.",
    "B88F14": "Analytica GmbH",
    "C495A2": "SHENZHEN WEIJIU INDUSTRY AND TRADE DEVELOPMENT CO.",
    "8C6878": "Nortek-AS",
    "202598": "Teleview",
    "38F8B7": "V2COM PARTICIPACOES S.A.",
    "A04CC1": "Helixtech Corp.",
    "00376D": "Murata Manufacturing Co.",
    "50008C": "Hong Kong Telecommunications (HKT) Limited",
    "A49005": "CHINA GREATWALL COMPUTER SHENZHEN CO.",
    "C40ACB": "Cisco Systems",
    "D4A02A": "Cisco Systems",
    "F8D462": "Pumatronix Equipamentos Eletronicos Ltda.",
    "A0DC04": "Becker-Antriebe GmbH",
    "40605A": "Hawkeye Tech Co. Ltd",
    "F48771": "Infoblox",
    "E86D6E": "voestalpine Signaling UK Ltd.",
    "681605": "Systems And Electronic Development FZCO",
    "60E956": "Ayla Networks",
    "EC1120": "FloDesign Wind Turbine Corporation",
    "F897CF": "DAESHIN-INFORMATION TECHNOLOGY CO.",
    "34A7BA": "Fischer International Systems Corporation",
    "3C4E47": "Etronic A/S",
    "0463E0": "Nome Oy",
    "B49EE6": "SHENZHEN TECHNOLOGY CO LTD",
    "BC4B79": "SensingTek",
    "5453ED": "Sony Corporation",
    "BCFE8C": "Altronic",
    "649EF3": "Cisco Systems",
    "24BBC1": "Absolute Analysis",
    "943AF0": "Nokia Corporation",
    "3CE624": "LG Display",
    "D8F0F2": "Zeebo Inc",
    "9CCAD9": "Nokia Corporation",
    "24B88C": "Crenus Co.",
    "88C36E": "Beijing Ereneben lnformation Technology Limited",
    "88E712": "Whirlpool Corporation",
    "D412BB": "Quadrant Components Inc. Ltd",
    "645422": "Equinox Payments",
    "080D84": "GECO",
    "4C9E80": "KYOKKO ELECTRIC Co.",
    "5CEB4E": "R. STAHL HMI Systems GmbH",
    "34AA99": "Nokia",
    "D8052E": "Skyviia Corporation",
    "80946C": "TOKYO RADAR CORPORATION",
    "306E5C": "Validus Technologies",
    "C894D2": "Jiangsu Datang  Electronic Products Co.",
    "C8A620": "Nebula",
    "FC946C": "UBIVELOX",
    "407B1B": "Mettle Networks Inc.",
    "40D559": "MICRO S.E.R.I.",
    "306CBE": "Skymotion Technology (HK) Limited",
    "183825": "Wuhan Lingjiu High-tech Co.",
    "7C4B78": "Red Sun Synthesis Pte Ltd",
    "64A0E7": "Cisco Systems",
    "644D70": "dSPACE GmbH",
    "D0CF5E": "Energy Micro AS",
    "DCC101": "SOLiD Technologies",
    "1803FA": "IBT Interfaces",
    "046D42": "Bryston Ltd.",
    "D8E743": "Wush",
    "94E0D0": "HealthStream Taiwan Inc.",
    "DCF858": "Lorent Networks",
    "940B2D": "NetView Technologies(Shenzhen) Co.",
    "803F5D": "Winstars Technology Ltd",
    "40BF17": "Digistar Telecom. SA",
    "780738": "Z.U.K. Elzab S.A.",
    "2037BC": "Kuipers Electronic Engineering BV",
    "806007": "RIM",
    "04D783": "Y&H E&C Co.",
    "886B76": "CHINA HOPEFUL GROUP HOPEFUL ELECTRIC CO.",
    "78F7D0": "Silverbrook Research",
    "207600": "Actiontec Electronics",
    "F04B6A": "Scientific Production Association Siberian Arsenal",
    "64AE0C": "Cisco Systems",
    "E8DA96": "Zhuhai Tianrui Electrical Power Tech. Co.",
    "F013C3": "SHENZHEN FENDA TECHNOLOGY CO.",
    "04A82A": "Nokia Corporation",
    "489BE2": "SCI Innovations Ltd",
    "80FFA8": "UNIDIS",
    "B0E50E": "NRG SYSTEMS INC",
    "48C1AC": "PLANTRONICS",
    "98588A": "SYSGRATION Ltd.",
    "E878A1": "BEOVIEW INTERCOM DOO",
    "CCEF48": "Cisco Systems",
    "2437EF": "EMC Electronic Media Communication SA",
    "94319B": "Alphatronics BV",
    "E435FB": "Sabre Technology (Hull) Ltd",
    "C83B45": "JRI",
    "C058A7": "Pico Systems Co.",
    "EC3F05": "Institute 706",
    "EC6264": "Global411 Internet Services",
    "00F051": "KWB Gmbh",
    "00E175": "AK-Systems Ltd",
    "CC501C": "KVH Industries",
    "28B0CC": "Xenya d.o.o.",
    "205B5E": "Shenzhen Wonhe Technology Co.",
    "DC2E6A": "HCT. Co.",
    "148A70": "ADS GmbH",
    "549478": "Silvershore Technology Partners",
    "1071F9": "Cloud Telecomputers",
    "B8621F": "Cisco Systems",
    "FCE892": "Hangzhou Lancable Technology Co.",
    "D453AF": "VIGO System S.A.",
    "B4D8DE": "iota Computing",
    "C8903E": "Pakton Technologies",
    "54CDA7": "Fujian Shenzhou Electronic Co.",
    "18AD4D": "Polostar Technology Corporation",
    "94C6EB": "NOVA electronics",
    "E44E18": "Gardasoft VisionLimited",
    "2046A1": "VECOW Co.",
    "FC01CD": "FUNDACION TEKNIKER",
    "A06E50": "Nanotek Elektronik Sistemler Ltd. Sti.",
    "84248D": "Zebra Technologies Inc",
    "9C8BF1": "The Warehouse Limited",
    "00B338": "Kontron Asia Pacific Design Sdn. Bhd",
    "B8288B": "Parker Hannifin Manufacturing (UK) Ltd",
    "90D11B": "Palomar Medical Technologies",
    "ECBD09": "FUSION Electronics Ltd",
    "944696": "BaudTec Corporation",
    "34A55D": "TECHNOSOFT INTERNATIONAL SRL",
    "4C774F": "Embedded Wireless Labs",
    "D0C282": "Cisco Systems",
    "147DB3": "JOA TELECOM.CO.",
    "3C2763": "SLE quality engineering GmbH & Co. KG",
    "B0F1BC": "Dhemax Ingenieros Ltda",
    "54847B": "Digital Devices GmbH",
    "C83232": "Hunting Innova",
    "F0022B": "Chrontel",
    "843F4E": "Tri-Tech Manufacturing",
    "34BCA6": "Beijing Ding Qing Technology",
    "5835D9": "Cisco Systems",
    "64D912": "Solidica",
    "C47B2F": "Beijing JoinHope Image Technology Ltd.",
    "704AAE": "Xstream Flow (Pty) Ltd",
    "40B3FC": "Logital Co. Limited",
    "508ACB": "SHENZHEN MAXMADE TECHNOLOGY CO.",
    "802E14": "azeti Networks AG",
    "D4C1FC": "Nokia Corporation",
    "3CD16E": "Telepower Communication Co.",
    "FC2E2D": "Lorom Industrial Co.LTD.",
    "40040C": "A&T",
    "DC3C84": "Ticom Geomatics",
    "D0131E": "Sunrex Technology Corp",
    "7C4A82": "Portsmith LLC",
    "2C0033": "EControls",
    "AC199F": "SUNGROW POWER SUPPLY CO.",
    "00FC70": "Intrepid Control Systems",
    "703AD8": "Shenzhen Afoundry Electronic Co.",
    "88F077": "Cisco Systems",
    "B09928": "FUJITSU LIMITED",
    "04E1C8": "IMS Soluções em Energia Ltda.",
    "AC5E8C": "Utillink",
    "587521": "CJSC RTSoft",
    "948FEE": "Verizon Telematics",
    "50D6D7": "Takahata Precision",
    "94E848": "FYLDE MICRO LTD",
    "C40F09": "Hermes electronic GmbH",
    "48F47D": "TechVision Holding  Internation Limited",
    "F081AF": "IRZ AUTOMATION TECHNOLOGIES LTD",
    "701404": "Limited Liability Company",
    "1C35F1": "NEW Lift Neue Elektronische Wege Steuerungsbau GmbH",
    "F0AE51": "Xi3 Corp",
    "B80B9D": "ROPEX Industrie-Elektronik GmbH",
    "5070E5": "He Shan World Fair Electronics Technology Limited",
    "802275": "Beijing Beny Wave Technology Co Ltd",
    "983000": "Beijing KEMACOM Technologies Co.",
    "90CF15": "Nokia Corporation",
    "948B03": "EAGET Innovation and Technology Co.",
    "14A9E3": "MST CORPORATION",
    "5C0CBB": "CELIZION Inc.",
    "18E288": "STT Condigi",
    "B435F7": "Zhejiang Pearmain Electronics Co.ltd.",
    "9866EA": "Industrial Control Communications",
    "24C86E": "Chaney Instrument Co.",
    "C4242E": "Galvanic Applied Sciences Inc",
    "F8EA0A": "Dipl.-Math. Michael Rauch",
    "803457": "OT Systems Limited",
    "CCF3A5": "Chi Mei Communication Systems",
    "306118": "Paradom Inc.",
    "4C7367": "Genius Bytes Software Solutions GmbH",
    "3831AC": "WEG",
    "584C19": "Chongqing Guohong Technology Development Company Limited",
    "6469BC": "Hytera Communications Co .",
    "B4F323": "PETATEL INC.",
    "14C21D": "Sabtech Industries",
    "40F4EC": "Cisco Systems",
    "14B73D": "ARCHEAN Technologies",
    "948D50": "Beamex Oy Ab",
    "A433D1": "Fibrlink Communications Co.",
    "FC10BD": "Control Sistematizado S.A.",
    "F0C27C": "Mianyang Netop Telecom Equipment Co.",
    "283410": "Enigma Diagnostics Limited",
    "0CE82F": "Bonfiglioli Vectron GmbH",
    "84D9C8": "Unipattern Co.",
    "90EA60": "SPI Lasers Ltd",
    "14F0C5": "Xtremio Ltd.",
    "E8C229": "H-Displays (MSC) Bhd",
    "3CA72B": "MRV Communications (Networks) LTD",
    "285132": "Shenzhen Prayfly Technology Co.",
    "E42FF6": "Unicore communication Inc.",
    "A88792": "Broadband Antenna Tracking Systems",
    "04E662": "Acroname Inc.",
    "F87B8C": "Amped Wireless",
    "241A8C": "Squarehead Technology AS",
    "D44F80": "Kemper Digital GmbH",
    "A41BC0": "Fastec Imaging Corporation",
    "205B2A": "Private",
    "F40321": "BeNeXt B.V.",
    "A071A9": "Nokia Corporation",
    "A4E32E": "Silicon & Software Systems Ltd.",
    "5CBD9E": "HONGKONG MIRACLE EAGLE TECHNOLOGY(GROUP) LIMITED",
    "08E672": "JEBSEE ELECTRONICS CO.",
    "B8E589": "Payter BV",
    "64DC01": "Static Systems Group PLC",
    "607688": "Velodyne",
    "C8C126": "ZPM Industria e Comercio Ltda",
    "64DE1C": "Kingnetic Pte Ltd",
    "4468AB": "JUIN COMPANY",
    "F81037": "Atopia Systems",
    "78A683": "Precidata",
    "FC1FC0": "EURECAM",
    "A862A2": "JIWUMEDIA CO.",
    "984E97": "Starlight Marketing (H. K.) Ltd.",
    "78CD8E": "SMC Networks Inc",
    "2C8065": "HARTING Inc. of North America",
    "3CC0C6": "d&b audiotechnik GmbH",
    "F02572": "Cisco Systems",
    "04FF51": "NOVAMEDIA INNOVISION SP. Z O.O.",
    "4CB4EA": "HRD (S) PTE.",
    "D44C24": "Vuppalamritha Magnetic Components LTD",
    "8091C0": "AgileMesh",
    "F8C678": "Carefusion",
    "6CAB4D": "Digital Payment Technologies",
    "2CB0DF": "Soliton Technologies Pvt Ltd",
    "ECE555": "Hirschmann Automation",
    "58F98E": "SECUDOS GmbH",
    "084EBF": "Sumitomo Electric Industries",
    "AC02CF": "RW Tecnologia Industria e Comercio Ltda",
    "B4C44E": "VXL eTech Pvt Ltd",
    "707EDE": "NASTEC LTD.",
    "E05FB9": "Cisco Systems",
    "BC6784": "Environics Oy",
    "68DCE8": "PacketStorm Communications",
    "488E42": "DIGALOG GmbH",
    "B4749F": "ASKEY COMPUTER CORP",
    "7C4AA8": "MindTree Wireless PVT Ltd",
    "E0143E": "Modoosis Inc.",
    "C07E40": "SHENZHEN XDK COMMUNICATION EQUIPMENT CO.",
    "E44F29": "MA Lighting Technology GmbH",
    "D41296": "Anobit Technologies Ltd.",
    "0876FF": "Thomson Telecom Belgium",
    "349A0D": "ZBD Displays Ltd",
    "90D852": "Comtec Co.",
    "380197": "TSST Global",
    "20AA25": "IP-NET LLC",
    "1C7C11": "EID",
    "48174C": "MicroPower technologies",
    "588D09": "Cisco Systems",
    "C0C1C0": "Cisco-Linksys",
    "90507B": "Advanced PANMOBIL Systems GmbH & Co. KG",
    "6015C7": "IdaTech",
    "1C83B0": "Linked IP GmbH",
    "A4D1D1": "ECOtality North America",
    "C49313": "100fio networks technology llc",
    "68597F": "Alcatel Lucent",
    "F065DD": "Primax Electronics Ltd.",
    "9433DD": "Taco Inc",
    "E0CF2D": "Gemintek Corporation",
    "C4EEF5": "II-VI Incorporated",
    "D491AF": "Electroacustica General Iberica",
    "C4B512": "General Electric Digital Energy",
    "E02538": "Titan Pet Products",
    "CC7A30": "CMAX Wireless Co.",
    "B88E3A": "Infinite Technologies JLT",
    "706582": "Suzhou Hanming Technologies Co.",
    "7C3920": "SSOMA SECURITY",
    "9C77AA": "NADASNV",
    "58BC27": "Cisco Systems",
    "34D2C4": "RENA GmbH Print Systeme",
    "0034F1": "Radicom Research",
    "DC2008": "ASD Electronics Ltd",
    "88ACC1": "Generiton Co.",
    "8818AE": "Tamron Co.",
    "20D607": "Nokia Corporation",
    "206FEC": "Braemac CA LLC",
    "A45C27": "Nintendo Co.",
    "6C0460": "RBH Access Technologies Inc.",
    "706417": "ORBIS TECNOLOGIA ELECTRICA S.A.",
    "B8BA72": "Cynove",
    "D4CBAF": "Nokia Corporation",
    "10E8EE": "PhaseSpace",
    "A47C1F": "Cobham plc",
    "D46CDA": "CSM GmbH",
    "5CD998": "D-Link Corporation",
    "100D32": "Embedian",
    "7CED8D": "Microsoft",
    "6CE0B0": "SOUND4",
    "9CFFBE": "OTSL Inc.",
    "045D56": "camtron industrial inc.",
    "68234B": "Nihon Dengyo Kousaku",
    "A4BE61": "EutroVision System",
    "18EF63": "Cisco Systems",
    "00F860": "PT. Panggung Electric Citrabuana",
    "1C3DE7": "Sigma Koki Co.",
    "A40CC3": "Cisco Systems",
    "4CBAA3": "Bison Electronics Inc.",
    "EC7C74": "Justone Technologies Co.",
    "A8B1D4": "Cisco Systems",
    "CCFCB1": "Wireless Technology",
    "3C1A79": "Huayuan Technology CO.",
    "8841C1": "ORBISAT DA AMAZONIA IND E AEROL SA",
    "9C7514": "Wildix srl",
    "4CF737": "SamJi Electronics Co.",
    "F0D767": "Axema Passagekontroll AB",
    "443D21": "Nuvolt",
    "30493B": "Nanjing Z-Com Wireless Co.",
    "D07DE5": "Forward Pay Systems",
    "84A991": "Cyber Trans Japan Co.",
    "68784C": "Nortel Networks",
    "9CF61A": "Carrier Fire & Security",
    "7CF098": "Bee Beans Technologies",
    "EC66D1": "B&W Group LTD",
    "385FC3": "Yu Jeong System",
    "888B5D": "Storage Appliance Corporation",
    "78C6BB": "Analog Devices",
    "04DD4C": "Velocytech",
    "F8D756": "Simm Tronic Limited",
    "C802A6": "Beijing Newmine Technology",
    "C84C75": "Cisco Systems",
    "4C8B55": "Grupo Digicon",
    "04A3F3": "Emicon",
    "1C17D3": "Cisco Systems",
    "7CE044": "NEON Inc",
    "284C53": "Intune Networks",
    "E86CDA": "Supercomputers and Neurocomputers Research Center",
    "240B2A": "Viettel Group",
    "84F64C": "Cross Point BV",
    "C08B6F": "S I Sistemas Inteligentes Eletrônicos Ltda",
    "64D02D": "NEXT GENERATION INTEGRATION LIMITED (NGI)",
    "90513F": "Elettronica Santerno SpA",
    "00B5D6": "Omnibit Inc.",
    "548922": "Zelfy Inc",
    "F86ECF": "Arcx Inc",
    "8C8401": "Private",
    "408493": "Clavister AB",
    "6C7039": "Novar GmbH",
    "6C5CDE": "SunReports",
    "34F39B": "WizLAN Ltd.",
    "089F97": "LEROY AUTOMATION",
    "78A6BD": "DAEYEON Control&Instrument Co",
    "FCCF62": "IBM Corp",
    "084E1C": "H2A Systems",
    "88B627": "Gembird Europe BV",
    "F06853": "Integrated Corporation",
    "A4ADB8": "Vitec Group",
    "3C1915": "GFI Chrono Time",
    "ECB106": "Acuro Networks",
    "481249": "Luxcom Technologies Inc.",
    "24A937": "PURE Storage",
    "348302": "iFORCOM Co.",
    "E02630": "Intrigue Technologies",
    "B43DB2": "Degreane Horizon",
    "34BA51": "Se-Kure Controls",
    "5C57C8": "Nokia Corporation",
    "D46CBF": "Goodrich ISR",
    "F89D0D": "Control Technology Inc.",
    "2C3F3E": "Alge-Timing GmbH",
    "147373": "TUBITAK UEKAE",
    "C835B8": "Ericsson",
    "ECC882": "Cisco Systems",
    "982D56": "Resolution Audio",
    "6CFDB9": "Proware Technologies Co Ltd.",
    "B42CBE": "Direct Payment Solutions Limited",
    "CC2218": "InnoDigital Co.",
    "C86C1E": "Display Systems Ltd",
    "90A7C1": "Pakedge Device and Software Inc.",
    "80BAAC": "TeleAdapt Ltd",
    "C86CB6": "Optcom Co.",
    "A01859": "Shenzhen Yidashi Electronics Co Ltd",
    "E8056D": "Nortel Networks",
    "C45976": "Fugoo Coorporation",
    "A4B121": "Arantia 2010 S.L.",
    "E02636": "Nortel Networks",
    "8C56C5": "Nintendo Co.",
    "CCB888": "AnB Securite s.a.",
    "6C5E7A": "Ubiquitous Internet Telecom Co.",
    "104369": "Soundmax Electronic Limited",
    "C06C0F": "Dobbs Stanford",
    "502DF4": "Phytec Messtechnik GmbH",
    "2CCD27": "Precor Inc",
    "10189E": "Elmo Motion Control",
    "746B82": "MOVEK",
    "9CC077": "PrintCounts",
    "3CB17F": "Wattwatchers Pty Ld",
    "CC5459": "OnTime Networks AS",
    "D4F143": "IPROAD.",
    "601D0F": "Midnite Solar",
    "A8F94B": "Eltex Enterprise Ltd.",
    "0C8230": "SHENZHEN MAGNUS TECHNOLOGIES CO.",
    "34862A": "Heinz Lackmann GmbH & Co KG",
    "B4ED54": "Wohler Technologies",
    "B8F732": "Aryaka Networks Inc",
    "E8DFF2": "PRF Co.",
    "006440": "Cisco Systems",
    "5849BA": "Chitai Electronic Corp.",
    "00D11C": "ACETEL",
    "94C4E9": "PowerLayer Microsystems HongKong Limited",
    "8843E1": "Cisco Systems",
    "549A16": "Uzushio Electric Co.",
    "9018AE": "Shanghai Meridian Technologies",
    "A4AD00": "Ragsdale Technology",
    "4C9EE4": "Hanyang Navicom Co.",
    "C47D4F": "Cisco Systems",
    "3CDF1E": "Cisco Systems",
    "50A6E3": "David Clark Company",
    "50934F": "Gradual Tecnologia Ltda.",
    "ACE348": "MadgeTech",
    "9C4E8E": "ALT Systems Ltd",
    "042BBB": "PicoCELA",
    "FC0877": "Prentke Romich Company",
    "ECD00E": "MiraeRecognition Co.",
    "7072CF": "EdgeCore Networks",
    "B8B1C7": "BT&COM CO.",
    "DC2C26": "Iton Technology Limited",
    "1C0FCF": "Sypro Optics GmbH",
    "0494A1": "CATCH THE WIND INC",
    "003A99": "Cisco Systems",
    "003A9A": "Cisco Systems",
    "003A98": "Cisco Systems",
    "D411D6": "ShotSpotter",
    "9CAFCA": "Cisco Systems",
    "7C7BE4": "Z'SEDAI KENKYUSHO CORPORATION",
    "F0DE71": "Shanghai EDO Technologies Co.",
    "60D30A": "Quatius Limited",
    "24CF21": "Shenzhen State Micro Technology Co.",
    "10BAA5": "GANA I&C CO.",
    "64BC11": "CombiQ AB",
    "EC3091": "Cisco Systems",
    "F4ACC1": "Cisco Systems",
    "4097D1": "BK Electronics cc",
    "0CE936": "ELIMOS srl",
    "60391F": "ABB Ltd",
    "E8A4C1": "Deep Sea Electronics Ltd",
    "64F970": "Kenade Electronics Technology Co.",
    "C87248": "Aplicom Oy",
    "986DC8": "TOSHIBA MITSUBISHI-ELECTRIC INDUSTRIAL SYSTEMS CORPORATION",
    "6CAC60": "Venetex Corp",
    "F04BF2": "JTECH Communications",
    "88A5BD": "QPCOM INC.",
    "80177D": "Nortel Networks",
    "C82E94": "Halfa Enterprise Co.",
    "BC9DA5": "DASCOM Europe GmbH",
    "28FBD3": "Ragentek Technology Group",
    "586ED6": "Private",
    "C8D2C1": "Jetlun (Shenzhen) Corporation",
    "E09153": "XAVi Technologies Corp.",
    "002712": "MaxVision LLC",
    "D4C766": "Acentic GmbH",
    "A02EF3": "United Integrated Services Co.",
    "A09805": "OpenVox Communication Co Ltd",
    "0026F3": "SMC Networks",
    "0026E7": "Shanghai ONLAN Communication Tech. Co.",
    "00271F": "MIPRO Electronics Co.",
    "00270C": "Cisco Systems",
    "0026E0": "ASITEQ",
    "002703": "Testech Electronics Pte Ltd",
    "0026C5": "Guangdong Gosun Telecommunications Co.",
    "0026C4": "Cadmos microsystems S.r.l.",
    "0026C8": "System Sensor",
    "0026C2": "SCDI Co. LTD",
    "002697": "Alpha  Technologies Inc.",
    "00268A": "Terrier SC Ltd",
    "0026A5": "MICROROBOT.CO.",
    "0026A3": "FQ Ingenieria Electronica S.A.",
    "00269D": "M2Mnet Co.",
    "00267A": "wuhan hongxin telecommunication technologies co.",
    "002672": "AAMP of America",
    "002689": "General Dynamics Robotic Systems",
    "002685": "Digital Innovation",
    "0026CF": "DEKA R&D",
    "002664": "Core System Japan",
    "002659": "Nintendo Co.",
    "002651": "Cisco Systems",
    "00264E": "r2p GmbH",
    "00264F": "Krüger &Gothe GmbH",
    "0026A9": "Strong Technologies Pty Ltd",
    "0025E9": "i-mate Development",
    "0025E6": "Belgian Monitoring Systems bvba",
    "0025E0": "CeedTec Sdn Bhd",
    "0025DE": "Probits Co.",
    "0025CE": "InnerSpace",
    "0025C6": "kasercorp",
    "0025C5": "Star Link Communication Pvt. Ltd.",
    "0025C7": "altek Corporation",
    "0025FF": "CreNova Multimedia Co.",
    "002612": "Space Exploration Technologies",
    "002616": "Rosemount Inc.",
    "00260B": "Cisco Systems",
    "0025FD": "OBR Centrum Techniki Morskiej S.A.",
    "002600": "TEAC Australia Pty Ltd.",
    "0025F3": "Nordwestdeutsche Zählerrevision",
    "0025EC": "Humanware",
    "0025ED": "NuVo Technologies LLC",
    "002623": "JRD Communication Inc",
    "002627": "Truesell",
    "002621": "InteliCloud Technology Inc.",
    "00261C": "NEOVIA INC.",
    "002639": "T.M. Electronics",
    "0025DD": "SUNNYTEK INFORMATION CO.",
    "0025B0": "Schmartz Inc",
    "0025AD": "Manufacturing Resources International",
    "0025AC": "I-Tech corporation",
    "0025AB": "AIO LCD PC BU / TPV",
    "0025BA": "Alcatel-Lucent IPD",
    "0025BB": "INNERINT Co.",
    "0025B1": "Maya-Creation Corporation",
    "0025B8": "Agile Communications",
    "0025A1": "Enalasys",
    "00259A": "CEStronics GmbH",
    "00254A": "RingCube Technologies",
    "002583": "Cisco Systems",
    "00255D": "Morningstar Corporation",
    "002558": "MPEDIA",
    "002591": "NEXTEK",
    "00258D": "Haier",
    "002571": "Zhejiang Tianle Digital Electric Co.",
    "00254F": "ELETTROLAB Srl",
    "002549": "Jeorich Tech. Co.",
    "002539": "IfTA GmbH",
    "002537": "Runcom Technologies Ltd.",
    "002538": "Samsung Electronics Co.",
    "002544": "LoJack Corporation",
    "002532": "Digital Recorders",
    "0024F8": "Technical Solutions Company Ltd.",
    "0024F9": "Cisco Systems",
    "0024F2": "Uniphone Telecommunication Co.",
    "002507": "ASTAK Inc.",
    "002502": "NaturalPoint",
    "00251A": "Psiber Data Systems Inc.",
    "002514": "PC Worth Int'l Co.",
    "00250B": "CENTROFACTOR  INC",
    "002506": "A.I. ANTITACCHEGGIO ITALIA SRL",
    "0024EE": "Wynmax Inc.",
    "0024E3": "CAO Group",
    "00251C": "EDT",
    "002469": "Fasttel - Smart Doorphones",
    "002464": "Bridge Technologies Co AS",
    "002462": "Rayzone Corporation",
    "002475": "Compass System(Embedded Dept.)",
    "00246F": "Onda Communication spa",
    "00249D": "NES Technology Inc.",
    "00248E": "Infoware ZRt.",
    "002494": "Shenzhen Baoxin Tech CO.",
    "0024E1": "Convey Computer Corp.",
    "0024D9": "BICOM",
    "002489": "Vodafone Omnitel N.V.",
    "00247F": "Nortel Networks",
    "0024B5": "Nortel Networks",
    "0024B0": "ESAB AB",
    "0024C3": "Cisco Systems",
    "0024C4": "Cisco Systems",
    "0023FD": "AFT Atlas Fahrzeugtechnik GmbH",
    "0023EF": "Zuend Systemtechnik AG",
    "002413": "Cisco Systems",
    "00240E": "Inventec Besta Co.",
    "002405": "Dilog Nordic AB",
    "002420": "NetUP Inc.",
    "00241E": "Nintendo Co.",
    "00241F": "DCT-Delta GmbH",
    "0023E8": "Demco Corp.",
    "0023E3": "Microtronic AG",
    "002460": "Giaval Science Development Co. Ltd.",
    "00245C": "Design-Com Technologies Pty. Ltd.",
    "00244F": "Asantron Technologies Ltd.",
    "002444": "Nintendo Co.",
    "00243D": "Emerson Appliance Motors and Controls",
    "002437": "Motorola - BSG",
    "00235B": "Gulfstream",
    "002359": "Benchmark Electronics ( Thailand ) Public Company Limited",
    "002357": "Pitronot Technologies and Engineering P.T.E. Ltd.",
    "002355": "Kinco Automation(Shanghai) Ltd.",
    "002373": "GridIron Systems",
    "002367": "UniControls a.s.",
    "002368": "Zebra Technologies Inc",
    "00236E": "Burster GmbH & Co KG",
    "002366": "Beijing Siasun Electronic System Co.",
    "00239F": "Institut für Prüftechnik",
    "00239D": "Mapower Electronics Co.",
    "002398": "Vutlan sro",
    "0023DD": "ELGIN S.A.",
    "0023DE": "Ansync Inc.",
    "0023D9": "Banner Engineering",
    "0023DA": "Industrial Computer Source (Deutschland)GmbH",
    "0023D8": "Ball-It Oy",
    "00238F": "NIDEC COPAL CORPORATION",
    "0023AC": "Cisco Systems",
    "002380": "Nanoteq",
    "0023B7": "Q-Light Co.",
    "00231E": "Cezzer Multimedia Technologies",
    "00231F": "Guangda Electronic & Telecommunication Technology Development Co.",
    "002270": "ABK North America",
    "002313": "Qool Technologies Ltd.",
    "002310": "LNC Technology Co.",
    "00230C": "CLOVER ELECTRONICS CO.",
    "0022CD": "Ared Technology Co.",
    "0022CC": "SciLog",
    "0022CB": "IONODES Inc.",
    "0022C6": "Sutus Inc",
    "0022EF": "iWDL Technologies",
    "0022F2": "SunPower Corp",
    "0022E8": "Applition Co.",
    "0022E9": "ProVision Communications",
    "0022E6": "Intelligent Data",
    "0022C0": "Shenzhen Forcelink Electronic Co",
    "002301": "Witron Technology Limited",
    "0022F7": "Conceptronic",
    "0022EB": "Data Respons A/S",
    "00231B": "Danaher Motion - Kollmorgen",
    "002334": "Cisco Systems",
    "0022E3": "Amerigon",
    "0022E2": "WABTEC Transit Division",
    "00233F": "Purechoice Inc",
    "002237": "Shinhint Group",
    "00222F": "Open Grid Computing",
    "0022A6": "Sony Computer Entertainment America",
    "0022A7": "Tyco Electronics AMP GmbH",
    "0022A1": "Huawei Symantec Technologies Co.",
    "002278": "Shenzhen  Tongfang Multimedia  Technology Co.",
    "00227A": "Telecom Design",
    "00226F": "3onedata Technology Co. Ltd.",
    "002260": "AFREEY Inc.",
    "00229D": "PYUNG-HWA IND.CO.",
    "002296": "LinoWave Corporation",
    "00223E": "IRTrans GmbH",
    "002250": "Point Six Wireless",
    "002244": "Chengdu Linkon Communications Device Co.",
    "0021CA": "ART System Co.",
    "0021CB": "SMS TECNOLOGIA ELETRONICA LTDA",
    "0021C8": "LOHUIS Networks",
    "0021BF": "Hitachi High-Tech Control Systems Corporation",
    "0021BC": "ZALA COMPUTER",
    "0021EF": "Kapsys",
    "0021ED": "Telegesis",
    "0021EB": "ESP SYSTEMS",
    "0021DF": "Martin Christ GmbH",
    "0021D4": "Vollmer Werke GmbH",
    "0021D6": "LXI Consortium",
    "0021CE": "NTC-Metrotek",
    "002206": "Cyberdyne Inc.",
    "002202": "Excito Elektronik i Skåne AB",
    "0021F6": "Oracle Corporation",
    "0021DB": "Santachi Video Technology (Shenzhen) Co.",
    "002220": "Mitac Technology Corp",
    "002227": "uv-electronic GmbH",
    "0021B4": "APRO MEDIA CO.",
    "0021A8": "Telephonics Corporation",
    "0021A9": "Mobilink Telecom Co.",
    "00220E": "Indigo Security Co.",
    "002207": "Inteno Broadband Technology AB",
    "002225": "Thales Avionics Ltd",
    "00221E": "Media Devices Co.",
    "00213B": "Berkshire Products",
    "002137": "Bay Controls",
    "002139": "Escherlogic Inc.",
    "00215E": "IBM Corp",
    "002155": "Cisco Systems",
    "002157": "National Datacast",
    "00214D": "Guangzhou Skytone Transmission Technology Com. Ltd.",
    "002150": "EYEVIEW ELECTRONICS",
    "002174": "AvaLAN Wireless",
    "002179": "IOGEAR",
    "00212C": "SemIndia System Private Limited",
    "00212B": "MSA Auer",
    "00212A": "Audiovox Corporation",
    "002196": "Telsey  S.p.A.",
    "00218D": "AP Router Ind. Eletronica LTDA",
    "002190": "Goliath Solutions",
    "002185": "MICRO-STAR INT'L CO.",
    "002182": "SandLinks Systems",
    "002183": "ANDRITZ HYDRO GmbH",
    "0021A6": "Videotec Spa",
    "00219F": "SATEL OY",
    "002168": "iVeia",
    "001FDD": "GDI LLC",
    "001FDA": "Nortel Networks",
    "001FB0": "TimeIPS",
    "001FD9": "RSD Communications Ltd",
    "001FCE": "QTECH LLC",
    "001FF0": "Audio Partnership",
    "001FEA": "Applied Media Technologies Corporation",
    "001FE9": "Printrex",
    "002110": "Clearbox Systems",
    "00210C": "Cymtec Systems",
    "00210B": "GEMINI TRAZE RFID PVT. LTD.",
    "002104": "Gigaset Communications GmbH",
    "001FFB": "Green Packet Bhd",
    "001F85": "Apriva ISS",
    "001F87": "Skydigital Inc.",
    "001F88": "FMS Force Measuring Systems AG",
    "001F86": "digEcor",
    "001F80": "Lucas Holding bv",
    "001B58": "ACE CAD Enterprise Co.",
    "001FA5": "Blue-White Industries",
    "001F9D": "Cisco Systems",
    "001F9F": "Thomson Telecom Belgium",
    "001FA1": "Gtran Inc",
    "001F99": "SERONICS co.ltd",
    "001F79": "Lodam Electronics A/S",
    "001F71": "xG Technology",
    "001F6C": "Cisco Systems",
    "001F6F": "Fujian Sunnada Communication Co.",
    "001F60": "COMPASS SYSTEMS CORP.",
    "001F6A": "PacketFlux Technologies",
    "001F65": "KOREA ELECTRIC TERMINAL CO.",
    "001F5E": "Dyna Technology Co.",
    "001F55": "Honeywell Security (China) Co.",
    "001F54": "Lorex Technology Inc.",
    "001F4B": "Lineage Power",
    "001F40": "Sendercraft Inc.",
    "001F2E": "Triangle Research Int'l Pte Ltd",
    "001F96": "APROTECH CO.LTD",
    "001F8B": "Cache IQ",
    "001FAE": "Blick South Africa (Pty) Ltd",
    "001EFA": "PROTEI Ltd.",
    "001EFB": "Trio Motion Technology Ltd",
    "001EF8": "Emfinity Inc.",
    "001EE8": "Mytek",
    "001EEE": "ETL Systems Ltd",
    "001EB4": "UNIFAT TECHNOLOGY LTD.",
    "001EA8": "Datang Mobile Communications Equipment CO.",
    "001EAB": "TeleWell Oy",
    "001E9F": "Visioneering Systems",
    "001F17": "IDX Company",
    "001F1B": "RoyalTek Company Ltd.",
    "001ED5": "Tekon-Automatics",
    "001ECB": "RPC Energoautomatika Ltd",
    "001EBA": "High Density Devices AS",
    "001EFC": "JSC MASSA-K",
    "001F06": "Integrated Dispatch Solutions",
    "001EE0": "Urmet SpA",
    "001EDA": "Wesemann Elektrotechniek B.V.",
    "001ED7": "H-Stream Wireless",
    "001E9B": "San-Eisha",
    "001F0D": "L3 Communications - Telemetry West",
    "001E1B": "Digital Stream Technology",
    "001E17": "STN BV",
    "001E18": "Radio Activity srl",
    "001E15": "Beech Hill Electronics",
    "001E05": "Xseed Technologies & Computing",
    "001E07": "Winy Technology Co.",
    "001E0A": "Syba Tech Limited",
    "001E03": "LiComm Co.",
    "001E71": "MIrcom Group of Companies",
    "001E6B": "Cisco SPVTG",
    "001E70": "Chelton Limited",
    "001E61": "ITEC GmbH",
    "001E3E": "KMW Inc.",
    "001E38": "Bluecard Software Technology Co.",
    "001E59": "Silicon Turnkey Express",
    "001E51": "Converter Industry Srl",
    "001E47": "PT. Hariff Daya Tunggal Engineering",
    "001E48": "Wi-Links",
    "001E8A": "eCopy",
    "001E30": "Shireen Inc",
    "001E2E": "SIRTI S.p.A.",
    "001DA6": "Media Numerics Limited",
    "001D9D": "ARTJOY INTERNATIONAL LIMITED",
    "001D9E": "AXION TECHNOLOGIES",
    "001DF8": "Webpro Vision Technology Corporation",
    "001DF9": "Cybiotronics (Far East) Limited",
    "001DF7": "R. STAHL Schaltgeräte GmbH",
    "001DEB": "DINEC International",
    "001D9A": "GODEX INTERNATIONAL CO.",
    "001D97": "Alertus Technologies LLC",
    "001D91": "Digitize",
    "001DC4": "AIOI Systems Co.",
    "001DC0": "Enphase Energy",
    "001DBD": "Versamed Inc.",
    "001DDC": "HangZhou DeChangLong Tech&Info Co.",
    "001DB7": "Tendril Networks",
    "001DAE": "CHANG TSENG TECHNOLOGY CO.",
    "001D7F": "Tekron International Ltd",
    "001D95": "Flash",
    "001D8D": "Fluke Process Instruments GmbH",
    "001D1F": "Siauliu Tauro Televizoriai",
    "001D70": "Cisco Systems",
    "001D79": "SIGNAMAX LLC",
    "001D6F": "Chainzone Technology Co.",
    "001D78": "Invengo Information Technology Co.",
    "001D13": "NextGTV",
    "001D10": "LightHaus Logic",
    "001D14": "SPERADTONE INFORMATION TECHNOLOGY LIMITED",
    "001D43": "Shenzhen G-link Digital Technology Co.",
    "001D3F": "Mitron Pty Ltd",
    "001D39": "MOOHADIGITAL CO.",
    "001D37": "Thales-Panda Transportation System",
    "001D30": "YX Wireless S.A.",
    "001CF2": "Tenlon Technology Co.",
    "001CEC": "Mobilesoft (Aust.) Pty Ltd",
    "001CE8": "Cummins Inc",
    "001D04": "Zipit Wireless",
    "001D62": "InPhase Technologies",
    "001D63": "Miele & Cie. KG",
    "001CC7": "Rembrandt Technologies",
    "001CBB": "MusicianLink",
    "001CB2": "BPT SPA",
    "001CB5": "Neihua Network Technology Co.",
    "001C5C": "Integrated Medical Systems",
    "001C52": "VISIONEE SRL",
    "001C47": "Hangzhou Hollysys Automation Co.",
    "001CD0": "Circleone Co.",
    "001CCD": "Alektrona Corporation",
    "001C6C": "30805",
    "001C61": "Galaxy  Microsystems LImited",
    "001C63": "TRUEN",
    "001CB4": "Iridium Satellite LLC",
    "001CB6": "Duzon CNT Co.",
    "001C9F": "Razorstream",
    "001C7D": "Excelpoint Manufacturing Pte Ltd",
    "001C77": "Prodys",
    "001C6F": "Emfit Ltd",
    "001C89": "Force Communications",
    "001C87": "Uriver Inc.",
    "001C8D": "Mesa Imaging",
    "001C49": "Zoltan Technology Inc.",
    "001C3F": "International Police Technologies",
    "001C3B": "AmRoad Technology Inc.",
    "001C32": "Telian Corporation",
    "001B93": "JC Decaux SA DNT",
    "001B9B": "Hose-McCann Communications",
    "001B9C": "SATEL sp. z o.o.",
    "001C16": "ThyssenKrupp Elevator",
    "001C19": "secunet Security Networks AG",
    "001C09": "SAE Electronic Co.",
    "001C0C": "TANITA Corporation",
    "001BE1": "ViaLogy",
    "001BDF": "Iskra Sistemi d.d.",
    "001BD9": "Edgewater Wireless Systems Inc",
    "001BB4": "Airvod Limited",
    "001BB6": "Bird Electronic Corp.",
    "001BA6": "intotech inc.",
    "001BA4": "S.A.E Afikim",
    "001BEC": "Netio Technologies Co.",
    "001BE8": "Ultratronik GmbH",
    "001C28": "Sphairon Technologies GmbH",
    "001C1F": "Quest Retail Technology Pty Ltd",
    "001BC7": "StarVedia Technology Inc.",
    "001B92": "l-acoustics",
    "001B8E": "Hulu Sweden AB",
    "001B8A": "2M Electronic A/S",
    "001B6B": "Swyx Solutions AG",
    "001B69": "Equaline Corporation",
    "001B68": "Modnnet Co.",
    "001B62": "JHT Optoelectronics Co.",
    "001B45": "ABB AS",
    "001B3F": "ProCurve Networking by HP",
    "001B41": "General Infinity Co.",
    "001B76": "Ripcode",
    "001B70": "IRI Ubiteq",
    "001B6C": "LookX Digital Media BV",
    "001B50": "Nizhny Novgorod Factory named after M.Frunze",
    "001B47": "Futarque A/S",
    "001B23": "SimpleComTools",
    "001B3E": "Curtis",
    "001B37": "Computec Oy",
    "001B30": "Solitech Inc.",
    "001B80": "LORD Corporation",
    "001B18": "Tsuken Electric Ind. Co.",
    "001A8B": "CHUNIL ELECTRIC IND.",
    "001A8D": "AVECS Bergen GmbH",
    "001A95": "Hisense Mobile Communications Technoligy Co.",
    "001A81": "Zelax",
    "001A87": "Canhold International Limited",
    "001B07": "Mendocino Software",
    "001B08": "Danfoss Drives A/S",
    "001B01": "Applied Radio Technologies",
    "001B02": "ED Co.Ltd",
    "001AFC": "ModusLink Corporation",
    "001ABE": "COMPUTER HI-TECH INC.",
    "001AC1": "3Com Ltd",
    "001ABB": "Fontal Technology Incorporation",
    "001ABD": "Impatica Inc.",
    "001AAE": "Savant Systems LLC",
    "001AD7": "Christie Digital Systems",
    "001ACD": "Tidel Engineering LP",
    "001AC9": "SUZUKEN CO.",
    "001AB4": "FFEI Ltd.",
    "001AB5": "Home Network System",
    "001A79": "TELECOMUNICATION TECHNOLOGIES LTD.",
    "001AAA": "Analogic Corp.",
    "001AF6": "Woven Systems",
    "001AF9": "AeroVIronment (AV Inc)",
    "001AE0": "Mythology Tech Express Inc.",
    "001AE2": "Cisco Systems",
    "001B10": "ShenZhen Kang Hui Technology Co.",
    "001B0B": "Phidgets Inc.",
    "001B0C": "Cisco Systems",
    "001AA4": "Future University-Hakodate",
    "001A9F": "A-Link Ltd",
    "001AE7": "Aztek Networks",
    "001A20": "CMOTECH Co. Ltd.",
    "001A19": "Computer Engineering Limited",
    "001A18": "Advanced Simulation Technology inc.",
    "001A13": "Wanlida Group Co.",
    "001A5C": "Euchner GmbH+Co. KG",
    "001A5B": "NetCare Service Co.",
    "001A4E": "NTI AG / LinMot",
    "001A52": "Meshlinx Wireless Inc.",
    "001A58": "CCV Deutschland GmbH - Celectronic eHealth Div.",
    "001A5E": "Thincom Technology Co.",
    "001A88": "Venergy",
    "001A74": "Procare International Co",
    "001A24": "Galaxy Telecom Technologies Ltd",
    "001A43": "Logical Link Communications",
    "001A47": "Agami Systems",
    "001A2D": "The Navvo Group",
    "001A2F": "Cisco Systems",
    "00199E": "Nifty",
    "00198D": "Ocean Optics",
    "001985": "IT Watchdogs",
    "001986": "Cheng Hongjian",
    "0019E5": "Lynx Studio Technology",
    "0019DB": "MICRO-STAR INTERNATIONAL CO.",
    "0019CE": "Progressive Gaming International",
    "0019BD": "New Media Life",
    "0019A9": "Cisco Systems",
    "0019AE": "Hopling Technologies b.v.",
    "0019F2": "Teradyne K.K.",
    "0019DE": "MOBITEK",
    "0019AF": "Rigol Technologies",
    "0019A7": "ITU-T",
    "001A03": "Angel Electronics Co.",
    "0019F9": "TDK-Lambda",
    "001A0F": "ARTECHE GROUP",
    "00199F": "DKT A/S",
    "0018FF": "PowerQuattro Co.",
    "0018F4": "EO TECHNICS Co.",
    "0018F6": "Thomson Telecom Belgium",
    "0018FC": "Altec Electronic AG",
    "0018F5": "Shenzhen Streaming Video Technology Company Limited",
    "0018F9": "VVOND",
    "0018FA": "Yushin Precision Equipment Co.",
    "001935": "DUERR DENTAL AG",
    "001932": "Gude Systems GmbH",
    "001931": "Balluff GmbH",
    "00193D": "GMC Guardian Mobility Corp.",
    "00193B": "LigoWave",
    "001914": "Winix Co.",
    "001901": "F1MEDIA",
    "001910": "Knick Elektronische Messgeraete GmbH & Co. KG",
    "001913": "Chuang-Yi Network Equipment Co.Ltd.",
    "001951": "NETCONS",
    "001957": "Saafnet Canada Inc.",
    "00196B": "Danpex Corporation",
    "00196A": "MikroM GmbH",
    "001956": "Cisco Systems",
    "001958": "Bluetooth SIG",
    "001899": "ShenZhen jieshun Science&Technology Industry CO",
    "00189F": "Lenntek Corporation",
    "001895": "Hansun Technologies Inc.",
    "0018B7": "D3 LED",
    "0018C1": "Almitec Informática e Comércio",
    "0018C4": "Raba Technologies LLC",
    "0018C9": "EOps Technology Limited",
    "0018BC": "ZAO NVP Bolid",
    "00186D": "Zhenjiang Sapphire Electronic Industry CO.",
    "00186F": "Setha Industria Eletronica LTDA",
    "001875": "AnaCise Testnology Pte Ltd",
    "0018D8": "ARCH METER Corporation",
    "0018D9": "Santosha Internatonal",
    "0018CF": "Baldor Electric Company",
    "00188E": "Ekahau",
    "001883": "FORMOSA21 INC.",
    "0018E3": "Visualgate Systems",
    "0018EA": "Alltec GmbH",
    "0018E8": "Hacetron Corporation",
    "0017DE": "Advantage Six Ltd",
    "0017D7": "ION Geophysical Corporation Inc.",
    "0017E1": "DACOS Technologies Co.",
    "001814": "Mitutoyo Corporation",
    "001817": "D. E. Shaw Research",
    "001811": "Neuros Technology International",
    "00180E": "Avega Systems",
    "0017E0": "Cisco Systems",
    "0017D2": "THINLINX PTY LTD",
    "0017C7": "MARA Systems Consulting AB",
    "00185D": "TAIGUEN TECHNOLOGY (SHEN-ZHEN) CO.",
    "00185E": "Nexterm Inc.",
    "001828": "e2v technologies (UK) ltd.",
    "001835": "Thoratec / ITC",
    "001837": "Universal ABIT Co.",
    "001801": "Actiontec Electronics",
    "0017F3": "Harris Corporation",
    "001822": "CEC TELECOM CO.",
    "001820": "w5networks",
    "00184B": "Las Vegas Gaming",
    "00184A": "Catcher",
    "001750": "GSI Group",
    "001755": "GE Security",
    "001751": "Online Corporation",
    "0017B8": "NOVATRON CO.",
    "0017BB": "Syrinx Industrial Electronics",
    "0017BC": "Touchtunes Music Corporation",
    "0017C1": "CM Precision Technology LTD.",
    "0017A3": "MIX s.r.l.",
    "0017A6": "YOSIN ELECTRONICS CO.",
    "00179C": "DEPRAG SCHULZ GMBH u. CO.",
    "001796": "Rittmeyer AG",
    "001776": "Meso Scale Diagnostics",
    "001779": "QuickTel",
    "001767": "Earforce AS",
    "001763": "Essentia S.p.A.",
    "001781": "Greystone Data System",
    "001785": "Sparr Electronics Ltd",
    "001775": "TTE Germany GmbH",
    "0017B2": "SK Telesys",
    "0017B1": "ACIST Medical Systems",
    "00178D": "Checkpoint Systems",
    "00178E": "Gunnebo Cash Automation AB",
    "00177C": "Smartlink Network Systems Limited",
    "00174C": "Millipore",
    "001745": "INNOTZ CO.",
    "001748": "Neokoros Brasil Ltda",
    "00175D": "Dongseo system.",
    "00171D": "DIGIT",
    "001718": "Vansco Electronics Oy",
    "001719": "Audiocodes USA",
    "0016FF": "Wamin Optocomm Mfg Corp",
    "001701": "KDE",
    "00170E": "Cisco Systems",
    "001705": "Methode Electronics",
    "0016DE": "FAST Inc",
    "0016DA": "Futronic Technology Co. Ltd.",
    "00172C": "TAEJIN INFOTECH",
    "0016EE": "Royaldigital Inc.",
    "001711": "Cytiva Sweden AB",
    "001717": "Leica Geosystems AG",
    "001715": "Qstik",
    "001739": "Bright Headphone Electronics Company",
    "0016ED": "Utility",
    "001671": "Symphox Information Co.",
    "001669": "MRV Communication (Networks) LTD",
    "001668": "Eishin Electronics",
    "00167D": "Sky-Line Information Co.",
    "001677": "Bihl + Wiedemann GmbH",
    "001672": "Zenway enterprise ltd",
    "0016D4": "Compal Communications",
    "0016D7": "Sunways AG",
    "0016D1": "ZAT a.s.",
    "0016C5": "Shenzhen Xing Feng Industry Co.",
    "0016AA": "Kei Communication Technology Inc.",
    "0016A8": "CWT CO.",
    "0016A6": "Dovado FZ-LLC",
    "0016A2": "CentraLite Systems",
    "0016CC": "Xcute Mobile Corp.",
    "0016C7": "Cisco Systems",
    "00165A": "Harman Specialty Group",
    "001659": "Z.M.P. RADWAG",
    "001655": "FUHO TECHNOLOGY Co.",
    "001695": "AVC Technology (International) Limited",
    "0015D8": "Interlink Electronics",
    "0015D2": "Xantech Corporation",
    "0015D4": "Emitor AB",
    "0015D6": "OSLiNK Sp. z o.o.",
    "0015D5": "NICEVT",
    "00161D": "Innovative Wireless Technologies",
    "001611": "Altecon Srl",
    "00160C": "LPL  DEVELOPMENT S.A. DE C.V",
    "001612": "Otsuka Electronics Co.",
    "00160B": "TVWorks LLC",
    "001640": "Asmobile Communication Inc.",
    "00163C": "Rebox B.V.",
    "0015EA": "Tellumat (Pty) Ltd",
    "0015E2": "Dr.Ing. Herbert Knauer GmbH",
    "0015E1": "Picochip Ltd",
    "0015DF": "Clivet S.p.A.",
    "0015F5": "Sustainable Energy Systems",
    "0015F1": "KYLINK Communications Corp.",
    "001646": "Cisco Systems",
    "001648": "SSD Company Limited",
    "001625": "Impinj",
    "001623": "Interval Media",
    "001619": "Lancelan Technologies S.L.",
    "001603": "COOLKSKY Co.",
    "001609": "Unitech electronics co.",
    "0015C7": "Cisco Systems",
    "001586": "Xiamen Overseas Chinese Electronic Co.",
    "00157E": "Weidmüller Interface GmbH & Co. KG",
    "001580": "U-WAY CORPORATION",
    "00157C": "Dave Networks",
    "00157F": "ChuanG International Holding CO.",
    "00159D": "Tripp Lite",
    "001592": "Facom UK Ltd (Melksham)",
    "00158B": "Park Air Systems Ltd",
    "00155C": "Dresser Wayne",
    "001559": "Securaplane Technologies",
    "001557": "Olivetti",
    "001554": "Atalum Wireless S.A.",
    "00153F": "Alcatel Alenia Space Italia",
    "001533": "NADAM.CO.",
    "001537": "Ventus Networks",
    "0015BE": "Iqua Ltd.",
    "0015B3": "Caretech AB",
    "0015AA": "Rextechnik International Co.",
    "0014EA": "S Digm Inc. (Safe Paradigm Inc.)",
    "0014E5": "Alticast",
    "0014FC": "Extandon",
    "0014F8": "Scientific Atlanta",
    "0014F7": "CREVIS Co.",
    "001515": "Leipold+Co.GmbH",
    "0014E0": "LET'S Corporation",
    "0014E2": "datacom systems inc.",
    "0014E4": "infinias",
    "0014DB": "Elma Trenew Electronic GmbH",
    "001526": "Remote Technologies Inc",
    "001518": "Shenzhen 10MOONS Technology Development CO.",
    "001534": "A Beltrónica-Companhia de Comunicações",
    "0014CC": "Zetec",
    "0014CB": "LifeSync Corporation",
    "0014C6": "Quixant Ltd",
    "00146F": "Kohler Co",
    "001466": "Kleinhenz Elektronik GmbH",
    "00146B": "Anagran",
    "001461": "CORONA CORPORATION",
    "001462": "Digiwell Technology",
    "001463": "IDCS N.V.",
    "00143D": "Aevoe Inc.",
    "00143A": "RAYTALK INTERNATIONAL SRL",
    "001498": "Viking Design Technology",
    "001496": "Phonic Corp.",
    "001493": "Systimax Solutions",
    "00148D": "Cubic Defense Simulation Systems",
    "00147F": "Thomson Telecom Belgium",
    "001475": "Wiline Networks",
    "001474": "K40 Electronics",
    "00149F": "System and Chips",
    "0014B3": "CoreStar International Corp",
    "0014B1": "Axell Wireless Limited",
    "001486": "Echo Digital Audio Corporation",
    "001482": "Aurora Networks",
    "001455": "Coder Electronics Corporation",
    "00144E": "SRISA",
    "001465": "Novo Nordisk A/S",
    "001436": "Qwerty Elektronik AB",
    "001433": "Empower Technologies(Canada) Inc.",
    "001434": "Keri Systems",
    "001423": "J-S Co. NEUROCOM",
    "001425": "Galactic Computing Corp.",
    "001419": "SIDSA",
    "001415": "Intec Automation inc.",
    "001410": "Suzhou Keda Technology CO.",
    "001417": "RSE Informations Technologie GmbH",
    "001408": "Eka Systems Inc.",
    "0013DE": "Adapt4",
    "0013DD": "Abbott Diagnostics",
    "0013D7": "SPIDCOM Technologies SA",
    "0013EE": "JBX Designs Inc.",
    "0013E5": "TENOSYS",
    "0013E2": "GeoVision Inc.",
    "0013C7": "IONOS Co.",
    "0013BC": "Artimi Ltd",
    "0013B2": "Carallon Limited",
    "001402": "kk-electronic a/s",
    "0013FF": "Dage-MTI of MC",
    "001396": "Acbel Polytech Inc.",
    "001393": "Panta Systems",
    "00138B": "Phantom Technologies LLC",
    "001388": "WiMedia Alliance",
    "0013A6": "Extricom Ltd",
    "00139F": "Electronics Design Services",
    "0013A2": "MaxStream",
    "0013A0": "ALGOSYSTEM Co.",
    "001398": "TrafficSim Co.",
    "00139B": "ioIMAGE Ltd.",
    "00136E": "Techmetro Corp.",
    "00136D": "Tentaculus AB",
    "00136A": "Hach Lange Sarl",
    "001363": "Verascape",
    "00134D": "Inepro BV",
    "00134B": "ToGoldenNet Technology Inc.",
    "00134A": "Engim",
    "001334": "Arkados",
    "001337": "Orient Power Home Network Ltd.",
    "001332": "Beijing Topsec Network Security Technology Co.",
    "00131F": "NxtPhase T&D",
    "0013AD": "Sendo Ltd",
    "0013AA": "ALS  & TEC Ltd.",
    "0013A4": "KeyEye Communications",
    "0013A7": "BATTELLE MEMORIAL INSTITUTE",
    "00133A": "VadaTech Inc.",
    "00132A": "Sitronics Telecom Solutions",
    "001384": "Advanced Motion Controls",
    "00137B": "Movon Corporation",
    "001353": "HYDAC Filtertechnik GMBH",
    "0012D7": "Invento Networks",
    "0012FF": "Lely Industries N.V.",
    "001303": "GateConnect",
    "0012F9": "URYU SEISAKU",
    "001304": "Flaircomm Technologies Co. LTD",
    "0012B8": "G2 Microsystems",
    "0012B3": "Advance Wireless Technology Corp.",
    "0012B0": "Efore Oyj   (Plc)",
    "001309": "Ocean Broadband Networks",
    "001319": "Cisco Systems",
    "00131C": "LiteTouch",
    "00130E": "Focusrite Audio Engineering Limited",
    "0012C4": "Viseon",
    "0012D0": "Gossen-Metrawatt-GmbH",
    "0012E5": "Time America",
    "0012DC": "SunCorp Industrial Limited",
    "001269": "Value Electronics",
    "001264": "daum electronic gmbh",
    "001275": "Sentilla Corporation",
    "001276": "CG Power Systems Ireland Limited",
    "001271": "Measurement Computing Corp",
    "001273": "Stoke Inc",
    "00127F": "Cisco Systems",
    "00127B": "VIA Networking Technologies",
    "001280": "Cisco Systems",
    "001293": "ABB Switzerland Ltd.",
    "001294": "SUMITOMO ELECTRIC DEVICE INNOVATIONS",
    "001296": "Addlogix",
    "001261": "Adaptix",
    "001260": "Stanton Magnetics",
    "001258": "TechVoIP Sp z o.o.",
    "001250": "Tokyo Aircaft Instrument Co.",
    "001252": "Citronix",
    "00124B": "Texas Instruments",
    "00124A": "Dedicated Devices",
    "0012A6": "Dolby Australia",
    "0012A4": "ThingMagic",
    "0012A9": "3Com Ltd",
    "001243": "Cisco Systems",
    "001299": "Ktech Telecommunications Inc",
    "00128C": "Woodward Governor",
    "0011D2": "Perception Digital Ltd",
    "0011D9": "TiVo",
    "0011CF": "Thrane & Thrane A/S",
    "0011D4": "NetEnrich",
    "0011D5": "Hangzhou Sunyard System Engineering Co.",
    "0011F8": "AIRAYA Corp",
    "0011F4": "woori-net",
    "0011F6": "Asia Pacific Microsystems",
    "0011F0": "Wideful Limited",
    "0011F1": "QinetiQ Ltd",
    "0011ED": "802 Global",
    "0011CC": "Guangzhou Jinpeng Group Co.",
    "0011C7": "Raymarine UK Ltd",
    "0011C9": "MTT Corporation",
    "0011B5": "Shenzhen Powercom Co.",
    "0011BB": "Cisco Systems",
    "0011BD": "Bombardier Transportation",
    "001203": "ActivNetworks",
    "001211": "Protechna Herbst GmbH & Co. KG",
    "001219": "General Datacomm LLC",
    "001216": "ICP Internet Communication Payment AG",
    "001215": "iStor Networks",
    "0011DB": "Land-Cellular Corporation",
    "001240": "AMOI ELECTRONICS CO.",
    "00122E": "Signal Technology - AISD",
    "001231": "Motion Control Systems",
    "001224": "NexQL Corporation",
    "001150": "Belkin Corporation",
    "001146": "Telecard-Pribor Ltd",
    "0011AA": "Uniclass Technology",
    "0011B1": "BlueExpert Technology Corp.",
    "0011A6": "Sypixx Networks",
    "001166": "Taelim Electronics Co.",
    "001164": "ACARD Technology Corp.",
    "001155": "Sevis Systems",
    "001152": "Eidsvoll Electronics AS",
    "00117E": "Midmark Corp",
    "001179": "Singular Technology Co. Ltd.",
    "00118A": "Viewtran Technology Limited",
    "001184": "Humo Laboratory",
    "00114C": "caffeina applied research ltd.",
    "001141": "GoodMan Corporation",
    "0011A2": "Manufacturing Technology Inc",
    "00119E": "Solectron Brazil",
    "001173": "SMART Storage Systems",
    "00111C": "Pleora Technologies Inc.",
    "001125": "IBM Corp",
    "00111F": "Doremi Labs",
    "00111D": "Hectrix Limited",
    "001119": "Solteras",
    "001114": "EverFocus Electronics Corp.",
    "00110E": "Tsurusaki Sealand Transportation Co. Ltd.",
    "000FD7": "Harman Music Group",
    "000FD4": "Soundcraft",
    "000FCF": "DataWind Research",
    "000FD2": "EWA Technologies",
    "000FCE": "Kikusui Electronics Corp.",
    "000FA1": "Gigabit Systems Inc.",
    "000F99": "APAC opto Electronics Inc.",
    "000F8E": "DONGYANG TELECOM CO.",
    "000F91": "Aerotelecom Co.",
    "000FE8": "Lobos",
    "000FEB": "Cylon Controls",
    "000FDC": "Ueda Japan  Radio Co.",
    "000FF4": "Guntermann & Drunck GmbH",
    "000FF8": "Cisco Systems",
    "000FF5": "GN&S company",
    "000FB2": "Broadband Pacenet (India) Pvt. Ltd.",
    "00112C": "IZT GmbH",
    "00110D": "SANBlaze Technology",
    "001106": "Siemens NV (Belgium)",
    "000FAF": "Dialog Inc.",
    "000FA5": "BWA Technology GmbH",
    "000F29": "Augmentix Corporation",
    "000F27": "TEAL Electronics",
    "000F73": "RS Automation Co.",
    "000F78": "Datacap Systems Inc",
    "000F70": "Wintec Industries",
    "000F74": "Qamcom Technology AB",
    "000F6D": "Midas Engineering",
    "000F43": "Wasabi Systems Inc.",
    "000F48": "Polypix Inc.",
    "000F50": "StreamScale Limited",
    "000F47": "ROBOX SPA",
    "000F4E": "Cellink",
    "000F0F": "Real ID Technology Co.",
    "000F16": "JAY HOW TECHNOLOGY CO.",
    "000F1B": "Ego Systems Inc.",
    "000F3C": "Endeleo Limited",
    "000F31": "Allied Vision Technologies Canada Inc",
    "000F87": "Maxcess International",
    "000F80": "Trinity Security Systems",
    "000E8E": "SparkLAN Communications",
    "000E91": "Navico Auckland Ltd",
    "000E84": "Cisco Systems",
    "000E87": "adp Gauselmann GmbH",
    "000EF9": "REA Elektronik GmbH",
    "000EF6": "E-TEN Information Systems Co.",
    "000EEA": "Shadong Luneng Jicheng Electronics",
    "000EE6": "Adimos Systems LTD",
    "000EE0": "Mcharge",
    "000EF8": "SBC ASI",
    "000EAB": "Cray Inc",
    "000EAD": "Metanoia Technologies",
    "000EAF": "CASTEL",
    "000E75": "New York Air Brake Corp.",
    "000E92": "Open Telecom",
    "000E96": "Cubic Defense Applications",
    "000E9F": "TEMIC SDS GmbH",
    "000EC6": "ASIX ELECTRONICS CORP.",
    "000EBF": "Remsdaq Limited",
    "000DFD": "Huges Hi-Tech Inc.",
    "000E68": "E-TOP Network Technology Inc.",
    "000E56": "4G Systems GmbH & Co. KG",
    "000E55": "AUVITRAN",
    "000E0F": "ERMME",
    "000E10": "C-guys",
    "000E13": "Accu-Sort Systems inc.",
    "000E0A": "SAKUMA DESIGN OFFICE",
    "000E0E": "ESA elettronica S.P.A.",
    "000E7C": "Televes S.A.",
    "000E73": "Tpack A/S",
    "000E6E": "MAT S.A. (Mircrelec Advanced Technology)",
    "000E66": "Hitachi Industry & Control Solutions",
    "000E48": "Lipman TransAction Solutions",
    "000E3E": "Sun Optronics Inc",
    "000E33": "Shuko Electronics Co.",
    "000E3A": "Cirrus Logic",
    "000E27": "Crere Networks",
    "000E18": "MyA Technology",
    "000E14": "Visionary Solutions",
    "000E1B": "IAV GmbH",
    "000DEC": "Cisco Systems",
    "000DF2": "Private",
    "000E3B": "Hawking Technologies",
    "000E53": "AV TECH CORPORATION",
    "000DDA": "ALLIED TELESIS K.K.",
    "000DD6": "ITI    LTD",
    "000DD5": "O'RITE TECHNOLOGY CO.",
    "000D9B": "Heraeus Electro-Nite International N.V.",
    "000D8A": "Winners Electronics Co.",
    "000D8E": "Koden Electronics Co.",
    "000D7E": "Axiowave Networks",
    "000DA0": "NEDAP N.V.",
    "000D6B": "Mita-Teknik A/S",
    "000D71": "boca systems",
    "000D5A": "Tiesse SpA",
    "000DCD": "GROUPE TXCOM",
    "000DCF": "Cidra Corp.",
    "000DCA": "Tait Electronics",
    "000DB8": "SCHILLER AG",
    "000DC4": "Emcore Corporation",
    "000DDE": "Joyteck Co.",
    "000DE2": "CMZ Sistemi Elettronici",
    "000D7C": "Codian Ltd",
    "000D43": "DRS Tactical Systems Inc.",
    "000D44": "Audio BU - Logitech",
    "000D3D": "Hammerhead Systems",
    "000D3E": "APLUX Communications Ltd.",
    "000D36": "Wu Han Routon Electronic Co.",
    "000D3B": "Microelectronics Technology Inc.",
    "000D52": "Comart system",
    "000D4A": "Steag ETA-Optik",
    "000D4F": "Kenwood Corporation",
    "000D47": "Collex",
    "000CFF": "MRO-TEK Realty Limited",
    "000CFA": "Digital Systems Corp",
    "000CFD": "Hyundai ImageQuest Co.",
    "000CEB": "CNMP Networks",
    "000CD3": "Prettl Elektronik Radeberg GmbH",
    "000D1E": "Control Techniques",
    "000D0D": "ITSupported",
    "000D06": "Compulogic Limited",
    "000D03": "Matrics",
    "000D61": "Giga-Byte Technology Co.",
    "000D2D": "NCT Deutschland GmbH",
    "000D1A": "Mustek System Inc.",
    "000C64": "X2 MSA Group",
    "000C88": "Apache Micro Peripherals",
    "000C82": "NETWORK TECHNOLOGIES INC",
    "000C7C": "Internet Information Image Inc.",
    "000C7B": "ALPHA PROJECT Co.",
    "000C77": "Life Racing Ltd",
    "000CBD": "Interface Masters",
    "000CB2": "UNION co.",
    "000CB9": "LEA",
    "000CB8": "MEDION AG",
    "000CBB": "ISKRAEMECO",
    "000CC0": "Genera Oy",
    "000CA0": "StorCase Technology",
    "000C99": "HITEL LINK Co.",
    "000C69": "National Radio Astronomy Observatory",
    "000C66": "Pronto Networks Inc",
    "000C4E": "Winbest Technology CO",
    "000CA8": "Garuda Networks Corporation",
    "000CA7": "Metro (Suzhou) Technologies Co.",
    "000CC7": "Intelligent Computer Solutions Inc.",
    "000CBE": "Innominate Security Technologies AG",
    "000C89": "AC Electric Vehicles",
    "000CD7": "Nallatech Ltd",
    "000CD4": "Positron Public Safety Systems inc.",
    "000CCC": "Aeroscout Ltd.",
    "000BF2": "Chih-Kan Technology Co.",
    "000BEB": "Systegra AG",
    "000BEF": "Code Corporation",
    "000BDF": "Shenzhen RouterD Networks Limited",
    "000BE6": "Datel Electronics",
    "000C45": "Animation Technologies Inc.",
    "000C3C": "MediaChorus",
    "000C38": "TelcoBridges Inc.",
    "000BF5": "Shanghai Sibo Telecom Technology Co.",
    "000BFE": "CASTEL Broadband Limited",
    "000C2A": "OCTTEL Communication Co.",
    "000C22": "Double D Electronics Ltd",
    "000C1C": "MicroWeb Co.",
    "000C5A": "IBSmm Embedded Electronics Consulting",
    "000C5E": "Calypso Medical",
    "000C61": "AC Tech corporation DBA Advanced Digital",
    "000C0F": "Techno-One Co.",
    "000C05": "RPA Reserch Co.",
    "000C5F": "Avtec",
    "000C4B": "Cheops Elektronik",
    "000C27": "Sammy Corporation",
    "000B57": "Silicon Laboratories",
    "000B51": "Micetek International Inc.",
    "000B53": "INITIUM Co.",
    "000BAF": "WOOJU COMMUNICATIONS Co",
    "000BB6": "Metalligence Technology Corp.",
    "000BB7": "Micro Systems Co.",
    "000BB3": "RiT technologies Ltd.",
    "000BBA": "Harmonic",
    "000B62": "ib-mohnen KG",
    "000B64": "Kieback & Peter GmbH & Co KG",
    "000B67": "Topview Technology Corporation",
    "000BAE": "Vitals System Inc.",
    "000BD9": "General Hydrogen",
    "000B94": "Digital Monitoring Products",
    "000B6D": "SOLECTRON JAPAN NAKANIIDA",
    "000BAB": "Advantech Technology (CHINA) Co.",
    "000B7D": "SOLOMON EXTREME INTERNATIONAL LTD.",
    "000BC4": "BIOTRONIK GmbH & Co",
    "000ACA": "YOKOYAMA SHOKAI CO.",
    "000ACE": "RADIANTECH",
    "000AC7": "Unication Group",
    "000B48": "sofrel",
    "000B4A": "Visimetrics (UK) Ltd",
    "000ADE": "Happy Communication Co.",
    "000AE2": "Binatone Electronics International",
    "000AD4": "CoreBell Systems Inc.",
    "000AFF": "Kilchherr Elektronik AG",
    "000AF8": "American Telecare Inc.",
    "000B1E": "KAPPA opto-electronics GmbH",
    "000B1C": "SIBCO bv",
    "000B17": "MKS Instruments",
    "000B37": "MANUFACTURE DES MONTRES ROLEX SA",
    "000AFB": "Ambri Limited",
    "000B2D": "Danfoss Inc.",
    "000A9A": "Aiptek International Inc",
    "000A94": "ShangHai cellink CO.",
    "000A97": "SONICblue",
    "000A92": "Presonus Corporation",
    "000A85": "PLAT'C2",
    "000A83": "SALTO SYSTEMS S.L.",
    "000A86": "Lenze",
    "000AB8": "Cisco Systems",
    "000AA3": "SHIMAFUJI ELECTRIC CO.",
    "000AA7": "FEI Electron Optics",
    "000AA6": "Hochiki Corporation",
    "000A58": "Freyer & Siegel Elektronik GmbH & Co. KG",
    "000A4E": "UNITEK Electronics INC.",
    "000A3D": "Elo Sistemas Eletronicos S.A.",
    "000A46": "ARO WELDING TECHNOLOGIES SAS",
    "000A62": "Crinis Networks",
    "000A6A": "SVM Microwaves s.r.o.",
    "000A66": "MITSUBISHI ELECTRIC SYSTEM & SERVICE CO.",
    "000A50": "REMOTEK CORPORATION",
    "000A70": "MPLS Forum",
    "000A72": "STEC",
    "000A71": "Avrio Technologies",
    "000A64": "Eracom Technologies",
    "000ABF": "HIROTA SS",
    "000ABC": "Seabridge Ltd.",
    "000AAC": "TerraTec Electronic GmbH",
    "000A3F": "Data East Corporation",
    "000A31": "HCV Consulting",
    "004252": "RLX Technologies",
    "000A20": "SVA Networks",
    "000A0C": "Scientific Research Corporation",
    "0009F6": "Shenzhen Eastern Digital Tech Ltd.",
    "0009B9": "Action Imaging Solutions",
    "0009AC": "LANVOICE",
    "0009B1": "Kanematsu Electronics",
    "0009B0": "Onkyo Technology K.K.",
    "000A24": "Octave Communications",
    "000A19": "Valere Power",
    "000A11": "ExPet Technologies",
    "000A0F": "Ilryung Telesys",
    "000A01": "SOHOware",
    "0009EE": "MEIKYO ELECTRIC CO.",
    "0009EC": "Daktronics",
    "0009E7": "ADC Techonology",
    "0009E0": "XEMICS S.A.",
    "0009CA": "iMaxNetworks(Shenzhen)Limited.",
    "0009CF": "iAd GmbH",
    "0009C1": "PROCES-DATA A/S",
    "0009BB": "MathStar",
    "0009E5": "Hottinger Brüel & Kjaer GmbH",
    "0009DE": "Samjin Information & Communications Co.",
    "000999": "CP GEORGES RENAULT",
    "000994": "Cronyx Engineering",
    "000988": "Nudian Electron Co.",
    "00098E": "ipcas GmbH",
    "00093F": "Double-Win Enterpirse CO.",
    "00093C": "Jacques Technologies P/L",
    "000935": "Sandvine Incorporated",
    "000936": "Ipetronik GmbH & Co. KG",
    "000960": "YOZAN Inc.",
    "000956": "Network Systems Group",
    "000963": "Dominion Lasercom Inc.",
    "000966": "TRIMBLE EUROPE BV",
    "000968": "TECHNOVENTURE",
    "000961": "Switchgear and Instrumentation Ltd",
    "00097B": "Cisco Systems",
    "000979": "Advanced Television Systems Committee",
    "0009AB": "Netcontrol Oy",
    "00099D": "Haliplex Communications",
    "00099E": "Testech",
    "000948": "Vista Control Systems",
    "000949": "Glyph Technologies Inc.",
    "000946": "Cluster Labs GmbH",
    "000937": "Inventec Appliance Corp",
    "00097C": "Cisco Systems",
    "0008DE": "3UP Systems",
    "0008E0": "ATO Technology Ltd.",
    "0008E4": "Envenergy Inc",
    "0008E3": "Cisco Systems",
    "0008E5": "IDK Corporation",
    "0008D9": "Mitadenshi Co.",
    "0008D5": "Vanguard Networks Solutions",
    "000900": "TMT",
    "0008FD": "BlueKorea Co.",
    "0008F8": "UTC CCS",
    "0008AE": "PacketFront Network Products AB",
    "0008A7": "iLogic Inc.",
    "0008C3": "Contex A/S",
    "0008BC": "Ilevo AB",
    "0008BD": "TEPG-US",
    "00090E": "Helix Technology Inc.",
    "0008CD": "With-Net Inc",
    "0008CC": "Remotec",
    "0008D1": "KAREL INC.",
    "00092A": "MYTECS Co.",
    "000925": "VSN Systemen BV",
    "0008F3": "WANY",
    "000913": "SystemK Corporation",
    "000823": "Texa Corp.",
    "000828": "Koei Engineering Ltd.",
    "00082D": "Indus Teqsite Private Limited",
    "000820": "Cisco Systems",
    "000824": "Nuance Document Imaging",
    "000814": "TIL Technologies",
    "000869": "Command-e Technology Co.",
    "000862": "NEC Eluminant Technologies",
    "000861": "SoftEnergy Co.",
    "00084F": "Qualstar Corporation",
    "000854": "Netronix",
    "000892": "EM Solutions",
    "00088C": "Quanta Network Systems Inc.",
    "00088A": "Minds@Work",
    "000887": "Maschinenfabrik Reinhausen GmbH",
    "000877": "Liebert-Hiross Spa",
    "00087B": "RTX Telecom A/S",
    "00085C": "Shanghai Dare Technologies Co. Ltd.",
    "00082C": "Homag AG",
    "000821": "Cisco Systems",
    "000822": "InPro Comm",
    "00081D": "Ipsil",
    "000876": "SDSystem",
    "000870": "Rasvia Systems",
    "00086E": "Hyglo AB",
    "00086C": "Plasmon LMS",
    "000868": "PurOptix",
    "000899": "Netbind",
    "0008A0": "Stotz Feinmesstechnik GmbH",
    "000891": "Lyan Inc.",
    "000803": "Cos Tron",
    "000805": "Techno-Holon Corporation",
    "0007FD": "LANergy Ltd.",
    "0007FE": "Rigaku Corporation",
    "0007E4": "SoftRadio Co.",
    "000773": "Ascom Powerline Communications Ltd.",
    "00076C": "Daehanet",
    "00075D": "Celleritas Inc.",
    "000765": "Jade Quantum Technologies",
    "000754": "Xyterra Computing",
    "0007C7": "Synectics Systems Limited",
    "0007BF": "Armillaire Technologies",
    "0007BB": "Candera Inc.",
    "0007BD": "Radionet Ltd.",
    "0007C4": "JEAN Co. Ltd.",
    "0007D9": "Splicecom",
    "0007DA": "Neuro Telecom Co.",
    "0007CD": "Kumoh Electronic Co",
    "0007CF": "Anoto AB",
    "0007D2": "Logopak Systeme GmbH & Co. KG",
    "0007C9": "Technol Seven Co.",
    "000777": "Motah Ltd.",
    "000780": "Bluegiga Technologies OY",
    "00076E": "Sinetica Corporation Limited",
    "00076F": "Synoptics Limited",
    "000757": "Topcall International AG",
    "00074C": "Beicom Inc.",
    "000753": "Beijing Qxcomm Technology Co.",
    "00074D": "Zebra Technologies Corp.",
    "00079C": "Golden Electronics Technology Co.",
    "0007B7": "Samurai Ind. Prods Eletronicos Ltda",
    "0007B0": "Office Details",
    "0007A5": "Y.D.K Co. Ltd.",
    "0007C3": "Thomson",
    "0007B6": "Telecom Technology Ltd.",
    "00078E": "Garz & Fricke GmbH",
    "00073F": "Woojyun Systec Co.",
    "000728": "Neo Telecom",
    "00072C": "Fabricom",
    "00072D": "CNSystems",
    "00072F": "Intransa",
    "000732": "AAEON Technology Inc.",
    "000725": "Bematech International Corp.",
    "000723": "ELCON Systemtechnik GmbH",
    "00071D": "Satelsa Sistemas Y Aplicaciones De Telecomunicaciones",
    "000720": "Trutzschler GmbH & Co. KG",
    "000724": "Telemax Co.",
    "00071B": "CDVI Americas Ltd",
    "0006C9": "Technical Marketing Research",
    "0006C8": "Sumitomo Metal Micro Devices",
    "0006C0": "United Internetworks",
    "0006D7": "Cisco Systems",
    "0006D5": "Diamond Systems Corp.",
    "0005EA": "Rednix",
    "0006E0": "MAT Co.",
    "000715": "General Research of Electronics",
    "0006FD": "Comjet Information Systems Corp.",
    "0006F9": "Mitsui Zosen Systems Research Inc.",
    "0006F1": "Optillion",
    "000737": "Soriya Co. Ltd.",
    "000734": "ONStor",
    "0006A9": "Universal Instruments Corp.",
    "00069E": "UNIQA",
    "000698": "egnite GmbH",
    "00069C": "Transmode Systems AB",
    "000686": "ZARDCOM Co.",
    "000689": "yLez Technologies Pte Ltd",
    "000681": "Goepel Electronic GmbH",
    "00D0B9": "MICROTEK INTERNATIONAL",
    "00D05F": "VALCOM",
    "000675": "Banderacom",
    "00067B": "Toplink C&C Corporation",
    "000670": "Upponetti Oy",
    "000649": "3M Deutschland GmbH",
    "000643": "SONO Computer Co.",
    "00063E": "Opthos Inc.",
    "00063B": "Arcturus Networks Inc.",
    "0006B1": "Sonicwall",
    "0006AD": "KB Electronics Ltd.",
    "0006AF": "Xalted Networks",
    "0006A7": "Primarion",
    "000618": "DigiPower Manufacturing Inc.",
    "000620": "Serial System Ltd.",
    "000617": "Redswitch Inc.",
    "00066F": "Korea Data Systems",
    "000668": "Vicon Industries Inc.",
    "00066D": "Compuprint S.P.A.",
    "000626": "MWE GmbH",
    "000658": "Helmut Fischer GmbH Institut für Elektronik und Messtechnik",
    "000613": "Kawasaki Microelectronics Incorporated",
    "0005D3": "eProduction Solutions",
    "000604": "@Track Communications",
    "000606": "RapidWAN",
    "000596": "Genotech Co.",
    "000579": "Universal Control Solution Corp.",
    "0005AE": "Mediaport USA",
    "0005B0": "Korea Computer Technology Co.",
    "0005B2": "Medison Co.",
    "000597": "Eagle Traffic Control Systems",
    "0005E1": "Trellis Photonics",
    "0005E2": "Creativ Network Technologies",
    "0005C8": "VERYTECH",
    "0005CB": "ROIS Technologies",
    "000603": "Baker Hughes Inc.",
    "000607": "Omni Directional Control Technology Inc.",
    "0005F7": "Analog Devices",
    "00059C": "Kleinknecht GmbH",
    "0005A2": "CELOX Networks",
    "0005AA": "Moore Industries International Inc.",
    "0005E7": "Netrake an AudioCodes Company",
    "0005F4": "System Base Co.",
    "0005B5": "Broadcom Technologies",
    "00058C": "Opentech Inc.",
    "0005CD": "D&M Holdings Inc.",
    "00052E": "Cinta Networks",
    "00052F": "Leviton Network Solutions",
    "00053B": "Harbour Networks Ltd.",
    "000556": "360 Systems",
    "000559": "Intracom S.A.",
    "000551": "F & S Elektronik Systeme GmbH",
    "00054D": "Brans Technologies",
    "000547": "Starent Networks",
    "00054E": "Philips",
    "000546": "KDDI Network & Solultions Inc.",
    "00053C": "XIRCOM",
    "000544": "Valley Technologies",
    "00056B": "C.P. Technology Co.",
    "000560": "LEADER COMM.CO.",
    "00055E": "Cisco Systems",
    "00057F": "Acqis Technology",
    "000573": "Cisco Systems",
    "000575": "CDS-Electronics BV",
    "000522": "LEA*D Corporation",
    "000520": "Smartronix",
    "000518": "Jupiters Technology",
    "00050B": "SICOM Systems",
    "000505": "Systems Integration Solutions",
    "000528": "New Focus",
    "000524": "BTL System (HK) Limited",
    "000514": "KDT Systems Co.",
    "0004C4": "Audiotonix Group Limited",
    "0004B7": "AMB i.t. Holding",
    "0004B9": "S.I. Soubou",
    "0004BB": "Bardac Corporation",
    "0004BC": "Giantec",
    "0004AF": "Digital Fountain",
    "00049D": "Ipanema Technologies",
    "000460": "Knilink Technology",
    "00048F": "TD Systems Corporation",
    "000495": "Tejas Networks India Limited",
    "0004D9": "Titan Electronics",
    "0004D8": "IPWireless",
    "0004D6": "Takagi Industrial Co.",
    "0004D1": "Drew Technologies",
    "0004B2": "ESSEGI SRL",
    "0004B4": "CIAC",
    "0004A9": "SandStream Technologies",
    "00049C": "Surgient Networks",
    "0004EB": "Paxonet Communications",
    "0004EF": "Polestar Corp.",
    "008087": "OKI ELECTRIC INDUSTRY CO.",
    "0004D0": "Softlink s.r.o.",
    "0004BE": "OptXCon",
    "0004C1": "Cisco Systems",
    "00046F": "Digitel S/A Industria Eletronica",
    "000469": "Innocom",
    "000487": "Cogency Semiconductor",
    "000468": "Vivity",
    "0004FE": "Pelago Networks",
    "0003E1": "Winmate Communication",
    "0003E4": "Cisco Systems",
    "0003DC": "Lexar Media",
    "0003D8": "iMPath Networks",
    "0003D5": "Advanced Communications Co.",
    "0003D6": "RADVision",
    "0003D4": "Alloptic",
    "000461": "EPOX Computer Co.",
    "000462": "DAKOS Data & Communication Co.",
    "00045F": "Avalue Technology",
    "000456": "Cambium Networks Limited",
    "000458": "Fusion X Co.",
    "000446": "CYZENTECH Co.",
    "00044A": "iPolicy Networks",
    "000440": "cyberPIXIE",
    "00043C": "SONOS Co.",
    "00042C": "Minet",
    "00042A": "Wireless Networks",
    "000419": "Fibercycle Networks",
    "00041C": "ipDialog",
    "0003CE": "ETEN Technologies",
    "0003C8": "CML Emergency Services",
    "0003F1": "Cicada Semiconductor",
    "0003ED": "Shinkawa Electric Co.",
    "000418": "Teltronic S.A.U.",
    "000370": "NXTV",
    "000402": "Nexsan Technologies",
    "0003F7": "Plast-Control GmbH",
    "0003FC": "Intertex Data AB",
    "0003EF": "Oneline AG",
    "00044F": "Schubert System Elektronik Gmbh",
    "000355": "TeraBeam Internet Systems",
    "000354": "Fiber Logic Communications",
    "000350": "BTICINO SPA",
    "00034E": "Pos Data Company",
    "000348": "Norscan Instruments",
    "000344": "Tietech.Co.",
    "000343": "Martin Professional A/S",
    "0003C3": "Micronik Multimedia",
    "0003C0": "RFTNC Co.",
    "0003BD": "OmniCluster Technologies",
    "0003B8": "NetKit Solutions",
    "0003B7": "ZACCESS Systems",
    "0003B0": "Xsense Technology Corp.",
    "0003AA": "Watlow",
    "0003A8": "IDOT Computers",
    "0003A0": "Cisco Systems",
    "0003A2": "Catapult Communications",
    "00039C": "OptiMight Communications",
    "000365": "Kira Information & Communications",
    "000335": "Mirae Technology",
    "000336": "Zetes Technologies",
    "000337": "Vaone",
    "000369": "Nippon Antenna Co.",
    "000373": "Aselsan A.S",
    "000377": "Gigabit Wireless",
    "000385": "Actelis Networks",
    "0002E6": "Gould Instrument Systems",
    "0002E4": "JC HYUN Systems",
    "0002DE": "Astrodesign",
    "0002E2": "NDC Infared Engineering",
    "0002DC": "Fujitsu General Limited",
    "0002E1": "Integrated Network Corporation",
    "0002D7": "EMPEG Ltd",
    "0002F8": "SEAKR Engineering",
    "0002F7": "ARM",
    "00D024": "Cognex Corporation",
    "0002F1": "Pinetron Co.",
    "0002ED": "DXO Telecom Co.",
    "0002EC": "Maschoff Design Engineering",
    "000299": "Apex",
    "000298": "Broadframe Corporation",
    "000297": "C-COR.net",
    "000291": "Open Network Co.",
    "0002C6": "Data Track Technology PLC",
    "0002C1": "Innovative Electronic Designs",
    "0002C0": "Bencent Tzeng Industry Co.",
    "0002D3": "NetBotz",
    "0002DA": "ExiO Communications",
    "0002D4": "PDA Peripherals",
    "0002D6": "NICE Systems",
    "00028B": "VDSL Systems OY",
    "00028C": "Micrel-Synergy Semiconductor",
    "00028D": "Movita Technologies",
    "00B052": "Atheros Communications",
    "000314": "Teleware Network Systems",
    "00033B": "TAMI Tech Co.",
    "00032D": "IBASE Technology",
    "00032F": "Global Sun Technology",
    "0002A6": "Effinet Systems Co.",
    "00025C": "SCI Systems (Kunshan) Co.",
    "000087": "HITACHI",
    "000258": "Flying Packets Communications",
    "000255": "IBM Corp",
    "000252": "Carrier Corporation",
    "000207": "VisionGlobal Network Corp.",
    "000208": "Unify Networks",
    "000204": "Bodmann Industries Elektronik GmbH",
    "00020D": "Micronpc.com",
    "000211": "Nature Worldwide Technology Corp.",
    "000212": "SierraCom",
    "000217": "Cisco Systems",
    "00022D": "Agere Systems",
    "000226": "XESystems",
    "000225": "One Stop Systems",
    "000220": "CANON FINETECH INC.",
    "00024E": "Datacard Group",
    "000242": "Videoframe Systems",
    "000244": "SURECOM Technology Co.",
    "00023E": "Selta Telematica S.p.a",
    "000241": "Amer.com",
    "00027D": "Cisco Systems",
    "00027C": "Trilithic",
    "000275": "SMART Technologies",
    "0001F9": "TeraGlobal Communications Corp.",
    "0001FB": "DoTop Technology",
    "0001F8": "TEXIO TECHNOLOGY CORPORATION",
    "0001E8": "Force10 Networks",
    "00017A": "Chengdu Maipu Electric Industrial Co.",
    "000238": "Serome Technology",
    "000229": "Adtec Corporation",
    "000269": "Nadatel Co.",
    "000264": "AudioRamp.com",
    "00025F": "Nortel Networks",
    "0001E9": "Litton Marine Systems B.V.",
    "0001E5": "Supernet",
    "0001D4": "Leisure Time",
    "0001DD": "Avail Networks",
    "0001D5": "HAEDONG INFO & COMM CO.",
    "0001D7": "F5 Networks",
    "0001DE": "Trango Systems",
    "0001DC": "Activetelco",
    "00010A": "CIS TECHNOLOGY INC.",
    "000162": "Cygnet Technologies",
    "000167": "HIOKI E.E. CORPORATION",
    "000168": "VITANA CORPORATION",
    "00015F": "DIGITAL DESIGN GmbH",
    "000164": "Cisco Systems",
    "0001BF": "Teleforce Co.",
    "0001B4": "Wayport",
    "0001BA": "IC-Net",
    "0001B0": "Fulltek Technology Co.",
    "0001A9": "BMW AG",
    "0001AA": "Airspan Communications",
    "0001CF": "Alpha Data Parallel Systems",
    "0001D0": "VitalPoint",
    "0001C7": "Cisco Systems",
    "000154": "G3M Corporation",
    "000152": "CHROMATEK INC.",
    "000150": "GILAT COMMUNICATIONS",
    "000151": "Ensemble Communications",
    "00019E": "ESS Technology",
    "00017D": "ThermoQuest",
    "000181": "Nortel Networks",
    "000194": "Capital Equipment Corporation",
    "000198": "Darim Vision",
    "0001BE": "Gigalink Co.",
    "0001B1": "General Bandwidth",
    "000185": "Hitachi Aloka Medical",
    "0001A2": "Logical Co.",
    "00B02D": "ViaGate Technologies",
    "0030EE": "DSG Technology",
    "00309E": "WORKBIT CORPORATION.",
    "0030DE": "WAGO Kontakttechnik GmbH",
    "00303E": "Radcom Ltd.",
    "0030D7": "Innovative Systems",
    "00307B": "Cisco Systems",
    "003088": "Ericsson",
    "0030B5": "Tadiran Microwave Networks",
    "003020": "TSI",
    "00B04A": "Cisco Systems",
    "00B048": "Marconi Communications Inc.",
    "00B0CE": "Viveris Technologies",
    "00B01C": "Westport Technologies",
    "000119": "RTUnet (Australia)",
    "000122": "Trend Communications",
    "00011A": "Hoffmann und Burmeister GbR",
    "000124": "Acer Incorporated",
    "000142": "Cisco Systems",
    "00012C": "Aravox Technologies",
    "000121": "WatchGuard Technologies",
    "000129": "DFI Inc.",
    "000115": "EXTRATECH CORPORATION",
    "000101": "Private",
    "00010D": "Teledyne DALSA Inc.",
    "000105": "Beckhoff Automation GmbH",
    "00B017": "InfoGear Technology Corp.",
    "00012B": "TELENET Co.",
    "00013F": "Neighbor World Co.",
    "00301B": "SHUTTLE",
    "00303A": "MAATEL",
    "00302C": "SYLANTRO SYSTEMS CORPORATION",
    "0030DF": "KB/TEL TELECOMUNICACIONES",
    "00304E": "BUSTEC PRODUCTION LTD.",
    "003063": "SANTERA SYSTEMS",
    "003030": "HARMONIX CORPORATION",
    "0030A3": "Cisco Systems",
    "0030FD": "INTEGRATED SYSTEMS DESIGN",
    "0030B9": "ECTEL",
    "00307D": "GRE AMERICA",
    "0030DD": "INDIGITA CORPORATION",
    "003099": "BOENIG UND KALLENBACH OHG",
    "0030F2": "Cisco Systems",
    "003051": "ORBIT AVIONIC & COMMUNICATION",
    "003008": "AVIO DIGITAL",
    "00301D": "SKYSTREAM",
    "0030A4": "Woodwind Communications System",
    "00303B": "PowerCom Technology",
    "0030BC": "Optronic AG",
    "0030B8": "RiverDelta Networks",
    "003071": "Cisco Systems",
    "003021": "HSING TECH. ENTERPRISE CO.",
    "0030EF": "NEON TECHNOLOGY",
    "003027": "KERBANGO",
    "003033": "ORIENT TELECOM CO.",
    "003095": "Procomp Informatics",
    "0030CA": "Discovery Com",
    "0030CE": "Zaffire",
    "0030BA": "AC&T SYSTEM CO.",
    "003096": "Cisco Systems",
    "003039": "SOFTBOOK PRESS",
    "00D097": "Cisco Systems",
    "00D08E": "Grass Valley",
    "00D056": "SOMAT CORPORATION",
    "00D0E0": "DOOIN ELECTRONICS CO.",
    "00D033": "DALIAN DAXIAN NETWORK",
    "00D0D6": "AETHRA TELECOMUNICAZIONI",
    "00D063": "Cisco Systems",
    "00D0F8": "FUJIAN STAR TERMINAL",
    "00D0ED": "XIOX",
    "00D055": "KATHREIN-WERKE KG",
    "00D03B": "VISION PRODUCTS PTY. LTD.",
    "00D0B3": "DRS Technologies Canada Ltd",
    "00D000": "FERRAN SCIENTIFIC",
    "00D0D0": "ZHONGXING TELECOM LTD.",
    "00D053": "CONNECTED SYSTEMS",
    "00D0B0": "BITSWITCH LTD.",
    "00D030": "Safetran Systems Corp",
    "00D047": "XN TECHNOLOGIES",
    "00D0AF": "CUTLER-HAMMER",
    "00D052": "ASCEND COMMUNICATIONS",
    "00D0AD": "TL INDUSTRIES",
    "00D0A4": "ALANTRO COMMUNICATIONS",
    "00302A": "SOUTHERN INFORMATION",
    "0030E1": "Network Equipment Technologies",
    "00D083": "INVERTEX",
    "00D0BA": "Cisco Systems",
    "00D0E4": "Cisco Systems",
    "00D092": "GLENAYRE WESTERN MULTIPLEX",
    "003001": "SMP",
    "00D08B": "ADVA Optical Networking Ltd.",
    "00D05A": "SYMBIONICS",
    "00D079": "Cisco Systems",
    "00D021": "REGENT ELECTRONICS CORP.",
    "00D09F": "NOVTEK TEST SYSTEMS",
    "00D009": "HSING TECH. ENTERPRISE CO. LTD",
    "00D0D4": "V-BITS",
    "00D0E7": "VCON TELECOMMUNICATION LTD.",
    "00D084": "NEXCOMM SYSTEMS",
    "00D099": "Elcard Wireless Systems Oy",
    "00D0FE": "ASTRAL POINT",
    "00D098": "Photon Dynamics Canada Inc.",
    "00D0BE": "EMUTEC INC.",
    "00D0F4": "CARINTHIAN TECH INSTITUTE",
    "00D07D": "COSINE COMMUNICATIONS",
    "00D01B": "MIMAKI ENGINEERING CO.",
    "00D00D": "MICROMERITICS INSTRUMENT",
    "00D04A": "PRESENCE TECHNOLOGY GMBH",
    "00D074": "TAQUA SYSTEMS",
    "00D0C7": "PATHWAY",
    "00D07A": "AMAQUEST COMPUTER CORP.",
    "00D0B8": "Iomega Corporation",
    "00509D": "THE INDUSTREE B.V.",
    "00506D": "VIDEOJET SYSTEMS",
    "005074": "ADVANCED HI-TECH CORP.",
    "00500A": "IRIS TECHNOLOGIES",
    "00D054": "SAS INSTITUTE INC.",
    "005070": "CHAINTECH COMPUTER CO.",
    "005023": "PG DESIGN ELECTRONICS",
    "0050B1": "GIDDINGS & LEWIS",
    "00509E": "Les Technologies SoftAcoustik Inc.",
    "005071": "AIWA CO.",
    "00505F": "BRAND INNOVATORS",
    "0050B4": "SATCHWELL CONTROL SYSTEMS",
    "00506A": "EDEVA",
    "0050C5": "ADS Technologies",
    "00508E": "OPTIMATION",
    "005028": "AVAL COMMUNICATIONS",
    "00502F": "TollBridge Technologies",
    "0050AA": "KONICA MINOLTA HOLDINGS",
    "005038": "DAIN TELECOM CO.",
    "0050A8": "OpenCon Systems",
    "00509C": "BETA RESEARCH",
    "0050D6": "ATLAS COPCO TOOLS AB",
    "005082": "FORESSON CORPORATION",
    "0050DF": "AirFiber",
    "005037": "KOGA ELECTRONICS CO.",
    "005006": "TAC AB",
    "005009": "PHILIPS BROADBAND NETWORKS",
    "005030": "FUTURE PLUS SYSTEMS",
    "005058": "Sangoma Technologies",
    "0050FE": "PCTVnet ASA",
    "0050AB": "NALTEC",
    "005032": "PICAZO COMMUNICATIONS",
    "0050B7": "BOSER TECHNOLOGY CO.",
    "005078": "MEGATON HOUSE",
    "005002": "OMNISEC AG",
    "00503F": "ANCHOR GAMES",
    "0090E6": "ALi Corporation",
    "009070": "NEO NETWORKS",
    "009030": "HONEYWELL-DATING",
    "009008": "HanA Systems Inc.",
    "009088": "BAXALL SECURITY LTD.",
    "00906C": "Sartorius Hamburg GmbH",
    "0090A4": "ALTIGA NETWORKS",
    "0050D0": "MINERVA SYSTEMS",
    "0050D8": "UNICORN COMPUTER CORP.",
    "0050B2": "BRODEL GmbH",
    "009076": "FMT AIRCRAFT GATE SUPPORT SYSTEMS AB",
    "009017": "Zypcom",
    "009049": "ENTRIDIA CORPORATION",
    "00909A": "ONE WORLD SYSTEMS",
    "0090C2": "JK microsystems",
    "0090AC": "OPTIVISION",
    "00904E": "DELEM BV",
    "0090ED": "CENTRAL SYSTEM RESEARCH CO.",
    "009080": "NOT LIMITED",
    "0090E8": "MOXA TECHNOLOGIES CORP.",
    "0090A1": "Flying Pig Systems/High End Systems Inc.",
    "009079": "ClearOne",
    "0090F9": "Imagine Communications",
    "009089": "SOFTCOM MICROSYSTEMS",
    "0090EE": "PERSONAL COMMUNICATIONS TECHNOLOGIES",
    "009001": "NISHIMU ELECTRONICS INDUSTRIES CO.",
    "0090AD": "ASPECT ELECTRONICS",
    "00901E": "Selesta Ingegneria S.p.A.",
    "009075": "NEC DO BRASIL S.A.",
    "0090C8": "WAVERIDER COMMUNICATIONS (CANADA) INC.",
    "00901B": "DIGITAL CONTROLS",
    "009043": "Tattile SRL",
    "001069": "HELIOSS COMMUNICATIONS",
    "0010BF": "InterAir Wireless",
    "001036": "INTER-TEL INTEGRATED SYSTEMS",
    "001026": "ACCELERATED NETWORKS",
    "0010AC": "IMCI TECHNOLOGIES",
    "0090F7": "NBASE COMMUNICATIONS LTD.",
    "009012": "GLOBESPAN SEMICONDUCTOR",
    "00908A": "BAYLY COMMUNICATIONS",
    "00900E": "HANDLINK TECHNOLOGIES",
    "0090E4": "NEC AMERICA",
    "00107D": "AURORA COMMUNICATIONS",
    "001039": "Vectron Systems AG",
    "0010B6": "ENTRATA COMMUNICATIONS CORP.",
    "0010EC": "Embedded Planet",
    "001059": "DIABLO RESEARCH CO. LLC",
    "001023": "Network Equipment Technologies",
    "00102B": "UMAX DATA SYSTEMS",
    "00108D": "Johnson Controls",
    "001045": "Nortel Networks",
    "009047": "GIGA FAST E. LTD.",
    "0090E1": "TELENA S.P.A.",
    "0090CB": "Wireless OnLine",
    "001063": "STARGUIDE DIGITAL NETWORKS",
    "0010FC": "BROADBAND NETWORKS",
    "001031": "OBJECTIVE COMMUNICATIONS",
    "00106D": "Axxcelera Broadband Wireless",
    "0090C1": "Peco II",
    "009040": "Siemens Network Convergence LLC",
    "0090B7": "DIGITAL LIGHTWAVE",
    "0090A0": "8X8 INC.",
    "009032": "PELCOMBE GROUP LTD.",
    "001030": "EION Inc.",
    "001062": "NX SERVER",
    "0010F0": "RITTAL-WERK RUDOLF LOH GmbH & Co.",
    "001001": "Citel",
    "00105C": "QUANTUM DESIGNS (H.K.) LTD.",
    "0010CF": "FIBERLANE COMMUNICATIONS",
    "0010A4": "XIRCOM",
    "001075": "Segate Technology LLC",
    "0010B1": "FOR-A CO.",
    "0010EE": "CTI PRODUCTS",
    "001041": "BRISTOL BABCOCK",
    "0010AA": "MEDIA4",
    "0010E8": "TELOCITY",
    "0010A2": "TNS",
    "001000": "CABLE TELEVISION LABORATORIES",
    "001009": "HORANET",
    "0010F8": "TEXIO TECHNOLOGY CORPORATION",
    "001066": "ADVANCED CONTROL SYSTEMS",
    "00104C": "Teledyne LeCroy",
    "0010CC": "CLP COMPUTER LOGISTIK PLANUNG GmbH",
    "001057": "Rebel.com",
    "001065": "RADYNE CORPORATION",
    "00101D": "WINBOND ELECTRONICS CORP.",
    "001002": "ACTIA",
    "00105B": "NET INSIGHT AB",
    "0010EB": "SELSIUS SYSTEMS",
    "00109F": "PAVO",
    "001084": "K-BOT COMMUNICATIONS",
    "0010F9": "UNIQUE SYSTEMS",
    "0010D0": "WITCOM",
    "001093": "CMS COMPUTERS",
    "00108F": "RAPTOR SYSTEMS",
    "0010F1": "I-O CORPORATION",
    "0010C0": "ARMA",
    "00E008": "AMAZING CONTROLS! INC.",
    "00E0AE": "XAQTI CORPORATION",
    "00E0E0": "SI ELECTRONICS",
    "00E0C8": "VIRTUAL ACCESS",
    "00E006": "SILICON INTEGRATED SYS. CORP.",
    "00E0AC": "MIDSCO",
    "00E095": "ADVANCED-VISION TECHNOLGIES CORP.",
    "00E00E": "AVALON IMAGING SYSTEMS",
    "08BBCC": "AK-NORD EDV VERTRIEBSGES. mbH",
    "00E003": "NOKIA WIRELESS BUSINESS COMMUN",
    "00E048": "SDL COMMUNICATIONS",
    "00E0CB": "RESON",
    "00E0FA": "TRL TECHNOLOGY",
    "00E02C": "AST COMPUTER",
    "00E067": "eac AUTOMATION-CONSULTING GmbH",
    "00E09F": "PIXEL VISION",
    "00E0DB": "ViaVideo Communications",
    "00E0A6": "TELOGY NETWORKS",
    "00E0F3": "WebSprint Communications",
    "00E0CC": "HERO SYSTEMS",
    "00E080": "CONTROL RESOURCES CORPORATION",
    "00E004": "PMC-SIERRA",
    "00E03B": "PROMINET CORPORATION",
    "00E0F5": "TELES AG",
    "00E0D7": "SUNSHINE ELECTRONICS",
    "00E0B5": "ARDENT COMMUNICATIONS CORP.",
    "00E0F1": "THAT CORPORATION",
    "00E0AF": "GENERAL DYNAMICS INFORMATION SYSTEMS",
    "00E054": "KODAI HITEC CO.",
    "00E0B9": "BYAS SYSTEMS",
    "00604B": "Safe-com GmbH & Co. KG",
    "00606B": "Synclayer Inc.",
    "00603B": "AMTEC spa",
    "00E02A": "TANDBERG TELEVISION AS",
    "00E04E": "SANYO DENKI CO.",
    "00E012": "PLUTO TECHNOLOGIES INTERNATIONAL INC.",
    "00E04C": "REALTEK SEMICONDUCTOR CORP.",
    "00E0EF": "DIONEX",
    "00E051": "TALX CORPORATION",
    "00E039": "PARADYNE CORP.",
    "00600B": "LOGWARE GmbH",
    "00603F": "PATAPSCO DESIGNS",
    "00E02D": "InnoMediaLogic",
    "00E035": "Artesyn Embedded Technologies",
    "00E090": "BECKMAN LAB. AUTOMATION DIV.",
    "00E085": "GLOBAL MAINTECH",
    "00E0BE": "GENROCO INTERNATIONAL",
    "006001": "InnoSys",
    "0060FE": "LYNX SYSTEM DEVELOPERS",
    "0060BD": "Enginuity Communications",
    "000800": "MULTITECH SYSTEMS",
    "00E068": "MERRIMAC SYSTEMS INC.",
    "00E049": "MICROWI ELECTRONIC GmbH",
    "00E050": "EXECUTONE INFORMATION SYSTEMS",
    "00E023": "TELRAD",
    "00E0B6": "Entrada Networks",
    "00E0F4": "INSIDE Technology A/S",
    "00E0A0": "WILTRON CO.",
    "00E0C7": "EUROTECH SRL",
    "0060B5": "KEBA GmbH",
    "006042": "TKS (USA)",
    "006079": "Mainstream Data",
    "00609A": "NJK TECHNO CO.",
    "00602B": "PEAK AUDIO",
    "0060F1": "EXP COMPUTER",
    "0005A8": "WYLE ELECTRONICS",
    "0060E6": "SHOMITI SYSTEMS INCORPORATED",
    "0060FF": "QuVis",
    "006067": "ACER NETXUS INC.",
    "00609F": "PHAST CORPORATION",
    "006040": "NETRO CORP.",
    "0060CC": "EMTRAK",
    "00602C": "LINX Data Terminals",
    "0060AC": "RESILIENCE CORPORATION",
    "00604E": "CYCLE COMPUTER CORPORATION",
    "0060AA": "INTELLIGENT DEVICES INC. (IDI)",
    "006065": "B&R Industrial Automation GmbH",
    "00605D": "SCANIVALVE CORP.",
    "00606F": "CLARION CORPORATION OF AMERICA",
    "006014": "EDEC CO.",
    "0060E1": "ORCKIT COMMUNICATIONS LTD.",
    "0060D2": "LUCENT TECHNOLOGIES TAIWAN TELECOMMUNICATIONS CO.",
    "0060CD": "VideoServer",
    "00607E": "GIGALABS",
    "006090": "Artiza Networks Inc",
    "006030": "VILLAGE TRONIC ENTWICKLUNG",
    "006025": "ACTIVE IMAGING PLC",
    "0060A7": "MICROSENS GmbH & CO. KG",
    "0060E5": "FUJI AUTOMATION CO.",
    "00605E": "LIBERTY TECHNOLOGY NETWORKING",
    "00A09C": "Xyplex",
    "00A00D": "THE PANDA PROJECT",
    "00A0E9": "ELECTRONIC RETAILING SYSTEMS INTERNATIONAL",
    "00A0BE": "INTEGRATED CIRCUIT SYSTEMS",
    "00A010": "SYSLOGIC DATENTECHNIK AG",
    "00A016": "MICROPOLIS CORP.",
    "00A059": "HAMILTON HALLMARK",
    "00A039": "ROSS TECHNOLOGY",
    "00A0AD": "MARCONI SPA",
    "00A0D6": "SBE",
    "0060C6": "DCS AG",
    "00601E": "SOFTLAB",
    "00600D": "Digital Logic GmbH",
    "00604A": "SAIC IDEAS GROUP",
    "00A0BD": "I-TECH CORP.",
    "00A048": "QUESTECH",
    "00A0FC": "IMAGE SCIENCES",
    "00A02E": "BRAND COMMUNICATIONS",
    "00A0F9": "BINTEC COMMUNICATIONS GMBH",
    "00A04D": "EDA INSTRUMENTS",
    "00A086": "AMBER WAVE SYSTEMS",
    "00A0AF": "WMS INDUSTRIES",
    "00A057": "LANCOM Systems GmbH",
    "00A09F": "COMMVISION CORP.",
    "00A0B6": "SANRITZ AUTOMATION CO.",
    "00A079": "ALPS ELECTRIC (USA)",
    "00A0F5": "RADGUARD LTD.",
    "00A0CA": "FUJITSU DENSO LTD.",
    "00A022": "CENTRE FOR DEVELOPMENT OF ADVANCED COMPUTING",
    "00A0C0": "DIGITAL LINK CORP.",
    "00A09D": "JOHNATHON FREEMAN TECHNOLOGIES",
    "00A06E": "AUSTRON",
    "00A0BA": "PATTON ELECTRONICS CO.",
    "00A0B5": "3H TECHNOLOGY",
    "00A01E": "EST CORPORATION",
    "00A062": "AES PRODATA",
    "00A0AE": "NUCOM SYSTEMS",
    "00A076": "CARDWARE LAB",
    "00A003": "Siemens Switzerland Ltd.",
    "00A08D": "JACOMO CORPORATION",
    "00A08E": "Check Point Software Technologies",
    "00A0A1": "EPIC DATA INC.",
    "00A044": "NTT IT CO.",
    "00A011": "MUTOH INDUSTRIES LTD.",
    "00A084": "Dataplex Pty Ltd",
    "00A049": "DIGITECH INDUSTRIES",
    "00A06B": "DMS DORSCH MIKROSYSTEM GMBH",
    "00A030": "CAPTOR NV/SA",
    "00A0DE": "YAMAHA CORPORATION",
    "000267": "NODE RUNNER",
    "0020B1": "COMTECH RESEARCH INC.",
    "002032": "ALCATEL TAISEL",
    "0020E9": "DANTEL",
    "002022": "NMS Communications",
    "0020AE": "ORNET DATA COMMUNICATION TECH.",
    "0020AA": "Ericsson Television Limited",
    "0020A4": "MULTIPOINT NETWORKS",
    "002051": "Verilink Corporation",
    "00203B": "WISDM LTD.",
    "0020BA": "CENTER FOR HIGH PERFORMANCE",
    "002038": "VME MICROSYSTEMS INTERNATIONAL CORPORATION",
    "0020A3": "Harmonic",
    "002059": "MIRO COMPUTER PRODUCTS AG",
    "002079": "MIKRON GMBH",
    "002005": "SIMPLE TECHNOLOGY",
    "0020FA": "GDE SYSTEMS",
    "00A0F8": "Zebra Technologies Inc",
    "002080": "SYNERGY (UK) LTD.",
    "002018": "CIS TECHNOLOGY INC.",
    "002098": "HECTRONIC AB",
    "0020FD": "ITV TECHNOLOGIES",
    "002034": "ROTEC INDUSTRIEAUTOMATION GMBH",
    "00200C": "ADASTRA SYSTEMS CORP.",
    "002011": "CANOPUS CO.",
    "00C023": "TUTANKHAMON ELECTRONICS",
    "00C08B": "RISQ MODULAR SYSTEMS",
    "0020C4": "INET",
    "00206D": "DATA RACE",
    "00203A": "DIGITAL BI0METRICS INC.",
    "00200E": "NSSLGlobal Technologies AS",
    "00C0B4": "MYSON TECHNOLOGY",
    "00C080": "NETSTAR",
    "00C0C3": "ACUSON COMPUTED SONOGRAPHY",
    "00C0B3": "COMSTAT DATACOMM CORPORATION",
    "00C0E5": "GESPAC",
    "00C04D": "MITEC",
    "002068": "ISDYNE",
    "0020C8": "LARSCOM INCORPORATED",
    "00209D": "LIPPERT AUTOMATIONSTECHNIK",
    "00209C": "PRIMARY ACCESS CORP.",
    "0020E7": "B&W NUCLEAR SERVICE COMPANY",
    "0020F0": "UNIVERSAL MICROELECTRONICS CO.",
    "002089": "T3PLUS NETWORKING",
    "0020F5": "PANDATEL AG",
    "002074": "SUNGWOON SYSTEMS",
    "00203C": "EUROTIME AB",
    "002028": "WEST EGG SYSTEMS",
    "002061": "GarrettCom",
    "0020DC": "DENSITRON TAIWAN LTD.",
    "002048": "Marconi Communications",
    "00C00D": "ADVANCED LOGIC RESEARCH",
    "00C081": "METRODATA LTD.",
    "00C03B": "MULTIACCESS COMPUTING CORP.",
    "00C082": "MOORE PRODUCTS CO.",
    "00C099": "YOSHIKI INDUSTRIAL CO.",
    "00C045": "ISOLATION SYSTEMS",
    "0070B3": "DATA RECALL LTD.",
    "00E6D3": "NIXDORF COMPUTER CORP.",
    "0070B0": "M/A-COM INC. COMPANIES",
    "00C01F": "S.E.R.C.E.L.",
    "00C0A1": "TOKYO DENSHI SEKEI CO.",
    "00C02E": "NETWIZ",
    "00C047": "UNIMICRO SYSTEMS",
    "00C084": "DATA LINK CORP. LTD.",
    "00C041": "DIGITAL TRANSMISSION SYSTEMS",
    "00C0B6": "HVE",
    "00C07A": "PRIVA B.V.",
    "00C06D": "BOCA RESEARCH",
    "00C0EA": "ARRAY TECHNOLOGY LTD.",
    "00C009": "KT TECHNOLOGY (S) PTE LTD",
    "006086": "LOGIC REPLACEMENT TECH. LTD.",
    "00C059": "DENSO CORPORATION",
    "00C0F1": "SHINKO ELECTRIC CO.",
    "00C0DC": "EOS TECHNOLOGIES",
    "00C03C": "TOWER TECH S.R.L.",
    "00C01D": "GRAND JUNCTION NETWORKS",
    "00C072": "KNX LTD.",
    "00C0AE": "TOWERCOM CO. INC. DBA PC HOUSE",
    "00C0D6": "J1 SYSTEMS",
    "00C0F6": "CELAN TECHNOLOGY INC.",
    "00C0C2": "INFINITE NETWORKS LTD.",
    "00C0AF": "TEKLOGIX INC.",
    "00C070": "SECTRA SECURE-TRANSMISSION AB",
    "00C007": "PINNACLE DATA SYSTEMS",
    "00C0F8": "ABOUT COMPUTING INC.",
    "00C078": "COMPUTER SYSTEMS ENGINEERING",
    "00C09A": "PHOTONICS CORPORATION",
    "00C01A": "COROMETRICS MEDICAL SYSTEMS",
    "00C068": "HME Clear-Com LTD.",
    "00C0D8": "UNIVERSAL DATA SYSTEMS",
    "004036": "Minim Inc.",
    "004016": "ADC - Global Connectivity Solutions Division",
    "00406A": "KENTEK INFORMATION SYSTEMS",
    "00400A": "PIVOTAL TECHNOLOGIES",
    "004082": "LABORATORY EQUIPMENT CORP.",
    "00C001": "DIATEK PATIENT MANAGMENT",
    "00C0F4": "INTERLINK SYSTEM CO.",
    "00C0E2": "CALCOMP",
    "00C07B": "ASCEND COMMUNICATIONS",
    "00C098": "CHUNTEX ELECTRONIC CO.",
    "0040A8": "IMF INTERNATIONAL LTD.",
    "004070": "INTERWARE CO.",
    "00803B": "APT COMMUNICATIONS",
    "00806A": "ERI (EMPAC RESEARCH INC.)",
    "00C0A8": "GVC CORPORATION",
    "004099": "NEWGEN SYSTEMS CORP.",
    "004011": "ANDOVER CONTROLS CORPORATION",
    "0040A1": "ERGO COMPUTING",
    "004081": "MANNESMANN SCANGRAPHIC GMBH",
    "00C0F7": "ENGAGE COMMUNICATION",
    "00C08C": "PERFORMANCE TECHNOLOGIES",
    "00C0BE": "ALCATEL - SEL",
    "00C06E": "HAFT TECHNOLOGY",
    "00C08A": "Lauterbach GmbH",
    "0040B7": "STEALTH COMPUTER SYSTEMS",
    "0040AC": "SUPER WORKSTATION",
    "10005A": "IBM Corp",
    "0040F1": "CHUO ELECTRONICS CO.",
    "0040A9": "DATACOM INC.",
    "0040E3": "QUIN SYSTEMS LTD",
    "004091": "PROCOMP INDUSTRIA ELETRONICA",
    "0040E0": "ATOMWIDE LTD.",
    "0040D1": "FUKUDA DENSHI CO.",
    "004069": "LEMCOM SYSTEMS",
    "00403B": "SYNERJET INTERNATIONAL CORP.",
    "00408A": "TPS TELEPROCESSING SYS. GMBH",
    "0040FD": "LXE",
    "004043": "Nokia Siemens Networks GmbH & Co. KG.",
    "0040EA": "PLAIN TREE SYSTEMS INC",
    "004014": "COMSOFT GMBH",
    "004000": "PCI COMPONENTES DA AMZONIA LTD",
    "0040FA": "MICROBOARDS",
    "00403F": "SSANGYONG COMPUTER SYSTEMS",
    "008038": "DATA RESEARCH & APPLICATIONS",
    "00805E": "LSI LOGIC CORPORATION",
    "008060": "NETWORK INTERFACE CORPORATION",
    "0080C3": "BICC INFORMATION SYSTEMS & SVC",
    "008044": "SYSTECH COMPUTER CORP.",
    "008006": "COMPUADD CORPORATION",
    "008028": "TRADPOST (HK) LTD",
    "008061": "LITTON SYSTEMS",
    "0080F5": "Quantel Ltd",
    "0080B9": "ARCHE TECHNOLIGIES INC.",
    "0080A7": "Honeywell International Inc",
    "00406C": "COPERNIQUE",
    "004075": "Tattile SRL",
    "004053": "AMPRO COMPUTERS",
    "00405E": "NORTH HILLS ISRAEL",
    "0040A7": "ITAUTEC PHILCO S.A.",
    "004064": "KLA INSTRUMENTS CORPORATION",
    "00405A": "GOLDSTAR INFORMATION & COMM.",
    "004013": "NTT DATA COMM. SYSTEMS CORP.",
    "00400C": "GENERAL MICRO SYSTEMS",
    "004063": "VIA TECHNOLOGIES",
    "00809B": "JUSTSYSTEM CORPORATION",
    "00808A": "SUMMIT MICROSYSTEMS CORP.",
    "008049": "NISSIN ELECTRIC CO.",
    "0080C1": "LANEX CORPORATION",
    "0080BC": "HITACHI ENGINEERING CO.",
    "00807C": "FIBERCOM",
    "008091": "TOKYO ELECTRIC CO.",
    "0080D4": "CHASE RESEARCH LTD.",
    "00803D": "SURIGIKEN CO.",
    "00808B": "DACOLL LIMITED",
    "0080CB": "FALCO DATA PRODUCTS",
    "00801E": "XINETRON",
    "0080E2": "T.D.I. CO.",
    "008036": "REFLEX MANUFACTURING SYSTEMS",
    "008083": "AMDAHL",
    "00804D": "CYCLONE MICROSYSTEMS",
    "00800B": "CSK CORPORATION",
    "008007": "DLOG NC-SYSTEME",
    "008062": "INTERFACE  CO.",
    "0080B2": "NETWORK EQUIPMENT TECHNOLOGIES",
    "008076": "MCNC",
    "00809D": "Commscraft Ltd.",
    "0080F4": "TELEMECANIQUE ELECTRIQUE",
    "0080DF": "ADC CODENOLL TECHNOLOGY CORP.",
    "008022": "SCAN-OPTICS",
    "0000CD": "Allied Telesis Labs Ltd",
    "008018": "KOBE STEEL",
    "0000B2": "TELEVIDEO SYSTEMS",
    "0000EE": "NETWORK DESIGNERS",
    "0000E5": "SIGMEX LTD.",
    "000089": "CAYMAN SYSTEMS INC.",
    "0000FF": "CAMTEC ELECTRONICS LTD.",
    "0000B7": "DOVE COMPUTER CORPORATION",
    "0000F2": "SPIDER COMMUNICATIONS",
    "008068": "YAMATECH SCIENTIFIC LTD.",
    "0080A8": "VITACOM CORPORATION",
    "008033": "EMS Aviation",
    "0080DD": "GMX INC/GIMIX",
    "0000DC": "HAYES MICROCOMPUTER PRODUCTS",
    "000063": "BARCO CONTROL ROOMS GMBH",
    "00004E": "AMPEX CORPORATION",
    "0000C2": "INFORMATION PRESENTATION TECH.",
    "0000FC": "MEIKO",
    "0000DB": "British Telecommunications plc",
    "0000C1": "Madge Ltd.",
    "0000F6": "APPLIED MICROSYSTEMS CORP.",
    "0080B4": "SOPHIA SYSTEMS",
    "00807F": "DY-4 INCORPORATED",
    "0000BD": "RYOSEI",
    "00002E": "SOCIETE EVIRA",
    "00003F": "SYNTREX",
    "00008E": "SOLBOURNE COMPUTER",
    "0080FB": "BVM LIMITED",
    "00802D": "XYLOGICS INC",
    "00006D": "CRAY COMMUNICATIONS",
    "0000DA": "ATEX",
    "0000CC": "DENSAN CO.",
    "0000A0": "SANYO Electric Co.",
    "0000C0": "WESTERN DIGITAL CORPORATION",
    "000033": "EGAN MACHINERY COMPANY",
    "00009D": "LOCUS COMPUTING CORPORATION",
    "0000FD": "HIGH LEVEL HARDWARE",
    "0000A4": "ACORN COMPUTERS LIMITED",
    "0000DD": "TCL INCORPORATED",
    "0000AE": "DASSAULT ELECTRONIQUE",
    "000065": "Network General Corporation",
    "000011": "NORMEREL SYSTEMES",
    "000061": "GATEWAY COMMUNICATIONS",
    "0000EA": "UPNOD AB",
    "000043": "MICRO TECHNOLOGY",
    "000017": "Oracle",
    "000077": "INTERPHASE CORPORATION",
    "0000A2": "Bay Networks",
    "0000EC": "MICROPROCESS",
    "000010": "SYTEK INC.",
    "0000C4": "WATERS DIV. OF MILLIPORE",
    "0000EB": "MATSUSHITA COMM. IND. CO. LTD.",
    "000099": "MTX",
    "000028": "PRODIGY SYSTEMS CORPORATION",
    "080043": "PIXEL COMPUTER INC.",
    "080045": "CONCURRENT COMPUTER CORP.",
    "08003B": "TORUS SYSTEMS LIMITED",
    "08003C": "SCHLUMBERGER WELL SERVICES",
    "080034": "FILENET CORPORATION",
    "080036": "INTERGRAPH CORPORATION",
    "080033": "BAUSCH & LOMB",
    "08002B": "DIGITAL EQUIPMENT CORPORATION",
    "080029": "Megatek Corporation",
    "080023": "Panasonic Communications Co.",
    "08007E": "AMALGAMATED WIRELESS(AUS) LTD",
    "08007F": "CARNEGIE-MELLON UNIVERSITY",
    "080048": "EUROTHERM GAUGING SYSTEMS",
    "080030": "CERN",
    "080031": "LITTLE MACHINES INC.",
    "08002E": "METAPHOR COMPUTER SYSTEMS",
    "080056": "STANFORD LINEAR ACCEL. CENTER",
    "08004F": "CYGNET SYSTEMS",
    "080050": "DAISY SYSTEMS CORP.",
    "08006D": "WHITECHAPEL COMPUTER WORKS",
    "08005E": "COUNTERPOINT COMPUTER INC.",
    "080075": "DANSK DATA ELECTRONIK",
    "080078": "ACCELL CORPORATION",
    "08000F": "MITEL CORPORATION",
    "0270B0": "M/A-COM INC. COMPANIES",
    "000053": "COMPUCORP",
    "08000A": "NESTAR SYSTEMS INCORPORATED",
    "080090": "SONOMA SYSTEMS",
    "00800F": "STANDARD MICROSYSTEMS",
    "00406B": "SYSGEN",
    "000004": "XEROX CORPORATION",
    "00DD0E": "UNGERMANN-BASS INC.",
    "080018": "PIRELLI FOCOM NETWORKS",
    "0000A6": "NETWORK GENERAL CORPORATION",
    "00BBF0": "UNGERMANN-BASS INC.",
    "00408E": "Tattile SRL",
    "08001C": "KDD-KOKUSAI DEBNSIN DENWA CO.",
    "F0A731": "TP-Link Corporation Limited",
    "00DD0C": "UNGERMANN-BASS INC.",
    "0001C8": "CONRAD CORP.",
    "CC45A5": "Texas Instruments",
    "602602": "Texas Instruments",
    "ECBFD0": "Texas Instruments",
    "C4E733": "Clear Align LLC",
    "5CFCE1": "Resideo",
    "9415B2": "Huawei Device Co.",
    "54DED3": "zte corporation",
    "749B89": "HUAWEI TECHNOLOGIES CO.",
    "5C53B4": "EM Microelectronic",
    "50A6D8": "Apple",
    "68CAC4": "Apple",
    "74205F": "Shenzhen Zhongruixin Intelligent Technology Co.",
    "A4978A": "LEAR",
    "80F5AE": "Hangzhou Hikvision Digital Technology Co.",
    "E8B722": "GreenTrol Automation",
    "606134": "Arcade Communications Ltd.",
    "4CEA41": "IEEE Registration Authority",
    "00308E": "Crossmatch Technologies/HID Global",
    "000633": "Crossmatch Technologies/HID Global",
    "14064C": "Vogl Electronic GmbH",
    "8C6120": "EM Microelectronic",
    "8C8E4E": "Baylan Olcu Aletleri San. ve Tic.A.S.",
    "F8ACC1": "InnoXings Co.",
    "845075": "Huawei Device Co.",
    "5CC787": "Huawei Device Co.",
    "4064DC": "X-speed lnformation Technology Co.",
    "30D97F": "Tech4home",
    "5CF838": "IEEE Registration Authority",
    "4080E1": "FN-LINK TECHNOLOGY Ltd.",
    "ECCF70": "FUJIAN STAR-NET COMMUNICATION CO.",
    "9C37CB": "Sony Interactive Entertainment Inc.",
    "3CB0ED": "Nothing Technology Limited",
    "C44838": "Satcom Direct",
    "D8032A": "COMMTACT LTD",
    "847051": "ALPSALPINE CO",
    "740BB0": "Hirschmann Automation and Control GmbH",
    "04F0E4": "ShenZhen Hosecom Electronic Technology Co.",
    "D47F78": "Dopple B.V.",
    "D8E23F": "Qingdao Haier Technology Co.",
    "50131D": "Motorola Mobility LLC",
    "3C8427": "Espressif Inc.",
    "90A9F7": "IEEE Registration Authority",
    "F0F7FC": "HUAWEI TECHNOLOGIES CO.",
    "30FFFD": "HUAWEI TECHNOLOGIES CO.",
    "B0995A": "HUAWEI TECHNOLOGIES CO.",
    "00F7AD": "HUAWEI TECHNOLOGIES CO.",
    "D4CBCC": "vivo Mobile Communication Co.",
    "20ED47": "Juniper Networks",
    "94EF49": "BDR Thermea Group B.V",
    "90B685": "WEIFANG GOERTEK ELECTRONICS CO.",
    "24D5E4": "Cisco Systems",
    "A0D1B3": "Apple",
    "7C4B26": "Apple",
    "18E83B": "Citadel Wallet LLC",
    "CC115A": "Apple",
    "008066": "Eurotech S.p.A.",
    "0080A3": "Lantronix",
    "785333": "Beijing Xiaomi Electronics Co.",
    "9CF8B8": "Shenzhen Skyworth Digital  Technology  CO.",
    "90D432": "zte corporation",
    "147F67": "LG Innotek",
    "9432C1": "Honor Device Co.",
    "107C61": "ASUSTek COMPUTER INC.",
    "189578": "DENSO Corporation",
    "EC9A0C": "IEEE Registration Authority",
    "008DF4": "IEEE Registration Authority",
    "6C7F0C": "Cisco Meraki",
    "5CB26D": "Intel Corporate",
    "CC4D75": "Beijing Xiaomi Mobile Software Co.",
    "E8B0C5": "Intel Corporate",
    "7818EC": "Fortinet",
    "E02EFE": "Zhejiang Dahua Technology Co.",
    "6C51E4": "Huawei Device Co.",
    "B0FA8B": "Huawei Device Co.",
    "E8288D": "Huawei Device Co.",
    "481CB9": "SZ DJI TECHNOLOGY CO.",
    "C46237": "sunweit industrial limited",
    "F462DC": "Huawei Device Co.",
    "CCA08F": "zte corporation",
    "FCB585": "Shenzhen Water World Information Co.",
    "D424DD": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
    "ECE660": "Qingdao Hisense Communications Co.",
    "A0551F": "Sagemcom Broadband SAS",
    "F4D58A": "Palo Alto Networks",
    "C8C6FE": "eero inc.",
    "1889DF": "OMNIVISION",
    "44303F": "HUAWEI TECHNOLOGIES CO.",
    "5C07A6": "HUAWEI TECHNOLOGIES CO.",
    "CC1E56": "HUAWEI TECHNOLOGIES CO.",
    "38C6BD": "Xiaomi Communications Co Ltd",
    "4CB911": "Raisecom Technology CO.",
    "000E5E": "Raisecom Technology CO.",
    "A83CA5": "Dell Inc.",
    "908938": "Hefei Linkin Technology Co.",
    "A8BA69": "Samsung Electronics Co.",
    "000C8D": "Balluff MV GmbH",
    "80F7A6": "Shenzhen C-Data Technology Co.",
    "302FAC": "Zhejiang HuaRay Technology Co.",
    "B80BDA": "GD Midea Air-Conditioning Equipment Co.",
    "342DA3": "Fiberhome Telecommunication Technologies Co.",
    "0C6AC4": "Apple",
    "BC37D3": "Apple",
    "20CC27": "Cisco Systems",
    "0C517E": "Apple",
    "BCEA9C": "ITEL MOBILE LIMITED",
    "28D25A": "Infinix mobility limited",
    "80EA0B": "Zyxel Communications Corporation",
    "982F86": "vivo Mobile Communication Co.",
    "04E4B6": "Samsung Electronics Co.",
    "0479FD": "Ciena Corporation",
    "509893": "Texas Instruments",
    "6C8338": "Ubihere",
    "000CEF": "ONE Investment Group Limited",
    "503AA0": "SHENZHEN MERCURY COMMUNICATION TECHNOLOGIES CO.",
    "5CDE34": "SHENZHEN MERCURY COMMUNICATION TECHNOLOGIES CO.",
    "38398F": "Silicon Laboratories",
    "842712": "Silicon Laboratories",
    "7CC6B6": "Silicon Laboratories",
    "980C33": "Silicon Laboratories",
    "505E5C": "SUNITEC TECHNOLOGY CO.",
    "3802E3": "YICHEN (SHENZHEN) TECHNOLOGY CO.",
    "7CF0E5": "OnePlus Technology (Shenzhen) Co.",
    "34C7E9": "Google",
    "209339": "Juniper Networks",
    "B42BB9": "HUAWEI TECHNOLOGIES CO.",
    "E4A7D0": "HUAWEI TECHNOLOGIES CO.",
    "482D63": "Wavarts Technologies Co.",
    "8099E7": "Sony Corporation",
    "E8FF1E": "IEEE Registration Authority",
    "1C54E6": "Shenzhen Yisheng Technology Co.",
    "AC8C46": "Beijing Xiaomi Mobile Software Co.",
    "0C4B48": "Nokia",
    "7C7B1C": "Motorola Mobility LLC",
    "7834FD": "vivo Mobile Communication Co.",
    "B09C63": "Xiaomi Communications Co Ltd",
    "E89847": "Xiaomi Communications Co Ltd",
    "FC386A": "Shenzhen Skyworth Digital  Technology  CO.",
    "508811": "Beijing Xiaomi Mobile Software Co.",
    "AC81B5": "Accton Technology Corporation",
    "F8C4FA": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "ACCE92": "New H3C Technologies Co.",
    "FC3CD7": "Tuya Smart Inc.",
    "D0460C": "Dell Inc.",
    "84D5A0": "MCOT INC.",
    "84E8CB": "BUFFALO.INC",
    "38E1F4": "Sagemcom Broadband SAS",
    "6453E0": "HUAWEI TECHNOLOGIES CO.",
    "688BF4": "Arista Network",
    "202351": "TP-LINK CORPORATION PTE. LTD.",
    "8C8474": "Broadcom Limited",
    "D8A6FD": "Ghost Autonomy Inc.",
    "94017D": "SHENZHEN SHLINK.CO.",
    "90A0BE": "Cannice",
    "C0E5DA": "Qingdao Intelligent&Precise Electronics Co.",
    "D83D3F": "JOYNED GmbH",
    "D44867": "Silicon Laboratories",
    "D8C6F9": "Tracklab Inc",
    "6C483F": "Xiaomi Communications Co Ltd",
    "3CAFB7": "Xiaomi Communications Co Ltd",
    "540853": "Qingdao Haier Technology Co.",
    "BC0866": "Nestle Purina PetCare",
    "2CB68F": "HUAWEI TECHNOLOGIES CO.",
    "C8D1A9": "HUAWEI TECHNOLOGIES CO.",
    "DC9B95": "Phyplus Technology (Shanghai) Co.",
    "4800B3": "Cisco Systems",
    "E05D54": "Ruijie Networks Co.",
    "40BB56": "TeraNXT Global India Pvt Ltd.",
    "40DA5C": "Apple",
    "5C9175": "Apple",
    "A0782D": "Apple",
    "D011E5": "Apple",
    "D84489": "TP-LINK CORPORATION PTE. LTD.",
    "18188B": "FCNT LLC",
    "6C6016": "OnePlus Technology (Shenzhen) Co.",
    "64FE15": "Flaircomm Microelectronics",
    "D86BFC": "zte corporation",
    "DC71D0": "Apple",
    "9CFA76": "Apple",
    "20FA85": "Apple",
    "9C1A25": "Apple",
    "E04824": "Garmin International",
    "44F770": "Beijing Xiaomi Mobile Software Co.",
    "A83162": "Hangzhou Huacheng Network Technology Co.",
    "CC641A": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
    "68B41E": "ZEASN TECHNOLOGY PRIVATE LIMITED",
    "08F0B6": "Edifier International",
    "C0555C": "Impulse Labs",
    "A8595F": "Intel Corporate",
    "CC28AA": "ASUSTek COMPUTER INC.",
    "3C9FCD": "Shenzhen Neoway Technology Co.",
    "341453": "Gantner Electronic GmbH",
    "DC4BA1": "Wistron Neweb Corporation",
    "34A6EF": "Shenzhen Phaten Tech. LTD",
    "BC3F4E": "Great Talent Technology Limited",
    "DC54AD": "Hangzhou RunZhou Fiber Technologies Co.",
    "A89609": "FN-LINK TECHNOLOGY Ltd.",
    "841571": "TCT mobile ltd",
    "E8BFB8": "Intel Corporate",
    "B0924A": "Sagemcom Broadband SAS",
    "540463": "CIG SHANGHAI CO LTD",
    "882067": "Fiberhome Telecommunication Technologies Co.",
    "E85497": "Samsung Electronics Co.",
    "1083B4": "Sidora Srl",
    "14E01D": "Samsung Electronics Co.",
    "40DE24": "Samsung Electronics Co.",
    "F0D805": "Cisco Systems",
    "086332": "IEEE Registration Authority",
    "B492FE": "Arista Network",
    "4471B3": "Logitech Far East",
    "403059": "Silicon Laboratories",
    "A4FCA1": "Nokia Solutions and Networks GmbH & Co. KG",
    "345A18": "Alignment Engine Inc.",
    "B85C5C": "Microsoft Corporation",
    "6429FF": "HUAWEI TECHNOLOGIES CO.",
    "C09B63": "HUAWEI TECHNOLOGIES CO.",
    "A0FAC8": "HUAWEI TECHNOLOGIES CO.",
    "787E42": "zte corporation",
    "0C6825": "Suzhou HYC technology Co.",
    "AC1518": "Espressif Inc.",
    "648FDB": "Huaqin Technology Co.LTD",
    "10A145": "nexzo india pvt ltd",
    "C4E7AE": "Chengdu Meross Technology Co.",
    "001F23": "Interacoustics",
    "94E6BA": "Samsung Electronics Co.",
    "746DFA": "Samsung Electronics Co.",
    "980709": "Huawei Device Co.",
    "6083E7": "TP-LINK CORPORATION PTE. LTD.",
    "90B4DD": "ZPT R&D",
    "38ACDD": "Valenco GmbH",
    "1C0EC2": "Apple",
    "C4CC37": "IEEE Registration Authority",
    "0441A5": "Apple",
    "3C996D": "Marelli Europe s.p.a.",
    "B08BA8": "Amazon Technologies Inc.",
    "7C7EF9": "eero inc.",
    "C40898": "Dropbeats Technology Co.",
    "8850DD": "Infiniband Trade Association",
    "5C35FC": "Actiontec Electronics Inc.",
    "ACEAEA": "HUAWEI TECHNOLOGIES CO.",
    "38F195": "HUAWEI TECHNOLOGIES CO.",
    "E85FB4": "Xiaomi Communications Co Ltd",
    "1402EC": "Hewlett Packard Enterprise",
    "1C98EC": "Hewlett Packard Enterprise",
    "941882": "Hewlett Packard Enterprise",
    "34FCB9": "Hewlett Packard Enterprise",
    "B8977A": "Nokia Solutions and Networks GmbH & Co. KG",
    "982A0A": "Intelbras",
    "703A0E": "Hewlett Packard Enterprise",
    "6026EF": "Hewlett Packard Enterprise",
    "BCD7A5": "Hewlett Packard Enterprise",
    "187A3B": "Hewlett Packard Enterprise",
    "6CC49F": "Hewlett Packard Enterprise",
    "000B86": "Hewlett Packard Enterprise",
    "883A30": "Hewlett Packard Enterprise",
    "7CA62A": "Hewlett Packard Enterprise",
    "B86CE0": "Hewlett Packard Enterprise",
    "24F27F": "Hewlett Packard Enterprise",
    "808DB7": "Hewlett Packard Enterprise",
    "484AE9": "Hewlett Packard Enterprise",
    "4CAEA3": "Hewlett Packard Enterprise",
    "204C03": "Hewlett Packard Enterprise",
    "20A6CD": "Hewlett Packard Enterprise",
    "2462CE": "Hewlett Packard Enterprise",
    "EC50AA": "Hewlett Packard Enterprise",
    "F061C0": "Hewlett Packard Enterprise",
    "B01F8C": "Hewlett Packard Enterprise",
    "48B4C3": "Hewlett Packard Enterprise",
    "209CB4": "Hewlett Packard Enterprise",
    "4472AC": "AltoBeam Inc.",
    "A86E84": "TP-LINK CORPORATION PTE. LTD.",
    "4CD587": "Hewlett Packard Enterprise",
    "9C3708": "Hewlett Packard Enterprise",
    "34C515": "Hewlett Packard Enterprise",
    "F01AA0": "Hewlett Packard Enterprise",
    "A0A001": "Hewlett Packard Enterprise",
    "8C7909": "Hewlett Packard Enterprise",
    "68B76B": "Fiberhome Telecommunication Technologies Co.",
    "103F8C": "New H3C Technologies Co.",
    "F09E9E": "Espressif Inc.",
    "888C1B": "EM Microelectronic",
    "D8D8E5": "Vantiva Connected Home - Technologies Telco",
    "4C2338": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "C0D941": "Shenzhen VMAX Software Co.",
    "9C1221": "Sichuan AI-Link Technology Co.",
    "3CF083": "Arcadyan Corporation",
    "3C94FD": "Mist Systems",
    "94CA9A": "Paul Vahle GmbH & Co. KG",
    "48B313": "Idesco Oy",
    "68C6AC": "Intel Corporate",
    "BC3898": "Intel Corporate",
    "A04F52": "Intel Corporate",
    "742EC1": "Dixon Electro Appliances Pvt Ltd",
    "84F2C1": "zte corporation",
    "4062EE": "Chicony Electronics Co.",
    "3023BA": "Accelerated Memory Production Inc.",
    "40827B": "STMicroelectronics Rousset SAS",
    "D06DC8": "HUAWEI TECHNOLOGIES CO.",
    "5C5A4C": "IEEE Registration Authority",
    "980802": "ORBIS BV",
    "742972": "Juniper Networks",
    "E45ECC": "Juniper Networks",
    "286B5C": "Cisco Systems",
    "70357B": "vivo Mobile Communication Co.",
    "A8A913": "GN Hearing A/S",
    "C47764": "Samsung Electronics Co.",
    "607FCB": "Samsung Electronics Co.",
    "6CB34D": "SharkNinja Operating LLC",
    "5879E0": "Samsung Electronics Co.",
    "FCB387": "Leapmotor (Jinhua) New Energy Vehicle Parts Technology Co.",
    "1CF64C": "Apple",
    "AC5C2C": "Apple",
    "50F265": "Apple",
    "C06C0C": "Apple",
    "BC2978": "Prama Hikvision India Private Limited",
    "1423F3": "Broadcom Limited",
    "9CDAA8": "Apple",
    "9C0E51": "Schneider Electric",
    "0C07DF": "Xiaomi Communications Co Ltd",
    "203B34": "Xiaomi Communications Co Ltd",
    "EC09C9": "Texas Instruments",
    "6C3A36": "Glowforge Inc",
    "C8EED7": "Lightspeed Technologies Inc.",
    "603192": "OVT India pvt Ltd",
    "0CEA14": "Ubiquiti Inc",
    "58D15A": "Texas Instruments",
    "F0ABF3": "Fiberhome Telecommunication Technologies Co.",
    "7CE712": "Quectel Wireless Solutions Co.",
    "E82281": "GD Midea Air-Conditioning Equipment Co.",
    "B43D6B": "NXP Semiconductor (Tianjin) LTD.",
    "E817FC": "Fujitsu Limited",
    "FCAE2B": "Titan Products Ltd.",
    "4CD7C8": "Guangzhou V-Solution Telecommunication Technology Co.",
    "A42902": "Hangzhou Hikvision Digital Technology Co.",
    "6CD008": "zte corporation",
    "508CC9": "zte corporation",
    "346E68": "HUAWEI TECHNOLOGIES CO.",
    "8492E5": "HUAWEI TECHNOLOGIES CO.",
    "CC9096": "Huawei Device Co.",
    "2CE2D9": "Huawei Device Co.",
    "685134": "Hewlett Packard Enterprise",
    "5CEB52": "zte corporation",
    "FCABF5": "zte corporation",
    "083BE9": "New H3C Technologies Co.",
    "10B65E": "New H3C Technologies Co.",
    "E41E33": "Continental Automotive Technologies GmbH",
    "28EBB7": "ambie corporation",
    "60CF84": "ASUSTek COMPUTER INC.",
    "F0CF4D": "BitRecords GmbH",
    "00153B": "EMH Metering GmbH & Co. KG",
    "B848EC": "Private",
    "F41E57": "Routerboard.com",
    "70C59C": "Silicon Laboratories",
    "E406BF": "Silicon Laboratories",
    "081031": "Lithiunal Energy",
    "CC6E2A": "Cisco Meraki",
    "30F23C": "TECNO MOBILE LIMITED",
    "1C112F": "vivo Mobile Communication Co.",
    "74AD45": "Valeo Auto- Electric Hungary Ltd",
    "EC308E": "Lierda Science & Technology Group Co.",
    "CC4B04": "Apple",
    "4409DA": "Apple",
    "809698": "Apple",
    "C484FC": "Apple",
    "0CC56C": "Apple",
    "E88088": "LCFC(Hefei) Electronics Technology co.",
    "983FE8": "Samsung Electronics Co.",
    "10ABC9": "Samsung Electronics Co.",
    "E86A64": "LCFC(Hefei) Electronics Technology co.",
    "902E16": "LCFC(Hefei) Electronics Technology co.",
    "60FF9E": "AzureWave Technology Inc.",
    "001E96": "Sepura Limited",
    "745D22": "LCFC(Hefei) Electronics Technology co.",
    "645563": "Q-Free America",
    "408556": "Continental Automotive Romania SLR",
    "9C69ED": "Arista Networks",
    "101A92": "AKEBONO BRAKE INDUSTRY CO.",
    "C8A913": "Lontium Semiconductor Corporation",
    "ECFC2F": "Sagemcom Broadband SAS",
    "6045CD": "Sagemcom Broadband SAS",
    "485C2C": "Earda Technologies co Ltd",
    "8407C4": "Walter Kidde Portable Equipment",
    "781F7C": "Nokia",
    "30E3A4": "Intel Corporate",
    "084857": "Suteng Innovation Technology Co.",
    "74F90F": "HUAWEI TECHNOLOGIES CO.",
    "2014C4": "HUAWEI TECHNOLOGIES CO.",
    "88F4DA": "Intel Corporate",
    "EC8E77": "Intel Corporate",
    "2C5683": "China Mobile Group Device Co.",
    "0C9515": "Palltronics",
    "707DAF": "Plucent AB",
    "A085E3": "Espressif Inc.",
    "50056E": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "EC470C": "Universal Electronics",
    "485E0E": "IEEE Registration Authority",
    "C0BAE6": "Zenitel GB Ltd",
    "64E815": "Arcelik A.S",
    "E01F34": "HMD Global Oy",
    "5CBE69": "Oraimo Technology Limited",
    "FC4116": "Google",
    "70F74F": "Robert Bosch JuP1",
    "3854F5": "AltoBeam Inc.",
    "2C0D27": "Huawei Device Co.",
    "94CFB0": "Huawei Device Co.",
    "4CF475": "Huawei Device Co.",
    "3C4AC9": "Huawei Device Co.",
    "D8CF61": "Sagemcom Broadband SAS",
    "48B424": "eero inc.",
    "A02442": "Shenzhenshi Xinzhongxin Technology Co.Ltd",
    "3C5765": "UNIONMAN TECHNOLOGY CO.",
    "5805D9": "Seiko Epson Corporation",
    "F01EAC": "Rentokil Initial",
    "34E6E6": "LG Innotek",
    "ECA7B1": "IEEE Registration Authority",
    "C4A9B8": "XIAMENSHI C-CHIP TECHNOLOGY CO.",
    "58ED99": "zte corporation",
    "2441FE": "Wistron Neweb Corporation",
    "F4BDB9": "Ubiqcom India Pvt Ltd",
    "EC5A31": "BUFFALO.INC",
    "A4A584": "Cisco Systems",
    "20B5C6": "Mimosa Networks",
    "B48618": "GX India Pvt Ltd",
    "EC1DA9": "YEALINK(XIAMEN) NETWORK TECHNOLOGY CO.",
    "345CF3": "Chipsea Technologies (Shenzhen) Corp.",
    "EC536F": "HUAWEI TECHNOLOGIES CO.",
    "D801D0": "HUAWEI TECHNOLOGIES CO.",
    "84EE7F": "HUAWEI TECHNOLOGIES CO.",
    "981CA2": "Apple",
    "E8FFF4": "Apple",
    "0C1563": "Apple",
    "3CDD57": "Apple",
    "788371": "HUAWEI TECHNOLOGIES CO.",
    "E8F0A4": "Antonios A. Chariton",
    "7C3B2D": "Apple",
    "7CFAD6": "Realme Chongqing Mobile Telecommunications Corp.",
    "D0C0BF": "Actions Microelectronics",
    "DC2FFA": "GE Lighting",
    "F43AFA": "IEEE Registration Authority",
    "284D7D": "zte corporation",
    "B82903": "VIETNAM POST AND TELECOMMUNICATION INDUSTRY TECHNOLOGY JOIN STOCK COMPANY",
    "CC2614": "Sichuan Tianyi Comheart Telecom Co.",
    "3C3824": "Xiaomi Communications Co Ltd",
    "84CC11": "LG Electornics",
    "C45746": "Texas Instruments",
    "440BAB": "Positivo Tecnologia S.A.",
    "20BEB4": "Hisense broadband multimedia technology Co.",
    "C47DA8": "NXP Semiconductor (Tianjin) LTD.",
    "B8A0B8": "Samsung Electronics Co.",
    "A8FECE": "Fiberhome Telecommunication Technologies Co.",
    "286DDA": "Fiberhome Telecommunication Technologies Co.",
    "DC7E1D": "HUAWEI TECHNOLOGIES CO.",
    "2CA797": "HUAWEI TECHNOLOGIES CO.",
    "AC1794": "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.",
    "DC0675": "Espressif Inc.",
    "98E255": "Nintendo Co.",
    "58257A": "MOBIWIRE MOBILES(NINGBO) CO.",
    "8892CC": "Tonly Technology Co. Ltd",
    "3490EA": "Murata Manufacturing Co.",
    "88B5FF": "Shenzhen iComm Semiconductor CO.",
    "EC41F9": "Shenzhen iComm Semiconductor CO.",
    "0022C8": "ModuVision Technologies",
    "2CDD5F": "Shenzhen iComm Semiconductor CO.",
    "081A1E": "Shenzhen iComm Semiconductor CO.",
    "087158": "HANSHOW TECHNOLOGY CO.",
    "308E7A": "Shenzhen iComm Semiconductor CO.",
    "905671": "Cisco Systems",
    "70BD96": "Cisco Systems",
    "BCFCE7": "ASUSTek COMPUTER INC.",
    "0060D5": "AMADA CO.",
    "B8CC5F": "Shenzhen iComm Semiconductor CO.",
    "A46011": "Verifone",
    "60C798": "Verifone",
    "000B4F": "Verifone",
    "88BF35": "Verifone",
    "4CA38F": "shenzhen trolink  Technology Co.",
    "081287": "Jiangxi Risound Electronics Co.",
    "94EC13": "Hangzhou Ezviz Software Co.",
    "6C4F89": "Zyxel Communications Corporation",
    "A809B1": "Huawei Device Co.",
    "34A8DB": "SenArch ApS",
    "ECD909": "ALPSALPINE CO",
    "9CDEF0": "Jiangxi Risound Electronics Co.",
    "185073": "Tianjin HuaLai Technology CO.",
    "AC69CF": "Cisco Meraki",
    "C0D6D5": "Microsoft Corporation",
    "405B7F": "Broadcom Limited",
    "2840DD": "Sony Interactive Entertainment Inc.",
    "5C1923": "Hangzhou Lanly Technology Co.",
    "B46E10": "vivo Mobile Communication Co.",
    "B8A1B8": "Arista Networks",
    "1406A7": "CRESYN",
    "FC942E": "Cisco Meraki",
    "CCD920": "Huizhou Desay SV Automotive Co.",
    "4087E5": "Wu Qi Technologies",
    "C4F035": "Hughes Network Systems",
    "D820A2": "HUAWEI TECHNOLOGIES CO.",
    "B4E7B3": "Edifier International",
    "D45944": "tonies GmbH",
    "684465": "Apple",
    "2478EF": "Nokia",
    "009D85": "Sigmastar Technology Ltd.",
    "D8C7C8": "Hewlett Packard Enterprise",
    "C0B22F": "Apple",
    "608110": "Apple",
    "64A3CC": "LeoLabs",
    "E8EAFA": "Qingdao Haier Technology Co.",
    "ACF473": "iRobot Corporation",
    "08B8D0": "Chipsea Technologies (Shenzhen) Corp.",
    "644F56": "YEALINK(XIAMEN) NETWORK TECHNOLOGY CO.",
    "3817B1": "Sagemcom Broadband SAS",
    "DC9009": "Intel Corporate",
    "54E4ED": "Intel Corporate",
    "38F0BB": "CompuSoft A/S",
    "0015D1": "Commscope",
    "0000CA": "Commscope",
    "0015A4": "Commscope",
    "0015A3": "Commscope",
    "0015A2": "Commscope",
    "000FCC": "Commscope",
    "D039B3": "Commscope",
    "BCCAB5": "Commscope",
    "5C8FE0": "Commscope",
    "4896D9": "zte corporation",
    "8461A0": "Commscope",
    "3CDFA9": "Commscope",
    "0CF893": "Commscope",
    "ACB313": "Commscope",
    "10868C": "Commscope",
    "384C90": "Commscope",
    "8096B1": "Commscope",
    "00E06F": "Commscope",
    "001DD3": "Commscope",
    "001DD0": "Commscope",
    "0015CE": "Commscope",
    "0004BD": "Commscope",
    "000F9F": "Commscope",
    "00111A": "Commscope",
    "0017EE": "Commscope",
    "00152F": "Commscope",
    "F87B7A": "Commscope",
    "C8AA21": "Commscope",
    "DC4517": "Commscope",
    "001FC4": "Commscope",
    "0023AF": "Commscope",
    "002395": "Commscope",
    "0022B4": "Commscope",
    "002210": "Commscope",
    "0024A1": "Commscope",
    "F80BBE": "Commscope",
    "5856E8": "Commscope",
    "00149A": "Commscope",
    "001CFB": "Commscope",
    "0019C0": "Commscope",
    "0014E8": "Commscope",
    "707E43": "Commscope",
    "002642": "Commscope",
    "2C584F": "Commscope",
    "4C1265": "Commscope",
    "9CC8FC": "Commscope",
    "2C9924": "Commscope",
    "E02202": "Commscope",
    "2C7E81": "Commscope",
    "14C03E": "Commscope",
    "C089AB": "Commscope",
    "0CB771": "Commscope",
    "8C5BF0": "Commscope",
    "0CEAC9": "Commscope",
    "3C0461": "Commscope",
    "641269": "Commscope",
    "28C87A": "Commscope",
    "D43FCB": "Commscope",
    "6092F5": "Commscope",
    "4C38D8": "Commscope",
    "D4B27A": "Commscope",
    "D82522": "Commscope",
    "E0B7B1": "Commscope",
    "005094": "Commscope",
    "4434A7": "Commscope",
    "6838E3": "EYESON SOLUTION CO.",
    "3C39A8": "Shenzhen Taichi Technology Limited",
    "A0E7AE": "Commscope",
    "90935A": "Commscope",
    "24A186": "Commscope",
    "90C792": "Commscope",
    "D46C6D": "Commscope",
    "BC5BD5": "Commscope",
    "145D34": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
    "ACC5B4": "HUAWEI TECHNOLOGIES CO.",
    "000540": "Tokyo Electron Device Limited",
    "00504D": "Tokyo Electron Device Limited",
    "B4D5E5": "Samsung Electronics Co.",
    "C4EF3D": "Samsung Electronics Co.",
    "C0D5E2": "Samsung Electronics Co.",
    "68ED57": "Juniper Networks",
    "4036B7": "Juniper Networks",
    "343607": "PINEWAVE PTE. LTD.",
    "7CC790": "Palo Alto Networks",
    "4C3089": "Hitachi Rail GTS Deutschland GmbH",
    "2C66F5": "SHENZHEN ELECTRICAL APPLIANCES CO.",
    "BCBEFB": "ASL Xiamen Technology CO.",
    "547E1A": "Kaon Group Co.",
    "B8D4F7": "New H3C Technologies Co.",
    "E46447": "EM Microelectronic",
    "C87023": "Altice Labs",
    "382228": "Telink Micro LLC",
    "542722": "Lacroix",
    "50E099": "HangZhou Atuo Future Technology Co.",
    "68508C": "Shanghai Sunmi Technology Co.",
    "A47D78": "Edgecore Americas Networking Corporation",
    "A88F99": "Arista Networks",
    "E8CF83": "Dell Inc.",
    "48BC0E": "Sichuan AI-Link Technology Co.",
    "6C22F7": "Nokia Shanghai Bell Co.",
    "244885": "Huawei Device Co.",
    "CC8A84": "Huawei Device Co.",
    "802EDE": "Huawei Device Co.",
    "98A44E": "IEC Technologies S. de R.L de C.V.",
    "384DD2": "Huawei Device Co.",
    "BCF2E5": "Powerful Devices",
    "443E8A": "Texas Instruments",
    "04FDE8": "Technoalpin",
    "9088A9": "IEEE Registration Authority",
    "3486DA": "Honor Device Co.",
    "F8CE21": "TP-LINK TECHNOLOGIES CO.",
    "F8C903": "TP-LINK TECHNOLOGIES CO.",
    "389231": "TECNO MOBILE LIMITED",
    "588C81": "Espressif Inc.",
    "6C05D3": "CHINA DRAGON TECHNOLOGY LIMITED",
    "7C8C09": "Mellanox Technologies",
    "441146": "The Chamberlain Group",
    "F43392": "Cisco Systems",
    "8428D6": "SERVERCOM (INDIA) PRIVATE LIMITED",
    "ACD929": "Quectel Wireless Solutions Co.",
    "10C735": "Microsoft Corporation",
    "CCB148": "Arcadyan Corporation",
    "DC567B": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "348E89": "Hangzhou BroadLink Technology Co.",
    "64028F": "Silicon Laboratories",
    "783F4D": "Apple",
    "9C79E3": "Apple",
    "8851F2": "Apple",
    "5CADBA": "Apple",
    "74FB17": "Qingdao Goertek  Horizons Tecnology  Co.",
    "1CF9D5": "Apple",
    "546749": "Google",
    "BC85D0": "SKY UK LIMITED",
    "140805": "SKY UK LIMITED",
    "ACCA0F": "INDISR COMMUNICATION SERVICES AND TECHNOLOGIES INDIA",
    "C4E3CE": "EnGenius Technologies",
    "D490E0": "Wachendorff Automation GmbH & CO.KG",
    "889E96": "zte corporation",
    "A0BD71": "QUALCOMM Incorporated",
    "50139D": "Sierra Wireless",
    "58FCC8": "Honeywell",
    "F8DC7A": "Variscite LTD",
    "FC012C": "Espressif Inc.",
    "C8A4CD": "Realme Chongqing Mobile Telecommunications Corp.",
    "7CBECE": "Private",
    "C890A8": "Bouffalo Lab (Nanjing) Co.",
    "48EEE2": "ROAMWIFI TECHNOLOGY(HK) LIMITED",
    "784946": "Cambridge Mobile Telematics",
    "880F62": "Silicon Laboratories",
    "245D92": "Juniper Networks",
    "3034DB": "LG Innotek",
    "5823BC": "IEEE Registration Authority",
    "A0E06D": "Fiberhome Telecommunication Technologies Co.",
    "903CDA": "Fiberhome Telecommunication Technologies Co.",
    "3C9722": "shenzhen worldelite electronics co.",
    "04208A": "浙江路川科技有限公司",
    "20F120": "Cisco Systems",
    "ECDD24": "Cisco Systems",
    "30BE29": "AltoBeam Inc.",
    "7410E0": "Broadcom Limited",
    "8449EE": "Demant Enterprise A/S",
    "C400B5": "HongKong Tenry Technology Co.",
    "845234": "Juniper Networks",
    "64C01A": "Sichuan Tianyi Comheart Telecom Co.",
    "A44343": "Huawei Device Co.",
    "344951": "Eliyan Corp.",
    "9877D5": "WiZ",
    "A499A8": "eero inc.",
    "44B3C5": "Huawei Device Co.",
    "782599": "Huawei Device Co.",
    "C4FF99": "Intel Corporate",
    "289529": "Intel Corporate",
    "F810A0": "Xtreme Testek Inc.",
    "B8CB93": "IC BOSS.COM TECH INC",
    "E845EB": "Kohler Ventures",
    "D823E0": "SPEEDTECH CORP.",
    "BC86A5": "Cambridge Mobile Telematics",
    "643135": "Apple",
    "E0BFB2": "Apple",
    "086202": "Apple",
    "68EFDC": "Apple",
    "A09D22": "Apple",
    "4CC449": "Icotera A/S",
    "C4D7DC": "Zhejiang Weilai Jingling Artificial Intelligence Technology Co.",
    "1C792D": "CHINA DRAGON TECHNOLOGY LIMITED",
    "14801F": "Sunnovo International Limited",
    "789F6A": "Ruckus Wireless",
    "000346": "KOKUSAI DENKI Electric Inc.",
    "54B29D": "Shenzhen YOUHUA Technology Co.",
    "800EA9": "TCL Yuxin Zhixing Technology (Huizhou) Co.",
    "00A62B": "Shanghai High-Flying Electronics Technology Co.",
    "3C566E": "Infinix mobility limited",
    "809D65": "FN-LINK TECHNOLOGY Ltd.",
    "A8B57C": "Roku",
    "345E08": "Roku",
    "D83134": "Roku",
    "105932": "Roku",
    "B0EE7B": "Roku",
    "9CDFB3": "NXP Semiconductor (Tianjin) LTD.",
    "4C2F7B": "AltoBeam Inc.",
    "BC8D7E": "Silicon Laboratories",
    "640864": "Cisco Systems",
    "C47981": "Ehya LTD",
    "001C2B": "Hive",
    "A4A404": "Bubendorff SAS",
    "E0EFBF": "Nintendo Co.",
    "985207": "HUAWEI TECHNOLOGIES CO.",
    "A80DE1": "HUAWEI TECHNOLOGIES CO.",
    "D400CA": "Continental Automotive Systems S.R.L",
    "C0E911": "RealNetworks",
    "882AE1": "MRC INC.",
    "B4E9B8": "Dell Inc.",
    "A4BA70": "Beijing Xiaomi Mobile Software Co.",
    "606E53": "Beijing Wisdomstar Technology Co.",
    "7828CA": "Sonos",
    "542A1B": "Sonos",
    "F0F6C1": "Sonos",
    "D42DC5": "i-PRO Co.",
    "6CB077": "ALL Winner (Hong Kong) Limited",
    "D09288": "Powertek Limited",
    "9C65EB": "Intel Corporate",
    "943EFD": "IEEE Registration Authority",
    "8CA401": "Shenzhen New Chip Intelligence Co.",
    "24B231": "Dongguan Liesheng Electronic Co.",
    "30292B": "eero inc.",
    "C049BD": "EM Microelectronic",
    "6882F2": "FIXME GmbH",
    "14375E": "Symbotic LLC",
    "000130": "Extreme Networks Headquarters",
    "FC0A81": "Extreme Networks Headquarters",
    "00749C": "Ruijie Networks Co.",
    "000FEA": "GIGA-BYTE TECHNOLOGY CO.",
    "489BD5": "Extreme Networks Headquarters",
    "DCB808": "Extreme Networks Headquarters",
    "F46E95": "Extreme Networks Headquarters",
    "E01C41": "Extreme Networks Headquarters",
    "BCF310": "Extreme Networks Headquarters",
    "D854A2": "Extreme Networks Headquarters",
    "C8665D": "Extreme Networks Headquarters",
    "8C497A": "Extreme Networks Headquarters",
    "B027CF": "Extreme Networks Headquarters",
    "C851FB": "Extreme Networks Headquarters",
    "DC233B": "Extreme Networks Headquarters",
    "E4DBAE": "Extreme Networks Headquarters",
    "38AD2B": "Hitron Technologies. Inc",
    "E8458B": "MitraStar Technology Corp.",
    "D04433": "Clourney Semiconductor",
    "4086CB": "D-Link Corporation",
    "48417B": "Nokia Solutions and Networks GmbH & Co. KG",
    "608CDF": "Beamtrail-Sole Proprietorship",
    "3027CF": "Canopy Growth Corp",
    "001277": "Beijer Electronics Corp.",
    "2047B5": "Sagemcom Broadband SAS",
    "60452E": "Intel Corporate",
    "1CAB48": "TECNO MOBILE LIMITED",
    "88B436": "FUJIFILM Corporation",
    "CCD342": "Cisco Systems",
    "40B8C2": "OSMOZIS",
    "8CE9EE": "Intel Corporate",
    "944560": "Google",
    "5C337B": "Google",
    "2C9C58": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "B8F44F": "u-blox AG",
    "540929": "Inventus Power Eletronica do Brasil LTDA",
    "2831F8": "HUAWEI TECHNOLOGIES CO.",
    "C4AA99": "HUAWEI TECHNOLOGIES CO.",
    "A8F5E1": "Shenzhen Shokz Co.",
    "606682": "SHENZHEN ATEKO PHOTOELECTRICITY CO.",
    "788DAF": "Sagemcom Broadband SAS",
    "2CBACA": "Cosonic Electroacoustic Technology Co.",
    "04FA3F": "OptiCore Inc.",
    "441DB1": "APTIV SERVICES US",
    "009CC0": "vivo Mobile Communication Co.",
    "E89E13": "CRESYN",
    "BC1896": "HUAWEI TECHNOLOGIES CO.",
    "BC0FFE": "Juniper Networks",
    "E0D3B4": "Cisco Meraki",
    "FC8C11": "Microsoft Corporation",
    "A494DC": "Infinite Clouds",
    "4C4341": "Calix Inc.",
    "E46CD1": "Calix Inc.",
    "D0F27F": "BrewLogix",
    "7CFCFD": "Fiberhome Telecommunication Technologies Co.",
    "4887B8": "TCL King Electrical Appliances(Huizhou)Co.",
    "7058A4": "Actiontec Electronics Inc.",
    "188025": "Hangzhou Hikvision Digital Technology Co.",
    "F8F09D": "Hangzhou Prevail Communication Technology Co.",
    "E47876": "Arista Networks",
    "A4A930": "Beijing Xiaomi Mobile Software Co.",
    "A02252": "Astra Wireless Technology FZ-LLC",
    "BC102F": "SJI Industry Company",
    "FC936B": "Samsung Electronics Co.",
    "BCB6FB": "P4Q ELECTRONICS",
    "7C752D": "Samsung Electronics Co.",
    "84EEE4": "Samsung Electronics Co.",
    "4435D3": "GD Midea Air-Conditioning Equipment Co.",
    "88F00F": "Miraeil",
    "18A788": "Shenzhen MEK Intellisys Pte Ltd",
    "BC8529": "Jiangxi Remote lntelligence Technology Co.",
    "64DAED": "eero inc.",
    "289401": "NETGEAR",
    "D878C9": "SERVERCOM (INDIA) PRIVATE LIMITED",
    "A85EF2": "TECNO MOBILE LIMITED",
    "789A18": "Routerboard.com",
    "84DB2F": "Sierra Wireless",
    "74C530": "vivo Mobile Communication Co.",
    "BC96E5": "SERCOMM PHILIPPINES INC",
    "A899AD": "Chaoyue Technology Co.",
    "D015BB": "IEEE Registration Authority",
    "64CE6E": "Sierra Wireless",
    "78DF72": "Shanghai Imilab Technology Co.Ltd",
    "602B58": "EM Microelectronic",
    "109D9C": "EM Microelectronic",
    "28FF5F": "HG Genuine Intelligent Terminal (Xiaogan) Co.",
    "607623": "Shenzhen E-Superlink Technology Co.",
    "7492BA": "Movesense Ltd",
    "D0484F": "Nokia Solutions and Networks GmbH & Co. KG",
    "2C459A": "Dixon Technologies (India) Limited",
    "6C6E07": "CE LINK LIMITED",
    "6C6286": "Nokia",
    "50482C": "IEEE Registration Authority",
    "B8FC28": "Valeo Vision Systems",
    "0020FC": "Matrox Central Services Inc",
    "888187": "Umeox Innovations Co.",
    "D40F9E": "Apple",
    "6CA367": "Avlinkpro",
    "48C461": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "B8B7DB": "GOIP Global Services Pvt. Ltd.",
    "880CE0": "Texas Instruments",
    "B83DF6": "Texas Instruments",
    "B4DDE0": "Shanghai Amphenol Airwave Communication Electronics Co.",
    "9064AD": "HUAWEI TECHNOLOGIES CO.",
    "D4D892": "HUAWEI TECHNOLOGIES CO.",
    "98D3D7": "HUAWEI TECHNOLOGIES CO.",
    "886EEB": "HUAWEI TECHNOLOGIES CO.",
    "980DAF": "Apple",
    "DC6DBC": "Apple",
    "A4D23E": "Apple",
    "30E04F": "Apple",
    "64E4A5": "LG Electronics",
    "48BDCE": "Vantiva USA LLC",
    "9404E3": "Vantiva USA LLC",
    "B42A0E": "Vantiva USA LLC",
    "603D26": "Vantiva USA LLC",
    "54A65C": "Vantiva USA LLC",
    "DCEB69": "Vantiva USA LLC",
    "946A77": "Vantiva USA LLC",
    "D4B92F": "Vantiva USA LLC",
    "589630": "Vantiva USA LLC",
    "989D5D": "Vantiva USA LLC",
    "484BD4": "Vantiva USA LLC",
    "E0DBD1": "Vantiva USA LLC",
    "ECA81F": "Vantiva USA LLC",
    "C42795": "Vantiva USA LLC",
    "E0885D": "Vantiva USA LLC",
    "802994": "Vantiva USA LLC",
    "E40D3B": "Ericsson AB",
    "EC5382": "Honor Device Co.",
    "9C0971": "New H3C Technologies Co.",
    "98AB15": "Fujian Youyike Technology Co.",
    "0018AD": "NIDEC INSTRUMENTS CORPORATION",
    "A4CCB3": "Xiaomi Communications Co Ltd",
    "ECE7C2": "China Mobile Group Device Co.",
    "BC3198": "IEEE Registration Authority",
    "ECA2A0": "Taicang T&W Electronics",
    "0C7043": "Sony Interactive Entertainment Inc.",
    "CC4085": "WiZ",
    "DCCD18": "Nintendo Co.",
    "7093C1": "eero inc.",
    "5449FC": "Ubee Interactive Co.",
    "4C496C": "Intel Corporate",
    "0011A9": "Nurivoice Co.",
    "18F935": "Cisco Systems",
    "588B1C": "Cisco Systems",
    "C8154E": "Intel Corporate",
    "789F38": "Shenzhen Feasycom Co.",
    "544C8A": "Microsoft Corporation",
    "9070D3": "Fiberhome Telecommunication Technologies Co.",
    "6C48A6": "Fiberhome Telecommunication Technologies Co.",
    "3C0D2C": "Liquid-Markets GmbH",
    "FCB9DF": "Motorola Mobility LLC",
    "D081C5": "Juniper Networks",
    "F4BFBB": "China Mobile Group Device Co.",
    "84AC60": "Guangxi Hesheng Electronics Co.",
    "9CA389": "Nokia",
    "5C101E": "zte corporation",
    "201746": "Paradromics",
    "C46026": "SKY UK LIMITED",
    "905A08": "Super Micro Computer",
    "FCF763": "KunGao Micro (JiangSu) Co.",
    "808C97": "Kaon Group Co.",
    "4C12E8": "VIETNAM POST AND TELECOMMUNICATION INDUSTRY TECHNOLOGY JOIN STOCK COMPANY",
    "2002FE": "Hangzhou Dangbei Network Technology Co.",
    "74272C": "Advanced Micro Devices",
    "208810": "Dell Inc.",
    "A06260": "Private",
    "E44519": "Beijing Xiaomi Electronics Co.",
    "C05B44": "Beijing Xiaomi Mobile Software Co.",
    "E4B224": "HUAWEI TECHNOLOGIES CO.",
    "A83ED3": "HUAWEI TECHNOLOGIES CO.",
    "6467CD": "HUAWEI TECHNOLOGIES CO.",
    "34ECB6": "Phyplus Microelectronics Limited",
    "4CD2FB": "UNIONMAN TECHNOLOGY CO.",
    "9C1ECF": "Valeo Telematik und Akustik GmbH",
    "000D39": "Nevion",
    "807677": "hangzhou puwell cloud tech co.",
    "F42B8C": "Samsung Electronics Co.",
    "E41A1D": "NOVEA ENERGIES",
    "F4CAE7": "Arcadyan Corporation",
    "3CEF42": "TCT mobile ltd",
    "B0A3F2": "Huaqin Technology Co. LTD",
    "F86691": "Sichuan Tianyi Comheart Telecom Co.",
    "E43819": "Shenzhen Hi-Link Electronic CO.",
    "84F175": "Jiangxi Xunte Intelligent Terminal Co.",
    "C89828": "zte corporation",
    "DC3642": "zte corporation",
    "788A86": "China Dragon Technology Limited",
    "608246": "Apple",
    "98B379": "Apple",
    "6C2ADF": "IEEE Registration Authority",
    "847293": "Texas Instruments",
    "60DC81": "AltoBeam Inc.",
    "20E46F": "vivo Mobile Communication Co.",
    "883037": "Juniper Networks",
    "E82404": "Quectel Wireless Solutions Co.",
    "F82E0C": "Texas Instruments",
    "9006F2": "Texas Instruments",
    "E86E3A": "Sony Interactive Entertainment Inc.",
    "BCB1D3": "Cisco Meraki",
    "B87BD4": "Google",
    "C8138B": "Shenzhen Skyworth Digital  Technology  CO.",
    "34AA31": "Shenzhen Skyworth Digital  Technology  CO.",
    "A04C0C": "Shenzhen Skyworth Digital  Technology  CO.",
    "6CC242": "Shenzhen Skyworth Digital  Technology  CO.",
    "049D05": "Apple",
    "E073E7": "HP Inc.",
    "54083B": "IEEE Registration Authority",
    "54EF43": "HUAWEI TECHNOLOGIES CO.",
    "D81BB5": "HUAWEI TECHNOLOGIES CO.",
    "8464DD": "HUAWEI TECHNOLOGIES CO.",
    "68A46A": "HUAWEI TECHNOLOGIES CO.",
    "F48E38": "Dell Inc.",
    "28F10E": "Dell Inc.",
    "90B11C": "Dell Inc.",
    "64006A": "Dell Inc.",
    "109836": "Dell Inc.",
    "C81F66": "Dell Inc.",
    "F8DB88": "Dell Inc.",
    "001422": "Dell Inc.",
    "0015C5": "Dell Inc.",
    "7845C4": "Dell Inc.",
    "5C260A": "Dell Inc.",
    "001E4F": "Dell Inc.",
    "0026B9": "Dell Inc.",
    "D067E5": "Dell Inc.",
    "544E45": "Private",
    "209727": "TELTONIKA NETWORKS UAB",
    "001AE8": "Unify Software and Solutions GmbH & Co. KG",
    "2CFE4F": "Xiaomi Communications Co Ltd",
    "907E43": "zte corporation",
    "943EE4": "WiSA Technologies Inc",
    "A8BD3A": "UNION MAN TECHNOLOGY CO.",
    "48CAC6": "UNION MAN TECHNOLOGY CO.",
    "D43844": "UNION MAN TECHNOLOGY CO.",
    "6C3C8C": "Dell Inc.",
    "C45AB1": "Dell Inc.",
    "A8B028": "CubePilot Pty Ltd",
    "407F5F": "Juniper Networks",
    "2CEA7F": "Dell Inc.",
    "F0D4E2": "Dell Inc.",
    "CC483A": "Dell Inc.",
    "30D042": "Dell Inc.",
    "8C04BA": "Dell Inc.",
    "E454E8": "Dell Inc.",
    "A4BB6D": "Dell Inc.",
    "E4434B": "Dell Inc.",
    "E01F6A": "Huawei Device Co.",
    "00566D": "Huawei Device Co.",
    "90CC7A": "Huawei Device Co.",
    "8CC58C": "ShenZhen Elsky Technology Co.",
    "2C704F": "zte corporation",
    "645234": "Sichuan Tianyi Comheart Telecom Co.",
    "381672": "Shenzhen SuperElectron Technology Co.",
    "6C29D2": "Cisco Systems",
    "08CC81": "Hangzhou Hikvision Digital Technology Co.",
    "F45433": "Rockwell Automation",
    "34C0F9": "Rockwell Automation",
    "5C8816": "Rockwell Automation",
    "0815AE": "China Mobile Group Device Co.",
    "04B4FE": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
    "D45347": "Merytronic 2012",
    "D07B6F": "Zhuhai Yunmai Technology Co.",
    "04A526": "Nokia",
    "20BA36": "u-blox AG",
    "D80AE6": "zte corporation",
    "489E9D": "Hui Zhou Gaoshengda Technology Co.",
    "C0DD8A": "Meta Platforms Technologies",
    "CCA174": "Meta Platforms Technologies",
    "18F46B": "Telenor Connexion AB",
    "28EA0B": "Microsoft Corporation",
    "A41437": "Hangzhou Hikvision Digital Technology Co.",
    "F84DFC": "Hangzhou Hikvision Digital Technology Co.",
    "849A40": "Hangzhou Hikvision Digital Technology Co.",
    "C0517E": "Hangzhou Hikvision Digital Technology Co.",
    "2CA59C": "Hangzhou Hikvision Digital Technology Co.",
    "40ACBF": "Hangzhou Hikvision Digital Technology Co.",
    "98F112": "Hangzhou Hikvision Digital Technology Co.",
    "989DE5": "Hangzhou Hikvision Digital Technology Co.",
    "3C1BF8": "Hangzhou Hikvision Digital Technology Co.",
    "9C65EE": "DZS Inc.",
    "9C5416": "Cisco Systems",
    "48BDA7": "Honor Device Co.",
    "EC2150": "vivo Mobile Communication Co.",
    "A0AF12": "HUAWEI TECHNOLOGIES CO.",
    "6096A4": "HUAWEI TECHNOLOGIES CO.",
    "5C5EAB": "Juniper Networks",
    "7819F7": "Juniper Networks",
    "2C2172": "Juniper Networks",
    "4C9614": "Juniper Networks",
    "784558": "Ubiquiti Inc",
    "AC8BA9": "Ubiquiti Inc",
    "9C05D6": "Ubiquiti Inc",
    "28704E": "Ubiquiti Inc",
    "0017CB": "Juniper Networks",
    "001F12": "Juniper Networks",
    "0024DC": "Juniper Networks",
    "00121E": "Juniper Networks",
    "0010DB": "Juniper Networks",
    "002283": "Juniper Networks",
    "100E7E": "Juniper Networks",
    "44F477": "Juniper Networks",
    "5C6AEC": "IEEE Registration Authority",
    "CC9F7A": "Chiun Mai Communication System",
    "5414A7": "Nanjing Qinheng Microelectronics Co.",
    "4CE705": "Siemens Industrial Automation Products Ltd.",
    "0C7274": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
    "80DB17": "Juniper Networks",
    "B8F015": "Juniper Networks",
    "E4233C": "Juniper Networks",
    "98868B": "Juniper Networks",
    "005828": "Axon Networks Inc.",
    "30B64F": "Juniper Networks",
    "08B258": "Juniper Networks",
    "F4A739": "Juniper Networks",
    "4C16FC": "Juniper Networks",
    "C8E7F0": "Juniper Networks",
    "7C2586": "Juniper Networks",
    "EC3873": "Juniper Networks",
    "C00380": "Juniper Networks",
    "20D80B": "Juniper Networks",
    "94BF94": "Juniper Networks",
    "4C6D58": "Juniper Networks",
    "408F9D": "Juniper Networks",
    "AC78D1": "Juniper Networks",
    "68228E": "Juniper Networks",
    "D8539A": "Juniper Networks",
    "F8C116": "Juniper Networks",
    "880AA3": "Juniper Networks",
    "FC3342": "Juniper Networks",
    "3C8C93": "Juniper Networks",
    "0C8126": "Juniper Networks",
    "182AD3": "Juniper Networks",
    "7495A7": "Keyence Corporation",
    "A0A3B3": "Espressif Inc.",
    "34987A": "Espressif Inc.",
    "685932": "Sunitec Enterprise Co.",
    "B4B9E6": "eero inc.",
    "30B216": "Hitachi Energy Germany AG",
    "88625D": "BITNETWORKS CO.",
    "380716": "FREEBOX SAS",
    "C836A3": "GERTEC BRASIL LTDA",
    "F4EE31": "Cisco Systems",
    "4045C4": "HUAWEI TECHNOLOGIES CO.",
    "74872E": "HUAWEI TECHNOLOGIES CO.",
    "3C1EB5": "Apple",
    "AC86A3": "Apple",
    "001FD6": "Shenzhen Allywll",
    "80D266": "ScaleFlux",
    "E42150": "Shanghai Chint low voltage electrical technology Co.",
    "D404E6": "Broadcom Limited",
    "28EBA6": "Nex-T LLC",
    "C0B3C8": "LLC NTC Rotek",
    "CC4D74": "Fujian Newland Payment Technology Co.",
    "A031EB": "Semikron Elektronik GmbH & Co. KG",
    "F8D758": "Veratron AG",
    "24FE9A": "CyberTAN Technology Inc.",
    "B4CBB8": "Universal Electronics",
    "BC32B2": "Samsung Electronics Co.",
    "EC8A48": "Arista Networks",
    "141A97": "Apple",
    "8C5DB2": "IEEE Registration Authority",
    "88CE3F": "HUAWEI TECHNOLOGIES CO.",
    "ECF8D0": "HUAWEI TECHNOLOGIES CO.",
    "30DF17": "ALPSALPINE CO",
    "D8028A": "Shenzhen YOUHUA Technology Co.",
    "B83C28": "Apple",
    "3C6D89": "Apple",
    "AC4500": "Apple",
    "E86538": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "242A04": "Cisco Systems",
    "141AAA": "Metal Work SpA",
    "CCDEDE": "Nokia",
    "748669": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "C80A35": "Qingdao Hisense Smart Life Technology Co.",
    "886D2D": "Huawei Device Co.",
    "40FF40": "GloquadTech",
    "24952F": "Google",
    "10BE99": "Netberg",
    "84D352": "Tonly Technology Co. Ltd",
    "047056": "Arcadyan Corporation",
    "B894D9": "Texas Instruments",
    "7CE269": "Texas Instruments",
    "0804B4": "Texas Instruments",
    "30AF7E": "Texas Instruments",
    "84B1E4": "Apple",
    "54EBE9": "Apple",
    "AC1615": "Apple",
    "EC7379": "Apple",
    "1CC316": "Xiamen Milesight IoT Co.",
    "3C6A48": "TP-LINK TECHNOLOGIES CO.",
    "FC2A46": "Realme Chongqing Mobile Telecommunications Corp.",
    "9CFA3C": "Daeyoung Electronics",
    "28CF51": "Nintendo Co.",
    "FCB0DE": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "044A6A": "niliwi nanjing big data Co",
    "64C6D2": "Seiko Epson Corporation",
    "0C3526": "Microsoft Corporation",
    "80616C": "New H3C Technologies Co.",
    "40B607": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "481F66": "China Mobile Group Device Co.",
    "782459": "Alcatel-Lucent Enterprise",
    "F44D5C": "Zyxel Communications Corporation",
    "106838": "AzureWave Technology Inc.",
    "78071C": "Green Energy Options Ltd",
    "1C8BEF": "Beijing Xiaomi Electronics Co.",
    "28E297": "Shanghai InfoTM Microelectronics Co.",
    "58F85C": "LLC Proizvodstvennaya Kompania TransService",
    "304449": "PLATH Signal Products GmbH & Co. KG",
    "ECC3B0": "zte corporation",
    "BCBD84": "zte corporation",
    "5CB12E": "Cisco Systems",
    "BC6BFF": "Guangzhou Shiyuan Electronic Technology Company Limited",
    "00301A": "SMARTBRIDGES PTE. LTD.",
    "B457E6": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "70033F": "Pimax Technology(ShangHai)Co.",
    "80F1A4": "HUAWEI TECHNOLOGIES CO.",
    "A46C24": "HUAWEI TECHNOLOGIES CO.",
    "087B12": "Sagemcom Broadband SAS",
    "50D45C": "Amazon Technologies Inc.",
    "44D506": "Sichuan Tianyi Comheart Telecom Co.",
    "2C69CC": "Valeo Detection Systems",
    "D46137": "IEEE Registration Authority",
    "08085C": "Luna Products",
    "2C8AC7": "Ubee Interactive Co.",
    "D0CF0E": "Sagemcom Broadband SAS",
    "80DECC": "HYBE Co.",
    "A0ED6D": "Ubee Interactive Co.",
    "C4EB42": "Sagemcom Broadband SAS",
    "F8345A": "Hitron Technologies. Inc",
    "70C932": "Dreame Technology (Suzhou) Limited",
    "301984": "HUAWEI TECHNOLOGIES CO.",
    "F8C249": "AMPERE COMPUTING LLC",
    "648CBB": "Texas Instruments",
    "74B839": "Texas Instruments",
    "C4D36A": "Texas Instruments",
    "988924": "Texas Instruments",
    "341593": "Ruckus Wireless",
    "B08BBE": "ABL GmbH",
    "0CB937": "Ubee Interactive Co.",
    "440CEE": "Robert Bosch Elektronikai Kft.",
    "A017F1": "Allwinner Technology Co.",
    "2C6F4E": "Hubei Yuan Times Technology Co.",
    "488F4C": "shenzhen trolink  Technology Co.",
    "744D6D": "HUAWEI TECHNOLOGIES CO.",
    "C435D9": "Apple",
    "ACC906": "Apple",
    "04BC6D": "Apple",
    "A8F1B2": "Allwinner Technology Co.",
    "FCE9D8": "Amazon Technologies Inc.",
    "642943": "D-Link Corporation",
    "585B69": "TVT CO.",
    "B8B2F7": "DRIMAES INC.",
    "C49894": "IEEE Registration Authority",
    "8CFADD": "HUAWEI TECHNOLOGIES CO.",
    "F89A25": "HUAWEI TECHNOLOGIES CO.",
    "083A8D": "Espressif Inc.",
    "842388": "Ruckus Wireless",
    "386504": "Honor Device Co.",
    "F8710C": "Xiaomi Communications Co Ltd",
    "3C135A": "Xiaomi Communications Co Ltd",
    "90F82E": "Amazon Technologies Inc.",
    "C084E0": "HUAWEI TECHNOLOGIES CO.",
    "900117": "HUAWEI TECHNOLOGIES CO.",
    "E0B668": "zte corporation",
    "A49DDD": "Samsung Electronics Co.",
    "6C5563": "Samsung Electronics Co.",
    "109F4F": "New H3C Intelligence Terminal Co.",
    "389E80": "zte corporation",
    "880FA2": "Sagemcom Broadband SAS",
    "DC97E6": "Sagemcom Broadband SAS",
    "D492B9": "ORION NOVA",
    "001BB5": "Cherry GmbH",
    "68B8BB": "Beijing Xiaomi Electronics Co.",
    "14AC60": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "1C2285": "Serrature Meroni SpA",
    "80FD7B": "BLU Products Inc",
    "589351": "Huawei Device Co.",
    "2CA7EF": "OnePlus Technology (Shenzhen) Co.",
    "50FDD5": "SJI Industry Company",
    "D0F4F7": "Huawei Device Co.",
    "D4E98A": "Intel Corporate",
    "EC96BF": "eSystems MTG GmbH",
    "D42000": "IEEE Registration Authority",
    "704DE7": "TECNO MOBILE LIMITED",
    "74D873": "GUANGDONG GENIUS TECHNOLOGY CO.",
    "30DE4B": "TP-Link Corporation Limited",
    "682624": "Ergatta",
    "A0218B": "ACE Antenna Co.",
    "2084F5": "Yufei Innovation Software(Shenzhen) Co.",
    "142103": "Calix Inc.",
    "40B15C": "HUAWEI TECHNOLOGIES CO.",
    "28808A": "HUAWEI TECHNOLOGIES CO.",
    "346679": "HUAWEI TECHNOLOGIES CO.",
    "448CAB": "Beijing Flitlink Vientiane Technology Co.",
    "C4D496": "Shenzhen Excelsecu Data Technology Co.",
    "6C97AA": "AI TECHNOLOGY CO.",
    "6C6567": "BELIMO Automation AG",
    "D0DAD7": "Apple",
    "C4ACAA": "Apple",
    "4C24CE": "Sichuan AI-Link Technology Co.",
    "1C97FB": "CoolBitX Ltd.",
    "2C326A": "Apple",
    "6CB133": "Apple",
    "28E71D": "Arista Networks",
    "10E840": "ZOWEE TECHNOLOGY(HEYUAN) CO.",
    "4405E8": "twareLAB",
    "78F1C6": "Cisco Systems",
    "341B2D": "Cisco Systems",
    "843C4C": "Robert Bosch SRL",
    "88287D": "AltoBeam (China) Inc.",
    "445ADF": "MIKAMI & CO.",
    "086E9C": "Huawei Device Co.",
    "4416FA": "Samsung Electronics Co.",
    "FC671F": "Tuya Smart Inc.",
    "78C57D": "Zyxel Communications Corporation",
    "8C3592": "Guangzhou Shiyuan Electronic Technology Company Limited",
    "A0465A": "Motorola Mobility LLC",
    "64B5F2": "Samsung Electronics Co.",
    "8C06CB": "Toradex AG",
    "38A89B": "Fiberhome Telecommunication Technologies Co.",
    "6437A4": "TOKYOSHUHA CO.",
    "90CAFA": "Google",
    "DCAA43": "Shenzhen Terca Information Technology Co.",
    "447147": "Beijing Xiaomi Electronics Co.",
    "F4BBC7": "vivo Mobile Communication Co.",
    "00FBF9": "Axiado Corporation",
    "986610": "zte corporation",
    "A8DC5A": "Digital Watchdog",
    "1C24CD": "ASKEY COMPUTER CORP",
    "6C72E2": "amitek",
    "04D9C8": "Hon Hai Precision Industry Co.",
    "906560": "EM Microelectronic",
    "A0FB83": "Honor Device Co.",
    "DC0B09": "Cisco Systems",
    "08F3FB": "Cisco Systems",
    "A036BC": "ASUSTek COMPUTER INC.",
    "840BBB": "MitraStar Technology Corp.",
    "E00871": "Dongguan Liesheng Electronic Co.",
    "9C956E": "Microchip Technology Inc.",
    "1073EB": "Infiniti Electro-Optics",
    "2CA774": "Texas Instruments",
    "187A3E": "Silicon Laboratories",
    "300505": "Intel Corporate",
    "B0DCEF": "Intel Corporate",
    "7413EA": "Intel Corporate",
    "78C213": "Sagemcom Broadband SAS",
    "4022D8": "Espressif Inc.",
    "184E03": "HMD Global Oy",
    "70B306": "Apple",
    "B8496D": "Apple",
    "9C924F": "Apple",
    "200E2B": "Apple",
    "F0D793": "Apple",
    "DCF31C": "Texas Instruments",
    "544538": "Texas Instruments",
    "303D51": "IEEE Registration Authority",
    "38F0C8": "Logitech",
    "34FE1C": "CHOUNG HWA TECH CO.",
    "60CF69": "meerecompany",
    "4C627B": "SmartCow AI Technologies Taiwan Ltd.",
    "28BC05": "BLU Products Inc",
    "1CEF03": "Guangzhou V-SOLUTION Electronic Technology Co.",
    "58B03E": "Nintendo Co.",
    "AC4E65": "Fiberhome Telecommunication Technologies Co.",
    "A88038": "ShenZhen MovingComm Technology Co.",
    "BC5DA3": "Sichuan Tianyi Comheart Telecom Co.",
    "BC7B72": "Huawei Device Co.",
    "F82B7F": "Huawei Device Co.",
    "40C3BC": "Huawei Device Co.",
    "2853E0": "Sintela Ltd",
    "D868A0": "Samsung Electronics Co.",
    "04292E": "Samsung Electronics Co.",
    "687FF0": "TP-Link Corporation Limited",
    "345DA8": "Cisco Systems",
    "E0806B": "Xiaomi Communications Co Ltd",
    "7050E7": "IEEE Registration Authority",
    "70AC08": "Silicon Laboratories",
    "38FDF5": "Renesas Electronics (Penang) Sdn. Bhd.",
    "3C26E4": "Cisco Systems",
    "3891B7": "Cisco Systems",
    "DC360C": "Hitron Technologies. Inc",
    "38127B": "Crenet Labs Co.",
    "B0E45C": "Samsung Electronics Co.",
    "88F2BD": "GD Midea Air-Conditioning Equipment Co.",
    "6C0831": "ANALOG SYSTEMS",
    "A47EFA": "Withings",
    "7891DE": "Guangdong ACIGA Science&Technology Co.",
    "BC4CA0": "HUAWEI TECHNOLOGIES CO.",
    "74342B": "HUAWEI TECHNOLOGIES CO.",
    "C412EC": "HUAWEI TECHNOLOGIES CO.",
    "ACA32F": "Solidigm Technology",
    "4C9E6C": "BROADEX TECHNOLOGIES CO.LTD",
    "8C9806": "SHENZHEN SEI ROBOTICS CO.",
    "200889": "zte corporation",
    "200BCF": "Nintendo Co.",
    "7070FC": "GOLD&WATER INDUSTRIAL LIMITED",
    "98D93D": "Demant Enterprise A/S",
    "B4A678": "Zhejiang Tmall Technology Co.",
    "ACC4BD": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "E4B633": "Wuxi Stars Microsystem Technology Co.",
    "085104": "Huawei Device Co.",
    "785B64": "Huawei Device Co.",
    "54E15B": "Huawei Device Co.",
    "2426D6": "HUAWEI TECHNOLOGIES CO.",
    "EC819C": "HUAWEI TECHNOLOGIES CO.",
    "C4A10E": "IEEE Registration Authority",
    "542F04": "Shanghai Longcheer Technology Co.",
    "1CA410": "Amlogic",
    "98C81C": "BAYTEC LIMITED",
    "748469": "Nintendo Co.",
    "8CCBDF": "FOXCONN INTERCONNECT TECHNOLOGY",
    "200B16": "Texas Instruments",
    "8801F9": "Texas Instruments",
    "F85548": "Texas Instruments",
    "68E74A": "Texas Instruments",
    "70A6BD": "Honor Device Co.",
    "846993": "HP Inc.",
    "746F88": "zte corporation",
    "74718B": "Apple",
    "70317F": "Apple",
    "A4CF99": "Apple",
    "4C2EB4": "Apple",
    "D0989C": "ConMet",
    "34AD61": "CELESTICA INC.",
    "2C553C": "Vecima Networks Inc.",
    "5443B2": "Espressif Inc.",
    "B41974": "Apple",
    "6095BD": "Apple",
    "EC1127": "Texas Instruments",
    "04E892": "SHENNAN CIRCUITS CO.",
    "BCE9E2": "Brocade Communications Systems LLC",
    "18A59C": "IEEE Registration Authority",
    "10961A": "CHIPSEA TECHNOLOGIES (SHENZHEN) CORP.",
    "ACBF71": "Bose Corporation",
    "ACD31D": "Cisco Meraki",
    "74563C": "GIGA-BYTE TECHNOLOGY CO.",
    "EC551C": "HUAWEI TECHNOLOGIES CO.",
    "B48351": "Intel Corporate",
    "BCF4D4": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "CCF305": "SHENZHEN TIAN XING CHUANG ZHAN ELECTRONIC CO.",
    "04B97D": "AiVIS Co.",
    "C4C063": "New H3C Technologies Co.",
    "E0798D": "Silicon Laboratories",
    "34BD20": "Hangzhou Hikrobot Technology Co.",
    "64C269": "eero inc.",
    "AC2AA1": "Cisco Systems",
    "F8E94F": "Cisco Systems",
    "30894A": "Intel Corporate",
    "D89C8E": "Comcast Cable Corporation",
    "0025CA": "Laird Connectivity",
    "E06CC5": "Huawei Device Co.",
    "30963B": "Huawei Device Co.",
    "8C6BDB": "Huawei Device Co.",
    "10DA49": "Huawei Device Co.",
    "60183A": "Huawei Device Co.",
    "18C007": "Huawei Device Co.",
    "98597A": "Intel Corporate",
    "64497D": "Intel Corporate",
    "B8D61A": "Espressif Inc.",
    "BC6E6D": "EM Microelectronic",
    "00D49E": "Intel Corporate",
    "3492C2": "Square Route Co.",
    "8C1759": "Intel Corporate",
    "B83FD2": "Mellanox Technologies",
    "30CB36": "Belden Singapore Pte. Ltd.",
    "30BB7D": "OnePlus Technology (Shenzhen) Co.",
    "6C67EF": "HUAWEI TECHNOLOGIES CO.",
    "88693D": "HUAWEI TECHNOLOGIES CO.",
    "00991D": "HUAWEI TECHNOLOGIES CO.",
    "283E0C": "Preferred Robotics",
    "04BC9F": "Calix Inc.",
    "6CA401": "essensys plc",
    "B04A6A": "Samsung Electronics Co.",
    "A8798D": "Samsung Electronics Co.",
    "5CEDF4": "Samsung Electronics Co.",
    "283DC2": "Samsung Electronics Co.",
    "B42875": "Futecho Solutions Private Limited",
    "302364": "Nokia Shanghai Bell Co.",
    "0C1C1A": "eero inc.",
    "4851D0": "Jiangsu Xinsheng Intelligent Technology Co.",
    "DC9A7D": "HISENSE VISUAL TECHNOLOGY CO.",
    "84F1D0": "EHOOME IOT PRIVATE LIMITED",
    "208BD1": "NXP Semiconductor (Tianjin) LTD.",
    "2C07F6": "SKG Health Technologies Co.",
    "3868BE": "Sichuan Tianyi Comheart Telecom Co.",
    "28A53F": "vivo Mobile Communication Co.",
    "8C49B6": "vivo Mobile Communication Co.",
    "8077A4": "TECNO MOBILE LIMITED",
    "7C6CF0": "Shenzhen TINNO Mobile Technology Corp.",
    "00C30A": "Xiaomi Communications Co Ltd",
    "8852EB": "Xiaomi Communications Co Ltd",
    "0857FB": "Amazon Technologies Inc.",
    "00D0FC": "GRANITE MICROSYSTEMS",
    "B0DE28": "Apple",
    "7C131D": "SERNET (SUZHOU) TECHNOLOGIES CORPORATION",
    "D49FDD": "Huawei Device Co.",
    "00D8A2": "Huawei Device Co.",
    "DC6B1B": "Huawei Device Co.",
    "D06DC9": "Sagemcom Broadband SAS",
    "DC152D": "China Mobile Group Device Co.",
    "98CA20": "Shanghai SIMCOM Ltd.",
    "D850A1": "Hunan Danuo Technology Co.",
    "441AAC": "Elektrik Uretim AS EOS",
    "342840": "Apple",
    "18E7B0": "Apple",
    "50578A": "Apple",
    "D833B7": "Sagemcom Broadband SAS",
    "D4FB8E": "Apple",
    "2C784C": "Iton Technology Corp.",
    "488759": "Xiaomi Communications Co Ltd",
    "AC1E9E": "Xiaomi Communications Co Ltd",
    "D01B1F": "OHSUNG",
    "E0AEA2": "HUAWEI TECHNOLOGIES CO.",
    "44456F": "SHENZHEN ONEGA TECHNOLOGY CO.",
    "E8FDF8": "Shanghai High-Flying Electronics  Technology Co.",
    "C01803": "HP Inc.",
    "04CF4B": "Intel Corporate",
    "FC38C4": "China Grand Communications Co.",
    "5CF51A": "Zhejiang Dahua Technology Co.",
    "101D51": "8Mesh Networks Limited",
    "34976F": "Rootech",
    "6C6C0F": "HUAWEI TECHNOLOGIES CO.",
    "CC8CBF": "Tuya Smart Inc.",
    "F897A9": "Ericsson AB",
    "AC93C4": "GD Midea Air-Conditioning Equipment Co.",
    "000688": "Telways Communication Co.",
    "EC9B2D": "China Mobile Group Device Co.",
    "A81306": "vivo Mobile Communication Co.",
    "1C34F1": "Silicon Laboratories",
    "CC7D5B": "Telink Semiconductor (Shanghai) Co.",
    "749552": "Xuzhou WIKA Electronics Control Technology Co.",
    "44EA30": "Samsung Electronics Co.",
    "845F04": "Samsung Electronics Co.",
    "9C2F9D": "Liteon Technology Corporation",
    "A4F33B": "zte corporation",
    "30E7BC": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "4CFE2E": "DongGuan Siyoto Electronics Co.",
    "0C4EC0": "Maxlinear Inc",
    "901195": "Amazon Technologies Inc.",
    "7CB566": "Intel Corporate",
    "40329D": "Union Image Co.",
    "50A030": "IEEE Registration Authority",
    "6C4BB4": "HUMAX Co.",
    "589BF7": "Hefei Radio Communication Technology Co.",
    "000E24": "Huwell Technology Inc.",
    "4C7713": "Renesas Electronics (Penang) Sdn. Bhd.",
    "D8AA59": "Tonly Technology Co. Ltd",
    "64CF13": "Weigao Nikkiso(Weihai)Dialysis Equipment Co.",
    "50E9DF": "Quectel Wireless Solutions Co.",
    "E8FA23": "Huawei Device Co.",
    "EC3A52": "Huawei Device Co.",
    "441B88": "Apple",
    "80045F": "Apple",
    "9C3E53": "Apple",
    "C889F3": "Apple",
    "10B9C4": "Apple",
    "60109E": "HUAWEI TECHNOLOGIES CO.",
    "480286": "Realme Chongqing Mobile Telecommunications Corp.",
    "94DEB8": "Silicon Laboratories",
    "040D84": "Silicon Laboratories",
    "4C195D": "Sagemcom Broadband SAS",
    "9C7403": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "3CECDE": "FUJIAN STAR-NET COMMUNICATION CO.",
    "9C6B00": "ASRock Incorporation",
    "54F82A": "u-blox AG",
    "D43538": "Beijing Xiaomi Mobile Software Co.",
    "10CE02": "Amazon Technologies Inc.",
    "98672E": "Skullcandy",
    "A83A48": "Ubiqcom India Pvt Ltd",
    "C85ACF": "HP Inc.",
    "FC29E3": "Infinix mobility limited",
    "9C1C6D": "HEFEI DATANG STORAGE TECHNOLOGY CO.",
    "641ABA": "Dryad Networks GmbH",
    "349454": "Espressif Inc.",
    "0013DC": "IBTEK INC.",
    "D84A2B": "zte corporation",
    "D0F99B": "zte corporation",
    "F41399": "Aerospace new generation communications Co.",
    "94A9A8": "Texas Instruments",
    "48B423": "Amazon Technologies Inc.",
    "7070AA": "Amazon Technologies Inc.",
    "642FC7": "New H3C Technologies Co.",
    "6026AA": "Cisco Systems",
    "5C3192": "Cisco Systems",
    "88C227": "HUAWEI TECHNOLOGIES CO.",
    "8054D9": "HUAWEI TECHNOLOGIES CO.",
    "9C8566": "Wingtech Mobile Communications Co.",
    "B03366": "vivo Mobile Communication Co.",
    "7CC225": "Samsung Electronics Co.",
    "D413F8": "Peplink International Ltd.",
    "001117": "CESNET",
    "9CEC61": "Huawei Device Co.",
    "747069": "Huawei Device Co.",
    "14FB70": "Huawei Device Co.",
    "84D3D5": "Huawei Device Co.",
    "9C00D3": "SHENZHEN IK WORLD Technology Co.",
    "282D06": "AMPAK Technology",
    "202B20": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "A0A309": "Apple",
    "5C50D9": "Apple",
    "E8CAC8": "Hui Zhou Gaoshengda Technology Co.",
    "D419F6": "NXP Semiconductor (Tianjin) LTD.",
    "64BF6B": "HUAWEI TECHNOLOGIES CO.",
    "30499E": "HUAWEI TECHNOLOGIES CO.",
    "884D7C": "Apple",
    "A8FE9D": "Apple",
    "DC973A": "Verana Networks",
    "FC7692": "Semptian Co.",
    "FCAFBE": "TireCheck GmbH",
    "1848BE": "Amazon Technologies Inc.",
    "202027": "Shenzhen Sundray Technologies Company Limited",
    "686725": "Espressif Inc.",
    "886EE1": "Erbe Elektromedizin GmbH",
    "C475AB": "Intel Corporate",
    "C8418A": "Samsung Electronics.",
    "547D40": "Powervision Tech Inc.",
    "C0D7AA": "Arcadyan Corporation",
    "ACACE2": "CHANGHONG (HONGKONG) TRADING LIMITED",
    "80B745": "The Silk Technologies ILC LTD",
    "F89E94": "Intel Corporate",
    "C403A8": "Intel Corporate",
    "0CB088": "AITelecom",
    "2066FD": "CONSTELL8 NV",
    "644212": "Shenzhen Water World Information Co.",
    "4CABF8": "ASKEY COMPUTER CORP",
    "8C5646": "LG Electronics",
    "CC7190": "VIETNAM POST AND TELECOMMUNICATION INDUSTRY TECHNOLOGY JOINT STOCK COMPANY",
    "48BD4A": "HUAWEI TECHNOLOGIES CO.",
    "A8D4E0": "HUAWEI TECHNOLOGIES CO.",
    "A0406F": "HUAWEI TECHNOLOGIES CO.",
    "004F1A": "HUAWEI TECHNOLOGIES CO.",
    "7433A6": "Shenzhen SuperElectron Technology Co.",
    "2C0DA7": "Intel Corporate",
    "D463DE": "vivo Mobile Communication Co.",
    "D4B7D0": "Ciena Corporation",
    "1400E9": "Mitel Networks Corporation",
    "0C9043": "Realme Chongqing Mobile Telecommunications Corp.",
    "541F8D": "zte corporation",
    "2CF1BB": "zte corporation",
    "BC2CE6": "Cisco Systems",
    "CCED4D": "Cisco Systems",
    "18A9A6": "Nebra Ltd",
    "B0F7C4": "Amazon Technologies Inc.",
    "4C8D53": "HUAWEI TECHNOLOGIES CO.",
    "6C0F0B": "China Mobile Group Device Co.",
    "DC2C6E": "Routerboard.com",
    "C4BDE5": "Intel Corporate",
    "3453D2": "Sagemcom Broadband SAS",
    "3429EF": "Qingdao Haier Technology Co.",
    "A0B53C": "Technicolor Delivery Technologies Belgium NV",
    "541D61": "YEESTOR Microelectronics Co.",
    "700971": "Samsung Electronics Co.",
    "D01B49": "Samsung Electronics Co.",
    "FC5F49": "Zhejiang Dahua Technology Co.",
    "3035C5": "Huawei Device Co.",
    "18EF3A": "Sichuan AI-Link Technology Co.",
    "A0FF22": "SHENZHEN APICAL TECHNOLOGY CO.",
    "F820A9": "Huawei Device Co.",
    "649E31": "Beijing Xiaomi Mobile Software Co.",
    "6CB0FD": "Shenzhen Xinghai Iot Technology Co.",
    "24CD8D": "Murata Manufacturing Co.",
    "5C0214": "Beijing Xiaomi Mobile Software Co.",
    "E42805": "Pivotal Optics",
    "381F8D": "Tuya Smart Inc.",
    "208C47": "Tenstorrent Inc",
    "6815D3": "Zaklady Elektroniki i Mechaniki Precyzyjnej R&G S.A.",
    "0080E7": "Leonardo UK Ltd",
    "3C9FC3": "Beijing Sinead Technology Co.",
    "00B0EC": "EACEM",
    "6CD3EE": "ZIMI CORPORATION",
    "04CD15": "Silicon Laboratories",
    "785EA2": "Sunitec Enterprise Co.",
    "B0BE83": "Apple",
    "10321D": "HUAWEI TECHNOLOGIES CO.",
    "E4936A": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "4877BD": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "F856C3": "zte corporation",
    "38FDF8": "Cisco Systems",
    "DCF4CA": "Apple",
    "7CFC16": "Apple",
    "88B945": "Apple",
    "18E1DE": "Chengdu ChipIntelli Technology Co.",
    "8CF681": "Silicon Laboratories",
    "7C66EF": "Hon Hai Precision IND.CO.",
    "441793": "Espressif Inc.",
    "00A388": "SKY UK LIMITED",
    "7CC177": "INGRAM MICRO SERVICES",
    "7876D9": "EXARA Group",
    "94A408": "Shenzhen Trolink Technology CO",
    "7C8437": "China Post Communications Equipment Co.",
    "B84D43": "HUNAN FN-LINK TECHNOLOGY LIMITED",
    "D0F865": "ITEL MOBILE LIMITED",
    "C89F1A": "HUAWEI TECHNOLOGIES CO.",
    "D86852": "HUAWEI TECHNOLOGIES CO.",
    "AC6490": "HUAWEI TECHNOLOGIES CO.",
    "A84A63": "TPV Display Technology(Xiamen) Co.",
    "608FA4": "Nokia Solutions and Networks GmbH & Co. KG",
    "243FAA": "Huawei Device Co.",
    "D867D3": "Huawei Device Co.",
    "48474B": "Huawei Device Co.",
    "806F1C": "Huawei Device Co.",
    "E0A258": "Wanbang Digital Energy Co.",
    "4CBCE9": "LG Innotek",
    "385C76": "PLANTRONICS",
    "9C50D1": "Murata Manufacturing Co.",
    "140020": "LongSung Technology (Shanghai) Co.",
    "30B930": "zte corporation",
    "949869": "zte corporation",
    "503DEB": "Zhejiang Tmall Technology Co.",
    "F87FA5": "GREATEK",
    "745CFA": "Shenzhen Shunrui Gaojie Technology Co.",
    "5CDFB8": "Shenzhen Unionmemory Information System Limited",
    "2C1A05": "Cisco Systems",
    "B40ECF": "Bouffalo Lab (Nanjing) Co.",
    "F83869": "LG Electronics",
    "2C0547": "Shenzhen Phaten Tech. LTD",
    "E0C58F": "China Mobile IOT Company Limited",
    "E00AF6": "Liteon Technology Corporation",
    "F05ECD": "Texas Instruments",
    "2C3A91": "Huawei Device Co.",
    "64F705": "Huawei Device Co.",
    "785005": "MOKO TECHNOLOGY Ltd",
    "F0B61E": "Intel Corporate",
    "C84D44": "Shenzhen Jiapeng Huaxiang Technology Co.",
    "98B177": "LANDIS + GYR",
    "A029BD": "Team Group Inc",
    "64DCDE": "ZheJiang FuChunJiang Information Technology Co.",
    "00919E": "Intel Corporate",
    "60CE41": "HUAWEI TECHNOLOGIES CO.",
    "281709": "HUAWEI TECHNOLOGIES CO.",
    "606EE8": "Xiaomi Communications Co Ltd",
    "EC97E0": "Hangzhou Ezviz Software Co.",
    "D0B66F": "SERNET (SUZHOU) TECHNOLOGIES CORPORATION",
    "3009C0": "Motorola Mobility LLC",
    "FC2E19": "China Mobile Group Device Co.",
    "50F908": "Wizardlab Co.",
    "EC94CB": "Espressif Inc.",
    "50C2E8": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "B04692": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "AC764C": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "5C58E6": "Palo Alto Networks",
    "0CE159": "Shenzhen iStartek Technology Co.",
    "001413": "Trebing & Himstedt Prozeßautomation GmbH & Co. KG",
    "000799": "Tipping Point Technologies",
    "DC8D8A": "Nokia Solutions and Networks GmbH & Co. KG",
    "7086CE": "GD Midea Air-Conditioning Equipment Co.",
    "500F59": "STMicrolectronics International NV",
    "E42AAC": "Microsoft Corporation",
    "20E7B6": "Universal Electronics",
    "D43DF3": "Zyxel Communications Corporation",
    "20579E": "HUNAN FN-LINK TECHNOLOGY LIMITED",
    "C884CF": "HUAWEI TECHNOLOGIES CO.",
    "E023D7": "Sleep Number",
    "241D48": "Sichuan Tianyi Comheart Telecom Co.",
    "287777": "zte corporation",
    "60E32B": "Intel Corporate",
    "D8BE65": "Amazon Technologies Inc.",
    "28DEA8": "zte corporation",
    "808ABD": "Samsung Electronics Co.",
    "3CCD57": "Beijing Xiaomi Mobile Software Co.",
    "806A10": "Whisker Labs - Ting",
    "C0F827": "Rapidmax Technology Corporation",
    "245E48": "Apple",
    "08C729": "Apple",
    "C4C36B": "Apple",
    "E8A730": "Apple",
    "6006E3": "Apple",
    "ACEC85": "eero inc.",
    "106FD9": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "584D42": "Dragos",
    "608A10": "Microchip Technology Inc.",
    "A864F1": "Intel Corporate",
    "D01E1D": "SaiNXT Technologies LLP",
    "E06781": "Dongguan Liesheng Electronic Co.",
    "B8DAE8": "Huawei Device Co.",
    "B8AE1D": "Guangzhou Xingyi Electronic Technology Co.",
    "D4548B": "Intel Corporate",
    "1009F9": "Amazon Technologies Inc.",
    "D03E7D": "CHIPSEA TECHNOLOGIES (SHENZHEN) CORP.",
    "906976": "Withrobot Inc.",
    "FC9257": "Renesas Electronics (Penang) Sdn. Bhd.",
    "60DB15": "New H3C Technologies Co.",
    "5CA721": "New H3C Technologies Co.",
    "A42A71": "Sichuan Tianyi Comheart Telecom Co.",
    "60A5E2": "Intel Corporate",
    "48F8FF": "CHENGDU KT ELECTRONIC HI-TECH CO.",
    "E8C1E8": "Shenzhen Xiao Bi En Culture Education Technology Co.",
    "7C70DB": "Intel Corporate",
    "8C94CC": "SFR",
    "98F217": "Castlenet Technology Inc.",
    "84EBEF": "Cisco Systems",
    "A82316": "Nokia",
    "38E39F": "Motorola Mobility LLC",
    "908060": "Nilfisk A/S",
    "70A6CC": "Intel Corporate",
    "6C433C": "TECNO MOBILE LIMITED",
    "78BB88": "Maxio Technology (Hangzhou) Ltd.",
    "446752": "Wistron INFOCOMM (Zhongshan) CORPORATION",
    "60B6E1": "Texas Instruments",
    "6C79B8": "Texas Instruments",
    "8CA399": "SERVERCOM (INDIA) PRIVATE LIMITED",
    "D48DD9": "Meld Technology",
    "582FF7": "Sagemcom Broadband SAS",
    "ACE77B": "Sichuan Tianyi Comheart Telecom Co.",
    "40F420": "Sichuan Tianyi Comheart Telecom Co.",
    "645D92": "Sichuan Tianyi Comheart Telecom Co.",
    "8CFD15": "Imagine Marketing Private Limited",
    "14223B": "Google",
    "C4FF22": "Huawei Device Co.",
    "A0A0DC": "Huawei Device Co.",
    "C4808A": "Cloud Diagnostics Canada ULC",
    "2CDDE9": "Arista Networks",
    "709741": "Arcadyan Corporation",
    "E408E7": "Quectel Wireless Solutions Co.",
    "0C8DCA": "Samsung Electronics Co.",
    "CC0DE7": "B METERS S.R.L.",
    "4456E2": "Sichuan Tianyi Comheart Telecom Co.",
    "683A48": "SAMJIN Co.",
    "CCA260": "Sichuan Tianyi Comheart Telecom Co.",
    "9C6121": "Sichuan Tianyi Comheart Telecom Co.",
    "E04FBD": "Sichuan Tianyi Comheart Telecom Co.",
    "5CA176": "Sichuan Tianyi Comheart Telecom Co.",
    "4CD3AF": "HMD Global Oy",
    "C85142": "Samsung Electronics Co.",
    "10E4C2": "Samsung Electronics Co.",
    "ACD829": "Bouffalo Lab (Nanjing) Co.",
    "5C625A": "CANON INC.",
    "7C0A3F": "Samsung Electronics Co.",
    "08AA89": "zte corporation",
    "04D60E": "FUNAI ELECTRIC CO.",
    "B0C952": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "D0E042": "Cisco Systems",
    "C47469": "BT9",
    "F46FA4": "Physik Instrumente GmbH & Co. KG",
    "C8BB81": "Huawei Device Co.",
    "1C472F": "Huawei Device Co.",
    "205E64": "Huawei Device Co.",
    "F4419E": "Huawei Device Co.",
    "90F9B7": "HUAWEI TECHNOLOGIES CO.",
    "F44588": "HUAWEI TECHNOLOGIES CO.",
    "60577D": "eero inc.",
    "3C3712": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
    "54AED2": "CSL Dualcom Ltd",
    "80B655": "Intel Corporate",
    "0CCB0C": "iSYS RTS GmbH",
    "F44EE3": "Intel Corporate",
    "78F235": "Sichuan AI-Link Technology Co.",
    "082FE9": "HUAWEI TECHNOLOGIES CO.",
    "984874": "HUAWEI TECHNOLOGIES CO.",
    "1CA681": "HUAWEI TECHNOLOGIES CO.",
    "E8A660": "HUAWEI TECHNOLOGIES CO.",
    "CC242E": "Shenzhen SuperElectron Technology Co.",
    "F0016E": "Tianyi Telecom Terminals Company Limited",
    "EC0BAE": "Hangzhou BroadLink Technology Co.",
    "802511": "ITEL MOBILE LIMITED",
    "3802DE": "Sercomm Corporation.",
    "D0CFD8": "Huizhou Boshijie Technology Co.",
    "2CBEEB": "Nothing Technology Limited",
    "7409AC": "Quext",
    "F04A02": "Cisco Systems",
    "509A46": "Safetrust Inc",
    "A4352D": "TRIZ Networks corp.",
    "B881FA": "Apple",
    "9C760E": "Apple",
    "94EA32": "Apple",
    "50F4EB": "Apple",
    "28C709": "Apple",
    "082E36": "Huawei Device Co.",
    "C8BFFE": "Huawei Device Co.",
    "049F81": "NETSCOUT SYSTEMS INC",
    "00808C": "NETSCOUT SYSTEMS INC",
    "4024B2": "Sichuan AI-Link Technology Co.",
    "640D22": "LG Electronics (Mobile Communications)",
    "8C31E2": "DAYOUPLUS",
    "10394E": "Hisense broadband multimedia technology Co.",
    "20A7F9": "SHENZHEN OLANBOA TECHNOLOGY CO.",
    "C006C3": "TP-Link Corporation Limited",
    "F4C7AA": "Marvell Semiconductors",
    "70F088": "Nintendo Co.",
    "CCED21": "Nokia Shanghai Bell Co.",
    "FC4DA6": "HUAWEI TECHNOLOGIES CO.",
    "3C1512": "Shenzhen Huanhu Technology Co.",
    "18C241": "SonicWall",
    "58454C": "Ericsson AB",
    "B414E6": "HUAWEI TECHNOLOGIES CO.",
    "AC9929": "HUAWEI TECHNOLOGIES CO.",
    "04BA1C": "Huawei Device Co.",
    "7C3D2B": "Huawei Device Co.",
    "14517E": "New H3C Technologies Co.",
    "083A38": "New H3C Technologies Co.",
    "F8ABE5": "shenzhen worldelite electronics co.",
    "08BB3C": "Flextronics Tech.(Ind) Pvt Ltd",
    "10D561": "Tuya Smart Inc.",
    "F0A3B2": "Hui Zhou Gaoshengda Technology Co.",
    "184859": "Castlenet Technology Inc.",
    "2CFDB3": "Tonly Technology Co. Ltd",
    "2CCE1E": "Cloudtronics Pty Ltd",
    "DC9A8E": "Nanjing Cocomm electronics co.",
    "58AEF1": "Fiberhome Telecommunication Technologies Co.",
    "E86CC7": "IEEE Registration Authority",
    "C0D46B": "Huawei Device Co.",
    "9C9567": "Huawei Device Co.",
    "A47B1A": "Huawei Device Co.",
    "D85982": "HUAWEI TECHNOLOGIES CO.",
    "48B25D": "HUAWEI TECHNOLOGIES CO.",
    "A41B34": "China Mobile Group Device Co.",
    "147D05": "SERCOMM PHILIPPINES INC",
    "787A6F": "Juice Technology AG",
    "641759": "Intellivision Holdings",
    "504348": "ThingsMatrix Inc.",
    "8045DD": "Intel Corporate",
    "002DB3": "AMPAK Technology",
    "E4FD45": "Intel Corporate",
    "145051": "SHARP Corporation",
    "3CC786": "DONGGUAN HUARONG COMMUNICATION TECHNOLOGIES CO.",
    "A47E36": "EM Microelectronic",
    "98387D": "ITRONIC  TECHNOLOGY CO .",
    "ACD618": "OnePlus Technology (Shenzhen) Co.",
    "6C5640": "BLU Products Inc",
    "88C3E5": "Betop Techonologies",
    "E428A4": "Prama India Private Limited",
    "943A91": "Amazon Technologies Inc.",
    "184CAE": "CONTINENTAL",
    "C4D0E3": "Intel Corporate",
    "28C87C": "zte corporation",
    "307C4A": "Huawei Device Co.",
    "C8D884": "Universal Electronics",
    "B4A25C": "Cambium Networks Limited",
    "2C71FF": "Amazon Technologies Inc.",
    "DC0077": "TP-LINK TECHNOLOGIES CO.",
    "48785E": "Amazon Technologies Inc.",
    "20C74F": "SensorPush",
    "24E853": "LG Innotek",
    "482952": "Sagemcom Broadband SAS",
    "F021E0": "eero inc.",
    "606C63": "Hitron Technologies. Inc",
    "00F361": "Amazon Technologies Inc.",
    "0040DD": "HONG TECHNOLOGIES",
    "408C1F": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "04F03E": "Huawei Device Co.",
    "E8D765": "HUAWEI TECHNOLOGIES CO.",
    "502DFB": "IGShare Co.",
    "40EE15": "Zioncom Electronics (Shenzhen) Ltd.",
    "6C0DE1": "Dongguan Cannice Precision Manufacturing Co.",
    "6C0309": "Cisco Systems",
    "BCD295": "Cisco Systems",
    "80C501": "OctoGate IT Security Systems GmbH",
    "14D19E": "Apple",
    "40C711": "Apple",
    "5C7017": "Apple",
    "8CEC7B": "Apple",
    "C430CA": "SD Biosensor",
    "28052E": "Dematic Corp",
    "E45E1B": "Google",
    "78E22C": "Huawei Device Co.",
    "C0D026": "Huawei Device Co.",
    "A4423B": "Intel Corporate",
    "ECBE5F": "Vestel Elektronik San ve Tic. A.S.",
    "70CF49": "Intel Corporate",
    "4851C5": "Intel Corporate",
    "F42A7D": "TP-LINK TECHNOLOGIES CO.",
    "04F993": "Infinix mobility limited",
    "BCBD9E": "ITEL MOBILE LIMITED",
    "BC6D05": "Dusun Electron Co.",
    "C0E018": "HUAWEI TECHNOLOGIES CO.",
    "5CE747": "HUAWEI TECHNOLOGIES CO.",
    "A8FFBA": "HUAWEI TECHNOLOGIES CO.",
    "F03965": "Samsung Electronics Co.",
    "EC7CB6": "Samsung Electronics Co.",
    "58A639": "Samsung Electronics Co.",
    "A4E57C": "Espressif Inc.",
    "8C0FC9": "Huawei Device Co.",
    "304E1B": "Huawei Device Co.",
    "74504E": "New H3C Technologies Co.",
    "7CC2C6": "TP-Link Corporation Limited",
    "089AC7": "zte corporation",
    "744CA1": "Liteon Technology Corporation",
    "B4B291": "LG Electronics",
    "D80093": "Aurender Inc.",
    "389052": "HUAWEI TECHNOLOGIES CO.",
    "C0F6EC": "HUAWEI TECHNOLOGIES CO.",
    "CC208C": "HUAWEI TECHNOLOGIES CO.",
    "885A85": "Wistron Neweb Corporation",
    "948ED3": "Arista Networks",
    "24E4C8": "Fiberhome Telecommunication Technologies Co.",
    "687627": "Zhuhai Dingzhi Electronic Technology Co.",
    "C86C3D": "Amazon Technologies Inc.",
    "70617B": "Cisco Systems",
    "A0024A": "IEEE Registration Authority",
    "04E77E": "We Corporation Inc.",
    "74ECB2": "Amazon Technologies Inc.",
    "4C52EC": "SOLARWATT GmbH",
    "E01FED": "Nokia Shanghai Bell Co.",
    "30D941": "Raydium Semiconductor Corp.",
    "146B9A": "zte corporation",
    "9C28B3": "Apple",
    "A07817": "Apple",
    "5C8730": "Apple",
    "A4AAFE": "Huawei Device Co.",
    "F83B7E": "Huawei Device Co.",
    "8815C5": "Huawei Device Co.",
    "B41BB0": "Apple",
    "58D349": "Apple",
    "F434F0": "Apple",
    "B08C75": "Apple",
    "7040FF": "Huawei Device Co.",
    "34D693": "Huawei Device Co.",
    "9C9AC0": "LEGO System A/S",
    "A09F10": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
    "201B88": "Dongguan Liesheng Electronic Co.",
    "E8EB34": "Cisco Systems",
    "3CBDC5": "Arcadyan Corporation",
    "A8DA0C": "SERVERCOM (INDIA) PRIVATE LIMITED",
    "249493": "FibRSol Global Network Limited",
    "28D044": "Shenzhen Xinyin technology company",
    "5C10C5": "Samsung Electronics Co.",
    "A8407D": "GD Midea Air-Conditioning Equipment Co.",
    "FC4B57": "Peerless Instrument Division of Curtiss-Wright",
    "74B7B3": "Shenzhen YOUHUA Technology Co.",
    "DC9BD6": "TCT mobile ltd",
    "DC8C1B": "vivo Mobile Communication Co.",
    "F85329": "HUAWEI TECHNOLOGIES CO.",
    "E80AEC": "Jiangsu Hengtong Optic-Electric Co.",
    "C4DE7B": "Huawei Device Co.",
    "6C1A75": "Huawei Device Co.",
    "40D4BD": "SK Networks Service CO.",
    "841B77": "Intel Corporate",
    "7CC294": "Beijing Xiaomi Mobile Software Co.",
    "E0E2E6": "Espressif Inc.",
    "6C7637": "Huawei Device Co.",
    "68D48B": "Hailo Technologies Ltd.",
    "C43772": "Virtuozzo International GmbH",
    "CC3B27": "TECNO MOBILE LIMITED",
    "3CD2E5": "New H3C Technologies Co.",
    "9C7370": "HUAWEI TECHNOLOGIES CO.",
    "983F60": "HUAWEI TECHNOLOGIES CO.",
    "C03FDD": "HUAWEI TECHNOLOGIES CO.",
    "303235": "Qingdao Intelligent&Precise Electronics Co.",
    "00301F": "OPTICAL NETWORKS",
    "0858A5": "Beijing Vrv Software Corpoaration Limited.",
    "18EE86": "Novatel Wireless Solutions",
    "001391": "OUEN CO.",
    "582429": "Google",
    "7C73EB": "Huawei Device Co.",
    "E48F1D": "Huawei Device Co.",
    "CCF55F": "E FOCUS INSTRUMENTS INDIA PRIVATE LIMITED",
    "087C39": "Amazon Technologies Inc.",
    "141333": "AzureWave Technology Inc.",
    "A4178B": "HUAWEI TECHNOLOGIES CO.",
    "94B271": "HUAWEI TECHNOLOGIES CO.",
    "808FE8": "Intelbras",
    "18CC18": "Intel Corporate",
    "C0C9E3": "TP-LINK TECHNOLOGIES CO.",
    "F88C21": "TP-LINK TECHNOLOGIES CO.",
    "C4278C": "Huawei Device Co.",
    "78058C": "mMax Communications",
    "C4A72B": "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.",
    "D0C31E": "JUNGJIN Electronics Co.",
    "5C3400": "Hisense Electric Co.",
    "D810CB": "Andrea Informatique",
    "E0913C": "Kyeungin CNS Co.",
    "D05919": "zte corporation",
    "00B881": "New platforms LLC",
    "B098BC": "Huawei Device Co.",
    "24016F": "Huawei Device Co.",
    "84E342": "Tuya Smart Inc.",
    "FCCD2F": "IEEE Registration Authority",
    "C03C59": "Intel Corporate",
    "4C3BDF": "Microsoft Corporation",
    "B43161": "Realme Chongqing Mobile Telecommunications Corp.",
    "B4FBE3": "AltoBeam (China) Inc.",
    "188740": "Xiaomi Communications Co Ltd",
    "341CF0": "Xiaomi Communications Co Ltd",
    "30AFCE": "vivo Mobile Communication Co.",
    "64F947": "Senscomm Semiconductor Co.",
    "DC00B0": "FREEBOX SAS",
    "707414": "Murata Manufacturing Co.",
    "A0764E": "Espressif Inc.",
    "CC4F5C": "IEEE Registration Authority",
    "FC6DD1": "APRESIA Systems",
    "6C09BF": "Fiberhome Telecommunication Technologies Co.",
    "10D7B0": "Sagemcom Broadband SAS",
    "445943": "zte corporation",
    "343654": "zte corporation",
    "C8E600": "HUAWEI TECHNOLOGIES CO.",
    "D4D51B": "HUAWEI TECHNOLOGIES CO.",
    "2491BB": "HUAWEI TECHNOLOGIES CO.",
    "645E10": "HUAWEI TECHNOLOGIES CO.",
    "ECF22B": "TECNO MOBILE LIMITED",
    "309610": "Huawei Device Co.",
    "30578E": "eero inc.",
    "FCB3BC": "Intel Corporate",
    "C816DA": "Realme Chongqing Mobile Telecommunications Corp.",
    "B04414": "New H3C Technologies Co.",
    "E45F01": "Raspberry Pi Trading Ltd",
    "748F3C": "Apple",
    "40F946": "Apple",
    "1CFE2B": "Amazon Technologies Inc.",
    "A4AE12": "Hon Hai Precision Industry Co.",
    "9C9D7E": "Beijing Xiaomi Mobile Software Co.",
    "DCA3A2": "Feng mi(Beijing)technology co.",
    "EC570D": "AFE Inc.",
    "7C25DA": "FN-LINK TECHNOLOGY LIMITED",
    "3059B7": "Microsoft",
    "7412B3": "CHONGQING FUGUI ELECTRONICS CO.",
    "9447B0": "BEIJING ESWIN COMPUTING TECHNOLOGY CO.",
    "E45AD4": "Eltex Enterprise Ltd.",
    "44A54E": "Qorvo International Pte. Ltd.",
    "A8698C": "Oracle Corporation",
    "A4AC0F": "Huawei Device Co.",
    "CCFF90": "Huawei Device Co.",
    "003054": "Castlenet Technology Inc.",
    "001368": "Saab Danmark A/S",
    "B030C8": "Teal Drones",
    "D4F337": "Xunison Ltd.",
    "48A2B8": "Chengdu Vision-Zenith Tech.Co",
    "58E873": "HANGZHOU DANGBEI NETWORK TECH.Co.",
    "A0681C": "GD Midea Air-Conditioning Equipment Co.",
    "6C442A": "HUAWEI TECHNOLOGIES CO.",
    "A47CC9": "HUAWEI TECHNOLOGIES CO.",
    "C40D96": "HUAWEI TECHNOLOGIES CO.",
    "44AF28": "Intel Corporate",
    "D4A651": "Tuya Smart Inc.",
    "84225E": "SHENZHEN TECHNEWCHIP TECHNOLOGY CO.",
    "F85C7D": "Shenzhen Honesty Electronics Co.",
    "842AFD": "HP Inc.",
    "C0B8E6": "Ruijie Networks Co.",
    "90F644": "Huawei Device Co.",
    "A83512": "Huawei Device Co.",
    "DC41A9": "Intel Corporate",
    "8C941F": "Cisco Systems",
    "687DB4": "Cisco Systems",
    "846B48": "ShenZhen EepuLink Co.",
    "B460ED": "Beijing Xiaomi Mobile Software Co.",
    "30CC21": "zte corporation",
    "646C80": "CHONGQING FUGUI ELECTRONICS CO.",
    "00300B": "mPHASE Technologies",
    "C01850": "Quanta Computer Inc.",
    "4427F3": "70mai Co.",
    "000896": "Printronix",
    "0025DC": "Sumitomo Electric Industries",
    "047D7B": "Quanta Computer Inc.",
    "089E01": "Quanta Computer Inc.",
    "A81E84": "Quanta Computer Inc.",
    "B46F2D": "Wahoo Fitness",
    "BC7F7B": "Huawei Device Co.",
    "F0FAC7": "Huawei Device Co.",
    "0026C0": "EnergyHub",
    "80EACA": "Dialog Semiconductor Hellas SA",
    "5C857E": "IEEE Registration Authority",
    "8803E9": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "0CDC7E": "Espressif Inc.",
    "2098D8": "Shenzhen Yingdakang Technology CO.",
    "182649": "Intel Corporate",
    "A0CFF5": "zte corporation",
    "98B3EF": "Huawei Device Co.",
    "50F958": "Huawei Device Co.",
    "C0A36E": "SKY UK LIMITED",
    "34C93D": "Intel Corporate",
    "1C012D": "Ficer Technology",
    "3CA62F": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
    "0005C9": "LG Innotek",
    "ACF108": "LG Innotek",
    "E41F7B": "Cisco Systems",
    "6032B1": "TP-LINK TECHNOLOGIES CO.",
    "7CFD6B": "Xiaomi Communications Co Ltd",
    "7CC77E": "Fiberhome Telecommunication Technologies Co.",
    "345840": "HUAWEI TECHNOLOGIES CO.",
    "5C647A": "HUAWEI TECHNOLOGIES CO.",
    "DCEF80": "HUAWEI TECHNOLOGIES CO.",
    "304950": "IEEE Registration Authority",
    "209E79": "Universal Electronics",
    "08ED9D": "TECNO MOBILE LIMITED",
    "FC1499": "Aimore Acoustics Incorporation",
    "88948F": "Xi'an Zhisensor Technologies Co.",
    "5CD5B5": "Shenzhen WiSiYiLink Technology Co.",
    "AC5FEA": "OnePlus Technology (Shenzhen) Co.",
    "00BED5": "New H3C Technologies Co.",
    "E86DCB": "Samsung Electronics Co.",
    "189552": "1MORE",
    "98C7A4": "Shenzhen HS Fiber Communication Equipment CO.",
    "044AC6": "Aipon Electronics Co.",
    "C0FFA8": "HUAWEI TECHNOLOGIES CO.",
    "C87EA1": "TCL MOKA International Limited",
    "642C0F": "vivo Mobile Communication Co.",
    "3066D0": "Huawei Device Co.",
    "3CB233": "Huawei Device Co.",
    "CCC261": "IEEE Registration Authority",
    "5CFE9E": "Wiwynn Corporation Tainan Branch",
    "881C95": "ITEL MOBILE LIMITED",
    "002003": "PIXEL POWER LTD.",
    "F02E51": "Casa Systems",
    "F46942": "ASKEY COMPUTER CORP",
    "08E9F6": "AMPAK Technology",
    "C8E42F": "Technical Research Design and Development",
    "680AE2": "Silicon Laboratories",
    "241407": "Xiamen Sigmastar Technology Ltd.",
    "B47947": "Nutanix",
    "04F8F8": "Edgecore Networks Corporation",
    "640BD7": "Apple",
    "A8913D": "Apple",
    "0C3B50": "Apple",
    "4CC95E": "Samsung Electronics Co.",
    "5C9157": "HUAWEI TECHNOLOGIES CO.",
    "04CB88": "Shenzhen Jingxun Software Telecommunication Technology Co.",
    "FCA5D0": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "347DF6": "Intel Corporate",
    "C85BA0": "Shenzhen Qihu Intelligent Technology Company Limited",
    "E0BE03": "Lite-On Network Communication (Dongguan) Limited",
    "A48873": "Cisco Systems",
    "98CBA4": "Benchmark Electronics",
    "B46293": "Samsung Electronics Co.",
    "000DA1": "MIRAE ITS Co.",
    "CCD9AC": "Intel Corporate",
    "B8804F": "Texas Instruments",
    "000F2D": "CHUNG-HSIN ELECTRIC & MACHINERY MFG.CORP.",
    "183CB7": "Huawei Device Co.",
    "5C9012": "Owl Cyber Defense Solutions",
    "481693": "Lear Corporation GmbH",
    "A4BDC4": "HUAWEI TECHNOLOGIES CO.",
    "38F7CD": "IEEE Registration Authority",
    "9C2976": "Intel Corporate",
    "18F697": "Axiom Memory Solutions",
    "5C6BD7": "Foshan VIOMI Electric Appliance Technology Co. Ltd.",
    "1848CA": "Murata Manufacturing Co.",
    "CC0DF2": "Motorola Mobility LLC",
    "94434D": "Ciena Corporation",
    "0001CD": "ARtem",
    "58A87B": "Fitbit",
    "C489ED": "Solid Optics EU N.V.",
    "488F5A": "Routerboard.com",
    "100645": "Sagemcom Broadband SAS",
    "A027B6": "Samsung Electronics Co.",
    "103917": "Samsung Electronics Co.",
    "9880EE": "Samsung Electronics Co.",
    "90EEC7": "Samsung Electronics Co.",
    "1029AB": "Samsung Electronics Co.",
    "184ECB": "Samsung Electronics Co.",
    "8022A7": "NEC Platforms",
    "5C2316": "Squirrels Research Labs LLC",
    "AC67B2": "Espressif Inc.",
    "985949": "LUXOTTICA GROUP S.P.A.",
    "64E172": "Shenzhen Qihoo Intelligent Technology Co.",
    "C4D8F3": "iZotope",
    "A84025": "Oxide Computer Company",
    "60F43A": "Edifier International",
    "FCB698": "Cambridge Industries(Group) Co.",
    "042144": "Sunitec Enterprise Co.",
    "4C3329": "Sweroam",
    "782B46": "Intel Corporate",
    "785773": "HUAWEI TECHNOLOGIES CO.",
    "AC6089": "HUAWEI TECHNOLOGIES CO.",
    "843E92": "HUAWEI TECHNOLOGIES CO.",
    "708CB6": "HUAWEI TECHNOLOGIES CO.",
    "50464A": "HUAWEI TECHNOLOGIES CO.",
    "C4A402": "HUAWEI TECHNOLOGIES CO.",
    "68332C": "KENSTEL NETWORKS LIMITED",
    "9CBD6E": "DERA Co.",
    "9C28BF": "Continental Automotive Czech Republic s.r.o.",
    "0006B3": "Diagraph Corporation",
    "D8787F": "Ubee Interactive Co.",
    "DC333D": "Huawei Device Co.",
    "285471": "Huawei Device Co.",
    "B88E82": "Huawei Device Co.",
    "34E5EC": "Palo Alto Networks",
    "0887C6": "INGRAM MICRO SERVICES",
    "D4D2D6": "FN-LINK TECHNOLOGY LIMITED",
    "105072": "Sercomm Corporation.",
    "98FAA7": "INNONET",
    "086BD1": "Shenzhen SuperElectron Technology Co.",
    "905D7C": "New H3C Technologies Co.",
    "3CB53D": "HUNAN GOKE MICROELECTRONICS CO.",
    "AC3A67": "Cisco Systems",
    "00B7A8": "Heinzinger electronic GmbH",
    "34CFF6": "Intel Corporate",
    "B8E3B1": "HUAWEI TECHNOLOGIES CO.",
    "980D51": "Huawei Device Co.",
    "00ADD5": "Huawei Device Co.",
    "EC7949": "FUJITSU LIMITED",
    "AC4A67": "Cisco Systems",
    "900A84": "Mellanox Technologies",
    "70CA97": "Ruckus Wireless",
    "345180": "TCL King Electrical Appliances (Huizhou) Co.",
    "6CD94C": "vivo Mobile Communication Co.",
    "AC1ED0": "Temic Automotive Philippines Inc.",
    "0088BA": "NC&C",
    "4CA64D": "Cisco Systems",
    "402B69": "Kumho Electric Inc.",
    "A40801": "Amazon Technologies Inc.",
    "A8A097": "ScioTeq bvba",
    "F47335": "Logitech Far East",
    "90ADFC": "Telechips",
    "BC1695": "zte corporation",
    "A4CFD2": "Ubee Interactive Co.",
    "E8E98E": "SOLAR controls s.r.o.",
    "64F6BB": "Fibocom Wireless Inc.",
    "5CA62D": "Cisco Systems",
    "EC97B2": "SUMEC Machinery & Electric Co.",
    "28FA7A": "Zhejiang Tmall Technology Co.",
    "1005E1": "Nokia",
    "BC542F": "Intel Corporate",
    "842E14": "Silicon Laboratories",
    "0020E1": "ALAMAR ELECTRONICS",
    "08F458": "Huawei Device Co.",
    "343794": "Hamee Corp.",
    "D4DC09": "Mist Systems",
    "4410FE": "Huizhou Foryou General Electronics Co.",
    "EC316D": "Hansgrohe",
    "CC7F75": "Cisco Systems",
    "20E874": "Apple",
    "D03FAA": "Apple",
    "7CAB60": "Apple",
    "44C65D": "Apple",
    "40EC99": "Intel Corporate",
    "F4A4D6": "HUAWEI TECHNOLOGIES CO.",
    "187EB9": "Apple",
    "1C97C5": "Ynomia Pty Ltd",
    "5CC1D7": "Samsung Electronics Co.",
    "380146": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
    "2C5741": "Cisco Systems",
    "B0B353": "IEEE Registration Authority",
    "1C919D": "Dongguan Liesheng Electronic Co.",
    "20114E": "MeteRSit S.R.L.",
    "FCF29F": "China Mobile Iot Limited company",
    "F81F32": "Motorola Mobility LLC",
    "A87EEA": "Intel Corporate",
    "B00AD5": "zte corporation",
    "A84D4A": "Audiowise Technology Inc.",
    "74B6B6": "eero inc.",
    "7CDFA1": "Espressif Inc.",
    "98006A": "zte corporation",
    "7894E8": "Radio Bridge",
    "547FBC": "iodyne",
    "FCE14F": "BRK Brands",
    "889655": "Zitte corporation",
    "18300C": "Hisense Electric Co.",
    "44A56E": "NETGEAR",
    "5C27D4": "Shenzhen Qihu Intelligent Technology Company Limited",
    "74D83E": "Intel Corporate",
    "88B6EE": "Dish Technologies Corp",
    "3C28A6": "Alcatel-Lucent Enterprise (China)",
    "5050A4": "Samsung Electronics Co.",
    "08F8BC": "Apple",
    "90A25B": "Apple",
    "88A479": "Apple",
    "047295": "Apple",
    "D446E1": "Apple",
    "141459": "Vodafone Italia S.p.A.",
    "5043B9": "OktoInform RUS",
    "88541F": "Google",
    "900CC8": "Google",
    "00104F": "Oracle Corporation",
    "08D23E": "Intel Corporate",
    "487B5E": "SMT TELECOMM HK",
    "0025A9": "Shanghai Embedway Information Technologies Co.",
    "68215F": "Edgecore Networks Corporation",
    "3CBF60": "Apple",
    "AC15F4": "Apple",
    "78D162": "Apple",
    "44C7FC": "Huawei Device Co.",
    "7885F4": "Huawei Device Co.",
    "8086D9": "Samsung Electronics Co.",
    "386A77": "Samsung Electronics Co.",
    "00B810": "Yichip Microelectronics (Hangzhou) Co.",
    "A4B239": "Cisco Systems",
    "548D5A": "Intel Corporate",
    "F44955": "MIMO TECH Co.",
    "0809C7": "Zhuhai Unitech Power Technology Co.",
    "58961D": "Intel Corporate",
    "68AFFF": "Shanghai Cambricon Information Technology Co.",
    "D01C3C": "TECNO MOBILE LIMITED",
    "041DC7": "zte corporation",
    "001A4D": "GIGA-BYTE TECHNOLOGY CO.",
    "001FD0": "GIGA-BYTE TECHNOLOGY CO.",
    "B89A2A": "Intel Corporate",
    "DC21E2": "HUAWEI TECHNOLOGIES CO.",
    "FC1BD1": "HUAWEI TECHNOLOGIES CO.",
    "582575": "HUAWEI TECHNOLOGIES CO.",
    "28DEE5": "HUAWEI TECHNOLOGIES CO.",
    "18C04D": "GIGA-BYTE TECHNOLOGY CO.",
    "402C76": "IEEE Registration Authority",
    "80C955": "Redpine Signals",
    "5C68D0": "Aurora Innovation Inc.",
    "10364A": "Boston Dynamics",
    "8CAAB5": "Espressif Inc.",
    "000BCC": "JUSAN",
    "00E059": "CONTROLLED ENVIRONMENTS",
    "0C8E29": "Arcadyan Corporation",
    "A0224E": "IEEE Registration Authority",
    "C49878": "SHANGHAI MOAAN INTELLIGENT TECHNOLOGY CO.",
    "000A23": "Parama Networks Inc",
    "3843E5": "Grotech Inc",
    "6C06D6": "Huawei Device Co.",
    "18E777": "vivo Mobile Communication Co.",
    "0C7A15": "Intel Corporate",
    "94D6DB": "NexFi",
    "78B46A": "HUAWEI TECHNOLOGIES CO.",
    "6CEBB6": "HUAWEI TECHNOLOGIES CO.",
    "4CF55B": "HUAWEI TECHNOLOGIES CO.",
    "643139": "IEEE Registration Authority",
    "A44BD5": "Xiaomi Communications Co Ltd",
    "14876A": "Apple",
    "E0B55F": "Apple",
    "F8FFC2": "Apple",
    "E0EB40": "Apple",
    "4077A9": "New H3C Technologies Co.",
    "64694E": "Texas Instruments",
    "F83331": "Texas Instruments",
    "40A6B7": "Intel Corporate",
    "B4ECF2": "Shanghai Listent Medical Tech Co.",
    "C4954D": "IEEE Registration Authority",
    "64956C": "LG Electronics",
    "E83F67": "Huawei Device Co.",
    "3446EC": "Huawei Device Co.",
    "1CBFC0": "CHONGQING FUGUI ELECTRONICS CO.",
    "34495B": "Sagemcom Broadband SAS",
    "801609": "Sleep Number",
    "AC8B9C": "Primera Technology",
    "1CC1BC": "Yichip Microelectronics (Hangzhou) Co.",
    "2C3AFD": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
    "AC61B9": "WAMA Technology Limited",
    "F855CD": "Visteon Corporation",
    "441847": "HUNAN SCROWN ELECTRONIC INFORMATION TECH.CO.",
    "0030B7": "Teletrol Systems",
    "C8F319": "LG Electronics (Mobile Communications)",
    "009096": "ASKEY COMPUTER CORP",
    "2474F7": "GoPro",
    "7CD566": "Amazon Technologies Inc.",
    "686350": "Hella India Automotive Pvt Ltd",
    "18703B": "Huawei Device Co.",
    "442295": "China Mobile Iot Limited company",
    "E85A8B": "Xiaomi Communications Co Ltd",
    "80751F": "SKY UK LIMITED",
    "D89E61": "Huawei Device Co.",
    "347E00": "Huawei Device Co.",
    "5CE50C": "Beijing Xiaomi Mobile Software Co.",
    "5C710D": "Cisco Systems",
    "98AF65": "Intel Corporate",
    "F8893C": "Inventec Appliances Corp.",
    "749EF5": "Samsung Electronics Co.",
    "68BFC4": "Samsung Electronics Co.",
    "B82ADC": "EFR Europäische Funk-Rundsteuerung GmbH",
    "00AB48": "eero inc.",
    "A0DF15": "HUAWEI TECHNOLOGIES CO.",
    "C4AD34": "Routerboard.com",
    "000733": "DANCONTROL Engineering",
    "A85E45": "ASUSTek COMPUTER INC.",
    "64C901": "INVENTEC Corporation",
    "B43939": "Shenzhen TINNO Mobile Technology Corp.",
    "5CCD5B": "Intel Corporate",
    "84C807": "ADVA Optical Networking Ltd.",
    "10B3C6": "Cisco Systems",
    "10B3D6": "Cisco Systems",
    "A0AB51": "WEIFANG GOERTEK ELECTRONICS CO.",
    "04B1A1": "Samsung Electronics Co.",
    "CC464E": "Samsung Electronics Co.",
    "306F07": "Nations Technologies Inc.",
    "3C894D": "Dr. Ing. h.c. F. Porsche AG",
    "F854B8": "Amazon Technologies Inc.",
    "781735": "Nokia Shanghai Bell Co.",
    "9CFFC2": "AVI Systems GmbH",
    "44D878": "Hui Zhou Gaoshengda Technology Co.",
    "7897C3": "DINGXIN INFORMATION TECHNOLOGY CO.",
    "F4D620": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "949034": "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.",
    "3C8F06": "Shenzhen Libtor Technology Co.",
    "987A10": "Ericsson AB",
    "202681": "TECNO MOBILE LIMITED",
    "A0D807": "Huawei Device Co.",
    "2C780E": "Huawei Device Co.",
    "34B20A": "Huawei Device Co.",
    "98F4AB": "Espressif Inc.",
    "D8BFC0": "Espressif Inc.",
    "B00875": "HUAWEI TECHNOLOGIES CO.",
    "64FB92": "PPC Broadband Inc.",
    "141346": "Skyworth Digital Technology(Shenzhen) Co.",
    "542BDE": "New H3C Technologies Co.",
    "4C90DB": "JL Audio",
    "8CF112": "Motorola Mobility LLC",
    "B899AE": "Shenzhen MiaoMing  Intelligent Technology Co.",
    "E8D0B9": "Taicang T&W Electronics",
    "5885A2": "Realme Chongqing MobileTelecommunications Corp Ltd",
    "A8C0EA": "Pepwave Limited",
    "44AEAB": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "A4F05E": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "00071C": "AT&T",
    "847637": "HUAWEI TECHNOLOGIES CO.",
    "FC9435": "HUAWEI TECHNOLOGIES CO.",
    "E02481": "HUAWEI TECHNOLOGIES CO.",
    "2CF89B": "Cisco Systems",
    "80B07B": "zte corporation",
    "C85A9F": "zte corporation",
    "500291": "Espressif Inc.",
    "001DDF": "Sunitec Enterprise Co.",
    "8C0FFA": "Hutec co.",
    "ACFE05": "ITEL MOBILE LIMITED",
    "BCC31B": "Kygo Life A",
    "64DF10": "JingLue Semiconductor(SH) Ltd.",
    "100177": "HUAWEI TECHNOLOGIES CO.",
    "44A191": "HUAWEI TECHNOLOGIES CO.",
    "24526A": "Zhejiang Dahua Technology Co.",
    "20DFB9": "Google",
    "5CCAD3": "CHIPSEA TECHNOLOGIES (SHENZHEN) CORP.",
    "782A79": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "786559": "Sagemcom Broadband SAS",
    "50D2F5": "Beijing Xiaomi Mobile Software Co.",
    "1C687E": "Shenzhen Qihu Intelligent Technology Company Limited",
    "C03656": "Fiberhome Telecommunication Technologies Co.",
    "B03E51": "SKY UK LIMITED",
    "28167F": "Xiaomi Communications Co Ltd",
    "087190": "Intel Corporate",
    "5CE883": "HUAWEI TECHNOLOGIES CO.",
    "6023A4": "Sichuan AI-Link Technology Co.",
    "A4530E": "Cisco Systems",
    "00403A": "IMPACT TECHNOLOGIES",
    "C8B1CD": "Apple",
    "1460CB": "Apple",
    "B8F12A": "Apple",
    "F887F1": "Apple",
    "60447A": "Water-i.d. GmbH",
    "807215": "SKY UK LIMITED",
    "74D637": "Amazon Technologies Inc.",
    "7484E1": "Dongguan Haoyuan Electronics Co.",
    "4074E0": "Intel Corporate",
    "D05F64": "IEEE Registration Authority",
    "44FB5A": "zte corporation",
    "C463FB": "Neatframe AS",
    "305714": "Apple",
    "04A222": "Arcadyan Corporation",
    "04AB6A": "Chun-il Co.",
    "0035FF": "Texas Instruments",
    "DC54D7": "Amazon Technologies Inc.",
    "28FE65": "DongGuan Siyoto Electronics Co.",
    "1806F5": "RAD Data Communications",
    "889FAA": "Hella Gutmann Solutions GmbH",
    "04C807": "Xiaomi Communications Co Ltd",
    "4459E3": "HUAWEI TECHNOLOGIES CO.",
    "683F1E": "EFFECT Photonics B.V.",
    "44D3CA": "Cisco Systems",
    "840B7C": "Hitron Technologies. Inc",
    "48A73C": "Sichuan tianyi kanghe communications co.",
    "F8A763": "Zhejiang Tmall Technology Co.",
    "6C2990": "WiZ Connected Lighting Company Limited",
    "9835ED": "HUAWEI TECHNOLOGIES CO.",
    "807693": "Newag SA",
    "BC9740": "IEEE Registration Authority",
    "084F0A": "HUAWEI TECHNOLOGIES CO.",
    "A8494D": "HUAWEI TECHNOLOGIES CO.",
    "44004D": "HUAWEI TECHNOLOGIES CO.",
    "20968A": "China Mobile (Hangzhou) Information Technology Co.",
    "8C1850": "China Mobile (Hangzhou) Information Technology Co.",
    "D8D4E6": "Hytec Inter Co.",
    "F8E7A0": "vivo Mobile Communication Co.",
    "2CFFEE": "vivo Mobile Communication Co.",
    "C85D38": "HUMAX Co.",
    "18CF24": "HUAWEI TECHNOLOGIES CO.",
    "50F8A5": "eWBM Co.",
    "D89B3B": "HUAWEI TECHNOLOGIES CO.",
    "88403B": "HUAWEI TECHNOLOGIES CO.",
    "FC8743": "HUAWEI TECHNOLOGIES CO.",
    "04885F": "HUAWEI TECHNOLOGIES CO.",
    "C850CE": "HUAWEI TECHNOLOGIES CO.",
    "000BE4": "Hosiden Corporation",
    "4413D0": "zte corporation",
    "2462AB": "Espressif Inc.",
    "1449BC": "DrayTek Corp.",
    "20F478": "Xiaomi Communications Co Ltd",
    "7438B7": "CANON INC.",
    "90735A": "Motorola Mobility LLC",
    "0004DF": "TERACOM TELEMATICA S.A",
    "18B6F7": "NEW POS TECHNOLOGY LIMITED",
    "1C8259": "IEEE Registration Authority",
    "00FA21": "Samsung Electronics Co.",
    "7C2302": "Samsung Electronics Co.",
    "6CAB05": "Cisco Systems",
    "5CB15F": "Oceanblue Cloud Technology Limited",
    "485DEB": "Just Add Power",
    "501395": "Sichuan AI-Link Technology Co.",
    "18D9EF": "Shuttle Inc.",
    "88DA33": "Beijing Xiaoyuer Network Technology Co.",
    "84C78F": "APS Networks GmbH",
    "C09FE1": "zte corporation",
    "18AACA": "Sichuan tianyi kanghe communications co.",
    "D49DC0": "Samsung Electronics Co.",
    "D0196A": "Ciena Corporation",
    "84FDD1": "Intel Corporate",
    "B0700D": "Nokia",
    "002175": "Pacific Satellite International Ltd.",
    "346B5B": "New H3C Technologies Co.",
    "84E892": "Actiontec Electronics",
    "78E2BD": "Vodafone Automotive S.p.A.",
    "F848FD": "China Mobile Group Device Co.",
    "5041B9": "I-O DATA DEVICE",
    "80DABC": "Megafone Limited",
    "20DA22": "HUAWEI TECHNOLOGIES CO.",
    "184644": "Home Control Singapore Pte Ltd",
    "C821DA": "Shenzhen YOUHUA Technology Co.",
    "20658E": "HUAWEI TECHNOLOGIES CO.",
    "183D5E": "HUAWEI TECHNOLOGIES CO.",
    "889746": "Sichuan AI-Link Technology Co.",
    "1CDE57": "Fiberhome Telecommunication Technologies Co.",
    "E0DCFF": "Xiaomi Communications Co Ltd",
    "00778D": "Cisco Systems",
    "000E8C": "Siemens AG",
    "008764": "Cisco Systems",
    "846FCE": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "B0E71D": "Shanghai Maigantech Co.",
    "C468D0": "VTech Telecommunications Ltd.",
    "14AEDB": "VTech Telecommunications Ltd.",
    "78DB2F": "Texas Instruments",
    "E0B655": "Beijing Xiaomi Electronics Co.",
    "8C0FA0": "di-soric GmbH & Co. KG",
    "F8BBBF": "eero inc.",
    "DCFB48": "Intel Corporate",
    "DC7137": "zte corporation",
    "847C9B": "GD Midea Air-Conditioning Equipment Co.",
    "3441A8": "ER-Telecom",
    "34DB9C": "Sagemcom Broadband SAS",
    "7440BE": "LG Innotek",
    "A4CF12": "Espressif Inc.",
    "FCB662": "IC Holdings LLC",
    "04D4C4": "ASUSTek COMPUTER INC.",
    "A0510B": "Intel Corporate",
    "7488BB": "Cisco Systems",
    "A8E2C3": "Shenzhen YOUHUA Technology Co.",
    "0CA06C": "Industrial Cyber Sensing Inc.",
    "FCD2B6": "IEEE Registration Authority",
    "804A14": "Apple",
    "703C69": "Apple",
    "AC2DA9": "TECNO MOBILE LIMITED",
    "40A93F": "Pivotal Commware",
    "4C6AF6": "HMD Global Oy",
    "489DD1": "Samsung Electronics Co.",
    "C08C71": "Motorola Mobility LLC",
    "48049F": "ELECOM CO.",
    "087F98": "vivo Mobile Communication Co.",
    "C04121": "Nokia Solutions and Networks GmbH & Co. KG",
    "F46F4E": "Echowell",
    "B06FE0": "Samsung Electronics Co.",
    "44B994": "Douglas Lighting Controls",
    "2479F8": "KUPSON spol. s r.o.",
    "70BF92": "GN Audio A/S",
    "ACBB61": "YSTen Technology Co.",
    "342003": "Shenzhen Feitengyun Technology Co.",
    "7CFD82": "GUANGDONG GENIUS TECHNOLOGY CO.",
    "002F5C": "Cisco Systems",
    "F4645D": "Toshiba",
    "F07D68": "D-Link Corporation",
    "EC4118": "XIAOMI Electronics",
    "D8860B": "IEEE Registration Authority",
    "08ECF5": "Cisco Systems",
    "D07650": "IEEE Registration Authority",
    "60D0A9": "Samsung Electronics Co.",
    "88CEFA": "HUAWEI TECHNOLOGIES CO.",
    "002706": "YOISYS",
    "042DB4": "First Property (Beijing) Co.",
    "38F85E": "HUMAX Co.",
    "00CB51": "Sagemcom Broadband SAS",
    "C464B7": "Fiberhome Telecommunication Technologies Co.",
    "04E0B0": "Shenzhen YOUHUA Technology Co.",
    "38B19E": "IEEE Registration Authority",
    "38E26E": "ShenZhen Sweet Rain Electronics Co.",
    "70C9C6": "Cisco Systems",
    "689A87": "Amazon Technologies Inc.",
    "64AE88": "Polytec GmbH",
    "00D050": "Iskratel d.o.o.",
    "78DAA2": "Cynosure Technologies Co.",
    "8084A9": "oshkosh Corporation",
    "180D2C": "Intelbras",
    "98DAC4": "TP-LINK TECHNOLOGIES CO.",
    "00177B": "Azalea Networks inc",
    "502B98": "Es-tech International",
    "C82832": "Beijing Xiaomi Electronics Co.",
    "701BFB": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "04766E": "ALPSALPINE CO",
    "AC7A4D": "ALPSALPINE CO",
    "38C096": "ALPSALPINE CO",
    "C4346B": "Hewlett Packard",
    "48F17F": "Intel Corporate",
    "002643": "ALPSALPINE CO",
    "1C3477": "Innovation Wireless",
    "4CC7D6": "FLEXTRONICS MANUFACTURING(ZHUHAI)CO.",
    "C80873": "Ruckus Wireless",
    "001697": "NEC Corporation",
    "003013": "NEC Corporation",
    "BC3E07": "Hitron Technologies. Inc",
    "48FDA3": "Xiaomi Communications Co Ltd",
    "288088": "NETGEAR",
    "90869B": "zte corporation",
    "E0189F": "EM Microelectronic",
    "F81308": "Nokia",
    "F8A2D6": "Liteon Technology Corporation",
    "049DFE": "Hivesystem",
    "D05157": "LEAX Arkivator Telecom",
    "FCBE7B": "vivo Mobile Communication Co.",
    "B40FB3": "vivo Mobile Communication Co.",
    "EC5C68": "CHONGQING FUGUI ELECTRONICS CO.",
    "9458CB": "Nintendo Co.",
    "74366D": "Vodafone Italia S.p.A.",
    "182A44": "HIROSE ELECTRONIC SYSTEM",
    "FC94CE": "zte corporation",
    "0CEC84": "Shenzhen TINNO Mobile Technology Corp.",
    "9CDB07": "Yellowtec GmbH",
    "28EC9A": "Texas Instruments",
    "C4E506": "Piper Networks",
    "0CD0F8": "Cisco Systems",
    "DCDA80": "New H3C Technologies Co.",
    "B8259A": "Thalmic Labs",
    "30EB5A": "LANDIS + GYR",
    "F80F6F": "Cisco Systems",
    "0080E3": "CORAL NETWORK CORPORATION",
    "D8F2CA": "Intel Corporate",
    "B4C62E": "Molex CMS",
    "282536": "SHENZHEN HOLATEK CO.",
    "B8A175": "Roku",
    "CCD3C1": "Vestel Elektronik San ve Tic. A.S.",
    "A42655": "LTI Motion (Shanghai) Co.",
    "60A730": "Shenzhen Yipinfang Internet Technology Co.",
    "3C9BD6": "Vizio",
    "50DB3F": "SHENZHEN GONGJIN ELECTRONICS CO.",
    "1081B4": "Hunan Greatwall Galaxy Science and Technology Co.",
    "3881D7": "Texas Instruments",
    "1804ED": "Texas Instruments",
    "D43260": "GoPro",
    "F4DD9E": "GoPro",
    "D4D919": "GoPro",
    "CC7286": "Xi'an Fengyu Information Technology Co.",
    "6CA928": "HMD Global Oy",
    "00D861": "Micro-Star INTL CO.",
    "74C17D": "Infinix mobility limited",
    "141114": "TECNO MOBILE LIMITED",
    "00B8B3": "Cisco Systems",
    "745F90": "LAM Technologies",
    "F85B9C": "SB SYSTEMS Co.",
    "004279": "Sunitec Enterprise Co.",
    "A45046": "Xiaomi Communications Co Ltd",
    "F8501C": "Tianjin Geneuo Technology Co.",
    "70D313": "HUAWEI TECHNOLOGIES CO.",
    "9C1D36": "HUAWEI TECHNOLOGIES CO.",
    "CCBBFE": "HUAWEI TECHNOLOGIES CO.",
    "44070B": "Google",
    "ECF6BD": "SNCF MOBILITÉS",
    "B831B5": "Microsoft Corporation",
    "007C2D": "Samsung Electronics Co.",
    "38B4D3": "BSH Hausgeraete GmbH",
    "C84782": "Areson Technology Corp.",
    "E89363": "Nokia",
    "7C0CF6": "Guangdong Huiwei High-tech Co.",
    "20AD56": "Continental Automotive Systems Inc.",
    "5029F5": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "300A60": "IEEE Registration Authority",
    "80D065": "CKS Corporation",
    "00D6FE": "Cisco Systems",
    "0CBF74": "Morse Micro",
    "B41D2B": "Shenzhen YOUHUA Technology Co.",
    "14C213": "Apple",
    "FC8F7D": "SHENZHEN GONGJIN ELECTRONICS CO.",
    "24BE18": "DADOUTEK COMPANY LIMITED",
    "749D79": "Sercomm Corporation.",
    "A4D931": "Apple",
    "BCFED9": "Apple",
    "808223": "Apple",
    "CC08FB": "TP-LINK TECHNOLOGIES CO.",
    "BCAF91": "TE Connectivity Sensor Solutions",
    "283166": "vivo Mobile Communication Co.",
    "C04004": "Medicaroid Corporation",
    "A4ED43": "IEEE Registration Authority",
    "94298D": "Shanghai AdaptComm Technology Co.",
    "00AA6E": "Cisco Systems",
    "F0D7DC": "Wesine (Wuhan) Technology Co.",
    "007204": "Samsung Electronics Co.",
    "40C81F": "Shenzhen Xinguodu Technology Co.",
    "0C7C28": "Nokia Solutions and Networks GmbH & Co. KG",
    "6843D7": "Agilecom Photonics Solutions Guangdong Limited",
    "B86A97": "Edgecore Networks Corporation",
    "A81087": "Texas Instruments",
    "8C8F8B": "China Mobile Chongqing branch",
    "1459C0": "NETGEAR",
    "00040B": "3COM EUROPE LTD",
    "C8C2F5": "FLEXTRONICS MANUFACTURING(ZHUHAI)CO.",
    "F05849": "CareView Communications",
    "8CFE74": "Ruckus Wireless",
    "604BAA": "Magic Leap",
    "4C0143": "eero inc.",
    "E43493": "HUAWEI TECHNOLOGIES CO.",
    "342912": "HUAWEI TECHNOLOGIES CO.",
    "48A472": "Intel Corporate",
    "000A5E": "3COM",
    "00105A": "3COM",
    "006097": "3COM",
    "006008": "3COM",
    "000102": "3COM",
    "A02833": "IEEE Registration Authority",
    "001B6E": "Keysight Technologies",
    "143719": "PT Prakarsa Visi Valutama",
    "582F40": "Nintendo Co.",
    "0890BA": "Danlaw Inc",
    "4C364E": "Panasonic Connect Co.",
    "BCA58B": "Samsung Electronics Co.",
    "80CEB9": "Samsung Electronics Co.",
    "E85D86": "CHANG YOW TECHNOLOGIES INTERNATIONAL CO.",
    "94A3CA": "KonnectONE",
    "D0D3FC": "Mios",
    "6C6CD3": "Cisco Systems",
    "E049ED": "Audeze LLC",
    "000157": "SYSWAVE CO.",
    "A8016D": "Aiwa Corporation",
    "0440A9": "New H3C Technologies Co.",
    "244CE3": "Amazon Technologies Inc.",
    "B8BEF4": "devolo AG",
    "58FDBE": "Shenzhen Taikaida Technology Co.",
    "F4F197": "EMTAKE Inc",
    "6CED51": "NEXCONTROL Co.",
    "1062E5": "Hewlett Packard",
    "04C3E6": "IEEE Registration Authority",
    "98BB99": "Phicomm (Sichuan) Co.",
    "002622": "COMPAL INFORMATION (KUNSHAN) CO.",
    "0020B5": "YASKAWA ELECTRIC CORPORATION",
    "286336": "Siemens AG",
    "14D169": "HUAWEI TECHNOLOGIES CO.",
    "1CC3EB": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "F460E2": "Xiaomi Communications Co Ltd",
    "E4D124": "Mojo Networks",
    "9CC950": "Baumer Holding",
    "F89910": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "50E0EF": "Nokia",
    "60F18A": "HUAWEI TECHNOLOGIES CO.",
    "C49500": "Amazon Technologies Inc.",
    "68DD26": "Shanghai Focus Vision Security Technology Co.",
    "2866E3": "AzureWave Technology Inc.",
    "848A8D": "Cisco Systems",
    "E06267": "Xiaomi Communications Co Ltd",
    "70B7AA": "vivo Mobile Communication Co.",
    "0013A3": "Siemens Home & Office Comm. Devices",
    "082525": "Xiaomi Communications Co Ltd",
    "84B31B": "Kinexon GmbH",
    "F8272E": "Mercku",
    "CC50E3": "Espressif Inc.",
    "A83E0E": "HMD Global Oy",
    "10C172": "HUAWEI TECHNOLOGIES CO.",
    "000EEE": "Muco Industrie BV",
    "7C1C4E": "LG Innotek",
    "D8B6B7": "Comtrend Corporation",
    "8C14B4": "zte corporation",
    "3C9872": "Sercomm Corporation.",
    "40C3C6": "SnapRoute",
    "D01CBB": "Beijing Ctimes Digital Technology Co.",
    "7487BB": "Ciena Corporation",
    "C0B6F9": "Intel Corporate",
    "DCE305": "AO",
    "A4DA32": "Texas Instruments",
    "780473": "Texas Instruments",
    "504C7E": "THE 41ST INSTITUTE OF CETC",
    "2C4759": "Beijing MEGA preponderance Science & Technology Co. Ltd",
    "DCE0EB": "Nanjing Aozheng Information Technology Co.Ltd",
    "00151E": "ETHERNET Powerlink Standarization Group (EPSG)",
    "00111E": "ETHERNET Powerlink Standarization Group (EPSG)",
    "00409D": "DigiBoard",
    "149346": "PNI sensor corporation",
    "00138A": "Qingdao GoerTek Technology Co.",
    "A830AD": "WEIFANG GOERTEK ELECTRONICS CO.",
    "A41566": "WEIFANG GOERTEK ELECTRONICS CO.",
    "1C965A": "WEIFANG GOERTEK ELECTRONICS CO.",
    "401B5F": "WEIFANG GOERTEK ELECTRONICS CO.",
    "144F8A": "Intel Corporate",
    "002106": "RIM Testing Services",
    "5CCD7C": "MEIZU Technology Co.",
    "5C9656": "AzureWave Technology Inc.",
    "E06066": "Sercomm Corporation.",
    "BC5FF6": "MERCURY COMMUNICATION TECHNOLOGIES CO.",
    "C8E7D8": "MERCURY COMMUNICATION TECHNOLOGIES CO.",
    "A8E552": "JUWEL Aquarium AG & Co. KG",
    "60D21C": "Sunnovo International Limited",
    "CC51B4": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "00C3F4": "Samsung Electronics Co.",
    "B88AEC": "Nintendo Co.",
    "78725D": "Cisco Systems",
    "B46BFC": "Intel Corporate",
    "B0FC0D": "Amazon Technologies Inc.",
    "CCC92C": "Schindler - PORT Technology",
    "001E39": "Comsys Communication Ltd.",
    "EC8C9A": "HUAWEI TECHNOLOGIES CO.",
    "B48655": "HUAWEI TECHNOLOGIES CO.",
    "D0D783": "HUAWEI TECHNOLOGIES CO.",
    "AC3B77": "Sagemcom Broadband SAS",
    "FCE66A": "Industrial Software Co",
    "7836CC": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "70C833": "Wirepas Oy",
    "0C73EB": "IEEE Registration Authority",
    "F0B5D1": "Texas Instruments",
    "00E000": "FUJITSU LIMITED",
    "90848B": "HDR10+ Technologies",
    "0CF5A4": "Cisco Systems",
    "80C7C5": "Fiberhome Telecommunication Technologies Co.",
    "2816A8": "Microsoft Corporation",
    "048AE1": "FLEXTRONICS MANUFACTURING(ZHUHAI)CO.",
    "8CCF5C": "BEFEGA GmbH",
    "501D93": "HUAWEI TECHNOLOGIES CO.",
    "C8D779": "QING DAO HAIER TELECOM CO.",
    "10B36F": "Bowei Technology Company Limited",
    "FC9BC6": "Sumavision Technologies Co.",
    "C8292A": "Barun Electronics",
    "0080BA": "SPECIALIX (ASIA) PTE",
    "480BB2": "IEEE Registration Authority",
    "CCC079": "Murata Manufacturing Co.",
    "F09CD7": "Guangzhou Blue Cheetah Intelligent Technology Co.",
    "BCE143": "Apple",
    "E482CC": "Jumptronic GmbH",
    "B0416F": "Shenzhen Maxtang Computer Co.",
    "E019D8": "BH TECHNOLOGIES",
    "48605F": "LG Electronics (Mobile Communications)",
    "30D9D9": "Apple",
    "6030D4": "Apple",
    "F895EA": "Apple",
    "18F1D8": "Apple",
    "647033": "Apple",
    "846878": "Apple",
    "C8D083": "Apple",
    "8C4CDC": "PLANEX COMMUNICATIONS INC.",
    "BCAB7C": "TRnP KOREA Co Ltd",
    "6C3838": "Marking System Technology Co.",
    "9C2EA1": "Xiaomi Communications Co Ltd",
    "0C6ABC": "Fiberhome Telecommunication Technologies Co.",
    "3CCD5D": "HUAWEI TECHNOLOGIES CO.",
    "7C7668": "HUAWEI TECHNOLOGIES CO.",
    "001386": "ABB Inc/Totalflow",
    "003C10": "Cisco Systems",
    "F041C8": "IEEE Registration Authority",
    "CC9916": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "EC7FC6": "ECCEL CORPORATION SAS",
    "A438CC": "Nintendo Co.",
    "74721E": "Edison Labs Inc.",
    "780F77": "HangZhou Gubei Electronics Technology Co.",
    "4CABFC": "zte corporation",
    "7C2A31": "Intel Corporate",
    "0CF346": "Xiaomi Communications Co Ltd",
    "7CFF4D": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
    "7470FD": "Intel Corporate",
    "5065F3": "Hewlett Packard",
    "3C9509": "Liteon Technology Corporation",
    "30FD38": "Google",
    "64CB5D": "SIA TeleSet",
    "5821E9": "TWPI",
    "F0E3DC": "Tecon MT",
    "A8DA01": "Shenzhen NUOLIJIA Digital Technology Co.",
    "88E90F": "innomdlelab",
    "0010D8": "CALISTA",
    "002194": "Ping Communication",
    "1894C6": "ShenZhen Chenyee Technology Co.",
    "703A73": "Shenzhen Sundray Technologies Company Limited",
    "80AD16": "Xiaomi Communications Co Ltd",
    "044EAF": "LG Innotek",
    "98D863": "Shanghai High-Flying Electronics Technology Co.",
    "C49F4C": "HUAWEI TECHNOLOGIES CO.",
    "0C704A": "HUAWEI TECHNOLOGIES CO.",
    "10F9EB": "Industria Fueguina de Relojería Electrónica s.a.",
    "5C5AEA": "FORD",
    "000B7B": "Test-Um Inc.",
    "BCDDC2": "Espressif Inc.",
    "C88F26": "Skyworth Digital Technology(Shenzhen) Co.",
    "20365B": "Megafone Limited",
    "E8DE00": "ChongQing GuanFang Technology Co.",
    "FC643A": "Samsung Electronics Co.",
    "003074": "EQUIINET LTD.",
    "B0B3AD": "HUMAX Co.",
    "40BD32": "Texas Instruments",
    "CC8E71": "Cisco Systems",
    "70D081": "Beijing Netpower Technologies Inc.",
    "70C94E": "Liteon Technology Corporation",
    "38F554": "HISENSE ELECTRIC CO.",
    "18A28A": "Essel-T Co.",
    "A8515B": "Samsung Electronics Co.",
    "001936": "STERLITE OPTICAL TECHNOLOGIES LIMITED",
    "3CE824": "HUAWEI TECHNOLOGIES CO.",
    "54B7E5": "Rayson Technology Co.",
    "946372": "vivo Mobile Communication Co.",
    "BC0FA7": "Ouster",
    "F0C9D1": "GD Midea Air-Conditioning Equipment Co.",
    "F8C120": "Xi'an Link-Science Technology Co.",
    "B4FBF9": "HUAWEI TECHNOLOGIES CO.",
    "506F77": "HUAWEI TECHNOLOGIES CO.",
    "0C41E9": "HUAWEI TECHNOLOGIES CO.",
    "70F220": "Actiontec Electronics",
    "345A06": "SHARP Corporation",
    "B89F09": "Wistron Neweb Corporation",
    "0402CA": "Shenzhen Vtsonic Co.",
    "3CFB5C": "Fiberhome Telecommunication Technologies Co.",
    "7440BB": "Hon Hai Precision Ind. Co.",
    "88BD45": "Samsung Electronics Co.",
    "54FCF0": "Samsung Electronics Co.",
    "306A85": "Samsung Electronics Co.",
    "4CDD31": "Samsung Electronics Co.",
    "B4DE31": "Cisco Systems",
    "A44027": "zte corporation",
    "B4F7A1": "LG Electronics (Mobile Communications)",
    "70EF00": "Apple",
    "28EDE0": "AMPAK Technology",
    "1C1161": "Ciena Corporation",
    "C87765": "Tiesse SpA",
    "D0817A": "Apple",
    "98CA33": "Apple",
    "68AB1E": "Apple",
    "BCFFEB": "Motorola Mobility LLC",
    "2C37C5": "Qingdao Haier Intelligent Home Appliance Technology Co.",
    "CC40D0": "NETGEAR",
    "7C7630": "Shenzhen YOUHUA Technology Co.",
    "9822EF": "Liteon Technology Corporation",
    "7C7635": "Intel Corporate",
    "B80716": "vivo Mobile Communication Co.",
    "788038": "FUNAI ELECTRIC CO.",
    "F045DA": "Texas Instruments",
    "1CEEC9": "Elo touch solutions",
    "001862": "Seagate Technology",
    "000C50": "Seagate Technology",
    "E4F042": "Google",
    "20B399": "Enterasys",
    "CC2D21": "Tenda Technology Co.",
    "004097": "DATEX DIVISION OF",
    "4048FD": "IEEE Registration Authority",
    "A8EEC6": "Muuselabs NV/SA",
    "9C4FCF": "TCT mobile ltd",
    "D896E0": "Alibaba Cloud Computing Ltd.",
    "207852": "Nokia Solutions and Networks GmbH & Co. KG",
    "F417B8": "AirTies Wireless Networks",
    "38F73D": "Amazon Technologies Inc.",
    "B8F74A": "RCNTEC",
    "ECF451": "Arcadyan Corporation",
    "581243": "AcSiP Technology Corp.",
    "58C17A": "Cambium Networks Limited",
    "E0AADB": "Nanjing PANENG Technology Development Co.",
    "C8DEC9": "Coriant",
    "342AF1": "Texas Instruments",
    "0C6111": "Anda Technologies SAC",
    "0022C4": "epro GmbH",
    "0C1539": "Apple",
    "1C330E": "PernixData",
    "44D5A5": "AddOn Computer",
    "645106": "Hewlett Packard",
    "00BE9E": "Fiberhome Telecommunication Technologies Co.",
    "54C57A": "Sunnovo International Limited",
    "6C5697": "Amazon Technologies Inc.",
    "F87B20": "Cisco Systems",
    "38AD8E": "New H3C Technologies Co.",
    "34D0B8": "IEEE Registration Authority",
    "ECFAF4": "SenRa Tech Pvt. Ltd",
    "0005FF": "SNS Solutions",
    "D88F76": "Apple",
    "409C28": "Apple",
    "001C73": "Arista Networks",
    "2C8A72": "HTC Corporation",
    "38019F": "SHENZHEN FAST TECHNOLOGIES CO.",
    "245CCB": "AXIe Consortium",
    "609BC8": "Hipad Intelligent Technology Co.",
    "406A8E": "Hangzhou Puwell OE Tech Ltd.",
    "1C0FAF": "Lucid Vision Labs",
    "88B4A6": "Motorola Mobility LLC",
    "F449EF": "EMSTONE",
    "54DF24": "Fiberhome Telecommunication Technologies Co.",
    "AC1DDF": "IEEE Registration Authority",
    "24B209": "Avaya Inc",
    "FC65DE": "Amazon Technologies Inc.",
    "BC903A": "Robert Bosch GmbH",
    "E8D819": "AzureWave Technology Inc.",
    "B06EBF": "ASUSTek COMPUTER INC.",
    "002128": "Oracle Corporation",
    "28CF08": "ESSYS",
    "74860B": "Cisco Systems",
    "182D98": "Jinwoo Industrial system",
    "782D7E": "TRENDnet",
    "741AE0": "IEEE Registration Authority",
    "583879": "RICOH COMPANY",
    "F44C70": "Skyworth Digital Technology(Shenzhen) Co.",
    "78321B": "D-Link International",
    "D8A534": "Spectronix Corporation",
    "00A096": "MITSUMI ELECTRIC CO.",
    "78617C": "MITSUMI ELECTRIC CO.",
    "EC51BC": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "F079E8": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "D0B128": "Samsung Electronics Co.",
    "BC5451": "Samsung Electronics Co.",
    "08661F": "Palo Alto Networks",
    "74EAC8": "New H3C Technologies Co.",
    "B4D64E": "Caldero Limited",
    "F89DBB": "Tintri",
    "D8A01D": "Espressif Inc.",
    "904E91": "IEEE Registration Authority",
    "DC0C2D": "WEIFANG GOERTEK ELECTRONICS CO.",
    "C4F312": "Texas Instruments",
    "601803": "Daikin Air-conditioning (Shanghai) Co.",
    "8CFEB4": "VSOONTECH ELECTRONICS CO.",
    "940E6B": "HUAWEI TECHNOLOGIES CO.",
    "64FB50": "RoomReady/Zdi",
    "58B42D": "YSTen Technology Co.",
    "34298F": "IEEE Registration Authority",
    "5CEA1D": "Hon Hai Precision Ind. Co.",
    "181456": "Nokia Corporation",
    "78CA04": "Nokia Corporation",
    "104B46": "Mitsubishi Electric Corporation",
    "0017C8": "KYOCERA Display Corporation",
    "5CE8B7": "Oraimo Technology Limited",
    "CC66B2": "Nokia",
    "38E2DD": "zte corporation",
    "885DFB": "zte corporation",
    "68ECC5": "Intel Corporate",
    "3C11B2": "Fraunhofer FIT",
    "288CB8": "zte corporation",
    "78BC1A": "Cisco Systems",
    "005C86": "SHENZHEN FAST TECHNOLOGIES CO.",
    "5C546D": "HUAWEI TECHNOLOGIES CO.",
    "48BCA6": "​ASUNG TECHNO CO.",
    "3C10E6": "PHAZR Inc.",
    "30053F": "JTI Co.",
    "B009DA": "Ring Solutions",
    "00054F": "Garmin International",
    "904506": "Tokyo Boeki Medisys Inc.",
    "0021A1": "Cisco Systems",
    "E048D3": "MOBIWIRE MOBILES (NINGBO) CO.",
    "B8DB1C": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "58E28F": "Apple",
    "787B8A": "Apple",
    "000C03": "HDMI Licensing",
    "F4939F": "Hon Hai Precision Industry Co.",
    "000726": "SHENZHEN GONGJIN ELECTRONICS CO.",
    "FC8B97": "SHENZHEN GONGJIN ELECTRONICS CO.",
    "2880A2": "Novatel Wireless Solutions",
    "84A1D1": "Sagemcom Broadband SAS",
    "FC7F56": "CoSyst Control Systems GmbH",
    "2C4053": "Samsung Electronics Co.",
    "0C8FFF": "HUAWEI TECHNOLOGIES CO.",
    "54B121": "HUAWEI TECHNOLOGIES CO.",
    "A80C63": "HUAWEI TECHNOLOGIES CO.",
    "5CC307": "HUAWEI TECHNOLOGIES CO.",
    "788C4D": "Indyme Solutions",
    "DCEB53": "Wuhan QianXiao Elecronic Technology CO.",
    "EC8AC7": "Fiberhome Telecommunication Technologies Co.",
    "88365F": "LG Electronics (Mobile Communications)",
    "24B2DE": "Espressif Inc.",
    "F0EFD2": "TF PAYMENT SERVICE CO.",
    "000E59": "Sagemcom Broadband SAS",
    "788102": "Sercomm Corporation.",
    "84AA9C": "MitraStar Technology Corp.",
    "2CAB25": "SHENZHEN GONGJIN ELECTRONICS CO.",
    "1CA532": "SHENZHEN GONGJIN ELECTRONICS CO.",
    "001F92": "Motorola Solutions Inc.",
    "0025C4": "Ruckus Wireless",
    "C0C520": "Ruckus Wireless",
    "70DEF9": "FAI WAH INTERNATIONAL (HONG KONG) LIMITED",
    "4CB008": "Shenzhen Gwelltimes Technology Co.",
    "E86FF2": "Actiontec Electronics",
    "005018": "AMIT",
    "FC2F6B": "Everspin Technologies",
    "101B54": "HUAWEI TECHNOLOGIES CO.",
    "7CBACC": "IEEE Registration Authority",
    "540237": "Teltronic AG",
    "E0107F": "Ruckus Wireless",
    "C4017C": "Ruckus Wireless",
    "404229": "Layer3TV",
    "F81D90": "Solidwintech",
    "B0EABC": "ASKEY COMPUTER CORP",
    "94C691": "EliteGroup Computer Systems Co.",
    "3CF591": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "602101": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "7CEB7F": "Dmet Products Corp.",
    "8C8580": "Smart Innovation LLC",
    "287B09": "zte corporation",
    "A06A44": "Vizio",
    "88B111": "Intel Corporate",
    "DCBE7A": "Zhejiang Nurotron Biotechnology Co.",
    "3438B7": "HUMAX Co.",
    "78B28D": "Beijing Tengling Technology CO.Ltd",
    "784501": "Biamp Systems",
    "54D751": "Proximus",
    "CC0677": "Fiberhome Telecommunication Technologies Co.",
    "14780B": "Varex Imaging Deutschland AG",
    "0080C2": "IEEE 802.1 Chair",
    "ECF342": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "D4258B": "Intel Corporate",
    "041B6D": "LG Electronics (Mobile Communications)",
    "F44156": "Arrikto Inc.",
    "986C5C": "Jiangxi Gosun Guard Security Co.",
    "50FF20": "Keenetic Limited",
    "688DB6": "AETEK INC.",
    "00F82C": "Cisco Systems",
    "00C1B1": "Cisco Systems",
    "F4FCB1": "JJ Corp",
    "8C395C": "Bit4id Srl",
    "309C23": "Micro-Star INTL CO.",
    "145E45": "Bamboo Systems Group",
    "ACAFB9": "Samsung Electronics Co.",
    "181212": "Cepton Technologies",
    "70D923": "vivo Mobile Communication Co.",
    "B83A08": "Tenda Technology Co.",
    "50D37F": "Yu Fly Mikly Way Science and Technology Co.",
    "B03D96": "Vision Valley FZ LLC",
    "F894C2": "Intel Corporate",
    "70D379": "Cisco Systems",
    "100501": "PEGATRON CORPORATION",
    "D8C8E9": "Phicomm (Shanghai) Co.",
    "7CB960": "Shanghai X-Cheng telecom LTD",
    "28B448": "HUAWEI TECHNOLOGIES CO.",
    "70DB98": "Cisco Systems",
    "30D386": "zte corporation",
    "24792A": "Ruckus Wireless",
    "A49BF5": "Hybridserver Tec GmbH",
    "F470AB": "vivo Mobile Communication Co.",
    "2C5A0F": "Cisco Systems",
    "2C3124": "Cisco Systems",
    "9CC8AE": "Becton",
    "B0359F": "Intel Corporate",
    "C0D962": "ASKEY COMPUTER CORP",
    "F80BCB": "Cisco Systems",
    "08028E": "NETGEAR",
    "B47C9C": "Amazon Technologies Inc.",
    "503DA1": "Samsung Electronics Co.",
    "503237": "Apple",
    "B0481A": "Apple",
    "B49CDF": "Apple",
    "48BF6B": "Apple",
    "2CFAA2": "Alcatel-Lucent Enterprise",
    "E8E732": "Alcatel-Lucent Enterprise",
    "7C2664": "Sagemcom Broadband SAS",
    "AC6B0F": "CADENCE DESIGN SYSTEMS INC",
    "7C3866": "Texas Instruments",
    "0C61CF": "Texas Instruments",
    "9C1D58": "Texas Instruments",
    "58821D": "H. Schomäcker GmbH",
    "D8A105": "Syslane",
    "3C0518": "Samsung Electronics Co.",
    "900628": "Samsung Electronics Co.",
    "9C84BF": "Apple",
    "B4A9FE": "GHIA Technology (Shenzhen) LTD",
    "F097E5": "TAMIO",
    "4C1A3D": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "1CA0D3": "IEEE Registration Authority",
    "9CFCD1": "Aetheris Technology (Shanghai) Co.",
    "BCA042": "SHANGHAI FLYCO ELECTRICAL APPLIANCE CO.",
    "CCCE1E": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
    "0CF4D5": "Ruckus Wireless",
    "00111B": "Targa Systems Div L-3 Communications",
    "6854C1": "ColorTokens",
    "346E9D": "Ericsson AB",
    "F4DC41": "YOUNGZONE CULTURE (SHANGHAI) CORP",
    "000F4F": "PCS Systemtechnik GmbH",
    "6C750D": "WiFiSONG",
    "3805AC": "Piller Group GmbH",
    "BC3F8F": "HUAWEI TECHNOLOGIES CO.",
    "143004": "HUAWEI TECHNOLOGIES CO.",
    "38AA3C": "SAMSUNG ELECTRO MECHANICS CO.",
    "50A4D0": "IEEE Registration Authority",
    "800010": "AT&T",
    "0C3CCD": "Universal Global Scientific Industrial Co.",
    "14ABC5": "Intel Corporate",
    "0024F1": "Shenzhen Fanhai Sanjiang Electronics Co.",
    "A80CCA": "Shenzhen Sundray Technologies Company Limited",
    "50D213": "CviLux Corporation",
    "001E29": "Hypertherm Inc",
    "7CC6C4": "Kolff Computer Supplies b.v.",
    "C4836F": "Ciena Corporation",
    "5004B8": "HUAWEI TECHNOLOGIES CO.",
    "000302": "Charles Industries",
    "5CFF35": "Wistron Corporation",
    "78F29E": "PEGATRON CORPORATION",
    "64777D": "Hitron Technologies. Inc",
    "60D262": "Tzukuri Pty Ltd",
    "142FFD": "LT SECURITY INC",
    "00D0B2": "Xiotech Corporation",
    "9C50EE": "Cambridge Industries(Group) Co.",
    "40ED98": "IEEE Registration Authority",
    "ACDCE5": "Procter & Gamble Company",
    "00B362": "Apple",
    "E4E4AB": "Apple",
    "54FA96": "Nokia Solutions and Networks GmbH & Co. KG",
    "60334B": "Apple",
    "C891F9": "Sagemcom Broadband SAS",
    "8404D2": "Kirale Technologies SL",
    "38AFD7": "FUJITSU LIMITED",
    "28993A": "Arista Networks",
    "60427F": "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.",
    "BCA8A6": "Intel Corporate",
    "74FF4C": "Skyworth Digital Technology(Shenzhen) Co.",
    "A02C36": "FN-LINK TECHNOLOGY LIMITED",
    "F48C50": "Intel Corporate",
    "DCD255": "Kinpo Electronics",
    "64EB8C": "Seiko Epson Corporation",
    "001351": "Niles Audio Corporation",
    "000320": "Xpeed",
    "AC1F6B": "Super Micro Computer",
    "508A0F": "SHENZHEN FISE TECHNOLOGY HOLDING CO.",
    "7CCBE2": "IEEE Registration Authority",
    "A8A5E2": "MSF-Vathauer Antriebstechnik GmbH & Co KG",
    "C0288D": "Logitech",
    "6CEC5A": "Hon Hai Precision Ind. CO.",
    "44C346": "HUAWEI TECHNOLOGIES CO.",
    "307496": "HUAWEI TECHNOLOGIES CO.",
    "708A09": "HUAWEI TECHNOLOGIES CO.",
    "180675": "Dilax Intelcom GmbH",
    "000FC2": "Uniwell Corporation",
    "CCC5EF": "Co-Comm Servicios Telecomunicaciones S.L.",
    "9002A9": "Zhejiang Dahua Technology Co.",
    "E89EB4": "Hon Hai Precision Ind. Co.",
    "D46A6A": "Hon Hai Precision Ind. Co.",
    "98FD74": "ACT.CO.LTD",
    "E0508B": "Zhejiang Dahua Technology Co.",
    "000064": "Yokogawa Digital Computer Corporation",
    "D0F73B": "Helmut Mauell GmbH Werk Weida",
    "0C4933": "Sichuan Jiuzhou Electronic Technology Co.",
    "9C1E95": "Actiontec Electronics",
    "64DB43": "Motorola (Wuhan) Mobility Technologies Communication Co.",
    "68AF13": "Futura Mobility",
    "681AB2": "zte corporation",
    "7CEBAE": "Ridgeline Instruments",
    "002590": "Super Micro Computer",
    "24C1BD": "CRRC DALIAN R&D CO.",
    "00A2EE": "Cisco Systems",
    "0059DC": "Cisco Systems",
    "C8D3FF": "Hewlett Packard",
    "C4BE84": "Texas Instruments",
    "F4F524": "Motorola Mobility LLC",
    "000B2E": "Cal-Comp Electronics & Communications Company Ltd.",
    "4865EE": "IEEE Registration Authority",
    "F4CAE5": "FREEBOX SAS",
    "00BBC1": "CANON INC.",
    "0013A5": "General Solutions",
    "5098F3": "Rheem Australia Pty Ltd",
    "506B8D": "Nutanix",
    "0038DF": "Cisco Systems",
    "9C3DCF": "NETGEAR",
    "40F413": "Rubezh",
    "90004E": "Hon Hai Precision Ind. Co.",
    "248894": "shenzhen lensun Communication Technology LTD",
    "EC107B": "Samsung Electronics Co.",
    "B04BBF": "PT HAN SUNG ELECTORONICS INDONESIA",
    "CC2D83": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "0015FF": "Novatel Wireless Solutions",
    "D46E0E": "TP-LINK TECHNOLOGIES CO.",
    "88366C": "EFM Networks",
    "48DA96": "Eddy Smart Home Solutions Inc.",
    "F074E4": "Thundercomm Technology Co.",
    "A0722C": "HUMAX Co.",
    "C83DD4": "CyberTAN Technology Inc.",
    "E0B94D": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
    "38D547": "ASUSTek COMPUTER INC.",
    "B4D135": "Cloudistics",
    "F02FA7": "HUAWEI TECHNOLOGIES CO.",
    "18DED7": "HUAWEI TECHNOLOGIES CO.",
    "1C232C": "Samsung Electronics Co.",
    "78888A": "CDR Sp. z o.o. Sp. k.",
    "FCD848": "Apple",
    "E00DB9": "Cree",
    "FC83C6": "N-Radio Technologies Co.",
    "DC0D30": "Shenzhen Feasycom Technology Co.",
    "F0ACD7": "IEEE Registration Authority",
    "0021D2": "Samsung Electronics Co.",
    "0021D1": "Samsung Electronics Co.",
    "001FCC": "Samsung Electronics Co.",
    "A42983": "Boeing Defence Australia",
    "EC8892": "Motorola Mobility LLC",
    "9495A0": "Google",
    "00A6CA": "Cisco Systems",
    "D8452B": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "E4186B": "Zyxel Communications Corporation",
    "D41D71": "Palo Alto Networks",
    "008731": "Cisco Systems",
    "88DEA9": "Roku",
    "004A77": "zte corporation",
    "60A10A": "Samsung Electronics Co.",
    "8C71F8": "Samsung Electronics Co.",
    "CC051B": "Samsung Electronics Co.",
    "8C7712": "Samsung Electronics Co.",
    "9463D1": "Samsung Electronics Co.",
    "1C9D3E": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "7487A9": "OCT Technology Co.",
    "2C3F0B": "Cisco Meraki",
    "503F98": "CMITECH",
    "5C497D": "Samsung Electronics Co.",
    "98234E": "Micromedia AG",
    "782079": "ID Tech",
    "78D6F0": "SAMSUNG ELECTRO MECHANICS CO.",
    "7825AD": "Samsung Electronics Co.",
    "ECE09B": "Samsung Electronics Co.",
    "001632": "Samsung Electronics Co.",
    "0C6076": "Hon Hai Precision Ind. Co.",
    "0CEEE6": "Hon Hai Precision Ind. Co.",
    "E4D53D": "Hon Hai Precision Ind. Co.",
    "C0143D": "Hon Hai Precision Ind. Co.",
    "C01885": "Hon Hai Precision Ind. Co.",
    "5894CF": "Vertex Standard LMR",
    "20F85E": "Delta Electronics",
    "E4E0C5": "Samsung Electronics Co.",
    "20D5BF": "Samsung Electronics Co.",
    "0023E4": "IPnect co. ltd.",
    "70D4F2": "RIM",
    "0016DB": "Samsung Electronics Co.",
    "001EE2": "Samsung Electronics Co.",
    "C0BDD1": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
    "B479A7": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
    "7C11CB": "HUAWEI TECHNOLOGIES CO.",
    "1C25E1": "China Mobile IOT Company Limited",
    "C0F636": "Hangzhou Kuaiyue Technologies",
    "BC20A4": "Samsung Electronics Co.",
    "08D42B": "Samsung Electronics Co.",
    "789ED0": "Samsung Electronics Co.",
    "B0C4E7": "Samsung Electronics Co.",
    "C81479": "Samsung Electronics Co.",
    "002490": "Samsung Electronics Co.",
    "0023D7": "Samsung Electronics Co.",
    "549B12": "Samsung Electronics Co.",
    "FCA13E": "Samsung Electronics Co.",
    "A00798": "Samsung Electronics Co.",
    "001A22": "eQ-3 Entwicklung GmbH",
    "1CAF05": "Samsung Electronics Co.",
    "24C696": "Samsung Electronics Co.",
    "94D771": "Samsung Electronics Co.",
    "E84E84": "Samsung Electronics Co.",
    "B0DF3A": "Samsung Electronics Co.",
    "805719": "Samsung Electronics Co.",
    "34BE00": "Samsung Electronics Co.",
    "78521A": "Samsung Electronics Co.",
    "001FCD": "Samsung Electronics Co.",
    "38ECE4": "Samsung Electronics Co.",
    "945103": "Samsung Electronics Co.",
    "5CE8EB": "Samsung Electronics Co.",
    "240DC2": "TCT mobile ltd",
    "04FEA1": "Fihonest communication co.",
    "EC8CA2": "Ruckus Wireless",
    "EC8EAE": "Nagravision SA",
    "E0E7BB": "Nureva",
    "546C0E": "Texas Instruments",
    "A043DB": "Sitael S.p.A.",
    "20BBC6": "Jabil Circuit Hungary Ltd.",
    "00B0B3": "XSTREAMIS PLC",
    "002363": "Zhuhai Raysharp Technology Co.",
    "009058": "Ultra Electronics Command & Control Systems",
    "001CFD": "Universal Electronics",
    "001087": "XSTREAMIS PLC",
    "AC482D": "Ralinwi Nanjing Electronic Technology Co.",
    "B80018": "Htel",
    "7472B0": "Guangzhou Shiyuan Electronics Co.",
    "DC1A01": "Ecoliv Technology ( Shenzhen ) Ltd.",
    "080087": "Xyplex",
    "00549F": "Avaya Inc",
    "049FCA": "HUAWEI TECHNOLOGIES CO.",
    "50016B": "HUAWEI TECHNOLOGIES CO.",
    "00001B": "Novell",
    "0004DC": "Nortel Networks",
    "000CF7": "Nortel Networks",
    "000FCD": "Nortel Networks",
    "2824FF": "Wistron Neweb Corporation",
    "38256B": "Microsoft Mobile Oy",
    "203AEF": "Sivantos GmbH",
    "005979": "Networked Energy Services",
    "D84710": "Sichuan Changhong Electric Ltd.",
    "001972": "Plexus (Xiamen) Co.",
    "4CB21C": "Maxphotonics Co.",
    "205EF7": "Samsung Electronics Co.",
    "141F78": "Samsung Electronics Co.",
    "002347": "ProCurve Networking by HP",
    "0024A8": "ProCurve Networking by HP",
    "C09134": "ProCurve Networking by HP",
    "001CEF": "Primax Electronics Ltd.",
    "000276": "Primax Electronics Ltd.",
    "A8AD3D": "Alcatel-Lucent Shanghai Bell Co.",
    "24AF4A": "Alcatel-Lucent IPD",
    "7C2064": "Alcatel-Lucent IPD",
    "48F8E1": "Nokia",
    "8C90D3": "Nokia",
    "207C8F": "Quanta Microsystems",
    "000B34": "ShangHai Broadband Technologies CO.LTD",
    "3092F6": "SHANGHAI SUNMON COMMUNICATION TECHNOGY CO.",
    "001BBA": "Nortel Networks",
    "001969": "Nortel Networks",
    "0018B0": "Nortel Networks",
    "0016CA": "Nortel Networks",
    "001478": "TP-LINK TECHNOLOGIES CO.",
    "00140E": "Nortel Networks",
    "001E1F": "Nortel Networks",
    "C44BD1": "Wallys Communications  Teachnologies Co.",
    "6CB9C5": "Delta Networks",
    "0028F8": "Intel Corporate",
    "58BC8F": "Cognitive Systems Corp.",
    "D455BE": "SHENZHEN FAST TECHNOLOGIES CO.",
    "B8BB23": "Guangdong Nufront CSC Co.",
    "34EA34": "HangZhou Gubei Electronics Technology Co.",
    "EC26FB": "TECC CO.",
    "44DC91": "PLANEX COMMUNICATIONS INC.",
    "E09DB8": "PLANEX COMMUNICATIONS INC.",
    "000F59": "Phonak AG",
    "74B57E": "zte corporation",
    "0020F4": "SPECTRIX CORPORATION",
    "04EE91": "x-fabric GmbH",
    "C49A02": "LG Electronics (Mobile Communications)",
    "54D272": "Nuki Home Solutions GmbH",
    "B47443": "Samsung Electronics Co.",
    "30766F": "LG Electronics (Mobile Communications)",
    "A8922C": "LG Electronics (Mobile Communications)",
    "F80CF3": "LG Electronics (Mobile Communications)",
    "001F6B": "LG Electronics (Mobile Communications)",
    "0026E2": "LG Electronics (Mobile Communications)",
    "E8886C": "Shenzhen SC Technologies Co.",
    "DC35F1": "Positivo Tecnologia S.A.",
    "0024FF": "QLogic Corporation",
    "001E21": "Qisda Corporation",
    "00039D": "Qisda Corporation",
    "00080D": "Toshiba",
    "000E7B": "Toshiba",
    "E8E0B7": "Toshiba",
    "0003B2": "Radware",
    "00A0C6": "Qualcomm Inc.",
    "649C81": "Qualcomm Inc.",
    "002186": "Universal Global Scientific Industrial Co.",
    "183919": "Unicoi Systems",
    "00C0E4": "SIEMENS BUILDING",
    "000D10": "Embedtronics Oy",
    "FCF647": "Fiberhome Telecommunication Technologies Co.",
    "18686A": "zte corporation",
    "DC4427": "IEEE Registration Authority",
    "001A6A": "Tranzas",
    "BC3400": "IEEE Registration Authority",
    "A47174": "HUAWEI TECHNOLOGIES CO.",
    "F4CB52": "HUAWEI TECHNOLOGIES CO.",
    "B808D7": "HUAWEI TECHNOLOGIES CO.",
    "94611E": "Wata Electronics Co.",
    "A020A6": "Espressif Inc.",
    "58528A": "Mitsubishi Electric Corporation",
    "680715": "Intel Corporate",
    "3CB6B7": "vivo Mobile Communication Co.",
    "001FA8": "Smart Energy Instruments Inc.",
    "000FDB": "Westell Technologies Inc.",
    "784476": "Zioncom Electronics (Shenzhen) Ltd.",
    "001165": "ZNYX Networks",
    "3C0771": "Sony Corporation",
    "80414E": "BBK EDUCATIONAL ELECTRONICS CORP.",
    "249442": "OPEN ROAD SOLUTIONS",
    "C46413": "Cisco Systems",
    "0010CA": "Telco Systems",
    "00E09E": "Quantum Corporation",
    "000A08": "Alps Alpine",
    "206A8A": "Wistron Infocomm (Zhongshan) Corporation",
    "000A68": "Solarflare Communications Inc.",
    "001EC0": "Microchip Technology Inc.",
    "C4F1D1": "BEIJING SOGOU TECHNOLOGY DEVELOPMENT CO.",
    "38BC1A": "MEIZU Technology Co.",
    "ECD68A": "Shenzhen JMicron Intelligent Technology Developmen",
    "5052D2": "Hangzhou Telin Technologies Co.",
    "90EED9": "UNIVERSAL DE DESARROLLOS ELECTRÓNICOS",
    "7C574E": "COBI GmbH",
    "045604": "Gionee Communication Equipment Co.",
    "C8AFE3": "Hefei Radio Communication Technology Co.",
    "945907": "Shanghai HITE-BELDEN Network Technology Co.",
    "001848": "Vecima Networks Inc.",
    "0016FB": "SHENZHEN MTC CO LTD",
    "74CC39": "Fiberhome Telecommunication Technologies Co.",
    "340AFF": "Qingdao Hisense Communications Co.",
    "587E61": "Qingdao Hisense Communications Co.",
    "C0A1A2": "MarqMetrix",
    "08D0B7": "Qingdao Hisense Communications Co.",
    "00FEC8": "Cisco Systems",
    "00253E": "Sensus Metering Systems",
    "606453": "AOD Co.",
    "6C98EB": "Riverbed Technology",
    "009E1E": "Cisco Systems",
    "2C36A0": "Capisco Limited",
    "B0B2DC": "Zyxel Communications Corporation",
    "CC5D4E": "Zyxel Communications Corporation",
    "404A03": "Zyxel Communications Corporation",
    "C86C87": "Zyxel Communications Corporation",
    "E47B3F": "BEIJING CO-CLOUD TECHNOLOGY LTD.",
    "54EDA3": "Navdy",
    "10BEF5": "D-Link International",
    "A0415E": "Opsens Solution Inc.",
    "2C5A8D": "SYSTRONIK Elektronik u. Systemtechnik GmbH",
    "3822D6": "Hangzhou H3C Technologies Co.",
    "A860B6": "Apple",
    "C4B301": "Apple",
    "E05F45": "Apple",
    "483B38": "Apple",
    "1C9148": "Apple",
    "34A2A2": "HUAWEI TECHNOLOGIES CO.",
    "749D8F": "HUAWEI TECHNOLOGIES CO.",
    "C864C7": "zte corporation",
    "0022E7": "WPS Parking Systems",
    "0C8A87": "AgLogica Holdings",
    "B8E779": "9Solutions Oy",
    "28F366": "Shenzhen Bilian electronic CO.",
    "E0A3AC": "HUAWEI TECHNOLOGIES CO.",
    "BC7574": "HUAWEI TECHNOLOGIES CO.",
    "20A680": "HUAWEI TECHNOLOGIES CO.",
    "8828B3": "HUAWEI TECHNOLOGIES CO.",
    "F823B2": "HUAWEI TECHNOLOGIES CO.",
    "341290": "Treeview Co.",
    "7CFE4E": "Shenzhen Safe vision Technology Co.",
    "644FB0": "Hyunjin.com",
    "00E0E6": "INCAA Computers",
    "6C3B6B": "Routerboard.com",
    "006CBC": "Cisco Systems",
    "5C70A3": "LG Electronics (Mobile Communications)",
    "001D08": "Jiangsu Yinhe  Electronics Co.",
    "4851B7": "Intel Corporate",
    "905F2E": "TCT mobile ltd",
    "B4B15A": "Siemens AG Energy Management Division",
    "00A0A4": "Oracle Corporation",
    "749781": "zte corporation",
    "9CDF03": "Harman/Becker Automotive Systems GmbH",
    "001188": "Enterasys",
    "0001F4": "Enterasys",
    "00109B": "Emulex Corporation",
    "A4E597": "Gessler GmbH",
    "A86BAD": "Hon Hai Precision Ind. Co.",
    "D80F99": "Hon Hai Precision Ind. Co.",
    "C89CDC": "Elitegroup Computer Systems Co.",
    "002511": "Elitegroup Computer Systems Co.",
    "4487FC": "Elitegroup Computer Systems Co.",
    "002465": "Elentec",
    "00089F": "EFM Networks",
    "001D82": "GN Netcom A/S",
    "001317": "GN Netcom A/S",
    "00142A": "Elitegroup Computer Systems Co.",
    "00115B": "Elitegroup Computer Systems Co.",
    "C03FD5": "Elitegroup Computer Systems Co.",
    "ECA86B": "Elitegroup Computer Systems Co.",
    "0050FC": "Edimax Technology Co. Ltd.",
    "0016FA": "ECI Telecom Ltd.",
    "A082AC": "Linear DMS Solutions Sdn. Bhd.",
    "A86AC1": "HanbitEDS Co.",
    "D463FE": "Arcadyan Corporation",
    "689361": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "A0043E": "Parker Hannifin Manufacturing Germany GmbH & Co. KG",
    "C84529": "IMK Networks Co.",
    "001174": "Mojo Networks",
    "001954": "Leaf Corporation.",
    "9466E7": "WOM Engineering",
    "F8A188": "LED Roadway Lighting",
    "34BF90": "Fiberhome Telecommunication Technologies Co.",
    "CCB3F8": "FUJITSU ISOTEC LIMITED",
    "E4A471": "Intel Corporate",
    "10F005": "Intel Corporate",
    "00BD82": "Shenzhen YOUHUA Technology Co.",
    "4CB8B5": "Shenzhen YOUHUA Technology Co.",
    "7085C2": "ASRock Incorporation",
    "94513D": "iSmart Alarm",
    "BC15AC": "Vodafone Italia S.p.A.",
    "EC93ED": "DDoS-Guard LTD",
    "0452C7": "Bose Corporation",
    "F02745": "F-Secure Corporation",
    "54D0B4": "Xiamen Four-Faith Communication Technology Co.",
    "00137C": "Kaicom co.",
    "7C477C": "IEEE Registration Authority",
    "F877B8": "Samsung Electronics Co.",
    "F0D2F1": "Amazon Technologies Inc.",
    "14D11F": "HUAWEI TECHNOLOGIES CO.",
    "DC094C": "HUAWEI TECHNOLOGIES CO.",
    "1C6758": "HUAWEI TECHNOLOGIES CO.",
    "24BCF8": "HUAWEI TECHNOLOGIES CO.",
    "DCEE06": "HUAWEI TECHNOLOGIES CO.",
    "E85659": "Advanced-Connectek Inc.",
    "30FC68": "TP-LINK TECHNOLOGIES CO.",
    "008A96": "Cisco Systems",
    "BC60A7": "Sony Interactive Entertainment Inc.",
    "64CC2E": "Xiaomi Communications Co Ltd",
    "8801F2": "Vitec System Engineering Inc.",
    "A8E3EE": "Sony Interactive Entertainment Inc.",
    "00248D": "Sony Interactive Entertainment Inc.",
    "00041F": "Sony Interactive Entertainment Inc.",
    "20A90E": "TCT mobile ltd",
    "0CA2F4": "Chameleon Technology (UK) Limited",
    "EC438B": "YAPTV",
    "182195": "Samsung Electronics Co.",
    "44783E": "Samsung Electronics Co.",
    "14C3C2": "K.A. Schmersal GmbH & Co. KG",
    "10785B": "Actiontec Electronics",
    "BC44B0": "Elastifile",
    "74BFB7": "Nusoft Corporation",
    "50DA00": "Hangzhou H3C Technologies Co.",
    "F4ED5F": "SHENZHEN KTC TECHNOLOGY GROUP",
    "00E0E4": "FANUC ROBOTICS NORTH AMERICA",
    "D0B53D": "SEPRO ROBOTIQUE",
    "00D0EC": "NAKAYO Inc",
    "441102": "EDMI  Europe Ltd",
    "980CA5": "Motorola (Wuhan) Mobility Technologies Communication Co.",
    "A85EE4": "12Sided Technology",
    "245EBE": "QNAP Systems",
    "0404EA": "Valens Semiconductor Ltd.",
    "800DD7": "Latticework",
    "4CCC6A": "Micro-Star INTL CO.",
    "30636B": "Apple",
    "70884D": "JAPAN RADIO CO.",
    "A4F1E8": "Apple",
    "546751": "Compal Broadband Networks",
    "240B0A": "Palo Alto Networks",
    "D099D5": "Alcatel-Lucent",
    "00247D": "Nokia Danmark A/S",
    "14BB6E": "Samsung Electronics Co.",
    "2CCC15": "Nokia Corporation",
    "D8FB5E": "ASKEY COMPUTER CORP",
    "0018C5": "Nokia Danmark A/S",
    "F4F5A5": "Nokia Corporation",
    "EC9B5B": "Nokia Corporation",
    "0CBF15": "Genetec Inc.",
    "002326": "FUJITSU LIMITED",
    "002265": "Nokia Danmark A/S",
    "1886AC": "Nokia Danmark A/S",
    "001F5C": "Nokia Danmark A/S",
    "001F00": "Nokia Danmark A/S",
    "002668": "Nokia Danmark A/S",
    "002547": "Nokia Danmark A/S",
    "00164E": "Nokia Danmark A/S",
    "E498D1": "Microsoft Mobile Oy",
    "6C2779": "Microsoft Mobile Oy",
    "000D4B": "Roku",
    "F88096": "Elsys Equipamentos Eletrônicos Ltda",
    "001DAA": "DrayTek Corp.",
    "1867B0": "Samsung Electronics Co.",
    "0040FB": "CASCADE COMMUNICATIONS",
    "00CF1C": "Communication Machinery Corporation",
    "D0542D": "Cambridge Industries(Group) Co.",
    "744AA4": "zte corporation",
    "28CC01": "Samsung Electronics Co.",
    "6CF373": "Samsung Electronics Co.",
    "9C3AAF": "Samsung Electronics Co.",
    "781FDB": "Samsung Electronics Co.",
    "183F47": "Samsung Electronics Co.",
    "00001D": "Cabletron Systems",
    "4CA56D": "Samsung Electronics Co.",
    "B86CE8": "Samsung Electronics Co.",
    "0CB319": "Samsung Electronics Co.",
    "50A4C8": "Samsung Electronics Co.",
    "6C8336": "Samsung Electronics Co.",
    "0026B6": "ASKEY COMPUTER CORP",
    "DCD87C": "Beijing Jingdong Century Trading Co.",
    "C4DA7D": "Ivium Technologies B.V.",
    "001BA9": "Brother industries",
    "30A220": "ARG Telecom",
    "E03E44": "Broadcom",
    "002557": "BlackBerry RTS",
    "001CCC": "BlackBerry RTS",
    "00300A": "Aztech Electronics Pte Ltd",
    "001F3F": "AVM GmbH",
    "246511": "AVM GmbH",
    "000B6A": "Asiarock Technology Limited",
    "001B9E": "ASKEY COMPUTER CORP",
    "E0CA94": "ASKEY COMPUTER CORP",
    "C40415": "NETGEAR",
    "E8FCAF": "NETGEAR",
    "841B5E": "NETGEAR",
    "2CB05D": "NETGEAR",
    "A021B7": "NETGEAR",
    "C0FFD4": "NETGEAR",
    "6CB0CE": "NETGEAR",
    "008EF2": "NETGEAR",
    "9CD36D": "NETGEAR",
    "00264D": "Arcadyan Technology Corporation",
    "849CA6": "Arcadyan Technology Corporation",
    "0024B2": "NETGEAR",
    "001B2F": "NETGEAR",
    "001F33": "NETGEAR",
    "001E45": "Sony Corporation",
    "001CA4": "Sony Corporation",
    "001A75": "Sony Corporation",
    "78843C": "Sony Corporation",
    "0023F1": "Sony Corporation",
    "6CFAA7": "AMPAK Technology",
    "0013A9": "Sony Corporation",
    "000AD9": "Sony Corporation",
    "000E07": "Sony Corporation",
    "94CE2C": "Sony Corporation",
    "ACE010": "Liteon Technology Corporation",
    "747548": "Amazon Technologies Inc.",
    "0000B1": "Alpha Micro",
    "001802": "Alpha Networks Inc.",
    "54271E": "AzureWave Technology Inc.",
    "900BC1": "Sprocomm Technologies CO.",
    "0C6AE6": "Stanley Security Solutions",
    "54E4BD": "FN-LINK TECHNOLOGY LIMITED",
    "5414FD": "Orbbec 3D Technology International",
    "485D60": "AzureWave Technology Inc.",
    "DC85DE": "AzureWave Technology Inc.",
    "B0EE45": "AzureWave Technology Inc.",
    "FC0FE6": "Sony Interactive Entertainment Inc.",
    "24FD52": "Liteon Technology Corporation",
    "2CD05A": "Liteon Technology Corporation",
    "74E543": "Liteon Technology Corporation",
    "001CA8": "AirTies Wireless Networks",
    "00238E": "ADB Broadband Italia",
    "001D8B": "ADB Broadband Italia",
    "0013C8": "ADB Broadband Italia",
    "74DE2B": "Liteon Technology Corporation",
    "00225F": "Liteon Technology Corporation",
    "5C93A2": "Liteon Technology Corporation",
    "DC0B1A": "ADB Broadband Italia",
    "842615": "ADB Broadband Italia",
    "F0842F": "ADB Broadband Italia",
    "28C2DD": "AzureWave Technology Inc.",
    "80A589": "AzureWave Technology Inc.",
    "C40938": "FUJIAN STAR-NET COMMUNICATION CO.",
    "74C63B": "AzureWave Technology Inc.",
    "ACE5F0": "Doppler Labs",
    "001C50": "TCL Technoly Electronics (Huizhou) Co.",
    "00AA02": "Intel Corporation",
    "7C7A91": "Intel Corporate",
    "AC7BA1": "Intel Corporate",
    "6C2995": "Intel Corporate",
    "984FEE": "Intel Corporate",
    "8C705A": "Intel Corporate",
    "606720": "Intel Corporate",
    "FCF8AE": "Intel Corporate",
    "6036DD": "Intel Corporate",
    "001E65": "Intel Corporate",
    "001E67": "Intel Corporate",
    "0022FA": "Intel Corporate",
    "001500": "Intel Corporate",
    "A088B4": "Intel Corporate",
    "648099": "Intel Corporate",
    "D07E35": "Intel Corporate",
    "E82AEA": "Intel Corporate",
    "605718": "Intel Corporate",
    "C4D987": "Intel Corporate",
    "100BA9": "Intel Corporate",
    "00270E": "Intel Corporate",
    "B4E1C4": "Microsoft Mobile Oy",
    "E0757D": "Motorola Mobility LLC",
    "34BB26": "Motorola Mobility LLC",
    "806C1B": "Motorola Mobility LLC",
    "00D09E": "2Wire Inc",
    "0019E4": "2Wire Inc",
    "001AC4": "2Wire Inc",
    "001B5B": "2Wire Inc",
    "001EC7": "2Wire Inc",
    "002650": "2Wire Inc",
    "0016EB": "Intel Corporate",
    "0018DE": "Intel Corporate",
    "5CE0C5": "Intel Corporate",
    "58A839": "Intel Corporate",
    "7C5CF8": "Intel Corporate",
    "4C17EB": "Sagemcom Broadband SAS",
    "CC33BB": "Sagemcom Broadband SAS",
    "3CA348": "vivo Mobile Communication Co.",
    "E45AA2": "vivo Mobile Communication Co.",
    "B0D5CC": "Texas Instruments",
    "3829DD": "ONvocal Inc",
    "800A80": "IEEE Registration Authority",
    "DC6DCD": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "002351": "2Wire Inc",
    "3CEA4F": "2Wire Inc",
    "DC7FA4": "2Wire Inc",
    "C4282D": "Embedded Intellect Pty Ltd",
    "348446": "Ericsson AB",
    "044E06": "Ericsson AB",
    "CC3B3E": "Lester Electrical",
    "2082C0": "Xiaomi Communications Co Ltd",
    "00173F": "Belkin International Inc.",
    "001CDF": "Belkin International Inc.",
    "205532": "Gotech International Technology Limited",
    "2CFF65": "Oki Electric Industry Co.",
    "2C27D7": "Hewlett Packard",
    "984BE1": "Hewlett Packard",
    "C05627": "Belkin International Inc.",
    "D86CE9": "Sagemcom Broadband SAS",
    "E8F1B0": "Sagemcom Broadband SAS",
    "0015E9": "D-Link Corporation",
    "001B11": "D-Link Corporation",
    "00265A": "D-Link Corporation",
    "5C6B32": "Texas Instruments",
    "84DD20": "Texas Instruments",
    "0017E5": "Texas Instruments",
    "0017EC": "Texas Instruments",
    "0017E7": "Texas Instruments",
    "0017E9": "Texas Instruments",
    "1CBA8C": "Texas Instruments",
    "5846E1": "Baxter International Inc",
    "001831": "Texas Instruments",
    "24FD5B": "SmartThings",
    "2876CD": "Funshion Online Technologies Co.",
    "001A11": "Google",
    "28BC56": "EMAC",
    "C8BE19": "D-Link International",
    "002926": "Applied Optoelectronics",
    "48DB50": "HUAWEI TECHNOLOGIES CO.",
    "A4BA76": "HUAWEI TECHNOLOGIES CO.",
    "0050C2": "IEEE Registration Authority",
    "A0F895": "Shenzhen TINNO Mobile Technology Corp.",
    "0078CD": "Ignition Design Labs",
    "440010": "Apple",
    "0056CD": "Apple",
    "00CDFE": "Apple",
    "24BA13": "RISO KAGAKU CORPORATION",
    "2C6E85": "Intel Corporate",
    "C8478C": "Beken Corporation",
    "E498D6": "Apple",
    "006037": "NXP Semiconductors",
    "DCC0EB": "ASSA ABLOY CÔTE PICARDE",
    "9CEFD5": "Panda Wireless",
    "70CA4D": "Shenzhen lnovance Technology Co.",
    "E4FAFD": "Intel Corporate",
    "94659C": "Intel Corporate",
    "484520": "Intel Corporate",
    "C80E77": "Le Shi Zhi Xin Electronic Technology (Tianjin) Limited",
    "9049FA": "Intel Corporate",
    "BC0F64": "Intel Corporate",
    "0002B3": "Intel Corporation",
    "000347": "Intel Corporation",
    "000E0C": "Intel Corporation",
    "001320": "Intel Corporate",
    "001321": "Hewlett Packard",
    "000802": "Hewlett Packard",
    "0002A5": "Hewlett Packard",
    "6CC217": "Hewlett Packard",
    "1458D0": "Hewlett Packard",
    "D8D385": "Hewlett Packard",
    "18A905": "Hewlett Packard",
    "001B78": "Hewlett Packard",
    "001871": "Hewlett Packard",
    "000E7F": "Hewlett Packard",
    "001185": "Hewlett Packard",
    "001279": "Hewlett Packard",
    "EC9A74": "Hewlett Packard",
    "10604B": "Hewlett Packard",
    "C8CBB8": "Hewlett Packard",
    "843497": "Hewlett Packard",
    "106F3F": "BUFFALO.INC",
    "B0C745": "BUFFALO.INC",
    "5C8A38": "Hewlett Packard",
    "2C59E5": "Hewlett Packard",
    "D860B0": "bioMérieux Italia S.p.A.",
    "D8FC38": "Giantec Semiconductor Inc",
    "AC2A0C": "CSR ZHUZHOU INSTITUTE CO.",
    "2C6798": "InTalTech Ltd.",
    "F8DB7F": "HTC Corporation",
    "64A769": "HTC Corporation",
    "E899C4": "HTC Corporation",
    "BCCFCC": "HTC Corporation",
    "28565A": "Hon Hai Precision Ind. Co.",
    "0019E0": "TP-LINK TECHNOLOGIES CO.",
    "002586": "TP-LINK TECHNOLOGIES CO.",
    "54E6FC": "TP-LINK TECHNOLOGIES CO.",
    "74EA3A": "TP-LINK TECHNOLOGIES CO.",
    "6CB56B": "HUMAX Co.",
    "D81FCC": "Brocade Communications Systems LLC",
    "00234D": "Hon Hai Precision Ind. Co.",
    "002556": "Hon Hai Precision Ind. Co.",
    "601888": "zte corporation",
    "847778": "Cochlear Limited",
    "887F03": "Comper Technology Investment Limited",
    "0080E1": "STMicroelectronics SRL",
    "0004EA": "Hewlett Packard",
    "F431C3": "Apple",
    "64A5C3": "Apple",
    "E422A5": "PLANTRONICS",
    "6021C0": "Murata Manufacturing Co.",
    "88308A": "Murata Manufacturing Co.",
    "5CDAD4": "Murata Manufacturing Co.",
    "0026E8": "Murata Manufacturing Co.",
    "FCC897": "zte corporation",
    "002512": "zte corporation",
    "001C26": "Hon Hai Precision Ind. Co.",
    "002268": "Hon Hai Precision Ind. Co.",
    "BC3AEA": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "F81A67": "TP-LINK TECHNOLOGIES CO.",
    "EC172F": "TP-LINK TECHNOLOGIES CO.",
    "14E6E4": "TP-LINK TECHNOLOGIES CO.",
    "0016CE": "Hon Hai Precision Ind. Co.",
    "300ED5": "Hon Hai Precision Ind. Co.",
    "485AB6": "Hon Hai Precision Ind. Co.",
    "543530": "Hon Hai Precision Ind. Co.",
    "002438": "Brocade Communications Systems LLC",
    "0014C9": "Brocade Communications Systems LLC",
    "344B50": "zte corporation",
    "E8088B": "HUAWEI TECHNOLOGIES CO.",
    "0C96BF": "HUAWEI TECHNOLOGIES CO.",
    "60E701": "HUAWEI TECHNOLOGIES CO.",
    "50EB1A": "Brocade Communications Systems LLC",
    "0027F8": "Brocade Communications Systems LLC",
    "748EF8": "Brocade Communications Systems LLC",
    "F866D1": "Hon Hai Precision Ind. Co.",
    "F0EBD0": "Shanghai Feixun Communication Co.",
    "888603": "HUAWEI TECHNOLOGIES CO.",
    "04F938": "HUAWEI TECHNOLOGIES CO.",
    "AC853D": "HUAWEI TECHNOLOGIES CO.",
    "4846FB": "HUAWEI TECHNOLOGIES CO.",
    "7C6097": "HUAWEI TECHNOLOGIES CO.",
    "CC53B5": "HUAWEI TECHNOLOGIES CO.",
    "60DE44": "HUAWEI TECHNOLOGIES CO.",
    "105172": "HUAWEI TECHNOLOGIES CO.",
    "08E84F": "HUAWEI TECHNOLOGIES CO.",
    "643E8C": "HUAWEI TECHNOLOGIES CO.",
    "84A8E4": "HUAWEI TECHNOLOGIES CO.",
    "001882": "HUAWEI TECHNOLOGIES CO.",
    "D4EA0E": "Avaya Inc",
    "78F5FD": "HUAWEI TECHNOLOGIES CO.",
    "5C7D5E": "HUAWEI TECHNOLOGIES CO.",
    "20F3A3": "HUAWEI TECHNOLOGIES CO.",
    "0C37DC": "HUAWEI TECHNOLOGIES CO.",
    "BC7670": "HUAWEI TECHNOLOGIES CO.",
    "24DBAC": "HUAWEI TECHNOLOGIES CO.",
    "1C1D67": "HUAWEI TECHNOLOGIES CO.",
    "D02DB3": "HUAWEI TECHNOLOGIES CO.",
    "E8CD2D": "HUAWEI TECHNOLOGIES CO.",
    "2469A5": "HUAWEI TECHNOLOGIES CO.",
    "EC233D": "HUAWEI TECHNOLOGIES CO.",
    "E0247F": "HUAWEI TECHNOLOGIES CO.",
    "00464B": "HUAWEI TECHNOLOGIES CO.",
    "80FB06": "HUAWEI TECHNOLOGIES CO.",
    "90671C": "HUAWEI TECHNOLOGIES CO.",
    "BC25E0": "HUAWEI TECHNOLOGIES CO.",
    "F4E3FB": "HUAWEI TECHNOLOGIES CO.",
    "6CFA58": "Avaya Inc",
    "6CA849": "Avaya Inc",
    "64C354": "Avaya Inc",
    "50CD22": "Avaya Inc",
    "B4A95A": "Avaya Inc",
    "581626": "Avaya Inc",
    "A051C6": "Avaya Inc",
    "70E422": "Cisco Systems",
    "00500F": "Cisco Systems",
    "0050A2": "Cisco Systems",
    "00E0B0": "Cisco Systems",
    "00E0FE": "Cisco Systems",
    "00E034": "Cisco Systems",
    "00E0F9": "Cisco Systems",
    "C8D719": "Cisco-Linksys",
    "203A07": "Cisco Systems",
    "0012D2": "Texas Instruments",
    "A863F2": "Texas Instruments",
    "D0FF50": "Texas Instruments",
    "20C38F": "Texas Instruments",
    "7C669D": "Texas Instruments",
    "D8DDFD": "Texas Instruments",
    "7C1DD9": "Xiaomi Communications Co Ltd",
    "A086C6": "Xiaomi Communications Co Ltd",
    "9C99A0": "Xiaomi Communications Co Ltd",
    "584498": "Xiaomi Communications Co Ltd",
    "001079": "Cisco Systems",
    "001029": "Cisco Systems",
    "000E08": "Cisco-Linksys",
    "00603E": "Cisco Systems",
    "00602F": "Cisco Systems",
    "006047": "Cisco Systems",
    "00023D": "Cisco Systems",
    "00502A": "Cisco Systems",
    "4403A7": "Cisco Systems",
    "B0FAEB": "Cisco Systems",
    "D05FB8": "Texas Instruments",
    "84EB18": "Texas Instruments",
    "88908D": "Cisco Systems",
    "F07816": "Cisco Systems",
    "00223A": "Cisco SPVTG",
    "0021BE": "Cisco SPVTG",
    "000C41": "Cisco-Linksys",
    "1CDEA7": "Cisco Systems",
    "F07F06": "Cisco Systems",
    "BC16F5": "Cisco Systems",
    "FC5B39": "Cisco Systems",
    "346F90": "Cisco Systems",
    "14DAE9": "ASUSTek COMPUTER INC.",
    "F4CFE2": "Cisco Systems",
    "A80C0D": "Cisco Systems",
    "7CAD74": "Cisco Systems",
    "F41FC2": "Cisco Systems",
    "44ADD9": "Cisco Systems",
    "0C6803": "Cisco Systems",
    "C08C60": "Cisco Systems",
    "E8EDF3": "Cisco Systems",
    "E4C722": "Cisco Systems",
    "64E950": "Cisco Systems",
    "5CFC66": "Cisco Systems",
    "D46D50": "Cisco Systems",
    "74A02F": "Cisco Systems",
    "C07BBC": "Cisco Systems",
    "24E9B3": "Cisco Systems",
    "0011D8": "ASUSTek COMPUTER INC.",
    "0018F3": "ASUSTek COMPUTER INC.",
    "001A92": "ASUSTek COMPUTER INC.",
    "88F031": "Cisco Systems",
    "0016B6": "Cisco-Linksys",
    "0018F8": "Cisco-Linksys",
    "00252E": "Cisco SPVTG",
    "54D46F": "Cisco SPVTG",
    "A4A24A": "Cisco SPVTG",
    "44E08E": "Cisco SPVTG",
    "BCC810": "Cisco SPVTG",
    "7CB21B": "Cisco SPVTG",
    "24767D": "Cisco SPVTG",
    "481D70": "Cisco SPVTG",
    "00E036": "PIONEER CORPORATION",
    "00E04F": "Cisco Systems",
    "0010FF": "Cisco Systems",
    "001054": "Cisco Systems",
    "0010F6": "Cisco Systems",
    "0010A6": "Cisco Systems",
    "F0B2E5": "Cisco Systems",
    "0010FA": "Apple",
    "0050E4": "Apple",
    "000D93": "Apple",
    "0019E3": "Apple",
    "001B63": "Apple",
    "001EC2": "Apple",
    "001FF3": "Apple",
    "002332": "Apple",
    "00236C": "Apple",
    "0023DF": "Apple",
    "002500": "Apple",
    "0025BC": "Apple",
    "34159E": "Apple",
    "58B035": "Apple",
    "5C5948": "Apple",
    "C8BCC8": "Apple",
    "5897BD": "Cisco Systems",
    "5C838F": "Cisco Systems",
    "ECBD1D": "Cisco Systems",
    "7CFADF": "Apple",
    "24AB81": "Apple",
    "78A3E4": "Apple",
    "1CABA7": "Apple",
    "E0F847": "Apple",
    "28E7CF": "Apple",
    "E4CE8F": "Apple",
    "E8040B": "Apple",
    "145A05": "Apple",
    "148FC6": "Apple",
    "286AB8": "Apple",
    "28E02C": "Apple",
    "E0B9BA": "Apple",
    "00C610": "Apple",
    "7CD1C3": "Apple",
    "F0DCE2": "Apple",
    "A82066": "Apple",
    "BC52B7": "Apple",
    "C0847A": "Apple",
    "B8F6B1": "Apple",
    "8CFABA": "Apple",
    "881FA1": "Apple",
    "C8E0EB": "Apple",
    "98B8E3": "Apple",
    "885395": "Apple",
    "786C1C": "Apple",
    "4C8D79": "Apple",
    "1CE62B": "Apple",
    "24A2E1": "Apple",
    "04214C": "Insight Energy Ventures LLC",
    "F832E4": "ASUSTek COMPUTER INC.",
    "80EA96": "Apple",
    "600308": "Apple",
    "04F13E": "Apple",
    "98F0AB": "Apple",
    "087402": "Apple",
    "94F6A3": "Apple",
    "98E0D9": "Apple",
    "CC29F5": "Apple",
    "285AEB": "Apple",
    "748114": "Apple",
    "18F643": "Apple",
    "A45E60": "Apple",
    "A01828": "Apple",
    "D0034B": "Apple",
    "24A074": "Apple",
    "F02475": "Apple",
    "2C1F23": "Apple",
    "549F13": "Apple",
    "F0DBE2": "Apple",
    "0C3021": "Apple",
    "DC86D8": "Apple",
    "90B931": "Apple",
    "D0E140": "Apple",
    "10417F": "Apple",
    "A8667F": "Apple",
    "D02598": "Apple",
    "783A84": "Apple",
    "5C8D4E": "Apple",
    "8863DF": "Apple",
    "84788B": "Apple",
    "80BE05": "Apple",
    "7831C1": "Apple",
    "0C3E9F": "Apple",
    "FCFC48": "Apple",
    "9C293F": "Apple",
    "80A1AB": "Intellisis",
    "84285A": "Saffron Solutions Inc",
    "D4B8FF": "Home Control Singapore Pte Ltd",
    "EC64E7": "MOCACARE Corporation",
    "40862E": "JDM MOBILE INTERNET SOLUTION CO.",
    "58F496": "Source Chain",
    "88947E": "Fiberhome Telecommunication Technologies Co.",
    "84A423": "Sagemcom Broadband SAS",
    "98F428": "zte corporation",
    "E8343E": "Beijing Infosec Technologies Co.",
    "346987": "zte corporation",
    "D07C2D": "Leie IOT technology Co.",
    "9C88AD": "Fiberhome Telecommunication Technologies Co.",
    "C8A2CE": "Oasis Media Systems LLC",
    "3C7873": "Airsonics",
    "70BF3E": "Charles River Laboratories",
    "A8C87F": "Roqos",
    "3C831E": "CKD Corporation",
    "90DFFB": "HOMERIDER SYSTEMS",
    "2C081C": "OVH",
    "C08488": "Finis Inc",
    "38F557": "JOLATA",
    "4054E4": "Wearsafe Labs Inc",
    "305A3A": "ASUSTek COMPUTER INC.",
    "587F57": "Apple",
    "988744": "Wuxi Hongda Science and Technology Co.",
    "A4CC32": "Inficomm Co.",
    "C4BBEA": "Pakedge Device and Software Inc",
    "006D52": "Apple",
    "54A3FA": "BQT Solutions (Australia)Pty Ltd",
    "A03299": "Lenovo (Beijing) Co.",
    "ACEE9E": "Samsung Electronics Co.",
    "041E7A": "DSPWorks",
    "385F66": "Cisco SPVTG",
    "9C7A03": "Ciena Corporation",
    "246C8A": "YUKAI Engineering",
    "5CCF7F": "Espressif Inc.",
    "B857D8": "Samsung Electronics Co.",
    "B844D9": "Apple",
    "681295": "Lupine Lighting Systems GmbH",
    "7011AE": "Music Life LTD",
    "ACC51B": "Zhuhai Pantum Electronics Co.",
    "1C497B": "Gemtek Technology Co.",
    "2CCF58": "HUAWEI TECHNOLOGIES CO.",
    "D09380": "Ducere Technologies Pvt. Ltd.",
    "68F956": "Objetivos y Servicio de Valor Añadido",
    "84A788": "Perples",
    "AC60B6": "Ericsson AB",
    "14B370": "Gigaset Digital Technology (Shenzhen) Co.",
    "6889C1": "HUAWEI TECHNOLOGIES CO.",
    "C8A9FC": "Goyoo Networks Inc.",
    "143EBF": "zte corporation",
    "FC2FEF": "UTT Technologies Co.",
    "FCFEC2": "Invensys Controls UK Limited",
    "689AB7": "Atelier Vision Corporation",
    "E4A32F": "Shanghai Artimen Technology Co.",
    "7C2BE1": "Shenzhen Ferex Electrical Co.",
    "5031AD": "ABB Global Industries and Services Private Limited",
    "A4C138": "Telink Semiconductor (Taipei) Co. Ltd.",
    "20F510": "Codex Digital Limited",
    "444CA8": "Arista Networks",
    "A48D3B": "Vizio",
    "1C56FE": "Motorola Mobility LLC",
    "046169": "MEDIA GLOBAL LINKS CO.",
    "BCEB5F": "Fujian Beifeng Telecom Technology Co.",
    "F09A51": "Shanghai Viroyal Electronic Technology Company Limited",
    "7CA23E": "HUAWEI TECHNOLOGIES CO.",
    "E00370": "ShenZhen Continental Wireless Technology Co.",
    "B869C2": "Sunitec Enterprise Co.",
    "88CBA5": "Suzhou Torchstar Intelligent Technology Co.",
    "B899B0": "Cohere Technologies",
    "D85DEF": "Busch-Jaeger Elektro GmbH",
    "88A2D7": "HUAWEI TECHNOLOGIES CO.",
    "00323A": "so-logic",
    "F4672D": "ShenZhen Topstar Technology Company",
    "A8D828": "Ascensia Diabetes Care",
    "3C3178": "Qolsys Inc.",
    "809FAB": "Fiberhome Telecommunication Technologies Co.",
    "501AA5": "GN Netcom A/S",
    "E04B45": "Hi-P Electronics Pte Ltd",
    "F46A92": "SHENZHEN FAST TECHNOLOGIES CO.",
    "F0D657": "ECHOSENS",
    "F0AB54": "MITSUMI ELECTRIC CO.",
    "14157C": "TOKYO COSMOS ELECTRIC CO.",
    "20E407": "Spark srl",
    "887384": "Toshiba",
    "AC562C": "LAVA INTERNATIONAL(H.K) LIMITED",
    "9C37F4": "HUAWEI TECHNOLOGIES CO.",
    "3C4711": "HUAWEI TECHNOLOGIES CO.",
    "5CEB68": "Cheerstar Technology Co.",
    "D09DAB": "TCT mobile ltd",
    "FC9AFA": "Motus Global Inc.",
    "08ECA9": "Samsung Electronics Co.",
    "AC5A14": "Samsung Electronics Co.",
    "1CF03E": "Wearhaus Inc.",
    "C8E130": "Milkyway Group Ltd",
    "1CC586": "Absolute Acoustics",
    "24693E": "innodisk Corporation",
    "C0DC6A": "Qingdao Eastsoft Communication Technology Co.",
    "24B0A9": "Shanghai Mobiletek Communication Ltd.",
    "407FE0": "Glory Star Technics (ShenZhen) Limited",
    "805067": "W & D TECHNOLOGY CORPORATION",
    "78F944": "Private",
    "486EFB": "Davit System Technology Co.",
    "B0966C": "Lanbowan Technology Ltd.",
    "5C5B35": "Mist Systems",
    "F8CFC5": "Motorola Mobility LLC",
    "146B72": "Shenzhen Fortune Ship Technology Co.",
    "C43ABE": "Sony Corporation",
    "883B8B": "Cheering Connection Co. Ltd.",
    "E4F939": "Minxon Hotel Technology INC.",
    "70DA9C": "TECSEN",
    "7840E4": "Samsung Electronics Co.",
    "E09971": "Samsung Electronics Co.",
    "2CA2B4": "Fortify Technologies",
    "10D38A": "Samsung Electronics Co.",
    "247656": "Shanghai Net Miles Fiber Optics Technology Co.",
    "B8F080": "SPS",
    "A47B85": "ULTIMEDIA Co Ltd",
    "847303": "Letv Mobile and Intelligent Information Technology (Beijing) Corporation Ltd.",
    "3CC2E1": "XINHUA CONTROL ENGINEERING CO.",
    "E48501": "Geberit International AG",
    "206274": "Microsoft Corporation",
    "E8162B": "IDEO Security Co.",
    "241B44": "Hangzhou Tuners Electronics Co.",
    "80A85D": "Osterhout Design Group",
    "ACCAAB": "Virtual Electric Inc",
    "485415": "NET RULES TECNOLOGIA EIRELI",
    "8C873B": "Leica Camera AG",
    "E0FFF7": "Softiron Inc.",
    "D89341": "General Electric Global Research",
    "700FC7": "SHENZHEN IKINLOOP TECHNOLOGY CO.",
    "349E34": "Evervictory Electronic Co.Ltd",
    "BC74D7": "HangZhou JuRu Technology CO.",
    "28D98A": "Hangzhou Konke Technology Co.",
    "78EB14": "SHENZHEN FAST TECHNOLOGIES CO.",
    "3C4937": "ASSMANN Electronic GmbH",
    "844464": "ServerU Inc",
    "78E980": "RainUs Co.",
    "142971": "NEMOA ELECTRONICS (HK) CO. LTD",
    "B47356": "Hangzhou Treebear Networking Co.",
    "346895": "Hon Hai Precision Ind. Co.",
    "003560": "Rosen Aviation",
    "F8BC41": "Rosslare Enterprises Limited",
    "3CB792": "Hitachi Maxell",
    "3C6A9D": "Dexatek Technology LTD.",
    "D88039": "Microchip Technology Inc.",
    "1C9ECB": "Beijing Nari Smartchip Microelectronics Company Limited",
    "DCC622": "BUHEUNG SYSTEM",
    "902CC7": "C-MAX Asia Limited",
    "94C038": "Tallac Networks",
    "6836B5": "DriveScale",
    "70FF5C": "Cheerzing Communication(Xiamen)Technology Co.",
    "582136": "KMB systems",
    "800902": "Keysight Technologies",
    "0499E6": "Shenzhen Yoostar Technology Co.",
    "C40880": "Shenzhen UTEPO Tech Co.",
    "F8B2F3": "GUANGZHOU BOSMA TECHNOLOGY CO.",
    "5C966A": "RTNET",
    "8870EF": "SC Professional Trading Co.",
    "BCBC46": "SKS Welding Systems GmbH",
    "38B1DB": "Hon Hai Precision Ind. Co.",
    "34F6D2": "Panasonic Taiwan Co.",
    "307512": "Sony Corporation",
    "D48F33": "Microsoft Corporation",
    "34B7FD": "Guangzhou Younghead Electronic Technology Co.",
    "B47C29": "Shenzhen Guzidi Technology Co.",
    "54F876": "ABB AG",
    "84930C": "InCoax Networks Europe AB",
    "1CA2B1": "ruwido austria gmbh",
    "384B76": "AIRTAME ApS",
    "205CFA": "Yangzhou ChangLian Network Technology Co",
    "64002D": "Powerlinq Co.",
    "9816EC": "IC Intracom",
    "D062A0": "China Essence Technology (Zhumadian) Co.",
    "90179B": "Nanomegas",
    "14F893": "Wuhan FiberHome Digital Technology Co.",
    "489D18": "Flashbay Limited",
    "4C48DA": "Beijing Autelan Technology Co.",
    "4CBB58": "Chicony Electronics Co.",
    "A41242": "NEC Platforms",
    "C40006": "Lipi Data Systems Ltd.",
    "D80CCF": "C.G.V. S.A.S.",
    "604826": "Newbridge Technologies Int. Ltd.",
    "38F33F": "TATSUNO CORPORATION",
    "B41780": "DTI Group Ltd",
    "90203A": "BYD Precision Manufacture Co.",
    "D00AAB": "Yokogawa Digital Computer Corporation",
    "20A99B": "Microsoft Corporation",
    "38262B": "UTran Technology",
    "480C49": "NAKAYO Inc",
    "3CD9CE": "Eclipse WiFi",
    "6077E2": "Samsung Electronics Co.",
    "FC1910": "Samsung Electronics Co.",
    "3CA10D": "Samsung Electronics Co.",
    "646CB2": "Samsung Electronics Co.",
    "680571": "Samsung Electronics Co.",
    "FC790B": "Hitachi High Technologies America",
    "6081F9": "Helium Systems",
    "F4C447": "Coagent International Enterprise Limited",
    "A43D78": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "A0FC6E": "Telegrafia a.s.",
    "2053CA": "Risk Technology Ltd",
    "98F170": "Murata Manufacturing Co.",
    "04C991": "Phistek INC.",
    "686E48": "Prophet Electronic Technology Corp.",
    "14B484": "Samsung Electronics Co.",
    "C4C9EC": "Gugaoo   HK Limited",
    "8401A7": "Greyware Automation Products",
    "C4626B": "ZPT Vigantice",
    "EC1766": "Research Centre Module",
    "A0D12A": "AXPRO Technology Inc.",
    "50C7BF": "TP-LINK TECHNOLOGIES CO.",
    "209AE9": "Volacomm Co.",
    "345D10": "Wytek",
    "6C14F7": "Erhardt+Leimer GmbH",
    "ACA9A0": "Audioengine",
    "A481EE": "Nokia Corporation",
    "78D66F": "Aristocrat Technologies Australia Pty. Ltd.",
    "441E91": "ARVIDA Intelligent Electronics Technology  Co.",
    "B0D59D": "Shenzhen Zowee Technology Co.",
    "6828BA": "Dejai",
    "34E42A": "Automatic Bar Controls Inc.",
    "20A787": "Bointec Taiwan Corporation Limited",
    "A49F85": "Lyve Minds",
    "04572F": "Sertel Electronics UK Ltd",
    "D8977C": "Grey Innovation",
    "205A00": "Coval",
    "A8A668": "zte corporation",
    "BC8D0E": "Nokia",
    "78923E": "Nokia Corporation",
    "00EEBD": "HTC Corporation",
    "A824EB": "ZAO NPO Introtest",
    "48EE07": "Silver Palm Technologies LLC",
    "38F708": "National Resource Management",
    "E0DB88": "Open Standard Digital-IF Interface for SATCOM Systems",
    "C40E45": "ACK Networks",
    "3C89A6": "KAPELSE",
    "A46CC1": "LTi REEnergy GmbH",
    "A8B9B3": "ESSYS",
    "6C09D6": "Digiquest Electronics LTD",
    "481842": "Shanghai Winaas Co. Equipment Co. Ltd.",
    "447098": "MING HONG TECHNOLOGY (SHEN ZHEN) LIMITED",
    "B05706": "Vallox Oy",
    "9CBD9D": "SkyDisk",
    "74C621": "Zhejiang Hite Renewable Energy Co.",
    "D4319D": "Sinwatec",
    "B068B6": "Hangzhou OYE Technology Co. Ltd",
    "2C534A": "Shenzhen Winyao Electronic Limited",
    "A4BBAF": "Lime Instruments",
    "F490CA": "Tensorcom",
    "282246": "Beijing Sinoix Communication Co.",
    "9C65F9": "AcSiP Technology Corp.",
    "487604": "Private",
    "E44C6C": "Shenzhen Guo Wei Electronic Co",
    "A8574E": "TP-LINK TECHNOLOGIES CO.",
    "B843E4": "Vlatacom",
    "C4824E": "Changzhou Uchip Electronics Co.",
    "48B977": "PulseOn Oy",
    "64E625": "Woxu Wireless Co.",
    "10B713": "Private",
    "208986": "zte corporation",
    "B8266C": "ANOV France",
    "182012": "Aztech Associates Inc.",
    "3C300C": "Dewar Electronics Pty Ltd",
    "98FFD0": "Lenovo Mobile Communication Technology Ltd.",
    "44C56F": "NGN Easy Satfinder (Tianjin) Electronic Co.",
    "B898F7": "Gionee Communication Equipment Co",
    "848336": "Newrun",
    "5C2AEF": "r2p Asia-Pacific Pty Ltd",
    "B87AC9": "Siemens Ltd.",
    "F06130": "Advantage Pharmacy Services",
    "88FED6": "ShangHai WangYong Software Co.",
    "7C72E4": "Unikey Technologies",
    "7C2048": "KoamTac",
    "8CB7F7": "Shenzhen UniStrong Science & Technology Co.",
    "084027": "Gridstore Inc.",
    "A47760": "Nokia Corporation",
    "C85663": "Sunflex Europe GmbH",
    "38BF2F": "Espec Corp.",
    "A875E2": "Aventura Technologies",
    "44C4A9": "Opticom Communication",
    "6C3C53": "SoundHawk Corp",
    "1C63B7": "OpenProducts 237 AB",
    "B4527E": "Sony Corporation",
    "18AA45": "Fon Technology",
    "94B9B4": "Aptos Technology",
    "902083": "General Engine Management Systems Ltd.",
    "14B126": "Industrial Software Co",
    "D850E6": "ASUSTek COMPUTER INC.",
    "DC3EF8": "Nokia Corporation",
    "A49F89": "Shanghai Rui Rui Communication Technology Co.Ltd.",
    "E47723": "zte corporation",
    "9CA9E4": "zte corporation",
    "90F3B7": "Kirisun Communications Co.",
    "180C14": "iSonea Limited",
    "C4E92F": "AB Sciex",
    "A88D7B": "SunDroid Global limited.",
    "7060DE": "LaVision GmbH",
    "502E5C": "HTC Corporation",
    "3CF748": "Shenzhen Linsn Technology Development Co.",
    "6C15F9": "Nautronix Limited",
    "643F5F": "Exablaze",
    "FCFE77": "Hitachi Reftechno",
    "70533F": "Alfa Instrumentos Eletronicos Ltda.",
    "38B74D": "Fijowave Limited",
    "50C271": "SECURETECH INC",
    "407A80": "Nokia Corporation",
    "B07908": "Cummings Engineering",
    "044F8B": "Adapteva",
    "9CE7BD": "Winduskorea co.",
    "3842A6": "Ingenieurbuero Stahlkopf",
    "644214": "Swisscom Energy Solutions AG",
    "0CA694": "Sunitec Enterprise Co.",
    "184462": "Riava Networks",
    "146080": "zte corporation",
    "9CBB98": "Shen Zhen RND Electronic Co.",
    "54FB58": "WISEWARE",
    "2CCD69": "Aqavi.com",
    "8C2F39": "IBA Dosimetry GmbH",
    "C0A0BB": "D-Link International",
    "344F3F": "IO-Power Technology Co.",
    "1446E4": "AVISTEL",
    "D095C7": "Pantech Co.",
    "D02C45": "littleBits Electronics",
    "248000": "Westcontrol AS",
    "1C4BB9": "SMG ENTERPRISE",
    "346178": "The Boeing Company",
    "C03580": "A&R TECH",
    "D08A55": "Skullcandy",
    "CC720F": "Viscount Systems Inc.",
    "742B62": "FUJITSU LIMITED",
    "B4A82B": "Histar Digital Electronics Co.",
    "940BD5": "Himax Technologies",
    "F45F69": "Matsufu Electronics distribution Company",
    "28A1EB": "ETEK TECHNOLOGY (SHENZHEN) CO.",
    "B8F828": "Changshu Gaoshida Optoelectronic Technology Co. Ltd.",
    "3C1A57": "Cardiopulmonary Corp",
    "541B5D": "Techno-Innov",
    "083571": "CASwell INC.",
    "9876B6": "Adafruit",
    "503CC4": "Lenovo Mobile Communication Technology Ltd.",
    "E0D1E6": "Aliph dba Jawbone",
    "041B94": "Host Mobility AB",
    "A0CEC8": "CE LINK LIMITED",
    "907A28": "Beijing Morncloud Information And Technology Co. Ltd.",
    "78FE41": "Socus networks",
    "205721": "Salix Technology CO.",
    "883612": "SRC Computers",
    "D82D9B": "Shenzhen G.Credit Communication Technology Co.",
    "709BFC": "Bryton Inc.",
    "ACE42E": "SK hynix",
    "2C7B84": "OOO Petr Telegin",
    "A4C0C7": "ShenZhen Hitom Communication Technology Co..LTD",
    "18104E": "CEDINT-UPM",
    "306112": "PAV GmbH",
    "789F4C": "HOERBIGER Elektronik GmbH",
    "FC4BBC": "Sunplus Technology Co.",
    "9C1465": "Edata Elektronik San. ve Tic. A.Ş.",
    "4C55CC": "Zentri Pty Ltd",
    "00C5DB": "Datatech Sistemas Digitales Avanzados SL",
    "8CF945": "Power Automation pte Ltd",
    "F842FB": "Yasuda Joho Co.",
    "887398": "K2E Tekpoint",
    "58F387": "Airios",
    "3C977E": "IPS Technology Limited",
    "A4FB8D": "Hangzhou Dunchong Technology Co.Ltd",
    "107A86": "U&U ENGINEERING INC.",
    "40BD9E": "Physio-Control",
    "6C5779": "Aclima",
    "C0DA74": "Hangzhou Sunyard Technology Co.",
    "882364": "Watchnet DVR Inc",
    "2C922C": "Kishu Giken Kogyou Company Ltd",
    "D8FEE3": "D-Link International",
    "50A0BF": "Alba Fiber Systems Inc.",
    "B836D8": "Videoswitch",
    "043D98": "ChongQing QingJia Electronics CO.",
    "E03E4A": "Cavanagh Group International",
    "F4CD90": "Vispiron Rotec GmbH",
    "542160": "Alula",
    "806C8B": "KAESER KOMPRESSOREN AG",
    "581CBD": "Affinegy",
    "284FCE": "Liaoning Wontel Science and Technology Development Co.",
    "DC6F00": "Livescribe",
    "54E3B0": "JVL Industri Elektronik",
    "1001CA": "Ashley Butterworth",
    "246AAB": "IT-IS International",
    "18D6CF": "Kurth Electronic GmbH",
    "F48139": "CANON INC.",
    "1836FC": "Elecsys International Corporation",
    "A4D094": "VIVAVIS AG",
    "2C9464": "Cincoze Co.",
    "804B20": "Ventilation Control",
    "287994": "Realplay Digital Technology(Shenzhen) Co.",
    "94B8C5": "RuggedCom Inc.",
    "604A1C": "SUYIN Corporation",
    "082719": "APS systems/electronic AG",
    "505AC6": "GUANGDONG SUPER TELECOM CO.",
    "3065EC": "Wistron (ChongQing)",
    "B863BC": "ROBOTIS",
    "980D2E": "HTC Corporation",
    "9C79AC": "Suntec Software(Shanghai) Co.",
    "C419EC": "Qualisys AB",
    "542CEA": "PROTECTRON",
    "D464F7": "CHENGDU USEE DIGITAL TECHNOLOGY CO.",
    "60E00E": "SHINSEI ELECTRONICS CO LTD",
    "545414": "Digital RF Corea",
    "24EB65": "SAET I.S. S.r.l.",
    "E894F6": "TP-LINK TECHNOLOGIES CO.",
    "DC825B": "JANUS",
    "9CA577": "Osorno Enterprises Inc.",
    "C04301": "Epec Oy",
    "E07C62": "Whistle Labs",
    "9498A2": "Shanghai LISTEN TECH.LTD",
    "DC2BCA": "Zera GmbH",
    "5C8486": "Brightsource Industries Israel LTD",
    "BCBAE1": "AREC Inc.",
    "18FA6F": "ISC applied systems corp",
    "601E02": "EltexAlatau",
    "F07F0C": "Leopold Kostal GmbH &Co. KG",
    "4C6255": "SANMINA-SCI SYSTEM DE MEXICO S.A. DE C.V.",
    "50CD32": "NanJing Chaoran Science & Technology Co.",
    "E0EDC7": "Shenzhen Friendcom Technology Development Co.",
    "D4A499": "InView Technology Corporation",
    "B4DD15": "ControlThings Oy Ab",
    "E0C6B3": "MilDef AB",
    "188410": "CoreTrust Inc.",
    "FC229C": "Han Kyung I Net Co.",
    "1832A2": "LAON TECHNOLOGY CO.",
    "74D02B": "ASUSTek COMPUTER INC.",
    "A01C05": "NIMAX TELECOM CO.",
    "08482C": "Raycore Taiwan Co.",
    "6472D8": "GooWi Technology Co.",
    "846223": "Shenzhen Coship Electronics Co.",
    "1CFA68": "TP-LINK TECHNOLOGIES CO.",
    "DC1DD4": "Microstep-MIS spol. s r.o.",
    "FCDD55": "Shenzhen WeWins wireless Co.",
    "B01743": "EDISON GLOBAL CIRCUITS LLC",
    "F82EDB": "RTW GmbH & Co. KG",
    "C04A00": "TP-LINK TECHNOLOGIES CO.",
    "045FA7": "Shenzhen Yichen Technology Development Co.",
    "087999": "AIM GmbH",
    "C011A6": "Fort-Telecom ltd.",
    "C0B8B1": "BitBox Ltd",
    "105F06": "Actiontec Electronics",
    "1853E0": "Hanyang Digitech Co.Ltd",
    "C0885B": "SnD Tech Co.",
    "3CFB96": "Emcraft Systems LLC",
    "081F3F": "WondaLink Inc.",
    "40516C": "Grandex International Corporation",
    "D0BE2C": "CNSLink Co.",
    "00C14F": "DDL Co",
    "2C26C5": "zte corporation",
    "807B1E": "Corsair Memory",
    "B4AB2C": "MtM Technology Corporation",
    "74372F": "Tongfang Shenzhen Cloudcomputing Technology Co.",
    "E8A364": "Signal Path International / Peachtree Audio",
    "BC51FE": "Swann communications Pty Ltd",
    "E0CEC3": "ASKEY COMPUTER CORP",
    "F0219D": "Cal-Comp Electronics & Communications Company Ltd.",
    "181725": "Cameo Communications",
    "8462A6": "EuroCB (Phils)",
    "E4F365": "Time-O-Matic",
    "DCC0DB": "Shenzhen Kaiboer Technology Co.",
    "AC5D10": "Pace Americas",
    "88F490": "Jetmobile Pte Ltd",
    "FC626E": "Beijing MDC Telecom",
    "94C962": "Teseq AG",
    "DC2A14": "Shanghai Longjing Technology Co.",
    "808B5C": "Shenzhen Runhuicheng Technology Co.",
    "C05E6F": "V. Stonkaus firma Kodinis Raktas",
    "6886E7": "Orbotix",
    "D819CE": "Telesquare",
    "1C9179": "Integrated System Technologies Ltd",
    "38F597": "home2net GmbH",
    "6CB311": "Shenzhen Lianrui Electronics Co.",
    "D8D5B9": "Rainforest Automation",
    "2411D0": "Chongqing Ehs Science and Technology Development Co.",
    "B461FF": "Lumigon A/S",
    "A0A130": "DLI Taiwan Branch office",
    "BC39A6": "CSUN System Technology Co.",
    "ECB541": "SHINANO E and E Co.Ltd.",
    "E4C146": "Objetivos y Servicios de Valor A",
    "D40057": "MC Technologies GmbH",
    "A875D6": "FreeTek International Co.",
    "10A743": "SK Mtek Limited",
    "547FA8": "TELCO systems",
    "5474E6": "Webtech Wireless",
    "C46DF1": "DataGravity",
    "30215B": "Shenzhen Ostar Display Electronic Co.",
    "CC593E": "Sensium Healthcare Limited",
    "34FA40": "Guangzhou Robustel Technologies Co.",
    "1C5A6B": "Philips Electronics Nederland BV",
    "84C8B1": "Incognito Software Systems Inc.",
    "30D357": "Logosol",
    "94FD2E": "Shanghai Uniscope Technologies Co.",
    "A0BAB8": "Pixon Imaging",
    "74E424": "APISTE CORPORATION",
    "D410CF": "Huanshun Network Science and Technology Co.",
    "5CE0F6": "NIC.br- Nucleo de Informacao e Coordenacao do Ponto BR",
    "C83D97": "Nokia Corporation",
    "0CF361": "Java Information",
    "B0358D": "Nokia Corporation",
    "F8E4FB": "Actiontec Electronics",
    "8C4AEE": "GIGA TMS INC",
    "34C99D": "EIDOLON COMMUNICATIONS TECHNOLOGY CO. LTD.",
    "802FDE": "Zurich Instruments AG",
    "5C38E0": "Shanghai Super Electronics Technology Co.",
    "600F77": "SilverPlus",
    "E44F5F": "EDS Elektronik Destek San.Tic.Ltd.Sti",
    "E86D54": "Digit Mobile Inc",
    "E8718D": "Elsys Equipamentos Eletronicos Ltda",
    "ECE915": "STI Ltd",
    "80D733": "QSR Automations",
    "303D08": "GLINTT TES S.A.",
    "ACE64B": "Shenzhen Baojia Battery Technology Co.",
    "044BFF": "GuangZhou Hedy Digital Technology Co.",
    "A81FAF": "KRYPTON POLSKA",
    "08E5DA": "NANJING FUJITSU COMPUTER PRODUCTS CO.",
    "5884E4": "IP500 Alliance e.V.",
    "08AF78": "Totus Solutions",
    "0C93FB": "BNS Solutions",
    "789F87": "Siemens AG I IA PP PRM",
    "6032F0": "Mplus technology",
    "D8AF3B": "Hangzhou Bigbright Integrated communications system Co.",
    "2829D9": "GlobalBeiMing technology (Beijing)Co. Ltd",
    "88615A": "Siano Mobile Silicon Ltd.",
    "70E24C": "SAE IT-systems GmbH & Co. KG",
    "00FD4C": "NEVATEC",
    "D0738E": "DONG OH PRECISION CO.",
    "64C944": "LARK Technologies",
    "1C9492": "RUAG Schweiz AG",
    "B889CA": "ILJIN ELECTRIC Co.",
    "64F50E": "Kinion Technology Company Limited",
    "601929": "VOLTRONIC POWER TECHNOLOGY(SHENZHEN) CORP.",
    "48B253": "Marketaxess Corporation",
    "305D38": "Beissbarth",
    "60D2B9": "REALAND BIO CO.",
    "30FD11": "MACROTECH (USA) INC.",
    "144319": "Creative&Link Technology Limited",
    "1848D8": "Fastback Networks",
    "C8C791": "Zero1.tv GmbH",
    "ECD925": "RAMI",
    "005D03": "Xilinx",
    "D04CC1": "SINTRONES Technology Corp.",
    "503F56": "Syncmold Enterprise Corp",
    "C4DA26": "NOBLEX SA",
    "7CC8AB": "Acro Associates",
    "10F3DB": "Gridco Systems",
    "8CEEC6": "Precepscion Pty. Ltd.",
    "101248": "ITG",
    "74943D": "AgJunction",
    "049C62": "BMT Medical Technology s.r.o.",
    "0C2A69": "electric imp",
    "C455C2": "Bach-Simpson",
    "00E8AB": "Meggitt Training Systems",
    "B4218A": "Dog Hunter LLC",
    "F0D3E7": "Sensometrix SA",
    "B01266": "Futaba-Kikaku",
    "7CC8D0": "TIANJIN YAAN TECHNOLOGY CO.",
    "88E917": "Tamaggo",
    "909DE0": "Newland Design + Assoc. Inc.",
    "985E1B": "ConversDigital Co.",
    "60D1AA": "Vishal Telecommunications Pvt Ltd",
    "709BA5": "Shenzhen Y&D Electronics Co.",
    "B48910": "Coster T.E. S.P.A.",
    "B0C83F": "Jiangsu Cynray IOT Co.",
    "3CF392": "Virtualtek. Co. Ltd",
    "149FE8": "Lenovo Mobile Communication Technology Ltd.",
    "BCD940": "ASR Co",
    "68B43A": "WaterFurnace International",
    "4C7897": "Arrowhead Alarm Products Ltd",
    "44E8A5": "Myreka Technologies Sdn. Bhd.",
    "B482C5": "Relay2",
    "D8AFF1": "Panasonic Appliances Company",
    "2C6289": "Regenersis (Glenrothes) Ltd",
    "58ECE1": "Newport Corporation",
    "4C09B4": "zte corporation",
    "58CF4B": "Lufkin Industries",
    "388AB7": "ITC Networks",
    "D48CB5": "Cisco Systems",
    "A865B2": "DONGGUAN YISHANG ELECTRONIC TECHNOLOGY CO.",
    "E8D0FA": "MKS Instruments Deutschland GmbH",
    "98262A": "Applied Research Associates",
    "3C9174": "ALONG COMMUNICATION TECHNOLOGY",
    "DC37D2": "Hunan HKT Electronic Technology Co.",
    "549D85": "EnerAccess inc",
    "B0750C": "QA Cafe",
    "B4E1EB": "Private",
    "ECD19A": "Zhuhai Liming Industries Co.",
    "348137": "UNICARD SA",
    "38B12D": "Sonotronic Nagel GmbH",
    "ACEE3B": "6harmonics Inc",
    "A06D09": "Intelcan Technosystems Inc.",
    "60F3DA": "Logic Way GmbH",
    "3C363D": "Nokia Corporation",
    "808698": "Netronics Technologies Inc.",
    "1C6BCA": "Mitsunami Co.",
    "E83EFB": "GEODESIC LTD.",
    "642400": "Xorcom Ltd.",
    "9CE10E": "NCTech Ltd",
    "407074": "Life Technology (China) Co.",
    "20F002": "MTData Developments Pty. Ltd.",
    "FC5090": "SIMEX Sp. z o.o.",
    "60B982": "RO.VE.R. Laboratories S.p.A.",
    "B46238": "Exablox",
    "C8BBD3": "Embrane",
    "1CF4CA": "Private",
    "B4A4B5": "Zen Eye Co.",
    "BCC23A": "Thomson Video Networks",
    "ACC2EC": "CLT INT'L IND. CORP.",
    "3C9F81": "Shenzhen CATIC Bit Communications Technology Co.",
    "445F7A": "Shihlin Electric & Engineering Corp.",
    "141A51": "Treetech Sistemas Digitais",
    "A47C14": "ChargeStorm AB",
    "8020AF": "Trade FIDES",
    "3CB87A": "Private",
    "002D76": "TITECH GmbH",
    "8C604F": "Cisco Systems",
    "A4B980": "Parking BOXX Inc.",
    "2C750F": "Shanghai Dongzhou-Lawton Communication Technology Co. Ltd.",
    "5C5015": "Cisco Systems",
    "088F2C": "Amber Technology Ltd.",
    "441319": "WKK TECHNOLOGY LTD.",
    "980284": "Theobroma Systems GmbH",
    "1CD40C": "Kriwan Industrie-Elektronik GmbH",
    "F8DB4C": "PNY Technologies",
    "0C9D56": "Consort Controls Ltd",
    "587FC8": "S2M",
    "200505": "RADMAX COMMUNICATION PRIVATE LIMITED",
    "AC1461": "ATAW  Co.",
    "E4C6E6": "Mophie",
    "502D1D": "Nokia Corporation",
    "F48E09": "Nokia Corporation",
    "5848C0": "COFLEC",
    "844915": "vArmour Networks",
    "C84544": "Asia Pacific CIS (Wuxi) Co",
    "8C57FD": "LVX Western",
    "54E63F": "ShenZhen LingKeWeiEr Technology Co.",
    "20FABB": "Cambridge Executive Limited",
    "C035BD": "Velocytech Aps",
    "287184": "Spire Payments",
    "7CB03E": "OSRAM GmbH",
    "E0EF25": "Lintes Technology Co.",
    "B01C91": "Elim Co",
    "2CBE97": "Ingenieurbuero Bickele und Buehler GmbH",
    "50ED94": "EGATEL SL",
    "18B591": "I-Storm",
    "04F17D": "Tarana Wireless",
    "BC8B55": "NPP ELIKS America Inc. DBA T&M Atlantic",
    "C0493D": "MAITRISE TECHNOLOGIQUE",
    "A849A5": "Lisantech Co.",
    "A05E6B": "MELPER Co.",
    "D878E5": "KUHN SA",
    "D824BD": "Cisco Systems",
    "28CD1C": "Espotel Oy",
    "D443A8": "Changzhou Haojie Electric Co.",
    "BCE59F": "WATERWORLD Technology Co.",
    "C467B5": "Libratone A/S",
    "4C3910": "Newtek Electronics co.",
    "AC0DFE": "Ekon GmbH - myGEKKO",
    "FC5B26": "MikroBits",
    "40F407": "Nintendo Co.",
    "900A3A": "PSG Plastic Service GmbH",
    "DC3C2E": "Manufacturing System Insights",
    "903AA0": "Nokia",
    "B06CBF": "3ality Digital Systems GmbH",
    "F83553": "Magenta Research Ltd.",
    "F4044C": "ValenceTech Limited",
    "3497FB": "ADVANCED RF TECHNOLOGIES INC",
    "7041B7": "Edwards Lifesciences LLC",
    "DCA8CF": "New Spin Golf",
    "F03A55": "Omega Elektronik AS",
    "98BC57": "SVA TECHNOLOGIES CO.LTD",
    "48A22D": "Shenzhen Huaxuchang Telecom Technology Co.",
    "C86000": "ASUSTek COMPUTER INC.",
    "70A66A": "Prox Dynamics AS",
    "DC3E51": "Solberg & Andersen AS",
    "843611": "hyungseul publishing networks",
    "3440B5": "IBM",
    "644BF0": "CalDigit",
    "F0620D": "Shenzhen Egreat Tech Corp.",
    "2C67FB": "ShenZhen Zhengjili Electronics Co.",
    "EC63E5": "ePBoard Design LLC",
    "94DB49": "SITCORP",
    "3CE5B4": "KIDASEN INDUSTRIA E COMERCIO DE ANTENAS LTDA",
    "08D09F": "Cisco Systems",
    "D4D748": "Cisco Systems",
    "344F69": "EKINOPS SAS",
    "F8313E": "endeavour GmbH",
    "143605": "Nokia Corporation",
    "C81AFE": "DLOGIC GmbH",
    "54D0ED": "AXIM Communications",
    "2C002C": "UNOWHY",
    "64ED62": "WOORI SYSTEMS Co.",
    "5CC9D3": "PALLADIUM ENERGY ELETRONICA DA AMAZONIA LTDA",
    "B4944E": "WeTelecom Co.",
    "E00B28": "Inovonics",
    "000830": "Cisco Systems",
    "C4EEAE": "VSS Monitoring",
    "F8D3A9": "AXAN Networks",
    "CC6BF1": "Sound Masking Inc.",
    "18E80F": "Viking Electronics Inc.",
    "2C9717": "I.C.Y. B.V.",
    "988217": "Disruptive Ltd",
    "C87CBC": "Valink Co.",
    "B81413": "Keen High Holding(HK) Ltd.",
    "48022A": "B-Link Electronic Limited",
    "345B11": "EVI HEAT AB",
    "78BAD0": "Shinybow Technology Co. Ltd.",
    "0C5A19": "Axtion Sdn Bhd",
    "A8BD1A": "Honey Bee (Hong Kong) Limited",
    "2C3F38": "Cisco Systems",
    "4050E0": "Milton Security Group LLC",
    "70CA9B": "Cisco Systems",
    "9CA3BA": "SAKURA Internet Inc.",
    "A078BA": "Pantech Co.",
    "68BC0C": "Cisco Systems",
    "DCB4C4": "Microsoft XCG",
    "ACCB09": "Hefcom Metering (Pty) Ltd",
    "1866E3": "Veros Systems",
    "74FDA0": "Compupal (Group) Corporation",
    "CCB8F1": "EAGLE KINGDOM TECHNOLOGIES LIMITED",
    "A429B7": "bluesky",
    "48F317": "Private",
    "704642": "CHYNG HONG ELECTRONIC CO.",
    "9C5C8D": "FIREMAX INDÚSTRIA E COMÉRCIO DE PRODUTOS ELETRÔNICOS  LTDA",
    "D4206D": "HTC Corporation",
    "7C1E52": "Microsoft",
    "24E6BA": "JSC Zavod im. Kozitsky",
    "CCA374": "Guangdong Guanglian Electronic Technology Co.Ltd",
    "58677F": "Clare Controls Inc.",
    "406AAB": "RIM",
    "248707": "SEnergy Corporation",
    "C4C19F": "National Oilwell Varco Instrumentation",
    "04888C": "Eifelwerk Butler Systeme GmbH",
    "CCF8F0": "Xi'an HISU Multimedia Technology Co.",
    "30DE86": "Cedac Software S.r.l.",
    "18C451": "Tucson Embedded Systems",
    "D41C1C": "RCF S.P.A.",
    "8C8A6E": "ESTUN AUTOMATION TECHNOLOY CO.",
    "BC779F": "SBM Co.",
    "58920D": "Kinetic Avionics Limited",
    "B8B42E": "Gionee Communication Equipment Co",
    "443EB2": "DEOTRON Co.",
    "D059C3": "CeraMicro Technology Corporation",
    "1C8E8E": "DB Communication & Systems Co.",
    "AC02EF": "Comsis",
    "B0BF99": "WIZITDONGDO",
    "24EC99": "ASKEY COMPUTER CORP",
    "280CB8": "Mikrosay Yazilim ve Elektronik A.S.",
    "3CC99E": "Huiyang Technology Co.",
    "78BEB6": "Enhanced Vision",
    "2C1EEA": "AERODEV",
    "B4FC75": "SEMA Electronics(HK) CO.",
    "FC1794": "InterCreative Co.",
    "B40B7A": "Brusa Elektronik AG",
    "D45AB2": "Galleon Systems",
    "182C91": "Concept Development",
    "A44B15": "Sun Cupid Technology (HK) LTD",
    "48C862": "Simo Wireless",
    "A0165C": "Triteka LTD",
    "449CB5": "Alcomp",
    "70B921": "Fiberhome Telecommunication Technologies Co.",
    "9C417C": "Hame  Technology Co.",
    "9C6ABE": "QEES ApS.",
    "E8944C": "Cogent Healthcare Systems Ltd",
    "9067F3": "Alcatel Lucent",
    "A0E295": "DAT System Co.",
    "40F14C": "ISE Europe SPRL",
    "3826CD": "ANDTEK",
    "D8973B": "Artesyn Embedded Technologies",
    "D4F0B4": "Napco Security Technologies",
    "9C934E": "Xerox Corporation",
    "68F895": "Redflow Limited",
    "2C8BF2": "Hitachi Metals America Ltd",
    "900917": "Far-sighted mobile",
    "044665": "Murata Manufacturing Co.",
    "58E476": "CENTRON COMMUNICATIONS TECHNOLOGIES FUJIAN CO.",
    "447E95": "Alpha and Omega",
    "F4A52A": "Hawa Technologies Inc",
    "E8B748": "Cisco Systems",
    "0C6E4F": "PrimeVOLT Co.",
    "986022": "EMW Co.",
    "BC99BC": "FonSee Technology Inc.",
    "783F15": "EasySYNC Ltd.",
    "18D071": "DASAN CO.",
    "24CBE7": "MYK",
    "B0A10A": "Pivotal Systems Corporation",
    "802DE1": "Solarbridge Technologies",
    "B8D49D": "M Seven System Ltd.",
    "88BFD5": "Simple Audio Ltd",
    "3C672C": "Sciovid Inc.",
    "147411": "RIM",
    "F8A9DE": "PUISSANCE PLUS",
    "B8871E": "Good Mind Industries Co.",
    "D4F027": "Trust Power Ltd.",
    "DC9B1E": "Intercom",
    "BC5FF4": "ASRock Incorporation",
    "E8B4AE": "Shenzhen C&D Electronics Co.",
    "CCC62B": "Tri-Systems Corporation",
    "D8C068": "Netgenetech.co.",
    "601199": "Siama Systems Inc",
    "A88CEE": "MicroMade Galka i Drozdz sp.j.",
    "C027B9": "Beijing National Railway Research & Design Institute  of Signal & Communication Co.",
    "B0BDA1": "ZAKLAD ELEKTRONICZNY SIMS",
    "70B265": "Hiltron s.r.l.",
    "781DFD": "Jabil Inc",
    "18AEBB": "Siemens Convergence Creators GmbH&Co.KG",
    "50FAAB": "L-tek d.o.o.",
    "3891FB": "Xenox Holding BV",
    "A8E018": "Nokia Corporation",
    "0455CA": "BriView (Xiamen) Corp.",
    "AC932F": "Nokia Corporation",
    "0054AF": "Continental Automotive Systems Inc.",
    "ACCABA": "Midokura Co.",
    "0C8112": "Private",
    "9C95F8": "SmartDoor Systems",
    "F43E9D": "Benu Networks",
    "64094C": "Beijing Superbee Wireless Technology Co.",
    "64D1A3": "Sitecom Europe BV",
    "DC2B66": "InfoBLOCK S.A. de C.V.",
    "6C81FE": "Mitsuba Corporation",
    "04E2F8": "AEP Ticketing solutions srl",
    "EC9ECD": "Artesyn Embedded Technologies",
    "8C5105": "Shenzhen ireadygo Information Technology CO.",
    "C8208E": "Storagedata",
    "2872F0": "ATHENA",
    "1C19DE": "eyevis GmbH",
    "9C807D": "SYSCABLE Korea Inc.",
    "743889": "ANNAX Anzeigesysteme GmbH",
    "44D2CA": "Anvia TV Oy",
    "386E21": "Wasion Group Ltd.",
    "609E64": "Vivonic GmbH",
    "34B571": "PLDS",
    "3C7437": "RIM",
    "EC9233": "Eddyfi NDT Inc",
    "BC15A6": "Taiwan Jantek Electronics",
    "DCDECA": "Akyllor",
    "A0AAFD": "EraThink Technologies Corp.",
    "7C7D41": "Jinmuyu Electronics Co.",
    "4C1480": "NOREGON SYSTEMS",
    "A4856B": "Q Electronics Ltd",
    "20D5AB": "Korea Infocom Co.",
    "0CF3EE": "EM Microelectronic",
    "B08991": "LGE",
    "30142D": "Piciorgros GmbH",
    "50AF73": "Shenzhen Bitland Information Technology Co.",
    "6CA906": "Telefield Ltd",
    "78223D": "Affirmed Networks",
    "3C02B1": "Creation Technologies LP",
    "E441E6": "Ottec Technology GmbH",
    "48DF1C": "Wuhan NEC Fibre Optic Communications industry Co. Ltd",
    "BC71C1": "XTrillion",
    "E0E8E8": "Olive Telecommunication Pvt. Ltd",
    "D49C8E": "University of FUKUI",
    "60DA23": "Estech Co.",
    "44DCCB": "SEMINDIA SYSTEMS PVT LTD",
    "5C9AD8": "FUJITSU LIMITED",
    "A4C0E1": "Nintendo Co.",
    "4C3B74": "VOGTEC(H.K.) Co.",
    "684352": "Bhuu Limited",
    "F8F014": "RackWare Inc.",
    "2826A6": "PBR electronics GmbH",
    "B428F1": "E-Prime Co.",
    "AC2FA8": "Humannix Co.",
    "A83944": "Actiontec Electronics",
    "74E06E": "Ergophone GmbH",
    "ECE90B": "SISTEMA SOLUCOES ELETRONICAS LTDA - EASYTECH",
    "A08C9B": "Xtreme Technologies Corp",
    "0CF0B4": "Globalsat International Technology Ltd",
    "6052D0": "FACTS Engineering",
    "64E8E6": "global moisture management system",
    "34A183": "AWare",
    "9873C4": "Sage Electronic Engineering LLC",
    "B40142": "GCI Science & Technology Co.",
    "740ABC": "LightwaveRF Technology Ltd",
    "304EC3": "Tianjin Techua Technology Co.",
    "B4CFDB": "Shenzhen Jiuzhou Electric Co.",
    "5C6A7D": "KENTKART EGE ELEKTRONIK SAN. VE TIC. LTD. STI.",
    "FCD4F2": "The Coca Cola Company",
    "1064E2": "ADFweb.com s.r.l.",
    "CC34D7": "GEWISS S.P.A.",
    "F02A61": "Waldo Networks",
    "C8A70A": "Verizon Business",
    "C01242": "Alpha Security Products",
    "BC20BA": "Inspur (Shandong) Electronic Information Co.",
    "1CFEA7": "IDentytech Solutins Ltd.",
    "AC8112": "Gemtek Technology Co.",
    "686359": "Advanced Digital Broadcast SA",
    "CCD811": "Aiconn Technology Corporation",
    "44599F": "Criticare Systems",
    "3C2F3A": "SFORZATO Corp.",
    "18922C": "Virtual Instruments",
    "28061E": "NINGBO GLOBAL USEFUL ELECTRIC CO.",
    "A0DE05": "JSC Irbis-T",
    "0817F4": "IBM Corp",
    "74CE56": "Packet Force Technology Limited Company",
    "ECBBAE": "Digivoice Tecnologia em Eletronica Ltda",
    "C44B44": "Omniprint Inc.",
    "F43814": "Shanghai Howell Electronic Co.",
    "90610C": "Fida International (S) Pte Ltd",
    "3C5F01": "Synerchip Co.",
    "10A13B": "FUJIKURA RUBBER LTD.",
    "F4E142": "Delta Elektronika BV",
    "E0D10A": "Katoudenkikougyousyo co ltd",
    "48C8B6": "SysTec GmbH",
    "3C6278": "SHENZHEN JETNET TECHNOLOGY CO.",
    "D43D67": "Carma Industries Inc.",
    "C8D5FE": "Shenzhen Zowee Technology Co.",
    "2C3068": "Pantech Co.",
    "00BD27": "Exar Corp.",
    "5C4058": "Jefferson Audio Video Systems",
    "58D08F": "IEEE 1904.1 Working Group",
    "CC09C8": "IMAQLIQ LTD",
    "9C4563": "DIMEP Sistemas",
    "E446BD": "C&C TECHNIC TAIWAN CO.",
    "8CDD8D": "Wifly-City System Inc.",
    "20A2E7": "Lee-Dickens Ltd",
    "FCEDB9": "Arrayent",
    "44ED57": "Longicorn",
    "EC98C1": "Beijing Risbo Network Technology Co.",
    "D4A928": "GreenWave Reality Inc",
    "E06290": "Jinan Jovision Science & Technology Co.",
    "100E2B": "NEC CASIO Mobile Communications",
    "C46354": "U-Raku",
    "405FBE": "RIM",
    "58DB8D": "Fast Co.",
    "38A95F": "Actifio Inc",
    "F4DCDA": "Zhuhai Jiahe Communication Technology Co.",
    "E80462": "Cisco Systems",
    "DCD0F7": "Bentek Systems Ltd.",
    "7CB542": "ACES Technology",
    "905446": "TES ELECTRONIC SOLUTIONS",
    "544A05": "wenglor sensoric gmbh",
    "6C9CE9": "Nimble Storage",
    "A49B13": "Digital Check",
    "C8EE08": "TANGTOP TECHNOLOGY CO.",
    "70E139": "3view Ltd",
    "18422F": "Alcatel Lucent",
    "6854F5": "enLighted Inc",
    "7472F2": "Chipsip Technology Co.",
    "E0A670": "Nokia Corporation",
    "0CD696": "Amimon Ltd",
    "F4DC4D": "Beijing CCD Digital Technology Co.",
    "4013D9": "Global ES",
    "AC4FFC": "SVS-VISTEK GmbH",
    "B43741": "Consert",
    "94857A": "Evantage Industries Corp",
    "24AF54": "NEXGEN Mediatech Inc.",
    "98E165": "Accutome",
    "785712": "Mobile Integration Workgroup",
    "380A0A": "Sky-City Communication and Electronics Limited Company",
    "DC4EDE": "SHINYEI TECHNOLOGY CO.",
    "F0F842": "KEEBOX",
    "4083DE": "Zebra Technologies Inc",
    "8897DF": "Entrypass Corporation Sdn. Bhd.",
    "E087B1": "Nata-Info Ltd.",
    "F0AD4E": "Globalscale Technologies",
    "08FAE0": "Fohhn Audio AG",
    "903D5A": "Shenzhen Wision Technology Holding Limited",
    "447C7F": "Innolight Technology Corporation",
    "5C864A": "Secret Labs LLC",
    "D496DF": "SUNGJIN C&T CO.",
    "58B9E1": "Crystalfontz America",
    "20D906": "Iota",
    "F45595": "HENGBAO Corporation LTD.",
    "180C77": "Westinghouse Electric Company",
    "9C4E20": "Cisco Systems",
    "1C3A4F": "AccuSpec Electronics",
    "7CA29B": "D.SignT GmbH & Co. KG",
    "A04041": "SAMWONFA Co.",
    "40406B": "Icomera",
    "6C22AB": "Ainsworth Game Technology",
    "9835B8": "Assembled Products Corporation",
    "288915": "CashGuard Sverige AB",
    "68CA00": "Octopus Systems Limited",
    "E0589E": "Laerdal Medical",
    "3018CF": "DEOS control systems GmbH",
    "D87533": "Nokia Corporation",
    "98DCD9": "UNITEC Co.",
    "C0CFA3": "Creative Electronics & Software",
    "6089B7": "KAEL MÜHENDİSLİK ELEKTRONİK TİCARET SANAYİ LİMİTED ŞİRKETİ",
    "30525A": "NST Co.",
    "2CA780": "True Technologies Inc.",
    "B0E39D": "CAT SYSTEM CO.",
    "7C2E0D": "Blackmagic Design",
    "5CE286": "Nortel Networks",
    "8C640B": "Beyond Devices d.o.o.",
    "FCE192": "Sichuan Jinwangtong Electronic Science&Technology Co",
    "949C55": "Alta Data Technologies",
    "D479C3": "Cameronet GmbH & Co. KG",
    "0C1DC2": "SeAH Networks",
    "4C5DCD": "Oy Finnish Electric Vehicle Technologies Ltd",
    "70D57E": "Scalar Corporation",
    "5475D0": "Cisco Systems",
    "7C6F06": "Caterpillar Trimble Control Technologies",
    "70D5E7": "Wellcore Corporation",
    "3CF72A": "Nokia Corporation",
    "545FA9": "Teracom Limited",
    "408A9A": "TITENG CO.",
    "F445ED": "Portable Innovation Technology Ltd.",
    "6C32DE": "Indieon Technologies Pvt. Ltd.",
    "601283": "TSB REAL TIME LOCATION SYSTEMS S.L.",
    "547FEE": "Cisco Systems",
    "ACEA6A": "GENIX INFOCOMM CO.",
    "A8F470": "Fujian Newland Communication Science Technologies Co.",
    "8C736E": "FUJITSU LIMITED",
    "E0BC43": "C2 Microsystems",
    "94236E": "Shenzhen Junlan Electronic Ltd",
    "10E6AE": "Source Technologies",
    "2CA835": "RIM",
    "C41ECE": "HMI Sources Ltd.",
    "14A62C": "S.M. Dezac S.A.",
    "50F003": "Open Stack",
    "DC49C9": "CASCO SIGNAL LTD",
    "70D880": "Upos System sp. z o.o.",
    "A05DC1": "TMCT Co.",
    "B86491": "CK Telecom Ltd",
    "583CC6": "Omneality Ltd.",
    "B0C8AD": "People Power Company",
    "181714": "DAEWOOIS",
    "F0EC39": "Essec",
    "04FE7F": "Cisco Systems",
    "EC4476": "Cisco Systems",
    "487119": "SGB GROUP LTD.",
    "681FD8": "Siemens Industry",
    "A8995C": "aizo ag",
    "4012E4": "Compass-EOS",
    "446C24": "Reallin Electronic Co.",
    "2046F9": "Advanced Network Devices (dba:AND)",
    "A4B1EE": "H. ZANDER GmbH & Co. KG",
    "842141": "Shenzhen Ginwave Technologies Ltd.",
    "A0231B": "TeleComp R&D Corp.",
    "B8A3E0": "BenRui Technology Co.",
    "3CF52C": "DSPECIALISTS GmbH",
    "6C1811": "Decatur Electronics",
    "F8E968": "Egker Kft.",
    "5403F5": "EBN Technology Corp.",
    "8038FD": "LeapFrog Enterprises",
    "ACBEB6": "Visualedge Technology Co.",
    "2C9127": "Eintechno Corporation",
    "5C1437": "Thyssenkrupp Aufzugswerke GmbH",
    "9C55B4": "I.S.E. S.r.l.",
    "E4751E": "Getinge Sterilization AB",
    "1065A3": "Panamax LLC",
    "4001C6": "3COM EUROPE LTD",
    "9C5E73": "Calibre UK LTD",
    "04C05B": "Tigo Energy",
    "AC583B": "Human Assembler",
    "E8E776": "Shenzhen Kootion Technology Co.",
    "50252B": "Nethra Imaging Incorporated",
    "F8811A": "OVERKIZ",
    "4C63EB": "Application Solutions (Electronics and Vision) Ltd",
    "702F97": "Aava Mobile Oy",
    "10CA81": "PRECIA",
    "3863F6": "3NOD MULTIMEDIA(SHENZHEN)CO.",
    "609F9D": "CloudSwitch",
    "CCCC4E": "Sun Fountainhead USA. Corp",
    "688540": "IGI Mobile",
    "A09A5A": "Time Domain",
    "64A837": "Juni Korea Co.",
    "60F13D": "JABLOCOM s.r.o.",
    "B894D2": "Retail Innovation HTT AB",
    "F0C24C": "Zhejiang FeiYue Digital Technology Co.",
    "40A6A4": "PassivSystems Ltd",
    "94BA31": "Visiontec da Amazônia Ltda.",
    "9C5B96": "NMR Corporation",
    "78B81A": "INTER SALES A/S",
    "B0E97E": "Advanced Micro Peripherals",
    "48343D": "IEP GmbH",
    "D4AAFF": "MICRO WORLD",
    "942E63": "Finsécur",
    "AC8317": "Shenzhen Furtunetel Communication Co.",
    "ACD180": "Crexendo Business Solutions",
    "202CB7": "Kong Yue Electronics & Information Industry (Xinhui) Ltd.",
    "74E537": "RADSPIN",
    "CC0080": "BETTINI SRL",
    "644BC3": "Shanghai WOASiS Telecommunications Ltd.",
    "002717": "CE Digital(Zhenjiang)Co.",
    "002716": "Adachi-Syokai Co.",
    "0026E1": "Stanford University",
    "0026DC": "Optical Systems Design",
    "0026EC": "Legrand Home Systems",
    "0026E9": "SP Corp",
    "0026EB": "Advanced Spectrum Technology Co.",
    "002700": "Shenzhen Siglent Technology Co.",
    "00267F": "Oregan Networks Ltd.",
    "00267D": "A-Max Technology Macao Commercial Offshore Company Limited",
    "00267C": "Metz-Werke GmbH & Co KG",
    "002674": "Hunter Douglas",
    "002673": "RICOH COMPANY",
    "00266D": "MobileAccess Networks",
    "002661": "Irumtek Co.",
    "00265B": "Hitron Technologies. Inc",
    "002656": "Sansonic Electronics USA",
    "002658": "T-Platforms (Cyprus) Limited",
    "00266F": "Coordiwise Technology Corp.",
    "00266E": "Nissho-denki Co.",
    "002663": "Shenzhen Huitaiwei Tech. Ltd",
    "0026C3": "Insightek Corp.",
    "0026C1": "ARTRAY CO.",
    "0026BE": "Schoonderbeek Elektronica Systemen B.V.",
    "002681": "Interspiro AB",
    "002683": "Ajoho Enterprise Co.",
    "00268C": "StarLeaf Ltd.",
    "00268B": "Guangzhou Escene Computer Technology Limited",
    "0026A1": "Megger",
    "002698": "Cisco Systems",
    "00269B": "SOKRAT Ltd.",
    "0026B5": "ICOMM Tele Ltd",
    "0026D4": "IRCA SpA",
    "00264C": "Shanghai DigiVision Technology Co.",
    "002646": "SHENYANG TONGFANG MULTIMEDIA TECHNOLOGY COMPANY LIMITED",
    "002644": "Thomson Telecom Belgium",
    "00263F": "LIOS Technology GmbH",
    "002606": "RAUMFELD GmbH",
    "002607": "Enabling Technology Pty Ltd",
    "002602": "SMART Temps LLC",
    "002605": "CC Systems AB",
    "0025D4": "General Dynamics Mission Systems",
    "0025C2": "RingBell Co.",
    "00263B": "Onbnetech",
    "002634": "Infineta Systems",
    "00262F": "HAMAMATSU TOA ELECTRONICS",
    "0025FB": "Tunstall Healthcare A/S",
    "0025F4": "KoCo Connector AG",
    "0025EF": "I-TEC Co.",
    "002631": "COMMTACT LTD",
    "002624": "Thomson Inc.",
    "00261A": "Femtocomm System Technology Corp.",
    "0025E3": "Hanshinit Inc.",
    "00259F": "TechnoDigital Technologies GmbH",
    "00259D": "Private",
    "002598": "Zhong Shan City Litai Electronic Industrial Co. Ltd",
    "002599": "Hedon e.d. B.V.",
    "002597": "Kalki Communication Technologies",
    "00256B": "ATENIX E.E. s.r.l.",
    "00256E": "Van Breda B.V.",
    "002565": "Vizimax Inc.",
    "00255E": "Shanghai Dare Technologies Co.",
    "00255F": "SenTec AG",
    "00253B": "din Dietmar Nocker Facilitymanagement GmbH",
    "00253D": "DRS Consolidated Controls",
    "002535": "Minimax GmbH & Co KG",
    "002592": "Guangzhou Shirui Electronic Co.",
    "002594": "Eurodesign BG LTD",
    "00258A": "Pole/Zero Corporation",
    "002584": "Cisco Systems",
    "002579": "J & F Labs",
    "00257F": "CallTechSolution Co.",
    "002577": "D-BOX Technologies",
    "002572": "Nemo-Q International AB",
    "0025B4": "Cisco Systems",
    "0025B2": "MBDA Deutschland GmbH",
    "0025A7": "itron",
    "0024C2": "Asumo Co.",
    "0024BF": "Carrier Culoz SA",
    "0024C0": "NTI COMODO INC",
    "0024BB": "CENTRAL Corporation",
    "0024BC": "HuRob Co.",
    "0024B7": "GridPoint",
    "0024EA": "iris-GmbH infrared & intelligent sensors",
    "0024ED": "YT Elec. Co",
    "0024EC": "United Information Technology Co.",
    "0024E6": "In Motion Technology Inc.",
    "0024E7": "Plaster Networks",
    "0024E4": "Withings",
    "002529": "COMELIT GROUP S.P.A",
    "00252A": "Chengdu GeeYa Technology Co.",
    "002528": "Daido Signal Co.",
    "002526": "Genuine Technologies Co.",
    "0024DE": "GLOBAL Technology Inc.",
    "0024DB": "Alcohol Monitoring Systems",
    "0024DD": "Centrak",
    "002521": "Logitek Electronic Systems",
    "00251F": "ZYNUS VISION INC.",
    "00251E": "ROTEL TECHNOLOGIES",
    "002519": "Viaas Inc",
    "002513": "CXP DIGITAL BV",
    "0024D5": "Winward Industrial Limited",
    "002503": "IBM Corp",
    "002504": "Valiant Communications Limited",
    "0024A7": "Advanced Video Communications Inc.",
    "0024AB": "A7 Engineering",
    "0024A4": "Siklu Communication",
    "00249A": "Beijing Zhongchuang Telecommunication Test Co.",
    "00249E": "ADC-Elektronik GmbH",
    "00245F": "Vine Telecom CO.",
    "002455": "MuLogic BV",
    "00245A": "Nanjing Panda Electronics Company Limited",
    "00245B": "RAIDON TECHNOLOGY",
    "002459": "ABB Automation products GmbH",
    "00249F": "RIM Testing Services",
    "002488": "Centre For Development Of Telematics",
    "00248F": "DO-MONIX",
    "002479": "Optec Displays",
    "002468": "Sumavision Technologies Co.",
    "002466": "Unitron nv",
    "0024AE": "IDEMIA",
    "0024AD": "Adolf Thies Gmbh & Co. KG",
    "00243A": "Ludl Electronic Products",
    "00244E": "RadChips",
    "002439": "Digital Barriers Advanced Technologies",
    "002434": "Lectrosonics",
    "00242F": "Micron",
    "00240B": "Virtual Computer Inc.",
    "002402": "Op-Tection GmbH",
    "0023C1": "Securitas Direct AB",
    "0023FC": "Ultra Stereo Labs",
    "002418": "Nextwave Semiconductor",
    "002412": "Benign Technologies Co",
    "00240D": "OnePath Networks LTD.",
    "0023DB": "saxnet gmbh",
    "0023C8": "TEAM-R",
    "0023EB": "Cisco Systems",
    "0023EC": "Algorithmix GmbH",
    "002426": "NOHMI BOSAI LTD.",
    "002429": "MK MASTER INC.",
    "00238D": "Techno Design Co.",
    "002387": "ThinkFlood",
    "002384": "GGH Engineering s.r.l.",
    "00236F": "DAQ System",
    "002369": "Cisco-Linksys",
    "0023AA": "HFR",
    "0023A5": "SageTV",
    "00239E": "Jiangsu Lemote Technology Corporation Limited",
    "002330": "DIZIPIA",
    "00232D": "SandForce",
    "002391": "Maxian",
    "002392": "Proteus Industries Inc.",
    "002393": "AJINEXTEK",
    "00237F": "PLANTRONICS",
    "0023BB": "Accretech SBS",
    "002295": "SGM Technology for lighting spa",
    "002287": "Titan Wireless LLC",
    "002288": "Sagrad",
    "002323": "Zylin AS",
    "0022F8": "PIMA Electronic Systems Ltd.",
    "00231C": "Fourier Systems Ltd.",
    "00231D": "Deltacom Electronics Ltd",
    "0022D0": "Polar Electro Oy",
    "0022C3": "Zeeport Technology Inc.",
    "002316": "KISAN ELECTRONICS CO",
    "00230F": "Hirsch Electronics Corporation",
    "00230A": "ARBURG GmbH & Co KG",
    "0022DE": "OPPO Digital",
    "0022D7": "Nintendo Co.",
    "0022D6": "Cypak AB",
    "0022A2": "Xtramus Technologies",
    "00229E": "Social Aid Research Co.",
    "0022F1": "Private",
    "002240": "Universal Telecom S/A",
    "002242": "Alacron Inc.",
    "002221": "ITOH DENKI CO",
    "002226": "Avaak",
    "00221D": "Freegene Technology LTD",
    "002224": "Good Will Instrument Co.",
    "002285": "NOMUS COMM SYSTEMS",
    "002281": "Daintree Networks Pty",
    "002273": "Techway",
    "002234": "Corventis Inc.",
    "002232": "Design Design Technology Ltd",
    "00222B": "Nucomm",
    "00224E": "SEEnergy Corp.",
    "002245": "Leine & Linde AB",
    "002249": "HOME MULTIENERGY SL",
    "00220F": "MoCA (Multimedia over Coax Alliance)",
    "00220A": "OnLive",
    "00226B": "Cisco-Linksys",
    "002267": "Nortel Networks",
    "00225A": "Garde Security AB",
    "002255": "Cisco Systems",
    "00221B": "Morega Systems",
    "002187": "Imacs GmbH",
    "002181": "Si2 Microsystems Limited",
    "00217E": "Telit Communication s.p.a",
    "0021F7": "HPN Supply Chain",
    "0021F4": "INRange Systems",
    "0021F5": "Western Engravers Supply",
    "0021AC": "Infrared Integrated Systems Ltd",
    "0021A2": "EKE-Electronics Ltd.",
    "0021E4": "I-WIN",
    "0021E5": "Display Solution AG",
    "0021E2": "visago Systems & Controls GmbH & Co. KG",
    "0021DD": "Northstar Systems Corp",
    "00218E": "MEKICS CO.",
    "00218F": "Avantgarde Acoustic Lautsprechersysteme GmbH",
    "002203": "Glensound Electronics Ltd",
    "002204": "KORATEK",
    "0021FF": "Cyfrowy Polsat SA",
    "0021C9": "Wavecom Asia Pacific Limited",
    "0021C2": "GL Communications Inc",
    "0021B2": "Fiberblaze A/S",
    "0021D5": "X2E GmbH",
    "00214A": "Pixel Velocity",
    "002146": "Sanmina-SCI",
    "002142": "Advanced Control Systems doo",
    "00216E": "Function ATI (Huizhou) Telecommunications Co.",
    "00211F": "SHINSUNG DELTATECH CO.",
    "002124": "Optos Plc",
    "002117": "Tellord",
    "002101": "Aplicaciones Electronicas Quasar (AEQ)",
    "002103": "GHI Electronics",
    "001FF8": "Siemens AG",
    "002130": "Keico Hightech Inc.",
    "002133": "Building B",
    "002134": "Brandywine Communications",
    "00216D": "Soltech Co.",
    "002165": "Presstek Inc.",
    "00213A": "Winchester Systems Inc.",
    "00212E": "dresden-elektronik",
    "00210F": "Cernium Corp",
    "00215B": "SenseAnywhere",
    "00214E": "GS Yuasa Power Supply Ltd.",
    "001F90": "Actiontec Electronics",
    "001F91": "DBS Lodging Technologies",
    "001F98": "DAIICHI-DENTSU LTD.",
    "001F93": "Xiotech Corporation",
    "001FD1": "OPTEX CO.",
    "001FC9": "Cisco Systems",
    "001FFA": "Coretree",
    "001FF5": "Kongsberg Defence & Aerospace",
    "001FF2": "VIA Technologies",
    "001FA3": "T&W Electronics(Shenzhen)Co.",
    "001FA2": "Datron World Communications",
    "001FF1": "Paradox Hellas S.A.",
    "001FE6": "Alphion Corporation",
    "001FDC": "Mobile Safe Track Ltd",
    "001FA9": "Atlanta DTH",
    "001FCF": "MSI Technology GmbH",
    "001F2A": "ACCM",
    "001F30": "Travelping",
    "001F24": "DIGITVIEW TECHNOLOGY CO.",
    "001F21": "Inner Mongolia Yin An Science & Technology Development Co.",
    "001F22": "Source Photonics",
    "001F1D": "Atlas Material Testing Technology LLC",
    "001F51": "HD Communications Corp",
    "001F53": "GEMAC Chemnitz GmbH",
    "001F4C": "Roseman Engineering Ltd",
    "001F50": "Swissdis AG",
    "001F48": "Mojix Inc.",
    "001F3E": "RP-Technik e.K.",
    "001F04": "Granch Ltd.",
    "001EF0": "Gigafin Networks",
    "001EF2": "Micro Motion Inc",
    "001F37": "Genesis I&C",
    "001F2C": "Starbridge Networks",
    "001F31": "Radiocomp",
    "001F2B": "Orange Logic",
    "001F15": "Bioscrypt Inc",
    "001F70": "Botik Technologies LTD",
    "001F6D": "Cisco Systems",
    "001F64": "Beijing Autelan Technology Inc.",
    "001EEA": "Sensor Switch",
    "001E98": "GreenLine Communications",
    "001E9A": "HAMILTON Bonaduz AG",
    "001E94": "SUPERCOM TECHNOLOGY CORPORATION",
    "001EA6": "Best IT World (India) Pvt. Ltd.",
    "001EA5": "ROBOTOUS",
    "001EA7": "Actiontec Electronics",
    "001EA0": "XLN-t",
    "001E83": "LAN/MAN Standards Association (LMSC)",
    "001E7C": "Taiwick Limited",
    "001E78": "Owitek Technology Ltd.",
    "001E62": "Siemon",
    "001E5C": "RB GeneralEkonomik",
    "001E5D": "Holosys d.o.o.",
    "001E60": "Digital Lighting Systems",
    "001EDF": "Master Industrialization Center Kista",
    "001EE3": "T&W Electronics (ShenZhen) Co.",
    "001ED9": "Mitsubishi Precision Co.",
    "001E6C": "Opaque Systems",
    "001ED3": "Dot Technology Int'l Co.",
    "001ECF": "PHILIPS ELECTRONICS UK LTD",
    "001E8F": "CANON INC.",
    "001DE8": "Nikko Denki Tsushin Corporation(NDTC)",
    "001DDA": "Mikroelektronika spol. s r. o.",
    "001DE3": "Intuicom",
    "001DDE": "Zhejiang Broadcast&Television Technology Co.",
    "001DE5": "Cisco Systems",
    "001E1A": "Best Source Taiwan Inc.",
    "001E19": "GTRI",
    "001E14": "Cisco Systems",
    "001E36": "IPTE",
    "001E27": "SBN TECH Co.",
    "001E22": "ARVOO Imaging Products BV",
    "001DCB": "Exéns Development Oy",
    "001DCA": "PAV Electronics Limited",
    "001DC2": "XORTEC OY",
    "001E44": "SANTEC",
    "001E0E": "MAXI VIEW HOLDINGS LIMITED",
    "001E0F": "Briot International",
    "001DFE": "Palm",
    "001DF5": "Sunshine Co",
    "001DF0": "Vidient Systems",
    "001DEC": "Marusys",
    "001DB8": "Intoto Inc.",
    "001E2F": "DiMoto Pty Ltd",
    "001DA7": "Seamless Internet",
    "001DA8": "Takahata Electronics Co.",
    "001DA9": "Castles Technology",
    "001DA5": "WB Electronics",
    "001DA1": "Cisco Systems",
    "001D96": "WatchGuard Video",
    "001D55": "ZANTAZ",
    "001D52": "Defzone B.V.",
    "001D4A": "Carestream Health",
    "001D8F": "PureWave Networks",
    "001D8C": "La Crosse Technology LTD",
    "001D71": "Cisco Systems",
    "001D65": "Microwave Radio Communications",
    "001D64": "Adam Communications Systems Int Ltd",
    "001D5E": "COMING MEDIA CORP.",
    "001D50": "SPINETIX SA",
    "001D45": "Cisco Systems",
    "001D36": "ELECTRONICS CORPORATION OF INDIA LIMITED",
    "001DB0": "FuJian HengTong Information Technology Co.",
    "001D69": "Knorr-Bremse IT-Services GmbH",
    "001D07": "Shenzhen Sang Fei Consumer Communications Co.",
    "001D06": "HM Electronics",
    "001D01": "Neptune Digital",
    "001CF8": "Parade Technologies",
    "001CF7": "AudioScience",
    "001CF6": "Cisco Systems",
    "001D33": "Maverick Systems Inc.",
    "001D2C": "Wavetrend Technologies (Pty) Limited",
    "001CCF": "LIMETEK",
    "001CCA": "Shanghai Gaozhi Science & Technology Development Co.",
    "001CAD": "Wuhan Telecommunication Devices Co.",
    "001CA7": "International Quartz Limited",
    "001CAB": "Meyer Sound Laboratories",
    "001CF5": "Wiseblue Technology Limited",
    "001CEE": "SHARP Corporation",
    "001CC9": "Kaise Electronic Technology Co.",
    "001CC8": "INDUSTRONIC Industrie-Electronic GmbH & Co. KG",
    "001CC6": "ProStor Systems",
    "001CBE": "Nintendo Co.",
    "001D27": "NAC-INTERCOM",
    "001D24": "Aclara Power-Line Systems Inc.",
    "001D18": "Power Innovation GmbH",
    "001CE3": "Optimedical Systems",
    "001CDE": "Interactive Multimedia eXchange Inc.",
    "001D1B": "Sangean Electronics Inc.",
    "001D17": "Digital Sky Corporation",
    "001C9E": "Dualtech IT AB",
    "001C94": "LI-COR Biosciences",
    "001C8C": "DIAL TECHNOLOGY LTD.",
    "001C48": "WiDeFi",
    "001C46": "QTUM",
    "001C42": "Parallels",
    "001C3E": "ECKey Corporation",
    "001C39": "S Netsystems Inc.",
    "001C93": "ExaDigm Inc",
    "001C85": "Eunicorn",
    "001C80": "New Business Division/Rhea-Information CO.",
    "001C83": "New Level Telecom Co.",
    "001C27": "Sunell Electronics Co.",
    "001C22": "Aeris Elettronica s.r.l.",
    "001C1D": "CHENZHOU GOSPELL DIGITAL TECHNOLOGY CO.",
    "001C67": "Pumpkin Networks",
    "001C60": "CSP Frontier Technologies",
    "001C51": "Celeno Communications",
    "001C0F": "Cisco Systems",
    "001C0A": "Shenzhen AEE Technology Co.",
    "001C0D": "G-Technology",
    "001C76": "The Wandsworth Group Ltd",
    "001C72": "Mayer & Cie GmbH & Co KG",
    "001C6A": "Weiss Engineering Ltd.",
    "001C37": "Callpod",
    "001C33": "Sutron",
    "001C2F": "Pfister GmbH",
    "001C54": "Hillstone Networks Inc",
    "001C59": "DEVON IT",
    "001BF6": "CONWISE Technology Corporation Ltd.",
    "001BF8": "Digitrax Inc.",
    "001BF1": "Nanjing SilverNet Software Co.",
    "001BEF": "Blossoms Digital Technology Co.",
    "001BEB": "DMP Electronics INC.",
    "001BE7": "Postek Electronics Co.",
    "001BB8": "BLUEWAY ELECTRONIC CO;LTD",
    "001BB2": "Intellect International NV",
    "001BB0": "Bharat Electronics Limited",
    "001BAD": "iControl Incorporated",
    "001BA7": "Lorica Solutions",
    "001BA5": "MyungMin Systems",
    "001B7F": "TMN Technologies Telecomunicacoes Ltda",
    "001B7E": "Beckmann GmbH",
    "001B7A": "Nintendo Co.",
    "001BA2": "IDS Imaging Development Systems GmbH",
    "001B9D": "Novus Security Sp. z o.o.",
    "001B95": "VIDEO SYSTEMS SRL",
    "001BD5": "Cisco Systems",
    "001BCE": "Measurement Devices Ltd",
    "001BC9": "FSN DISPLAY INC",
    "001BC3": "Mobisolution Co.",
    "001B90": "Cisco Systems",
    "001B87": "Deepsound Tech. Co.",
    "001C03": "Betty TV Technology AG",
    "001BE3": "Health Hero Network",
    "001BDC": "Vencer Co.",
    "001AFE": "SOFACREAL",
    "001AF1": "Embedded Artists AB",
    "001AF8": "Copley Controls Corporation",
    "001AF5": "PENTAONE. CO.",
    "001B72": "Sicep s.p.a.",
    "001B74": "MiraLink Corporation",
    "001B6D": "Midtronics",
    "001B6F": "Teletrak Ltd",
    "001B34": "Focus System Inc.",
    "001B3A": "SIMS Corp.",
    "001B2E": "Sinkyo Electron Inc",
    "001B1A": "e-trees Japan",
    "001B12": "Apprion",
    "001B0D": "Cisco Systems",
    "001B0A": "Intelligent Distributed Controls Ltd",
    "001B5F": "Alien Technology",
    "001B5E": "BPL Limited",
    "001B61": "Digital Acoustics",
    "001B4B": "SANION Co.",
    "001B4D": "Areca Technology Corporation",
    "001B2D": "Med-Eng Systems Inc.",
    "001B1D": "Phoenix International Co.",
    "001B5C": "Azuretec Co.",
    "001AE9": "Nintendo Co.",
    "001AE5": "Mvox Technologies Inc.",
    "001AE4": "Medicis Technologies Corporation",
    "001AED": "INCOTEC GmbH",
    "001AEE": "Shenztech Ltd",
    "001AE3": "Cisco Systems",
    "001ADF": "Interactivetv Pty Limited",
    "001AE1": "EDGE ACCESS INC",
    "001AC0": "JOYBIEN TECHNOLOGIES CO.",
    "001AC2": "YEC Co.",
    "001AB1": "Asia Pacific Satellite Industries Co.",
    "001AB2": "Cyber Solutions Inc.",
    "001AB7": "Ethos Networks LTD.",
    "001AA2": "Cisco Systems",
    "001AA5": "BRN Phoenix",
    "001A97": "fitivision technology Inc.",
    "001A90": "Trópico Sistemas e Telecomunicações da Amazônia LTDA.",
    "001A94": "Votronic GmbH",
    "001A86": "New Wave Design & Verification",
    "001AD2": "Eletronica Nitron Ltda",
    "001ACE": "YUPITERU CORPORATION",
    "001ACC": "Celestial Semiconductor",
    "001AC7": "UNIPOINT",
    "001A9C": "RightHand Technologies",
    "001A9E": "ICON Digital International Limited",
    "001A98": "Asotel Communication Limited Taiwan Branch",
    "001A7E": "LN Srithai Comm Ltd.",
    "001A38": "Sanmina-SCI",
    "001A2B": "Ayecom Technology Co.",
    "001A28": "ASWT Co.",
    "001A2C": "SATEC Co.",
    "001A27": "Ubistar",
    "001A2E": "Ziova Coporation",
    "001A32": "ACTIVA MULTIMEDIA",
    "001A35": "BARTEC GmbH",
    "001A37": "Lear Corporation",
    "001A5A": "Korea Electric Power Data Network  (KDN) Co.",
    "001A5F": "KitWorks.fi Ltd.",
    "001A72": "Mosart Semiconductor Corp.",
    "001A68": "Weltec Enterprise Co.",
    "001A48": "Takacom Corporation",
    "001A21": "Brookhuis Applied Technologies BV",
    "001A0B": "BONA TECHNOLOGY INC.",
    "001A06": "OpVista",
    "001A5D": "Mobinnova Corp.",
    "001993": "Changshu Switchgear MFG. Co.",
    "00199B": "Diversified Technical Systems",
    "0019FA": "Cable Vision Electronics CO.",
    "0019F1": "Star Communication Network Technology Co.",
    "0019EC": "Sagamore Systems",
    "0019A3": "asteel electronique atlantique",
    "0019AD": "BOBST SA",
    "0019A2": "ORDYN TECHNOLOGIES",
    "0019A5": "RadarFind Corporation",
    "0019C4": "Infocrypt Inc.",
    "0019BC": "ELECTRO CHANCE SRL",
    "0019D5": "IP Innovations",
    "0019CC": "RCG (HK) Ltd",
    "0019C8": "AnyDATA Corporation",
    "001981": "Vivox Inc",
    "0019EA": "TeraMage Technologies Co.",
    "0019D8": "MAXFOR",
    "001A00": "MATRIX INC.",
    "0019FF": "Finnzymes",
    "001990": "ELM DATA Co.",
    "00198F": "Nokia Bell N.V.",
    "001929": "2M2B Montadora de Maquinas Bahia Brasil LTDA",
    "00192A": "Antiope Associates",
    "00190F": "Advansus Corp.",
    "001911": "Just In Mobile Information Technologies (Shanghai) Co.",
    "001917": "Posiflex Inc.",
    "00196E": "Metacom (Pty) Ltd.",
    "001965": "YuHua TelTech (ShangHai) Co.",
    "001966": "Asiarock Technology Limited",
    "00192E": "Spectral Instruments",
    "00192B": "Aclara RF Systems Inc.",
    "00191E": "Beyondwiz Co.",
    "00191F": "Microlink communications Inc.",
    "001920": "KUME electric Co.",
    "001926": "BitsGen Co.",
    "001918": "Interactive Wear AG",
    "00190B": "Southern Vision Systems",
    "001903": "Bigfoot Networks Inc",
    "001973": "Zeugma Systems",
    "001975": "Beijing Huisen networks technology Inc",
    "00197B": "Picotest Corp.",
    "001943": "Belden",
    "001940": "Rackable Systems",
    "00193C": "HighPoint Technologies Incorporated",
    "001900": "Intelliverese - DBA Voicecom",
    "001902": "Cambridge Consultants Ltd",
    "001945": "RF COncepts",
    "001948": "AireSpider Networks",
    "00195C": "Innotech Corporation",
    "00195F": "Valemount Networks Corporation",
    "0018F1": "Chunichi Denshi Co.",
    "0018F2": "Beijing Tianyu Communication Equipment Co.",
    "0018EC": "Welding Technology Corporation",
    "0018ED": "Accutech Ultrasystems Co.",
    "001894": "NPCore",
    "001898": "KINGSTATE ELECTRONICS CORPORATION",
    "001892": "ads-tec GmbH",
    "001891": "Zhongshan General K-mate Electronics Co.",
    "001889": "WinNet Solutions Limited",
    "0018B2": "ADEUNIS RF",
    "0018B3": "TEC WizHome Co.",
    "0018AC": "Shanghai Jiao Da HISYS Technology Co. Ltd.",
    "0018AB": "BEIJING LHWT MICROELECTRONICS INC.",
    "0018A5": "ADigit Technologies Corp.",
    "0018E0": "ANAVEO",
    "0018CE": "Dreamtech Co.",
    "0018A6": "Persistent Systems",
    "00189B": "Thomson Inc.",
    "00186B": "Sambu Communics CO.",
    "001877": "Amplex A/S",
    "001867": "Datalogic ADC",
    "0018BD": "SHENZHEN DVBWORLD TECHNOLOGY CO.",
    "00186A": "Global Link Digital Technology Co",
    "001878": "Mackware GmbH",
    "00186E": "3Com Ltd",
    "0018CB": "Tecobest Technology Limited",
    "001843": "Dawevision Ltd",
    "00182C": "Ascend Networks",
    "001836": "REJ Co.",
    "0017ED": "WooJooIT Ltd.",
    "0017DD": "Clipsal Australia",
    "0017D9": "AAI Corporation",
    "0017DC": "DAEMYUNG ZERO1",
    "0017F9": "Forcom Sp. z o.o.",
    "0017F4": "ZERON ALLIANCE",
    "0017F7": "CEM Solutions Pvt Ltd",
    "00181D": "ASIA ELECTRONICS CO.",
    "00181F": "Palmmicro Communications",
    "00181B": "TaiJin Metal Co.",
    "001865": "Siemens Healthcare Diagnostics Manufacturing Ltd",
    "001805": "Beijing InHand Networking Technology Co.",
    "001854": "Argard Co.",
    "001847": "AceNet Technology Inc.",
    "00180D": "Terabytes Server Storage Tech Corp",
    "0017C4": "Quanta Microsystems",
    "0017BD": "Tibetsystem",
    "0017BF": "Coherent Research Limited",
    "00179E": "Sirit Inc",
    "0017A7": "Mobile Computing Promotion Consortium",
    "00179F": "Apricorn",
    "0017A1": "3soft inc.",
    "001758": "ThruVision Ltd",
    "00174F": "iCatch Inc.",
    "0017B4": "Remote Security Systems",
    "0017AC": "O'Neil Product Development Inc.",
    "0017AD": "AceNet Corporation",
    "001788": "Philips Lighting BV",
    "00176F": "PAX Computer Technology(Shenzhen) Ltd.",
    "001766": "Accense Technology",
    "001764": "ATMedia GmbH",
    "00175E": "Zed-3",
    "00175B": "ACS Solutions Switzerland Ltd.",
    "001792": "Falcom Wireless Comunications Gmbh",
    "001797": "Telsy Elettronica S.p.A.",
    "00178C": "Independent Witness",
    "0017D3": "Etymotic Research",
    "0017CC": "Alcatel-Lucent",
    "001771": "APD Communications Ltd",
    "001729": "Ubicod Co.LTD",
    "001727": "Thermo Ramsey Italia s.r.l.",
    "00172A": "Proware Technology Corp.(By Unifosa)",
    "001725": "Liquid Computing",
    "00173C": "Extreme Engineering Solutions",
    "001736": "iiTron Inc.",
    "001737": "Industrie Dial Face S.p.A.",
    "001733": "SFR",
    "00174A": "SOCOMEC",
    "00174E": "Parama-tech Co.",
    "0016F8": "AVIQTECH TECHNOLOGY CO.",
    "0016E8": "Lumissil Microsystems",
    "0016E9": "Tiba Medical Inc",
    "001714": "BR Controls Nederland bv",
    "00171B": "Innovation Lab Corp.",
    "001709": "Exalt Communications",
    "001703": "MOSDAN Internation Co.",
    "0016FC": "TOHKEN CO.",
    "0016F0": "Dell",
    "0016A9": "2EI",
    "0016B0": "VK Corporation",
    "0016B1": "KBS",
    "0016AE": "INVENTEL",
    "00168C": "DSL Partner AS",
    "001683": "WEBIO International Co.",
    "001684": "Donjin Co.",
    "001687": "Chubb CSC-Vendor AP",
    "0016D0": "ATech elektronika d.o.o.",
    "0016C3": "BA Systems Inc",
    "00167F": "Bluebird Soft Inc.",
    "00167C": "iRex Technologies BV",
    "001673": "Bury GmbH & Co. KG",
    "0016C1": "Eleksen Ltd",
    "0016AC": "Toho Technology Corp.",
    "00169C": "Cisco Systems",
    "0016DC": "ARCHOS",
    "001694": "Sennheiser Communications A/S",
    "001618": "HIVION Co.",
    "00161E": "Woojinnet",
    "00161F": "SUNWAVETEC Co.",
    "001614": "Picosecond Pulse Labs",
    "00160E": "Optica Technologies Inc.",
    "001643": "Sunhillo Corporation",
    "001644": "LITE-ON Technology Corp.",
    "00163E": "Xensource",
    "001634": "Mathtech",
    "00162C": "Xanboo",
    "00164C": "PLANET INT Co.",
    "001649": "SetOne GmbH",
    "001647": "Cisco Systems",
    "0015FD": "Complete Media Systems",
    "0015F6": "SCIENCE AND ENGINEERING SERVICES",
    "00161B": "Micronet Corporation",
    "001605": "YORKVILLE SOUND INC.",
    "0015F9": "Cisco Systems",
    "00165F": "Fairmount Automation",
    "001657": "Aegate Ltd",
    "001665": "Cellon France",
    "0015D3": "Pantech&Curitel Communications",
    "0015CA": "TeraRecon",
    "001570": "Zebra Technologies Inc",
    "00156E": "A. W. Communication Systems Ltd",
    "001568": "Dilithium Networks",
    "00155F": "GreenPeak Technologies",
    "0015AD": "Accedian Networks",
    "0015AC": "Capelon AB",
    "0015A9": "KWANG WOO I&C CO.",
    "00E0A8": "SAT GmbH & Co.",
    "001574": "Horizon Semiconductors Ltd.",
    "0015F3": "PELTOR AB",
    "0015E7": "Quantec Tontechnik",
    "0015E3": "Dream Technologies Corporation",
    "0015E0": "Ericsson",
    "001598": "Kolektor group",
    "00158A": "SURECOM Technology Corp.",
    "00158E": "Plustek.INC",
    "001589": "D-MAX Technology Co.",
    "0015B4": "Polymap  Wireless LLC",
    "0014F4": "DekTec Digital Video B.V.",
    "0014F5": "OSI Security Devices",
    "0014EC": "Acro Telecom",
    "0014EB": "AwarePoint Corporation",
    "00154B": "Wonde Proud Technology Co.",
    "001548": "CUBE TECHNOLOGIES",
    "00153C": "Kprotech Co.",
    "00155A": "DAINIPPON PHARMACEUTICAL CO.",
    "0014FF": "Precise Automation",
    "0014FA": "AsGa S.A.",
    "0014FB": "Technical Solutions Inc.",
    "00153A": "Shenzhen Syscan Technology Co.",
    "001532": "Consumer Technologies Group",
    "00150A": "Sonoa Systems",
    "00151D": "M2I CORPORATION",
    "001512": "Zurich University of Applied Sciences",
    "0014A9": "Cisco Systems",
    "00149B": "Nokota Communications",
    "0014A1": "Synchronous Communication Corp",
    "00149E": "UbONE Co.",
    "0014A2": "Core Micro Systems Inc.",
    "0014AB": "Senhai Electronic Technology Co.",
    "0014B0": "Naeil Community",
    "0014AD": "Gassner Wiege- und Meßtechnik GmbH",
    "0014AF": "Datasym POS Inc.",
    "0014D2": "Kyuden Technosystems Corporation",
    "0014DC": "Communication System Design & Manufacturing (CSDM)",
    "0014CD": "DigitalZone Co.",
    "0014C0": "Symstream Technology Group Ltd",
    "0014C1": "U.S. Robotics Corporation",
    "0014C4": "Vitelcom Mobile Technology",
    "00148E": "Tele Power Inc.",
    "00148F": "Protronic (Far East) Ltd.",
    "00148C": "General Dynamics Mission Systems",
    "001481": "Multilink Inc",
    "00147C": "3Com Ltd",
    "001464": "Cryptosoft",
    "00145E": "IBM Corp",
    "001458": "HS Automatic ApS",
    "001468": "CelPlan International",
    "001487": "American Technology Integrators",
    "001444": "Grundfos Holding",
    "001437": "GSTeletech Co.",
    "0013F0": "Wavefront Semiconductor",
    "0013EF": "Kingjon Digital Technology Co.",
    "0013EB": "Sysmaster Corporation",
    "0013EC": "Netsnapper Technologies SARL",
    "001431": "PDL Electronics Ltd",
    "00142B": "Edata Communication Inc.",
    "00142C": "Koncept International",
    "001424": "Merry Electrics CO.",
    "001421": "Total Wireless Technologies Pte. Ltd.",
    "001420": "G-Links networking company",
    "001418": "C4Line",
    "00141B": "Cisco Systems",
    "00140F": "Federal State Unitary Enterprise Leningrad R&D Institute of",
    "001407": "Sperian Protection Instrumentation",
    "001406": "Go Networks",
    "00140A": "WEPIO Co.",
    "0013D0": "t+ Medical Ltd",
    "0013D2": "PAGE IBERICA",
    "0013D1": "KIRK telecom A/S",
    "00144D": "Intelligent Systems",
    "00144A": "Taiwan Thick-Film Ind. Corp.",
    "001445": "Telefon-Gradnja d.o.o.",
    "0013FA": "LifeSize Communications",
    "0013FB": "RKC INSTRUMENT INC.",
    "00136F": "PacketMotion",
    "001366": "Neturity Technologies Inc.",
    "00137D": "Dynalab",
    "001383": "Application Technologies and Engineering Research Laboratory",
    "001387": "27M Technologies AB",
    "001373": "BLwave Electronics Co.",
    "00135B": "PanelLink Cinema",
    "00135E": "EAB/RWI/K",
    "00134E": "Valox Systems",
    "0013C3": "Cisco Systems",
    "0013BD": "HYMATOM SA",
    "0013BA": "ReadyLinks Inc",
    "001397": "Oracle Corporation",
    "001336": "Tianjin 712 Communication Broadcasting co.",
    "0013B8": "RyCo Electronic Systems Limited",
    "0013B6": "Sling Media",
    "0013B4": "Appear AS",
    "0013AE": "Radiance Technologies",
    "001344": "Fargo Electronics Inc.",
    "001348": "Artila Electronics Co.",
    "0012D6": "Jiangsu Yitong High-Tech Co.",
    "0012DA": "Cisco Systems",
    "0012D3": "Zetta Systems",
    "0012D5": "Motion Reality Inc.",
    "0012D8": "International Games System Co.",
    "001314": "Asiamajor Inc.",
    "001316": "L-S-B Broadcast Technologies GmbH",
    "001312": "Amedia Networks Inc.",
    "0012E6": "SPECTEC COMPUTER CO.",
    "0012E3": "Agat Soft LLC",
    "0012DB": "ZIEHL industrie-elektronik GmbH + Co KG",
    "001300": "IT-FACTORY",
    "0012EF": "OneAccess SA",
    "0012E9": "Abbey Systems Ltd",
    "001322": "DAQ Electronics",
    "001323": "Cap Co.",
    "0012A2": "VITA",
    "0012A8": "intec GmbH",
    "0012A5": "Dolphin Interconnect Solutions AS",
    "00129E": "Surf Communications Inc.",
    "001251": "SILINK",
    "001245": "Zellweger Analytics",
    "0012BA": "FSI Systems",
    "0012B2": "AVOLITES LTD.",
    "0012AE": "HLS HARD-LINE Solutions Inc.",
    "0012AF": "ELPRO Technologies",
    "001242": "Millennial Net",
    "001241": "a2i marketing center",
    "00123B": "KeRo Systems ApS",
    "001292": "Griffin Technology",
    "001282": "Qovia",
    "001287": "Digital Everywhere Unterhaltungselektronik GmbH",
    "001285": "Gizmondo Europe Ltd",
    "00129A": "IRT Electronics Pty Ltd",
    "00128D": "STB Datenservice GmbH",
    "00128E": "Q-Free ASA",
    "001257": "LeapComm Communication Technologies Inc.",
    "001267": "Panasonic Corporation",
    "001265": "Enerdyne Technologies",
    "00126D": "University of California",
    "0011FA": "Rane Corporation",
    "0011F2": "Institute of Network Technologies",
    "0011F3": "NeoMedia Europe AG",
    "0011E9": "STARNEX CO.",
    "0011EC": "AVIX INC.",
    "00120D": "Advanced Telecommunication Technologies",
    "00120E": "AboCom",
    "001202": "Decrane Aerospace - Audio International Inc.",
    "0011FE": "Keiyo System Research",
    "0011FD": "KORG INC.",
    "001236": "ConSentry Networks",
    "001235": "Andrew Corporation",
    "001226": "Japan Direx Corporation",
    "001229": "BroadEasy Technologies Co.",
    "001222": "Skardin (UK) Ltd",
    "001228": "Data Ltd.",
    "00121F": "Harding Instruments",
    "0011E7": "WORLDSAT - Texas de France",
    "0011E8": "Tixi.Com",
    "0011E0": "U-MEDIA Communications",
    "0011D0": "Tandberg Data ASA",
    "0011C3": "Transceiving System Technology Corporation",
    "0011C2": "United Fiber Optic Communication",
    "0011BF": "AESYS S.p.A.",
    "0011B7": "Octalix B.V.",
    "0011B9": "Inner Range Pty. Ltd.",
    "001220": "Cadco Systems",
    "001210": "WideRay Corp",
    "0011CE": "Ubisense Limited",
    "001198": "Prism Media Products Limited",
    "001197": "Monitoring Technologies Limited",
    "001199": "2wcom Systems GmbH",
    "001162": "STAR MICRONICS CO.",
    "001161": "NetStreams",
    "001156": "Pharos Systems NZ",
    "001159": "MATISSE NETWORKS INC",
    "00115C": "Cisco Systems",
    "00115D": "Cisco Systems",
    "001170": "GSC SRL",
    "00116B": "Digital Data Communications Asia Co.",
    "001169": "EMS Satcom",
    "0011A7": "Infilco Degremont Inc.",
    "0011A3": "LanReady Technologies Inc.",
    "0011A4": "JStream Technologies Inc.",
    "001194": "Chi Mei Communication Systems",
    "001181": "InterEnergy Co.Ltd",
    "001177": "Coaxial Networks",
    "00113D": "KN SOLTEC CO.",
    "001134": "MediaCell",
    "001135": "Grandeye Ltd",
    "001149": "Proliphix Inc.",
    "00113B": "Micronet Communications Inc.",
    "000FC1": "WAVE Corporation",
    "000FC4": "NST co.",
    "000FC9": "Allnet GmbH",
    "000FC6": "Eurocom Industries A/S",
    "000FBE": "e-w/you Inc.",
    "000FC0": "DELCOMp",
    "000FBA": "Tevebox AB",
    "000FB8": "CallURL Inc.",
    "000FD8": "Force",
    "000FD3": "Digium",
    "000FD1": "Applied Wireless Identifications Group",
    "001100": "Schneider Electric",
    "000FFA": "Optinel Systems",
    "000FFD": "Glorytek Network Inc.",
    "000FF9": "Valcretec",
    "001126": "Venstar Inc.",
    "00112E": "CEICOM",
    "001121": "Cisco Systems",
    "001122": "CIMSYS Inc",
    "000FB7": "Cavium",
    "001109": "Micro-Star International",
    "001104": "TELEXY",
    "000FF7": "Cisco Systems",
    "000FA9": "PC Fabrik",
    "000F9A": "Synchrony",
    "000FA0": "Canon Korea Inc.",
    "001116": "COTEAU VERT CO.",
    "001110": "Maxanna Technology Co.",
    "000F85": "ADDO-Japan Corporation",
    "000F82": "Mortara Instrument",
    "000F81": "PAL Pacific Inc.",
    "000F7F": "UBSTORAGE Co.",
    "000F49": "Northover Solutions Limited",
    "000F4B": "Oracle Corporation",
    "000F4A": "Kyushu-kyohan co.",
    "000F44": "Tivella Inc.",
    "000F40": "Optical Internetworking Forum",
    "000F33": "DUALi Inc.",
    "000F2F": "W-LINX TECHNOLOGY CO.",
    "000F95": "ELECOM Co.",
    "000F8A": "WideView",
    "000F5B": "Delta Information Systems",
    "000F55": "Datawire Communication Networks Inc.",
    "000F56": "Continuum Photonics Inc",
    "000F90": "Cisco Systems",
    "000F8D": "FAST TV-Server AG",
    "000F68": "Vavic Network Technology",
    "000F60": "Lifetron Co.",
    "000F77": "DENTUM CO.",
    "000F7B": "Arce Sistemas",
    "000F1C": "DigitAll World Co.",
    "000EF7": "Vulcan Portals Inc",
    "000EE9": "WayTech Development",
    "000EF0": "Festo AG & Co. KG",
    "000EEB": "Sandmartin(zhong shan)Electronics Co.",
    "000EEC": "Orban",
    "000EEF": "Private",
    "000EF1": "EZQUEST INC.",
    "000EE7": "AAC ELECTRONICS CORP.",
    "000F1A": "Gaming Support B.V.",
    "000F0A": "Clear Edge Networks",
    "000F02": "Digicube Technology Co.",
    "000EDA": "C-TECH UNITED CORP.",
    "000EC9": "YOKO Technology Corp.",
    "000ED0": "Privaris",
    "000EC3": "Logic Controls",
    "000EC4": "Iskra Transmission d.d.",
    "000EE2": "Custom Engineering",
    "000EE3": "Chiyu Technology Co.",
    "000EE5": "bitWallet",
    "000ECF": "PROFIBUS Nutzerorganisation e.V.",
    "000EC1": "MYNAH Technologies",
    "000EBD": "Burdick",
    "000EB9": "HASHIMOTO Electronics Industry Co.",
    "000E98": "HME Clear-Com LTD.",
    "000E99": "Spectrum Digital",
    "000E95": "Fujiya Denki Seisakusho Co.",
    "000EA7": "Endace Technology",
    "000EA1": "Formosa Teletek Corporation",
    "000F05": "3B SYSTEM INC.",
    "000EB2": "Micro-Research Finland Oy",
    "000EB5": "Ecastle Electronics Co.",
    "000E4F": "Trajet GmbH",
    "000E50": "Thomson Telecom Belgium",
    "000E4B": "atrium c and i",
    "000E82": "Infinity Tech",
    "000E89": "CLEMATIC",
    "000E79": "Ample Communications Inc.",
    "000E45": "Beijing Newtry Electronic Technology Ltd",
    "000E3F": "Soronti",
    "000E38": "Cisco Systems",
    "000E36": "HEINESYS",
    "000E2B": "Safari Technologies",
    "000E28": "Dynamic Ratings P/L",
    "000E97": "Ultracker Technology CO.",
    "000E1D": "ARION Technology Inc.",
    "000E12": "Adaptive Micro Systems Inc.",
    "000E17": "Private",
    "000E15": "Tadlys LTD",
    "000E6F": "IRIS Corporation Berhad",
    "000DCC": "NEOSMART Corp.",
    "000DCE": "Dynavac Technology Pte Ltd",
    "000DC3": "First Communication",
    "000DB9": "PC Engines GmbH",
    "000DE6": "YOUNGBO ENGINEERING CO.",
    "000DDF": "Japan Image & Network Inc.",
    "000D95": "Opti-cell",
    "000D91": "Eclipse (HQ Espana) S.L.",
    "000D80": "Online Development Inc",
    "000DE8": "Nasaco Electronics Pte. Ltd",
    "000DE9": "Napatech Aps",
    "000DB7": "SANKO ELECTRIC CO",
    "000DAC": "Japan CBM Corporation",
    "000DDB": "AIRWAVE TECHNOLOGIES INC.",
    "000DCB": "Petcomkorea Co.",
    "000E01": "ASIP Technologies Inc.",
    "000E04": "CMA/Microdialysis AB",
    "000D29": "Cisco Systems",
    "000D26": "Primagraphics Limited",
    "000D19": "ROBE Show lighting",
    "000D1C": "Amesys Defense",
    "000D62": "Funkwerk Dabendorf GmbH",
    "000D65": "Cisco Systems",
    "000D55": "SANYCOM Technology Co.",
    "000D57": "Fujitsu I-Network Systems Limited.",
    "000D58": "Private",
    "000CF9": "Xylem Water Solutions",
    "000CED": "Real Digital Media",
    "000CF0": "M & N GmbH",
    "000CF4": "AKATSUKI ELECTRIC MFG.CO.",
    "000CF3": "CALL IMAGE SA",
    "000D41": "Siemens AG ICM MP UC RD IT KLF1",
    "000D42": "Newbest Development Limited",
    "000D3C": "i.Tech Dynamic Ltd",
    "000D0C": "MDI Security Systems",
    "000D01": "P&E Microcomputer Systems",
    "000D00": "Seaway Networks Inc.",
    "000D51": "DIVR Systems",
    "000D45": "Tottori SANYO Electric Co.",
    "000D46": "Parker SSD Drives",
    "000D35": "PAC International Ltd",
    "000D2A": "Scanmatic AS",
    "000D13": "Wilhelm Rutenbeck GmbH&Co.KG",
    "000D16": "UHS Systems Pty Ltd",
    "000D1F": "AV Digital",
    "000CE0": "Trek Diagnostics Inc.",
    "000CE2": "Rolls-Royce",
    "000CAA": "Cubic Transportation Systems Inc",
    "000CAC": "Citizen Watch Co.",
    "000CAE": "Ailocom Oy",
    "000C9E": "MemoryLink Corp.",
    "000C95": "PrimeNet",
    "000C9C": "Chongho information & communications",
    "000C97": "NV ADB TTV Technologies SA",
    "000C8F": "Nergal s.r.l.",
    "000C92": "WolfVision Gmbh",
    "000C93": "Xeline Co.",
    "000C7F": "synertronixx GmbH",
    "000CD1": "SFOM Technology Corp.",
    "000CD8": "M. K. Juchheim GmbH & Co",
    "000CCE": "Cisco Systems",
    "000CCF": "Cisco Systems",
    "000CC6": "Ka-Ro electronics GmbH",
    "000CC4": "Tiptel AG",
    "000CBA": "Jamex",
    "000C81": "Schneider Electric (Australia)",
    "000C80": "Opelcomm Inc.",
    "000C7D": "TEIKOKU ELECTRIC MFG. CO.",
    "000CB7": "Nanjing Huazhuo Electronics Co.",
    "000C76": "MICRO-STAR INTERNATIONAL CO.",
    "000C68": "SigmaTel",
    "000CAD": "BTU International",
    "000CA3": "Rancho Technology",
    "000C0E": "XtremeSpectrum",
    "000C12": "Micro-Optronic-Messtechnik GmbH",
    "000C10": "PNI Corporation",
    "000C0A": "Guangdong Province Electronic Technology Research Institute",
    "000C0B": "Broadbus Technologies",
    "000C07": "Iftest AG",
    "000C0C": "APPRO TECHNOLOGY INC.",
    "000BF9": "Gemstone Communications",
    "000BEA": "Zultys Technologies",
    "000BDD": "TOHOKU RICOH Co.",
    "000BE5": "HIMS International Corporation",
    "000C23": "Beijing Lanchuan Tech. Co.",
    "000C25": "Allied Telesis Labs",
    "000C18": "Zenisu Keisoku Inc.",
    "000C3A": "Oxance",
    "000C35": "KaVo Dental GmbH & Co. KG",
    "000C37": "Geomation",
    "000C40": "Altech Controls",
    "000C3E": "Crest Audio",
    "000C56": "Megatel Computer (1986) Corp.",
    "000C57": "MACKIE Engineering Services Belgium BVBA",
    "000C54": "Pedestal Networks",
    "000C4A": "Cygnus Microsystems (P) Limited",
    "000BFC": "Cisco Systems",
    "000BE9": "Actel Corporation",
    "000BE3": "Key Stream Co.",
    "000BE8": "AOIP",
    "000BDC": "AKCP",
    "000BD8": "Industrial Scientific Corp.",
    "000BD7": "DORMA Time + Access GmbH",
    "000B95": "eBet Gaming Systems Pty Ltd",
    "000B98": "NiceTechVision",
    "000B9E": "Yasing Technology Corp.",
    "000B88": "Vidisco ltd.",
    "000B8A": "MITEQ Inc.",
    "000B8C": "Flextronics",
    "000B90": "ADVA Optical Networking Ltd.",
    "000BC0": "China IWNComm Co.",
    "000BB0": "Sysnet Telematica srl",
    "000BB4": "RDC Semiconductor Inc.",
    "000BD1": "Aeronix",
    "000BD2": "Remopro Technology Inc.",
    "000BC7": "ICET S.p.A.",
    "000BB8": "Kihoku Electronic Co.",
    "000B75": "Iosoft Ltd.",
    "000B70": "Load Technology",
    "000B6F": "Media Streaming Networks Inc",
    "000B79": "X-COM",
    "000B87": "American Reliance Inc.",
    "000B63": "Kaleidescape",
    "000B68": "Addvalue Communications Pte Ltd",
    "000B58": "Astronautics C.A  LTD",
    "000B9F": "Neue ELSA GmbH",
    "000B0D": "Air2U",
    "000B0B": "Corrent Corporation",
    "000B08": "Pillar Data Systems",
    "000AFA": "Traverse Technologies Australia",
    "000AFC": "Core Tec Communications",
    "000B4B": "VISIOWAVE SA",
    "000B36": "Productivity Systems",
    "000B35": "Quad Bit System co.",
    "000B3F": "Anthology Solutions Inc.",
    "000AE1": "EG Technology",
    "000ADF": "Gennum Corporation",
    "000ADA": "Vindicator Technologies",
    "000AC9": "Zambeel Inc",
    "000B21": "G-Star Communications Inc.",
    "000B25": "Aeluros",
    "000B1A": "Industrial Defender",
    "000B15": "Platypus Technology",
    "000B18": "Private",
    "000B55": "ADInstruments",
    "000B54": "BiTMICRO Networks",
    "000AEC": "Koatsu Gas Kogyo Co.",
    "000AE7": "ELIOP S.A.",
    "000AE8": "Cathay Roxus Information Technology Co. LTD",
    "000ADD": "Allworx Corp.",
    "000B43": "Microscan Systems",
    "000B45": "Cisco Systems",
    "000B4C": "Clarion (M) Sdn Bhd",
    "000B3C": "Cygnal Integrated Products",
    "000B27": "Scion Corporation",
    "000AF1": "Clarity Design",
    "000AF3": "Cisco Systems",
    "000AC0": "Fuyoh Video Industry CO.",
    "000AAE": "Rosemount Process Analytical",
    "000AB3": "Fa. GIRA",
    "000ABA": "Arcon Technology Limited",
    "000AAF": "Pipal Systems",
    "000AB2": "Fresnel Wireless Systems",
    "000A9F": "Pannaway Technologies",
    "000A8F": "Aska International Inc.",
    "000AA0": "Cedar Point Communications",
    "000A8E": "Invacom Ltd",
    "000A99": "Calamp Wireless Networks Inc",
    "000A5D": "FingerTec Worldwide Sdn Bhd",
    "000A5C": "Carel s.p.a.",
    "000A5A": "GreenNET Technologies Co.",
    "000A56": "HITACHI Maxell Ltd.",
    "000A51": "GyroSignal Technology Co.",
    "000A53": "Intronics",
    "000A76": "Beida Jade Bird Huaguang Technology Co.",
    "000A60": "Autostar Technology Pte Ltd",
    "000AC1": "Futuretel",
    "000AC3": "eM Technics Co.",
    "000AC4": "Daewoo Teletech Co.",
    "000ABE": "OPNET Technologies CO.",
    "000AB6": "COMPUNETIX",
    "000AAA": "AltiGen Communications Inc.",
    "000A8D": "EUROTHERM LIMITED",
    "000A4A": "Targa Systems Ltd.",
    "000A39": "LoPA Information Technology",
    "000A37": "Procera Networks",
    "000A93": "W2 Networks",
    "000A89": "Creval Systems",
    "000A80": "Telkonet Inc.",
    "000A79": "corega K.K",
    "0009C7": "Movistec",
    "0009C9": "BlueWINC Co.",
    "0009D4": "Transtech Networks",
    "0009CB": "HBrain",
    "0009C5": "KINGENE Technology Corporation",
    "0009CD": "HUDSON SOFT CO.",
    "000A2C": "Active Tchnology Corporation",
    "000A2A": "QSI Systems Inc.",
    "000A1F": "ART WARE Telecommunication Co.",
    "0009F1": "Yamaki Electric Corporation",
    "0009F4": "Alcon Laboratories",
    "0009F5": "Emerson Network Power Co.",
    "0009EA": "YEM Inc.",
    "0009C0": "6WIND",
    "0009BF": "Nintendo Co.",
    "000A15": "Silicon Data",
    "000A1B": "Stream Labs",
    "000A1A": "Imerge Ltd",
    "000A0A": "SUNIX Co.",
    "000A05": "Widax Corp.",
    "000A04": "3Com Ltd",
    "0009E3": "Angel Iglesias S.A.",
    "0009D6": "KNC One GmbH",
    "000A34": "Identicard Systems Incorporated",
    "000A30": "Visteon Corporation",
    "000A2F": "Artnix Inc.",
    "00092F": "Akom Technology Corporation",
    "0009BA": "MAKU Informationstechik GmbH",
    "0009B4": "KISAN TELECOM CO.",
    "0009AE": "OKANO ELECTRIC CO.",
    "00095A": "RACEWOOD TECHNOLOGY",
    "000951": "Apogee Imaging Systems",
    "000971": "Time Management",
    "000974": "Innopia Technologies",
    "00094E": "BARTECH SYSTEMS INTERNATIONAL",
    "000947": "Aztek",
    "00093D": "Newisys",
    "00098B": "Entropic Communications",
    "00097E": "IMI TECHNOLOGY CO.",
    "000967": "Tachyon",
    "00096A": "Cloverleaf Communications Inc.",
    "000991": "Intelligent Platforms",
    "000996": "RDI",
    "000938": "Allot Communications",
    "00090C": "Mayekawa Mfg. Co. Ltd.",
    "00090D": "LEADER ELECTRONICS CORP.",
    "0008FE": "UNIK C&C Co.",
    "0008FF": "Trilogy Communications Ltd",
    "000904": "MONDIAL electronic",
    "0008A8": "Systec Co.",
    "0008A4": "Cisco Systems",
    "00091F": "A&D Co.",
    "000924": "Telebau GmbH",
    "000921": "Planmeca Oy",
    "000919": "MDS Gateways",
    "0008BF": "Aptus Elektronik AB",
    "0008B8": "E.F. Johnson",
    "0008BB": "NetExcell",
    "0008BE": "XENPAK MSA Group",
    "0008C1": "Avistar Communications Corporation",
    "0008C6": "Philips Consumer Communications",
    "000918": "SAMSUNG TECHWIN CO.",
    "000910": "Simple Access Inc.",
    "000914": "COMPUTROLS INC.",
    "0008EF": "DIBAL",
    "0008F0": "Next Generation Systems",
    "0008E9": "NextGig",
    "0008E7": "SHI ControlSystems",
    "0008D7": "HOW CORPORATION",
    "0008FC": "Gigaphoton Inc.",
    "000807": "Access Devices Limited",
    "0007FC": "Adept Systems Inc.",
    "0007E8": "EdgeWave",
    "0007EB": "Cisco Systems",
    "000865": "JASCOM CO.",
    "000864": "Fasy S.p.A.",
    "000860": "LodgeNet Entertainment Corp.",
    "000851": "Canadian Bank Note Company",
    "000859": "ShenZhen Unitone Electronics Co.",
    "00084E": "DivergeNet",
    "000819": "Banksys",
    "00081A": "Sanrad Intelligence Storage Communications (2000) Ltd.",
    "000810": "Key Technology",
    "000897": "Quake Technologies",
    "000890": "AVILINKS SA",
    "00088D": "Sigma-Links Inc.",
    "000825": "Acme Packet",
    "00081F": "Pou Yuen Tech Corp. Ltd.",
    "000884": "Index Braille AB",
    "08006B": "ACCEL TECHNOLOGIES INC.",
    "0007F5": "Bridgeco Co AG",
    "0007EC": "Cisco Systems",
    "0007DC": "Atek Co",
    "0007C6": "VDS Vosskuhler GmbH",
    "0007CC": "Kaba Benzing GmbH",
    "0007C0": "NetZerver Inc.",
    "0007BC": "Identix Inc.",
    "000756": "Juyoung Telecom",
    "00075A": "Air Products and Chemicals",
    "000748": "The Imaging Source Europe",
    "000746": "TURCK",
    "000741": "Sierra Automated Systems",
    "00079E": "Ilinx Co.",
    "0007A0": "e-Watch Inc.",
    "000794": "Simple Devices",
    "000797": "Netpower Co.",
    "00078C": "Elektronikspecialisten i Borlange AB",
    "000781": "Itron Inc.",
    "000788": "Clipcomm",
    "00076B": "Stralfors AB",
    "000768": "Danfoss A/S",
    "00075F": "VCS Video Communication Systems AG",
    "00075C": "Eastman Kodak Company",
    "000745": "Radlan Computer Communications Ltd.",
    "00073E": "China Great-Wall Computer Shenzhen Co.",
    "0007A9": "Novasonics",
    "0007A1": "VIASYS Healthcare GmbH",
    "0007B8": "Corvalent Corporation",
    "00077B": "Millimetrix Broadband Networks",
    "000769": "Italiana Macchi SpA",
    "000718": "iCanTek Co.",
    "000716": "J & S Marine Ltd.",
    "00071A": "Finedigital Inc.",
    "00071E": "Tri-M Engineering / Nupak Dev. Corp.",
    "000717": "Wieland Electric GmbH",
    "0006D9": "IPM-Net S.p.A.",
    "0006D3": "Alpha Telecom",
    "0006A4": "INNOWELL Corp.",
    "0006D6": "Cisco Systems",
    "000647": "Etrali S.A.",
    "0006CB": "Jotron Electronics A/S",
    "0006CD": "Leaf Imaging Ltd.",
    "000711": "Acterna",
    "00070A": "Unicom Automation Co.",
    "000709": "Westerstrand Urfabrik AB",
    "0006C7": "RFNET Technologies Pte Ltd (S)",
    "0006B9": "A5TEK Corp.",
    "000702": "Varex Imaging",
    "000705": "Endress & Hauser GmbH & Co",
    "00073B": "Tenovis GmbH & Co KG",
    "000731": "Ophir-Spiricon LLC",
    "00072B": "Jung Myung Telecom Co.",
    "0006FF": "Sheba Systems Co.",
    "0006EB": "Global Data",
    "0006E3": "Quantitative Imaging Corporation",
    "0006E4": "Citel Technologies Ltd.",
    "0006A1": "Celsian Technologies",
    "000663": "Human Technology Co.",
    "000665": "Sunny Giken",
    "000662": "MBM Technology Ltd.",
    "000669": "Datasound Laboratories Ltd",
    "00066E": "Delta Electronics",
    "00065A": "Strix Systems",
    "000695": "Ensure Technologies",
    "000691": "PT Inovacao",
    "000692": "Intruvert Networks",
    "00061A": "Zetari Inc.",
    "00061F": "Vision Components GmbH",
    "00061B": "Notebook Development Lab.  Lenovo Japan Ltd.",
    "00060F": "Narad Networks Inc",
    "000610": "Abeona Networks Inc",
    "000652": "Cisco Systems",
    "000656": "Tactel AB",
    "000641": "ITCN",
    "000648": "Seedsware",
    "0006AB": "W-Link Systems",
    "0006AC": "Intersoft Co.",
    "000694": "Mobillian Corporation",
    "000674": "Spectrum Control",
    "00068B": "AirRunner Technologies",
    "000687": "Omnitron Systems Technology",
    "00064C": "Invicta Networks",
    "000638": "Sungjin C&C Co.",
    "000635": "PacketAir Networks",
    "0005D5": "Speedcom Wireless",
    "0005D2": "DAP Technologies",
    "0005C5": "Flaga HF",
    "0005CA": "Hitron Technology",
    "0005C0": "Digital Network Alacarte Co.",
    "0005B8": "Electronic Design Associates",
    "0005BA": "Area Netwoeks",
    "00058B": "IPmental",
    "00057D": "Sun Communications",
    "000581": "Snell",
    "0005BF": "JustEzy Technology",
    "0005AC": "Northern Digital",
    "0005AD": "Topspin Communications",
    "0005B1": "ASB Technology BV",
    "000599": "DRS Test and Energy Management or DRS-TEM",
    "00059A": "Cisco Systems",
    "000611": "Zeus Wireless",
    "0005EC": "Mosaic Systems Inc.",
    "000602": "Cirkitech Electronics Co.",
    "0005AB": "Cyber Fone",
    "000592": "Pultek Corp.",
    "0005FB": "ShareGate",
    "0005F0": "SATEC",
    "0005D1": "Metavector Technologies",
    "0005FE": "Traficon N.V.",
    "000510": "Infinite Shanghai Communication Terminals Ltd.",
    "000501": "Cisco Systems",
    "000508": "Inetcam",
    "0004FF": "Acronet Co.",
    "000504": "Naray Information & Communication Enterprise",
    "000515": "Nuark Co.",
    "00051B": "Magic Control Technology Corporation",
    "000513": "VTLinx Multimedia Systems",
    "00050E": "3ware",
    "000586": "Lucent Technologies",
    "00057B": "Chung Nam Electronic Co.",
    "000571": "Seiwa Electronics Co.",
    "000570": "Baydel Ltd.",
    "000577": "SM Information & Communication",
    "000538": "Merilus",
    "000530": "Andiamo Systems",
    "00056E": "National Enhance Technology",
    "00056D": "Pacific Corporation",
    "00055C": "Kowa Company",
    "000549": "Salira Optical Network Systems",
    "00054C": "RF Innovations Pty Ltd",
    "000543": "IQ Wireless GmbH",
    "00051D": "Airocon",
    "000516": "SMART Modular Technologies",
    "00052B": "HORIBA",
    "000492": "Hive Internet",
    "00048C": "Nayna Networks",
    "000491": "Technovision",
    "000493": "Tsinghua Unisplendour Co.",
    "000494": "Breezecom",
    "0004E0": "Procket Networks",
    "0004DB": "Tellus Group Corp.",
    "0004DD": "Cisco Systems",
    "008086": "COMPUTER GENERATION INC.",
    "000489": "YAFO Networks",
    "00048A": "Temia Vertriebs GmbH",
    "000481": "Econolite Control Products",
    "000477": "Scalant Systems",
    "0004D7": "Omitec Instrumentation Ltd.",
    "0004D4": "Proview Electronics Co.",
    "0004CD": "Extenway Solutions Inc",
    "0004C0": "Cisco Systems",
    "0004BA": "KDD Media Will Corporation",
    "0004B6": "Stratex Networks",
    "0004B3": "Videotek",
    "0004E9": "Infiniswitch Corporation",
    "0004E8": "IER",
    "000509": "AVOC Nishimura Ltd.",
    "0004FB": "Commtech",
    "0004A4": "NetEnabled",
    "000439": "Rosco Entertainment Technology",
    "00043A": "Intelligent Telecommunications",
    "00043F": "ESTeem Wireless Modems",
    "000433": "Cyberboard A/S",
    "000434": "Accelent Systems",
    "00042D": "Sarian Systems",
    "000473": "Photonex Corporation",
    "000470": "ipUnplugged AB",
    "00046C": "Cyber Technology Co.",
    "000471": "IPrad",
    "00046E": "Cisco Systems",
    "000474": "LEGRAND",
    "000416": "Parks S/A Comunicacoes Digitais",
    "00040F": "Asus Network Technologies",
    "00040A": "Sage Systems",
    "000404": "Makino Milling Machine Co.",
    "000405": "ACN Technologies",
    "000401": "Osaki Electric Co.",
    "0003F4": "NetBurner",
    "0003F2": "Seneca Networks",
    "00042E": "Netous Technologies",
    "000425": "Atmel Corporation",
    "00041B": "Bridgeworks Ltd.",
    "0003E3": "Cisco Systems",
    "0003DB": "Apogee Electronics Corp.",
    "0003D2": "Crossbeam Systems",
    "0003F0": "Redfern Broadband Networks",
    "0003EB": "Atrica",
    "0003E7": "Logostek Co. Ltd.",
    "00044C": "JENOPTIK",
    "000444": "Western Multiplex Corporation",
    "00045D": "BEKA Elektronik",
    "000459": "Veristar Corporation",
    "0003B6": "QSI Corporation",
    "0003B1": "ICU Medical",
    "0003B3": "IA Link Systems Co.",
    "0003AD": "Emerson Energy Systems AB",
    "0003A7": "Unixtar Technology",
    "0003AE": "Allied Advanced Manufacturing Pte",
    "000363": "Miraesys Co.",
    "00035F": "Prüftechnik Condition Monitoring GmbH & Co. KG",
    "000360": "PAC Interactive Technology",
    "000361": "Widcomm",
    "000359": "DigitalSis",
    "000352": "Colubris Networks",
    "0003A3": "MAVIX",
    "0003A1": "HIPER Information & Communication",
    "000396": "EZ Cast Co.",
    "00039A": "SiConnect",
    "000394": "Connect One",
    "00038A": "America Online",
    "00038D": "PCS Revenue Control Systems",
    "000388": "Fastfame Technology Co.",
    "0003D0": "KOANKEISO Co.",
    "0003CF": "Muxcom",
    "0003D1": "Takaya Corporation",
    "00037E": "PORTech Communications",
    "000374": "Control Microsystems",
    "000376": "Graphtec Technology",
    "000378": "HUMAX Co.",
    "00036D": "Runtop",
    "00036E": "Nicon Systems (Pty) Limited",
    "000371": "Acomz Networks Corp.",
    "00034C": "Shanghai DigiVision Technology Co.",
    "000349": "Vidicode Datacommunicatie B.V.",
    "00033E": "Tateyama System Laboratory Co.",
    "00033C": "Daiden Co.",
    "00031F": "Condev Ltd.",
    "00029F": "L-3 Communication Aviation Recorders",
    "00031B": "Cellvision Systems",
    "00031C": "Svenska Hardvarufabriken AB",
    "0001A8": "Welltech Computer Co.",
    "000317": "Merlin Systems",
    "000318": "Cyras Systems",
    "00030C": "Telesoft Technologies Ltd.",
    "000308": "AM Communications",
    "000307": "Secure Works",
    "000306": "Fusion In Tech Co.",
    "0002FC": "Cisco Systems",
    "00029E": "Information Equipment Co.",
    "00029B": "Kreatel Communications AB",
    "000293": "Solid Data Systems",
    "00032A": "UniData Communication Systems",
    "000325": "Arima Computer Corp.",
    "0002FA": "DX Antenna Co.",
    "0002FB": "Baumuller Aulugen-Systemtechnik GmbH",
    "0002F6": "Equipe Communications",
    "000223": "ClickTV",
    "0002CB": "TriState Ltd.",
    "0002CA": "EndPoints",
    "0002C4": "OPT Machine Vision Tech Co.",
    "0002BF": "dotRocket",
    "0002E3": "LITE-ON Communications",
    "0002DD": "Bromax Communications",
    "0002A7": "Vivace Networks",
    "000272": "CC&C Technologies",
    "00026D": "Adept Telecom",
    "00026B": "BCM Computers Co.",
    "000266": "Thermalogic Corporation",
    "000268": "Harris Government Communications",
    "00025E": "High Technology Ltd",
    "000260": "Accordion Networks",
    "00012F": "Twinhead International Corp",
    "000247": "Great Dragon Information Technology (Group) Co.",
    "000243": "Raysis Co.",
    "000209": "Shenzhen SED Information Technology Co.",
    "000206": "Telital R&D Denmark A/S",
    "000202": "Amino Communications",
    "000201": "IFM Electronic gmbh",
    "009064": "Thomson Inc.",
    "00027A": "IOI Technology Corporation",
    "000274": "Tommy Technologies Corp.",
    "000289": "DNE Technologies",
    "000283": "Spectrum Controls",
    "000284": "UK Grid Solutions Limited",
    "000280": "Mu Net",
    "000231": "Ingersoll-Rand",
    "000234": "Imperial Technology",
    "000236": "INIT GmbH",
    "00022B": "SAXA",
    "000224": "C-COR",
    "00021F": "Aculab PLC",
    "00021A": "Zuma Networks",
    "000222": "Chromisys",
    "0001EF": "Camtel Technology Corp.",
    "000213": "S.D.E.L.",
    "00020A": "Gefran Spa",
    "0001D1": "CoNet Communications",
    "0001B2": "Digital Processing Systems",
    "0001B8": "Netsensity",
    "0001B9": "SKF (U.K.) Limited",
    "0001BD": "Peterson Electro-Musical Products",
    "0001B3": "Precision Electronic Manufacturing",
    "00014E": "WIN Enterprises",
    "003073": "International Microsystems",
    "00303F": "TurboComm Tech Inc.",
    "000195": "Sena Technologies",
    "000184": "SIEB & MEYER AG",
    "00018E": "Logitec Corporation",
    "000179": "WIRELESS TECHNOLOGY",
    "000160": "ELMEX Co.",
    "00016D": "CarrierComm Inc.",
    "00016A": "ALITEC",
    "00016F": "Inkel Corp.",
    "000170": "ESE Embedded System Engineer'g",
    "0001B7": "Centos",
    "0001B5": "Turin Networks",
    "00017E": "ADTEK System Science Co.",
    "000183": "ANITE TELECOMS",
    "0001DB": "Freecom Technologies GmbH",
    "0001DF": "ISDN Communications",
    "0001CA": "Geocast Network Systems",
    "0001A4": "Microlink Corporation",
    "00305C": "SMAR Laboratories Corp.",
    "003004": "LEADTEK RESEARCH INC.",
    "0030F9": "Sollae Systems Co.",
    "003002": "Expand Networks",
    "003078": "Cisco Systems",
    "00B0F5": "NetWorth Technologies",
    "00B0DB": "Nextcell",
    "00B0AE": "Symmetricom",
    "00B0E7": "British Federal Ltd.",
    "00B08E": "Cisco Systems",
    "000118": "EZ Digital Co.",
    "000128": "EnjoyWeb",
    "00011C": "Universal Talkware Corporation",
    "00010C": "System Talks Inc.",
    "000111": "iDigm Inc.",
    "000135": "KDC Corp.",
    "000141": "CABLE PRINT",
    "000146": "Tesco Controls",
    "000149": "TDT AG",
    "000165": "AirSwitch Corporation",
    "000156": "FIREWIREDIRECT.COM",
    "000153": "ARCHTEK TELECOM CORPORATION",
    "0030BE": "City-Net Technology",
    "003092": "Kontron Electronics AG",
    "000114": "KANDA TSUSHIN KOGYO CO.",
    "000107": "Leiser GmbH",
    "00010B": "Space CyberLink",
    "00B0DF": "Starboard Storage Systems",
    "000131": "Bosch Security Systems",
    "00307E": "Redflex Communication Systems",
    "00304F": "PLANET Technology Corporation",
    "003022": "Fong Kai Industrial Co.",
    "003070": "1Net Corporation",
    "0030F8": "Dynapro Systems",
    "0030E7": "CNF MOBILE SOLUTIONS",
    "003043": "IDREAM TECHNOLOGIES",
    "0030B4": "INTERSIL CORP.",
    "003056": "HMS Industrial Networks",
    "003050": "Versa Technology",
    "0030C0": "Lara Technology",
    "003005": "Fujitsu Siemens Computers",
    "00308F": "MICRILOR",
    "00309C": "Timing Applications",
    "003009": "Tachion Networks",
    "00307A": "Advanced Technology & Systems",
    "003061": "MobyTEL",
    "0030B1": "TrunkNet",
    "0030E0": "OXFORD SEMICONDUCTOR LTD.",
    "003064": "ADLINK TECHNOLOGY",
    "0030DB": "Mindready Solutions",
    "0030B3": "San Valley Systems",
    "0030C7": "Macromate Corp.",
    "0030E4": "CHIYODA SYSTEM RIKEN",
    "003066": "RFM",
    "003031": "LIGHTWAVE COMMUNICATIONS",
    "003060": "Powerfile",
    "0030A0": "TYCO SUBMARINE SYSTEMS",
    "003015": "CP CLARE CORP.",
    "003000": "ALLWELL TECHNOLOGY CORP.",
    "003011": "HMS Industrial Networks",
    "00304B": "ORBACOM SYSTEMS",
    "0030FA": "TELICA",
    "0030A5": "ACTIVE POWER",
    "003084": "ALLIED TELESYN INTERNAIONAL",
    "0030E9": "GMA COMMUNICATION MANUFACT'G",
    "003068": "CYBERNETICS TECH. CO.",
    "003091": "TAIWAN FIRST LINE ELEC. CORP.",
    "0030CD": "CONEXANT SYSTEMS",
    "00305B": "Toko Inc.",
    "003029": "OPICOM",
    "003083": "Ivron Systems",
    "0030B6": "Cisco Systems",
    "00D03E": "ROCKETCHIPS",
    "00D093": "TQ - COMPONENTS GMBH",
    "00D03F": "AMERICAN COMMUNICATION",
    "00D0F9": "ACUTE COMMUNICATIONS CORP.",
    "00D0F7": "NEXT NETS CORPORATION",
    "00D044": "ALIDIAN NETWORKS",
    "00D018": "QWES. COM",
    "00D077": "LUCENT TECHNOLOGIES",
    "00D028": "Harmonic",
    "00D025": "XROSSTECH",
    "00D007": "MIC ASSOCIATES",
    "00D0FF": "Cisco Systems",
    "00D05B": "ACROLOOP MOTION CONTROL",
    "00D042": "MAHLO GMBH & CO. UG",
    "00D031": "INDUSTRIAL LOGIC CORPORATION",
    "00D038": "FIVEMERE",
    "00D0C6": "THOMAS & BETTS CORP.",
    "0001A7": "UNEX TECHNOLOGY CORPORATION",
    "00D0A9": "SHINANO KENSHI CO.",
    "00D0DD": "SUNRISE TELECOM",
    "00D0E6": "IBOND INC.",
    "00D0D1": "Sycamore Networks",
    "00D087": "MICROFIRST INC.",
    "00D091": "SMARTSAN SYSTEMS",
    "00D040": "SYSMATE CO.",
    "00D08C": "GENOA TECHNOLOGY",
    "00D059": "AMBIT MICROSYSTEMS CORP.",
    "00D0FD": "OPTIMA TELE.COM",
    "00D027": "APPLIED AUTOMATION",
    "00D080": "EXABYTE CORPORATION",
    "00D04E": "LOGIBAG",
    "00D02C": "CAMPBELL SCIENTIFIC",
    "00D0CD": "ATAN TECHNOLOGY INC.",
    "00D0A6": "LANBIRD TECHNOLOGY CO.",
    "00D049": "IMPRESSTEK CO.",
    "00D003": "COMDA ENTERPRISES CORP.",
    "00D0D2": "EPILOG CORPORATION",
    "00D06F": "KMC CONTROLS",
    "00D089": "DYNACOLOR",
    "00D072": "BROADLOGIC",
    "00D0E2": "MRT MICRO",
    "00D01A": "URMET  TLC S.P.A.",
    "00D06A": "LINKUP SYSTEMS CORPORATION",
    "0050F9": "Sensormatic Electronics LLC",
    "005048": "INFOLIBRIA",
    "00504E": "SIERRA MONITOR CORP.",
    "0050D7": "TELSTRAT",
    "0050F6": "PAN-INTERNATIONAL INDUSTRIAL CORP.",
    "0050E6": "HAKUSAN CORPORATION",
    "00503C": "TSINGHUA NOVEL ELECTRONICS",
    "005060": "TANDBERG TELECOM AS",
    "0050EE": "TEK DIGITEL CORPORATION",
    "0050FF": "HAKKO ELECTRONICS CO.",
    "0050D2": "CMC Electronics Inc",
    "005068": "ELECTRONIC INDUSTRIES ASSOCIATION",
    "00501C": "JATOM SYSTEMS",
    "00507A": "XPEED",
    "00502E": "CAMBEX CORPORATION",
    "00506E": "CORDER ENGINEERING CORPORATION",
    "00502C": "SOYO COMPUTER",
    "00D0CC": "TECHNOLOGIES LYRE INC.",
    "005077": "PROLIFIC TECHNOLOGY",
    "00506C": "Beijer Electronics Products AB",
    "005044": "ASACA CORPORATION",
    "00500E": "CHROMATIS NETWORKS",
    "005033": "MAYAN NETWORKS",
    "005045": "RIOWORKS SOLUTIONS",
    "00502B": "GENRAD LTD.",
    "0050EC": "OLICOM A/S",
    "0050C9": "MASPRO DENKOH CORP.",
    "005069": "PixStream Incorporated",
    "00504F": "OLENCOM ELECTRONICS",
    "0050C0": "GATAN",
    "005051": "IWATSU ELECTRIC CO.",
    "0050BB": "CMS TECHNOLOGIES",
    "005062": "KOUWELL ELECTRONICS CORP.  **",
    "0050D5": "AD SYSTEMS CORP.",
    "0050F3": "GLOBAL NET INFORMATION CO.",
    "0050BE": "FAST MULTIMEDIA AG",
    "00506F": "G-CONNECT",
    "005007": "SIEMENS TELECOMMUNICATION SYSTEMS LIMITED",
    "005022": "ZONET TECHNOLOGY",
    "005040": "Panasonic Electric Works Co.",
    "0050F8": "ENTREGA TECHNOLOGIES",
    "005042": "SCI MANUFACTURING SINGAPORE PTE",
    "0050EB": "ALPHA-TOP CORPORATION",
    "0050EF": "SPE Systemhaus GmbH",
    "005098": "GLOBALOOP",
    "0050BC": "HAMMER STORAGE SOLUTIONS",
    "009071": "Applied Innovation Inc.",
    "009018": "ITO ELECTRIC INDUSTRY CO",
    "0090CD": "ENT-EMPRESA NACIONAL DE TELECOMMUNICACOES",
    "0090D0": "Thomson Telecom Belgium",
    "00909B": "MARKEM-IMAJE",
    "009022": "IVEX",
    "009016": "ZAC",
    "0090FF": "TELLUS TECHNOLOGY INC.",
    "00903E": "N.V. PHILIPS INDUSTRIAL ACTIVITIES",
    "0090BA": "VALID NETWORKS",
    "00507D": "IFP",
    "005097": "MMC-EMBEDDED COMPUTERTECHNIK GmbH",
    "005010": "NovaNET Learning",
    "00509A": "TAG ELECTRONIC SYSTEMS",
    "0090D1": "LEICHU ENTERPRISE CO.",
    "009046": "DEXDYNE",
    "0090DA": "DYNARC",
    "0090E0": "SYSTRAN CORP.",
    "009094": "OSPREY TECHNOLOGIES",
    "0090B3": "AGRANAT SYSTEMS",
    "00905D": "NETCOM SICHERHEITSTECHNIK GMBH",
    "0090FB": "PORTWELL",
    "00904F": "ABB POWER T&D COMPANY",
    "009060": "SYSTEM CREATE CORP.",
    "009013": "SAMSAN CORP.",
    "009085": "GOLDEN ENTERPRISES",
    "0090DC": "TECO INFORMATION SYSTEMS",
    "0090E2": "DISTRIBUTED PROCESSING TECHNOLOGY",
    "0010A3": "OMNITRONIX",
    "0010AD": "SOFTRONICS USB",
    "0010A7": "UNEX TECHNOLOGY CORPORATION",
    "0010D5": "IMASDE CANARIAS",
    "001055": "FUJITSU MICROELECTRONICS",
    "001052": "METTLER-TOLEDO (ALBSTADT) GMBH",
    "0090C7": "ICOM INC.",
    "009035": "ALPHA TELECOM",
    "0090F0": "Harmonic Video Systems Ltd.",
    "00907A": "Spectralink",
    "009020": "PHILIPS ANALYTICAL X-RAY B.V.",
    "00900F": "KAWASAKI HEAVY INDUSTRIES",
    "0090EA": "ALPHA TECHNOLOGIES",
    "009077": "ADVANCED FIBRE COMMUNICATIONS",
    "009099": "ALLIED TELESIS",
    "0090A7": "CLIENTEC CORPORATION",
    "00905C": "EDMI",
    "0090E3": "AVEX ELECTRONICS INC.",
    "0090A9": "WESTERN DIGITAL",
    "00903C": "ATLANTIC NETWORK SYSTEMS",
    "009055": "PARKER HANNIFIN CORPORATION COMPUMOTOR DIVISION",
    "0090F3": "ASPECT COMMUNICATIONS",
    "009053": "DAEWOO ELECTRONICS CO.",
    "00105D": "Draeger Medical",
    "00102D": "HITACHI SOFTWARE ENGINEERING",
    "001033": "ACCESSLAN COMMUNICATIONS",
    "001012": "PROCESSOR SYSTEMS (I) PVT LTD",
    "001015": "OOmon Inc.",
    "00106B": "SONUS NETWORKS",
    "0010C3": "CSI-CONTROL SYSTEMS",
    "001078": "NUERA COMMUNICATIONS",
    "0010DD": "ENABLE SEMICONDUCTOR",
    "00107A": "AmbiCom",
    "0010B9": "MAXTOR CORP.",
    "001091": "NO WIRES NEEDED BV",
    "001051": "CMICRO CORPORATION",
    "001037": "CYQ've Technology Co.",
    "00101B": "CORNET TECHNOLOGY",
    "0010DC": "MICRO-STAR INTERNATIONAL CO.",
    "00100A": "WILLIAMS COMMUNICATIONS GROUP",
    "001032": "ALTA TECHNOLOGY",
    "001080": "METAWAVE COMMUNICATIONS",
    "0010F4": "Vertical Communications",
    "001077": "SAF DRIVE SYSTEMS",
    "0010B3": "NOKIA MULTIMEDIA TERMINALS",
    "00101E": "MATSUSHITA ELECTRONIC INSTRUMENTS CORP.",
    "00104D": "SURTEC INDUSTRIES",
    "00E06E": "FAR SYSTEMS S.p.A.",
    "00E06D": "COMPUWARE CORPORATION",
    "00E0BB": "NBX CORPORATION",
    "00E08A": "GEC AVERY",
    "00E07F": "LOGISTISTEM s.r.l.",
    "00E013": "EASTERN ELECTRONIC CO.",
    "00E086": "Emerson Network Power",
    "00E01B": "SPHERE COMMUNICATIONS",
    "00E0FD": "A-TREND TECHNOLOGY CO.",
    "00E0BD": "INTERFACE SYSTEMS",
    "00E038": "PROXIMA CORPORATION",
    "00E09C": "MII",
    "00E0E9": "DATA LABS",
    "00E00C": "MOTOROLA",
    "00E00A": "DIBA",
    "00E0C4": "HORNER ELECTRIC",
    "00E0C5": "BCOM ELECTRONICS INC.",
    "00E0EE": "MAREL HF",
    "00E08E": "UTSTARCOM",
    "00E03F": "JATON CORPORATION",
    "00E0D4": "EXCELLENT COMPUTER",
    "00E0E8": "GRETACODER Data Systems AG",
    "00E016": "RAPID CITY COMMUNICATIONS",
    "00E0EA": "INNOVAT COMMUNICATIONS",
    "00E064": "SAMSUNG ELECTRONICS",
    "00E069": "JAYCOR",
    "00E0A4": "ESAOTE S.p.A.",
    "00E0DE": "DATAX NV",
    "00E005": "TECHNICAL CORP.",
    "00E0C1": "MEMOREX TELEX JAPAN",
    "00E084": "COMPULITE R&D",
    "00E0A5": "ComCore Semiconductor",
    "00E015": "HEIWA CORPORATION",
    "00E096": "SHIMADZU CORPORATION",
    "00E017": "EXXACT GmbH",
    "00E0C9": "AutomatedLogic Corporation",
    "00E0A9": "FUNAI ELECTRIC CO.",
    "00607F": "AURORA TECHNOLOGIES",
    "00E029": "STANDARD MICROSYSTEMS CORP.",
    "0060A5": "PERFORMANCE TELECOM CORP.",
    "0060A1": "VPNet",
    "006027": "Superior Modular Products",
    "0060BC": "KeunYoung Electronics & Communication Co.",
    "006061": "WHISTLE COMMUNICATIONS CORP.",
    "006074": "QSC LLC",
    "006076": "SCHLUMBERGER TECHNOLOGIES RETAIL PETROLEUM SYSTEMS",
    "0060EA": "StreamLogic",
    "006029": "CARY PERIPHERALS INC.",
    "0060FC": "CONSERVATION THROUGH INNOVATION LTD.",
    "006018": "STELLAR ONE CORPORATION",
    "0060F9": "DIAMOND LANE COMMUNICATIONS",
    "0060B6": "LAND COMPUTER CO.",
    "00606C": "ARESCOM",
    "00601B": "MESA ELECTRONICS",
    "00602E": "CYCLADES CORPORATION",
    "0060E3": "ARBIN INSTRUMENTS",
    "006071": "MIDAS LAB",
    "0060D4": "ELDAT COMMUNICATION LTD.",
    "0060A4": "GEW Technologies (PTY)Ltd",
    "006064": "NETCOMM LIMITED",
    "0060C5": "ANCOT CORP.",
    "0060A9": "GESYTEC MBH",
    "0060F2": "LASERGRAPHICS",
    "0060C3": "NETVISION CORPORATION",
    "00A05A": "KOFAX IMAGE PRODUCTS",
    "00A052": "STANILITE ELECTRONICS PTY. LTD",
    "00A05E": "MYRIAD LOGIC INC.",
    "00A095": "ACACIA NETWORKS",
    "00A0F2": "INFOTEK COMMUNICATIONS",
    "00A053": "COMPACT DEVICES",
    "00A069": "Symmetricom",
    "00A07A": "ADVANCED PERIPHERALS TECHNOLOGIES",
    "00A04E": "VOELKER TECHNOLOGIES",
    "006082": "NOVALINK TECHNOLOGIES",
    "0060E7": "RANDATA",
    "006054": "CONTROLWARE GMBH",
    "0060C2": "MPL AG",
    "00609B": "AstroNova",
    "0060DB": "NTP ELEKTRONIK A/S",
    "006052": "PERIPHERALS ENTERPRISE CO.",
    "00A0DF": "STS TECHNOLOGIES",
    "00A094": "COMSAT CORPORATION",
    "00A0EF": "LUCIDATA LTD.",
    "0060B2": "PROCESS CONTROL CORP.",
    "006081": "TV/COM INTERNATIONAL",
    "00A005": "DANIEL INSTRUMENTS",
    "0060D9": "TRANSYS NETWORKS INC.",
    "00601F": "STALLION TECHNOLOGIES",
    "00600A": "SORD COMPUTER CORPORATION",
    "0060A8": "TIDOMAT AB",
    "00A066": "ISA CO.",
    "00A0AB": "NETCS INFORMATIONSTECHNIK GMBH",
    "00A0D8": "SPECTRA - TEK",
    "00A080": "Tattile SRL",
    "00A02B": "TRANSITIONS RESEARCH CORP.",
    "00A0E8": "REUTERS HOLDINGS PLC",
    "00A008": "NETCORP",
    "00A0FD": "SCITEX DIGITAL PRINTING",
    "00A00F": "Broadband Technologies",
    "00A002": "LEEDS & NORTHRUP AUSTRALIA PTY LTD",
    "00A0E4": "OPTIQUEST",
    "00A0EE": "NASHOBA NETWORKS",
    "00A0DD": "AZONIX CORPORATION",
    "00A0C3": "UNICOMPUTER GMBH",
    "00A00A": "Airspan",
    "00A067": "NETWORK SERVICES GROUP",
    "00A0E0": "TENNYSON TECHNOLOGIES PTY LTD",
    "00A099": "K-NET LTD.",
    "00A0EC": "TRANSMITTON LTD.",
    "00A028": "CONNER PERIPHERALS",
    "00A09E": "ICTV",
    "00A020": "CITICORP/TTI",
    "00A0FA": "Marconi Communication GmbH",
    "00A0CB": "ARK TELECOMMUNICATIONS",
    "00A050": "CYPRESS SEMICONDUCTOR",
    "00A0CE": "Ecessa",
    "00A009": "WHITETREE NETWORK",
    "00A00C": "KINGMAX TECHNOLOGY",
    "00A0BB": "HILAN GMBH",
    "00A091": "APPLICOM INTERNATIONAL",
    "00A0A5": "TEKNOR MICROSYSTEME",
    "002086": "MICROTECH ELECTRONICS LIMITED",
    "002023": "T.C. TECHNOLOGIES PTY. LTD",
    "0020B2": "GKD Gesellschaft Fur Kommunikation Und Datentechnik",
    "002052": "RAGULA SYSTEMS",
    "0020FE": "TOPWARE INC. / GRAND COMPUTER",
    "002073": "FUSION SYSTEMS CORPORATION",
    "0020B7": "NAMAQUA COMPUTERWARE",
    "0020E3": "MCD KENCOM CORPORATION",
    "002013": "DIVERSIFIED TECHNOLOGY",
    "0020AB": "MICRO INDUSTRIES CORP.",
    "00A025": "REDCOM LABS INC.",
    "00A0A2": "B810 S.R.L.",
    "00A017": "J B M CORPORATION",
    "00A034": "AXEL",
    "00A001": "DRS Signal Solutions",
    "00A075": "MICRON TECHNOLOGY",
    "00208D": "CMD TECHNOLOGY",
    "0020DD": "Cybertec Pty Ltd",
    "0020E6": "LIDKOPING MACHINE TOOLS AB",
    "00A054": "Private",
    "00A0E7": "CENTRAL DATA CORPORATION",
    "002026": "AMKLY SYSTEMS",
    "002065": "SUPERNET NETWORKING INC.",
    "002019": "OHLER GMBH",
    "00209E": "BROWN'S OPERATING SYSTEM SERVICES",
    "002035": "IBM Corp",
    "00207A": "WiSE Communications",
    "00203E": "LogiCan Technologies",
    "002058": "ALLIED SIGNAL INC.",
    "00208E": "CHEVIN SOFTWARE ENG. LTD.",
    "00209B": "ERSAT ELECTRONIC GMBH",
    "00201C": "EXCEL",
    "00207F": "KYOEI SANGYO CO.",
    "00205A": "COMPUTER IDENTICS",
    "002000": "LEXMARK INTERNATIONAL",
    "00201D": "KATANA PRODUCTS",
    "002046": "CIPRICO",
    "00205B": "Kentrox",
    "0020D3": "OST (OUEST STANDARD TELEMATIQU",
    "0020F6": "NET TEK  AND KARLNET",
    "0020B0": "GATEWAY DEVICES",
    "00202A": "N.V. DZINE",
    "002083": "PRESTICOM INCORPORATED",
    "0020C9": "VICTRON BV",
    "002077": "KARDIOS SYSTEMS CORP.",
    "002097": "APPLIED SIGNAL TECHNOLOGY",
    "00C0C9": "ELSAG BAILEY PROCESS",
    "00C048": "BAY TECHNICAL ASSOCIATES",
    "00C00E": "PSITECH",
    "00C031": "DESIGN RESEARCH SYSTEMS",
    "000701": "RACAL-DATACOM",
    "00C09C": "HIOKI E.E. CORPORATION",
    "002008": "CABLE & COMPUTER TECHNOLOGY",
    "00C00B": "NORCONTROL A.S.",
    "00C0FD": "PROSUM",
    "00C076": "I-DATA INTERNATIONAL A-S",
    "00C046": "Blue Chip Technology Ltd",
    "00C014": "TELEMATICS CALABASAS INT'L",
    "00AA3C": "OLIVETTI TELECOM SPA (OLTECO)",
    "00C011": "INTERACTIVE COMPUTING DEVICES",
    "00C03E": "FA. GEBR. HELLER GMBH",
    "00C060": "ID SCANDINAVIA AS",
    "0020C6": "NECTEC",
    "00C09E": "CACHE COMPUTERS",
    "00C0AC": "GAMBIT COMPUTER COMMUNICATIONS",
    "00C034": "TRANSACTION NETWORK",
    "00C093": "ALTA RESEARCH CORP.",
    "00C02C": "CENTRUM COMMUNICATIONS",
    "0040E7": "ARNOS INSTRUMENTS & COMPUTER",
    "004087": "UBITREX CORPORATION",
    "004007": "TELMAT INFORMATIQUE",
    "00407B": "SCIENTIFIC ATLANTA",
    "00402C": "ISIS DISTRIBUTED SYSTEMS",
    "0040CC": "SILCOM MANUF'G TECHNOLOGY INC.",
    "00C054": "NETWORK PERIPHERALS",
    "00C022": "LASERMASTER TECHNOLOGIES",
    "00C025": "DATAPRODUCTS CORPORATION",
    "00C0DF": "KYE Systems Corp.",
    "00C0F5": "METACOMP",
    "00C091": "JABIL CIRCUIT",
    "00C049": "U.S. ROBOTICS",
    "00C09D": "DISTRIBUTED SYSTEMS INT'L",
    "00C0E9": "OAK SOLUTIONS",
    "00C0C5": "SID INFORMATICA",
    "00C051": "ADVANCED INTEGRATION RESEARCH",
    "00C085": "ELECTRONICS FOR IMAGING",
    "00C066": "DOCUPOINT",
    "00C02D": "FUJI PHOTO FILM CO.",
    "00C0BD": "INEX TECHNOLOGIES",
    "00C088": "EKF ELEKTRONIK GMBH",
    "00C097": "ARCHIPEL SA",
    "00C004": "JAPAN BUSINESS COMPUTER CO.LTD",
    "00C0AA": "SILICON VALLEY COMPUTER",
    "00C0B2": "NORAND CORPORATION",
    "00C0FB": "ADVANCED TECHNOLOGY LABS",
    "0040CF": "STRAWBERRY TREE",
    "004077": "MAXTON TECHNOLOGY CORPORATION",
    "00C02B": "GERLOFF GESELLSCHAFT FUR",
    "00405B": "FUNASSET LIMITED",
    "004012": "WINDATA",
    "0040D5": "Sartorius Mechatronics T&H GmbH",
    "0040BF": "CHANNEL SYSTEMS INTERN'L INC.",
    "00401E": "ICC",
    "00409A": "NETWORK EXPRESS",
    "004094": "SHOGRAPHICS",
    "0040E2": "MESA RIDGE TECHNOLOGIES",
    "0040C4": "KINKEI SYSTEM CORPORATION",
    "004022": "KLEVER COMPUTERS",
    "004074": "CABLE AND WIRELESS",
    "0040B8": "IDEA ASSOCIATES",
    "0040E8": "CHARLES RIVER DATA SYSTEMS",
    "0040C0": "VISTA CONTROLS CORPORATION",
    "00C010": "HIRAKAWA HEWTECH CORP.",
    "00C037": "DYNATEM",
    "004083": "TDA INDUSTRIA DE PRODUTOS",
    "00405D": "STAR-TEK",
    "004008": "A PLUS INFO CORPORATION",
    "0040B5": "VIDEO TECHNOLOGY COMPUTERS LTD",
    "004073": "BASS ASSOCIATES",
    "00407D": "EXTENSION TECHNOLOGY CORP.",
    "00404D": "TELECOMMUNICATIONS TECHNIQUES",
    "00400D": "LANNET DATA COMMUNICATIONS",
    "0080D7": "Fantum Engineering",
    "00807A": "AITECH SYSTEMS LTD.",
    "0080DC": "PICKER INTERNATIONAL",
    "00C0A0": "ADVANCE MICRO RESEARCH",
    "004019": "AEON SYSTEMS",
    "0040BE": "BOEING DEFENSE & SPACE",
    "00406E": "COROLLARY",
    "004076": "Sun Conversion Technologies",
    "004028": "NETCOMM LIMITED",
    "0040CB": "LANWAN TECHNOLOGIES",
    "0040B2": "SYSTEMFORSCHUNG",
    "0040E6": "C.A.E.N.",
    "004010": "SONIC SYSTEMS",
    "0040CA": "FIRST INTERNAT'L COMPUTER",
    "00408B": "RAYLAN CORPORATION",
    "0040EF": "HYPERCOM",
    "004093": "PAXDATA NETWORKS LTD.",
    "004085": "SAAB INSTRUMENTS AB",
    "004023": "LOGIC CORPORATION",
    "0040F0": "MicroBrain",
    "004089": "MEIDENSHA CORPORATION",
    "004055": "METRONIX GMBH",
    "004027": "SMC MASSACHUSETTS",
    "004045": "TWINHEAD CORPORATION",
    "0040A4": "ROSE ELECTRONICS",
    "008080": "DATAMEDIA CORPORATION",
    "008082": "PEP MODULAR COMPUTERS GMBH",
    "008071": "SAI TECHNOLOGY",
    "008098": "TDK CORPORATION",
    "00803F": "TATUNG COMPANY",
    "0080E6": "PEER NETWORKS",
    "0080E0": "XTP SYSTEMS",
    "00802B": "INTEGRATED MARKETING CO",
    "004015": "ASCOM INFRASYS AG",
    "008056": "SPHINX Electronics GmbH & Co KG",
    "008031": "BASYS",
    "00803A": "VARITYPER",
    "008088": "VICTOR COMPANY OF JAPAN",
    "008001": "PERIPHONICS CORPORATION",
    "008097": "CENTRALP AUTOMATISMES",
    "008041": "VEB KOMBINAT ROBOTRON",
    "00801C": "NEWPORT SYSTEMS SOLUTIONS",
    "008095": "BASIC MERTON HANDELSGES.M.B.H.",
    "0080AE": "HUGHES NETWORK SYSTEMS",
    "0080DB": "GRAPHON CORPORATION",
    "0080D8": "NETWORK PERIPHERALS INC.",
    "00809E": "DATUS GMBH",
    "008013": "THOMAS-CONRAD CORPORATION",
    "00806E": "NIPPON STEEL CORPORATION",
    "008010": "COMMODORE INTERNATIONAL",
    "0080D5": "CADRE TECHNOLOGIES",
    "00801B": "KODIAK TECHNOLOGY",
    "0080D3": "SHIVA CORP.",
    "0080B3": "AVAL DATA CORPORATION",
    "008045": "MATSUSHITA ELECTRIC IND. CO",
    "008020": "NETWORK PRODUCTS",
    "008070": "COMPUTADORAS MICRON",
    "008008": "DYNATECH COMPUTER SYSTEMS",
    "0000E4": "IN2 GROUPE INTERTECHNIQUE",
    "008039": "ALCATEL STC AUSTRALIA",
    "008023": "INTEGRATED BUSINESS NETWORKS",
    "00806B": "SCHMID TELECOMMUNICATION",
    "008059": "STANLEY ELECTRIC CO.",
    "0080CA": "NETCOM RESEARCH INCORPORATED",
    "000094": "ASANTE TECHNOLOGIES",
    "000090": "MICROCOM",
    "000047": "NICOLET INSTRUMENTS CORP.",
    "000070": "HCL LIMITED",
    "00008F": "Raytheon",
    "0080A1": "MICROTEST",
    "0080A9": "CLEARPOINT RESEARCH",
    "0080F9": "HEURIKON CORPORATION",
    "008047": "IN-NET CORP.",
    "008067": "SQUARE D COMPANY",
    "0080BF": "TAKAOKA ELECTRIC MFG. CO. LTD.",
    "008017": "PFU LIMITED",
    "0080F8": "MIZAR",
    "0000A1": "MARQUETTE ELECTRIC CO.",
    "0000F5": "DIAMOND SALES LIMITED",
    "00005C": "TELEMATICS INTERNATIONAL INC.",
    "0000AC": "CONWARE COMPUTER CONSULTING",
    "000026": "SHA-KEN CO.",
    "0000B6": "MICRO-MATIC RESEARCH",
    "000082": "LECTRA SYSTEMES SA",
    "00002B": "CRISP AUTOMATION",
    "000014": "NETRONIX",
    "000072": "MINIWARE TECHNOLOGY",
    "000046": "OLIVETTI NORTH AMERICA",
    "00008D": "Cryptek Inc.",
    "00003B": "i Controls",
    "000098": "CROSSCOMM CORPORATION",
    "0000C6": "EON SYSTEMS",
    "00008B": "INFOTRON",
    "000074": "RICOH COMPANY LTD.",
    "000035": "SPECTRAGRAPHICS CORPORATION",
    "000021": "SUREMAN COMP. & COMMUN. CORP.",
    "000051": "HOB ELECTRONIC GMBH & CO. KG",
    "0000A7": "NETWORK COMPUTING DEVICES INC.",
    "000030": "VG LABORATORY SYSTEMS LTD",
    "000020": "DATAINDUSTRIER DIAB AB",
    "00007A": "DANA COMPUTER INC.",
    "000045": "FORD AEROSPACE & COMM. CORP.",
    "00009C": "ROLM MIL-SPEC COMPUTERS",
    "00007C": "AMPERE INCORPORATED",
    "080071": "MATRA (DSIE)",
    "08006C": "SUNTEK TECHNOLOGY INT'L",
    "080067": "ComDesign",
    "08005D": "GOULD INC.",
    "08005B": "VTA TECHNOLOGIES INC.",
    "000068": "ROSEMOUNT CONTROLS",
    "0000E9": "ISICAD",
    "00009F": "AMERISTAR TECHNOLOGIES INC.",
    "0000E3": "INTEGRATED MICRO PRODUCTS LTD",
    "0000AD": "BRUKER INSTRUMENTS INC.",
    "0000D3": "WANG LABORATORIES INC.",
    "0000D0": "DEVELCON ELECTRONICS LTD.",
    "000093": "PROTEON INC.",
    "080057": "Evans & Sutherland",
    "080081": "ASTECH INC.",
    "0000B3": "CIMLINC INCORPORATED",
    "08008C": "NETWORK RESEARCH CORPORATION",
    "0000F1": "MAGNA COMPUTER CORPORATION",
    "000054": "Schneider Electric",
    "040AE0": "XMIT AG COMPUTER NETWORKS",
    "00DD00": "UNGERMANN-BASS INC.",
    "0000AA": "XEROX CORPORATION",
    "080011": "TEKTRONIX INC.",
    "080017": "NATIONAL SEMICONDUCTOR",
    "08001D": "ABLE COMMUNICATIONS INC.",
    "00DD0B": "UNGERMANN-BASS INC.",
    "08002D": "LAN-TEC INC.",
    "080026": "NORSK DATA A.S.",
    "080025": "CONTROL DATA",
    "100000": "Private",
    "0000D7": "DARTMOUTH COLLEGE",
    "F809A4": "Henan Thinker Rail Transportation Research Inc.",
    "080003": "ADVANCED COMPUTER COMM.",
    "00DD0F": "UNGERMANN-BASS INC.",
    "000001": "XEROX CORPORATION",
    "00DD03": "UNGERMANN-BASS INC.",
    "AA0004": "DIGITAL EQUIPMENT CORPORATION",
    "08000C": "MIKLYN DEVELOPMENT CO.",
    "00DD05": "UNGERMANN-BASS INC.",
    "A842A1": "TP-Link Corporation Limited",
    "9CF55F": "Harman/Becker Automotive Systems GmbH",
    "902C09": "Apple",
    "A0B40F": "Apple",
    "48D017": "Telecom Infra Project",
    "EC0D51": "Apple",
    "ACDFA1": "Apple",
    "C8CCB5": "Hunter Douglas",
    "C05F87": "Legrand INTELLIGENT ELECTRICAL(HUIZHOU)CO.",
    "807C0A": "zte corporation",
    "48836F": "EM Microelectronic",
    "F4832C": "OHSUNG",
    "685210": "MCS Logic",
    "A87C45": "HUAWEI TECHNOLOGIES CO.",
    "2CEDB0": "HUAWEI TECHNOLOGIES CO.",
    "2C693E": "HUAWEI TECHNOLOGIES CO.",
    "14DAB9": "Huawei Device Co.",
    "B0CAE7": "Huawei Device Co.",
    "DC621F": "HUAWEI TECHNOLOGIES CO.",
    "48EDE6": "Zyxel Communications Corporation",
    "70BDD2": "Adva Network Security GmbH",
    "A410B6": "Cisco Systems",
    "C84709": "Cisco Systems",
    "00D598": "BOPEL MOBILE TECHNOLOGY CO.",
    "904528": "Nintendo Co.",
    "F45246": "ASKEY COMPUTER CORP",
    "3C25F8": "Dell Inc.",
    "000324": "LIMNO Co.",
    "D00B27": "Murata Manufacturing Co.",
    "4C5739": "Samsung Electronics Co.",
    "6C1629": "Edifier International",
    "F037CF": "Huawei Device Co.",
    "2CC8F5": "Huawei Device Co.",
    "48E533": "Sunnovo International Limited",
    "F0FDDD": "Foxtron Vehicle Technologies Co.",
    "AC361B": "Hon Hai Precision Industry Co.",
    "B8060D": "Tuya Smart Inc.",
    "C8E193": "ITEL MOBILE LIMITED",
    "D4A23D": "New H3C Technologies Co.",
    "D8132A": "Espressif Inc.",
    "9C1ECE": "ALT Co.",
    "001F9C": "Havis Inc.",
    "806599": "Espressif Inc.",
    "BC9A8E": "HUMAX NETWORKS",
    "502065": "Quectel Wireless Solutions Co.",
    "FC478D": "SHENZHEN TOPWELL TECHNOLOGY CO.",
    "28CB5C": "Shenzhen CPETEK Technology Co.",
    "D05BCB": "Tianyi Telecom Terminals Company Limited",
    "00C0F2": "Lantronix",
    "A0004C": "HISENSE VISUAL TECHNOLOGY CO.",
    "E4AAE4": "Xiaomi Communications Co Ltd",
    "68C44C": "Xiaomi Communications Co Ltd",
    "E4F8BE": "TECNO MOBILE LIMITED",
    "D8E593": "Apple",
    "CC68E0": "Apple",
    "102CB1": "Smart Innovation LLC",
    "70DA48": "Cisco Systems",
    "04AEC7": "Marquardt",
    "F4B62D": "Dongguan Huayin Electronic Technology Co.",
    "20108A": "zte corporation",
    "58FFA1": "zte corporation",
    "B08B9E": "Telechips",
    "BC1FE1": "Ascendent Technology Group",
    "B8B1EA": "Honor Device Co.",
    "2C58B9": "HP Inc.",
    "3050F1": "Ennoconn Corporation.",
    "B0FA91": "EM Microelectronic",
    "ACDB22": "Marquardt Schaltsysteme SCS",
    "488002": "Cisco Systems",
    "B46AD4": "Edgecore Americas Networking Corporation",
    "AC712E": "Fortinet",
    "F801B4": "LG Electronics",
    "5421A9": "ITEL MOBILE LIMITED",
    "1073C6": "August Internet Limited",
    "CCD843": "Beijing Xiaomi Mobile Software Co.",
    "C03532": "Liteon Technology Corporation",
    "740635": "SERNET (SUZHOU) TECHNOLOGIES CORPORATION",
    "D4F921": "Qingdao Intelligent&Precise Electronics Co.",
    "7CC0AA": "Microsoft Corporation",
    "60601F": "SZ DJI TECHNOLOGY CO.",
    "E47A2C": "SZ DJI TECHNOLOGY CO.",
    "94AB18": "cellXica ltd",
    "F03F03": "Private",
    "C421B9": "zte corporation",
    "08A5DF": "Samsung Electronics Co.",
    "6CD63F": "HUAWEI TECHNOLOGIES CO.",
    "0C184E": "HUAWEI TECHNOLOGIES CO.",
    "D4F7D5": "Sony Interactive Entertainment Inc.",
    "98288B": "zhejiang Dusun Electron Co.",
    "BCB2CC": "Samsung Electronics Co.",
    "E0E8E6": "Shenzhen C-Data Technology Co.",
    "6C1FF7": "Ugreen Group Limited",
    "045EA4": "Netis Technology Co.",
    "64EEB7": "Netis Technology Co.",
    "048D38": "Netis Technology Co.",
    "E82587": "Shenzhen Chilink IoT Technology Co.",
    "507B91": "Sigmastar Technology Ltd.",
    "8C44A5": "Cisco Systems",
    "08E342": "Cear",
    "F4FE3E": "Apple",
    "342B6E": "Apple",
    "606525": "Apple",
    "1455B9": "Nokia Solutions and Networks GmbH & Co. KG",
    "F439A6": "Apple",
    "FC5557": "Apple",
    "8C5570": "IEEE Registration Authority",
    "A0E025": "Provision-ISR",
    "9C2472": "Sagemcom Broadband SAS",
    "808544": "Intelbras",
    "78CD55": "Texas Instruments",
    "8C0879": "Texas Instruments",
    "6823B0": "Texas Instruments",
    "24698E": "SHENZHEN MERCURY COMMUNICATION TECHNOLOGIES CO.",
    "640DCE": "SHENZHEN MERCURY COMMUNICATION TECHNOLOGIES CO.",
    "F8F519": "Rulogic Inc.",
    "A46DD4": "Silicon Laboratories",
    "0CAE5F": "Silicon Laboratories",
    "28DBA7": "Silicon Laboratories",
    "6C5CB1": "Silicon Laboratories",
    "5CC7C1": "Silicon Laboratories",
    "60B647": "Silicon Laboratories",
    "205A1D": "zte corporation",
    "3425B4": "Silicon Laboratories",
    "4CB7E0": "SHENZHEN MERCURY COMMUNICATION TECHNOLOGIES CO.",
    "BC0FB7": "sywinkey HongKong Co",
    "583BC2": "Silicon Laboratories",
    "006005": "Touchstar ATC Limited",
    "54606D": "HUAWEI TECHNOLOGIES CO.",
    "601D56": "Extreme Networks Headquarters",
    "44D465": "NXP Semiconductors Taiwan Ltd.",
    "ACBAC0": "Intertech Services AG",
    "00CAE0": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "D4F04A": "SKY UK LIMITED",
    "00408C": "Axis Communications AB",
    "3C450B": "Sentry Equipment Corp.",
    "1C7ACF": "vivo Mobile Communication Co.",
    "A86A86": "Xiaomi Communications Co Ltd",
    "A486DB": "Guangdong Juan Intelligent Technology Joint Stock Co.",
    "9C63C0": "Mellanox Technologies",
    "5C2573": "Mellanox Technologies",
    "B87E39": "Motorola Mobility LLC",
    "54ECB0": "Sercomm France Sarl",
    "646772": "SERCOMM PHILIPPINES INC",
    "70D51E": "Fiberhome Telecommunication Technologies Co.",
    "1090FA": "New H3C Technologies Co.",
    "7473E2": "Hillstone Networks Corp.",
    "D401C3": "Routerboard.com",
    "74077E": "Quectel Wireless Solutions Co.",
    "30EC7C": "Shenzhen Along Electronics Co.",
    "DCDA4D": "CELESTICA INC.",
    "505E24": "zte corporation",
    "382656": "TCL King Electrical Appliances(Huizhou)Co.",
    "84BA59": "Wistron InfoComm(Chongqing)Co.",
    "B09E1B": "Butlr Technologies",
    "14A1DF": "China Mobile Group Device Co.",
    "D0A011": "IEEE Registration Authority",
    "D8F760": "EM Microelectronic",
    "005092": "Rigaku Corporation Osaka Plant",
    "A8CFE0": "GDN Enterprises Private Limited",
    "54C6A6": "Hubei Yangtze Mason Semiconductor Technology  Co.",
    "D0B3C2": "Meta Platforms Technologies",
    "40B82D": "Ruckus Wireless",
    "B0B369": "Shenzhen SDMC Technology CO.",
    "C43EAB": "Huawei Device Co.",
    "CC4460": "Huawei Device Co.",
    "24506F": "THINKCAR TECH CO.",
    "34EA10": "Orbic North America",
    "6C92CF": "Broadcom Limited",
    "F43149": "Pixel FX",
    "78E996": "IEEE Registration Authority",
    "3C3576": "ITEL MOBILE LIMITED",
    "A021AA": "China Mobile Group Device Co.",
    "F42015": "Guangzhou Shiyuan Electronic Technology Company Limited",
    "1C7A43": "vivo Mobile Communication Co.",
    "084473": "zte corporation",
    "B47748": "Shenzhen Neoway Technology Co.",
    "90212E": "Apption Labs Ltd",
    "50D448": "Private",
    "943589": "HUAWEI TECHNOLOGIES CO.",
    "94261D": "HUAWEI TECHNOLOGIES CO.",
    "A45C25": "Texas Instruments",
    "98F487": "Texas Instruments",
    "FC599F": "Ruijie Networks Co.",
    "84A329": "Arcadyan Corporation",
    "9C098B": "Cisco Systems",
    "9C5884": "Apple",
    "24B339": "Apple",
    "E04E7A": "Nanjing Qinheng Microelectronics Co.",
    "D07602": "Hui Zhou Gaoshengda Technology Co.",
    "6CEFBD": "Cisco Meraki",
    "84821B": "PROX SG Pte Ltd",
    "94BDBE": "TPV Display Technology (Xiamen) Co.",
    "940BFA": "EM Microelectronic",
    "80A579": "IEEE Registration Authority",
    "743989": "TP-LINK TECHNOLOGIES CO.",
    "283984": "Qidi Technology (shanghai) Co.",
    "5CFA5A": "Sinepower Lda",
    "F49D8A": "Fantasia Trading LLC",
    "7C992E": "Shanghai Notion lnformatio Technology Co.",
    "8CEA88": "Chengdu Yocto Communication Technology Co.Ltd.",
    "105FAD": "Intel Corporate",
    "4CB04A": "Intel Corporate",
    "40EEBE": "NXP Semiconductor (Tianjin) LTD.",
    "FC9816": "ALPSALPINE CO",
    "E08F4C": "Intel Corporate",
    "54726E": "Daimler Truck AG",
    "3C0A7A": "Samsung Electronics Co.",
    "2424B7": "Samsung Electronics Co.",
    "F0051B": "Samsung Electronics Co.",
    "BCA080": "Samsung Electronics Co.",
    "002B70": "Samsung Electronics Co.",
    "C44606": "Cisco Systems",
    "88659F": "Fiberhome Telecommunication Technologies Co.",
    "B436A9": "Fibocom Wireless Inc.",
    "942770": "BSH Hausgeräte GmbH",
    "AC1EA9": "Intelbras",
    "487410": "Cisco Systems",
    "80E94A": "LEAPS s.r.o.",
    "588670": "Juniper Networks",
    "9C5A80": "Juniper Networks",
    "58FE7E": "zte corporation",
    "34194D": "Arcadyan Corporation",
    "6C80AB": "ifanr Inc",
    "2817CB": "Software Freedom Conservancy",
    "7C0CFA": "HUAWEI TECHNOLOGIES CO.",
    "3483D5": "HUAWEI TECHNOLOGIES CO.",
    "20185B": "Shenzhen Jingxun Technology Co.",
    "7C5E98": "eero inc.",
    "1C64F0": "Motorola Mobility LLC",
    "74BEF3": "Motorola Mobility LLC",
    "AC8866": "Shenzhen Skyworth Digital  Technology  CO.",
    "5C4842": "Hangzhou Anysoft Information Technology Co.",
    "8CC9E9": "Huawei Device Co.",
    "D854F2": "Huawei Device Co.",
    "E454E5": "Huawei Device Co.",
    "C40826": "HISENSE VISUAL TECHNOLOGY CO.",
    "C8586A": "Beijing Winner Microelectronics Co.",
    "1435B7": "Apple",
    "7CC025": "Palo Alto Networks",
    "644842": "Apple",
    "F45293": "Apple",
    "942157": "Apple",
    "886BDB": "Apple",
    "B4174D": "PROJECT MONITOR INC",
    "C4AB4D": "Cisco Systems",
    "10E376": "Cisco Systems",
    "FC915D": "Google",
    "CCB777": "zte corporation",
    "9C9E6E": "Espressif Inc.",
    "3089A6": "HUAWEI TECHNOLOGIES CO.",
    "74C17E": "LG Electronics",
    "F84D8B": "ecamtek",
    "1CE89E": "SJIT",
    "109819": "Dell Inc.",
    "60F419": "eero inc.",
    "D06726": "Hewlett Packard Enterprise",
    "EC9B8B": "Hewlett Packard Enterprise",
    "089734": "Hewlett Packard Enterprise",
    "B0B867": "Hewlett Packard Enterprise",
    "8030E0": "Hewlett Packard Enterprise",
    "004E35": "Hewlett Packard Enterprise",
    "DC9272": "Sagemcom Broadband SAS",
    "180C7A": "Sagemcom Broadband SAS",
    "00FD45": "Hewlett Packard Enterprise",
    "C8B5AD": "Hewlett Packard Enterprise",
    "5CBA2C": "Hewlett Packard Enterprise",
    "5CED8C": "Hewlett Packard Enterprise",
    "94F128": "Hewlett Packard Enterprise",
    "ACA31E": "Hewlett Packard Enterprise",
    "0CC3B8": "Shenzhen Jiahua Zhongli Technology Co.",
    "EC6794": "Hewlett Packard Enterprise",
    "A025D7": "Hewlett Packard Enterprise",
    "988F00": "Hewlett Packard Enterprise",
    "ECFCC6": "Hewlett Packard Enterprise",
    "A40E75": "Hewlett Packard Enterprise",
    "38BD7A": "Hewlett Packard Enterprise",
    "E81098": "Hewlett Packard Enterprise",
    "445BED": "Hewlett Packard Enterprise",
    "A85BF7": "Hewlett Packard Enterprise",
    "B45D50": "Hewlett Packard Enterprise",
    "40E3D6": "Hewlett Packard Enterprise",
    "9020C2": "Hewlett Packard Enterprise",
    "64E881": "Hewlett Packard Enterprise",
    "48E2AD": "HUMAX NETWORKS",
    "5C241F": "Qingdao Haier Technology Co.",
    "EC3BAF": "EM Microelectronic",
    "5038AB": "PROVE",
    "AC8EBD": "Microsoft Corporation",
    "ACFAE4": "Nintendo Co.",
    "782E03": "GUANGDONG GENIUS TECHNOLOGY CO.",
    "4438E8": "Intel Corporate",
    "7829AD": "NINGBO QIXIANG INFORMATION TECHNOLOGY CO.",
    "64078C": "HUAWEI TECHNOLOGIES CO.",
    "98B71E": "Infinix mobility limited",
    "381B9E": "Qingdao Intelligent&Precise Electronics Co.",
    "480234": "HUAWEI TECHNOLOGIES CO.",
    "E8DF24": "OHSUNG",
    "7CBAC6": "Solar Manager AG",
    "0401A1": "Fortinet",
    "28AF21": "zte corporation",
    "0C323A": "Samsung Electronics Co.",
    "5C15C5": "Shenzhen SSC Technology Co. Ltd",
    "D056FB": "Samsung Electronics Co.",
    "C07AD6": "Samsung Electronics Co.",
    "000295": "MAVENIR IPA UK LTD",
    "78EE4C": "Espressif Inc.",
    "78E61C": "Honor Device Co.",
    "04137A": "Apple",
    "70F94A": "Apple",
    "90B790": "Apple",
    "044707": "Texas Instruments",
    "945044": "Texas Instruments",
    "C8844E": "Flextronics International Kft",
    "F49ECE": "Sena Technologies Co.",
    "34105D": "Texas Instruments",
    "F0D635": "Apple",
    "F87A39": "IEEE Registration Authority",
    "9CDBCB": "Funshion Online Technologies Co.",
    "382CE5": "Tuya Smart Inc.",
    "847848": "Ubiquiti Inc",
    "C418FC": "Cisco Systems",
    "EC5BCD": "IEEE Registration Authority",
    "6C1D2C": "HUAWEI TECHNOLOGIES CO.",
    "20C2B0": "HUAWEI TECHNOLOGIES CO.",
    "B0C2C7": "Motorola Mobility LLC",
    "648B9B": "ALWAYS ON TECH PTE.LTD.",
    "382835": "zte corporation",
    "C05234": "HUAWEI TECHNOLOGIES CO.",
    "68BF6C": "Arista Networks",
    "343D7F": "Klipsch Group",
    "94B3F7": "Hui Zhou Gaoshengda Technology Co.",
    "741213": "Linksys USA",
    "74A5C2": "KYOCERA Corporation",
    "CC96A2": "China Mobile Group Device Co.",
    "543D60": "Arcadyan Corporation",
    "38DE35": "GUANGZHOU YUANDIANHE COMMUNICATION TECHNOLOGY CO.",
    "A00A9A": "Huawei Device Co.",
    "581F19": "EMH Metering GmbH & Co. KG",
    "1C83EC": "Ubee Interactive co",
    "280708": "Samsung Electronics Co.",
    "08DA33": "IEEE Registration Authority",
    "B8B4C9": "Cisco Meraki",
    "C01C6A": "Google",
    "8C1ECF": "UNIONMAN TECHNOLOGY CO.",
    "7C3E82": "Bouffalo Lab (Nanjing) Co.",
    "F024F9": "Espressif Inc.",
    "68CCBA": "Dense Air Networks US LLC",
    "4C6BB8": "Hui Zhou Gaoshengda Technology Co.",
    "0056F1": "zte corporation",
    "84A938": "LCFC(Hefei) Electronics Technology co.",
    "744218": "Apple",
    "904CC5": "Apple",
    "EC4654": "Apple",
    "5405DB": "LCFC(Hefei) Electronics Technology co.",
    "50F351": "Apple",
    "202DF6": "Apple",
    "C4EFBB": "LCFC(Hefei) Electronics Technology co.",
    "38A5C9": "Tuya Smart Inc.",
    "F8172D": "Tuya Smart Inc.",
    "FC5CEE": "LCFC(Hefei) Electronics Technology co.",
    "40F4C9": "FN-LINK TECHNOLOGY Ltd.",
    "987596": "EM Microelectronic",
    "545B86": "Panasonic Automotive Systems Co.",
    "8C5C20": "Vantiva USA LLC",
    "C41375": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "1C627E": "HUAWEI TECHNOLOGIES CO.",
    "6056B1": "HUAWEI TECHNOLOGIES CO.",
    "4C22C9": "zte corporation",
    "8CBFEA": "Espressif Inc.",
    "B41DC4": "HUAWEI TECHNOLOGIES CO.",
    "105F02": "Ruijie Networks Co.",
    "00A159": "LG Electronics",
    "2824C9": "Amazon Technologies Inc.",
    "5000E0": "Cisco Systems",
    "74E2E7": "Cisco Systems",
    "CC6C52": "DZS Inc.",
    "C4600A": "Huaqin Technology Co.LTD",
    "00F8CC": "Sagemcom Broadband SAS",
    "147E19": "Hewlett Packard Enterprise",
    "3806E6": "Arcadyan Corporation",
    "1074C5": "Calix Inc.",
    "BCCD7F": "Huawei Device Co.",
    "44896D": "TELLESCOM INDUSTRIA E COMERCIO EM TELECOMUNICACAO",
    "E451A9": "Nanjing Xinlian Electronics Co.",
    "742869": "Huawei Device Co.",
    "D0C1B5": "Dell Inc.",
    "ECE78E": "AsiaTelco Technologies Co.",
    "145A41": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "AC45CA": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "8876B9": "D-Link Corporation",
    "90A196": "Private",
    "1435B3": "Future Designs",
    "54A245": "Digisol Systems Limited",
    "50695A": "AiFamous（shenzhen）Technology Co.",
    "502FBB": "Motorola Mobility LLC",
    "6C0B5E": "HP Inc.",
    "2C195C": "Beijing Xiaomi Mobile Software Co.",
    "68E580": "Apple",
    "58666D": "Apple",
    "DC9E8F": "Apple",
    "C48B66": "Hui Zhou Gaoshengda Technology Co.",
    "B496A5": "Apple",
    "3809FB": "Apple",
    "C463C4": "HUAWEI TECHNOLOGIES CO.",
    "4C5D6A": "Apple",
    "14E289": "Abietec Inc.",
    "0C1BCC": "IFLYTEK CO.",
    "FCD96B": "Realme Chongqing Mobile Telecommunications Corp.",
    "FC1928": "Actions Microelectronics",
    "E0C29E": "zte corporation",
    "60B02B": "Qingdao Haier Technology Co.",
    "306893": "TP-Link Systems Inc.",
    "D4C9B2": "Quanergy Solutions Inc",
    "242856": "Beijing Gctech Technology Co.",
    "A0D42D": "G.Tech Technology Ltd.",
    "F87BE0": "Funtime Pickleball Inc.",
    "789987": "Xiaomi Communications Co Ltd",
    "34C459": "Texas Instruments",
    "4488BE": "Texas Instruments",
    "FCDEC5": "Texas Instruments",
    "584BBC": "zte corporation",
    "9C47F4": "Nokia",
    "08A136": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "74E147": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "342C8E": "Ufispace Co.",
    "74B8A8": "HUAWEI TECHNOLOGIES CO.",
    "E0F330": "HUAWEI TECHNOLOGIES CO.",
    "9C0351": "HUAWEI TECHNOLOGIES CO.",
    "0CB787": "HUAWEI TECHNOLOGIES CO.",
    "9898FB": "Google",
    "24A3F0": "IEEE Registration Authority",
    "243CB0": "Dongguan Mentech Optical & Magnetic Co.",
    "A457A0": "SAMJIN Co.",
    "F8160C": "Shenzhen iComm Semiconductor CO.",
    "341736": "Shenzhen iComm Semiconductor CO.",
    "707FF2": "Telechips",
    "90B57F": "Shenzhen iComm Semiconductor CO.",
    "60DEF4": "Shenzhen iComm Semiconductor CO.",
    "B88EB0": "Shenzhen Skyworth Digital  Technology  CO.",
    "84EB3F": "Vivint Inc",
    "C0A3C7": "Telink Micro LLC",
    "FC4D6A": "Silicon Laboratories",
    "4C6460": "ITEL MOBILE LIMITED",
    "E826CF": "Shenzhen Jingxun Technology Co.",
    "F4650B": "Espressif Inc.",
    "B41678": "Juniper Networks",
    "AC9FC3": "Ring LLC",
    "3CDC03": "IEEE Registration Authority",
    "FC221C": "Shenzhen Xunman Technology Co.",
    "3023CD": "FUJIAN STAR-NET COMMUNICATION CO.",
    "5408D3": "Tianyi Telecom Terminals Company Limited",
    "E81CA5": "Hewlett Packard Enterprise",
    "04ED62": "Daikin Europe NV",
    "5C14EB": "Trident IoT",
    "500A9C": "Extreme Networks Headquarters",
    "4C92D2": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "2CB6C2": "zte corporation",
    "10985F": "Inventus Power Eletronica do Brasil LTDA",
    "38D518": "GooWi Wireless Technology Co.",
    "A46D33": "Phyplus Technology (Shanghai) Co.",
    "640552": "China Post Communication Equipment Co.",
    "3C59C0": "HUAWEI TECHNOLOGIES CO.",
    "8C13E2": "NETLINK ICT",
    "00FADE": "Motorola Mobility LLC",
    "08C7B5": "Apple",
    "942B68": "Apple",
    "BC804E": "Apple",
    "D87475": "Apple",
    "9CB150": "Intel Corporate",
    "24EB16": "Intel Corporate",
    "700810": "Intel Corporate",
    "8C3396": "Apple",
    "74CC40": "Apple",
    "3C5002": "Apple",
    "B0D1D6": "Nokia Shanghai Bell Co.",
    "E86EAD": "Guangzhou Gizwits loT Technology Co.",
    "502E66": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "5003CF": "CANON INC.",
    "48EA62": "HP Inc.",
    "B88C2B": "Sagemcom Broadband SAS",
    "04E3C8": "FUJIAN STAR-NET COMMUNICATION CO.",
    "6455B1": "Commscope",
    "0000C5": "Commscope",
    "44E137": "Commscope",
    "14CFE2": "Commscope",
    "BCC2D9": "Private",
    "001DD4": "Commscope",
    "001DD5": "Commscope",
    "001DCF": "Commscope",
    "001DD1": "Commscope",
    "9C3426": "Commscope",
    "0015CF": "Commscope",
    "002040": "Commscope",
    "001225": "Commscope",
    "00909C": "Commscope",
    "E86D52": "Commscope",
    "386BBB": "Commscope",
    "001784": "Commscope",
    "1C1448": "Commscope",
    "001E46": "Commscope",
    "001C11": "Commscope",
    "0018C0": "Commscope",
    "0018A4": "Commscope",
    "CCA462": "Commscope",
    "00080E": "Commscope",
    "2C1DB8": "Commscope",
    "E45740": "Commscope",
    "909D7D": "Commscope",
    "002495": "Commscope",
    "74F612": "Commscope",
    "6CC1D2": "Commscope",
    "145BD1": "Commscope",
    "A811FC": "Commscope",
    "94E8C5": "Commscope",
    "E48399": "Commscope",
    "3C754A": "Commscope",
    "0024A0": "Commscope",
    "001CC3": "Commscope",
    "347A60": "Commscope",
    "54E2E0": "Commscope",
    "7C2634": "Commscope",
    "7085C6": "Commscope",
    "002374": "Commscope",
    "002143": "Commscope",
    "88BD09": "Netis Technology Co.",
    "8C61A3": "Commscope",
    "8871B1": "Commscope",
    "F0AF85": "Commscope",
    "FCAE34": "Commscope",
    "B0935B": "Commscope",
    "A89FEC": "Commscope",
    "C0A00D": "Commscope",
    "A49813": "Commscope",
    "98F781": "Commscope",
    "6C639C": "Commscope",
    "484EFC": "Commscope",
    "5860D8": "Commscope",
    "50A5DC": "Commscope",
    "FC3FFC": "Tozed Kangwei Tech Co.",
    "F8F532": "Commscope",
    "B083D6": "Commscope",
    "C85261": "Commscope",
    "60D248": "Commscope",
    "B05DD4": "Commscope",
    "A4438C": "Commscope",
    "FCD202": "Realme Chongqing Mobile Telecommunications Corp.",
    "68AAC4": "Altice Labs",
    "3CF341": "Hosenso GmbH & Co. KG",
    "7450CD": "HUAWEI TECHNOLOGIES CO.",
    "A091CA": "Nokia Solutions and Networks GmbH & Co. KG",
    "0C44C0": "zte corporation",
    "A840F8": "HUMAX NETWORKS",
    "EC750C": "TP-Link Systems Inc.",
    "343E25": "OHSUNG",
    "844D4C": "Adtran Inc",
    "58D61F": "Ubiquiti Inc",
    "6C63F8": "Ubiquiti Inc",
    "A8741D": "Phoenix Contact GmbH & Co. KG",
    "CCCCEA": "Phoenix Contact GmbH & Co. KG",
    "28DE1C": "Samsung Electronics Co.",
    "186BE2": "LYLINK LIMITED",
    "D8C80C": "Tuya Smart Inc.",
    "347069": "Cisco Systems",
    "EC74CD": "IEEE Registration Authority",
    "F815E0": "Siemens Canada",
    "3CE86E": "Hewlett Packard Enterprise",
    "0CED71": "Extreme Networks Headquarters",
    "A00CE2": "Shenzhen Shokz Co.",
    "CC1228": "HISENSE VISUAL TECHNOLOGY CO.",
    "58FB3E": "Huawei Device Co.",
    "C02CED": "Silicon Laboratories",
    "0C93A5": "eero inc.",
    "7071B3": "Brain Corporation",
    "1C3003": "Hewlett Packard Enterprise",
    "E0E2D1": "Beijing Netswift Technology Co.",
    "98BA5F": "TP-Link Systems Inc.",
    "98EE94": "Xiaomi Communications Co Ltd",
    "209952": "Xiaomi Communications Co Ltd",
    "A4E88D": "FN-LINK TECHNOLOGY Ltd.",
    "08D593": "Texas Instruments",
    "88CFCD": "Texas Instruments",
    "F8916F": "Texas Instruments",
    "5CA436": "Shenzhen G-world Technology Incorporated Company",
    "38182B": "Espressif Inc.",
    "284D92": "Luminator Technology Group Global LLC",
    "A0C7D2": "Cisco Systems",
    "5C6152": "NXP Semiconductor (Tianjin) LTD.",
    "6858A0": "Honor Device Co.",
    "14EA63": "Hui Zhou Gaoshengda Technology Co.",
    "04BFD5": "Apple",
    "44A10E": "Apple",
    "7CC8DF": "Apple",
    "E8E49D": "Nexthop Systems Inc.",
    "8083F6": "Apple",
    "74761F": "Microsoft Corporation",
    "603D61": "Private",
    "70A703": "Honor Device Co.",
    "1CD1D7": "Hangzhou BroadLink Technology Co.",
    "088AF1": "MERCUSYS TECHNOLOGIES CO.",
    "947AF4": "HUAWEI TECHNOLOGIES CO.",
    "8CA96D": "HUAWEI TECHNOLOGIES CO.",
    "10BA1A": "SHENZHEN IK WORLD Technology Co.",
    "7CDC73": "HUAWEI TECHNOLOGIES CO.",
    "98038E": "TP-Link Systems Inc.",
    "8C938B": "Realme Chongqing Mobile Telecommunications Corp.",
    "706871": "FN-LINK TECHNOLOGY Ltd.",
    "C8AC35": "PiLink Co.",
    "B4107A": "Amazon Technologies Inc.",
    "543ADF": "Qualfiber Technology Co.",
    "043D6E": "Nokia",
    "5C0610": "Cisco Meraki",
    "F4D454": "Shenzhen Skyworth Digital  Technology  CO.",
    "BC3E0B": "Panasonic Connect Co.",
    "B46415": "Guangzhou V-Solution Telecommunication Technology Co.",
    "30BD13": "Zyxel Communications Corporation",
    "701AD5": "Avigilon Alta",
    "4CB82C": "Cambridge Mobile Telematics",
    "901057": "Intel Corporate",
    "C40F08": "Intel Corporate",
    "C8D959": "Motorola Mobility LLC",
    "9C5A8A": "DJI BAIWANG TECHNOLOGY CO LTD",
    "A844AA": "Fiberhome Telecommunication Technologies Co.",
    "D87D45": "Nicent Technology Co.",
    "4CCA95": "Huawei Device Co.",
    "F05C0E": "Huawei Device Co.",
    "D4958E": "Universal Electronics",
    "74FC45": "SIEMENS AG",
    "40C73C": "Intel Corporate",
    "D4438A": "Beijing Xiaomi Mobile Software Co.",
    "A0EEEE": "CIG SHANGHAI CO LTD",
    "147057": "SHENNAN CIRCUITS CO.",
    "4C37DE": "AltoBeam Inc.",
    "200F92": "STK Technology Co.",
    "581862": "Sony Corporation",
    "785ECC": "Apple",
    "880264": "Pascal Audio",
    "4C1F86": "Hangzhou Hikvision Digital Technology Co.",
    "68D976": "EM Microelectronic",
    "84E585": "EM Microelectronic",
    "2CFB0F": "Sagemcom Broadband SAS",
    "BCD5ED": "Sagemcom Broadband SAS",
    "94E7F3": "HUAWEI TECHNOLOGIES CO.",
    "DC9C99": "HUAWEI TECHNOLOGIES CO.",
    "B45976": "Apple",
    "DC9566": "Apple",
    "B845EB": "Apple",
    "989D39": "China Mobile Group Device Co.",
    "1C61BF": "Apple",
    "9C69D3": "ASIX Electronics Corporation",
    "343C30": "NXP Semiconductor (Tianjin) LTD.",
    "340557": "vivo Mobile Communication Co.",
    "9CF1D4": "Roku",
    "20EFBD": "Roku",
    "846EBC": "Nokia solutions and networks Pvt Ltd",
    "D46C62": "MultiTracks.com",
    "9CDAB7": "Hewlett Packard Enterprise",
    "8CC573": "Xsight Labs LTD.",
    "E0280A": "TP-Link Systems Inc.",
    "00596C": "Cisco Systems",
    "00D0CE": "TASKING Labs",
    "38165A": "zte corporation",
    "808800": "zte corporation",
    "7866D7": "GENSTORAIGE TECHNOLOGY CO.LTD.",
    "24B5F2": "Shanghai Ingeek Technology Co.",
    "F8D0C5": "Sector Alarm Tech S.L.",
    "148121": "TOP WING Corporation",
    "1C7126": "snom technology GmbH",
    "5C8DE5": "Delta Electronics",
    "EC1BCF": "Brain Technologies",
    "287B11": "Hui Zhou Gaoshengda Technology Co.",
    "88A29E": "Raspberry Pi (Trading) Ltd",
    "68B1C9": "IYO",
    "347E5C": "Sonos",
    "00047E": "TKH Security B.V.",
    "708B97": "INSYS icom GmbH",
    "000E58": "Sonos",
    "004B12": "Espressif Inc.",
    "444A37": "Xiaomi Communications Co Ltd",
    "405ECF": "Esconet Technologies Limited",
    "C895CE": "Intel Corporate",
    "94390E": "Intel Corporate",
    "40D133": "Intel Corporate",
    "20BD1D": "Intel Corporate",
    "C02242": "Chauvet",
    "6C8720": "New H3C Technologies Co.",
    "0C8D7A": "RADiflow",
    "FCA9F5": "Xiaomi Communications Co Ltd",
    "B85001": "Extreme Networks Headquarters",
    "14144B": "Ruijie Networks Co.",
    "0004A5": "Barco NV",
    "40882F": "Extreme Networks Headquarters",
    "4018B1": "Extreme Networks Headquarters",
    "206C8A": "Extreme Networks Headquarters",
    "885BDD": "Extreme Networks Headquarters",
    "ACED32": "Extreme Networks Headquarters",
    "DCE650": "Extreme Networks Headquarters",
    "241FBD": "Extreme Networks Headquarters",
    "E444E5": "Extreme Networks Headquarters",
    "00E60E": "Extreme Networks Headquarters",
    "6C0370": "Extreme Networks Headquarters",
    "7896A3": "Extreme Networks Headquarters",
    "949B2C": "Extreme Networks Headquarters",
    "A4EA8E": "Extreme Networks Headquarters",
    "44D980": "EVERYBOT INC.",
    "348584": "Extreme Networks Headquarters",
    "0016E6": "GIGA-BYTE TECHNOLOGY CO.",
    "D09168": "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.",
    "D4A38B": "ELE(GROUP)CO.",
    "10E83A": "FIBERX DISTRIBUIDORA DE PRODUTOS DE TELECOMUNICACAO LTDA",
    "5413CA": "ITEL MOBILE LIMITED",
    "D0DC2C": "Cisco Systems",
    "18523D": "Xiamen Jiwu Technology CO.",
    "D843EA": "SY Electronics Ltd",
    "E04C05": "EverCharge",
    "E8C829": "Intel Corporate",
    "F83C44": "SHENZHEN TRANSCHAN TECHNOLOGY LIMITED",
    "80482C": "Wyze Labs Inc",
    "9C891E": "FireBrick Ltd",
    "B04AB4": "Motorola Mobility LLC",
    "885EBD": "NCKOREA Co.",
    "1C6066": "TEJAS NETWORKS LTD",
    "58A2E1": "Mellanox Technologies",
    "B0CF0E": "Mellanox Technologies",
    "C414A2": "Cisco Meraki",
    "58687A": "Sagemcom Broadband SAS",
    "2015DE": "Samsung Electronics Co.",
    "8809AF": "Masimo Corporation",
    "DCF51B": "Arcadyan Corporation",
    "5C7DF3": "Fiberhome Telecommunication Technologies Co.",
    "CCE9FA": "Samsung Electronics Co.",
    "EC0482": "STL Systems AG",
    "9C9613": "Lenovo Future Communication Technology (Chongqing) Company Limited",
    "D0F405": "Hon Hai Precision Industry Co.",
    "087B87": "Cisco Systems",
    "6466D8": "Samsung Electronics Co.",
    "489A5B": "Shenzhen iComm Semiconductor CO.",
    "64E738": "Zhejiang SUPCON Technology Co.",
    "38F6ED": "EVK DI Kerschhaggl GmbH",
    "000CEC": "Safran Trusted 4D Inc.",
    "58D312": "zte corporation",
    "D8097F": "zte corporation",
    "44E761": "Infinix mobility limited",
    "E88DA6": "Quectel Wireless Solutions Co.",
    "3C0AF3": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "6C68A4": "Guangzhou V-Solution Telecommunication Technology Co.",
    "D82D40": "Janz - Contagem e Gestão de Fluídos S.A.",
    "A436C7": "LG Innotek",
    "44B59C": "Tenet Networks Private Limited",
    "C07C90": "Shenzhen YOUHUA Technology Co.",
    "848687": "weiyuantechnology",
    "00E63A": "Ruckus Wireless",
    "003969": "Air-Weigh Incorporated",
    "2091DF": "Apple",
    "A89C78": "Apple",
    "7C6130": "Apple",
    "80B989": "Apple",
    "C4524F": "Apple",
    "603E5F": "Apple",
    "94F929": "Meta Platforms Technologies",
    "E03717": "Vantiva USA LLC",
    "905851": "Vantiva USA LLC",
    "087E64": "Vantiva USA LLC",
    "1033BF": "Vantiva USA LLC",
    "6C55E8": "Vantiva USA LLC",
    "889E68": "Vantiva USA LLC",
    "087073": "HUAWEI TECHNOLOGIES CO.",
    "F85E42": "Vantiva USA LLC",
    "EC937D": "Vantiva USA LLC",
    "D4E2CB": "Vantiva USA LLC",
    "8CD08B": "WuXi Rigosys Technology Co.",
    "5C22DA": "Vantiva USA LLC",
    "00651E": "Amcrest Technologies",
    "4432C8": "Vantiva USA LLC",
    "08952A": "Vantiva USA LLC",
    "FC528D": "Vantiva USA LLC",
    "28BE9B": "Vantiva USA LLC",
    "D05A00": "Vantiva USA LLC",
    "3C9A77": "Vantiva USA LLC",
    "7C9A54": "Vantiva USA LLC",
    "B8C065": "Universal Electronics",
    "D0CEC9": "HAN CHANG",
    "68DA73": "IEEE Registration Authority",
    "A4BD7E": "HMD Global Oy",
    "FCC233": "ASUSTek COMPUTER INC.",
    "0438DC": "China Unicom Online Information Technology Co.",
    "DCBDCC": "Quectel Wireless Solutions Co.",
    "FCFA21": "zte corporation",
    "D07CB2": "Sigmastar Technology Ltd.",
    "00EE01": "Enablers Solucoes e Consultoria em Dispositivos",
    "80F0CF": "Ruckus Wireless",
    "68DECE": "Fiberhome Telecommunication Technologies Co.",
    "FCB467": "Espressif Inc.",
    "D8BC38": "Espressif Inc.",
    "38315A": "Rinnai",
    "3C19CB": "TECNO MOBILE LIMITED",
    "A800E3": "Starkey Labs Inc.",
    "B096EA": "GD Midea Air-Conditioning Equipment Co.",
    "186A81": "Sagemcom Broadband SAS",
    "64009C": "Insulet Corporation",
    "605699": "MAGNETI MARELLI   S.E. S.p.A.",
    "A82C3E": "Shenzhen Cultraview Digital Technology Co.",
    "D0F928": "zte corporation",
    "38922E": "ArrayComm",
    "C47EE0": "Cisco Systems",
    "743AEF": "Kaon Group Co.",
    "24E4CE": "Kaon Group Co.",
    "1091D1": "Intel Corporate",
    "6C4CE2": "Intel Corporate",
    "A8E539": "Nurivoice Co.",
    "B0F00C": "Dongguan Wecxw CO.",
    "A8FB40": "Nokia Solutions and Networks GmbH & Co. KG",
    "1C7C98": "NEC Platforms",
    "A07F8A": "Sagemcom Broadband SAS",
    "2C9975": "Samsung Electronics Co.",
    "A8584E": "PK VEGA",
    "F854F6": "AzureWave Technology Inc.",
    "087458": "Fiberhome Telecommunication Technologies Co.",
    "C482E1": "Tuya Smart Inc.",
    "00E04D": "INTERNET INITIATIVE JAPAN",
    "6879DD": "Omnipless Manufacturing (PTY) Ltd",
    "60C9AA": "Nokia",
    "E068EE": "Phyplus Microelectronics Limited",
    "F0C558": "U.D.Electronic Corp.",
    "48062B": "Private",
    "E87640": "SKY UK LIMITED",
    "743357": "vivo Mobile Communication Co.",
    "AC00F9": "BizLink Technology (S.E.A) Sdn. Bhd.",
    "681A7C": "Sichuan Tianyi Comheart Telecom Co.",
    "800794": "Samsung Electronics Co.",
    "F43C3B": "HUNAN FN-LINK TECHNOLOGY LIMITED",
    "74D7CA": "Panasonic Automotive Systems Co.",
    "00181C": "VITEC",
    "989F1E": "HUAWEI TECHNOLOGIES CO.",
    "944788": "HUAWEI TECHNOLOGIES CO.",
    "5412CB": "HUAWEI TECHNOLOGIES CO.",
    "98FBF5": "ATRALTECH",
    "301D49": "Firmus Technologies Pty Ltd",
    "401482": "Cisco Systems",
    "90395F": "Amazon Technologies Inc.",
    "D4B680": "Shanghai Linkyum Microeletronics Co.",
    "C81337": "Juniper Networks",
    "AC416A": "Amazon Technologies Inc.",
    "8CEEFD": "zte corporation",
    "C04943": "zte corporation",
    "58CDC9": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "BCF499": "Rockwell Automation",
    "903C1D": "HISENSE VISUAL TECHNOLOGY CO.",
    "246C84": "Cisco Systems",
    "90EB50": "Cisco Systems",
    "609532": "Zebra Technologies Inc.",
    "D4E95E": "Texas Instruments",
    "1015C1": "Zhanzuo (Beijing) Technology Co.",
    "8CF3E7": "solidotech",
    "8488E1": "Apple",
    "10BD3A": "Apple",
    "184A53": "Apple",
    "109F41": "Apple",
    "7072FE": "Apple",
    "90A7BF": "EM Microelectronic",
    "28EF01": "Amazon Technologies Inc.",
    "D452C7": "Beijing L&S Lancom Platform Tech. Co.",
    "80EE25": "Shenzhen Skyworth Digital  Technology  CO.",
    "1055E4": "Shenzhen Skyworth Digital  Technology  CO.",
    "04CE09": "Shenzhen Skyworth Digital  Technology  CO.",
    "2CC253": "Apple",
    "B0FB15": "Laird Connectivity",
    "80C45D": "IPG Laser GmbH",
    "68F63B": "Amazon Technologies Inc.",
    "6885A4": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "E8D52B": "Google",
    "B456FA": "IOPSYS Software Solutions",
    "CC3ADF": "Neptune Technology Group Inc.",
    "68EC8A": "IKEA of Sweden AB",
    "40679B": "Shenzhen Skyworth Digital  Technology  CO.",
    "C068CC": "Shenzhen Skyworth Digital  Technology  CO.",
    "24E8E5": "Shenzhen Skyworth Digital  Technology  CO.",
    "04AB08": "Shenzhen Skyworth Digital  Technology  CO.",
    "E8F8D0": "Nokia Shanghai Bell Co.",
    "408E2C": "Microsoft Corporation",
    "111111": "Private",
    "B0216F": "HUAWEI TECHNOLOGIES CO.",
    "94DF34": "HUAWEI TECHNOLOGIES CO.",
    "7430AF": "Fiberhome Telecommunication Technologies Co.",
    "28BEF3": "FUJIAN STAR-NET COMMUNICATION CO.",
    "E0CB19": "Nokia",
    "848F69": "Dell Inc.",
    "549F35": "Dell Inc.",
    "845A3E": "Cisco Systems",
    "A44CC8": "Dell Inc.",
    "E4F004": "Dell Inc.",
    "20040F": "Dell Inc.",
    "8CEC4B": "Dell Inc.",
    "D4BED9": "Dell Inc.",
    "ECF4BB": "Dell Inc.",
    "B8CA3A": "Dell Inc.",
    "544810": "Dell Inc.",
    "A89969": "Dell Inc.",
    "B82A72": "Dell Inc.",
    "BC305B": "Dell Inc.",
    "0023AE": "Dell Inc.",
    "001D09": "Dell Inc.",
    "000D56": "Dell Inc.",
    "14C35E": "FibRSol Global Network Limited",
    "880894": "Skullcandy",
    "902AEE": "Xiaomi Communications Co Ltd",
    "D8478F": "Microchip Technology Inc.",
    "40FAFE": "Motorola Mobility LLC",
    "201C3A": "Nintendo Co.",
    "249038": "Universal Biosensors Pty Ltd",
    "F8EDAE": "MOBIWIRE MOBILES(NINGBO) CO.",
    "D8E35E": "LG Innotek",
    "786829": "eero inc.",
    "14A417": "Shenzhen Belon Technology CO.",
    "60489C": "YIPPEE ELECTRONICS CO.",
    "94988F": "Sagemcom Broadband SAS",
    "F07B65": "Sagemcom Broadband SAS",
    "3C0CDB": "UNION MAN TECHNOLOGY CO.",
    "F4D9C6": "UNION MAN TECHNOLOGY CO.",
    "C025A5": "Dell Inc.",
    "E8B5D0": "Dell Inc.",
    "089204": "Dell Inc.",
    "70B5E8": "Dell Inc.",
    "B8CB29": "Dell Inc.",
    "34735A": "Dell Inc.",
    "F40270": "Dell Inc.",
    "3448ED": "Dell Inc.",
    "A8C56F": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "AC7A94": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "04DA28": "Chongqing Zhouhai Intelligent Technology Co.",
    "0C014B": "zte corporation",
    "74D6E5": "Huawei Device Co.",
    "20F597": "Maasiv",
    "988CB3": "Sichuan Tianyi Comheart Telecom Co.",
    "5C2167": "Rockwell Automation",
    "6C8F4E": "Chongqing Yipingfang Technology Co.",
    "34AFA3": "Recogni Inc",
    "DC9EAB": "Chongqing Yipingfang Technology Co.",
    "4891D5": "Cisco Systems",
    "E01FFC": "Motorola (Wuhan) Mobility Technologies Communication Co.",
    "CC4740": "AzureWave Technology Inc.",
    "001491": "Daniels Electronics Ltd. dba Codan Radio Communications",
    "200BC5": "Cisco Systems",
    "90E95E": "Cisco Systems",
    "2857BE": "Hangzhou Hikvision Digital Technology Co.",
    "ACCB51": "Hangzhou Hikvision Digital Technology Co.",
    "5850ED": "Hangzhou Hikvision Digital Technology Co.",
    "1012FB": "Hangzhou Hikvision Digital Technology Co.",
    "4CF5DC": "Hangzhou Hikvision Digital Technology Co.",
    "988B0A": "Hangzhou Hikvision Digital Technology Co.",
    "2029B9": "Ikotek technology SH Co.",
    "807C62": "Hangzhou Hikvision Digital Technology Co.",
    "BC9B5E": "Hangzhou Hikvision Digital Technology Co.",
    "80BEAF": "Hangzhou Hikvision Digital Technology Co.",
    "040312": "Hangzhou Hikvision Digital Technology Co.",
    "304F75": "DZS Inc.",
    "D096FB": "DZS Inc.",
    "000147": "DZS Inc.",
    "000271": "DZS Inc.",
    "9C65FA": "AcSiP",
    "882508": "Meta Platforms Technologies",
    "1868CB": "Hangzhou Hikvision Digital Technology Co.",
    "BCBAC2": "Hangzhou Hikvision Digital Technology Co.",
    "C82B6B": "shenzhen worldelite electronics co.",
    "C4678B": "Alphabet Capital Sdn Bhd",
    "60F04D": "Honor Device Co.",
    "5C628B": "TP-Link Corporation Limited",
    "D43A2F": "SHENZHEN MTC CO LTD",
    "4881D4": "Ruijie Networks Co.",
    "34CA81": "New H3C Intelligence Terminal Co.",
    "280C2D": "QUALVISION TECHNOLOGY CO.",
    "60030C": "Shenzhen YOUHUA Technology Co.",
    "1814AE": "Nokia",
    "C0613D": "BioIntelliSense",
    "0418D6": "Ubiquiti Inc",
    "8867DC": "HUAWEI TECHNOLOGIES CO.",
    "40410D": "HUAWEI TECHNOLOGIES CO.",
    "5C8B6B": "Amazon Technologies Inc.",
    "0019E2": "Juniper Networks",
    "002688": "Juniper Networks",
    "841888": "Juniper Networks",
    "24A43C": "Ubiquiti Inc",
    "44D9E7": "Ubiquiti Inc",
    "D021F9": "Ubiquiti Inc",
    "70A741": "Ubiquiti Inc",
    "0C8610": "Juniper Networks",
    "544B8C": "Juniper Networks",
    "B0A86E": "Juniper Networks",
    "0881F4": "Juniper Networks",
    "E4BCAA": "Xiaomi Communications Co Ltd",
    "545DD9": "EDISTEC",
    "404CCA": "Espressif Inc.",
    "BC9E2C": "China Mobile Group Device Co.",
    "307C5E": "Juniper Networks",
    "F01C2D": "Juniper Networks",
    "64649B": "Juniper Networks",
    "009069": "Juniper Networks",
    "80ACAC": "Juniper Networks",
    "2C2131": "Juniper Networks",
    "9CCC83": "Juniper Networks",
    "44AA50": "Juniper Networks",
    "E8B6C2": "Juniper Networks",
    "C409B7": "Juniper Networks",
    "74E798": "Juniper Networks",
    "487310": "Juniper Networks",
    "E4FC82": "Juniper Networks",
    "B8C253": "Juniper Networks",
    "14B3A1": "Juniper Networks",
    "D4996C": "Juniper Networks",
    "40DEAD": "Juniper Networks",
    "0C599C": "Juniper Networks",
    "045C6C": "Juniper Networks",
    "38141B": "Secure Letter Inc.",
    "B461E9": "Sichuan AI-Link Technology Co.",
    "64E204": "NTN Technical Service Corporation",
    "2C9811": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "90D689": "Huahao Fangzhou Technology Co.",
    "C08B2A": "Cisco Systems",
    "2CCA75": "Robert Bosch GmbH AnP",
    "E0D8C4": "Qingdao Intelligent&Precise Electronics Co.",
    "9CD1D0": "Guangzhou Ronsuo Electronic Technology Co.",
    "3C792B": "Dongguan Auklink TechnologyCo.",
    "000E51": "TECNA SpA",
    "C0C70A": "Ruckus Wireless",
    "001616": "BROWAN COMMUNICATIONS INCORPORATION",
    "5C9462": "Shenzhen Jiuzhou Electric Co.",
    "CCD81F": "Maipu Communication Technology Co.",
    "88C6E8": "HUAWEI TECHNOLOGIES CO.",
    "707CE3": "HUAWEI TECHNOLOGIES CO.",
    "3C6F9B": "zte corporation",
    "386F6B": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "541149": "vivo Mobile Communication Co.",
    "9052BF": "Sichuan Tianyi Comheart Telecom Co.",
    "881E59": "Onion Corporation",
    "28022E": "Apple",
    "FC9CA7": "Apple",
    "48E15C": "Apple",
    "7415F5": "Apple",
    "48A98A": "Routerboard.com",
    "2C002A": "Shenzhen TINNO Mobile Technology Corp.",
    "E88843": "Xiaomi Communications Co Ltd",
    "7C1779": "EM Microelectronic",
    "ACFC82": "Shenzhen Sundray Technologies Company Limited",
    "705A6F": "IEEE Registration Authority",
    "DCA313": "Shenzhen Changjin Communication Technology Co.",
    "182654": "Samsung Electronics Co.",
    "1C6760": "Phonesuite",
    "043201": "Broadcom Limited",
    "B04B68": "NAKAYO Inc",
    "F86B14": "Barrot Technology Co.",
    "704698": "HUAWEI TECHNOLOGIES CO.",
    "78084D": "HUAWEI TECHNOLOGIES CO.",
    "ECAA8F": "HUAWEI TECHNOLOGIES CO.",
    "689A21": "Fiberhome Telecommunication Technologies Co.",
    "38396C": "Huawei Device Co.",
    "5066E5": "Huawei Device Co.",
    "DC7794": "Huawei Device Co.",
    "D8341C": "GD Midea Air-Conditioning Equipment Co.",
    "00187F": "ZODIANET",
    "CCF826": "Samsung Electronics Co.",
    "70B651": "Eight Sleep",
    "90CEB8": "Texas Instruments",
    "B4BC7C": "Texas Instruments",
    "F88A5E": "Texas Instruments",
    "F4331C": "Toast",
    "5451DE": "Cisco Systems",
    "4C0617": "Taicang T&W Electronics",
    "D49AF6": "AzureWave Technology Inc.",
    "AC81F3": "Nokia Corporation",
    "606E41": "Barrot Technology Co.",
    "2C1809": "Apple",
    "FC47D8": "Apple",
    "E49D73": "Edgecore Networks Corporation",
    "44EB2E": "ALPSALPINE CO",
    "047F0E": "Barrot Technology Co.",
    "D40145": "ATW TECHNOLOGY",
    "7C646C": "LG Electronics",
    "48C1EE": "Honor Device Co.",
    "94720F": "Guangdong Nanguang Photo&Video Systems Co.",
    "646876": "Edifier International",
    "5C64F3": "sywinkey HongKong Co",
    "28E424": "New H3C Technologies Co.",
    "A8F8C9": "NXP Semiconductor (Tianjin) LTD.",
    "DCB347": "SHENZHEN FAST TECHNOLOGIES CO.",
    "60292B": "TP-LINK TECHNOLOGIES CO.",
    "50804A": "Quectel Wireless Solutions Co.",
    "A486AE": "Quectel Wireless Solutions Co.",
    "58D391": "Quectel Wireless Solutions Co.",
    "FC3FA6": "eero inc.",
    "A024F9": "Chengdu InnovaTest Technology Co.",
    "0024AC": "Hangzhou DPtech Technologies Co.",
    "CC087B": "HUAWEI TECHNOLOGIES CO.",
    "601521": "Redarc Electronics",
    "E426D5": "Motorola Mobility LLC",
    "704777": "Ruckus Wireless",
    "00068F": "Telemonitor",
    "040067": "Stanley Black & Decker",
    "7830F5": "TBT Inc.",
    "88AF7B": "Nanjing Powercore Tech Co.",
    "8C8E0D": "zte corporation",
    "C47B80": "Protempis",
    "00090F": "Fortinet",
    "000CE6": "Fortinet",
    "9C8824": "PetroCloud LLC",
    "5C2FAF": "HomeWizard B.V.",
    "E04B41": "Hangzhou Beilian Low Carbon Technology Co.",
    "E0B98A": "Shenzhen Taike industrial automation company",
    "A8EE6D": "Fine Point-High Export",
    "F4E975": "New H3C Technologies Co.",
    "D4D4DA": "Espressif Inc.",
    "386407": "Qingdao Intelligent&Precise Electronics Co.",
    "1C63A5": "securityplatform",
    "280AEE": "Renesas Electronics (Penang) Sdn. Bhd.",
    "70AED5": "Apple",
    "4C22F3": "Arcadyan Corporation",
    "200C86": "GX India Pvt Ltd",
    "88B86F": "Infinix mobility limited",
    "C4EB43": "Sagemcom Broadband SAS",
    "C4EB41": "Sagemcom Broadband SAS",
    "743E39": "YUSUR Technology Co.",
    "385319": "34ED LLC DBA Centegix",
    "846082": "Hyperloop Technologies",
    "F04F7C": "Amazon Technologies Inc.",
    "4C74A7": "IEEE Registration Authority",
    "B8D4BC": "zte corporation",
    "F0A225": "Amazon Technologies Inc.",
    "D43A2C": "Google",
    "54C6FF": "New H3C Technologies Co.",
    "E8AACB": "Samsung Electronics Co.",
    "C4AAC4": "Zhejiang Dahua Technology Co.",
    "C4E5B1": "Suzhou PanKore Integrated Circuit Technology Co. Ltd.",
    "ACC4A9": "Fiberhome Telecommunication Technologies Co.",
    "7C949F": "Shenzhen iComm Semiconductor CO.",
    "3C2CA6": "Beijing Xiaomi Electronics Co.",
    "34F223": "Fujian Newland Communication Science Technology Co.",
    "94D86B": "nass magnet Hungária Kft.",
    "38A9EA": "HK DAPU ELECTRONIC TECHNOLOGY CO.",
    "24E50F": "Google",
    "E48E10": "CIG SHANGHAI CO LTD",
    "64DBF7": "Nokia Shanghai Bell Co.",
    "3CA2C3": "vivo Mobile Communication Co.",
    "1461A4": "Honor Device Co.",
    "D09686": "IEEE Registration Authority",
    "E8EF22": "Siemens Numerical Control Ltd.",
    "786C84": "Amazon Technologies Inc.",
    "94BE09": "China Mobile Group Device Co.",
    "E07526": "China Dragon Technology Limited",
    "5C475E": "Ring LLC",
    "54102E": "HUAWEI TECHNOLOGIES CO.",
    "94D54D": "HUAWEI TECHNOLOGIES CO.",
    "C091B9": "Amazon Technologies Inc.",
    "702804": "Realme Chongqing Mobile Telecommunications Corp.",
    "BCD0EB": "New H3C Technologies Co.",
    "605801": "Shandong ZTop Microelectronics Co.",
    "D8630D": "Motorola (Wuhan) Mobility Technologies Communication Co.",
    "9C635B": "zte corporation",
    "F8075D": "Huawei Device Co.",
    "98226E": "Amazon Technologies Inc.",
    "F8A4FB": "Nanjing Decowell Automation Co.",
    "24F0D3": "Samsung Electronics Co.",
    "582071": "Samsung Electronics Co.",
    "14DC51": "Xiamen Cheerzing IOT Technology Co.",
    "04331F": "Huawei Device Co.",
    "F89B6E": "Nokia Solutions and Networks GmbH & Co. KG",
    "E0C264": "Intel Corporate",
    "24DC0F": "Phytium Technology Co.",
    "684992": "Cisco Meraki",
    "D4BABA": "IEEE Registration Authority",
    "9CD8E3": "Wuhan Huazhong Numerical Control Co.",
    "60C7BE": "Realme Chongqing Mobile Telecommunications Corp.",
    "0404B8": "China Hualu Panasonic AVC Networks Co.",
    "40C2BA": "COMPAL INFORMATION (KUNSHAN) CO.",
    "18D6DD": "HUAWEI TECHNOLOGIES CO.",
    "FC1803": "HUAWEI TECHNOLOGIES CO.",
    "68962E": "HUAWEI TECHNOLOGIES CO.",
    "CC3DD1": "HUAWEI TECHNOLOGIES CO.",
    "54C45B": "Arcadyan Corporation",
    "80BC37": "Ruckus Wireless",
    "E001A6": "Edgecore Networks Corporation",
    "203626": "TP-Link Corporation Limited",
    "C0515C": "zte corporation",
    "7C2F80": "Gigaset Communications GmbH",
    "2CF2A5": "Sagemcom Broadband SAS",
    "4CFC22": "SHANGHAI HI-TECH CONTROL SYSTEM CO.",
    "943C96": "Sagemcom Broadband SAS",
    "30B0EA": "Shenzhen Chuangxin Internet Communication Technology Co.",
    "7CDCCC": "BEIJING STARBLAZE TECHNOLOGY CO.",
    "34479A": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "A41CB4": "DFI Inc",
    "401A58": "Wistron Neweb Corporation",
    "3C0268": "Infinera",
    "7408DE": "Fujian Landi Commercial Technology Co.",
    "10FC33": "Huawei Device Co.",
    "B08101": "Honor Device Co.",
    "485DED": "Sichuan Tianyi Comheart Telecom Co.",
    "5CFC6E": "Sichuan Tianyi Comheart Telecom Co.",
    "70B7E4": "Broadcom Limited",
    "1423F2": "Broadcom Limited",
    "94AD23": "Apple",
    "20A5CB": "Apple",
    "F421CA": "Apple",
    "BC89A7": "Apple",
    "CC5EF8": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "709C45": "HUAWEI TECHNOLOGIES CO.",
    "FC1263": "ASKEY COMPUTER CORP",
    "58305B": "Shanghai Junqian Sensing Technology Co.",
    "7C50DA": "E.J Ward",
    "5C0758": "Ufispace Co.",
    "A03131": "Procenne Digital Security",
    "C071AA": "ShenZhen OnMicro Electronics Co.",
    "FC0736": "Huawei Device Co.",
    "94A07D": "Huawei Device Co.",
    "142D79": "Fiberhome Telecommunication Technologies Co.",
    "E4ECE8": "Samsung Electronics Co.",
    "C8908A": "Samsung Electronics Co.",
    "403306": "Taicang T&W Electronics",
    "000BF8": "Infinera",
    "783EA1": "Nokia Shanghai Bell Co.",
    "84F44C": "International Integrated Systems.",
    "68B9C2": "Earda Technologies co Ltd",
    "D8E844": "zte corporation",
    "E46A35": "Realme Chongqing Mobile Telecommunications Corp.",
    "2004F3": "Honor Device Co.",
    "38E7C0": "Hui Zhou Gaoshengda Technology Co.",
    "F0C1CE": "GoodWe Technologies CO.",
    "906AEB": "Microsoft Corporation",
    "C4EB39": "Sagemcom Broadband SAS",
    "0052C8": "Made Studio Design Ltd.",
    "ECC07A": "Laird Connectivity",
    "C81EC2": "ITEL MOBILE LIMITED",
    "582B0A": "Texas Instruments",
    "089DF4": "Intel Corporate",
    "DC4628": "Intel Corporate",
    "0C9192": "Intel Corporate",
    "48AD9A": "Intel Corporate",
    "589A3E": "Amazon Technologies Inc.",
    "E838A0": "Vizio",
    "6865B7": "Zhishang Chuanglian Technology Co.",
    "9C0591": "Mellanox Technologies",
    "6883CB": "Apple",
    "88B863": "HISENSE VISUAL TECHNOLOGY CO.",
    "1C46D1": "SKY UK LIMITED",
    "003F10": "Shenzhen GainStrong Technology Co.",
    "8822B2": "Chipsea Technologies (Shenzhen) Corp.",
    "4802AF": "Telit Communication s.p.a",
    "FCC737": "Shaanxi Gangsion Electronic Technology Co.",
    "94286F": "zte corporation",
    "400EF3": "zte corporation",
    "743AF4": "Intel Corporate",
    "687A64": "Intel Corporate",
    "405EF6": "Samsung Electronics Co.",
    "945244": "Samsung Electronics Co.",
    "9C2E7A": "Samsung Electronics Co.",
    "7C6305": "Amazon Technologies Inc.",
    "D87E6F": "CASCINATION AG",
    "044F7A": "China Mobile Group Device Co.",
    "E4B555": "Huawei Device Co.",
    "2877B1": "Tri plus grupa d.o.o.",
    "5431D4": "TGW Mechanics GmbH",
    "E016B1": "Advanced Design Technology co.",
    "AC606F": "Nokia Shanghai Bell Co.",
    "BC0358": "Intel Corporate",
    "B4466B": "REALTIMEID AS",
    "C06911": "Arista Networks",
    "9401AC": "Wuhan Qianyang Iotian Technology Co.",
    "2C93FB": "Sercomm France Sarl",
    "7844FD": "TP-LINK TECHNOLOGIES CO.",
    "58C57E": "Fiberhome Telecommunication Technologies Co.",
    "4C312D": "Sichuan AI-Link Technology Co.",
    "C04E30": "Espressif Inc.",
    "AC15A2": "TP-Link Corporation Limited",
    "2418C0": "E. Wehrle GmbH",
    "0021D0": "Global Display Solutions Spa",
    "D4E22F": "Roku",
    "B8B409": "Samsung Electronics Co.",
    "C43CB0": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
    "ACDF9F": "Arcadyan Corporation",
    "B859C8": "70mai Co.",
    "145BB9": "ConMet",
    "C82496": "Jiangsu Yinhe  Electronics Co.",
    "A8E207": "GOIP Global Services Pvt. Ltd.",
    "E0F678": "Fiberhome Telecommunication Technologies Co.",
    "28F7D6": "Fiberhome Telecommunication Technologies Co.",
    "402230": "Shenzhen SuperElectron Technology Co.",
    "0830CE": "Fiberhome Telecommunication Technologies Co.",
    "14130B": "Garmin International",
    "90235B": "Amazon Technologies Inc.",
    "1CBCEC": "silex technology",
    "34CF6C": "Hangzhou Taili wireless communication equipment Co.",
    "489BE0": "Realme Chongqing Mobile Telecommunications Corp.",
    "5CFA25": "Sagemcom Broadband SAS",
    "F8CDC8": "Sichuan Tianyi Comheart Telecom Co.",
    "64D814": "Cisco Systems",
    "7C11CD": "QianTang Technology",
    "447F77": "Connected Home",
    "749779": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "B0285B": "JUHUA Technology Inc.",
    "403B7B": "Huawei Device Co.",
    "90CD1F": "Quectel Wireless Solutions Co.",
    "F0B661": "eero inc.",
    "0425F0": "Nokia",
    "4857D2": "Broadcom Limited",
    "9C2183": "Broadcom Limited",
    "C8EBEC": "Shenzhen YOUHUA Technology Co.",
    "047C16": "Micro-Star INTL CO.",
    "001794": "Cisco Systems",
    "D834EE": "SHURE INCORPORATED",
    "94C5A6": "ITEL MOBILE LIMITED",
    "E06A05": "Shenzhen YOUHUA Technology Co.",
    "404244": "Cisco Systems",
    "04B6BE": "CIG SHANGHAI CO LTD",
    "E0D738": "WireStar Networks",
    "FCB97E": "GE Appliances",
    "30E8E4": "Qorvo International Pte. Ltd.",
    "5CE91E": "Apple",
    "88034C": "WEIFANG GOERTEK ELECTRONICS CO.",
    "48DC9D": "Grandprint(Beijing) Technology Co.",
    "64FD96": "Sagemcom Broadband SAS",
    "64989E": "TRINNOV AUDIO",
    "F4CE46": "Hewlett Packard",
    "BCC746": "Hon Hai Precision IND.CO.",
    "7CECB1": "Apple",
    "281293": "Honor Device Co.",
    "C0A938": "HUAWEI TECHNOLOGIES CO.",
    "9CBFCD": "HUAWEI TECHNOLOGIES CO.",
    "B89FCC": "HUAWEI TECHNOLOGIES CO.",
    "3425BE": "Amazon Technologies Inc.",
    "9CE041": "Nokia",
    "783486": "Nokia",
    "F0D415": "Intel Corporate",
    "D4D853": "Intel Corporate",
    "643172": "ZHEJIANG HISING TECHNOLOGY CO.",
    "D0FCD0": "HUMAX Co.",
    "20FADB": "Huahao Kunpeng Technology (chengDu)  Co.",
    "0C8B95": "Espressif Inc.",
    "DCBE49": "ITEL MOBILE LIMITED",
    "9C9561": "Hui Zhou Gaoshengda Technology Co.",
    "C0EDE5": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "10A562": "Iton Technology Corp.",
    "0463D0": "Huawei Device Co.",
    "14448F": "Edgecore Networks Corporation",
    "9C4F5F": "Google",
    "78152D": "UNION CHIP TECHNOLOGY LIMITED",
    "38AB41": "Texas Instruments",
    "CC4792": "ASIX Electronics Corporation",
    "E046EE": "NETGEAR",
    "5876AC": "SERNET (SUZHOU) TECHNOLOGIES CORPORATION",
    "50DCD0": "Observint Technologies",
    "A02942": "Intel Corporate",
    "1071B3": "Zyxel Communications Corporation",
    "1869D4": "Samsung Electronics Co.",
    "685E1C": "Texas Instruments",
    "D4F0EA": "Beijing Xiaomi Mobile Software Co.",
    "5C24E2": "Suzhou Denbom Electronic S&T Co.",
    "E0036B": "Samsung Electronics Co.",
    "00A554": "Intel Corporate",
    "581122": "ASUSTek COMPUTER INC.",
    "74694A": "Sichuan Tianyi Comheart Telecom Co.",
    "00B0EE": "Ajile Systems",
    "B87EE5": "Intelbras",
    "A854A2": "Heimgard Technologies AS",
    "60BEB4": "S-Bluetech co.",
    "90DF7D": "Realme Chongqing Mobile Telecommunications Corp.",
    "0C8629": "IEEE Registration Authority",
    "50C1F0": "NXP Semiconductor (Tianjin) LTD.",
    "F4848D": "TP-LINK TECHNOLOGIES CO.",
    "94ABFE": "Nokia",
    "BC1D89": "Motorola Mobility LLC",
    "98A92D": "New H3C Technologies Co.",
    "30F70D": "Cisco Systems",
    "742A8A": "shenzhen worldelite electronics co.",
    "E47305": "Shenzhen INVT Electric CO.",
    "B01B4B": "Invisible Fun Studio Limited",
    "B4B742": "Amazon Technologies Inc.",
    "78A03F": "Amazon Technologies Inc.",
    "5046AE": "MERCURY CORPORATION",
    "B099D7": "Samsung Electronics Co.",
    "747446": "Google",
    "7820A5": "Nintendo Co.",
    "2078CD": "Apple",
    "30D53E": "Apple",
    "5023A2": "Apple",
    "98698A": "Apple",
    "78FBD8": "Apple",
    "A4C337": "Apple",
    "B0F1D8": "Apple",
    "D0880C": "Apple",
    "1C57DC": "Apple",
    "604F5B": "Huawei Device Co.",
    "24813B": "Cisco Systems",
    "0CB8E8": "Renesas Electronics (Penang) Sdn. Bhd.",
    "E8F375": "Nokia",
    "E831CD": "Espressif Inc.",
    "A069D9": "New H3C Technologies Co.",
    "20FE00": "Amazon Technologies Inc.",
    "F421AE": "Shanghai Xiaodu Technology Limited",
    "F412FA": "Espressif Inc.",
    "B0F208": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
    "F0B2B9": "Intel Corporate",
    "DC99FE": "Armatura LLC",
    "F0A654": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "9CF155": "Nokia",
    "EC5C84": "Murata Manufacturing Co.",
    "C0886D": "Securosys SA",
    "487412": "OnePlus Technology (Shenzhen) Co.",
    "14DCE2": "THALES AVS France",
    "6CD869": "Guangzhou Sat Infrared Co.",
    "C89BD7": "Realme Chongqing Mobile Telecommunications Corp.",
    "28B133": "SHINEMAN(SHENZHEN) Tech. Cor.",
    "985F4F": "Tongfang Computer Co.",
    "34F86E": "Parker Hannifin Corporation",
    "0CAEBD": "Edifier International",
    "A8E621": "Amazon Technologies Inc.",
    "3CCFB4": "Telink Semiconductor (Shanghai) Co.",
    "043CE8": "Shenzhen SuperElectron Technology Co.",
    "74E6B8": "LG Electronics",
    "28D0F5": "Ruijie Networks Co.",
    "941865": "NETGEAR",
    "A8587C": "Shoogee GmbH & Co. KG",
    "381EC7": "Chipsea Technologies(Shenzhen) Corp.",
    "90F260": "Shenzhen Honesty Electronics Co.",
    "1889CF": "TECNO MOBILE LIMITED",
    "D004B0": "Samsung Electronics Co.",
    "98B08B": "Samsung Electronics Co.",
    "9C2595": "Samsung Electronics Co.",
    "04BD97": "Cisco Systems",
    "541651": "Ruijie Networks Co.",
    "60BC4C": "EWM Hightec Welding GmbH",
    "0C2369": "Honeywell SPS",
    "AC0425": "ball-b GmbH Co KG",
    "A81710": "Bouffalo Lab (Nanjing) Co.",
    "086AE5": "Amazon Technologies Inc.",
    "4CE0DB": "Xiaomi Communications Co Ltd",
    "7C33F9": "HUAWEI TECHNOLOGIES CO.",
    "E8EECC": "Fantasia Trading LLC",
    "84160C": "Broadcom Limited",
    "209BE6": "Guangzhou Shiyuan Electronic Technology Company Limited",
    "7087A7": "Murata Manufacturing Co.",
    "48352B": "Apple",
    "4CE6C0": "Apple",
    "3888A4": "Apple",
    "44DA30": "Apple",
    "A08069": "Intel Corporate",
    "F438C1": "Huawei Device Co.",
    "28EA2D": "Apple",
    "B8E60C": "Apple",
    "38F7F1": "Huawei Device Co.",
    "4076A9": "Huawei Device Co.",
    "A06720": "China Dragon Technology Limited",
    "94C9B7": "IEEE Registration Authority",
    "2072A9": "Beijing Xiaomi Electronics Co.",
    "1C869A": "Samsung Electronics Co.",
    "70A8D3": "Intel Corporate",
    "D8FBD6": "Amazon Technologies Inc.",
    "9C47F9": "LJU Automatisierungstechnik GmbH",
    "00064D": "Sencore",
    "D0622C": "Xi'an Yipu Telecom Technology Co.",
    "E05689": "Lootom Telcovideo Network (Wuxi) Co Ltd",
    "2C3358": "Intel Corporate",
    "206296": "Shenzhen Malio Technology Co.",
    "8CB094": "Airtech I&C Co.",
    "EC6488": "Honor Device Co.",
    "98BEDC": "Honor Device Co.",
    "5058B0": "Hunan Greatwall Computer System Co.",
    "3C869A": "HUAWEI TECHNOLOGIES CO.",
    "E06CF6": "ESSENCORE limited",
    "78C62B": "FUJIAN STAR-NET COMMUNICATION CO.",
    "D46624": "Cisco Systems",
    "A02BB8": "Hewlett Packard",
    "2C2768": "HUAWEI TECHNOLOGIES CO.",
    "546990": "HUAWEI TECHNOLOGIES CO.",
    "D80A60": "HUAWEI TECHNOLOGIES CO.",
    "0CC6FD": "Xiaomi Communications Co Ltd",
    "50DAD6": "Xiaomi Communications Co Ltd",
    "D4F98D": "Espressif Inc.",
    "9C9019": "Beyless",
    "E42761": "Honor Device Co.",
    "A06974": "Honor Device Co.",
    "14019C": "Ubyon Inc.",
    "0434F6": "Motorola (Wuhan) Mobility Technologies Communication Co.",
    "546925": "PS INODIC CO.",
    "7813E0": "FUJIAN STAR-NET COMMUNICATION CO.",
    "4861EE": "Samsung Electronics Co.",
    "A84B4D": "Samsung Electronics Co.",
    "F4F309": "Samsung Electronics Co.",
    "086F48": "Shenzhen iComm Semiconductor CO.",
    "E8CBED": "Chipsea Technologies(Shenzhen) Corp.",
    "D07880": "Fiberhome Telecommunication Technologies Co.",
    "14CB65": "Microsoft Corporation",
    "7857B0": "GERTEC BRASIL LTDA",
    "3408E1": "Texas Instruments",
    "18B96E": "Dongguan Liesheng Electronic Co.",
    "64BE63": "STORDIS GmbH",
    "F89522": "HUAWEI TECHNOLOGIES CO.",
    "F8B132": "HUAWEI TECHNOLOGIES CO.",
    "C4F122": "Nexar Ltd.",
    "6007C4": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "E84727": "Quectel Wireless Solutions Co.",
    "28C538": "Apple",
    "0499B9": "Apple",
    "78028B": "Apple",
    "4448FF": "Qingdao Haier Technology Co.",
    "04C461": "Murata Manufacturing Co.",
    "A08222": "Qingdao Haier Technology Co.",
    "E01F2B": "Nokia Solutions and Networks GmbH & Co. KG",
    "0816D5": "GOERTEK INC.",
    "D4D7CF": "Realme Chongqing Mobile Telecommunications Corp.",
    "F4E4D7": "FUJIAN STAR-NET COMMUNICATION CO.",
    "F84E17": "Sony Corporation",
    "A8C266": "HUMAX Co.",
    "AC8226": "Qingdao Haier Technology Co.",
    "C8CB9E": "Intel Corporate",
    "540F57": "Silicon Laboratories",
    "F84D89": "Apple",
    "BCDB09": "Cisco Meraki",
    "9C2BA6": "Ruijie Networks Co.",
    "941457": "Shenzhen Sundray Technologies Company Limited",
    "B898AD": "Motorola Mobility LLC",
    "64B94E": "Dell Technologies",
    "5447E8": "Syrotech Networks. Ltd.",
    "EC2BEB": "Amazon Technologies Inc.",
    "1CAE3E": "IEEE Registration Authority",
    "D0C35A": "Jabil Circuit de Chihuahua",
    "84B630": "Sichuan Tianyi Comheart Telecom Co.",
    "3C5576": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "90EB48": "Shanghai XinMiaoLink Technology Co.",
    "185345": "Nokia",
    "E48210": "HUAWEI TECHNOLOGIES CO.",
    "7052D8": "ITEL MOBILE LIMITED",
    "001D5B": "Tecvan Informatica Ltda",
    "1C568E": "Zioncom Electronics (Shenzhen) Ltd.",
    "28563A": "Fiberhome Telecommunication Technologies Co.",
    "BC5729": "Shenzhen KKM Co.",
    "0CCAFB": "TPVision Europe B.V",
    "F8F7B9": "HUAWEI TECHNOLOGIES CO.",
    "207BD2": "ASIX Electronics Corporation",
    "687724": "TP-LINK TECHNOLOGIES CO.",
    "182DF7": "JY COMPANY",
    "EC2C11": "CWD INNOVATION LIMITED",
    "D86C5A": "HUMAX Co.",
    "E4C0E2": "Sagemcom Broadband SAS",
    "4C3FA7": "uGrid Network Inc.",
    "545284": "Huawei Device Co.",
    "646140": "Huawei Device Co.",
    "C4170E": "Huawei Device Co.",
    "F0CD31": "Samsung Electronics Co.",
    "6401FB": "Landis+Gyr GmbH",
    "F03575": "Hui Zhou Gaoshengda Technology Co.",
    "908175": "Samsung Electronics Co.",
    "307467": "Samsung Electronics Co.",
    "58C7AC": "New H3C Technologies Co.",
    "7C8334": "IEEE Registration Authority",
    "249745": "HUAWEI TECHNOLOGIES CO.",
    "C0F535": "AMPAK Technology",
    "8C3DB1": "Beijing H-IoT Technology Co.",
    "F4239C": "SERNET (SUZHOU) TECHNOLOGIES CORPORATION",
    "FCA64C": "Alibaba cloud computing Co.",
    "E069BA": "Cisco Systems",
    "2436DA": "Cisco Systems",
    "4CEBD6": "Espressif Inc.",
    "F8B54D": "Intel Corporate",
    "38A8CD": "IEEE Registration Authority",
    "546706": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "D8A6F0": "Wu Qi Technologies",
    "08E4DF": "Shenzhen Sande Dacom Electronics Co.",
    "145808": "Taicang T&W Electronics",
    "C4E532": "Arcadyan Corporation",
    "105A17": "Tuya Smart Inc.",
    "008A76": "Apple",
    "2037A5": "Apple",
    "DCB54F": "Apple",
    "B8374A": "Apple",
    "EC7C2C": "HUAWEI TECHNOLOGIES CO.",
    "24F603": "HUAWEI TECHNOLOGIES CO.",
    "08FA28": "HUAWEI TECHNOLOGIES CO.",
    "F4B19C": "AltoBeam (China) Inc.",
    "A8D081": "Huawei Device Co.",
    "ECC1AB": "Guangzhou Shiyuan Electronic Technology Company Limited",
    "1C9DC2": "Espressif Inc.",
    "906A94": "hangzhou huacheng network technology co.",
    "100C29": "Shenzhen NORCO lntelligent Technology Co.",
    "0000C8": "ALTOS COMPUTER SYSTEMS",
    "7432C2": "KYOLIS",
    "640E9B": "ISHIDA MEDICAL CO.",
    "2442BC": "Alinco",
    "18FC26": "Qorvo International Pte. Ltd.",
    "00CE30": "Express LUCK Industrial Ltd.",
    "5C8382": "Nokia",
    "283613": "IEEE Registration Authority",
    "0CAAEE": "Ansjer Electronics Co.",
    "6C11B3": "Wu Qi Technologies",
    "1C2CE0": "Shanghai  Mountain View Silicon",
    "740CEE": "Huawei Device Co.",
    "6CB4FD": "Huawei Device Co.",
    "0C0E76": "D-Link International",
    "38B800": "Wistron Neweb Corporation",
    "703E97": "Iton Technology Corp.",
    "104738": "Nokia Shanghai Bell Co.",
    "A0941A": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "F8CA85": "NEC Corporation",
    "DCED83": "Beijing Xiaomi Mobile Software Co.",
    "AC0BFB": "Espressif Inc.",
    "B41CAB": "ICR",
    "CC312A": "HUIZHOU TCL COMMUNICATION ELECTRON CO.",
    "300EB8": "LG Electronics",
    "945AFC": "Amazon Technologies Inc.",
    "00D76D": "Intel Corporate",
    "2C1165": "Silicon Laboratories",
    "1C2A8B": "Nokia",
    "BC3329": "Sony Interactive Entertainment Inc.",
    "A88940": "Huawei Device Co.",
    "30B037": "New H3C Technologies Co.",
    "20B868": "Motorola Mobility LLC",
    "289C6E": "Shanghai High-Flying Electronics  Technology Co.",
    "FC122C": "HUAWEI TECHNOLOGIES CO.",
    "6CD1E5": "HUAWEI TECHNOLOGIES CO.",
    "84F703": "Espressif Inc.",
    "A85B36": "IEEE Registration Authority",
    "3039A9": "Hongshan Information Science and Technology (HangZhou) Co.",
    "FCD908": "Xiaomi Communications Co Ltd",
    "D0167C": "eero inc.",
    "84144D": "Intel Corporate",
    "44D5CC": "Amazon Technologies Inc.",
    "485A67": "Shaanxi Ruixun Electronic Information Technology Co.",
    "9C6BF0": "Shenzhen Yipingfang Network Technology Co.",
    "44953B": "RLTech India Private Limited",
    "4C77CB": "Intel Corporate",
    "64C403": "Quectel Wireless Solutions Co.",
    "EC9468": "META SYSTEM SPA",
    "1C4190": "Universal Electronics",
    "00005B": "ELTEC ELEKTRONIK AG",
    "945C9A": "Apple",
    "00F39F": "Apple",
    "64C394": "HUAWEI TECHNOLOGIES CO.",
    "8C1F64": "IEEE Registration Authority",
    "F47B09": "Intel Corporate",
    "E87829": "IEEE Registration Authority",
    "50325F": "Silicon Laboratories",
    "FC8A3D": "zte corporation",
    "705FA3": "Xiaomi Communications Co Ltd",
    "3C62F0": "Sercomm Corporation.",
    "983B67": "DWnet Technologies(Suzhou) Corporation",
    "085A11": "D-Link International",
    "6C9392": "BEKO Technologies GmbH",
    "58355D": "Huawei Device Co.",
    "AC7E01": "Huawei Device Co.",
    "D01769": "Murata Manufacturing Co.",
    "3CBDD8": "LG ELECTRONICS INC",
    "54C250": "Iskratel d.o.o.",
    "00FAB6": "Kontakt Micro-Location Sp z o.o.",
    "30B346": "CJSC NORSI-TRANS",
    "0004B8": "Kumahira Co.",
    "000B3A": "PESA Inc.",
    "A0B086": "Hirschmann Automation and Control GmbH",
    "F0C814": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
    "1874E2": "IEEE Registration Authority",
    "70B950": "Texas Instruments",
    "781C5A": "SHARP Corporation",
    "C45E5C": "HUAWEI TECHNOLOGIES CO.",
    "5CE42A": "Intel Corporate",
    "20C19B": "Intel Corporate",
    "2C6DC1": "Intel Corporate",
    "7CF462": "BEIJING HUAWOO TECHNOLOGIES CO.LTD",
    "D09FD9": "IEEE Registration Authority",
    "04B9E3": "Samsung Electronics Co.",
    "94AA0A": "Fiberhome Telecommunication Technologies Co.",
    "E85C0A": "Cisco Systems",
    "C8059E": "Hefei Symboltek Co.",
    "34FCA1": "Micronet union Technology(Chengdu)Co.",
    "107BCE": "Nokia",
    "2897B8": "myenergi Ltd",
    "20415A": "Smarteh d.o.o.",
    "B0A7B9": "TP-Link Corporation Limited",
    "6C5AB0": "TP-Link Corporation Limited",
    "60E6F0": "Wistron Neweb Corporation",
    "C8F5D6": "IEEE Registration Authority",
    "9843FA": "Intel Corporate",
    "20D276": "ITEL MOBILE LIMITED",
    "08A842": "Huawei Device Co.",
    "B825B5": "Trakm8 Ltd",
    "405899": "Logitech Far East",
    "F44E38": "Olibra LLC",
    "201F3B": "Google",
    "A0D722": "Samsung Electronics Co.",
    "5049B0": "Samsung Electronics Co.",
    "000CDF": "JAI Manufacturing",
    "C4A151": "Sichuan Tianyi Comheart Telecom Co.",
    "7847E3": "Sichuan Tianyi Comheart Telecom Co.",
    "0000B8": "SEIKOSHA CO.",
    "D035E5": "EM Microelectronic",
    "9096F3": "BUFFALO.INC",
    "540E58": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "5C648E": "Zyxel Communications Corporation",
    "30E396": "Huawei Device Co.",
    "D07D33": "Huawei Device Co.",
    "C0E1BE": "HUAWEI TECHNOLOGIES CO.",
    "88E056": "HUAWEI TECHNOLOGIES CO.",
    "2C8DB1": "Intel Corporate",
    "586C25": "Intel Corporate",
    "2CC81B": "Routerboard.com",
    "042728": "Microsoft Corporation",
    "A49BCD": "Cisco Systems",
    "B4E3F9": "Silicon Laboratories",
    "2066CF": "FREEBOX SAS",
    "F092B4": "Sichuan Tianyi Comheart Telecom Co.",
    "ECF8EB": "Sichuan Tianyi Comheart Telecom Co.",
    "2C6373": "Sichuan Tianyi Comheart Telecom Co.",
    "E0925C": "Apple",
    "00116C": "Nanwang Multimedia Inc.",
    "28F49B": "LEETEK",
    "1842D4": "Wuhan Hosan Telecommunication Technology Co.",
    "A8637D": "D-Link International",
    "D8E72B": "NETSCOUT SYSTEMS INC",
    "78E36D": "Espressif Inc.",
    "145AFC": "Liteon Technology Corporation",
    "EC153D": "Beijing Yaxunhongda Technology Co.",
    "D8A35C": "Samsung Electronics Co.",
    "C09296": "zte corporation",
    "50E24E": "zte corporation",
    "2C43BE": "Sunnovo International Limited",
    "5810B7": "Infinix mobility limited",
    "1C9180": "Apple",
    "4CB910": "Apple",
    "B48901": "HUAWEI TECHNOLOGIES CO.",
    "449BC1": "HUAWEI TECHNOLOGIES CO.",
    "2025D2": "Fiberhome Telecommunication Technologies Co.",
    "34865D": "Espressif Inc.",
    "000139": "Point Multimedia Systems",
    "B02491": "Huawei Device Co.",
    "98751A": "Huawei Device Co.",
    "18BFB3": "Samsung Electronics Co.",
    "082CED": "Technity Solutions Inc.",
    "1CA0EF": "IEEE Registration Authority",
    "6C1B3F": "MiraeSignal Co.",
    "B03DC2": "Wasp artificial intelligence(Shenzhen) Co.",
    "C84D34": "LIONS Taiwan Technology Inc.",
    "446FF8": "Dyson Limited",
    "9C7613": "Ring LLC",
    "D097FE": "Realme Chongqing Mobile Telecommunications Corp.",
    "843A5B": "Inventec(Chongqing) Corporation",
    "28AFFD": "Cisco Systems",
    "EC9365": "Mapper.ai",
    "D8EB46": "Google",
    "781053": "China Mobile Group Device Co.",
    "F83E95": "HUAWEI TECHNOLOGIES CO.",
    "481258": "HUAWEI TECHNOLOGIES CO.",
    "CC3296": "Huawei Device Co.",
    "2C17E0": "SYSTEMES ET TECHNOLOGIES IDENTIFICATION (STid)",
    "5449DF": "Peloton Interactive",
    "98CDAC": "Espressif Inc.",
    "808AF7": "Nanoleaf",
    "182A57": "HUAWEI TECHNOLOGIES CO.",
    "08474C": "Nokia",
    "90C119": "Nokia",
    "D8CD2C": "WUXI NEIHUA NETWORK TECHNOLOGY CO.",
    "7CF880": "Cisco Systems",
    "60A751": "Huawei Device Co.",
    "102B41": "Samsung Electronics Co.",
    "344AC3": "HuNan ZiKun Information Technology CO.",
    "981A35": "HUAWEI TECHNOLOGIES CO.",
    "00E421": "Sony Interactive Entertainment Inc.",
    "D85ED3": "GIGA-BYTE TECHNOLOGY CO.",
    "249AD8": "YEALINK(XIAMEN) NETWORK TECHNOLOGY CO.",
    "F845C4": "Shenzhen Netforward Micro-Electronic Co.",
    "682D83": "SHENZHEN DINGHE COMMUNICATION COMPANY",
    "A84397": "Innogrit Corporation",
    "8CAACE": "Xiaomi Communications Co Ltd",
    "E89F39": "Nokia",
    "B0227A": "HP Inc.",
    "803428": "Microchip Technology Inc.",
    "403F8C": "TP-LINK TECHNOLOGIES CO.",
    "CCDB04": "DataRemote Inc.",
    "04D6F4": "GD Midea Air-Conditioning Equipment Co.",
    "D4351D": "Technicolor Delivery Technologies Belgium NV",
    "F8AA3F": "DWnet Technologies(Suzhou) Corporation",
    "0CCF89": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
    "0C8C69": "Shenzhen elink smart Co.",
    "C89402": "CHONGQING FUGUI ELECTRONICS CO.",
    "7CB94C": "Bouffalo Lab (Nanjing) Co.",
    "C833E5": "HUAWEI TECHNOLOGIES CO.",
    "B844AE": "TCT mobile ltd",
    "00682B": "Huawei Device Co.",
    "98AD1D": "Huawei Device Co.",
    "F077C3": "Intel Corporate",
    "049081": "Pensando Systems",
    "4C796E": "Intel Corporate",
    "F09E4A": "Intel Corporate",
    "AC5AFC": "Intel Corporate",
    "D8BBC1": "Micro-Star INTL CO.",
    "DC15C8": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
    "6CD630": "Rootous System Co.",
    "84D343": "Calix Inc.",
    "38B5D3": "SecuWorks",
    "B068E6": "CHONGQING FUGUI ELECTRONICS CO.",
    "34318F": "Apple",
    "C41411": "Apple",
    "CCC95D": "Apple",
    "7061BE": "Wistron Neweb Corporation",
    "D847BB": "Huawei Device Co.",
    "E86DE9": "HUAWEI TECHNOLOGIES CO.",
    "144658": "HUAWEI TECHNOLOGIES CO.",
    "58BE72": "HUAWEI TECHNOLOGIES CO.",
    "108FFE": "HUAWEI TECHNOLOGIES CO.",
    "446FD8": "IEEE Registration Authority",
    "BCD7CE": "China Mobile (Hangzhou) Information Technology Co.",
    "9CA570": "eero inc.",
    "A0412D": "Lansen Systems AB",
    "2CDD0C": "Discovergy GmbH",
    "BC9D42": "SHENZHEN RF-LINK TECHNOLOGY CO.",
    "240B88": "Taicang T&W Electronics",
    "0C938F": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "C43960": "GD Midea Air-Conditioning Equipment Co.",
    "44B6BE": "Cisco Systems",
    "8CDEE6": "Samsung Electronics Co.",
    "10EC81": "Samsung Electronics Co.",
    "C45D83": "Samsung Electronics Co.",
    "9C9C1F": "Espressif Inc.",
    "D809D6": "ZEXELON CO.",
    "5CA4A4": "Fiberhome Telecommunication Technologies Co.",
    "5CBD9A": "Huawei Device Co.",
    "14A3B4": "Huawei Device Co.",
    "EC75ED": "Citrix Systems",
    "7404F0": "Mobiwire Mobiles (NingBo) Co.",
    "B4B5B6": "CHONGQING FUGUI ELECTRONICS CO.",
    "047A0B": "Beijing Xiaomi Electronics Co.",
    "900F0C": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "4C1154": "Mobiwire Mobiles (NingBo) Co.",
    "C4BF60": "TECNO MOBILE LIMITED",
    "D040EF": "Murata Manufacturing Co.",
    "2C9AA4": "Eolo SpA",
    "18D5B6": "SMG Holdings LLC",
    "70F096": "Cisco Systems",
    "A453EE": "IEEE Registration Authority",
    "C8A40D": "Cooler Master Technology Inc",
    "BC9A53": "Huawei Device Co.",
    "DC2727": "Huawei Device Co.",
    "F042F5": "Huawei Device Co.",
    "E02E3F": "Huawei Device Co.",
    "002236": "VECTOR SP. Z O.O.",
    "001340": "AD.EL s.r.l.",
    "4C7525": "Espressif Inc.",
    "D056BF": "AMOSENSE",
    "508E49": "Xiaomi Communications Co Ltd",
    "608D26": "Arcadyan Corporation",
    "1C3929": "OHSUNG",
    "80B97A": "eero inc.",
    "8CF319": "Siemens Industrial Automation Products Ltd.",
    "48701E": "Texas Instruments",
    "AC3328": "Huawei Device Co.",
    "78CB2C": "Join Digital",
    "8C476E": "IEEE Registration Authority",
    "74D6CB": "New H3C Technologies Co.",
    "0C3AFA": "New H3C Technologies Co.",
    "B00CD1": "Hewlett Packard",
    "2CF05D": "Micro-Star INTL CO.",
    "30A023": "ROCK PATH S.R.L",
    "E848B8": "TP-Link Corporation Limited",
    "0002F4": "PCTEL",
    "309E1D": "OHSUNG",
    "687912": "IEEE Registration Authority",
    "F8665A": "Apple",
    "6CE874": "HUAWEI TECHNOLOGIES CO.",
    "C469F0": "HUAWEI TECHNOLOGIES CO.",
    "BC9930": "HUAWEI TECHNOLOGIES CO.",
    "60BEC4": "Apple",
    "F8B1DD": "Apple",
    "A8817E": "Apple",
    "18B6CC": "We Corporation Inc.",
    "64037F": "Samsung Electronics Co.",
    "B49D02": "Samsung Electronics Co.",
    "809FF5": "Samsung Electronics Co.",
    "E0C377": "Samsung Electronics Co.",
    "4CFBF4": "Optimal Audio Ltd",
    "DCB72E": "Xiaomi Communications Co Ltd",
    "F86D73": "Zengge Co.",
    "E02BE9": "Intel Corporate",
    "588694": "EFM Networks",
    "AC3728": "Taicang T&W Electronics",
    "20CD6E": "Realme Chongqing Mobile Telecommunications Corp.",
    "E868E7": "Espressif Inc.",
    "D0BCC1": "WEIFANG GOERTEK ELECTRONICS CO.",
    "B40EDE": "Intel Corporate",
    "647924": "Huawei Device Co.",
    "D8CC98": "Huawei Device Co.",
    "C8B6D3": "HUAWEI TECHNOLOGIES CO.",
    "E04BA6": "HUAWEI TECHNOLOGIES CO.",
    "DC4A9E": "IEEE Registration Authority",
    "C033DA": "Shenzhen JRUN Technologies CO.",
    "A87484": "zte corporation",
    "FC8D3D": "Leapfive Tech. Ltd.",
    "BC69CB": "Panasonic Electric Works Networks Co.",
    "089356": "HUAWEI TECHNOLOGIES CO.",
    "6C146E": "HUAWEI TECHNOLOGIES CO.",
    "44E968": "HUAWEI TECHNOLOGIES CO.",
    "DCB7FC": "Alps Electric (Ireland) Ltd",
    "ACFAA5": "digitron",
    "78C95E": "Midmark RTLS",
    "4014AD": "Huawei Device Co.",
    "44CE3A": "Jiangsu Huacun Electronic Technology Co.",
    "9C1EA4": "Renesas Electronics (Penang) Sdn. Bhd.",
    "4CEF56": "Shenzhen Sundray Technologies Company Limited",
    "E84F4B": "Shenzhen Delos Electronic Co.",
    "B04A39": "Beijing Roborock Technology Co.",
    "A4F9E4": "AirVine Scientific",
    "F44FD3": "shenzhen hemuwei technology co.",
    "001FB8": "Universal Remote Control",
    "800384": "Ruckus Wireless",
    "D8373B": "Shenzhen Jingxun Software Telecommunication Technology Co.",
    "A8301C": "Qingdao Intelligent&Precise Electronics Co.",
    "FC45C3": "Texas Instruments",
    "AC6AA3": "Shenzhen Kertong Technology Co.",
    "3CE038": "Omnifi Inc.",
    "8493A0": "Huawei Device Co.",
    "9C8E9C": "Huawei Device Co.",
    "FC698C": "ANDREAS STIHL AG & Co. KG",
    "6C2D24": "Zhen Shi Information Technology (Shanghai) Co.",
    "7C78B2": "Wyze Labs Inc",
    "0060E9": "ATOP TECHNOLOGIES",
    "E4C32A": "TP-LINK TECHNOLOGIES CO.",
    "909A4A": "TP-LINK TECHNOLOGIES CO.",
    "BC9789": "Huawei Device Co.",
    "684571": "Huawei Device Co.",
    "AC122F": "Fantasia Trading LLC",
    "607072": "SHENZHEN HONGDE SMART LINK TECHNOLOGY CO.",
    "B8AE1C": "Smart Cube.",
    "141B30": "Shenzhen Yipingfang Network Technology Co.",
    "B8477A": "Dasan Electron Co.",
    "B4ADA3": "Guangzhou Shiyuan Electronic Technology Company Limited",
    "6CADAD": "CHONGQING FUGUI ELECTRONICS CO.",
    "CCE0DA": "Baidu Online Network Technology (Beijing) Co.",
    "408C4C": "Shenzhen MiaoMing  Intelligent Technology Co.",
    "D4482D": "Shenzhen Deejoy Lighting Technology Co.",
    "78E3DE": "Apple",
    "D0D23C": "Apple",
    "64D2C4": "Apple",
    "DC5285": "Apple",
    "E88152": "Apple",
    "D8F3BC": "Liteon Technology Corporation",
    "F46FED": "Fiberhome Telecommunication Technologies Co.",
    "94B97E": "Espressif Inc.",
    "642315": "Huawei Device Co.",
    "A4C74B": "Huawei Device Co.",
    "908158": "Apple",
    "D8F8AF": "DAONTEC",
    "E4842B": "HANGZHOU SOFTEL OPTIC CO.",
    "94026B": "Optictimes Co.",
    "084296": "Mobile Technology Solutions LLC",
    "34EFB6": "Edgecore Networks Corporation",
    "E874C7": "Sentinhealth",
    "18FDCB": "IEEE Registration Authority",
    "4487DB": "Tymphany Acoustic Technology (Huizhou) Co.",
    "C81739": "ITEL MOBILE LIMITED",
    "58D061": "HUAWEI TECHNOLOGIES CO.",
    "009023": "ZILOG INC.",
    "001C7B": "Castlenet Technology Inc.",
    "B0FEE5": "Huawei Device Co.",
    "04C1D8": "Huawei Device Co.",
    "C8BC9C": "Huawei Device Co.",
    "90CCDF": "Intel Corporate",
    "B8D309": "Cox Communications",
    "085BD6": "Intel Corporate",
    "6CBAB8": "Sagemcom Broadband SAS",
    "E0D464": "Intel Corporate",
    "C0F6C2": "HUAWEI TECHNOLOGIES CO.",
    "689320": "New H3C Technologies Co.",
    "9454CE": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "388ABE": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "047E23": "China Mobile IOT Company Limited",
    "14CCB3": "AO GK NATEKS",
    "60077C": "Jala Group",
    "8C8D28": "Intel Corporate",
    "343EA4": "Ring LLC",
    "5484DC": "zte corporation",
    "38549B": "zte corporation",
    "DCCD2F": "Seiko Epson Corporation",
    "609866": "Texas Instruments",
    "D8778B": "Intelbras",
    "30C9AB": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "007E56": "China Dragon Technology Limited",
    "3C1A9E": "VitalThings AS",
    "C884A1": "Cisco Systems",
    "083AF2": "Espressif Inc.",
    "743A20": "New H3C Technologies Co.",
    "C4D738": "Huawei Device Co.",
    "0008F6": "Sumitomo Electric Industries",
    "000BA2": "Sumitomo Electric Industries",
    "00005F": "Sumitomo Electric Industries",
    "001E68": "Quanta Computer Inc.",
    "18ECE7": "BUFFALO.INC",
    "D4AFF7": "Arista Networks",
    "28D127": "Beijing Xiaomi Mobile Software Co.",
    "30A452": "Arrival Elements BV",
    "F469D5": "IEEE Registration Authority",
    "8CC5B4": "Sagemcom Broadband SAS",
    "F81B04": "Zhong Shan City Richsound Electronic Industrial Ltd",
    "18D61C": "Shenzhen TINNO Mobile Technology Corp.",
    "5448E6": "Beijing Xiaomi Mobile Software Co.",
    "D88C79": "Google",
    "10341B": "Spacelink",
    "1CD6BE": "Wistron Neweb Corporation",
    "F86465": "Anova Applied Electronics",
    "90A935": "JWEntertainment",
    "60D4E9": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "C868DE": "Huawei Device Co.",
    "D00DF7": "Huawei Device Co.",
    "4805E2": "Huawei Device Co.",
    "2868D2": "HUAWEI TECHNOLOGIES CO.",
    "C8E265": "Intel Corporate",
    "2C600C": "Quanta Computer Inc.",
    "00238B": "Quanta Computer Inc.",
    "30C50F": "HUAWEI TECHNOLOGIES CO.",
    "BC03A7": "MFP MICHELIN",
    "CCDB93": "Cisco Systems",
    "1CE61D": "Samsung Electronics Co.",
    "441C7F": "Motorola Mobility LLC",
    "00B8B6": "Motorola Mobility LLC",
    "80EA07": "TP-LINK TECHNOLOGIES CO.",
    "04A2F3": "Fiberhome Telecommunication Technologies Co.",
    "8012DF": "Shenzhen SuperElectron Technology Co.",
    "2C6F51": "Herospeed Digital Technology Limited",
    "982FF8": "Huawei Device Co.",
    "40DCA5": "Huawei Device Co.",
    "10E77A": "STMicrolectronics International NV",
    "00D0B6": "CRESCENT NETWORKS",
    "2CA042": "Huawei Device Co.",
    "C083C9": "Huawei Device Co.",
    "982CBC": "Intel Corporate",
    "2050E7": "AMPAK Technology",
    "BC17B8": "Intel Corporate",
    "E43D1A": "Broadcom Limited",
    "7018A7": "Cisco Systems",
    "24F150": "Guangzhou Qi'an Technology Co.",
    "08FA79": "vivo Mobile Communication Co.",
    "8C5EBD": "Huawei Device Co.",
    "C01C30": "Shenzhen WIFI-3L Technology Co.",
    "D8C678": "MitraStar Technology Corp.",
    "4CC53E": "Zyxel Communications Corporation",
    "ECC01B": "HUAWEI TECHNOLOGIES CO.",
    "9844CE": "HUAWEI TECHNOLOGIES CO.",
    "F09BB8": "HUAWEI TECHNOLOGIES CO.",
    "44BB3B": "Google",
    "14C14E": "Google",
    "D8C0A6": "AzureWave Technology Inc.",
    "607EC9": "Apple",
    "108B6A": "Antailiye Technology Co.",
    "98A942": "Guangzhou Tozed Kangwei Intelligent Technology Co.",
    "4C2113": "Nokia Shanghai Bell Co.",
    "DC503A": "Nanjing Ticom Tech Co.",
    "18473D": "CHONGQING FUGUI ELECTRONICS CO.",
    "942533": "HUAWEI TECHNOLOGIES CO.",
    "605661": "IXECLOUD Tech",
    "706979": "IEEE Registration Authority",
    "D477B2": "Netix Global B.V.",
    "FC609B": "New H3C Technologies Co.",
    "E8A1F8": "zte corporation",
    "304240": "zte corporation",
    "14C88B": "Apple",
    "EC2651": "Apple",
    "183EEF": "Apple",
    "802DBF": "Cisco Systems",
    "708CBB": "MIMODISPLAYKOREA",
    "B848AA": "EM Microelectronic",
    "987ECA": "Inventus Power Eletronica do Brasil LTDA",
    "28B371": "Ruckus Wireless",
    "D4F829": "Sagemcom Broadband SAS",
    "E06234": "Texas Instruments",
    "F86BD9": "Cisco Systems",
    "C014FE": "Cisco Systems",
    "7CAD4F": "Cisco Systems",
    "0C14D2": "China Mobile Group Device Co.",
    "50382F": "ASE Group Chung-Li",
    "F8AC65": "Intel Corporate",
    "0019F4": "Convergens Oy Ltd",
    "244BFE": "ASUSTek COMPUTER INC.",
    "7CDDE9": "ATOM tech Inc.",
    "08ACC4": "FMTech",
    "6C2F8A": "Samsung Electronics Co.",
    "F0B022": "TOHO Electronics INC.",
    "F82F65": "Huawei Device Co.",
    "0831A4": "Huawei Device Co.",
    "A8E978": "Huawei Device Co.",
    "44F4E7": "Cohesity Inc",
    "E0F6B5": "Nintendo Co.",
    "40B31E": "Universal Electronics",
    "884033": "HUAWEI TECHNOLOGIES CO.",
    "948AC6": "Realme Chongqing Mobile Telecommunications Corp.",
    "2C9FFB": "Wistron Neweb Corporation",
    "84CCA8": "Espressif Inc.",
    "E0D462": "Huawei Device Co.",
    "909838": "Huawei Device Co.",
    "448DBF": "Rhino Mobility LLC",
    "C0A66D": "Inspur Group Co.",
    "002060": "ALCATEL ITALIA S.p.A.",
    "C88314": "Tempo Communications",
    "24C8D3": "McWane India Pvt Ltd",
    "AC7A56": "Cisco Systems",
    "D89136": "Dover Fueling Solutions",
    "FC956A": "OCTAGON SYSTEMS CORP.",
    "00062A": "Cisco Systems",
    "98ED5C": "Tesla",
    "C44268": "CRESTRON ELECTRONICS",
    "40F520": "Espressif Inc.",
    "78AA82": "New H3C Technologies Co.",
    "38F601": "Solid State Storage Technology Corporation",
    "1070FD": "Mellanox Technologies",
    "E8986D": "Palo Alto Networks",
    "7C89C1": "Palo Alto Networks",
    "B8E3EE": "Universal Electronics",
    "84D6C5": "SolarEdge Technologies",
    "5471DD": "Huawei Device Co.",
    "08C0EB": "Mellanox Technologies",
    "E4E112": "Texas Instruments",
    "3414B5": "Texas Instruments",
    "D003EB": "Texas Instruments",
    "9056FC": "TECNO MOBILE LIMITED",
    "B86392": "GUANGDONG GENIUS TECHNOLOGY CO.",
    "68B9D3": "Shenzhen Trolink Technology CO",
    "B8C6AA": "Earda Technologies co Ltd",
    "54AED0": "DASAN Networks",
    "6CF712": "Nokia Solutions and Networks GmbH & Co. KG",
    "6409AC": "TCT mobile ltd",
    "24B657": "Cisco Systems",
    "5C5578": "iryx corp",
    "189E2C": "Huawei Device Co.",
    "94DB56": "Sony Home Entertainment&Sound Products Inc",
    "3822E2": "HP Inc.",
    "08BFA0": "Samsung Electronics Co.",
    "701F3C": "Samsung Electronics Co.",
    "487AF6": "NCS ELECTRICAL SDN BHD",
    "486E70": "Zhejiang Tmall Technology Co.",
    "601D9D": "Sichuan AI-Link Technology Co.",
    "3C7D0A": "Apple",
    "D85F77": "Telink Semiconductor (Shanghai) Co.",
    "2C97ED": "Sony Imaging Products & Solutions Inc.",
    "188A6A": "AVPro Global Hldgs",
    "D48A39": "Samsung Electronics Co.",
    "E4F3C4": "Samsung Electronics Co.",
    "9C2F4E": "zte corporation",
    "D8A8C8": "zte corporation",
    "20826A": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "B89047": "Apple",
    "909C4A": "Apple",
    "908C43": "Apple",
    "F01090": "New H3C Technologies Co.",
    "E42686": "DWnet Technologies(Suzhou) Corporation",
    "0C3796": "BIZLINK TECHNOLOGY",
    "38EB47": "HUAWEI TECHNOLOGIES CO.",
    "10C3AB": "HUAWEI TECHNOLOGIES CO.",
    "2811EC": "HUAWEI TECHNOLOGIES CO.",
    "00692D": "Sunnovo International Limited",
    "F4032A": "Amazon Technologies Inc.",
    "646266": "IEEE Registration Authority",
    "B4157E": "Celona Inc.",
    "645E2C": "IRay Technology Co.",
    "B0B194": "zte corporation",
    "18D98F": "Huawei Device Co.",
    "147740": "Huawei Device Co.",
    "9043E2": "Cornami",
    "9C28F7": "Xiaomi Communications Co Ltd",
    "10521C": "Espressif Inc.",
    "8468C8": "TOTOLINK TECHNOLOGY INT‘L LIMITED",
    "3C5731": "Cisco Systems",
    "9CFCE8": "Intel Corporate",
    "D80BCB": "Telink Semiconductor (Shanghai) Co.",
    "6C42AB": "Subscriber Networks",
    "64F6F7": "Anhui Dynamic Power Co.",
    "941C56": "Actiontec Electronics",
    "A02D13": "AirTies Wireless Networks",
    "CC2D1B": "SFR",
    "C0D682": "Arista Networks",
    "501408": "AiNET",
    "943BB0": "New H3C Technologies Co.",
    "289AF7": "ADVA Optical Networking Ltd.",
    "803049": "Liteon Technology Corporation",
    "F0F0A4": "Amazon Technologies Inc.",
    "E84943": "YUGE Information technology Co. Ltd",
    "50DE19": "IEEE Registration Authority",
    "D005E4": "Huawei Device Co.",
    "30AAE4": "Huawei Device Co.",
    "9055DE": "Fiberhome Telecommunication Technologies Co.",
    "E8910F": "Fiberhome Telecommunication Technologies Co.",
    "14AB56": "WUXI FUNIDE DIGITAL CO.",
    "807B3E": "Samsung Electronics Co.",
    "F8F1E6": "Samsung Electronics Co.",
    "5CE176": "Cisco Systems",
    "28CDC4": "CHONGQING FUGUI ELECTRONICS CO.",
    "E8D8D1": "HP Inc.",
    "48EB62": "Murata Manufacturing Co.",
    "342FBD": "Nintendo Co.",
    "2C91AB": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
    "ECCED7": "Apple",
    "AC9085": "Apple",
    "88A9B7": "Apple",
    "CC5CDE": "China Mobile Group Device Co.",
    "4C4FEE": "OnePlus Technology (Shenzhen) Co.",
    "A82BCD": "HUAWEI TECHNOLOGIES CO.",
    "48DC2D": "HUAWEI TECHNOLOGIES CO.",
    "34F150": "Hui Zhou Gaoshengda Technology Co.",
    "BCF9F2": "TEKO",
    "60CE86": "Sercomm Corporation.",
    "6010A2": "Crompton Instruments",
    "B0A454": "Tripwire Inc.",
    "ACEB51": "Universal Electronics",
    "C4B239": "Cisco Systems",
    "0009FC": "IPFLEX Inc.",
    "A824B8": "Nokia",
    "6490C1": "Beijing Xiaomi Mobile Software Co.",
    "809F9B": "Sichuan AI-Link Technology Co.",
    "4CE175": "Cisco Systems",
    "50E549": "GIGA-BYTE TECHNOLOGY CO.",
    "D42493": "GW Technologies Co.",
    "3C510E": "Cisco Systems",
    "CC5289": "SHENZHEN OPTFOCUS TECHNOLOGY.",
    "CC5D78": "JTD Consulting",
    "D8AED0": "Shanghai Engineering Science & Technology Co.",
    "0C42A1": "Mellanox Technologies",
    "D03110": "Ingenic Semiconductor Co.",
    "A8E77D": "Texas Instruments",
    "E0859A": "SHENZHEN RF-LINK TECHNOLOGY CO.",
    "FC8596": "Axonne Inc.",
    "5CB4E2": "Inspur Software Group Ltd.",
    "349F7B": "CANON INC.",
    "6C410E": "Cisco Systems",
    "149138": "Amazon Technologies Inc.",
    "08CC27": "Motorola Mobility LLC",
    "04D395": "Motorola Mobility LLC",
    "E09806": "Espressif Inc.",
    "F4CFA2": "Espressif Inc.",
    "58D50A": "Murata Manufacturing Co.",
    "50C6AD": "Fiberhome Telecommunication Technologies Co.",
    "0C8447": "Fiberhome Telecommunication Technologies Co.",
    "9C6B72": "Realme Chongqing MobileTelecommunications Corp Ltd",
    "F81E6F": "EBG compleo GmbH",
    "6C310E": "Cisco Systems",
    "DC543D": "ITEL MOBILE LIMITED",
    "748A28": "HMD Global Oy",
    "14A32F": "Huawei Device Co.",
    "04D3B5": "Huawei Device Co.",
    "642CAC": "HUAWEI TECHNOLOGIES CO.",
    "E884C6": "HUAWEI TECHNOLOGIES CO.",
    "2877F1": "Apple",
    "F0A35A": "Apple",
    "608373": "Apple",
    "84AD8D": "Apple",
    "74428B": "Apple",
    "DC4BFE": "Shenzhen Belon Technology CO.",
    "506255": "IEEE Registration Authority",
    "F0A7B2": "FUTABA CORPORATION",
    "609B2D": "JMACS Japan Co.",
    "00BB1C": "Huawei Device Co.",
    "88A303": "Samsung Electronics Co.",
    "FCDE90": "Samsung Electronics Co.",
    "1854CF": "Samsung Electronics Co.",
    "80795D": "Infinix mobility limited",
    "5CE7A0": "Nokia",
    "8CDC02": "zte corporation",
    "80AC7C": "Sichuan AI-Link Technology Co.",
    "10C65E": "Adapt-IP",
    "20311C": "vivo Mobile Communication Co.",
    "7CA7B0": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
    "683943": "ittim",
    "B4E842": "Hong Kong Bouffalo Lab Limited",
    "2852F9": "Zhongxin Intelligent Times (Shenzhen) Co.",
    "B8F853": "Arcadyan Corporation",
    "E0D083": "Samsung Electronics Co.",
    "D80B9A": "Samsung Electronics Co.",
    "6C710D": "Cisco Systems",
    "00D2B1": "TPV Display Technology (Xiamen) Co.",
    "1C4455": "Sieb & Meyer AG",
    "E01F88": "Xiaomi Communications Co Ltd",
    "803253": "Intel Corporate",
    "C0E434": "AzureWave Technology Inc.",
    "D03D52": "Ava Security Limited",
    "246F8C": "Huawei Device Co.",
    "1C1386": "Huawei Device Co.",
    "BC2EF6": "Huawei Device Co.",
    "4455C4": "Huawei Device Co.",
    "AC8D34": "HUAWEI TECHNOLOGIES CO.",
    "8031F0": "Samsung Electronics Co.",
    "583526": "DEEPLET TECHNOLOGY CORP",
    "401175": "IEEE Registration Authority",
    "84A9EA": "Career Technologies USA",
    "E405F8": "Bytedance",
    "743C18": "Taicang T&W Electronics",
    "1088CE": "Fiberhome Telecommunication Technologies Co.",
    "8C02FA": "COMMANDO Networks Limited",
    "F47488": "New H3C Technologies Co.",
    "6C1DEB": "u-blox AG",
    "287FCF": "Intel Corporate",
    "4C80BA": "Wuhan Tianyu Information Industry Co.",
    "34B5A3": "CIG SHANGHAI CO LTD",
    "743170": "Arcadyan Technology Corporation",
    "000084": "SUPERNET",
    "50A132": "Shenzhen MiaoMing  Intelligent Technology Co.",
    "807871": "ASKEY COMPUTER CORP",
    "283334": "Huawei Device Co.",
    "30A2C2": "Huawei Device Co.",
    "DCDFD6": "zte corporation",
    "ACA88E": "SHARP Corporation",
    "98415C": "Nintendo Co.",
    "5C0BCA": "Tunstall Nordic AB",
    "88517A": "HMD Global Oy",
    "ACB3B5": "HUAWEI TECHNOLOGIES CO.",
    "848094": "Meter",
    "10B3D5": "Cisco Systems",
    "F49C12": "Structab AB",
    "60AB14": "LG Innotek",
    "BC62D2": "Genexis International B.V.",
    "6C9E7C": "Fiberhome Telecommunication Technologies Co.",
    "84D15A": "TCT mobile ltd",
    "F08620": "Arcadyan Corporation",
    "DCCC8D": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "B8F653": "Shenzhen Jingxun Software Telecommunication Technology Co.",
    "4C7A48": "Nippon Seiki (Europe) B.V.",
    "F4B688": "PLANTRONICS",
    "000C86": "Cisco Systems",
    "083A88": "Universal Global Scientific Industrial Co.",
    "08318B": "HUAWEI TECHNOLOGIES CO.",
    "4CB1CD": "Ruckus Wireless",
    "F83CBF": "BOTATO ELECTRONICS SDN BHD",
    "FC589A": "Cisco Systems",
    "F05C77": "Google",
    "446747": "HUAWEI TECHNOLOGIES CO.",
    "884A70": "Wacom Co.",
    "A463A1": "Inventus Power Eletronica do Brasil LTDA",
    "3C9D56": "HUAWEI TECHNOLOGIES CO.",
    "70FD45": "HUAWEI TECHNOLOGIES CO.",
    "F4B5BB": "CERAGON NETWORKS",
    "542B8D": "Apple",
    "6CD71F": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "44D5F2": "IEEE Registration Authority",
    "0CDD24": "Intel Corporate",
    "8C4962": "Roku",
    "507AC5": "Apple",
    "4C6BE8": "Apple",
    "8C861E": "Apple",
    "001D29": "Doro AB",
    "ECA5DE": "ONYX WIFI Inc",
    "C4AC59": "Murata Manufacturing Co.",
    "5816D7": "ALPSALPINE CO",
    "FCA47A": "IEEE Registration Authority",
    "38184C": "Sony Home Entertainment&Sound Products Inc",
    "347563": "SHENZHEN RF-LINK TECHNOLOGY CO.",
    "142E5E": "Sercomm Corporation.",
    "0025CB": "Reiner SCT",
    "44237C": "Beijing Xiaomi Mobile Software Co.",
    "309435": "vivo Mobile Communication Co.",
    "50EB71": "Intel Corporate",
    "D44BB6": "Zhejiang Tmall Technology Co.",
    "C064E4": "Cisco Systems",
    "D82FE6": "Zhejiang Tmall Technology Co.",
    "F06865": "Taicang T&W Electronics",
    "140F42": "Nokia",
    "006D61": "Guangzhou V-SOLUTION Electronic Technology Co.",
    "78CC2B": "SINEWY TECHNOLOGY CO.",
    "50D4F7": "TP-LINK TECHNOLOGIES CO.",
    "000A17": "NESTAR COMMUNICATIONS",
    "B86685": "Sagemcom Broadband SAS",
    "B45459": "China Mobile (Hangzhou) Information Technology Co.",
    "381A52": "Seiko Epson Corporation",
    "5C879C": "Intel Corporate",
    "24EE9A": "Intel Corporate",
    "E4FDA1": "HUAWEI TECHNOLOGIES CO.",
    "E419C1": "HUAWEI TECHNOLOGIES CO.",
    "B452A9": "Texas Instruments",
    "D8AF81": "AO",
    "1C20DB": "HUAWEI TECHNOLOGIES CO.",
    "D0C65B": "HUAWEI TECHNOLOGIES CO.",
    "9078B2": "Xiaomi Communications Co Ltd",
    "78C313": "China Mobile Group Device Co.",
    "7434AE": "this is engineering Inc.",
    "D0C857": "IEEE Registration Authority",
    "54EF44": "Lumi United Technology Co.",
    "000970": "Vibration Research Corporation",
    "14A2A0": "Cisco Systems",
    "E4AB89": "MitraStar Technology Corp.",
    "AC83E9": "Beijing Zile Technology Co.",
    "D8CA06": "Titan DataCenters France",
    "6095CE": "IEEE Registration Authority",
    "7460FA": "HUAWEI TECHNOLOGIES CO.",
    "C40683": "HUAWEI TECHNOLOGIES CO.",
    "94D00D": "HUAWEI TECHNOLOGIES CO.",
    "C48A5A": "JFCONTROL",
    "B49A95": "Shenzhen Boomtech Industrial Corporation",
    "8CFD18": "HUAWEI TECHNOLOGIES CO.",
    "FCBCD1": "HUAWEI TECHNOLOGIES CO.",
    "8CE5C0": "Samsung Electronics Co.",
    "F08A76": "Samsung Electronics Co.",
    "ECAA25": "Samsung Electronics Co.",
    "687D6B": "Samsung Electronics Co.",
    "485169": "Samsung Electronics Co.",
    "001F47": "MCS Logic Inc.",
    "74ADB7": "China Mobile Group Device Co.",
    "BC7FA4": "Xiaomi Communications Co Ltd",
    "90473C": "China Mobile Group Device Co.",
    "7C21D8": "Shenzhen Think Will Communication Technology co.",
    "FC492D": "Amazon Technologies Inc.",
    "74EE2A": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
    "080039": "SPIDER SYSTEMS LIMITED",
    "FCEA50": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "00E06B": "W&G SPECIAL PRODUCTS",
    "D4F057": "Nintendo Co.",
    "889E33": "TCT mobile ltd",
    "6C8AEC": "Nantong Coship Electronics Co.",
    "84C2E4": "Jiangsu Qinheng Co.",
    "B4CFE0": "Sichuan tianyi kanghe communications co.",
    "6CF17E": "Zhejiang Uniview Technologies Co.",
    "D8F15B": "Espressif Inc.",
    "103D3E": "China Mobile Group Device Co.",
    "64CC22": "Arcadyan Corporation",
    "4C9157": "Fujian LANDI Commercial Equipment Co.",
    "488764": "vivo Mobile Communication Co.",
    "5C1CB9": "vivo Mobile Communication Co.",
    "C0FD84": "zte corporation",
    "9C25BE": "Wildlife Acoustics",
    "D039EA": "NetApp",
    "F8DFE1": "MyLight Systems",
    "444B7E": "Fiberhome Telecommunication Technologies Co.",
    "E8D0FC": "Liteon Technology Corporation",
    "E8E8B7": "Murata Manufacturing Co.",
    "083A2F": "Guangzhou Juan Intelligent Tech Joint Stock Co.",
    "1C3A60": "Ruckus Wireless",
    "6009C3": "u-blox AG",
    "DC8C37": "Cisco Systems",
    "788C77": "LEXMARK INTERNATIONAL",
    "3C0C7D": "Tiny Mesh AS",
    "3476C5": "I-O DATA DEVICE",
    "60D2DD": "Shenzhen Baitong Putian Technology Co.",
    "5C32C5": "Teracom Ltd.",
    "A8DB03": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
    "308944": "DEVA Broadcast Ltd.",
    "24DA33": "HUAWEI TECHNOLOGIES CO.",
    "FCAB90": "HUAWEI TECHNOLOGIES CO.",
    "A4975C": "VTech Telecommunications Ltd.",
    "1C2704": "zte corporation",
    "5078B3": "zte corporation",
    "F0D4F7": "varram system",
    "E0CC7A": "HUAWEI TECHNOLOGIES CO.",
    "B02A1F": "Wingtech Group (HongKong）Limited",
    "5893D8": "Texas Instruments",
    "5051A9": "Texas Instruments",
    "F47960": "HUAWEI TECHNOLOGIES CO.",
    "145290": "KNS Group LLC (YADRO Company)",
    "6C23CB": "Wattty Corporation",
    "60AB67": "Xiaomi Communications Co Ltd",
    "AC710C": "China Mobile Group Device Co.",
    "ACEE70": "Fontem Ventures BV",
    "00B600": "VOIM Co.",
    "4418FD": "Apple",
    "005B94": "Apple",
    "E0897E": "Apple",
    "002615": "Teracom Limited",
    "9C8EDC": "Teracom Limited",
    "000191": "SYRED Data Systems",
    "A8346A": "Samsung Electronics Co.",
    "4846C1": "FN-LINK TECHNOLOGY LIMITED",
    "4889E7": "Intel Corporate",
    "A0BD1D": "Zhejiang Dahua Technology Co.",
    "B4D0A9": "China Mobile Group Device Co.",
    "FC29F3": "McPay Co.",
    "F8AFDB": "Fiberhome Telecommunication Technologies Co.",
    "ACE2D3": "Hewlett Packard",
    "00FD22": "Cisco Systems",
    "2CCCE6": "Skyworth Digital Technology(Shenzhen) Co.",
    "CC2C83": "DarkMatter L.L.C",
    "DCED84": "Haverford Systems Inc",
    "644C36": "Intel Corporate",
    "ACD564": "CHONGQING FUGUI ELECTRONICS CO.",
    "94D075": "CIS Crypto",
    "28B4FB": "Sprocomm Technologies CO.",
    "C05336": "Beijing National Railway Research & Design Institute of Signal & Communication Group Co..Ltd.",
    "606ED0": "SEAL AG",
    "3C20F6": "Samsung Electronics Co.",
    "7C38AD": "Samsung Electronics Co.",
    "40F9D5": "Tecore Networks",
    "E44CC7": "IEEE Registration Authority",
    "D4E880": "Cisco Systems",
    "9849E1": "Boeing Defence Australia",
    "04D7A5": "New H3C Technologies Co.",
    "2C01B5": "Cisco Systems",
    "885A06": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "5447D3": "TSAT AS",
    "4C4D66": "Nanjing Jiahao Technology Co.",
    "A4817A": "CIG SHANGHAI CO LTD",
    "CCEDDC": "MitraStar Technology Corp.",
    "688B0F": "China Mobile IOT Company Limited",
    "3CF011": "Intel Corporate",
    "D49CDD": "AMPAK Technology",
    "50F722": "Cisco Systems",
    "9809CF": "OnePlus Technology (Shenzhen) Co.",
    "B8DE5E": "LONGCHEER TELECOMMUNICATION LIMITED",
    "A4E7E4": "Connex GmbH",
    "B8EF8B": "SHENZHEN CANNICE TECHNOLOGY CO.",
    "20B780": "Toshiba Visual Solutions Corporation Co.",
    "B8186F": "ORIENTAL MOTOR CO.",
    "001A3F": "Intelbras",
    "F0B31E": "Universal Electronics",
    "ECA9FA": "GUANGDONG GENIUS TECHNOLOGY CO.",
    "0003A5": "Medea Corporation",
    "443C88": "FICOSA MAROC INTERNATIONAL",
    "841C70": "zte corporation",
    "C4F839": "Actia Automotive",
    "BCE67C": "Cambium Networks Limited",
    "7C1E06": "New H3C Technologies Co.",
    "F89173": "AEDLE SAS",
    "C84F86": "Sophos Ltd",
    "6429ED": "AO PKK Milandr",
    "CCD39D": "IEEE Registration Authority",
    "18DFB4": "BOSUNG POWERTEC CO.",
    "F82F6A": "ITEL MOBILE LIMITED",
    "C0D834": "xvtec ltd",
    "544741": "XCHENG HOLDING",
    "CCF735": "Amazon Technologies Inc.",
    "B4EC02": "ALPSALPINE CO",
    "646038": "Hirschmann Automation and Control GmbH",
    "649D99": "FS COM INC",
    "00169D": "Cisco Systems",
    "78DD12": "Arcadyan Corporation",
    "D425CC": "IEEE Registration Authority",
    "C8F742": "HangZhou Gubei Electronics Technology Co.",
    "006FF2": "MITSUMI ELECTRIC CO.",
    "8C6DC4": "Megapixel VR",
    "2C5D34": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "9C1463": "Zhejiang Dahua Technology Co.",
    "30DF8D": "SHENZHEN GONGJIN ELECTRONICS CO.",
    "D4C93C": "Cisco Systems",
    "E0750A": "ALPSALPINE CO",
    "0019C1": "ALPSALPINE CO",
    "0016FE": "ALPSALPINE CO",
    "9C8D7C": "ALPSALPINE CO",
    "002433": "ALPSALPINE CO",
    "002306": "ALPSALPINE CO",
    "BC7536": "ALPSALPINE CO",
    "E0AE5E": "ALPSALPINE CO",
    "4861A3": "Concern Axion JSC",
    "D4B761": "Sichuan AI-Link Technology Co.",
    "7C035E": "Xiaomi Communications Co Ltd",
    "44FE3B": "Arcadyan Corporation",
    "D83AF5": "Wideband Labs LLC",
    "38D9A5": "Mikotek Information Inc.",
    "304A26": "Shenzhen Trolink Technology CO",
    "D467D3": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "A41232": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "48E3C3": "JENOPTIK Advanced Systems GmbH",
    "CC355A": "SecuGen Corporation",
    "4C875D": "Bose Corporation",
    "B0E7DE": "Homa Technologies JSC",
    "00D279": "VINGROUP JOINT STOCK COMPANY",
    "00004C": "NEC Corporation",
    "8CCF8F": "ITC Systems",
    "4C962D": "Fresh AB",
    "2875D8": "FUJIAN STAR-NET COMMUNICATION CO.",
    "484A30": "George Robotics Limited",
    "90E202": "Texas Instruments",
    "4CE5AE": "Tianjin Beebox Intelligent Technology Co.",
    "F4C7C8": "Kelvin Inc.",
    "80546A": "SHENZHEN GONGJIN ELECTRONICS CO.",
    "B447F5": "Earda Technologies co Ltd",
    "A89CA4": "Furrion Limited",
    "589EC6": "Gigaset Communications GmbH",
    "6458AD": "China Mobile IOT Company Limited",
    "84A93E": "Hewlett Packard",
    "349342": "TTE Corporation",
    "1CF29A": "Google",
    "302478": "Sagemcom Broadband SAS",
    "A0A3B8": "WISCLOUD",
    "38F9D3": "Apple",
    "FC183C": "Apple",
    "184BDF": "Caavo Inc",
    "FC7774": "Intel Corporate",
    "700B4F": "Cisco Systems",
    "E4388C": "Digital Products Limited",
    "B89A9A": "Xin Shi Jia Technology (Beijing) Co.",
    "64C753": "Apple",
    "B0C387": "GOEFER",
    "086BD7": "Silicon Laboratories",
    "A40C66": "Shenzhen Colorful Yugong Technology and Development Co.",
    "4455B1": "HUAWEI TECHNOLOGIES CO.",
    "98F9C7": "IEEE Registration Authority",
    "D8A756": "Sagemcom Broadband SAS",
    "D8D6F3": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "8C7BF0": "Xufeng Development Limited",
    "E0A509": "Bitmain Technologies Inc",
    "3C5CC4": "Amazon Technologies Inc.",
    "F43909": "Hewlett Packard",
    "201F31": "Inteno Broadband Technology AB",
    "6C2CDC": "Skyworth Digital Technology(Shenzhen) Co.",
    "7835A0": "Zurn Industries LLC",
    "54833A": "Zyxel Communications Corporation",
    "248498": "Beijing Jiaoda Microunion Tech.Co.",
    "2CCC44": "Sony Interactive Entertainment Inc.",
    "F47DEF": "Samsung Electronics Co.",
    "7C8BB5": "Samsung Electronics Co.",
    "787052": "Welotec GmbH",
    "D8A98B": "Texas Instruments",
    "A83FA1": "IEEE Registration Authority",
    "F4DBE6": "Cisco Systems",
    "C074AD": "Grandstream Networks",
    "F095F1": "Carl Zeiss AG",
    "00F48D": "Liteon Technology Corporation",
    "702ED9": "Guangzhou Shiyuan Electronics Co.",
    "70192F": "HUAWEI TECHNOLOGIES CO.",
    "6C9BC0": "Chemoptics Inc.",
    "10B9F7": "Niko-Servodan",
    "14EFCF": "SCHREDER",
    "3830F9": "LG Electronics (Mobile Communications)",
    "58E6BA": "Apple",
    "18A7F1": "Qingdao Haier Technology Co.",
    "90E17B": "Apple",
    "D81C79": "Apple",
    "10C22F": "China Entropy Co.",
    "BC3865": "JWCNETWORKS",
    "04EB40": "Cisco Systems",
    "1801F1": "Xiaomi Communications Co Ltd",
    "44E4EE": "Wistron Neweb Corporation",
    "C0847D": "AMPAK Technology",
    "C44F33": "Espressif Inc.",
    "546AD8": "Elster Water Metering",
    "00A5BF": "Cisco Systems",
    "DC41E5": "Shenzhen Zhixin Data Service Co.",
    "C8BAE9": "QDIS",
    "0409A5": "HFR",
    "7CD30A": "INVENTEC CORPORATION",
    "001E33": "INVENTEC CORPORATION",
    "FC1D84": "Autobase",
    "242124": "Nokia",
    "94917F": "ASKEY COMPUTER CORP",
    "002654": "3COM",
    "0050DA": "3COM",
    "000476": "3COM",
    "000475": "3COM",
    "9C0CDF": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "4422F1": "S.FAC",
    "00D096": "3COM EUROPE LTD",
    "3009F9": "IEEE Registration Authority",
    "B4DDD0": "Continental Automotive Hungary Kft",
    "48F027": "Chengdu newifi Co.",
    "B42E99": "GIGA-BYTE TECHNOLOGY CO.",
    "342CC4": "Compal Broadband Networks",
    "14C697": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "7C03AB": "Xiaomi Communications Co Ltd",
    "DC16B2": "HUAWEI TECHNOLOGIES CO.",
    "24FB65": "HUAWEI TECHNOLOGIES CO.",
    "0CB527": "HUAWEI TECHNOLOGIES CO.",
    "14E9B2": "Fiberhome Telecommunication Technologies Co.",
    "18AC9E": "ITEL MOBILE LIMITED",
    "EC84B4": "CIG SHANGHAI CO LTD",
    "C8544B": "Zyxel Communications Corporation",
    "4C1159": "Vision Information & Communications",
    "50DCFC": "ECOCOM",
    "700B01": "Sagemcom Broadband SAS",
    "5C2623": "WaveLynx Technologies Corporation",
    "303855": "Nokia Corporation",
    "009093": "EIZO Corporation",
    "F09FFC": "SHARP Corporation",
    "00D07B": "COMCAM INTERNATIONAL INC",
    "78524A": "Optonic GmbH",
    "C46E7B": "SHENZHEN RF-LINK TECHNOLOGY CO.",
    "00B670": "Cisco Systems",
    "AC6417": "Siemens AG",
    "347916": "HUAWEI TECHNOLOGIES CO.",
    "C048FB": "Shenzhen JingHanDa Electronics Co.Ltd",
    "20E882": "zte corporation",
    "00B5D0": "Samsung Electronics Co.",
    "1496E5": "Samsung Electronics Co.",
    "D07FA0": "Samsung Electronics Co.",
    "00049F": "Freescale Semiconductor",
    "0CB5DE": "Alcatel Lucent",
    "000B3B": "devolo AG",
    "240588": "Google",
    "0C1C57": "Texas Instruments",
    "806FB0": "Texas Instruments",
    "883F99": "Siemens AG",
    "705AB6": "COMPAL INFORMATION (KUNSHAN) CO.",
    "201A06": "COMPAL INFORMATION (KUNSHAN) CO.",
    "F8A963": "COMPAL INFORMATION (KUNSHAN) CO.",
    "009D6B": "Murata Manufacturing Co.",
    "DC0EA1": "COMPAL INFORMATION (KUNSHAN) CO.",
    "B870F4": "COMPAL INFORMATION (KUNSHAN) CO.",
    "1C3947": "COMPAL INFORMATION (KUNSHAN) CO.",
    "342792": "FREEBOX SAS",
    "7C6DA6": "Superwave Group LLC",
    "0006EC": "Harris Corporation",
    "40A108": "Motorola (Wuhan) Mobility Technologies Communication Co.",
    "D016B4": "HUAWEI TECHNOLOGIES CO.",
    "00BB60": "Intel Corporate",
    "3466EA": "VERTU INTERNATIONAL CORPORATION LIMITED",
    "28385C": "FLEXTRONICS",
    "EC6F0B": "FADU",
    "388B59": "Google",
    "880118": "BLT Co",
    "A42618": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "34E12D": "Intel Corporate",
    "20A8B9": "SIEMENS AG",
    "F0F08F": "Nextek Solutions Pte Ltd",
    "8CB0E9": "Samsung Electronics.",
    "A46191": "NamJunSa",
    "84A24D": "Birds Eye Systems Private Limited",
    "D0EFC1": "HUAWEI TECHNOLOGIES CO.",
    "0018B5": "Magna Carta",
    "D87EB1": "x.o.ware",
    "0017B6": "Aquantia Corporation",
    "105917": "Tonal",
    "745933": "Danal Entertainment",
    "EC58EA": "Ruckus Wireless",
    "485702": "HUAWEI TECHNOLOGIES CO.",
    "D45251": "IBT Ingenieurbureau Broennimann Thun",
    "7C6B9C": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "7089CC": "China Mobile Group Device Co.",
    "5061BF": "Cisco Systems",
    "0009DF": "Vestel Elektronik San ve Tic. A.S.",
    "644F42": "JETTER CO.",
    "DCAF68": "WEIFANG GOERTEK ELECTRONICS CO.",
    "CC7B61": "NIKKISO CO.",
    "9C713A": "HUAWEI TECHNOLOGIES CO.",
    "2C97B1": "HUAWEI TECHNOLOGIES CO.",
    "24EC51": "ADF Technologies Sdn Bhd",
    "882D53": "Baidu Online Network Technology (Beijing) Co.",
    "00D0B5": "IPricot formerly DotCom",
    "2C5BE1": "Centripetal Networks",
    "DCEFCA": "Murata Manufacturing Co.",
    "00BC60": "Cisco Systems",
    "700F6A": "Cisco Systems",
    "746BAB": "GUANGDONG ENOK COMMUNICATION CO.",
    "0CB6D2": "D-Link International",
    "7829ED": "ASKEY COMPUTER CORP",
    "B8B7F1": "Wistron Neweb Corporation",
    "8050F6": "ITEL MOBILE LIMITED",
    "A8CAB9": "SAMSUNG ELECTRO MECHANICS CO.",
    "8CF228": "MERCURY COMMUNICATION TECHNOLOGIES CO.",
    "108EE0": "Samsung Electronics Co.",
    "FCA621": "Samsung Electronics Co.",
    "F8C39E": "HUAWEI TECHNOLOGIES CO.",
    "944A0C": "Sercomm Corporation.",
    "000FA2": "2xWireless",
    "000BB2": "SMALLBIG TECHNOLOGY",
    "F4032F": "Reduxio Systems",
    "7C41A2": "Nokia",
    "BC325F": "Zhejiang Dahua Technology Co.",
    "505BC2": "Liteon Technology Corporation",
    "6C21A2": "AMPAK Technology",
    "9C2F73": "Universal Tiancheng Technology (Beijing) Co.",
    "E8D099": "Fiberhome Telecommunication Technologies Co.",
    "00305E": "Abelko Innovation",
    "FC6BF0": "TOPWELL INTERNATIONAL HOLDINDS LIMITED",
    "001477": "Trilliant",
    "00079B": "Aurora Networks",
    "C88629": "Shenzhen Duubee Intelligent Technologies Co.",
    "54B203": "PEGATRON CORPORATION",
    "3868DD": "INVENTEC CORPORATION",
    "3C6AA7": "Intel Corporate",
    "A028ED": "HMD Global Oy",
    "AC5474": "China Mobile IOT Company Limited",
    "203956": "HMD Global Oy",
    "78AFE4": "Comau S.p.A",
    "90A137": "Beijing Splendidtel Communication Technology Co",
    "80029C": "Gemtek Technology Co.",
    "D832E3": "Xiaomi Communications Co Ltd",
    "9487E0": "Xiaomi Communications Co Ltd",
    "38AF29": "Zhejiang Dahua Technology Co.",
    "14169E": "Wingtech Group (HongKong）Limited",
    "107BA4": "Olive & Dove Co.",
    "D0C5D3": "AzureWave Technology Inc.",
    "8C1CDA": "IEEE Registration Authority",
    "883F4A": "Texas Instruments",
    "300AC5": "Ruio telecommunication technologies Co.",
    "00E065": "OPTICAL ACCESS INTERNATIONAL",
    "4466FC": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "D88A3B": "UNIT-EM",
    "EC5A86": "Yulong Computer Telecommunication Scientific (Shenzhen) Co.",
    "C4BAA3": "Beijing Winicssec Technologies Co.",
    "CCC2E0": "Raisecom Technology CO.",
    "1409DC": "HUAWEI TECHNOLOGIES CO.",
    "38BAF8": "Intel Corporate",
    "0007A8": "Haier Group Technologies Ltd",
    "50A009": "Xiaomi Communications Co Ltd",
    "9CFEA1": "Fiberhome Telecommunication Technologies Co.",
    "C0EEB5": "Enice Network.",
    "60DEF3": "HUAWEI TECHNOLOGIES CO.",
    "004098": "DRESSLER GMBH & CO.",
    "001DFA": "Fujian LANDI Commercial Equipment Co.",
    "9814D2": "Avonic",
    "78F9B4": "Nokia Solutions and Networks GmbH & Co. KG",
    "D076E7": "TP-LINK TECHNOLOGIES CO.",
    "9CA615": "TP-LINK TECHNOLOGIES CO.",
    "E44E76": "CHAMPIONTECH  ENTERPRISE (SHENZHEN) INC",
    "08F69C": "Apple",
    "04FA83": "Qingdao Haier Technology Co.",
    "50A67F": "Apple",
    "2016B9": "Intel Corporate",
    "00165C": "Trackflow Ltd.",
    "14205E": "Apple",
    "B841A4": "Apple",
    "9CE65E": "Apple",
    "C49880": "Apple",
    "E0338E": "Apple",
    "D461DA": "Apple",
    "F01898": "Apple",
    "881908": "Apple",
    "5C0947": "Apple",
    "641CAE": "Samsung Electronics Co.",
    "F8E44E": "MCOT INC.",
    "40CD7A": "Qingdao Hisense Communications Co.",
    "949990": "VTC Telecommunications",
    "F4BC97": "Shenzhen Crave Communication Co.",
    "28FEDE": "COMESTA",
    "144E34": "Remote Solution",
    "907910": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "003DE8": "LG Electronics (Mobile Communications)",
    "68FEDA": "Fiberhome Telecommunication Technologies Co.",
    "DC4EF4": "Shenzhen MTN Electronics CO.",
    "F08173": "Amazon Technologies Inc.",
    "00508B": "Hewlett Packard",
    "2CD974": "Hui Zhou Gaoshengda Technology Co.",
    "D4F786": "Fiberhome Telecommunication Technologies Co.",
    "94B86D": "Intel Corporate",
    "146B9C": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
    "948DEF": "Oetiker Schweiz AG",
    "8817A3": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "88A9A7": "IEEE Registration Authority",
    "3403DE": "Texas Instruments",
    "34D712": "Smartisan Digital Co.",
    "A06610": "FUJITSU LIMITED",
    "E0E62E": "TCT mobile ltd",
    "44FFBA": "zte corporation",
    "501479": "iRobot Corporation",
    "E42D7B": "China Mobile IOT Company Limited",
    "387862": "Sony Corporation",
    "EC8914": "HUAWEI TECHNOLOGIES CO.",
    "B89436": "HUAWEI TECHNOLOGIES CO.",
    "6084BD": "BUFFALO.INC",
    "347ECA": "NEXTWILL",
    "B42EF8": "Eline Technology co.Ltd",
    "A4D4B2": "Shenzhen MeiG Smart Technology Co.",
    "8CF773": "Nokia",
    "DCDD24": "Energica Motor Company SpA",
    "641CB0": "Samsung Electronics Co.",
    "903A72": "Ruckus Wireless",
    "2802D8": "Samsung Electronics Co.",
    "DCE533": "IEEE Registration Authority",
    "D8445C": "DEV Tecnologia Ind Com Man Eq LTDA",
    "7C3953": "zte corporation",
    "38E1AA": "zte corporation",
    "48C796": "Samsung Electronics Co.",
    "F4C248": "Samsung Electronics Co.",
    "F47190": "Samsung Electronics Co.",
    "8C5973": "Zyxel Communications Corporation",
    "24181D": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
    "F89066": "Nain Inc.",
    "7006AC": "Eastcompeace Technology Co.",
    "804126": "HUAWEI TECHNOLOGIES CO.",
    "ACF970": "HUAWEI TECHNOLOGIES CO.",
    "58D759": "HUAWEI TECHNOLOGIES CO.",
    "4CEFC0": "Amazon Technologies Inc.",
    "C464E3": "Texas Instruments",
    "CC3B58": "Curiouser Products Inc",
    "000889": "Dish Technologies Corp",
    "04C9D9": "Dish Technologies Corp",
    "7055F8": "Cerebras Systems Inc",
    "C4FFBC": "IEEE Registration Authority",
    "283B82": "D-Link International",
    "D4909C": "Apple",
    "E4E0A6": "Apple",
    "5C0038": "Viasat Group S.p.A.",
    "F0B5B7": "Disruptive Technologies Research AS",
    "B4DEDF": "zte corporation",
    "6C54CD": "LAMPEX ELECTRONICS LIMITED",
    "94290C": "Shenyang wisdom Foundation Technology Development Co.",
    "9C32CE": "CANON INC.",
    "34415D": "Intel Corporate",
    "005091": "NETACCESS",
    "20E09C": "Nokia",
    "2CFDA1": "ASUSTek COMPUTER INC.",
    "14444A": "Apollo Seiko Ltd.",
    "3C2C99": "Edgecore Networks Corporation",
    "3807D4": "Zeppelin Systems GmbH",
    "04197F": "Grasphere Japan",
    "10CEA9": "Texas Instruments",
    "802BF9": "Hon Hai Precision Ind. Co.",
    "54B802": "Samsung Electronics Co.",
    "580454": "ICOMM HK LIMITED",
    "C477AF": "Advanced Digital Broadcast SA",
    "805E0C": "YEALINK(XIAMEN) NETWORK TECHNOLOGY CO.",
    "6C49C1": "o2ones Co.",
    "70EEA3": "Eoptolink Technology Inc. Ltd",
    "5C521E": "Nintendo Co.",
    "6CDD30": "Cisco Systems",
    "6C4E86": "Third Millennium Systems Ltd.",
    "5C86C1": "DONGGUAN SOLUM ELECTRONICS CO.",
    "88D039": "Tonly Technology Co. Ltd",
    "5C81A7": "Network Devices Pty Ltd",
    "5C0C0E": "Guizhou Huaxintong Semiconductor Technology Co Ltd",
    "683E02": "SIEMENS AG",
    "503CEA": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "EC8193": "Logitech",
    "000261": "Tilgin AB",
    "0014C3": "Seagate Technology",
    "0004CF": "Seagate Technology",
    "002037": "Seagate Technology",
    "00E091": "LG Electronics",
    "38437D": "Compal Broadband Networks",
    "506F98": "Sehaj Synergy Technologies Private Limited",
    "4CAE1C": "SaiNXT Technologies LLP",
    "449160": "Murata Manufacturing Co.",
    "B4F1DA": "LG Electronics (Mobile Communications)",
    "C863F1": "Sony Interactive Entertainment Inc.",
    "5C7776": "TCT mobile ltd",
    "70E56E": "Texas Instruments",
    "547DCD": "Texas Instruments",
    "00AECD": "Pensando Systems",
    "142882": "MIDICOM ELECTRONICS CO.LTD",
    "30E48E": "Vodafone UK",
    "84509A": "Easy Soft TV Co.",
    "FC9DD8": "Beijing TongTongYiLian Science and Technology Ltd.",
    "DC2834": "HAKKO Corporation",
    "001730": "Automation Electronics",
    "0019C2": "Equustek Solutions",
    "80000B": "Intel Corporate",
    "DCE1AD": "Shenzhen Wintop Photoelectric Technology Co.",
    "78DDD9": "Guangzhou Shiyuan Electronics Co.",
    "B0FC36": "CyberTAN Technology Inc.",
    "001DF4": "Magellan Technology Pty Limited",
    "F8B7E2": "Cisco Systems",
    "F82055": "Green Information System",
    "74E19A": "Fiberhome Telecommunication Technologies Co.",
    "001CAE": "WiChorus",
    "ECB0E1": "Ciena Corporation",
    "948854": "Texas Instruments",
    "001D0D": "Sony Interactive Entertainment Inc.",
    "6C05D5": "Ethertronics Inc",
    "000097": "Dell EMC",
    "8CCF09": "Dell EMC",
    "8C839D": "SHENZHEN XINYUPENG ELECTRONIC TECHNOLOGY CO.",
    "0081F9": "Texas Instruments",
    "ECB5FA": "Philips Lighting BV",
    "B0C19E": "zte corporation",
    "0C3747": "zte corporation",
    "ACA667": "Electronic Systems Protection",
    "44CD0E": "FLEXTRONICS MANUFACTURING(ZHUHAI)CO.",
    "001C56": "Pado Systems",
    "F06D78": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "70991C": "Shenzhen Honesty Electronics Co.",
    "80B03D": "Apple",
    "E49ADC": "Apple",
    "ACE4B5": "Apple",
    "D0D2B0": "Apple",
    "707D95": "Shenzhen City LinwlanTechnology Co. Ltd.",
    "18CC88": "Hitachi Johnson Controls Air",
    "7CDD76": "Suzhou Hanming Technologies Co.",
    "246880": "Braveridge.co.",
    "2C431A": "Shenzhen YOUHUA Technology Co.",
    "70708B": "Cisco Systems",
    "389F5A": "C-Kur TV Inc.",
    "F0BD2E": "H+S Polatis Ltd",
    "746EE4": "Asia Vital Components Co.",
    "28AD3E": "Shenzhen TONG BO WEI Technology CO.",
    "D843ED": "Suzuken",
    "0040E4": "E-M TECHNOLOGY",
    "E084F3": "High Grade Controls Corporation",
    "E8DF70": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
    "D05995": "Fiberhome Telecommunication Technologies Co.",
    "043A0D": "SM Optics S.r.l.",
    "B8D94D": "Sagemcom Broadband SAS",
    "448F17": "Samsung Electronics Co.",
    "00FC8B": "Amazon Technologies Inc.",
    "0076B1": "Somfy-Protect By Myfox SAS",
    "80C755": "Panasonic Appliances Company",
    "4C1365": "Emplus Technologies",
    "38A6CE": "SKY UK LIMITED",
    "BC4101": "Shenzhen TINNO Mobile Technology Corp.",
    "1878D4": "Verizon",
    "0C62A6": "Hui Zhou Gaoshengda Technology Co.",
    "18132D": "zte corporation",
    "74D21D": "HUAWEI TECHNOLOGIES CO.",
    "CCF957": "u-blox AG",
    "3890A5": "Cisco Systems",
    "1C7022": "Murata Manufacturing Co.",
    "CC9891": "Cisco Systems",
    "28BF89": "Fiberhome Telecommunication Technologies Co.",
    "903DBD": "SECURE METERS LIMITED",
    "C0742B": "SHENZHEN XUNLONG SOFTWARE CO.",
    "5C6776": "IDS Imaging Development Systems GmbH",
    "A072E4": "NJ SYSTEM CO.",
    "44EAD8": "Texas Instruments",
    "189BA5": "IEEE Registration Authority",
    "A491B1": "Technicolor Delivery Technologies Belgium NV",
    "6CC147": "Xiamen Hanin Electronic Technology Co.",
    "002294": "KYOCERA CORPORATION",
    "3889DC": "Opticon Sensors Europe B.V.",
    "74E5F9": "Intel Corporate",
    "1CDDEA": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "940006": "jinyoung",
    "40CE24": "Cisco Systems",
    "3432E6": "Panasonic Industrial Devices Europe GmbH",
    "40017A": "Cisco Systems",
    "8C8590": "Apple",
    "BC88C3": "Ningbo Dooya Mechanic & Electronic Technology Co.",
    "38CD07": "Beijing FaceCam Technology Co.",
    "A43412": "Thales Alenia Space",
    "FC017C": "Hon Hai Precision Ind. Co.",
    "90324B": "Hon Hai Precision Ind. Co.",
    "681F40": "Blu Wireless Technology Ltd",
    "6C96CF": "Apple",
    "78886D": "Apple",
    "20EE28": "Apple",
    "B4F61C": "Apple",
    "08F4AB": "Apple",
    "8C4500": "Murata Manufacturing Co.",
    "90ADF7": "vivo Mobile Communication Co.",
    "ECFA03": "FCA",
    "00D060": "Panasonic Europe Ltd.",
    "0C4B54": "TP-LINK TECHNOLOGIES CO.",
    "60F677": "Intel Corporate",
    "E8E1E2": "Energotest",
    "E472E2": "HUAWEI TECHNOLOGIES CO.",
    "508F4C": "Xiaomi Communications Co Ltd",
    "A47758": "Ningbo Freewings Technologies Co.",
    "00127D": "MobileAria",
    "602E20": "HUAWEI TECHNOLOGIES CO.",
    "58A0CB": "TrackNet",
    "A08869": "Intel Corporate",
    "008BFC": "mixi",
    "94E36D": "Texas Instruments",
    "E06089": "Cloudleaf",
    "783690": "Yulong Computer Telecommunication Scientific (Shenzhen) Co.",
    "F0F8F2": "Texas Instruments",
    "341513": "Texas Instruments",
    "74819A": "PT. Hartono Istana Teknologi",
    "C444A0": "Cisco Systems",
    "18742E": "Amazon Technologies Inc.",
    "F844E3": "Taicang T&W Electronics",
    "283545": "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.",
    "044F4C": "HUAWEI TECHNOLOGIES CO.",
    "1C151F": "HUAWEI TECHNOLOGIES CO.",
    "D837BE": "SHENZHEN GONGJIN ELECTRONICS CO.",
    "90A365": "HMD Global Oy",
    "DC44B6": "Samsung Electronics Co.",
    "1007B6": "Samsung Electronics Co.",
    "24A534": "SynTrust Tech International Ltd.",
    "A82BB5": "Edgecore Networks Corporation",
    "A0423F": "Tyan Computer Corp",
    "70F11C": "Shenzhen Ogemray Technology Co.",
    "7065A3": "Kandao lightforge Co.",
    "74D0DC": "Ericsson AB",
    "54BD79": "Samsung Electronics Co.",
    "342D0D": "Samsung Electronics Co.",
    "7811DC": "XIAOMI Electronics",
    "D463C6": "Motorola Mobility LLC",
    "C08ADE": "Ruckus Wireless",
    "001D2E": "Ruckus Wireless",
    "8C0C90": "Ruckus Wireless",
    "6CAAB3": "Ruckus Wireless",
    "001392": "Ruckus Wireless",
    "D4684D": "Ruckus Wireless",
    "A0C5F2": "IEEE Registration Authority",
    "A86B7C": "SHENZHEN FENGLIAN TECHNOLOGY CO.",
    "B03956": "NETGEAR",
    "EC42B4": "ADC Corporation",
    "60DA83": "Hangzhou H3C Technologies Co.",
    "2C5731": "Wingtech Group (HongKong）Limited",
    "4859A4": "zte corporation",
    "085114": "QINGDAO TOPSCOMM COMMUNICATION CO.",
    "70788B": "vivo Mobile Communication Co.",
    "AC9E17": "ASUSTek COMPUTER INC.",
    "641666": "Nest Labs Inc.",
    "CC4639": "WAAV",
    "D8DF7A": "Quest Software",
    "A0239F": "Cisco Systems",
    "70F35A": "Cisco Systems",
    "B4E62A": "LG Innotek",
    "E4A749": "Palo Alto Networks",
    "A0AFBD": "Intel Corporate",
    "7C8BCA": "TP-LINK TECHNOLOGIES CO.",
    "B04E26": "TP-LINK TECHNOLOGIES CO.",
    "B089C2": "Zyptonite",
    "F023B9": "IEEE Registration Authority",
    "30074D": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
    "A0341B": "Adero Inc",
    "8C147D": "IEEE Registration Authority",
    "FC4DD4": "Universal Global Scientific Industrial Co.",
    "145BE1": "nyantec GmbH",
    "A4F4C2": "VNPT TECHNOLOGY",
    "481063": "NTT Innovation Institute",
    "A08E78": "Sagemcom Broadband SAS",
    "947BE7": "Samsung Electronics Co.",
    "5092B9": "Samsung Electronics Co.",
    "DC74A8": "Samsung Electronics Co.",
    "88D50C": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "D428D5": "TCT mobile ltd",
    "1C1FD4": "LifeBEAM Technologies LTD",
    "009AD2": "Cisco Systems",
    "E83935": "Hewlett Packard",
    "00180A": "Cisco Meraki",
    "18A958": "PROVISION THAI CO.",
    "9CE951": "Shenzhen Sang Fei Consumer Communications Ltd.",
    "74C9A3": "Fiberhome Telecommunication Technologies Co.",
    "EC8A4C": "zte corporation",
    "D45F25": "Shenzhen YOUHUA Technology Co.",
    "40C8CB": "AM Telecom co.",
    "907065": "Texas Instruments",
    "5C6A80": "Zyxel Communications Corporation",
    "D860B3": "Guangdong Global Electronic Technology CO.，LTD",
    "64351C": "e-CON SYSTEMS INDIA PVT LTD",
    "A8D579": "Beijing Chushang Science and Technology Co.",
    "605317": "Sandstone Technologies",
    "60BA18": "nextLAP GmbH",
    "84CD62": "ShenZhen IDWELL Technology CO.",
    "B8D50B": "Sunitec Enterprise Co.",
    "BC66DE": "Shadow Creator Information Technology Co.",
    "9CAF6F": "ITEL MOBILE LIMITED",
    "FC539E": "Shanghai Wind Technologies Co.",
    "C83A6B": "Roku",
    "B4C6F8": "Axilspot Communication",
    "001FA4": "SHENZHEN GONGJIN ELECTRONICS CO.",
    "C4AE12": "Samsung Electronics Co.",
    "58D9D5": "Tenda Technology Co.",
    "94D299": "Techmation Co.",
    "6CAB31": "Apple",
    "4C74BF": "Apple",
    "04946B": "TECNO MOBILE LIMITED",
    "A04C5B": "Shenzhen TINNO Mobile Technology Corp.",
    "F85971": "Intel Corporate",
    "341A35": "Fiberhome Telecommunication Technologies Co.",
    "2C029F": "3ALogics",
    "00050F": "Tanaka S/S Ltd.",
    "488803": "ManTechnology Inc.",
    "B436E3": "KBVISION GROUP",
    "6C4B90": "LiteON",
    "2CABEB": "Cisco Systems",
    "64D154": "Routerboard.com",
    "989E63": "Apple",
    "886B6E": "Apple",
    "D4DCCD": "Apple",
    "484BAA": "Apple",
    "DCA904": "Apple",
    "BC452E": "Knowledge Development for POF S.L.",
    "706DEC": "Wifi-soft LLC",
    "B0C205": "BIONIME",
    "94F551": "Cadi Scientific Pte Ltd",
    "F4E4AD": "zte corporation",
    "28FF3E": "zte corporation",
    "B8D7AF": "Murata Manufacturing Co.",
    "D4AE05": "Samsung Electronics Co.",
    "1005CA": "Cisco Systems",
    "7894B4": "Sercomm Corporation.",
    "E048AF": "Premietech Limited",
    "2C3311": "Cisco Systems",
    "5082D5": "Apple",
    "3CA067": "Liteon Technology Corporation",
    "F0EE10": "Samsung Electronics Co.",
    "C4700B": "GUANGZHOU CHIP TECHNOLOGIES CO.",
    "443708": "MRV Comunications",
    "1C1EE3": "Hui Zhou Gaoshengda Technology Co.",
    "44032C": "Intel Corporate",
    "500FF5": "Tenda Technology Co.",
    "BC024A": "HMD Global Oy",
    "949901": "Shenzhen YITOA Digital Appliance CO.",
    "285F2F": "RNware Co.",
    "105AF7": "ADB Italia",
    "B81DAA": "LG Electronics (Mobile Communications)",
    "00E400": "Sichuan Changhong Electric Ltd.",
    "542F8A": "TELLESCOM INDUSTRIA E COMERCIO EM TELECOMUNICACAO",
    "08CCA7": "Cisco Systems",
    "0896AD": "Cisco Systems",
    "2C55D3": "HUAWEI TECHNOLOGIES CO.",
    "DCC64B": "HUAWEI TECHNOLOGIES CO.",
    "043389": "HUAWEI TECHNOLOGIES CO.",
    "00A068": "BHP LIMITED",
    "703ACB": "Google",
    "00C024": "EDEN SISTEMAS DE COMPUTACAO SA",
    "7C4685": "Motorola (Wuhan) Mobility Technologies Communication Co.",
    "6014B3": "CyberTAN Technology Inc.",
    "1C398A": "Fiberhome Telecommunication Technologies Co.",
    "00179B": "CHANT SINCERE CO.",
    "7868F7": "YSTen Technology Co.",
    "44D437": "Inteno Broadband Technology AB",
    "ECE154": "Beijing Unisound Information Technology Co.",
    "E865D4": "Tenda Technology Co.",
    "24D51C": "Zhongtian broadband technology co.",
    "EC43F6": "Zyxel Communications Corporation",
    "60C658": "PHYTRONIX Co.",
    "FCB58A": "Wapice Ltd.",
    "347877": "O-Net Communications (Shenzhen) Limited",
    "0020CC": "DIGITAL SERVICES",
    "0823B2": "vivo Mobile Communication Co.",
    "88C3B3": "SOVICO",
    "A462DF": "DS Global. Co.",
    "4C1694": "shenzhen sibituo Technology Co.",
    "6C160E": "ShotTracker",
    "803A0A": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "E05124": "NXP Semiconductors",
    "001DA3": "SabiOso",
    "689FF0": "zte corporation",
    "00014F": "Adtran Inc",
    "285261": "Cisco Systems",
    "286F7F": "Cisco Systems",
    "20780B": "Delta Faucet Company",
    "0C73BE": "Dongguan Haimai Electronie Technology Co.",
    "F0C850": "HUAWEI TECHNOLOGIES CO.",
    "C81451": "HUAWEI TECHNOLOGIES CO.",
    "5CAF06": "LG Electronics (Mobile Communications)",
    "24A7DC": "SKY UK LIMITED",
    "98B6E9": "Nintendo Co.",
    "F8983A": "Leeman International (HongKong) Limited",
    "4CECEF": "Soraa",
    "1CEFCE": "bebro electronic GmbH",
    "30E171": "Hewlett Packard",
    "F015B9": "PlayFusion Limited",
    "64DBA0": "Select Comfort",
    "2CD02D": "Cisco Systems",
    "1840A4": "Shenzhen Trylong Smart Science and Technology Co.",
    "C8AA55": "Hunan Comtom Electronic Incorporated Co.",
    "64B0A6": "Apple",
    "7C04D0": "Apple",
    "84FCAC": "Apple",
    "DC0C5C": "Apple",
    "70700D": "Apple",
    "001D72": "Wistron Corporation",
    "186590": "Apple",
    "F86214": "Apple",
    "784F43": "Apple",
    "404D7F": "Apple",
    "1C48CE": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "D8197A": "Nuheara Ltd",
    "4C38D5": "MITAC COMPUTING TECHNOLOGY CORPORATION",
    "54B56C": "Xi'an NovaStar Tech Co.",
    "2CDCAD": "Wistron Neweb Corporation",
    "6C5C14": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "4C7487": "Leader Phone Communication Technology Co.",
    "C80CC8": "HUAWEI TECHNOLOGIES CO.",
    "344CC8": "Echodyne Corp",
    "64136C": "zte corporation",
    "04B648": "ZENNER",
    "98F199": "NEC Platforms",
    "603E7B": "Gafachi",
    "0425C5": "HUAWEI TECHNOLOGIES CO.",
    "AC83F3": "AMPAK Technology",
    "90D7BE": "Wavelab Global Inc.",
    "244E7B": "IEEE Registration Authority",
    "30AEA4": "Espressif Inc.",
    "CC8CDA": "Shenzhen Wei Da Intelligent Technology Go.",
    "D436DB": "Jiangsu Toppower Automotive Electronics Co.",
    "7C2587": "chaowifi.com",
    "B0A2E7": "Shenzhen TINNO Mobile Technology Corp.",
    "E80945": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "002144": "SS Telecoms",
    "20719E": "SF Technology Co.",
    "2CC260": "Oracle Corporation",
    "3C3F51": "2CRSI",
    "3C2AF4": "Brother Industries",
    "50584F": "waytotec",
    "CC61E5": "Motorola Mobility LLC",
    "EC0D9A": "Mellanox Technologies",
    "3CFA43": "HUAWEI TECHNOLOGIES CO.",
    "145F94": "HUAWEI TECHNOLOGIES CO.",
    "CC9470": "Kinestral Technologies",
    "085DDD": "MERCURY CORPORATION",
    "001F82": "Cal-Comp Electronics & Communications Company Ltd.",
    "883C1C": "MERCURY CORPORATION",
    "2834A2": "Cisco Systems",
    "006BF1": "Cisco Systems",
    "00501E": "Grass Valley",
    "B439D6": "ProCurve Networking by HP",
    "34F39A": "Intel Corporate",
    "8C60E7": "MPGIO CO.",
    "8C8ABB": "Beijing Orient View Technology Co.",
    "00039B": "NetChip Technology",
    "609AC1": "Apple",
    "748D08": "Apple",
    "9C8BA0": "Apple",
    "CC088D": "Apple",
    "38A4ED": "Xiaomi Communications Co Ltd",
    "B89919": "7signal Solutions",
    "40FE0D": "MAXIO",
    "AC64DD": "IEEE Registration Authority",
    "BC39D9": "Z-TEC",
    "3087D9": "Ruckus Wireless",
    "F09838": "HUAWEI TECHNOLOGIES CO.",
    "94B819": "Nokia",
    "787D48": "ITEL MOBILE LIMITED",
    "8871E5": "Amazon Technologies Inc.",
    "C0854C": "Ragentek Technology Group",
    "D816C1": "DEWAV (HK) ELECTRONICS LIMITED",
    "60EFC6": "Shenzhen Chima Technologies Co Limited",
    "20DBAB": "Samsung Electronics Co.",
    "383A21": "IEEE Registration Authority",
    "D8380D": "SHENZHEN IP-COM Network Co.",
    "FCCAC4": "LifeHealth",
    "88AD43": "PEGATRON CORPORATION",
    "B4EFFA": "Lemobile Information Technology (Beijing) Co.",
    "00265F": "Samsung Electronics Co.",
    "00233A": "Samsung Electronics Co.",
    "101250": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "B0C128": "Adler ELREHA GmbH",
    "F81D78": "IEEE Registration Authority",
    "38F7B2": "SEOJUN ELECTRIC",
    "7802B7": "ShenZhen Ultra Easy Technology CO.",
    "646184": "VELUX",
    "F0D9B2": "EXO S.A.",
    "E4C801": "BLU Products Inc",
    "001FC6": "ASUSTek COMPUTER INC.",
    "6C71BD": "EZELINK TELECOM",
    "0007AB": "Samsung Electronics Co.",
    "E8E5D6": "Samsung Electronics Co.",
    "C87E75": "Samsung Electronics Co.",
    "EC65CC": "Panasonic Automotive Systems Company of America",
    "80691A": "Belkin International Inc.",
    "B80756": "Cisco Meraki",
    "3456FE": "Cisco Meraki",
    "001E84": "Pika Technologies Inc.",
    "10DDB1": "Apple",
    "002329": "DDRdrive LLC",
    "0026AD": "Arada Systems",
    "002486": "DesignArt Networks",
    "002478": "Mag Tech Electronics Co Limited",
    "382DD1": "Samsung Electronics Co.",
    "001B2C": "ATRON electronic GmbH",
    "001427": "JazzMutant",
    "9034FC": "Hon Hai Precision Ind. Co.",
    "889FFA": "Hon Hai Precision Ind. Co.",
    "8C7CB5": "Hon Hai Precision Ind. Co.",
    "C44619": "Hon Hai Precision Ind. Co.",
    "AC63BE": "Amazon Technologies Inc.",
    "086A0A": "ASKEY COMPUTER CORP",
    "98E7F4": "Hewlett Packard",
    "C80E14": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
    "FC1F19": "SAMSUNG ELECTRO MECHANICS CO.",
    "840B2D": "SAMSUNG ELECTRO MECHANICS CO.",
    "206432": "SAMSUNG ELECTRO MECHANICS CO.",
    "001599": "Samsung Electronics Co.",
    "0012FB": "Samsung Electronics Co.",
    "D0667B": "Samsung Electronics Co.",
    "E8039A": "Samsung Electronics Co.",
    "0C84DC": "Hon Hai Precision Ind. Co.",
    "1C66AA": "Samsung Electronics Co.",
    "1489FD": "Samsung Electronics Co.",
    "BC851F": "Samsung Electronics Co.",
    "B85E7B": "Samsung Electronics Co.",
    "B407F9": "SAMSUNG ELECTRO MECHANICS CO.",
    "00166C": "Samsung Electronics Co.",
    "506313": "Hon Hai Precision Ind. Co.",
    "60D819": "Hon Hai Precision Ind. Co.",
    "F82FA8": "Hon Hai Precision Ind. Co.",
    "002491": "Samsung Electronics Co.",
    "3C8BFE": "Samsung Electronics Co.",
    "D4E8B2": "Samsung Electronics Co.",
    "002339": "Samsung Electronics Co.",
    "30CDA7": "Samsung Electronics Co.",
    "001247": "Samsung Electronics Co.",
    "0015B9": "Samsung Electronics Co.",
    "5001BB": "Samsung Electronics Co.",
    "2C4401": "Samsung Electronics Co.",
    "B8D9CE": "Samsung Electronics Co.",
    "C40142": "MaxMedia Technology Limited",
    "8430E5": "SkyHawke Technologies",
    "1C77F6": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "58E326": "Compass Technologies Inc.",
    "001B2A": "Cisco Systems",
    "749DDC": "2Wire Inc",
    "9CB2B2": "HUAWEI TECHNOLOGIES CO.",
    "A8C83A": "HUAWEI TECHNOLOGIES CO.",
    "14DDE5": "MPMKVVCL",
    "001A09": "Wayfarer Transit Systems Ltd",
    "C8BA94": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
    "843838": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
    "54880E": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
    "F025B7": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
    "F04347": "HUAWEI TECHNOLOGIES CO.",
    "E492FB": "Samsung Electronics Co.",
    "6CB7F4": "Samsung Electronics Co.",
    "181EB0": "Samsung Electronics Co.",
    "247F20": "Sagemcom Broadband SAS",
    "BC72B1": "Samsung Electronics Co.",
    "78F7BE": "Samsung Electronics Co.",
    "684898": "Samsung Electronics Co.",
    "3423BA": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
    "400E85": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
    "742344": "Xiaomi Communications Co Ltd",
    "E09DFA": "Wanan Hongsheng Electronic Co.Ltd",
    "5C3C27": "Samsung Electronics Co.",
    "70A84C": "MONAD.",
    "84C7EA": "Sony Corporation",
    "24E43F": "Wenzhou Kunmei Communication Technology Co.",
    "2CAC44": "CONEXTOP",
    "A48269": "Datrium",
    "00258B": "Mellanox Technologies",
    "00562B": "Cisco Systems",
    "E8FD90": "Turbostor",
    "1899F5": "Sichuan Changhong Electric Ltd.",
    "D013FD": "LG Electronics (Mobile Communications)",
    "88797E": "Motorola Mobility LLC",
    "305890": "Frontier Silicon Ltd",
    "708BCD": "ASUSTek COMPUTER INC.",
    "606405": "Texas Instruments",
    "10E68F": "KWANGSUNG ELECTRONICS KOREA CO.",
    "4CFACA": "Cambridge Industries(Group) Co.",
    "0025C3": "21168",
    "000F57": "CABLELOGIC Co.",
    "000342": "Nortel Networks",
    "001283": "Nortel Networks",
    "0011F9": "Nortel Networks",
    "001158": "Nortel Networks",
    "000F6A": "Nortel Networks",
    "000E62": "Nortel Networks",
    "000CF8": "Nortel Networks",
    "000997": "Nortel Networks",
    "001CEB": "Nortel Networks",
    "001C17": "Nortel Networks",
    "18ABF5": "Ultra Electronics Electrics",
    "B03EB0": "MICRODIA Ltd.",
    "001591": "RLW Inc.",
    "00182E": "XStreamHD",
    "001A8F": "Nortel Networks",
    "0017D1": "Nortel Networks",
    "0014C7": "Nortel Networks",
    "001DAF": "Nortel Networks",
    "0026F1": "ProCurve Networking by HP",
    "380DD4": "Primax Electronics Ltd.",
    "98FDB4": "Primax Electronics Ltd.",
    "D8C46A": "Murata Manufacturing Co.",
    "888322": "Samsung Electronics Co.",
    "E89309": "Samsung Electronics Co.",
    "982F3C": "Sichuan Changhong Electric Ltd.",
    "D8FB68": "Cloud Corner Ltd.",
    "685388": "P&S Technology",
    "14C1FF": "ShenZhen QianHai Comlan communication Co.",
    "ECFAAA": "The IMS Company",
    "F00786": "Shandong Bittel Electronics Co.",
    "00D0F6": "Nokia",
    "44334C": "Shenzhen Bilian electronic CO.",
    "ACA213": "Shenzhen Bilian electronic CO.",
    "3C3300": "Shenzhen Bilian electronic CO.",
    "54A619": "Alcatel-Lucent Shanghai Bell Co.",
    "002105": "Alcatel-Lucent IPD",
    "38F8CA": "OWIN Inc.",
    "E417D8": "8BITDO TECHNOLOGY HK LIMITED",
    "2057AF": "Shenzhen FH-NET OPTOELECTRONICS CO.",
    "54DC1D": "Yulong Computer Telecommunication Scientific (Shenzhen) Co.",
    "882BD7": "ADDÉNERGIE  TECHNOLOGIES",
    "0090CC": "PLANEX COMMUNICATIONS INC.",
    "0022CF": "PLANEX COMMUNICATIONS INC.",
    "78C3E9": "Samsung Electronics Co.",
    "8C1ABF": "Samsung Electronics Co.",
    "30CBF8": "Samsung Electronics Co.",
    "A0CBFD": "Samsung Electronics Co.",
    "C0E42D": "TP-LINK TECHNOLOGIES CO.",
    "8CA6DF": "TP-LINK TECHNOLOGIES CO.",
    "8416F9": "TP-LINK TECHNOLOGIES CO.",
    "18D6C7": "TP-LINK TECHNOLOGIES CO.",
    "6CD032": "LG Electronics",
    "344DF7": "LG Electronics (Mobile Communications)",
    "583F54": "LG Electronics (Mobile Communications)",
    "88A6C6": "Sagemcom Broadband SAS",
    "94D469": "Cisco Systems",
    "9CD332": "PLC Technology Ltd",
    "74A722": "LG Electronics (Mobile Communications)",
    "F01C13": "LG Electronics (Mobile Communications)",
    "A816B2": "LG Electronics (Mobile Communications)",
    "64BC0C": "LG Electronics (Mobile Communications)",
    "64899A": "LG Electronics (Mobile Communications)",
    "F8A9D0": "LG Electronics (Mobile Communications)",
    "CCFA00": "LG Electronics (Mobile Communications)",
    "001BC5": "IEEE Registration Authority",
    "000031": "QPSX COMMUNICATIONS",
    "000E1E": "QLogic Corporation",
    "E45D75": "Samsung Electronics Co.",
    "90C682": "IEEE Registration Authority",
    "005056": "VMware",
    "CC52AF": "Universal Global Scientific Industrial Co.",
    "C01ADA": "Apple",
    "00121C": "PARROT SA",
    "9003B7": "PARROT SA",
    "58FCDB": "IEEE Registration Authority",
    "B0C5CA": "IEEE Registration Authority",
    "7419F8": "IEEE Registration Authority",
    "0014D1": "TRENDnet",
    "001C14": "VMware",
    "38A28C": "SHENZHEN RF-LINK TECHNOLOGY CO.",
    "A09E1A": "Polar Electro Oy",
    "B4A5EF": "Sercomm Corporation.",
    "0010C1": "OI ELECTRIC CO.",
    "208756": "SIEMENS AG",
    "74B472": "CIESSE",
    "FCF152": "Sony Corporation",
    "309BAD": "BBK EDUCATIONAL ELECTRONICS CORP.",
    "BC307E": "Wistron Neweb Corporation",
    "BC307D": "Wistron Neweb Corporation",
    "48A9D2": "Wistron Neweb Corporation",
    "80EA23": "Wistron Neweb Corporation",
    "483C0C": "HUAWEI TECHNOLOGIES CO.",
    "002713": "Universal Global Scientific Industrial Co.",
    "0080F7": "Zenith Electronics Corporation",
    "001BB1": "Wistron Neweb Corporation",
    "68B35E": "Shenzhen Neostra Technology Co.Ltd",
    "1CD6BD": "LEEDARSON LIGHTING CO.",
    "D0D94F": "IEEE Registration Authority",
    "849D64": "SMC Corporation",
    "00A0C5": "Zyxel Communications Corporation",
    "506583": "Texas Instruments",
    "B09122": "Texas Instruments",
    "FCF528": "Zyxel Communications Corporation",
    "9857D3": "HON HAI-CCPBG  PRECISION IND.CO.",
    "24E271": "Qingdao Hisense Communications Co.",
    "BC6010": "Qingdao Hisense Communications Co.",
    "AC0481": "Jiangsu Huaxing Electronics Co.",
    "98398E": "Samsung Electronics Co.",
    "D0FCCC": "Samsung Electronics Co.",
    "60C0BF": "ON Semiconductor",
    "408805": "Motorola Mobility LLC",
    "001E04": "Hanson Research Corporation",
    "44D1FA": "Shenzhen Yunlink Technology Co.",
    "F0F644": "Whitesky Science & Technology Co.",
    "C41CFF": "Vizio",
    "7C6AF3": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "C09727": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
    "E46251": "HAO CHENG GROUP LIMITED",
    "3876D1": "Euronda SpA",
    "DC293A": "Shenzhen Nuoshi Technology Co.",
    "40562D": "Smartron India Pvt ltd",
    "A0D385": "AUMA Riester GmbH & Co. KG",
    "1414E6": "Ningbo Sanhe Digital Co.",
    "0C5101": "Apple",
    "2CF0A2": "Apple",
    "68FB7E": "Apple",
    "84A134": "Apple",
    "20F17C": "HUAWEI TECHNOLOGIES CO.",
    "346AC2": "HUAWEI TECHNOLOGIES CO.",
    "6891D0": "IEEE Registration Authority",
    "904D4A": "Sagemcom Broadband SAS",
    "C4693E": "Turbulence Design Inc.",
    "009569": "LSD Science and Technology Co.",
    "B0CF4D": "MI-Zone Technology Ireland",
    "289AFA": "TCT mobile ltd",
    "001A34": "Konka Group Co.",
    "0011FC": "HARTING Electronics GmbH",
    "D8209F": "Cubro Acronet GesmbH",
    "8C7716": "LONGCHEER TELECOMMUNICATION LIMITED",
    "002389": "Hangzhou H3C Technologies Co.",
    "3CE5A6": "Hangzhou H3C Technologies Co.",
    "5CDD70": "Hangzhou H3C Technologies Co.",
    "3C8C40": "Hangzhou H3C Technologies Co.",
    "E04F43": "Universal Global Scientific Industrial Co.",
    "A067BE": "Sicon srl",
    "002582": "Maksat Technologies (P) Ltd",
    "6C2483": "Microsoft Mobile Oy",
    "48C049": "Broad Telecom SA",
    "AC6FBB": "TATUNG Technology Inc.",
    "001C41": "scemtec Transponder Technology GmbH",
    "146308": "JABIL CIRCUIT (SHANGHAI) LTD.",
    "001E25": "INTEK DIGITAL",
    "00E0CF": "INTEGRATED DEVICE",
    "0060B1": "Input/Output",
    "547F54": "INGENICO",
    "90C7D8": "zte corporation",
    "001CD7": "Harman/Becker Automotive Systems GmbH",
    "003A7D": "Cisco Systems",
    "001A45": "GN Netcom A/S",
    "002088": "GLOBAL VILLAGE COMMUNICATION",
    "844076": "Drivenets",
    "001921": "Elitegroup Computer Systems Co.",
    "0016EC": "Elitegroup Computer Systems Co.",
    "000795": "Elitegroup Computer Systems Co.",
    "541379": "Hon Hai Precision Ind. Co.",
    "000E2E": "Edimax Technology Co. Ltd.",
    "00065F": "ECI Telecom Ltd.",
    "00208F": "ECI Telecom Ltd.",
    "DC9C9F": "Shenzhen YOUHUA Technology Co.",
    "74DFBF": "Liteon Technology Corporation",
    "84AD58": "HUAWEI TECHNOLOGIES CO.",
    "58605F": "HUAWEI TECHNOLOGIES CO.",
    "D8D723": "IDS",
    "F03E90": "Ruckus Wireless",
    "00A0F4": "GE",
    "00185C": "EDSLAB Technologies",
    "FC0F4B": "Texas Instruments",
    "D4883F": "HDPRO CO.",
    "AC0D1B": "LG Electronics (Mobile Communications)",
    "F0D1B8": "LEDVANCE",
    "986D35": "IEEE Registration Authority",
    "88795B": "Konka Group Co.",
    "081F71": "TP-LINK TECHNOLOGIES CO.",
    "5CCA1A": "Microsoft Mobile Oy",
    "60B617": "Fiberhome Telecommunication Technologies Co.",
    "18A3E8": "Fiberhome Telecommunication Technologies Co.",
    "741E93": "Fiberhome Telecommunication Technologies Co.",
    "FC2FAA": "Nokia",
    "B07E70": "Zadara Storage Ltd.",
    "0080B1": "SOFTCOM A/S",
    "202DF8": "Digital Media Cartridge Ltd.",
    "10D0AB": "zte corporation",
    "0004C6": "YAMAHA MOTOR CO.",
    "202D07": "Samsung Electronics Co.",
    "981FB1": "Shenzhen Lemon Network Technology Co.",
    "0C5A9E": "Wi-SUN Alliance",
    "E8B2AC": "Apple",
    "E49A79": "Apple",
    "B44BD2": "Apple",
    "DC415F": "Apple",
    "641225": "Cisco Systems",
    "7864E6": "Green Motive Technology Limited",
    "3CBEE1": "NIKON CORPORATION",
    "D8803C": "Anhui Huami Information Technology Company Limited",
    "0034DA": "LG Electronics (Mobile Communications)",
    "3810D5": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
    "006016": "CLARIION",
    "00C88B": "Cisco Systems",
    "18C501": "SHENZHEN GONGJIN ELECTRONICS CO.",
    "00A0B8": "NetApp",
    "102AB3": "Xiaomi Communications Co Ltd",
    "40D357": "Ison Technology Co.",
    "A0B9ED": "Skytap",
    "0009D2": "Mai Logic Inc.",
    "24C3F9": "Securitas Direct AB",
    "2C21D7": "IMAX Corporation",
    "30A9DE": "LG Innotek",
    "F01B6C": "vivo Mobile Communication Co.",
    "20768F": "Apple",
    "9C5CF9": "Sony Corporation",
    "0011D1": "Soft Imaging System GmbH",
    "74C330": "SHENZHEN FAST TECHNOLOGIES CO.",
    "98D686": "Chyi Lee industry Co.",
    "8CC661": "Current",
    "88A084": "Formation Data Systems",
    "94C960": "Zhongshan B&T technology.co.",
    "F45C89": "Apple",
    "DCB3B4": "Honeywell Environmental & Combustion Controls (Tianjin) Co.",
    "00247C": "Nokia Danmark A/S",
    "4C2578": "Nokia Corporation",
    "BCC6DB": "Nokia Corporation",
    "60A8FE": "Nokia Solutions and Networks GmbH & Co. KG",
    "001FDE": "Nokia Danmark A/S",
    "001FDF": "Nokia Danmark A/S",
    "547975": "Nokia Corporation",
    "A87B39": "Nokia Corporation",
    "001D3B": "Nokia Danmark A/S",
    "001DFD": "Nokia Danmark A/S",
    "001E3B": "Nokia Danmark A/S",
    "001EA4": "Nokia Danmark A/S",
    "0026CC": "Nokia Danmark A/S",
    "000EED": "Nokia Danmark A/S",
    "00119F": "Nokia Danmark A/S",
    "001A16": "Nokia Danmark A/S",
    "001A89": "Nokia Danmark A/S",
    "001ADC": "Nokia Danmark A/S",
    "0025CF": "Nokia Danmark A/S",
    "0021AB": "Nokia Danmark A/S",
    "002266": "Nokia Danmark A/S",
    "0021FE": "Nokia Danmark A/S",
    "C477AB": "Beijing ASU Tech Co.",
    "300D43": "Microsoft Mobile Oy",
    "607EDD": "Microsoft Mobile Oy",
    "A8A089": "Tactical Communications",
    "48365F": "Wintecronics Ltd.",
    "000BCA": "DATAVAN TC",
    "702559": "CyberTAN Technology Inc.",
    "001D20": "Comtrend Corporation",
    "389496": "Samsung Electronics Co.",
    "5056BF": "Samsung Electronics Co.",
    "90F1AA": "Samsung Electronics Co.",
    "1077B1": "Samsung Electronics Co.",
    "001FC7": "Casio Hitachi Mobile Communications Co.",
    "00000E": "FUJITSU LIMITED",
    "000B5D": "FUJITSU LIMITED",
    "080581": "Roku",
    "74458A": "Samsung Electronics Co.",
    "FCC734": "Samsung Electronics Co.",
    "8425DB": "Samsung Electronics Co.",
    "B0EC71": "Samsung Electronics Co.",
    "E458B8": "Samsung Electronics Co.",
    "088C2C": "Samsung Electronics Co.",
    "A49A58": "Samsung Electronics Co.",
    "08EE8B": "Samsung Electronics Co.",
    "64B853": "Samsung Electronics Co.",
    "08373D": "Samsung Electronics Co.",
    "C488E5": "Samsung Electronics Co.",
    "0C75BD": "Cisco Systems",
    "000DF3": "Asmax Solutions",
    "000DB6": "Broadcom",
    "000AF7": "Broadcom",
    "D40129": "Broadcom",
    "001D00": "Brivo Systems",
    "0020D6": "Breezecom",
    "C4473F": "HUAWEI TECHNOLOGIES CO.",
    "5CDC96": "Arcadyan Technology Corporation",
    "001A2A": "Arcadyan Technology Corporation",
    "88252C": "Arcadyan Technology Corporation",
    "1CC63C": "Arcadyan Technology Corporation",
    "1883BF": "Arcadyan Technology Corporation",
    "68ED43": "BlackBerry RTS",
    "70AAB2": "BlackBerry RTS",
    "00E063": "Cabletron Systems",
    "9CC7A6": "AVM GmbH",
    "A06391": "NETGEAR",
    "20E52A": "NETGEAR",
    "4494FC": "NETGEAR",
    "E091F5": "NETGEAR",
    "00146C": "NETGEAR",
    "001E2A": "NETGEAR",
    "00184D": "NETGEAR",
    "0CA42A": "OB Telecom Electronic Technology Co.",
    "200CC8": "NETGEAR",
    "744401": "NETGEAR",
    "000F86": "BlackBerry RTS",
    "E839DF": "ASKEY COMPUTER CORP",
    "0024D2": "ASKEY COMPUTER CORP",
    "B4EEB4": "ASKEY COMPUTER CORP",
    "00040E": "AVM GmbH",
    "40BA61": "ARIMA Communications Corp.",
    "0011F5": "ASKEY COMPUTER CORP",
    "0016E3": "ASKEY COMPUTER CORP",
    "E874E6": "ADB Broadband Italia",
    "0020E0": "Actiontec Electronics",
    "002662": "Actiontec Electronics",
    "280DFC": "Sony Interactive Entertainment Inc.",
    "701A04": "Liteon Technology Corporation",
    "48D224": "Liteon Technology Corporation",
    "20689D": "Liteon Technology Corporation",
    "D0DF9A": "Liteon Technology Corporation",
    "1C659D": "Liteon Technology Corporation",
    "3010B3": "Liteon Technology Corporation",
    "E8C74F": "Liteon Technology Corporation",
    "D05349": "Liteon Technology Corporation",
    "948815": "Infinique Worldwide Inc",
    "D0E44A": "Murata Manufacturing Co.",
    "58170C": "Sony Corporation",
    "5CB524": "Sony Corporation",
    "90C115": "Sony Corporation",
    "D05162": "Sony Corporation",
    "18002D": "Sony Corporation",
    "0016B8": "Sony Corporation",
    "0024EF": "Sony Corporation",
    "0025E7": "Sony Corporation",
    "002553": "ADB Broadband Italia",
    "00193E": "ADB Broadband Italia",
    "000827": "ADB Broadband Italia",
    "080046": "Sony Corporation",
    "74DAEA": "Texas Instruments",
    "D887D5": "Leadcore Technology CO.",
    "00F28B": "Cisco Systems",
    "4C14A3": "TCL Technoly Electronics (Huizhou) Co.",
    "ECF00E": "AboCom",
    "00E098": "AboCom",
    "4CB0E8": "Beijing RongZhi xinghua technology co.",
    "9C4E36": "Intel Corporate",
    "3413E8": "Intel Corporate",
    "34E6AD": "Intel Corporate",
    "081196": "Intel Corporate",
    "742F68": "AzureWave Technology Inc.",
    "384FF0": "AzureWave Technology Inc.",
    "B4B676": "Intel Corporate",
    "3CA9F4": "Intel Corporate",
    "B88A60": "Intel Corporate",
    "78FF57": "Intel Corporate",
    "A48E0A": "DeLaval International AB",
    "AC2B6E": "Intel Corporate",
    "F8E079": "Motorola Mobility LLC",
    "CCC3EA": "Motorola Mobility LLC",
    "40786A": "Motorola Mobility LLC",
    "000A8A": "Cisco Systems",
    "9C3583": "Nipro Diagnostics",
    "C06118": "TP-LINK TECHNOLOGIES CO.",
    "002314": "Intel Corporate",
    "340286": "Intel Corporate",
    "001CBF": "Intel Corporate",
    "34DE1A": "Intel Corporate",
    "E8B1FC": "Intel Corporate",
    "D02212": "IEEE Registration Authority",
    "100723": "IEEE Registration Authority",
    "A44F29": "IEEE Registration Authority",
    "74F8DB": "IEEE Registration Authority",
    "CC3D82": "Intel Corporate",
    "001F3C": "Intel Corporate",
    "002315": "Intel Corporate",
    "00166F": "Intel Corporate",
    "0019D1": "Intel Corporate",
    "0019D2": "Intel Corporate",
    "001B21": "Intel Corporate",
    "18FF0F": "Intel Corporate",
    "183DA2": "Intel Corporate",
    "809B20": "Intel Corporate",
    "002710": "Intel Corporate",
    "C0830A": "2Wire Inc",
    "383BC8": "2Wire Inc",
    "60FE20": "2Wire Inc",
    "00183F": "2Wire Inc",
    "002456": "2Wire Inc",
    "1801E3": "Bittium Wireless Ltd",
    "18622C": "Sagemcom Broadband SAS",
    "3C81D8": "Sagemcom Broadband SAS",
    "40F201": "Sagemcom Broadband SAS",
    "D084B0": "Sagemcom Broadband SAS",
    "181E78": "Sagemcom Broadband SAS",
    "0037B7": "Sagemcom Broadband SAS",
    "0054BD": "Swelaser AB",
    "001E4C": "Hon Hai Precision Ind. Co.",
    "D8543A": "Texas Instruments",
    "649C8E": "Texas Instruments",
    "102EAF": "Texas Instruments",
    "7C8EE4": "Texas Instruments",
    "B4EED4": "Texas Instruments",
    "149182": "Belkin International Inc.",
    "20BB76": "COL GIOVANNI PAOLO SpA",
    "3CDD89": "SOMO HOLDINGS & TECH. CO.",
    "388602": "Flexoptix GmbH",
    "4065A3": "Sagemcom Broadband SAS",
    "00194B": "Sagemcom Broadband SAS",
    "001E74": "Sagemcom Broadband SAS",
    "A43BFA": "IEEE Registration Authority",
    "3C2DB7": "Texas Instruments",
    "D03761": "Texas Instruments",
    "C83E99": "Texas Instruments",
    "40984E": "Texas Instruments",
    "0017EB": "Texas Instruments",
    "0017E6": "Texas Instruments",
    "5464D9": "Sagemcom Broadband SAS",
    "001832": "Texas Instruments",
    "24DA11": "NO NDA Inc",
    "9C8E99": "Hewlett Packard",
    "EC2280": "D-Link International",
    "F4F5D8": "Google",
    "C4EDBA": "Texas Instruments",
    "9059AF": "Texas Instruments",
    "BC6A29": "Texas Instruments",
    "847E40": "Texas Instruments",
    "00195B": "D-Link Corporation",
    "000F3D": "D-Link Corporation",
    "B0C090": "Chicony Electronics Co.",
    "AC06C7": "ServerNet S.r.l.",
    "0059AC": "KPN. B.V.",
    "001735": "Intel Wireless Network Group",
    "74AC5F": "Qiku Internet Network Scientific (Shenzhen) Co.",
    "38CADA": "Apple",
    "788B77": "Standar Telecom",
    "18AF61": "Apple",
    "5CF938": "Apple",
    "0C0535": "Juniper Systems",
    "BC83A7": "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.",
    "BCEC23": "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.",
    "D0B33F": "Shenzhen TINNO Mobile Technology Corp.",
    "BCD1D3": "Shenzhen TINNO Mobile Technology Corp.",
    "D83C69": "Shenzhen TINNO Mobile Technology Corp.",
    "40D855": "IEEE Registration Authority",
    "34AB37": "Apple",
    "2400BA": "HUAWEI TECHNOLOGIES CO.",
    "24DF6A": "HUAWEI TECHNOLOGIES CO.",
    "8C579B": "Wistron Neweb Corporation",
    "101F74": "Hewlett Packard",
    "009C02": "Hewlett Packard",
    "0019BB": "Hewlett Packard",
    "DCFB02": "BUFFALO.INC",
    "8857EE": "BUFFALO.INC",
    "907F61": "Chicony Electronics Co.",
    "001F29": "Hewlett Packard",
    "00215A": "Hewlett Packard",
    "00237D": "Hewlett Packard",
    "002655": "Hewlett Packard",
    "000D9D": "Hewlett Packard",
    "00207B": "Intel Corporation",
    "001175": "Intel Corporation",
    "780CB8": "Intel Corporate",
    "185E0F": "Intel Corporate",
    "940937": "HUMAX Co.",
    "E84DD0": "HUAWEI TECHNOLOGIES CO.",
    "0C45BA": "HUAWEI TECHNOLOGIES CO.",
    "20906F": "Shenzhen Tencent Computer System Co.",
    "6CE3B6": "Nera Telecommunications Ltd.",
    "EC5F23": "Qinghai Kimascend Electronics Technology Co. Ltd.",
    "047D50": "Shenzhen Kang Ying Technology Co.Ltd.",
    "54EFFE": "Fullpower Technologies",
    "8002DF": "ORA Inc.",
    "DCD321": "HUMAX Co.",
    "7C7D3D": "HUAWEI TECHNOLOGIES CO.",
    "4482E5": "HUAWEI TECHNOLOGIES CO.",
    "00234E": "Hon Hai Precision Ind. Co.",
    "2C8158": "Hon Hai Precision Ind. Co.",
    "3CA82A": "Hewlett Packard",
    "2C233A": "Hewlett Packard",
    "000A57": "Hewlett Packard",
    "0001E7": "Hewlett Packard",
    "0001E6": "Hewlett Packard",
    "00306E": "Hewlett Packard",
    "001560": "Hewlett Packard",
    "001635": "Hewlett Packard",
    "0008C7": "Hewlett Packard",
    "0010E3": "Hewlett Packard",
    "000883": "Hewlett Packard",
    "8CDCD4": "Hewlett Packard",
    "002376": "HTC Corporation",
    "38E7D8": "HTC Corporation",
    "188796": "HTC Corporation",
    "B4CEF6": "HTC Corporation",
    "3C4A92": "Hewlett Packard",
    "D4C9EF": "Hewlett Packard",
    "FC15B4": "Hewlett Packard",
    "CC4463": "Apple",
    "6C72E7": "Apple",
    "741BB2": "Apple",
    "001D0F": "TP-LINK TECHNOLOGIES CO.",
    "0023CD": "TP-LINK TECHNOLOGIES CO.",
    "D85D4C": "TP-LINK TECHNOLOGIES CO.",
    "A0F3C1": "TP-LINK TECHNOLOGIES CO.",
    "50FA84": "TP-LINK TECHNOLOGIES CO.",
    "44B32D": "TP-LINK TECHNOLOGIES CO.",
    "882593": "TP-LINK TECHNOLOGIES CO.",
    "001FE1": "Hon Hai Precision Ind. Co.",
    "4CAC0A": "zte corporation",
    "B4B362": "zte corporation",
    "B075D5": "zte corporation",
    "D0154A": "zte corporation",
    "0026ED": "zte corporation",
    "002293": "zte corporation",
    "006057": "Murata Manufacturing Co.",
    "783E53": "SKY UK LIMITED",
    "0019FB": "SKY UK LIMITED",
    "C4F57C": "Brocade Communications Systems LLC",
    "0012F2": "Brocade Communications Systems LLC",
    "00051E": "Brocade Communications Systems LLC",
    "384608": "zte corporation",
    "6CE873": "TP-LINK TECHNOLOGIES CO.",
    "C46E1F": "TP-LINK TECHNOLOGIES CO.",
    "083E8E": "Hon Hai Precision Ind. Co.",
    "10A5D0": "Murata Manufacturing Co.",
    "90489A": "Hon Hai Precision Ind. Co.",
    "0071CC": "Hon Hai Precision Ind. Co.",
    "B05B67": "HUAWEI TECHNOLOGIES CO.",
    "CCA223": "HUAWEI TECHNOLOGIES CO.",
    "786A89": "HUAWEI TECHNOLOGIES CO.",
    "50A72B": "HUAWEI TECHNOLOGIES CO.",
    "0CD6BD": "HUAWEI TECHNOLOGIES CO.",
    "00F81C": "HUAWEI TECHNOLOGIES CO.",
    "087A4C": "HUAWEI TECHNOLOGIES CO.",
    "ACE215": "HUAWEI TECHNOLOGIES CO.",
    "00040D": "Avaya Inc",
    "70A8E3": "HUAWEI TECHNOLOGIES CO.",
    "F8E811": "HUAWEI TECHNOLOGIES CO.",
    "200BC7": "HUAWEI TECHNOLOGIES CO.",
    "346BD3": "HUAWEI TECHNOLOGIES CO.",
    "70723C": "HUAWEI TECHNOLOGIES CO.",
    "ACE87B": "HUAWEI TECHNOLOGIES CO.",
    "F83DFF": "HUAWEI TECHNOLOGIES CO.",
    "285FDB": "HUAWEI TECHNOLOGIES CO.",
    "404D8E": "HUAWEI TECHNOLOGIES CO.",
    "4C5499": "HUAWEI TECHNOLOGIES CO.",
    "84DBAC": "HUAWEI TECHNOLOGIES CO.",
    "94772B": "HUAWEI TECHNOLOGIES CO.",
    "D440F0": "HUAWEI TECHNOLOGIES CO.",
    "04021F": "HUAWEI TECHNOLOGIES CO.",
    "14B968": "HUAWEI TECHNOLOGIES CO.",
    "5CF96A": "HUAWEI TECHNOLOGIES CO.",
    "F49FF3": "HUAWEI TECHNOLOGIES CO.",
    "240995": "HUAWEI TECHNOLOGIES CO.",
    "048A15": "Avaya Inc",
    "B4B017": "Avaya Inc",
    "90FB5B": "Avaya Inc",
    "C8F406": "Avaya Inc",
    "7052C5": "Avaya Inc",
    "F81547": "Avaya Inc",
    "506184": "Avaya Inc",
    "10CDAE": "Avaya Inc",
    "00605C": "Cisco Systems",
    "0006C1": "Cisco Systems",
    "00E014": "Cisco Systems",
    "20A783": "miControl GmbH",
    "0050BD": "Cisco Systems",
    "00906F": "Cisco Systems",
    "F84ABF": "HUAWEI TECHNOLOGIES CO.",
    "78D752": "HUAWEI TECHNOLOGIES CO.",
    "104780": "HUAWEI TECHNOLOGIES CO.",
    "548998": "HUAWEI TECHNOLOGIES CO.",
    "30D17E": "HUAWEI TECHNOLOGIES CO.",
    "F8A45F": "Xiaomi Communications Co Ltd",
    "640980": "Xiaomi Communications Co Ltd",
    "185936": "Xiaomi Communications Co Ltd",
    "60735C": "Cisco Systems",
    "34A84E": "Cisco Systems",
    "54781A": "Cisco Systems",
    "94049C": "HUAWEI TECHNOLOGIES CO.",
    "688F84": "HUAWEI TECHNOLOGIES CO.",
    "005014": "Cisco Systems",
    "0090F2": "Cisco Systems",
    "544A16": "Texas Instruments",
    "74D6EA": "Texas Instruments",
    "209148": "Texas Instruments",
    "0050F0": "Cisco Systems",
    "381C1A": "Cisco Systems",
    "BC671C": "Cisco Systems",
    "346288": "Cisco Systems",
    "CCD8C1": "Cisco Systems",
    "7C0ECE": "Cisco Systems",
    "001731": "ASUSTek COMPUTER INC.",
    "002215": "ASUSTek COMPUTER INC.",
    "E0CB4E": "ASUSTek COMPUTER INC.",
    "E02F6D": "Cisco Systems",
    "58971E": "Cisco Systems",
    "B4E9B0": "Cisco Systems",
    "000832": "Cisco Systems",
    "3085A9": "ASUSTek COMPUTER INC.",
    "B83861": "Cisco Systems",
    "189C5D": "Cisco Systems",
    "5CA48A": "Cisco Systems",
    "1C1D86": "Cisco Systems",
    "580A20": "Cisco Systems",
    "2C3ECF": "Cisco Systems",
    "508789": "Cisco Systems",
    "DCA5F4": "Cisco Systems",
    "5017FF": "Cisco Systems",
    "A0ECF9": "Cisco Systems",
    "547C69": "Cisco Systems",
    "70105C": "Cisco Systems",
    "10F311": "Cisco Systems",
    "382056": "Cisco Systems",
    "DCCEC1": "Cisco Systems",
    "9C57AD": "Cisco Systems",
    "0CE0E4": "PLANTRONICS",
    "74A2E6": "Cisco Systems",
    "BCF1F2": "Cisco Systems",
    "C80084": "Cisco Systems",
    "40A6E8": "Cisco Systems",
    "B05947": "Shenzhen Qihu Intelligent Technology Company Limited",
    "60FEC5": "Apple",
    "E425E7": "Apple",
    "BC926B": "Apple",
    "101C0C": "Apple",
    "080007": "Apple",
    "004096": "Cisco Systems",
    "E86549": "Cisco Systems",
    "B07D47": "Cisco Systems",
    "38ED18": "Cisco Systems",
    "0016CB": "Apple",
    "0017F2": "Apple",
    "001F5B": "Apple",
    "002436": "Apple",
    "00254B": "Apple",
    "001947": "Cisco SPVTG",
    "001839": "Cisco-Linksys",
    "A8FAD8": "Apple",
    "008865": "Apple",
    "BC3BAF": "Apple",
    "3CE072": "Apple",
    "38484C": "Apple",
    "804971": "Apple",
    "6C3E6D": "Apple",
    "BC6778": "Apple",
    "20C9D0": "Apple",
    "68967B": "Apple",
    "7C6D62": "Apple",
    "40D32D": "Apple",
    "C42C03": "Apple",
    "9027E4": "Apple",
    "84FCFE": "Apple",
    "E48B7F": "Apple",
    "D8D1CB": "Apple",
    "B817C2": "Apple",
    "7C11BE": "Apple",
    "98D6BB": "Apple",
    "A46706": "Apple",
    "8C5877": "Apple",
    "7CF05F": "Apple",
    "109ADD": "Apple",
    "581FAA": "Apple",
    "88C663": "Apple",
    "283737": "Apple",
    "50EAD6": "Apple",
    "189EFC": "Apple",
    "ACCF5C": "Apple",
    "80006E": "Apple",
    "848E0C": "Apple",
    "3C15C2": "Apple",
    "6C709F": "Apple",
    "6476BA": "Apple",
    "34E2FD": "Apple",
    "04489A": "Apple",
    "90FD61": "Apple",
    "2CF0EE": "Apple",
    "5C97F3": "Apple",
    "D4F46F": "Apple",
    "5CF5DA": "Apple",
    "18EE69": "Apple",
    "649ABE": "Apple",
    "F099BF": "Apple",
    "48437C": "Apple",
    "34A395": "Apple",
    "787E61": "Apple",
    "60F81D": "Apple",
    "C0F2FB": "Apple",
    "24E314": "Apple",
    "80E650": "Apple",
    "A4C361": "Apple",
    "B09FBA": "Apple",
    "0C4DE9": "Apple",
    "E0F5C6": "Apple",
    "A0EDCD": "Apple",
    "F0F61C": "Apple",
    "8C2937": "Apple",
    "087045": "Apple",
    "A88808": "Apple",
    "D03311": "Apple",
    "F0F249": "Hitron Technologies. Inc",
    "94E96A": "Apple",
    "AC293A": "Apple",
    "9CFC01": "Apple",
    "9C35EB": "Apple",
    "507A55": "Apple",
    "38C986": "Apple",
    "C8C2C6": "Shanghai Airm2m Communication Technology Co.",
    "DCFE07": "PEGATRON CORPORATION",
    "707938": "Wuxi Zhanrui Electronic Technology Co.",
    "789C85": "August Home",
    "5882A8": "Microsoft",
    "58685D": "Tempo Australia Pty Ltd",
    "B813E9": "Trace Live Network",
    "80B709": "Viptela",
    "F00D5C": "JinQianMao  Technology Co.",
    "54BE53": "zte corporation",
    "30E090": "Genevisio Ltd.",
    "C49E41": "G24 Power Limited",
    "D03E5C": "HUAWEI TECHNOLOGIES CO.",
    "E03676": "HUAWEI TECHNOLOGIES CO.",
    "EC388F": "HUAWEI TECHNOLOGIES CO.",
    "243184": "SHARP Corporation",
    "582BDB": "Pax AB",
    "24DA9B": "Motorola Mobility LLC",
    "280E8B": "Beijing Spirit Technology Development Co.",
    "F44D30": "Elitegroup Computer Systems Co.",
    "A4DCBE": "HUAWEI TECHNOLOGIES CO.",
    "ECB870": "Beijing Heweinet Technology Co.",
    "B078F0": "Beijing HuaqinWorld Technology Co.",
    "38D40B": "Samsung Electronics Co.",
    "E83A12": "Samsung Electronics Co.",
    "94BBAE": "Husqvarna AB",
    "D494E8": "HUAWEI TECHNOLOGIES CO.",
    "80656D": "Samsung Electronics Co.",
    "209BCD": "Apple",
    "3095E3": "SHANGHAI SIMCOM LIMITED",
    "FCF136": "Samsung Electronics Co.",
    "B88687": "Liteon Technology Corporation",
    "18895B": "Samsung Electronics Co.",
    "584925": "E3 Enterprise",
    "94F278": "Elma Electronic",
    "3C5CC3": "Shenzhen First Blue Chip Technology Ltd",
    "ECEED8": "ZTLX Network Technology Co.",
    "80EB77": "Wistron Corporation",
    "4CC681": "Shenzhen Aisat Electronic Co.",
    "0894EF": "Wistron Infocomm (Zhongshan) Corporation",
    "283713": "Shenzhen 3Nod Digital Technology Co.",
    "E0319E": "Valve Corporation",
    "483974": "Proware Technologies Co.",
    "30FFF6": "HangZhou KuoHeng Technology Co.",
    "7CAB25": "MESMO TECHNOLOGY INC.",
    "C49FF3": "Mciao Technologies",
    "788E33": "Jiangsu SEUIC Technology Co.",
    "7CA237": "King Slide Technology CO.",
    "584822": "Sony Corporation",
    "D8EFCD": "Nokia Solutions and Networks GmbH & Co. KG",
    "48E244": "Hon Hai Precision Ind. Co.",
    "747336": "MICRODIGTAL Inc",
    "B0411D": "ITTIM Technologies",
    "A47B2C": "Nokia",
    "DCDB70": "Tonfunk Systementwicklung und Service GmbH",
    "800B51": "Chengdu XGimi Technology Co.",
    "A0A65C": "Supercomputing Systems AG",
    "884157": "Shenzhen Atsmart Technology Co.",
    "3481F4": "SST Taiwan Ltd.",
    "F80D60": "CANON INC.",
    "F8BF09": "HUAWEI TECHNOLOGIES CO.",
    "7CB25C": "Acacia Communications",
    "F0182B": "LG Chem",
    "382B78": "ECO PLUGS ENTERPRISE CO.",
    "00A784": "ITX security",
    "E8377A": "Zyxel Communications Corporation",
    "D89A34": "Beijing SHENQI Technology Co.",
    "C4EA1D": "Technicolor Delivery Technologies Belgium NV",
    "7CF90E": "Samsung Electronics Co.",
    "50F0D3": "Samsung Electronics Co.",
    "803B2A": "ABB Xiamen Low Voltage Equipment Co.",
    "3CCE15": "Mercedes-Benz USA",
    "38FACA": "Skyworth Digital Technology(Shenzhen) Co.",
    "149A10": "Microsoft Corporation",
    "5CB43E": "HUAWEI TECHNOLOGIES CO.",
    "54E140": "INGENICO",
    "E4907E": "Motorola Mobility LLC",
    "24E5AA": "Philips Oral Healthcare",
    "78BDBC": "Samsung Electronics Co.",
    "349B5B": "Maquet GmbH",
    "84119E": "Samsung Electronics Co.",
    "746A3A": "Aperi Corporation",
    "94A7B7": "zte corporation",
    "1844E6": "zte corporation",
    "485073": "Microsoft Corporation",
    "707781": "Hon Hai Precision Ind. Co.",
    "287610": "IgniteNet",
    "1C8341": "Hefei Bitland Information Technology Co.Ltd",
    "706879": "Saijo Denki International Co.",
    "081FEB": "BinCube",
    "785F4C": "Argox Information Co.",
    "6C1E70": "Guangzhou YBDS IT Co.",
    "20D75A": "Posh Mobile Limited",
    "F41563": "F5 Networks",
    "8C8B83": "Texas Instruments",
    "4011DC": "Sonance",
    "10AF78": "Shenzhen ATUE Technology Co.",
    "D8ADDD": "Sonavation",
    "8833BE": "Ivenix",
    "54B80A": "D-Link International",
    "34CC28": "Nexpring Co. LTD.",
    "249EAB": "HUAWEI TECHNOLOGIES CO.",
    "E48D8C": "Routerboard.com",
    "CC19A8": "PT Inovação e Sistemas SA",
    "6CA75F": "zte corporation",
    "8C7967": "zte corporation",
    "B4B265": "DAEHO I&T",
    "CCA4AF": "Shenzhen Sowell Technology Co.",
    "E03560": "Challenger Supply Holdings",
    "3CCB7C": "TCT mobile ltd",
    "E4CE70": "Health & Life co.",
    "244B03": "Samsung Electronics Co.",
    "0071C2": "PEGATRON CORPORATION",
    "74E28C": "Microsoft Corporation",
    "7C8274": "Shenzhen Hikeen Technology CO.",
    "94D417": "GPI KOREA INC.",
    "F07959": "ASUSTek COMPUTER INC.",
    "704E66": "SHENZHEN FAST TECHNOLOGIES CO.",
    "244B81": "Samsung Electronics Co.",
    "D855A3": "zte corporation",
    "38D82F": "zte corporation",
    "7858F3": "Vachen Co.",
    "102C83": "XIMEA",
    "709C8F": "Nero AG",
    "2884FA": "SHARP Corporation",
    "300EE3": "Aquantia Corporation",
    "60D9A0": "Lenovo Mobile Communication Technology Ltd.",
    "844BB7": "Beijing Sankuai Online Technology Co.",
    "68F0BC": "Shenzhen LiWiFi Technology Co.",
    "60AF6D": "Samsung Electronics Co.",
    "B85A73": "Samsung Electronics Co.",
    "3C1E04": "D-Link International",
    "18F145": "NetComm Wireless Limited",
    "E08E3C": "Aztech Electronics Pte Ltd",
    "68B983": "b-plus GmbH",
    "50ADD5": "Dynalec Corporation",
    "B04519": "TCT mobile ltd",
    "78B3B9": "ShangHai sunup lighting CO.",
    "04C09C": "Tellabs Inc.",
    "ACABBF": "AthenTek Inc.",
    "981DFA": "Samsung Electronics Co.",
    "186882": "Beward R&D Co.",
    "7429AF": "Hon Hai Precision Ind. Co.",
    "40EACE": "FOUNDER BROADBAND NETWORK SERVICE CO.",
    "848EDF": "Sony Corporation",
    "3C1A0F": "ClearSky Data",
    "D88D5C": "Elentec",
    "EC8009": "NovaSparks",
    "E8CC18": "D-Link International",
    "B09137": "ISis ImageStream Internet Solutions",
    "948E89": "INDUSTRIAS UNIDAS SA DE CV",
    "2497ED": "Techvision Intelligent Technology Limited",
    "A49D49": "Ketra",
    "8C0551": "Koubachi AG",
    "D897BA": "PEGATRON CORPORATION",
    "A8D88A": "Wyconn",
    "2C5089": "Shenzhen Kaixuan Visual Technology Co.",
    "207693": "Lenovo (Beijing) Limited.",
    "600417": "POSBANK CO.",
    "C03896": "Hon Hai Precision Ind. Co.",
    "084656": "VEO-LABS",
    "EC3C5A": "SHEN ZHEN HENG SHENG HUI DIGITAL TECHNOLOGY CO.",
    "4488CB": "Camco Technologies NV",
    "50294D": "NANJING IOT SENSOR TECHNOLOGY CO",
    "0CCFD1": "SPRINGWAVE Co.",
    "1C7E51": "3bumen.com",
    "6872DC": "CETORY.TV Company Limited",
    "00AEFA": "Murata Manufacturing Co.",
    "74BADB": "Longconn Electornics(shenzhen)Co.",
    "F82441": "Yeelink",
    "108A1B": "RAONIX Inc.",
    "B8F317": "iSun Smasher Communications Private Limited",
    "8CF813": "ORANGE POLSKA",
    "6CBFB5": "Noon Technology Co.",
    "841826": "Osram GmbH",
    "F8E903": "D-Link International",
    "E89606": "testo Instruments (Shenzhen) Co.",
    "3077CB": "Maike Industry(Shenzhen)CO.",
    "909F33": "EFM Networks",
    "68F06D": "ALONG INDUSTRIAL CO.",
    "945493": "Rigado",
    "F42853": "Zioncom Electronics (Shenzhen) Ltd.",
    "1C9C26": "Zoovel Technologies",
    "D4EC86": "LinkedHope Intelligent Technologies Co.",
    "046785": "scemtec Hard- und Software fuer Mess- und Steuerungstechnik GmbH",
    "D0FA1D": "Qihoo  360  Technology Co.",
    "8432EA": "ANHUI WANZTEN P&T CO.",
    "E01D38": "Beijing HuaqinWorld Technology Co.",
    "E47FB2": "FUJITSU LIMITED",
    "FC9FE1": "CONWIN.Tech. Ltd",
    "A81B5D": "Foxtel Management Pty Ltd",
    "AC11D3": "Suzhou HOTEK  Video Technology Co. Ltd",
    "FC6DC0": "BME CORPORATION",
    "24D13F": "MEXUS CO.",
    "505065": "TAKT Corporation",
    "40C62A": "Shanghai Jing Ren Electronic Technology Co.",
    "E8150E": "Nokia Corporation",
    "B89BE4": "ABB Power Systems Power Generation",
    "7824AF": "ASUSTek COMPUTER INC.",
    "102F6B": "Microsoft Corporation",
    "0CAC05": "Unitend Technologies Inc.",
    "80AD67": "Kasda Networks Inc",
    "30B5F1": "Aitexin Technology Co.",
    "B01041": "Hon Hai Precision Ind. Co.",
    "3CAA3F": "iKey",
    "0C383E": "Fanvil Technology Co.",
    "60CDA9": "Abloomy",
    "B8AD3E": "BLUECOM",
    "183009": "Woojin Industrial Systems Co.",
    "74DBD1": "Ebay Inc",
    "DC537C": "Compal Broadband Networks",
    "44A6E5": "THINKING TECHNOLOGY CO.",
    "90DA6A": "FOCUS H&S Co.",
    "4C6E6E": "Comnect Technology CO.",
    "8C3357": "HiteVision Digital Media Technology Co.",
    "C44202": "Samsung Electronics Co.",
    "B4AE6F": "Circle Reliance",
    "A45DA1": "ADB Broadband Italia",
    "4C3909": "HPL Electric & Power Private Limited",
    "907EBA": "UTEK TECHNOLOGY (SHENZHEN) CO.",
    "A002DC": "Amazon Technologies Inc.",
    "84948C": "Hitron Technologies. Inc",
    "A8F7E0": "PLANET Technology Corporation",
    "4486C1": "Siemens Low Voltage & Products",
    "4045DA": "Spreadtrum Communications (Shanghai) Co.",
    "542AA2": "Alpha Networks Inc.",
    "6C198F": "D-Link International",
    "C8FF77": "Dyson Limited",
    "B49EAC": "Imagik Int'l Corp",
    "E0CBEE": "Samsung Electronics Co.",
    "103047": "Samsung Electronics Co.",
    "5C2E59": "Samsung Electronics Co.",
    "F884F2": "Samsung Electronics Co.",
    "B0754D": "Nokia",
    "54B753": "Hunan Fenghui Yinjia Science And Technology Co.",
    "3451AA": "JID GLOBAL",
    "98BE94": "IBM",
    "C46BB4": "myIDkey",
    "CC07E4": "Lenovo Mobile Communication Technology Ltd.",
    "0874F6": "Winterhalter Gastronom GmbH",
    "0C63FC": "Nanjing Signway Technology Co.",
    "D4E08E": "ValueHD Corporation",
    "C89F1D": "SHENZHEN COMMUNICATION TECHNOLOGIES CO.",
    "143DF2": "Beijing Shidai Hongyuan Network Communication Co.",
    "2C39C1": "Ciena Corporation",
    "54EE75": "Wistron InfoComm(Kunshan)Co.",
    "ACB859": "Uniband Electronic Corp",
    "D8492F": "CANON INC.",
    "800E24": "ForgetBox",
    "18FF2E": "Shenzhen Rui Ying Da Technology Co.",
    "847207": "I&C Technology",
    "3C25D7": "Nokia Corporation",
    "30A8DB": "Sony Corporation",
    "20EAC7": "SHENZHEN RIOPINE ELECTRONICS CO.",
    "64B370": "PowerComm Solutions LLC",
    "5CF50D": "Institute of microelectronic applications",
    "749C52": "Huizhou Desay SV Automotive Co.",
    "10DEE4": "automationNEXT GmbH",
    "F03A4B": "Bloombase",
    "0C4F5A": "ASA-RT s.r.l.",
    "CCA614": "AIFA TECHNOLOGY CORP.",
    "90F1B0": "Hangzhou Anheng Info&Tech CO.",
    "90DB46": "E-LEAD ELECTRONIC CO.",
    "54D163": "MAX-TECH",
    "48B5A7": "Glory Horse Industries Ltd.",
    "7CE4AA": "Private",
    "083F3E": "WSH GmbH",
    "1820A6": "Sage Co.",
    "4C8B30": "Actiontec Electronics",
    "0805CD": "DongGuang EnMai Electronic Product Co.Ltd.",
    "2C073C": "DEVLINE LIMITED",
    "7C1A03": "8Locations Co.",
    "344F5C": "R&amp;M AG",
    "D4224E": "Alcatel Lucent",
    "9C86DA": "Phoenix Geophysics Ltd.",
    "6047D4": "FORICS Electronic Technology Co.",
    "FCF8B7": "TRONTEQ Electronic",
    "30F42F": "ESP",
    "704E01": "KWANGWON TECH CO.",
    "746A8F": "VS Vision Systems GmbH",
    "54A31B": "Shenzhen Linkworld Technology Co",
    "CC398C": "Shiningtek",
    "6C5F1C": "Lenovo Mobile Communication Technology Ltd.",
    "C0C569": "SHANGHAI LYNUC CNC TECHNOLOGY CO.",
    "C4C0AE": "MIDORI ELECTRONIC CO.",
    "ACC595": "Graphite Systems",
    "7CE1FF": "Computer Performance",
    "D8150D": "TP-LINK TECHNOLOGIES CO.",
    "5850AB": "TLS Corporation",
    "CC856C": "SHENZHEN MDK DIGITAL TECHNOLOGY CO.",
    "D8EE78": "Moog Protokraft",
    "483D32": "Syscor Controls &amp; Automation",
    "A0E453": "Sony Corporation",
    "404A18": "Addrek Smart Solutions",
    "C4291D": "KLEMSAN ELEKTRIK ELEKTRONIK SAN.VE TIC.AS.",
    "241148": "Entropix",
    "4CD7B6": "Helmer Scientific",
    "8425A4": "Tariox Limited",
    "2C957F": "zte corporation",
    "3C0C48": "Servergy",
    "C445EC": "Shanghai Yali Electron Co.",
    "E0E631": "SNB TECHNOLOGIES LIMITED",
    "F8572E": "Core Brands",
    "78B5D2": "Ever Treasure Industrial Limited",
    "1CC11A": "Wavetronix",
    "90028A": "Shenzhen Shidean Legrand Electronic Products Co.",
    "CC7498": "Filmetrics Inc.",
    "BCEE7B": "ASUSTek COMPUTER INC.",
    "3413A8": "Mediplan Limited",
    "FC09D8": "ACTEON Group",
    "743ECB": "Gentrice tech",
    "98FF6A": "OTEC(Shanghai)Technology Co.",
    "7CCD11": "MS-Magnet",
    "BC1A67": "YF Technology Co.",
    "AC6BAC": "Jenny Science AG",
    "7C9763": "Openmatics s.r.o.",
    "48A2B7": "Kodofon JSC",
    "0444A1": "TELECON GALICIA",
    "20C60D": "Shanghai annijie Information technology Co.",
    "E0C86A": "SHENZHEN TW-SCIE Co.",
    "1879A2": "GMJ ELECTRIC LIMITED",
    "38CA97": "Contour Design LLC",
    "BC2D98": "ThinGlobal LLC",
    "50ED78": "Changzhou Yongse Infotech Co.",
    "085AE0": "Recovision Technology Co.",
    "7C444C": "Entertainment Solutions",
    "9CD643": "D-Link International",
    "3C18A0": "Luxshare Precision Industry Company Limited",
    "94E98C": "Nokia",
    "8CAE89": "Y-cam Solutions Ltd",
    "FCE1D9": "Stable Imaging Solutions LLC",
    "B04545": "YACOUB Automation GmbH",
    "C8EE75": "Pishion International Co. Ltd",
    "CC3429": "TP-LINK TECHNOLOGIES CO.",
    "94C3E4": "Atlas Copco IAS GmbH",
    "20E791": "Siemens Healthcare Diagnostics",
    "089758": "Shenzhen Strong Rising Electronics Co.",
    "FC19D0": "Cloud Vision Networks Technology Co.",
    "9486D4": "Surveillance Pro Corporation",
    "2847AA": "Nokia Corporation",
    "5CD61F": "Qardio",
    "682DDC": "Wuhan Changjiang Electro-Communication Equipment CO.",
    "64BABD": "SDJ Technologies",
    "24C848": "mywerk Portal GmbH",
    "B424E7": "Codetek Technology Co.",
    "542F89": "Euclid Laboratories",
    "7CBF88": "Mobilicom LTD",
    "60DB2A": "HNS",
    "CCFB65": "Nintendo Co.",
    "A0A23C": "GPMS",
    "68FCB3": "Next Level Security Systems",
    "9C443D": "CHENGDU XUGUANG TECHNOLOGY CO",
    "FCD817": "Beijing Hesun Technologies Co.Ltd.",
    "34885D": "Logitech Far East",
    "88576D": "XTA Electronics Ltd",
    "BC4100": "CODACO ELECTRONIC s.r.o.",
    "E8611F": "Dawning Information Industry Co.",
    "705957": "Medallion Instrumentation Systems",
    "60A9B0": "Merchandising Technologies",
    "5027C7": "TECHNART Co.",
    "6C5AB5": "TCL Technoly Electronics (Huizhou) Co.",
    "B43E3B": "Viableware",
    "34A3BF": "Terewave. Inc.",
    "8C088B": "Remote Solution",
    "EC3E09": "PERFORMANCE DESIGNED PRODUCTS",
    "0C5CD8": "DOLI Elektronik GmbH",
    "3C15EA": "TESCOM CO.",
    "E80410": "Private",
    "909916": "ELVEES NeoTek OJSC",
    "A0143D": "PARROT SA",
    "FC1BFF": "V-ZUG AG",
    "00A2FF": "abatec group AG",
    "6024C1": "Jiangsu Zhongxun Electronic Technology Co.",
    "DCC422": "Systembase Limited",
    "C8F36B": "Yamato Scale Co.",
    "6CD1B0": "WING SING ELECTRONICS HONG KONG LIMITED",
    "98F8C1": "IDT Technology Limited",
    "A4F522": "CHOFU SEISAKUSHO CO.",
    "845C93": "Chabrier Services",
    "F4BD7C": "Chengdu jinshi communication Co.",
    "68E166": "Private",
    "60FEF9": "Thomas & Betts",
    "B8DC87": "IAI Corporation",
    "7C6FF8": "ShenZhen ACTO Digital Video Technology Co.",
    "DCF755": "SITRONIK",
    "BC2BD7": "Revogi Innovation Co.",
    "286D97": "SAMJIN Co.",
    "947C3E": "Polewall Norge AS",
    "385AA8": "Beijing Zhongdun Security Technology Development Co.",
    "F4A294": "EAGLE WORLD DEVELOPMENT CO.",
    "F42896": "SPECTO PAINEIS ELETRONICOS LTDA",
    "78CB33": "DHC Software Co.",
    "24ECD6": "CSG Science & Technology Co.",
    "1C48F9": "GN Netcom A/S",
    "9C4EBF": "BoxCast",
    "34A843": "KYOCERA Display Corporation",
    "80BBEB": "Satmap Systems Ltd",
    "00B78D": "Nanjing Shining Electric Automation Co.",
    "A05B21": "ENVINET GmbH",
    "5C026A": "Applied Vision Corporation",
    "0C9301": "PT. Prasimax Inovasi Teknologi",
    "746630": "T:mi Ytti",
    "6CB350": "Anhui comhigher tech co.",
    "3859F8": "MindMade Sp. z o.o.",
    "E89218": "Arcontia International AB",
    "0075E1": "Ampt",
    "D46A91": "SnapAV",
    "B0793C": "Revolv Inc",
    "4CDF3D": "TEAM ENGINEERS ADVANCE TECHNOLOGIES INDIA PVT LTD",
    "98CDB4": "Virident Systems",
    "A42305": "Open Networking Laboratory",
    "CC2A80": "Micro-Biz intelligence solutions Co.",
    "34CD6D": "CommSky Technologies",
    "B0FEBD": "Private",
    "60699B": "isepos GmbH",
    "D4D50D": "Southwest Microwave",
    "E438F2": "Advantage Controls",
    "C4C755": "Beijing HuaqinWorld Technology Co.",
    "0C2D89": "QiiQ Communications Inc.",
    "A8D236": "Lightware Visual Engineering",
    "4C55B8": "Turkcell Teknoloji",
    "788DF7": "Hitron Technologies. Inc",
    "945047": "Rechnerbetriebsgruppe",
    "E031D0": "SZ Telstar CO.",
    "54112F": "Sulzer Pump Solutions Finland Oy",
    "088039": "Cisco SPVTG",
    "981094": "Shenzhen Vsun communication technology Co.",
    "A4F3C1": "Open Source Robotics Foundation",
    "141330": "Anakreon UK LLP",
    "74CA25": "Calxeda",
    "B4346C": "MATSUNICHI DIGITAL TECHNOLOGY (HONG KONG) LIMITED",
    "9046B7": "Vadaro Pte Ltd",
    "04CF25": "MANYCOLORS",
    "B050BC": "SHENZHEN BASICOM ELECTRONIC CO.",
    "841E26": "KERNEL-I Co.",
    "DC7014": "Private",
    "50B8A2": "ImTech Technologies LLC",
    "0086A0": "Private",
    "60FE1E": "China Palms Telecom.Ltd",
    "04BFA8": "ISB Corporation",
    "8CC7D0": "zhejiang ebang communication co.",
    "B8AE6E": "Nintendo Co.",
    "D0EB03": "Zhehua technology limited",
    "683EEC": "ERECA",
    "0C2AE7": "Beijing General Research Institute of Mining and Metallurgy",
    "983071": "DAIKYUNG VASCOM",
    "D49524": "Clover Network",
    "0C0400": "Jantar d.o.o.",
    "687CD5": "Y Soft Corporation",
    "C04DF7": "SERELEC",
    "50A715": "Aboundi",
    "C42628": "Airo Wireless",
    "30AABD": "Shanghai Reallytek Information Technology Co.",
    "A4B818": "PENTA Gesellschaft für elektronische Industriedatenverarbeitung mbH",
    "0C8484": "Zenovia Electronics Inc.",
    "005907": "LenovoEMC Products USA",
    "A861AA": "Cloudview Limited",
    "0CF405": "Beijing Signalway Technologies Co.",
    "5061D6": "Indu-Sol GmbH",
    "FC1186": "Logic3 plc",
    "C8B373": "Cisco-Linksys",
    "2C245F": "Babolat VS",
    "905692": "Autotalks Ltd.",
    "C8EEA6": "Shenzhen SHX Technology Co.",
    "2481AA": "KSH International Co.",
    "E01877": "FUJITSU LIMITED",
    "E457A8": "Stuart Manufacturing",
    "4CCC34": "Motorola Solutions Inc.",
    "D0D471": "MVTECH co.",
    "0868D0": "Japan System Design",
    "D4223F": "Lenovo Mobile Communication Technology Ltd.",
    "E8E875": "iS5 Communications Inc.",
    "C80E95": "OmniLync Inc.",
    "104D77": "Innovative Computer Engineering",
    "5CE0CA": "FeiTian United (Beijing) System Technology Co.",
    "E08177": "GreenBytes",
    "9C9811": "Guangzhou Sunrise Electronics Development Co.",
    "B86091": "Onnet Technologies and Innovations LLC",
    "301518": "Ubiquitous Communication Co. ltd.",
    "6897E8": "Society of Motion Picture &amp; Television Engineers",
    "7CA15D": "GN ReSound A/S",
    "3C081E": "Beijing Yupont Electric Power Technology Co.",
    "FC58FA": "Shen Zhen Shi Xin Zhong Xin Technology Co.",
    "60BB0C": "Beijing HuaqinWorld Technology Co",
    "10B9FE": "Lika srl",
    "A42C08": "Masterwork Automodules",
    "8C078C": "FLOW DATA INC",
    "F8DFA8": "zte corporation",
    "A895B0": "Aker Subsea Ltd",
    "789966": "Musilab Electronics (DongGuan)Co.",
    "28CBEB": "One",
    "B8C46F": "PRIMMCON INDUSTRIES INC",
    "D8B02E": "Guangzhou Zonerich Business Machine Co.",
    "907AF1": "Wally",
    "2CB693": "Radware",
    "AC4122": "Eclipse Electronic Systems Inc.",
    "30055C": "Brother industries",
    "080EA8": "Velex s.r.l.",
    "C4E032": "IEEE 1904.1 Working Group",
    "841715": "GP Electronics (HK) Ltd.",
    "58EB14": "Proteus Digital Health",
    "C458C2": "Shenzhen TATFOOK Technology Co.",
    "D0CDE1": "Scientech Electronics",
    "8C76C1": "Goden Tech Limited",
    "08F1B7": "Towerstream Corpration",
    "C044E3": "Shenzhen Sinkna Electronics Co.",
    "18550F": "Cisco SPVTG",
    "187A93": "AMICCOM Electronics Corporation",
    "DCA989": "MACANDC",
    "A00363": "Robert Bosch Healthcare GmbH",
    "C45DD8": "HDMI Forum",
    "C4EBE3": "RRCN SAS",
    "94756E": "QinetiQ North America",
    "4C1A95": "Novakon Co.",
    "6499A0": "AG Elektronik AB",
    "848E96": "Embertec Pty Ltd",
    "7C438F": "E-Band Communications Corp.",
    "449B78": "The Now Factory",
    "F0F669": "Motion Analysis Corporation",
    "F8F082": "NAGTECH LLC",
    "5C89D4": "Beijing Banner Electric Co.",
    "182A7B": "Nintendo Co.",
    "68FB95": "Generalplus Technology Inc.",
    "D40FB2": "Applied Micro Electronics AME bv",
    "D0B498": "Robert Bosch LLC Automotive Electronics",
    "E05597": "Emergent Vision Technologies Inc.",
    "8887DD": "DarbeeVision Inc.",
    "30C82A": "WI-BIZ srl",
    "88A3CC": "Amatis Controls",
    "C0A0C7": "FAIRFIELD INDUSTRIES",
    "A0E25A": "Amicus SK",
    "849DC5": "Centera Photonics Inc.",
    "580943": "Private",
    "242FFA": "Toshiba Global Commerce Solutions",
    "E496AE": "ALTOGRAPHICS Inc.",
    "4C2258": "cozybit",
    "ECFC55": "A. Eberle GmbH & Co. KG",
    "78995C": "Nationz Technologies Inc",
    "54115F": "Atamo Pty Ltd",
    "8CAE4C": "Plugable Technologies",
    "6851B7": "PowerCloud Systems",
    "1C959F": "Veethree Electronics And Marine LLC",
    "703811": "Siemens Mobility Limited",
    "CC4BFB": "Hellberg Safety AB",
    "F49466": "CountMax",
    "F45214": "Mellanox Technologies",
    "10F49A": "T3 Innovation",
    "3C57BD": "Kessler Crane Inc.",
    "04E9E5": "PJRC.COM",
    "60BD91": "Move Innovation",
    "34C803": "Nokia Corporation",
    "F05F5A": "Getriebebau NORD GmbH and Co. KG",
    "6CADEF": "KZ Broadband Technologies",
    "745FAE": "TSL PPL",
    "742D0A": "Norfolk Elektronik AG",
    "485A3F": "WISOL",
    "70F1E5": "Xetawave LLC",
    "C0AA68": "OSASI Technos Inc.",
    "88D7BC": "DEP Company",
    "0CC655": "Wuxi YSTen Technology Co.",
    "289EDF": "Danfoss Turbocor Compressors",
    "803FD6": "bytes at work AG",
    "CC262D": "Verifi",
    "3C8AE5": "Tensun Information Technology(Hangzhou) Co.",
    "7C0187": "Curtis Instruments",
    "54F666": "Berthold Technologies GmbH and Co.KG",
    "1C11E1": "Wartsila Finland Oy",
    "50465D": "ASUSTek COMPUTER INC.",
    "74BFA1": "HYUNTECK",
    "2C5AA3": "PROMATE ELECTRONIC CO.LTD",
    "34E0CF": "zte corporation",
    "F82285": "Cypress Technology CO.",
    "24EE3A": "Chengdu Yingji Electronic Hi-tech Co Ltd",
    "0CC66A": "Nokia Corporation",
    "74273C": "ChangYang Technology (Nanjing) Co.",
    "087CBE": "Quintic Corp.",
    "C4AD21": "MEDIAEDGE Corporation",
    "08B738": "Lite-On Technogy Corp.",
    "F8AA8A": "Axview Technology (Shenzhen) Co.",
    "B4009C": "CableWorld Ltd.",
    "0868EA": "EITO ELECTRONICS CO.",
    "E804F3": "Throughtek Co.",
    "842BBC": "Modelleisenbahn GmbH",
    "801DAA": "Avaya Inc",
    "7C092B": "Bekey A/S",
    "80AAA4": "USAG",
    "A40BED": "Carry Technology Co.",
    "702393": "fos4X GmbH",
    "F85F2A": "Nokia Corporation",
    "C438D3": "TAGATEC CO.",
    "E85BF0": "Imaging Diagnostics",
    "044A50": "Ramaxel Technology (Shenzhen) limited company",
    "38A5B6": "SHENZHEN MEGMEET ELECTRICAL CO.",
    "0CD9C1": "Visteon Corporation",
    "E0AAB0": "SUNTAILI ENTERPRISE CO. LTD",
    "AC14D2": "wi-daq",
    "68AB8A": "RF IDeas",
    "9C4CAE": "Mesa Labs",
    "085B0E": "Fortinet",
    "EC42F0": "ADL Embedded Solutions",
    "30AEF6": "Radio Mobile Access",
    "6CE4CE": "Villiger Security Solutions AG",
    "E8CBA1": "Nokia Corporation",
    "784405": "FUJITU(HONG KONG) ELECTRONIC Co.",
    "649FF7": "Kone OYj",
    "146A0B": "Cypress Electronics Limited",
    "F490EA": "Deciso B.V.",
    "5CEE79": "Global Digitech Co LTD",
    "80CEB1": "Theissen Training Systems GmbH",
    "FC2A54": "Connected Data",
    "782544": "Omnima Limited",
    "A41875": "Cisco Systems",
    "C8AE9C": "Shanghai TYD Elecronic Technology Co. Ltd",
    "080CC9": "Mission Technology Group",
    "C05E79": "SHENZHEN HUAXUN ARK TECHNOLOGIES CO.",
    "58BFEA": "Cisco Systems",
    "FC1D59": "I Smart Cities HK Ltd",
    "78C4AB": "Shenzhen Runsil Technology Co.",
    "C401B1": "SeekTech INC",
    "C0C946": "MITSUYA LABORATORIES INC.",
    "F4600D": "Panoptic Technology",
    "A82BD6": "Shina System Co.",
    "ACCF23": "Hi-flying electronics technology Co.",
    "CC912B": "TE Connectivity Touch Solutions",
    "609084": "DSSD Inc",
    "802AFA": "Germaneers GmbH",
    "18421D": "Private",
    "28C914": "Taimag Corporation",
    "20C1AF": "i Wit Digital Co.",
    "7493A4": "Zebra Technologies Corp.",
    "E47185": "Securifi Ltd",
    "D05785": "Pantech Co.",
    "408B07": "Actiontec Electronics",
    "045C06": "Zmodo Technology Corporation",
    "747B7A": "ETH Inc.",
    "48EA63": "Zhejiang Uniview Technologies Co.",
    "E88DF5": "ZNYX Networks",
    "6CAE8B": "IBM Corporation",
    "BC1401": "Hitron Technologies. Inc",
    "94CA0F": "Honeywell Analytics",
    "4016FA": "EKM Metering",
    "0C130B": "Uniqoteq Ltd.",
    "2C542D": "Cisco Systems",
    "AC3FA4": "TAIYO YUDEN CO.",
    "640E94": "Pluribus Networks",
    "0CB4EF": "Digience Co.",
    "40AC8D": "Data Management",
    "4CAA16": "AzureWave Technologies (Shanghai) Inc.",
    "AC40EA": "C&T Solution Inc.",
    "002AAF": "LARsys-Automation GmbH",
    "1CE165": "Marshal Corporation",
    "284121": "OptiSense Network",
    "38458C": "MyCloud Technology corporation",
    "10E4AF": "APR",
    "90F72F": "Phillips Machine & Welding Co.",
    "F4EA67": "Cisco Systems",
    "28BA18": "NextNav",
    "AC3D75": "HANGZHOU ZHIWAY TECHNOLOGIES CO.",
    "A090DE": "VEEDIMS",
    "002A6A": "Cisco Systems",
    "608C2B": "Hanson Technology",
    "642DB7": "SEUNGIL ELECTRONICS",
    "F436E1": "Abilis Systems SARL",
    "800A06": "COMTEC co.",
    "E80C75": "Syncbak",
    "04F021": "Compex Systems Pte Ltd",
    "342F6E": "Anywire corporation",
    "940070": "Nokia Corporation",
    "BC2C55": "Bear Flag Design",
    "0C7523": "BEIJING GEHUA CATV NETWORK CO.",
    "34BA9A": "Asiatelco Technologies Co.",
    "F0007F": "Janz - Contadores de Energia",
    "30B3A2": "Shenzhen Heguang Measurement & Control Technology Co.",
    "2818FD": "Aditya Infotech Ltd.",
    "D8B90E": "Triple Domain Vision Co.",
    "CCEED9": "VAHLE Automation GmbH",
    "B08E1A": "URadio Systems Co.",
    "D8E952": "KEOPSYS",
    "645299": "The Chamberlain Group",
    "005CB1": "Gospell DIGITAL TECHNOLOGY CO.",
    "506028": "Xirrus Inc.",
    "6CE907": "Nokia Corporation",
    "E4FA1D": "PAD Peripheral Advanced Design Inc.",
    "BCA4E1": "Nabto",
    "506441": "Greenlee",
    "9C1FDD": "Accupix Inc.",
    "7CDD11": "Chongqing MAS SCI&TECH.Co.",
    "B8FD32": "Zhejiang ROICX Microelectronics",
    "C8AF40": "marco Systemanalyse und Entwicklung GmbH",
    "40984C": "Casacom Solutions AG",
    "70EE50": "Netatmo",
    "984A47": "CHG Hospital Beds",
    "144978": "Digital Control Incorporated",
    "2C10C1": "Nintendo Co.",
    "8CD17B": "CG Mobile",
    "000831": "Cisco Systems",
    "34D09B": "MobilMAX Technology Inc.",
    "0091FA": "Synapse Product Development",
    "A05AA4": "Grand Products Nevada",
    "908FCF": "UNO System Co.",
    "40E793": "Shenzhen Siviton Technology Co.",
    "502690": "FUJITSU LIMITED",
    "3C6A7D": "Niigata Power Systems Co.",
    "502267": "PixeLINK",
    "3C7059": "MakerBot Industries",
    "8823FE": "TTTech Computertechnik AG",
    "F0EEBB": "VIPAR GmbH",
    "1C5C55": "PRIMA Cinema",
    "5CCEAD": "CDYNE Corporation",
    "AC54EC": "IEEE P1823 Standards Working Group",
    "709756": "Happyelectronics Co.",
    "B820E7": "Guangzhou Horizontal Information & Network Integration Co. Ltd",
    "00082F": "Cisco Systems",
    "386077": "PEGATRON CORPORATION",
    "708105": "Cisco Systems",
    "E0ED1A": "vastriver Technology Co.",
    "685E6B": "PowerRay Co.",
    "E455EA": "Dedicated Computing",
    "B89AED": "OceanServer Technology",
    "20C8B3": "SHENZHEN BUL-TECH CO.",
    "D4F63F": "IEA S.R.L.",
    "58B0D4": "ZuniData Systems Inc.",
    "64557F": "NSFOCUS Information Technology Co.",
    "988BAD": "Corintech Ltd.",
    "D44B5E": "TAIYO YUDEN CO.",
    "640E36": "TAZTAG",
    "C87D77": "Shenzhen Kingtech Communication Equipment Co.",
    "B05CE5": "Nokia Corporation",
    "3482DE": "Kiio Inc",
    "941D1C": "TLab West Systems AB",
    "94AE61": "Alcatel Lucent",
    "5C18B5": "Talon Communications",
    "64E161": "DEP Corp.",
    "0064A6": "Maquet CardioVascular",
    "7C6B52": "Tigaro Wireless",
    "4C5FD2": "Alcatel-Lucent",
    "9CC7D1": "SHARP Corporation",
    "149090": "KongTop industrial(shen zhen)CO.",
    "28C718": "Altierre",
    "7C4C58": "Scale Computing",
    "1013EE": "Justec International Technology INC.",
    "807A7F": "ABB Genway Xiamen Electrical Equipment CO.",
    "24DAB6": "Sistemas de Gestión Energética S.A. de C.V",
    "B07D62": "Dipl.-Ing. H. Horstmann GmbH",
    "B8F5E7": "WayTools",
    "B81999": "Nesys",
    "34255D": "Shenzhen Loadcom Technology Co.",
    "38DE60": "Mohlenhoff GmbH",
    "2839E7": "Preceno Technology Pte.Ltd.",
    "30688C": "Reach Technology Inc.",
    "FC0012": "Toshiba Samsung Storage Technolgoy Korea Corporation",
    "10EED9": "Canoga Perkins Corporation",
    "C029F3": "XySystem",
    "94DE0E": "SmartOptics AS",
    "D4CEB8": "Enatel LTD",
    "F8E7B5": "µTech Tecnologia LTDA",
    "8C271D": "QuantHouse",
    "181420": "TEB SAS",
    "4CA74B": "Alcatel Lucent",
    "1CE192": "Qisda Corporation",
    "706F81": "Private",
    "C43A9F": "Siconix Inc.",
    "686E23": "Wi3 Inc.",
    "DCF05D": "Letta Teknoloji",
    "8CB82C": "IPitomy Communications",
    "807DE3": "Chongqing Sichuan Instrument Microcircuit Co.LTD.",
    "DC175A": "Hitachi High-Technologies Corporation",
    "54F5B6": "ORIENTAL PACIFIC INTERNATIONAL LIMITED",
    "90342B": "Gatekeeper Systems",
    "5C16C7": "Arista Networks",
    "900D66": "Digimore Electronics Co.",
    "C8A1BA": "Neul Ltd",
    "3C096D": "Powerhouse Dynamics",
    "AC4AFE": "Hisense Broadband Multimedia Technology Co.",
    "A4B36A": "JSC SDO Chromatec",
    "F49461": "NexGen Storage",
    "0C924E": "Rice Lake Weighing Systems",
    "5435DF": "Symeo GmbH",
    "B8CDA7": "Maxeler Technologies Ltd.",
    "F43D80": "FAG Industrial Services GmbH",
    "48DCFB": "Nokia Corporation",
    "8C89A5": "Micro-Star INT'L CO.",
    "20B7C0": "OMICRON electronics GmbH",
    "8058C5": "NovaTec Kommunikationstechnik GmbH",
    "B8C716": "Fiberhome Telecommunication Technologies Co.",
    "D42C3D": "Sky Light Digital Limited",
    "589835": "Technicolor Delivery Technologies Belgium NV",
    "B4A5A9": "MODI GmbH",
    "E8C320": "Austco Marketing & Service (USA) ltd.",
    "C436DA": "Rusteletech Ltd.",
    "0C3956": "Observator instruments",
    "DCA6BD": "Beijing Lanbo Technology Co.",
    "A45A1C": "smart-electronic GmbH",
    "806459": "Nimbus Inc.",
    "8C5CA1": "d-broad",
    "F0DB30": "Yottabyte",
    "9C31B6": "Kulite Semiconductor Products Inc",
    "E4DD79": "En-Vision America",
    "E8CC32": "Micronet  LTD",
    "D43AE9": "DONGGUAN ipt INDUSTRIAL CO.",
    "18F650": "Multimedia Pacific Limited",
    "688470": "eSSys Co.",
    "10C586": "BIO SOUND LAB CO.",
    "10768A": "EoCell",
    "DC16A2": "Medtronic Diabetes",
    "308CFB": "Dropcam",
    "F44EFD": "Actions Semiconductor Co.",
    "24B8D2": "Opzoon Technology Co.",
    "A49981": "FuJian Elite Power Tech CO.",
    "54055F": "Alcatel Lucent",
    "6C5D63": "ShenZhen Rapoo Technology Co.",
    "941673": "Point Core SARL",
    "C8FE30": "Bejing DAYO Mobile Communication Technology Ltd.",
    "143E60": "Nokia",
    "5C56ED": "3pleplay Electronics Private Limited",
    "78028F": "Adaptive Spectrum and Signal Alignment (ASSIA)",
    "24C9DE": "Genoray",
    "1407E0": "Abrantix AG",
    "DCCF94": "Beijing Rongcheng Hutong Technology Co.",
    "A4DB2E": "Kingspan Environmental Ltd",
    "B83A7B": "Worldplay (Canada) Inc.",
    "D0EB9E": "Seowoo Inc.",
    "0432F4": "Partron",
    "1C184A": "ShenZhen RicherLink Technologies Co.",
    "BCCD45": "VOISMART",
    "70A41C": "Advanced Wireless Dynamics S.L.",
    "D4945A": "COSMO CO.",
    "304C7E": "Panasonic Electric Works Automation Controls Techno Co.",
    "5CF207": "Speco Technologies",
    "7032D5": "Athena Wireless Communications Inc",
    "78510C": "LiveU Ltd.",
    "44AAE8": "Nanotec Electronic GmbH & Co. KG",
    "103711": "NORBIT ITS",
    "D428B2": "ioBridge",
    "8427CE": "Corporation of the Presiding Bishop of The Church of Jesus Christ of Latter-day Saints",
    "48D8FE": "ClarIDy Solutions",
    "70E843": "Beijing C&W Optical Communication Technology Co.",
    "2C7ECF": "Onzo Ltd",
    "74B00C": "Network Video Technologies",
    "B42A39": "ORBIT MERRET",
    "E4D71D": "Oraya Therapeutics",
    "BCBBC9": "Kellendonk Elektronik GmbH",
    "E84040": "Cisco Systems",
    "D89DB9": "eMegatech International Corp.",
    "B4B88D": "Thuh Company",
    "4C73A5": "KOVE",
    "405A9B": "ANOVO",
    "D075BE": "Reno A&E",
    "E42AD3": "Magneti Marelli S.p.A. Powertrain",
    "E83EB6": "RIM",
    "BC35E5": "Hydro Systems Company",
    "28CCFF": "Corporacion Empresarial Altra SL",
    "94FD1D": "WhereWhen Corp",
    "4C07C9": "COMPUTER OFFICE Co.",
    "00B342": "MacroSAN Technologies Co.",
    "1CF5E7": "Turtle Industry Co.",
    "980EE4": "Private",
    "447DA5": "VTION INFORMATION TECHNOLOGY (FUJIAN) CO.",
    "0CCDD3": "EASTRIVER TECHNOLOGY CO.",
    "9C5D95": "VTC Electronics Corp.",
    "B8A8AF": "Logic S.p.A.",
    "60F673": "TERUMO CORPORATION",
    "F8769B": "Neopis Co.",
    "E06995": "PEGATRON CORPORATION",
    "84DE3D": "Crystal Vision Ltd",
    "C89C1D": "Cisco Systems",
    "BC6E76": "Green Energy Options Ltd",
    "E828D5": "Cots Technology",
    "F8DAF4": "Taishan Online Technology Co.",
    "08D5C0": "Seers Technology Co.",
    "6C33A9": "Magicjack LP",
    "108CCF": "Cisco Systems",
    "E0A1D7": "SFR",
    "9481A4": "Azuray Technologies",
    "BCE09D": "Eoslink",
    "CC7669": "SEETECH",
    "AC20AA": "DMATEK Co.",
    "E437D7": "HENRI DEPAEPE S.A.S.",
    "BC4377": "Hang Zhou Huite Technology Co.",
    "346F92": "White Rodgers Division",
    "7CDD90": "Shenzhen Ogemray Technology Co.",
    "9C220E": "TASCAN Systems GmbH",
    "0C3C65": "Dome Imaging Inc",
    "C8DF7C": "Nokia Corporation",
    "E46C21": "messMa GmbH",
    "00B033": "OAO Izhevskiy radiozavod",
    "081735": "Cisco Systems",
    "CCBE71": "OptiLogix BV",
    "0C469D": "MS Sedco",
    "D8E3AE": "CIRTEC MEDICAL SYSTEMS",
    "08B7EC": "Wireless Seismic",
    "18AF9F": "DIGITRONIC Automationsanlagen GmbH",
    "FCAF6A": "Qulsar Inc",
    "14EE9D": "AirNav Systems LLC",
    "78D004": "Neousys Technology Inc.",
    "8895B9": "Unified Packet Systems Crop",
    "78A051": "iiNet Labs Pty Ltd",
    "E0F379": "Vaddio",
    "78B6C1": "AOBO Telecom Co.",
    "B09AE2": "STEMMER IMAGING GmbH",
    "34BDF9": "Shanghai WDK Industrial Co.",
    "B44CC2": "NR ELECTRIC CO.",
    "48CB6E": "Cello Electronics (UK) Ltd",
    "804F58": "ThinkEco",
    "D8FE8F": "IDFone Co.",
    "888C19": "Brady Corp Asia Pacific Ltd",
    "08D29A": "Proformatique",
    "C89383": "Embedded Automation",
    "006DFB": "Vutrix Technologies Ltd",
    "9067B5": "Alcatel-Lucent",
    "448C52": "KTIS CO.",
    "0475F5": "CSST",
    "C8A729": "SYStronics Co.",
    "4454C0": "Thompson Aerospace",
    "64317E": "Dexin Corporation",
    "3C99F7": "Lansentechnology AB",
    "8C4DEA": "Cerio Corporation",
    "E80C38": "DAEYOUNG INFORMATION SYSTEM CO.",
    "34DF2A": "Fujikon Industrial Co.",
    "70A191": "Trendsetter Medical",
    "24BA30": "Technical Consumer Products",
    "E08A7E": "Exponent",
    "188ED5": "TP Vision Belgium N.V. - innovation site Brugge",
    "40B2C8": "Nortel Networks",
    "708B78": "citygrow technology co.",
    "A8B0AE": "BizLink Special Cables Germany GmbH",
    "E42771": "Smartlabs",
    "70B08C": "Shenou Communication Equipment Co.",
    "C03B8F": "Minicom Digital Signage",
    "20FEDB": "M2M Solution S.A.S.",
    "4491DB": "Shanghai Huaqin Telecom Technology Co.",
    "C4F464": "Spica international",
    "602A54": "CardioTek B.V.",
    "BCFFAC": "TOPCON CORPORATION",
    "14D76E": "CONCH ELECTRONIC Co.",
    "507D02": "BIODIT",
    "B4A4E3": "Cisco Systems",
    "94DD3F": "A+V Link Technologies",
    "C8A1B6": "Shenzhen Longway Technologies Co.",
    "A8556A": "3S System Technology Inc.",
    "D0574C": "Cisco Systems",
    "F8DAE2": "NDC Technologies",
    "F44227": "S & S Research Inc.",
    "8C1F94": "RF Surgical System Inc.",
    "AC83F0": "Cobalt Digital Inc.",
    "CC6B98": "Minetec Wireless Technologies",
    "3C04BF": "PRAVIS SYSTEMS Co.Ltd.",
    "705EAA": "Action Target",
    "34F968": "ATEK Products",
    "445EF3": "Tonalite Holding B.V.",
    "68DB96": "OPWILL Technologies CO .",
    "94A7BC": "BodyMedia",
    "B4C810": "Umpi srl",
    "585076": "Linear Equipamentos Eletronicos SA",
    "F0F9F7": "IES GmbH & Co. KG",
    "64A232": "OOO Samlight",
    "64FC8C": "Zonar Systems",
    "0C8D98": "TOP EIGHT IND CORP",
    "9803A0": "ABB n.v. Power Quality Products",
    "DCFAD5": "STRONG Ges.m.b.H.",
    "6C8D65": "Wireless Glue Networks",
    "40C7C9": "Naviit Inc.",
    "7CBB6F": "Cosco Electronics Co.",
    "20B0F7": "Enclustra GmbH",
    "543131": "Raster Vision Ltd",
    "D0E347": "Yoga",
    "38580C": "Panaccess Systems GmbH",
    "4451DB": "Raytheon BBN Technologies",
    "F0ED1E": "Bilkon Bilgisayar Kontrollu Cih. Im.Ltd.",
    "F8C091": "Highgates Technology",
    "AC9B84": "Smak Tecnologia e Automacao",
    "90F278": "Radius Gateway",
    "806629": "Prescope Technologies CO.",
    "4C60D5": "airPointe of New Hampshire",
    "C416FA": "Prysm Inc",
    "506F9A": "Wi-Fi Alliance",
    "842914": "EMPORIA TELECOM Produktions- und VertriebsgesmbH & Co KG",
    "BC7DD1": "Radio Data Comms",
    "646707": "Beijing Omnific Technology",
    "58FD20": "Systemhouse Solutions AB",
    "241F2C": "Calsys",
    "F0BDF1": "Sipod Inc.",
    "CC43E3": "Trump s.a.",
    "404022": "ZIV",
    "A85BB0": "Shenzhen Dehoo Technology Co.",
    "ACA016": "Cisco Systems",
    "58E747": "Deltanet AG",
    "40618E": "Stella-Green Co",
    "68E41F": "Unglaube Identech GmbH",
    "087695": "Auto Industrial Co.",
    "ACCE8F": "HWA YAO TECHNOLOGIES CO.",
    "8C9236": "Aus.Linx Technology Co.",
    "F8912A": "GLP German Light Products GmbH",
    "10C73F": "Midas Klark Teknik Ltd",
    "D4823E": "Argosy Technologies",
    "009363": "Uni-Link Technology Co.",
    "7C7673": "ENMAS GmbH",
    "389F83": "OTN Systems N.V.",
    "BC6A16": "tdvine",
    "003A9D": "NEC Platforms",
    "003532": "Electro-Metrics Corporation",
    "081FF3": "Cisco Systems",
    "44376F": "Young Electric Sign Co",
    "6CDC6A": "Promethean Limited",
    "9055AE": "Ericsson",
    "84C727": "Gnodal Ltd",
    "28CD4C": "Individual Computers GmbH",
    "8C53F7": "A&D ENGINEERING CO.",
    "888717": "CANON INC.",
    "44A689": "PROMAX ELECTRONICA SA",
    "1010B6": "McCain Inc",
    "F02408": "Talaris (Sweden) AB",
    "8081A5": "TONGQING COMMUNICATION EQUIPMENT (SHENZHEN) Co.",
    "44E49A": "OMNITRONICS PTY LTD",
    "08F2F4": "Net One Partners Co.",
    "0C7D7C": "Kexiang Information Technology Co",
    "B482FE": "ASKEY COMPUTER CORP",
    "307C30": "RIM",
    "BC4E3C": "CORE STAFF CO.",
    "3037A6": "Cisco Systems",
    "DC1D9F": "U & B tech",
    "B09074": "Fulan Electronics Limited",
    "94F692": "Geminico co.",
    "785C72": "Hioso Technology Co.",
    "580556": "Elettronica GF S.r.L.",
    "10445A": "Shaanxi Hitech Electronic Co.",
    "F47626": "Viltechmeda UAB",
    "68EFBD": "Cisco Systems",
    "F02FD8": "Bi2-Vision",
    "502A8B": "Telekom Research and Development Sdn Bhd",
    "EC43E6": "AWCER Ltd.",
    "0C8411": "A.O. Smith Water Products",
    "98BC99": "Edeltech Co.",
    "904716": "RORZE CORPORATION",
    "8894F9": "Gemicom Technology",
    "502A7E": "Smart electronic GmbH",
    "F0264C": "Sigrist-Photometer AG",
    "0C17F1": "TELECSYS",
    "7812B8": "ORANTEK LIMITED",
    "10B7F6": "Plastoform Industries Ltd.",
    "448E81": "VIG",
    "544249": "Sony Corporation",
    "E0ABFE": "Orb Networks",
    "087618": "ViE Technologies Sdn. Bhd.",
    "D0E40B": "Wearable Inc.",
    "747E1A": "Red Embedded Design Limited",
    "14A86B": "ShenZhen Telacom Science&Technology Co.",
    "0CC3A7": "Meritec",
    "A4DA3F": "Bionics Corp.",
    "A8C222": "TM-Research Inc.",
    "003D41": "Hatteland Computer AS",
    "CC5076": "Ocom Communications",
    "5C8778": "Cybertelbridge co.",
    "38BB23": "OzVision America LLC",
    "003A9B": "Cisco Systems",
    "2C3427": "ERCO & GENER",
    "80912A": "Lih Rong electronic Enterprise Co.",
    "803B9A": "ghe-ces electronic ag",
    "743256": "NT-ware Systemprg GmbH",
    "4CC452": "Shang Hai Tyd. Electon Technology Ltd.",
    "7CCB0D": "Antaira Technologies",
    "C01E9B": "Pixavi AS",
    "C4E17C": "U2S co.",
    "20BFDB": "DVL",
    "A05DE7": "DIRECTV",
    "448312": "Star-Net",
    "DCE2AC": "Lumens Digital Optics Inc.",
    "98D88C": "Nortel Networks",
    "78192E": "NASCENT Technology",
    "48EB30": "ETERNA TECHNOLOGY",
    "4C322D": "TELEDATA NETWORKS",
    "AC867E": "Create New Technology (HK) Limited Company",
    "8C598B": "C Technologies AB",
    "D44CA7": "Informtekhnika & Communication",
    "A04025": "Actioncable",
    "4C4B68": "Mobile Device",
    "201257": "Most Lucky Trading Ltd",
    "E8DAAA": "VideoHome Technology Corp.",
    "647D81": "YOKOTA INDUSTRIAL CO",
    "7CCFCF": "Shanghai SEARI Intelligent System Co.",
    "DC3350": "TechSAT GmbH",
    "E064BB": "DigiView S.r.l.",
    "68AAD2": "DATECS LTD.",
    "B4B5AF": "Minsung Electronics",
    "04B3B6": "Seamap (UK) Ltd",
    "1CF061": "SCAPS GmbH",
    "A893E6": "JIANGXI JINGGANGSHAN CKING COMMUNICATION TECHNOLOGY CO.",
    "C4AAA1": "SUMMIT DEVELOPMENT",
    "3032D4": "Hanilstm Co.",
    "04B466": "BSP Co.",
    "68CC9C": "Mine Site Technologies",
    "146E0A": "Private",
    "0CE709": "Fox Crypto B.V.",
    "6C0F6A": "JDC Tech Co.",
    "F0BCC8": "MaxID (Pty) Ltd",
    "24828A": "Prowave Technologies Ltd.",
    "00271B": "Alec Sicherheitssysteme GmbH",
    "002718": "Suzhou NEW SEAUNION Video Technology Co.",
    "00270B": "Adura Technologies",
    "00270D": "Cisco Systems",
    "002707": "Lift Complex DS",
    "0026FE": "MKD Technology Inc.",
    "0026E3": "DTI",
    "0026E5": "AEG Power Solutions",
    "002670": "Cinch Connectors",
    "002671": "AUTOVISION Co.",
    "002665": "ProtectedLogic Corporation",
    "0026BC": "General Jack Technology Ltd.",
    "0026AE": "Wireless Measurement Ltd",
    "0026B1": "Navis Auto Motive Systems",
    "0026AA": "Kenmec Mechanical Engineering Co.",
    "002660": "Logiways",
    "0026D7": "KM Electornic Technology Co.",
    "0026D0": "Semihalf",
    "0026D2": "Pcube Systems",
    "0026CD": "PurpleComm",
    "00269A": "Carina System Co.",
    "002695": "ZT Group Int'l Inc",
    "002693": "QVidium Technologies",
    "00268E": "Alta Solutions",
    "0026A0": "moblic",
    "002696": "NOOLIX Co.",
    "002678": "Logic Instrument SA",
    "002677": "DEIF A/S",
    "002610": "Apacewave Technologies",
    "00260E": "Ablaze Systems",
    "00260D": "Mercury Systems",
    "00260A": "Cisco Systems",
    "002603": "Shenzhen Wistar Technology Co.",
    "00262C": "IKT Advanced Technologies s.r.o.",
    "00262E": "Chengdu Jiuzhou Electronic Technology Inc",
    "002629": "Juphoon System Software Inc.",
    "002648": "Emitech Corp.",
    "002645": "Circontrol S.A.",
    "00263E": "Trapeze Networks",
    "0025E2": "Everspring Industry Co.",
    "0025E1": "SHANGHAI SEEYOO ELECTRONIC & TECHNOLOGY CO.",
    "0025DA": "Secura Key",
    "00263C": "Bachmann Technology GmbH & Co. KG",
    "00263D": "MIA Corporation",
    "002632": "Instrumentation Technologies d.d.",
    "0025DB": "ATI Electronics(Shenzhen) Co.",
    "0025D5": "Robonica (Pty) Ltd",
    "0025CC": "Mobile Communications Korea Incorporated",
    "0025C8": "S-Access GmbH",
    "0025C0": "ZillionTV Corporation",
    "002625": "MediaSputnik",
    "002626": "Geophysical Survey Systems",
    "00261B": "LAUREL BANK MACHINES CO.",
    "002614": "KTNF",
    "0025F9": "GMK electronic design GmbH",
    "0025F7": "Ansaldo STS USA",
    "0025A6": "Central Network Solution Co.",
    "0025AA": "Beijing Soul Technology Co.",
    "0025A3": "Trimax Wireless",
    "00259C": "Cisco-Linksys",
    "0025A2": "Alta Definicion LINCEO S.L.",
    "0025BD": "Italdata Ingegneria dell'Idea S.p.A.",
    "0025B7": "Costar  electronics",
    "002588": "Genie Industries",
    "002580": "Equipson S.A.",
    "00256D": "Broadband Forum",
    "00256C": "Azimut Production Association JSC",
    "002563": "Luxtera Inc",
    "002560": "Ibridge Networks & Communications Ltd.",
    "002593": "DatNet Informatikai Kft.",
    "00258E": "The Weather Channel",
    "00250D": "GZT Telkom-Telmor sp. z o.o.",
    "00250E": "gt german telematics gmbh",
    "002508": "Maquet Cardiopulmonary AG",
    "0024FB": "Private",
    "0024FA": "Hilger u. Kern GMBH",
    "0024F6": "MIYOSHI ELECTRONICS CORPORATION",
    "0024F0": "Seanodes",
    "002531": "Cloud Engines",
    "00252D": "Kiryung Electronics",
    "00252B": "Stirling Energy Systems",
    "002524": "Lightcomm Technology Co.",
    "002518": "Power PLUS Communications AG",
    "002515": "SFR",
    "002522": "ASRock Incorporation",
    "00251B": "Philips CareServant",
    "002536": "Oki Electric Industry Co.",
    "002541": "Maquet Critical Care AB",
    "0024FC": "QuoPin Co.",
    "002546": "Cisco Systems",
    "002545": "Cisco Systems",
    "002542": "Pittasoft",
    "0024C7": "Mobilarm Ltd",
    "0024B8": "free alliance sdn bhd",
    "0024D0": "Shenzhen SOGOOD Industry CO.",
    "0024CC": "Fascinations Toys and Gifts",
    "0024CB": "Autonet Mobile",
    "0024D1": "Thomson Inc.",
    "0024C9": "Broadband Solutions Group",
    "0024CA": "Tobii Technology AB",
    "0024A9": "Ag Leader Technology",
    "0024A6": "TELESTAR DIGITAL GmbH",
    "0024A3": "Sonim Technologies Inc",
    "0024B3": "Graf-Syteco GmbH & Co. KG",
    "0024AA": "Dycor Technologies Ltd.",
    "002472": "ReDriven Power Inc.",
    "002471": "Fusion MultiSystems dba Fusion-io",
    "002474": "Autronica Fire And Securirty",
    "00249B": "Action Star Enterprise Co.",
    "002463": "Phybridge Inc",
    "002497": "Cisco Systems",
    "0024DF": "Digitalbox Europe GmbH",
    "002425": "Shenzhenshi chuangzhicheng Technology Co.",
    "002427": "SSI COMPUTER CORP",
    "00241C": "FuGang Electronic (DG) Co.",
    "002419": "Private",
    "0023E7": "Hinke A/S",
    "0023E6": "Innovation Farm",
    "0023E2": "SEA Signalisation",
    "002415": "Magnetic Autocontrol GmbH",
    "002411": "PharmaSmart LLC",
    "00240F": "Ishii Tool & Engineering Corporation",
    "00243F": "Storwize",
    "002440": "Halo Monitoring",
    "002446": "MMB Research Inc.",
    "002445": "Adtran Inc",
    "0023FA": "RG Nets",
    "0023F2": "TVLogic",
    "0023E0": "INO Therapeutics LLC",
    "0023D5": "WAREMA Renkhoff SE",
    "00240A": "US Beverage Net",
    "002407": "TELEM SAS",
    "0023C4": "Lux Lumen",
    "0023C5": "Radiation Safety and Control Services Inc",
    "0023C6": "SMC Corporation",
    "0023B9": "Airbus Defence and Space Deutschland GmbH",
    "0023BD": "Digital Ally",
    "002390": "Algolware Corporation",
    "002388": "V.T. Telematica S.p.a.",
    "002386": "IMI Hydronic Engineering international SA",
    "002383": "InMage Systems Inc",
    "002381": "Lengda Technology(Xiamen) Co.",
    "0023C9": "Sichuan Tianyi Information Science & Technology Stock CO.",
    "0023CE": "KITA DENSHI CORPORATION",
    "0023CF": "CUMMINS-ALLISON CORP.",
    "0023C2": "SAMSUNG Electronics. Co. LTD",
    "0023BF": "Mainpine",
    "0023B2": "Intelligent Mechatronic Systems Inc",
    "0023B5": "ORTANA LTD",
    "00235D": "Cisco Systems",
    "00235C": "Aprius",
    "002352": "DATASENSOR S.p.A.",
    "00237B": "WHDI LLC",
    "002324": "G-PRO COMPUTER",
    "00236A": "SmartRG Inc",
    "002370": "Snell",
    "0023A9": "Beijing Detianquan Electromechanical Equipment Co.",
    "0023A7": "Redpine Signals",
    "00239B": "Elster Solutions",
    "002309": "Janam Technologies LLC",
    "002304": "Cisco Systems",
    "0022F9": "Pollin Electronic GmbH",
    "0022EE": "Algo Communication Products Ltd",
    "0022EA": "Rustelcom Inc.",
    "0022F0": "3 Greens Aviation Limited",
    "0022EC": "IDEALBT TECHNOLOGY CORPORATION",
    "002331": "Nintendo Co.",
    "002335": "Linkflex Co.",
    "00232F": "Advanced Card Systems Ltd.",
    "0022C5": "INFORSON Co",
    "0022BF": "SieAmp Group of Companies",
    "0022BE": "Cisco Systems",
    "0022B9": "Analogix Seminconductor",
    "002311": "Gloscom Co.",
    "002353": "F E T Elettronica snc",
    "002342": "Coffee Equipment Company",
    "002337": "Global Star Solutions ULC",
    "0022DD": "Protecta Electronics Ltd",
    "0022DB": "Translogic Corporation",
    "002325": "IOLAN Holding",
    "002321": "Avitech International Corp",
    "002319": "Sielox LLC",
    "0022DA": "ANATEK",
    "00226A": "Honeywell",
    "002262": "BEP Marine",
    "002263": "Koos Technical Services",
    "00226C": "LinkSprite Technologies",
    "00225C": "Multimedia & Communication Technology",
    "002290": "Cisco Systems",
    "00228A": "Teratronik elektronische systeme gmbh",
    "00228E": "TV-NUMERIC",
    "002284": "DESAY A&V SCIENCE AND TECHNOLOGY CO.",
    "002286": "ASTRON",
    "00229B": "AverLogic Technologies",
    "00229C": "Verismo Networks Inc",
    "00229A": "Lastar",
    "002254": "Bigelow Aerospace",
    "002257": "3COM EUROPE LTD",
    "0022B8": "Norcott",
    "0022B7": "GSS Grundig SAT-Systems GmbH",
    "0022B3": "Sei S.p.A.",
    "0022AB": "Shenzhen Turbosight Technology Ltd",
    "002246": "Evoc Intelligent Technology Co.",
    "002248": "Microsoft Corporation",
    "002282": "8086 Consultancy",
    "002276": "Triple EYE B.V.",
    "002274": "FamilyPhone AB",
    "002230": "FutureLogic Inc.",
    "00222E": "maintech GmbH",
    "0021BB": "Riken Keiki Co.",
    "0021B1": "DIGITAL SOLUTIONS LTD",
    "0021B0": "Tyco Telecommunications",
    "002214": "RINNAI KOREA",
    "00220B": "National Source Coding Center",
    "00220C": "Cisco Systems",
    "0021C6": "CSJ Global",
    "0021C3": "CORNELL Communications",
    "0021C7": "Russound",
    "0021C1": "ABB Oy / Medium Voltage Products",
    "0021C0": "Mobile Appliance",
    "0021EA": "Bystronic Laser AG",
    "0021E1": "Nortel Networks",
    "0021FD": "LACROIX TRAFFIC S.A.U",
    "002200": "IBM Corp",
    "002228": "Breeze Innovations Ltd.",
    "002229": "Compumedics Ltd",
    "002216": "SHIBAURA VENDING MACHINE CORPORATION",
    "0021CD": "LiveTV",
    "00216F": "SymCom",
    "002166": "NovAtel Inc.",
    "002164": "Special Design Bureau for Seismic Instrumentation",
    "002160": "Hidea Solutions Co. Ltd.",
    "002152": "General Satellite Research & Development Limited",
    "002158": "Style Flying Technology Co.",
    "002148": "Kaco Solar Korea",
    "002132": "Masterclock",
    "002131": "Blynke Inc.",
    "002129": "Cisco-Linksys",
    "00211D": "Dataline AB",
    "00217F": "Intraco Technology Pte Ltd",
    "00217D": "PYXIS S.R.L.",
    "002141": "RADLIVE",
    "00213D": "Cermetek Microelectronics",
    "0021AD": "Nordic ID Oy",
    "0021A3": "Micromint",
    "0021A5": "ERLPhase Power Technologies Ltd.",
    "00219D": "Adesys BV",
    "002120": "Sequel Technologies",
    "00211A": "LInTech Corporation",
    "002140": "EN Technologies Inc.",
    "00213C": "AliphCom",
    "002195": "GWD Media Limited",
    "002188": "EMC Corporation",
    "002116": "Transcon Electronic Systems",
    "002115": "PHYWE Systeme GmbH & Co. KG",
    "002111": "Uniphone Inc.",
    "002114": "Hylab Technology Inc.",
    "001FBF": "Fulhua Microelectronics Corp. Taiwan Branch",
    "001FBE": "Shenzhen Mopnet Industrial Co.",
    "001FC2": "Jow Tong Technology Co Ltd",
    "001FAD": "Brown Innovations",
    "001FA6": "Stilo srl",
    "001FE7": "Simet",
    "001FDB": "Network Supply Corp.",
    "001FCB": "NIW Solutions",
    "001FD2": "COMMTECH TECHNOLOGY MACAO COMMERCIAL OFFSHORE LTD.",
    "001FB5": "I/O Interconnect Inc.",
    "001FEB": "Trio Datacom Pty Ltd",
    "001FF7": "Nakajima All Precision Co.",
    "001F68": "Martinsson Elektronik AB",
    "001F63": "JSC Goodwin-Europa",
    "001F69": "Pingood Technology Co.",
    "001F4D": "Segnetics LLC",
    "001F1A": "Prominvest",
    "001F18": "Hakusan.Mfg.Co",
    "001F13": "S.& A.S. Ltd.",
    "001F25": "MBS GmbH",
    "001F27": "Cisco Systems",
    "001F26": "Cisco Systems",
    "001F97": "BERTANA srl",
    "001F8C": "CCS Inc.",
    "001F42": "Etherstack plc",
    "001F81": "Accel Semiconductor Corp",
    "001F83": "Teleplan Technology Services Sdn Bhd",
    "001F9B": "POSBRO",
    "001F78": "Blue Fox Porini Textile",
    "001F35": "AIR802 LLC",
    "001F34": "Lung Hwa Electronics Co.",
    "001F10": "TOLEDO DO BRASIL INDUSTRIA DE BALANCAS  LTDA",
    "001F0F": "Select Engineered Systems",
    "001F02": "Pixelmetrix Corporation Pte Ltd",
    "001EEF": "Cantronic International Limited",
    "001EDE": "BYD COMPANY LIMITED",
    "001EDD": "WASKO S.A.",
    "001EDB": "Giken Trastem Co.",
    "001ED1": "Keyprocessor B.V.",
    "001ED0": "Ingespace",
    "001ECD": "KYLAND Technology Co. LTD",
    "001E8E": "Hunkeler AG",
    "001E87": "Realease Limited",
    "001EBF": "Haas Automation Inc.",
    "001EBC": "WINTECH AUTOMATION CO.",
    "001EB1": "Cryptsoft Pty Ltd",
    "001EAF": "Ophir Optronics Ltd",
    "001EAD": "Wingtech Group Limited",
    "001EFE": "LEVEL s.r.o.",
    "001EEB": "Talk-A-Phone Co.",
    "001EA1": "Brunata a/s",
    "001E35": "Nintendo Co.",
    "001E2B": "Radio Systems Design",
    "001E28": "Lumexis Corporation",
    "001E24": "Zhejiang Bell Technology Co.",
    "001E20": "Intertain Inc.",
    "001E6F": "Magna-Power Electronics",
    "001E6A": "Beijing Bluexon Technology Co.",
    "001E66": "RESOL Elektronische Regelungen GmbH",
    "001E63": "Vibro-Meter SA",
    "001E53": "Further Tech Co.",
    "001E4E": "DAKO EDV-Ingenieur- und Systemhaus GmbH",
    "001E49": "Cisco Systems",
    "001E42": "Teltonika",
    "001E43": "AISIN CORPORATION",
    "001E32": "Zensys",
    "001E1C": "SWS Australia Pty Limited",
    "001E12": "Ecolab",
    "001E16": "Keytronix",
    "001E08": "Centec Networks Inc",
    "001DFB": "NETCLEUS Systems Corporation",
    "001E7F": "CBM of America",
    "001E82": "SanDisk Corporation",
    "001D90": "EMCO Flow Systems",
    "001D93": "Modacom",
    "001D94": "Climax Technology Co.",
    "001D8E": "Alereon",
    "001DBF": "Radiient Technologies",
    "001DB9": "Wellspring Wireless",
    "001DBB": "Dynamic System Electronics Corp.",
    "001D84": "Gateway",
    "001D85": "Call Direct Cellular Solutions",
    "001D7B": "Ice Energy",
    "001D6C": "ClariPhy Communications",
    "001DDB": "C-BEL Corporation",
    "001DE6": "Cisco Systems",
    "001DE7": "Marine Sonic Technology",
    "001DA4": "Hangzhou System Technology CO.",
    "001DB3": "HPN Supply Chain",
    "001DB1": "Crescendo Networks",
    "001DB4": "KUMHO ENG CO.",
    "001DC5": "Beijing Jiaxun Feihong Electricial Co.",
    "001DC6": "SNR Inc.",
    "001D9F": "MATT   R.P.Traczynscy Sp.J.",
    "001D34": "SYRIS Technology Corp",
    "001D32": "Longkay Communication & Technology (Shanghai) Co. Ltd",
    "001D2A": "SHENZHEN BUL-TECH CO.",
    "001D2D": "Pylone",
    "001D2B": "Wuhan Pont Technology CO.",
    "001D4C": "Alcatel-Lucent",
    "001D3E": "SAKA TECHNO SCIENCE CO.",
    "001D40": "Intel – GE Care Innovations LLC",
    "001CE9": "Galaxy Technology Limited",
    "001CEA": "Scientific-Atlanta",
    "001CE7": "Rocon PLC Research Centre",
    "001D02": "Cybertech Telecom Development",
    "001CFE": "Quartics Inc",
    "001CE4": "EleSy JSC",
    "001CE2": "Attero Tech",
    "001D5D": "Control Dynamics Pty. Ltd.",
    "001D59": "Mitra Energy & Infrastructure",
    "001D57": "CAETEC Messtechnik",
    "001D51": "Babcock & Wilcox Power Generation Group",
    "001D0B": "Power Standards Lab",
    "001D22": "Foss Analytical A/S",
    "001D23": "SENSUS",
    "001D1A": "OvisLink S.A.",
    "001C7A": "Perfectone Netware Company Ltd",
    "001C75": "Segnet Ltd.",
    "001C74": "Syswan Technologies Inc.",
    "001C68": "Anhui Sun Create Electronics Co.",
    "001CBC": "CastGrabber",
    "001CB7": "USC DigiArk Corporation",
    "001CB1": "Cisco Systems",
    "001CAF": "Plato Networks Inc.",
    "001CAA": "Bellon Pty Ltd",
    "001CA0": "Production Resource Group",
    "001C98": "LUCKY TECHNOLOGY (HK) COMPANY LIMITED",
    "001C91": "Gefen LLC",
    "001C92": "Tervela",
    "001C66": "UCAMP CO.",
    "001CDB": "CARPOINT CO.",
    "001CD5": "ZeeVee",
    "001CD3": "ZP Engineering SEL",
    "001CCB": "Forth Corporation Public Company Limited",
    "001C53": "Synergy Lighting Controls",
    "001C4D": "Aplix IP Holdings Corporation",
    "001C38": "Bio-Rad Laboratories",
    "001C8A": "Cirrascale Corporation",
    "001C81": "NextGen Venturi LTD",
    "001C02": "Pano Logic",
    "001C05": "Nonin Medical Inc.",
    "001C06": "Siemens Numerical Control Ltd.",
    "001C04": "Airgain",
    "001C01": "ABB Oy Drives",
    "001BFF": "Millennia Media inc.",
    "001C30": "Mode Lighting (UK ) Ltd.",
    "001C2E": "HPN Supply Chain",
    "001C2A": "Envisacor Technologies Inc.",
    "001BC6": "Strato Rechenzentrum AG",
    "001BC4": "Ultratec",
    "001BC2": "Integrated Control Technology Limitied",
    "001BBB": "RFTech Co.",
    "001BD2": "ULTRA-X ASIA PACIFIC Inc.",
    "001BF2": "KWORLD COMPUTER CO.",
    "001BF0": "Value Platforms Limited",
    "001BEA": "Nintendo Co.",
    "001BE5": "802automation Limited",
    "001BE4": "TOWNET SRL",
    "001BAA": "XenICs nv",
    "001C1B": "Hyperstone GmbH",
    "001C10": "Cisco-Linksys",
    "001B8D": "Electronic Computer Systems",
    "001B86": "Bosch Access Systems GmbH",
    "001B5D": "Vololink Pty Ltd",
    "001B5A": "Apollo Imaging Technologies",
    "001B56": "Tehuti Networks Ltd.",
    "001B7C": "A & R Cambridge",
    "001BA1": "Åmic AB",
    "001B96": "General Sensing",
    "001B4C": "Signtech",
    "001AEA": "Radio Terminal Systems Pty Ltd",
    "001ADD": "PePWave Ltd",
    "001AD4": "iPOX Technology Co.",
    "001AD6": "JIAGNSU AETNA ELECTRIC CO.",
    "001AD5": "KMC CHAIN INDUSTRIAL CO.",
    "001AD0": "Albis Technologies AG",
    "001B1E": "HART Communication Foundation",
    "001B14": "Carex Lighting Equipment Factory",
    "001B15": "Voxtel",
    "001AC3": "Scientific-Atlanta",
    "001ABF": "TRUMPF Laser Marking Systems AG",
    "001AB8": "Anseri Corporation",
    "001ABC": "U4EA Technologies Ltd",
    "001AD3": "Vamp Ltd.",
    "001AD8": "AlsterAero GmbH",
    "001ADA": "Biz-2-Me Inc.",
    "001ACB": "Autocom Products Ltd",
    "001ACF": "C.T. ELETTRONICA",
    "001B03": "Action Technology (SZ) Co.",
    "001AFB": "Joby Inc.",
    "001AFD": "EVOLIS",
    "001AA3": "DELORME",
    "001A9B": "ADEC & Parter AG",
    "001A9D": "Skipper Wireless",
    "001A8E": "3Way Networks Ltd",
    "001A6F": "MI.TEL s.r.l.",
    "001A71": "Diostech Co.",
    "001A69": "Wuhan Yangtze Optical Technology CO.",
    "001A67": "Infinite QL Sdn Bhd",
    "001A64": "IBM Corp",
    "001A1F": "Coastal Environmental Systems",
    "001A23": "Ice Qube",
    "001A1D": "PChome Online Inc.",
    "001A17": "Teak Technologies",
    "001A44": "JWTrading Co.",
    "001A33": "ASI Communications",
    "001A1C": "GT&T Engineering Pte Ltd",
    "001A49": "Micro Vision Co.",
    "001A3D": "Ajin Vision Co.",
    "001A41": "INOCOVA Co.",
    "001A55": "ACA-Digital Corporation",
    "001A85": "NV Michel Van de Wiele",
    "001A51": "Alfred Mann Foundation",
    "0019B2": "XYnetsoft Co.",
    "0019A4": "Austar Technology (hang zhou) Co.",
    "0019AA": "Cisco Systems",
    "0019B1": "Arrow7 Corporation",
    "001996": "TurboChef Technologies Inc.",
    "001997": "Soft Device Sdn Bhd",
    "001998": "SATO CORPORATION",
    "00199C": "CTRING",
    "0019E6": "TOYO MEDIC CO.",
    "0019E8": "Cisco Systems",
    "0019DF": "Thomson Inc.",
    "0019DD": "FEI-Zyfer",
    "001A0A": "Adaptive Micro-Ware Inc.",
    "001A05": "OPTIBASE LTD",
    "0019B3": "Stanford Research Systems",
    "0019D4": "ICX Technologies",
    "0019CF": "SALICRU",
    "0019FC": "PT. Ufoakses Sukses Luarbiasa",
    "00198B": "Novera Optics Korea",
    "001946": "Cianet Industria e Comercio S/A",
    "001949": "TENTEL  COMTECH CO.",
    "001944": "Fossil Partners",
    "001908": "Duaxes Corporation",
    "00190C": "Encore Electronics",
    "001976": "Xipher Technologies",
    "00196C": "ETROVISION TECHNOLOGY",
    "001967": "TELDAT Sp.J.",
    "001942": "ON SOFTWARE INTERNATIONAL LIMITED",
    "00193F": "RDI technology(Shenzhen) Co.",
    "001941": "Pitney Bowes",
    "00192D": "Nokia Corporation",
    "001930": "Cisco Systems",
    "001927": "ImCoSys Ltd",
    "001971": "Guangzhou Unicomp Technology Co.",
    "001964": "Doorking Inc.",
    "001961": "Blaupunkt  Embedded Systems GmbH",
    "001952": "ACOGITO Co.",
    "001919": "ASTEL Inc.",
    "0018F7": "Kameleon Technologies",
    "0018B4": "Dawon Media Inc.",
    "0018B6": "S3C",
    "0018B1": "IBM Corp",
    "00189D": "Navcast Inc.",
    "001885": "Motorola Solutions Inc.",
    "001888": "GOTIVE a.s.",
    "00188A": "Infinova LLC",
    "0018FD": "Optimal Technologies International Inc.",
    "0018F0": "JOYTOTO Co.",
    "0018E9": "Numata Corporation",
    "0018EF": "Escape Communications",
    "0018A3": "ZIPPY TECHNOLOGY CORP.",
    "001893": "SHENZHEN PHOTON BROADBAND TECHNOLOGY CO.",
    "0018A0": "Cierma Ascenseurs",
    "001886": "EL-TECH",
    "001887": "Metasystem SpA",
    "00187B": "4NSYS Co. Ltd.",
    "00187E": "RGB Spectrum",
    "0018E6": "Computer Hardware Design SIA",
    "0018DB": "EPL Technology Ltd",
    "0018C8": "ISONAS Inc.",
    "0018BE": "ANSA Corporation",
    "0018BA": "Cisco Systems",
    "0018D6": "Swirlnet A/S",
    "0018CD": "Erae Electronics Industry Co.",
    "001879": "dSys",
    "0017EF": "IBM Corp",
    "0017F5": "LIG NEOPTEK",
    "0017FE": "TALOS SYSTEM INC.",
    "0017F8": "Motech Industries Inc.",
    "001863": "Veritech Electronics Limited",
    "00185A": "uControl",
    "001852": "StorLink Semiconductors",
    "00181E": "GDX Technologies Ltd.",
    "001807": "Fanstel Corp.",
    "001850": "Secfone Kft",
    "001858": "TagMaster AB",
    "001849": "nVent",
    "001846": "Crypto S.A.",
    "001845": "Pulsar-Telecom LLC.",
    "00183D": "Vertex Link Corporation",
    "001808": "SightLogix",
    "001803": "ArcSoft Shanghai Co. LTD",
    "001824": "Kimaldi Electronics",
    "0017DB": "CANKO TECHNOLOGIES INC.",
    "0017D6": "Bluechips Microhouse Co.",
    "001825": "Private",
    "0017CE": "Screen Service Spa",
    "0017CD": "CEC Wireless R&D Ltd.",
    "0017D0": "Opticom Communications",
    "0017C6": "Cross Match Technologies Inc",
    "00178F": "NINGBO YIDONG ELECTRONIC CO.",
    "00178A": "DARTS TECHNOLOGIES CORP.",
    "0017AB": "Nintendo Co.",
    "001789": "Zenitron Corporation",
    "001787": "Brother",
    "001761": "Private",
    "001768": "Zinwave Ltd",
    "001769": "Cymphonix Corp",
    "001762": "Solar Technology",
    "0017C3": "KTF Technologies Inc.",
    "0017B7": "Tonze Technology Co.",
    "001772": "ASTRO Strobel Kommunikationssysteme GmbH",
    "00177A": "ASSA ABLOY AB",
    "001760": "Naito Densei Machida MFG.CO.",
    "001798": "Azonic Technology Co.",
    "001747": "Trimble",
    "0016F1": "OmniSense",
    "0016F4": "Eidicom Co.",
    "0016E7": "Dynamix Promotions Limited",
    "0016E5": "FORDLEY DEVELOPMENT LIMITED",
    "001720": "Image Sensing Systems",
    "00171A": "Winegard Company",
    "001726": "m2c Electronic Technology Ltd.",
    "001721": "FITRE S.p.A.",
    "001734": "ADC Telecommunications",
    "00172E": "FXC Inc.",
    "00172B": "Global Technologies Inc.",
    "0016F3": "CAST Information Co.",
    "0016F5": "Dalian Golden Hualu Digital Technology Co.",
    "00173E": "LeucotronEquipamentos Ltda.",
    "00171C": "NT MicroSystems",
    "001716": "Qno Technology Inc.",
    "0016F9": "CETRTA POT",
    "00170A": "INEW DIGITAL COMPANY",
    "0016BD": "ATI Industrial Automation",
    "0016C0": "Semtech Corporation",
    "0016C2": "Avtec Systems Inc",
    "0016BA": "WEATHERNEWS INC.",
    "0016AF": "Shenzhen Union Networks Equipment Co.",
    "00169E": "TV One Ltd",
    "00169F": "Vimtron Electronics Co.",
    "00168B": "Paralan Corporation",
    "001682": "OMS Motion",
    "00169A": "Quadrics Ltd",
    "001692": "Scientific-Atlanta",
    "001691": "Moser-Baer AG",
    "001688": "ServerEngines LLC",
    "0016B2": "DriveCam Inc",
    "0016B3": "Photonicbridges (China) Co.",
    "0016AD": "BT-Links Company Limited",
    "0016DD": "Gigabeam Corporation",
    "0016C8": "Cisco Systems",
    "0016C4": "SiRF Technology",
    "001629": "Nivus GmbH",
    "001621": "Colorado Vnet",
    "00161A": "Dametric AB",
    "001615": "Nittan Company",
    "00162E": "Space Shuttle Hi-Tech Co.",
    "00162A": "Antik computers & communications s.r.o.",
    "00166E": "Arbitron Inc.",
    "00166A": "TPS",
    "001663": "KBT Mobile",
    "001654": "Flex-P Industries Sdn. Bhd.",
    "001656": "Nintendo Co.",
    "001606": "Ideal Industries",
    "001607": "Curves International Inc.",
    "00160A": "SWEEX Europe BV",
    "001602": "CEYON TECHNOLOGY CO.",
    "001600": "CelleBrite Mobile Synchronization",
    "0015F4": "Eventide",
    "0015ED": "Fulcrum Microsystems",
    "001651": "Exeo Systems",
    "00164B": "Quorion Data Systems GmbH",
    "001617": "MSI",
    "001610": "Carina Technology",
    "001631": "Xteam",
    "0015F0": "EGO BV",
    "0015EE": "Omnex Control Systems",
    "001594": "BIXOLON CO.",
    "001590": "Hectronic GmbH",
    "00158C": "Liab ApS",
    "00158F": "NTT Advanced Technology Corporation",
    "0015C8": "FlexiPanel Ltd",
    "0015C0": "DIGITAL TELEMEDIA CO.",
    "0015C2": "3M Germany",
    "001583": "IVT corporation",
    "001588": "Salutica Allied Solutions Sdn Bhd",
    "001585": "Aonvision Technolopy Corp.",
    "0015A5": "DCI Co.",
    "001579": "Lunatone Industrielle Elektronik GmbH",
    "00156B": "Perfisans Networks Corp.",
    "001566": "A-First Technology Co.",
    "0015B2": "Advanced Industrial Computer",
    "0015DA": "IRITEL A.D.",
    "00150E": "OPENBRAIN TECHNOLOGIES CO.",
    "00150D": "Hoana Medical",
    "001506": "Neo Photonics",
    "001504": "GAME PLUS CO.",
    "001505": "Actiontec Electronics",
    "0014FE": "Artech Electronics",
    "001539": "Technodrive srl",
    "001531": "KOCOM",
    "001535": "OTE Spa",
    "001536": "Powertech co.",
    "00152B": "Cisco Systems",
    "00152C": "Cisco Systems",
    "001528": "Beacon Medical Products LLC d.b.a. BeaconMedaes",
    "00154A": "WANSHIH ELECTRONIC CO.",
    "00154C": "Saunders Electronics",
    "00154D": "Netronome Systems",
    "001549": "Dixtal Biomedica Ind. Com. Ltda",
    "001547": "AiZen Solutions Inc.",
    "001527": "Balboa Instruments",
    "001521": "Horoquartz",
    "001520": "Radiocrafts AS",
    "00151C": "LENECO",
    "00153D": "ELIM PRODUCT CO.",
    "001544": "coM.s.a.t. AG",
    "001519": "StoreAge Networking Technologies",
    "001511": "Data Center Systems",
    "0014E6": "AIM Infrarotmodule GmbH",
    "0014F3": "ViXS Systems Inc",
    "001489": "B15402100 - JANDEI",
    "001480": "Hitachi-LG Data Storage Korea",
    "0014BE": "Wink communication technology CO.LTD",
    "0014BA": "Carvers SA de CV",
    "00147E": "InnerWireless",
    "00147D": "Aeon Digital International",
    "001476": "MultiCom Industries Limited",
    "001473": "Bookham Inc",
    "0014D7": "Datastore Technology Corp",
    "0014DD": "Covergence Inc.",
    "0014D4": "K Technology Corporation",
    "0014CF": "INVISIO Communications",
    "00146E": "H. Stoll GmbH & Co. KG",
    "001469": "Cisco Systems",
    "0014B6": "Enswer Technology Inc.",
    "0014B2": "mCubelogics Corporation",
    "0014AE": "Wizlogics Co.",
    "0014DE": "Sage Instruments Inc.",
    "0014DF": "HI-P Tech Corporation",
    "0014A6": "Teranetics",
    "0014AA": "Ashly Audio",
    "00148A": "Elin Ebg Traction Gmbh",
    "0013FD": "Nokia Danmark A/S",
    "001400": "MINERVA KOREA CO.",
    "0013FC": "SiCortex",
    "0013F6": "Cintech",
    "0013F3": "Giga-byte Communications Inc.",
    "00144F": "Oracle Corporation",
    "001456": "Edge Products",
    "001450": "Heim Systems GmbH",
    "001452": "CALCULEX",
    "001442": "ATTO CORPORATION",
    "0013DA": "Diskware Co.",
    "0013D8": "Princeton Instruments",
    "0013CB": "Zenitel Norway AS",
    "001409": "MAGNETI MARELLI   S.E. S.p.A.",
    "00140B": "FIRST INTERNATIONAL COMPUTER",
    "001447": "BOAZ Inc.",
    "00143E": "AirLink Communications",
    "00143B": "Sensovation AG",
    "00145D": "WJ Communications",
    "00142D": "Toradex AG",
    "001429": "V Center Technologies Co.",
    "00141E": "P.A. Semi",
    "001414": "Jumpnode Systems LLC.",
    "0013F4": "Psitek (Pty) Ltd",
    "0013E9": "VeriWave",
    "00135F": "Cisco Systems",
    "001356": "FLIR Radiation Inc",
    "00135A": "Project T&E Limited",
    "001361": "Biospace Co.",
    "001362": "ShinHeung Precision Co.",
    "00134F": "Rapidus Wireless Networks Inc.",
    "001378": "Qsan Technology",
    "00137A": "Netvox Technology Co.",
    "001381": "CHIPS & Systems",
    "001379": "PONDER INFORMATION INDUSTRIES LTD.",
    "001374": "Atheros Communications",
    "0013CF": "4Access Communications",
    "0013C9": "Beyond Achieve Enterprises Ltd.",
    "0013C6": "OpenGear",
    "001369": "Honda Electron Co.",
    "001367": "Narayon. Co.",
    "00135C": "OnSite Systems",
    "0013AC": "Sunmyung Electronics Co.",
    "0013A8": "Tanisys Technology",
    "001399": "STAC Corporation.",
    "001395": "congatec GmbH",
    "0013B9": "BM SPA",
    "0013AB": "Telemotive AG",
    "0013BE": "Virtual Conexions",
    "0012E8": "Fraunhofer IMS",
    "0012DD": "Shengqu Information Technology (Shanghai) Co.",
    "0012E0": "Codan Limited",
    "0012DE": "Radio Components Sweden AB",
    "001318": "DGSTATION Co.",
    "00131A": "Cisco Systems",
    "00130C": "HF System Corporation",
    "00130F": "EGEMEN Bilgisayar Muh San ve Tic LTD STI",
    "00132D": "iWise Communications",
    "00132C": "MAZ Brandenburg GmbH",
    "001324": "Schneider Electric Ultra Terminal",
    "001326": "ECM Systems Ltd",
    "001327": "Data Acquisitions limited",
    "00131D": "Scanvaegt International A/S",
    "001301": "IronGate S.L.",
    "0012F6": "MDK CO.",
    "0012F4": "Belco International Co.",
    "0012F1": "IFOTEC",
    "0012F5": "Imarda New Zealand Limited",
    "001313": "GuangZhou Post & Telecom Equipment ltd",
    "0012F8": "WNI Resources",
    "00133B": "Speed Dragon Multimedia Limited",
    "001338": "FRESENIUS-VIAL",
    "001342": "Vision Research",
    "0012CB": "CSS Inc.",
    "0012CE": "Advanced Cybernetics Group",
    "0012CA": "Mechatronic Brick Aps",
    "0012C7": "SECURAY Technologies Ltd.Co.",
    "0012CD": "ASEM SpA",
    "00126A": "OPTOELECTRONICS Co.",
    "001268": "IPS d.o.o.",
    "001266": "Swisscom Hospitality Services SA",
    "0012AB": "WiLife",
    "0012AC": "ONTIMETEK INC.",
    "0012C0": "HotLava Systems",
    "0012B7": "PTW Freiburg",
    "0012BC": "Echolab LLC",
    "0012BD": "Avantec Manufacturing Limited",
    "00127C": "SWEGON AB",
    "001278": "International Bar Code",
    "00127A": "Sanyu Industry Co.",
    "001272": "Redux Communications Ltd.",
    "00129B": "E2S Electronic Engineering Solutions",
    "001298": "MICO ELECTRIC(SHENZHEN) LIMITED",
    "0012A1": "BluePacket Communications Co.",
    "001221": "B.Braun Melsungen AG",
    "001212": "PLUS  Corporation",
    "001213": "Metrohm AG",
    "001218": "ARUZE Corporation",
    "001206": "iQuest (NZ) Ltd",
    "001207": "Head Strong International Limited",
    "001209": "Fastrax Ltd",
    "00124D": "Inducon BV",
    "001238": "SetaBox Technology Co.",
    "00123C": "Second Rule LLC",
    "00123E": "ERUNE technology Co.",
    "0011E3": "Thomson",
    "0011DC": "Glunz & Jensen",
    "00125E": "CAEN",
    "00125D": "CyberNet Inc.",
    "001254": "Spectra Technologies Holdings Company Ltd",
    "00124F": "nVent",
    "001249": "Delta Elettronica S.p.A.",
    "00123A": "Posystech Inc.",
    "001234": "Camille Bauer",
    "0011F7": "Shenzhen Forward Industry Co.",
    "00120B": "Chinasys Technologies Limited",
    "001205": "Terrasat Communications",
    "001223": "Pixim",
    "001190": "Digital Design Corporation",
    "001196": "Actuality Systems",
    "001187": "Category Solutions",
    "001171": "DEXTER Communications",
    "001167": "Integrated System Solution Corp.",
    "00116D": "American Time and Signal",
    "001160": "ARTDIO Company Co.",
    "001154": "Webpro Technologies Inc.",
    "0011A5": "Fortuna Electronic Corp.",
    "0011C4": "Terminales de Telecomunicacion Terrestre",
    "0011CB": "Jacobsons AB",
    "00117B": "Büchi  Labortechnik AG",
    "00116F": "Netforyou Co.",
    "001151": "Mykotronx",
    "00114E": "690885 Ontario Inc.",
    "0011D3": "NextGenTel Holding ASA",
    "0011AB": "TRUSTABLE TECHNOLOGY CO.",
    "000FE7": "Lutron Electronics Co.",
    "000FE6": "MBTech Systems",
    "000FE9": "GW TECHNOLOGIES CO.",
    "000FE1": "ID DIGITAL CORPORATION",
    "000FDF": "SOLOMON Technology Corp.",
    "000FEF": "Thales e-Transactions GmbH",
    "000FEE": "XTec",
    "000FE4": "Pantech Co.",
    "001102": "Aurora Multimedia Corp.",
    "000FFE": "G-PRO COMPUTER",
    "000FDA": "YAZAKI CORPORATION",
    "001145": "ValuePoint Networks",
    "001127": "TASI",
    "00112A": "Niko NV",
    "00112B": "NetModule AG",
    "00112D": "iPulse Systems",
    "00113C": "Micronas GmbH",
    "001131": "UNATECH. CO.",
    "001123": "Appointech",
    "00110F": "netplat",
    "001115": "EPIN Technologies",
    "00110B": "Franklin Technology Systems",
    "001105": "Sunplus Technology Co.",
    "000FD6": "Sarotech Co.",
    "000FAC": "IEEE 802.11",
    "000FB3": "Actiontec Electronics",
    "000F9C": "Panduit Corp",
    "000F72": "Sandburst",
    "000F75": "First Silicon Solutions",
    "000F7C": "ACTi Corporation",
    "000F7A": "BeiJing NuQX Technology CO.",
    "000FC7": "Dionica R&D Ltd.",
    "000FC8": "Chantry Networks",
    "000FBB": "Nokia Siemens Networks GmbH & Co. KG.",
    "000FBC": "Onkey Technologies",
    "000FB6": "Europlex Technologies",
    "000F64": "D&R Electronica Weesp BV",
    "000FB9": "Adaptive Instruments",
    "000FAB": "Kyushu Electronics Systems Inc.",
    "000FAD": "FMN communications GmbH",
    "000F54": "Entrelogic Corporation",
    "000F53": "Solarflare Communications Inc.",
    "000F51": "Azul Systems",
    "000F98": "Avamax Co. Ltd.",
    "000F97": "Avanex Corporation",
    "000F96": "Telco Systems",
    "000F8B": "Orion MultiSystems Inc",
    "000F8C": "Gigawavetech Pte Ltd",
    "000F3B": "Fuji System Machines Co.",
    "000F37": "Xambala Incorporated",
    "000F38": "Netstar",
    "000F3A": "HISHARP",
    "000F34": "Cisco Systems",
    "000F30": "Raza Microelectronics Inc",
    "000F2E": "Megapower International Corp.",
    "000F26": "WorldAccxx  LLC",
    "000ED3": "Epicenter",
    "000ED7": "Cisco Systems",
    "000EC5": "Digital Multitools Inc",
    "000F00": "Legra Systems",
    "000F01": "DIGITALKS INC",
    "000F03": "COM&C CO.",
    "000F45": "Stretch",
    "000F10": "RDM Corporation",
    "000F07": "Mangrove Systems",
    "000F25": "AimValley B.V.",
    "000F19": "Boston Scientific",
    "000EDF": "PLX Technology",
    "000EE1": "ExtremeSpeed Inc.",
    "000EC7": "Motorola Korea",
    "000EBA": "HANMI SEMICONDUCTOR CO.",
    "000EBC": "Paragon Fidelity GmbH",
    "000E6C": "Device Drivers Limited",
    "000E6B": "Janitza electronics GmbH",
    "000E67": "Eltis Microelectronics Ltd.",
    "000EAE": "GAWELL TECHNOLOGIES CORP.",
    "000EA4": "Quantum Corp.",
    "000E9D": "Tiscali UK Ltd",
    "000E57": "Iworld Networking",
    "000E47": "NCI System Co.",
    "000EA8": "United Technologists Europe Limited",
    "000EAA": "Scalent Systems",
    "000EAC": "MINTRON ENTERPRISE CO.",
    "000E8B": "Astarte Technology Co",
    "000E80": "Thomson Technology Inc",
    "000E85": "Catalyst Enterprises",
    "000E74": "Solar Telecom. Tech",
    "000E7A": "GemWon Communications Co.",
    "000E65": "TransCore",
    "000E5F": "activ-net GmbH & Co. KG",
    "000DF5": "Teletronics International Inc.",
    "000DF7": "Space Dynamics Lab",
    "000DEB": "CompXs Limited",
    "000DEE": "Andrew RF Power Amplifier Group",
    "000DEF": "Soc. Coop. Bilanciai",
    "000DE7": "Snap-on OEM Group",
    "000DF0": "QCOM TECHNOLOGY INC.",
    "000DE5": "Samsung Thales",
    "000DDD": "Profilo Telra Elektronik Sanayi ve Ticaret. A.Ş",
    "000E0B": "Netac Technology Co.",
    "000E11": "BDT Büro und Datentechnik GmbH & Co.KG",
    "000DC0": "Spagat AS",
    "000E32": "Kontron Medical",
    "000E1F": "TCL Networks Equipment Co.",
    "000E46": "Niigata Seimitsu Co.",
    "000E43": "G-Tek Electronics Sdn. Bhd.",
    "000E44": "Digital 5",
    "000DF8": "ORGA Kartensysteme GmbH",
    "000E26": "Gincom Technology Corp.",
    "000E16": "SouthWing S.L.",
    "000D82": "PHSNET",
    "000D83": "Sanmina-SCI Hungary  Ltd.",
    "000D7F": "MIDAS  COMMUNICATION TECHNOLOGIES PTE LTD ( Foreign Branch)",
    "000D75": "Kobian Pte Ltd - Taiwan Branch",
    "000D78": "Engineering & Security",
    "000D79": "Dynamic Solutions Co",
    "000DA7": "Private",
    "000DAD": "Dataprobe",
    "000DA9": "INGETEAM",
    "000DAB": "Parker Hannifin GmbH Electromechanical Division Europe",
    "000DA8": "Teletronics Technology Corporation",
    "000D9E": "TOKUDEN OHIZUMI SEISAKUSYO Co.",
    "000DC6": "DigiRose Technology Co.",
    "000DC1": "SafeWeb Inc",
    "000DBA": "Océ Document Technologies GmbH",
    "000DBD": "Cisco Systems",
    "000D6D": "K-Tech Devices Corp.",
    "000D6E": "K-Patents Oy",
    "000D6A": "Redwood Technologies LTD",
    "000DB5": "GLOBALSAT TECHNOLOGY CORPORATION",
    "000DB4": "Stormshield",
    "000DAF": "Plexus Corp (UK) Ltd",
    "000DB1": "Japan Network Service Co.",
    "000DA3": "Emerging Technologies Limited",
    "000DA4": "DOSCH & AMAND SYSTEMS AG",
    "000D9A": "INFOTEC LTD",
    "000D96": "Vtera Technology Inc.",
    "000D8B": "T&D Corporation",
    "000D90": "Factum Electronics AB",
    "000D85": "Tapwave",
    "000D5D": "Raritan Computer",
    "000D63": "DENT Instruments",
    "000D66": "Cisco Systems",
    "000D21": "WISCORE Inc.",
    "000D23": "Smart Solution",
    "000D27": "MICROPLEX Printware AG",
    "000D1B": "Kyoto Electronics Manufacturing Co.",
    "000D1D": "HIGH-TEK HARNESS ENT. CO.",
    "000CC9": "ILWOO DATA & TECHNOLOGY CO.",
    "000D40": "Verint Loronix Video Solutions",
    "000D37": "WIPLUG",
    "000D02": "NEC Platforms",
    "000D07": "Calrec Audio Ltd",
    "000CDD": "AOS technologies AG",
    "000CCD": "IEC - TC57",
    "000CCB": "Design Combus Ltd",
    "000CE9": "BLOOMBERG L.P.",
    "000CEA": "aphona Kommunikationssysteme",
    "000CDA": "FreeHand Systems",
    "000D33": "Prediwave Corp.",
    "000D2F": "AIN Comm.Tech.Co.",
    "000D09": "Yuehua(Zhuhai) Electronic CO. LTD",
    "000CFB": "Korea Network Systems",
    "000CF5": "InfoExpress",
    "000CEE": "jp-embedded",
    "000C85": "Cisco Systems",
    "000C84": "Eazix",
    "000C7A": "DaTARIUS Technologies GmbH",
    "000C79": "Extel Communications P/L",
    "000C75": "Oriental integrated electronics. LTD",
    "000C6D": "Edwards Ltd.",
    "000C70": "ACC GmbH",
    "000C6A": "MBARI",
    "000C6B": "Kurz Industrie-Elektronik GmbH",
    "000CB3": "ROUND Co.",
    "000CA5": "Naman NZ LTd",
    "000CA9": "Ebtron Inc.",
    "000C9A": "Hitech Electronics Corp.",
    "000C91": "Riverhead Networks Inc.",
    "000C5D": "CHIC TECHNOLOGY (CHINA) CORP.",
    "000C4F": "UDTech Japan Corporation",
    "000C62": "ABB AB",
    "000C9D": "UbeeAirWalk",
    "000C9F": "NKE Corporation",
    "000C4C": "Arcor AG&Co.",
    "000C47": "SK Teletech(R&D Planning Team)",
    "000CAF": "TRI TERM CO.",
    "000C15": "CyberPower Systems",
    "000C16": "Concorde Microsystems Inc.",
    "000BDA": "EyeCross Co.",
    "000BD6": "Paxton Access Ltd",
    "000C1F": "Glimmerglass Networks",
    "000C20": "Fi WIn",
    "000C02": "ABB Oy",
    "000BFF": "Berkeley Camera Engineering",
    "000BD0": "XiMeta Technology Americas Inc.",
    "000BD4": "Beijing Wise Technology & Science Development Co.Ltd",
    "000BEC": "NIPPON ELECTRIC INSTRUMENT",
    "000BE7": "COMFLUX TECHNOLOGY INC.",
    "000C3F": "Cogent Defence & Security Networks",
    "000BC5": "SMC Networks",
    "000BC6": "ISAC",
    "000C09": "Hitachi IE Systems Co.",
    "000B5E": "Audio Engineering Society Inc.",
    "000B5F": "Cisco Systems",
    "000B60": "Cisco Systems",
    "000B65": "Sy.A.C. srl",
    "000B61": "Friedrich Lütze GmbH & Co. KG",
    "000B59": "ScriptPro",
    "000B5C": "Newtech Co.",
    "000B83": "DATAWATT B.V.",
    "000B71": "Litchfield Communications Inc.",
    "000B74": "Kingwave Technology Co.",
    "000B73": "Kodeos Communications",
    "000B76": "ET&T Technology Co. Ltd.",
    "000B7E": "SAGINOMIYA Seisakusho Inc.",
    "000B80": "Lycium Networks",
    "000B7C": "Telex Communications",
    "000BC1": "Bay Microsystems",
    "000BA7": "Maranti Networks",
    "000BAA": "Aiphone co.",
    "000B39": "Keisoku Giken Co.",
    "000B33": "Vivato Technologies",
    "000B3E": "BittWare",
    "000BA4": "Shiron Satellite Communications Ltd. (1996)",
    "000B99": "SensAble Technologies",
    "000B9C": "TriBeam Technologies",
    "000B5B": "Rincon Research Corporation",
    "000B89": "Top Global Technology",
    "000B8B": "KERAJET",
    "000B41": "Ing. Büro Dr. Beutlhauser",
    "000AEA": "ADAM ELEKTRONIK LTD. ŞTI",
    "000AE3": "YANG MEI TECHNOLOGY CO.",
    "000ADC": "RuggedCom Inc.",
    "000AE0": "Fujitsu Softek",
    "000B03": "Taekwang Industrial Co.",
    "000B01": "DAIICHI ELECTRONICS CO.",
    "000AB9": "Astera Technologies Corp.",
    "000AA1": "V V S Limited",
    "000AA4": "SHANGHAI SURVEILLANCE TECHNOLOGY CO",
    "000A9E": "BroadWeb Corportation",
    "000ABB": "Taiwan Secom Co",
    "000AAD": "Stargames Corporation",
    "000AB1": "GENETEC Corporation",
    "000AB7": "Cisco Systems",
    "000B11": "HIMEJI ABC TRADING CO.",
    "000B05": "Pacific Broadband Networks",
    "000B00": "FUJIAN START COMPUTER EQUIPMENT CO.",
    "000B29": "LS(LG) Industrial Systems co.",
    "000B20": "Hirata corporation",
    "000B22": "Environmental Systems and Services",
    "000B1B": "Systronix",
    "000A88": "InCypher S.A.",
    "000A7C": "Tecton Ltd",
    "000A6E": "Harmonic",
    "000A6D": "EKS Elektronikservice GmbH",
    "000A4B": "DataPower Technology",
    "000A43": "Chunghwa Telecom Co.",
    "000A45": "Audio-Technica Corp.",
    "000A35": "Xilinx",
    "000A3B": "GCT Semiconductor",
    "000A1E": "Red-M Products Limited",
    "000A14": "TECO a.s.",
    "000A0B": "Sealevel Systems",
    "000A10": "FAST media integrations AG",
    "000A74": "Manticom Networks Inc.",
    "000A6F": "ZyFLEX Technologies Inc",
    "000A63": "DHD GmbH",
    "000A67": "OngCorp",
    "000A90": "Bayside Interactive",
    "000A9D": "King Young Technology Co. Ltd.",
    "000A33": "Emulex Corporation",
    "000A2E": "MAPLE NETWORKS CO.",
    "000A2D": "Cabot Communications Limited",
    "000A25": "CERAGON NETWORKS",
    "000A21": "Integra Telecom Co. Ltd",
    "000A8B": "Cisco Systems",
    "0009FB": "Philips Patient Monitoring",
    "00098F": "Cetacean Networks",
    "000986": "Metalink LTD.",
    "000987": "NISHI NIPPON ELECTRIC WIRE & CABLE CO.",
    "000989": "VividLogic Inc.",
    "00098C": "Option Wireless Sweden",
    "000985": "Auto Telecom Company",
    "00098D": "Velocity Semiconductor",
    "000981": "Newport Networks",
    "000984": "MyCasa Network Inc.",
    "0009A3": "Leadfly Techologies Corp. Ltd.",
    "0009A5": "HANSUNG ELETRONIC INDUSTRIES DEVELOPMENT CO.",
    "00099A": "ELMO COMPANY",
    "00099C": "Naval Research Laboratory",
    "0009D7": "DC Security Products",
    "0009D8": "Fält Communications AB",
    "0009DB": "eSpace",
    "0009D5": "Signal Communication",
    "0009D3": "Western DataCom Co.",
    "0009BC": "Utility",
    "0009BE": "Mamiya-OP Co.",
    "000992": "InterEpoch Technology",
    "000995": "Castle Technology Ltd",
    "000998": "Capinfo Company Limited",
    "0009F9": "ART JAPAN CO.",
    "0009FD": "Ubinetics Limited",
    "0009E6": "Cyber Switching Inc.",
    "0009E2": "Sinbon Electronics Co.",
    "0009DA": "Control Module Inc.",
    "0009B6": "Cisco Systems",
    "0009B3": "MCM Systems Ltd",
    "00094A": "Homenet Communications",
    "00094B": "FillFactory NV",
    "00094D": "Braintree Communications Pty Ltd",
    "000950": "Independent Storage Corporation",
    "000954": "AMiT spol. s. r. o.",
    "000952": "Auerswald GmbH & Co. KG",
    "000944": "Cisco Systems",
    "00092C": "Hitpoint Inc.",
    "00092B": "iQstor Networks",
    "000926": "YODA COMMUNICATIONS",
    "000927": "TOYOKEIKI CO.",
    "000923": "Heaman System Co.",
    "00091D": "Proteam Computer Corporation",
    "00095C": "Philips Medical Systems - Cardiac and Monitoring Systems (CM",
    "000958": "INTELNET S.A.",
    "000955": "Young Generation International Corp.",
    "000909": "Telenor Connect A/S",
    "00090A": "SnedFar Technology Co.",
    "000903": "Panasas",
    "000907": "Chrysalis Development",
    "000906": "Esteem Networks",
    "0008FB": "SonoSite",
    "000962": "Sonitor Technologies AS",
    "00095D": "Dialogue Technology Corp.",
    "000917": "WEM Technology Inc",
    "00087E": "Bon Electro-Telecom Inc.",
    "000880": "BroadTel Canada Communications inc.",
    "00086D": "Missouri FreeNet",
    "00086A": "Securiton Gmbh",
    "0008D4": "IneoQuest Technologies",
    "0008D6": "HASSNET Inc.",
    "0008CE": "IPMobileNet Inc.",
    "0008C2": "Cisco Systems",
    "0008C0": "ASA SYSTEMS",
    "000881": "DIGITAL HANDS CO.",
    "000882": "SIGMA CORPORATION",
    "000873": "DapTechnology B.V.",
    "00087A": "Wipotec GmbH",
    "000871": "NORTHDATA Co.",
    "0008B2": "SHENZHEN COMPASS TECHNOLOGY DEVELOPMENT CO.",
    "0008B1": "ProQuent Systems",
    "0008AF": "Novatec Corporation",
    "0008A6": "Multiware & Image Co.",
    "0008EE": "Logic Product Development",
    "0008EB": "ROMWin Co.",
    "0008E8": "Excel Master Ltd.",
    "0008DC": "Wiznet",
    "000863": "Entrisphere Inc.",
    "000866": "DSX Access Systems",
    "00085F": "Picanol N.V.",
    "000852": "Davolink Co. Inc.",
    "0008A3": "Cisco Systems",
    "00089E": "Beijing Enter-Net co.LTD",
    "00088E": "Nihon Computer Co.",
    "0008DD": "Telena Communications",
    "0008E1": "Barix AG",
    "0008DA": "SofaWare Technologies Ltd.",
    "0008B4": "SYSPOL",
    "0008B3": "Fastwel",
    "0007DD": "Cradle Technologies",
    "0007D5": "3e Technologies Int;.",
    "0007DB": "Kirana Networks",
    "0007D1": "Spectrum Signal Processing Inc.",
    "0007B4": "Cisco Systems",
    "0007EF": "Lockheed Martin Tactical Systems",
    "0007F4": "Eletex Co.",
    "0007B3": "Cisco Systems",
    "0007B5": "Any One Wireless Ltd.",
    "0007A2": "Opteon Corporation",
    "0007B9": "Ginganet Corporation",
    "00047F": "Chr. Mayr GmbH & Co. KG",
    "00047B": "Schlumberger",
    "00080C": "VDA Group S.p.a.",
    "000804": "ICA Inc.",
    "0007FF": "Gluon Networks",
    "000829": "TOKYO ELECTRON DEVICE NAGASAKI LIMITED",
    "00081B": "Windigo Systems",
    "000857": "Polaris Networks",
    "0007F7": "Galtronics",
    "00074B": "Daihen Corporation",
    "00074A": "Carl Valentin GmbH",
    "00073C": "Telecom Design",
    "000736": "Data Video Technologies Co.",
    "00078B": "Wegener Communications",
    "000783": "SynCom Network",
    "000789": "Allradio Co.",
    "000787": "Idea System Co.",
    "000785": "Cisco Systems",
    "000755": "Lafon",
    "000759": "Boris Manufacturing Corp.",
    "000751": "m-u-t AG",
    "000750": "Cisco Systems",
    "000742": "Ormazabal",
    "000738": "Young Technology Co.",
    "000729": "Kistler Instrumente AG",
    "00072A": "Innovance Networks",
    "000775": "Valence Semiconductor",
    "00077F": "J Communications Co.",
    "000771": "Embedded System Corporation",
    "000770": "Ubiquoss Inc",
    "00070D": "Cisco Systems",
    "00070E": "Cisco Systems",
    "00070B": "Novabase SGPS",
    "000710": "Adax",
    "000764": "YoungWoo Telecom Co. Ltd.",
    "000766": "Chou Chin Industrial Co.",
    "761": "2953",
    "000793": "Shin Satellite Public Company Limited",
    "000796": "LSI Systems",
    "000719": "Mobiis Co.",
    "0006C4": "Piolink Inc.",
    "0006B5": "Source Photonics",
    "0006A5": "PINON Corp.",
    "00069D": "Petards Ltd",
    "0006F8": "The Boeing Company",
    "0006FB": "Hitachi Printing Solutions",
    "0006FC": "Fnet Co.",
    "0006F4": "Prime Electronics & Satellitics Inc.",
    "0006EE": "Shenyang Neu-era Information & Technology Stock Co.",
    "0006E8": "Optical Network Testing",
    "0006BF": "Accella Technologies Co.",
    "0006BA": "Westwave Communications",
    "0006BE": "Baumer Optronic GmbH",
    "0006DA": "ITRAN Communications Ltd.",
    "0006D0": "Elgar Electronics Corp.",
    "0006CC": "JMI Electronics Co.",
    "0006E2": "Ceemax Technology Co.",
    "0006E1": "Techno Trade s.a",
    "000690": "Euracom Communication GmbH",
    "0006A8": "KC Technology",
    "0006A0": "Mx Imaging",
    "00067E": "WinCom Systems",
    "000630": "Adtranz Sweden",
    "000637": "Toptrend-Meta Information (ShenZhen) Inc.",
    "00062E": "Aristos Logic Corp.",
    "000625": "The Linksys Group",
    "000627": "Uniwide Technologies",
    "000624": "Gentner Communications Corp.",
    "00062C": "Bivio Networks",
    "000660": "NADEX Co.",
    "00064E": "Broad Net Technology Inc.",
    "00062D": "TouchStar Technologies",
    "000646": "ShenZhen XunBao Network Technology Co Ltd",
    "00064B": "Alexon Co.",
    "0005FD": "PacketLight Networks Ltd.",
    "0005E4": "Red Lion Controls Inc.",
    "0005F2": "Power R",
    "0005F3": "Webyn",
    "000601": "Otanikeiki Co.",
    "0005DF": "Electronic Innovation",
    "0005E0": "Empirix Corp.",
    "000621": "Hinox",
    "00061C": "Hoshino Metal Industries",
    "000623": "MGE UPS Systems France",
    "00060B": "Artesyn Embedded Technologies",
    "000605": "Inncom International",
    "0005FA": "IPOptical",
    "0005E5": "Renishaw PLC",
    "0005F5": "Geospace Technologies",
    "00066C": "Robinson Corporation",
    "000666": "Roving Networks",
    "000667": "Tripp Lite",
    "000615": "Kimoto Electric Co.",
    "00060A": "Blue2space",
    "00063C": "Intrinsyc Software International Inc.",
    "000677": "SICK AG",
    "000679": "Konami Corporation",
    "000566": "Secui.com Corporation",
    "00056C": "Hung Chang Co.",
    "00055F": "Cisco Systems",
    "00055D": "D-LINK SYSTEMS",
    "000561": "nac Image Technology",
    "000563": "J-Works",
    "000557": "Agile TV Corporation",
    "00055B": "Charles Industries",
    "000554": "Rangestar Wireless",
    "000553": "DVC Company",
    "00054B": "Eaton Automation AG",
    "000583": "ImageCom Limited",
    "00056F": "Innomedia Technologies Pvt. Ltd.",
    "000574": "Cisco Systems",
    "000567": "Etymonic Design",
    "000565": "Tailyn Communication Company Ltd.",
    "0005CE": "Prolink Microsystems Corporation",
    "0005C2": "Soronti",
    "00057C": "RCO Security AB",
    "0005D8": "Arescom",
    "0005DE": "Gi Fone Korea",
    "0005C4": "Telect",
    "0005D4": "FutureSmart Networks",
    "00058E": "Flextronics International GmbH & Co. Nfg. KG",
    "000594": "HMS Industrial Networks",
    "00059D": "Daniel Computing Systems",
    "0005A4": "Lucid Voice Ltd.",
    "0005B3": "Asahi-Engineering Co.",
    "0005A5": "KOTT",
    "0005A3": "QEI",
    "00059E": "Zinwell Corporation",
    "0004F6": "Amphus",
    "0004F4": "Infinite Electronics Inc.",
    "0004F1": "WhereNet",
    "000537": "Nets Technology Co.",
    "000532": "Cisco Systems",
    "000536": "Danam Communications",
    "000521": "Control Microsystems",
    "00051F": "Taijin Media Co.",
    "000523": "AVL List GmbH",
    "0004EC": "Memobox SA",
    "0004E4": "Daeryung Ind.",
    "0004E2": "SMC Networks",
    "00050C": "Network Photonics",
    "000511": "Complementary Technologies Ltd",
    "000506": "Reddo Networks AB",
    "00050A": "ICS Spa",
    "000542": "Otari",
    "000526": "IPAS GmbH",
    "00042F": "International Communications Products",
    "000429": "Pixord Corporation",
    "000426": "Autosys",
    "000421": "Ocular Networks",
    "000424": "TMC s.r.l.",
    "00041D": "Corega of America",
    "00041A": "Ines Test and Measurement GmbH & CoKG",
    "00041E": "Shikoku Instrumentation Co.",
    "0004CB": "Tdsoft Communication",
    "0004CC": "Peek Traffic B.V.",
    "0004C8": "LIBA Maschinenfabrik GmbH",
    "0004BF": "VersaLogic Corp.",
    "000451": "Medrad",
    "000453": "YottaYotta",
    "000450": "DMD Computers SRL",
    "000443": "Agilent Technologies",
    "000449": "Mapletree Networks",
    "00045A": "The Linksys Group",
    "000463": "Bosch Security Systems",
    "00045C": "Mobiwave Pte Ltd",
    "000415": "Rasteme Systems Co.",
    "000403": "Nexsi Corporation",
    "000406": "Fa. Metabox AG",
    "0004C3": "CASTOR Informatique",
    "0004B1": "Signal Technology",
    "0004B5": "Equitrac Corporation",
    "000483": "Deltron Technology",
    "000482": "Medialogic Corp.",
    "000467": "Wuhan Research Institute of MII",
    "000441": "Half Dome Systems",
    "0003C7": "hopf Elektronik GmbH",
    "0003C2": "Solphone K.K.",
    "0003C6": "ICUE Systems",
    "0003BB": "Signal Communications Limited",
    "0003BE": "Netility",
    "0003F3": "Dazzle Multimedia",
    "0003EC": "ICG Research",
    "0003E9": "Akara Canada",
    "0003E5": "Hermstedt SG",
    "0003E8": "Wavesight Limited",
    "000397": "FireBrick Limited",
    "000398": "WISI",
    "00039E": "Tera System Co.",
    "000392": "Hyundai Teletek Co.",
    "000395": "California Amplifier",
    "0003B4": "Macrotek International Corp.",
    "0003A6": "Traxit Technology",
    "0003A4": "Imation Corp.",
    "0003AB": "Bridge Information Systems",
    "0003F8": "SanCastle Technologies",
    "0003FA": "TiMetra Networks",
    "0003FB": "ENEGATE Co.",
    "0003F6": "Allegro Networks",
    "0003CA": "MTS Systems Corp.",
    "0003CB": "SystemGear Co.",
    "0003DF": "Desana Systems",
    "0003DA": "Takamisawa Cybernetics Co.",
    "0003D9": "Secheron SA",
    "00037F": "Atheros Communications",
    "0002F0": "AME Optimedia Technology Co.",
    "00038E": "Atoga Systems",
    "00037C": "Coax Media",
    "00030D": "Uniwill Computer Corp.",
    "000309": "Texcel Technology PLC",
    "000303": "JAMA Electronics Co.",
    "000305": "MSC Vertriebs GmbH",
    "0002FE": "Viditec",
    "00019F": "ReadyNet",
    "0002FF": "Handan BroadInfoCom",
    "000327": "HMS Industrial Networks",
    "00032E": "Scope Information Management",
    "000329": "F3",
    "000321": "Reco Research Co.",
    "000316": "Nobell Communications",
    "00030F": "Digital China (Shanghai) Networks Ltd.",
    "000311": "Micro Technology Co.",
    "00031A": "Beijing Broad Telecom Ltd.",
    "00035B": "BridgeWave Communications",
    "000357": "Intervoice-Brite",
    "000345": "Routrek Networks Corporation",
    "0002E9": "CS Systemes De Securite - C3S",
    "0002E5": "Timeware Ltd.",
    "0002E0": "ETAS GmbH",
    "00033F": "BigBand Networks",
    "000368": "Embedone Co.",
    "0002F5": "VIVE Synergies",
    "0002B7": "Watanabe Electric Industry Co.",
    "0002AF": "TeleCruz Technology",
    "0002A8": "Air Link Technology",
    "0002AB": "CTC Union Technologies Co.",
    "0002A4": "AddPac Technology Co.",
    "0002A3": "Hitachi Energy Switzerland Ltd",
    "0002A0": "Flatstack Ltd.",
    "0002C3": "Arelnet Ltd.",
    "0002C8": "Technocom Communications Technology (pte) Ltd",
    "0002B8": "WHI KONSULT AB",
    "0002BB": "Continuous Computing Corp",
    "0002BC": "LVL 7 Systems",
    "0002A9": "RACOM",
    "0002B2": "Cablevision",
    "00025B": "Cambridge Silicon Radio",
    "000256": "Alpha Processor",
    "000259": "Tsann Kuen China (Shanghai)Enterprise Co.",
    "000251": "Soma Networks",
    "00026A": "Cocess Telecom Co.",
    "00026C": "Philips CFT",
    "000262": "Soyo Group Soyo Com Tech Co.",
    "000265": "Virditech Co. Ltd.",
    "00028A": "Ambit Microsystems Corporation",
    "0001FA": "HOROSCAS",
    "000282": "ViaClix",
    "000285": "Riverstone Networks",
    "000294": "Tokyo Sokushin Co.",
    "000296": "Lectron Co",
    "00028E": "Rapid 5 Networks",
    "000279": "Control Applications",
    "00024F": "IPM Datacom S.R.L.",
    "00023C": "Creative Technology",
    "00022C": "ABB Bomem",
    "0002D5": "ACR",
    "0002CE": "FoxJet",
    "0001E1": "Kinpo Electronics",
    "0001DA": "WINCOMM Corporation",
    "0001D2": "inXtron",
    "0001C6": "Quarry Technologies",
    "0001FF": "Data Direct Networks",
    "0001FC": "Keyence Corporation",
    "0001FD": "Digital Voice Systems",
    "0001EE": "Comtrol Europe",
    "0001F0": "Tridium",
    "0001F1": "Innovative Concepts",
    "00022F": "P-Cube",
    "000227": "ESD Electronic System Design GmbH",
    "00021D": "Data General Communication Ltd.",
    "000219": "Paralon Technologies",
    "000210": "Fenecom",
    "00020B": "Native Networks",
    "000218": "Advanced Scientific Corp",
    "000203": "Woonsang Telecom",
    "0001F5": "ERIM S.A.",
    "0001CE": "Custom Micro Products",
    "0001BB": "Frequentis",
    "0001BC": "Brains Corporation",
    "0001C0": "CompuLab",
    "0001A0": "Infinilink Corporation",
    "000196": "Cisco Systems",
    "00017C": "AG-E GmbH",
    "0001E2": "Ando Electric Corporation",
    "0001D3": "PAXCOMM",
    "000199": "HeiSei Electronics",
    "000172": "TechnoLand Co.",
    "00306C": "Hitex Holding GmbH",
    "00308B": "Brix Networks",
    "000177": "EDSL",
    "00014D": "Shin Kin Enterprises Co.",
    "000110": "Gotham Networks",
    "000112": "Shark Multimedia Inc.",
    "000116": "Netspect Technologies",
    "000108": "AVLAB Technology",
    "00062B": "INTRASERVER TECHNOLOGY",
    "000100": "EQUIP'TRANS",
    "00B09D": "Point Grey Research Inc.",
    "00B06D": "Jones Futurex Inc.",
    "00016E": "Conklin Corporation",
    "000174": "CyberOptics Corporation",
    "00015E": "BEST TECHNOLOGY CO.",
    "000161": "Meta Machine Technology",
    "000155": "Promise Technology",
    "00011E": "Precidia Technologies",
    "000113": "OLYMPUS CORPORATION",
    "00019D": "E-Control Systems",
    "00018B": "NetLinks Co.",
    "00018D": "AudeSi Technologies",
    "0001A1": "Mag-Tek",
    "000186": "Uwe Disch",
    "0001A6": "Scientific-Atlanta Arcodan A/S",
    "00012E": "PC Partner Ltd.",
    "00013E": "Ascom Tateco AB",
    "000132": "Dranetz - BMI",
    "00013B": "BNA SYSTEMS",
    "000134": "Selectron Systems AG",
    "003032": "MagicRam",
    "0030EA": "TeraForce Technology Corporation",
    "003069": "IMPACCT TECHNOLOGY CORP.",
    "0030C3": "FLUECKIGER ELEKTRONIK AG",
    "00305A": "TELGEN CORPORATION",
    "00308A": "NICOTRA SISTEMI S.P.A",
    "003072": "Intellibyte Inc.",
    "003006": "SUPERPOWER COMPUTER",
    "003038": "XCP",
    "003079": "CQOS",
    "00309B": "Smartware",
    "003045": "Village Networks",
    "0030E5": "Amper Datos S.A.",
    "003094": "Cisco Systems",
    "003040": "Cisco Systems",
    "00B094": "Alaris",
    "0030F0": "Uniform Industrial Corp.",
    "0030C9": "LuxN",
    "003010": "VISIONETICS INTERNATIONAL",
    "003017": "BlueArc UK Ltd",
    "0030F7": "RAMIX INC.",
    "0030D0": "Tellabs",
    "003014": "DIVIO",
    "00300C": "CONGRUENCY",
    "00304C": "APPIAN COMMUNICATIONS",
    "003028": "FASE Saldatura srl",
    "0030E8": "ENSIM CORP.",
    "0030D9": "DATACORE SOFTWARE CORP.",
    "003026": "HeiTel Digital Video GmbH",
    "003047": "NISSEI ELECTRIC CO.",
    "003077": "ONPREM NETWORKS",
    "0030D4": "AAE Systems",
    "00D0D7": "B2C2",
    "00D073": "ACN ADVANCED COMMUNICATIONS",
    "00D057": "ULTRAK",
    "00D0E5": "SOLIDUM SYSTEMS CORP.",
    "00D036": "TECHNOLOGY ATLANTA CORP.",
    "00D0E3": "ELE-CHEM ENGINEERING CO.",
    "00D0C4": "TERATECH CORPORATION",
    "00D045": "KVASER AB",
    "00D004": "PENTACOM LTD.",
    "00D005": "ZHS ZEITMANAGEMENTSYSTEME",
    "00301C": "ALTVATER AIRDATA SYSTEMS",
    "003080": "Cisco Systems",
    "003081": "ALTOS C&C",
    "00D0D3": "Cisco Systems",
    "00D017": "SYNTECH INFORMATION CO.",
    "00D061": "TREMON ENTERPRISES CO.",
    "00D026": "HIRSCHMANN AUSTRIA GMBH",
    "0030AB": "DELTA NETWORKS",
    "003049": "BRYANT TECHNOLOGY",
    "00306D": "LUCENT TECHNOLOGIES",
    "00D0F0": "CONVISION TECHNOLOGY GMBH",
    "00D010": "CONVERGENT NETWORKS",
    "00D04B": "LA CIE GROUP S.A.",
    "00D00E": "PLURIS",
    "00D012": "GATEWORKS CORP.",
    "00D04D": "DIV OF RESEARCH & STATISTICS",
    "00D02E": "COMMUNICATION AUTOMATION CORP.",
    "00D0C5": "COMPUTATIONAL SYSTEMS",
    "00D046": "DOLBY LABORATORIES",
    "00D0DE": "PHILIPS MULTIMEDIA NETWORK",
    "00D00C": "SNIJDER MICRO SYSTEMS",
    "00D0DA": "TAICOM DATA SYSTEMS CO.",
    "00D01E": "PINGTEL CORP.",
    "00D065": "TOKO ELECTRIC",
    "00D014": "ROOT",
    "00D0CA": "Intrinsyc Software International Inc.",
    "00D023": "INFORTREND TECHNOLOGY",
    "00D03C": "Vieo",
    "00D0B4": "KATSUJIMA CO.",
    "00D086": "FOVEON",
    "00D0E8": "MAC SYSTEM CO.",
    "00D06B": "SR TELECOM INC.",
    "00D0A8": "NETWORK ENGINES",
    "00D0AB": "DELTAKABEL TELECOM CV",
    "00D01D": "FURUNO ELECTRIC CO.",
    "00D0A2": "INTEGRATED DEVICE",
    "00D09A": "FILANET CORPORATION",
    "00D0AE": "ORESIS COMMUNICATIONS",
    "00D0F2": "MONTEREY NETWORKS",
    "0050A7": "Cisco Systems",
    "00D06C": "SHAREWAVE",
    "00D0EE": "DICTAPHONE CORPORATION",
    "00D0DC": "MODULAR MINING SYSTEMS",
    "00D0A7": "TOKYO SOKKI KENKYUJO CO.",
    "00D034": "ORMEC SYSTEMS CORP.",
    "00D08A": "PHOTRON USA",
    "005036": "NETCAM",
    "005083": "GILBARCO",
    "0050DC": "TAS TELEFONBAU A. SCHWABE GMBH & CO. KG",
    "005008": "TIVA MICROCOMPUTER CORP. (TMC)",
    "0050CC": "Seagate Cloud Systems Inc",
    "005016": "Molex Canada Ltd",
    "00504C": "Galil Motion Control",
    "005076": "IBM Corp",
    "0050D4": "JOOHONG INFORMATION &",
    "0050A6": "OPTRONICS",
    "0050DB": "CONTEMPORARY CONTROL",
    "00507C": "VIDEOCON AG",
    "005047": "Private",
    "005084": "Quantum Corp.",
    "0050A9": "MOLDAT WIRELESS TECHNOLGIES",
    "00509B": "SWITCHCORE AB",
    "00507E": "NEWER TECHNOLOGY",
    "005055": "DOMS A/S",
    "005072": "CORVIS CORPORATION",
    "0050CE": "LG INTERNATIONAL CORP.",
    "0050F7": "VENTURE MANUFACTURING (SINGAPORE) LTD.",
    "005019": "SPRING TIDE NETWORKS",
    "00501F": "MRG SYSTEMS",
    "005043": "MARVELL SEMICONDUCTOR",
    "0050FA": "OXTEL",
    "00501B": "ABL CANADA",
    "0050FD": "VISIONCOMM CO.",
    "0050BF": "Metalligence Technology Corp.",
    "0050B8": "INOVA COMPUTERS GMBH & CO. KG",
    "00505B": "KAWASAKI LSI U.S.A.",
    "009038": "FOUNTAIN TECHNOLOGIES",
    "0090B0": "VADEM",
    "0090EF": "INTEGRIX",
    "0090C5": "INTERNET MAGIC",
    "00908C": "ETREND ELECTRONICS",
    "009048": "ZEAL CORPORATION",
    "009007": "DOMEX TECHNOLOGY CORP.",
    "005052": "TIARA NETWORKS",
    "005064": "CAE ELECTRONICS",
    "005027": "GENICOM CORPORATION",
    "00505A": "NETWORK ALCHEMY",
    "005039": "MARINER NETWORKS",
    "005095": "PERACOM NETWORKS",
    "00903D": "BIOPAC SYSTEMS",
    "009057": "AANetcom",
    "009083": "TURBO COMMUNICATION",
    "009000": "DIAMOND MULTIMEDIA",
    "009054": "INNOVATIVE SEMICONDUCTORS",
    "00906E": "PRAXON",
    "0090C0": "K.J. LAW ENGINEERS",
    "0090C4": "JAVELIN SYSTEMS",
    "0090B9": "BERAN INSTRUMENTS LTD.",
    "0090A5": "SPECTRA LOGIC",
    "0090A3": "Corecess Inc.",
    "009029": "CRYPTO AG",
    "00902D": "DATA ELECTRONICS (AUST.) PTY",
    "0090D4": "BindView Development Corp.",
    "0090D7": "NetBoost Corp.",
    "00901F": "ADTEC PRODUCTIONS",
    "009082": "FORCE INSTITUTE",
    "009041": "APPLIED DIGITAL ACCESS",
    "009024": "PIPELINKS",
    "00903A": "NIHON MEDIA TOOL INC.",
    "0090B2": "AVICI SYSTEMS INC.",
    "0090B6": "FIBEX SYSTEMS",
    "009063": "COHERENT COMMUNICATIONS SYSTEMS CORPORATION",
    "009011": "WAVTrace",
    "009065": "FINISAR CORPORATION",
    "0010D3": "GRIPS ELECTRONIC GMBH",
    "0010FB": "ZIDA TECHNOLOGIES LIMITED",
    "009062": "ICP VORTEX COMPUTERSYSTEME GmbH",
    "0090C3": "TOPIC SEMICONDUCTOR CORP.",
    "00905A": "DEARBORN GROUP",
    "0090EC": "PYRESCOM",
    "001053": "COMPUTER TECHNOLOGY CORP.",
    "0010ED": "SUNDANCE TECHNOLOGY",
    "00109D": "CLARINET SYSTEMS",
    "00100E": "MICRO LINEAR COPORATION",
    "00900B": "LANNER ELECTRONICS",
    "009061": "PACIFIC RESEARCH & ENGINEERING CORPORATION",
    "0090CE": "avateramedical Mechatronics GmbH",
    "00106C": "EDNT GmbH",
    "0010E9": "RAIDTEC LTD.",
    "001003": "IMATRON",
    "001071": "ADVANET INC.",
    "0090A8": "NineTiles Networks",
    "009015": "CENTIGRAM COMMUNICATIONS CORP.",
    "009095": "UNIVERSAL AVIONICS",
    "0090DF": "MITSUBISHI CHEMICAL AMERICA",
    "0090F6": "ESCALATE NETWORKS",
    "00102A": "ZF MICROSYSTEMS",
    "0010E5": "SOLECTRON TEXAS",
    "00103F": "TOLLGRADE COMMUNICATIONS",
    "0010CD": "INTERFACE CONCEPT",
    "001056": "SODICK CO.",
    "001061": "HOSTLINK CORP.",
    "001099": "InnoMedia",
    "0010C8": "COMMUNICATIONS ELECTRONICS SECURITY GROUP",
    "001086": "ATTO Technology",
    "0010F3": "Nexcom International Co.",
    "0010DF": "RISE COMPUTER INC.",
    "001072": "GVN TECHNOLOGIES",
    "0010DA": "Kollmorgen Corp",
    "0010E4": "NSI CORPORATION",
    "001088": "AMERICAN NETWORKS INC.",
    "001022": "SatCom Media Corporation",
    "0010A0": "INNOVEX TECHNOLOGIES",
    "001016": "T.SQWARE",
    "001090": "CIMETRICS",
    "0010F5": "AMHERST SYSTEMS",
    "00103D": "PHASECOM",
    "0010EA": "ADEPT TECHNOLOGY",
    "0010AE": "SHINKO ELECTRIC INDUSTRIES CO.",
    "001096": "TRACEWELL SYSTEMS",
    "001082": "JNA TELECOMMUNICATIONS LIMITED",
    "001098": "STARNET TECHNOLOGIES",
    "001068": "COMOS TELECOM",
    "001042": "Alacritech",
    "001049": "ShoreTel",
    "00105E": "Spirent plc",
    "0010AF": "TAC SYSTEMS",
    "00108C": "Fujitsu Services Ltd",
    "0010E1": "S.I. TECH",
    "0010BB": "DATA & INFORMATION TECHNOLOGY",
    "001020": "Hand Held Products Inc",
    "00107E": "BACHMANN ELECTRONIC GmbH",
    "00103A": "DIAMOND NETWORK TECH",
    "001004": "THE BRANTLEY COILE COMPANY",
    "0010EF": "DBTEL INCORPORATED",
    "001076": "EUREM GmbH",
    "0010C4": "MEDIA GLOBAL LINKS CO.",
    "0010FE": "DIGITAL EQUIPMENT CORPORATION",
    "0010BC": "Aastra Telecom",
    "001058": "ArrowPoint Communications",
    "00100F": "INDUSTRIAL CPU SYSTEMS",
    "0010F7": "IRIICHI TECHNOLOGIES Inc.",
    "0010AB": "KOITO ELECTRIC INDUSTRIES",
    "001010": "INITIO CORPORATION",
    "0010F2": "ANTEC",
    "00E007": "Avaya ECS Ltd",
    "0010BE": "MARCH NETWORKS CORPORATION",
    "00E0D3": "DATENTECHNIK GmbH",
    "00E043": "VitalCom",
    "00E0B3": "EtherWAN Systems",
    "00E0ED": "SILICOM",
    "00E0BF": "TORRENT NETWORKING TECHNOLOGIES CORP.",
    "00E0E3": "SK-ELEKTRONIK GMBH",
    "00E0C6": "LINK2IT",
    "00E0E5": "CINCO NETWORKS",
    "00E045": "TOUCHWAVE",
    "00E040": "DeskStation Technology",
    "00E01A": "COMTEC SYSTEMS. CO.",
    "00E081": "TYAN COMPUTER CORP.",
    "00E057": "HAN MICROTELECOM. CO.",
    "00E061": "EdgePoint Networks",
    "00E0B8": "GATEWAY 2000",
    "00E07C": "METTLER-TOLEDO",
    "00E026": "Redlake MASD LLC",
    "00E020": "TECNOMEN OY",
    "00E00D": "RADIANT SYSTEMS",
    "00E0DC": "NEXWARE CORP.",
    "00E037": "CENTURY CORPORATION",
    "00E0C2": "NECSY S.p.A.",
    "00E09B": "ENGAGE NETWORKS",
    "00E0FB": "LEIGHTRONIX",
    "00E053": "CELLPORT LABS",
    "00E0BC": "SYMON COMMUNICATIONS",
    "00E07E": "WALT DISNEY IMAGINEERING",
    "00E0B2": "TELMAX COMMUNICATIONS CORP.",
    "00E0EC": "CELESTICA INC.",
    "00E06C": "Ultra Electronics Command & Control Systems",
    "00601D": "LUCENT TECHNOLOGIES",
    "00607B": "FORE SYSTEMS",
    "00E087": "LeCroy - Networking Productions Division",
    "00E041": "CSPI",
    "00E0E2": "INNOVA CORP.",
    "00E082": "ANERMA",
    "0060C9": "ControlNet",
    "00605F": "NIPPON UNISOFT CORPORATION",
    "006091": "FIRST PACIFIC NETWORKS",
    "00E077": "WEBGEAR",
    "00E056": "HOLONTECH CORPORATION",
    "00E02F": "MCNS HOLDINGS",
    "00E031": "HAGIWARA ELECTRIC CO.",
    "00E00B": "ROOFTOP COMMUNICATIONS CORP.",
    "00E099": "SAMSON AG",
    "00E078": "BERKELEY NETWORKS",
    "00E04A": "ZX Technologies",
    "00E07A": "MIKRODIDAKT AB",
    "0060D8": "ELMIC SYSTEMS",
    "0060EF": "FLYTECH TECHNOLOGY CO.",
    "006085": "Storage Concepts",
    "006011": "CRYSTAL SEMICONDUCTOR CORP.",
    "0060FA": "EDUCATIONAL TECHNOLOGY RESOURCES",
    "0060DA": "Red Lion Controls",
    "006056": "NETWORK TOOLS",
    "00600C": "Eurotech Inc.",
    "006032": "I-CUBE",
    "006033": "ACUITY IMAGING",
    "006013": "NETSTAL MASCHINEN AG",
    "006022": "VICOM SYSTEMS",
    "0060EE": "APOLLO",
    "000288": "GLOBAL VILLAGE COMMUNICATION",
    "006034": "ROBERT BOSCH GmbH",
    "006050": "INTERNIX INC.",
    "0060E0": "AXIOM TECHNOLOGY CO.",
    "006096": "T.S. MICROTECH INC.",
    "006043": "iDirect",
    "00603A": "QUICK CONTROLS LTD.",
    "006028": "MACROVISION CORPORATION",
    "0060F0": "JOHNSON & JOHNSON MEDICAL",
    "0060F5": "ICON WEST",
    "006062": "TELESYNC",
    "00601C": "TELXON CORPORATION",
    "0060AE": "TRIO INFORMATION SYSTEMS AB",
    "006053": "TOYODA MACHINE WORKS",
    "0060E4": "COMPUSERVE",
    "00608F": "TEKRAM TECHNOLOGY CO.",
    "0060C4": "SOLITON SYSTEMS K.K.",
    "0060A6": "PARTICLE MEASURING SYSTEMS",
    "00602A": "SYMICRON COMPUTER COMMUNICATIONS",
    "00A037": "Mindray DS USA",
    "00A04C": "INNOVATIVE SYSTEMS & TECHNOLOGIES",
    "00A031": "HAZELTINE CORPORATION",
    "00A041": "INFICON",
    "00A03C": "EG&G NUCLEAR INSTRUMENTS",
    "00A0C4": "CRISTIE ELECTRONICS LTD.",
    "00A063": "JRL SYSTEMS",
    "00A02C": "interWAVE Communications",
    "00A0F7": "V.I COMPUTER CORP.",
    "00A090": "TimeStep Corporation",
    "00A033": "imc MeBsysteme GmbH",
    "00A0A9": "NAVTEL COMMUNICATIONS INC.",
    "00A071": "VIDEO LOTTERY TECHNOLOGIES",
    "00A06D": "MANNESMANN TALLY CORPORATION",
    "00A0F6": "AutoGas Systems Inc.",
    "00A0A7": "VORAX CORPORATION",
    "00A0E2": "Keisokugiken Corporation",
    "00A061": "PURITAN BENNETT",
    "006080": "MICROTRONIX DATACOM LTD.",
    "0060BE": "WEBTRONICS",
    "0060BF": "MACRAIGOR SYSTEMS",
    "00A0EA": "ETHERCOM CORP.",
    "00A0DC": "O.N. ELECTRONIC CO.",
    "00A00B": "COMPUTEX CO.",
    "006000": "XYCOM INC.",
    "006045": "PATHLIGHT TECHNOLOGIES",
    "00A05D": "CS COMPUTER SYSTEME GmbH",
    "00A01A": "BINAR ELEKTRONIK AB",
    "00A088": "ESSENTIAL COMMUNICATIONS",
    "00A0C2": "R.A. SYSTEMS CO.",
    "00A081": "ALCATEL DATA NETWORKS",
    "00A06C": "SHINDENGEN ELECTRIC MFG. CO.",
    "00A01F": "TRICORD SYSTEMS",
    "00A0FB": "Toray Engineering D Solutions Co.",
    "00A097": "JC INFORMATION SYSTEMS",
    "00A073": "COM21",
    "00A03A": "KUBOTEK CORPORATION",
    "00A0B2": "SHIMA SEIKI",
    "00A04B": "TFL LAN INC.",
    "00A064": "KVB/ANALECT",
    "00A03E": "ATM FORUM",
    "00A098": "NetApp",
    "00A0DB": "FISHER & PAYKEL PRODUCTION",
    "00A07E": "AVID TECHNOLOGY",
    "00A06F": "Color Sentinel Systems",
    "00A0C7": "TADIRAN TELECOMMUNICATIONS",
    "00A027": "FIREPOWER SYSTEMS",
    "00A046": "SCITEX CORP. LTD.",
    "00A092": "H. BOLLMANN MANUFACTURERS",
    "00A08B": "ASTON ELECTRONIC DESIGNS LTD.",
    "00200D": "CARL ZEISS",
    "00202D": "TAIYO CORPORATION",
    "002091": "J125",
    "0020BD": "NIOBRARA R & D CORPORATION",
    "002054": "Sycamore Networks",
    "0020A7": "PAIRGAIN TECHNOLOGIES",
    "002072": "WORKLINK INNOVATIONS",
    "002010": "JEOL SYSTEM TECHNOLOGY CO. LTD",
    "00209F": "MERCURY COMPUTER SYSTEMS",
    "0020CB": "PRETEC ELECTRONICS CORP.",
    "0020EB": "CINCINNATI MICROWAVE",
    "0020A0": "OA LABORATORY CO.",
    "002075": "MOTOROLA COMMUNICATION ISRAEL",
    "0020A5": "API ENGINEERING",
    "002064": "PROTEC MICROSYSTEMS",
    "002033": "SYNAPSE TECHNOLOGIES",
    "0020EA": "EFFICIENT NETWORKS",
    "0020CF": "TEST & MEASUREMENT SYSTEMS INC",
    "0020B4": "TERMA ELEKTRONIK AS",
    "0020E4": "HSING TECH ENTERPRISE CO.",
    "0020A2": "GALCOM NETWORKING LTD.",
    "002031": "Tattile SRL",
    "0020E2": "INFORMATION RESOURCE ENGINEERING",
    "002007": "SFA",
    "00205C": "InterNet Systems of Florida",
    "002055": "ALTECH CO.",
    "00200A": "SOURCE-COMM CORP.",
    "0020D0": "VERSALYNX CORPORATION",
    "00206C": "EVERGREEN TECHNOLOGY CORP.",
    "00205E": "CASTLE ROCK",
    "002012": "CAMTRONICS MEDICAL SYSTEMS",
    "00A0B1": "FIRST VIRTUAL CORPORATION",
    "00A0D4": "RADIOLAN",
    "0020B9": "METRICOM",
    "002039": "SCINETS",
    "0020E8": "DATATREK CORPORATION",
    "0020C5": "EAGLE TECHNOLOGY",
    "002009": "PACKARD BELL ELEC.",
    "002027": "MING FORTUNE INDUSTRY CO.",
    "00202C": "WELLTRONIX CO.",
    "002084": "OCE PRINTING SYSTEMS",
    "0020EC": "TECHWARE SYSTEMS CORP.",
    "00206E": "XACT",
    "0020F1": "ALTOS INDIA LIMITED",
    "002041": "DATA NET",
    "002076": "REUDO CORPORATION",
    "00C043": "STRATACOM",
    "00C0B5": "CORPORATE NETWORK SYSTEMS",
    "00C04B": "CREATIVE MICROSYSTEMS",
    "00208A": "SONIX COMMUNICATIONS",
    "0020D2": "RAD DATA COMMUNICATIONS",
    "002002": "SERITECH ENTERPRISE CO.",
    "00204B": "AUTOCOMPUTER CO.",
    "00208C": "GALAXY NETWORKS",
    "00C0B9": "FUNK SOFTWARE",
    "0020BB": "ZAX CORPORATION",
    "0020A8": "SAST TECHNOLOGY CORP.",
    "002045": "ION Networks",
    "002021": "ALGORITHMS SOFTWARE PVT. LTD.",
    "002049": "COMTRON",
    "002050": "KOREA COMPUTER INC.",
    "0020A6": "Proxim Wireless",
    "00206A": "OSAKA COMPUTER CORP.",
    "0020DB": "XNET TECHNOLOGY",
    "00C07F": "NUPON COMPUTING CORP.",
    "00C057": "MYCO ELECTRONICS",
    "00C056": "SOMELEC",
    "00C027": "CIPHER SYSTEMS",
    "00C05C": "ELONEX PLC",
    "00C0ED": "US ARMY ELECTRONIC",
    "00C028": "JASCO CORPORATION",
    "00C08D": "TRONIX PRODUCT DEVELOPMENT",
    "00C02A": "OHKURA ELECTRIC CO.",
    "00C0EF": "ABIT CORPORATION",
    "00C061": "SOLECTEK CORPORATION",
    "00C0AD": "MARBEN COMMUNICATION SYSTEMS",
    "00C075": "XANTE CORPORATION",
    "001C7C": "PERQ SYSTEMS CORPORATION",
    "00C039": "Teridian Semiconductor Corporation",
    "00C0A9": "BARRON MCCANN LTD.",
    "00C019": "LEAP TECHNOLOGY",
    "00C0CF": "IMATRAN VOIMA OY",
    "00C05B": "NETWORKS NORTHWEST",
    "00C008": "SECO SRL",
    "00C0B7": "AMERICAN POWER CONVERSION CORP",
    "00C0FC": "ELASTIC REALITY",
    "00C0BB": "FORVAL CREATIVE",
    "00C015": "NEW MEDIA CORPORATION",
    "00C083": "TRACE MOUNTAIN PRODUCTS",
    "00C094": "VMX INC.",
    "00C0F9": "Artesyn Embedded Technologies",
    "00C032": "I-CUBED LIMITED",
    "00C0A5": "DICKENS DATA SYSTEMS",
    "00C0D3": "OLYMPUS IMAGE SYSTEMS",
    "00C07D": "RISC DEVELOPMENTS LTD.",
    "00C0E0": "DSC COMMUNICATION CORP.",
    "00C0DA": "NICE SYSTEMS LTD.",
    "0040D9": "AMERICAN MEGATRENDS INC.",
    "004021": "RASTER GRAPHICS",
    "0040C1": "BIZERBA-WERKE WILHEIM KRAUT",
    "0040E1": "MARNER INTERNATIONAL",
    "0040FE": "SYMPLEX COMMUNICATIONS",
    "00C0E8": "PLEXCOM",
    "00C0D1": "COMTREE TECHNOLOGY CORPORATION",
    "00C038": "RASTER IMAGE PROCESSING SYSTEM",
    "00C092": "MENNEN MEDICAL INC.",
    "00C052": "BURR-BROWN",
    "0040BD": "STARLIGHT NETWORKS",
    "0040ED": "NETWORK CONTROLS INT'NATL INC.",
    "0040E5": "SYBUS CORPORATION",
    "0040A5": "CLINICOMP INTL.",
    "004005": "ANI COMMUNICATIONS INC.",
    "00C030": "INTEGRATED ENGINEERING B. V.",
    "00C0A6": "EXICOM AUSTRALIA PTY. LTD",
    "00C0CB": "CONTROL TECHNOLOGY CORPORATION",
    "00C0EB": "SEH COMPUTERTECHNIK GMBH",
    "0040DB": "ADVANCED TECHNICAL SOLUTIONS",
    "00409B": "HAL COMPUTER SYSTEMS INC.",
    "0040EB": "MARTIN MARIETTA CORPORATION",
    "0040D4": "GAGE TALKER CORP.",
    "004038": "TALENT ELECTRIC INCORPORATED",
    "0040D8": "OCEAN OFFICE AUTOMATION LTD.",
    "0040C6": "FIBERNET RESEARCH",
    "004032": "DIGITAL COMMUNICATIONS",
    "0040C2": "APPLIED COMPUTING DEVICES",
    "004088": "MOBIUS TECHNOLOGIES",
    "0080AA": "MAXPEED",
    "00C050": "TOYO DENKI SEIZO K.K.",
    "00400E": "MEMOTEC",
    "00C03D": "WIESEMANN & THEIS GMBH",
    "00404C": "HYPERTEC PTY LTD.",
    "0040C8": "MILAN TECHNOLOGY CORPORATION",
    "0040BA": "ALLIANT COMPUTER SYSTEMS CORP.",
    "0040CE": "NET-SOURCE",
    "004050": "IRONICS",
    "004047": "WIND RIVER SYSTEMS",
    "00401C": "AST RESEARCH",
    "00400F": "DATACOM TECHNOLOGIES",
    "004006": "SAMPO TECHNOLOGY CORPORATION",
    "004062": "E-SYSTEMS",
    "004034": "BUSTEK CORPORATION",
    "00804E": "APEX COMPUTER COMPANY",
    "008055": "FERMILAB",
    "00802A": "TEST SYSTEMS & SIMULATIONS INC",
    "0080C0": "PENRIL DATACOMM",
    "008035": "TECHNOLOGY WORKS",
    "00807E": "SOUTHERN PACIFIC LTD.",
    "0080EF": "RATIONAL",
    "0080F0": "Panasonic Communications Co.",
    "008051": "FIBERMUX",
    "008093": "XYRON CORPORATION",
    "008092": "Silex Technology",
    "00805A": "TULIP COMPUTERS INTERNAT'L B.V",
    "0080C6": "NATIONAL DATACOMM CORPORATION",
    "004041": "FUJIKURA LTD.",
    "000050": "RADISYS CORPORATION",
    "00802E": "CASTLE ROCK COMPUTING",
    "0080F2": "RAYCOM SYSTEMS INC",
    "0080BD": "THE FURUKAWA ELECTRIC CO.",
    "008025": "Telit Wireless Solutions GmbH",
    "0080EA": "ADVA Optical Networking Ltd.",
    "00800D": "VOSSWINKEL F.U.",
    "0080D1": "KIMTRON CORPORATION",
    "008040": "JOHN FLUKE MANUFACTURING CO.",
    "008021": "Alcatel Canada Inc.",
    "0080E8": "CUMULUS CORPORATIION",
    "00001E": "TELSIST INDUSTRIA ELECTRONICA",
    "008004": "ANTLOW COMMUNICATIONS",
    "0080D0": "COMPUTER PERIPHERALS",
    "008024": "KALPANA",
    "008000": "MULTITECH SYSTEMS",
    "008069": "COMPUTONE SYSTEMS",
    "008075": "PARSYTEC GMBH",
    "00801D": "INTEGRATED INFERENCE MACHINES",
    "0080ED": "IQ TECHNOLOGIES",
    "00809A": "NOVUS NETWORKS LTD",
    "008042": "Artesyn Embedded Technologies",
    "00804A": "PRO-LOG",
    "0000B5": "DATABILITY SOFTWARE SYS. INC.",
    "000066": "TALARIS SYSTEMS",
    "000049": "APRICOT COMPUTERS",
    "0000FA": "MICROSAGE COMPUTER SYSTEMS INC",
    "0000D4": "PURE DATA LTD.",
    "000019": "APPLIED DYNAMICS INTERNATIONAL",
    "00004B": "ICL DATA OY",
    "0000E0": "QUADRAM CORP.",
    "00004F": "LOGICRAFT",
    "000015": "DATAPOINT CORPORATION",
    "00001C": "BELL TECHNOLOGIES",
    "000034": "NETWORK RESOURCES CORPORATION",
    "000022": "VISUAL TECHNOLOGY INC.",
    "0000AB": "LOGIC MODELING CORPORATION",
    "000027": "JAPAN RADIO COMPANY",
    "0000E8": "ACCTON TECHNOLOGY CORP.",
    "00002F": "TIMEPLEX INC.",
    "0000E6": "APTOR PRODUITS DE COMM INDUST",
    "00009A": "RC COMPUTER A/S",
    "0000E7": "Star Gate Technologies",
    "00003A": "CHYRON CORPORATION",
    "0000BE": "THE NTI GROUP",
    "0000D9": "NIPPON TELEGRAPH & TELEPHONE",
    "000018": "WEBSTER COMPUTER CORPORATION",
    "0000D5": "MICROGNOSIS INTERNATIONAL",
    "0080AC": "IMLOGIX",
    "000080": "CRAY COMMUNICATIONS A/S",
    "080089": "Kinetics",
    "080086": "KONICA MINOLTA HOLDINGS",
    "000069": "CONCORD COMMUNICATIONS INC",
    "000073": "SIECOR CORPORATION",
    "0000B9": "MCDONNELL DOUGLAS COMPUTER SYS",
    "0000BF": "SYMMETRIC COMPUTER SYSTEMS",
    "00002D": "CHROMATICS INC",
    "00004D": "DCI CORPORATION",
    "000023": "ABB INDUSTRIAL SYSTEMS AB",
    "000059": "Hellige GMBH",
    "00006F": "Madge Ltd.",
    "000078": "LABTAM LIMITED",
    "00005A": "SysKonnect GmbH",
    "000071": "ADRA SYSTEMS INC.",
    "080061": "JAROGATE LTD.",
    "08005F": "SABER TECHNOLOGY CORP.",
    "080058": "SYSTEMS CONCEPTS",
    "080083": "Seiko Instruments Inc.",
    "08002A": "MOSAIC TECHNOLOGIES INC.",
    "080024": "10NET COMMUNICATIONS/DCA",
    "080022": "NBI INC.",
    "080020": "Oracle Corporation",
    "021C7C": "PERQ SYSTEMS CORPORATION",
    "000005": "XEROX CORPORATION",
    "00DD08": "UNGERMANN-BASS INC.",
    "AA0000": "DIGITAL EQUIPMENT CORPORATION",
    "AA0001": "DIGITAL EQUIPMENT CORPORATION",
    "AA0002": "DIGITAL EQUIPMENT CORPORATION",
    "080014": "EXCELAN",
    "080065": "GENRAD INC.",
    "08001F": "SHARP CORPORATION",
    "020701": "RACAL-DATACOM",
    "080006": "SIEMENS AG",
    "080049": "UNIVATION",
    "000007": "XEROX CORPORATION",
    "00801F": "KRUPP ATLAS ELECTRONIK GMBH",
    "02AA3C": "OLIVETTI TELECOMM SPA (OLTECO)",
    "04E0C4": "TRIUMPH-ADLER AG",
    "080013": "Exxon",
    "645725": "Hui Zhou Gaoshengda Technology Co.",
    "0080E9": "Madge Ltd.",
    "0040D6": "LOCAMATION B.V.",
    "08004B": "Planning Research Corp.",
    "0425E8": "Texas Instruments",
    "283C90": "Texas Instruments",
    "E4FA5B": "Texas Instruments",
    "8487FF": "Shenzhen Skyworth Digital  Technology  CO.",
    "080059": "A/S MYCRON",
    "080008": "BOLT BERANEK AND NEWMAN INC.",
    "DC1057": "Apple",
    "30D875": "Apple",
    "683EC0": "Apple",
    "000009": "XEROX CORPORATION",
    "44C3B6": "HUAWEI TECHNOLOGIES CO.",
    "E8F72F": "HUAWEI TECHNOLOGIES CO.",
    "50A1F3": "Huawei Device Co.",
    "485FDF": "zte corporation",
    "F0F84A": "BUFFALO.INC",
    "6C1544": "Microsoft Corporation",
    "3C55DB": "Shenzhen Skyworth Digital  Technology  CO.",
    "EC6E79": "InHand Networks",
    "C80C53": "China Mobile Group Device Co.",
    "785F28": "EM Microelectronic",
    "A4004E": "Cisco Systems",
    "38EFE3": "INGENICO TERMINALS SAS",
    "2C9EE0": "Cavli Inc.",
    "64C17E": "cheilelectric",
    "FC8D13": "FUJIAN STAR-NET COMMUNICATION CO.",
    "240462": "Siemens Energy Global GmbH & Co.KG - GT PRM",
    "A4373E": "Huawei Device Co.",
    "C44F5F": "Huawei Device Co.",
    "9CB1DC": "Earda Technologies co Ltd",
    "B02EE0": "Huawei Device Co.",
    "388871": "ASKEY COMPUTER CORP",
    "BCF87E": "Arcadyan Corporation",
    "284EE9": "mercury corperation",
    "58E359": "Interroll Software & Electronics GmbH",
    "8C3223": "JWIPC Technology Co.",
    "00C896": "CIG SHANGHAI CO LTD",
    "001B09": "MATRIX COMSEC PRIVATE LIMITED",
    "F41A79": "IEEE Registration Authority",
    "2800AF": "Dell Inc.",
    "000413": "snom technology GmbH",
    "74B059": "Motorola Mobility LLC",
    "E48429": "New H3C Technologies Co.",
    "8C0734": "Private",
    "987A9B": "TCL MOKA International Limited",
    "781699": "HUAWEI TECHNOLOGIES CO.",
    "E40A16": "HUAWEI TECHNOLOGIES CO.",
    "409CA7": "CHINA DRAGON TECHNOLOGY LIMITED",
    "D0AD08": "HP Inc.",
    "CC40B2": "ECI Telecom Ltd.",
    "A4E287": "Xiaomi Communications Co Ltd",
    "80953A": "Apple",
    "6845CC": "Apple",
    "60045C": "NXP Semiconductor (Tianjin) LTD.",
    "849C02": "Druid Software",
    "D0C901": "GLA ELECTRONICS PVT LTD",
    "1C4C27": "World WLAN Application Alliance",
    "68AE04": "Shenzhen SuperElectron Technology Co.",
    "AC9738": "Apple",
    "CC6023": "Apple",
    "0CDBEA": "Apple",
    "08C224": "Amazon Technologies Inc.",
    "68932E": "Habana Labs LTD.",
    "2CC44F": "IEEE Registration Authority",
    "981223": "Tarmoc Network LTD",
    "4099E3": "Guangzhou Mudi Information Technology Co.",
    "7C8899": "FN-LINK TECHNOLOGY Ltd.",
    "046874": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "FC702E": "Sichuan AI-Link Technology Co.",
    "D476A0": "Fortinet",
    "94FF3C": "Fortinet",
    "B4F95D": "Juniper Networks",
    "6C45C4": "Cloudflare",
    "B047E9": "Intel Corporate",
    "6C2F80": "Intel Corporate",
    "D06578": "Intel Corporate",
    "7490BC": "Arcadyan Corporation",
    "98BD80": "Intel Corporate",
    "A0F509": "IEI Integration Corp.",
    "94706C": "Quectel Wireless Solutions Co.",
    "1C3B01": "Shanghai Xiaodu Technology Limited",
    "187F88": "Ring LLC",
    "000D97": "Hitachi Energy USA Inc.",
    "B87E40": "Huawei Device Co.",
    "1C2FA2": "Guangzhou Shiyuan Electronic Technology Company Limited",
    "A43F68": "Arista Network",
    "BC9D4E": "Shenzhen Skyworth Digital  Technology  CO.",
    "3CB8D6": "Bluebank Communication Technology Co.",
    "9C9E03": "awayfrom",
    "64D81B": "Vestel Elektronik San ve Tic. A.S.",
    "30DCE7": "zte corporation",
    "D01255": "Hui Zhou Gaoshengda Technology Co.",
    "3C2D9E": "Vantiva - Connected Home",
    "08C7F5": "Vantiva Connected Home - Technologies Telco",
    "C01693": "Xiaomi Communications Co Ltd",
    "FC5B8C": "Xiaomi Communications Co Ltd",
    "284E44": "HUAWEI TECHNOLOGIES CO.",
    "802EC3": "HUAWEI TECHNOLOGIES CO.",
    "D4D659": "Meta Platforms Technologies",
    "80053A": "CHeKT Inc.",
    "D8B32F": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "EC90C1": "Samsung Electronics Co.",
    "54104F": "Samsung Electronics Co.",
    "B05476": "Samsung Electronics Co.",
    "8C26AA": "Apple",
    "30D959": "Shanghai Longcheer Technology Co.",
    "007839": "Nokia",
    "108A7B": "Nokia",
    "A052AB": "AVM ELECTRONICS PTE LTD",
    "90623F": "Apple",
    "A8BB56": "Apple",
    "282D7F": "Apple",
    "F0866F": "EM Microelectronic",
    "5CB260": "EM Microelectronic",
    "5C07A4": "Ciena Corporation",
    "6C6F18": "Stereotaxis",
    "88010C": "Sichuan Tianyi Comheart Telecom Co.",
    "505B1D": "Shenzhen C-Data Technology Co.",
    "BC54FC": "SHENZHEN MERCURY COMMUNICATION TECHNOLOGIES CO.",
    "90769F": "SHENZHEN MERCURY COMMUNICATION TECHNOLOGIES CO.",
    "4C7766": "SHENZHEN MERCURY COMMUNICATION TECHNOLOGIES CO.",
    "005CC2": "SHENZHEN MERCURY COMMUNICATION TECHNOLOGIES CO.",
    "581DC9": "MSE CO.",
    "CC7B5C": "Espressif Inc.",
    "FCE8C0": "Espressif Inc.",
    "004BF3": "SHENZHEN MERCURY COMMUNICATION TECHNOLOGIES CO.",
    "88548E": "vivo Mobile Communication Co.",
    "BC744B": "Nintendo Co.",
    "D87A3B": "Silicon Laboratories",
    "3C2EF5": "Silicon Laboratories",
    "3410F4": "Silicon Laboratories",
    "A49E69": "Silicon Laboratories",
    "F082C0": "Silicon Laboratories",
    "0CEFF6": "Silicon Laboratories",
    "ECF64C": "Silicon Laboratories",
    "90AB96": "Silicon Laboratories",
    "60EFAB": "Silicon Laboratories",
    "488EB7": "Zebra Technologies Inc.",
    "0C82D5": "Maxio Technology Hangzhou Co.",
    "0401BB": "TECNO MOBILE LIMITED",
    "AC72DD": "GD Midea Air-Conditioning Equipment Co.",
    "64BB1E": "Earda Technologies co Ltd",
    "FCD290": "SKY UK LIMITED",
    "78305D": "zte corporation",
    "940B83": "zte corporation",
    "7CD3E5": "HUAWEI TECHNOLOGIES CO.",
    "648214": "FN-LINK TECHNOLOGY Ltd.",
    "E09CE5": "Shanghai Tricheer Technology Co.",
    "E47450": "Shenzhen Grandsun Electronic Co.",
    "70C912": "Sichuan AI-Link Technology Co.",
    "B4A3BD": "Extreme Networks Headquarters",
    "B8876E": "Intertech Services AG",
    "3C0B4F": "Intertech Services AG",
    "EC192E": "Cisco Systems",
    "84E9C1": "Realme Chongqing Mobile Telecommunications Corp.",
    "6C62FE": "Juniper Networks",
    "9C9ED5": "Xiaomi Communications Co Ltd",
    "743822": "Xiaomi Communications Co Ltd",
    "B83BAB": "Arcadyan Corporation",
    "40A63D": "SignalFire Telemetry",
    "605464": "Eyedro Green Solutions Inc.",
    "CCE536": "ittim",
    "C8A23B": "Shenzhen Sundray Technologies Company Limited",
    "2C67BE": "DWnet Technologies(Suzhou) Corporation",
    "BC0004": "Fiberhome Telecommunication Technologies Co.",
    "98A829": "AltoBeam Inc.",
    "B4622E": "Zhong Ge Smart Technology Co.",
    "C46E33": "Zhong Ge Smart Technology Co.",
    "F89D9D": "Shenzhen MinewSemi Co.",
    "F896FE": "LG Innotek",
    "A4C40D": "WAC Lighting",
    "58306E": "Nokia",
    "A8CA77": "Amazon Technologies Inc.",
    "241E2B": "Zhejiang Cainiao Supply Chain Management Co.",
    "C4A451": "TECNO MOBILE LIMITED",
    "142B2F": "Espressif Inc.",
    "F061F3": "Comcast Cable Corporation",
    "D48D26": "LG Innotek",
    "D0C907": "Private",
    "F4F28A": "HUAWEI TECHNOLOGIES CO.",
    "94E300": "HUAWEI TECHNOLOGIES CO.",
    "0CE5B5": "HUAWEI TECHNOLOGIES CO.",
    "FCF738": "HUAWEI TECHNOLOGIES CO.",
    "8C862A": "HUAWEI TECHNOLOGIES CO.",
    "C03379": "HUAWEI TECHNOLOGIES CO.",
    "AC7F8D": "Extreme Networks Headquarters",
    "042DAD": "Areus GmbH",
    "24ACAC": "Polar Electro Oy",
    "50206B": "Copeland - Transportation Solutions ApS",
    "781C1E": "Chongqing Yipingfang Technology Co.",
    "78A13E": "New H3C Technologies Co.",
    "48CA43": "Espressif Inc.",
    "449046": "Honor Device Co.",
    "94F6F2": "Honor Device Co.",
    "B0C38E": "Huawei Device Co.",
    "143B51": "Huawei Device Co.",
    "D07380": "Huawei Device Co.",
    "1047E7": "Shenzhen YOUHUA Technology Co.",
    "80D10A": "Sichuan AI-Link Technology Co.",
    "ACFCE3": "EM Microelectronic",
    "B0A7D2": "Fiberhome Telecommunication Technologies Co.",
    "8C87D0": "Shenzhen Uascent Technology Co.",
    "5C1783": "Edgecore Americas Networking Corporation",
    "7CBAC0": "EVBox BV",
    "98256E": "Private",
    "D413B3": "Wu Qi Technologies",
    "647060": "Texas Instruments",
    "00AAFD": "Texas Instruments",
    "60E5D8": "zte corporation",
    "5435E9": "Feitian Technologies Co.",
    "7CB59F": "HUAWEI TECHNOLOGIES CO.",
    "505C88": "Cisco Systems",
    "0C4BEE": "Texas Instruments",
    "30138B": "HP Inc.",
    "606832": "Guangdong Seneasy Intelligent Technology Co.",
    "8433F2": "Shenzhen Stellamore Technology Co.",
    "28D043": "AzureWave Technology Inc.",
    "E4D3AA": "FCNT LLC",
    "B0D576": "Apple",
    "142876": "Apple",
    "147FCE": "Apple",
    "6CC3B2": "Cisco Meraki",
    "F8CE07": "ZHEJIANG DAHUA TECHNOLOGYCO.",
    "2098ED": "AltoBeam Inc.",
    "F88FC8": "Chipsea Technologies (Shenzhen) Corp.",
    "4C10D5": "TP-LINK TECHNOLOGIES CO.",
    "983910": "Kaon Group Co.",
    "804C5D": "NXP Semiconductor (Tianjin) LTD.",
    "289176": "Indyme Solutions",
    "28A06B": "Intel Corporate",
    "7C8BC1": "Infinix mobility limited",
    "3CCA61": "TECNO MOBILE LIMITED",
    "ECA971": "Hangzhou Hikvision Digital Technology Co.",
    "E00855": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
    "68A2AA": "Acres Manufacturing",
    "88AE35": "Realme Chongqing Mobile Telecommunications Corp.",
    "7049A2": "Zyxel Communications Corporation",
    "A07D9C": "Samsung Electronics Co.",
    "F8C3F1": "Raytron Photonics Co.",
    "D89563": "Taiwan Digital Streaming Co.",
    "E8A848": "Wacom Co.",
    "5CA3EB": "SKODA DIGITAL s.r.o.",
    "5CBE05": "ISPEC",
    "08524E": "Shenzhen Fangcheng Baiyi Technology Co.",
    "ACF42C": "Earda Technologies co Ltd",
    "508A7F": "HUAWEI TECHNOLOGIES CO.",
    "98A878": "Agnigate Technologies Private Limited",
    "E8B527": "Phyplus Technology (Shanghai) Co.",
    "305223": "GD Midea Air-Conditioning Equipment Co.",
    "DC4965": "DASAN Newtork Solutions",
    "C4CBBE": "Great Talent Technology Limited",
    "189E2D": "Allwinner Technology Co.",
    "C0AB2B": "Huawei Device Co.",
    "9C2D49": "Nanowell Info Tech Co.",
    "38E13D": "Apple",
    "D0D49F": "Apple",
    "887FD5": "zte corporation",
    "F47470": "Cisco Systems",
    "9C6076": "Apple",
    "387B01": "Shenzhen MiaoMing Intelligent Technology Co.",
    "2C36F2": "HUAWEI TECHNOLOGIES CO.",
    "E4995F": "HUAWEI TECHNOLOGIES CO.",
    "A8F059": "HUAWEI TECHNOLOGIES CO.",
    "60A434": "IEEE Registration Authority",
    "C88DD4": "Markone technology Co.",
    "0CEDC8": "Xiaomi Communications Co Ltd",
    "283DE8": "Guangzhou Shiyuan Electronic Technology Company Limited",
    "180403": "vivo Mobile Communication Co.",
    "206BD5": "vivo Mobile Communication Co.",
    "E8F724": "Hewlett Packard Enterprise",
    "88BCAC": "Zebra Technologies Inc.",
    "9C1C12": "Hewlett Packard Enterprise",
    "04BD88": "Hewlett Packard Enterprise",
    "F05C19": "Hewlett Packard Enterprise",
    "104F58": "Hewlett Packard Enterprise",
    "CCD083": "Hewlett Packard Enterprise",
    "B47AF1": "Hewlett Packard Enterprise",
    "489ECB": "Hewlett Packard Enterprise",
    "7C573C": "Hewlett Packard Enterprise",
    "DC680C": "Hewlett Packard Enterprise",
    "348A12": "Hewlett Packard Enterprise",
    "48DF37": "Hewlett Packard Enterprise",
    "20677C": "Hewlett Packard Enterprise",
    "4448C1": "Hewlett Packard Enterprise",
    "E89505": "Shenzhen MiaoMing Intelligent Technology Co.",
    "685377": "Bouffalo Lab (Nanjing) Co.",
    "1063A3": "IEEE Registration Authority",
    "E80690": "Espressif Inc.",
    "E4DE40": "Hewlett Packard Enterprise",
    "480020": "Hewlett Packard Enterprise",
    "5CA47D": "Hewlett Packard Enterprise",
    "54D7E3": "Hewlett Packard Enterprise",
    "14ABEC": "Hewlett Packard Enterprise",
    "6828CF": "Hewlett Packard Enterprise",
    "BC4632": "Fiberhome Telecommunication Technologies Co.",
    "E0604A": "Fiberhome Telecommunication Technologies Co.",
    "DCB7AC": "Hewlett Packard Enterprise",
    "5006F5": "Roku",
    "34516F": "Skychers Creations ShenZhen Limited",
    "B8374B": "Hewlett Packard Enterprise",
    "DCA706": "CHENGDU KT ELECTRONIC HI-TECH CO.",
    "C86E08": "Intel Corporate",
    "9816CD": "leapio",
    "EC725B": "zte corporation",
    "78078F": "HUAWEI TECHNOLOGIES CO.",
    "309E62": "HUAWEI TECHNOLOGIES CO.",
    "E49282": "Samsung Electronics Co.",
    "188637": "INGRAM MICRO SERVICES",
    "10C0D5": "HOLOEYE Photonics AG",
    "0009F7": "Calian Advanced Technologies",
    "387ACC": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
    "B4C556": "Shanghai Kenmyond Industrial Network Equipment Co.",
    "0884FB": "Honor Device Co.",
    "0494E9": "FAXedge Technologies",
    "241651": "Chipsea Technologies (Shenzhen) Corp.",
    "58769C": "Palo Alto Networks",
    "F0090D": "TP-LINK CORPORATION PTE. LTD.",
    "54FA89": "Medtronic CRM",
    "282E89": "Wistron Neweb Corporation",
    "90FB5D": "Beijing Xiaomi Mobile Software Co.",
    "7C72E7": "Texas Instruments",
    "3030D0": "Texas Instruments",
    "54FEEB": "Texas Instruments",
    "441690": "Wuxi Ranke Technology Co.",
    "14BEFC": "Nanjing Jiahao Technology Co.",
    "905F7A": "Apple",
    "F8F58C": "Apple",
    "0C85E1": "Apple",
    "74C90F": "Microchip Technologies Inc",
    "34CDB0": "Espressif Inc.",
    "0C2A6F": "Silicon Laboratories",
    "A0479B": "PROCITEC GmbH",
    "9CA6D8": "Fiberhome Telecommunication Technologies Co.",
    "5026D2": "AVIRE Trading Limited",
    "942453": "HUAWEI TECHNOLOGIES CO.",
    "20DBEA": "Cisco Systems",
    "B03226": "Keheng Information Industry Co.",
    "3C5836": "Sagemcom Broadband SAS",
    "2CB7A1": "Huawei Device Co.",
    "6C8243": "Huawei Device Co.",
    "18E204": "BEIJING COOLSHARK TECHNOLOGY CO.",
    "B476A4": "Huawei Device Co.",
    "84CB85": "EM Microelectronic",
    "ACF23C": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "D01BBE": "Onward Brands",
    "F86BFA": "Infinix mobility limited",
    "184F43": "UNIONMAN TECHNOLOGY CO.",
    "E45768": "vivo Mobile Communication Co.",
    "48E6C6": "IEEE Registration Authority",
    "246A0E": "HP Inc.",
    "B07C51": "Ruckus Wireless",
    "000417": "Schneider Electric",
    "884F59": "Cisco Systems",
    "7CFA80": "JiangSu Fulian Communication Technology Co.",
    "ACB722": "Qingdao Haier Technology Co.",
    "9454C5": "Espressif Inc.",
    "C08706": "Shenzhen Qianfenyi Intelligent Technology Co.",
    "C4B349": "Apple",
    "34F68D": "Apple",
    "CC2746": "Apple",
    "0C01A5": "zte corporation",
    "98FA9B": "LCFC(Hefei) Electronics Technology co.",
    "F875A4": "LCFC(Hefei) Electronics Technology co.",
    "8C8CAA": "LCFC(Hefei) Electronics Technology co.",
    "701988": "Nanjing Qinheng Microelectronics Co.",
    "FC1A46": "Samsung Electronics Co.",
    "983DAE": "Espressif Inc.",
    "5C5E0A": "Samsung Electronics Co.",
    "24E3A4": "Fiberhome Telecommunication Technologies Co.",
    "3000FC": "Nokia",
    "285923": "Xiaomi Communications Co Ltd",
    "D0CEC0": "Xiaomi Communications Co Ltd",
    "88B2AB": "Fiberhome Telecommunication Technologies Co.",
    "EC6652": "Info Fiber Solutions Pvt Ltd",
    "CC763A": "zte corporation",
    "300475": "QBIC COMMUNICATIONS DMCC",
    "000AF6": "Copeland LP",
    "CCB0B3": "Microsoft Corporation",
    "80D52C": "Beijing Cheering Networks Technology Co.",
    "5C18DD": "CIG SHANGHAI CO LTD",
    "14360E": "Zyxel Communications Corporation",
    "5C4EEE": "AltoBeam Inc.",
    "C805A4": "Motorola(Wuhan) Mobility Technologies Communication Co.",
    "0072EE": "Intel Corporate",
    "C858B3": "Intel Corporate",
    "E41FD5": "Intel Corporate",
    "5CC1F2": "HUAWEI TECHNOLOGIES CO.",
    "1CB46C": "HUAWEI TECHNOLOGIES CO.",
    "64DE6D": "Intel Corporate",
    "EC4C8C": "Intel Corporate",
    "E8F673": "Microsoft Corporation",
    "5CDB36": "Calix Inc.",
    "4C7B35": "UNIONMAN TECHNOLOGY CO.",
    "9C45F0": "SKYLARK ELECTRONICS PVT LTD",
    "EC1B5F": "Hewlett Packard Enterprise",
    "409249": "Shanghai Baud Data Communication Co.",
    "7864A0": "Cisco Systems",
    "686B6A": "Phytium Technology Co.",
    "3407AC": "PRONYX TRADING LLC",
    "D0CBDD": "eero inc.",
    "44B423": "HANWHA VISION VIETNAM COMPANY LIMITED",
    "7475DF": "TECLINK",
    "0C7E24": "Garmin International",
    "6887BD": "zte corporation",
    "3058EB": "zte corporation",
    "4405B8": "Huawei Device Co.",
    "58B858": "SZ DJI TECHNOLOGY CO.",
    "E8BCE4": "Cisco Systems",
    "841A24": "UNIONMAN TECHNOLOGY CO.",
    "5C40E3": "NOVAON",
    "786CAB": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "007D3B": "Samsung Electronics Co.",
    "8C8726": "VAST Data Inc",
    "68628A": "vivo Mobile Communication Co.",
    "2844F4": "Honor Device Co.",
    "18E8EC": "STMicrolectronics International NV",
    "986297": "Shenzhen Techwinsemi Technology Co.",
    "28F52B": "FN-LINK TECHNOLOGY Ltd.",
    "F8EF5D": "Motorola Mobility LLC",
    "BC31E2": "New H3C Technologies Co.",
    "A409B3": "HUAWEI TECHNOLOGIES CO.",
    "6CD7A0": "WIKO Terminal Technology (Dongguan) Co.",
    "F8E35F": "Sichuan Tianyi Comheart Telecom Co.",
    "E8E7C3": "zte corporation",
    "24B2B9": "Liteon Technology Corporation",
    "1C1DD3": "Apple",
    "C81FE8": "Apple",
    "08B95F": "Silicon Laboratories",
    "3C07D7": "Apple",
    "2CD3AD": "Texas Instruments",
    "54FB5A": "Optomind Inc.",
    "747847": "Interdisciplinary Consulting Corporation",
    "78421C": "Espressif Inc.",
    "F0D506": "Ubee Interactive Co.",
    "B423A2": "Google",
    "A4B0F5": "Texas Instruments",
    "7CE53F": "HUAWEI TECHNOLOGIES CO.",
    "38D09C": "HUAWEI TECHNOLOGIES CO.",
    "8C2A85": "Amazon Technologies Inc.",
    "E4D58B": "Hangzhou Hikvision Digital Technology Co.",
    "2067E0": "Shenzhen iComm Semiconductor CO.",
    "D4A3EB": "Shenzhen iComm Semiconductor CO.",
    "500401": "TelHi Corporation",
    "9C84B6": "Shenzhen iComm Semiconductor CO.",
    "E8C6E6": "CHANGHONG (HONGKONG) TRADING LIMITED",
    "0C979B": "FUJIAN STAR-NET COMMUNICATION CO.",
    "CC22DF": "EM Microelectronic",
    "08F4F0": "Cisco Systems",
    "24215E": "Quectel Wireless Solutions Co.",
    "28DB02": "zte corporation",
    "881566": "Huawei Device Co.",
    "2845AC": "Huawei Device Co.",
    "A44380": "Huawei Device Co.",
    "1086F4": "Huawei Device Co.",
    "D450EE": "GD Midea Air-Conditioning Equipment Co.",
    "5C013B": "Espressif Inc.",
    "544DD4": "China Mobile Group Device Co.",
    "E805DC": "Verifone",
    "A0FB68": "Miba Battery Systems GmbH",
    "286BB4": "SJIT Co.",
    "98C9BE": "Shenzhen SDMC Technology CO.",
    "6C8375": "Broadcom Limited",
    "D4BEDC": "Roku",
    "30ED96": "LS Mecapion",
    "FC068C": "SHENZHEN MICIPC TECHNOLOGY CO.",
    "DC868D": "HUAWEI TECHNOLOGIES CO.",
    "E8F494": "AltoBeam Inc.",
    "48CFA9": "HUAWEI TECHNOLOGIES CO.",
    "D087B5": "SAFEMO PTE. LTD.",
    "742584": "IEEE Registration Authority",
    "00CD90": "MAS Elektronik AG",
    "40486E": "Nokia Solutions and Networks GmbH & Co. KG",
    "D8B061": "SHENZHEN WENXUN TECHNOLOGY CO.",
    "F485AE": "Senbiosys SA",
    "08DD03": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "28372F": "Espressif Inc.",
    "E44E12": "zte corporation",
    "CCB85E": "Shenzhen Phaten Tech. LTD",
    "C8A702": "Hangzhou Hikvision Digital Technology Co.",
    "2CFE8B": "Microchip Technologies Inc",
    "68EFAB": "Vention",
    "B09200": "Apple",
    "A0EE1A": "Apple",
    "584146": "Guangzhou Shiyuan Electronic Technology Company Limited",
    "781EB8": "Shenzhen iComm Semiconductor CO.",
    "9CF3AC": "Apple",
    "085D53": "Apple",
    "542906": "Apple",
    "7015FB": "Intel Corporate",
    "28A44A": "Intel Corporate",
    "B0475E": "IEEE Registration Authority",
    "EC8E12": "Nokia",
    "C084FF": "GD Midea Air-Conditioning Equipment Co.",
    "10003B": "Espressif Inc.",
    "F8731A": "zte corporation",
    "CC65AD": "Commscope",
    "789684": "Commscope",
    "E8ED05": "Commscope",
    "D404CD": "Commscope",
    "203D66": "Commscope",
    "D40AA9": "Commscope",
    "1096C6": "Cisco Systems",
    "8C09F4": "Commscope",
    "900DCB": "Commscope",
    "001371": "Commscope",
    "001E5A": "Commscope",
    "001CC1": "Commscope",
    "001DD2": "Commscope",
    "001DCD": "Commscope",
    "001ADE": "Commscope",
    "0023EE": "Commscope",
    "E83EFC": "Commscope",
    "7CBFB1": "Commscope",
    "0050E3": "Commscope",
    "001626": "Commscope",
    "001311": "Commscope",
    "0019A6": "Commscope",
    "80F503": "Commscope",
    "A055DE": "Commscope",
    "D42C0F": "Commscope",
    "FC6FB7": "Commscope",
    "FC8E7E": "Commscope",
    "A41588": "Commscope",
    "044E5A": "Commscope",
    "38700C": "Commscope",
    "FC51A4": "Commscope",
    "2C9E5F": "Commscope",
    "40FC89": "Commscope",
    "E46449": "Commscope",
    "745612": "Commscope",
    "287AEE": "Commscope",
    "BC644B": "Commscope",
    "44AAF5": "Commscope",
    "003676": "Commscope",
    "7823AE": "Commscope",
    "105611": "Commscope",
    "18B81F": "Commscope",
    "984B4A": "Commscope",
    "E8825B": "Commscope",
    "002136": "Commscope",
    "002636": "Commscope",
    "748A0D": "Commscope",
    "CC75E2": "Commscope",
    "14D4FE": "Commscope",
    "E49F1E": "Commscope",
    "509551": "Commscope",
    "240A63": "Commscope",
    "F88B37": "Commscope",
    "88964E": "Commscope",
    "88C48E": "UNEEVIU TECHNOLOGIES INDIA PRIVATE LIMITED",
    "402B50": "Commscope",
    "705425": "Commscope",
    "ECA940": "Commscope",
    "E4F75B": "Commscope",
    "F8790A": "Commscope",
    "1C937C": "Commscope",
    "DC2E97": "Quectel Wireless Solutions Co.",
    "80E540": "Commscope",
    "C09435": "Commscope",
    "8C763F": "Commscope",
    "ACEF92": "IEEE Registration Authority",
    "78123E": "TECNO MOBILE LIMITED",
    "14B5CD": "Liteon Technology Corporation",
    "BC4548": "Beijing gpthink technology co.",
    "B852E0": "Beijing Xiaomi Electronics Co.",
    "289F04": "Samsung Electronics Co.",
    "E0854D": "LG Innotek",
    "4045A0": "vivo Mobile Communication Co.",
    "0CE67C": "Realme Chongqing Mobile Telecommunications Corp.",
    "58FC20": "Altice Labs",
    "1C573E": "Altice Labs",
    "E03ECB": "Qingdao Intelligent&Precise Electronics Co.",
    "6CA31E": "ITEL MOBILE LIMITED",
    "F8F3D3": "Shenzhen Gotron electronic CO.",
    "3CA9AB": "Nintendo Co.",
    "0C47A9": "IEEE Registration Authority",
    "548450": "Tiinlab Corporation",
    "689575": "Zhejiang Bodyguard Electronic Co.",
    "20538D": "Hon Hai Precision Industry Co.",
    "9CE91E": "TEJAS NETWORKS LTD",
    "C8FB54": "iMin Technology Pte. Ltd.",
    "0447CA": "GREE ELECTRIC APPLIANCES",
    "C02D2E": "China Mobile Group Device Co.",
    "C0F853": "Tuya Smart Inc.",
    "58DF59": "Cisco Systems",
    "44AC85": "eero inc.",
    "1C4EA2": "Shenzhen V-Link Technology CO.",
    "00BC2F": "Actiontec Electronics Inc.",
    "E4FD8C": "Extreme Networks Headquarters",
    "30EB15": "Huawei Device Co.",
    "689B43": "Huawei Device Co.",
    "E022A1": "AltoBeam Inc.",
    "04B066": "Private",
    "4CFA9A": "Shenzhen Quanxing Technology Co.",
    "284992": "Luminator Technology Group Global LLC",
    "A8EAE4": "Weiser",
    "9438AA": "Technology Innovation Institute",
    "6C9AB4": "Brodersen A/S",
    "388D3D": "Wistron Neweb Corporation",
    "50EE32": "Hon Hai Precision Industry Co.",
    "60A3E3": "TP-LINK TECHNOLOGIES CO.",
    "646306": "Xiaomi Communications Co Ltd",
    "E45D39": "Texas Instruments",
    "0490C0": "Forvia",
    "E441D4": "vivo Mobile Communication Co.",
    "083F21": "Motorola Mobility LLC",
    "64447B": "vivo Mobile Communication Co.",
    "98E7D5": "NXP Semiconductor (Tianjin) LTD.",
    "4C858A": "BUFFALO.INC",
    "10A450": "Kwikset",
    "C84805": "Nintendo Co.",
    "80A197": "u-blox AG",
    "8CB6C5": "Mimosa Networks",
    "D80FB5": "SHENZHEN ULTRAEASY TECHNOLOGY CO LTD",
    "ECFF3A": "Apple",
    "701384": "Apple",
    "84A824": "Google",
    "346691": "Apple",
    "E01CA7": "Arista Networks",
    "A8D3C8": "Wachendorff Automation GmbH & CO.KG",
    "E4CDA7": "zte corporation",
    "84EAD2": "KOGANEI CORPORATION",
    "F0DB2A": "LANNER ELECTRONICS",
    "909507": "HUAWEI TECHNOLOGIES CO.",
    "8863C5": "HUAWEI TECHNOLOGIES CO.",
    "488C78": "Alpha Networks Inc.",
    "500B88": "Moxa.Inc",
    "24FBE3": "HP Inc.",
    "540BB6": "Variscite LTD",
    "989F1A": "Private",
    "940E2A": "NXP Semiconductors Taiwan Ltd.",
    "F074BF": "Silicon Laboratories",
    "F897B0": "Goki Pty Ltd",
    "0C7955": "Hui Zhou Gaoshengda Technology Co.",
    "5C8E10": "TimeWatch Infocom Pvt. Ltd.",
    "005245": "GANATECHWIN",
    "44C20C": "Cisco Systems",
    "88948E": "Max Weishaupt SE",
    "647B40": "Sichuan AI-Link Technology Co.",
    "74ADCB": "New H3C Technologies Co.",
    "A06B4A": "TCT mobile ltd",
    "186041": "Arcadyan Corporation",
    "2C2D48": "Commend International GmbH",
    "D81909": "Wiwynn Technology Service Malaysia",
    "3877CD": "KOKUSAI ELECTRIC CORPORATION",
    "808489": "Intel Corporate",
    "FCB3AA": "Intel Corporate",
    "4C0F3E": "Intel Corporate",
    "14335C": "Espressif Inc.",
    "9888E0": "Espressif Inc.",
    "94C7A8": "Jiangsu Huitong Group Co.",
    "88DDB8": "Huawei Device Co.",
    "009B08": "Quectel Wireless Solutions Co.",
    "BCDFE1": "IEEE Registration Authority",
    "4C99E8": "ZHEJIANG DAHUA TECHNOLOGYCO.",
    "8CBD37": "Shenzhen Phaten Tech. LTD",
    "58960A": "LG Electronics",
    "2CD8AE": "Shenzhen SEI Robotics Co.",
    "C4B757": "ALPSALPINE CO",
    "88F715": "Arista Networks",
    "90E643": "Tesla",
    "40B3FA": "Apple",
    "C4D6D3": "Dell Inc.",
    "300A9D": "Axino Solutions AG",
    "9CDA36": "TECNO MOBILE LIMITED",
    "C0C989": "Edgecore Americas Networking Corporation",
    "8CBE6F": "Tianyi Telecom Terminals Company Limited",
    "04006E": "Google",
    "2442E3": "Shenzhen Ai-Thinker  Technology Co.",
    "D0C1BF": "Xiaomi Communications Co Ltd",
    "A82BD5": "Xiaomi Communications Co Ltd",
    "BCD7D4": "Roku",
    "F814DD": "Cisco Systems",
    "0C8247": "CIG SHANGHAI CO LTD",
    "78ED25": "New H3C Technologies Co.",
    "447609": "New H3C Technologies Co.",
    "04C845": "TP-Link Systems Inc.",
    "5C5EBB": "HUAWEI TECHNOLOGIES CO.",
    "B0C61C": "HUAWEI TECHNOLOGIES CO.",
    "44BE0B": "HUAWEI TECHNOLOGIES CO.",
    "7C9946": "Sector Alarm Tech S.L.",
    "402508": "Highway 9 Networks",
    "04A16F": "IEEE Registration Authority",
    "3497D7": "YEALINK(XIAMEN) NETWORK TECHNOLOGY CO.",
    "14392F": "LEAR",
    "8C3F44": "GD Midea Air-Conditioning Equipment Co.",
    "68F62B": "ITEL MOBILE LIMITED",
    "247BA4": "China Mobile Group Device Co.",
    "38420B": "Sonos",
    "A44BD9": "Hangzhou Hikvision Digital Technology Co.",
    "9812E0": "Xiaomi Communications Co Ltd",
    "64DD68": "Zyxel Communications Corporation",
    "2843DC": "United Memory Technology (Jiangsu) Limited",
    "387707": "AltoBeam Inc.",
    "80E4BA": "Intel Corporate",
    "74CA60": "Sonos",
    "EC1BFA": "EM Microelectronic",
    "4CD0F9": "Cisco Systems",
    "B00C9D": "Quectel Wireless Solutions Co.",
    "F0AB1F": "zte corporation",
    "7CB30A": "zte corporation",
    "B4C799": "Extreme Networks Headquarters",
    "58696C": "Ruijie Networks Co.",
    "90B832": "Extreme Networks Headquarters",
    "9C5D12": "Extreme Networks Headquarters",
    "F09CE9": "Extreme Networks Headquarters",
    "C8675E": "Extreme Networks Headquarters",
    "C413E2": "Extreme Networks Headquarters",
    "40E317": "Extreme Networks Headquarters",
    "AC4DD9": "Extreme Networks Headquarters",
    "F4CE48": "Extreme Networks Headquarters",
    "00DCB2": "Extreme Networks Headquarters",
    "8C8394": "Arcadyan Corporation",
    "CC14BC": "Edifier International",
    "E8D3EB": "eero inc.",
    "B0104B": "Fiberhome Telecommunication Technologies Co.",
    "44365D": "Shenzhen HippStor Technology Co.",
    "54C078": "Infinix mobility limited",
    "E81711": "Shenzhen Vipstech Co.",
    "200B74": "AzureWave Technology Inc.",
    "F8FE5E": "Intel Corporate",
    "4C62DF": "Hangzhou Hikvision Digital Technology Co.",
    "102874": "Shenzhen Jingxun Technology Co.",
    "7C7398": "Espressif Inc.",
    "6CB456": "Espressif Inc.",
    "E4E26C": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "88F916": "Qingdao Dayu Dance Digital Technology Co.",
    "38C0EA": "Fortinet",
    "D094CF": "HUAWEI TECHNOLOGIES CO.",
    "043855": "Scopus International Pvt. Ltd.",
    "9C4952": "Dongguan Liesheng Electronic Co.",
    "C022F1": "IEEE Registration Authority",
    "446D05": "NoTraffic",
    "3030F9": "Espressif Inc.",
    "542259": "HUAWEI TECHNOLOGIES CO.",
    "041471": "HUAWEI TECHNOLOGIES CO.",
    "C816A5": "Masimo Corporation",
    "18C009": "New H3C Technologies Co.",
    "706173": "Calantec GmbH",
    "C89D6D": "ITEL MOBILE LIMITED",
    "ECAB3E": "ESSYS",
    "384A80": "Samsung Electronics Co.",
    "900E9E": "Shenzhen SuperElectron Technology Co.",
    "54F29F": "HUNAN FN-LINK TECHNOLOGY LIMITED",
    "C82E18": "Espressif Inc.",
    "E86BEA": "Espressif Inc.",
    "4CA0D4": "Telink Semiconductor (Shanghai) Co.",
    "A8B483": "Shenzhen SuperElectron Technology Co.",
    "6855D4": "Seiko Epson Corporation",
    "D422CD": "Movella Technologies B.V.",
    "0C659A": "Panasonic Automotive Systems Company of America",
    "00409E": "Concurrent Technologies Ltd.",
    "288EB9": "Wacom Co.",
    "BC2411": "Proxmox Server Solutions GmbH",
    "DC6880": "zte corporation",
    "28BBED": "Bouffalo Lab (Nanjing) Co.",
    "344E2F": "LEAR",
    "98EDCA": "Fiberhome Telecommunication Technologies Co.",
    "ECB0D2": "EM Microelectronic",
    "4CEB76": "Murrelektronik GmbH",
    "BC8D1F": "Cisco Systems",
    "88A6EF": "IEEE Registration Authority",
    "84F5EB": "zte corporation",
    "D8E72F": "Chipsea Technologies (Shenzhen) Corp.",
    "74C76E": "RTK-TECHNOLOGIES",
    "C493BB": "Beijing Xiaomi Mobile Software Co.",
    "E89C25": "ASUSTek COMPUTER INC.",
    "ECC38A": "Accuenergy (CANADA) Inc",
    "14993E": "Xiaomi Communications Co Ltd",
    "78467D": "SKAIChips",
    "EC748C": "Sony Interactive Entertainment Inc.",
    "B04FA6": "DongGuan Ramaxel Memory Technology",
    "4C9992": "vivo Mobile Communication Co.",
    "045791": "Shenzhenshi Xinzhongxin Technology Co.Ltd",
    "54DF1B": "Vestel Elektronik San ve Tic. A.S.",
    "38F9F5": "Garmin International",
    "60BD2C": "Taicang T&W Electronics",
    "2C4C15": "Juniper Networks",
    "E41088": "Samsung Electronics Co.",
    "000CC8": "Xytronix Research & Design",
    "14C050": "GUANGDONG GENIUS TECHNOLOGY CO.",
    "441A4C": "xFusion Digital Technologies Co.",
    "4C62CD": "Nokia",
    "98DA92": "Vuzix Corporation",
    "3C52A1": "TP-Link Corporation Limited",
    "9CF86B": "AgiTech Distribution Limited - Linki",
    "1071FA": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "78465C": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "D0DD7C": "zte corporation",
    "843C99": "zte corporation",
    "F83B1D": "Vantiva USA LLC",
    "E4BFFA": "Vantiva USA LLC",
    "1C9D72": "Vantiva USA LLC",
    "3C82C0": "Vantiva USA LLC",
    "80DAC2": "Vantiva USA LLC",
    "481B40": "Vantiva USA LLC",
    "B85E71": "Vantiva USA LLC",
    "400FC1": "Vantiva USA LLC",
    "107B93": "Zhen Shi Information Technology (Shanghai) Co.",
    "705A9E": "Vantiva USA LLC",
    "68E59E": "Cisco Systems",
    "F8E5CE": "Apple",
    "14B7F8": "Vantiva USA LLC",
    "1062D0": "Vantiva USA LLC",
    "10C25A": "Vantiva USA LLC",
    "D08A91": "Vantiva USA LLC",
    "88F7C7": "Vantiva USA LLC",
    "0C0227": "Vantiva USA LLC",
    "F4C114": "Vantiva USA LLC",
    "74978E": "Nova Labs",
    "0823C6": "HUAWEI TECHNOLOGIES CO.",
    "7036B2": "Focusai Corp",
    "4CD717": "Dell Inc.",
    "C87F54": "ASUSTek COMPUTER INC.",
    "1CC992": "Honor Device Co.",
    "08D1F9": "Espressif Inc.",
    "34B7DA": "Espressif Inc.",
    "00C711": "ITEL MOBILE LIMITED",
    "348D52": "Sichuan Tianyi Comheart Telecom Co.",
    "1C860B": "Guangdong Taiying Technology Co.",
    "74D713": "Huaqin Technology Co. LTD",
    "2CC3E6": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
    "F020FF": "Intel Corporate",
    "C88A9A": "Intel Corporate",
    "90837E": "Fiberhome Telecommunication Technologies Co.",
    "CCB071": "Fiberhome Telecommunication Technologies Co.",
    "485541": "Iskratel d.o.o.",
    "F09008": "Shenzhen Skyworth Digital  Technology  CO.",
    "C84C78": "zte corporation",
    "802D1A": "zte corporation",
    "6823F4": "Shenzhen Jinlangxin Technology Co.",
    "A0B339": "Intel Corporate",
    "6CF6DA": "Intel Corporate",
    "C86BBC": "IEEE Registration Authority",
    "30600A": "CIG SHANGHAI CO LTD",
    "302F1E": "SIEMENS AG",
    "FCB2D6": "CIG SHANGHAI CO LTD",
    "60FCF1": "Private",
    "5476B2": "Raisecom Technology CO.",
    "6074F4": "Private",
    "A03768": "Shenzhen E-Life Intelligence Technology Co.",
    "44FA66": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "847ADF": "FUJIAN STAR-NET COMMUNICATION CO.",
    "6813F3": "Amazon Technologies Inc.",
    "806D97": "Private",
    "28EB0A": "Rolling Wireless S.a.r.l. Luxembourg",
    "848A59": "Hisilicon Technologies Co.",
    "DCCD66": "NXP Semiconductor (Tianjin) LTD.",
    "B0FF72": "IEEE Registration Authority",
    "649A63": "Ring LLC",
    "102834": "SALZ Automation GmbH",
    "4C70CC": "Blyott NV",
    "586861": "VIASAT",
    "14C9CF": "Sigmastar Technology Ltd.",
    "148554": "Earda Technologies co Ltd",
    "60C01E": "V&G Information System Co.",
    "2C3C05": "Marinesync Corp",
    "0008B9": "Kaon Group Co.",
    "98CCF3": "Amazon Technologies Inc.",
    "5091E3": "TP-Link Corporation Limited",
    "F02178": "UNIONMAN TECHNOLOGY CO.",
    "2C3EBF": "HOSIN Global Electronics Co.",
    "40D563": "HANA Electronics",
    "348818": "Cisco Systems",
    "005001": "YAMASHITA SYSTEMS CORP.",
    "6CEEF7": "shenzhen scodeno technology co.",
    "B440DC": "Samsung Electronics Co.",
    "3C3332": "D-Link Corporation",
    "DC2DDE": "Ledworks SRL",
    "6417CD": "Samsung Electronics Co.",
    "DC69E2": "Samsung Electronics Co.",
    "C05064": "SHENNAN CIRCUITS CO.",
    "9CFB77": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "643E0A": "HUAWEI TECHNOLOGIES CO.",
    "143375": "Zyxel Communications Corporation",
    "2CFEE2": "Qingdao Hisense Communications Co.",
    "001457": "Nevion",
    "C4D666": "Cisco Meraki",
    "18DE50": "Tuya Smart Inc.",
    "947918": "ITEL MOBILE LIMITED",
    "68F0B5": "Honor Device Co.",
    "101849": "WEIFANG GOERTEK ELECTRONICS CO.",
    "08F9E0": "Espressif Inc.",
    "0036D7": "Keltron IOT Corp.",
    "34DC99": "New H3C Technologies Co.",
    "5CE8D3": "Signalinks Communication Technology Co.",
    "44053F": "Sagemcom Broadband SAS",
    "80802C": "Fortinet",
    "4831B7": "Espressif Inc.",
    "543204": "Espressif Inc.",
    "CCB54C": "Texas Instruments",
    "74A58C": "Texas Instruments",
    "3CE002": "Texas Instruments",
    "402A8F": "Shanghai High-Flying Electronics  Technology Co.",
    "B03893": "Onda TLC Italia S.r.l.",
    "28C1A0": "Apple",
    "EC2C73": "Apple",
    "7CC06F": "Apple",
    "EC8150": "Apple",
    "D42FCA": "Apple",
    "D058A5": "Apple",
    "B09738": "Shenzhen Skyworth Digital  Technology  CO.",
    "B86061": "China Mobile Group Device Co.",
    "8CDF2C": "vivo Mobile Communication Co.",
    "F87928": "zte corporation",
    "2C67AB": "EZELINK TELECOM",
    "2CD7FF": "LANCOM Systems GmbH",
    "98038A": "Texas Instruments",
    "F8B8B4": "Shenzhen Skyworth Digital  Technology  CO.",
    "681AA4": "Shenzhen Skyworth Digital  Technology  CO.",
    "48555E": "Shenzhen Skyworth Digital  Technology  CO.",
    "700692": "IEEE Registration Authority",
    "1C880C": "Shenzhen Skyworth Digital  Technology  CO.",
    "348511": "Shenzhen Skyworth Digital  Technology  CO.",
    "D88ED4": "eero inc.",
    "943FD6": "Apple",
    "38B5C9": "INGRAM MICRO SERVICES",
    "984B06": "HUAWEI TECHNOLOGIES CO.",
    "ACFF6B": "HUAWEI TECHNOLOGIES CO.",
    "844DBE": "Fiberhome Telecommunication Technologies Co.",
    "38AB16": "NPO RTT LLC",
    "44A842": "Dell Inc.",
    "4C7625": "Dell Inc.",
    "001143": "Dell Inc.",
    "001372": "Dell Inc.",
    "00188B": "Dell Inc.",
    "80B946": "Nokia",
    "F8CAB8": "Dell Inc.",
    "F01FAF": "Dell Inc.",
    "18A99B": "Dell Inc.",
    "F8BC12": "Dell Inc.",
    "002067": "Private",
    "ACDE48": "Private",
    "0050C7": "Private",
    "E8655F": "Dell Inc.",
    "E8B265": "Dell Inc.",
    "AC91A1": "Dell Inc.",
    "C4CBE1": "Dell Inc.",
    "381428": "Dell Inc.",
    "F4EE08": "Dell Inc.",
    "908D6E": "Dell Inc.",
    "EC2A72": "Dell Inc.",
    "7486E2": "Dell Inc.",
    "00BE43": "Dell Inc.",
    "605B30": "Dell Inc.",
    "C84BD6": "Dell Inc.",
    "B4E10F": "Dell Inc.",
    "1866DA": "Dell Inc.",
    "18DBF2": "Dell Inc.",
    "14B31F": "Dell Inc.",
    "107D1A": "Dell Inc.",
    "509A4C": "Dell Inc.",
    "247152": "Dell Inc.",
    "8C47BE": "Dell Inc.",
    "601895": "Dell Inc.",
    "B04F13": "Dell Inc.",
    "405CFD": "Dell Inc.",
    "D09466": "Dell Inc.",
    "D89EF3": "Dell Inc.",
    "106530": "Dell Inc.",
    "3C2C30": "Dell Inc.",
    "886FD4": "Dell Inc.",
    "5CF9DD": "Dell Inc.",
    "004E01": "Dell Inc.",
    "000874": "Dell Inc.",
    "0024E8": "Dell Inc.",
    "002219": "Dell Inc.",
    "3417EB": "Dell Inc.",
    "B083FE": "Dell Inc.",
    "94CBCD": "zte corporation",
    "805F8E": "Huizhou BYD Electronic Co.",
    "A83A79": "Mist Systems",
    "5488FE": "Xiaoniu network technology (Shanghai) Co.",
    "F4D580": "YAMAHA CORPORATION",
    "5030F4": "Exascend",
    "E49069": "Rockwell Automation",
    "184C08": "Rockwell Automation",
    "FC35E6": "Visteon Corporation",
    "8CBA25": "UNION MAN TECHNOLOGY CO.",
    "54725E": "UNION MAN TECHNOLOGY CO.",
    "F814FE": "UNION MAN TECHNOLOGY CO.",
    "CC62FE": "UNION MAN TECHNOLOGY CO.",
    "404101": "Rockwell Automation",
    "68C8EB": "Rockwell Automation",
    "7CBFAE": "Renesas Electronics (Penang) Sdn. Bhd.",
    "80AFCA": "Shenzhen Cudy Technology Co.",
    "1C6E74": "EnOcean Edge Inc.",
    "B417A8": "Meta Platforms Technologies",
    "C09573": "AIxLink",
    "04472A": "Palo Alto Networks",
    "C02C17": "Cisco Systems",
    "984925": "Juniper Networks",
    "4419B6": "Hangzhou Hikvision Digital Technology Co.",
    "7C8931": "Huawei Device Co.",
    "BC5E33": "Hangzhou Hikvision Digital Technology Co.",
    "FC9FFD": "Hangzhou Hikvision Digital Technology Co.",
    "E8A0ED": "Hangzhou Hikvision Digital Technology Co.",
    "5C345B": "Hangzhou Hikvision Digital Technology Co.",
    "7CEDC6": "Amazon Technologies Inc.",
    "4825F3": "Huawei Device Co.",
    "C04884": "Sigma Bilisim Sist. Tekn. Elk. Enj. ve San. D??. Tic. Ltd. ?ti.",
    "4CBD8F": "Hangzhou Hikvision Digital Technology Co.",
    "F412DA": "zte corporation",
    "540295": "HUAWEI TECHNOLOGIES CO.",
    "C8787D": "D-Link Corporation",
    "40F21C": "DZS Inc.",
    "00180C": "DZS Inc.",
    "00E0DF": "DZS Inc.",
    "00A01B": "DZS Inc.",
    "D09395": "IEEE Registration Authority",
    "F4E2C6": "Ubiquiti Inc",
    "D8B370": "Ubiquiti Inc",
    "B0A732": "Espressif Inc.",
    "B0B21C": "Espressif Inc.",
    "B4FBE4": "Ubiquiti Inc",
    "687251": "Ubiquiti Inc",
    "E09B27": "Ciena Corporation",
    "FCECDA": "Ubiquiti Inc",
    "942A6F": "Ubiquiti Inc",
    "8CE042": "vivo Mobile Communication Co.",
    "407183": "Juniper Networks",
    "40B4F0": "Juniper Networks",
    "384F49": "Juniper Networks",
    "5800BB": "Juniper Networks",
    "D007CA": "Juniper Networks",
    "D8B122": "Juniper Networks",
    "9CC893": "Juniper Networks",
    "58E434": "Juniper Networks",
    "B0EB7F": "Juniper Networks",
    "28B829": "Juniper Networks",
    "64C3D6": "Juniper Networks",
    "C0BFA7": "Juniper Networks",
    "B033A6": "Juniper Networks",
    "201BC9": "Juniper Networks",
    "541E56": "Juniper Networks",
    "88A25E": "Juniper Networks",
    "003146": "Juniper Networks",
    "78FE3D": "Juniper Networks",
    "648788": "Juniper Networks",
    "AC4BC8": "Juniper Networks",
    "3C94D5": "Juniper Networks",
    "50C709": "Juniper Networks",
    "00C52C": "Juniper Networks",
    "B48A5F": "Juniper Networks",
    "E0F62D": "Juniper Networks",
    "EC7C5C": "Juniper Networks",
    "DC38E1": "Juniper Networks",
    "CCE17F": "Juniper Networks",
    "807FF8": "Juniper Networks",
    "54B7BD": "Arcadyan Corporation",
    "BC73A4": "ANDA TELECOM PVT LTD",
    "14F5F9": "HUNAN FN-LINK TECHNOLOGY LIMITED",
    "AC1754": "tiko Energy Solutions AG",
    "ACE0D6": "koreabts",
    "FC5703": "Hisense broadband multimedia technology Co.",
    "E897B8": "Chiun Mai Communication System",
    "94F524": "Chengdu BeiZhongWangXin Technology Co.Ltd",
    "60FAB1": "Kempower Oyj",
    "A4C23E": "Huizhou Speed Wireless Technology Co.",
    "0050C4": "IMD",
    "001AA6": "Elbit Systems Deutschland GmbH & Co. KG",
    "7C45F9": "IEEE Registration Authority",
    "C0EAC3": "IEEE Registration Authority",
    "FCA0F3": "HUAWEI TECHNOLOGIES CO.",
    "04A81C": "HUAWEI TECHNOLOGIES CO.",
    "304074": "zte corporation",
    "10CF0F": "Apple",
    "D8638C": "Shenzhen Dttek Technology Co.",
    "1C76F2": "Samsung Electronics Co.",
    "0092A5": "LG Innotek",
    "A01077": "zte corporation",
    "7C7A3C": "New H3C Technologies Co.",
    "483177": "Nintendo Co.",
    "140FA6": "Renesas Electronics (Penang) Sdn. Bhd.",
    "148473": "Cisco Systems",
    "1CCA41": "AO",
    "347DE4": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
    "CCCF83": "CIG SHANGHAI CO LTD",
    "B4636F": "Nokia Solutions and Networks GmbH & Co. KG",
    "24D337": "Xiaomi Communications Co Ltd",
    "90314B": "AltoBeam Inc.",
    "205F3D": "Adtran Inc",
    "3C3B4D": "Toyo Seisakusho Kaisha",
    "3CBCD0": "zte corporation",
    "D0A9D3": "EM Microelectronic",
    "14DD02": "Liangang Optoelectronic Technology CO.",
    "60C727": "Digiboard Eletronica da Amazonia Ltda",
    "646E60": "zte corporation",
    "4C421E": "Cisco Systems",
    "64B2B4": "Fiberhome Telecommunication Technologies Co.",
    "4831DB": "Huawei Device Co.",
    "04F778": "Sony Interactive Entertainment Inc.",
    "58707F": "Ericsson AB",
    "D039FA": "Samsung Electronics Co.",
    "B40B1D": "Samsung Electronics Co.",
    "AC80FB": "Samsung Electronics Co.",
    "147F0F": "Texas Instruments",
    "444AD6": "Shenzhen Rinocloud Technology Co.",
    "189EAD": "Shenzhen Chengqian Information Technology Co.",
    "94DDF8": "Brother Industries",
    "84B386": "IEEE Registration Authority",
    "408EF6": "Infinix mobility limited",
    "E02DF0": "ALPSALPINE CO",
    "A45D5E": "Wilk Elektronik S.A.",
    "FC315D": "Apple",
    "74A6CD": "Apple",
    "2C7CF2": "Apple",
    "30D7A1": "Apple",
    "887477": "HUAWEI TECHNOLOGIES CO.",
    "A8727E": "WISDRI (wuhan) Automation Company Limited",
    "DCD2FD": "HUAWEI TECHNOLOGIES CO.",
    "5873D1": "HUAWEI TECHNOLOGIES CO.",
    "4CB087": "HUAWEI TECHNOLOGIES CO.",
    "88B4BE": "HUAWEI TECHNOLOGIES CO.",
    "947BAE": "Xiaomi Communications Co Ltd",
    "00C28F": "Allied Telesis K.K.",
    "F42D06": "zte corporation",
    "1C674A": "zte corporation",
    "7C5758": "HP Inc.",
    "C829C8": "Palo Alto Networks",
    "9C5322": "TP-Link Corporation Limited",
    "482254": "TP-Link Corporation Limited",
    "B4E265": "Shenzhen SDMC Technology CO.",
    "E0382D": "IEEE Registration Authority",
    "98BFF4": "MARKIN co.",
    "78605B": "TP-LINK TECHNOLOGIES CO.",
    "04F9F8": "TP-LINK TECHNOLOGIES CO.",
    "3847F2": "Recogni Inc",
    "D8AD49": "Honor Device Co.",
    "38F8F6": "Adtran Inc",
    "B484D5": "GooWi Wireless Technology Co.",
    "54077D": "NETGEAR",
    "C45379": "Micronview Limited Liability Company",
    "68FCB6": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "D8312C": "zte corporation",
    "049F15": "Humane",
    "3838A6": "Arista Networks",
    "50236D": "Nintendo Co.",
    "A03975": "Leo Bodnar Electronics Ltd",
    "F42756": "DASAN Newtork Solutions",
    "E0A1CE": "zte corporation",
    "24A6FA": "WEIFANG GOERTEK ELECTRONICS CO.",
    "7493DA": "ASKEY COMPUTER CORP",
    "C84AA0": "Sony Interactive Entertainment Inc.",
    "4C968A": "Wacom Co.",
    "EC83B7": "PUWELL CLOUD TECH LIMITED",
    "0C6422": "Beijing Wiseasy Technology Co.",
    "C8F2B4": "Guizhou Huaxin Information Technology Co.",
    "2C75CB": "Novitec Co.",
    "9C558F": "Lockin Technology(Beijing) Co.",
    "E8268D": "Shenzhen SuperElectron Technology Co.",
    "6C9106": "Katena Computing Technologies",
    "6C70CB": "Samsung Electronics Co.",
    "907BC6": "Texas Instruments",
    "904846": "Texas Instruments",
    "C47905": "Zhejiang Uniview Technologies Co.",
    "D4DA21": "Beijing Xiaomi Mobile Software Co.",
    "201A94": "Apple",
    "B0E5EF": "Apple",
    "288FF6": "Apple",
    "5027A9": "eero inc.",
    "10BBF3": "HUNAN FN-LINK TECHNOLOGY LIMITED",
    "D04E99": "HUAWEI TECHNOLOGIES CO.",
    "20A766": "HUAWEI TECHNOLOGIES CO.",
    "3C058E": "HUAWEI TECHNOLOGIES CO.",
    "A411BB": "Cisco Systems",
    "504921": "Cisco Systems",
    "44B7D0": "Microchip Technology Inc.",
    "E88F6F": "TCT mobile ltd",
    "84FCE6": "Espressif Inc.",
    "58B965": "Apple",
    "743174": "Apple",
    "F0C725": "Apple",
    "784F24": "Taicang T&W Electronics",
    "7C669A": "HUAWEI TECHNOLOGIES CO.",
    "CC1E97": "HUAWEI TECHNOLOGIES CO.",
    "B4E46B": "China Mobile IOT Company Limited",
    "CCCC77": "Zaram Technology. Inc.",
    "ECDA3B": "Espressif Inc.",
    "6813E2": "Eltex Enterprise LTD",
    "6444D5": "TD Tech",
    "F8AAB3": "DESSMANN (China) Machinery & Electronic  Co.",
    "9C5467": "Nokia",
    "B46142": "HUAWEI TECHNOLOGIES CO.",
    "BCB923": "Alta Networks",
    "8C8442": "Cisco Systems",
    "84F117": "Newseason",
    "3C0664": "Beijing Leagrid Technology Co.",
    "BC5274": "Samsung Electronics Co.",
    "BC458C": "Shenzhen Topwise Communication Co.",
    "947806": "NINGBO SUNVOT TECHNOLOGY CO.",
    "98CCE4": "Shenzhen Mindray Animal Medical Technology Co.",
    "9009DF": "Intel Corporate",
    "E40D36": "Intel Corporate",
    "149F43": "Cisco Meraki",
    "64DB38": "zte corporation",
    "2C08B4": "Huawei Device Co.",
    "5007C3": "Amazon Technologies Inc.",
    "C8EFBC": "Inspur Communication Technology Co.",
    "848DCE": "Ciena Corporation",
    "E466AB": "zte corporation",
    "A0957F": "SERNET (SUZHOU) TECHNOLOGIES CORPORATION",
    "64135A": "Itectra A/S",
    "54E1B6": "Renesas Electronics (Penang) Sdn. Bhd.",
    "CC77C9": "Fiberhome Telecommunication Technologies Co.",
    "2C572C": "Allwinner Technology Co.",
    "ECDFC9": "Hangzhou Microimage Software Co.",
    "3CE441": "Amazon Technologies Inc.",
    "444201": "Amazon Technologies Inc.",
    "E46D7F": "Ciena Corporation",
    "80276C": "Cisco Systems",
    "6C4EF6": "Cisco Systems",
    "5C2763": "Itibia Technologies",
    "40C1F6": "Shenzhen Jingxun Technology Co.",
    "FC22D3": "FDSYS",
    "B40421": "zte corporation",
    "E84368": "zte corporation",
    "4C5CDF": "ITEL MOBILE LIMITED",
    "C02E26": "iRhythm Technologies",
    "504877": "Honor Device Co.",
    "F85C7E": "Shenzhen Honesty Electronics Co.",
    "F824E4": "Beyonics Technology Electronic (Changshu) Co.",
    "1CB8BA": "XIAMEN LEELEN TECHNOLOGY CO.",
    "6C7E67": "Apple",
    "A4C6F0": "Apple",
    "A88FD9": "Apple",
    "089542": "Apple",
    "E49C67": "Apple",
    "64E220": "Qisda Corporation",
    "F0CCE0": "Shenzhen All-Smartlink Technology Co.",
    "44E2F1": "NewRadio Technologies Co.",
    "00234B": "Inyuan Technology Inc.",
    "00176E": "DUCATI SISTEMI",
    "1C6A76": "Apple",
    "78C1AE": "Hangzhou Ezviz Software Co.",
    "30C6D7": "New H3C Technologies Co.",
    "D4F242": "Huawei Device Co.",
    "0030AF": "Honeywell GmbH",
    "E886CF": "Nokia",
    "B07839": "GD Midea Air-Conditioning Equipment Co.",
    "D85482": "Oxit",
    "C4EFDA": "Honeywell",
    "D8F507": "Fiberhome Telecommunication Technologies Co.",
    "F41C71": "SHENZHEN SANMU COMMUNICATION TECHNOLOGY CO.",
    "70110E": "zte corporation",
    "98818A": "Huawei Device Co.",
    "A8AA7C": "Huawei Device Co.",
    "B4C2F7": "Huawei Device Co.",
    "D4AD20": "Jinan USR IOT Technology Limited",
    "1CFC17": "Cisco Systems",
    "E05A1B": "Espressif Inc.",
    "488AE8": "vivo Mobile Communication Co.",
    "F40595": "Sagemcom Broadband SAS",
    "10AE60": "Amazon Technologies Inc.",
    "BC107B": "Samsung Electronics Co.",
    "8812AC": "HUNAN FN-LINK TECHNOLOGY LIMITED",
    "EC74D7": "Grandstream Networks Inc",
    "28011C": "zte corporation",
    "306371": "Shenzhenshi Xinzhongxin Technology Co.Ltd",
    "98A2C0": "Cisco Systems",
    "00410E": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "FC6179": "IEEE Registration Authority",
    "1C3283": "COMTTI Intelligent Technology(Shenzhen) Co.",
    "C8848C": "Ruckus Wireless",
    "20E6DF": "eero inc.",
    "F4931C": "Universal Electronics",
    "08B61F": "Espressif Inc.",
    "CCBA6F": "HUAWEI TECHNOLOGIES CO.",
    "785C5E": "HUAWEI TECHNOLOGIES CO.",
    "3C4E56": "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.",
    "A08CF2": "YINUOLINK CO.",
    "40475E": "eero inc.",
    "5C3E1B": "Apple",
    "7C2ACA": "Apple",
    "288EEC": "Apple",
    "74375F": "SERCOMM PHILIPPINES INC",
    "C82AF1": "TCT mobile ltd",
    "3CE90E": "Espressif Inc.",
    "A842E3": "Espressif Inc.",
    "D49B74": "Kinetic Technologies",
    "480EEC": "TP-LINK TECHNOLOGIES CO.",
    "50F261": "Photon Sail Technologies",
    "944E5B": "Ubee Interactive Co.",
    "B4BA9D": "SKY UK LIMITED",
    "E08614": "Novatel Wireless Solutions",
    "40F8DF": "CANON INC.",
    "0C7FED": "IEEE Registration Authority",
    "503EAA": "TP-LINK TECHNOLOGIES CO.",
    "3CFEAC": "Cisco Systems",
    "04A741": "Cisco Systems",
    "A8DE68": "Beijing Wide Technology Co.",
    "F43BD8": "Intel Corporate",
    "A0889D": "Huawei Device Co.",
    "6C302A": "Texas Instruments",
    "7446B3": "Texas Instruments",
    "F46ADD": "Liteon Technology Corporation",
    "18E91D": "HUAWEI TECHNOLOGIES CO.",
    "18B185": "Qiao Information Technology (Zhengzhou) Co.",
    "7C0C92": "Suzhou Mobydata Smart System Co.",
    "303F5D": "PT HAN SUNG ELECTORONICS INDONESIA",
    "3C69D1": "ADC Automotive Distance Control System GmbH",
    "B0FBDD": "Shenzhen SuperElectron Technology Co.",
    "E09C8D": "Seakeeper",
    "307F10": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "A490CE": "vivo Mobile Communication Co.",
    "48706F": "HUAWEI TECHNOLOGIES CO.",
    "04BAD6": "D-Link Corporation",
    "98D742": "Samsung Electronics Co.",
    "54A9C8": "Home Control Singapore Pte Ltd",
    "A0B765": "Espressif Inc.",
    "CCDBA7": "Espressif Inc.",
    "C86C20": "Sichuan Tianyi Comheart Telecom Co.",
    "34AC11": "China Mobile Group Device Co.",
    "4432C2": "GOAL Co.",
    "70662A": "Sony Interactive Entertainment Inc.",
    "DC71DD": "AX Technologies",
    "2064DE": "Sunitec Enterprise Co.",
    "A40F98": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "74B725": "Huawei Device Co.",
    "408EDF": "Huawei Device Co.",
    "D880DC": "Huawei Device Co.",
    "E8B3EF": "Fiberhome Telecommunication Technologies Co.",
    "5CFB3A": "CHONGQING FUGUI ELECTRONICS CO.",
    "D04E50": "Mobiwire Mobiles (NingBo) Co.",
    "E8F791": "Xiaomi Communications Co Ltd",
    "F46C68": "Wistron Neweb Corporation",
    "8493B2": "zte corporation",
    "B49F4D": "Fiberhome Telecommunication Technologies Co.",
    "E83A4B": "China Mobile Group Device Co.",
    "60E9AA": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "240F5E": "Shenzhen z-router Technology Co.",
    "000C06": "Nixvue Systems  Pte Ltd",
    "18FD74": "Routerboard.com",
    "6C976D": "Motorola Mobility LLC",
    "6411A4": "Motorola Mobility LLC",
    "18863A": "DIGITAL ART SYSTEM",
    "C8D6B7": "Solidigm Technology",
    "F0877F": "Magnetar Technology Shenzhen Co.",
    "000EDB": "XiNCOM Corp.",
    "40D95A": "AMPAK Technology",
    "4CD0DD": "HUAWEI TECHNOLOGIES CO.",
    "78669D": "Hui Zhou Gaoshengda Technology Co.",
    "48468D": "Zepcam B.V.",
    "904992": "YSTen Technology Co.",
    "3CCE0D": "Shenzhen juduoping Technology Co.",
    "D0497C": "OnePlus Technology (Shenzhen) Co.",
    "74D4DD": "Quanta Computer Inc.",
    "E4902A": "HUAWEI TECHNOLOGIES CO.",
    "905E44": "HUAWEI TECHNOLOGIES CO.",
    "10F068": "Ruckus Wireless",
    "AC2929": "Infinix mobility limited",
    "50E636": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
    "7CE152": "THE GOODYEAR TIRE & RUBBER COMPANY",
    "7820BD": "Polysense (Beijing) Technologies Co. Ltd",
    "68CE4E": "L-3 Communications Infrared Products",
    "00E5F1": "BUFFALO.INC",
    "34EE2A": "ConMet",
    "F04DD4": "Sagemcom Broadband SAS",
    "684E05": "HUNAN FN-LINK TECHNOLOGY LIMITED",
    "0499BB": "Apple",
    "EC2125": "Toshiba Corp.",
    "5C1BF4": "Apple",
    "A851AB": "Apple",
    "50392F": "INGRAM MICRO SERVICES",
    "FC8417": "Honor Device Co.",
    "2CA79E": "HUAWEI TECHNOLOGIES CO.",
    "102407": "HUAWEI TECHNOLOGIES CO.",
    "74D9EB": "Petabit Scale",
    "28CDC1": "Raspberry Pi Trading Ltd",
    "C4DEE2": "Espressif Inc.",
    "68B6B3": "Espressif Inc.",
    "FCA05A": "Oray.com co.",
    "90486C": "Ring LLC",
    "C0EE40": "Laird Connectivity",
    "30045C": "Shenzhen SuperElectron Technology Co.",
    "9079CF": "zte corporation",
    "8C1E80": "Cisco Systems",
    "A4F933": "Intel Corporate",
    "10F60A": "Intel Corporate",
    "70D823": "Intel Corporate",
    "3C4645": "Shanghai Infinity Wireless Technologies Co.",
    "888FA4": "Huawei Device Co.",
    "5068AC": "Huawei Device Co.",
    "ACB566": "Renesas Electronics (Penang) Sdn. Bhd.",
    "381F26": "IEEE Registration Authority",
    "3043D7": "IEEE Registration Authority",
    "B4A7C6": "SERVERCOM (INDIA) PRIVATE LIMITED",
    "80C3BA": "Sonova Consumer Hearing GmbH",
    "487E48": "Earda Technologies co Ltd",
    "E84DEC": "Xerox Corporation",
    "C8B82F": "eero inc.",
    "A41EE1": "Taicang T&W Electronics",
    "E8FB1C": "AzureWave Technology Inc.",
    "5478C9": "AMPAK Technology",
    "286B35": "Intel Corporate",
    "4035E6": "Samsung Electronics Co.",
    "D0A46F": "China Dragon Technology Limited",
    "2C60CD": "NR ELECTRIC CO.",
    "0060E2": "QUEST ENGINEERING & DEVELOPMENT",
    "C4DF39": "Realme Chongqing Mobile Telecommunications Corp.",
    "CC60C8": "Microsoft Corporation",
    "FC101A": "Palo Alto Networks",
    "6CAEE3": "Nokia",
    "0CAC8A": "Sagemcom Broadband SAS",
    "809733": "Shenzhen Elebao Technology Co.",
    "00405F": "AFE COMPUTERS LTD.",
    "00EBD8": "MERCUSYS TECHNOLOGIES CO.",
    "7404F1": "Intel Corporate",
    "00A265": "M2Motive Technology Inc.",
    "F46D2F": "TP-LINK TECHNOLOGIES CO.",
    "1054D2": "IEEE Registration Authority",
    "B85DC3": "HUAWEI TECHNOLOGIES CO.",
    "B43AE2": "HUAWEI TECHNOLOGIES CO.",
    "F0C8B5": "HUAWEI TECHNOLOGIES CO.",
    "D8365F": "Intelbras",
    "DCFE23": "Murata Manufacturing Co.",
    "347379": "xFusion Digital Technologies Co.",
    "D83DCC": "shenzhen UDD Technologies",
    "AC80AE": "Fiberhome Telecommunication Technologies Co.",
    "BC606B": "Shanghai Baud Data Communication Co.",
    "0417B6": "Smart Innovation LLC",
    "E8C7CF": "Wistron Neweb Corporation",
    "CC5C61": "Huawei Device Co.",
    "1CF42B": "Huawei Device Co.",
    "6C51BF": "Huawei Device Co.",
    "6C8D77": "Cisco Systems",
    "7411B2": "Cisco Systems",
    "04E69E": "ZHONGGUANCUN XINHAIZEYOU TECHNOLOGY CO.",
    "00198E": "Demant A/S",
    "60FB00": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
    "D09200": "FiRa Consortium",
    "E893F3": "Graphiant Inc",
    "7CC180": "Apple",
    "280244": "Apple",
    "E85F02": "Apple",
    "BCDF58": "Google",
    "2C301A": "Technicolor CH USA Inc for Telus",
    "C814B4": "Sichuan Tianyi Comheart Telecom Co.",
    "C049EF": "Espressif Inc.",
    "E42B79": "Nokia",
    "ECE7A7": "Intel Corporate",
    "94B555": "Espressif Inc.",
    "74F2FA": "Xiaomi Communications Co Ltd",
    "5C843C": "Sony Interactive Entertainment Inc.",
    "E8AEC5": "Arista Networks",
    "588FCF": "Hangzhou Ezviz Software Co.",
    "4017F6": "TKH SECURITY",
    "3CE9F7": "Intel Corporate",
    "185E0B": "zte corporation",
    "D0BB61": "zte corporation",
    "60A6C5": "HUAWEI TECHNOLOGIES CO.",
    "208C86": "HUAWEI TECHNOLOGIES CO.",
    "F0A951": "HUAWEI TECHNOLOGIES CO.",
    "004058": "UKG",
    "F4CE23": "Intel Corporate",
    "A84FB1": "Cisco Systems",
    "54ACFC": "LIZN ApS",
    "4C7274": "Shenzhenshi Xinzhongxin Technology Co.Ltd",
    "A439B3": "Beijing Xiaomi Mobile Software Co.",
    "6CFFCE": "Sagemcom Broadband SAS",
    "C899B2": "Arcadyan Corporation",
    "AC7352": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "50C275": "GN Audio A/S",
    "C8727E": "Nokia",
    "0CB815": "Espressif Inc.",
    "6425EC": "guangdong kesheng zhixun technology",
    "00E0CD": "SAAB SENSIS CORPORATION",
    "800CF9": "Amazon Technologies Inc.",
    "A09208": "Tuya Smart Inc.",
    "F4B898": "Texas Instruments",
    "B0D278": "Texas Instruments",
    "0024B6": "Seagate Technology",
    "64D69A": "Intel Corporate",
    "E0A25A": "Shanghai Mo xiang Network Technology CO.",
    "E484D3": "Xiaomi Communications Co Ltd",
    "04106B": "Xiaomi Communications Co Ltd",
    "04CCBC": "HUAWEI TECHNOLOGIES CO.",
    "1CE504": "HUAWEI TECHNOLOGIES CO.",
    "2C0BAB": "HUAWEI TECHNOLOGIES CO.",
    "94D2BC": "HUAWEI TECHNOLOGIES CO.",
    "2887BA": "TP-Link Corporation Limited",
    "3460F9": "TP-Link Corporation Limited",
    "684AE9": "Samsung Electronics Co.",
    "201F54": "Raisecom Technology CO.",
    "7C97E1": "Huawei Device Co.",
    "C83E9E": "Huawei Device Co.",
    "E0D045": "Intel Corporate",
    "60DD70": "Apple",
    "98A5F9": "Apple",
    "ECA907": "Apple",
    "34CE69": "Nokia Solutions and Networks GmbH & Co. KG",
    "940D2D": "Universal Electronics",
    "A88C3E": "Microsoft Corporation",
    "4C06B7": "ProDVX Europe B.V.",
    "605747": "CIG SHANGHAI CO LTD",
    "F82551": "Seiko Epson Corporation",
    "7453A8": "ACL Airshop BV",
    "147EA1": "Britania Eletrônicos S.A.",
    "E81656": "Hangzhou BroadLink Technology Co.",
    "149E5D": "JSC IB Reform",
    "70B8F6": "Espressif Inc.",
    "BC4760": "Samsung Electronics Co.",
    "2C4DDE": "TECNO MOBILE LIMITED",
    "303F7B": "Shenzhen YOUHUA Technology Co.",
    "14EBB6": "TP-Link Corporation Limited",
    "54AF97": "TP-Link Corporation Limited",
    "54CF8D": "HUAWEI TECHNOLOGIES CO.",
    "0CB789": "Honor Device Co.",
    "F0B040": "HUNAN FN-LINK TECHNOLOGY LIMITED",
    "D48866": "HUAWEI TECHNOLOGIES CO.",
    "D48457": "GD Midea Air-Conditioning Equipment Co.",
    "FC0296": "Xiaomi Communications Co Ltd",
    "68BE49": "Nebula Matrix",
    "94F827": "Shanghai Imilab Technology Co.Ltd",
    "D8CFBF": "Motorola Mobility LLC",
    "1845B3": "IEEE Registration Authority",
    "60E85B": "Texas Instruments",
    "C448FA": "Taicang T&W Electronics",
    "A89892": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "E0720A": "Shenzhen SuperElectron Technology Co.",
    "24D904": "Sichuan Changhong Network Technologies Co.",
    "483E5E": "SERNET (SUZHOU) TECHNOLOGIES CORPORATION",
    "50EBF6": "ASUSTek COMPUTER INC.",
    "60FF12": "Samsung Electronics Co.",
    "24C613": "Samsung Electronics Co.",
    "94E129": "Samsung Electronics Co.",
    "2804C6": "Wanan Hongsheng Electronic Co.Ltd",
    "C44F96": "Alps Alpine",
    "685811": "Fiberhome Telecommunication Technologies Co.",
    "B4BA02": "Agatel Ltd",
    "D47954": "Huawei Device Co.",
    "C839AC": "Huawei Device Co.",
    "145594": "Huawei Device Co.",
    "08C06C": "Huawei Device Co.",
    "3C457A": "SKY UK LIMITED",
    "902759": "Nanjing Jiahao Technology Co.",
    "84BA20": "Silicon Laboratories",
    "003C84": "Silicon Laboratories",
    "281D21": "IN ONE SMART TECHNOLOGY(H",
    "74E336": "FUJIAN STAR-NET COMMUNICATION CO.",
    "C4345B": "HUAWEI TECHNOLOGIES CO.",
    "B0739C": "Amazon Technologies Inc.",
    "3C219C": "Intel Corporate",
    "DC6294": "Guangzhou Lango Electronics Technology Co.",
    "3498B5": "NETGEAR",
    "1859F5": "Cisco Systems",
    "703217": "Intel Corporate",
    "389461": "Renesas Electronics (Penang) Sdn. Bhd.",
    "485519": "Espressif Inc.",
    "5C46B0": "SIMCom Wireless Solutions Limited",
    "C02C5C": "Apple",
    "EC4269": "HMD Global Oy",
    "D45763": "Apple",
    "48B9C2": "Teletics Inc.",
    "90F3B8": "China Mobile Group Device Co.",
    "38563D": "Microsoft Corporation",
    "28937D": "Sichuan Tianyi Comheart Telecom Co.",
    "1C73E2": "HUAWEI TECHNOLOGIES CO.",
    "8C83E8": "HUAWEI TECHNOLOGIES CO.",
    "34A5B4": "NAVTECH PTE LTD",
    "E89F6D": "Espressif Inc.",
    "F829C0": "Availink",
    "24B72A": "China Dragon Technology Limited",
    "F8FCE1": "Amazon Technologies Inc.",
    "6457E5": "Beijing Royaltech Co.",
    "FC9BD4": "EdgeQ",
    "145790": "Qingdao Haier Technology Co.",
    "405F7D": "TCT mobile ltd",
    "986EE8": "IEEE Registration Authority",
    "D4C3B0": "Gearlinx Pty Ltd",
    "E070EA": "HP Inc.",
    "08B49D": "TECNO MOBILE LIMITED",
    "04D921": "Occuspace",
    "4C034F": "Intel Corporate",
    "942957": "Airpo Networks Technology Co.",
    "9877CB": "Vorteks ED",
    "C436C0": "BUFFALO.INC",
    "B88A72": "Renesas Electronics (Penang) Sdn. Bhd.",
    "88D82E": "Intel Corporate",
    "50547B": "Nanjing Qinheng Microelectronics Co.",
    "4CEAAE": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "D41AD1": "Zyxel Communications Corporation",
    "B845F4": "New H3C Technologies Co.",
    "EC01D5": "Cisco Systems",
    "2C53D7": "Sonova AG",
    "E8979A": "Quectel Wireless Solutions Co.",
    "5CA6E6": "TP-Link Corporation Limited",
    "B4B024": "TP-Link Corporation Limited",
    "18F22C": "TP-LINK TECHNOLOGIES CO.",
    "9897CC": "TP-LINK TECHNOLOGIES CO.",
    "180EAC": "SHENZHEN FAST TECHNOLOGIES CO.",
    "144920": "HUAWEI TECHNOLOGIES CO.",
    "DCA782": "HUAWEI TECHNOLOGIES CO.",
    "045170": "Zhongshan K-mate General Electronics Co.",
    "384554": "Harman/Becker Automotive Systems GmbH",
    "3CE4B0": "Texas Instruments",
    "E80115": "COOCAA Network Technology CO.",
    "8CEA12": "Shenzhen MiaoMing  Intelligent Technology Co.",
    "C8BD4D": "Samsung Electronics Co.",
    "8881B9": "Huawei Device Co.",
    "3C38F4": "Sony Corporation",
    "0CC413": "Google",
    "7463C2": "Huawei Device Co.",
    "D48FA2": "Huawei Device Co.",
    "2C15BF": "Samsung Electronics Co.",
    "2CB0FD": "Shenzhen MiaoMing  Intelligent Technology Co.",
    "C4FBC8": "Shenzhen Candour Co.",
    "2CE032": "TCL King Electrical Appliances(Huizhou)Co.",
    "A0D2B1": "Amazon Technologies Inc.",
    "806D71": "Amazon Technologies Inc.",
    "88AC9E": "Shenzhen YOUHUA Technology Co.",
    "9C36F8": "Hyundai Kefico",
    "E0B72E": "ShenZhen Qualmesh Technology Co.",
    "081605": "Vodafone Italia S.p.A.",
    "1C53F9": "Google",
    "04421A": "ASUSTek COMPUTER INC.",
    "207C14": "Qotom",
    "B859CE": "Earda Technologies co Ltd",
    "100020": "Apple",
    "BC1E85": "HUAWEI TECHNOLOGIES CO.",
    "B85600": "HUAWEI TECHNOLOGIES CO.",
    "305F77": "New H3C Technologies Co.",
    "8C7A3D": "Xiaomi Communications Co Ltd",
    "987EE3": "vivo Mobile Communication Co.",
    "8C7AAA": "Apple",
    "7C2499": "Apple",
    "000D4E": "NDR Co.",
    "305696": "Infinix mobility limited",
    "7CB073": "Realme Chongqing Mobile Telecommunications Corp.",
    "0CE5A3": "SharkNinja",
    "34317F": "Panasonic Appliances Company",
    "409151": "Espressif Inc.",
    "B0E9FE": "Woan Technology (Shenzhen) Co.",
    "C89665": "Microsoft Corporation",
    "CC3F8A": "KOMATSU LTD.",
    "EC354D": "Wingtech Mobile Communications Co.",
    "7C3985": "HUAWEI TECHNOLOGIES CO.",
    "00BD3E": "Vizio",
    "18F87F": "Wha Yu Industrial Co.",
    "40E1E4": "Nokia Solutions and Networks GmbH & Co. KG",
    "90F157": "Garmin International",
    "FC5C45": "Ruckus Wireless",
    "10F605": "Realme Chongqing Mobile Telecommunications Corp.",
    "5C8F40": "TECNO MOBILE LIMITED",
    "584849": "IEEE Registration Authority",
    "E075AA": "Beijing Jingling Information System Technology Co.",
    "E446B0": "Fujitsu Client Computing Limited",
    "44AE44": "Huawei Device Co.",
    "444F8E": "WiZ",
    "0899E8": "KEMAS GmbH",
    "04B86A": "SKY UK LIMITED",
    "54CE82": "zte corporation",
    "80CBBC": "Qingdao Intelligent&Precise Electronics Co.",
    "F4A475": "Intel Corporate",
    "C89E43": "NETGEAR",
    "2864EF": "Shenzhen Fsan Intelligent Technology Co.",
    "180712": "Shenzhen Dazoo Technologies CO.",
    "F02A2B": "IEEE Registration Authority",
    "20BECD": "eero inc.",
    "04ECD8": "Intel Corporate",
    "700777": "OnTarget Technologies",
    "000534": "Northstar Engineering Ltd.",
    "BC091B": "Intel Corporate",
    "0026A7": "CONNECT SRL",
    "8C1D96": "Intel Corporate",
    "60DD8E": "Intel Corporate",
    "90593C": "AZ-TECHNOLOGY SDN BHD",
    "1CC10C": "Intel Corporate",
    "00BFAF": "Hui Zhou Gaoshengda Technology Co.",
    "B4ECFF": "Wuhan IPG Technologies Co.",
    "F057A6": "Intel Corporate",
    "642677": "BKM-Micronic Richtfunkanlagen GmbH",
    "1CE639": "HUAWEI TECHNOLOGIES CO.",
    "8C6794": "vivo Mobile Communication Co.",
    "001441": "Innovation Sound Technology Co.",
    "20D778": "Texas Instruments",
    "4C2FD7": "Huawei Device Co.",
    "D47415": "Huawei Device Co.",
    "50586F": "Huawei Device Co.",
    "F0B13F": "Huawei Device Co.",
    "7CC255": "Super Micro Computer",
    "0064AF": "Dish Technologies Corp",
    "E4B503": "Realme Chongqing Mobile Telecommunications Corp.",
    "ECF40C": "Cisco Systems",
    "1006ED": "Cisco Systems",
    "D4EB68": "Cisco Systems",
    "C44D84": "Cisco Systems",
    "102CEF": "EMU Electronic AG",
    "C0D063": "EM Microelectronic",
    "7C10C9": "ASUSTek COMPUTER INC.",
    "38FF13": "Joint Stock Company Research Instinite Masshtab",
    "D0DBB7": "Casa Systems",
    "205383": "HUAWEI TECHNOLOGIES CO.",
    "B8857B": "HUAWEI TECHNOLOGIES CO.",
    "50D065": "ESYLUX GmbH",
    "A8671E": "RATP",
    "8CE9B4": "Zhejiang Dahua Technology Co.",
    "D88C73": "zte corporation",
    "E87865": "Apple",
    "B4CDF5": "CUB ELECPARTS INC.",
    "A04ECF": "Apple",
    "0887C7": "Apple",
    "3865B2": "Apple",
    "D8DE3A": "Apple",
    "08855B": "Kontron Europe GmbH",
    "E84FA7": "Huawei Device Co.",
    "449F46": "Huawei Device Co.",
    "345184": "Huawei Device Co.",
    "FCF77B": "Huawei Device Co.",
    "844709": "Shenzhen IP3 Century Intelligent Technology CO.",
    "5CD06E": "Xiaomi Communications Co Ltd",
    "0091EB": "Renesas Electronics (Penang) Sdn. Bhd.",
    "DCF56E": "Wellysis Corp.",
    "EC08E5": "Motorola Mobility LLC",
    "80CC9C": "NETGEAR",
    "280FEB": "LG Innotek",
    "74E20C": "Amazon Technologies Inc.",
    "4CD577": "CHONGQING FUGUI ELECTRONICS CO.",
    "745D68": "Fiberhome Telecommunication Technologies Co.",
    "20CFAE": "Cisco Systems",
    "CC1531": "Intel Corporate",
    "C0F9B0": "HUAWEI TECHNOLOGIES CO.",
    "148C4A": "HUAWEI TECHNOLOGIES CO.",
    "609BB4": "HUAWEI TECHNOLOGIES CO.",
    "105403": "INTARSO GmbH",
    "7C27BC": "Hui Zhou Gaoshengda Technology Co.",
    "C0238D": "Samsung Electronics Co.",
    "507097": "China Mobile Group Device Co.",
    "0C6046": "vivo Mobile Communication Co.",
    "CC2D8C": "LG ELECTRONICS INC",
    "0C9A3C": "Intel Corporate",
    "DC2148": "Intel Corporate",
    "44DB60": "Nanjing Baihezhengliu Technology Co.",
    "B8B77D": "Guangdong Transtek Medical Electronics CO.",
    "C478A2": "Huawei Device Co.",
    "C0FBF9": "IEEE Registration Authority",
    "2811A8": "Intel Corporate",
    "74CF00": "Shenzhen SuperElectron Technology Co.",
    "589153": "China Mobile IOT Company Limited",
    "987DDD": "China Mobile Group Device Co.",
    "B81332": "AMPAK Technology",
    "ACE14F": "Autonomic Controls",
    "AC976C": "Greenliant",
    "2CEADC": "ASKEY COMPUTER CORP",
    "9C5A81": "Xiaomi Communications Co Ltd",
    "643AB1": "Sichuan Tianyi Comheart Telecom Co.",
    "8048A5": "Sichuan Tianyi Comheart Telecom Co.",
    "44BA46": "Sichuan Tianyi Comheart Telecom Co.",
    "9C32A9": "Sichuan Tianyi Comheart Telecom Co.",
    "908674": "Sichuan Tianyi Comheart Telecom Co.",
    "9C9E71": "Huawei Device Co.",
    "98499F": "Domo Tactical Communications",
    "88C9B3": "IEEE Registration Authority",
    "5813D3": "Gemtek Technology Co.",
    "201E88": "Intel Corporate",
    "206A94": "Hitron Technologies. Inc",
    "309587": "HUNAN FN-LINK TECHNOLOGY LIMITED",
    "20CE2A": "IEEE Registration Authority",
    "7CF666": "Tuya Smart Inc.",
    "68262A": "Sichuan Tianyi Comheart Telecom Co.",
    "B8224F": "Sichuan Tianyi Comheart Telecom Co.",
    "C8BD69": "Samsung Electronics Co.",
    "A87650": "Samsung Electronics Co.",
    "54D17D": "Samsung Electronics Co.",
    "603AAF": "Samsung Electronics Co.",
    "C04B13": "WonderSound Technology Co.",
    "9C7F81": "SHENZHEN FAST TECHNOLOGIES CO.",
    "642753": "Huawei Device Co.",
    "28534E": "HUAWEI TECHNOLOGIES CO.",
    "5CB00A": "HUAWEI TECHNOLOGIES CO.",
    "00E5E4": "Sichuan Tianyi Comheart Telecom Co.",
    "1469A2": "Sichuan Tianyi Comheart Telecom Co.",
    "046B25": "Sichuan Tianyi Comheart Telecom Co.",
    "1012B4": "Sichuan Tianyi Comheart Telecom Co.",
    "102D41": "Sichuan AI-Link Technology Co.",
    "DC87CB": "Beijing Perfectek Technologies Co.",
    "F40228": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
    "0C83CC": "Alpha Networks Inc.",
    "C8B6FE": "Fitbit",
    "187CAA": "China Mobile Group Device Co.",
    "001CC5": "3Com Ltd",
    "E84F25": "Murata Manufacturing Co.",
    "0425E0": "Taicang T&W Electronics",
    "385247": "Huawei Device Co.",
    "C4BCD7": "New Ryatek",
    "C0AEFD": "Shenzhen HC-WLAN Technology Co.",
    "C0DCD7": "Huawei Device Co.",
    "3037B3": "HUAWEI TECHNOLOGIES CO.",
    "3085EB": "Fiberhome Telecommunication Technologies Co.",
    "8406FA": "Fiberhome Telecommunication Technologies Co.",
    "B8D43E": "vivo Mobile Communication Co.",
    "14CB19": "HP Inc.",
    "ECB970": "Ruijie Networks Co.",
    "308398": "Espressif Inc.",
    "F889D2": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "1027F5": "TP-Link Corporation Limited",
    "848C8D": "Apple",
    "0CE441": "Apple",
    "B82AA9": "Apple",
    "7864C0": "Apple",
    "E81CD8": "Apple",
    "3C0630": "Apple",
    "741575": "Xiaomi Communications Co Ltd",
    "7C55A7": "Kastle Systems",
    "FCE806": "Edifier International",
    "3078D3": "Virgilant Technologies Ltd.",
    "0017E8": "Texas Instruments",
    "E8EA4D": "HUAWEI TECHNOLOGIES CO.",
    "3CFFD8": "HUAWEI TECHNOLOGIES CO.",
    "40BEEE": "Shenzhen Yunding Information Technology Co.",
    "A44C62": "Hangzhou Microimage Software Co.",
    "CC86EC": "Silicon Laboratories",
    "9C8281": "vivo Mobile Communication Co.",
    "4C617E": "Huawei Device Co.",
    "E0E37C": "Huawei Device Co.",
    "2418C6": "HUNAN FN-LINK TECHNOLOGY LIMITED",
    "50C2ED": "GN Audio A/S",
    "90A822": "Amazon Technologies Inc.",
    "0C5CB5": "IEEE Registration Authority",
    "74AD98": "Cisco Systems",
    "649714": "eero inc.",
    "B4107B": "Texas Instruments",
    "00C06A": "Zahner-Elektrik Ingeborg Zahner-Schiller GmbH & Co. KG.",
    "8C4361": "Hailo Digital Hub GmbH & Co. KG",
    "4851CF": "Intelbras",
    "4C5D3C": "Cisco Systems",
    "34732D": "Cisco Systems",
    "E44164": "Nokia",
    "0881B2": "Logitech (China) Technology Co.",
    "C4F174": "eero inc.",
    "28D0EA": "Intel Corporate",
    "E00CE5": "HUAWEI TECHNOLOGIES CO.",
    "D4475A": "ScreenBeam",
    "78A6A0": "Hangzhou Ezviz Software Co.",
    "F46B8C": "Hon Hai Precision Industry Co.",
    "FC3497": "ASUSTek COMPUTER INC.",
    "AC139C": "Adtran Inc",
    "A4CEDA": "Arcadyan Corporation",
    "847AB6": "AltoBeam (China) Inc.",
    "047BCB": "Universal Global Scientific Industrial Co.",
    "2841EC": "HUAWEI TECHNOLOGIES CO.",
    "7C004D": "HUAWEI TECHNOLOGIES CO.",
    "1C9957": "Intel Corporate",
    "04D320": "ITEL MOBILE LIMITED",
    "8C3446": "Huawei Device Co.",
    "804786": "Samsung Electronics Co.",
    "34E9FE": "Metis Co.",
    "98C3D2": "Ningbo Sanxing Medical Electric Co.",
    "245DFC": "IEEE Registration Authority",
    "D8ECE5": "Zyxel Communications Corporation",
    "C470AB": "Ruijie Networks Co.",
    "CC6B1E": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "F0D08C": "TCT mobile ltd",
    "E0E8BB": "Unicom Vsens Telecommunications Co.",
    "982782": "IEEE Registration Authority",
    "FC4009": "zte corporation",
    "24A65E": "zte corporation",
    "509839": "Xiaomi Communications Co Ltd",
    "CC812A": "vivo Mobile Communication Co.",
    "7C1B93": "Huawei Device Co.",
    "DC2D3C": "Huawei Device Co.",
    "E455A8": "Cisco Meraki",
    "30F94B": "Universal Electronics",
    "041119": "IEEE Registration Authority",
    "38A067": "Nokia Solutions and Networks GmbH & Co. KG",
    "18A6F7": "TP-LINK TECHNOLOGIES CO.",
    "E4C90B": "Radwin",
    "6407F6": "Samsung Electronics Co.",
    "5CC336": "ittim",
    "FC041C": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "003DE1": "Huawei Device Co.",
    "F06F46": "Ubiik",
    "B06088": "Intel Corporate",
    "48007D": "DTS ELEKTRONIK SAN. TIC. LTD. STI.",
    "30B1B5": "Arcadyan Corporation",
    "68ABBC": "Beijing Xiaomi Mobile Software Co.",
    "F4D488": "Apple",
    "682F67": "Apple",
    "50ED3C": "Apple",
    "D814DF": "TCL King Electrical Appliances (Huizhou) Co.",
    "90027A": "Shenzhen Sworix Techonlogy Co.",
    "D05AFD": "Realme Chongqing Mobile Telecommunications Corp.",
    "34C103": "Hangzhou Huamu Technology Co.",
    "584120": "TP-LINK TECHNOLOGIES CO.",
    "3C06A7": "TP-LINK TECHNOLOGIES CO.",
    "24E927": "TomTom International BV",
    "F0F564": "Samsung Electronics Co.",
    "708976": "Tuya Smart Inc.",
    "245B83": "Renesas Electronics (Penang) Sdn. Bhd.",
    "845CF3": "Intel Corporate",
    "2C793D": "Boditech Med",
    "6C02E0": "HP Inc.",
    "F0ACA4": "HBC-radiomatic",
    "64D7C0": "Huawei Device Co.",
    "946010": "Huawei Device Co.",
    "903CB3": "Edgecore Networks Corporation",
    "802278": "China Mobile IOT Company Limited",
    "6413AB": "HUAWEI TECHNOLOGIES CO.",
    "0C7329": "Sercomm Corporation.",
    "6C13D5": "Cisco Systems",
    "F89725": "OPPLE LIGHTING CO.",
    "5466F9": "ConMet",
    "8C64D4": "Hyeco Smart Tech Co.",
    "14230A": "HUAWEI TECHNOLOGIES CO.",
    "58AEA8": "HUAWEI TECHNOLOGIES CO.",
    "6CD704": "HUAWEI TECHNOLOGIES CO.",
    "543AD6": "Samsung Electronics Co.",
    "544617": "zte corporation",
    "8444AF": "Zhejiang Tmall Technology Co.",
    "8CDEF9": "Beijing Xiaomi Mobile Software Co.",
    "D03C1F": "Intel Corporate",
    "A03D6E": "Cisco Systems",
    "B08BD0": "Cisco Systems",
    "5C85F8": "SHENZHEN KAIFA TECHNOLOGY CO.",
    "9CBCF0": "Xiaomi Communications Co Ltd",
    "0C4885": "LG Electronics (Mobile Communications)",
    "70E46E": "Lytx",
    "58AE2B": "Huawei Device Co.",
    "E43C80": "University of Oklahoma",
    "A8F766": "ITE Tech Inc",
    "7C210D": "Cisco Systems",
    "34FEC5": "Shenzhen Sunwoda intelligent hardware Co.",
    "94A67E": "NETGEAR",
    "FCD436": "Motorola Mobility LLC",
    "0CEC8D": "Motorola Mobility LLC",
    "184F5D": "JRC Mobility Inc.",
    "103F44": "Xiaomi Communications Co Ltd",
    "8C3401": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "000BDE": "TELDIX GmbH",
    "A46BB6": "Intel Corporate",
    "FC0C45": "Shenzhen SuperElectron Technology Co.",
    "5467E6": "SHENZHEN MTC CO LTD",
    "D439B8": "Ciena Corporation",
    "249F89": "Texas Instruments",
    "247625": "Texas Instruments",
    "F87A41": "Cisco Systems",
    "84F147": "Cisco Systems",
    "74E9BF": "HUAWEI TECHNOLOGIES CO.",
    "D8109F": "HUAWEI TECHNOLOGIES CO.",
    "3C5447": "HUAWEI TECHNOLOGIES CO.",
    "006B6F": "HUAWEI TECHNOLOGIES CO.",
    "603573": "Earda Technologies co Ltd",
    "A49733": "ASKEY COMPUTER CORP",
    "F02F74": "ASUSTek COMPUTER INC.",
    "006E02": "Xovis AG",
    "2C1875": "Skyworth Digital Technology(Shenzhen) Co.",
    "D06EDE": "Sagemcom Broadband SAS",
    "08CBE5": "R3 Solutions GmbH",
    "482567": "Poly",
    "A89AD7": "Nokia",
    "181171": "Guangzhou Doctorpai Education & Technology Co.",
    "ACF85C": "Chengdu Higon Integrated Circuit Design Co",
    "00E93A": "AzureWave Technology Inc.",
    "78F09B": "Huawei Device Co.",
    "48EF61": "Huawei Device Co.",
    "E07726": "Huawei Device Co.",
    "44F21B": "Apple",
    "74650C": "Apple",
    "E06D17": "Apple",
    "F0B3EC": "Apple",
    "F465A6": "Apple",
    "F023AE": "AMPAK Technology",
    "0034A1": "RF-LAMBDA USA INC.",
    "249494": "Hong Kong Bouffalo Lab Limited",
    "30BE3B": "Mitsubishi Electric Corporation",
    "3CA37E": "HUAWEI TECHNOLOGIES CO.",
    "7898E8": "D-Link International",
    "F8E43B": "ASIX Electronics Corporation",
    "60DB98": "Calix Inc.",
    "6872C3": "Samsung Electronics Co.",
    "70B13D": "Samsung Electronics Co.",
    "F85EA0": "Intel Corporate",
    "14563A": "Huawei Device Co.",
    "7090B7": "Huawei Device Co.",
    "38FC98": "Intel Corporate",
    "502F9B": "Intel Corporate",
    "00188C": "Mobile Action Technology Inc.",
    "1C90BE": "Ericsson AB",
    "342B70": "Arris",
    "4C0220": "Xiaomi Communications Co Ltd",
    "D41B81": "CHONGQING FUGUI ELECTRONICS CO.",
    "F40B9F": "CIG SHANGHAI CO LTD",
    "C094AD": "zte corporation",
    "5C6199": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "E8DB84": "Espressif Inc.",
    "A07751": "ASMedia Technology Inc.",
    "305684": "SHENZHEN YUNJI INTELLIGENT TECHNOLOGY CO.",
    "00081E": "Repeatit AB",
    "74731D": "ifm electronic gmbh",
    "001F94": "Lascar Electronics Ltd",
    "787DF3": "Sterlite Technologies Limited",
    "D05509": "Nintendo Co.",
    "9CB2E8": "HUAWEI TECHNOLOGIES CO.",
    "088FC3": "COMPAL INFORMATION (KUNSHAN) CO.",
    "D021AC": "Yohana",
    "7845B3": "Huawei Device Co.",
    "20DCFD": "Huawei Device Co.",
    "FC65B3": "Huawei Device Co.",
    "109D7A": "Huawei Device Co.",
    "DC6373": "OBARA KOREA",
    "D47EE4": "China Mobile IOT Company Limited",
    "1CA852": "SENSAIO PTE LTD",
    "401C83": "Intel Corporate",
    "443B32": "Intelbras",
    "683E26": "Intel Corporate",
    "8C554A": "Intel Corporate",
    "549FC6": "Cisco Systems",
    "F01D2D": "Cisco Systems",
    "0055B1": "Shanghai Baud Data Communication Co.",
    "74901F": "Ragile Networks Inc.",
    "88892F": "HUAWEI TECHNOLOGIES CO.",
    "28E5B0": "HUAWEI TECHNOLOGIES CO.",
    "38CA73": "Shenzhen MiaoMing  Intelligent Technology Co.",
    "6C0DC4": "Beijing Xiaomi Electronics Co.",
    "C440F6": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "E01CFC": "D-Link International",
    "204EF6": "AzureWave Technology Inc.",
    "FC449F": "zte corporation",
    "9860CA": "Apple",
    "4490BB": "Apple",
    "34FD6A": "Apple",
    "443583": "Apple",
    "0C8B7D": "Vizio",
    "0023E9": "F5 Networks",
    "3C7C3F": "ASUSTek COMPUTER INC.",
    "24470E": "PentronicAB",
    "8CD67F": "EM Microelectronic",
    "34916F": "UserGate Ltd.",
    "142C78": "GooWi Wireless Technology Co.",
    "98FC84": "IEEE Registration Authority",
    "EC4D3E": "Beijing Xiaomi Mobile Software Co.",
    "EC3EB3": "Zyxel Communications Corporation",
    "D8A491": "Huawei Device Co.",
    "681324": "Huawei Device Co.",
    "A8C092": "Huawei Device Co.",
    "5C91FD": "Jaewoncnc",
    "F82E3F": "HUAWEI TECHNOLOGIES CO.",
    "90A5AF": "HUAWEI TECHNOLOGIES CO.",
    "0476B0": "Cisco Systems",
    "40F078": "Cisco Systems",
    "78D71A": "Ciena Corporation",
    "24B105": "Prama Hikvision India Private Limited",
    "709CD1": "Intel Corporate",
    "4CAEEC": "Guangzhou limee technology co.",
    "8060B7": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "DC7223": "Hui Zhou Gaoshengda Technology Co.",
    "90AAC3": "Hitron Technologies. Inc",
    "44917C": "HMD Global Oy",
    "245F9F": "Huawei Device Co.",
    "CCB0A8": "Huawei Device Co.",
    "502873": "Huawei Device Co.",
    "3420E3": "Ruckus Wireless",
    "20F44F": "Nokia",
    "345594": "FUJIAN STAR-NET COMMUNICATION CO.",
    "4C93A6": "IEEE Registration Authority",
    "CC47BD": "Rhombus Systems",
    "40AA56": "China Dragon Technology Limited",
    "68545A": "Intel Corporate",
    "4CB99B": "WEIFANG GOERTEK ELECTRONICS CO.",
    "BC7E8B": "Samsung Electronics Co.",
    "9C6B37": "Renesas Electronics (Penang) Sdn. Bhd.",
    "A83759": "Huawei Device Co.",
    "50F7ED": "Huawei Device Co.",
    "001E31": "infomark",
    "3CE3E7": "China Mobile Group Device Co.",
    "5488DE": "Cisco Systems",
    "24FD0D": "Intelbras",
    "0C31DC": "HUAWEI TECHNOLOGIES CO.",
    "40DDD1": "Beautiful Card Corporation",
    "C0E7BF": "Sichuan AI-Link Technology Co.",
    "6433DB": "Texas Instruments",
    "A406E9": "Texas Instruments",
    "B0B113": "Texas Instruments",
    "E0B260": "TENO NETWORK TECHNOLOGIES COMPANY LIMITED",
    "346D9C": "Carrier Corporation",
    "7CF9A0": "Fiberhome Telecommunication Technologies Co.",
    "6CA4D1": "Fiberhome Telecommunication Technologies Co.",
    "A446B4": "Huawei Device Co.",
    "DCD444": "Huawei Device Co.",
    "D4F756": "zte corporation",
    "482335": "Dialog Semiconductor Hellas SA",
    "E8DA20": "Nintendo Co.",
    "70828E": "OleumTech Corporation",
    "20A171": "Amazon Technologies Inc.",
    "E0693A": "Innophase Inc.",
    "0002AC": "3PAR data",
    "782B64": "Bose Corporation",
    "54AB3A": "Quanta Computer Inc.",
    "E89A8F": "Quanta Computer Inc.",
    "EC6C9A": "Arcadyan Corporation",
    "10BC97": "vivo Mobile Communication Co.",
    "4401BB": "SHENZHEN BILIAN ELECTRONIC CO.，LTD",
    "C80210": "LG Innotek",
    "001EB2": "LG Innotek",
    "3C53D7": "CEDES AG",
    "44680C": "Wacom Co.",
    "980E24": "Phytium Technology Co.",
    "A830BC": "Samsung Electronics Co.",
    "7846D4": "Samsung Electronics Co.",
    "1C98C1": "CLOUD NETWORK TECHNOLOGY SINGAPORE PTE. LTD.",
    "A09B17": "Taicang T&W Electronics",
    "E06CA6": "Creotech Instruments S.A.",
    "A0D83D": "Fiberhome Telecommunication Technologies Co.",
    "58F2FC": "Huawei Device Co.",
    "507043": "SKY UK LIMITED",
    "E8136E": "HUAWEI TECHNOLOGIES CO.",
    "4CAE13": "HUAWEI TECHNOLOGIES CO.",
    "4C2EFE": "Shenzhen Comnect Technology Co.",
    "C086B3": "Shenzhen Voxtech Co.",
    "44ADB1": "Sagemcom Broadband SAS",
    "643AEA": "Cisco Systems",
    "D01411": "IEEE Registration Authority",
    "E4268B": "Huawei Device Co.",
    "C0E3A0": "Renesas Electronics (Penang) Sdn. Bhd.",
    "8CE468": "Guangzhou Sageran Technology Co.",
    "2848E7": "Huawei Device Co.",
    "2CDB07": "Intel Corporate",
    "988D46": "Intel Corporate",
    "6888A1": "Universal Electronics",
    "0063DE": "CLOUDWALK TECHNOLOGY CO.",
    "60A423": "Silicon Laboratories",
    "E43EC6": "HUAWEI TECHNOLOGIES CO.",
    "38881E": "HUAWEI TECHNOLOGIES CO.",
    "805FC5": "Apple",
    "3C4DBE": "Apple",
    "48262C": "Apple",
    "147DDA": "Apple",
    "C4910C": "Apple",
    "001693": "PowerLink Technology Inc.",
    "AC1F09": "shenzhen RAKwireless technology  Co.",
    "F85128": "SimpliSafe",
    "2400FA": "China Mobile (Hangzhou) Information Technology Co.",
    "50E039": "Zyxel Communications Corporation",
    "B85776": "lignex1",
    "AC2334": "Infinix mobility limited",
    "F8BC0E": "eero inc.",
    "E01995": "Nutanix",
    "FCBC0E": "Zhejiang Cainiao Supply Chain Management Co.",
    "10F920": "Cisco Systems",
    "9077EE": "Cisco Systems",
    "3C13CC": "Cisco Systems",
    "BC13A8": "Shenzhen YOUHUA Technology Co.",
    "6C9961": "Sagemcom Broadband SAS",
    "206980": "Apple",
    "D8DC40": "Apple",
    "94E3EE": "zte corporation",
    "B05CDA": "HP Inc.",
    "B01B7C": "Ontrol A.S.",
    "001C70": "NOVACOMM LTDA",
    "000FA4": "Sprecher Automation GmbH",
    "0024A2": "Hong Kong Middleware Technology Limited",
    "18DFC1": "Aetheros",
    "84A3B5": "Propulsion systems",
    "9CEDFA": "EVUlution AG",
    "EC63ED": "Hyundai Autoever Corp.",
    "1C1338": "Kimball Electronics Group",
    "E44122": "OnePlus Technology (Shenzhen) Co.",
    "9C19C2": "Dongguan Liesheng Electronic Co.",
    "74CBF3": "Lava international limited",
    "2CD066": "Xiaomi Communications Co Ltd",
    "9016BA": "HUAWEI TECHNOLOGIES CO.",
    "DCBD7A": "Guangzhou Shiyuan Electronic Technology Company Limited",
    "342EB7": "Intel Corporate",
    "BC26A1": "FACTORY FIVE Corporation",
    "60AAEF": "Huawei Device Co.",
    "D0F3F5": "Huawei Device Co.",
    "2479EF": "Greenpacket Berhad",
    "D44649": "HUAWEI TECHNOLOGIES CO.",
    "9400B0": "HUAWEI TECHNOLOGIES CO.",
    "2468B0": "Samsung Electronics Co.",
    "30FCEB": "LG Electronics (Mobile Communications)",
    "B4EF1C": "360 AI Technology Co.Ltd",
    "B8F009": "Espressif Inc.",
    "E8B470": "IEEE Registration Authority",
    "FC71FA": "Trane Technologies",
    "0002D8": "BRECIS Communications Corporation",
    "B04502": "Huawei Device Co.",
    "1C1FF1": "Huawei Device Co.",
    "14DE39": "Huawei Device Co.",
    "04F5F4": "Proxim Wireless",
    "008016": "WANDEL AND GOLTERMANN",
    "C8BCE5": "Sense Things Japan INC.",
    "F45420": "TELLESCOM INDUSTRIA E COMERCIO EM TELECOMUNICACAO",
    "0C817D": "EEP Elektro-Elektronik Pranjic GmbH",
    "64DDE9": "Xiaomi Communications Co Ltd",
    "4C4088": "SANSHIN ELECTRONICS CO.",
    "009EEE": "Positivo Tecnologia S.A.",
    "00A058": "GLORY",
    "7C9EBD": "Espressif Inc.",
    "1C0219": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "9C611D": "Panasonic Corporation of North America",
    "F0D5BF": "Intel Corporate",
    "DCD2FC": "HUAWEI TECHNOLOGIES CO.",
    "60F262": "Intel Corporate",
    "A4B1C1": "Intel Corporate",
    "00092E": "B&Tech System Inc.",
    "D41AC8": "Nippon Printer Engineering",
    "5061F6": "Universal Electronics",
    "F4EB9F": "Ellu Company 2019 SL",
    "E898C2": "ZETLAB Company",
    "A4C54E": "Huawei Device Co.",
    "D4BBE6": "Huawei Device Co.",
    "40B6E7": "Huawei Device Co.",
    "D0B45D": "Huawei Device Co.",
    "8836CF": "Huawei Device Co.",
    "402F86": "LG Innotek",
    "3C806B": "Hunan Voc Acoustics Technology Co.",
    "60DE35": "GITSN",
    "28317E": "Hongkong Nano IC Technologies Co.",
    "9405BB": "IEEE Registration Authority",
    "B802A4": "Aeonsemi",
    "CCA7C1": "Google",
    "8C5FAD": "Fiberhome Telecommunication Technologies Co.",
    "ACC25D": "Fiberhome Telecommunication Technologies Co.",
    "8C0C87": "Nokia",
    "E48326": "HUAWEI TECHNOLOGIES CO.",
    "447654": "HUAWEI TECHNOLOGIES CO.",
    "7CD9A0": "HUAWEI TECHNOLOGIES CO.",
    "F033E5": "HUAWEI TECHNOLOGIES CO.",
    "6C6A77": "Intel Corporate",
    "1869D8": "Tuya Smart Inc.",
    "C8B29B": "Intel Corporate",
    "CC418E": "MSA Innovation",
    "6849B2": "CARLO GAVAZZI LTD",
    "487AFF": "ESSYS",
    "C8D778": "BSH Hausgeraete GmbH",
    "C095DA": "NXP India Private Limited",
    "B42200": "Brother Industries",
    "DC9840": "Microsoft Corporation",
    "B8CEF6": "Mellanox Technologies",
    "B4F18C": "Huawei Device Co.",
    "C432D1": "Farlink Technology Limited",
    "6CDDBC": "Samsung Electronics Co.",
    "186F2D": "Shenzhen Sundray Technologies Company Limited",
    "F84FAD": "Hui Zhou Gaoshengda Technology Co.",
    "4C0A3D": "ADNACOM INC.",
    "CC7F76": "Cisco Systems",
    "A84122": "China Mobile (Hangzhou) Information Technology Co.",
    "E8ABFA": "Shenzhen Reecam Tech.Ltd.",
    "B0CCFE": "Huawei Device Co.",
    "540DF9": "Huawei Device Co.",
    "006619": "Huawei Device Co.",
    "206D31": "FIREWALLA INC",
    "14472D": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "28401A": "C8 MediSensors",
    "E45E37": "Intel Corporate",
    "E490FD": "Apple",
    "84AB1A": "Apple",
    "D06544": "Apple",
    "000E9E": "Topfield Co.",
    "90E2FC": "IEEE Registration Authority",
    "C853E1": "Beijing Bytedance Network Technology Co.",
    "FC3964": "ITEL MOBILE LIMITED",
    "8C3B32": "Microfan B.V.",
    "3C58C2": "Intel Corporate",
    "CCF9E4": "Intel Corporate",
    "000C1E": "Global Cache",
    "F008D1": "Espressif Inc.",
    "14AE85": "IEEE Registration Authority",
    "645CF3": "ParanTek Inc.",
    "90749D": "IRay Technology Co.",
    "3C5CF1": "eero inc.",
    "CCD42E": "Arcadyan Corporation",
    "5894B2": "BrainCo",
    "B09575": "TP-LINK TECHNOLOGIES CO.",
    "14169D": "Cisco Systems",
    "48A2E6": "Resideo",
    "B4B055": "HUAWEI TECHNOLOGIES CO.",
    "048C16": "HUAWEI TECHNOLOGIES CO.",
    "98DD5B": "TAKUMI JAPAN LTD",
    "E0BB9E": "Seiko Epson Corporation",
    "48D24F": "Sagemcom Broadband SAS",
    "E4AAEC": "Tianjin Hualai Technology Co.",
    "94BE46": "Motorola (Wuhan) Mobility Technologies Communication Co.",
    "58278C": "BUFFALO.INC",
    "140AC5": "Amazon Technologies Inc.",
    "483FDA": "Espressif Inc.",
    "2CDCD7": "AzureWave Technology Inc.",
    "C8C750": "Motorola Mobility LLC",
    "6C5D3A": "Microsoft Corporation",
    "8CC681": "Intel Corporate",
    "2083F8": "Advanced Digital Broadcast SA",
    "9C54DA": "SkyBell Technologies Inc.",
    "4C494F": "zte corporation",
    "C4741E": "zte corporation",
    "001D7D": "GIGA-BYTE TECHNOLOGY CO.",
    "1C6F65": "GIGA-BYTE TECHNOLOGY CO.",
    "00241D": "GIGA-BYTE TECHNOLOGY CO.",
    "DC8983": "Samsung Electronics Co.",
    "D46075": "Baidu Online Network Technology (Beijing) Co.",
    "78C5F8": "Huawei Device Co.",
    "5C78F8": "Huawei Device Co.",
    "B827C5": "Huawei Device Co.",
    "5CCB99": "Samsung Electronics Co.",
    "90B144": "Samsung Electronics Co.",
    "D45D64": "ASUSTek COMPUTER INC.",
    "38EC0D": "Apple",
    "48DD0C": "eero inc.",
    "940C98": "Apple",
    "E8FBE9": "Apple",
    "142A14": "ShenZhen Selenview Digital Technology Co.",
    "B86142": "Beijing Tricolor Technology Co.",
    "384B5B": "ZTRON TECHNOLOGY LIMITED",
    "E47C65": "Sunstar Communication Technology  Co.",
    "34E3DA": "Hoval Aktiengesellschaft",
    "D87E76": "ITEL MOBILE LIMITED",
    "A4307A": "Samsung Electronics Co.",
    "00A0B3": "ZYKRONIX",
    "200A0D": "IEEE Registration Authority",
    "2CE310": "Stratacache",
    "E4F327": "ATOL LLC",
    "6819AC": "Guangzhou Xianyou Intelligent Technogoly CO.",
    "E82E0C": "NETINT Technologies Inc.",
    "1892A4": "Ciena Corporation",
    "B0735D": "Huawei Device Co.",
    "F0B4D2": "D-Link International",
    "5C3A45": "CHONGQING FUGUI ELECTRONICS CO.",
    "14115D": "Skyworth Digital Technology(Shenzhen) Co.",
    "FC8E5B": "China Mobile Iot Limited company",
    "A03C31": "Shenzhen Belon Technology CO.",
    "10082C": "Texas Instruments",
    "9013DA": "Athom B.V.",
    "D49E3B": "Guangzhou Shiyuan Electronic Technology Company Limited",
    "DC4BDD": "Shenzhen SuperElectron Technology Co.",
    "C0B5CD": "Huawei Device Co.",
    "4C5077": "Huawei Device Co.",
    "502DBB": "GD Midea Air-Conditioning Equipment Co.",
    "7CA1AE": "Apple",
    "58EAFC": "ELL-IoT Inc",
    "5C3A3D": "zte corporation",
    "30FD65": "HUAWEI TECHNOLOGIES CO.",
    "3C22FB": "Apple",
    "80E455": "New H3C Technologies Co.",
    "00909E": "Critical IO",
    "38E8EE": "Nanjing Youkuo Electric Technology Co.",
    "90B8E0": "SHENZHEN YANRAY TECHNOLOGY CO.",
    "2C4CC6": "Murata Manufacturing Co.",
    "6802B8": "Compal Broadband Networks",
    "3463D4": "BIONIX SUPPLYCHAIN TECHNOLOGIES SLU",
    "08F7E9": "HRCP Research and Development Partnership",
    "440377": "IEEE Registration Authority",
    "0812A5": "Amazon Technologies Inc.",
    "9CF531": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "C809A8": "Intel Corporate",
    "748B34": "Shanghai Smart System Technology Co.",
    "4CBC72": "Primex Wireless",
    "DCDCE2": "Samsung Electronics Co.",
    "A0AC69": "Samsung Electronics Co.",
    "1089FB": "Samsung Electronics Co.",
    "D4772B": "Nanjing Ztlink Network Technology Co.",
    "64F9C0": "ANALOG DEVICES",
    "BCA511": "NETGEAR",
    "F8C4F3": "Shanghai Infinity Wireless Technologies Co.",
    "C4E90A": "D-Link International",
    "18D0C5": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "ACBD70": "Huawei Device Co.",
    "30E98E": "HUAWEI TECHNOLOGIES CO.",
    "C4447D": "HUAWEI TECHNOLOGIES CO.",
    "70F82B": "DWnet Technologies(Suzhou) Corporation",
    "44CB8B": "LG Innotek",
    "EC1BBD": "Silicon Laboratories",
    "10DCB6": "IEEE Registration Authority",
    "D8A315": "vivo Mobile Communication Co.",
    "14A1BF": "ASSA ABLOY Korea Co.",
    "9483C4": "GL Technologies (Hong Kong) Limited",
    "9C93B0": "Megatronix (Beijing) Technology Co.",
    "64AEF1": "Qingdao Hisense Electronics Co.",
    "048C9A": "Huawei Device Co.",
    "EC3CBB": "Huawei Device Co.",
    "28BD89": "Google",
    "984827": "TP-LINK TECHNOLOGIES CO.",
    "34ED1B": "Cisco Systems",
    "142475": "4DReplay",
    "80647A": "Ola Sense Inc",
    "C0B883": "Intel Corporate",
    "70441C": "SHENZHEN KAIFA TECHNOLOGY CO.",
    "1CEA0B": "Edgecore Networks Corporation",
    "24418C": "Intel Corporate",
    "44EFBF": "China Dragon Technology Limited",
    "4CB44A": "NANOWAVE Technologies Inc.",
    "F8D027": "Seiko Epson Corporation",
    "5C666C": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "4C4BF9": "IEEE Registration Authority",
    "88D5A8": "ITEL MOBILE LIMITED",
    "B81F5E": "Apption Labs Limited",
    "D81265": "CHONGQING FUGUI ELECTRONICS CO.",
    "8C3A7E": "Universal Electronics",
    "208593": "IEEE Registration Authority",
    "B47C59": "Jiangsu Hengxin Technology Co.",
    "300D9E": "Ruijie Networks Co.",
    "BCB0E7": "HUAWEI TECHNOLOGIES CO.",
    "5434EF": "HUAWEI TECHNOLOGIES CO.",
    "ECFA5C": "Beijing Xiaomi Electronics Co.",
    "F8B46A": "Hewlett Packard",
    "ACE342": "HUAWEI TECHNOLOGIES CO.",
    "9017C8": "HUAWEI TECHNOLOGIES CO.",
    "E4922A": "DBG HOLDINGS LIMITED",
    "4801C5": "OnePlus Technology (Shenzhen) Co.",
    "18BF1C": "Jiangsu Huitong Group Co.",
    "207759": "OPTICAL NETWORK VIDEO TECHNOLOGIES (SHENZHEN) CO.",
    "889D98": "Allied-telesisK.K.",
    "4C56DF": "Targus US LLC",
    "B4EE25": "Shenzhen Belon Technology CO.",
    "C82B96": "Espressif Inc.",
    "98523D": "Sunitec Enterprise Co.",
    "DCF8B9": "zte corporation",
    "189088": "eero inc.",
    "2C641F": "Vizio",
    "54E7D5": "Sun Cupid Technology (HK) LTD",
    "241510": "IEEE Registration Authority",
    "6C4D51": "Shenzhen Ceres Technology Co.",
    "04819B": "SKY UK LIMITED",
    "2CA89C": "Creatz inc.",
    "4CDC0D": "Coral Telecom Limited",
    "000163": "Cisco Systems",
    "6070C0": "Apple",
    "F0C371": "Apple",
    "1855E3": "Apple",
    "60634C": "D-Link International",
    "E00084": "HUAWEI TECHNOLOGIES CO.",
    "0000DE": "CETIA",
    "F43E66": "Bee Computing (HK) Limited",
    "DC396F": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
    "B4C476": "Wuhan Maritime Communication Research Institute",
    "683489": "LEA Professional",
    "9C3A9A": "Shenzhen Sundray Technologies Company Limited",
    "B46C47": "Panasonic Appliances Company",
    "94BF80": "zte corporation",
    "64FF0A": "Wistron Neweb Corporation",
    "44422F": "TESTOP CO.",
    "549C27": "Plasma Cloud Limited",
    "541589": "MCS Logic Inc.",
    "845733": "Microsoft Corporation",
    "3CECEF": "Super Micro Computer",
    "E450EB": "Apple",
    "886440": "Apple",
    "C4E1A1": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "ACC358": "Continental Automotive Czech Republic s.r.o.",
    "F09919": "Garmin International",
    "58F39C": "Cisco Systems",
    "002423": "AzureWave Technologies (Shanghai) Inc.",
    "8C593C": "IEEE Registration Authority",
    "00AD63": "Dedicated Micros Malta LTD",
    "6029D5": "DAVOLINK Inc.",
    "509744": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "987A14": "Microsoft Corporation",
    "C83DDC": "Xiaomi Communications Co Ltd",
    "B0B5E8": "Ruroc LTD",
    "E415F6": "Texas Instruments",
    "809133": "AzureWave Technology Inc.",
    "1819D6": "Samsung Electronics Co.",
    "70FC8F": "FREEBOX SAS",
    "501B32": "Taicang T&W Electronics",
    "14ADCA": "China Mobile Iot Limited company",
    "CC9070": "Cisco Systems",
    "2841C6": "HUAWEI TECHNOLOGIES CO.",
    "0077E4": "Nokia Solutions and Networks GmbH & Co. KG",
    "380118": "ULVAC",
    "F41D6B": "HUAWEI TECHNOLOGIES CO.",
    "7CEC9B": "Fuzhou Teraway Information Technology Co.",
    "C48FC1": "DEEPTRACK S.L.U.",
    "B4F58E": "HUAWEI TECHNOLOGIES CO.",
    "AC4228": "Parta Networks",
    "B0A6F5": "Xaptum",
    "ACF5E6": "Cisco Systems",
    "E828C1": "Eltex Enterprise Ltd.",
    "78D347": "Ericsson AB",
    "F82387": "Shenzhen Horn Audio Co.",
    "BC98DF": "Motorola Mobility LLC",
    "A4A179": "Nanjing dianyan electric power automation co. LTD",
    "68DB67": "Nantong Coship Electronics Co.",
    "980D67": "Zyxel Communications Corporation",
    "702E80": "DIEHL Connectivity Solutions",
    "F8C397": "NZXT Corp. Ltd.",
    "70DDA8": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "4C6F9C": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "782C29": "New H3C Technologies Co.",
    "ACA46E": "SHENZHEN GONGJIN ELECTRONICS CO.",
    "C8B422": "ASKEY COMPUTER CORP",
    "94EE9F": "HMD Global Oy",
    "D4D252": "Intel Corporate",
    "58A023": "Intel Corporate",
    "DCB082": "Nokia",
    "F4323D": "Sichuan tianyi kanghe communications co.",
    "E8C417": "Fiberhome Telecommunication Technologies Co.",
    "F8B797": "NEC Platforms",
    "B0AAD2": "Sichuan tianyi kanghe communications co.",
    "001EA3": "Nokia Danmark A/S",
    "38F32E": "Skullcandy",
    "DC2AA1": "MedHab LLC",
    "E4F3E8": "Shenzhen SuperElectron Technology Co.",
    "CCA12B": "TCL King Electrical Appliances (Huizhou) Co.",
    "AC00D0": "zte corporation",
    "981E19": "Sagemcom Broadband SAS",
    "84B866": "Beijing XiaoLu technology co. LTD",
    "1422DB": "eero inc.",
    "18BC5A": "Zhejiang Tmall Technology Co.",
    "C4C138": "OWLink Technology Inc",
    "C46516": "Hewlett Packard",
    "E41E0A": "IEEE Registration Authority",
    "AC37C9": "RAID Incorporated",
    "205869": "Ruckus Wireless",
    "CC37AB": "Edgecore Networks Corporation",
    "907841": "Intel Corporate",
    "C86314": "IEEE Registration Authority",
    "243154": "HUAWEI TECHNOLOGIES CO.",
    "84B8B8": "Motorola (Wuhan) Mobility Technologies Communication Co.",
    "D041C9": "Fiberhome Telecommunication Technologies Co.",
    "E8018D": "Fiberhome Telecommunication Technologies Co.",
    "18399C": "Skorpios Technologies",
    "94C2BD": "TECNOBIT",
    "4883B4": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "701E68": "Hanna Instruments",
    "941625": "Apple",
    "543B30": "duagon AG",
    "8C965F": "Shandong Zhongan Technology Co.",
    "10A3B8": "Iskratel d.o.o.",
    "70CD91": "TERACOM TELEMATICA S.A",
    "E8ECA3": "Dongguan Liesheng Electronic Co.Ltd",
    "08A6BC": "Amazon Technologies Inc.",
    "2C58E8": "HUAWEI TECHNOLOGIES CO.",
    "B0BB8B": "WAVETEL TECHNOLOGY LIMITED",
    "34A8EB": "Apple",
    "1CB3E9": "Shenzhen Zhongke United Communication Technology",
    "A483E7": "Apple",
    "F4AFE7": "Apple",
    "AC88FD": "Apple",
    "6489F1": "Samsung Electronics Co.",
    "503E7C": "LeiShen Intelligent  System Co.Ltd",
    "243F30": "Oxygen Broadband s.a.",
    "3C9180": "Liteon Technology Corporation",
    "20326C": "Samsung Electronics Co.",
    "80FD7A": "BLU Products Inc",
    "B4A305": "XIAMEN YAXON NETWORK CO.",
    "803E48": "SHENZHEN GONGJIN ELECTRONICS CO.",
    "24586E": "zte corporation",
    "C0074A": "Brita GmbH",
    "E8B2FE": "HUMAX Co.",
    "0017FA": "Microsoft Corporation",
    "94BFC4": "Ruckus Wireless",
    "2034FB": "Xiaomi Communications Co Ltd",
    "A89CED": "Xiaomi Communications Co Ltd",
    "00124E": "XAC AUTOMATION CORP.",
    "88E034": "Shinwa industries(China) ltd.",
    "BCCF4F": "Zyxel Communications Corporation",
    "0CE041": "iDruide",
    "B88FB4": "JABIL CIRCUIT ITALIA S.R.L",
    "C010B1": "HMD Global Oy",
    "0052C2": "peiker acustic GmbH",
    "90895F": "WEIFANG GOERTEK ELECTRONICS CO.",
    "48D845": "Shenzhen Mainuoke Electronics Co.",
    "D0EC35": "Cisco Systems",
    "380025": "Intel Corporate",
    "0CF475": "Zliide Technologies ApS",
    "68FF7B": "TP-LINK TECHNOLOGIES CO.",
    "808F1D": "TP-LINK TECHNOLOGIES CO.",
    "000F69": "SEW Eurodrive GmbH & Co. KG",
    "8C53D2": "China Mobile Group Device Co.",
    "D058C0": "Qingdao Haier Multimedia Limited.",
    "F8D478": "Flextronics Tech.(Ind) Pvt Ltd",
    "48BD0E": "Quanta Storage Inc.",
    "D45383": "Murata Manufacturing Co.",
    "A04246": "IT Telecom Co.",
    "A45F9B": "Nexell",
    "E458E7": "Samsung Electronics Co.",
    "00104A": "The Parvus Corporation",
    "48C3B0": "Pharos Co.Ltd",
    "DC58BC": "Thomas-Krenn.AG",
    "001025": "Grayhill",
    "70EA1A": "Cisco Systems",
    "808A8B": "vivo Mobile Communication Co.",
    "1C3B8F": "Selve GmbH & Co. KG",
    "E4E749": "Hewlett Packard",
    "9844B6": "INFRANOR SAS",
    "38839A": "SHENZHEN RF-LINK TECHNOLOGY CO.",
    "C8F6C8": "Fiberhome Telecommunication Technologies Co.",
    "A86DAA": "Intel Corporate",
    "38C2BA": "CCTV NEOTECH",
    "A0F9B7": "Ademco Smart Homes Technology(Tianjin)Co.",
    "A83CCB": "ROSSMA",
    "DC6723": "barox Kommunikation GmbH",
    "44B462": "Flextronics Tech.(Ind) Pvt Ltd",
    "CC3FEA": "BAE Systems",
    "94677E": "Belden India Private Limited",
    "AC5775": "HMD Global Oy",
    "E85BB7": "Ample Systems Inc.",
    "AC4330": "Versa Networks",
    "D43A2E": "SHENZHEN MTC CO LTD",
    "ECC57F": "Suzhou Pairlink Network Technology",
    "30C3D9": "ALPSALPINE CO",
    "50AD92": "NX Technologies",
    "4CF2BF": "Cambridge Industries(Group) Co.",
    "CC9EA2": "Amazon Technologies Inc.",
    "001BFB": "ALPSALPINE CO",
    "8CAEDB": "NAGTECH LLC",
    "78B213": "DWnet Technologies(Suzhou) Corporation",
    "7CDB98": "ASKEY COMPUTER CORP",
    "380B3C": "Texas Instruments",
    "6845F1": "TOSHIBA CLIENT SOLUTIONS CO.",
    "6CA936": "DisplayLink (UK) Ltd",
    "708540": "Skyworth Digital Technology(Shenzhen) Co.",
    "F00DF5": "ACOMA Medical Industry Co",
    "58C232": "NEC Corporation",
    "94E0D6": "China Dragon Technology Limited",
    "B4A9FC": "Quanta Computer Inc.",
    "003217": "Cisco Systems",
    "381D14": "Skydio Inc.",
    "3C286D": "Google",
    "00093A": "Molex CMS",
    "74F737": "KCE",
    "48A493": "TAIYO YUDEN CO.",
    "88D211": "Eko Devices",
    "B8C227": "PSTec",
    "A48CC0": "JLG Industries",
    "48E695": "Insigma Inc",
    "B479C8": "Ruckus Wireless",
    "E82C6D": "SmartRG",
    "04F9D9": "Sender Electronic(Jiashan) Co.",
    "DC080F": "Apple",
    "F8E94E": "Apple",
    "EC2CE2": "Apple",
    "40BC60": "Apple",
    "E83617": "Apple",
    "9C648B": "Apple",
    "344262": "Apple",
    "2CAA8E": "Wyze Labs Inc",
    "703A51": "Xiaomi Communications Co Ltd",
    "14D00D": "Apple",
    "C03DD9": "MitraStar Technology Corp.",
    "0C9541": "CHIPSEA TECHNOLOGIES (SHENZHEN) CORP.",
    "B40B78": "Brusa Elektronik AG",
    "181E95": "AuVerte",
    "9C6937": "Qorvo International Pte. Ltd.",
    "207918": "Intel Corporate",
    "48352E": "Shenzhen Wolck Network Product Co.",
    "04E598": "Xiaomi Communications Co Ltd",
    "001060": "BILLIONTON SYSTEMS",
    "C4D489": "JiangSu Joyque Information Industry Co.",
    "B82CA0": "Resideo",
    "DC48B2": "Baraja Pty. Ltd.",
    "ACAE19": "Roku",
    "C0BDC8": "Samsung Electronics Co.",
    "B4F949": "optilink networks pvt ltd",
    "3C3786": "NETGEAR",
    "A4A1E4": "Innotube",
    "98D3E7": "Netafim L",
    "647BCE": "Samsung Electronics Co.",
    "A887B3": "Samsung Electronics Co.",
    "6C006B": "Samsung Electronics Co.",
    "6CC7EC": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
    "D89685": "GoPro",
    "A0A4C5": "Intel Corporate",
    "F4D108": "Intel Corporate",
    "60CE92": "The Refined Industry Company Limited",
    "94EAEA": "TELLESCOM INDUSTRIA E COMERCIO EM TELECOMUNICACAO",
    "301389": "Siemens AG",
    "3C01EF": "Sony Corporation",
    "706D15": "Cisco Systems",
    "105BAD": "Mega Well Limited",
    "F063F9": "HUAWEI TECHNOLOGIES CO.",
    "7CC385": "HUAWEI TECHNOLOGIES CO.",
    "900EB3": "Shenzhen Amediatech Technology Co.",
    "F05494": "Honeywell Connected Building",
    "48872D": "SHEN ZHEN DA XIA LONG QUE TECHNOLOGY CO.",
    "E81A58": "TECHNOLOGIC SYSTEMS",
    "00AD24": "D-Link International",
    "54068B": "Ningbo Deli Kebei Technology Co.LTD",
    "549FAE": "iBASE Gaming Inc",
    "00EABD": "Cisco Systems",
    "74BFC0": "CANON INC.",
    "20B001": "Technicolor Delivery Technologies Belgium NV",
    "181DEA": "Intel Corporate",
    "185680": "Intel Corporate",
    "C8D9D2": "Hewlett Packard",
    "24FCE5": "Samsung Electronics Co.",
    "809621": "Lenovo",
    "142233": "Fiberhome Telecommunication Technologies Co.",
    "78055F": "Shenzhen WYC Technology Co.",
    "0060EB": "FOURTHTRACK SYSTEMS",
    "EC79F2": "Startel",
    "04BC87": "Shenzhen JustLink Technology Co.",
    "54C33E": "Ciena Corporation",
    "1862E4": "Texas Instruments",
    "5CC999": "New H3C Technologies Co.",
    "B02A43": "Google",
    "C474F8": "Hot Pepper",
    "BCB22B": "EM-Tech",
    "B08BCF": "Cisco Systems",
    "C4985C": "Hui Zhou Gaoshengda Technology Co.",
    "30A1FA": "HUAWEI TECHNOLOGIES CO.",
    "64628A": "evon GmbH",
    "0415D9": "Viwone",
    "DC3757": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "005099": "3COM EUROPE LTD",
    "ECB313": "SHENZHEN GONGJIN ELECTRONICS CO.",
    "242E90": "PALIT MICROSYSTEMS",
    "743400": "MTG Co.",
    "6035C0": "SFR",
    "001AC5": "Keysight Technologies",
    "00201E": "NETQUEST CORPORATION",
    "00608C": "3COM",
    "00A024": "3COM",
    "0020AF": "3COM",
    "00104B": "3COM",
    "A85AF3": "Shanghai Siflower Communication Technology Co.",
    "70FD46": "Samsung Electronics Co.",
    "8C83E1": "Samsung Electronics Co.",
    "645D86": "Intel Corporate",
    "9CAA1B": "Microsoft Corporation",
    "E00EE1": "We Corporation Inc.",
    "A89A93": "Sagemcom Broadband SAS",
    "8C9246": "Oerlikon Textile Gmbh&Co.KG",
    "000E94": "Maas International BV",
    "4898CA": "Sichuan AI-Link Technology Co.",
    "247E51": "zte corporation",
    "E8B541": "zte corporation",
    "0C9D92": "ASUSTek COMPUTER INC.",
    "0CCB85": "Motorola Mobility LLC",
    "889F6F": "Samsung Electronics Co.",
    "5C63C9": "Intellithings Ltd.",
    "0C96E6": "Cloud Network Technology (Samoa) Limited",
    "3C8994": "SKY UK LIMITED",
    "582D34": "Qingping Electronics (Suzhou) Co.",
    "20DE88": "IC Realtime LLC",
    "482CA0": "Xiaomi Communications Co Ltd",
    "A4E615": "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.",
    "001A31": "SCAN COIN AB",
    "001B84": "Scan Engineering Telecom",
    "F4068D": "devolo AG",
    "988ED4": "ITEL MOBILE LIMITED",
    "E8A788": "XIAMEN LEELEN TECHNOLOGY CO.",
    "3412F9": "HUAWEI TECHNOLOGIES CO.",
    "BCE265": "HUAWEI TECHNOLOGIES CO.",
    "4CD1A1": "HUAWEI TECHNOLOGIES CO.",
    "88BFE4": "HUAWEI TECHNOLOGIES CO.",
    "4017E2": "INTAI TECHNOLOGY CORP.",
    "741F79": "YOUNGKOOK ELECTRONICS CO.",
    "E0735F": "NUCOM",
    "0051ED": "LG Innotek",
    "40DC9D": "HAJEN",
    "F0BCC9": "PFU LIMITED",
    "B4CEFE": "James Czekaj",
    "88AE1D": "COMPAL INFORMATION (KUNSHAN) CO.",
    "C4518D": "Shenzhen YOUHUA Technology Co.",
    "486834": "Silicon Motion",
    "F8CC6E": "DEPO Electronics Ltd",
    "F8369B": "Texas Instruments",
    "A09351": "Cisco Systems",
    "98039B": "Mellanox Technologies",
    "B888E3": "COMPAL INFORMATION (KUNSHAN) CO.",
    "208984": "COMPAL INFORMATION (KUNSHAN) CO.",
    "641331": "Bosch Car Multimedia (Wuhu) Co. Ltd.",
    "183A48": "VostroNet",
    "782F17": "Xlab Co.",
    "B0027E": "MULLER SERVICES",
    "24FAF3": "Shanghai Flexem Technology Co.",
    "289EFC": "Sagemcom Broadband SAS",
    "00C055": "MODULAR COMPUTING TECHNOLOGIES",
    "E41FE9": "Dunkermotoren GmbH",
    "D8760A": "Escort",
    "487583": "Intellion AG",
    "8C3579": "QDIQO Sp. z o.o.",
    "38C70A": "WiFiSong",
    "FCFBFB": "Cisco Systems",
    "88D2BF": "German Autolabs",
    "20163D": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "5C2ED2": "ABC(XiSheng) Electronics Co.",
    "9C5A44": "COMPAL INFORMATION (KUNSHAN) CO.",
    "340A98": "HUAWEI TECHNOLOGIES CO.",
    "646D6C": "HUAWEI TECHNOLOGIES CO.",
    "C4B8B4": "HUAWEI TECHNOLOGIES CO.",
    "14CAA0": "Hu&Co",
    "001133": "Siemens AG Austria",
    "000B23": "Siemens Home & Office Comm. Devices",
    "D82477": "Universal Electric Corporation",
    "00907F": "WatchGuard Technologies",
    "4C5E0C": "Routerboard.com",
    "D4CA6D": "Routerboard.com",
    "001017": "Bosch Access Systems GmbH",
    "F4EE14": "MERCURY COMMUNICATION TECHNOLOGIES CO.",
    "6C5940": "MERCURY COMMUNICATION TECHNOLOGIES CO.",
    "D02516": "MERCURY COMMUNICATION TECHNOLOGIES CO.",
    "1C60DE": "MERCURY COMMUNICATION TECHNOLOGIES CO.",
    "08D46A": "LG Electronics (Mobile Communications)",
    "001472": "China Broadband Wireless IP Standard group(ChinaBWIPS)",
    "007E95": "Cisco Systems",
    "4006A0": "Texas Instruments",
    "80B575": "HUAWEI TECHNOLOGIES CO.",
    "A4BE2B": "HUAWEI TECHNOLOGIES CO.",
    "2811A5": "Bose Corporation",
    "D8F3DB": "Post CH AG",
    "DCB4AC": "FLEXTRONICS MANUFACTURING(ZHUHAI)CO.",
    "203DBD": "LG Innotek",
    "04ECBB": "Fiberhome Telecommunication Technologies Co.",
    "D42122": "Sercomm Corporation.",
    "00C002": "Sercomm Corporation.",
    "68E7C2": "Samsung Electronics Co.",
    "58B10F": "Samsung Electronics Co.",
    "A45385": "WEIFANG GOERTEK ELECTRONICS CO.",
    "00402F": "XLNT DESIGNS INC.",
    "A492CB": "Nokia",
    "C0D2F3": "Hui Zhou Gaoshengda Technology Co.",
    "64A2F9": "OnePlus Technology (Shenzhen) Co.",
    "A87D12": "HUAWEI TECHNOLOGIES CO.",
    "94193A": "Elvaco AB",
    "BC9911": "Zyxel Communications Corporation",
    "280245": "Konze System Technology Co.",
    "E48F65": "Yelatma Instrument Making Enterprise",
    "840D8E": "Espressif Inc.",
    "00BB3A": "Amazon Technologies Inc.",
    "3CF5CC": "New H3C Technologies Co.",
    "002082": "ONEAC CORPORATION",
    "0000A8": "Stratus Technologies",
    "0004FC": "Stratus Technologies",
    "3C24F0": "IEEE Registration Authority",
    "0CB34F": "Shenzhen Xiaoqi Intelligent Technology Co.",
    "C08135": "Ningbo Forfan technology Co.",
    "3CF4F9": "Moda-InnoChips",
    "505DAC": "HUAWEI TECHNOLOGIES CO.",
    "B0A37E": "QING DAO HAIER TELECOM CO.",
    "3CEAF9": "JUBIXCOLTD",
    "682C7B": "Cisco Systems",
    "E8FAF7": "Guangdong Uniteddata Holding Group Co.",
    "949D57": "Panasonic do Brasil Limitada",
    "FC6947": "Texas Instruments",
    "E07DEA": "Texas Instruments",
    "B4C0F5": "Shenzhen TINNO Mobile Technology Corp.",
    "406231": "GIFA",
    "FCB7F0": "Idaho National Laboratory",
    "04D3B0": "Intel Corporate",
    "58DB15": "TECNO MOBILE LIMITED",
    "5050CE": "Hangzhou Dianyixia Communication Technology Co. Ltd.",
    "2C28B7": "Hangzhou Ruiying technology co.",
    "046B1B": "SYSDINE Co.",
    "1C666D": "Hon Hai Precision Ind. Co.",
    "DCDE4F": "Gionee Communication Equipment Co Ltd",
    "4CD0CB": "HUAWEI TECHNOLOGIES CO.",
    "88D37B": "FirmTek",
    "441E98": "Ruckus Wireless",
    "007278": "Cisco Systems",
    "00A021": "General Dynamics Mission Systems",
    "90DD5D": "Apple",
    "F0AF50": "Phantom Intelligence",
    "00250C": "Senet Inc",
    "0C8063": "TP-LINK TECHNOLOGIES CO.",
    "B4CD27": "HUAWEI TECHNOLOGIES CO.",
    "C819F7": "Samsung Electronics Co.",
    "DC2919": "AltoBeam (Xiamen) Technology Ltd",
    "645AED": "Apple",
    "84F3EB": "Espressif Inc.",
    "001B48": "Shenzhen Lantech Electronics Co.",
    "FC2A9C": "Apple",
    "A056F3": "Apple",
    "549963": "Apple",
    "C0B658": "Apple",
    "48A91C": "Apple",
    "50BC96": "Apple",
    "002FD9": "Fiberhome Telecommunication Technologies Co.",
    "885FE8": "IEEE Registration Authority",
    "3880DF": "Motorola Mobility LLC",
    "BC6A2F": "Henge Docks LLC",
    "F4E11E": "Texas Instruments",
    "C42C4F": "Qingdao Hisense Mobile Communication Technology Co",
    "24CACB": "Fiberhome Telecommunication Technologies Co.",
    "543E64": "Fiberhome Telecommunication Technologies Co.",
    "0C08B4": "HUMAX Co.",
    "DC0265": "Meditech Kft",
    "48BD3D": "New H3C Technologies Co.",
    "002705": "Sectronic",
    "180F76": "D-Link International",
    "909497": "HUAWEI TECHNOLOGIES CO.",
    "DC729B": "HUAWEI TECHNOLOGIES CO.",
    "14A72B": "currentoptronics Pvt.Ltd",
    "3C1710": "Sagemcom Broadband SAS",
    "34029B": "Plexonics Technologies LImited",
    "84DB9E": "Pink Nectarine Health AB",
    "A4DA22": "IEEE Registration Authority",
    "900372": "Longnan Junya Digital Technology Co. Ltd.",
    "8C4CAD": "Evoluzn Inc.",
    "8CF957": "RuiXingHengFang Network (Shenzhen) Co.",
    "0CC6CC": "HUAWEI TECHNOLOGIES CO.",
    "785860": "HUAWEI TECHNOLOGIES CO.",
    "4C776D": "Cisco Systems",
    "3CDCBC": "Samsung Electronics Co.",
    "804E70": "Samsung Electronics Co.",
    "D4E6B7": "Samsung Electronics Co.",
    "74E182": "Texas Instruments",
    "E8DEFB": "MESOTIC SAS",
    "C400AD": "Advantech Technology (CHINA) Co.",
    "94FE9D": "SHENZHEN GONGJIN ELECTRONICS CO.",
    "6CB6CA": "DIVUS GmbH",
    "04D13A": "Xiaomi Communications Co Ltd",
    "6CC4D5": "HMD Global Oy",
    "80C548": "Shenzhen Zowee Technology Co.",
    "0024AF": "Dish Technologies Corp",
    "C0A8F0": "Adamson Systems Engineering",
    "9C431E": "IEEE Registration Authority",
    "4CC206": "Somfy",
    "3499D7": "Universal Flow Monitors",
    "0C8BD3": "ITEL MOBILE LIMITED",
    "E8ABF3": "HUAWEI TECHNOLOGIES CO.",
    "449EF9": "vivo Mobile Communication Co.",
    "B4E9A3": "port industrial automation GmbH",
    "6C2ACB": "Paxton Access Ltd",
    "980074": "Raisecom Technology CO.",
    "18C19D": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "0C9838": "Xiaomi Communications Co Ltd",
    "282C02": "IEEE Registration Authority",
    "583BD9": "Fiberhome Telecommunication Technologies Co.",
    "FCA183": "Amazon Technologies Inc.",
    "C48466": "Apple",
    "347C25": "Apple",
    "CC2DB7": "Apple",
    "DCA266": "Hon Hai Precision Ind. Co.",
    "A0BDCD": "SKY UK LIMITED",
    "BC91B5": "Infinix mobility limited",
    "74EACB": "New H3C Technologies Co.",
    "5C865C": "Samsung Electronics Co.",
    "04F128": "HMD Global Oy",
    "D41A3F": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "30C507": "ECI Telecom Ltd.",
    "282FC2": "Automotive Data Solutions",
    "44AD19": "XINGFEI （H.K）LIMITED",
    "000F9B": "Ross Video Limited",
    "0024BA": "Texas Instruments",
    "60512C": "TCT mobile ltd",
    "64DB81": "Syszone Co.",
    "1CDF52": "Texas Instruments",
    "04B167": "Xiaomi Communications Co Ltd",
    "EC8350": "Microsoft Corporation",
    "5CAD76": "Shenzhen TCL New Technology Co.",
    "646E6C": "Radio Datacom LLC",
    "E88E60": "NSD Corporation",
    "38ADBE": "New H3C Technologies Co.",
    "0C5203": "AGM GROUP LIMITED",
    "2C5491": "Microsoft Corporation",
    "C8458F": "Wyler AG",
    "001BB9": "Elitegroup Computer Systems Co.",
    "002461": "Shin Wang Tech.",
    "E4A7A0": "Intel Corporate",
    "38D7CA": "7HUGS LABS",
    "5CE28C": "Zyxel Communications Corporation",
    "E4BD4B": "zte corporation",
    "001E1D": "East Coast Datacom",
    "7846C4": "DAEHAP HYPER-TECH",
    "000144": "Dell EMC",
    "08001B": "Dell EMC",
    "7C010A": "Texas Instruments",
    "701F53": "Cisco Systems",
    "18396E": "SUNSEA TELECOMMUNICATIONS CO.",
    "EC7D11": "vivo Mobile Communication Co.",
    "A04EA7": "Apple",
    "F0989D": "Apple",
    "E42B34": "Apple",
    "3C2EF9": "Apple",
    "FCD6BD": "Robert Bosch GmbH",
    "0C1C20": "Kakao Corp",
    "94282E": "New H3C Technologies Co.",
    "683C7D": "Magic Intelligence Technology Limited",
    "74BBD3": "Shenzhen xeme Communication Co.",
    "D80831": "Samsung Electronics Co.",
    "48BA4E": "Hewlett Packard",
    "9441C1": "Mini-Cam Limited",
    "185282": "Fiberhome Telecommunication Technologies Co.",
    "500F80": "Cisco Systems",
    "504EDC": "Ping Communication",
    "08674E": "Hisense broadband multimedia technology Co.",
    "8C3C4A": "NAKAYO Inc",
    "7086C1": "Texas Instruments",
    "10F1F2": "LG Electronics (Mobile Communications)",
    "8C68C8": "zte corporation",
    "EC8263": "zte corporation",
    "98F5A9": "OHSUNG",
    "6CB749": "HUAWEI TECHNOLOGIES CO.",
    "989C57": "HUAWEI TECHNOLOGIES CO.",
    "F4D7B2": "LGS Innovations",
    "00152A": "Nokia Corporation",
    "9C4A7B": "Nokia Corporation",
    "2CD2E7": "Nokia Corporation",
    "48EC5B": "Nokia Solutions and Networks GmbH & Co. KG",
    "D86162": "Wistron Neweb Corporation",
    "DC6AEA": "Infinix mobility limited",
    "386EA2": "vivo Mobile Communication Co.",
    "982D68": "Samsung Electronics Co.",
    "444AB0": "Zhejiang Moorgen Intelligence Technology Co.",
    "80739F": "KYOCERA CORPORATION",
    "28840E": "silicon valley immigration service",
    "080070": "Mitsubishi Precision Co.",
    "C421C8": "KYOCERA CORPORATION",
    "80615F": "Beijing Sinead Technology Co.",
    "34008A": "IEEE Registration Authority",
    "9050CA": "Hitron Technologies. Inc",
    "409922": "AzureWave Technology Inc.",
    "C06D1A": "Tianjin Henxinhuifeng Technology Co.",
    "107B44": "ASUSTek COMPUTER INC.",
    "A41115": "Robert Bosch Engineering and Business Solutions pvt. Ltd.",
    "F4F3AA": "JBL GmbH & Co. KG",
    "40A3CC": "Intel Corporate",
    "84253F": "silex technology",
    "0008C9": "TechniSat Digital GmbH Daun",
    "D8B12A": "Panasonic Mobile Communications Co.",
    "705812": "Panasonic Corporation AVC Networks Company",
    "04209A": "Panasonic Corporation AVC Networks Company",
    "40D63C": "Equitech Industrial(DongGuan)Co.",
    "AC512C": "Infinix mobility limited",
    "B019C6": "Apple",
    "3866F0": "Apple",
    "E4FB5D": "HUAWEI TECHNOLOGIES CO.",
    "E86819": "HUAWEI TECHNOLOGIES CO.",
    "0011C0": "Aday Technology Inc",
    "0005F1": "Vrcom",
    "1CAB34": "New H3C Technologies Co.",
    "3C7843": "HUAWEI TECHNOLOGIES CO.",
    "5C0979": "HUAWEI TECHNOLOGIES CO.",
    "309935": "zte corporation",
    "0C72D9": "zte corporation",
    "0030C8": "GAD LINE",
    "0016E0": "3Com Ltd",
    "D8DECE": "ISUNG CO.",
    "801934": "Intel Corporate",
    "703EAC": "Apple",
    "50642B": "XIAOMI Electronics",
    "30C01B": "Shenzhen Jingxun Software Telecommunication Technology Co.",
    "8C3BAD": "NETGEAR",
    "6432A8": "Intel Corporate",
    "747D24": "Phicomm (Shanghai) Co.",
    "64CFD9": "Texas Instruments",
    "008009": "JUPITER SYSTEMS",
    "00C064": "General Datacomm LLC",
    "F4B520": "Biostar Microtech international corp.",
    "8886C2": "STABILO International GmbH",
    "887A31": "Velankani Electronics Pvt. Ltd.",
    "8C0F6F": "PEGATRON CORPORATION",
    "8C2505": "HUAWEI TECHNOLOGIES CO.",
    "08A8A1": "Cyclotronics Power Concepts",
    "BC9680": "SHENZHEN GONGJIN ELECTRONICS CO.",
    "A47B9D": "Espressif Inc.",
    "7C2EDD": "Samsung Electronics Co.",
    "3CF7A4": "Samsung Electronics Co.",
    "CC2F71": "Intel Corporate",
    "B8F8BE": "BLUECOM",
    "2C5D93": "Ruckus Wireless",
    "0000FE": "Annapolis Micro Systems",
    "38E595": "SHENZHEN GONGJIN ELECTRONICS CO.",
    "38FF36": "Ruckus Wireless",
    "84183A": "Ruckus Wireless",
    "24C9A1": "Ruckus Wireless",
    "002482": "Ruckus Wireless",
    "103034": "Cara Systems",
    "706E6D": "Cisco Systems",
    "00D01F": "Senetas Corporation Ltd",
    "6447E0": "Feitian Technologies Co.",
    "B0DFC1": "Tenda Technology Co.",
    "9C6F52": "zte corporation",
    "604762": "Beijing Sensoro Technology Co.",
    "689234": "Ruckus Wireless",
    "50A733": "Ruckus Wireless",
    "E86D65": "AUDIO MOBIL Elektronik GmbH",
    "BC1C81": "Sichuan iLink Technology Co.",
    "900A1A": "Taicang T&W Electronics",
    "506E92": "Innocent Technology Co.",
    "30FE31": "Nokia",
    "E8E1E1": "Gemtek Technology Co.",
    "28070D": "GUANGZHOU WINSOUND INFORMATION TECHNOLOGY CO.",
    "B44F96": "Zhejiang Xinzailing Technology co.",
    "4C65A8": "IEEE Registration Authority",
    "D822F4": "Avnet Silica",
    "348F27": "Ruckus Wireless",
    "2C9EEC": "Jabil Circuit Penang",
    "C4571F": "June Life Inc",
    "886AE3": "Alpha Networks Inc.",
    "1C4D70": "Intel Corporate",
    "60313B": "Sunnovo International Limited",
    "6CB227": "Sony Video & Sound Products Inc.",
    "00A3D1": "Cisco Systems",
    "001CFA": "Alarm.com",
    "986F60": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "745427": "SHENZHEN FAST TECHNOLOGIES CO.",
    "60720B": "BLU Products Inc",
    "308976": "DALIAN LAMBA TECHNOLOGY CO.",
    "2C2617": "Oculus VR",
    "FC06ED": "M2Motive Technology Inc.",
    "34D954": "WiBotic Inc.",
    "4857DD": "Facebook Inc",
    "487D2E": "TP-LINK TECHNOLOGIES CO.",
    "A0094C": "CenturyLink",
    "F07485": "NGD Systems",
    "488D36": "Arcadyan Corporation",
    "BCD713": "Owl Labs",
    "F0D4F6": "Lars Thrane A/S",
    "F4A997": "CANON INC.",
    "FC4D8C": "SHENZHEN PANTE ELECTRONICS TECHNOLOGY CO.",
    "64DFE9": "ATEME",
    "B43934": "Pen Generations",
    "7426AC": "Cisco Systems",
    "10C6FC": "Garmin International",
    "AC2205": "Compal Broadband Networks",
    "80A036": "Shanghai MXCHIP Information Technology Co.",
    "105887": "Fiberhome Telecommunication Technologies Co.",
    "B02628": "Broadcom Limited",
    "9874DA": "Infinix mobility limited",
    "50338B": "Texas Instruments",
    "9C061B": "Hangzhou H3C Technologies Co.",
    "20F452": "Shanghai IUV Software Development Co. Ltd",
    "143F27": "Noccela Oy",
    "680235": "Konten Networks Inc.",
    "E8DE8E": "Integrated Device Technology (Malaysia) Sdn. Bhd.",
    "D8C06A": "Hunantv.com Interactive Entertainment Media Co.",
    "1C5A0B": "Tegile Systems",
    "046E02": "OpenRTLS Group",
    "900E83": "Monico Monitoring",
    "601466": "zte corporation",
    "AC202E": "Hitron Technologies. Inc",
    "D8D866": "SHENZHEN TOZED TECHNOLOGIES CO.",
    "6854ED": "Alcatel-Lucent",
    "38AC3D": "Nephos Inc",
    "38F135": "SensorTec-Canada",
    "AC7409": "Hangzhou H3C Technologies Co.",
    "E037BF": "Wistron Neweb Corporation",
    "E81367": "AIRSOUND Inc.",
    "C49DED": "Microsoft Corporation",
    "98A40E": "Snap",
    "F093C5": "Garland Technology",
    "9810E8": "Apple",
    "C0D012": "Apple",
    "BCA920": "Apple",
    "001192": "Cisco Systems",
    "8058F8": "Motorola Mobility LLC",
    "48A195": "Apple",
    "F80377": "Apple",
    "F49634": "Intel Corporate",
    "A41163": "IEEE Registration Authority",
    "E8D11B": "ASKEY COMPUTER CORP",
    "C4D197": "Ventia Utility Services",
    "70AF24": "TP Vision Belgium NV",
    "0C5F35": "Niagara Video Corporation",
    "7CE97C": "ITEL MOBILE LIMITED",
    "CCBE59": "Calix Inc.",
    "DCA4CA": "Apple",
    "8C8FE9": "Apple",
    "70AF25": "Nishiyama Industry Co.",
    "2C86D2": "Cisco Systems",
    "B8F883": "TP-LINK TECHNOLOGIES CO.",
    "DCFE18": "TP-LINK TECHNOLOGIES CO.",
    "704F57": "TP-LINK TECHNOLOGIES CO.",
    "001912": "Welcat Inc",
    "9800C1": "GuangZhou CREATOR Technology Co.",
    "98D3D2": "MEKRA Lang GmbH & Co. KG",
    "903D6B": "Zicon Technology Corp.",
    "B0C46C": "Senseit",
    "8C78D7": "SHENZHEN FAST TECHNOLOGIES CO.",
    "B8EAAA": "ICG NETWORKS CO.",
    "0002A1": "World Wide Packets",
    "00E022": "Analog Devices",
    "F8A34F": "zte corporation",
    "C87324": "Sow Cheng Technology Co. Ltd.",
    "4C4E03": "TCT mobile ltd",
    "50E666": "Shenzhen Techtion Electronics Co.",
    "B04089": "Senient Systems LTD",
    "5425EA": "HUAWEI TECHNOLOGIES CO.",
    "C894BB": "HUAWEI TECHNOLOGIES CO.",
    "10B1F8": "HUAWEI TECHNOLOGIES CO.",
    "089E08": "Google",
    "3C7F6F": "Telechips",
    "28FECD": "Lemobile Information Technology (Beijing) Co.",
    "00210D": "SAMSIN INNOTEC",
    "5CBA37": "Microsoft Corporation",
    "00C0C6": "PERSONAL MEDIA CORP.",
    "B8ECA3": "Zyxel Communications Corporation",
    "5419C8": "vivo Mobile Communication Co.",
    "000277": "Cash Systemes Industrie",
    "0016D3": "Wistron Corporation",
    "001F16": "Wistron Corporation",
    "00262D": "Wistron Corporation",
    "0495E6": "Tenda Technology Co.",
    "00608B": "ConferTech International",
    "702D84": "i4C Innovations",
    "C0D9F7": "ShanDong Domor Intelligent S&T CO.",
    "B0B98A": "NETGEAR",
    "805A04": "LG Electronics (Mobile Communications)",
    "2C200B": "Apple",
    "8866A5": "Apple",
    "901711": "Hagenuk Marinekommunikation GmbH",
    "0010DE": "INTERNATIONAL DATACASTING CORPORATION",
    "8CA5A1": "Oregano Systems - Design & Consulting GmbH",
    "CCA219": "SHENZHEN ALONG INVESTMENT CO.",
    "4C1A3A": "PRIMA Research And Production Enterprise Ltd.",
    "9CAED3": "Seiko Epson Corporation",
    "707C69": "Avaya Inc",
    "500B91": "IEEE Registration Authority",
    "F8461C": "Sony Interactive Entertainment Inc.",
    "704D7B": "ASUSTek COMPUTER INC.",
    "38BC01": "HUAWEI TECHNOLOGIES CO.",
    "341E6B": "HUAWEI TECHNOLOGIES CO.",
    "886639": "HUAWEI TECHNOLOGIES CO.",
    "000048": "Seiko Epson Corporation",
    "B0E892": "Seiko Epson Corporation",
    "AC1826": "Seiko Epson Corporation",
    "A4EE57": "Seiko Epson Corporation",
    "E4B005": "Beijing IQIYI Science & Technology Co.",
    "ACC1EE": "Xiaomi Communications Co Ltd",
    "BC8385": "Microsoft Corporation",
    "B05216": "Hon Hai Precision Ind. Co.",
    "14A78B": "Zhejiang Dahua Technology Co.",
    "4C26E7": "Welgate Co.",
    "006041": "Yokogawa Digital Computer Corporation",
    "18F87A": "i3 International Inc.",
    "A0E4CB": "Zyxel Communications Corporation",
    "284ED7": "OutSmart Power Systems",
    "64A68F": "Zhongshan Readboy Electronics Co.",
    "2C598A": "LG Electronics (Mobile Communications)",
    "A0B8F8": "Amgen U.S.A. Inc.",
    "884477": "HUAWEI TECHNOLOGIES CO.",
    "149D09": "HUAWEI TECHNOLOGIES CO.",
    "686975": "Angler Labs Inc",
    "4C11BF": "Zhejiang Dahua Technology Co.",
    "00425A": "Cisco Systems",
    "9CFBD5": "vivo Mobile Communication Co.",
    "18F76B": "Zhejiang Winsight Technology CO.",
    "C81B5C": "BCTech",
    "E07C13": "zte corporation",
    "F41F88": "zte corporation",
    "583112": "DRUST",
    "9C83BF": "PRO-VISION",
    "78EF4C": "Unetconvergence Co.",
    "20D25F": "SmartCap Technologies",
    "E47DBD": "Samsung Electronics Co.",
    "00C05A": "SEMAPHORE COMMUNICATIONS CORP.",
    "0007F9": "Sensaphone",
    "001CB3": "Apple",
    "1CC0E1": "IEEE Registration Authority",
    "24920E": "Samsung Electronics Co.",
    "FC4203": "Samsung Electronics Co.",
    "A01081": "Samsung Electronics Co.",
    "A04E01": "CENTRAL ENGINEERING co.",
    "28CA09": "ThyssenKrupp Elevators (Shanghai) Co.",
    "005093": "BOEING",
    "28EE52": "TP-LINK TECHNOLOGIES CO.",
    "001A39": "Merten GmbH&CoKG",
    "3C8BCD": "Alcatel-Lucent Shanghai Bell Co.",
    "4CF95D": "HUAWEI TECHNOLOGIES CO.",
    "8421F1": "HUAWEI TECHNOLOGIES CO.",
    "707990": "HUAWEI TECHNOLOGIES CO.",
    "14EDBB": "2Wire Inc",
    "18E29F": "vivo Mobile Communication Co.",
    "00B0E1": "Cisco Systems",
    "E43ED7": "Arcadyan Corporation",
    "F07960": "Apple",
    "A0D795": "Apple",
    "0090E7": "HORSCH ELEKTRONIK AG",
    "905C44": "Compal Broadband Networks",
    "842519": "Samsung Electronics",
    "5C2443": "O-Sung Telecom Co.",
    "2047ED": "SKY UK LIMITED",
    "748A69": "Korea Image Technology Co.",
    "5454CF": "PROBEDIGITAL CO.",
    "F8633F": "Intel Corporate",
    "088620": "TECNO MOBILE LIMITED",
    "002566": "Samsung Electronics Co.",
    "981333": "zte corporation",
    "6474F6": "Shooter Detection Systems",
    "00F22C": "Shanghai B-star Technology Co.",
    "0005EE": "Vanderbilt International (SWE) AB",
    "04180F": "Samsung Electronics Co.",
    "2013E0": "Samsung Electronics Co.",
    "D0DB32": "Nokia Corporation",
    "E80036": "Befs co",
    "C09F05": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "F43C96": "Ericsson AB",
    "F89E28": "Cisco Meraki",
    "388479": "Cisco Meraki",
    "5C4979": "AVM Audiovisuelles Marketing und Computersysteme GmbH",
    "C4411E": "Belkin International Inc.",
    "24F5A2": "Belkin International Inc.",
    "E0CBBC": "Cisco Meraki",
    "683A1E": "Cisco Meraki",
    "C0F945": "Toshiba Toko Meter Systems Co.",
    "70F8E7": "IEEE Registration Authority",
    "D42C44": "Cisco Systems",
    "B88EDF": "Zencheer Communication Technology Co.",
    "DC7144": "SAMSUNG ELECTRO MECHANICS CO.",
    "002485": "ConteXtream Ltd",
    "28FCF6": "Shenzhen Xin KingBrand enterprises Co.",
    "689423": "Hon Hai Precision Ind. Co.",
    "844BF5": "Hon Hai Precision Ind. Co.",
    "08EDB9": "Hon Hai Precision Ind. Co.",
    "3C77E6": "Hon Hai Precision Ind. Co.",
    "70188B": "Hon Hai Precision Ind. Co.",
    "980C82": "SAMSUNG ELECTRO MECHANICS CO.",
    "A00BBA": "SAMSUNG ELECTRO MECHANICS CO.",
    "606BBD": "Samsung Electronics Co.",
    "00214C": "Samsung Electronics Co.",
    "00166B": "Samsung Electronics Co.",
    "001F58": "EMH Energiemesstechnik GmbH",
    "0016DF": "Lundinova AB",
    "001D0C": "MobileCompia",
    "843DC6": "Cisco Systems",
    "0000F0": "Samsung Electronics Co.",
    "8CC8CD": "Samsung Electronics Co.",
    "8018A7": "Samsung Electronics Co.",
    "5C6D20": "Hon Hai Precision Ind. Co.",
    "5CAC4C": "Hon Hai Precision Ind. Co.",
    "34E71C": "Shenzhen YOUHUA Technology Co.",
    "F47B5E": "Samsung Electronics Co.",
    "08C6B3": "QTECH LLC",
    "0018AF": "Samsung Electronics Co.",
    "001EE1": "Samsung Electronics Co.",
    "D02544": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
    "005A13": "HUAWEI TECHNOLOGIES CO.",
    "24DBED": "Samsung Electronics Co.",
    "C45006": "Samsung Electronics Co.",
    "88329B": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
    "1449E0": "SAMSUNG ELECTRO-MECHANICS(THAILAND)",
    "D487D8": "Samsung Electronics Co.",
    "184617": "Samsung Electronics Co.",
    "380A94": "Samsung Electronics Co.",
    "D0DFC7": "Samsung Electronics Co.",
    "D0C1B1": "Samsung Electronics Co.",
    "20D390": "Samsung Electronics Co.",
    "9401C2": "Samsung Electronics Co.",
    "50FC9F": "Samsung Electronics Co.",
    "380B40": "Samsung Electronics Co.",
    "70F927": "Samsung Electronics Co.",
    "F0728C": "Samsung Electronics Co.",
    "34AA8B": "Samsung Electronics Co.",
    "BC4486": "Samsung Electronics Co.",
    "A8F274": "Samsung Electronics Co.",
    "886AB1": "vivo Mobile Communication Co.",
    "6C1E90": "Hansol Technics Co.",
    "00177E": "Meshcom Technologies Inc.",
    "98F058": "Lynxspring",
    "C4F5A5": "Kumalift Co.",
    "A00460": "NETGEAR",
    "9884E3": "Texas Instruments",
    "38D269": "Texas Instruments",
    "C8FD19": "Texas Instruments",
    "508CB1": "Texas Instruments",
    "B8FF61": "Apple",
    "946124": "Pason Systems",
    "68C44D": "Motorola Mobility LLC",
    "C8DE51": "IntegraOptics",
    "304487": "Hefei Radio Communication Technology Co.",
    "2C9D1E": "HUAWEI TECHNOLOGIES CO.",
    "943DC9": "Asahi Net",
    "0081C4": "Cisco Systems",
    "440444": "GUANGDONG OPPO MOBILE TELECOMMUNICATIONS CORP.",
    "58E876": "IEEE Registration Authority",
    "D03742": "Yulong Computer Telecommunication Scientific (Shenzhen) Co.",
    "001765": "Nortel Networks",
    "0015E8": "Nortel Networks",
    "000F06": "Nortel Networks",
    "F8E61A": "Samsung Electronics Co.",
    "84B541": "Samsung Electronics Co.",
    "006F64": "Samsung Electronics Co.",
    "DC6672": "Samsung Electronics Co.",
    "EC8EB5": "Hewlett Packard",
    "70AF6A": "SHENZHEN FENGLIAN TECHNOLOGY CO.",
    "C4047B": "Shenzhen YOUHUA Technology Co.",
    "20F41B": "Shenzhen Bilian electronic CO.",
    "00233E": "Alcatel-Lucent IPD",
    "6CBEE9": "Alcatel-Lucent IPD",
    "00164D": "Alcatel-Lucent IPD",
    "001AF0": "Alcatel-Lucent IPD",
    "38521A": "Nokia",
    "001E40": "Shanghai DareGlobal Technologies Co.",
    "20F543": "Hui Zhou Gaoshengda Technology Co.",
    "E0DDC0": "vivo Mobile Communication Co.",
    "94D723": "Shanghai DareGlobal Technologies Co.",
    "FCFAF7": "Shanghai Baud Data Communication Co.",
    "D826B9": "Guangdong Coagent Electronics S&amp;T Co.",
    "AC9CE4": "Alcatel-Lucent Shanghai Bell Co.",
    "00159B": "Nortel Networks",
    "001540": "Nortel Networks",
    "001ECA": "Nortel Networks",
    "00130A": "Nortel Networks",
    "001F0A": "Nortel Networks",
    "6CA858": "Fiberhome Telecommunication Technologies Co.",
    "A84E3F": "Hitron Technologies. Inc",
    "08D833": "Shenzhen RF Technology Co.",
    "A46032": "MRV Communications (Networks) LTD",
    "40667A": "mediola - connected living AG",
    "9C2A83": "Samsung Electronics Co.",
    "0022A9": "LG Electronics (Mobile Communications)",
    "0025E5": "LG Electronics (Mobile Communications)",
    "0021FB": "LG Electronics (Mobile Communications)",
    "34FCEF": "LG Electronics (Mobile Communications)",
    "BCF5AC": "LG Electronics (Mobile Communications)",
    "98D6F7": "LG Electronics (Mobile Communications)",
    "700514": "LG Electronics (Mobile Communications)",
    "E892A4": "LG Electronics (Mobile Communications)",
    "10683F": "LG Electronics (Mobile Communications)",
    "40B0FA": "LG Electronics (Mobile Communications)",
    "A039F7": "LG Electronics (Mobile Communications)",
    "1CCAE3": "IEEE Registration Authority",
    "E4956E": "IEEE Registration Authority",
    "B437D1": "IEEE Registration Authority",
    "A091C8": "zte corporation",
    "0055DA": "IEEE Registration Authority",
    "78C2C0": "IEEE Registration Authority",
    "2C6A6F": "IEEE Registration Authority",
    "00600F": "Westell Technologies Inc.",
    "00183A": "Westell Technologies Inc.",
    "000EE8": "Zioncom Electronics (Shenzhen) Ltd.",
    "00C095": "ZNYX Networks",
    "002025": "CONTROL TECHNOLOGY",
    "001E37": "Universal Global Scientific Industrial Co.",
    "001A6B": "Universal Global Scientific Industrial Co.",
    "001641": "Universal Global Scientific Industrial Co.",
    "0010C6": "Universal Global Scientific Industrial Co.",
    "00247E": "Universal Global Scientific Industrial Co.",
    "00DD0A": "UNGERMANN-BASS INC.",
    "002517": "Venntis",
    "683563": "SHENZHEN LIOWN ELECTRONICS CO.",
    "004072": "Applied Innovation Inc.",
    "0008F1": "Voltaire",
    "00199D": "Vizio",
    "001938": "UMB Communications Co.",
    "4439C4": "Universal Global Scientific Industrial Co.",
    "402CF4": "Universal Global Scientific Industrial Co.",
    "00B064": "Cisco Systems",
    "68A0F6": "HUAWEI TECHNOLOGIES CO.",
    "845DD7": "Shenzhen Netcom Electronics Co.",
    "1C57D8": "Kraftway Corporation PLC",
    "00E08B": "QLogic Corporation",
    "D8EB97": "TRENDnet",
    "001C7E": "Toshiba",
    "002318": "Toshiba",
    "B86B23": "Toshiba",
    "AC040B": "Peloton Interactive",
    "48FCB6": "LAVA INTERNATIONAL(H.K) LIMITED",
    "B0E235": "Xiaomi Communications Co Ltd",
    "40C729": "Sagemcom Broadband SAS",
    "001349": "Zyxel Communications Corporation",
    "D8E0B8": "BULAT LLC",
    "603197": "Zyxel Communications Corporation",
    "001BFE": "Zavio Inc.",
    "5410EC": "Microchip Technology Inc.",
    "0004A3": "Microchip Technology Inc.",
    "789CE7": "Shenzhen Aikede Technology Co.",
    "509F3B": "OI ELECTRIC CO.",
    "14C913": "LG Electronics",
    "C0C976": "Shenzhen TINNO Mobile Technology Corp.",
    "588BF3": "Zyxel Communications Corporation",
    "5067F0": "Zyxel Communications Corporation",
    "446EE5": "HUAWEI TECHNOLOGIES CO.",
    "C8778B": "Mercury Systems – Trusted Mission Solutions",
    "000B6B": "Wistron Neweb Corporation",
    "6002B4": "Wistron Neweb Corporation",
    "94DF4E": "Wistron InfoComm(Kunshan)Co.",
    "98EECB": "Wistron Infocomm (Zhongshan) Corporation",
    "683E34": "MEIZU Technology Co.",
    "00044B": "NVIDIA",
    "AC9B0A": "Sony Corporation",
    "104FA8": "Sony Corporation",
    "A06090": "Samsung Electronics Co.",
    "BC765E": "Samsung Electronics Co.",
    "E0A8B8": "Le Shi Zhi Xin Electronic Technology (Tianjin) Limited",
    "F45B73": "Wanjiaan Interconnected Technology Co.",
    "B88198": "Intel Corporate",
    "B0D7CC": "Tridonic GmbH & Co KG",
    "2CDDA3": "Point Grey Research Inc.",
    "00809F": "ALE International",
    "B824F0": "SOYO Technology Development Co.",
    "D85B2A": "Samsung Electronics Co.",
    "A009ED": "Avaya Inc",
    "0014B4": "General Dynamics United Kingdom Ltd",
    "A0B437": "GD Mission Systems",
    "E09861": "Motorola Mobility LLC",
    "9C8ECD": "Amcrest Technologies",
    "48C663": "GTO Access Systems LLC",
    "005F86": "Cisco Systems",
    "381DD9": "FN-LINK TECHNOLOGY LIMITED",
    "00F663": "Cisco Systems",
    "8C6D50": "SHENZHEN MTC CO LTD",
    "FC2325": "EosTek (Shenzhen) Co.",
    "FC3D93": "LONGCHEER TELECOMMUNICATION LIMITED",
    "8C59C3": "ADB Italia",
    "1CB9C4": "Ruckus Wireless",
    "FCA89A": "Sunitec Enterprise Co.",
    "1C7B23": "Qingdao Hisense Communications Co.",
    "C83DFC": "AlphaTheta Corporation",
    "CCD31E": "IEEE Registration Authority",
    "34B354": "HUAWEI TECHNOLOGIES CO.",
    "C02FF1": "Volta Networks",
    "E8A7F2": "sTraffic",
    "001F20": "Logitech Europe SA",
    "1C6E76": "Quarion Technology Inc",
    "0062EC": "Cisco Systems",
    "6C0EE6": "Chengdu Xiyida Electronic Technology Co",
    "000763": "Sunniwell Cyber Tech. Co.",
    "C46AB7": "Xiaomi Communications Co Ltd",
    "000AED": "HARTING Electronics GmbH",
    "CC167E": "Cisco Systems",
    "CC500A": "Fiberhome Telecommunication Technologies Co.",
    "D046DC": "Southwest Research Institute",
    "0CDA41": "Hangzhou H3C Technologies Co.",
    "74258A": "Hangzhou H3C Technologies Co.",
    "741F4A": "Hangzhou H3C Technologies Co.",
    "70A2B3": "Apple",
    "F40F24": "Apple",
    "4C57CA": "Apple",
    "90C1C6": "Apple",
    "E41D2D": "Mellanox Technologies",
    "240A11": "TCT mobile ltd",
    "D8E56D": "TCT mobile ltd",
    "540593": "WOORI ELEC Co.",
    "A0B662": "Acutvista Innovation Co.",
    "3497F6": "ASUSTek COMPUTER INC.",
    "50680A": "HUAWEI TECHNOLOGIES CO.",
    "00A006": "IMAGE DATA PROCESSING SYSTEM GROUP",
    "C83F26": "Microsoft Corporation",
    "000C49": "Dangaard Telecom Denmark A/S",
    "002238": "LOGIPLUS",
    "F8DA0C": "Hon Hai Precision Ind. Co.",
    "1C1B0D": "GIGA-BYTE TECHNOLOGY CO.",
    "48E9F1": "Apple",
    "903809": "Ericsson AB",
    "A4D8CA": "HONG KONG WATER WORLD TECHNOLOGY CO. LIMITED",
    "8019FE": "JianLing Technology CO.",
    "60B4F7": "Plume Design Inc",
    "44650D": "Amazon Technologies Inc.",
    "E42F56": "OptoMET GmbH",
    "00168F": "GN Netcom A/S",
    "487ADA": "Hangzhou H3C Technologies Co.",
    "1078D2": "Elitegroup Computer Systems Co.",
    "002197": "Elitegroup Computer Systems Co.",
    "001E90": "Elitegroup Computer Systems Co.",
    "0022B1": "Elbit Systems Ltd.",
    "0000B4": "Edimax Technology Co. Ltd.",
    "A08CFD": "Hewlett Packard",
    "60B387": "Synergics Technologies GmbH",
    "001F45": "Enterasys",
    "000E03": "Emulex Corporation",
    "000D87": "Elitegroup Computer Systems Co.",
    "FC3F7C": "HUAWEI TECHNOLOGIES CO.",
    "384C4F": "HUAWEI TECHNOLOGIES CO.",
    "FC084A": "FUJITSU LIMITED",
    "00CAE5": "Cisco Systems",
    "004268": "Cisco Systems",
    "4883C7": "Sagemcom Broadband SAS",
    "40163B": "Samsung Electronics Co.",
    "48555F": "Fiberhome Telecommunication Technologies Co.",
    "BC9889": "Fiberhome Telecommunication Technologies Co.",
    "24615A": "China Mobile Group Device Co.",
    "04A316": "Texas Instruments",
    "D4F207": "DIAODIAO(Beijing)Technology CO.",
    "D4AD2D": "Fiberhome Telecommunication Technologies Co.",
    "F08CFB": "Fiberhome Telecommunication Technologies Co.",
    "30B49E": "TP-LINK TECHNOLOGIES CO.",
    "34E70B": "HAN Networks Co.",
    "007888": "Cisco Systems",
    "140C5B": "PLNetworks",
    "50FF99": "IEEE Registration Authority",
    "84E323": "Green Wave Telecommunication SDN BHD",
    "0CBF3F": "Shenzhen Lencotion Technology Co.",
    "001706": "Techfaithwireless Communication Technology Limited.",
    "C83870": "Samsung Electronics Co.",
    "1C553A": "QianGua Corp.",
    "008E73": "Cisco Systems",
    "9C9D5D": "Raden Inc",
    "DC4D23": "MRV Comunications",
    "0023B3": "Lyyn AB",
    "248A07": "Mellanox Technologies",
    "405EE1": "Shenzhen H&T Intelligent Control Co.",
    "002578": "JSC Concern Sozvezdie",
    "085BDA": "CliniCare LTD",
    "1CC035": "PLANEX COMMUNICATIONS INC.",
    "583277": "Reliance Communications LLC",
    "0015C1": "Sony Interactive Entertainment Inc.",
    "34543C": "TAKAOKA TOKO CO.",
    "900325": "HUAWEI TECHNOLOGIES CO.",
    "98E7F5": "HUAWEI TECHNOLOGIES CO.",
    "A09D91": "SoundBridge",
    "40B688": "LEGIC Identsystems AG",
    "9CD48B": "Innolux Technology Europe BV",
    "90A62F": "NAVER",
    "1C9E46": "Apple",
    "9C4FDA": "Apple",
    "00351A": "Cisco Systems",
    "00AF1F": "Cisco Systems",
    "C0CCF8": "Apple",
    "402E28": "MiXTelematics",
    "6C8FB5": "Microsoft Mobile Oy",
    "C4E510": "Mechatro",
    "803896": "SHARP Corporation",
    "8489AD": "Apple",
    "0060EC": "HERMARY OPTO ELECTRONICS INC.",
    "AC3A7A": "Roku",
    "B83E59": "Roku",
    "DC3A5E": "Roku",
    "00507F": "DrayTek Corp.",
    "001A73": "Gemtek Technology Co.",
    "00904B": "Gemtek Technology Co.",
    "001A7F": "GCI Science & Technology Co.",
    "0024D4": "FREEBOX SAS",
    "ECF35B": "Nokia Corporation",
    "544408": "Nokia Corporation",
    "3CC243": "Nokia Corporation",
    "347E39": "Nokia Danmark A/S",
    "00180F": "Nokia Danmark A/S",
    "C8979F": "Nokia Corporation",
    "0021FC": "Nokia Danmark A/S",
    "001F5D": "Nokia Danmark A/S",
    "001F01": "Nokia Danmark A/S",
    "001979": "Nokia Danmark A/S",
    "0025D0": "Nokia Danmark A/S",
    "001BEE": "Nokia Danmark A/S",
    "00175A": "Cisco Systems",
    "0090A2": "CyberTAN Technology Inc.",
    "0090D6": "Crystal Group",
    "647791": "Samsung Electronics Co.",
    "9CE6E7": "Samsung Electronics Co.",
    "9C0298": "Samsung Electronics Co.",
    "28987B": "Samsung Electronics Co.",
    "0C715D": "Samsung Electronics Co.",
    "BCD11F": "Samsung Electronics Co.",
    "F4428F": "Samsung Electronics Co.",
    "446D6C": "Samsung Electronics Co.",
    "00F46F": "Samsung Electronics Co.",
    "54FA3E": "Samsung Electronics Co.",
    "0C8910": "Samsung Electronics Co.",
    "78ABBB": "Samsung Electronics Co.",
    "D476EA": "zte corporation",
    "001018": "Broadcom",
    "18C086": "Broadcom",
    "D8C4E9": "Samsung Electronics Co.",
    "7C1CF1": "HUAWEI TECHNOLOGIES CO.",
    "78F557": "HUAWEI TECHNOLOGIES CO.",
    "E02861": "HUAWEI TECHNOLOGIES CO.",
    "D0D04B": "HUAWEI TECHNOLOGIES CO.",
    "480031": "HUAWEI TECHNOLOGIES CO.",
    "4C09D4": "Arcadyan Technology Corporation",
    "C8FF28": "Liteon Technology Corporation",
    "9C80DF": "Arcadyan Technology Corporation",
    "002308": "Arcadyan Technology Corporation",
    "880355": "Arcadyan Technology Corporation",
    "34BB1F": "BlackBerry RTS",
    "FCB4E6": "ASKEY COMPUTER CORP",
    "0896D7": "AVM GmbH",
    "506A03": "NETGEAR",
    "100D7F": "NETGEAR",
    "504A6E": "NETGEAR",
    "E0469A": "NETGEAR",
    "406F2A": "BlackBerry RTS",
    "30469A": "NETGEAR",
    "04E676": "AMPAK Technology",
    "0022F4": "AMPAK Technology",
    "001DBA": "Sony Corporation",
    "0024BE": "Sony Corporation",
    "000FDE": "Sony Corporation",
    "001B59": "Sony Corporation",
    "002298": "Sony Corporation",
    "2421AB": "Sony Corporation",
    "B8F934": "Sony Corporation",
    "8C6422": "Sony Corporation",
    "00006E": "Artisoft Inc.",
    "00DA55": "Cisco Systems",
    "0004E3": "Accton Technology Corp",
    "0010B5": "Accton Technology Corp",
    "1974": "16063",
    "E0B2F1": "FN-LINK TECHNOLOGY LIMITED",
    "0C4C39": "MitraStar Technology Corp.",
    "E063E5": "Sony Corporation",
    "F8D0AC": "Sony Interactive Entertainment Inc.",
    "0CFE45": "Sony Interactive Entertainment Inc.",
    "2016D8": "Liteon Technology Corporation",
    "F0272D": "Amazon Technologies Inc.",
    "84D6D0": "Amazon Technologies Inc.",
    "00D0C9": "ADVANTECH CO.",
    "6487D7": "ADB Broadband Italia",
    "38229D": "ADB Broadband Italia",
    "A4526F": "ADB Broadband Italia",
    "74888B": "ADB Broadband Italia",
    "008C54": "ADB Broadband Italia",
    "00247B": "Actiontec Electronics",
    "E8617E": "Liteon Technology Corporation",
    "18CF5E": "Liteon Technology Corporation",
    "18FE34": "Espressif Inc.",
    "002243": "AzureWave Technology Inc.",
    "18E3BC": "TCT mobile ltd",
    "CC1FC4": "InVue",
    "5C36B8": "TCL King Electrical Appliances (Huizhou) Co.",
    "00AA01": "Intel Corporation",
    "00AA00": "Intel Corporation",
    "00C2C6": "Intel Corporate",
    "5CD2E4": "Intel Corporate",
    "28B2BD": "Intel Corporate",
    "985FD3": "Microsoft Corporation",
    "448500": "Intel Corporate",
    "0CD292": "Intel Corporate",
    "685D43": "Intel Corporate",
    "A0369F": "Intel Corporate",
    "64D4DA": "Intel Corporate",
    "4025C2": "Intel Corporate",
    "502DA2": "Intel Corporate",
    "78929C": "Intel Corporate",
    "4C79BA": "Intel Corporate",
    "84A6C8": "Intel Corporate",
    "5891CF": "Intel Corporate",
    "0C8BFD": "Intel Corporate",
    "843A4B": "Intel Corporate",
    "5C514F": "Intel Corporate",
    "A44E31": "Intel Corporate",
    "DCA971": "Intel Corporate",
    "58946B": "Intel Corporate",
    "0024D7": "Intel Corporate",
    "0024D6": "Intel Corporate",
    "001DE0": "Intel Corporate",
    "A0A8CD": "Intel Corporate",
    "5CC5D4": "Intel Corporate",
    "4CEB42": "Intel Corporate",
    "F81654": "Intel Corporate",
    "606C66": "Intel Corporate",
    "4C8093": "Intel Corporate",
    "AC7289": "Intel Corporate",
    "605BB4": "AzureWave Technology Inc.",
    "64D954": "Taicang T&W Electronics",
    "001E64": "Intel Corporate",
    "00215C": "Intel Corporate",
    "00216B": "Intel Corporate",
    "0022FB": "Intel Corporate",
    "001517": "Intel Corporate",
    "247C4C": "Herman Miller",
    "E46F13": "D-Link International",
    "1C4419": "TP-LINK TECHNOLOGIES CO.",
    "002691": "Sagemcom Broadband SAS",
    "988B5D": "Sagemcom Broadband SAS",
    "90013B": "Sagemcom Broadband SAS",
    "7C034C": "Sagemcom Broadband SAS",
    "6C2E85": "Sagemcom Broadband SAS",
    "94FEF4": "Sagemcom Broadband SAS",
    "28FAA0": "vivo Mobile Communication Co.",
    "ECDF3A": "vivo Mobile Communication Co.",
    "5C353B": "Compal Broadband Networks",
    "00604C": "Sagemcom Broadband SAS",
    "001F95": "Sagemcom Broadband SAS",
    "002348": "Sagemcom Broadband SAS",
    "448723": "HOYA SERVICE CORPORATION",
    "D86C02": "Huaqin Telecom Technology Co.",
    "60BEB5": "Motorola Mobility LLC",
    "F8F1B6": "Motorola Mobility LLC",
    "3CFDFE": "Intel Corporate",
    "A4C494": "Intel Corporate",
    "902E1C": "Intel Corporate",
    "A434D9": "Intel Corporate",
    "F4F1E1": "Motorola Mobility LLC",
    "9CD917": "Motorola Mobility LLC",
    "9068C3": "Motorola Mobility LLC",
    "3C197D": "Ericsson AB",
    "34EF44": "2Wire Inc",
    "B0E754": "2Wire Inc",
    "B8E625": "2Wire Inc",
    "001D5A": "2Wire Inc",
    "00253C": "2Wire Inc",
    "F42981": "vivo Mobile Communication Co.",
    "84F6FA": "Miovision Technologies Incorporated",
    "F8E71E": "Ruckus Wireless",
    "001783": "Texas Instruments",
    "34B1F7": "Texas Instruments",
    "2CFD37": "Blue Calypso",
    "0C6127": "Actiontec Electronics",
    "08863B": "Belkin International Inc.",
    "2C56DC": "ASUSTek COMPUTER INC.",
    "3CD92B": "Hewlett Packard",
    "90D7EB": "Texas Instruments",
    "78DEE4": "Texas Instruments",
    "001833": "Texas Instruments",
    "001834": "Texas Instruments",
    "0017E3": "Texas Instruments",
    "001830": "Texas Instruments",
    "0023D4": "Texas Instruments",
    "C0E422": "Texas Instruments",
    "D00790": "Texas Instruments",
    "3C7DB1": "Texas Instruments",
    "00F871": "Demant A/S",
    "002191": "D-Link Corporation",
    "F4FC32": "Texas Instruments",
    "2435CC": "Zhongshan Scinan Internet of Things Co.",
    "2C3033": "NETGEAR",
    "BC4434": "Shenzhen TINNO Mobile Technology Corp.",
    "04BF6D": "Zyxel Communications Corporation",
    "CC46D6": "Cisco Systems",
    "0041D2": "Cisco Systems",
    "0CD746": "Apple",
    "60A37D": "Apple",
    "68DBCA": "Apple",
    "086698": "Apple",
    "BC5436": "Apple",
    "044BED": "Apple",
    "6C8DC1": "Apple",
    "ACF1DF": "D-Link International",
    "BCF685": "D-Link International",
    "78542E": "D-Link International",
    "C4A81D": "D-Link International",
    "F88FCA": "Google",
    "2CAB00": "HUAWEI TECHNOLOGIES CO.",
    "A8CA7B": "HUAWEI TECHNOLOGIES CO.",
    "88B8D0": "Dongguan Koppo Electronic Co.",
    "58AC78": "Cisco Systems",
    "FCFFAA": "IEEE Registration Authority",
    "3898D8": "MERITECH CO.",
    "9486CD": "SEOUL ELECTRONICS&TELECOM",
    "84ACFB": "Crouzet Automatismes",
    "7CBB8A": "Nintendo Co.",
    "3897D6": "Hangzhou H3C Technologies Co.",
    "1CA770": "SHENZHEN CHUANGWEI-RGB ELECTRONICS CO.",
    "8896B6": "Global Fire Equipment S.A.",
    "000D0B": "BUFFALO.INC",
    "001D73": "BUFFALO.INC",
    "001601": "BUFFALO.INC",
    "7403BD": "BUFFALO.INC",
    "B8FC9A": "Le Shi Zhi Xin Electronic Technology (Tianjin) Limited",
    "CC3E5F": "Hewlett Packard",
    "D89D67": "Hewlett Packard",
    "A45D36": "Hewlett Packard",
    "F0921C": "Hewlett Packard",
    "A0481C": "Hewlett Packard",
    "A01D48": "Hewlett Packard",
    "000423": "Intel Corporation",
    "001111": "Intel Corporation",
    "001302": "Intel Corporate",
    "40A8F0": "Hewlett Packard",
    "8851FB": "Hewlett Packard",
    "082E5F": "Hewlett Packard",
    "E4115B": "Hewlett Packard",
    "28924A": "Hewlett Packard",
    "0014C2": "Hewlett Packard",
    "00805F": "Hewlett Packard",
    "288023": "Hewlett Packard",
    "780AC7": "Baofeng TV Co.",
    "0018FE": "Hewlett Packard",
    "001A4B": "Hewlett Packard",
    "002481": "Hewlett Packard",
    "000F61": "Hewlett Packard",
    "8CAB8E": "Shanghai Feixun Communication Co.",
    "9060F1": "Apple",
    "A4516F": "Microsoft Mobile Oy",
    "FC64BA": "Xiaomi Communications Co Ltd",
    "D40B1A": "HTC Corporation",
    "945330": "Hon Hai Precision Ind. Co.",
    "4CD08A": "HUMAX Co.",
    "CC4EEC": "HUMAX Co.",
    "403DEC": "HUMAX Co.",
    "EC4D47": "HUAWEI TECHNOLOGIES CO.",
    "C44044": "RackTop Systems Inc.",
    "4CA161": "Rain Bird Corporation",
    "A08D16": "HUAWEI TECHNOLOGIES CO.",
    "00242B": "Hon Hai Precision Ind. Co.",
    "F8D111": "TP-LINK TECHNOLOGIES CO.",
    "B0487A": "TP-LINK TECHNOLOGIES CO.",
    "940C6D": "TP-LINK TECHNOLOGIES CO.",
    "542758": "Motorola (Wuhan) Mobility Technologies Communication Co.",
    "480FCF": "Hewlett Packard",
    "000480": "Brocade Communications Systems LLC",
    "000CDB": "Brocade Communications Systems LLC",
    "001BED": "Brocade Communications Systems LLC",
    "000533": "Brocade Communications Systems LLC",
    "006069": "Brocade Communications Systems LLC",
    "0060DF": "Brocade Communications Systems LLC",
    "000088": "Brocade Communications Systems LLC",
    "2C088C": "HUMAX Co.",
    "1C994C": "Murata Manufacturing Co.",
    "F02765": "Murata Manufacturing Co.",
    "5CF8A1": "Murata Manufacturing Co.",
    "44A7CF": "Murata Manufacturing Co.",
    "0013E0": "Murata Manufacturing Co.",
    "08181A": "zte corporation",
    "001E73": "zte corporation",
    "0015EB": "zte corporation",
    "001C25": "Hon Hai Precision Ind. Co.",
    "00197E": "Hon Hai Precision Ind. Co.",
    "90FBA6": "Hon Hai Precision Ind. Co.",
    "4437E6": "Hon Hai Precision Ind. Co.",
    "CCAF78": "Hon Hai Precision Ind. Co.",
    "F4B7E2": "Hon Hai Precision Ind. Co.",
    "785968": "Hon Hai Precision Ind. Co.",
    "647002": "TP-LINK TECHNOLOGIES CO.",
    "10FEED": "TP-LINK TECHNOLOGIES CO.",
    "645601": "TP-LINK TECHNOLOGIES CO.",
    "ECCB30": "HUAWEI TECHNOLOGIES CO.",
    "F4DCF9": "HUAWEI TECHNOLOGIES CO.",
    "EC26CA": "TP-LINK TECHNOLOGIES CO.",
    "9471AC": "TCT mobile ltd",
    "00664B": "HUAWEI TECHNOLOGIES CO.",
    "9CC172": "HUAWEI TECHNOLOGIES CO.",
    "247F3C": "HUAWEI TECHNOLOGIES CO.",
    "C8D15E": "HUAWEI TECHNOLOGIES CO.",
    "F4559C": "HUAWEI TECHNOLOGIES CO.",
    "80B686": "HUAWEI TECHNOLOGIES CO.",
    "10C61F": "HUAWEI TECHNOLOGIES CO.",
    "CC96A0": "HUAWEI TECHNOLOGIES CO.",
    "581F28": "HUAWEI TECHNOLOGIES CO.",
    "C07009": "HUAWEI TECHNOLOGIES CO.",
    "8038BC": "HUAWEI TECHNOLOGIES CO.",
    "C4072F": "HUAWEI TECHNOLOGIES CO.",
    "F48E92": "HUAWEI TECHNOLOGIES CO.",
    "241FA0": "HUAWEI TECHNOLOGIES CO.",
    "7054F5": "HUAWEI TECHNOLOGIES CO.",
    "9017AC": "HUAWEI TECHNOLOGIES CO.",
    "18C58A": "HUAWEI TECHNOLOGIES CO.",
    "34CDBE": "HUAWEI TECHNOLOGIES CO.",
    "D8490B": "HUAWEI TECHNOLOGIES CO.",
    "C057BC": "Avaya Inc",
    "64A7DD": "Avaya Inc",
    "A4251B": "Avaya Inc",
    "646A52": "Avaya Inc",
    "F80113": "HUAWEI TECHNOLOGIES CO.",
    "A49947": "HUAWEI TECHNOLOGIES CO.",
    "308730": "HUAWEI TECHNOLOGIES CO.",
    "44322A": "Avaya Inc",
    "7038EE": "Avaya Inc",
    "703018": "Avaya Inc",
    "9C28EF": "HUAWEI TECHNOLOGIES CO.",
    "006083": "Cisco Systems",
    "006009": "Cisco Systems",
    "00067C": "Cisco Systems",
    "00E0F7": "Cisco Systems",
    "005073": "Cisco Systems",
    "00900C": "Cisco Systems",
    "00905F": "Cisco Systems",
    "00100B": "Cisco Systems",
    "00173B": "Cisco Systems",
    "F0B429": "Xiaomi Communications Co Ltd",
    "00107B": "Cisco Systems",
    "0050E2": "Cisco Systems",
    "080028": "Texas Instruments",
    "405FC2": "Texas Instruments",
    "20CD39": "Texas Instruments",
    "B4994C": "Texas Instruments",
    "E4D3F1": "Cisco Systems",
    "8478AC": "Cisco Systems",
    "04DAD2": "Cisco Systems",
    "F02929": "Cisco Systems",
    "20BBC0": "Cisco Systems",
    "4C4E35": "Cisco Systems",
    "68DFDD": "Xiaomi Communications Co Ltd",
    "98FAE3": "Xiaomi Communications Co Ltd",
    "0090A6": "Cisco Systems",
    "009086": "Cisco Systems",
    "005080": "Cisco Systems",
    "EC24B8": "Texas Instruments",
    "7CEC79": "Texas Instruments",
    "689E19": "Texas Instruments",
    "E0E5CF": "Texas Instruments",
    "001BD7": "Cisco SPVTG",
    "00248C": "ASUSTek COMPUTER INC.",
    "002354": "ASUSTek COMPUTER INC.",
    "1C872C": "ASUSTek COMPUTER INC.",
    "60182E": "ShenZhen Protruly Electronic Ltd co.",
    "C4143C": "Cisco Systems",
    "3C08F6": "Cisco Systems",
    "78BAF9": "Cisco Systems",
    "0022CE": "Cisco SPVTG",
    "000F66": "Cisco-Linksys",
    "001E8C": "ASUSTek COMPUTER INC.",
    "0013D4": "ASUSTek COMPUTER INC.",
    "20CF30": "ASUSTek COMPUTER INC.",
    "501CBF": "Cisco Systems",
    "B000B4": "Cisco Systems",
    "544A00": "Cisco Systems",
    "00E16D": "Cisco Systems",
    "BC1665": "Cisco Systems",
    "F872EA": "Cisco Systems",
    "D0C789": "Cisco Systems",
    "F84F57": "Cisco Systems",
    "7C69F6": "Cisco Systems",
    "78DA6E": "Cisco Systems",
    "E0D173": "Cisco Systems",
    "E0899D": "Cisco Systems",
    "C47295": "Cisco Systems",
    "24374C": "Cisco SPVTG",
    "F45FD4": "Cisco SPVTG",
    "2CABA4": "Cisco SPVTG",
    "1C6E4C": "Logistic Service & Engineering Co.",
    "B8782E": "Apple",
    "000502": "Apple",
    "34BDC8": "Cisco Systems",
    "DCEB94": "Cisco Systems",
    "84B517": "Cisco Systems",
    "188B9D": "Cisco Systems",
    "E4AA5D": "Cisco Systems",
    "9803D8": "Apple",
    "D89E3F": "Apple",
    "B8C75D": "Apple",
    "0C74C2": "Apple",
    "90840D": "Apple",
    "E80688": "Apple",
    "7CC537": "Apple",
    "78CA39": "Apple",
    "18E7F4": "Apple",
    "70CD60": "Apple",
    "8C7B9D": "Apple",
    "002241": "Apple",
    "00264A": "Apple",
    "041E64": "Apple",
    "000A95": "Apple",
    "001124": "Apple",
    "CC785F": "Apple",
    "88CB87": "Apple",
    "685B35": "Apple",
    "2CB43A": "Apple",
    "689C70": "Apple",
    "380F4A": "Apple",
    "444C0C": "Apple",
    "B4F0AB": "Apple",
    "80929F": "Apple",
    "9C04EB": "Apple",
    "5C969D": "Apple",
    "3010E4": "Apple",
    "A886DD": "Apple",
    "F0C1F1": "Apple",
    "843835": "Apple",
    "8C006D": "Apple",
    "5C95AE": "Apple",
    "842999": "Apple",
    "74E2F5": "Apple",
    "E0C97A": "Apple",
    "A8968A": "Apple",
    "F41BA1": "Apple",
    "041552": "Apple",
    "68A86D": "Apple",
    "7CC3A1": "Apple",
    "7073CB": "Apple",
    "907240": "Apple",
    "F82793": "Apple",
    "403004": "Apple",
    "60C547": "Apple",
    "EC852F": "Apple",
    "00F4B9": "Apple",
    "3CAB8E": "Apple",
    "609217": "Apple",
    "84B153": "Apple",
    "E06678": "Apple",
    "48D705": "Apple",
    "68D93C": "Apple",
    "00F76F": "Apple",
    "C88550": "Apple",
    "E0B52D": "Apple",
    "A43135": "Apple",
    "7014A6": "Apple",
    "985AEB": "Apple",
    "78D75F": "Apple",
    "4C7C5F": "Apple",
    "68644B": "Apple",
    "C81EE7": "Apple",
    "6C94F8": "Apple",
    "908D6C": "Apple",
    "B8098A": "Apple",
    "C0CECD": "Apple",
    "60D9C7": "Apple",
    "F44B2A": "Cisco SPVTG",
    "C4ADF1": "GOPEACE Inc.",
    "58FC73": "Arria Live Media",
    "0C1A10": "Acoustic Stream",
    "E81363": "Comstock RD",
    "741865": "Shanghai DareGlobal Technologies Co.",
    "A4B805": "Apple",
    "90C99B": "Tesorion Nederland B.V.",
    "5CADCF": "Apple",
    "BC6C21": "Apple",
    "C4EF70": "Home Skinovations",
    "746F19": "ICARVISIONS (SHENZHEN) TECHNOLOGY CO.",
    "7C5A67": "JNC Systems",
    "5CE3B6": "Fiberhome Telecommunication Technologies Co.",
    "A0F9E0": "VIVATEL COMPANY LIMITED",
    "2CAE2B": "Samsung Electronics Co.",
    "C869CD": "Apple",
    "F8C372": "TSUZUKI DENKI",
    "D47208": "Bragi GmbH",
    "A4A6A9": "Private",
    "8C10D4": "Sagemcom Broadband SAS",
    "F898B9": "HUAWEI TECHNOLOGIES CO.",
    "5CB559": "CNEX Labs",
    "B83A9D": "Alarm.com",
    "F40E22": "Samsung Electronics Co.",
    "C01173": "Samsung Electronics Co.",
    "7853F2": "Roxton Systems Ltd.",
    "6CEBB2": "Dongguan Sen DongLv Electronics Co.",
    "6858C5": "ZF TRW Automotive",
    "BCE63F": "Samsung Electronics Co.",
    "7C9122": "Samsung Electronics Co.",
    "ACBC32": "Apple",
    "544E90": "Apple",
    "881B99": "SHENZHEN XIN FEI JIA ELECTRONIC CO. LTD.",
    "080A4E": "Planet Bingo® — 3rd Rock Gaming®",
    "B49D0B": "BQ",
    "3C8CF8": "TRENDnet",
    "A87285": "IDT",
    "780541": "Queclink Wireless Solutions Co.",
    "044169": "GoPro",
    "C02DEE": "Cuff",
    "9023EC": "Availink",
    "441CA8": "Hon Hai Precision Ind. Co.",
    "340CED": "Moduel AB",
    "9CA69D": "Whaley Technology Co.Ltd",
    "5853C0": "Beijing Guang Runtong Technology Development Company co.",
    "247260": "IOTTECH Corp",
    "E8F2E2": "LG Innotek",
    "2CA539": "Parallel Wireless",
    "245BF0": "Liteon",
    "CC794A": "BLU Products Inc.",
    "B4293D": "Shenzhen Urovo Technology Co.",
    "54FF82": "Davit Solution co.",
    "2827BF": "Samsung Electronics Co.",
    "F4E926": "Tianjin Zanpu Technology Inc.",
    "906F18": "Private",
    "98CB27": "Galore Networks Pvt. Ltd.",
    "94D859": "TCT mobile ltd",
    "2CFCE4": "CTEK Sweden AB",
    "E855B4": "SAI Technology Inc.",
    "50DF95": "Lytx",
    "300C23": "zte corporation",
    "C47D46": "FUJITSU LIMITED",
    "C0B713": "Beijing Xiaoyuer Technology Co. Ltd.",
    "188EF9": "G2C Co. Ltd.",
    "F4B8A7": "zte corporation",
    "20635F": "Abeeway",
    "083A5C": "Junilab",
    "6CE01E": "Modcam AB",
    "74852A": "PEGATRON CORPORATION",
    "4CEEB0": "SHC Netzwerktechnik GmbH",
    "800184": "HTC Corporation",
    "B8B3DC": "DEREK (SHAOGUAN) LIMITED",
    "702A7D": "EpSpot AB",
    "4CAE31": "ShengHai Electronics (Shenzhen) Ltd",
    "F4E9D4": "QLogic Corporation",
    "44F436": "zte corporation",
    "44C69B": "Wuhan Feng Tian Information Network CO.",
    "4CB76D": "Novi Security",
    "185D9A": "BobjGear LLC",
    "C02567": "Nexxt Solutions",
    "FCE33C": "HUAWEI TECHNOLOGIES CO.",
    "9CB6D0": "Rivet Networks",
    "40B89A": "Hon Hai Precision Ind. Co.",
    "1CB72C": "ASUSTek COMPUTER INC.",
    "40B837": "Sony Corporation",
    "609C9F": "Brocade Communications Systems LLC",
    "A8827F": "CIBN Oriental Network(Beijing) CO.",
    "D048F3": "DATTUS Inc",
    "B008BF": "Vital Connect",
    "E076D0": "AMPAK Technology",
    "D4522A": "TangoWiFi.com",
    "B8C3BF": "Henan Chengshi NetWork Technology Co.，Ltd",
    "44962B": "Aidon Oy",
    "E807BF": "SHENZHEN BOOMTECH INDUSTRY CO.",
    "84F129": "Metrascale Inc.",
    "B89ACD": "ELITE OPTOELECTRONIC(ASIA)CO.",
    "D468BA": "Shenzhen Sundray Technologies Company Limited",
    "F01E34": "ORICO Technologies Co.",
    "DCE026": "Patrol Tag",
    "B40566": "SP Best Corporation Co.",
    "1CC72D": "Shenzhen Huapu Digital CO.",
    "8CBFA6": "Samsung Electronics Co.",
    "086266": "ASUSTek COMPUTER INC.",
    "9C3066": "RWE Effizienz GmbH",
    "700136": "FATEK Automation Corporation",
    "FCA22A": "PT. Callysta Multi Engineering",
    "A45602": "fenglian Technology Co.",
    "C8C50E": "Shenzhen Primestone Network Technologies.Co.",
    "D06A1F": "BSE CO.",
    "18BDAD": "L-TECH CORPORATION",
    "60E6BC": "Sino-Telecom Technology Co.",
    "94E2FD": "Boge Kompressoren OTTO Boge GmbH & Co. KG",
    "F42C56": "SENOR TECH CO LTD",
    "FCDC4A": "G-Wearables Corp.",
    "1C14B3": "Airwire Technologies",
    "A89008": "Beijing Yuecheng Technology Co. Ltd.",
    "183864": "CAP-TECH INTERNATIONAL CO.",
    "C0335E": "Microsoft",
    "B0E03C": "TCT mobile ltd",
    "BC1485": "Samsung Electronics Co.",
    "9C6C15": "Microsoft Corporation",
    "A48CDB": "Lenovo",
    "D85DE2": "Hon Hai Precision Ind. Co.",
    "3C912B": "Vexata Inc",
    "346C0F": "Pramod Telecom Pvt. Ltd",
    "C8A823": "Samsung Electronics Co.",
    "B0C559": "Samsung Electronics Co.",
    "6CF5E8": "Mooredoll Inc.",
    "E8447E": "Bitdefender SRL",
    "B0495F": "OMRON HEALTHCARE Co.",
    "445ECD": "Razer Inc",
    "A0C2DE": "Costar Video Systems",
    "88E161": "Art Beijing Science and Technology Development Co.",
    "00A509": "WigWag Inc.",
    "7491BD": "Four systems Co.",
    "D0929E": "Microsoft Corporation",
    "84CFBF": "Fairphone",
    "ACD1B8": "Hon Hai Precision Ind. Co.",
    "60F189": "Murata Manufacturing Co.",
    "742EFC": "DirectPacket Research",
    "3CAE69": "ESA Elektroschaltanlagen Grimma GmbH",
    "D43266": "Fike Corporation",
    "900CB4": "Alinket Electronic Technology Co.",
    "4CA928": "Insensi",
    "DC0914": "Talk-A-Phone Co.",
    "48C093": "Xirrus",
    "00A2F5": "Guangzhou Yuanyun Network Technology Co.",
    "1008B1": "Hon Hai Precision Ind. Co.",
    "E48C0F": "Discovery Insure",
    "BC52B4": "Nokia",
    "9405B6": "Liling FullRiver Electronics & Technology Ltd",
    "10FACE": "Reacheng Communication Technology Co.",
    "C81B6B": "Innova Security",
    "B4A828": "Shenzhen Concox Information Technology Co.",
    "3438AF": "Inlab Networks GmbH",
    "00F3DB": "WOO Sports",
    "78312B": "zte corporation",
    "44CE7D": "SFR",
    "344DEA": "zte corporation",
    "94BF95": "Shenzhen Coship Electronics Co.",
    "E42354": "SHENZHEN FUZHI SOFTWARE TECHNOLOGY CO.",
    "9470D2": "WINFIRM TECHNOLOGY",
    "A44AD3": "ST Electronics(Shanghai) Co.",
    "EC0EC4": "Hon Hai Precision Ind. Co.",
    "8C18D9": "Shenzhen RF Technology Co.",
    "CC3080": "VAIO Corporation",
    "187117": "eta plus electronic gmbh",
    "7CB177": "Satelco AG",
    "30FAB7": "Tunai Creative",
    "0809B6": "Masimo Corp",
    "4CF5A0": "Scalable Network Technologies Inc",
    "4C16F1": "zte corporation",
    "D8FB11": "AXACORE",
    "C4BD6A": "SKF GmbH",
    "C401CE": "PRESITION (2000) CO.",
    "587BE9": "AirPro Technology India Pvt. Ltd",
    "600292": "PEGATRON CORPORATION",
    "B4B859": "Texa Spa",
    "5CF9F0": "Atomos Engineering P/L",
    "E4C62B": "Airware",
    "EC1D7F": "zte corporation",
    "4CE933": "RailComm",
    "AC3870": "Lenovo Mobile Communication Technology Ltd.",
    "4CBC42": "Shenzhen Hangsheng Electronics Co.",
    "987E46": "Emizon Networks Limited",
    "3C46D8": "TP-LINK TECHNOLOGIES CO.",
    "147590": "TP-LINK TECHNOLOGIES CO.",
    "50BD5F": "TP-LINK TECHNOLOGIES CO.",
    "70F196": "Actiontec Electronics",
    "188219": "Alibaba Cloud Computing Ltd.",
    "28A5EE": "Shenzhen SDGI CATV Co.",
    "F4FD2B": "ZOYI Company",
    "BC4E5D": "ZhongMiao Technology Co.",
    "7C6AC3": "GatesAir",
    "F4D032": "Yunnan Ideal Information&Technology.",
    "0C8C8F": "Kamo Technology Limited",
    "A4A4D3": "Bluebank Communication Technology Co.Ltd",
    "702DD1": "Newings Communication CO.",
    "F4F646": "Dediprog Technology Co. Ltd.",
    "D0A0D6": "ChengDu TD Tech",
    "ECB907": "CloudGenix Inc",
    "F42833": "MMPC Inc.",
    "A8329A": "Digicom Futuristic Technologies Ltd.",
    "083D88": "Samsung Electronics Co.",
    "30595B": "streamnow AG",
    "4C83DE": "Cisco SPVTG",
    "A81374": "Panasonic Corporation AVC Networks Company",
    "3C189F": "Nokia Corporation",
    "28E6E9": "SIS Sat Internet Services GmbH",
    "045C8E": "gosund GROUP CO.",
    "7CC4EF": "Devialet",
    "D85DFB": "Private",
    "300D2A": "Zhejiang Wellcom Technology Co.",
    "908C63": "GZ Weedong Networks Technology Co.",
    "84850A": "Hella Sonnen- und Wetterschutztechnik GmbH",
    "08CD9B": "samtec automotive electronics & software GmbH",
    "5C5BC2": "YIK Corporation",
    "109266": "Samsung Electronics Co.",
    "DCF110": "Nokia Corporation",
    "608F5C": "Samsung Electronics Co.",
    "E8EF89": "OPMEX Tech.",
    "EC2E4E": "HITACHI-LG DATA STORAGE INC",
    "3481C4": "AVM GmbH",
    "CCB691": "NECMagnusCommunications",
    "40167E": "ASUSTek COMPUTER INC.",
    "142BD6": "Guangdong Appscomm Co.",
    "F84A73": "EUMTECH CO.",
    "983713": "PT.Navicom Indonesia",
    "A47E39": "zte corporation",
    "FCC2DE": "Murata Manufacturing Co.",
    "D0C7C0": "TP-LINK TECHNOLOGIES CO.",
    "D46761": "XonTel Technology Co.",
    "98349D": "Krauss Maffei Technologies GmbH",
    "880FB6": "Jabil Circuits India Pvt Ltd",
    "B46698": "Zealabs srl",
    "687CC8": "Measurement Systems S. de R.L.",
    "74F85D": "Berkeley Nucleonics Corp",
    "B061C7": "Ericsson-LG Enterprise",
    "400107": "Arista Corp",
    "0092FA": "SHENZHEN WISKY TECHNOLOGY CO.",
    "4C7F62": "Nokia Corporation",
    "D881CE": "AHN INC.",
    "E0D31A": "EQUES Technology Co.",
    "580528": "LABRIS NETWORKS",
    "407875": "IMBEL - Industria de Material Belico do Brasil",
    "30C750": "MIC Technology Group",
    "4411C2": "Telegartner Karl Gartner GmbH",
    "8059FD": "Noviga",
    "987770": "Pep Digital Technology (Guangzhou) Co.",
    "28C825": "DellKing Industrial Co.",
    "447E76": "Trek Technology (S) Pte Ltd",
    "B0EC8F": "GMX SAS",
    "28DEF6": "bioMerieux Inc.",
    "100F18": "Fu Gang Electronic(KunShan)CO.",
    "18CC23": "Philio Technology Corporation",
    "68D247": "Portalis LC",
    "50B695": "Micropoint Biotechnologies",
    "B4430D": "Broadlink Pty Ltd",
    "50A054": "Actineon",
    "A06518": "VNPT TECHNOLOGY",
    "7C8D91": "Shanghai Hongzhuo Information Technology co.",
    "748F1B": "MasterImage 3D",
    "083F76": "Intellian Technologies",
    "386C9B": "Ivy Biomedical",
    "B42C92": "Zhejiang Weirong Electronic Co.",
    "6C641A": "Penguin Computing",
    "5CE7BF": "New Singularity International Technical Development Co.",
    "CC89FD": "Nokia Corporation",
    "34466F": "HiTEM Engineering",
    "D82A15": "Leitner SpA",
    "80618F": "Shenzhen sangfei consumer communications co.",
    "B48547": "Amptown System Company GmbH",
    "D87CDD": "SANIX INCORPORATED",
    "707C18": "ADATA Technology Co.",
    "78EC74": "Kyland-USA",
    "E8E770": "Warp9 Tech Design",
    "609620": "Private",
    "C0F991": "GME Standard Communications P/L",
    "C064C6": "Nokia Corporation",
    "14F28E": "ShenYang ZhongKe-Allwin Technology Co.LTD",
    "BC14EF": "ITON Technology Limited",
    "443C9C": "Pintsch GmbH",
    "10DDF4": "Maxway Electronics CO.",
    "080371": "KRG CORPORATE",
    "200E95": "IEC – TC9 WG43",
    "0C1262": "zte corporation",
    "3CD4D6": "WirelessWERX",
    "C8F68D": "S.E.TECHNOLOGIES LIMITED",
    "387B47": "AKELA",
    "E40439": "TomTom Software Ltd",
    "24A495": "Thales Canada Inc.",
    "D0C42F": "Tamagawa Seiki Co.",
    "549359": "SHENZHEN TWOWING TECHNOLOGIES CO.",
    "90356E": "Vodafone Omnitel N.V.",
    "E097F2": "Atomax Inc.",
    "70305E": "Nanjing Zhongke Menglian Information Technology Co.",
    "C098E5": "University of Michigan",
    "50E14A": "Private",
    "708D09": "Nokia Corporation",
    "701D7F": "Comtech Technology Co.",
    "9C039E": "Beijing Winchannel Software Technology Co.",
    "680AD7": "Yancheng Kecheng Optoelectronic Technology Co.",
    "5C1193": "Seal One AG",
    "847616": "Addat s.r.o.",
    "DC0575": "SIEMENS ENERGY AUTOMATION",
    "844F03": "Ablelink Electronics Ltd",
    "783D5B": "TELNET Redes Inteligentes S.A.",
    "D0B523": "Bestcare Cloucal Corp.",
    "98FB12": "Grand Electronics (HK) Ltd",
    "3C1040": "daesung network",
    "28FC51": "The Electric Controller and Manufacturing Co.",
    "BC8893": "VILLBAU Ltd.",
    "407496": "aFUN TECHNOLOGY INC.",
    "705986": "OOO TTV",
    "986CF5": "zte corporation",
    "906717": "Alphion India Private Limited",
    "6064A1": "RADiflow Ltd.",
    "58B961": "SOLEM Electronique",
    "78491D": "The Will-Burt Company",
    "20D21F": "Wincal Technology Corp.",
    "F89550": "Proton Products Chengdu Ltd",
    "447BC4": "DualShine Technology(SZ)Co.",
    "2C5FF3": "Pertronic Industries",
    "58639A": "TPL SYSTEMES",
    "187ED5": "shenzhen kaism technology Co. Ltd",
    "9CF8DB": "shenzhen eyunmei technology co",
    "0C473D": "Hitron Technologies. Inc",
    "8CCDA2": "ACTP",
    "84262B": "Nokia",
    "F46ABC": "Adonit Corp. Ltd.",
    "7C49B9": "Plexus Manufacturing Sdn Bhd",
    "840F45": "Shanghai GMT Digital Technologies Co.",
    "E0AF4B": "Pluribus Networks",
    "54A54B": "NSC Communications Siberia Ltd",
    "BC2B6B": "Beijing Haier IC Design Co.",
    "7CB77B": "Paradigm Electronics Inc",
    "B0CE18": "Zhejiang shenghui lighting co.",
    "98D331": "Shenzhen Bolutek Technology Co.",
    "38EC11": "Novatek Microelectronics Corp.",
    "4CCBF5": "zte corporation",
    "44700B": "IFFU",
    "1C4158": "Gemalto M2M GmbH",
    "9C2840": "Discovery Technology",
    "1C7B21": "Sony Corporation",
    "EC2257": "JiangSu NanJing University Electronic Information Technology Co.",
    "F037A1": "Huike Electronics (SHENZHEN) CO.",
    "F08EDB": "VeloCloud Networks",
    "F47A4E": "Woojeon&Handan",
    "04848A": "7INOVA TECHNOLOGY LIMITED",
    "6CF97C": "Nanoptix Inc.",
    "F8FF5F": "Shenzhen Communication Technology Co.",
    "704CED": "TMRG",
    "841B38": "Shenzhen Excelsecu Data Technology Co.",
    "A897DC": "IBM",
    "109AB9": "Tosibox Oy",
    "142D8B": "Incipio Technologies",
    "68EE96": "Cisco SPVTG",
    "08EF3B": "MCS Logic Inc.",
    "E8EADA": "Denkovi Assembly Electronics LTD",
    "F85BC9": "M-Cube Spa",
    "907A0A": "Gebr. Bode GmbH & Co KG",
    "A0C6EC": "ShenZhen ANYK Technology Co.",
    "102279": "ZeroDesktop",
    "7C1AFC": "Dalian Co-Edifice Video Technology Co.",
    "28C671": "Yota Devices OY",
    "D86960": "Steinsvik",
    "78E8B6": "zte corporation",
    "DCAE04": "CELOXICA Ltd",
    "8005DF": "Montage Technology Group Limited",
    "84E629": "Bluwan SA",
    "C47F51": "Inventek Systems",
    "681D64": "Sunwave Communications Co.",
    "4C21D0": "Sony Corporation",
    "CCD29B": "Shenzhen Bopengfa Elec&Technology CO.",
    "78DAB3": "GBO Technology",
    "700FEC": "Poindus Systems Corp.",
    "E8481F": "Advanced Automotive Antennas",
    "D40BB9": "Solid Semecs bv.",
    "F415FD": "Shanghai Pateo Electronic Equipment Manufacturing Co.",
    "748E08": "Bestek Corp.",
    "D8DA52": "APATOR S.A.",
    "587A4D": "Stonesoft Corporation",
    "F02405": "OPUS High Technology Corporation",
    "D41090": "iNFORM Systems AG",
    "3495DB": "Logitec Corporation",
    "9CB793": "Creatcomm Technology Inc.",
    "5C335C": "Swissphone Telecom AG",
    "78D38D": "HONGKONG YUNLINK TECHNOLOGY LIMITED",
    "1078CE": "Hanvit SI",
    "78F5E5": "BEGA Gantenbrink-Leuchten KG",
    "C47DFE": "A.N. Solutions GmbH",
    "70E027": "HONGYU COMMUNICATION TECHNOLOGY LIMITED",
    "A09BBD": "Total Aviation Solutions Pty Ltd",
    "04DF69": "Car Connectivity Consortium",
    "78D5B5": "NAVIELEKTRO KY",
    "ECD040": "GEA Farm Technologies GmbH",
    "F80DEA": "ZyCast Technology Inc.",
    "B08807": "Strata Worldwide",
    "5CF370": "CC&C Technologies",
    "CCBD35": "Steinel GmbH",
    "6CECA1": "SHENZHEN CLOU ELECTRONICS CO. LTD.",
    "105C3B": "Perma-Pipe",
    "349D90": "Heinzmann GmbH & CO. KG",
    "B03850": "Nanjing CAS-ZDC IOT SYSTEM CO.",
    "A4E0E6": "FILIZOLA S.A. PESAGEM E AUTOMACAO",
    "DC647C": "C.R.S. iiMotion GmbH",
    "148692": "TP-LINK TECHNOLOGIES CO.",
    "A8154D": "TP-LINK TECHNOLOGIES CO.",
    "D862DB": "Eno Inc.",
    "8C3C07": "Skiva Technologies",
    "C0C3B6": "Automatic Systems",
    "A0EB76": "AirCUVE Inc.",
    "FC4499": "Swarco LEA d.o.o.",
    "E4F7A1": "Datafox GmbH",
    "381766": "PROMZAKAZ LTD.",
    "1441E2": "Monaco Enterprises",
    "E47D5A": "Beijing Hanbang Technology Corp.",
    "38A86B": "Orga BV",
    "F07765": "Sourcefire",
    "249504": "SFR",
    "F45842": "Boxx TV Ltd",
    "106682": "NEC Platforms",
    "F084C9": "zte corporation",
    "D4016D": "TP-LINK TECHNOLOGIES CO.",
    "985C93": "SBG Systems SAS",
    "A08A87": "HuiZhou KaiYue Electronic Co.",
    "18E8DD": "MODULETEK",
    "D073D5": "LIFI LABS MANAGEMENT PTY LTD",
    "149448": "BLU CASTLE S.A.",
    "48F925": "Maestronic",
    "68831A": "Pandora Mobility Corporation",
    "D429EA": "Zimory GmbH",
    "34ADE4": "Shanghai Chint Power Systems Co.",
    "D81EDE": "B&W Group Ltd",
    "24EA40": "Helmholz GmbH & Co. KG",
    "FCDB96": "ENERVALLEY CO.",
    "1423D7": "EUTRONIX CO.",
    "386793": "Asia Optical Co.",
    "0C8268": "TP-LINK TECHNOLOGIES CO.",
    "90DA4E": "AVANU",
    "281878": "Microsoft Corporation",
    "7038B4": "Low Tech Solutions",
    "28CD9C": "Shenzhen Dynamax Software Development Co.",
    "504F94": "Loxone Electronics GmbH",
    "60B185": "ATH system",
    "745F00": "Samsung Semiconductor Inc.",
    "E0C3F3": "zte corporation",
    "5C20D0": "Asoni Communication Co.",
    "BC629F": "Telenet Systems P. Ltd.",
    "380FE4": "Dedicated Network Partners Oy",
    "847A88": "HTC Corporation",
    "A4D856": "Gimbal",
    "785517": "SankyuElectronics",
    "B47F5E": "Foresight Manufacture (S) Pte Ltd",
    "44184F": "Fitview",
    "ACA430": "Peerless AV",
    "541FD5": "Advantage Electronics",
    "ACE97F": "IoT Tech Limited",
    "A0FE91": "AVAT Automation GmbH",
    "74ECF1": "Acumen",
    "78324F": "Millennium Group",
    "48F230": "Ubizcore Co.",
    "384369": "Patrol Products Consortium LLC",
    "B85AF7": "Ouya",
    "84ACA4": "Beijing Novel Super Digital TV Technology Co.",
    "5809E5": "Kivic Inc.",
    "DC6F08": "Bay Storage Technology",
    "58D6D3": "Dairy Cheq Inc",
    "046E49": "TaiYear Electronic Technology (Suzhou) Co.",
    "E85AA7": "LLC Emzior",
    "9C9C1D": "Starkey Labs Inc.",
    "9CE1D6": "Junger Audio-Studiotechnik GmbH",
    "34F62D": "SHARP Corporation",
    "4C8FA5": "Jastec",
    "84ED33": "BBMC Co.",
    "E82E24": "Out of the Fog Research LLC",
    "2C3BFD": "Netstor Technology Co.",
    "1C52D6": "FLAT DISPLAY TECHNOLOGY CORPORATION",
    "D0DFB2": "Genie Networks Limited",
    "386645": "OOSIC Technology CO.",
    "D0D6CC": "Wintop",
    "58D071": "BW Broadcast",
    "80FA5B": "CLEVO CO.",
    "C0B339": "Comigo Ltd.",
    "20858C": "Assa",
    "8007A2": "Esson Technology Inc.",
    "C0A0E2": "Eden Innovations",
    "6C5A34": "Shenzhen Haitianxiong Electronic Co.",
    "DCB058": "Bürkert Werke GmbH",
    "60CDC5": "Taiwan Carol Electronics.",
    "D8182B": "Conti Temic Microelectronic GmbH",
    "80CF41": "Lenovo Mobile Communication Technology Ltd.",
    "9038DF": "Changzhou Tiannengbo System Co. Ltd.",
    "185253": "Pixord Corporation",
    "683B1E": "Countwise LTD",
    "10FBF0": "KangSheng LTD.",
    "B49DB4": "Axion Technologies Inc.",
    "ACE87E": "Bytemark Computer Consulting Ltd",
    "ACA22C": "Baycity Technologies Ltd",
    "6C9AC9": "Valentine Research",
    "080FFA": "KSP INC.",
    "AC3CB4": "Nilan A/S",
    "B85AFE": "Handaer Communication Technology (Beijing) Co.",
    "60748D": "Atmaca Elektronik",
    "B8B7D7": "2GIG Technologies",
    "78D129": "Vicos",
    "84DF0C": "NET2GRID BV",
    "78AB60": "ABB Australia",
    "8482F4": "Beijing Huasun Unicreate Technology Co.",
    "5CD41B": "UCZOON Technology Co.",
    "CCE798": "My Social Stuff",
    "A036F0": "Comprehensive Power",
    "180CAC": "CANON INC.",
    "AC7236": "Lexking Technology Co.",
    "3CD7DA": "SK Mtek microelectronics(shenzhen)limited",
    "04F8C2": "Flaircomm Microelectronics",
    "808287": "ATCOM Technology Co.Ltd.",
    "28A186": "enblink",
    "6869F2": "ComAp s.r.o.",
    "5887E2": "Shenzhen Coship Electronics Co.",
    "F46DE2": "zte corporation",
    "388EE7": "Fanhattan LLC",
    "2091D9": "I'M SPA",
    "141BF0": "Intellimedia Systems Ltd",
    "303294": "W-IE-NE-R Plein & Baus GmbH",
    "7C822D": "Nortec",
    "AC8D14": "Smartrove Inc",
    "503955": "Cisco SPVTG",
    "34996F": "VPI Engineering",
    "7CD9FE": "New Cosmos Electric Co.",
    "CCC104": "Applied Technical Systems",
    "A4B1E9": "Technicolor Delivery Technologies Belgium NV",
    "4C72B9": "PEGATRON CORPORATION",
    "907025": "Garea Microsys Co.",
    "10D1DC": "INSTAR Deutschland GmbH",
    "2CEDEB": "Alpheus Digital Company Limited",
    "00DB1E": "Albedo Telecom SL",
    "34AF2C": "Nintendo Co.",
    "0CDCCC": "Inala Technologies",
    "98291D": "Jaguar de Mexico",
    "0CD996": "Cisco Systems",
    "30F33A": "+plugg srl",
    "F8A03D": "Dinstar Technologies Co.",
    "2CD444": "FUJITSU LIMITED",
    "0C57EB": "Mueller Systems",
    "745327": "COMMSEN CO.",
    "D08CFF": "UPWIS AB",
    "68D1FD": "Shenzhen Trimax Technology Co.",
    "BC28D6": "Rowley Associates Limited",
    "10BD18": "Cisco Systems",
    "5869F9": "Fusion Transactive Ltd.",
    "D41E35": "TOHO Electronics INC.",
    "98A7B0": "MCST ZAO",
    "8CC7AA": "Radinet Communications Inc.",
    "40336C": "Godrej & Boyce Mfg. co. ltd",
    "E856D6": "NCTech Ltd",
    "C08170": "Effigis GeoSolutions",
    "60455E": "Liptel s.r.o.",
    "D806D1": "Honeywell Fire System (Shanghai) Co",
    "647657": "Innovative Security Designs",
    "944A09": "BitWise Controls",
    "9C066E": "Hytera Communications Corporation Limited",
    "443839": "Cumulus Networks",
    "D867D9": "Cisco Systems",
    "642216": "Shandong Taixin Electronic co.",
    "A4E731": "Nokia Corporation",
    "3CEAFB": "NSE AG",
    "BC811F": "Ingate Systems",
    "4C068A": "Basler Electric Company",
    "A44C11": "Cisco Systems",
    "60843B": "Soladigm",
    "209BA5": "JIAXING GLEAD Electronics Co.",
    "A0F450": "HTC Corporation",
    "6089B1": "Key Digital Systems",
    "44D15E": "Shanghai Kingto Information Technology Ltd",
    "68D925": "ProSys Development Services",
    "848D84": "Rajant Corporation",
    "D8337F": "Office FA.com Co.",
    "0036F8": "Conti Temic microelectronic GmbH",
    "AC9403": "Envision Peripherals Inc",
    "048B42": "Skspruce Technologies",
    "5076A6": "Ecil Informatica Ind. Com. Ltda",
    "A4F7D0": "LAN Accessories Co.",
    "0036FE": "SuperVision",
    "54466B": "Shenzhen CZTIC Electronic Technology Co.",
    "44B382": "Kuang-chi Institute of Advanced Technology",
    "709E86": "X6D Limited",
    "A0F419": "Nokia Corporation",
    "1C973D": "PRICOM Design",
    "BC0200": "Stewart Audio",
    "D4EC0C": "Harley-Davidson Motor Company",
    "6CA96F": "TransPacket AS",
    "AC0142": "Uriel Technologies SIA",
    "60B933": "Deutron Electronics Corp.",
    "489153": "Weinmann Geräte für Medizin GmbH + Co. KG",
    "F44848": "Amscreen Group Ltd",
    "50D274": "Steffes Corporation",
    "F85063": "Verathon",
    "F0D14F": "LINEAR LLC",
    "0043FF": "KETRON S.R.L.",
    "7CACB2": "Bosch Software Innovations GmbH",
    "5C6F4F": "S.A. SISTEL",
    "901B0E": "Fujitsu Technology Solutions GmbH",
    "2C36F8": "Cisco Systems",
    "5808FA": "Fiber Optic & telecommunication INC.",
    "845787": "DVR C&C Co.",
    "C85645": "Intermas France",
    "44348F": "MXT INDUSTRIAL LTDA",
    "C47BA3": "NAVIS Inc.",
    "C8F704": "Building Block Video",
    "508A42": "Uptmate Technology Co.",
    "BCEA2B": "CityCom GmbH",
    "18D66A": "Inmarsat",
    "28E608": "Tokheim",
    "74FF7D": "Wren Sound Systems",
    "ACF0B2": "Becker Electronics Taiwan Ltd.",
    "542A9C": "LSY Defense",
    "504A5E": "Masimo Corporation",
    "1C7C45": "Vitek Industrial Video Products",
    "3C3888": "ConnectQuest",
    "48D7FF": "BLANKOM Antennentechnik GmbH",
    "C47130": "Fon Technology S.L.",
    "AC3D05": "Instorescreen Aisa",
    "00D632": "GE Energy",
    "C43C3C": "CYBELEC SA",
    "B826D4": "Furukawa Industrial S.A. Produtos Elétricos",
    "B87447": "Convergence Technologies",
    "D01AA7": "UniPrint",
    "E05DA6": "Detlef Fink Elektronik & Softwareentwicklung",
    "846AED": "Wireless Tsukamoto.",
    "7463DF": "VTS GmbH",
    "BC125E": "Beijing  WisVideo  INC.",
    "14E4EC": "mLogic LLC",
    "3828EA": "Fujian Netcom Technology Co.",
    "045A95": "Nokia Corporation",
    "04F4BC": "Xena Networks",
    "6C3A84": "Shenzhen Aero-Startech. Co.Ltd",
    "0C9E91": "Sankosha Corporation",
    "C8F9F9": "Cisco Systems",
    "80DB31": "Power Quotient International Co.",
    "1C51B5": "Techaya LTD",
    "A45630": "Cisco Systems",
    "286094": "CAPELEC",
    "383F10": "DBL Technology Ltd.",
    "ACD364": "ABB SPA",
    "A4EF52": "Telewave Co.",
    "A826D9": "HTC Corporation",
    "28940F": "Cisco Systems",
    "B8DAF7": "Advanced Photonics",
    "143AEA": "Dynapower Company LLC",
    "B4D8A9": "BetterBots",
    "7CC8D7": "Damalisk",
    "942E17": "Schneider Electric Canada Inc",
    "9CB008": "Ubiquitous Computing Technology Corporation",
    "A8776F": "Zonoff",
    "00FA3B": "CLOOS ELECTRONIC GMBH",
    "CC944A": "Pfeiffer Vacuum GmbH",
    "0C8525": "Cisco Systems",
    "C46044": "Everex Electronics Limited",
    "98FE03": "Ericsson - North America",
    "20AA4B": "Cisco-Linksys",
    "2CEE26": "Petroleum Geo-Services",
    "A086EC": "SAEHAN HITEC Co.",
    "E03C5B": "SHENZHEN JIAXINJIE ELECTRON CO.",
    "2838CF": "Gen2wave",
    "60B606": "Phorus",
    "9092B4": "Diehl BGT Defence GmbH & Co. KG",
    "FC455F": "JIANGXI SHANSHUI OPTOELECTRONIC TECHNOLOGY CO.",
    "F04A2B": "PYRAMID Computer GmbH",
    "A85BF3": "Audivo GmbH",
    "B8975A": "BIOSTAR Microtech Int'l Corp.",
    "4833DD": "ZENNIO AVANCE Y TECNOLOGIA",
    "10FC54": "Shany Electronic Co.",
    "C02973": "Audyssey Laboratories Inc.",
    "24BC82": "Dali Wireless",
    "087572": "Obelux Oy",
    "10C2BA": "UTT Co.",
    "90D74F": "Bookeen",
    "64C5AA": "South African Broadcasting Corporation",
    "CC6DEF": "TJK Tietolaite Oy",
    "9C53CD": "ENGICAM s.r.l.",
    "608645": "Avery Weigh-Tronix",
    "FC8FC4": "Intelligent Technology Inc.",
    "541DFB": "Freestyle Energy Ltd",
    "24C0B3": "RSF",
    "603553": "Buwon Technology",
    "98AAD7": "BLUE WAVE NETWORKING CO LTD",
    "7C336E": "MEG Electronics Inc.",
    "B40C25": "Palo Alto Networks",
    "E039D7": "Plexxi",
    "500B32": "Foxda Technology Industrial(ShenZhen)Co.",
    "302DE8": "JDA",
    "48A6D2": "GJsun Optical Science and Tech Co.",
    "68CD0F": "U Tek Company Limited",
    "A4E391": "DENY FONTAINE",
    "603FC5": "COX CO.",
    "AC6FD9": "Valueplus Inc.",
    "DC1EA3": "Accensus LLC",
    "A40130": "ABIsystems Co.",
    "90A783": "JSW PACIFIC CORPORATION",
    "28AF0A": "Sirius XM Radio Inc",
    "5CD4AB": "Zektor",
    "64E84F": "Serialway Communication Technology Co. Ltd",
    "2C9EFC": "CANON INC.",
    "08FC52": "OpenXS BV",
    "F8462D": "SYNTEC Incorporation",
    "78A5DD": "Shenzhen Smarteye Digital Electronics Co.",
    "ECE744": "Omntec mfg. inc",
    "08A12B": "ShenZhen EZL Technology Co.",
    "A00CA1": "SKTB SKiT",
    "4C32D9": "M Rutty Holdings Pty. Ltd.",
    "D4E33F": "Nokia",
    "28D1AF": "Nokia Corporation",
    "F8F7D3": "International Communications Corporation",
    "182B05": "8D Technologies",
    "240BB1": "KOSTAL Industrie Elektrik GmbH",
    "20EEC6": "Elefirst Science & Tech Co .",
    "E01E07": "Anite Telecoms  US. Inc",
    "147DC5": "Murata Manufacturing Co.",
    "00B9F6": "Shenzhen Super Rich Electronics Co.",
    "FCC23D": "Atmel Corporation",
    "88E7A6": "iKnowledge Integration Corp.",
    "0462D7": "ALSTOM HYDRO FRANCE",
    "D4507A": "CEIVA Logic",
    "CCE7DF": "American Magnetics",
    "A446FA": "AmTRAN Video Corporation",
    "644346": "GuangDong Quick Network Computer CO.",
    "7C6B33": "Tenyu Tech Co. Ltd.",
    "64D989": "Cisco Systems",
    "645DD7": "Shenzhen Lifesense Medical Electronics Co.",
    "D4024A": "Delphian Systems LLC",
    "0041B4": "Wuxi Zhongxing Optoelectronics Technology Co.",
    "F44450": "BND Co.",
    "EC4670": "Meinberg Funkuhren GmbH & Co. KG",
    "2804E0": "FERMAX ELECTRONICA S.A.U.",
    "D05A0F": "I-BT DIGITAL CO.",
    "EC9681": "2276427 Ontario Inc",
    "5C076F": "Thought Creator",
    "3C0FC1": "KBC Networks",
    "10F9EE": "Nokia Corporation",
    "742B0F": "Infinidat Ltd.",
    "C8F981": "Seneca s.r.l.",
    "58E636": "EVRsafe Technologies",
    "24497B": "Innovative Converged Devices Inc",
    "98E79A": "Foxconn(NanJing) Communication Co.",
    "14307A": "Avermetrics",
    "A06CEC": "RIM",
    "A0E9DB": "Ningbo FreeWings Technologies Co.",
    "788973": "CMC",
    "203706": "Cisco Systems",
    "90B97D": "Johnson Outdoors Marine Electronics d/b/a Minnkota",
    "F4B164": "Lightning Telecommunications Technology Co. Ltd",
    "70B035": "Shenzhen Zowee Technology Co.",
    "8821E3": "Nebusens",
    "7CF429": "NUUO Inc.",
    "1045BE": "Norphonic AS",
    "8C82A8": "Insigma Technology Co.",
    "CCB55A": "Fraunhofer ITWM",
    "AC8ACD": "ROGER D.Wensker",
    "AC4723": "Genelec",
    "E8BA70": "Cisco Systems",
    "D4A425": "SMAX Technology Co.",
    "8C11CB": "ABUS Security-Center GmbH & Co. KG",
    "F80332": "Khomp",
    "984246": "SOL INDUSTRY PTE.",
    "3429EA": "MCD ELECTRONICS SP. Z O.O.",
    "28A574": "Miller Electric Mfg. Co.",
    "60190C": "RRAMAC",
    "D05FCE": "Hitachi Data Systems",
    "D09B05": "Emtronix",
    "FC8329": "Trei technics",
    "90B8D0": "Joyent",
    "281471": "Lantis co.",
    "88B168": "Delta Control GmbH",
    "AC8674": "Open Mesh",
    "64D241": "Keith & Koep GmbH",
    "18B79E": "Invoxia",
    "CCF841": "Lumewave",
    "14EB33": "B