/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_select_report.h
 * @brief implementation of the select_report function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_SELECT_REPORT_H
#define PG_SELECT_REPORT_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"


/**
 * Lookup details about a particular report.
 *
 * @param cls closure
 * @param instance_id instance to lookup reports for
 * @param report_id serial number of the report to lookup
 * @param[out] report_program_section configuration section of program
 *   for report generation
 * @param[out] report_description text describing the report
 * @param[out] mime_type mime type to request from the @a data_source
 * @param[out] data_source relative URL (to instance base URL)
 *   to request report data from
 * @param[out] target_address where to send report data
 * @param[out] frequency report frequency
 * @param[out] frequency_shift how much to shift the report time from a
 *   multiple of the report @a frequency
 * @param[out] next_transmission when will the report be generated next
 * @param[out] last_error_code status of the last report
 * @param[out] last_error_detail details about failures of last generation
 * @return database result code
 */
enum GNUNET_DB_QueryStatus
TMH_PG_select_report (void *cls,
                      const char *instance_id,
                      uint64_t report_id,
                      char **report_program_section,
                      char **report_description,
                      char **mime_type,
                      char **data_source,
                      char **target_address,
                      struct GNUNET_TIME_Relative *frequency,
                      struct GNUNET_TIME_Relative *frequency_shift,
                      struct GNUNET_TIME_Absolute *next_transmission,
                      enum TALER_ErrorCode *last_error_code,
                      char **last_error_detail);

#endif
