/* sendme_cell.c -- generated by Trunnel v1.5.3.
 * https://gitweb.torproject.org/trunnel.git
 * You probably shouldn't edit this file.
 */
#include <stdlib.h>
#include "trunnel-impl.h"

#include "sendme_cell.h"

#define TRUNNEL_SET_ERROR_CODE(obj) \
  do {                              \
    (obj)->trunnel_error_code_ = 1; \
  } while (0)

#if defined(__COVERITY__) || defined(__clang_analyzer__)
/* If we're running a static analysis tool, we don't want it to complain
 * that some of our remaining-bytes checks are dead-code. */
int sendmecell_deadcode_dummy__ = 0;
#define OR_DEADCODE_DUMMY || sendmecell_deadcode_dummy__
#else
#define OR_DEADCODE_DUMMY
#endif

#define CHECK_REMAINING(nbytes, label)                           \
  do {                                                           \
    if (remaining < (nbytes) OR_DEADCODE_DUMMY) {                \
      goto label;                                                \
    }                                                            \
  } while (0)

sendme_cell_t *
sendme_cell_new(void)
{
  sendme_cell_t *val = trunnel_calloc(1, sizeof(sendme_cell_t));
  if (NULL == val)
    return NULL;
  val->data_len = 16;
  return val;
}

/** Release all storage held inside 'obj', but do not free 'obj'.
 */
static void
sendme_cell_clear(sendme_cell_t *obj)
{
  (void) obj;
  TRUNNEL_DYNARRAY_WIPE(&obj->data_v1_digest);
  TRUNNEL_DYNARRAY_CLEAR(&obj->data_v1_digest);
}

void
sendme_cell_free(sendme_cell_t *obj)
{
  if (obj == NULL)
    return;
  sendme_cell_clear(obj);
  trunnel_memwipe(obj, sizeof(sendme_cell_t));
  trunnel_free_(obj);
}

uint8_t
sendme_cell_get_version(const sendme_cell_t *inp)
{
  return inp->version;
}
int
sendme_cell_set_version(sendme_cell_t *inp, uint8_t val)
{
  if (! ((val == 0 || val == 1))) {
     TRUNNEL_SET_ERROR_CODE(inp);
     return -1;
  }
  inp->version = val;
  return 0;
}
uint16_t
sendme_cell_get_data_len(const sendme_cell_t *inp)
{
  return inp->data_len;
}
int
sendme_cell_set_data_len(sendme_cell_t *inp, uint16_t val)
{
  if (! ((val == 16 || val == 20))) {
     TRUNNEL_SET_ERROR_CODE(inp);
     return -1;
  }
  inp->data_len = val;
  return 0;
}
size_t
sendme_cell_getlen_data_v1_digest(const sendme_cell_t *inp)
{
  return TRUNNEL_DYNARRAY_LEN(&inp->data_v1_digest);
}

uint8_t
sendme_cell_get_data_v1_digest(sendme_cell_t *inp, size_t idx)
{
  return TRUNNEL_DYNARRAY_GET(&inp->data_v1_digest, idx);
}

uint8_t
sendme_cell_getconst_data_v1_digest(const sendme_cell_t *inp, size_t idx)
{
  return sendme_cell_get_data_v1_digest((sendme_cell_t*)inp, idx);
}
int
sendme_cell_set_data_v1_digest(sendme_cell_t *inp, size_t idx, uint8_t elt)
{
  TRUNNEL_DYNARRAY_SET(&inp->data_v1_digest, idx, elt);
  return 0;
}
int
sendme_cell_add_data_v1_digest(sendme_cell_t *inp, uint8_t elt)
{
  TRUNNEL_DYNARRAY_ADD(uint8_t, &inp->data_v1_digest, elt, {});
  return 0;
 trunnel_alloc_failed:
  TRUNNEL_SET_ERROR_CODE(inp);
  return -1;
}

uint8_t *
sendme_cell_getarray_data_v1_digest(sendme_cell_t *inp)
{
  return inp->data_v1_digest.elts_;
}
const uint8_t  *
sendme_cell_getconstarray_data_v1_digest(const sendme_cell_t *inp)
{
  return (const uint8_t  *)sendme_cell_getarray_data_v1_digest((sendme_cell_t*)inp);
}
int
sendme_cell_setlen_data_v1_digest(sendme_cell_t *inp, size_t newlen)
{
  uint8_t *newptr;
  newptr = trunnel_dynarray_setlen(&inp->data_v1_digest.allocated_,
                 &inp->data_v1_digest.n_, inp->data_v1_digest.elts_, newlen,
                 sizeof(inp->data_v1_digest.elts_[0]), (trunnel_free_fn_t) NULL,
                 &inp->trunnel_error_code_);
  if (newlen != 0 && newptr == NULL)
    goto trunnel_alloc_failed;
  inp->data_v1_digest.elts_ = newptr;
  return 0;
 trunnel_alloc_failed:
  TRUNNEL_SET_ERROR_CODE(inp);
  return -1;
}
const char *
sendme_cell_check(const sendme_cell_t *obj)
{
  if (obj == NULL)
    return "Object was NULL";
  if (obj->trunnel_error_code_)
    return "A set function failed on this object";
  if (! (obj->version == 0 || obj->version == 1))
    return "Integer out of bounds";
  if (! (obj->data_len == 16 || obj->data_len == 20))
    return "Integer out of bounds";
  switch (obj->version) {

    case 0:
      break;

    case 1:
      break;

    default:
        return "Bad tag for union";
      break;
  }
  return NULL;
}

ssize_t
sendme_cell_encoded_len(const sendme_cell_t *obj)
{
  ssize_t result = 0;

  if (NULL != sendme_cell_check(obj))
     return -1;


  /* Length of u8 version IN [0, 1] */
  result += 1;

  /* Length of u16 data_len IN [16, 20] */
  result += 2;
  switch (obj->version) {

    case 0:
      break;

    case 1:

      /* Length of u8 data_v1_digest[] */
      result += TRUNNEL_DYNARRAY_LEN(&obj->data_v1_digest);
      break;

    default:
      trunnel_assert(0);
      break;
  }
  return result;
}
int
sendme_cell_clear_errors(sendme_cell_t *obj)
{
  int r = obj->trunnel_error_code_;
  obj->trunnel_error_code_ = 0;
  return r;
}
ssize_t
sendme_cell_encode(uint8_t *output, const size_t avail, const sendme_cell_t *obj)
{
  ssize_t result = 0;
  size_t written = 0;
  uint8_t *ptr = output;
  const char *msg;
#ifdef TRUNNEL_CHECK_ENCODED_LEN
  const ssize_t encoded_len = sendme_cell_encoded_len(obj);
#endif

  uint8_t *backptr_data_len = NULL;

  if (NULL != (msg = sendme_cell_check(obj)))
    goto check_failed;

#ifdef TRUNNEL_CHECK_ENCODED_LEN
  trunnel_assert(encoded_len >= 0);
#endif

  /* Encode u8 version IN [0, 1] */
  trunnel_assert(written <= avail);
  if (avail - written < 1)
    goto truncated;
  trunnel_set_uint8(ptr, (obj->version));
  written += 1; ptr += 1;

  /* Encode u16 data_len IN [16, 20] */
  backptr_data_len = ptr;
  trunnel_assert(written <= avail);
  if (avail - written < 2)
    goto truncated;
  trunnel_set_uint16(ptr, trunnel_htons(obj->data_len));
  written += 2; ptr += 2;
  {
    size_t written_before_union = written;

    /* Encode union data[version] */
    trunnel_assert(written <= avail);
    switch (obj->version) {

      case 0:
        break;

      case 1:

        /* Encode u8 data_v1_digest[] */
        {
          size_t elt_len = TRUNNEL_DYNARRAY_LEN(&obj->data_v1_digest);
          trunnel_assert(written <= avail);
          if (avail - written < elt_len)
            goto truncated;
          if (elt_len)
            memcpy(ptr, obj->data_v1_digest.elts_, elt_len);
          written += elt_len; ptr += elt_len;
        }
        break;

      default:
        trunnel_assert(0);
        break;
    }
    /* Write the length field back to data_len */
    trunnel_assert(written >= written_before_union);
#if UINT16_MAX < SIZE_MAX
    if (written - written_before_union > UINT16_MAX)
      goto check_failed;
#endif
    trunnel_set_uint16(backptr_data_len, trunnel_htons(written - written_before_union));
  }


  trunnel_assert(ptr == output + written);
#ifdef TRUNNEL_CHECK_ENCODED_LEN
  {
    trunnel_assert(encoded_len >= 0);
    trunnel_assert((size_t)encoded_len == written);
  }

#endif

  return written;

 truncated:
  result = -2;
  goto fail;
 check_failed:
  (void)msg;
  result = -1;
  goto fail;
 fail:
  trunnel_assert(result < 0);
  return result;
}

/** As sendme_cell_parse(), but do not allocate the output object.
 */
static ssize_t
sendme_cell_parse_into(sendme_cell_t *obj, const uint8_t *input, const size_t len_in)
{
  const uint8_t *ptr = input;
  size_t remaining = len_in;
  ssize_t result = 0;
  (void)result;

  /* Parse u8 version IN [0, 1] */
  CHECK_REMAINING(1, truncated);
  obj->version = (trunnel_get_uint8(ptr));
  remaining -= 1; ptr += 1;
  if (! (obj->version == 0 || obj->version == 1))
    goto fail;

  /* Parse u16 data_len IN [16, 20] */
  CHECK_REMAINING(2, truncated);
  obj->data_len = trunnel_ntohs(trunnel_get_uint16(ptr));
  remaining -= 2; ptr += 2;
  if (! (obj->data_len == 16 || obj->data_len == 20))
    goto fail;
  {
    size_t remaining_after;
    CHECK_REMAINING(obj->data_len, truncated);
    remaining_after = remaining - obj->data_len;
    remaining = obj->data_len;

    /* Parse union data[version] */
    switch (obj->version) {

      case 0:
        /* Skip to end of union */
        ptr += remaining; remaining = 0;
        break;

      case 1:

        /* Parse u8 data_v1_digest[] */
        TRUNNEL_DYNARRAY_EXPAND(uint8_t, &obj->data_v1_digest, remaining, {});
        obj->data_v1_digest.n_ = remaining;
        if (remaining)
          memcpy(obj->data_v1_digest.elts_, ptr, remaining);
        ptr += remaining; remaining -= remaining;
        break;

      default:
        goto fail;
        break;
    }
    if (remaining != 0)
      goto fail;
    remaining = remaining_after;
  }
  trunnel_assert(ptr + remaining == input + len_in);
  return len_in - remaining;

 truncated:
  return -2;
 trunnel_alloc_failed:
  return -1;
 fail:
  result = -1;
  return result;
}

ssize_t
sendme_cell_parse(sendme_cell_t **output, const uint8_t *input, const size_t len_in)
{
  ssize_t result;
  *output = sendme_cell_new();
  if (NULL == *output)
    return -1;
  result = sendme_cell_parse_into(*output, input, len_in);
  if (result < 0) {
    sendme_cell_free(*output);
    *output = NULL;
  }
  return result;
}
