/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.onionoo.server;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.onionoo.docs.DocumentStore;
import org.torproject.metrics.onionoo.docs.DocumentStoreFactory;
import org.torproject.metrics.onionoo.docs.SummaryDocument;
import org.torproject.metrics.onionoo.docs.UpdateStatus;
import org.torproject.metrics.onionoo.server.NodeIndex;
import org.torproject.metrics.onionoo.server.NodeIndexerFactory;
import org.torproject.metrics.onionoo.updater.TorVersion;

public class NodeIndexer
implements ServletContextListener,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(NodeIndexer.class);
    private long lastIndexed = -1L;
    private NodeIndex latestNodeIndex = null;
    private Thread nodeIndexerThread = null;
    private long specialTime = -1L;

    @Override
    public void contextInitialized(ServletContextEvent contextEvent) {
        File outDir = new File(System.getProperty("onionoo.basedir", "/srv/onionoo.torproject.org/onionoo"), "out");
        if (!outDir.exists() || !outDir.isDirectory()) {
            log.error("\n\n\tOut-dir not found! Expected directory: {}\n\tSet system property 'onionoo.basedir'.", (Object)outDir);
            System.exit(1);
        }
        DocumentStore documentStore = DocumentStoreFactory.getDocumentStore();
        documentStore.setOutDir(outDir);
        NodeIndexerFactory.setNodeIndexer(this);
        this.startIndexing();
    }

    @Override
    public void contextDestroyed(ServletContextEvent contextEvent) {
        this.stopIndexing();
    }

    public synchronized long getLastIndexed(long timeoutMillis) {
        if (this.lastIndexed == -1L && this.nodeIndexerThread != null && timeoutMillis > 0L) {
            try {
                this.wait(timeoutMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.lastIndexed;
    }

    public synchronized NodeIndex getLatestNodeIndex(long timeoutMillis) {
        if (this.latestNodeIndex == null && this.nodeIndexerThread != null && timeoutMillis > 0L) {
            try {
                this.wait(timeoutMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.latestNodeIndex;
    }

    public synchronized void startIndexing() {
        if (this.nodeIndexerThread == null) {
            this.nodeIndexerThread = new Thread((Runnable)this, "Onionoo-Node-Indexer");
            this.nodeIndexerThread.setDaemon(true);
            this.nodeIndexerThread.start();
        }
    }

    @Override
    public void run() {
        try {
            while (this.nodeIndexerThread != null) {
                this.indexNodeStatuses();
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Throwable th) {
            log.error("Indexing failed: {}", (Object)th.getMessage(), (Object)th);
        }
    }

    public synchronized void stopIndexing() {
        Thread indexerThread = this.nodeIndexerThread;
        this.nodeIndexerThread = null;
        indexerThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexNodeStatuses() {
        String fingerprint;
        long updateStatusMillis = -1L;
        DocumentStore documentStore = DocumentStoreFactory.getDocumentStore();
        UpdateStatus updateStatus = documentStore.retrieve(UpdateStatus.class, true);
        if (updateStatus != null) {
            updateStatusMillis = updateStatus.getUpdatedMillis();
        }
        NodeIndexer nodeIndexer = this;
        synchronized (nodeIndexer) {
            if (updateStatusMillis <= this.lastIndexed) {
                return;
            }
        }
        documentStore.invalidateDocumentCache();
        HashMap<String, SummaryDocument> newRelayFingerprintSummaryLines = new HashMap<String, SummaryDocument>();
        HashMap<String, SummaryDocument> newBridgeFingerprintSummaryLines = new HashMap<String, SummaryDocument>();
        HashMap<String, Set<String>> newRelaysByCountryCode = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> newRelaysByAsNumber = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> newRelaysByAsName = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> newRelaysByFlag = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> newBridgesByFlag = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> newRelaysByContact = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> newRelaysByFamily = new HashMap<String, Set<String>>();
        HashMap<TorVersion, Set<String>> newRelaysByVersion = new HashMap<TorVersion, Set<String>>();
        HashMap<TorVersion, Set<String>> newBridgesByVersion = new HashMap<TorVersion, Set<String>>();
        HashMap<String, Set<String>> newRelaysByOperatingSystem = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> newBridgesByOperatingSystem = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> newRelaysByHostName = new HashMap<String, Set<String>>();
        HashMap<Boolean, Set<String>> newRelaysByRecommendedVersion = new HashMap<Boolean, Set<String>>();
        newRelaysByRecommendedVersion.put(true, new HashSet());
        newRelaysByRecommendedVersion.put(false, new HashSet());
        HashMap<Boolean, Set<String>> newBridgesByRecommendedVersion = new HashMap<Boolean, Set<String>>();
        newBridgesByRecommendedVersion.put(true, new HashSet());
        newBridgesByRecommendedVersion.put(false, new HashSet());
        TreeMap<Integer, Set<String>> newRelaysByFirstSeenDays = new TreeMap<Integer, Set<String>>();
        TreeMap<Integer, Set<String>> newBridgesByFirstSeenDays = new TreeMap<Integer, Set<String>>();
        TreeMap<Integer, Set<String>> newRelaysByLastSeenDays = new TreeMap<Integer, Set<String>>();
        TreeMap<Integer, Set<String>> newBridgesByLastSeenDays = new TreeMap<Integer, Set<String>>();
        HashSet<SummaryDocument> currentRelays = new HashSet<SummaryDocument>();
        HashSet<SummaryDocument> currentBridges = new HashSet<SummaryDocument>();
        SortedSet<String> fingerprints = documentStore.list(SummaryDocument.class);
        long relaysLastValidAfterMillis = 0L;
        long bridgesLastPublishedMillis = 0L;
        for (String string : fingerprints) {
            SummaryDocument node = documentStore.retrieve(SummaryDocument.class, true, string);
            if (node.isRelay()) {
                relaysLastValidAfterMillis = Math.max(relaysLastValidAfterMillis, node.getLastSeenMillis());
                currentRelays.add(node);
                continue;
            }
            bridgesLastPublishedMillis = Math.max(bridgesLastPublishedMillis, node.getLastSeenMillis());
            currentBridges.add(node);
        }
        TreeMap<String, SortedSet<String>> computedEffectiveFamilies = new TreeMap<String, SortedSet<String>>();
        for (SummaryDocument entry : currentRelays) {
            SortedSet<String> unverifiedHostNames;
            String operatingSystem;
            fingerprint = entry.getFingerprint().toUpperCase();
            String hashedFingerprint = entry.getHashedFingerprint().toUpperCase();
            newRelayFingerprintSummaryLines.put(fingerprint, entry);
            newRelayFingerprintSummaryLines.put(hashedFingerprint, entry);
            String countryCode = null != entry.getCountryCode() ? entry.getCountryCode() : "xz";
            newRelaysByCountryCode.putIfAbsent(countryCode, new HashSet());
            ((Set)newRelaysByCountryCode.get(countryCode)).add(fingerprint);
            ((Set)newRelaysByCountryCode.get(countryCode)).add(hashedFingerprint);
            String asNumber = null != entry.getAsNumber() ? entry.getAsNumber() : "AS0";
            newRelaysByAsNumber.putIfAbsent(asNumber, new HashSet());
            ((Set)newRelaysByAsNumber.get(asNumber)).add(fingerprint);
            ((Set)newRelaysByAsNumber.get(asNumber)).add(hashedFingerprint);
            String asName = entry.getAsName();
            newRelaysByAsName.putIfAbsent(asName, new HashSet());
            ((Set)newRelaysByAsName.get(asName)).add(fingerprint);
            ((Set)newRelaysByAsName.get(asName)).add(hashedFingerprint);
            for (String flag : entry.getRelayFlags()) {
                String flagLowerCase = flag.toLowerCase();
                newRelaysByFlag.putIfAbsent(flagLowerCase, new HashSet());
                ((Set)newRelaysByFlag.get(flagLowerCase)).add(fingerprint);
                ((Set)newRelaysByFlag.get(flagLowerCase)).add(hashedFingerprint);
            }
            if (entry.getFamilyFingerprints() != null && !entry.getFamilyFingerprints().isEmpty()) {
                computedEffectiveFamilies.put(fingerprint, entry.getFamilyFingerprints());
            }
            if (entry.getEffectiveFamily() != null) {
                newRelaysByFamily.put(fingerprint, entry.getEffectiveFamily());
            }
            int daysSinceFirstSeen = (int)(((this.specialTime < 0L ? System.currentTimeMillis() : this.specialTime) - entry.getFirstSeenMillis()) / 86400000L);
            newRelaysByFirstSeenDays.putIfAbsent(daysSinceFirstSeen, new HashSet());
            ((Set)newRelaysByFirstSeenDays.get(daysSinceFirstSeen)).add(fingerprint);
            ((Set)newRelaysByFirstSeenDays.get(daysSinceFirstSeen)).add(hashedFingerprint);
            int daysSinceLastSeen = (int)(((this.specialTime < 0L ? System.currentTimeMillis() : this.specialTime) - entry.getLastSeenMillis()) / 86400000L);
            newRelaysByLastSeenDays.putIfAbsent(daysSinceLastSeen, new HashSet());
            ((Set)newRelaysByLastSeenDays.get(daysSinceLastSeen)).add(fingerprint);
            ((Set)newRelaysByLastSeenDays.get(daysSinceLastSeen)).add(hashedFingerprint);
            String contact = entry.getContact();
            newRelaysByContact.putIfAbsent(contact, new HashSet());
            ((Set)newRelaysByContact.get(contact)).add(fingerprint);
            ((Set)newRelaysByContact.get(contact)).add(hashedFingerprint);
            TorVersion version = TorVersion.of(entry.getVersion());
            if (null != version) {
                newRelaysByVersion.putIfAbsent(version, new HashSet());
                ((Set)newRelaysByVersion.get(version)).add(fingerprint);
                ((Set)newRelaysByVersion.get(version)).add(hashedFingerprint);
            }
            if (null != (operatingSystem = entry.getOperatingSystem())) {
                newRelaysByOperatingSystem.putIfAbsent(operatingSystem, new HashSet());
                ((Set)newRelaysByOperatingSystem.get(operatingSystem)).add(fingerprint);
                ((Set)newRelaysByOperatingSystem.get(operatingSystem)).add(hashedFingerprint);
            }
            TreeSet<String> allHostNames = new TreeSet<String>();
            SortedSet<String> verifiedHostNames = entry.getVerifiedHostNames();
            if (null != verifiedHostNames) {
                allHostNames.addAll(verifiedHostNames);
            }
            if (null != (unverifiedHostNames = entry.getUnverifiedHostNames())) {
                allHostNames.addAll(unverifiedHostNames);
            }
            for (String hostName : allHostNames) {
                String hostNameLowerCase = hostName.toLowerCase();
                newRelaysByHostName.putIfAbsent(hostNameLowerCase, new HashSet());
                ((Set)newRelaysByHostName.get(hostNameLowerCase)).add(fingerprint);
                ((Set)newRelaysByHostName.get(hostNameLowerCase)).add(hashedFingerprint);
            }
            Boolean recommendedVersion = entry.isRecommendedVersion();
            if (null == recommendedVersion) continue;
            ((Set)newRelaysByRecommendedVersion.get(recommendedVersion)).add(fingerprint);
            ((Set)newRelaysByRecommendedVersion.get(recommendedVersion)).add(hashedFingerprint);
        }
        for (Map.Entry e : computedEffectiveFamilies.entrySet()) {
            fingerprint = (String)e.getKey();
            HashSet<String> inMutualFamilyRelation = new HashSet<String>();
            for (String otherFingerprint : (Set)e.getValue()) {
                if (!computedEffectiveFamilies.containsKey(otherFingerprint) || !((Set)computedEffectiveFamilies.get(otherFingerprint)).contains(fingerprint)) continue;
                inMutualFamilyRelation.add(otherFingerprint);
            }
            newRelaysByFamily.put(fingerprint, inMutualFamilyRelation);
        }
        for (SummaryDocument entry : currentBridges) {
            Boolean recommendedVersion;
            String operatingSystem;
            String hashedFingerprint = entry.getFingerprint().toUpperCase();
            String hashedHashedFingerprint = entry.getHashedFingerprint().toUpperCase();
            newBridgeFingerprintSummaryLines.put(hashedFingerprint, entry);
            newBridgeFingerprintSummaryLines.put(hashedHashedFingerprint, entry);
            for (String flag : entry.getRelayFlags()) {
                String flagLowerCase = flag.toLowerCase();
                newBridgesByFlag.putIfAbsent(flagLowerCase, new HashSet());
                ((Set)newBridgesByFlag.get(flagLowerCase)).add(hashedFingerprint);
                ((Set)newBridgesByFlag.get(flagLowerCase)).add(hashedHashedFingerprint);
            }
            int daysSinceFirstSeen = (int)(((this.specialTime < 0L ? System.currentTimeMillis() : this.specialTime) - entry.getFirstSeenMillis()) / 86400000L);
            newBridgesByFirstSeenDays.putIfAbsent(daysSinceFirstSeen, new HashSet());
            ((Set)newBridgesByFirstSeenDays.get(daysSinceFirstSeen)).add(hashedFingerprint);
            ((Set)newBridgesByFirstSeenDays.get(daysSinceFirstSeen)).add(hashedHashedFingerprint);
            int daysSinceLastSeen = (int)(((this.specialTime < 0L ? System.currentTimeMillis() : this.specialTime) - entry.getLastSeenMillis()) / 86400000L);
            newBridgesByLastSeenDays.putIfAbsent(daysSinceLastSeen, new HashSet());
            ((Set)newBridgesByLastSeenDays.get(daysSinceLastSeen)).add(hashedFingerprint);
            ((Set)newBridgesByLastSeenDays.get(daysSinceLastSeen)).add(hashedHashedFingerprint);
            TorVersion version = TorVersion.of(entry.getVersion());
            if (null != version) {
                newBridgesByVersion.putIfAbsent(version, new HashSet());
                ((Set)newBridgesByVersion.get(version)).add(hashedFingerprint);
                ((Set)newBridgesByVersion.get(version)).add(hashedHashedFingerprint);
            }
            if (null != (operatingSystem = entry.getOperatingSystem())) {
                newBridgesByOperatingSystem.putIfAbsent(operatingSystem, new HashSet());
                ((Set)newBridgesByOperatingSystem.get(operatingSystem)).add(hashedFingerprint);
                ((Set)newBridgesByOperatingSystem.get(operatingSystem)).add(hashedHashedFingerprint);
            }
            if (null == (recommendedVersion = entry.isRecommendedVersion())) continue;
            ((Set)newBridgesByRecommendedVersion.get(recommendedVersion)).add(hashedFingerprint);
            ((Set)newBridgesByRecommendedVersion.get(recommendedVersion)).add(hashedHashedFingerprint);
        }
        NodeIndex nodeIndex = new NodeIndex();
        nodeIndex.setRelayFingerprintSummaryLines(newRelayFingerprintSummaryLines);
        nodeIndex.setBridgeFingerprintSummaryLines(newBridgeFingerprintSummaryLines);
        nodeIndex.setRelaysByCountryCode(newRelaysByCountryCode);
        nodeIndex.setRelaysByAsNumber(newRelaysByAsNumber);
        nodeIndex.setRelaysByAsName(newRelaysByAsName);
        nodeIndex.setRelaysByFlag(newRelaysByFlag);
        nodeIndex.setBridgesByFlag(newBridgesByFlag);
        nodeIndex.setRelaysByContact(newRelaysByContact);
        nodeIndex.setRelaysByFamily(newRelaysByFamily);
        nodeIndex.setRelaysByFirstSeenDays(newRelaysByFirstSeenDays);
        nodeIndex.setRelaysByLastSeenDays(newRelaysByLastSeenDays);
        nodeIndex.setBridgesByFirstSeenDays(newBridgesByFirstSeenDays);
        nodeIndex.setBridgesByLastSeenDays(newBridgesByLastSeenDays);
        nodeIndex.setRelaysPublishedMillis(relaysLastValidAfterMillis);
        nodeIndex.setBridgesPublishedMillis(bridgesLastPublishedMillis);
        nodeIndex.setRelaysByVersion(newRelaysByVersion);
        nodeIndex.setBridgesByVersion(newBridgesByVersion);
        nodeIndex.setRelaysByOperatingSystem(newRelaysByOperatingSystem);
        nodeIndex.setBridgesByOperatingSystem(newBridgesByOperatingSystem);
        nodeIndex.setRelaysByHostName(newRelaysByHostName);
        nodeIndex.setRelaysByRecommendedVersion(newRelaysByRecommendedVersion);
        nodeIndex.setBridgesByRecommendedVersion(newBridgesByRecommendedVersion);
        NodeIndexer nodeIndexer2 = this;
        synchronized (nodeIndexer2) {
            this.lastIndexed = updateStatusMillis;
            this.latestNodeIndex = nodeIndex;
            this.notifyAll();
        }
    }
}

