/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.onionoo.docs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.torproject.metrics.onionoo.docs.DateTimeHelper;
import org.torproject.metrics.onionoo.docs.Document;

public class SummaryDocument
extends Document {
    @JsonProperty(value="t")
    private boolean isRelay;
    @JsonProperty(value="f")
    private String fingerprint;
    @JsonIgnore
    private transient String hashedFingerprint = null;
    @JsonIgnore
    private transient String base64Fingerprint = null;
    @JsonIgnore
    private transient String[] fingerprintSortedHexBlocks = null;
    @JsonProperty(value="n")
    private String nickname;
    @JsonProperty(value="ad")
    private String[] addresses;
    @JsonProperty(value="cc")
    private String countryCode;
    @JsonProperty(value="as")
    private String asNumber;
    @JsonProperty(value="an")
    private String asName;
    @JsonProperty(value="fs")
    private String firstSeenMillis;
    @JsonProperty(value="ls")
    private String lastSeenMillis;
    @JsonProperty(value="rf")
    private String[] relayFlags;
    @JsonProperty(value="cw")
    private long consensusWeight;
    @JsonProperty(value="r")
    private boolean running;
    @JsonProperty(value="c")
    private String contact;
    @JsonProperty(value="ff")
    private String[] familyFingerprints;
    @JsonProperty(value="ef")
    private String[] effectiveFamily;
    @JsonProperty(value="v")
    private String version;
    @JsonProperty(value="o")
    private String operatingSystem;
    @JsonProperty(value="h")
    private String hostName;
    @JsonProperty(value="vh")
    private SortedSet<String> verifiedHostNames;
    @JsonProperty(value="uh")
    private SortedSet<String> unverifiedHostNames;
    @JsonProperty(value="rv")
    private Boolean recommendedVersion;

    public void setRelay(boolean isRelay) {
        this.isRelay = isRelay;
    }

    public boolean isRelay() {
        return this.isRelay;
    }

    public void setFingerprint(String fingerprint) {
        Pattern fingerprintPattern;
        if (fingerprint != null && !(fingerprintPattern = Pattern.compile("^[0-9a-fA-F]{40}$")).matcher(fingerprint).matches()) {
            throw new IllegalArgumentException("Fingerprint '" + fingerprint + "' is not a valid fingerprint.");
        }
        this.fingerprint = fingerprint;
        this.hashedFingerprint = null;
        this.base64Fingerprint = null;
        this.fingerprintSortedHexBlocks = null;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getHashedFingerprint() {
        if (this.hashedFingerprint == null && this.fingerprint != null) {
            try {
                this.hashedFingerprint = DigestUtils.sha1Hex(Hex.decodeHex(this.fingerprint.toCharArray())).toUpperCase();
            }
            catch (DecoderException decoderException) {
                // empty catch block
            }
        }
        return this.hashedFingerprint;
    }

    public String getBase64Fingerprint() {
        if (this.base64Fingerprint == null && this.fingerprint != null) {
            try {
                this.base64Fingerprint = Base64.encodeBase64String(Hex.decodeHex(this.fingerprint.toCharArray())).replaceAll("=", "");
            }
            catch (DecoderException decoderException) {
                // empty catch block
            }
        }
        return this.base64Fingerprint;
    }

    public String[] getFingerprintSortedHexBlocks() {
        if (this.fingerprintSortedHexBlocks == null && this.fingerprint != null) {
            String fingerprint = this.fingerprint.toUpperCase();
            Object[] fingerprintSortedHexBlocks = new String[fingerprint.length() / 4];
            for (int i = 0; i < fingerprint.length(); i += 4) {
                fingerprintSortedHexBlocks[i / 4] = fingerprint.substring(i, Math.min(i + 4, fingerprint.length()));
            }
            Arrays.sort(fingerprintSortedHexBlocks);
            this.fingerprintSortedHexBlocks = fingerprintSortedHexBlocks;
        }
        return this.fingerprintSortedHexBlocks;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname == null || nickname.equals("Unnamed") ? null : nickname;
    }

    public String getNickname() {
        return this.nickname == null ? "Unnamed" : this.nickname;
    }

    public void setAddresses(List<String> addresses) {
        this.addresses = this.collectionToStringArray(addresses);
    }

    public List<String> getAddresses() {
        return this.stringArrayToList(this.addresses);
    }

    private String[] collectionToStringArray(Collection<String> collection) {
        String[] stringArray = null;
        if (collection != null && !collection.isEmpty()) {
            stringArray = new String[collection.size()];
            int index = 0;
            for (String string : collection) {
                stringArray[index++] = string;
            }
        }
        return stringArray;
    }

    private List<String> stringArrayToList(String[] stringArray) {
        List<String> list = stringArray == null ? new ArrayList<String>() : Arrays.asList(stringArray);
        return list;
    }

    private SortedSet<String> stringArrayToSortedSet(String[] stringArray) {
        TreeSet<String> sortedSet = new TreeSet<String>();
        if (stringArray != null) {
            sortedSet.addAll(Arrays.asList(stringArray));
        }
        return sortedSet;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setAsNumber(String asNumber) {
        this.asNumber = asNumber;
    }

    public String getAsNumber() {
        return this.asNumber;
    }

    public void setAsName(String asName) {
        this.asName = asName;
    }

    public String getAsName() {
        return this.asName;
    }

    public void setFirstSeenMillis(long firstSeenMillis) {
        this.firstSeenMillis = DateTimeHelper.format(firstSeenMillis);
    }

    public long getFirstSeenMillis() {
        return DateTimeHelper.parse(this.firstSeenMillis);
    }

    public void setLastSeenMillis(long lastSeenMillis) {
        this.lastSeenMillis = DateTimeHelper.format(lastSeenMillis);
    }

    public long getLastSeenMillis() {
        return DateTimeHelper.parse(this.lastSeenMillis);
    }

    public void setRelayFlags(SortedSet<String> relayFlags) {
        this.relayFlags = this.collectionToStringArray(relayFlags);
    }

    public SortedSet<String> getRelayFlags() {
        return this.stringArrayToSortedSet(this.relayFlags);
    }

    public void setConsensusWeight(long consensusWeight) {
        this.consensusWeight = consensusWeight;
    }

    public long getConsensusWeight() {
        return this.consensusWeight;
    }

    public void setRunning(boolean isRunning) {
        this.running = isRunning;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setContact(String contact) {
        this.contact = contact != null && contact.length() == 0 ? null : contact;
    }

    public String getContact() {
        return this.contact;
    }

    public void setFamilyFingerprints(SortedSet<String> familyFingerprints) {
        this.familyFingerprints = this.collectionToStringArray(familyFingerprints);
    }

    public SortedSet<String> getFamilyFingerprints() {
        return this.stringArrayToSortedSet(this.familyFingerprints);
    }

    public void setEffectiveFamily(SortedSet<String> effectiveFamily) {
        this.effectiveFamily = this.collectionToStringArray(effectiveFamily);
    }

    public SortedSet<String> getEffectiveFamily() {
        return this.stringArrayToSortedSet(this.effectiveFamily);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setVerifiedHostNames(SortedSet<String> verifiedHostNames) {
        this.verifiedHostNames = verifiedHostNames;
    }

    public SortedSet<String> getVerifiedHostNames() {
        return this.verifiedHostNames;
    }

    public void setUnverifiedHostNames(SortedSet<String> unverifiedHostNames) {
        this.unverifiedHostNames = unverifiedHostNames;
    }

    public SortedSet<String> getUnverifiedHostNames() {
        return this.unverifiedHostNames;
    }

    public void setRecommendedVersion(Boolean recommendedVersion) {
        this.recommendedVersion = recommendedVersion;
    }

    public Boolean isRecommendedVersion() {
        return this.recommendedVersion;
    }

    public SummaryDocument() {
    }

    public SummaryDocument(boolean isRelay, String nickname, String fingerprint, List<String> addresses, long lastSeenMillis, boolean running, SortedSet<String> relayFlags, long consensusWeight, String countryCode, long firstSeenMillis, String asNumber, String asName, String contact, SortedSet<String> familyFingerprints, SortedSet<String> effectiveFamily, String version, String operatingSystem, SortedSet<String> verifiedHostNames, SortedSet<String> unverifiedHostNames, Boolean recommendedVersion) {
        this.setRelay(isRelay);
        this.setNickname(nickname);
        this.setFingerprint(fingerprint);
        this.setAddresses(addresses);
        this.setLastSeenMillis(lastSeenMillis);
        this.setRunning(running);
        this.setRelayFlags(relayFlags);
        this.setConsensusWeight(consensusWeight);
        this.setCountryCode(countryCode);
        this.setFirstSeenMillis(firstSeenMillis);
        this.setAsNumber(asNumber);
        this.setAsName(asName);
        this.setContact(contact);
        this.setFamilyFingerprints(familyFingerprints);
        this.setEffectiveFamily(effectiveFamily);
        this.setVersion(version);
        this.setOperatingSystem(operatingSystem);
        this.setVerifiedHostNames(verifiedHostNames);
        this.setUnverifiedHostNames(unverifiedHostNames);
        this.setRecommendedVersion(recommendedVersion);
    }
}

