/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.onionoo.docs;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.onionoo.docs.DateTimeHelper;
import org.torproject.metrics.onionoo.docs.Document;
import org.torproject.metrics.onionoo.updater.TorVersionStatus;

public class NodeStatus
extends Document {
    private static final Logger log = LoggerFactory.getLogger(NodeStatus.class);
    private String contact;
    private String[] declaredFamily;
    private boolean isRelay;
    private final String fingerprint;
    private String nickname;
    private String address;
    private SortedSet<String> orAddressesAndPorts;
    private long firstSeenMillis;
    private long lastSeenMillis;
    private int orPort;
    private int dirPort;
    private static Map<String, Integer> relayFlagIndexes = new HashMap<String, Integer>();
    private static Map<Integer, String> relayFlagStrings = new HashMap<Integer, String>();
    private BitSet relayFlags;
    private long consensusWeight;
    private String defaultPolicy;
    private String portList;
    private SortedMap<Long, Set<String>> lastAddresses = new TreeMap(Collections.reverseOrder());
    private Boolean recommendedVersion;
    private String version;
    private TorVersionStatus versionStatus;
    private String operatingSystem;
    private SortedSet<String> exitAddresses;
    private String countryCode;
    private String asNumber;
    private String asName;
    private String hostName;
    private SortedSet<String> verifiedHostNames;
    private SortedSet<String> unverifiedHostNames;
    private long lastRdnsLookup = -1L;
    private String[] effectiveFamily;
    private String[] extendedFamily;

    public void setContact(String contact) {
        if (contact == null) {
            this.contact = null;
        } else {
            StringBuilder sb = new StringBuilder();
            for (char c : contact.toLowerCase().toCharArray()) {
                if (c >= ' ' && c < '\u007f') {
                    sb.append(c);
                    continue;
                }
                sb.append(" ");
            }
            this.contact = sb.toString();
        }
    }

    public String getContact() {
        return this.contact;
    }

    public void setDeclaredFamily(SortedSet<String> declaredFamily) {
        TreeSet<String> declaredFamilyIncludingSelf = new TreeSet<String>(declaredFamily);
        declaredFamilyIncludingSelf.add(this.fingerprint);
        this.declaredFamily = NodeStatus.collectionToStringArray(declaredFamilyIncludingSelf);
    }

    public SortedSet<String> getDeclaredFamily() {
        SortedSet<String> declaredFamilyIncludingSelf = this.stringArrayToSortedSet(this.declaredFamily);
        declaredFamilyIncludingSelf.add(this.fingerprint);
        return declaredFamilyIncludingSelf;
    }

    private static String[] collectionToStringArray(Collection<String> collection) {
        return null == collection || collection.isEmpty() ? null : collection.toArray(new String[collection.size()]);
    }

    private SortedSet<String> stringArrayToSortedSet(String[] stringArray) {
        return stringArray == null ? new TreeSet<String>() : (SortedSet)Arrays.stream(stringArray).collect(Collectors.toCollection(TreeSet::new));
    }

    public void setRelay(boolean isRelay) {
        this.isRelay = isRelay;
    }

    public boolean isRelay() {
        return this.isRelay;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public void setOrAddressesAndPorts(SortedSet<String> orAddressesAndPorts) {
        this.orAddressesAndPorts = orAddressesAndPorts;
    }

    public SortedSet<String> getOrAddressesAndPorts() {
        return this.orAddressesAndPorts == null ? new TreeSet() : this.orAddressesAndPorts;
    }

    public SortedSet<String> getOrAddresses() {
        TreeSet<String> orAddresses = new TreeSet<String>();
        if (this.address != null) {
            orAddresses.add(this.address);
        }
        if (this.orAddressesAndPorts != null) {
            for (String orAddressAndPort : this.orAddressesAndPorts) {
                if (!orAddressAndPort.contains(":")) continue;
                String orAddress = orAddressAndPort.substring(0, orAddressAndPort.lastIndexOf(58));
                orAddresses.add(orAddress);
            }
        }
        return orAddresses;
    }

    public void setFirstSeenMillis(long firstSeenMillis) {
        this.firstSeenMillis = firstSeenMillis;
    }

    public long getFirstSeenMillis() {
        return this.firstSeenMillis;
    }

    public void setLastSeenMillis(long lastSeenMillis) {
        this.lastSeenMillis = lastSeenMillis;
    }

    public long getLastSeenMillis() {
        return this.lastSeenMillis;
    }

    public void setOrPort(int orPort) {
        this.orPort = orPort;
    }

    public int getOrPort() {
        return this.orPort;
    }

    public void setDirPort(int dirPort) {
        this.dirPort = dirPort;
    }

    public int getDirPort() {
        return this.dirPort;
    }

    public void setRelayFlags(SortedSet<String> relayFlags) {
        BitSet newRelayFlags = new BitSet(relayFlagIndexes.size());
        for (String relayFlag : relayFlags) {
            if (relayFlag.length() == 0) continue;
            if (!relayFlagIndexes.containsKey(relayFlag)) {
                relayFlagStrings.put(relayFlagIndexes.size(), relayFlag);
                relayFlagIndexes.put(relayFlag, relayFlagIndexes.size());
            }
            newRelayFlags.set(relayFlagIndexes.get(relayFlag));
        }
        this.relayFlags = newRelayFlags;
    }

    public SortedSet<String> getRelayFlags() {
        TreeSet<String> result = new TreeSet<String>();
        if (this.relayFlags != null) {
            int i = this.relayFlags.nextSetBit(0);
            while (i >= 0) {
                result.add(relayFlagStrings.get(i));
                i = this.relayFlags.nextSetBit(i + 1);
            }
        }
        return result;
    }

    public void setConsensusWeight(long consensusWeight) {
        this.consensusWeight = consensusWeight;
    }

    public long getConsensusWeight() {
        return this.consensusWeight;
    }

    public void setDefaultPolicy(String defaultPolicy) {
        this.defaultPolicy = defaultPolicy;
    }

    public String getDefaultPolicy() {
        return this.defaultPolicy;
    }

    public void setPortList(String portList) {
        this.portList = portList;
    }

    public String getPortList() {
        return this.portList;
    }

    public SortedMap<Long, Set<String>> getLastAddresses() {
        return new TreeMap<Long, Set<String>>(this.lastAddresses);
    }

    public void addLastAddresses(long lastSeenMillis, String address, int orPort, int dirPort, SortedSet<String> orAddressesAndPorts) {
        HashSet<String> addressesAndPorts = new HashSet<String>();
        addressesAndPorts.add(address + ":" + orPort);
        if (dirPort > 0) {
            addressesAndPorts.add(address + ":" + dirPort);
        }
        addressesAndPorts.addAll(orAddressesAndPorts);
        this.lastAddresses.putIfAbsent(lastSeenMillis, new TreeSet());
        ((Set)this.lastAddresses.get(lastSeenMillis)).addAll(addressesAndPorts);
    }

    public long getLastChangedOrAddressOrPort() {
        long lastChangedAddressesMillis = -1L;
        if (this.lastAddresses != null) {
            Set<String> lastAddresses = null;
            for (Map.Entry<Long, Set<String>> e : this.lastAddresses.entrySet()) {
                if (lastAddresses != null) {
                    for (String address : e.getValue()) {
                        if (lastAddresses.contains(address)) continue;
                        return lastChangedAddressesMillis;
                    }
                }
                lastChangedAddressesMillis = e.getKey();
                lastAddresses = e.getValue();
            }
        }
        return lastChangedAddressesMillis;
    }

    public void setRecommendedVersion(Boolean recommendedVersion) {
        this.recommendedVersion = recommendedVersion;
    }

    public Boolean isRecommendedVersion() {
        return this.recommendedVersion;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersionStatus(TorVersionStatus versionStatus) {
        this.versionStatus = versionStatus;
    }

    public TorVersionStatus getVersionStatus() {
        return this.versionStatus;
    }

    public void setOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public void setExitAddresses(SortedSet<String> exitAddresses) {
        this.exitAddresses = exitAddresses;
    }

    public SortedSet<String> getExitAddresses() {
        return new TreeSet<String>(this.exitAddresses);
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setAsNumber(String asNumber) {
        this.asNumber = asNumber;
    }

    public String getAsNumber() {
        return this.asNumber;
    }

    public void setAsName(String asName) {
        this.asName = asName;
    }

    public String getAsName() {
        return this.asName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setVerifiedHostNames(SortedSet<String> verifiedHostNames) {
        this.verifiedHostNames = verifiedHostNames;
    }

    public SortedSet<String> getVerifiedHostNames() {
        return this.verifiedHostNames;
    }

    public void setUnverifiedHostNames(SortedSet<String> unverifiedHostNames) {
        this.unverifiedHostNames = unverifiedHostNames;
    }

    public SortedSet<String> getUnverifiedHostNames() {
        return this.unverifiedHostNames;
    }

    public void setLastRdnsLookup(long lastRdnsLookup) {
        this.lastRdnsLookup = lastRdnsLookup;
    }

    public long getLastRdnsLookup() {
        return this.lastRdnsLookup;
    }

    public void setEffectiveFamily(SortedSet<String> effectiveFamily) {
        this.effectiveFamily = NodeStatus.collectionToStringArray(effectiveFamily);
    }

    public SortedSet<String> getEffectiveFamily() {
        return this.stringArrayToSortedSet(this.effectiveFamily);
    }

    public void setExtendedFamily(SortedSet<String> extendedFamily) {
        this.extendedFamily = NodeStatus.collectionToStringArray(extendedFamily);
    }

    public SortedSet<String> getExtendedFamily() {
        return this.stringArrayToSortedSet(this.extendedFamily);
    }

    public SortedSet<String> getAllegedFamily() {
        TreeSet<String> allegedFamily = new TreeSet<String>(this.stringArrayToSortedSet(this.declaredFamily));
        allegedFamily.removeAll(this.stringArrayToSortedSet(this.effectiveFamily));
        return allegedFamily;
    }

    public SortedSet<String> getIndirectFamily() {
        TreeSet<String> indirectFamily = new TreeSet<String>(this.stringArrayToSortedSet(this.extendedFamily));
        indirectFamily.removeAll(this.stringArrayToSortedSet(this.effectiveFamily));
        return indirectFamily;
    }

    public NodeStatus(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public static NodeStatus fromString(String documentString) {
        try {
            long firstSeenMillis;
            String address;
            String[] parts = documentString.trim().split("\t");
            if (parts.length < 23) {
                log.error("Too few space-separated values in line '{}'. Skipping.", (Object)documentString.trim());
                return null;
            }
            String fingerprint = parts[2];
            NodeStatus nodeStatus = new NodeStatus(fingerprint);
            nodeStatus.setRelay(parts[0].equals("r"));
            nodeStatus.setNickname(parts[1]);
            TreeSet<String> orAddressesAndPorts = new TreeSet<String>();
            TreeSet<String> exitAddresses = new TreeSet<String>();
            String addresses = parts[3];
            if (addresses.contains(";")) {
                String[] addressParts = addresses.split(";", -1);
                if (addressParts.length != 3) {
                    log.error("Invalid addresses entry in line '{}'. Skipping.", (Object)documentString.trim());
                    return null;
                }
                address = addressParts[0];
                if (addressParts[1].length() > 0) {
                    orAddressesAndPorts.addAll(Arrays.asList(addressParts[1].split("\\+")));
                }
                if (addressParts[2].length() > 0) {
                    exitAddresses.addAll(Arrays.asList(addressParts[2].split("\\+")));
                }
            } else {
                address = addresses;
            }
            nodeStatus.setAddress(address);
            nodeStatus.setOrAddressesAndPorts(orAddressesAndPorts);
            nodeStatus.setExitAddresses(exitAddresses);
            long lastSeenMillis = DateTimeHelper.parse(parts[4] + " " + parts[5]);
            if (lastSeenMillis < 0L) {
                log.error("Parse exception while parsing node status line '{}'. Skipping.", (Object)documentString);
                return null;
            }
            if (lastSeenMillis == 0L) {
                log.debug("Skipping node status with fingerprint {} that has so far never been seen in a network status.", (Object)fingerprint);
                return null;
            }
            nodeStatus.setLastSeenMillis(lastSeenMillis);
            int orPort = Integer.parseInt(parts[6]);
            int dirPort = Integer.parseInt(parts[7]);
            nodeStatus.setOrPort(orPort);
            nodeStatus.setDirPort(dirPort);
            nodeStatus.setRelayFlags(new TreeSet<String>(Arrays.asList(parts[8].split(","))));
            nodeStatus.setConsensusWeight(Long.parseLong(parts[9]));
            nodeStatus.setCountryCode(parts[10]);
            nodeStatus.setLastRdnsLookup(Long.parseLong(parts[12]));
            if (!parts[13].equals("null")) {
                nodeStatus.setDefaultPolicy(parts[13]);
            }
            if (!parts[14].equals("null")) {
                nodeStatus.setPortList(parts[14]);
            }
            if ((firstSeenMillis = DateTimeHelper.parse(parts[15] + " " + parts[16])) < 0L) {
                log.error("Parse exception while parsing node status line '{}'. Skipping.", (Object)documentString);
                return null;
            }
            nodeStatus.setFirstSeenMillis(firstSeenMillis);
            long lastChangedAddresses = lastSeenMillis;
            if (!parts[17].equals("null") && (lastChangedAddresses = DateTimeHelper.parse(parts[17] + " " + parts[18])) < 0L) {
                log.error("Parse exception while parsing node status line '{}'. Skipping.", (Object)documentString);
                return null;
            }
            nodeStatus.addLastAddresses(lastChangedAddresses, address, orPort, dirPort, orAddressesAndPorts);
            nodeStatus.setAsNumber(parts[19]);
            nodeStatus.setContact(parts[20]);
            if (!parts[21].equals("null")) {
                nodeStatus.setRecommendedVersion(parts[21].equals("true"));
            }
            if (!parts[22].equals("null")) {
                String[] groups = parts[22].split(":", -1);
                TreeSet<String> allegedFamily = new TreeSet<String>();
                TreeSet<String> effectiveFamily = new TreeSet<String>();
                TreeSet<String> indirectFamily = new TreeSet<String>();
                if (groups[0].length() > 0) {
                    allegedFamily.addAll(Arrays.asList(groups[0].split(";")));
                }
                if (groups.length > 1 && groups[1].length() > 0) {
                    effectiveFamily.addAll(Arrays.asList(groups[1].split(";")));
                }
                if (groups.length > 2 && groups[2].length() > 0) {
                    indirectFamily.addAll(Arrays.asList(groups[2].split(";")));
                }
                TreeSet<String> declaredFamily = new TreeSet<String>();
                declaredFamily.addAll(allegedFamily);
                declaredFamily.addAll(effectiveFamily);
                nodeStatus.setDeclaredFamily(declaredFamily);
                nodeStatus.setEffectiveFamily(effectiveFamily);
                TreeSet<String> extendedFamily = new TreeSet<String>();
                extendedFamily.addAll(effectiveFamily);
                extendedFamily.addAll(indirectFamily);
                nodeStatus.setExtendedFamily(extendedFamily);
            }
            if (parts.length >= 24 && !parts[23].isEmpty()) {
                nodeStatus.setVersion(parts[23]);
            }
            if (parts.length >= 26) {
                nodeStatus.setVersionStatus(TorVersionStatus.ofAbbreviation(parts[25]));
            }
            if (parts.length >= 27) {
                nodeStatus.setAsName(parts[26]);
            }
            if (parts.length >= 28) {
                TreeSet<String> verifiedHostNames = new TreeSet<String>();
                TreeSet<String> unverifiedHostNames = new TreeSet<String>();
                String[] groups = parts[27].split(":", -1);
                if (groups[0].length() > 0) {
                    verifiedHostNames.addAll(Arrays.asList(groups[0].split(";")));
                }
                if (groups.length > 1 && groups[1].length() > 0) {
                    unverifiedHostNames.addAll(Arrays.asList(groups[1].split(";")));
                }
                nodeStatus.setVerifiedHostNames(verifiedHostNames);
                nodeStatus.setUnverifiedHostNames(unverifiedHostNames);
            }
            return nodeStatus;
        }
        catch (NumberFormatException e) {
            log.error("Number format exception while parsing node status line '{}'. Skipping.", (Object)documentString, (Object)e);
            return null;
        }
        catch (Exception e) {
            log.error("Unknown exception while parsing node status line '{}'. Skipping.", (Object)documentString, (Object)e);
            return null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.isRelay ? "r" : "b");
        sb.append("\t").append(this.nickname);
        sb.append("\t").append(this.fingerprint);
        sb.append("\t").append(this.address).append(";");
        if (this.orAddressesAndPorts != null) {
            sb.append(StringUtils.join(this.orAddressesAndPorts, "+"));
        }
        sb.append(";");
        if (this.isRelay) {
            sb.append(StringUtils.join(this.exitAddresses, "+"));
        }
        sb.append("\t").append(DateTimeHelper.format(this.lastSeenMillis, "yyyy-MM-dd\tHH:mm:ss"));
        sb.append("\t").append(this.orPort);
        sb.append("\t").append(this.dirPort).append("\t");
        sb.append(StringUtils.join(this.getRelayFlags(), ","));
        if (this.isRelay) {
            sb.append("\t").append(String.valueOf(this.consensusWeight));
            sb.append("\t").append(this.countryCode != null ? this.countryCode : "??");
            sb.append("\t");
            sb.append("\t").append(String.valueOf(this.lastRdnsLookup));
            sb.append("\t").append(this.defaultPolicy != null ? this.defaultPolicy : "null");
            sb.append("\t").append(this.portList != null ? this.portList : "null");
        } else {
            sb.append("\t-1\t??\t\t-1\tnull\tnull");
        }
        sb.append("\t").append(DateTimeHelper.format(this.firstSeenMillis, "yyyy-MM-dd\tHH:mm:ss"));
        if (this.isRelay) {
            sb.append("\t").append(DateTimeHelper.format(this.getLastChangedOrAddressOrPort(), "yyyy-MM-dd\tHH:mm:ss"));
            sb.append("\t").append(this.asNumber != null ? this.asNumber : "null");
        } else {
            sb.append("\tnull\tnull\tnull");
        }
        sb.append("\t").append(this.contact != null ? this.contact : "");
        sb.append("\t").append(this.recommendedVersion == null ? "null" : (this.recommendedVersion != false ? "true" : "false"));
        sb.append("\t").append(StringUtils.join(this.getAllegedFamily(), ";")).append(":").append(StringUtils.join(this.getEffectiveFamily(), ";")).append(":").append(StringUtils.join(this.getIndirectFamily(), ";"));
        sb.append("\t").append(this.getVersion() != null ? this.getVersion() : "");
        sb.append("\t");
        sb.append("\t").append(null != this.getVersionStatus() ? this.getVersionStatus().getAbbreviation() : "");
        sb.append("\t").append(this.asName != null ? this.asName : "");
        sb.append("\t").append(this.verifiedHostNames != null ? StringUtils.join(this.getVerifiedHostNames(), ";") : "").append(":").append(this.unverifiedHostNames != null ? StringUtils.join(this.getUnverifiedHostNames(), ";") : "");
        return sb.toString();
    }
}

