/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.security;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import org.eclipse.jetty.util.resource.Resource;

public class CertificateUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getKeyStore(InputStream storeStream, String storePath, String storeType, String storeProvider, String storePassword) throws Exception {
        KeyStore keystore = null;
        if (storeStream != null || storePath != null) {
            try (InputStream inStream = storeStream;){
                if (inStream == null) {
                    inStream = Resource.newResource(storePath).getInputStream();
                }
                keystore = storeProvider != null ? KeyStore.getInstance(storeType, storeProvider) : KeyStore.getInstance(storeType);
                keystore.load(inStream, storePassword == null ? null : storePassword.toCharArray());
            }
        }
        return keystore;
    }

    public static Collection<? extends CRL> loadCRL(String crlPath) throws Exception {
        Collection<? extends CRL> crlList = null;
        if (crlPath != null) {
            try (InputStream in = null;){
                in = Resource.newResource(crlPath).getInputStream();
                crlList = CertificateFactory.getInstance("X.509").generateCRLs(in);
            }
        }
        return crlList;
    }
}

