/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.onionoo.writer;

import java.util.ArrayList;
import java.util.SortedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.onionoo.docs.DocumentStore;
import org.torproject.metrics.onionoo.docs.DocumentStoreFactory;
import org.torproject.metrics.onionoo.docs.NodeStatus;
import org.torproject.metrics.onionoo.docs.SummaryDocument;
import org.torproject.metrics.onionoo.util.FormattingUtils;
import org.torproject.metrics.onionoo.writer.DocumentWriter;

public class SummaryDocumentWriter
implements DocumentWriter {
    private static final Logger log = LoggerFactory.getLogger(SummaryDocumentWriter.class);
    private DocumentStore documentStore = DocumentStoreFactory.getDocumentStore();
    private int writtenDocuments = 0;
    private int deletedDocuments = 0;

    @Override
    public void writeDocuments(long mostRecentStatusMillis) {
        long relaysLastValidAfterMillis = -1L;
        long bridgesLastPublishedMillis = -1L;
        for (String fingerprint : this.documentStore.list(NodeStatus.class)) {
            NodeStatus nodeStatus = this.documentStore.retrieve(NodeStatus.class, true, fingerprint);
            if (nodeStatus == null) continue;
            if (nodeStatus.isRelay()) {
                relaysLastValidAfterMillis = Math.max(relaysLastValidAfterMillis, nodeStatus.getLastSeenMillis());
                continue;
            }
            bridgesLastPublishedMillis = Math.max(bridgesLastPublishedMillis, nodeStatus.getLastSeenMillis());
        }
        long cutoff = Math.max(relaysLastValidAfterMillis, bridgesLastPublishedMillis) - 604800000L;
        for (String fingerprint : this.documentStore.list(NodeStatus.class)) {
            Boolean recommendedVersion;
            SortedSet<String> unverifiedHostNames;
            SortedSet<String> verifiedHostNames;
            String operatingSystem;
            String version;
            NodeStatus nodeStatus = this.documentStore.retrieve(NodeStatus.class, true, fingerprint);
            if (nodeStatus == null) continue;
            if (nodeStatus.getLastSeenMillis() < cutoff) {
                if (!this.documentStore.remove(SummaryDocument.class, fingerprint)) continue;
                ++this.deletedDocuments;
                continue;
            }
            ArrayList<String> addresses = new ArrayList<String>();
            addresses.add(nodeStatus.getAddress());
            for (String orAddress : nodeStatus.getOrAddresses()) {
                if (addresses.contains(orAddress)) continue;
                addresses.add(orAddress);
            }
            for (String exitAddress : nodeStatus.getExitAddresses()) {
                if (addresses.contains(exitAddress)) continue;
                addresses.add(exitAddress);
            }
            long lastSeenMillis = nodeStatus.getLastSeenMillis();
            SortedSet<String> relayFlags = nodeStatus.getRelayFlags();
            boolean isRelay = nodeStatus.isRelay();
            boolean running = relayFlags.contains("Running") && (isRelay ? lastSeenMillis == relaysLastValidAfterMillis : lastSeenMillis == bridgesLastPublishedMillis);
            long consensusWeight = nodeStatus.getConsensusWeight();
            String countryCode = nodeStatus.getCountryCode();
            long firstSeenMillis = nodeStatus.getFirstSeenMillis();
            String asNumber = nodeStatus.getAsNumber();
            String asName = nodeStatus.getAsName();
            String contact = nodeStatus.getContact();
            SortedSet<String> declaredFamily = nodeStatus.getDeclaredFamily();
            SortedSet<String> effectiveFamily = nodeStatus.getEffectiveFamily();
            String nickname = nodeStatus.getNickname();
            SummaryDocument summaryDocument = new SummaryDocument(isRelay, nickname, fingerprint, addresses, lastSeenMillis, running, relayFlags, consensusWeight, countryCode, firstSeenMillis, asNumber, asName, contact, declaredFamily, effectiveFamily, version = nodeStatus.getVersion(), operatingSystem = nodeStatus.getOperatingSystem(), verifiedHostNames = nodeStatus.getVerifiedHostNames(), unverifiedHostNames = nodeStatus.getUnverifiedHostNames(), recommendedVersion = nodeStatus.isRecommendedVersion());
            if (!this.documentStore.store(summaryDocument, fingerprint)) continue;
            ++this.writtenDocuments;
        }
        log.info("Wrote summary document files");
    }

    @Override
    public String getStatsString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ").append(FormattingUtils.formatDecimalNumber(this.writtenDocuments)).append(" summary document files written\n");
        sb.append("    ").append(FormattingUtils.formatDecimalNumber(this.deletedDocuments)).append(" summary document files deleted\n");
        return sb.toString();
    }
}

