/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.onionoo.writer;

import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.torproject.metrics.onionoo.docs.GraphHistory;

public class GraphHistoryCompiler {
    private long graphsEndMillis;
    private boolean divisible = false;
    private long threshold = 5L;
    private List<String> graphNames = new ArrayList<String>();
    private List<Period> graphIntervals = new ArrayList<Period>();
    private List<Long> dataPointIntervals = new ArrayList<Long>();
    private Map<long[], Double> history = new LinkedHashMap<long[], Double>();

    GraphHistoryCompiler(long graphsEndMillis) {
        this.graphsEndMillis = graphsEndMillis;
    }

    void setDivisible(boolean divisible) {
        this.divisible = divisible;
    }

    void setThreshold(long threshold) {
        this.threshold = threshold;
    }

    void addGraphType(String graphName, Period graphInterval, Long dataPointInterval) {
        this.graphNames.add(graphName);
        this.graphIntervals.add(graphInterval);
        this.dataPointIntervals.add(dataPointInterval);
    }

    void addHistoryEntry(long startMillis, long endMillis, double value) {
        this.history.put(new long[]{startMillis, endMillis}, value);
    }

    Map<String, GraphHistory> compileGraphHistories() {
        LinkedHashMap<String, GraphHistory> graphs = new LinkedHashMap<String, GraphHistory>();
        for (int graphIntervalIndex = 0; graphIntervalIndex < this.graphIntervals.size(); ++graphIntervalIndex) {
            String graphName = this.graphNames.get(graphIntervalIndex);
            Period graphInterval = this.graphIntervals.get(graphIntervalIndex);
            long dataPointInterval = this.dataPointIntervals.get(graphIntervalIndex);
            long graphEndMillis = this.graphsEndMillis / dataPointInterval * dataPointInterval;
            long graphStartMillis = LocalDateTime.ofEpochSecond(graphEndMillis / 1000L, 0, ZoneOffset.UTC).minus(graphInterval).toEpochSecond(ZoneOffset.UTC) * 1000L / dataPointInterval * dataPointInterval;
            int dataPoints = (int)((graphEndMillis - graphStartMillis) / dataPointInterval);
            double[] totalValues = new double[dataPoints];
            long[] totalMillis = new long[dataPoints];
            for (Map.Entry<long[], Double> h : this.history.entrySet()) {
                long startMillis = h.getKey()[0];
                long endMillis = h.getKey()[1];
                double value = h.getValue();
                if (endMillis <= graphStartMillis || startMillis >= graphEndMillis || !this.divisible && endMillis - startMillis > dataPointInterval) continue;
                long intervalStartMillis = startMillis;
                while (intervalStartMillis < endMillis) {
                    int dataPointIndex = (int)((intervalStartMillis - graphStartMillis) / dataPointInterval);
                    if (dataPointIndex >= 0 && dataPointIndex < dataPoints) {
                        long intervalEndMillis = Math.min(endMillis, (intervalStartMillis + dataPointInterval) / dataPointInterval * dataPointInterval);
                        long millis = intervalEndMillis - intervalStartMillis;
                        int n = dataPointIndex;
                        totalValues[n] = totalValues[n] + value * (double)millis / (double)(endMillis - startMillis);
                        int n2 = dataPointIndex;
                        totalMillis[n2] = totalMillis[n2] + millis;
                    }
                    intervalStartMillis = (intervalStartMillis + dataPointInterval) / dataPointInterval * dataPointInterval;
                }
            }
            double maxValue = 0.0;
            int firstNonNullIndex = -1;
            int lastNonNullIndex = -1;
            boolean foundTwoAdjacentDataPoints = false;
            int previousNonNullIndex = -2;
            for (int dataPointIndex = 0; dataPointIndex < dataPoints; ++dataPointIndex) {
                if (totalMillis[dataPointIndex] * this.threshold < dataPointInterval) continue;
                if (firstNonNullIndex < 0) {
                    firstNonNullIndex = dataPointIndex;
                }
                lastNonNullIndex = dataPointIndex;
                if (dataPointIndex - previousNonNullIndex == 1) {
                    foundTwoAdjacentDataPoints = true;
                }
                previousNonNullIndex = dataPointIndex;
                maxValue = Math.max(maxValue, totalValues[dataPointIndex] / (double)totalMillis[dataPointIndex]);
            }
            if (!foundTwoAdjacentDataPoints) continue;
            long firstDataPointMillis = graphStartMillis + (long)firstNonNullIndex * dataPointInterval + dataPointInterval / 2L;
            if (graphIntervalIndex > 0 && !graphs.isEmpty() && firstDataPointMillis >= LocalDateTime.ofEpochSecond(graphEndMillis / 1000L, 0, ZoneOffset.UTC).minus(this.graphIntervals.get(graphIntervalIndex - 1)).toEpochSecond(ZoneOffset.UTC) * 1000L) continue;
            ArrayList<Integer> values = new ArrayList<Integer>();
            for (int dataPointIndex = firstNonNullIndex; dataPointIndex <= lastNonNullIndex; ++dataPointIndex) {
                if (totalMillis[dataPointIndex] * this.threshold >= dataPointInterval) {
                    values.add((int)(totalValues[dataPointIndex] * 999.0 / (maxValue * (double)totalMillis[dataPointIndex])));
                    continue;
                }
                values.add(null);
            }
            GraphHistory graphHistory = new GraphHistory();
            graphHistory.setFirst(firstDataPointMillis);
            graphHistory.setLast(firstDataPointMillis + (long)(lastNonNullIndex - firstNonNullIndex) * dataPointInterval);
            graphHistory.setInterval((int)(dataPointInterval / 1000L));
            graphHistory.setFactor(maxValue / 999.0);
            graphHistory.setCount(lastNonNullIndex - firstNonNullIndex + 1);
            graphHistory.setValues(values);
            graphs.put(graphName, graphHistory);
        }
        return graphs;
    }
}

