/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.onionoo.writer;

import java.time.Period;
import java.util.SortedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.onionoo.docs.ClientsDocument;
import org.torproject.metrics.onionoo.docs.ClientsHistory;
import org.torproject.metrics.onionoo.docs.ClientsStatus;
import org.torproject.metrics.onionoo.docs.DocumentStore;
import org.torproject.metrics.onionoo.docs.DocumentStoreFactory;
import org.torproject.metrics.onionoo.docs.UpdateStatus;
import org.torproject.metrics.onionoo.util.FormattingUtils;
import org.torproject.metrics.onionoo.writer.DocumentWriter;
import org.torproject.metrics.onionoo.writer.GraphHistoryCompiler;

public class ClientsDocumentWriter
implements DocumentWriter {
    private static final Logger log = LoggerFactory.getLogger(ClientsDocumentWriter.class);
    private DocumentStore documentStore;
    private int writtenDocuments = 0;
    private String[] graphNames = new String[]{"6_months", "1_year", "5_years"};
    private Period[] graphIntervals = new Period[]{Period.ofMonths(6), Period.ofYears(1), Period.ofYears(5)};
    private long[] dataPointIntervals = new long[]{86400000L, 172800000L, 864000000L};

    public ClientsDocumentWriter() {
        this.documentStore = DocumentStoreFactory.getDocumentStore();
    }

    @Override
    public void writeDocuments(long mostRecentStatusMillis) {
        UpdateStatus updateStatus = this.documentStore.retrieve(UpdateStatus.class, true);
        long updatedMillis = updateStatus != null ? updateStatus.getUpdatedMillis() : 0L;
        SortedSet<String> updateDocuments = this.documentStore.list(ClientsStatus.class, updatedMillis);
        for (String hashedFingerprint : updateDocuments) {
            ClientsStatus clientsStatus = this.documentStore.retrieve(ClientsStatus.class, true, hashedFingerprint);
            if (clientsStatus == null) continue;
            SortedSet<ClientsHistory> history = clientsStatus.getHistory();
            ClientsDocument clientsDocument = this.compileClientsDocument(hashedFingerprint, mostRecentStatusMillis, history);
            this.documentStore.store(clientsDocument, hashedFingerprint);
            ++this.writtenDocuments;
        }
        log.info("Wrote clients document files");
    }

    private ClientsDocument compileClientsDocument(String hashedFingerprint, long mostRecentStatusMillis, SortedSet<ClientsHistory> history) {
        ClientsDocument clientsDocument = new ClientsDocument();
        clientsDocument.setFingerprint(hashedFingerprint);
        GraphHistoryCompiler ghc = new GraphHistoryCompiler(mostRecentStatusMillis + 3600000L);
        ghc.setThreshold(2L);
        for (int i = 0; i < this.graphIntervals.length; ++i) {
            ghc.addGraphType(this.graphNames[i], this.graphIntervals[i], this.dataPointIntervals[i]);
        }
        for (ClientsHistory hist : history) {
            ghc.addHistoryEntry(hist.getStartMillis(), hist.getEndMillis(), hist.getTotalResponses() * 8.64E7 / 10.0);
        }
        clientsDocument.setAverageClients(ghc.compileGraphHistories());
        return clientsDocument;
    }

    @Override
    public String getStatsString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ").append(FormattingUtils.formatDecimalNumber(this.writtenDocuments)).append(" clients document files updated\n");
        return sb.toString();
    }
}

