/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.onionoo.updater;

import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.ExtraInfoDescriptor;
import org.torproject.metrics.onionoo.docs.ClientsHistory;
import org.torproject.metrics.onionoo.docs.ClientsStatus;
import org.torproject.metrics.onionoo.docs.DocumentStore;
import org.torproject.metrics.onionoo.docs.DocumentStoreFactory;
import org.torproject.metrics.onionoo.docs.NodeStatus;
import org.torproject.metrics.onionoo.updater.DescriptorListener;
import org.torproject.metrics.onionoo.updater.DescriptorSource;
import org.torproject.metrics.onionoo.updater.DescriptorSourceFactory;
import org.torproject.metrics.onionoo.updater.DescriptorType;
import org.torproject.metrics.onionoo.updater.StatusUpdater;
import org.torproject.metrics.onionoo.util.FormattingUtils;

public class ClientsStatusUpdater
implements DescriptorListener,
StatusUpdater {
    private DescriptorSource descriptorSource;
    private DocumentStore documentStore;
    private SortedMap<String, SortedSet<ClientsHistory>> newResponses = new TreeMap<String, SortedSet<ClientsHistory>>();

    public ClientsStatusUpdater() {
        this.descriptorSource = DescriptorSourceFactory.getDescriptorSource();
        this.documentStore = DocumentStoreFactory.getDocumentStore();
        this.registerDescriptorListeners();
    }

    private void registerDescriptorListeners() {
        this.descriptorSource.registerDescriptorListener(this, DescriptorType.BRIDGE_EXTRA_INFOS);
    }

    @Override
    public void processDescriptor(Descriptor descriptor, boolean relay) {
        if (descriptor instanceof ExtraInfoDescriptor && !relay) {
            this.processBridgeExtraInfoDescriptor((ExtraInfoDescriptor)descriptor);
        }
    }

    private void processBridgeExtraInfoDescriptor(ExtraInfoDescriptor descriptor) {
        long dirreqStatsEndMillis = descriptor.getDirreqStatsEndMillis();
        long dirreqStatsIntervalLengthMillis = descriptor.getDirreqStatsIntervalLength() * 1000L;
        SortedMap responses = descriptor.getDirreqV3Resp();
        if (dirreqStatsEndMillis < 0L || dirreqStatsIntervalLengthMillis != 86400000L || responses == null || !responses.containsKey("ok")) {
            return;
        }
        double okResponses = (Integer)responses.get("ok") - 4;
        if (okResponses < 0.0) {
            return;
        }
        String hashedFingerprint = descriptor.getFingerprint().toUpperCase();
        long dirreqStatsStartMillis = dirreqStatsEndMillis - dirreqStatsIntervalLengthMillis;
        long utcBreakMillis = dirreqStatsEndMillis / 86400000L * 86400000L;
        for (int i = 0; i < 2; ++i) {
            long endMillis;
            long startMillis = i == 0 ? dirreqStatsStartMillis : utcBreakMillis;
            long l = endMillis = i == 0 ? utcBreakMillis : dirreqStatsEndMillis;
            if (startMillis >= endMillis) continue;
            double totalResponses = okResponses * (double)(endMillis - startMillis) / 8.64E7;
            SortedMap<String, Double> responsesByCountry = this.weightResponsesWithUniqueIps(totalResponses, descriptor.getBridgeIps(), "??");
            SortedMap<String, Double> responsesByTransport = this.weightResponsesWithUniqueIps(totalResponses, descriptor.getBridgeIpTransports(), "<??>");
            SortedMap<String, Double> responsesByVersion = this.weightResponsesWithUniqueIps(totalResponses, descriptor.getBridgeIpVersions(), "");
            ClientsHistory newResponseHistory = new ClientsHistory(startMillis, endMillis, totalResponses, responsesByCountry, responsesByTransport, responsesByVersion);
            this.newResponses.putIfAbsent(hashedFingerprint, new TreeSet());
            ((SortedSet)this.newResponses.get(hashedFingerprint)).add(newResponseHistory);
        }
    }

    private SortedMap<String, Double> weightResponsesWithUniqueIps(double totalResponses, SortedMap<String, Integer> uniqueIps, String omitString) {
        TreeMap<String, Double> weightedResponses = new TreeMap<String, Double>();
        int totalUniqueIps = 0;
        if (uniqueIps != null) {
            for (Map.Entry<String, Integer> e : uniqueIps.entrySet()) {
                if (e.getValue() <= 4) continue;
                totalUniqueIps += e.getValue() - 4;
            }
        }
        if (totalUniqueIps > 0) {
            for (Map.Entry<String, Integer> e : uniqueIps.entrySet()) {
                if (e.getKey().equals(omitString) || e.getValue() <= 4) continue;
                weightedResponses.put(e.getKey(), (double)(e.getValue() - 4) * totalResponses / (double)totalUniqueIps);
            }
        }
        return weightedResponses;
    }

    @Override
    public void updateStatuses() {
        for (Map.Entry<String, SortedSet<ClientsHistory>> e : this.newResponses.entrySet()) {
            String hashedFingerprint = e.getKey();
            ClientsStatus clientsStatus = this.documentStore.retrieve(ClientsStatus.class, true, hashedFingerprint);
            if (clientsStatus == null) {
                clientsStatus = new ClientsStatus();
            }
            clientsStatus.addToHistory(e.getValue());
            if (!clientsStatus.isDirty()) continue;
            NodeStatus nodeStatus = this.documentStore.retrieve(NodeStatus.class, true, hashedFingerprint);
            if (null != nodeStatus) {
                clientsStatus.compressHistory(nodeStatus.getLastSeenMillis());
            }
            this.documentStore.store(clientsStatus, hashedFingerprint);
            clientsStatus.clearDirty();
        }
    }

    @Override
    public String getStatsString() {
        int newIntervals = 0;
        for (SortedSet<ClientsHistory> hist : this.newResponses.values()) {
            newIntervals += hist.size();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("    ").append(FormattingUtils.formatDecimalNumber(newIntervals / 2)).append(" client statistics processed from extra-info descriptors\n");
        sb.append("    ").append(FormattingUtils.formatDecimalNumber(this.newResponses.size())).append(" client status files updated\n");
        return sb.toString();
    }
}

