/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.onionoo.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

class MostFrequentString {
    Map<String, Integer> stringFrequencies = new HashMap<String, Integer>();

    MostFrequentString() {
    }

    void addString(String string) {
        this.stringFrequencies.put(string, this.stringFrequencies.getOrDefault(string, 0) + 1);
    }

    public String toString() {
        TreeMap sortedFrequencies = new TreeMap(Collections.reverseOrder());
        if (this.stringFrequencies.isEmpty()) {
            return "null (0)";
        }
        for (Map.Entry<String, Integer> e : this.stringFrequencies.entrySet()) {
            sortedFrequencies.putIfAbsent(e.getValue(), new TreeSet());
            ((SortedSet)sortedFrequencies.get(e.getValue())).add(e.getKey());
        }
        StringBuilder sb = new StringBuilder();
        int stringsToAdd = 3;
        int written = 0;
        TreeSet<String> remainingStrings = new TreeSet<String>();
        for (Map.Entry e : sortedFrequencies.entrySet()) {
            for (String string : (SortedSet)e.getValue()) {
                if (stringsToAdd-- > 0) {
                    sb.append(written++ > 0 ? ", " : "").append(string).append(" (").append(e.getKey()).append(")");
                    continue;
                }
                remainingStrings.add(string);
            }
        }
        for (String string : remainingStrings) {
            sb.append(", ").append(string);
        }
        return sb.toString();
    }

    void clear() {
        this.stringFrequencies.clear();
    }
}

