/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.onionoo.docs;

import java.util.Map;
import java.util.Scanner;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.BandwidthHistory;
import org.torproject.metrics.onionoo.docs.DateTimeHelper;
import org.torproject.metrics.onionoo.docs.Document;

public class BandwidthStatus
extends Document {
    private static Logger log = LoggerFactory.getLogger(BandwidthStatus.class);
    private transient boolean isDirty = false;
    private SortedMap<Long, long[]> writeHistory = new TreeMap<Long, long[]>();
    private SortedMap<Long, long[]> readHistory = new TreeMap<Long, long[]>();

    public boolean isDirty() {
        return this.isDirty;
    }

    public void clearDirty() {
        this.isDirty = false;
    }

    public void setWriteHistory(SortedMap<Long, long[]> writeHistory) {
        this.writeHistory = writeHistory;
    }

    public SortedMap<Long, long[]> getWriteHistory() {
        return this.writeHistory;
    }

    public void setReadHistory(SortedMap<Long, long[]> readHistory) {
        this.readHistory = readHistory;
    }

    public SortedMap<Long, long[]> getReadHistory() {
        return this.readHistory;
    }

    @Override
    public void setFromDocumentString(String documentString) {
        try (Scanner s = new Scanner(documentString);){
            while (s.hasNextLine()) {
                long nextStartMillis;
                String line = s.nextLine();
                String[] parts = line.split(" ");
                if (parts.length != 6) {
                    log.error("Illegal line '{}' in bandwidth history. Skipping this line.", (Object)line);
                    continue;
                }
                SortedMap<Long, long[]> history = parts[0].equals("r") ? this.readHistory : this.writeHistory;
                long startMillis = DateTimeHelper.parse(parts[1] + " " + parts[2]);
                long endMillis = DateTimeHelper.parse(parts[3] + " " + parts[4]);
                if (startMillis < 0L || endMillis < 0L) {
                    log.error("Could not parse timestamp while reading bandwidth history.  Skipping.");
                    break;
                }
                long bandwidth = Long.parseLong(parts[5]);
                long previousEndMillis = history.headMap(startMillis).isEmpty() ? startMillis : ((long[])history.get(history.headMap(startMillis).lastKey()))[1];
                long l = nextStartMillis = history.tailMap(startMillis).isEmpty() ? endMillis : history.tailMap(startMillis).firstKey();
                if (previousEndMillis > startMillis || nextStartMillis < endMillis) continue;
                history.put(startMillis, new long[]{startMillis, endMillis, bandwidth});
            }
        }
    }

    public void addToWriteHistory(BandwidthHistory bandwidthHistory) {
        this.addToHistory(this.writeHistory, bandwidthHistory);
    }

    public void addToReadHistory(BandwidthHistory bandwidthHistory) {
        this.addToHistory(this.readHistory, bandwidthHistory);
    }

    private void addToHistory(SortedMap<Long, long[]> history, BandwidthHistory bandwidthHistory) {
        long intervalMillis = bandwidthHistory.getIntervalLength() * 1000L;
        for (Map.Entry e : bandwidthHistory.getBandwidthValues().entrySet()) {
            long endMillis = (Long)e.getKey();
            long startMillis = endMillis - intervalMillis;
            long bandwidthValue = (Long)e.getValue();
            history.put(startMillis, new long[]{startMillis, endMillis, bandwidthValue});
            this.isDirty = true;
        }
    }

    public void compressHistory(long lastSeenMillis) {
        this.compressHistory(this.writeHistory, lastSeenMillis);
        this.compressHistory(this.readHistory, lastSeenMillis);
    }

    private void compressHistory(SortedMap<Long, long[]> history, long lastSeenMillis) {
        TreeMap<Long, long[]> uncompressedHistory = new TreeMap<Long, long[]>(history);
        history.clear();
        long lastStartMillis = 0L;
        long lastEndMillis = 0L;
        long lastBandwidth = 0L;
        String lastMonthString = "1970-01";
        for (long[] v : uncompressedHistory.values()) {
            long startMillis = v[0];
            long endMillis = v[1];
            long bandwidth = v[2];
            long intervalLengthMillis = lastSeenMillis - endMillis <= 259200000L ? 900000L : (lastSeenMillis - endMillis <= 604800000L ? 3600000L : (lastSeenMillis - endMillis <= 2678400000L ? 14400000L : (lastSeenMillis - endMillis <= 15811200000L ? 86400000L : (lastSeenMillis - endMillis <= 31622400000L ? 172800000L : 864000000L))));
            String monthString = DateTimeHelper.format(startMillis, "yyyy-MM");
            if (lastEndMillis == startMillis && (lastEndMillis - 1L) / intervalLengthMillis == (endMillis - 1L) / intervalLengthMillis && lastMonthString.equals(monthString)) {
                lastEndMillis = endMillis;
                lastBandwidth += bandwidth;
            } else {
                if (lastStartMillis > 0L) {
                    history.put(lastStartMillis, new long[]{lastStartMillis, lastEndMillis, lastBandwidth});
                }
                lastStartMillis = startMillis;
                lastEndMillis = endMillis;
                lastBandwidth = bandwidth;
            }
            lastMonthString = monthString;
        }
        if (lastStartMillis > 0L) {
            history.put(lastStartMillis, new long[]{lastStartMillis, lastEndMillis, lastBandwidth});
        }
    }

    @Override
    public String toDocumentString() {
        StringBuilder sb = new StringBuilder();
        for (long[] v : this.writeHistory.values()) {
            sb.append("w ").append(DateTimeHelper.format(v[0])).append(" ").append(DateTimeHelper.format(v[1])).append(" ").append(String.valueOf(v[2])).append("\n");
        }
        for (long[] v : this.readHistory.values()) {
            sb.append("r ").append(DateTimeHelper.format(v[0])).append(" ").append(DateTimeHelper.format(v[1])).append(" ").append(String.valueOf(v[2])).append("\n");
        }
        return sb.toString();
    }
}

