/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.updater;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.torproject.onionoo.updater.RdnsLookupRequest;
import org.torproject.onionoo.updater.ReverseDomainNameResolver;

class RdnsLookupWorker
extends Thread {
    private final ReverseDomainNameResolver reverseDomainNameResolver;

    RdnsLookupWorker(ReverseDomainNameResolver reverseDomainNameResolver) {
        this.reverseDomainNameResolver = reverseDomainNameResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (System.currentTimeMillis() - 300000L <= this.reverseDomainNameResolver.startedRdnsLookups) {
            long lookupMillis;
            List<String> unverifiedHostNames;
            List<String> verifiedHostNames;
            Object job;
            String rdnsLookupJob = null;
            Set<String> set = this.reverseDomainNameResolver.rdnsLookupJobs;
            synchronized (set) {
                Iterator<String> iterator = this.reverseDomainNameResolver.rdnsLookupJobs.iterator();
                if (iterator.hasNext()) {
                    job = iterator.next();
                    rdnsLookupJob = job;
                    this.reverseDomainNameResolver.rdnsLookupJobs.remove(job);
                }
            }
            if (rdnsLookupJob == null) break;
            RdnsLookupRequest request = new RdnsLookupRequest(this, rdnsLookupJob);
            request.setDaemon(true);
            request.start();
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            String hostName = request.getHostName();
            if (null != hostName) {
                job = this.reverseDomainNameResolver.rdnsLookupResults;
                synchronized (job) {
                    this.reverseDomainNameResolver.rdnsLookupResults.put(rdnsLookupJob, hostName);
                }
            }
            if (null != (verifiedHostNames = request.getVerifiedHostNames()) && !verifiedHostNames.isEmpty()) {
                Map<String, List<String>> map = this.reverseDomainNameResolver.rdnsVerifiedLookupResults;
                synchronized (map) {
                    this.reverseDomainNameResolver.rdnsVerifiedLookupResults.put(rdnsLookupJob, verifiedHostNames);
                }
            }
            if (null != (unverifiedHostNames = request.getUnverifiedHostNames()) && !unverifiedHostNames.isEmpty()) {
                Map<String, List<String>> map = this.reverseDomainNameResolver.rdnsUnverifiedLookupResults;
                synchronized (map) {
                    this.reverseDomainNameResolver.rdnsUnverifiedLookupResults.put(rdnsLookupJob, unverifiedHostNames);
                }
            }
            if ((lookupMillis = request.getLookupMillis()) < 0L) continue;
            List<Long> list = this.reverseDomainNameResolver.rdnsLookupMillis;
            synchronized (list) {
                this.reverseDomainNameResolver.rdnsLookupMillis.add(lookupMillis);
            }
        }
    }
}

