/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.updater;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.TreeSet;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.torproject.onionoo.updater.RdnsLookupWorker;

class RdnsLookupRequest
extends Thread {
    private RdnsLookupWorker parent;
    private String address;
    private List<String> verifiedHostNames;
    private List<String> unverifiedHostNames;
    private long lookupStartedMillis = -1L;
    private long lookupCompletedMillis = -1L;

    public RdnsLookupRequest(RdnsLookupWorker parent, String address) {
        this.parent = parent;
        this.address = address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.lookupStartedMillis = System.currentTimeMillis();
        try {
            ArrayList<String> verifiedResults = new ArrayList<String>();
            ArrayList<String> unverifiedResults = new ArrayList<String>();
            String[] bytes = this.address.split("\\.");
            if (bytes.length == 4) {
                String[] reverseDnsRecords;
                String reverseDnsDomain = bytes[3] + "." + bytes[2] + "." + bytes[1] + "." + bytes[0] + ".in-addr.arpa";
                for (String reverseDnsRecord : reverseDnsRecords = this.getRecords(reverseDnsDomain, "PTR")) {
                    String[] forwardDnsRecords;
                    boolean verified = false;
                    for (String forwardDnsRecord : forwardDnsRecords = this.getRecords(reverseDnsRecord, "A")) {
                        if (!forwardDnsRecord.equals(this.address)) continue;
                        verified = true;
                        break;
                    }
                    if (verified) {
                        verifiedResults.add(reverseDnsRecord.substring(0, reverseDnsRecord.length() - 1));
                        continue;
                    }
                    unverifiedResults.add(reverseDnsRecord.substring(0, reverseDnsRecord.length() - 1));
                }
            }
            RdnsLookupRequest rdnsLookupRequest = this;
            synchronized (rdnsLookupRequest) {
                this.verifiedHostNames = verifiedResults;
                this.unverifiedHostNames = unverifiedResults;
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        this.lookupCompletedMillis = System.currentTimeMillis();
        this.parent.interrupt();
    }

    public String[] getRecords(String hostName, String type) throws NamingException {
        Attribute dnsAttribute;
        Hashtable<String, String> envProps = new Hashtable<String, String>();
        envProps.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        InitialDirContext dnsContext = new InitialDirContext(envProps);
        TreeSet<String> results = new TreeSet<String>();
        Attributes dnsEntries = dnsContext.getAttributes(hostName, new String[]{type});
        if (dnsEntries != null && (dnsAttribute = dnsEntries.get(type)) != null) {
            NamingEnumeration<?> dnsEntryIterator = dnsEntries.get(type).getAll();
            while (dnsEntryIterator.hasMoreElements()) {
                results.add(dnsEntryIterator.next().toString());
            }
        }
        return results.toArray(new String[results.size()]);
    }

    public synchronized String getHostName() {
        List<String> verifiedHostNames = this.verifiedHostNames;
        if (null != verifiedHostNames && !verifiedHostNames.isEmpty()) {
            return verifiedHostNames.get(0);
        }
        return null;
    }

    public synchronized List<String> getVerifiedHostNames() {
        return this.verifiedHostNames;
    }

    public synchronized List<String> getUnverifiedHostNames() {
        return this.unverifiedHostNames;
    }

    public synchronized long getLookupMillis() {
        return this.lookupCompletedMillis - this.lookupStartedMillis;
    }
}

