/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.torproject.onionoo.server.HttpServletRequestWrapper;
import org.torproject.onionoo.server.HttpServletResponseWrapper;
import org.torproject.onionoo.server.NodeIndex;
import org.torproject.onionoo.server.NodeIndexerFactory;
import org.torproject.onionoo.server.PerformanceMetrics;
import org.torproject.onionoo.server.RequestHandler;
import org.torproject.onionoo.server.ResponseBuilder;

public class ResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = 7236658979947465319L;
    private boolean maintenanceMode = false;
    private static final long INDEX_WAITING_TIME = 10000L;
    private static final long CACHE_MIN_TIME = 300000L;
    private static final long CACHE_MAX_TIME = 2700000L;
    private static final long CACHE_INTERVAL = 300000L;
    private static Set<String> knownParameters = new HashSet<String>(Arrays.asList("type", "running", "search", "lookup", "fingerprint", "country", "as", "as_name", "flag", "first_seen_days", "last_seen_days", "contact", "order", "limit", "offset", "fields", "family", "version", "os", "host_name", "recommended_version"));
    private static Set<String> illegalSearchQualifiers = new HashSet<String>(Arrays.asList("search,fingerprint,order,limit,offset,fields".split(",")));
    private static String ipv6AddressPatternString = "^\\[?[0-9a-fA-F:\\.]{1,39}\\]?$";
    private static Pattern ipv6AddressPattern = Pattern.compile(ipv6AddressPatternString);
    private static Pattern searchQueryStringPattern = Pattern.compile("(?:.*[\\?&])*?search=([\\p{Graph} &&[^&]]+)(?:&.*)*");
    private static Pattern searchParameterPattern = Pattern.compile("^\\$?[0-9a-fA-F]{1,40}$|^[0-9a-zA-Z+/]{1,27}$|^[0-9a-zA-Z\\.]{1,19}$|" + ipv6AddressPatternString + "|^[a-zA-Z_]+:\"?[\\p{Graph} ]+\"?$");
    private static Pattern fingerprintParameterPattern = Pattern.compile("((^|,)[0-9a-zA-Z]{40})+$");
    private static Pattern countryCodeParameterPattern = Pattern.compile("^[0-9a-zA-Z]{2}$");
    private static Pattern asNumberParameterPattern = Pattern.compile("((^|,)([aA][sS])?[1-9][0-9]{0,9})+$");
    private static Pattern flagPattern = Pattern.compile("^[a-zA-Z0-9]{1,20}$");
    private static Pattern daysPattern = Pattern.compile("^[0-9-]{1,10}$");
    private static Pattern orderParameterPattern = Pattern.compile("^[0-9a-zA-Z_,-]*$");
    private static HashSet<String> knownOrderParameters = new HashSet<String>(Arrays.asList("consensus_weight", "-consensus_weight", "first_seen", "-first_seen"));
    private static Pattern fieldsParameterPattern = Pattern.compile("^[0-9a-zA-Z_,]*$");
    private static Pattern versionParameterPattern = Pattern.compile("^[0-9a-zA-Z\\.-]+$");
    private static Pattern hostNameParameterPattern = Pattern.compile("^[0-9A-Za-z_\\.\\-]+$");

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.maintenanceMode = config.getInitParameter("maintenance") != null && config.getInitParameter("maintenance").equals("1");
    }

    public long getLastModified(HttpServletRequest request) {
        if (this.maintenanceMode) {
            return super.getLastModified(request);
        }
        return NodeIndexerFactory.getNodeIndexer().getLastIndexed(10000L);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpServletRequestWrapper requestWrapper = new HttpServletRequestWrapper(request);
        HttpServletResponseWrapper responseWrapper = new HttpServletResponseWrapper(response);
        this.doGet(requestWrapper, responseWrapper);
    }

    public void doGet(HttpServletRequestWrapper request, HttpServletResponseWrapper response) throws IOException {
        this.doGet(request, response, System.currentTimeMillis());
    }

    public void doGet(HttpServletRequestWrapper request, HttpServletResponseWrapper response, long receivedRequestMillis) throws IOException {
        int[] days;
        if (this.maintenanceMode) {
            response.sendError(503);
            return;
        }
        NodeIndex nodeIndex = NodeIndexerFactory.getNodeIndexer().getLatestNodeIndex(10000L);
        if (nodeIndex == null) {
            response.sendError(500);
            return;
        }
        String uri = request.getRequestURI();
        if (uri.startsWith("/onionoo/")) {
            uri = uri.substring("/onionoo".length());
        }
        String resourceType = null;
        if (uri.startsWith("/summary")) {
            resourceType = "summary";
        } else if (uri.startsWith("/details")) {
            resourceType = "details";
        } else if (uri.startsWith("/bandwidth")) {
            resourceType = "bandwidth";
        } else if (uri.startsWith("/weights")) {
            resourceType = "weights";
        } else if (uri.startsWith("/clients")) {
            resourceType = "clients";
        } else if (uri.startsWith("/uptime")) {
            resourceType = "uptime";
        } else {
            response.sendError(400);
            return;
        }
        RequestHandler rh = new RequestHandler(nodeIndex);
        rh.setResourceType(resourceType);
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        for (Object parameterKey : request.getParameterMap().keySet()) {
            String[] parameterValues = request.getParameterValues((String)parameterKey);
            parameterMap.put((String)parameterKey, parameterValues[0]);
        }
        for (Object parameterKey : parameterMap.keySet()) {
            if (knownParameters.contains(parameterKey)) continue;
            response.sendError(400);
            return;
        }
        if (parameterMap.containsKey("search")) {
            String[] searchTerms = ResourceServlet.parseSearchParameters(request.getQueryString());
            if (searchTerms == null) {
                response.sendError(400);
                return;
            }
            ArrayList<String> unqualifiedSearchTerms = new ArrayList<String>();
            for (String searchTerm : searchTerms) {
                if (searchTerm.contains(":")) {
                    String[] parts = searchTerm.split(":", 2);
                    String parameterKey = parts[0];
                    if (!knownParameters.contains(parameterKey) || illegalSearchQualifiers.contains(parameterKey)) {
                        if (ipv6AddressPattern.matcher(parameterKey).matches()) {
                            unqualifiedSearchTerms.add(searchTerm);
                        } else {
                            response.sendError(400);
                            return;
                        }
                    }
                    if (parameterMap.containsKey(parameterKey)) continue;
                    String parameterValue = parts[1];
                    if (parameterValue.startsWith("\"") && parameterValue.endsWith("\"")) {
                        parameterValue = parameterValue.substring(1, parameterValue.length() - 1).replaceAll("\\\\\"", "\"");
                    }
                    parameterMap.put(parameterKey, parameterValue);
                    continue;
                }
                unqualifiedSearchTerms.add(searchTerm);
            }
            rh.setSearch(unqualifiedSearchTerms.toArray(new String[unqualifiedSearchTerms.size()]));
        }
        if (parameterMap.containsKey("type")) {
            String typeParameterValue = ((String)parameterMap.get("type")).toLowerCase();
            boolean relaysRequested = true;
            if (typeParameterValue.equals("bridge")) {
                relaysRequested = false;
            } else if (!typeParameterValue.equals("relay")) {
                response.sendError(400);
                return;
            }
            rh.setType(relaysRequested ? "relay" : "bridge");
        }
        if (parameterMap.containsKey("running")) {
            String runningParameterValue = ((String)parameterMap.get("running")).toLowerCase();
            boolean runningRequested = true;
            if (runningParameterValue.equals("false")) {
                runningRequested = false;
            } else if (!runningParameterValue.equals("true")) {
                response.sendError(400);
                return;
            }
            rh.setRunning(runningRequested ? "true" : "false");
        }
        if (parameterMap.containsKey("lookup")) {
            String[] lookupParameter = this.parseFingerprintParameter((String)parameterMap.get("lookup"));
            if (lookupParameter == null) {
                response.sendError(400);
                return;
            }
            rh.setLookup(lookupParameter);
        }
        if (parameterMap.containsKey("fingerprint")) {
            String[] fingerprintParameter = this.parseFingerprintParameter((String)parameterMap.get("fingerprint"));
            if (null == fingerprintParameter || 1 != fingerprintParameter.length) {
                response.sendError(400);
                return;
            }
            rh.setFingerprint(fingerprintParameter[0]);
        }
        if (parameterMap.containsKey("country")) {
            String countryCodeParameter = this.parseCountryCodeParameter((String)parameterMap.get("country"));
            if (countryCodeParameter == null) {
                response.sendError(400);
                return;
            }
            rh.setCountry(countryCodeParameter);
        }
        if (parameterMap.containsKey("as")) {
            String[] asNumberParameter = this.parseAsNumberParameter((String)parameterMap.get("as"));
            if (asNumberParameter == null) {
                response.sendError(400);
                return;
            }
            rh.setAs(asNumberParameter);
        }
        if (parameterMap.containsKey("as_name")) {
            String[] asNameParameter = this.parseAsNameParameter((String)parameterMap.get("as_name"));
            if (null == asNameParameter) {
                response.sendError(400);
                return;
            }
            rh.setAsName(asNameParameter);
        }
        if (parameterMap.containsKey("flag")) {
            String flagParameter = this.parseFlagParameter((String)parameterMap.get("flag"));
            if (flagParameter == null) {
                response.sendError(400);
                return;
            }
            rh.setFlag(flagParameter);
        }
        if (parameterMap.containsKey("first_seen_days")) {
            days = this.parseDaysParameter((String)parameterMap.get("first_seen_days"));
            if (days == null) {
                response.sendError(400);
                return;
            }
            rh.setFirstSeenDays(days);
        }
        if (parameterMap.containsKey("last_seen_days")) {
            days = this.parseDaysParameter((String)parameterMap.get("last_seen_days"));
            if (days == null) {
                response.sendError(400);
                return;
            }
            rh.setLastSeenDays(days);
        }
        if (parameterMap.containsKey("contact")) {
            String[] contactParts = this.parseContactParameter((String)parameterMap.get("contact"));
            if (contactParts == null) {
                response.sendError(400);
                return;
            }
            rh.setContact(contactParts);
        }
        if (parameterMap.containsKey("version")) {
            String versionParameter = this.parseVersionParameter((String)parameterMap.get("version"));
            if (null == versionParameter) {
                response.sendError(400);
                return;
            }
            rh.setVersion(versionParameter);
        }
        if (parameterMap.containsKey("os")) {
            String osParameter = this.parseOperatingSystemParameter((String)parameterMap.get("os"));
            if (null == osParameter) {
                response.sendError(400);
                return;
            }
            rh.setOperatingSystem(osParameter);
        }
        if (parameterMap.containsKey("host_name")) {
            String hostNameParameter = this.parseHostNameParameter((String)parameterMap.get("host_name"));
            if (null == hostNameParameter) {
                response.sendError(400);
                return;
            }
            rh.setHostName(hostNameParameter);
        }
        if (parameterMap.containsKey("recommended_version")) {
            String recommendedVersionParameterValue = ((String)parameterMap.get("recommended_version")).toLowerCase();
            boolean recommendedVersionRequested = true;
            if (recommendedVersionParameterValue.equals("false")) {
                recommendedVersionRequested = false;
            } else if (!recommendedVersionParameterValue.equals("true")) {
                response.sendError(400);
                return;
            }
            rh.setRecommendedVersion(recommendedVersionRequested);
        }
        if (parameterMap.containsKey("order")) {
            String[] order = this.parseOrderParameter((String)parameterMap.get("order"));
            if (order == null) {
                response.sendError(400);
                return;
            }
            rh.setOrder(order);
        }
        if (parameterMap.containsKey("offset")) {
            String offsetParameter = (String)parameterMap.get("offset");
            if (offsetParameter.length() > 6) {
                response.sendError(400);
                return;
            }
            try {
                Integer.parseInt(offsetParameter);
            }
            catch (NumberFormatException e) {
                response.sendError(400);
                return;
            }
            rh.setOffset(offsetParameter);
        }
        if (parameterMap.containsKey("limit")) {
            String limitParameter = (String)parameterMap.get("limit");
            if (limitParameter.length() > 6) {
                response.sendError(400);
                return;
            }
            try {
                Integer.parseInt(limitParameter);
            }
            catch (NumberFormatException e) {
                response.sendError(400);
                return;
            }
            rh.setLimit(limitParameter);
        }
        if (parameterMap.containsKey("family")) {
            String[] familyParameter = this.parseFingerprintParameter((String)parameterMap.get("family"));
            if (null == familyParameter || 1 != familyParameter.length) {
                response.sendError(400);
                return;
            }
            rh.setFamily(familyParameter[0]);
        }
        rh.handleRequest();
        long parsedRequestMillis = System.currentTimeMillis();
        ResponseBuilder rb = new ResponseBuilder();
        rb.setResourceType(resourceType);
        rb.setRelaysPublishedString(rh.getRelaysPublishedString());
        rb.setBridgesPublishedString(rh.getBridgesPublishedString());
        rb.setOrderedRelays(rh.getOrderedRelays());
        rb.setOrderedBridges(rh.getOrderedBridges());
        rb.setRelaysSkipped(rh.getRelaysSkipped());
        rb.setBridgesSkipped(rh.getBridgesSkipped());
        rb.setRelaysTruncated(rh.getRelaysTruncated());
        rb.setBridgesTruncated(rh.getBridgesTruncated());
        String[] fields = null;
        if (parameterMap.containsKey("fields")) {
            fields = this.parseFieldsParameter((String)parameterMap.get("fields"));
            if (fields == null) {
                response.sendError(400);
                return;
            }
            rb.setFields(fields);
        }
        long indexWrittenMillis = NodeIndexerFactory.getNodeIndexer().getLastIndexed(10000L);
        long indexAgeMillis = receivedRequestMillis - indexWrittenMillis;
        long cacheMaxAgeMillis = Math.max(300000L, (2700000L - indexAgeMillis) / 300000L * 300000L);
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        response.setHeader("Cache-Control", "public, max-age=" + cacheMaxAgeMillis / 1000L);
        try (PrintWriter pw = response.getWriter();){
            rb.buildResponse(pw);
        }
        int relayDocumentsWritten = rh.getOrderedRelays().size();
        int bridgeDocumentsWritten = rh.getOrderedBridges().size();
        int charsWritten = rb.getCharsWritten();
        long writtenResponseMillis = System.currentTimeMillis();
        PerformanceMetrics.logStatistics(receivedRequestMillis, resourceType, parameterMap.keySet(), parsedRequestMillis, relayDocumentsWritten, bridgeDocumentsWritten, charsWritten, writtenResponseMillis);
    }

    protected static String[] parseSearchParameters(String queryString) {
        Matcher searchQueryStringMatcher = searchQueryStringPattern.matcher(queryString);
        if (!searchQueryStringMatcher.matches()) {
            return null;
        }
        String parameter = searchQueryStringMatcher.group(1);
        String[] spaceSeparatedParts = parameter.replaceAll("%20", " ").split(" ");
        ArrayList<String> searchParameters = new ArrayList<String>();
        StringBuilder doubleQuotedSearchTerm = null;
        for (String spaceSeparatedPart : spaceSeparatedParts) {
            if ((StringUtils.countMatches((CharSequence)spaceSeparatedPart, (char)'\"') - StringUtils.countMatches((CharSequence)spaceSeparatedPart, (CharSequence)"\\\"")) % 2 == 0) {
                if (null == doubleQuotedSearchTerm) {
                    searchParameters.add(spaceSeparatedPart);
                    continue;
                }
                doubleQuotedSearchTerm.append(' ').append(spaceSeparatedPart);
                continue;
            }
            if (null == doubleQuotedSearchTerm) {
                doubleQuotedSearchTerm = new StringBuilder(spaceSeparatedPart);
                continue;
            }
            doubleQuotedSearchTerm.append(' ').append(spaceSeparatedPart);
            searchParameters.add(doubleQuotedSearchTerm.toString());
            doubleQuotedSearchTerm = null;
        }
        if (null != doubleQuotedSearchTerm) {
            return null;
        }
        for (String searchParameter : searchParameters) {
            if (searchParameterPattern.matcher(searchParameter).matches()) continue;
            return null;
        }
        return searchParameters.toArray(new String[0]);
    }

    private String[] parseFingerprintParameter(String parameter) {
        if (!fingerprintParameterPattern.matcher(parameter).matches()) {
            return null;
        }
        return parameter.toUpperCase().split(",");
    }

    private String parseCountryCodeParameter(String parameter) {
        if (!countryCodeParameterPattern.matcher(parameter).matches()) {
            return null;
        }
        return parameter;
    }

    private String[] parseAsNumberParameter(String parameter) {
        if (!asNumberParameterPattern.matcher(parameter).matches()) {
            return null;
        }
        String[] parameterParts = parameter.toUpperCase().split(",");
        String[] parsedParameter = new String[parameterParts.length];
        for (int i = 0; i < parameterParts.length; ++i) {
            parsedParameter[i] = (!parameterParts[i].startsWith("AS") ? "AS" : "") + parameterParts[i];
        }
        return parsedParameter;
    }

    private String[] parseAsNameParameter(String parameter) {
        for (char c : parameter.toCharArray()) {
            if (c >= ' ' && c < '\u007f') continue;
            return null;
        }
        return parameter.toLowerCase().split(" ");
    }

    private String parseFlagParameter(String parameter) {
        if (!flagPattern.matcher(parameter).matches()) {
            return null;
        }
        return parameter;
    }

    private int[] parseDaysParameter(String parameter) {
        if (!daysPattern.matcher(parameter).matches()) {
            return null;
        }
        int fromDays = 0;
        int toDays = Integer.MAX_VALUE;
        try {
            if (!parameter.contains("-")) {
                toDays = fromDays = Integer.parseInt(parameter);
            } else {
                String[] parts = parameter.split("-", 2);
                if (parts[0].length() > 0) {
                    fromDays = Integer.parseInt(parts[0]);
                }
                if (parts.length > 1 && parts[1].length() > 0) {
                    toDays = Integer.parseInt(parts[1]);
                }
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (fromDays > toDays) {
            return null;
        }
        return new int[]{fromDays, toDays};
    }

    private String[] parseContactParameter(String parameter) {
        for (char c : parameter.toCharArray()) {
            if (c >= ' ' && c < '\u007f') continue;
            return null;
        }
        return parameter.split(" ");
    }

    private String[] parseOrderParameter(String parameter) {
        if (!orderParameterPattern.matcher(parameter).matches()) {
            return null;
        }
        String[] orderParameters = parameter.toLowerCase().split(",");
        HashSet<String> seenOrderParameters = new HashSet<String>();
        for (String orderParameter : orderParameters) {
            if (!knownOrderParameters.contains(orderParameter)) {
                return null;
            }
            if (seenOrderParameters.add(orderParameter.startsWith("-") ? orderParameter.substring(1) : orderParameter)) continue;
            return null;
        }
        return orderParameters;
    }

    private String[] parseFieldsParameter(String parameter) {
        if (!fieldsParameterPattern.matcher(parameter).matches()) {
            return null;
        }
        return parameter.toLowerCase().split(",");
    }

    private String parseVersionParameter(String parameter) {
        if (!versionParameterPattern.matcher(parameter).matches()) {
            return null;
        }
        return parameter;
    }

    private String parseOperatingSystemParameter(String parameter) {
        for (char c : parameter.toCharArray()) {
            if (c >= ' ' && c < '\u007f') continue;
            return null;
        }
        return parameter.toLowerCase();
    }

    private String parseHostNameParameter(String parameter) {
        if (!hostNameParameterPattern.matcher(parameter).matches()) {
            return null;
        }
        return parameter;
    }
}

