/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.server;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.onionoo.docs.DocumentStore;
import org.torproject.onionoo.docs.DocumentStoreFactory;
import org.torproject.onionoo.docs.SummaryDocument;
import org.torproject.onionoo.docs.UpdateStatus;
import org.torproject.onionoo.server.NodeIndex;
import org.torproject.onionoo.server.NodeIndexerFactory;

public class NodeIndexer
implements ServletContextListener,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(NodeIndexer.class);
    private long lastIndexed = -1L;
    private NodeIndex latestNodeIndex = null;
    private Thread nodeIndexerThread = null;
    private long specialTime = -1L;

    public void contextInitialized(ServletContextEvent contextEvent) {
        File outDir = new File(System.getProperty("onionoo.basedir", "/srv/onionoo.torproject.org/onionoo"), "out");
        if (!outDir.exists() || !outDir.isDirectory()) {
            log.error("\n\n\tOut-dir not found! Expected directory: " + outDir + "\n\tSet system property 'onionoo.basedir'.");
            System.exit(1);
        }
        DocumentStore documentStore = DocumentStoreFactory.getDocumentStore();
        documentStore.setOutDir(outDir);
        NodeIndexerFactory.setNodeIndexer(this);
        this.startIndexing();
    }

    public void contextDestroyed(ServletContextEvent contextEvent) {
        this.stopIndexing();
    }

    public synchronized long getLastIndexed(long timeoutMillis) {
        if (this.lastIndexed == -1L && this.nodeIndexerThread != null && timeoutMillis > 0L) {
            try {
                this.wait(timeoutMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.lastIndexed;
    }

    public synchronized NodeIndex getLatestNodeIndex(long timeoutMillis) {
        if (this.latestNodeIndex == null && this.nodeIndexerThread != null && timeoutMillis > 0L) {
            try {
                this.wait(timeoutMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.latestNodeIndex;
    }

    public synchronized void startIndexing() {
        if (this.nodeIndexerThread == null) {
            this.nodeIndexerThread = new Thread((Runnable)this, "Onionoo-Node-Indexer");
            this.nodeIndexerThread.setDaemon(true);
            this.nodeIndexerThread.start();
        }
    }

    @Override
    public void run() {
        try {
            while (this.nodeIndexerThread != null) {
                this.indexNodeStatuses();
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Throwable th) {
            log.error("Indexing failed: {}", (Object)th.getMessage(), (Object)th);
        }
    }

    public synchronized void stopIndexing() {
        Thread indexerThread = this.nodeIndexerThread;
        this.nodeIndexerThread = null;
        indexerThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexNodeStatuses() {
        String fingerprint;
        long updateStatusMillis = -1L;
        DocumentStore documentStore = DocumentStoreFactory.getDocumentStore();
        UpdateStatus updateStatus = documentStore.retrieve(UpdateStatus.class, true);
        if (updateStatus != null) {
            updateStatusMillis = updateStatus.getUpdatedMillis();
        }
        NodeIndexer nodeIndexer = this;
        synchronized (nodeIndexer) {
            if (updateStatusMillis <= this.lastIndexed) {
                return;
            }
        }
        documentStore.invalidateDocumentCache();
        HashMap<String, SummaryDocument> newRelayFingerprintSummaryLines = new HashMap<String, SummaryDocument>();
        HashMap<String, SummaryDocument> newBridgeFingerprintSummaryLines = new HashMap<String, SummaryDocument>();
        HashMap<String, Set<String>> newRelaysByCountryCode = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> newRelaysByAsNumber = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> newRelaysByAsName = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> newRelaysByFlag = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> newBridgesByFlag = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> newRelaysByContact = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> newRelaysByFamily = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> newRelaysByVersion = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> newBridgesByVersion = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> newRelaysByOperatingSystem = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> newBridgesByOperatingSystem = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> newRelaysByHostName = new HashMap<String, Set<String>>();
        HashMap<Boolean, Set<String>> newRelaysByRecommendedVersion = new HashMap<Boolean, Set<String>>();
        newRelaysByRecommendedVersion.put(true, new HashSet());
        newRelaysByRecommendedVersion.put(false, new HashSet());
        HashMap<Boolean, Set<String>> newBridgesByRecommendedVersion = new HashMap<Boolean, Set<String>>();
        newBridgesByRecommendedVersion.put(true, new HashSet());
        newBridgesByRecommendedVersion.put(false, new HashSet());
        TreeMap<Integer, Set<String>> newRelaysByFirstSeenDays = new TreeMap<Integer, Set<String>>();
        TreeMap<Integer, Set<String>> newBridgesByFirstSeenDays = new TreeMap<Integer, Set<String>>();
        TreeMap<Integer, Set<String>> newRelaysByLastSeenDays = new TreeMap<Integer, Set<String>>();
        TreeMap<Integer, Set<String>> newBridgesByLastSeenDays = new TreeMap<Integer, Set<String>>();
        HashSet<SummaryDocument> currentRelays = new HashSet<SummaryDocument>();
        HashSet<SummaryDocument> currentBridges = new HashSet<SummaryDocument>();
        SortedSet<String> fingerprints = documentStore.list(SummaryDocument.class);
        long relaysLastValidAfterMillis = 0L;
        long bridgesLastPublishedMillis = 0L;
        for (String string : fingerprints) {
            SummaryDocument node = documentStore.retrieve(SummaryDocument.class, true, string);
            if (node.isRelay()) {
                relaysLastValidAfterMillis = Math.max(relaysLastValidAfterMillis, node.getLastSeenMillis());
                currentRelays.add(node);
                continue;
            }
            bridgesLastPublishedMillis = Math.max(bridgesLastPublishedMillis, node.getLastSeenMillis());
            currentBridges.add(node);
        }
        TreeMap<String, SortedSet<String>> computedEffectiveFamilies = new TreeMap<String, SortedSet<String>>();
        for (SummaryDocument entry : currentRelays) {
            List<String> unverifiedHostNames;
            String operatingSystem;
            int daysSinceFirstSeen;
            fingerprint = entry.getFingerprint().toUpperCase();
            String hashedFingerprint = entry.getHashedFingerprint().toUpperCase();
            newRelayFingerprintSummaryLines.put(fingerprint, entry);
            newRelayFingerprintSummaryLines.put(hashedFingerprint, entry);
            String countryCode = null != entry.getCountryCode() ? entry.getCountryCode() : "xz";
            if (!newRelaysByCountryCode.containsKey(countryCode)) {
                newRelaysByCountryCode.put(countryCode, new HashSet());
            }
            ((Set)newRelaysByCountryCode.get(countryCode)).add(fingerprint);
            ((Set)newRelaysByCountryCode.get(countryCode)).add(hashedFingerprint);
            String asNumber = null != entry.getAsNumber() ? entry.getAsNumber() : "AS0";
            if (!newRelaysByAsNumber.containsKey(asNumber)) {
                newRelaysByAsNumber.put(asNumber, new HashSet());
            }
            ((Set)newRelaysByAsNumber.get(asNumber)).add(fingerprint);
            ((Set)newRelaysByAsNumber.get(asNumber)).add(hashedFingerprint);
            String asName = entry.getAsName();
            if (!newRelaysByAsName.containsKey(asName)) {
                newRelaysByAsName.put(asName, new HashSet());
            }
            ((Set)newRelaysByAsName.get(asName)).add(fingerprint);
            ((Set)newRelaysByAsName.get(asName)).add(hashedFingerprint);
            for (String flag : entry.getRelayFlags()) {
                String flagLowerCase = flag.toLowerCase();
                if (!newRelaysByFlag.containsKey(flagLowerCase)) {
                    newRelaysByFlag.put(flagLowerCase, new HashSet());
                }
                ((Set)newRelaysByFlag.get(flagLowerCase)).add(fingerprint);
                ((Set)newRelaysByFlag.get(flagLowerCase)).add(hashedFingerprint);
            }
            if (entry.getFamilyFingerprints() != null && !entry.getFamilyFingerprints().isEmpty()) {
                computedEffectiveFamilies.put(fingerprint, entry.getFamilyFingerprints());
            }
            if (entry.getEffectiveFamily() != null) {
                newRelaysByFamily.put(fingerprint, entry.getEffectiveFamily());
            }
            if (!newRelaysByFirstSeenDays.containsKey(daysSinceFirstSeen = (int)(((this.specialTime < 0L ? System.currentTimeMillis() : this.specialTime) - entry.getFirstSeenMillis()) / 86400000L))) {
                newRelaysByFirstSeenDays.put(daysSinceFirstSeen, new HashSet());
            }
            ((Set)newRelaysByFirstSeenDays.get(daysSinceFirstSeen)).add(fingerprint);
            ((Set)newRelaysByFirstSeenDays.get(daysSinceFirstSeen)).add(hashedFingerprint);
            int daysSinceLastSeen = (int)(((this.specialTime < 0L ? System.currentTimeMillis() : this.specialTime) - entry.getLastSeenMillis()) / 86400000L);
            if (!newRelaysByLastSeenDays.containsKey(daysSinceLastSeen)) {
                newRelaysByLastSeenDays.put(daysSinceLastSeen, new HashSet());
            }
            ((Set)newRelaysByLastSeenDays.get(daysSinceLastSeen)).add(fingerprint);
            ((Set)newRelaysByLastSeenDays.get(daysSinceLastSeen)).add(hashedFingerprint);
            String contact = entry.getContact();
            if (!newRelaysByContact.containsKey(contact)) {
                newRelaysByContact.put(contact, new HashSet());
            }
            ((Set)newRelaysByContact.get(contact)).add(fingerprint);
            ((Set)newRelaysByContact.get(contact)).add(hashedFingerprint);
            String version = entry.getVersion();
            if (null != version) {
                if (!newRelaysByVersion.containsKey(version)) {
                    newRelaysByVersion.put(version, new HashSet());
                }
                ((Set)newRelaysByVersion.get(version)).add(fingerprint);
                ((Set)newRelaysByVersion.get(version)).add(hashedFingerprint);
            }
            if (null != (operatingSystem = entry.getOperatingSystem())) {
                if (!newRelaysByOperatingSystem.containsKey(operatingSystem)) {
                    newRelaysByOperatingSystem.put(operatingSystem, new HashSet());
                }
                ((Set)newRelaysByOperatingSystem.get(operatingSystem)).add(fingerprint);
                ((Set)newRelaysByOperatingSystem.get(operatingSystem)).add(hashedFingerprint);
            }
            ArrayList<String> allHostNames = new ArrayList<String>();
            List<String> verifiedHostNames = entry.getVerifiedHostNames();
            if (null != verifiedHostNames) {
                allHostNames.addAll(verifiedHostNames);
            }
            if (null != (unverifiedHostNames = entry.getUnverifiedHostNames())) {
                allHostNames.addAll(unverifiedHostNames);
            }
            for (String hostName : allHostNames) {
                String hostNameLowerCase = hostName.toLowerCase();
                if (!newRelaysByHostName.containsKey(hostNameLowerCase)) {
                    newRelaysByHostName.put(hostNameLowerCase, new HashSet());
                }
                ((Set)newRelaysByHostName.get(hostNameLowerCase)).add(fingerprint);
                ((Set)newRelaysByHostName.get(hostNameLowerCase)).add(hashedFingerprint);
            }
            Boolean recommendedVersion = entry.getRecommendedVersion();
            if (null == recommendedVersion) continue;
            ((Set)newRelaysByRecommendedVersion.get(recommendedVersion)).add(fingerprint);
            ((Set)newRelaysByRecommendedVersion.get(recommendedVersion)).add(hashedFingerprint);
        }
        for (Map.Entry e : computedEffectiveFamilies.entrySet()) {
            fingerprint = (String)e.getKey();
            HashSet<String> inMutualFamilyRelation = new HashSet<String>();
            for (String otherFingerprint : (Set)e.getValue()) {
                if (!computedEffectiveFamilies.containsKey(otherFingerprint) || !((Set)computedEffectiveFamilies.get(otherFingerprint)).contains(fingerprint)) continue;
                inMutualFamilyRelation.add(otherFingerprint);
            }
            newRelaysByFamily.put(fingerprint, inMutualFamilyRelation);
        }
        for (SummaryDocument entry : currentBridges) {
            Boolean recommendedVersion;
            String operatingSystem;
            String hashedFingerprint = entry.getFingerprint().toUpperCase();
            String hashedHashedFingerprint = entry.getHashedFingerprint().toUpperCase();
            newBridgeFingerprintSummaryLines.put(hashedFingerprint, entry);
            newBridgeFingerprintSummaryLines.put(hashedHashedFingerprint, entry);
            for (String flag : entry.getRelayFlags()) {
                String flagLowerCase = flag.toLowerCase();
                if (!newBridgesByFlag.containsKey(flagLowerCase)) {
                    newBridgesByFlag.put(flagLowerCase, new HashSet());
                }
                ((Set)newBridgesByFlag.get(flagLowerCase)).add(hashedFingerprint);
                ((Set)newBridgesByFlag.get(flagLowerCase)).add(hashedHashedFingerprint);
            }
            int daysSinceFirstSeen = (int)(((this.specialTime < 0L ? System.currentTimeMillis() : this.specialTime) - entry.getFirstSeenMillis()) / 86400000L);
            if (!newBridgesByFirstSeenDays.containsKey(daysSinceFirstSeen)) {
                newBridgesByFirstSeenDays.put(daysSinceFirstSeen, new HashSet());
            }
            ((Set)newBridgesByFirstSeenDays.get(daysSinceFirstSeen)).add(hashedFingerprint);
            ((Set)newBridgesByFirstSeenDays.get(daysSinceFirstSeen)).add(hashedHashedFingerprint);
            int daysSinceLastSeen = (int)(((this.specialTime < 0L ? System.currentTimeMillis() : this.specialTime) - entry.getLastSeenMillis()) / 86400000L);
            if (!newBridgesByLastSeenDays.containsKey(daysSinceLastSeen)) {
                newBridgesByLastSeenDays.put(daysSinceLastSeen, new HashSet());
            }
            ((Set)newBridgesByLastSeenDays.get(daysSinceLastSeen)).add(hashedFingerprint);
            ((Set)newBridgesByLastSeenDays.get(daysSinceLastSeen)).add(hashedHashedFingerprint);
            String version = entry.getVersion();
            if (null != version) {
                if (!newBridgesByVersion.containsKey(version)) {
                    newBridgesByVersion.put(version, new HashSet());
                }
                ((Set)newBridgesByVersion.get(version)).add(hashedFingerprint);
                ((Set)newBridgesByVersion.get(version)).add(hashedHashedFingerprint);
            }
            if (null != (operatingSystem = entry.getOperatingSystem())) {
                if (!newBridgesByOperatingSystem.containsKey(operatingSystem)) {
                    newBridgesByOperatingSystem.put(operatingSystem, new HashSet());
                }
                ((Set)newBridgesByOperatingSystem.get(operatingSystem)).add(hashedFingerprint);
                ((Set)newBridgesByOperatingSystem.get(operatingSystem)).add(hashedHashedFingerprint);
            }
            if (null == (recommendedVersion = entry.getRecommendedVersion())) continue;
            ((Set)newBridgesByRecommendedVersion.get(recommendedVersion)).add(hashedFingerprint);
            ((Set)newBridgesByRecommendedVersion.get(recommendedVersion)).add(hashedHashedFingerprint);
        }
        NodeIndex nodeIndex = new NodeIndex();
        nodeIndex.setRelayFingerprintSummaryLines(newRelayFingerprintSummaryLines);
        nodeIndex.setBridgeFingerprintSummaryLines(newBridgeFingerprintSummaryLines);
        nodeIndex.setRelaysByCountryCode(newRelaysByCountryCode);
        nodeIndex.setRelaysByAsNumber(newRelaysByAsNumber);
        nodeIndex.setRelaysByAsName(newRelaysByAsName);
        nodeIndex.setRelaysByFlag(newRelaysByFlag);
        nodeIndex.setBridgesByFlag(newBridgesByFlag);
        nodeIndex.setRelaysByContact(newRelaysByContact);
        nodeIndex.setRelaysByFamily(newRelaysByFamily);
        nodeIndex.setRelaysByFirstSeenDays(newRelaysByFirstSeenDays);
        nodeIndex.setRelaysByLastSeenDays(newRelaysByLastSeenDays);
        nodeIndex.setBridgesByFirstSeenDays(newBridgesByFirstSeenDays);
        nodeIndex.setBridgesByLastSeenDays(newBridgesByLastSeenDays);
        nodeIndex.setRelaysPublishedMillis(relaysLastValidAfterMillis);
        nodeIndex.setBridgesPublishedMillis(bridgesLastPublishedMillis);
        nodeIndex.setRelaysByVersion(newRelaysByVersion);
        nodeIndex.setBridgesByVersion(newBridgesByVersion);
        nodeIndex.setRelaysByOperatingSystem(newRelaysByOperatingSystem);
        nodeIndex.setBridgesByOperatingSystem(newBridgesByOperatingSystem);
        nodeIndex.setRelaysByHostName(newRelaysByHostName);
        nodeIndex.setRelaysByRecommendedVersion(newRelaysByRecommendedVersion);
        nodeIndex.setBridgesByRecommendedVersion(newBridgesByRecommendedVersion);
        NodeIndexer nodeIndexer2 = this;
        synchronized (nodeIndexer2) {
            this.lastIndexed = updateStatusMillis;
            this.latestNodeIndex = nodeIndex;
            this.notifyAll();
        }
    }
}

