/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;

public enum FileType {
    BZ2(BZip2CompressorInputStream.class, BZip2CompressorOutputStream.class),
    GZ(GzipCompressorInputStream.class, GzipCompressorOutputStream.class),
    JSON(BufferedInputStream.class, BufferedOutputStream.class),
    PLAIN(BufferedInputStream.class, BufferedOutputStream.class),
    XZ(XZCompressorInputStream.class, XZCompressorOutputStream.class);

    private final Class<? extends InputStream> inClass;
    private final Class<? extends OutputStream> outClass;

    private FileType(Class<? extends InputStream> in, Class<? extends OutputStream> out) {
        this.inClass = in;
        this.outClass = out;
    }

    public static FileType findType(String ext) {
        FileType res = null;
        try {
            res = FileType.valueOf(ext.toUpperCase());
            return res;
        }
        catch (IllegalArgumentException | NullPointerException re) {
            return PLAIN;
        }
    }

    public InputStream inputStream(InputStream is) throws Exception {
        return this.inClass.getConstructor(InputStream.class).newInstance(is);
    }

    public OutputStream outputStream(OutputStream os) throws Exception {
        return this.outClass.getConstructor(OutputStream.class).newInstance(os);
    }

    public byte[] compress(byte[] bytes) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (OutputStream os = this.outputStream(baos);){
            os.write(bytes);
            os.flush();
        }
        return baos.toByteArray();
    }

    public OutputStream compress(OutputStream os) throws Exception {
        return this.outputStream(os);
    }

    public InputStream decompress(InputStream is) throws Exception {
        return this.inputStream(is);
    }

    /*
     * Exception decompiling
     */
    public byte[] decompress(byte[] bytes) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

