/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.util;

import java.util.Hashtable;
import java.util.TreeSet;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainNameSystem {
    private DirContext dnsContext;
    private Logger log = LoggerFactory.getLogger(DomainNameSystem.class);

    public DomainNameSystem() {
        Hashtable<String, String> envProps = new Hashtable<String, String>();
        envProps.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        try {
            this.dnsContext = new InitialDirContext(envProps);
        }
        catch (NamingException e) {
            this.log.error("Unable to create directory context. Host name lookup will be disabled!");
        }
    }

    public String[] getRecords(String hostName, String type) throws NamingException {
        Attribute dnsAttribute;
        if (this.dnsContext == null) {
            throw new NamingException();
        }
        TreeSet<String> results = new TreeSet<String>();
        Attributes dnsEntries = this.dnsContext.getAttributes(hostName, new String[]{type});
        if (dnsEntries != null && (dnsAttribute = dnsEntries.get(type)) != null) {
            NamingEnumeration<?> dnsEntryIterator = dnsEntries.get(type).getAll();
            while (dnsEntryIterator.hasMoreElements()) {
                results.add(dnsEntryIterator.next().toString());
            }
        }
        return results.toArray(new String[results.size()]);
    }
}

