/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.updater;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.torproject.onionoo.updater.RdnsLookupWorker;
import org.torproject.onionoo.util.DomainNameSystem;
import org.torproject.onionoo.util.FormattingUtils;

public class ReverseDomainNameResolver {
    static final long RDNS_LOOKUP_MAX_REQUEST_MILLIS = 10000L;
    static final long RDNS_LOOKUP_MAX_DURATION_MILLIS = 300000L;
    private static final long RDNS_LOOKUP_MAX_AGE_MILLIS = 43200000L;
    private static final int RDNS_LOOKUP_WORKERS_NUM = 5;
    private DomainNameSystem domainNameSystem;
    private Map<String, Long> addressLastLookupTimes;
    Set<String> rdnsLookupJobs;
    Map<String, String> rdnsLookupResults;
    Map<String, List<String>> rdnsVerifiedLookupResults;
    Map<String, List<String>> rdnsUnverifiedLookupResults;
    List<Long> rdnsLookupMillis;
    long startedRdnsLookups;
    private List<RdnsLookupWorker> rdnsLookupWorkers;

    public void setAddresses(Map<String, Long> addressLastLookupTimes) {
        this.addressLastLookupTimes = addressLastLookupTimes;
    }

    public void startReverseDomainNameLookups() {
        this.domainNameSystem = new DomainNameSystem();
        this.startedRdnsLookups = System.currentTimeMillis();
        this.rdnsLookupJobs = new HashSet<String>();
        for (Map.Entry<String, Long> e : this.addressLastLookupTimes.entrySet()) {
            if (e.getValue() >= this.startedRdnsLookups - 43200000L) continue;
            this.rdnsLookupJobs.add(e.getKey());
        }
        this.rdnsLookupResults = new HashMap<String, String>();
        this.rdnsVerifiedLookupResults = new HashMap<String, List<String>>();
        this.rdnsUnverifiedLookupResults = new HashMap<String, List<String>>();
        this.rdnsLookupMillis = new ArrayList<Long>();
        this.rdnsLookupWorkers = new ArrayList<RdnsLookupWorker>();
        for (int i = 0; i < 5; ++i) {
            RdnsLookupWorker rdnsLookupWorker = new RdnsLookupWorker(this);
            this.rdnsLookupWorkers.add(rdnsLookupWorker);
            rdnsLookupWorker.setDaemon(true);
            rdnsLookupWorker.start();
        }
    }

    public void finishReverseDomainNameLookups() {
        for (RdnsLookupWorker rdnsLookupWorker : this.rdnsLookupWorkers) {
            try {
                rdnsLookupWorker.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getLookupResults() {
        Map<String, String> map = this.rdnsLookupResults;
        synchronized (map) {
            return new HashMap<String, String>(this.rdnsLookupResults);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> getVerifiedLookupResults() {
        Map<String, List<String>> map = this.rdnsVerifiedLookupResults;
        synchronized (map) {
            return new HashMap<String, List<String>>(this.rdnsVerifiedLookupResults);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> getUnverifiedLookupResults() {
        Map<String, List<String>> map = this.rdnsUnverifiedLookupResults;
        synchronized (map) {
            return new HashMap<String, List<String>>(this.rdnsUnverifiedLookupResults);
        }
    }

    public long getLookupStartMillis() {
        return this.startedRdnsLookups;
    }

    public DomainNameSystem getDomainNameSystemInstance() {
        return this.domainNameSystem;
    }

    public String getStatsString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    " + FormattingUtils.formatDecimalNumber(this.rdnsLookupMillis.size()) + " lookups performed\n");
        sb.append("    " + FormattingUtils.formatDecimalNumber(this.rdnsVerifiedLookupResults.size()) + " verified results found\n");
        sb.append("    " + FormattingUtils.formatDecimalNumber(this.rdnsUnverifiedLookupResults.size()) + " unverified results found\n");
        if (!this.rdnsLookupMillis.isEmpty()) {
            Collections.sort(this.rdnsLookupMillis);
            sb.append("    " + FormattingUtils.formatMillis(this.rdnsLookupMillis.get(0)) + " minimum lookup time\n");
            sb.append("    " + FormattingUtils.formatMillis(this.rdnsLookupMillis.get(this.rdnsLookupMillis.size() / 2)) + " median lookup time\n");
            sb.append("    " + FormattingUtils.formatMillis(this.rdnsLookupMillis.get(this.rdnsLookupMillis.size() - 1)) + " maximum lookup time\n");
        }
        return sb.toString();
    }
}

