/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.updater;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import org.torproject.onionoo.updater.RdnsLookupWorker;
import org.torproject.onionoo.updater.ReverseDomainNameResolver;
import org.torproject.onionoo.util.DomainNameSystem;

class RdnsLookupRequest
extends Thread {
    private ReverseDomainNameResolver reverseDomainNameResolver;
    private DomainNameSystem domainNameSystem;
    private RdnsLookupWorker parent;
    private String address;
    private List<String> verifiedHostNames;
    private List<String> unverifiedHostNames;
    private long lookupStartedMillis = -1L;
    private long lookupCompletedMillis = -1L;

    public RdnsLookupRequest(ReverseDomainNameResolver reverseDomainNameResolver, RdnsLookupWorker parent, String address) {
        this.reverseDomainNameResolver = reverseDomainNameResolver;
        this.domainNameSystem = this.reverseDomainNameResolver.getDomainNameSystemInstance();
        this.parent = parent;
        this.address = address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.lookupStartedMillis = System.currentTimeMillis();
        try {
            ArrayList<String> verifiedResults = new ArrayList<String>();
            ArrayList<String> unverifiedResults = new ArrayList<String>();
            String[] bytes = this.address.split("\\.");
            if (bytes.length == 4) {
                String[] reverseDnsRecords;
                String reverseDnsDomain = bytes[3] + "." + bytes[2] + "." + bytes[1] + "." + bytes[0] + ".in-addr.arpa";
                for (String reverseDnsRecord : reverseDnsRecords = this.domainNameSystem.getRecords(reverseDnsDomain, "PTR")) {
                    String[] forwardDnsRecords;
                    boolean verified = false;
                    for (String forwardDnsRecord : forwardDnsRecords = this.domainNameSystem.getRecords(reverseDnsRecord, "A")) {
                        if (!forwardDnsRecord.equals(this.address)) continue;
                        verified = true;
                        break;
                    }
                    if (verified) {
                        verifiedResults.add(reverseDnsRecord.substring(0, reverseDnsRecord.length() - 1));
                        continue;
                    }
                    unverifiedResults.add(reverseDnsRecord.substring(0, reverseDnsRecord.length() - 1));
                }
            }
            RdnsLookupRequest rdnsLookupRequest = this;
            synchronized (rdnsLookupRequest) {
                this.verifiedHostNames = verifiedResults;
                this.unverifiedHostNames = unverifiedResults;
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        this.lookupCompletedMillis = System.currentTimeMillis();
        this.parent.interrupt();
    }

    public synchronized String getHostName() {
        List<String> verifiedHostNames = this.verifiedHostNames;
        if (null != verifiedHostNames && !verifiedHostNames.isEmpty()) {
            return verifiedHostNames.get(0);
        }
        return null;
    }

    public synchronized List<String> getVerifiedHostNames() {
        return this.verifiedHostNames;
    }

    public synchronized List<String> getUnverifiedHostNames() {
        return this.unverifiedHostNames;
    }

    public synchronized long getLookupMillis() {
        return this.lookupCompletedMillis - this.lookupStartedMillis;
    }
}

