/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.Filter;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class FilterSet
implements Filter {
    private final Set<Filter> filters = Sets.newHashSet();

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public void removeFilter(Filter filter) {
        this.filters.remove(filter);
    }

    public Set<Filter> getFilters() {
        return Collections.unmodifiableSet(this.filters);
    }

    public String toString() {
        return this.filters.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FilterSet filterSet = (FilterSet)other;
        return Objects.equals(this.filters, filterSet.filters);
    }

    public int hashCode() {
        return Objects.hash(this.filters);
    }

    @Override
    public boolean accept(AuditEvent event) {
        for (Filter filter : this.filters) {
            if (filter.accept(event)) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        this.filters.clear();
    }
}

