/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.updater;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.torproject.onionoo.updater.RdnsLookupWorker;
import org.torproject.onionoo.util.FormattingUtils;

public class ReverseDomainNameResolver {
    static final long RDNS_LOOKUP_MAX_REQUEST_MILLIS = 10000L;
    static final long RDNS_LOOKUP_MAX_DURATION_MILLIS = 300000L;
    private static final long RDNS_LOOKUP_MAX_AGE_MILLIS = 43200000L;
    private static final int RDNS_LOOKUP_WORKERS_NUM = 5;
    private Map<String, Long> addressLastLookupTimes;
    Set<String> rdnsLookupJobs;
    Map<String, String> rdnsLookupResults;
    List<Long> rdnsLookupMillis;
    long startedRdnsLookups;
    private List<RdnsLookupWorker> rdnsLookupWorkers;

    public void setAddresses(Map<String, Long> addressLastLookupTimes) {
        this.addressLastLookupTimes = addressLastLookupTimes;
    }

    public void startReverseDomainNameLookups() {
        this.startedRdnsLookups = System.currentTimeMillis();
        this.rdnsLookupJobs = new HashSet<String>();
        for (Map.Entry<String, Long> e : this.addressLastLookupTimes.entrySet()) {
            if (e.getValue() >= this.startedRdnsLookups - 43200000L) continue;
            this.rdnsLookupJobs.add(e.getKey());
        }
        this.rdnsLookupResults = new HashMap<String, String>();
        this.rdnsLookupMillis = new ArrayList<Long>();
        this.rdnsLookupWorkers = new ArrayList<RdnsLookupWorker>();
        for (int i = 0; i < 5; ++i) {
            RdnsLookupWorker rdnsLookupWorker = new RdnsLookupWorker(this);
            this.rdnsLookupWorkers.add(rdnsLookupWorker);
            rdnsLookupWorker.setDaemon(true);
            rdnsLookupWorker.start();
        }
    }

    public void finishReverseDomainNameLookups() {
        for (RdnsLookupWorker rdnsLookupWorker : this.rdnsLookupWorkers) {
            try {
                rdnsLookupWorker.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getLookupResults() {
        Map<String, String> map = this.rdnsLookupResults;
        synchronized (map) {
            return new HashMap<String, String>(this.rdnsLookupResults);
        }
    }

    public long getLookupStartMillis() {
        return this.startedRdnsLookups;
    }

    public String getStatsString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    " + FormattingUtils.formatDecimalNumber(this.rdnsLookupMillis.size()) + " lookups performed\n");
        if (this.rdnsLookupMillis.size() > 0) {
            Collections.sort(this.rdnsLookupMillis);
            sb.append("    " + FormattingUtils.formatMillis(this.rdnsLookupMillis.get(0)) + " minimum lookup time\n");
            sb.append("    " + FormattingUtils.formatMillis(this.rdnsLookupMillis.get(this.rdnsLookupMillis.size() / 2)) + " median lookup time\n");
            sb.append("    " + FormattingUtils.formatMillis(this.rdnsLookupMillis.get(this.rdnsLookupMillis.size() - 1)) + " maximum lookup time\n");
        }
        return sb.toString();
    }
}

