/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.dsl;

import java.util.concurrent.atomic.AtomicBoolean;
import net.sourceforge.cobertura.check.CheckCoverageTask;
import net.sourceforge.cobertura.coveragedata.CoverageDataFileHandler;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.coveragedata.TouchCollector;
import net.sourceforge.cobertura.dsl.Arguments;
import net.sourceforge.cobertura.instrument.CodeInstrumentationTask;
import net.sourceforge.cobertura.merge.MergeProjectDataFilesTask;
import net.sourceforge.cobertura.reporting.ComplexityCalculator;
import net.sourceforge.cobertura.reporting.CompositeReport;
import net.sourceforge.cobertura.reporting.NativeReport;
import net.sourceforge.cobertura.reporting.Report;

public class Cobertura {
    private Arguments args;
    private ProjectData projectData;
    private CodeInstrumentationTask instrumentationTask;
    private CheckCoverageTask checkCoverageTask;
    private MergeProjectDataFilesTask mergeProjectDataFilesTask;
    private AtomicBoolean didApplyInstrumentationResults;
    private CompositeReport report = new CompositeReport();

    private Cobertura() {
    }

    public Cobertura(Arguments arguments) {
        this.args = arguments;
        this.instrumentationTask = new CodeInstrumentationTask();
        this.checkCoverageTask = new CheckCoverageTask();
        this.mergeProjectDataFilesTask = new MergeProjectDataFilesTask();
        this.didApplyInstrumentationResults = new AtomicBoolean(false);
    }

    public Cobertura instrumentCode() throws Throwable {
        this.instrumentationTask.instrument(this.args, this.getProjectDataInstance());
        return this;
    }

    public Cobertura calculateCoverage() {
        TouchCollector.applyTouchesOnProjectData(this.projectData);
        this.didApplyInstrumentationResults.set(true);
        return this;
    }

    public Cobertura checkThresholds() {
        this.report.addReport(this.checkCoverageTask.checkCoverage(this.args, this.getProjectDataInstance()));
        return this;
    }

    public Cobertura merge() {
        this.mergeProjectDataFilesTask.mergeProjectDataFiles(this.args, this.getProjectDataInstance());
        return this;
    }

    public Report report() {
        ComplexityCalculator complexityCalculator = new ComplexityCalculator(this.args.getSources());
        complexityCalculator.setEncoding(this.args.getEncoding());
        complexityCalculator.setCalculateMethodComplexity(this.args.isCalculateMethodComplexity());
        this.report.addReport(new NativeReport(this.getProjectDataInstance(), this.args.getDestinationDirectory(), this.args.getSources(), complexityCalculator, this.args.getEncoding()));
        return this.report;
    }

    public Cobertura saveProjectData() {
        CoverageDataFileHandler.saveCoverageData(this.getProjectDataInstance(), this.args.getDataFile());
        return this;
    }

    private ProjectData getProjectDataInstance() {
        if (this.projectData != null) {
            return this.projectData;
        }
        if (this.args.getDataFile().isFile()) {
            this.projectData = CoverageDataFileHandler.loadCoverageData(this.args.getDataFile());
        }
        if (this.projectData == null) {
            this.projectData = new ProjectData();
        }
        return this.projectData;
    }
}

