/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.updater;

import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.NetworkStatusEntry;
import org.torproject.descriptor.RelayNetworkStatusConsensus;
import org.torproject.onionoo.docs.DocumentStore;
import org.torproject.onionoo.docs.DocumentStoreFactory;
import org.torproject.onionoo.docs.NodeStatus;
import org.torproject.onionoo.docs.WeightsStatus;
import org.torproject.onionoo.updater.DescriptorListener;
import org.torproject.onionoo.updater.DescriptorSource;
import org.torproject.onionoo.updater.DescriptorSourceFactory;
import org.torproject.onionoo.updater.DescriptorType;
import org.torproject.onionoo.updater.StatusUpdater;

public class WeightsStatusUpdater
implements DescriptorListener,
StatusUpdater {
    private DescriptorSource descriptorSource = DescriptorSourceFactory.getDescriptorSource();
    private DocumentStore documentStore = DocumentStoreFactory.getDocumentStore();

    public WeightsStatusUpdater() {
        this.registerDescriptorListeners();
    }

    private void registerDescriptorListeners() {
        this.descriptorSource.registerDescriptorListener(this, DescriptorType.RELAY_CONSENSUSES);
    }

    @Override
    public void processDescriptor(Descriptor descriptor, boolean relay) {
        if (descriptor instanceof RelayNetworkStatusConsensus) {
            this.processRelayNetworkConsensus((RelayNetworkStatusConsensus)descriptor);
        }
    }

    @Override
    public void updateStatuses() {
    }

    private void processRelayNetworkConsensus(RelayNetworkStatusConsensus consensus) {
        long validAfterMillis = consensus.getValidAfterMillis();
        long freshUntilMillis = consensus.getFreshUntilMillis();
        SortedMap<String, double[]> pathSelectionWeights = this.calculatePathSelectionProbabilities(consensus);
        this.updateWeightsHistory(validAfterMillis, freshUntilMillis, pathSelectionWeights);
    }

    private void updateWeightsHistory(long validAfterMillis, long freshUntilMillis, SortedMap<String, double[]> pathSelectionWeights) {
        for (Map.Entry<String, double[]> e : pathSelectionWeights.entrySet()) {
            String fingerprint = e.getKey();
            WeightsStatus weightsStatus = this.documentStore.retrieve(WeightsStatus.class, true, fingerprint);
            if (weightsStatus == null) {
                weightsStatus = new WeightsStatus();
            }
            double[] weights = e.getValue();
            weightsStatus.addToHistory(validAfterMillis, freshUntilMillis, weights);
            if (!weightsStatus.isDirty()) continue;
            NodeStatus nodeStatus = this.documentStore.retrieve(NodeStatus.class, true, fingerprint);
            if (null != nodeStatus) {
                weightsStatus.compressHistory(nodeStatus.getLastSeenMillis());
            }
            this.documentStore.store(weightsStatus, fingerprint);
            weightsStatus.clearDirty();
        }
    }

    private SortedMap<String, double[]> calculatePathSelectionProbabilities(RelayNetworkStatusConsensus consensus) {
        boolean containsBandwidthWeights = false;
        double wgg = 1.0;
        double wgd = 1.0;
        double wmg = 1.0;
        double wmm = 1.0;
        double wme = 1.0;
        double wmd = 1.0;
        double wee = 1.0;
        double wed = 1.0;
        SortedMap<String, Integer> bandwidthWeights = consensus.getBandwidthWeights();
        if (bandwidthWeights != null) {
            TreeSet<String> missingWeightKeys = new TreeSet<String>(Arrays.asList("Wgg,Wgd,Wmg,Wmm,Wme,Wmd,Wee,Wed".split(",")));
            missingWeightKeys.removeAll(bandwidthWeights.keySet());
            if (missingWeightKeys.isEmpty()) {
                wgg = (double)((Integer)bandwidthWeights.get("Wgg")).intValue() / 10000.0;
                wgd = (double)((Integer)bandwidthWeights.get("Wgd")).intValue() / 10000.0;
                wmg = (double)((Integer)bandwidthWeights.get("Wmg")).intValue() / 10000.0;
                wmm = (double)((Integer)bandwidthWeights.get("Wmm")).intValue() / 10000.0;
                wme = (double)((Integer)bandwidthWeights.get("Wme")).intValue() / 10000.0;
                wmd = (double)((Integer)bandwidthWeights.get("Wmd")).intValue() / 10000.0;
                wee = (double)((Integer)bandwidthWeights.get("Wee")).intValue() / 10000.0;
                wed = (double)((Integer)bandwidthWeights.get("Wed")).intValue() / 10000.0;
                containsBandwidthWeights = true;
            }
        }
        TreeMap<String, Double> consensusWeights = new TreeMap<String, Double>();
        TreeMap<String, Double> guardWeights = new TreeMap<String, Double>();
        TreeMap<String, Double> middleWeights = new TreeMap<String, Double>();
        TreeMap<String, Double> exitWeights = new TreeMap<String, Double>();
        double totalConsensusWeight = 0.0;
        double totalGuardWeight = 0.0;
        double totalMiddleWeight = 0.0;
        double totalExitWeight = 0.0;
        for (NetworkStatusEntry relay : consensus.getStatusEntries().values()) {
            String fingerprint = relay.getFingerprint();
            if (!relay.getFlags().contains("Running") || relay.getBandwidth() < 0L) continue;
            double consensusWeight = relay.getBandwidth();
            consensusWeights.put(fingerprint, consensusWeight);
            totalConsensusWeight += consensusWeight;
            if (!containsBandwidthWeights) continue;
            double guardWeight = relay.getBandwidth();
            double middleWeight = relay.getBandwidth();
            double exitWeight = relay.getBandwidth();
            boolean isExit = relay.getFlags().contains("Exit") && !relay.getFlags().contains("BadExit");
            boolean isGuard = relay.getFlags().contains("Guard");
            if (isGuard && isExit) {
                guardWeight *= wgd;
                middleWeight *= wmd;
                exitWeight *= wed;
            } else if (isGuard) {
                guardWeight *= wgg;
                middleWeight *= wmg;
                exitWeight = 0.0;
            } else if (isExit) {
                guardWeight = 0.0;
                middleWeight *= wme;
                exitWeight *= wee;
            } else {
                guardWeight = 0.0;
                middleWeight *= wmm;
                exitWeight = 0.0;
            }
            guardWeights.put(fingerprint, guardWeight);
            middleWeights.put(fingerprint, middleWeight);
            exitWeights.put(fingerprint, exitWeight);
            totalGuardWeight += guardWeight;
            totalMiddleWeight += middleWeight;
            totalExitWeight += exitWeight;
        }
        TreeMap<String, double[]> pathSelectionProbabilities = new TreeMap<String, double[]>();
        for (String fingerprint : consensusWeights.keySet()) {
            double[] probabilities = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0};
            if (consensusWeights.containsKey(fingerprint) && totalConsensusWeight > 0.0) {
                probabilities[1] = (Double)consensusWeights.get(fingerprint) / totalConsensusWeight;
                probabilities[6] = (Double)consensusWeights.get(fingerprint);
            }
            if (guardWeights.containsKey(fingerprint) && totalGuardWeight > 0.0) {
                probabilities[2] = (Double)guardWeights.get(fingerprint) / totalGuardWeight;
            }
            if (middleWeights.containsKey(fingerprint) && totalMiddleWeight > 0.0) {
                probabilities[3] = (Double)middleWeights.get(fingerprint) / totalMiddleWeight;
            }
            if (exitWeights.containsKey(fingerprint) && totalExitWeight > 0.0) {
                probabilities[4] = (Double)exitWeights.get(fingerprint) / totalExitWeight;
            }
            pathSelectionProbabilities.put(fingerprint, probabilities);
        }
        return pathSelectionProbabilities;
    }

    @Override
    public String getStatsString() {
        return null;
    }
}

