/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.torproject.onionoo.docs.DocumentStore;
import org.torproject.onionoo.docs.DocumentStoreFactory;
import org.torproject.onionoo.docs.SummaryDocument;
import org.torproject.onionoo.server.NodeIndex;
import org.torproject.onionoo.server.SummaryDocumentComparator;

public class RequestHandler {
    private NodeIndex nodeIndex;
    private DocumentStore documentStore;
    private String resourceType;
    private String type;
    private String running;
    private String[] search;
    private String lookup;
    private String fingerprint;
    private String country;
    private String as;
    private String flag;
    private String[] contact;
    private String version;
    private String hostName;
    private Boolean recommendedVersion;
    private String[] order;
    private String offset;
    private String limit;
    private int[] firstSeenDays;
    private int[] lastSeenDays;
    private String family;
    private Map<String, SummaryDocument> filteredRelays = new HashMap<String, SummaryDocument>();
    private Map<String, SummaryDocument> filteredBridges = new HashMap<String, SummaryDocument>();
    private int relaysSkipped = 0;
    private int bridgesSkipped = 0;
    private int relaysTruncated = 0;
    private int bridgesTruncated = 0;
    private List<SummaryDocument> orderedRelays = new ArrayList<SummaryDocument>();
    private List<SummaryDocument> orderedBridges = new ArrayList<SummaryDocument>();

    public RequestHandler(NodeIndex nodeIndex) {
        this.nodeIndex = nodeIndex;
        this.documentStore = DocumentStoreFactory.getDocumentStore();
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setRunning(String running) {
        this.running = running;
    }

    public void setSearch(String[] search) {
        this.search = new String[search.length];
        System.arraycopy(search, 0, this.search, 0, search.length);
    }

    public void setLookup(String lookup) {
        this.lookup = lookup;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public void setAs(String as) {
        this.as = as;
    }

    public void setFlag(String flag) {
        this.flag = flag;
    }

    public void setContact(String[] contact) {
        this.contact = new String[contact.length];
        System.arraycopy(contact, 0, this.contact, 0, contact.length);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setRecommendedVersion(Boolean recommendedVersion) {
        this.recommendedVersion = recommendedVersion;
    }

    public void setOrder(String[] order) {
        this.order = new String[order.length];
        System.arraycopy(order, 0, this.order, 0, order.length);
    }

    public void setOffset(String offset) {
        this.offset = offset;
    }

    public void setLimit(String limit) {
        this.limit = limit;
    }

    public void setFirstSeenDays(int[] firstSeenDays) {
        this.firstSeenDays = new int[firstSeenDays.length];
        System.arraycopy(firstSeenDays, 0, this.firstSeenDays, 0, firstSeenDays.length);
    }

    public void setLastSeenDays(int[] lastSeenDays) {
        this.lastSeenDays = new int[lastSeenDays.length];
        System.arraycopy(lastSeenDays, 0, this.lastSeenDays, 0, lastSeenDays.length);
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public void handleRequest() {
        this.filteredRelays.putAll(this.nodeIndex.getRelayFingerprintSummaryLines());
        this.filteredBridges.putAll(this.nodeIndex.getBridgeFingerprintSummaryLines());
        this.filterByResourceType();
        this.filterByType();
        this.filterByRunning();
        this.filterBySearchTerms();
        this.filterByLookup();
        this.filterByFingerprint();
        this.filterByCountryCode();
        this.filterByAsNumber();
        this.filterByFlag();
        this.filterNodesByFirstSeenDays();
        this.filterNodesByLastSeenDays();
        this.filterByContact();
        this.filterByFamily();
        this.filterByVersion();
        this.filterByHostName();
        this.filterByRecommendedVersion();
        this.order();
        this.offset();
        this.limit();
    }

    private void filterByResourceType() {
        if (this.resourceType.equals("clients")) {
            this.filteredRelays.clear();
        }
        if (this.resourceType.equals("weights")) {
            this.filteredBridges.clear();
        }
    }

    private void filterByType() {
        if (this.type == null) {
            return;
        }
        if (this.type.equals("relay")) {
            this.filteredBridges.clear();
        } else {
            this.filteredRelays.clear();
        }
    }

    private void filterByRunning() {
        if (this.running == null) {
            return;
        }
        boolean runningRequested = this.running.equals("true");
        HashSet<String> removeRelays = new HashSet<String>();
        for (Map.Entry<String, SummaryDocument> e : this.filteredRelays.entrySet()) {
            if (e.getValue().isRunning() == runningRequested) continue;
            removeRelays.add(e.getKey());
        }
        for (String fingerprint : removeRelays) {
            this.filteredRelays.remove(fingerprint);
        }
        HashSet<String> removeBridges = new HashSet<String>();
        for (Map.Entry<String, SummaryDocument> e : this.filteredBridges.entrySet()) {
            if (e.getValue().isRunning() == runningRequested) continue;
            removeBridges.add(e.getKey());
        }
        for (String fingerprint : removeBridges) {
            this.filteredBridges.remove(fingerprint);
        }
    }

    private void filterBySearchTerms() {
        if (this.search == null) {
            return;
        }
        for (String searchTerm : this.search) {
            this.filterBySearchTerm(searchTerm);
        }
    }

    private void filterBySearchTerm(String searchTerm) {
        HashSet<String> removeRelays = new HashSet<String>();
        for (Map.Entry<String, SummaryDocument> e : this.filteredRelays.entrySet()) {
            boolean lineMatches;
            block20: {
                String nickname;
                Object[] fingerprintSortedHexBlocks;
                String base64Fingerprint;
                SummaryDocument entry;
                String fingerprint;
                block19: {
                    fingerprint = e.getKey();
                    entry = e.getValue();
                    base64Fingerprint = entry.isRelay() ? entry.getBase64Fingerprint() : null;
                    fingerprintSortedHexBlocks = entry.getFingerprintSortedHexBlocks();
                    lineMatches = false;
                    String string = nickname = entry.getNickname() != null ? entry.getNickname().toLowerCase() : "unnamed";
                    if (!searchTerm.startsWith("$")) break block19;
                    if (!fingerprint.startsWith(searchTerm.substring(1).toUpperCase())) break block20;
                    lineMatches = true;
                    break block20;
                }
                if (nickname.contains(searchTerm.toLowerCase())) {
                    lineMatches = true;
                } else if (fingerprint.startsWith(searchTerm.toUpperCase())) {
                    lineMatches = true;
                } else if (base64Fingerprint != null && base64Fingerprint.startsWith(searchTerm)) {
                    lineMatches = true;
                } else if (searchTerm.length() == 4 && fingerprintSortedHexBlocks != null && Arrays.binarySearch(fingerprintSortedHexBlocks, searchTerm.toUpperCase()) >= 0) {
                    lineMatches = true;
                } else {
                    List<String> addresses = entry.getAddresses();
                    for (String address : addresses) {
                        if (!address.startsWith(searchTerm.toLowerCase()) && !address.startsWith("[" + searchTerm.toLowerCase())) continue;
                        lineMatches = true;
                        break;
                    }
                }
            }
            if (lineMatches) continue;
            removeRelays.add(e.getKey());
        }
        for (String fingerprint : removeRelays) {
            this.filteredRelays.remove(fingerprint);
        }
        HashSet<String> removeBridges = new HashSet<String>();
        for (Map.Entry<String, SummaryDocument> e : this.filteredBridges.entrySet()) {
            String nickname;
            String hashedFingerprint = e.getKey();
            SummaryDocument entry = e.getValue();
            boolean lineMatches = false;
            String string = nickname = entry.getNickname() != null ? entry.getNickname().toLowerCase() : "unnamed";
            if (searchTerm.startsWith("$")) {
                if (hashedFingerprint.startsWith(searchTerm.substring(1).toUpperCase())) {
                    lineMatches = true;
                }
            } else if (nickname.contains(searchTerm.toLowerCase())) {
                lineMatches = true;
            } else if (hashedFingerprint.startsWith(searchTerm.toUpperCase())) {
                lineMatches = true;
            }
            if (lineMatches) continue;
            removeBridges.add(e.getKey());
        }
        for (String fingerprint : removeBridges) {
            this.filteredBridges.remove(fingerprint);
        }
    }

    private void filterByLookup() {
        if (this.lookup == null) {
            return;
        }
        String fingerprint = this.lookup;
        SummaryDocument relayLine = this.filteredRelays.get(fingerprint);
        this.filteredRelays.clear();
        if (relayLine != null) {
            this.filteredRelays.put(fingerprint, relayLine);
        }
        SummaryDocument bridgeLine = this.filteredBridges.get(fingerprint);
        this.filteredBridges.clear();
        if (bridgeLine != null) {
            this.filteredBridges.put(fingerprint, bridgeLine);
        }
    }

    private void filterByFingerprint() {
        if (this.fingerprint == null) {
            return;
        }
        this.filteredRelays.clear();
        this.filteredBridges.clear();
        String fingerprint = this.fingerprint;
        SummaryDocument entry = this.documentStore.retrieve(SummaryDocument.class, true, fingerprint);
        if (entry != null) {
            if (entry.isRelay()) {
                this.filteredRelays.put(fingerprint, entry);
            } else {
                this.filteredBridges.put(fingerprint, entry);
            }
        }
    }

    private void filterByCountryCode() {
        if (this.country == null) {
            return;
        }
        String countryCode = this.country.toLowerCase();
        if (!this.nodeIndex.getRelaysByCountryCode().containsKey(countryCode)) {
            this.filteredRelays.clear();
        } else {
            Set<String> relaysWithCountryCode = this.nodeIndex.getRelaysByCountryCode().get(countryCode);
            HashSet<String> removeRelays = new HashSet<String>();
            for (String fingerprint : this.filteredRelays.keySet()) {
                if (relaysWithCountryCode.contains(fingerprint)) continue;
                removeRelays.add(fingerprint);
            }
            for (String fingerprint : removeRelays) {
                this.filteredRelays.remove(fingerprint);
            }
        }
        this.filteredBridges.clear();
    }

    private void filterByAsNumber() {
        if (this.as == null) {
            return;
        }
        String asNumber = this.as.toUpperCase();
        if (!asNumber.startsWith("AS")) {
            asNumber = "AS" + asNumber;
        }
        if (!this.nodeIndex.getRelaysByAsNumber().containsKey(asNumber)) {
            this.filteredRelays.clear();
        } else {
            Set<String> relaysWithAsNumber = this.nodeIndex.getRelaysByAsNumber().get(asNumber);
            HashSet<String> removeRelays = new HashSet<String>();
            for (String fingerprint : this.filteredRelays.keySet()) {
                if (relaysWithAsNumber.contains(fingerprint)) continue;
                removeRelays.add(fingerprint);
            }
            for (String fingerprint : removeRelays) {
                this.filteredRelays.remove(fingerprint);
            }
        }
        this.filteredBridges.clear();
    }

    private void filterByFlag() {
        if (this.flag == null) {
            return;
        }
        String flag = this.flag.toLowerCase();
        if (!this.nodeIndex.getRelaysByFlag().containsKey(flag)) {
            this.filteredRelays.clear();
        } else {
            Set<String> relaysWithFlag = this.nodeIndex.getRelaysByFlag().get(flag);
            HashSet<String> removeRelays = new HashSet<String>();
            for (String fingerprint : this.filteredRelays.keySet()) {
                if (relaysWithFlag.contains(fingerprint)) continue;
                removeRelays.add(fingerprint);
            }
            for (String fingerprint : removeRelays) {
                this.filteredRelays.remove(fingerprint);
            }
        }
        if (!this.nodeIndex.getBridgesByFlag().containsKey(flag)) {
            this.filteredBridges.clear();
        } else {
            Set<String> bridgesWithFlag = this.nodeIndex.getBridgesByFlag().get(flag);
            HashSet<String> removeBridges = new HashSet<String>();
            for (String fingerprint : this.filteredBridges.keySet()) {
                if (bridgesWithFlag.contains(fingerprint)) continue;
                removeBridges.add(fingerprint);
            }
            for (String fingerprint : removeBridges) {
                this.filteredBridges.remove(fingerprint);
            }
        }
    }

    private void filterNodesByFirstSeenDays() {
        if (this.firstSeenDays == null) {
            return;
        }
        this.filterNodesByDays(this.filteredRelays, this.nodeIndex.getRelaysByFirstSeenDays(), this.firstSeenDays);
        this.filterNodesByDays(this.filteredBridges, this.nodeIndex.getBridgesByFirstSeenDays(), this.firstSeenDays);
    }

    private void filterNodesByLastSeenDays() {
        if (this.lastSeenDays == null) {
            return;
        }
        this.filterNodesByDays(this.filteredRelays, this.nodeIndex.getRelaysByLastSeenDays(), this.lastSeenDays);
        this.filterNodesByDays(this.filteredBridges, this.nodeIndex.getBridgesByLastSeenDays(), this.lastSeenDays);
    }

    private void filterNodesByDays(Map<String, SummaryDocument> filteredNodes, SortedMap<Integer, Set<String>> nodesByDays, int[] days) {
        HashSet<String> removeNodes = new HashSet<String>();
        for (Set<String> nodes : nodesByDays.headMap(days[0]).values()) {
            removeNodes.addAll(nodes);
        }
        if (days[1] < Integer.MAX_VALUE) {
            for (Set<String> nodes : nodesByDays.tailMap(days[1] + 1).values()) {
                removeNodes.addAll(nodes);
            }
        }
        for (String fingerprint : removeNodes) {
            filteredNodes.remove(fingerprint);
        }
    }

    private void filterByContact() {
        if (this.contact == null) {
            return;
        }
        HashSet removeRelays = new HashSet();
        block0: for (Map.Entry<String, Set<String>> e : this.nodeIndex.getRelaysByContact().entrySet()) {
            String contact = e.getKey();
            for (String contactPart : this.contact) {
                if (contact != null && contact.contains(contactPart.toLowerCase())) continue;
                removeRelays.addAll(e.getValue());
                continue block0;
            }
        }
        for (String fingerprint : removeRelays) {
            this.filteredRelays.remove(fingerprint);
        }
        this.filteredBridges.clear();
    }

    private void filterByFamily() {
        if (this.family == null) {
            return;
        }
        HashSet<String> removeRelays = new HashSet<String>(this.filteredRelays.keySet());
        removeRelays.remove(this.family);
        if (this.nodeIndex.getRelaysByFamily().containsKey(this.family)) {
            removeRelays.removeAll((Collection)this.nodeIndex.getRelaysByFamily().get(this.family));
        }
        for (String fingerprint : removeRelays) {
            this.filteredRelays.remove(fingerprint);
        }
        this.filteredBridges.clear();
    }

    private void filterByVersion() {
        if (null == this.version) {
            return;
        }
        HashSet keepRelays = new HashSet();
        for (Map.Entry<String, Set<String>> e : this.nodeIndex.getRelaysByVersion().entrySet()) {
            if (!e.getKey().startsWith(this.version)) continue;
            keepRelays.addAll(e.getValue());
        }
        this.filteredRelays.keySet().retainAll(keepRelays);
        HashSet keepBridges = new HashSet();
        for (Map.Entry<String, Set<String>> e : this.nodeIndex.getBridgesByVersion().entrySet()) {
            if (!e.getKey().startsWith(this.version)) continue;
            keepBridges.addAll(e.getValue());
        }
        this.filteredBridges.keySet().retainAll(keepBridges);
    }

    private void filterByHostName() {
        if (this.hostName == null) {
            return;
        }
        String hostName = this.hostName.toLowerCase();
        HashSet<String> removeRelays = new HashSet<String>(this.filteredRelays.keySet());
        for (Map.Entry<String, Set<String>> e : this.nodeIndex.getRelaysByHostName().entrySet()) {
            if (!e.getKey().endsWith(hostName)) continue;
            removeRelays.removeAll((Collection)e.getValue());
        }
        for (String fingerprint : removeRelays) {
            this.filteredRelays.remove(fingerprint);
        }
        this.filteredBridges.clear();
    }

    private void filterByRecommendedVersion() {
        if (null == this.recommendedVersion) {
            return;
        }
        Set<String> keepRelays = this.nodeIndex.getRelaysByRecommendedVersion().get(this.recommendedVersion);
        this.filteredRelays.keySet().retainAll(keepRelays);
        Set<String> keepBridges = this.nodeIndex.getBridgesByRecommendedVersion().get(this.recommendedVersion);
        this.filteredBridges.keySet().retainAll(keepBridges);
    }

    private void order() {
        ArrayList<SummaryDocument> uniqueRelays = new ArrayList<SummaryDocument>();
        ArrayList<SummaryDocument> uniqueBridges = new ArrayList<SummaryDocument>();
        for (SummaryDocument relay : this.filteredRelays.values()) {
            if (uniqueRelays.contains(relay)) continue;
            uniqueRelays.add(relay);
        }
        for (SummaryDocument bridge : this.filteredBridges.values()) {
            if (uniqueBridges.contains(bridge)) continue;
            uniqueBridges.add(bridge);
        }
        SummaryDocumentComparator comparator = new SummaryDocumentComparator(this.order);
        Collections.sort(uniqueRelays, comparator);
        Collections.sort(uniqueBridges, comparator);
        this.orderedRelays.addAll(uniqueRelays);
        this.orderedBridges.addAll(uniqueBridges);
    }

    public int getRelaysSkipped() {
        return this.relaysSkipped;
    }

    public int getBridgesSkipped() {
        return this.bridgesSkipped;
    }

    private void offset() {
        if (this.offset == null) {
            return;
        }
        int offsetValue = Integer.parseInt(this.offset);
        while (!(offsetValue-- <= 0 || this.orderedRelays.isEmpty() && this.orderedBridges.isEmpty())) {
            if (!this.orderedRelays.isEmpty()) {
                this.orderedRelays.remove(0);
                ++this.relaysSkipped;
                continue;
            }
            this.orderedBridges.remove(0);
            ++this.bridgesSkipped;
        }
    }

    public int getRelaysTruncated() {
        return this.relaysTruncated;
    }

    public int getBridgesTruncated() {
        return this.bridgesTruncated;
    }

    private void limit() {
        if (this.limit == null) {
            return;
        }
        int limitValue = Integer.parseInt(this.limit);
        while (!this.orderedRelays.isEmpty() && limitValue < this.orderedRelays.size()) {
            this.orderedRelays.remove(this.orderedRelays.size() - 1);
            ++this.relaysTruncated;
        }
        limitValue -= this.orderedRelays.size();
        while (!this.orderedBridges.isEmpty() && limitValue < this.orderedBridges.size()) {
            this.orderedBridges.remove(this.orderedBridges.size() - 1);
            ++this.bridgesTruncated;
        }
    }

    public List<SummaryDocument> getOrderedRelays() {
        return this.orderedRelays;
    }

    public List<SummaryDocument> getOrderedBridges() {
        return this.orderedBridges;
    }

    public String getRelaysPublishedString() {
        return this.nodeIndex.getRelaysPublishedString();
    }

    public String getBridgesPublishedString() {
        return this.nodeIndex.getBridgesPublishedString();
    }
}

