/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;

public enum FileType {
    BZ2(BZip2CompressorInputStream.class, BZip2CompressorOutputStream.class),
    GZ(GzipCompressorInputStream.class, GzipCompressorOutputStream.class),
    JSON(BufferedInputStream.class, BufferedOutputStream.class),
    PLAIN(BufferedInputStream.class, BufferedOutputStream.class),
    XZ(XZCompressorInputStream.class, XZCompressorOutputStream.class);

    private final Class<? extends InputStream> inClass;
    private final Class<? extends OutputStream> outClass;

    private FileType(Class<? extends InputStream> in, Class<? extends OutputStream> out) {
        this.inClass = in;
        this.outClass = out;
    }

    public static FileType findType(String ext) {
        FileType res = null;
        try {
            res = FileType.valueOf(ext.toUpperCase());
            return res;
        }
        catch (IllegalArgumentException | NullPointerException re) {
            return PLAIN;
        }
    }

    public InputStream inputStream(InputStream is) throws Exception {
        return this.inClass.getConstructor(InputStream.class).newInstance(is);
    }

    public OutputStream outputStream(OutputStream os) throws Exception {
        return this.outClass.getConstructor(OutputStream.class).newInstance(os);
    }
}

