/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.util;

public class FormattingUtils {
    private static final long ONE_SECOND = 1000L;
    private static final long ONE_MINUTE = 60000L;

    private FormattingUtils() {
    }

    public static String formatMillis(long millis) {
        return String.format("%02d:%02d.%03d minutes", millis / 60000L, millis % 60000L / 1000L, millis % 1000L);
    }

    public static String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(1024.0));
        return String.format("%.1f %siB", (double)bytes / Math.pow(1024.0, exp), Character.valueOf("KMGTPE".charAt(exp - 1)));
    }

    public static String formatDecimalNumber(long decimalNumber) {
        return String.format("%,d", decimalNumber);
    }
}

