/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.docs;

import java.util.Comparator;
import java.util.Map;
import java.util.Scanner;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.onionoo.docs.DateTimeHelper;
import org.torproject.onionoo.docs.Document;

public class WeightsStatus
extends Document {
    private static final Logger log = LoggerFactory.getLogger(WeightsStatus.class);
    private transient boolean isDirty = false;
    private Comparator<long[]> histComparator = new Comparator<long[]>(){

        @Override
        public int compare(long[] first, long[] second) {
            int relation = Long.compare(first[0], second[0]);
            if (0 != relation) {
                return relation;
            }
            return Long.compare(first[1], second[1]);
        }
    };
    private SortedMap<long[], double[]> history = new TreeMap<long[], double[]>(this.histComparator);

    public boolean isDirty() {
        return this.isDirty;
    }

    public void clearDirty() {
        this.isDirty = false;
    }

    public void setHistory(SortedMap<long[], double[]> history) {
        this.history = history;
    }

    public SortedMap<long[], double[]> getHistory() {
        return this.history;
    }

    @Override
    public void setFromDocumentString(String documentString) {
        try (Scanner s = new Scanner(documentString);){
            while (s.hasNextLine()) {
                double[] weights;
                long[] interval;
                block19: {
                    String line = s.nextLine();
                    String[] parts = line.split(" ", 11);
                    if (parts.length == 2) continue;
                    if (parts.length != 9 && parts.length != 11) {
                        log.error("Illegal line '" + line + "' in weights status file.  Skipping this line.");
                        continue;
                    }
                    if (parts[4].equals("NaN")) continue;
                    long validAfterMillis = DateTimeHelper.parse(parts[0] + " " + parts[1]);
                    long freshUntilMillis = DateTimeHelper.parse(parts[2] + " " + parts[3]);
                    if (validAfterMillis < 0L || freshUntilMillis < 0L) {
                        log.error("Could not parse timestamp while reading weights status file.  Skipping.");
                        break;
                    }
                    if (validAfterMillis > freshUntilMillis) {
                        log.error("Illegal dates in '" + line + "' of weights status file.  Skipping.");
                        break;
                    }
                    interval = new long[]{validAfterMillis, freshUntilMillis};
                    try {
                        weights = new double[]{-1.0, this.parseWeightDouble(parts[5]), this.parseWeightDouble(parts[6]), this.parseWeightDouble(parts[7]), this.parseWeightDouble(parts[8]), -1.0, -1.0};
                        if (parts.length != 11) break block19;
                        weights[6] = this.parseWeightDouble(parts[10]);
                    }
                    catch (NumberFormatException e) {
                        log.error("Could not parse weights values in line '" + line + "' while reading weights status file.  Skipping.");
                        break;
                    }
                }
                this.history.put(interval, weights);
            }
        }
    }

    private double parseWeightDouble(String in) throws NumberFormatException {
        return in.isEmpty() || in.startsWith("-") ? Double.NaN : Double.parseDouble(in);
    }

    public void addToHistory(long validAfterMillis, long freshUntilMillis, double[] weights) {
        long[] interval = new long[]{validAfterMillis, freshUntilMillis};
        if ((this.history.headMap(interval).isEmpty() || this.history.headMap(interval).lastKey()[1] <= validAfterMillis) && (this.history.tailMap(interval).isEmpty() || this.history.tailMap(interval).firstKey()[0] >= freshUntilMillis)) {
            this.history.put(interval, weights);
            this.isDirty = true;
        }
    }

    public void compressHistory(long lastSeenMillis) {
        TreeMap<long[], double[]> uncompressedHistory = new TreeMap<long[], double[]>(this.histComparator);
        uncompressedHistory.putAll(this.history);
        this.history.clear();
        long lastStartMillis = 0L;
        long lastEndMillis = 0L;
        double[] lastWeights = null;
        String lastMonthString = "1970-01";
        int lastMissingValues = -1;
        for (Map.Entry e : uncompressedHistory.entrySet()) {
            long startMillis = ((long[])e.getKey())[0];
            long endMillis = ((long[])e.getKey())[1];
            double[] weights = (double[])e.getValue();
            long intervalLengthMillis = lastSeenMillis - endMillis <= 604800000L ? 3600000L : (lastSeenMillis - endMillis <= 2678400000L ? 14400000L : (lastSeenMillis - endMillis <= 15811200000L ? 86400000L : (lastSeenMillis - endMillis <= 31622400000L ? 172800000L : 864000000L)));
            String monthString = DateTimeHelper.format(startMillis, "yyyy-MM");
            int missingValues = 0;
            for (int i = 0; i < weights.length; ++i) {
                if (!Double.valueOf(weights[i]).isNaN()) continue;
                missingValues += 1 << i;
            }
            if (lastEndMillis == startMillis && (lastEndMillis - 1L) / intervalLengthMillis == (endMillis - 1L) / intervalLengthMillis && lastMonthString.equals(monthString) && lastMissingValues == missingValues) {
                double lastIntervalInHours = (lastEndMillis - lastStartMillis) / 3600000L;
                double currentIntervalInHours = (endMillis - startMillis) / 3600000L;
                double newIntervalInHours = (endMillis - lastStartMillis) / 3600000L;
                int i = 0;
                while (i < lastWeights.length) {
                    int n = i;
                    lastWeights[n] = lastWeights[n] * lastIntervalInHours;
                    int n2 = i;
                    lastWeights[n2] = lastWeights[n2] + weights[i] * currentIntervalInHours;
                    int n3 = i++;
                    lastWeights[n3] = lastWeights[n3] / newIntervalInHours;
                }
                lastEndMillis = endMillis;
            } else {
                if (lastStartMillis > 0L) {
                    this.history.put(new long[]{lastStartMillis, lastEndMillis}, lastWeights);
                }
                lastStartMillis = startMillis;
                lastEndMillis = endMillis;
                lastWeights = weights;
            }
            lastMonthString = monthString;
            lastMissingValues = missingValues;
        }
        if (lastStartMillis > 0L) {
            this.history.put(new long[]{lastStartMillis, lastEndMillis}, lastWeights);
        }
    }

    @Override
    public String toDocumentString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<long[], double[]> e : this.history.entrySet()) {
            long[] fresh = e.getKey();
            double[] weights = e.getValue();
            sb.append(DateTimeHelper.format(fresh[0]) + " " + DateTimeHelper.format(fresh[1]));
            for (int i = 0; i < weights.length; ++i) {
                sb.append(" ");
                if (i == 0 || i == 5 || Double.valueOf(weights[i]).isNaN()) continue;
                sb.append(String.format("%.12f", weights[i]));
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

