/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.updater;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorCollector;
import org.torproject.descriptor.DescriptorSourceFactory;
import org.torproject.onionoo.updater.DescriptorHistory;
import org.torproject.onionoo.updater.DescriptorListener;
import org.torproject.onionoo.updater.DescriptorQueue;
import org.torproject.onionoo.updater.DescriptorType;
import org.torproject.onionoo.util.FormattingUtils;

public class DescriptorSource {
    private static final Logger log = LoggerFactory.getLogger(DescriptorSource.class);
    private final File inDir = new File("in");
    private final File inRecentDir = new File(this.inDir, "recent");
    private final File inArchiveDir = new File(this.inDir, "archive");
    private final File statusDir = new File("status");
    private List<DescriptorQueue> descriptorQueues = new ArrayList<DescriptorQueue>();
    private DescriptorQueue archiveDescriptorQueue;
    private Map<DescriptorType, Set<DescriptorListener>> descriptorListeners = new HashMap<DescriptorType, Set<DescriptorListener>>();

    private DescriptorQueue getDescriptorQueue(DescriptorType descriptorType, DescriptorHistory descriptorHistory) {
        DescriptorQueue descriptorQueue = new DescriptorQueue(this.inRecentDir, descriptorType, this.statusDir);
        if (descriptorHistory != null) {
            descriptorQueue.readHistoryFile(descriptorHistory);
        }
        this.descriptorQueues.add(descriptorQueue);
        return descriptorQueue;
    }

    public void registerDescriptorListener(DescriptorListener listener, DescriptorType descriptorType) {
        if (!this.descriptorListeners.containsKey((Object)descriptorType)) {
            this.descriptorListeners.put(descriptorType, new HashSet());
        }
        this.descriptorListeners.get((Object)descriptorType).add(listener);
    }

    public void downloadDescriptors() {
        ArrayList<String> remoteDirectories = new ArrayList<String>();
        for (DescriptorType descriptorType : DescriptorType.values()) {
            remoteDirectories.add("/recent/" + descriptorType.getDir());
        }
        DescriptorCollector dc = DescriptorSourceFactory.createDescriptorCollector();
        dc.collectDescriptors("https://collector.torproject.org", remoteDirectories.toArray(new String[0]), 0L, this.inDir, true);
    }

    public void readDescriptors() {
        this.readArchivedDescriptors();
        log.debug("Reading recent {} ...", (Object)DescriptorType.RELAY_SERVER_DESCRIPTORS);
        this.readDescriptors(DescriptorType.RELAY_SERVER_DESCRIPTORS, DescriptorHistory.RELAY_SERVER_HISTORY, true);
        log.debug("Reading recent {} ...", (Object)DescriptorType.RELAY_EXTRA_INFOS);
        this.readDescriptors(DescriptorType.RELAY_EXTRA_INFOS, DescriptorHistory.RELAY_EXTRAINFO_HISTORY, true);
        log.debug("Reading recent {} ...", (Object)DescriptorType.EXIT_LISTS);
        this.readDescriptors(DescriptorType.EXIT_LISTS, DescriptorHistory.EXIT_LIST_HISTORY, true);
        log.debug("Reading recent {} ...", (Object)DescriptorType.RELAY_CONSENSUSES);
        this.readDescriptors(DescriptorType.RELAY_CONSENSUSES, DescriptorHistory.RELAY_CONSENSUS_HISTORY, true);
        log.debug("Reading recent {} ...", (Object)DescriptorType.BRIDGE_SERVER_DESCRIPTORS);
        this.readDescriptors(DescriptorType.BRIDGE_SERVER_DESCRIPTORS, DescriptorHistory.BRIDGE_SERVER_HISTORY, false);
        log.debug("Reading recent {} ...", (Object)DescriptorType.BRIDGE_EXTRA_INFOS);
        this.readDescriptors(DescriptorType.BRIDGE_EXTRA_INFOS, DescriptorHistory.BRIDGE_EXTRAINFO_HISTORY, false);
        log.debug("Reading recent {} ...", (Object)DescriptorType.BRIDGE_STATUSES);
        this.readDescriptors(DescriptorType.BRIDGE_STATUSES, DescriptorHistory.BRIDGE_STATUS_HISTORY, false);
    }

    private void readDescriptors(DescriptorType descriptorType, DescriptorHistory descriptorHistory, boolean relay) {
        Descriptor descriptor;
        if (!this.descriptorListeners.containsKey((Object)descriptorType)) {
            return;
        }
        Set<DescriptorListener> descriptorListeners = this.descriptorListeners.get((Object)descriptorType);
        DescriptorQueue descriptorQueue = this.getDescriptorQueue(descriptorType, descriptorHistory);
        while ((descriptor = descriptorQueue.nextDescriptor()) != null) {
            for (DescriptorListener descriptorListener : descriptorListeners) {
                descriptorListener.processDescriptor(descriptor, relay);
            }
        }
        log.info("Read recent/{}.", (Object)descriptorType.getDir());
    }

    public void readArchivedDescriptors() {
        Descriptor descriptor;
        if (!this.inArchiveDir.exists()) {
            return;
        }
        log.info("Reading archived descriptors...");
        this.archiveDescriptorQueue = new DescriptorQueue(this.inArchiveDir, null, this.statusDir);
        this.archiveDescriptorQueue.readHistoryFile(DescriptorHistory.ARCHIVED_HISTORY);
        while ((descriptor = this.archiveDescriptorQueue.nextDescriptor()) != null) {
            DescriptorType descriptorType = null;
            boolean relay = false;
            for (String annotation : descriptor.getAnnotations()) {
                if (annotation.startsWith("@type network-status-consensus-3 1.")) {
                    descriptorType = DescriptorType.RELAY_CONSENSUSES;
                    relay = true;
                    continue;
                }
                if (annotation.startsWith("@type server-descriptor 1.")) {
                    descriptorType = DescriptorType.RELAY_SERVER_DESCRIPTORS;
                    relay = true;
                    continue;
                }
                if (annotation.startsWith("@type extra-info 1.")) {
                    descriptorType = DescriptorType.RELAY_EXTRA_INFOS;
                    relay = true;
                    continue;
                }
                if (annotation.startsWith("@type tordnsel 1.")) {
                    descriptorType = DescriptorType.EXIT_LISTS;
                    relay = true;
                    continue;
                }
                if (annotation.startsWith("@type bridge-network-status 1.")) {
                    descriptorType = DescriptorType.BRIDGE_STATUSES;
                    relay = false;
                    continue;
                }
                if (annotation.startsWith("@type bridge-server-descriptor 1.")) {
                    descriptorType = DescriptorType.BRIDGE_SERVER_DESCRIPTORS;
                    relay = false;
                    continue;
                }
                if (!annotation.startsWith("@type bridge-extra-info 1.")) continue;
                descriptorType = DescriptorType.BRIDGE_EXTRA_INFOS;
                relay = false;
            }
            if (descriptorType == null) {
                log.warn("Unrecognized descriptor in " + this.inArchiveDir.getAbsolutePath() + " with annotations " + descriptor.getAnnotations() + ".  Skipping descriptor.");
                continue;
            }
            for (DescriptorListener descriptorListener : this.descriptorListeners.get((Object)descriptorType)) {
                descriptorListener.processDescriptor(descriptor, relay);
            }
        }
        this.archiveDescriptorQueue.writeHistoryFile();
        log.info("Read archived descriptors");
    }

    public void writeHistoryFiles() {
        log.debug("Writing parse histories for recent descriptors...");
        for (DescriptorQueue descriptorQueue : this.descriptorQueues) {
            descriptorQueue.writeHistoryFile();
        }
    }

    public String getStatsString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    ").append(this.descriptorQueues.size()).append(" descriptor ").append("queues created for recent descriptors\n");
        int historySizeBefore = 0;
        int historySizeAfter = 0;
        long descriptors = 0L;
        long bytes = 0L;
        for (DescriptorQueue descriptorQueue : this.descriptorQueues) {
            historySizeBefore += descriptorQueue.getHistorySizeBefore();
            historySizeAfter += descriptorQueue.getHistorySizeAfter();
            descriptors += descriptorQueue.getReturnedDescriptors();
            bytes += descriptorQueue.getReturnedBytes();
        }
        sb.append("    ").append(FormattingUtils.formatDecimalNumber(historySizeBefore)).append(" recent descriptors excluded from this ").append("execution\n");
        sb.append("    ").append(FormattingUtils.formatDecimalNumber(descriptors)).append(" recent descriptors provided\n");
        sb.append("    ").append(FormattingUtils.formatBytes(bytes)).append(" of recent descriptors provided\n");
        sb.append("    ").append(FormattingUtils.formatDecimalNumber(historySizeAfter)).append(" recent descriptors excluded from next ").append("execution\n");
        if (this.archiveDescriptorQueue != null) {
            sb.append("    ").append(FormattingUtils.formatDecimalNumber(this.archiveDescriptorQueue.getReturnedDescriptors())).append(" archived descriptors provided\n");
            sb.append("    ").append(FormattingUtils.formatBytes(this.archiveDescriptorQueue.getReturnedBytes())).append(" of ").append("archived descriptors provided\n");
        }
        return sb.toString();
    }
}

