/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator.qdox.model.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.hamcrest.generator.qdox.model.Annotation;
import org.hamcrest.generator.qdox.model.JavaClass;
import org.hamcrest.generator.qdox.model.JavaField;
import org.hamcrest.generator.qdox.model.annotation.AnnotationAdd;
import org.hamcrest.generator.qdox.model.annotation.AnnotationAnd;
import org.hamcrest.generator.qdox.model.annotation.AnnotationCast;
import org.hamcrest.generator.qdox.model.annotation.AnnotationConstant;
import org.hamcrest.generator.qdox.model.annotation.AnnotationDivide;
import org.hamcrest.generator.qdox.model.annotation.AnnotationEquals;
import org.hamcrest.generator.qdox.model.annotation.AnnotationExclusiveOr;
import org.hamcrest.generator.qdox.model.annotation.AnnotationFieldRef;
import org.hamcrest.generator.qdox.model.annotation.AnnotationGreaterEquals;
import org.hamcrest.generator.qdox.model.annotation.AnnotationGreaterThan;
import org.hamcrest.generator.qdox.model.annotation.AnnotationLessEquals;
import org.hamcrest.generator.qdox.model.annotation.AnnotationLessThan;
import org.hamcrest.generator.qdox.model.annotation.AnnotationLogicalAnd;
import org.hamcrest.generator.qdox.model.annotation.AnnotationLogicalNot;
import org.hamcrest.generator.qdox.model.annotation.AnnotationLogicalOr;
import org.hamcrest.generator.qdox.model.annotation.AnnotationMinusSign;
import org.hamcrest.generator.qdox.model.annotation.AnnotationMultiply;
import org.hamcrest.generator.qdox.model.annotation.AnnotationNot;
import org.hamcrest.generator.qdox.model.annotation.AnnotationNotEquals;
import org.hamcrest.generator.qdox.model.annotation.AnnotationOr;
import org.hamcrest.generator.qdox.model.annotation.AnnotationParenExpression;
import org.hamcrest.generator.qdox.model.annotation.AnnotationPlusSign;
import org.hamcrest.generator.qdox.model.annotation.AnnotationQuery;
import org.hamcrest.generator.qdox.model.annotation.AnnotationRemainder;
import org.hamcrest.generator.qdox.model.annotation.AnnotationShiftLeft;
import org.hamcrest.generator.qdox.model.annotation.AnnotationShiftRight;
import org.hamcrest.generator.qdox.model.annotation.AnnotationSubtract;
import org.hamcrest.generator.qdox.model.annotation.AnnotationTypeRef;
import org.hamcrest.generator.qdox.model.annotation.AnnotationUnsignedShiftRight;
import org.hamcrest.generator.qdox.model.annotation.AnnotationValue;
import org.hamcrest.generator.qdox.model.annotation.AnnotationValueList;
import org.hamcrest.generator.qdox.model.annotation.AnnotationVisitor;

public abstract class EvaluatingVisitor
implements AnnotationVisitor {
    public Object getValue(Annotation annotation, String property) {
        Object result = null;
        AnnotationValue value = annotation.getProperty(property);
        if (value != null) {
            result = value.accept(this);
        }
        return result;
    }

    public List getListValue(Annotation annotation, String property) {
        Object value = this.getValue(annotation, property);
        List<Object> list = null;
        if (value != null) {
            list = value instanceof List ? (List<Object>)value : Collections.singletonList(value);
        }
        return list;
    }

    protected static Class resultType(Object left, Object right) {
        Class<Object> type = Void.TYPE;
        if (left instanceof String || right instanceof String) {
            type = String.class;
        } else if (left instanceof Number && right instanceof Number) {
            type = left instanceof Double || right instanceof Double ? Double.class : (left instanceof Float || right instanceof Float ? Float.class : (left instanceof Long || right instanceof Long ? Long.class : Integer.class));
        }
        return type;
    }

    protected static Class numericResultType(Object left, Object right) {
        Class<Object> type = Void.TYPE;
        if (left instanceof Number && right instanceof Number) {
            if (left instanceof Long || right instanceof Long) {
                type = Long.class;
            } else if (left instanceof Integer || right instanceof Integer) {
                type = Integer.class;
            }
        }
        return type;
    }

    protected static Class unaryNumericResultType(Object value) {
        Class<Object> type = Void.TYPE;
        if (value instanceof Byte || value instanceof Short || value instanceof Character || value instanceof Integer) {
            type = Integer.class;
        } else if (value instanceof Long) {
            value = Long.class;
        }
        return type;
    }

    protected static Class unaryResultType(Object value) {
        Class type = EvaluatingVisitor.unaryNumericResultType(value);
        if (type == Void.TYPE) {
            if (value instanceof Float) {
                value = Float.class;
            } else if (value instanceof Double) {
                value = Double.class;
            }
        }
        return type;
    }

    public Object visitAnnotation(Annotation annotation) {
        throw new UnsupportedOperationException("Illegal annotation value '" + annotation + "'.");
    }

    public Object visitAnnotationAdd(AnnotationAdd op) {
        Object result;
        Object right;
        Object left = op.getLeft().accept(this);
        Class type = EvaluatingVisitor.resultType(left, right = op.getRight().accept(this));
        if (type == String.class) {
            result = left.toString() + right.toString();
        } else if (type == Double.class) {
            result = new Double(((Number)left).doubleValue() + ((Number)right).doubleValue());
        } else if (type == Float.class) {
            result = new Float(((Number)left).floatValue() + ((Number)right).floatValue());
        } else if (type == Long.class) {
            result = new Long(((Number)left).longValue() + ((Number)right).longValue());
        } else if (type == Integer.class) {
            result = new Integer(((Number)left).intValue() + ((Number)right).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + op + "'.");
        }
        return result;
    }

    public Object visitAnnotationConstant(AnnotationConstant constant) {
        return constant.getValue();
    }

    public Object visitAnnotationDivide(AnnotationDivide op) {
        Number result;
        Object right;
        Object left = op.getLeft().accept(this);
        Class type = EvaluatingVisitor.resultType(left, right = op.getRight().accept(this));
        if (type == Double.class) {
            result = new Double(((Number)left).doubleValue() / ((Number)right).doubleValue());
        } else if (type == Float.class) {
            result = new Float(((Number)left).floatValue() / ((Number)right).floatValue());
        } else if (type == Long.class) {
            result = new Long(((Number)left).longValue() / ((Number)right).longValue());
        } else if (type == Integer.class) {
            result = new Integer(((Number)left).intValue() / ((Number)right).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + op + "'.");
        }
        return result;
    }

    public Object visitAnnotationFieldRef(AnnotationFieldRef fieldRef) {
        JavaField javaField = fieldRef.getField();
        if (javaField == null) {
            throw new IllegalArgumentException("Cannot resolve field reference '" + fieldRef + "'.");
        }
        if (!javaField.isFinal() || !javaField.isStatic()) {
            throw new IllegalArgumentException("Field reference '" + fieldRef + "' must be static and final.");
        }
        Object result = this.getFieldReferenceValue(javaField);
        return result;
    }

    protected abstract Object getFieldReferenceValue(JavaField var1);

    public Object visitAnnotationGreaterThan(AnnotationGreaterThan op) {
        boolean result;
        Object right;
        Object left = op.getLeft().accept(this);
        Class type = EvaluatingVisitor.resultType(left, right = op.getRight().accept(this));
        if (type == Double.class) {
            result = ((Number)left).doubleValue() > ((Number)right).doubleValue();
        } else if (type == Float.class) {
            result = ((Number)left).floatValue() > ((Number)right).floatValue();
        } else if (type == Long.class) {
            result = ((Number)left).longValue() > ((Number)right).longValue();
        } else if (type == Integer.class) {
            result = ((Number)left).intValue() > ((Number)right).intValue();
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + op + "'.");
        }
        return result ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object visitAnnotationLessThan(AnnotationLessThan op) {
        boolean result;
        Object right;
        Object left = op.getLeft().accept(this);
        Class type = EvaluatingVisitor.resultType(left, right = op.getRight().accept(this));
        if (type == Double.class) {
            result = ((Number)left).doubleValue() < ((Number)right).doubleValue();
        } else if (type == Float.class) {
            result = ((Number)left).floatValue() < ((Number)right).floatValue();
        } else if (type == Long.class) {
            result = ((Number)left).longValue() < ((Number)right).longValue();
        } else if (type == Integer.class) {
            result = ((Number)left).intValue() < ((Number)right).intValue();
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + op + "'.");
        }
        return result ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object visitAnnotationMultiply(AnnotationMultiply op) {
        Number result;
        Object right;
        Object left = op.getLeft().accept(this);
        Class type = EvaluatingVisitor.resultType(left, right = op.getRight().accept(this));
        if (type == Double.class) {
            result = new Double(((Number)left).doubleValue() * ((Number)right).doubleValue());
        } else if (type == Float.class) {
            result = new Float(((Number)left).floatValue() * ((Number)right).floatValue());
        } else if (type == Long.class) {
            result = new Long(((Number)left).longValue() * ((Number)right).longValue());
        } else if (type == Integer.class) {
            result = new Integer(((Number)left).intValue() * ((Number)right).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + op + "'.");
        }
        return result;
    }

    public Object visitAnnotationParenExpression(AnnotationParenExpression parenExpression) {
        return parenExpression.getValue().accept(this);
    }

    public Object visitAnnotationSubtract(AnnotationSubtract op) {
        Number result;
        Object right;
        Object left = op.getLeft().accept(this);
        Class type = EvaluatingVisitor.resultType(left, right = op.getRight().accept(this));
        if (type == Double.class) {
            result = new Double(((Number)left).doubleValue() - ((Number)right).doubleValue());
        } else if (type == Float.class) {
            result = new Float(((Number)left).floatValue() - ((Number)right).floatValue());
        } else if (type == Long.class) {
            result = new Long(((Number)left).longValue() - ((Number)right).longValue());
        } else if (type == Integer.class) {
            result = new Integer(((Number)left).intValue() - ((Number)right).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + op + "'.");
        }
        return result;
    }

    public Object visitAnnotationTypeRef(AnnotationTypeRef typeRef) {
        JavaClass javaClass = typeRef.getType().getJavaClass();
        return javaClass;
    }

    public Object visitAnnotationValueList(AnnotationValueList valueList) {
        ArrayList<Object> list = new ArrayList<Object>();
        ListIterator i = valueList.getValueList().listIterator();
        while (i.hasNext()) {
            AnnotationValue value = (AnnotationValue)i.next();
            Object v = value.accept(this);
            list.add(v);
        }
        return list;
    }

    public Object visitAnnotationAnd(AnnotationAnd and) {
        Number result;
        Object right;
        Object left = and.getLeft().accept(this);
        Class type = EvaluatingVisitor.numericResultType(left, right = and.getRight().accept(this));
        if (type == Long.class) {
            result = new Long(((Number)left).longValue() & ((Number)right).longValue());
        } else if (type == Integer.class) {
            result = new Integer(((Number)left).intValue() & ((Number)right).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + and + "'.");
        }
        return result;
    }

    public Object visitAnnotationGreaterEquals(AnnotationGreaterEquals greaterEquals) {
        boolean result;
        Object right;
        Object left = greaterEquals.getLeft().accept(this);
        Class type = EvaluatingVisitor.resultType(left, right = greaterEquals.getRight().accept(this));
        if (type == Double.class) {
            result = ((Number)left).doubleValue() >= ((Number)right).doubleValue();
        } else if (type == Float.class) {
            result = ((Number)left).floatValue() >= ((Number)right).floatValue();
        } else if (type == Long.class) {
            result = ((Number)left).longValue() >= ((Number)right).longValue();
        } else if (type == Integer.class) {
            result = ((Number)left).intValue() >= ((Number)right).intValue();
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + greaterEquals + "'.");
        }
        return result ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object visitAnnotationLessEquals(AnnotationLessEquals lessEquals) {
        boolean result;
        Object right;
        Object left = lessEquals.getLeft().accept(this);
        Class type = EvaluatingVisitor.resultType(left, right = lessEquals.getRight().accept(this));
        if (type == Double.class) {
            result = ((Number)left).doubleValue() <= ((Number)right).doubleValue();
        } else if (type == Float.class) {
            result = ((Number)left).floatValue() <= ((Number)right).floatValue();
        } else if (type == Long.class) {
            result = ((Number)left).longValue() <= ((Number)right).longValue();
        } else if (type == Integer.class) {
            result = ((Number)left).intValue() <= ((Number)right).intValue();
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + lessEquals + "'.");
        }
        return result ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object visitAnnotationLogicalAnd(AnnotationLogicalAnd and) {
        Object left = and.getLeft().accept(this);
        Object right = and.getRight().accept(this);
        if (!(left instanceof Boolean) || !(right instanceof Boolean)) {
            throw new IllegalArgumentException("Cannot evaluate '" + and + "'.");
        }
        boolean result = (Boolean)left != false && (Boolean)right != false;
        return result ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object visitAnnotationLogicalNot(AnnotationLogicalNot not) {
        Object value = not.getValue().accept(this);
        if (!(value instanceof Boolean)) {
            throw new IllegalArgumentException("Cannot evaluate '" + not + "'.");
        }
        boolean result = (Boolean)value == false;
        return result ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object visitAnnotationLogicalOr(AnnotationLogicalOr or) {
        Object left = or.getLeft().accept(this);
        Object right = or.getRight().accept(this);
        if (!(left instanceof Boolean) || !(right instanceof Boolean)) {
            throw new IllegalArgumentException("Cannot evaluate '" + or + "'.");
        }
        boolean result = (Boolean)left != false || (Boolean)right != false;
        return result ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object visitAnnotationMinusSign(AnnotationMinusSign sign) {
        Number result;
        Object value = sign.getValue().accept(this);
        Class type = EvaluatingVisitor.unaryResultType(value);
        if (type == Integer.class) {
            result = new Integer(-((Integer)value).intValue());
        } else if (type == Long.class) {
            result = new Long(-((Long)value).longValue());
        } else if (type == Float.class) {
            result = new Float(-((Float)value).floatValue());
        } else if (type == Double.class) {
            result = new Double(-((Double)value).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + sign + "'.");
        }
        return result;
    }

    public Object visitAnnotationNot(AnnotationNot not) {
        Number result;
        Object value = not.getValue().accept(this);
        Class type = EvaluatingVisitor.unaryNumericResultType(value);
        if (type == Long.class) {
            result = new Long((long)((Long)value ^ 0xFFFFFFFFFFFFFFFFL));
        } else if (type == Integer.class) {
            result = new Integer(~((Integer)value).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + not + "'.");
        }
        return result;
    }

    public Object visitAnnotationOr(AnnotationOr or) {
        Number result;
        Object right;
        Object left = or.getLeft().accept(this);
        Class type = EvaluatingVisitor.numericResultType(left, right = or.getRight().accept(this));
        if (type == Long.class) {
            result = new Long(((Number)left).longValue() | ((Number)right).longValue());
        } else if (type == Integer.class) {
            result = new Integer(((Number)left).intValue() | ((Number)right).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + or + "'.");
        }
        return result;
    }

    public Object visitAnnotationPlusSign(AnnotationPlusSign sign) {
        Object value = sign.getValue().accept(this);
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("Cannot evaluate '" + sign + "'.");
        }
        Object result = value;
        return result;
    }

    public Object visitAnnotationRemainder(AnnotationRemainder remainder) {
        Number result;
        Object right;
        Object left = remainder.getLeft().accept(this);
        Class type = EvaluatingVisitor.resultType(left, right = remainder.getRight().accept(this));
        if (type == Double.class) {
            result = new Double(((Number)left).doubleValue() % ((Number)right).doubleValue());
        } else if (type == Float.class) {
            result = new Float(((Number)left).floatValue() % ((Number)right).floatValue());
        } else if (type == Long.class) {
            result = new Long(((Number)left).longValue() % ((Number)right).longValue());
        } else if (type == Integer.class) {
            result = new Integer(((Number)left).intValue() % ((Number)right).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + remainder + "'.");
        }
        return result;
    }

    public Object visitAnnotationShiftLeft(AnnotationShiftLeft shiftLeft) {
        Number result;
        Object right;
        Object left = shiftLeft.getLeft().accept(this);
        Class type = EvaluatingVisitor.numericResultType(left, right = shiftLeft.getRight().accept(this));
        if (type == Long.class) {
            result = new Long(((Number)left).longValue() << (int)((Number)right).longValue());
        } else if (type == Integer.class) {
            result = new Integer(((Number)left).intValue() << ((Number)right).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + shiftLeft + "'.");
        }
        return result;
    }

    public Object visitAnnotationShiftRight(AnnotationShiftRight shiftRight) {
        Number result;
        Object right;
        Object left = shiftRight.getLeft().accept(this);
        Class type = EvaluatingVisitor.numericResultType(left, right = shiftRight.getRight().accept(this));
        if (type == Long.class) {
            result = new Long(((Number)left).longValue() >> (int)((Number)right).longValue());
        } else if (type == Integer.class) {
            result = new Integer(((Number)left).intValue() >> ((Number)right).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + shiftRight + "'.");
        }
        return result;
    }

    public Object visitAnnotationUnsignedShiftRight(AnnotationUnsignedShiftRight shiftRight) {
        Number result;
        Object right;
        Object left = shiftRight.getLeft().accept(this);
        Class type = EvaluatingVisitor.numericResultType(left, right = shiftRight.getRight().accept(this));
        if (type == Long.class) {
            result = new Long(((Number)left).longValue() >>> (int)((Number)right).longValue());
        } else if (type == Integer.class) {
            result = new Integer(((Number)left).intValue() >>> ((Number)right).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + shiftRight + "'.");
        }
        return result;
    }

    public Object visitAnnotationEquals(AnnotationEquals annotationEquals) {
        Object right;
        Object left = annotationEquals.getLeft().accept(this);
        Class type = EvaluatingVisitor.resultType(left, right = annotationEquals.getRight().accept(this));
        boolean result = type == Double.class ? ((Number)left).doubleValue() == ((Number)right).doubleValue() : (type == Float.class ? ((Number)left).floatValue() == ((Number)right).floatValue() : (type == Long.class ? ((Number)left).longValue() == ((Number)right).longValue() : (type == Integer.class ? ((Number)left).intValue() == ((Number)right).intValue() : left == right)));
        return result ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object visitAnnotationExclusiveOr(AnnotationExclusiveOr annotationExclusiveOr) {
        Number result;
        Object right;
        Object left = annotationExclusiveOr.getLeft().accept(this);
        Class type = EvaluatingVisitor.numericResultType(left, right = annotationExclusiveOr.getRight().accept(this));
        if (type == Long.class) {
            result = new Long(((Number)left).longValue() ^ ((Number)right).longValue());
        } else if (type == Integer.class) {
            result = new Integer(((Number)left).intValue() ^ ((Number)right).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + annotationExclusiveOr + "'.");
        }
        return result;
    }

    public Object visitAnnotationNotEquals(AnnotationNotEquals annotationNotEquals) {
        Object right;
        Object left = annotationNotEquals.getLeft().accept(this);
        Class type = EvaluatingVisitor.resultType(left, right = annotationNotEquals.getRight().accept(this));
        boolean result = type == Double.class ? ((Number)left).doubleValue() != ((Number)right).doubleValue() : (type == Float.class ? ((Number)left).floatValue() != ((Number)right).floatValue() : (type == Long.class ? ((Number)left).longValue() != ((Number)right).longValue() : (type == Integer.class ? ((Number)left).intValue() != ((Number)right).intValue() : left == right)));
        return result ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object visitAnnotationQuery(AnnotationQuery annotationQuery) {
        Object value = annotationQuery.getCondition().accept(this);
        if (value == null || !(value instanceof Boolean)) {
            throw new IllegalArgumentException("Cannot evaluate '" + annotationQuery + "'.");
        }
        AnnotationValue expression = (Boolean)value != false ? annotationQuery.getTrueExpression() : annotationQuery.getFalseExpression();
        return expression.accept(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object visitAnnotationCast(AnnotationCast annotationCast) {
        Object value = annotationCast.getValue().accept(this);
        String type = annotationCast.getType().getJavaClass().getFullyQualifiedName();
        if (value instanceof Number) {
            Number n = (Number)value;
            if (type.equals("byte")) {
                return new Byte(n.byteValue());
            }
            if (type.equals("char")) {
                return new Character((char)n.intValue());
            }
            if (type.equals("short")) {
                return new Short(n.shortValue());
            }
            if (type.equals("int")) {
                return new Integer(n.intValue());
            }
            if (type.equals("long")) {
                return new Long(n.longValue());
            }
            if (type.equals("float")) {
                return new Float(n.floatValue());
            }
            if (!type.equals("double")) throw new IllegalArgumentException("Cannot evaluate '" + annotationCast + "'.");
            return new Double(n.doubleValue());
        }
        if (!(value instanceof String)) throw new IllegalArgumentException("Cannot evaluate '" + annotationCast + "'.");
        if (!type.equals("java.lang.String")) throw new IllegalArgumentException("Cannot evaluate '" + annotationCast + "'.");
        return value;
    }
}

