/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.writer;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.onionoo.docs.DocumentStore;
import org.torproject.onionoo.docs.DocumentStoreFactory;
import org.torproject.onionoo.docs.GraphHistory;
import org.torproject.onionoo.docs.UpdateStatus;
import org.torproject.onionoo.docs.UptimeDocument;
import org.torproject.onionoo.docs.UptimeHistory;
import org.torproject.onionoo.docs.UptimeStatus;
import org.torproject.onionoo.util.FormattingUtils;
import org.torproject.onionoo.writer.DocumentWriter;

public class UptimeDocumentWriter
implements DocumentWriter {
    private static final Logger log = LoggerFactory.getLogger(UptimeDocumentWriter.class);
    private DocumentStore documentStore;
    private long now;
    private int writtenDocuments = 0;
    private String[] graphNames = new String[]{"1_week", "1_month", "3_months", "1_year", "5_years"};
    private long[] graphIntervals = new long[]{604800000L, 2678400000L, 7948800000L, 31622400000L, 158112000000L};
    private long[] dataPointIntervals = new long[]{3600000L, 14400000L, 43200000L, 172800000L, 864000000L};

    public UptimeDocumentWriter() {
        this.documentStore = DocumentStoreFactory.getDocumentStore();
        this.now = System.currentTimeMillis();
    }

    @Override
    public void writeDocuments() {
        UptimeStatus uptimeStatus = this.documentStore.retrieve(UptimeStatus.class, true);
        if (uptimeStatus == null) {
            return;
        }
        UpdateStatus updateStatus = this.documentStore.retrieve(UpdateStatus.class, true);
        long updatedMillis = updateStatus != null ? updateStatus.getUpdatedMillis() : 0L;
        SortedSet<String> updatedUptimeStatuses = this.documentStore.list(UptimeStatus.class, updatedMillis);
        for (String fingerprint : updatedUptimeStatuses) {
            this.updateDocument(fingerprint, uptimeStatus);
        }
        log.info("Wrote uptime document files");
    }

    private void updateDocument(String fingerprint, UptimeStatus knownStatuses) {
        UptimeStatus uptimeStatus = this.documentStore.retrieve(UptimeStatus.class, true, fingerprint);
        if (uptimeStatus != null) {
            boolean relay = uptimeStatus.getBridgeHistory().isEmpty();
            SortedSet<UptimeHistory> history = relay ? uptimeStatus.getRelayHistory() : uptimeStatus.getBridgeHistory();
            SortedSet<UptimeHistory> knownStatusesHistory = relay ? knownStatuses.getRelayHistory() : knownStatuses.getBridgeHistory();
            UptimeDocument uptimeDocument = this.compileUptimeDocument(relay, fingerprint, history, knownStatusesHistory);
            this.documentStore.store(uptimeDocument, fingerprint);
            ++this.writtenDocuments;
        }
    }

    private UptimeDocument compileUptimeDocument(boolean relay, String fingerprint, SortedSet<UptimeHistory> history, SortedSet<UptimeHistory> knownStatuses) {
        UptimeDocument uptimeDocument = new UptimeDocument();
        uptimeDocument.setFingerprint(fingerprint);
        LinkedHashMap<String, GraphHistory> uptime = new LinkedHashMap<String, GraphHistory>();
        for (int graphIntervalIndex = 0; graphIntervalIndex < this.graphIntervals.length; ++graphIntervalIndex) {
            String graphName = this.graphNames[graphIntervalIndex];
            GraphHistory graphHistory = this.compileUptimeHistory(graphIntervalIndex, relay, history, knownStatuses, null);
            if (graphHistory == null) continue;
            uptime.put(graphName, graphHistory);
        }
        uptimeDocument.setUptime(uptime);
        TreeMap<String, Map<String, GraphHistory>> flags = new TreeMap<String, Map<String, GraphHistory>>();
        TreeSet<String> allFlags = new TreeSet<String>();
        for (UptimeHistory hist : history) {
            if (hist.getFlags() == null) continue;
            allFlags.addAll(hist.getFlags());
        }
        for (String flag : allFlags) {
            LinkedHashMap<String, GraphHistory> graphsForFlags = new LinkedHashMap<String, GraphHistory>();
            for (int graphIntervalIndex = 0; graphIntervalIndex < this.graphIntervals.length; ++graphIntervalIndex) {
                String graphName = this.graphNames[graphIntervalIndex];
                GraphHistory graphHistory = this.compileUptimeHistory(graphIntervalIndex, relay, history, knownStatuses, flag);
                if (graphHistory == null) continue;
                graphsForFlags.put(graphName, graphHistory);
            }
            if (graphsForFlags.isEmpty()) continue;
            flags.put(flag, graphsForFlags);
        }
        if (!flags.isEmpty()) {
            uptimeDocument.setFlags(flags);
        }
        return uptimeDocument;
    }

    private GraphHistory compileUptimeHistory(int graphIntervalIndex, boolean relay, SortedSet<UptimeHistory> history, SortedSet<UptimeHistory> knownStatuses, String flag) {
        long graphInterval = this.graphIntervals[graphIntervalIndex];
        long dataPointInterval = this.dataPointIntervals[graphIntervalIndex];
        int dataPointIntervalHours = (int)(dataPointInterval / 3600000L);
        ArrayList<Integer> uptimeDataPoints = new ArrayList<Integer>();
        long intervalStartMillis = (this.now - graphInterval) / dataPointInterval * dataPointInterval;
        int uptimeHours = 0;
        long firstStatusStartMillis = -1L;
        for (UptimeHistory hist : history) {
            long histEndMillis;
            if (hist.isRelay() != relay || flag != null && (hist.getFlags() == null || !hist.getFlags().contains(flag))) continue;
            if (firstStatusStartMillis < 0L) {
                firstStatusStartMillis = hist.getStartMillis();
            }
            if ((histEndMillis = hist.getStartMillis() + 3600000L * (long)hist.getUptimeHours()) < intervalStartMillis) continue;
            while (hist.getStartMillis() >= intervalStartMillis + dataPointInterval) {
                if (firstStatusStartMillis < intervalStartMillis + dataPointInterval) {
                    uptimeDataPoints.add(uptimeHours);
                } else {
                    uptimeDataPoints.add(-1);
                }
                uptimeHours = 0;
                intervalStartMillis += dataPointInterval;
            }
            while (histEndMillis >= intervalStartMillis + dataPointInterval) {
                uptimeDataPoints.add(uptimeHours += (int)((intervalStartMillis + dataPointInterval - Math.max(hist.getStartMillis(), intervalStartMillis)) / 3600000L));
                uptimeHours = 0;
                intervalStartMillis += dataPointInterval;
            }
            uptimeHours += (int)((histEndMillis - Math.max(hist.getStartMillis(), intervalStartMillis)) / 3600000L);
        }
        uptimeDataPoints.add(uptimeHours);
        ArrayList<Integer> statusDataPoints = new ArrayList<Integer>();
        intervalStartMillis = (this.now - graphInterval) / dataPointInterval * dataPointInterval;
        int statusHours = -1;
        for (UptimeHistory hist : knownStatuses) {
            long histEndMillis;
            if (hist.isRelay() != relay || flag != null && (hist.getFlags() == null || !hist.getFlags().contains(flag)) || (histEndMillis = hist.getStartMillis() + 3600000L * (long)hist.getUptimeHours()) < intervalStartMillis) continue;
            while (hist.getStartMillis() >= intervalStartMillis + dataPointInterval) {
                statusDataPoints.add(statusHours * 5 > dataPointIntervalHours ? statusHours : -1);
                statusHours = -1;
                intervalStartMillis += dataPointInterval;
            }
            while (histEndMillis >= intervalStartMillis + dataPointInterval) {
                if (statusHours < 0) {
                    statusHours = 0;
                }
                statusDataPoints.add((statusHours += (int)((intervalStartMillis + dataPointInterval - Math.max(Math.max(hist.getStartMillis(), firstStatusStartMillis), intervalStartMillis)) / 3600000L)) * 5 > dataPointIntervalHours ? statusHours : -1);
                statusHours = -1;
                intervalStartMillis += dataPointInterval;
            }
            if (statusHours < 0) {
                statusHours = 0;
            }
            statusHours += (int)((histEndMillis - Math.max(Math.max(hist.getStartMillis(), firstStatusStartMillis), intervalStartMillis)) / 3600000L);
        }
        if (statusHours > 0) {
            statusDataPoints.add(statusHours * 5 > dataPointIntervalHours ? statusHours : -1);
        }
        ArrayList<Double> dataPoints = new ArrayList<Double>();
        for (int dataPointIndex = 0; dataPointIndex < statusDataPoints.size(); ++dataPointIndex) {
            if (dataPointIndex >= uptimeDataPoints.size()) {
                dataPoints.add(0.0);
                continue;
            }
            if ((Integer)uptimeDataPoints.get(dataPointIndex) >= 0 && (Integer)statusDataPoints.get(dataPointIndex) > 0) {
                dataPoints.add((double)((Integer)uptimeDataPoints.get(dataPointIndex)).intValue() / (double)((Integer)statusDataPoints.get(dataPointIndex)).intValue());
                continue;
            }
            dataPoints.add(-1.0);
        }
        int firstNonNullIndex = -1;
        int lastNonNullIndex = -1;
        for (int dataPointIndex = 0; dataPointIndex < dataPoints.size(); ++dataPointIndex) {
            double dataPoint = (Double)dataPoints.get(dataPointIndex);
            if (!(dataPoint >= 0.0)) continue;
            if (firstNonNullIndex < 0) {
                firstNonNullIndex = dataPointIndex;
            }
            lastNonNullIndex = dataPointIndex;
        }
        if (firstNonNullIndex < 0) {
            return null;
        }
        long firstDataPointMillis = ((this.now - graphInterval) / dataPointInterval + (long)firstNonNullIndex) * dataPointInterval + dataPointInterval / 2L;
        if (graphIntervalIndex > 0 && firstDataPointMillis >= this.now - this.graphIntervals[graphIntervalIndex - 1]) {
            return null;
        }
        long lastDataPointMillis = firstDataPointMillis + (long)(lastNonNullIndex - firstNonNullIndex) * dataPointInterval;
        int count = lastNonNullIndex - firstNonNullIndex + 1;
        GraphHistory graphHistory = new GraphHistory();
        graphHistory.setFirst(firstDataPointMillis);
        graphHistory.setLast(lastDataPointMillis);
        graphHistory.setInterval((int)(dataPointInterval / 1000L));
        graphHistory.setFactor(0.001001001001001001);
        graphHistory.setCount(count);
        int previousNonNullIndex = -2;
        boolean foundTwoAdjacentDataPoints = false;
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (int dataPointIndex = firstNonNullIndex; dataPointIndex <= lastNonNullIndex; ++dataPointIndex) {
            double dataPoint = (Double)dataPoints.get(dataPointIndex);
            if (dataPoint >= 0.0) {
                if (dataPointIndex - previousNonNullIndex == 1) {
                    foundTwoAdjacentDataPoints = true;
                }
                previousNonNullIndex = dataPointIndex;
            }
            values.add(dataPoint < -0.5 ? null : Integer.valueOf((int)(dataPoint * 999.0)));
        }
        graphHistory.setValues(values);
        if (foundTwoAdjacentDataPoints) {
            return graphHistory;
        }
        return null;
    }

    @Override
    public String getStatsString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    " + FormattingUtils.formatDecimalNumber(this.writtenDocuments) + " uptime document files written\n");
        return sb.toString();
    }
}

