/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.onionoo.docs.BandwidthDocument;
import org.torproject.onionoo.docs.ClientsDocument;
import org.torproject.onionoo.docs.DetailsDocument;
import org.torproject.onionoo.docs.DocumentStore;
import org.torproject.onionoo.docs.DocumentStoreFactory;
import org.torproject.onionoo.docs.SummaryDocument;
import org.torproject.onionoo.docs.UptimeDocument;
import org.torproject.onionoo.docs.WeightsDocument;

public class ResponseBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ResponseBuilder.class);
    private DocumentStore documentStore;
    private String buildRevision;
    private String resourceType;
    private String relaysPublishedString;
    private String bridgesPublishedString;
    private List<SummaryDocument> orderedRelays = new ArrayList<SummaryDocument>();
    private List<SummaryDocument> orderedBridges = new ArrayList<SummaryDocument>();
    private int relaysSkipped;
    private int bridgesSkipped;
    private int relaysTruncated;
    private int bridgesTruncated;
    private String[] fields;
    private int charsWritten = 0;
    private static final String PROTOCOL_VERSION = "4.3";
    private static final String NEXT_MAJOR_VERSION_SCHEDULED = "2017-12-17";

    public ResponseBuilder() {
        this.documentStore = DocumentStoreFactory.getDocumentStore();
        Properties buildProperties = new Properties();
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("onionoo.buildrevision.properties");){
            buildProperties.load(is);
            this.buildRevision = buildProperties.getProperty("onionoo.build.revision", null);
        }
        catch (Exception ex) {
            logger.warn("No build revision available.", ex);
            this.buildRevision = null;
        }
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public void setRelaysPublishedString(String relaysPublishedString) {
        this.relaysPublishedString = relaysPublishedString;
    }

    public void setBridgesPublishedString(String bridgesPublishedString) {
        this.bridgesPublishedString = bridgesPublishedString;
    }

    public void setOrderedRelays(List<SummaryDocument> orderedRelays) {
        this.orderedRelays = orderedRelays;
    }

    public void setOrderedBridges(List<SummaryDocument> orderedBridges) {
        this.orderedBridges = orderedBridges;
    }

    public void setRelaysSkipped(int relaysSkipped) {
        this.relaysSkipped = relaysSkipped;
    }

    public void setBridgesSkipped(int bridgesSkipped) {
        this.bridgesSkipped = bridgesSkipped;
    }

    public void setRelaysTruncated(int relaysTruncated) {
        this.relaysTruncated = relaysTruncated;
    }

    public void setBridgesTruncated(int bridgesTruncated) {
        this.bridgesTruncated = bridgesTruncated;
    }

    public void setFields(String[] fields) {
        this.fields = new String[fields.length];
        System.arraycopy(fields, 0, this.fields, 0, fields.length);
    }

    public void buildResponse(PrintWriter pw) {
        this.writeRelays(this.orderedRelays, pw);
        this.writeBridges(this.orderedBridges, pw);
    }

    public int getCharsWritten() {
        return this.charsWritten;
    }

    private void writeRelays(List<SummaryDocument> relays, PrintWriter pw) {
        this.write(pw, "{\"version\":\"%s\",\n", PROTOCOL_VERSION);
        if (null != NEXT_MAJOR_VERSION_SCHEDULED) {
            this.write(pw, "\"next_major_version_scheduled\":\"%s\",\n", NEXT_MAJOR_VERSION_SCHEDULED);
        }
        if (null != this.buildRevision) {
            this.write(pw, "\"build_revision\":\"%s\",\n", this.buildRevision);
        }
        this.write(pw, "\"relays_published\":\"%s\",\n", this.relaysPublishedString);
        if (this.relaysSkipped > 0) {
            this.write(pw, "\"relays_skipped\":%d,\n", this.relaysSkipped);
        }
        this.write(pw, "\"relays\":[", new Object[0]);
        int written = 0;
        for (SummaryDocument entry : relays) {
            String lines = this.formatNodeStatus(entry);
            if (lines.length() <= 0) continue;
            this.write(pw, "%s%s", written++ > 0 ? ",\n" : "\n", lines);
        }
        this.write(pw, "\n],\n", new Object[0]);
        if (this.relaysTruncated > 0) {
            this.write(pw, "\"relays_truncated\":%d,\n", this.relaysTruncated);
        }
    }

    private void writeBridges(List<SummaryDocument> bridges, PrintWriter pw) {
        this.write(pw, "\"bridges_published\":\"" + this.bridgesPublishedString + "\",\n", new Object[0]);
        if (this.bridgesSkipped > 0) {
            this.write(pw, "\"bridges_skipped\":%d,\n", this.bridgesSkipped);
        }
        this.write(pw, "\"bridges\":[", new Object[0]);
        int written = 0;
        for (SummaryDocument entry : bridges) {
            String lines = this.formatNodeStatus(entry);
            if (lines.length() <= 0) continue;
            this.write(pw, (written++ > 0 ? ",\n" : "\n") + lines, new Object[0]);
        }
        this.write(pw, "\n]", new Object[0]);
        if (this.bridgesTruncated > 0) {
            this.write(pw, ",\n\"bridges_truncated\":%d", this.bridgesTruncated);
        }
        this.write(pw, "}\n", new Object[0]);
    }

    private void write(PrintWriter pw, String format, Object ... args) {
        String stringToWrite = String.format(format, args);
        this.charsWritten += stringToWrite.length();
        pw.write(stringToWrite);
    }

    private String formatNodeStatus(SummaryDocument entry) {
        if (this.resourceType == null) {
            return "";
        }
        if (this.resourceType.equals("summary")) {
            return this.writeSummaryLine(entry);
        }
        if (this.resourceType.equals("details")) {
            return this.writeDetailsLines(entry);
        }
        if (this.resourceType.equals("bandwidth")) {
            return this.writeBandwidthLines(entry);
        }
        if (this.resourceType.equals("weights")) {
            return this.writeWeightsLines(entry);
        }
        if (this.resourceType.equals("clients")) {
            return this.writeClientsLines(entry);
        }
        if (this.resourceType.equals("uptime")) {
            return this.writeUptimeLines(entry);
        }
        return "";
    }

    private String writeSummaryLine(SummaryDocument entry) {
        return entry.isRelay() ? this.writeRelaySummaryLine(entry) : this.writeBridgeSummaryLine(entry);
    }

    private String writeRelaySummaryLine(SummaryDocument entry) {
        String nickname = !entry.getNickname().equals("Unnamed") ? entry.getNickname() : null;
        String fingerprint = entry.getFingerprint();
        String running = entry.isRunning() ? "true" : "false";
        List<String> addresses = entry.getAddresses();
        StringBuilder addressesBuilder = new StringBuilder();
        int written = 0;
        for (String address : addresses) {
            addressesBuilder.append((written++ > 0 ? "," : "") + "\"" + address.toLowerCase() + "\"");
        }
        return String.format("{%s\"f\":\"%s\",\"a\":[%s],\"r\":%s}", nickname == null ? "" : "\"n\":\"" + nickname + "\",", fingerprint, addressesBuilder.toString(), running);
    }

    private String writeBridgeSummaryLine(SummaryDocument entry) {
        String nickname = !entry.getNickname().equals("Unnamed") ? entry.getNickname() : null;
        String hashedFingerprint = entry.getFingerprint();
        String running = entry.isRunning() ? "true" : "false";
        return String.format("{%s\"h\":\"%s\",\"r\":%s}", nickname == null ? "" : "\"n\":\"" + nickname + "\",", hashedFingerprint, running);
    }

    private String writeDetailsLines(SummaryDocument entry) {
        String fingerprint = entry.getFingerprint();
        if (this.fields != null) {
            DetailsDocument detailsDocument = this.documentStore.retrieve(DetailsDocument.class, true, fingerprint);
            if (detailsDocument != null) {
                DetailsDocument dd = new DetailsDocument();
                for (String field : this.fields) {
                    if (field.equals("nickname")) {
                        dd.setNickname(detailsDocument.getNickname());
                        continue;
                    }
                    if (field.equals("fingerprint")) {
                        dd.setFingerprint(detailsDocument.getFingerprint());
                        continue;
                    }
                    if (field.equals("hashed_fingerprint")) {
                        dd.setHashedFingerprint(detailsDocument.getHashedFingerprint());
                        continue;
                    }
                    if (field.equals("or_addresses")) {
                        dd.setOrAddresses(detailsDocument.getOrAddresses());
                        continue;
                    }
                    if (field.equals("exit_addresses")) {
                        dd.setExitAddresses(detailsDocument.getExitAddresses());
                        continue;
                    }
                    if (field.equals("dir_address")) {
                        dd.setDirAddress(detailsDocument.getDirAddress());
                        continue;
                    }
                    if (field.equals("last_seen")) {
                        dd.setLastSeen(detailsDocument.getLastSeen());
                        continue;
                    }
                    if (field.equals("last_changed_address_or_port")) {
                        dd.setLastChangedAddressOrPort(detailsDocument.getLastChangedAddressOrPort());
                        continue;
                    }
                    if (field.equals("first_seen")) {
                        dd.setFirstSeen(detailsDocument.getFirstSeen());
                        continue;
                    }
                    if (field.equals("running")) {
                        dd.setRunning(detailsDocument.getRunning());
                        continue;
                    }
                    if (field.equals("flags")) {
                        dd.setFlags(detailsDocument.getFlags());
                        continue;
                    }
                    if (field.equals("country")) {
                        dd.setCountry(detailsDocument.getCountry());
                        continue;
                    }
                    if (field.equals("country_name")) {
                        dd.setCountryName(detailsDocument.getCountryName());
                        continue;
                    }
                    if (field.equals("region_name")) {
                        dd.setRegionName(detailsDocument.getRegionName());
                        continue;
                    }
                    if (field.equals("city_name")) {
                        dd.setCityName(detailsDocument.getCityName());
                        continue;
                    }
                    if (field.equals("latitude")) {
                        dd.setLatitude(detailsDocument.getLatitude());
                        continue;
                    }
                    if (field.equals("longitude")) {
                        dd.setLongitude(detailsDocument.getLongitude());
                        continue;
                    }
                    if (field.equals("as_number")) {
                        dd.setAsNumber(detailsDocument.getAsNumber());
                        continue;
                    }
                    if (field.equals("as_name")) {
                        dd.setAsName(detailsDocument.getAsName());
                        continue;
                    }
                    if (field.equals("consensus_weight")) {
                        dd.setConsensusWeight(detailsDocument.getConsensusWeight());
                        continue;
                    }
                    if (field.equals("host_name")) {
                        dd.setHostName(detailsDocument.getHostName());
                        continue;
                    }
                    if (field.equals("last_restarted")) {
                        dd.setLastRestarted(detailsDocument.getLastRestarted());
                        continue;
                    }
                    if (field.equals("bandwidth_rate")) {
                        dd.setBandwidthRate(detailsDocument.getBandwidthRate());
                        continue;
                    }
                    if (field.equals("bandwidth_burst")) {
                        dd.setBandwidthBurst(detailsDocument.getBandwidthBurst());
                        continue;
                    }
                    if (field.equals("observed_bandwidth")) {
                        dd.setObservedBandwidth(detailsDocument.getObservedBandwidth());
                        continue;
                    }
                    if (field.equals("advertised_bandwidth")) {
                        dd.setAdvertisedBandwidth(detailsDocument.getAdvertisedBandwidth());
                        continue;
                    }
                    if (field.equals("exit_policy")) {
                        dd.setExitPolicy(detailsDocument.getExitPolicy());
                        continue;
                    }
                    if (field.equals("exit_policy_summary")) {
                        dd.setExitPolicySummary(detailsDocument.getExitPolicySummary());
                        continue;
                    }
                    if (field.equals("exit_policy_v6_summary")) {
                        dd.setExitPolicyV6Summary(detailsDocument.getExitPolicyV6Summary());
                        continue;
                    }
                    if (field.equals("contact")) {
                        dd.setContact(detailsDocument.getContact());
                        continue;
                    }
                    if (field.equals("platform")) {
                        dd.setPlatform(detailsDocument.getPlatform());
                        continue;
                    }
                    if (field.equals("consensus_weight_fraction")) {
                        dd.setConsensusWeightFraction(detailsDocument.getConsensusWeightFraction());
                        continue;
                    }
                    if (field.equals("guard_probability")) {
                        dd.setGuardProbability(detailsDocument.getGuardProbability());
                        continue;
                    }
                    if (field.equals("middle_probability")) {
                        dd.setMiddleProbability(detailsDocument.getMiddleProbability());
                        continue;
                    }
                    if (field.equals("exit_probability")) {
                        dd.setExitProbability(detailsDocument.getExitProbability());
                        continue;
                    }
                    if (field.equals("recommended_version")) {
                        dd.setRecommendedVersion(detailsDocument.getRecommendedVersion());
                        continue;
                    }
                    if (field.equals("hibernating")) {
                        dd.setHibernating(detailsDocument.getHibernating());
                        continue;
                    }
                    if (field.equals("transports")) {
                        dd.setTransports(detailsDocument.getTransports());
                        continue;
                    }
                    if (field.equals("effective_family")) {
                        dd.setEffectiveFamily(detailsDocument.getEffectiveFamily());
                        continue;
                    }
                    if (field.equals("measured")) {
                        dd.setMeasured(detailsDocument.getMeasured());
                        continue;
                    }
                    if (field.equals("alleged_family")) {
                        dd.setAllegedFamily(detailsDocument.getAllegedFamily());
                        continue;
                    }
                    if (!field.equals("indirect_family")) continue;
                    dd.setIndirectFamily(detailsDocument.getIndirectFamily());
                }
                Gson gson = new GsonBuilder().disableHtmlEscaping().create();
                return StringUtils.replace(gson.toJson(dd), "\\\\u", "\\u");
            }
            return "";
        }
        DetailsDocument detailsDocument = this.documentStore.retrieve(DetailsDocument.class, false, fingerprint);
        if (detailsDocument != null) {
            return detailsDocument.getDocumentString();
        }
        return "";
    }

    private String writeBandwidthLines(SummaryDocument entry) {
        String fingerprint = entry.getFingerprint();
        BandwidthDocument bandwidthDocument = this.documentStore.retrieve(BandwidthDocument.class, false, fingerprint);
        if (bandwidthDocument != null && bandwidthDocument.getDocumentString() != null) {
            return bandwidthDocument.getDocumentString();
        }
        return "{\"fingerprint\":\"" + fingerprint.toUpperCase() + "\"}";
    }

    private String writeWeightsLines(SummaryDocument entry) {
        String fingerprint = entry.getFingerprint();
        WeightsDocument weightsDocument = this.documentStore.retrieve(WeightsDocument.class, false, fingerprint);
        if (weightsDocument != null && weightsDocument.getDocumentString() != null) {
            return weightsDocument.getDocumentString();
        }
        return "{\"fingerprint\":\"" + fingerprint.toUpperCase() + "\"}";
    }

    private String writeClientsLines(SummaryDocument entry) {
        String fingerprint = entry.getFingerprint();
        ClientsDocument clientsDocument = this.documentStore.retrieve(ClientsDocument.class, false, fingerprint);
        if (clientsDocument != null && clientsDocument.getDocumentString() != null) {
            return clientsDocument.getDocumentString();
        }
        return "{\"fingerprint\":\"" + fingerprint.toUpperCase() + "\"}";
    }

    private String writeUptimeLines(SummaryDocument entry) {
        String fingerprint = entry.getFingerprint();
        UptimeDocument uptimeDocument = this.documentStore.retrieve(UptimeDocument.class, false, fingerprint);
        if (uptimeDocument != null && uptimeDocument.getDocumentString() != null) {
            return uptimeDocument.getDocumentString();
        }
        return "{\"fingerprint\":\"" + fingerprint.toUpperCase() + "\"}";
    }
}

