/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.docs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.apache.commons.lang3.StringEscapeUtils;
import org.torproject.onionoo.docs.DateTimeHelper;
import org.torproject.onionoo.docs.Document;

public class DetailsDocument
extends Document {
    private String nickname;
    private String fingerprint;
    private String hashed_fingerprint;
    private List<String> or_addresses;
    private List<String> exit_addresses;
    private String dir_address;
    private String last_seen;
    private String last_changed_address_or_port;
    private String first_seen;
    private Boolean running;
    private SortedSet<String> flags;
    private String country;
    private String country_name;
    private String region_name;
    private String city_name;
    private Float latitude;
    private Float longitude;
    private String as_number;
    private String as_name;
    private Long consensus_weight;
    private String host_name;
    private String last_restarted;
    private Integer bandwidth_rate;
    private Integer bandwidth_burst;
    private Integer observed_bandwidth;
    private Integer advertised_bandwidth;
    private List<String> exit_policy;
    private Map<String, List<String>> exit_policy_summary;
    private Map<String, List<String>> exit_policy_v6_summary;
    private String contact;
    private String platform;
    private SortedSet<String> alleged_family;
    private SortedSet<String> effective_family;
    private SortedSet<String> indirect_family;
    private Float consensus_weight_fraction;
    private Float guard_probability;
    private Float middle_probability;
    private Float exit_probability;
    private Boolean recommended_version;
    private Boolean hibernating;
    private List<String> transports;
    private Boolean measured;
    private List<String> unreachable_or_addresses;

    private static String escapeJson(String stringToEscape) {
        return StringEscapeUtils.escapeJava(stringToEscape);
    }

    private static String unescapeJson(String stringToUnescape) {
        return StringEscapeUtils.unescapeJava(stringToUnescape);
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public void setHashedFingerprint(String hashedFingerprint) {
        this.hashed_fingerprint = hashedFingerprint;
    }

    public String getHashedFingerprint() {
        return this.hashed_fingerprint;
    }

    public void setOrAddresses(List<String> orAddresses) {
        this.or_addresses = orAddresses;
    }

    public List<String> getOrAddresses() {
        return this.or_addresses;
    }

    public void setExitAddresses(List<String> exitAddresses) {
        this.exit_addresses = !exitAddresses.isEmpty() ? exitAddresses : null;
    }

    public List<String> getExitAddresses() {
        return this.exit_addresses == null ? new ArrayList() : this.exit_addresses;
    }

    public void setDirAddress(String dirAddress) {
        this.dir_address = dirAddress;
    }

    public String getDirAddress() {
        return this.dir_address;
    }

    public void setLastSeen(long lastSeen) {
        this.last_seen = DateTimeHelper.format(lastSeen);
    }

    public long getLastSeen() {
        return DateTimeHelper.parse(this.last_seen);
    }

    public void setLastChangedAddressOrPort(long lastChangedAddressOrPort) {
        this.last_changed_address_or_port = DateTimeHelper.format(lastChangedAddressOrPort);
    }

    public long getLastChangedAddressOrPort() {
        return DateTimeHelper.parse(this.last_changed_address_or_port);
    }

    public void setFirstSeen(long firstSeen) {
        this.first_seen = DateTimeHelper.format(firstSeen);
    }

    public long getFirstSeen() {
        return DateTimeHelper.parse(this.first_seen);
    }

    public void setRunning(Boolean running) {
        this.running = running;
    }

    public Boolean getRunning() {
        return this.running;
    }

    public void setFlags(SortedSet<String> flags) {
        this.flags = flags;
    }

    public SortedSet<String> getFlags() {
        return this.flags;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountryName(String countryName) {
        this.country_name = DetailsDocument.escapeJson(countryName);
    }

    public String getCountryName() {
        return DetailsDocument.unescapeJson(this.country_name);
    }

    public void setRegionName(String regionName) {
        this.region_name = DetailsDocument.escapeJson(regionName);
    }

    public String getRegionName() {
        return DetailsDocument.unescapeJson(this.region_name);
    }

    public void setCityName(String cityName) {
        this.city_name = DetailsDocument.escapeJson(cityName);
    }

    public String getCityName() {
        return DetailsDocument.unescapeJson(this.city_name);
    }

    public void setLatitude(Float latitude) {
        this.latitude = latitude;
    }

    public Float getLatitude() {
        return this.latitude;
    }

    public void setLongitude(Float longitude) {
        this.longitude = longitude;
    }

    public Float getLongitude() {
        return this.longitude;
    }

    public void setAsNumber(String asNumber) {
        this.as_number = DetailsDocument.escapeJson(asNumber);
    }

    public String getAsNumber() {
        return DetailsDocument.unescapeJson(this.as_number);
    }

    public void setAsName(String asName) {
        this.as_name = DetailsDocument.escapeJson(asName);
    }

    public String getAsName() {
        return DetailsDocument.unescapeJson(this.as_name);
    }

    public void setConsensusWeight(Long consensusWeight) {
        this.consensus_weight = consensusWeight;
    }

    public Long getConsensusWeight() {
        return this.consensus_weight;
    }

    public void setHostName(String hostName) {
        this.host_name = DetailsDocument.escapeJson(hostName);
    }

    public String getHostName() {
        return DetailsDocument.unescapeJson(this.host_name);
    }

    public void setLastRestarted(Long lastRestarted) {
        this.last_restarted = lastRestarted == null ? null : DateTimeHelper.format(lastRestarted);
    }

    public Long getLastRestarted() {
        return this.last_restarted == null ? null : Long.valueOf(DateTimeHelper.parse(this.last_restarted));
    }

    public void setBandwidthRate(Integer bandwidthRate) {
        this.bandwidth_rate = bandwidthRate;
    }

    public Integer getBandwidthRate() {
        return this.bandwidth_rate;
    }

    public void setBandwidthBurst(Integer bandwidthBurst) {
        this.bandwidth_burst = bandwidthBurst;
    }

    public Integer getBandwidthBurst() {
        return this.bandwidth_burst;
    }

    public void setObservedBandwidth(Integer observedBandwidth) {
        this.observed_bandwidth = observedBandwidth;
    }

    public Integer getObservedBandwidth() {
        return this.observed_bandwidth;
    }

    public void setAdvertisedBandwidth(Integer advertisedBandwidth) {
        this.advertised_bandwidth = advertisedBandwidth;
    }

    public Integer getAdvertisedBandwidth() {
        return this.advertised_bandwidth;
    }

    public void setExitPolicy(List<String> exitPolicy) {
        this.exit_policy = exitPolicy;
    }

    public List<String> getExitPolicy() {
        return this.exit_policy;
    }

    public void setExitPolicySummary(Map<String, List<String>> exitPolicySummary) {
        this.exit_policy_summary = exitPolicySummary;
    }

    public Map<String, List<String>> getExitPolicySummary() {
        return this.exit_policy_summary;
    }

    public void setExitPolicyV6Summary(Map<String, List<String>> exitPolicyV6Summary) {
        this.exit_policy_v6_summary = exitPolicyV6Summary;
    }

    public Map<String, List<String>> getExitPolicyV6Summary() {
        return this.exit_policy_v6_summary;
    }

    public void setContact(String contact) {
        this.contact = DetailsDocument.escapeJson(contact);
    }

    public String getContact() {
        return DetailsDocument.unescapeJson(this.contact);
    }

    public void setPlatform(String platform) {
        this.platform = DetailsDocument.escapeJson(platform);
    }

    public String getPlatform() {
        return DetailsDocument.unescapeJson(this.platform);
    }

    public void setAllegedFamily(SortedSet<String> allegedFamily) {
        this.alleged_family = allegedFamily;
    }

    public SortedSet<String> getAllegedFamily() {
        return this.alleged_family;
    }

    public void setEffectiveFamily(SortedSet<String> effectiveFamily) {
        this.effective_family = effectiveFamily;
    }

    public SortedSet<String> getEffectiveFamily() {
        return this.effective_family;
    }

    public void setIndirectFamily(SortedSet<String> indirectFamily) {
        this.indirect_family = indirectFamily;
    }

    public SortedSet<String> getIndirectFamily() {
        return this.indirect_family;
    }

    public void setConsensusWeightFraction(Float consensusWeightFraction) {
        if (consensusWeightFraction == null || (double)consensusWeightFraction.floatValue() >= 0.0) {
            this.consensus_weight_fraction = consensusWeightFraction;
        }
    }

    public Float getConsensusWeightFraction() {
        return this.consensus_weight_fraction;
    }

    public void setGuardProbability(Float guardProbability) {
        if (guardProbability == null || (double)guardProbability.floatValue() >= 0.0) {
            this.guard_probability = guardProbability;
        }
    }

    public Float getGuardProbability() {
        return this.guard_probability;
    }

    public void setMiddleProbability(Float middleProbability) {
        if (middleProbability == null || (double)middleProbability.floatValue() >= 0.0) {
            this.middle_probability = middleProbability;
        }
    }

    public Float getMiddleProbability() {
        return this.middle_probability;
    }

    public void setExitProbability(Float exitProbability) {
        if (exitProbability == null || (double)exitProbability.floatValue() >= 0.0) {
            this.exit_probability = exitProbability;
        }
    }

    public Float getExitProbability() {
        return this.exit_probability;
    }

    public void setRecommendedVersion(Boolean recommendedVersion) {
        this.recommended_version = recommendedVersion;
    }

    public Boolean getRecommendedVersion() {
        return this.recommended_version;
    }

    public void setHibernating(Boolean hibernating) {
        this.hibernating = hibernating;
    }

    public Boolean getHibernating() {
        return this.hibernating;
    }

    public void setTransports(List<String> transports) {
        this.transports = transports != null && !transports.isEmpty() ? transports : null;
    }

    public List<String> getTransports() {
        return this.transports;
    }

    public void setMeasured(Boolean measured) {
        this.measured = measured;
    }

    public Boolean getMeasured() {
        return this.measured;
    }

    public void setUnreachableOrAddresses(List<String> unreachableOrAddresses) {
        this.unreachable_or_addresses = unreachableOrAddresses;
    }

    public List<String> getUnreachableOrAddresses() {
        return this.unreachable_or_addresses;
    }
}

