/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.onionoo.writer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.onionoo.writer.BandwidthDocumentWriter;
import org.torproject.onionoo.writer.ClientsDocumentWriter;
import org.torproject.onionoo.writer.DetailsDocumentWriter;
import org.torproject.onionoo.writer.DocumentWriter;
import org.torproject.onionoo.writer.SummaryDocumentWriter;
import org.torproject.onionoo.writer.UptimeDocumentWriter;
import org.torproject.onionoo.writer.WeightsDocumentWriter;

public class DocumentWriterRunner {
    private static final Logger log = LoggerFactory.getLogger(DocumentWriterRunner.class);
    private DocumentWriter[] documentWriters;

    public DocumentWriterRunner() {
        SummaryDocumentWriter sdw = new SummaryDocumentWriter();
        DetailsDocumentWriter ddw = new DetailsDocumentWriter();
        BandwidthDocumentWriter bdw = new BandwidthDocumentWriter();
        WeightsDocumentWriter wdw = new WeightsDocumentWriter();
        ClientsDocumentWriter cdw = new ClientsDocumentWriter();
        UptimeDocumentWriter udw = new UptimeDocumentWriter();
        this.documentWriters = new DocumentWriter[]{sdw, ddw, bdw, wdw, cdw, udw};
    }

    public void writeDocuments() {
        for (DocumentWriter dw : this.documentWriters) {
            log.debug("Writing " + dw.getClass().getSimpleName());
            dw.writeDocuments();
        }
    }

    public void logStatistics() {
        for (DocumentWriter dw : this.documentWriters) {
            String statsString = dw.getStatsString();
            if (statsString == null) continue;
            log.info(dw.getClass().getSimpleName() + "\n" + statsString);
        }
    }
}

